/* pgm.c
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1998  Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#if STDC_HEADERS
#  include <string.h>
#else
#  include <strings.h>
#endif
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif

#include "dvi-2_6.h"
#include "defs.h"

extern char         *param_dvi2img_title;
extern char         *param_dvi2img_ofile;
extern int           param_dvi2img_out;
extern double        param_dvi2img_shrink;
extern int           param_dvi2img_aa;
extern int           param_dvi2img_bbx;
extern int           param_dvi2img_page;
extern int           param_verbose;

static int           pcol;

static void    pgm_sprintf(char *s, char *fmt, int page, char *f);
static void    pgm_page(int page);
static void    pgm_begin_page(DVI_DEVICE, int);
static void    pgm_end_page(DVI_DEVICE, int, char*, FILE*);


void
dvi2pgm(char *dvi_file, long w, long h) 
{
  int     page;  

  pcol = 0;
  if (param_dvi2img_page > 0){
    pgm_page(param_dvi2img_page);
  } else {
    page = (param_page_rev == 0) ? param_page_from : param_page_to;
    do {
      pgm_page(page);
      page = page + ((param_page_rev == 0) ? 1 : -1);
    } while ((param_page_from <= page) && (page <= param_page_to));
  }
  if (param_verbose > 0)
    fprintf(stderr, "\n");
}

static void 
pgm_page(int page)
{
  int      need_close, ppp;
  double   s;
  FILE    *fp;
  char     title[1024], fname[1024];

  if (interrupted == 1)
    return;

  if ((s = param_dvi2img_shrink) <= 0)
    s = 1.0;

  if (param_verbose > 0){
    if (pcol > 70){
      fprintf(stderr, "\n");
      pcol = 0;
    }
    fprintf(stderr, "[%d] ", page);
    fflush(stderr);
    pcol += 4;
    ppp = page;
    while (ppp >= 10){
      pcol++;
      ppp /= 10;
    }
  }

  if (param_dvi2img_title != NULL){
    pgm_sprintf(title, param_dvi2img_title, page, param_dvi_file);
  } else if (param_dvi_file != NULL){
    pgm_sprintf(title, "%f: %p page", page, param_dvi_file);
  } else if (param_dvi_file == NULL){
    pgm_sprintf(title, "(stdin): %p page", page, param_dvi_file);
  }

  need_close = 0;
  if (param_dvi2img_ofile == NULL){
    fp = stdout;
  } else {
    pgm_sprintf(fname, param_dvi2img_ofile, page, "");
    if ((fp = fopen(fname, "w")) == NULL){
      fprintf(stderr, "Cannot open %s\n", fname);
      return;
    }
    need_close = 1;
  }

  pgm_begin_page(dev, page);
  if (DVI_DRAW_PAGE(dvi, dev, page, s) >= 0)
    pgm_end_page(dev, page, title, fp);

  if (need_close == 1)
    fclose(fp);
}

static void  
pgm_begin_page(DVI_DEVICE dev, int seq_page)
{
  DVI_fb_clear(framebuff);
}

static void  
pgm_end_page(DVI_DEVICE dev, int seq_page, char *title, FILE *fp)
{
  int             maxval, c;
  long            xmin, xmax, ymin, ymax, w, h;
  long            aabw, aabh, x, y;
  unsigned short *aa_buff;

  if (param_dvi2img_bbx == 1){
    if (DVI_fb_boundingbox(framebuff, &xmin, &xmax, &ymin, &ymax) < 0)
      return;
    if ((xmin < 0) || (xmax < 0) || (ymin < 0) || (ymax < 0))
      return;
    w = xmax - xmin + 1;
    h = ymax - ymin + 1; 
  } else {
    xmin = ymin = 0;
    w = framebuff->width;
    h = framebuff->height;
  }

  aa_buff = DVI_fb_antialias(framebuff, param_dvi2img_aa, 
			     xmin, ymin, w, h, &aabw, &aabh);
  if (aa_buff == NULL)
    return;

  fprintf(fp, "P5\n");
  fprintf(fp, "# Created by %s\n", program_name);
  fprintf(fp, "# %s\n", title);
  fprintf(fp, "%ld %ld\n", aabw, aabh);
  fprintf(fp, "%d\n", 255);

  maxval = param_dvi2img_aa * param_dvi2img_aa;
  for (y = 0; y < aabh; y++){
    for (x = 0; x < aabw; x++){
      c = 255 - (255 * aa_buff[aabw * y + x]) / maxval;
      fprintf(fp, "%c", (char)c);
#if 0
      printf("%d %d\n", aa_buff[aabw * y + x], c);
#endif
    }
  }

  free(aa_buff);
}

static void 
pgm_sprintf(char *s, char *fmt, int page, char *f)
{
  int    i;
  char   tmp[1024];
  char  *p, *q;

  i = 0;
  for (p = fmt; *p != '\0'; p++){
    if  (*p != '%'){
      s[i++] = *p;
    } else {
      p++;
      switch (*p){
      case '\0':   s[i++] = '%'; break;
      case '%':    s[i++] = '%'; break;
      case 'p': 
	sprintf(tmp, "%d", page); 
	for (q = tmp; *q != '\0'; q++)
	  s[i++] = *q;
	break;
      case 'f': 
	if (f == NULL)
	  f = "";
	for (q = f; *q != '\0'; q++)
	  s[i++] = *q;
	break;
      default:
	fprintf(stderr, "Unknown format directive: %%%c\n", *p);
	break;
      }
    }
  }
  s[i++] = '\0';
}

/*EOF*/

