using namespace std;

#include <stdio.h>

#include "wfnetobjs.h"

int
main(int argc, char *argv[]) {
  wf_ipaddr ipaddr1("10.0.17.18");
  wf_ipaddr ipaddr2(ipaddr1);
  cout << ipaddr2 << endl;

  wf_ipaddr_range ipaddr_range1("10.0.17.18", "10.0.17.28");
  wf_ipaddr_range ipaddr_range2(ipaddr_range1);
  cout << ipaddr_range2 << endl;

  char* str = strdup("net");
  wf_network network1("10.0.18.16/24");
  network1.name = str;
  wf_network network2(network1);
  network2.debugprint(cout);

#if 0
  // wf_ipaddr ipaddr1;
  wf_ipaddr ipaddr2("10.0.18.16");

  // wf_network network("10.0.18.*");

  // wf_network network("10.0.18.16", 24);
  wf_network network(ipaddr1, 24);
  //  wf_network network(ipaddr1, 24);


  network.comment = strdup("my network");

  wf_metahost_elem elem1;
  wf_metahost_elem elem2;
  wf_metahost_elem elem3(ipaddr1);

  elem1.debugprint(cout);
  elem2.debugprint(cout);

  elem1.set(network);
  elem2.set(ipaddr_range);

  elem1.debugprint(cout);
  elem2.debugprint(cout);

  wf_metahost metahost1;
  metahost1.name = "metahost1";
  metahost1.add(elem1);
  metahost1.add(elem2);
  metahost1.add(elem3);

  metahost1.debugprint(cout);
  cout << endl;

  wf_metahost metahost2;
  metahost2.name = "metahost2";
  metahost2.add(metahost1);
  metahost2.add(ipaddr1);

  metahost2.debugprint(cout);

  wf_iface iface1, iface2;
  wf_service service1, service2;
  wf_host host;

  iface1.comment = strdup("my interface");
  iface1.name = strdup("eth0");
  iface1.ipaddr = ipaddr1;
  iface1.network = network;
  
  //  ipaddr1.set("10.0.18.16");

  //  network.network_set("10.0.18.0/24");
  //  network.netmask.set("255.255.255.0");
  //  network.netmask_set(23);
  iface.complete();

  iface2.comment = strdup("my interface2");
  iface2.name = strdup("eth1");
  iface2.ipaddr = ipaddr1;
  iface2.network = network;

  /*
  iface1.debugprint(cout);
  iface2.debugprint(cout);
  */

  service1.protocol_set(6);
  service1.port_set(25);

  service2.protocol_set(17);
  service2.port_set(53);

  /*
  service1.debugprint(cout);
  service2.debugprint(cout);
  */

  host.comment = strdup("my host");
  host.name = strdup("myhost");

  host.iface_add(iface1);
  host.iface_add(iface2);

  host.service_add(service1);
  host.service_add(service2);

  host.service_del(service1);

  //  host.debugprint(cout);
 
  host.iface_del("eth3");
  //  host.debugprint(cout);

  //  host.iface_add(iface1);

  host.debugprint(cout);

#endif
  exit(0);
}
