// $Id: HeightOps.cpp,v 1.11 2001/11/02 08:35:10 nekeme Exp $

#include "Application.h"

#include "HeightOps.h"

#include "HFEOffset.h"
#include "HFEAbsolute.h"

template <class T>
class HeightOpImpl: public HeightOp
{
   public:
      HeightOpImpl(const std::string &name, const std::string &icon) :
	 HeightOp (name, icon)
      {}

      ~HeightOpImpl() {}

      HFEditHeight *Create(World* w, int type, int s, float a, float h)
      {return new T(w, type, s, a, h);}
};

HeightOp::HeightOp (const std::string& name, const std::string& icon) :
   m_Name (name), 
   m_Icon(icon)
{
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


HeightOpList::HeightOpList()
{
   reserve(5);
   
   push_back(new HeightOpImpl<HFEHigher>("higher", "ho-higher.xpm"));
   push_back(new HeightOpImpl<HFELower>("lower", "ho-lower.xpm"));
   push_back(new HeightOpImpl<HFEBulldozer>("bulldozer", "ho-bulldozer.xpm"));
   push_back(new HeightOpImpl<HFESmooth>("smooth", "ho-smooth.xpm"));
   push_back(new HeightOpImpl<HFENoise>("noise", "ho-noise.xpm"));
}



