/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Bindery;
import com.icl.saxon.Controller;
import com.icl.saxon.LastPositionFinder;
import com.icl.saxon.Mode;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.XSLTemplate;
import java.util.Stack;
import org.xml.sax.SAXException;

public class Context
implements LastPositionFinder {
    public static final int VARIABLES = 1;
    public static final int CURRENT_NODE = 4;
    public static final int CONTEXT_NODE = 8;
    public static final int POSITION = 16;
    public static final int LAST = 32;
    public static final int CONTROLLER = 64;
    public static final int NO_DEPENDENCIES = 0;
    public static final int ALL_DEPENDENCIES = 255;
    public static final int XSLT_CONTEXT = 69;
    private NodeInfo contextNode;
    private NodeInfo currentNode;
    private int position;
    private int last;
    private LastPositionFinder lastPositionFinder;
    private Controller controller;
    private Bindery bindery;
    private Mode currentMode;
    private XSLTemplate currentTemplate;
    private Stack groupActivationStack;
    private StaticContext staticContext;
    private ParameterSet tailRecursion;
    private NodeInfo lastRememberedNode = null;
    private int lastRememberedNumber = -1;
    private Value returnValue = null;

    public Context() {
        this.last = -1;
        this.position = -1;
        this.lastPositionFinder = this;
    }

    public Context(Controller controller) {
        this.controller = controller;
        this.bindery = controller.getBindery();
        this.last = -1;
        this.lastPositionFinder = this;
        this.position = -1;
        this.contextNode = null;
        this.currentNode = null;
        this.currentTemplate = null;
        this.currentMode = null;
        this.groupActivationStack = null;
        this.tailRecursion = null;
        this.returnValue = null;
    }

    public Context newContext() {
        Context context = new Context();
        context.controller = this.controller;
        context.currentNode = this.currentNode;
        context.contextNode = this.contextNode;
        context.position = this.position;
        context.last = this.last;
        context.lastPositionFinder = this.lastPositionFinder;
        context.currentMode = this.currentMode;
        context.currentTemplate = this.currentTemplate;
        context.bindery = this.bindery;
        context.groupActivationStack = this.groupActivationStack;
        context.lastRememberedNode = this.lastRememberedNode;
        context.lastRememberedNumber = this.lastRememberedNumber;
        context.returnValue = null;
        return context;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public Controller getController() {
        return this.controller;
    }

    public Bindery getBindery() {
        return this.bindery;
    }

    public void setBindery(Bindery bindery) {
        this.bindery = bindery;
    }

    public Outputter getOutputter() {
        return this.controller.getOutputter();
    }

    public void setMode(Mode mode) {
        this.currentMode = mode;
    }

    public Mode getMode() {
        return this.currentMode;
    }

    public void setContextNode(NodeInfo nodeInfo) {
        this.contextNode = nodeInfo;
    }

    public NodeInfo getContextNode() {
        return this.contextNode;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }

    public void setLast(int n) {
        this.last = n;
        this.lastPositionFinder = this;
    }

    public void setLastPositionFinder(LastPositionFinder lastPositionFinder) {
        this.lastPositionFinder = lastPositionFinder;
    }

    public int getLast() throws SAXException {
        return this.lastPositionFinder.getLastPosition();
    }

    public int getLastPosition() {
        return this.last;
    }

    public void setCurrentNode(NodeInfo nodeInfo) {
        this.currentNode = nodeInfo;
    }

    public NodeInfo getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentTemplate(XSLTemplate xSLTemplate) {
        this.currentTemplate = xSLTemplate;
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public Stack getGroupActivationStack() {
        if (this.groupActivationStack == null) {
            this.groupActivationStack = new Stack();
        }
        return this.groupActivationStack;
    }

    public void setRememberedNumber(NodeInfo nodeInfo, int n) {
        this.lastRememberedNode = nodeInfo;
        this.lastRememberedNumber = n;
    }

    public int getRememberedNumber(NodeInfo nodeInfo) {
        if (this.lastRememberedNode == nodeInfo) {
            return this.lastRememberedNumber;
        }
        return -1;
    }

    public void applyImports() throws SAXException {
        if (this.currentTemplate == null) {
            throw new SAXException("There is no current template");
        }
        int n = this.currentTemplate.getMinImportPrecedence();
        int n2 = this.currentTemplate.getPrecedence() - 1;
        this.controller.applyImports(this, this.currentMode, n, n2);
    }

    public void setTailRecursion(ParameterSet parameterSet) {
        this.tailRecursion = parameterSet;
    }

    public ParameterSet getTailRecursion() {
        return this.tailRecursion;
    }

    public void setReturnValue(Value value) {
        this.returnValue = value;
    }

    public Value getReturnValue() {
        return this.returnValue;
    }
}

