/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.DummyStaticContext;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import java.util.Vector;
import org.xml.sax.SAXException;

public class AttributeValueTemplate
extends Expression {
    private Vector components;

    public AttributeValueTemplate(Vector vector) {
        this.components = vector;
    }

    public AttributeValueTemplate() {
        this.components = new Vector();
    }

    public AttributeValueTemplate(String string) {
        this.components = new Vector(1);
        this.components.addElement(string);
    }

    public AttributeValueTemplate(Expression expression) {
        this.components = new Vector(1);
        this.components.addElement(expression);
    }

    public static Expression make(String string, StaticContext staticContext) throws SAXException {
        if (string.indexOf("{") < 0 && string.indexOf("}") < 0) {
            return new StringValue(string);
        }
        Vector<Object> vector = new Vector<Object>();
        char c = ' ';
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = string.indexOf("{", n);
            int n4 = string.indexOf("{{", n);
            int n5 = string.indexOf("}", n);
            int n6 = string.indexOf("}}", n);
            if (n5 >= 0 && (n3 < 0 || n5 < n3)) {
                if (n5 != n6) {
                    throw new SAXException("Closing curly brace in attribute value template \"" + string + "\" must be doubled");
                }
                vector.addElement(string.substring(n, n5 + 1));
                n = n5 + 2;
                continue;
            }
            if (n4 >= 0 && n4 == n3) {
                vector.addElement(string.substring(n, n4 + 1));
                n = n4 + 2;
                continue;
            }
            if (n3 >= 0) {
                if (n3 > n) {
                    vector.addElement(string.substring(n, n3));
                }
                int n7 = n3 + 1;
                while (n7 < n2) {
                    if (string.charAt(n7) == '\"') {
                        c = '\"';
                    }
                    if (string.charAt(n7) == '\'') {
                        c = '\'';
                    }
                    if (c != ' ') {
                        ++n7;
                        while (n7 < n2 && string.charAt(n7) != c) {
                            ++n7;
                        }
                        c = ' ';
                    } else if (string.charAt(n7) == '}') break;
                    ++n7;
                }
                if (n7 >= n2) {
                    throw new SAXException("No closing \"}\" in attribute value template " + string);
                }
                String string2 = string.substring(n3 + 1, n7);
                Expression expression = Expression.make(string2, staticContext);
                vector.addElement(expression);
                n = n7 + 1;
                continue;
            }
            vector.addElement(string.substring(n));
            n = n2;
        }
        return new AttributeValueTemplate(vector).simplify();
    }

    public static Expression make(String string) throws SAXException {
        return AttributeValueTemplate.make(string, new DummyStaticContext());
    }

    public Vector getComponents() {
        return this.components;
    }

    public Expression simplify() throws SAXException {
        if (this.components.size() == 0) {
            return new StringValue("");
        }
        if (this.components.size() == 1) {
            if (this.components.elementAt(0) instanceof Expression) {
                return ((Expression)this.components.elementAt(0)).simplify();
            }
            return new StringValue((String)this.components.elementAt(0));
        }
        int n = 0;
        while (n < this.components.size()) {
            if (this.components.elementAt(n) instanceof Expression) {
                Expression expression = (Expression)this.components.elementAt(n);
                this.components.setElementAt(expression.simplify(), n);
            }
            ++n;
        }
        return this;
    }

    public Value evaluate(Context context) throws SAXException {
        return new StringValue(this.evaluateAsString(context));
    }

    public int getDataType() {
        return 3;
    }

    public String evaluateAsString(Context context) throws SAXException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.components.size()) {
            Object e = this.components.elementAt(n);
            if (e instanceof Expression) {
                stringBuffer.append(((Expression)e).evaluateAsString(context));
            } else {
                stringBuffer.append(e);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getDependencies() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.components.size()) {
            n |= ((Expression)this.components.elementAt(n2)).getDependencies();
            ++n2;
        }
        return n;
    }

    public Expression reduce(int n, Context context) throws SAXException {
        throw new SAXException("Cannot reduce expressions in an attribute value template");
    }
}

