/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.Loader;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ObjectValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FunctionProxy
extends Function {
    private Class theClass;
    private Object theInstance;
    private Method theMethod;
    private Class[] theParameterTypes;
    private Class theReturnType;
    private SAXException theException = null;
    private String name;
    private boolean usesContext;
    private boolean isStatic;
    private Constructor theConstructor;
    static /* synthetic */ Class class$com$icl$saxon$Context;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$icl$saxon$expr$Value;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$org$w3c$dom$Document;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$org$w3c$dom$Attr;
    static /* synthetic */ Class class$org$w3c$dom$Text;
    static /* synthetic */ Class class$org$w3c$dom$Comment;
    static /* synthetic */ Class class$org$w3c$dom$ProcessingInstruction;
    static /* synthetic */ Class class$org$w3c$dom$NodeList;

    public void setMethod(Name name) {
        try {
            this.name = name.getLocalName();
            String string = this.getClassName(name);
            int n = this.arguments.size();
            this.theClass = Loader.getClass(string);
            if (this.name.equals("new")) {
                Constructor<?>[] constructorArray = this.theClass.getConstructors();
                int n2 = 0;
                while (n2 < constructorArray.length) {
                    this.theConstructor = constructorArray[n2];
                    this.theParameterTypes = this.theConstructor.getParameterTypes();
                    this.theReturnType = this.theClass;
                    this.isStatic = true;
                    if (this.theParameterTypes.length == n) {
                        return;
                    }
                    ++n2;
                }
                throw new SAXException("No constructor with " + n + (n == 1 ? " parameter" : " parameters") + " found in class " + string);
            }
            Method[] methodArray = this.theClass.getMethods();
            int n3 = 0;
            while (n3 < methodArray.length) {
                int n4;
                this.theMethod = methodArray[n3];
                this.theParameterTypes = this.theMethod.getParameterTypes();
                this.theReturnType = this.theMethod.getReturnType();
                this.isStatic = Modifier.isStatic(this.theMethod.getModifiers());
                int n5 = n4 = this.isStatic ? n : n - 1;
                if (n4 >= 0) {
                    if (this.theParameterTypes.length == n4 && this.matches(this.theMethod.getName(), this.name) && (n4 == 0 || this.theParameterTypes[0] != (class$com$icl$saxon$Context == null ? FunctionProxy.class$("com.icl.saxon.Context") : class$com$icl$saxon$Context))) {
                        this.usesContext = false;
                        return;
                    }
                    if (this.theParameterTypes.length == n4 + 1 && this.matches(this.theMethod.getName(), this.name) && this.theParameterTypes[0] == (class$com$icl$saxon$Context == null ? FunctionProxy.class$("com.icl.saxon.Context") : class$com$icl$saxon$Context)) {
                        this.usesContext = true;
                        return;
                    }
                }
                ++n3;
            }
            throw new SAXException("No method matching " + this.name + " with " + n + (n == 1 ? " parameter" : " parameters") + " found in class " + string);
        }
        catch (SAXException sAXException) {
            this.theException = sAXException;
            return;
        }
    }

    private String getClassName(Name name) throws SAXException {
        String string;
        String string2 = name.getURI();
        if (string2.equals("http://icl.com/saxon")) {
            string = "com.icl.saxon.functions.Extensions";
        } else {
            int n = string2.lastIndexOf(47);
            if (n < 0) {
                string = string2;
            } else {
                if (n == string2.length() - 1) {
                    throw new SAXException("Namespace URI must contain a classname after the final slash (" + string2 + ")");
                }
                string = string2.substring(n + 1);
            }
        }
        return string;
    }

    public boolean isAvailable(Name name) {
        Method[] methodArray;
        try {
            this.name = name.getLocalName();
            methodArray = this.getClassName(name);
            this.theClass = Loader.getClass((String)methodArray);
        }
        catch (Exception exception) {
            return false;
        }
        if (this.name.equals("new")) {
            int n = this.theClass.getModifiers();
            if (Modifier.isInterface(n)) {
                return false;
            }
            if (Modifier.isAbstract(n)) {
                return false;
            }
            return this.theClass.getConstructors().length != 0;
        }
        methodArray = this.theClass.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (this.matches(methodArray[n].getName(), this.name)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean matches(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        do {
            if (string2.charAt(n2) == '-' && ++n2 > n4) {
                return false;
            }
            if (Character.toUpperCase(string.charAt(n)) != Character.toUpperCase(string2.charAt(n2))) {
                return false;
            }
            if (++n2 < n4 || ++n < n3) continue;
            return true;
        } while (n2 < n4 && n < n3);
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getDependencies() {
        return 56;
    }

    public Expression reduce(int n, Context context) throws SAXException {
        if ((n & 0x38) != 0) {
            return this.evaluate(context);
        }
        return this;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        if (this.theException != null) {
            throw this.theException;
        }
        if (this.name.equals("new")) {
            int n = this.theParameterTypes.length;
            int n2 = this.checkArgumentCount(n, n);
            Object[] objectArray = new Object[this.theParameterTypes.length];
            this.setupParams(objectArray, this.theParameterTypes, vector, 0, 0);
            try {
                Object t = this.theConstructor.newInstance(objectArray);
                return new ObjectValue(t);
            }
            catch (InstantiationException instantiationException) {
                throw new SAXException("Cannot instantiate class", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SAXException("Constructor access is illegal", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException("Argument is of wrong type", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SAXException("Exception in extension function" + invocationTargetException.getTargetException().toString());
            }
        }
        if (this.isStatic) {
            this.theInstance = null;
        } else {
            if (vector.size() == 0) {
                throw new SAXException("Must supply an argument for an instance-level extension function");
            }
            if (!(vector.elementAt(0) instanceof ObjectValue)) {
                throw new SAXException("First argument is not an object instance");
            }
            this.theInstance = ((ObjectValue)vector.elementAt(0)).getObject();
        }
        int n = this.theParameterTypes.length - (this.usesContext ? 1 : 0) + (this.isStatic ? 0 : 1);
        int n3 = this.checkArgumentCount(n, n);
        Object[] objectArray = new Object[this.theParameterTypes.length];
        if (this.usesContext) {
            context.setStaticContext(this.getStaticContext());
            objectArray[0] = context;
        }
        this.setupParams(objectArray, this.theParameterTypes, vector, this.usesContext ? 1 : 0, this.isStatic ? 0 : 1);
        try {
            Object object = this.theMethod.invoke(this.theInstance, objectArray);
            return FunctionProxy.convertJavaObjectToXPath(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException("Method access is illegal", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SAXException("Argument is of wrong type", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SAXException) {
                throw (SAXException)throwable;
            }
            throw new SAXException("Exception in extension function " + invocationTargetException.getTargetException().toString());
        }
    }

    public static Value convertJavaObjectToXPath(Object object) throws SAXException {
        if (object instanceof Boolean) {
            return new BooleanValue((Boolean)object);
        }
        if (object instanceof Double) {
            return new NumericValue((Double)object);
        }
        if (object instanceof Float) {
            return new NumericValue(((Float)object).floatValue());
        }
        if (object instanceof Short) {
            return new NumericValue(((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return new NumericValue(((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return new NumericValue(((Long)object).longValue());
        }
        if (object instanceof String) {
            return new StringValue((String)object);
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof NodeInfo) {
            return new SingletonNodeSet((NodeInfo)object);
        }
        if (object instanceof NodeList) {
            NodeList nodeList = (NodeList)object;
            NodeInfo[] nodeInfoArray = new NodeInfo[nodeList.getLength()];
            int n = 0;
            while (n < nodeList.getLength()) {
                if (!(nodeList.item(n) instanceof NodeInfo)) {
                    throw new SAXException("Result NodeList contains non-Saxon DOM Nodes");
                }
                nodeInfoArray[n] = (NodeInfo)nodeList.item(n);
                ++n;
            }
            return new NodeSetExtent(nodeInfoArray);
        }
        if (object instanceof Node) {
            throw new SAXException("Result is a non-Saxon DOM Node");
        }
        return new ObjectValue(object);
    }

    private void setupParams(Object[] objectArray, Class[] classArray, Vector vector, int n, int n2) throws SAXException {
        int n3 = n;
        int n4 = n2;
        while (n4 < vector.size()) {
            Value value = (Value)vector.elementAt(n4);
            Class clazz = classArray[n3];
            if (clazz == Boolean.TYPE) {
                objectArray[n3++] = new Boolean(value.asBoolean());
            } else if (clazz == Double.TYPE) {
                objectArray[n3++] = new Double(value.asNumber());
            } else if (clazz == Float.TYPE) {
                objectArray[n3++] = new Float((float)value.asNumber());
            } else if (clazz == Integer.TYPE) {
                objectArray[n3++] = new Integer((int)value.asNumber());
            } else if (clazz == Long.TYPE) {
                objectArray[n3++] = new Long((long)value.asNumber());
            } else if (clazz == Short.TYPE) {
                objectArray[n3++] = new Short((short)value.asNumber());
            } else if (clazz == (class$java$lang$String == null ? FunctionProxy.class$("java.lang.String") : class$java$lang$String)) {
                objectArray[n3++] = new String(value.asString());
            } else if (clazz == (class$com$icl$saxon$expr$Value == null ? FunctionProxy.class$("com.icl.saxon.expr.Value") : class$com$icl$saxon$expr$Value)) {
                objectArray[n3++] = value;
            } else if (value instanceof NodeSetValue && (clazz == (class$org$w3c$dom$Node == null ? FunctionProxy.class$("org.w3c.dom.Node") : class$org$w3c$dom$Node) || clazz == (class$org$w3c$dom$Document == null ? FunctionProxy.class$("org.w3c.dom.Document") : class$org$w3c$dom$Document) || clazz == (class$org$w3c$dom$Element == null ? FunctionProxy.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element) || clazz == (class$org$w3c$dom$Attr == null ? FunctionProxy.class$("org.w3c.dom.Attr") : class$org$w3c$dom$Attr) || clazz == (class$org$w3c$dom$Text == null ? FunctionProxy.class$("org.w3c.dom.Text") : class$org$w3c$dom$Text) || clazz == (class$org$w3c$dom$Comment == null ? FunctionProxy.class$("org.w3c.dom.Comment") : class$org$w3c$dom$Comment) || clazz == (class$org$w3c$dom$ProcessingInstruction == null ? FunctionProxy.class$("org.w3c.dom.ProcessingInstruction") : class$org$w3c$dom$ProcessingInstruction))) {
                objectArray[n3++] = ((NodeSetValue)value).getFirst();
            } else if (value instanceof NodeSetValue && clazz == (class$org$w3c$dom$NodeList == null ? FunctionProxy.class$("org.w3c.dom.NodeList") : class$org$w3c$dom$NodeList)) {
                objectArray[n3++] = value;
            } else if (value instanceof BooleanValue) {
                objectArray[n3++] = new Boolean(value.asBoolean());
            } else if (value instanceof NumericValue) {
                objectArray[n3++] = new Double(value.asNumber());
            } else if (value instanceof StringValue) {
                objectArray[n3++] = new String(value.asString());
            } else if (value instanceof ObjectValue) {
                Object object = ((ObjectValue)value).getObject();
                objectArray[n3++] = object;
            } else {
                objectArray[n3++] = value;
            }
            ++n4;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

