/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.SAXException;

public class NormalizeSpace
extends Function {
    public String getName() {
        return "normalize-space";
    }

    public int getDataType() {
        return 3;
    }

    public int getIntrinsicDependencies() {
        int n = this.arguments.size();
        return n == 0 ? 8 : 0;
    }

    protected Expression reduceIntrinsic(int n, Context context) throws SAXException {
        int n2 = this.checkArgumentCount(0, 1);
        if (n2 == 0 && (n & 8) != 0) {
            return this.evaluate(context);
        }
        return this;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        String string;
        int n = this.checkArgumentCount(0, 1);
        if (vector.size() == 0) {
            string = context.getContextNode().getValue();
        } else {
            Value value = (Value)vector.elementAt(0);
            string = value.asString();
        }
        return new StringValue(NormalizeSpace.normalize(string));
    }

    public Expression simplify() throws SAXException {
        int n = this.checkArgumentCount(0, 1);
        if (n == 1) {
            return this.simplifyPureFunction();
        }
        return super.simplify();
    }

    public static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

