/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StyleElement;
import org.xml.sax.SAXException;

public class XSLValueOf
extends StyleElement {
    private Expression select;
    private boolean disable = false;

    public boolean isInstruction() {
        return true;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public void prepareAttributes() throws SAXException {
        if (this.getAttributeValue("default") != null) {
            throw this.styleError("default attribute of xsl:value-of is no longer available");
        }
        String[] stringArray = new String[]{"select", "disable-output-escaping"};
        this.allowAttributes(stringArray);
        String string = this.getAttributeValue("select");
        if (string == null) {
            this.reportAbsence("select");
        }
        this.select = string.trim().equals(".") ? null : Expression.make(string, this);
        String string2 = this.getAttributeValue("disable-output-escaping");
        if (string2 != null) {
            if (string2.equals("yes")) {
                this.disable = true;
            } else if (string2.equals("no")) {
                this.disable = false;
            } else {
                throw this.styleError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    public void validate() throws SAXException {
        this.checkWithinTemplate();
        this.checkEmpty();
    }

    public void process(Context context) throws SAXException {
        Outputter outputter = context.getOutputter();
        if (this.disable) {
            outputter.setEscaping(false);
        }
        if (this.select == null) {
            context.getCurrentNode().copyStringValue(outputter);
        } else {
            String string = this.select.evaluateAsString(context);
            if (!string.equals("")) {
                outputter.writeContent(string);
            }
        }
        if (this.disable) {
            outputter.setEscaping(true);
        }
    }
}

