/* Help-related definitions for Xconq.
   Copyright (C) 1991-1994, 1996, 1998, 1999 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

enum nodeclass {
    miscnode,
    utypenode,
    mtypenode,
    ttypenode,
    atypenode
};

#include "obstack.h"

typedef struct a_textbuffer {
    char *text;
    int bufmax;
    struct obstack ostack;
} TextBuffer;

typedef struct a_helpnode {
    char *key;
    void (*fn)(int arg, char *key, TextBuffer *buf);
    enum nodeclass nclass;
    int arg;
    char *text;
    int textend;
    struct a_helpnode *prev;
    struct a_helpnode *next;
} HelpNode;

extern void tbprintf(TextBuffer *buf, char *str, ...);
extern void tbcat(TextBuffer *buf, char *str);

extern HelpNode *first_help_node;

extern HelpNode *copying_help_node;
extern HelpNode *warranty_help_node;

extern void init_help(void);
extern HelpNode *create_help_node(void);
extern HelpNode *add_help_node(char *key,
			       void (*fn)(int, char *, TextBuffer *),
			       int arg, HelpNode *prevnode);
extern HelpNode *find_help_node(HelpNode *node, char *str);
extern void create_game_help_nodes(void);
extern char *get_help_text(HelpNode *node);

extern void describe_topics(int arg, char *key, TextBuffer *buf);
extern void describe_command(int ch, char *name, char *help, int onechar, TextBuffer *buf);
extern void notify_instructions(void);

extern void print_any_news(void);
extern void print_game_description_to_file(FILE *fp);

extern void describe_copyright(int arg, char *key, TextBuffer *buf);
extern void describe_warranty(int arg, char *key, TextBuffer *buf);
