.\"
.\" $Id: xmbdfed.man,v 1.20 2004/02/08 23:59:00 mleisher Exp $
.\"
.TH XMBDFED 1 "09 February 2004" "X Version 11"
.SH NAME 
xmbdfed \- Motif-based BDF font editor

.SH SYNOPSIS
.B xmbdfed
[\fIoptions\fP] [\fIfonts ...\fP]

.SH DESCRIPTION
.I xmbdfed
lets you interactively create new bitmap font files or modify
existing ones.  It allows editing multiple fonts and multiple
glyphs, it allows cut and paste operations between fonts and
glyphs and editing font properties.
.I xmbdfed
can import Metafont PK/GF fonts, Han Bitmap Font Format (HBF) fonts, Linux
console fonts (PSF, CP, and EGA/VGA) fonts, Sun VF fonts, TrueType (TTF)
fonts, or grab a font from the X server.
.I xmbdfed
can export PSF2 Linux console fonts and HEX fonts (see online help).
The editor support two and four bits per pixel gray scale fonts.

.I xmbdfed
works on X Window System Version 11 (X11), Release 5 or Release
6, with Motif 1.2.x or Motif 2.x.

.SH OPTIONS
.I xmbdfed
accepts the following command line arguments:

.PP
.TP 8
.I -nc
do not preserve comments (by default,
.I xmbdfed
automatically collects comments that are saved with the font).
.PP
.TP 8
.I -nu
do not preserve unencoded glyphs (by default,
.I xmbdfed
preserves the unencoded glyphs).
.PP
.TP 8
.I -nm
do not make metrics corrections (by default,
.I xmbdfed
attempts to make metrics corrections automatically).
.PP
.TP 8
.I -np
do not pad character-cell bitmaps (by default,
.I xmbdfed
pads character-cell bitmaps with 0's to the cell dimensions when the font is 
saved).
.PP
.TP 8
.I -bp
allow blank pages (by default,
.I xmbdfed
skips blank pages).
.PP
.TP 8
.I -ed
do not present the "Really Exit?" dialog (by default, this dialog always
presented).
.PP
.TP 8
.I -ps n
set default point size (if unspecified, 
.I xmbdfed
sets it to 12).
.PP
.TP 8
.I -hres n
set default horizontal resolution.
.PP
.TP 8
.I -vres n
set default vertical resolution.
.PP
.TP 8
.I -res n
set both default resolutions (if unspecified,
.I xmbdfed
sets both horizontal and vertical resolution to that of display,
(e.g. 90x90 dpi for Sun workstations).
.PP
.TP 8
.I -sp s
set the default font spacing ("p" for Proportional, "m" for Monowidth, or "c"
for Character Cell).
.PP
.TP 8
.I -bpp n
set the default bits per pixel for new fonts (1, 2, or 4).
.PP
.TP 8
.I -eol e
set the default end-of-line type ("u" for Unix LF, "d" for DOS/Windows CRLF,
or "m" for Macintosh CR).
CR)
.PP
.TP 8
.I -g glyph-code
specify the initial glyph code at startup.  The glyph code can be specified in
decimal, octal, or hex.  Octal numbers must be prefixed with the digit 0, and
hex numbers must be prefixed with one of: \fI0x, 0X, U+, U-, \\u\fP.
.PP
.TP 8
.I -pb
do not use the progress bar.  Use the watch cursor instead.
.PP
.TP 8
.I -cb code-base
specify the code base used to display the glyphs encodings (can be "octal",
"decimal", or "hexadecimal").

.SH FONT GRID

At the top of each editor window there are some
fields and buttons.  These are:
.IP
The "Font" text field is where the font name
is set so it can be edited.

The "Glyph" field is a label that provides
some information about glyph name, encoding, and
metrics when a glyph is selected.  When a range
of glyphs are selected, this field displays the
start and end codes of the range.

The push buttons are used to navigate through the
glyph pages.  The "Previous Page" and "Next Page"
buttons normally skip glyph pages that are empty,
but that can be changed using the "Setup" dialog.

If the Shift key is held down while the "Next"
or "Previous" page buttons is pressed, then the
paging behavior will be opposite of the current
paging behavior.

The "Page" field indicates the current glyph page
and also allows a specific page number to be entered.
Once a page number is entered, pressing the Return
key will cause the Font Grid to shift to that page.
The page number entered is expected to be a decimal
number.

The "Code" field is provided for situations where
the page number is not known, but the encoding is
known.  The encoding entered in this field must be
in the base (8, 10, or 16) that is currently being
used to display glyph encodings (see the "View"
menu below).  Once the encoding is entered, pressing
the Return key will cause the Font Grid to shift to
the page containing the encoding.
.PP
The main window of each font editor is called the
.I Font Grid.
Each Font Grid has a clipboard used for passing glyphs around.
This clipboard is called 
.I FONTGRID_CLIPBOARD.
The format of the data stored to this clipboard is not documented yet.
.sp
When a glyph has been modified either by the user or
by automatic metrics corrections when the font is loaded,
the glyph code above the glyph cell will be highlighted.

.SH Font Grid Menus
The 
.I File
menu has the following entries:
.PP
.TP 4
.I New <Ctrl+N>
This creates a new font using the current defaults for point size, horizontal
and vertical resolution, and font spacing.
.PP
.TP 4
.I Open <Ctrl+O>
This opens a new font in the current Font Grid.  If the font in the grid has
been modified, the option to save the font before loading a new one will be
given.
.PP
.TP 4
.I Save <Ctrl+S>
Save the current font.  If the current font does not have a file name, a file
selection dialog will pop up so a file name can be entered.
.br
When the font is saved, it will automatically generate a list of
_XFREE86_GLYPH_RANGE properties containing a list of glyph codes available in
the font.
.PP
.TP 4
.I Save As <Ctrl+W>
Save the current font with some other name.
.br
When the font is saved, it will automatically generate a list of
_XFREE86_GLYPH_RANGE properties containing a list of glyph codes available in
the font.
.PP
The
.I Import
submenu of the
.I File
menu has the following entries:
.PP
.TP 8
.in 4
.I PK/GF Font <Ctrl+K>
Import a Metafont PK or GF font.
.PP
.TP 8
.in 4
.I Console Font <Ctrl+L>
Import a binary console font used by Linux and Sun (PSF1, PSF2, CP, vfont, and
other font formats).
.PP
.TP 8
.in 4
.I HBF Font <Ctrl+H>
Import an HBF font.
.PP
.TP 8
.in 4
.I Windows Font <Ctrl+B>
Import a Windows FON/FNT font.  This will also import fonts from .EXE
and .DLL files as well.
.PP
.TP 8
.in 4
.I TrueType Font <Ctrl+Y>
Import a TrueType font (.ttf extension) or a TrueType collection (.ttc
extension).
.PP
.TP 8
.in 4
.I Server Font <Ctrl+G>
Import a font from the X server.
.PP
The \fIExport\fR submenu of the \fIFile\fR menu has the following entries:
.PP
.TP 8
.in 4
.I PSF <Ctrl+F>
This will export the current BDF font or the currently selected glyphs to a
PSF2 font.  Glyphs in PSF fonts are usually arranged in a specific way to make
them work properly with the basic display driver.  Many of these fonts come
with mapping tables attached that indicate which Unicode characters a glyph
can be used for.  The mapping table allows the console to attempt to display
Unicode text.
.sp
During the export, an option menu will let you select whether to:
.TP 10
.in 10
Export Font with Mapping Table
.br
Export Font Only
.br
Export Mapping Table Only
.TP 8
.in 8
Only the first 512 glyphs will be exported to the font.
.PP
.TP 8
.in 4
.I HEX
.br
This will export the current BDF font into the HEX format (see
http://czyborra.com/unifont/).
.PP
.TP 4
.I Exit/Close <Ctrl+F4>
Exit the program if this is the primary Font Grid or simply hide (unmap) the
current Font Grid window.
.PP
The 
.I Edit
menu has the following entries:
.PP
.TP 4
.I Copy <Ctrl+C> or <Button3Down>
This copies the current selection to the Font Grid clipboard.
.PP
.TP 4
.I Cut <Ctrl+X> or <Key>Delete or <Key>BackSpace
This copies the current selection to the Font Grid clipboard and
then deletes the selection.
.PP
.TP 4
.I Paste <Ctrl+V> or <Button2Down>
This replaces the glyphs starting at the currently selected position with the
Font Grid clipboard.
.PP
.TP 4
.I Overlay <Ctrl+Shift+V> or Ctrl<Button2Down>
This merges the Font Grid cliboard with the glyphs starting at the currently
selected position.  The names of the modified glyphs are not changed.
.PP
.TP 4
.I Insert <Ctrl+Meta+V> or Shift<Button2Down>
This inserts the Font Grid clipboard in front of the currently selected
position.
.PP
.TP 4
.I Properties <Ctrl+P>
This invokes the font property editor.
.PP
.TP 4
.I Comments <Ctrl+M>
This invokes the font comments editor.
.PP
.TP 4
.I Font Info <Ctrl+I>
This invokes a dialog that allows changes to some of the font information so
these values do not have to be changed using the property editor.  These
values include the default character, font device width (for monowidth and
character cell fonts), font ascent and descent, font vertical and horizontal
resolution, and the font spacing.
.PP
The 
.I Font Name
submenu of the
.I Edit
menu has the following four entries:
.PP
.TP 8
.in 4
.I Make XLFD Name
If the font does not have an XLFD name, this
will save the current font name in the
.I _ORIGINAL_FONT_NAME
font property and then generate an XLFD name
for the font.
.PP
.TP 8
.in 4
.I Update Name From Properties
This will update the XLFD font name fields from
the font property list.
.PP
.TP 8
.in 4
.I Update Properties From Name
This will update the font properties from the
XLFD font name.
.PP
.TP 8
.in 4
.I Update Average Width
This will update the average width field of the
XLFD font name and will update the
.I AVERAGE_WIDTH
font property as a side effect.
.PP
.TP 8
.I Name Glyphs
.PP
.TP 8
.in 4
.I Unicode Names
This will rename all the glyphs using names taken from a file in the Unicode
Character Database format.  This file can be set in the configuration file
or set using the \fISetup\fR dialog.
.PP
.TP 8
.in 4
.I Unicode Values
This will rename all the glyphs with a hexadecimal value prefixed by \fC0x\fR,
\fCU+\fR, or \fC\\u\fR (example: 0x010D, U+010D, \\u010D).
.PP
.TP 8
.I Test Glyphs <Ctrl+Z>
This will toggle the glyph test dialog on or off for the editor.  When this is
active, selecting a glyph from any Font Grid will also add it to the glyph
test dialog.  When changes are made to a glyph or the font bounding box, the
glyph test dialog will be updated accordingly.
.sp
The glyph test dialog provides a toggle to turn the baseline on or off and
another toggle to draw from right to left instead of left to right.
.PP
.TP 8
.I Setup <Ctrl+T>
This will invoke the dialog to edit various settings
used by the editor such as the default point size, resolution and font
spacing.
.PP
The 
.I View
menu has the following entries:
.PP
.TP 4
.I Unencoded <Ctrl+E>
This will toggle between displaying the unencoded (glyphs with an
.I ENCODING
field of -1) and encoded glyphs.
.PP
.TP 4
.I Code Base
Selects displaying of glyph encoding.  Options are Octal
(base 8), Decimal (base 10) or Hexadecimal (base 16).
.PP
.TP 4
.I Other Page <Ctrl+Shift+S>
This will toggle between the current page and the last page
that was viewed.
.PP
.TP 4
.I Vertical View <Ctrl+Q>
This will toggle the FontGrid between showing the glyphs
horizontally (default) and vertically.
.PP
.TP 4
.I Messages <Ctrl+A>
This will show messages generated when corrections to the font metrics are
done or errors are encountered.
.PP
The
.I Operations
menu has the following entries:
.PP
.TP 4
.I Translate <Ctrl+D>
This will bring up the dialog for entering the X offset and Y offset used to
translate the glyph to a new location.
.sp
The option of translating the selected glyphs or all of the glyphs is
provided.
.PP
.TP 4
.I Rotate <Ctrl+R>
This will bring up the dialog for entering the rotation angle.  The rotation
is limited to between plus or minus 1 and 359 degrees.
.sp
The option of rotating the selected glyphs or all of the glyphs is provided.
.PP
.TP 4
.I Shear <Ctrl+J>
This will bring up the dialog for entering theangle of the shear.  The shear
is limited to plus or minus 45 degrees.
.sp
The option of rotating the selected glyphs or all of the glyphs is provided.
.PP
.TP 4
.I Embolden <Ctrl+Shift+B>
This will bring up the dialog for emboldening either the selected or all
glyphs.
.sp
To \fIembolden\fP means to make bold.
.PP
The 
.I Editors
menu has the following entries:
.PP
.TP 4
.I New <Ctrl+N>
This will cause a new editor to be created using the point size, resolution,
and bits per pixel set in the config file, from the command line or from the
Setup dialog.
.PP
.TP 4
.I [editor list]
The remaining menu items are all the Font Grid's that have been
created.  Choosing one will force that window to be made visible (mapped)
and also put that window on top.

.SH Font Grid Other Features
Double clicking the mouse on one of the glyphs will start a Glyph Editor for
that glyph.
.sp
The font name can be edited in the Font Grid and page switching can be done
with the buttons on the Font Grid.

.SH GLYPH EDITOR
The
.I Glyph Editor
provides a simple bitmap editor
designed to edit glyph bitmaps and other glyph
information.  The Glyph Editors all use a special
clipboard used to pass bitmaps between the Glyph
Editors.  This clipboard is called
.I GLYPHEDIT_CLIPBOARD.
.sp
The only limit on the number of Glyph Editors that
can be open at one time is the amount of memory.

.SH Glyph Editor Menus
The
.I File
menu has the following entries:
.PP
.TP 4
.I Update <Ctrl+S>
This will update the Font Grid with the modified glyph.
.PP
.TP 4
.I Update and Next <Ctrl+U>
This will update the FontGrid with the modified glyph and move to the next
glyph.
.PP
.TP 4
.I Update and Previous <Ctrl+B>
This will update the FontGrid with the modified glyph and move to the previous
glyph.
.PP
.TP 4
.I Import XBM <Ctrl+I>
This will pop up a file selection dialog so an X Bitmap file (.xbm extension)
can be selected to be imported into the glyph editor.
.sp
The imported bitmap is handled the same way as bitmaps pasted.  They are
inserted as a selection with the move operation active and do not destroy any
bitmap that already exists in the editor.
.PP
.TP 4
.I Export XBM <Ctrl+O>
This will pop up a file selection dialog so that the glyph image can be
exported as an X Bitmap file (.xbm extension).
.PP
.TP 4
.I Close <Ctrl+F4>
This will close the Glyph Editor.
.PP
The
.I Edit
menu has the following entries:
.PP
.TP 4
.I Reload <Ctrl+L>
This will reload the glyph and discard any changes made in the GlyphEditor.
.PP
.TP 4
.I Resize BBX <Ctrl+R>
This will allow changing the sizes of the glyph bounding box including the
left/right bearings and the glyph ascent/descent.  If this change causes the
glyph bounding box to be larger than the font bounding box, the font bounding
box will be resized when the glyph is saved next.
.PP
.TP 4
.I Copy <Ctrl+C>
This will copy the currently selected portion of the bitmap to the Glyph
Editor clipboard.
.PP
.TP 4
.I Cut <Ctrl+X>
This will copy the currently selected portion of the bitmap to the Glyph
Editor clipboard and then delete the selection.
.PP
.TP 4
.I Paste <Ctrl+V>
This will paste the contents of the Glyph Editor clipboard into the current
Glyph Editor with the top-left coordinate of the bitmap on the clipboard
pasted at the location of the mouse.  If the bitmap is too big to fit if it is
pasted at the mouse location, the bitmap will be shifted until it fits
completely in the Glyph Editor.
.PP
.TP 4
.I Select All <Ctrl+A>
This will select the whole glyph bitmap.
.PP
.TP 4
.I Next Glyph <Ctrl+N>
This will move the Glyph Editor to the next glyph position in the Font Grid.
If the current glyph has been modified, a save prompt will appear before
moving to the next glyph.
.PP
.TP 4
.I Previous Glyph <Ctrl+P>
This will move the Glyph Editor to the previous glyph position in the Font
Grid.  If the current glyph has been modified, a save prompt will appear
before moving to the previous glyph.
.PP
The
.I Operation
menu has the following entries:
.PP
.TP 4
.I Draw <Ctrl+D>
Change the Glyph Editor into Draw mode.
.PP
.TP 4
.I Move <Ctrl+M>
Change the Glyph Editor into Move mode.  Move mode allows selecting a portion
of the glyph bitmap and moving it to another location.
.PP
.TP 4
.I Copy <Ctrl+Y>
Change the Glyph Editor into Copy mode.  Copy mode allows copying a portion of
the glyph bitmap and moving it to another location.
.PP
.TP 4
.I Rotate <Ctrl+T>
This will invoke the rotation dialog that allows the degrees of rotation
to be specified.  Rotation can be between 1 and 359 degrees.
.PP
.TP 4
.I Shear <Ctrl+E>
This will invoke the shear dialog that allows the degrees of horizontal
shear to be specified.  Other names for shearing are obliquing or slanting.
Shearing is allowed between 1 and 45 degrees.
.PP
.TP 4
.I Embolden <Ctrl+H>
This will embolden the glyph in a simple manner.

.SH Glyph Editor Other Features
When the mouse is used to shift the bitmap by one of the buttons, holding
the mouse down will cause the activity to repeat.

When editing fonts with two or four bits per pixel, a strip of colors is
presented on the left side of the Glyph Editor toolbox.  These can be selected
with the mouse or with certain keys (see online help text for details).

.SH RESOURCES
The program understands all of the core X Toolkit resource names
and classes as well as:
.\".in +1in
.TP 8
.B "noComments (Boolean)"
Specify whether
.I xmbdfed
preserves comments or not (default False).
.TP 8
.B "noUnencodedGlyphs (Boolean)"
Specify whether
.I xmbdfed
preserves unencoded glyphs (character code -1) or not (default False).
.TP 8
.B "noMetricsCorrections (Boolean)"
Specify whether
.I xmbdfed
does metrics corrections or not (default False).
.TP 8
.B "padCharacterCells (Boolean)"
Specify whether character-cell glyphs should be padded to cell geometry
(default False).
.TP 8
.B "skipBlankGlyphPages (Boolean)"
Specify whether
.I xmbdfed
skips blank pages or not (default True).
.TP 8
.B "fontPointSize (Cardinal)"
Sets default point size.
.TP 8
.B "fontHorizontalResolution (Cardinal)"
Sets default horizontal resolution.
.TP 8
.B "fontVerticalResolution (Cardinal)"
Sets default vertical resolution.
.TP 8
.B "fontResolution (Cardinal)"
Sets both default horizontal and vertical resolutions.
.TP 8
.B "fontSpacing (String)"
Sets the default font spacing ("p", "m", or "c")

.SH "SEE ALSO"
xfed(1), bdftopcf(1), bdftosnf(1), psfaddtable(1), psfgettable(1), pfaedit(1)
.br
\fIGlyph Bitmap Distribution Format (BDF) Specification\fP, Application
Note 5005, Adobe System Inc, 1993
.br
\fIX Logical Font Description\fP, X Consortium

.SH ACKNOWLEDGMENTS

Ross Patterson for his HBF code.
.br
der Mouse for his "getbdf" code.
.br
K. Carothers and A. Korobka for their "fnt2bdf" code in Wine.
.sp
Mike Stroyan <mike_stroyan@fc.hp.com> for patches.
.br
Primoz Peterlin <primoz.peterlin@biofiz.mf.uni-lj.si> for this manual page.
.br
Danny Backx <u27113@kb.be> for the LessTif Imakefile.
.br
Donald Page <donaldp@sco.com> for patches.
.br
Michal Szymanski <msz@sirius.astrouw.edu.pl> for problem reports.
.br
Werner Lemberg <a7971428@unet.univie.ac.at> for problem reports.
.br
William F. Maton <wmaton@enterprise.ic.gc.ca> for problem reports.
.br
Ivan Nejgebauer <ian@uns.ns.ac.yu> for problem reports.
.br
Solofo <solofo@mpi-sb.mpg.de> for problem reports.
.br
Dave Bodenstab <imdave@mcs.net> for patches.
.br
W. Chao <wchao@HRZ.Uni-Bielefeld.DE> for Makefile changes and problem report.
.br
Andreas Reuter <ar205@bonzo.geowiss.nat.tu-bs.de> for problem reports.
.br
Leonard Dickens <leonard@saul.hipgraphics.com> for IRIX 6.3 Makefile changes.
.br
Markus Kuhn <Markus.Kuhn@cl.cam.ac.uk> for suggestions.
.br
Jim Knoble <jmknoble@pobox.com> for dialog geometry fixes.
.br
Darren Stuart Embry <dsembr01@ox.slug.louisville.edu> for HP/UX 10.20 X11R6
Makefile additions.
.br
Vladimir Volovich <vvv@vvv.vsu.ru> for pointing out something I forgot to
test.
.br
Ben Fry <fry@media.mit.edu> for IRIX 6.5.2 variables for the Makefile.
.br
J.H.M. Dassen (Ray) <jdassen@debian.org> for bug fixes.
.br
Robert Brady <rwb197@ecs.soton.ac.uk> for pointing out a problem.
.br
Stefan Monnier <monnier@cs.yale.edu> for a bug report.
.br
Humphrey Clerx <humphrey.clerx@eurocontrol.be> for a bug report.
.br
Rudolf Cejka <cejkar@dcse.fee.vutbr.cz> for bug fixes and a suggestion.
.br
Baruch Even <baruch@ev-en.org> for a bug fix.
.br
Sergey Vlasov <vsu@mivlgu.murom.ru> for bug fixes.
.br
Daniel Neuburger <daniel.neuburger@lmco.com> for bug fixes.
.br
Pierre HANSER <Pierre.Hanser@sxb.bsf.alcatel.fr> for a bug fix.
.br
Patrick Hagglund <patrik.hagglund@bredband.net> for FreeType 2 support.

.SH AUTHOR
Mark Leisher
.br
Computing Research Lab
.br
New Mexico State University
.br
Email: mleisher@crl.nmsu.edu
