/*
 * easy_spice. A small spice front-end for students
 * Routoure Jean-Marc  2000-2001.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "easyspice.h"

/* global data structure */
EasySpice *easyspice;

int
main (int argc, char *argv[])
{
  gchar *dirname, *filename;

  gtk_set_locale ();
  gtk_init (&argc, &argv);

#if ENABLE_NLS
  setlocale(LC_ALL, "");
  setlocale(LC_NUMERIC, "POSIX");
  bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain(PACKAGE);
  bind_textdomain_codeset (PACKAGE, "UTF-8");
#endif
  
  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

  /* easy_spice setup */
  easyspice=g_malloc(sizeof(EasySpice));
  easyspice_init(easyspice);
  
  /* setup default spice variables */
  easyspice->spice_vars=g_malloc(sizeof(SpiceVariables));
  spice_variables_init(easyspice->spice_vars);
  spice_variables_default(easyspice->spice_vars);
  /* setup default geda variables */
  easyspice->geda=g_malloc(sizeof(GedaSettings));
  geda_settings_init(easyspice->geda);
  geda_settings_default(easyspice->geda);
  /* setup default external commands */
  easyspice->commands=g_malloc(sizeof(ExternalProgramms));
  commands_init(easyspice->commands);
  commands_set_default(easyspice->commands);
  /* setup spice values */
  easyspice->spice_vars=g_malloc(sizeof(SpiceVariables));
  spice_variables_init(easyspice->spice_vars);
  spice_variables_default(easyspice->spice_vars);
  /* text viewer setup */
  easyspice->textviewer=g_malloc(sizeof(Textviewer));
  textviewer_init(easyspice->textviewer);
  /* post processing setup */
  easyspice->postproc=g_malloc(sizeof(PostProcessing));
  postprocessing_init(easyspice->postproc);
  /* spice library setup */
  easyspice->spicelibrary=g_malloc(sizeof(SpiceLibrary));
  spicelibrary_init(easyspice->spicelibrary);

  /* netlist structure (should be renamed) */
  easyspice->netlist=g_malloc(sizeof(SpiceNetlist));
  easyspice->netlist->nodenames=NULL;
  easyspice->netlist->op_result=NULL;
  easyspice->netlist->devices=NULL;
  
  /* create main window */
  easyspice->win_main = create_toplevel_window (easyspice);

  /* read local configuration file */
  localconfiguration_file_read(easyspice);

  /* get the project name */
  if (argc==2) {
    /* check wheter it is a readable file */
    dirname=g_path_get_dirname(argv[1]);
    filename=g_path_get_basename(argv[1]);
    /* change to the new directory */
    chdir(dirname);
    g_free(dirname);

    if (g_str_has_suffix(filename, PROJECT_EXTENTION)) {
      easyspice->project=g_strndup(filename, strlen(filename) -strlen(PROJECT_EXTENTION));
    }
    else {
      easyspice->project=g_strdup(filename);
    }
    g_free(filename);
    easyspice_filename_update(easyspice);
    /* try to load the project file */
    configuration_file_read(easyspice, easyspice->file_easyspice_project);
  }
  else {
    easyspice->project=g_strdup("");
  }

  /* set values inside win_main */
  project_set_title(easyspice);   
  spice_variables_set_entries(easyspice->win_main ,easyspice->spice_vars);

  gtk_widget_show (easyspice->win_main);

  /* Turn the flags off */
  led_off(easyspice->win_main);

  /* Get the environnement variables */
  /* EASY_SPICE_BIN */
  if (getenv("EASY_SPICE_BIN") != NULL)
    easyspice->commands->spice_command =
      update_str(easyspice->commands->spice_command,
		 getenv("EASY_SPICE_BIN"));
  
  /* Entering GTK main loop */
  gtk_main ();

  /* TODO: Free all memory of the structures */
  g_free(easyspice);

  return 0;
}
