//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_31.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot31(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[31] = {1.973961619317818e-02,1.777314270714174e-01,4.941155764894072e-01,9.696987316449983e-01,1.605705114098536e+00,
    2.403794111724268e+00,3.366084710314292e+00,4.495187636816266e+00,5.794246436988960e+00,7.266989129559398e+00,8.917792624474627e+00,1.075176281839592e+01,
    1.277483426484725e+01,1.499389467681596e+01,1.741694143510619e+01,2.005328002532177e+01,2.291377835512352e+01,2.601119694024908e+01,2.936062422099912e+01,
    3.298006091817217e+01,3.689122121747779e+01,4.112065894699022e+01,4.570139813115516e+01,5.067537937066850e+01,5.609729355498452e+01,6.204092566265864e+01,
    6.861041363445379e+01,7.596219511656251e+01,8.435387463479354e+01,9.427804196974294e+01,1.070011389901059e+02};
  constexpr double aw[31] = {2.755176345713133e-01,2.354014137664905e-01,1.717735112789321e-01,1.069655603592892e-01,5.677355644112947e-02,
    2.564184454466973e-02,9.834282267149455e-03,3.194510495128344e-03,8.761600412960132e-04,2.021521799945729e-04,3.906693268870992e-05,6.291925684128613e-06,
    8.395636881833487e-07,9.218573733578959e-08,8.263864761851688e-09,5.992692864265347e-10,3.477943758772892e-11,1.595214880176060e-12,5.697094988418945e-14,
    1.556417651227674e-15,3.183888774771905e-17,4.751303844123422e-19,5.007373932494541e-21,3.576785299957721e-23,1.641411635392467e-25,4.502923907452466e-28,
    6.672511095938867e-31,4.588857404397464e-34,1.142402896672514e-37,6.427456967173713e-42,2.483713818053586e-47};
  constexpr double x[11904] = {  1.243124640927281e-03, -9.860037795878258e-06,  5.861805125465705e-08, -3.095141657198346e-10,  1.530557625643881e-12,
 -7.256946536399372e-15,  3.340320651078955e-17, -1.503630014260189e-19,  6.650035004499973e-22, -2.898555378676712e-24,  1.247759255533868e-26, -5.312649906008030e-29,
  1.117015628884473e-02, -8.816470558478981e-05,  5.189984157556771e-07, -2.695392801148270e-09,  1.299769934653964e-11, -5.945498764940261e-14,  2.605435117750911e-16,
 -1.098366167007666e-18,  4.456087320494778e-21, -1.734680442877953e-23,  6.433234912406189e-26, -2.240891836868218e-28,  3.092856891070726e-02, -2.417278938202756e-04,
  1.394908829560446e-06, -7.002010195992123e-09,  3.201406624594939e-11, -1.352119231000310e-13,  5.265049770274786e-16, -1.856726826110137e-18,  5.643909264248429e-21,
 -1.256210472473821e-23,  1.284942080521710e-27,  2.092084820143100e-28,  6.032785376590100e-02, -4.645711978407193e-04,  2.600535356656496e-06, -1.237386456346795e-08,
  5.177909372693056e-11, -1.887513683321241e-13,  5.634150472752689e-16, -1.057011787303953e-18, -1.742355869370351e-21,  3.191988961851746e-23, -2.122651504686737e-25,
  1.040483407847455e-27,  9.908422725099165e-02, -7.480078813938197e-04,  4.016553211470123e-06, -1.770333120351734e-08,  6.442836110332440e-11, -1.760152357396039e-13,
  1.862960587390748e-16,  1.705790571043511e-18, -1.570618571880069e-20,  8.304850372836483e-23, -3.105562989125603e-25,  6.652787145749730e-28,  1.468230005356811e-01,
 -1.080969227017318e-03,  5.500528858839289e-06, -2.181136515000151e-08,  6.319096260882662e-11, -7.399550149384375e-14, -5.748071486336784e-16,  5.238715113299619e-18,
 -2.521992568391897e-20,  7.247042555116577e-23,  6.324551193046920e-27, -1.594445724294961e-27,  2.030817290301348e-01, -1.450422138517276e-03,  6.899405947255096e-06,
 -2.364304048617236e-08,  4.435133348730375e-11,  1.066939249663155e-13, -1.445561420635497e-15,  7.203446505231170e-18, -1.786468431961286e-20, -3.320404273412375e-23,
  6.139618879600279e-25, -3.443063110196183e-27,  2.673141322285212e-01, -1.841863554312952e-03,  8.063027996072698e-06, -2.244771772267861e-08,  8.518346209139097e-12,
  3.210656497729506e-13, -2.006024330606801e-15,  5.497540029811480e-18,  8.969665622523657e-21, -1.763298807755697e-22,  8.981301405389896e-25, -1.548755234262805e-27,
  3.388947710744089e-01, -2.239874351555339e-03,  8.857551606263316e-06, -1.791553311801552e-08, -3.913903739918706e-11,  5.018676516926580e-13, -1.880247485802711e-15,
 -2.317594489785973e-19,  4.238023199091719e-20, -2.322196657861208e-22,  3.176436909969392e-25,  3.824128921306444e-27,  4.171244659348939e-01, -2.628713027148183e-03,
  9.177596813111459e-06, -1.024809250808218e-08, -8.978861717776067e-11,  5.810597240370758e-13, -9.319765112964247e-16, -7.919719628718861e-18,  5.973644644838934e-20,
 -1.104434155523124e-22, -9.014440209802305e-25,  7.380554670306330e-27,  5.012364334537831e-01, -2.992927624803307e-03,  8.956069001941521e-06, -1.509047465167716e-10,
 -1.327915021464279e-10,  5.136647674271234e-13,  6.284632033454679e-16, -1.382010824294475e-17,  4.361411749432481e-20,  1.478359686670087e-22, -1.736939395516780e-24,
  3.828600702611310e-27,  5.904031149035824e-01, -3.317963222484268e-03,  8.170765353014963e-06,  1.125314550759490e-08, -1.581070694087012e-10,  2.957814274338557e-13,
  2.286514906911128e-15, -1.439169645124246e-17, -4.074644402864758e-21,  3.707857715599440e-22, -1.228544624701369e-24, -5.313574636884111e-27,  6.837436621232811e-01,
 -3.590741877643494e-03,  6.847136577141739e-06,  2.257781739413632e-08, -1.586877603669658e-10, -2.988251134203858e-14,  3.409976506691372e-15, -8.348058765907227e-18,
 -5.958838295188330e-20,  3.746452341048389e-22,  5.070886769671316e-25, -1.149777668813239e-26,  7.803320397006900e-01, -3.800192309907351e-03,  5.056893365948152e-06,
  3.237281720399383e-08, -1.322873279655569e-10, -3.836516145621219e-13,  3.507306548140127e-15,  2.319546612224593e-18, -9.006802002385270e-20,  1.151982765995410e-22,
  2.155577862249355e-24, -7.423924881698305e-27,  8.792056937631197e-01, -3.937707824319627e-03,  2.912502176386818e-06,  3.933855591300841e-08, -8.222673038085049e-11,
 -6.713331671323813e-13,  2.446892514010700e-15,  1.304365644788000e-17, -7.426525620111305e-20, -2.549746224760859e-22,  2.264028680177882e-24,  4.461524351238736e-27,
  9.793747286561789e-01, -3.997513059987030e-03,  5.579779205893730e-07,  4.252331922269062e-08, -1.689691227066605e-11, -8.126293265033650e-13,  5.370396989541640e-16,
  1.885837397633975e-17, -1.755720771170648e-20, -4.840133398866990e-22,  5.841297350054699e-25,  1.321250877981046e-26,  1.079831523050486e+00, -3.976923075456616e-03,
 -1.843279340809261e-06,  4.147167311011311e-08,  5.192541314503432e-11, -7.663382057837442e-13, -1.576467621724401e-15,  1.693835552891226e-17,  4.961283729182061e-20,
 -4.070357203021840e-22, -1.592675035154803e-24,  1.019485001505580e-26,  1.179560706813316e+00, -3.876482004043566e-03, -4.122571599858373e-06,  3.629977539937431e-08,
  1.115842110288217e-10, -5.438996129484279e-13, -3.158713943886891e-15,  8.113311525885724e-18,  8.983963430003539e-20, -7.485371190057519e-23, -2.513593777627418e-24,
 -1.802258274926984e-27,  1.277549409572588e+00, -3.699972940242274e-03, -6.120679657424435e-06,  2.768420602489685e-08,  1.512987800775503e-10, -2.064983666832115e-13,
 -3.676901659070006e-15, -3.509859258524759e-18,  8.187573071517794e-20,  2.814822095876497e-22, -1.500655380056019e-24, -1.128156903765405e-26,  1.372797681602340e+00,
 -3.454295720413810e-03, -7.701998168794879e-06,  1.676437493007307e-08,  1.645175099674750e-10,  1.536348192786231e-13, -3.009471509401360e-15, -1.264677672193068e-17,
  3.340838722430570e-20,  4.250054055512887e-22,  4.892070708552660e-25, -9.851873292054375e-27,  1.464328977847953e+00, -3.149214662703399e-03, -8.766720311364612e-06,
  4.972437707626620e-09,  1.503044328849983e-10,  4.417212859528145e-13, -1.482320748370254e-15, -1.551771832764171e-17, -2.497173999564914e-20,  2.866013452667333e-22,
  1.789221232676310e-24, -3.323548568490259e-28,  1.551200587011577e+00, -2.796983918579960e-03, -9.259909291195272e-06, -6.183310660402141e-09,  1.134179230930885e-10,
  5.893141778087272e-13,  2.823108373327133e-16, -1.164423030712131e-17, -6.015053971104342e-20,  8.829416237366625e-25,  1.516410419389058e-24,  7.270007267754225e-27,
  1.632513880096901e+00, -2.411863614409872e-03, -9.176555099116624e-06, -1.534744947102165e-08,  6.305742593933216e-11,  5.739434801242106e-13,  1.634846717667829e-15,
 -3.808909609866512e-18, -5.702940462563328e-20, -2.161063900803692e-22,  2.183807167824380e-25,  6.641514133953221e-27,  1.707424247158776e+00, -2.009545156103621e-03,
 -8.562071525767517e-06, -2.152200195282823e-08,  1.058399357454374e-11,  4.230784451031389e-13,  2.163586851261436e-15,  3.709186622099303e-18, -2.550880947893840e-20,
 -2.374038449515530e-22, -8.372623807919707e-25,  6.371429037135846e-28,  1.775150587740367e+00, -1.606508653877895e-03, -7.508109702255179e-06, -2.421304204427607e-08,
 -3.322041446561557e-11,  2.014361873777791e-13,  1.838819682455566e-15,  7.532752406505225e-18,  9.610132915266406e-21, -1.028881570888636e-22, -8.996543204371309e-25,
 -3.616293304534270e-27,  1.834984220241568e+00, -1.219339125104100e-03, -6.144011166654373e-06, -2.349486924728830e-08, -6.067030147184568e-11, -1.348320009484939e-14,
  9.777511600148211e-16,  6.819303866770755e-18,  2.712286548142417e-20,  4.610172791542216e-23, -2.632883800260651e-25, -2.916996558782849e-27,  1.886297079390352e+00,
 -8.640307007701433e-04, -4.624651634899475e-06, -1.998068808604306e-08, -6.884072993078469e-11, -1.586502115243315e-13,  5.785589166854012e-17,  3.266656663636750e-18,
  2.246565863355154e-20,  9.986142061740334e-23,  2.804473022264747e-25, -3.775953219229396e-30,  1.928549082829576e+00, -5.553092693696117e-04, -3.115791792002737e-06,
 -1.470430899121537e-08, -5.996673755656049e-11, -2.057304966639247e-13, -5.232073229312637e-16, -3.400272653026157e-19,  6.834840113920658e-21,  5.826236150934880e-23,
  3.163715312770556e-25,  1.305412697032377e-27,  1.961294587403950e+00, -3.060035487132084e-04, -1.778312832831663e-06, -8.932491599094320e-09, -4.049483468446428e-11,
 -1.672363705355854e-13, -6.219652602946970e-16, -1.997478650620297e-18, -4.829538464876466e-21, -2.631096286134773e-24,  6.613850970346055e-26,  5.726481034312315e-28,
  1.984188085041378e+00, -1.264911192000693e-04, -7.528338651538594e-07, -3.939486070152353e-09, -1.905585195443497e-11, -8.692686255858679e-14, -3.769595696794998e-16,
 -1.556020142527471e-18, -6.087744098022747e-21, -2.231674691145228e-23, -7.476008453173623e-26, -2.154166666226555e-28,  1.996992387602729e+00, -2.421788463379716e-05,
 -1.460375284888414e-07, -7.812164442427411e-10, -3.908029172322151e-12, -1.871088160305090e-14, -8.678308899716710e-17, -3.926492242473845e-19, -1.740371544282938e-21,
 -7.576790110142857e-24, -3.245032517088768e-26, -1.368348797403826e-28,  1.204599429026473e-03, -9.405544508623385e-06,  5.504616249878539e-08, -2.861441867692195e-10,
  1.393106471815832e-12, -6.503479979411065e-15,  2.947593824254371e-17, -1.306605201148953e-19,  5.691035950097332e-22, -2.443205087053151e-24,  1.036028194408112e-26,
 -4.345847188488269e-29,  1.082560146599212e-02, -8.413864995399477e-05,  4.878633136344865e-07, -2.496612834658002e-09,  1.186871983182537e-11, -5.355544092165635e-14,
  2.316951373586461e-16, -9.652851848050385e-19,  3.875634408370201e-21, -1.496100013698383e-23,  5.518985240519736e-26, -1.922297823675329e-28,  2.998345575187458e-02,
 -2.308962129950374e-04,  1.313870994230966e-06, -6.510749795476727e-09,  2.943208162480816e-11, -1.231796725795371e-13,  4.769772794867105e-16, -1.683330923282505e-18,
  5.194614113496264e-21, -1.234858930590853e-23,  8.885186657474671e-27,  1.396945917744939e-28,  5.851025663740340e-02, -4.443470587522211e-04,  2.456897551115417e-06,
 -1.157487475261163e-08,  4.813686040703243e-11, -1.755898581649765e-13,  5.331997114354011e-16, -1.095933782098413e-18, -7.355409087877969e-22,  2.429000927181397e-23,
 -1.705378426031433e-25,  8.607324651315774e-28,  9.615513951346621e-02, -7.167079569738726e-04,  3.810183018539642e-06, -1.670038168162880e-08,  6.095635407369122e-11,
 -1.710251000200000e-13,  2.274545254703919e-16,  1.248689291235591e-18, -1.293284353198177e-20,  7.122653102018366e-23, -2.802693416307471e-25,  7.030705242341742e-28,
  1.425854985368043e-01, -1.037994870833856e-03,  5.244807676820513e-06, -2.081285031429695e-08,  6.158451918473820e-11, -8.611945085600822e-14, -4.390298427066201e-16,
  4.473341415124141e-18, -2.262193053252490e-20,  7.147389029915210e-23, -5.255987319700913e-26, -1.101093287979493e-27,  1.973886513298539e-01, -1.396349543056194e-03,
  6.620011685925523e-06, -2.291816573240592e-08,  4.615427671413796e-11,  7.435526797161560e-14, -1.252015880837715e-15,  6.617102754745158e-18, -1.865323607522164e-20,
 -1.153773079680382e-23,  4.727941546393961e-25, -2.971293318216509e-27,  2.600739843260312e-01, -1.778434032518189e-03,  7.794676718766370e-06, -2.226261668769424e-08,
  1.447082541280103e-11,  2.747950525831192e-13, -1.848980480653310e-15,  5.689794568908537e-18,  3.250670115773640e-21, -1.419122067292210e-22,  8.196369281118232e-25,
 -1.977640737080836e-27,  3.300756188696567e-01, -2.169883783203794e-03,  8.639131152136060e-06, -1.846391028211807e-08, -2.955270982557703e-11,  4.568094585824213e-13,
 -1.868987912505224e-15,  9.934059135577839e-19,  3.428581372394685e-20, -2.165591789341227e-22,  4.556049846253338e-25,  2.482376787782744e-27,  4.067556431955112e-01,
 -2.555807708631181e-03,  9.046379361754569e-06, -1.159302768333636e-08, -7.840795907505918e-11,  5.562433618486520e-13, -1.127610454633436e-15, -6.078106125526962e-18,
  5.518764368010206e-20, -1.402363554221149e-22, -5.943179894054966e-25,  6.543040197954994e-27,  4.894079586332120e-01, -2.921321650050869e-03,  8.941851481622071e-06,
 -2.192691573785698e-09, -1.223978854244585e-10,  5.242664833769151e-13,  2.617458051578844e-16, -1.235235997713081e-17,  4.772961366850637e-20,  8.209288919161597e-23,
 -1.542183622068912e-24,  4.932141156809233e-27,  5.772627894015552e-01, -3.252099485520286e-03,  8.290829319766852e-06,  8.773601921394754e-09, -1.516753427272676e-10,
  3.458194255011417e-13,  1.883658607589862e-15, -1.431841000937509e-17,  8.339445050121442e-21,  3.177012149700126e-22, -1.407881951232360e-24, -2.871914277874388e-27,
  6.694919037519709e-01, -3.534924229804107e-03,  7.102830816028420e-06,  2.003839544649452e-08, -1.584870099020316e-10,  4.894908346306739e-14,  3.151585111775955e-15,
 -1.003614819255608e-17, -4.585518488544812e-20,  3.851254872404931e-22,  2.577411667553384e-26, -1.028578754570997e-26,  7.652145895593870e-01, -3.758219803257713e-03,
  5.432429240057950e-06,  3.019942550335819e-08, -1.391150107699017e-10, -2.990181652840502e-13,  3.532641598299140e-15, -4.803095062216701e-19, -8.445297258300807e-20,
  1.943081566920077e-22,  1.786969266365430e-24, -9.200680897040181e-27,  8.635044193373378e-01, -3.912542920995197e-03,  3.376238664446549e-06,  3.791882490980484e-08,
 -9.503797806432085e-11, -6.085014695509518e-13,  2.777590686547911e-15,  1.053810679775597e-17, -8.177581130465181e-20, -1.614628889433843e-22,  2.387402486559125e-24,
  1.149426604459304e-27,  9.633968277251094e-01, -3.991013943020569e-03,  1.066102068131923e-06,  4.212382641901945e-08, -3.297823423442025e-11, -7.934833581235451e-13,
  1.054627703636628e-15,  1.802337877648770e-17, -3.442404675707736e-20, -4.493674729120718e-22,  1.137992990700973e-24,  1.181827219456382e-26,  1.063897508514147e+00,
 -3.989665723538267e-03, -1.341146418057557e-06,  4.217797419695121e-08,  3.625958117095977e-11, -7.983166979527833e-13, -1.082252366165429e-15,  1.828013733663495e-17,
  3.392720516310268e-20, -4.610924725234616e-22, -1.094689293774468e-24,  1.231607587624401e-26,  1.163991618159622e+00, -3.907690689798827e-03, -3.676634301929677e-06,
  3.799406291939154e-08,  9.996819423499279e-11, -6.166610012806442e-13, -2.891837132672593e-15,  1.092556259106020e-17,  8.532493696586019e-20, -1.759978126300960e-22,
 -2.518699597129561e-24,  1.613806820867188e-27,  1.262653748582251e+00, -3.747568727516374e-03, -5.774096400615783e-06,  3.006712411600848e-08,  1.462799642263249e-10,
 -2.956183313126736e-13, -3.737062156749956e-15, -7.402431013791709e-19,  9.081134863842957e-20,  2.118002106201494e-22, -1.975083495874466e-24, -1.013323711968664e-26,
  1.358858604292251e+00, -3.515062059564408e-03, -7.484943625042512e-06,  1.941719426809756e-08,  1.668399350512616e-10,  7.729324151365641e-14, -3.346292341553464e-15,
 -1.133001407410791e-17,  4.895064716443961e-20,  4.352842407191423e-22,  1.013772572119669e-26, -1.185210535260124e-26,  1.451592288162814e+00, -3.219068207260061e-03,
 -8.692336965871690e-06,  7.445901866972875e-09,  1.587474830168209e-10,  4.008513626609613e-13, -1.926355014907364e-15, -1.613799104226207e-17, -1.337604682310068e-20,
  3.571386895783582e-22,  1.718549652311397e-24, -2.952426539499775e-27,  1.539864067592779e+00, -2.871328244563084e-03, -9.322831070965260e-06, -4.274080250750057e-09,
  1.252444297411519e-10,  5.919601354728983e-13, -7.058321507805328e-17, -1.355621247506634e-17, -5.895078546288411e-20,  6.782552386108463e-23,  1.826880581212453e-24,
  6.741052234018900e-27,  1.622718459732959e+00, -2.485994695108458e-03, -9.354285379797410e-06, -1.424460792133121e-08,  7.491892414337127e-11,  6.116866757458880e-13,
  1.501493967906854e-15, -5.756043891410744e-18, -6.457755256079050e-20, -2.010855299084243e-22,  5.434919539137514e-25,  8.126257881743562e-27,  1.699247442653198e+00,
 -2.079071243979888e-03, -8.819031022790461e-06, -2.128211063859888e-08,  1.957272470048876e-11,  4.761504500517958e-13,  2.254685642921349e-15,  2.749773344536813e-18,
 -3.464803333709713e-20, -2.699566064708843e-22, -7.804018961188445e-25,  2.006896649513196e-27,  1.768602570845524e+00, -1.667744471346904e-03, -7.801714454170894e-06,
 -2.470986877420940e-08, -2.873312557019967e-11,  2.481299362789547e-13,  2.053433929421419e-15,  7.773754626435929e-18,  5.219789547921050e-21, -1.420836748404383e-22,
 -1.060424187192313e-24, -3.656499558799243e-27,  1.830006750638842e+00, -1.269635482364621e-03, -6.431778533781578e-06, -2.446640969218737e-08, -6.068932591990595e-11,
  1.237364452826368e-14,  1.181076205079482e-15,  7.711493452661470e-18,  2.856003142430969e-20,  3.278250192778563e-23, -4.083157728950118e-25, -3.691545546492068e-27,
  1.882765416876856e+00, -9.020059520536953e-04, -4.871132978176718e-06, -2.110741575129926e-08, -7.199200575410325e-11, -1.560794385765693e-13,  1.599427502603055e-16,
  4.045237104912679e-18,  2.626169825987073e-20,  1.109804423342345e-22,  2.729059165742992e-25, -3.610061392282311e-28,  1.926276852110830e+00, -5.809580386469709e-04,
 -3.298138306576741e-06, -1.569737870064837e-08, -6.420755214845233e-11, -2.183749785913548e-13, -5.293326822759425e-16, -8.519526510545368e-20,  9.174411486246665e-21,
  7.212056218239039e-23,  3.778973160291010e-25,  1.491818251675308e-27,  1.960041425442497e+00, -3.206700851319136e-04, -1.889503292053141e-06, -9.607997147149672e-09,
 -4.399345459446580e-11, -1.828522212122078e-13, -6.800685951307431e-16, -2.152976575195751e-18, -4.870114446703775e-21,  5.685536689907201e-25,  9.516355397949406e-26,
  7.539799892117244e-28,  1.983669768326030e+00, -1.327082040420176e-04, -8.019960652395735e-07, -4.258794773780787e-09, -2.088850555056477e-11, -9.651949172585202e-14,
 -4.233804452187792e-16, -1.764278449755897e-18, -6.947313554622078e-21, -2.550274224617383e-23, -8.468625863367702e-26, -2.355131888126207e-28,  1.996893118552159e+00,
 -2.542477542976230e-05, -1.558000228672969e-07, -8.468556717646796e-10, -4.303998901340946e-12, -2.093216035346516e-14, -9.859981603165172e-17, -4.529681367872636e-19,
 -2.038027639748734e-21, -9.003699304036348e-24, -3.911642946695495e-26, -1.672420458586390e-28,  1.167836764860889e-03, -8.978540846235813e-06,  5.174199937659438e-08,
 -2.648578112713985e-10,  1.269825060004911e-12, -5.837980018875410e-15,  2.605972875726970e-17, -1.137801028920324e-19,  4.881690213736615e-22, -2.064619004051272e-24,
  8.625821033737855e-27, -3.565402413069221e-29,  1.049666738930039e-02, -8.035243205515811e-05,  4.590089642960412e-07, -2.314989001045848e-09,  1.085109894976471e-11,
 -4.830556198318974e-14,  2.063254118023953e-16, -8.494723893704523e-19,  3.374813754553405e-21, -1.291416341546999e-23,  4.735257739388028e-26, -1.646805363417473e-28,
  2.908040907887986e-02, -2.206899387755280e-04,  1.238488149704640e-06, -6.058938951323833e-09,  2.707924026946747e-11, -1.122794413694244e-13,  4.321049239440278e-16,
 -1.524136438196329e-18,  4.757793522883259e-21, -1.188649361349105e-23,  1.384692680060386e-26,  8.845759519070417e-29,  5.677131721103045e-02, -4.252346415366669e-04,
  2.322506527011400e-06, -1.083209454222315e-08,  4.475053511388201e-11, -1.631631958628356e-13,  5.023065293468550e-16, -1.106725367884680e-18,  2.480827657110332e-23,
  1.817895510017625e-23, -1.361318253428352e-25,  7.073342730240494e-28,  9.334802445186063e-02, -6.870117889934188e-04,  3.615518363073301e-06, -1.575213635599382e-08,
  5.759304127489769e-11, -1.651911035452477e-13,  2.569943148505821e-16,  8.737617389267078e-19, -1.056301038996310e-20,  6.063577389784360e-23, -2.492987932611584e-25,
  6.991450504480963e-28,  1.385158776711116e-01, -9.970188096606301e-04,  5.000907006474974e-06, -1.984180846958726e-08,  5.976649581403738e-11, -9.523256447472915e-14,
 -3.235274965736550e-16,  3.790115451774917e-18, -2.009727547575324e-20,  6.852345643880004e-23, -9.214996603396532e-26, -7.147650085711459e-28,  1.919074494232725e-01,
 -1.344476864839942e-03,  6.349468462857586e-06, -2.216937131318261e-08,  4.735555608622476e-11,  4.646252378197928e-14, -1.075131513083856e-15,  6.016956077569134e-18,
 -1.875841927506665e-20,  4.898696571423673e-24,  3.524509396031405e-25, -2.501608074509220e-27,  2.530832771526730e-01, -1.717140886011059e-03,  7.529088220779321e-06,
 -2.198947302317056e-08,  1.953591713000815e-11,  2.323385477994476e-13, -1.688933858218589e-15,  5.718227198579049e-18, -1.289711244843808e-21, -1.109421373836258e-22,
  7.273640819251797e-25, -2.184821606338986e-27,  3.215328961254217e-01, -2.101664361445313e-03,  8.415020799256248e-06, -1.886608968945012e-08, -2.086221406978132e-11,
  4.124044375972976e-13, -1.826958310387098e-15,  1.969523778219488e-18,  2.684086630156220e-20, -1.964960126973150e-22,  5.394165360572753e-25,  1.365248878115755e-27,
  3.966762443543589e-01, -2.484013630366925e-03,  8.900098073481295e-06, -1.276008082920008e-08, -6.756649249380263e-11,  5.273332105718189e-13, -1.273861853775344e-15,
 -4.396919645507070e-18,  4.977801745347449e-20, -1.585374520324842e-22, -3.280247365396066e-25,  5.544106829820262e-27,  4.778655290640936e-01, -2.849924581086806e-03,
  8.904135793462505e-06, -4.066948245198525e-09, -1.118768498728037e-10,  5.265728958715416e-13, -6.237547874243723e-17, -1.078919496638085e-17,  4.962882882226238e-20,
  2.495216380732037e-23, -1.310632932969217e-24,  5.512841790463046e-27,  5.643876539913073e-01, -3.185392432833347e-03,  8.381787536459687e-06,  6.404448199412691e-09,
 -1.443391510450931e-10,  3.862565758036637e-13,  1.488119873875064e-15, -1.387962779560566e-17,  1.873863277943369e-20,  2.595211476603080e-22, -1.485305238854706e-24,
 -7.019233323644590e-28,  6.554673143159886e-01, -3.477182748144200e-03,  7.328122159242651e-06,  1.751444644507908e-08, -1.567752124122172e-10,  1.210619645153903e-13,
  2.852110564257274e-15, -1.128234063036581e-17, -3.207696915260281e-20,  3.775731600993846e-22, -3.911052381262306e-25, -8.602273783367271e-27,  7.502708703887853e-01,
 -3.713349060819803e-03,  5.781284849423661e-06,  2.793033900997888e-08, -1.442501785314536e-10, -2.146945962020441e-13,  3.482503256041145e-15, -3.057901365377626e-18,
 -7.627207264992746e-20,  2.573450624618507e-22,  1.357778363388673e-24, -1.017561379802707e-26,  8.479111116188845e-01, -3.883739659328227e-03,  3.821751300216645e-06,
  3.630457394437092e-08, -1.065190338775449e-10, -5.385989010916993e-13,  3.035279970407940e-15,  7.846750699684026e-18, -8.586603682774777e-20, -6.590513721869720e-23,
  2.367444558400264e-24, -2.010180925250090e-27,  9.474530167554246e-01, -3.980473349204904e-03,  1.567903293426575e-06,  4.147076172341830e-08, -4.855461924922529e-11,
 -7.622555244273575e-13,  1.541496717955543e-15,  1.667274159049593e-17, -4.966190400639441e-20, -3.940405993544472e-22,  1.612381685038802e-24,  9.629095889655012e-27,
  1.047920605116710e+00, -3.998361711253153e-03, -8.320607879744336e-07,  4.262916160182406e-08,  2.007553392684940e-11, -8.180415609766951e-13, -5.577585398015246e-16,
  1.909285533482617e-17,  1.667444295809805e-20, -4.935995925581981e-22, -5.213567282572287e-25,  1.359236392735811e-26,  1.148304953922170e+00, -3.935253819131018e-03,
 -3.211527514250345e-06,  3.949122679181514e-08,  8.696727966540350e-11, -6.820921134449201e-13, -2.548785826933049e-15,  1.353534271921341e-17,  7.720215373024415e-20,
 -2.742831918298146e-22, -2.369767089361235e-24,  5.151589124234842e-27,  1.247573428770400e+00, -3.792278969624412e-03, -5.399458932954798e-06,  3.235543042698340e-08,
  1.394707487371580e-10, -3.852216917680256e-13, -3.716072825467642e-15,  2.271628279704537e-18,  9.691144251616378e-20,  1.244193924732367e-22, -2.378996004199071e-24,
 -8.080167402677614e-27,  1.344680136847840e+00, -3.573964114163531e-03, -7.235884067905782e-06,  2.209453209040062e-08,  1.675579694075406e-10, -6.633197582758026e-15,
 -3.639252582079036e-15, -9.513840623097229e-18,  6.449810913812955e-20,  4.247868257866065e-22, -5.455338194274428e-25, -1.329345158813976e-26,  1.438577565571710e+00,
 -3.288205728173784e-03, -8.587490381657523e-06,  1.004733149920345e-08,  1.662653862479772e-10,  3.491604564946667e-13, -2.382185530869311e-15, -1.634735047011532e-17,
  6.792208673976383e-22,  4.224243494885246e-22,  1.523949650806011e-24, -5.940318465530186e-27,  1.528229313765888e+00, -2.946081083972709e-03, -9.361706534956303e-06,
 -2.175680650017499e-09,  1.370348567725751e-10,  5.855008593202834e-13, -4.760962151401528e-16, -1.538890345075184e-17, -5.512487875827198e-20,  1.465320025881406e-22,
  2.099714283611987e-24,  5.541083962438740e-27,  1.612623759806605e+00, -2.561491399184700e-03, -9.517618562642394e-06, -1.294613640152826e-08,  8.749872689676680e-11,
  6.455484666766663e-13,  1.310339807923889e-15, -7.933430767843158e-18, -7.133536850698608e-20, -1.717824834279568e-22,  9.315027602746091e-25,  9.474818164997510e-27,
  1.690788444234847e+00, -2.150638966720961e-03, -9.072213519947443e-06, -2.088979905460353e-08,  2.964240836416243e-11,  5.310523516014127e-13,  2.314654158800677e-15,
  1.479717763993045e-18, -4.490271715050953e-20, -2.989222982203021e-22, -6.552347438587308e-25,  3.743330155173553e-27,  1.761804877064939e+00, -1.731351681168814e-03,
 -8.100818617162930e-06, -2.512714603342403e-08, -2.325999542554358e-11,  3.000381801852972e-13,  2.272608389269259e-15,  7.850448639713172e-18, -6.971567080831772e-22,
 -1.876763997122266e-22, -1.217644544661734e-24, -3.439684562182741e-27,  1.824823417538860e+00, -1.322280576610664e-03, -6.731188264812637e-06, -2.543384371619610e-08,
 -6.014036715223040e-11,  4.341477796425917e-14,  1.409945948461218e-15,  8.640812504307682e-18,  2.940481538867407e-20,  1.295263915648058e-23, -5.894758914279117e-25,
 -4.555846338359082e-27,  1.879077822821628e+00, -9.420079893481486e-04, -5.131435427133829e-06, -2.228401172104241e-08, -7.506552695222233e-11, -1.507828845396190e-13,
  2.855900579408942e-16,  4.951603948206061e-18,  3.044842783568871e-20,  1.214415360700592e-22,  2.464484919333302e-25, -8.696822046563726e-28,  1.923899031643581e+00,
 -6.081144201473669e-04, -3.492817140088040e-06, -1.676032996385134e-08, -6.870210276495350e-11, -2.310719073421974e-13, -5.271961375931944e-16,  2.529763941623451e-19,
  1.205915683728122e-20,  8.860405164060642e-23,  4.476192910610313e-25,  1.675836168581165e-27,  1.958727765574208e+00, -3.362595453510124e-04, -2.009146241300603e-06,
 -1.034205639815702e-08, -4.781868926382340e-11, -1.999148311047102e-13, -7.425250414887570e-16, -2.307689441192555e-18, -4.772557746075574e-21,  5.102588238709410e-24,
  1.332184467953553e-25,  9.848673253050170e-28,  1.983125771685182e+00, -1.393344267683529e-04, -8.551724372859334e-07, -4.609023328359466e-09, -2.292464159348050e-11,
 -1.072994136613202e-13, -4.760354392752627e-16, -2.001956438688271e-18, -7.928933469388726e-21, -2.910285549322871e-23, -9.544694389076124e-26, -2.529810078925425e-28,
  1.996788860593280e+00, -2.671302804682917e-05, -1.663897186448268e-07, -9.192018227898556e-10, -4.747372794079723e-12, -2.345843340334973e-14, -1.122469276237851e-16,
 -5.236881426972616e-19, -2.392192784300184e-21, -1.072604181149466e-23, -4.727516356044226e-26, -2.049561535699296e-28,  1.132730820457528e-03, -8.576981291951073e-06,
  4.868186297150960e-08, -2.454417575130369e-10,  1.159070581157458e-12, -5.249077794547184e-15,  2.308186945991951e-17, -9.928427290925951e-20,  4.196932460249482e-22,
 -1.749004987479057e-24,  7.200872095684109e-27, -2.933458420809212e-29,  1.018242993751605e-02, -7.678860002966747e-05,  4.322397700505935e-07, -2.148839132231040e-09,
  9.932640497654157e-12, -4.362738834605817e-14,  1.839847363691640e-16, -7.485650798086777e-19,  2.942317887543092e-21, -1.115773490220460e-23,  4.064159049692915e-26,
 -1.409556000999801e-28,  2.821701483275805e-02, -2.110656641689563e-04,  1.168308171222817e-06, -5.643086558091235e-09,  2.493398713266568e-11, -1.024042202521780e-13,
  3.914970680952122e-16, -1.378619882785035e-18,  4.340677813392174e-21, -1.126664744072321e-23,  1.687375740862424e-26,  5.111006698405875e-29,  5.510673237265407e-02,
 -4.071626015178441e-04,  2.196711849141089e-06, -1.014154761104940e-08,  4.160531760810556e-11, -1.514790405815714e-13,  4.714205656558668e-16, -1.096452898502760e-18,
  5.883713262406320e-22,  1.331637538841038e-23, -1.079401064274240e-25,  5.778237135920441e-28,  9.065665021480773e-02, -6.588283282013207e-04,  3.431913739308481e-06,
 -1.485673549538454e-08,  5.435269044292912e-11, -1.587659022278069e-13,  2.770422007713400e-16,  5.688067760217456e-19, -8.552269865776980e-21,  5.127150655235882e-23,
 -2.191413237855375e-25,  6.681820224673928e-28,  1.346063317233768e-01, -9.579478512490055e-04,  4.768478763869645e-06, -1.890116882335348e-08,  5.779242790459606e-11,
 -1.017941648358325e-13, -2.260423945053454e-16,  3.185704921949585e-18, -1.770350029029444e-20,  6.430150161958885e-23, -1.167967483395480e-25, -4.191777132462155e-28,
  1.866294668536101e-01, -1.294732304454897e-03,  6.088008417975604e-06, -2.140559431941617e-08,  4.804007192678977e-11,  2.261348931256930e-14, -9.150158117201903e-16,
  5.422021931967126e-18, -1.835361444880402e-20,  1.692818581417139e-23,  2.522491929426628e-25, -2.058953443809110e-27,  2.463335157699148e-01, -1.657958022064766e-03,
  7.267236350371997e-06, -2.164187224290161e-08,  2.379027385309530e-11,  1.937173016378013e-13, -1.529962769009287e-15,  5.618479432517257e-18, -4.783317396915868e-21,
 -8.379267370017410e-23,  6.298132250808308e-25, -2.226219848814982e-27,  3.132594379856047e-01, -2.035254830401936e-03,  8.186889475544113e-06, -1.913626234438667e-08,
 -1.304765401620787e-11,  3.693098699437635e-13, -1.760820086585897e-15,  2.719514645530490e-18,  2.016730794912735e-20, -1.739957603190184e-22,  5.791269737601540e-25,
  4.768226984037795e-28,  3.868815967333339e-01, -2.413442917185413e-03,  8.740833272651945e-06, -1.375847119991755e-08, -5.733461976061087e-11,  4.954578057378774e-13,
 -1.375548438370053e-15, -2.897414342938845e-18,  4.389046746256866e-20, -1.670889629118873e-22, -1.072375963782001e-25,  4.489991708960156e-27,  4.666079459176450e-01,
 -2.778916339392486e-03,  8.844939238709527e-06, -5.772906994759412e-09, -1.013839022580793e-10,  5.216306528224904e-13, -3.421735464000385e-16, -9.196338859899952e-18,
  4.964259987736133e-20, -2.255178258366421e-23, -1.063554619551238e-24,  5.653024137661554e-27,  5.517806249615324e-01, -3.118069380210519e-03,  8.445045213641568e-06,
  4.158632534662689e-09, -1.362879644305961e-10,  4.173838786252374e-13,  1.109207798239085e-15, -1.314200033719490e-17,  2.700966992188681e-20,  2.000500300493274e-22,
 -1.475139100012217e-24,  1.097549512964674e-27,  6.416771044465942e-01, -3.417759512662573e-03,  7.523336746252499e-06,  1.502902277794490e-08, -1.536956015431335e-10,
  1.856181952124073e-13,  2.523852319430549e-15, -1.209504782845786e-17, -1.885205826710408e-20,  3.549209723513011e-22, -7.272559574687885e-25, -6.649019407534116e-27,
  7.355120416235106e-01, -3.665797658796803e-03,  6.102473820824053e-06,  2.559249224228763e-08, -1.477165927465094e-10, -1.324088594837260e-13,  3.364174500899443e-15,
 -5.340778423731649e-18, -6.613907308287297e-20,  3.025892415540194e-22,  9.029966773525077e-25, -1.037396277863855e-26,  8.324400182001513e-01, -3.851452795161713e-03,
  4.246837896658696e-06,  3.451812067650210e-08, -1.165463598801320e-10, -4.634277092310372e-13,  3.216293374978995e-15,  5.079128309091454e-18, -8.656317719411932e-20,
  2.617367488362172e-23,  2.216319960668847e-24, -4.777451640797592e-27,  9.315593414340523e-01, -3.965953877945711e-03,  2.060395038852363e-06,  4.057409237360259e-08,
 -6.339293876597588e-11, -7.198497821289449e-13,  1.984045721376240e-15,  1.486982345034852e-17, -6.259140475288308e-20, -3.218543462303273e-22,  1.976686158106645e-24,
  6.853605741620268e-27,  1.031917091180173e+00, -4.002967784497260e-03, -3.191253621044935e-07,  4.281893881506164e-08,  3.624384761002931e-12, -8.249688055658867e-13,
 -1.838166427955106e-17,  1.933928024945146e-17, -1.324769827049987e-21, -5.023291549004481e-22,  8.713379652641460e-26,  1.390156335446929e-26,  1.132515587540780e+00,
 -3.959027862972563e-03, -2.729744516862865e-06,  4.077037866734635e-08,  7.274582864902635e-11, -7.384457008741091e-13, -2.136821650557745e-15,  1.583003423528097e-17,
  6.568560346764783e-20, -3.635286840472145e-22, -2.068019280268076e-24,  8.508926768419176e-27,  1.232320433306974e+00, -3.833884261270302e-03, -4.998074444591296e-06,
  3.452050915412787e-08,  1.308814356758229e-10, -4.732902750084194e-13, -3.608512290855946e-15,  5.425445135927946e-18,  9.959910465829269e-20,  2.294253136778103e-23,
 -2.673805244082078e-24, -5.193825492419903e-27,  1.330270249720140e+00, -3.630745114744964e-03, -6.954684104852752e-06,  2.476956650742154e-08,  1.665315721069643e-10,
 -9.692473394535833e-14, -3.874482755678487e-15, -7.210596034913806e-18,  7.925424720517945e-20,  3.910115850508683e-22, -1.147971726824493e-24, -1.394160507229680e-26,
  1.425288170929364e+00, -3.356377645359829e-03, -8.450740967757720e-06,  1.276018158366418e-08,  1.726398688687277e-10,  2.865122085253031e-13, -2.837240247165246e-15,
 -1.607110067142879e-17,  1.691232214390729e-20,  4.772277861915492e-22,  1.193124473442983e-24, -9.107526018125451e-27,  1.516295090562452e+00, -3.021041010256371e-03,
 -9.374275345750876e-06,  1.097863460078639e-10,  1.485947014915529e-10,  5.687100120773405e-13, -9.307702419972054e-16, -1.705184047981768e-17, -4.828380737792821e-20,
  2.348768616073292e-22,  2.303251823484055e-24,  3.580295545716680e-27,  1.602224563313192e+00, -2.638228970638588e-03, -9.664140942505684e-06, -1.144124057094942e-08,
  1.007048284022418e-10,  6.740676041404678e-13,  1.055371909051387e-15, -1.030708208365775e-17, -7.674529020540068e-20, -1.258499774634633e-22,  1.372700493626637e-24,
  1.051193517150118e-26,  1.682039157798602e+00, -2.224210495633136e-03, -9.319685134571572e-06, -2.032752279882468e-08,  4.082144642645717e-11,  5.869287527722680e-13,
  2.334318044217518e-15, -1.340497602934266e-19, -5.609065406555214e-20, -3.212461081385875e-22, -4.457010152302682e-25,  5.836974225099929e-27,  1.754747939273434e+00,
 -1.797370184152334e-03, -8.404369500512672e-06, -2.544826176245355e-08, -1.669604175820184e-11,  3.572094252139961e-13,  2.491024224134462e-15,  7.710349562619048e-18,
 -8.365467768679678e-21, -2.392697999764044e-22, -1.357859629227737e-24, -2.865930633084479e-27,  1.819424640256714e+00, -1.377367187055701e-03, -7.042133025909949e-06,
 -2.638722047930443e-08, -5.891353648170100e-11,  8.026337969383175e-14,  1.665097361132900e-15,  9.584268438672075e-18,  2.939593508407923e-20, -1.490441878704245e-23,
 -8.101045081628068e-25, -5.478667818660974e-27,  1.875225965188522e+00, -9.841497496793662e-04, -5.406148035061332e-06, -2.350876383186035e-08, -7.800082638776353e-11,
 -1.421507771106747e-13,  4.385461824635702e-16,  5.997720573595455e-18,  3.498683474694772e-20,  1.303435448651781e-22,  1.935621827238931e-25, -1.569199794338666e-27,
  1.921409388253390e+00, -6.368804957587149e-04, -3.700691227301163e-06, -1.789721934518602e-08, -7.344925590422293e-11, -2.435929341650085e-13, -5.142052837024285e-16,
  6.935082671688844e-19,  1.558942419427006e-20,  1.080342716550735e-22,  5.250979774208564e-25,  1.841063973527923e-27,  1.957349776285592e+00, -3.528424509435469e-04,
 -2.137976653231652e-06, -1.114013232914415e-08, -5.200051406389970e-11, -2.185278646336927e-13, -8.092429899361909e-16, -2.456354226608945e-18, -4.481773673289507e-21,
  1.137911809150986e-23,  1.827344259698379e-25,  1.277037489040480e-27,  1.982554391910051e+00, -1.464034421137555e-04, -9.127543645501454e-07, -4.993625837364535e-09,
 -2.518957119098119e-11, -1.194265875560897e-13, -5.358052671623379e-16, -2.273204429608873e-18, -9.048078509545284e-21, -3.314741921679013e-23, -1.068695953066388e-25,
 -2.650469476020903e-28,  1.996679274515026e+00, -2.808959540205638e-05, -1.778918590106550e-07, -9.990646526718549e-10, -5.244714717796968e-12, -2.633733934158501e-14,
 -1.280426552734033e-16, -6.067998837252864e-19, -2.814659447719592e-21, -1.281047463125530e-23, -5.728782154955556e-26, -2.518605358460864e-28,  1.099183586328386e-03,
 -8.199000112974407e-06,  4.584446324517370e-08, -2.277073005126303e-10,  1.059411100592935e-12, -4.727011084548472e-15,  2.048084896783840e-17, -8.680835324394482e-20,
  3.616172311430006e-22, -1.485196508719689e-24,  6.026905097919408e-27, -2.420227369862993e-29,  9.882031790570062e-03, -7.343118925892499e-05,  4.073791980057741e-07,
 -1.996664289877243e-09,  9.102604772821660e-12, -3.945299334540185e-14,  1.642848553956531e-16, -6.605357638660576e-19,  2.568463761370138e-21, -9.649888783047239e-24,
  3.489901601202767e-26, -1.205870430878547e-28,  2.739102560577633e-02, -2.019834373111424e-04,  1.102918826997450e-06, -5.260029773859355e-09,  2.297681485958658e-11,
 -9.345618102491406e-14,  3.547803115473647e-16, -1.246073643555651e-18,  3.947690361394005e-21, -1.055528669156234e-23,  1.849903569022433e-26,  2.426186883268390e-29,
  5.351247427639649e-02, -3.900646106695714e-04,  2.078909374995578e-06, -9.499494837959873e-09,  3.868640374758326e-11, -1.405308132716874e-13,  4.410498801006031e-16,
 -1.070740375201342e-18,  9.958650619744440e-22,  9.473918605940005e-24, -8.497175946899842e-26,  4.694461297709800e-28,  8.807513896618677e-02, -6.320715966112022e-04,
  3.258747169880112e-06, -1.401212884970125e-08,  5.124499977705387e-11, -1.519550489197317e-13,  2.894031228141075e-16,  3.230315026952140e-19, -6.857308843645990e-21,
  4.308083309429400e-23, -1.907373059148882e-25,  6.209407320056737e-28,  1.308494214758348e-01, -9.206917141973554e-04,  4.547144752269554e-06, -1.799304259927477e-08,
  5.570919772544179e-11, -1.062106954323542e-13, -1.444324413763542e-16,  2.655297109605160e-18, -1.547653977256358e-20,  5.933061493618478e-23, -1.301426011445931e-25,
 -1.985842464342693e-28,  1.815463374285566e-01, -1.247042611866927e-03,  5.835764331104104e-06, -2.063447775941887e-08,  4.828469470095944e-11,  2.409171000699537e-15,
 -7.713171080078458e-16,  4.846234393562227e-18, -1.758330261707969e-20,  2.532763564181432e-23,  1.706441631135727e-25, -1.658029251527824e-27,  2.398163241886402e-01,
 -1.600852188422338e-03,  7.009939285927672e-06, -2.123217502172664e-08,  2.731007093200893e-11,  1.588660896180976e-13, -1.375208198240693e-15,  5.421820028249390e-18,
 -7.369868906719656e-21, -6.054393226840519e-23,  5.331806079446294e-25, -2.150415654904133e-27,  3.052479502508366e-01, -1.970681257585061e-03,  7.956238133175827e-06,
 -1.928820420961054e-08, -6.077532668090311e-12,  3.280312425937413e-13, -1.676548339242856e-15,  3.269145800391619e-18,  1.432352215226011e-20, -1.506240484535829e-22,
  5.845613304065891e-25, -1.959586140187688e-28,  3.773666117147136e-01, -2.344191511321744e-03,  8.570548617941365e-06, -1.459837038177612e-08, -4.776137004530820e-11,
  4.616242415098088e-13, -1.437921150890886e-15, -1.589622506660281e-18,  3.784286541097055e-20, -1.677341200936296e-22,  6.748062348958252e-26,  3.461248651091367e-27,
  4.556333229567262e-01, -2.708460711881855e-03,  8.766274099578100e-06, -7.312119052732364e-09, -9.105334464207360e-11,  5.105069937968950e-13, -5.776089287416125e-16,
 -7.628491482397883e-18,  4.812460995824111e-20, -6.015787258832590e-23, -8.182521595704127e-25,  5.448319631053518e-27,  5.394437327331291e-01, -3.050345831259066e-03,
  8.482144980683994e-06,  2.046129657865819e-09, -1.277033515221203e-10,  4.396930707885856e-13,  7.543342795664311e-16, -1.217372890951526e-17,  3.316504881003286e-20,
  1.424479326106815e-22, -1.394902605179671e-24,  2.479180905913339e-27,  6.281275233687152e-01, -3.356892927857220e-03,  7.689063093357755e-06,  1.260276694573617e-08,
 -1.494052476334991e-10,  2.420701376200609e-13,  2.178622923824225e-15, -1.250003005932603e-17, -6.663583618294643e-21,  3.205784656419742e-22, -9.750303625183847e-25,
 -4.614171880834806e-27,  7.209483786459224e-01, -3.615789780545435e-03,  6.395329606257360e-06,  2.321217320859643e-08, -1.495706733994362e-10, -5.369203936118018e-14,
  3.186684566189850e-15, -7.276854092010622e-18, -5.470489974552042e-20,  3.296779551717902e-22,  4.550075484298509e-25, -9.886210588967265e-27,  8.171047341551010e-01,
 -3.815853599750295e-03,  4.649574736161444e-06,  3.258346727042128e-08, -1.250330959970930e-10, -3.848416221740458e-13,  3.319989712013572e-15,  2.340839209926966e-18,
 -8.408221635116802e-20,  1.099302549550800e-22,  1.955517372202717e-24, -6.971358984805339e-27,  9.157315501104545e-01, -3.947541480757328e-03,  2.540732081670304e-06,
  3.944735394095553e-08, -7.728125178453041e-11, -6.674729016174758e-13,  2.370729903650030e-15,  1.269730676225058e-17, -7.269043096766941e-20, -2.376552204171596e-22,
  2.210614237098756e-24,  3.747332383142444e-27,  1.015903368015184e+00, -4.003465745693673e-03,  1.945057899372719e-07,  4.274509380289866e-08, -1.283563694348358e-11,
 -8.189334136226968e-13,  5.198177760527165e-16,  1.900940867865276e-17, -1.919953309787297e-20, -4.867410394705257e-22,  6.872744359309708e-25,  1.321655000555760e-26,
  1.116638925158080e+00, -3.978890193841667e-03, -2.234012351692887e-06,  4.181352901301038e-08,  5.750115415393835e-11, -7.841856539119926e-13, -1.666230274136160e-15,
  1.770740234424436e-17,  5.120801048920754e-20, -4.378709473125429e-22, -1.628135392640425e-24,  1.138218194400518e-26,  1.216907599901307e+00, -3.872177022326909e-03,
 -4.571591174123054e-06,  3.653423831311699e-08,  1.205637539617559e-10, -5.577114548726332e-13, -3.412004728105443e-15,  8.604801905430855e-18,  9.845389204458532e-20,
 -8.757560543201859e-23, -2.826207258341570e-24, -1.642667173401827e-27,  1.315637940514685e+00, -3.685148532273322e-03, -6.641542786774364e-06,  2.741344805250296e-08,
  1.636483829821830e-10, -1.920358369549840e-13, -4.038827523469329e-15, -4.459299752447955e-18,  9.235636066058367e-20,  3.328468336199644e-22, -1.757816718454649e-24,
 -1.360338711844430e-26,  1.411728485102922e+00, -3.423323715634485e-03, -8.280868662730495e-06,  1.556440998738673e-08,  1.776531106784376e-10,  2.130958911050525e-13,
 -3.277010732733574e-15, -1.524665167141968e-17,  3.484655040297450e-20,  5.160130741581769e-22,  7.235971377541784e-25, -1.219767810619258e-26,  1.504061004648787e+00,
 -3.095988669783559e-03, -9.358321852104161e-06,  2.576916079090834e-09,  1.597059764647763e-10,  5.404759691072070e-13, -1.428453426687798e-15, -1.844358800924197e-17,
 -3.813869414587652e-20,  3.294038730577018e-22,  2.403024140713013e-24,  8.247431142660963e-28,  1.591516191673404e+00, -2.716062852996451e-03, -9.791319103556687e-06,
 -9.720839460757918e-09,  1.144146427533085e-10,  6.956520546522492e-13,  7.317914772403795e-16, -1.282390635942703e-17, -8.017420067057688e-20, -6.149384743147210e-23,
  1.848901733991863e-24,  1.102943472516015e-26,  1.672991672838710e+00, -2.299731682484213e-03, -9.559299328736332e-06, -1.957743216797053e-08,  5.311885981393040e-11,
  6.426937255480369e-13,  2.303676031685876e-15, -2.116886206229725e-18, -6.790830829498777e-20, -3.332511157581080e-22, -1.370766683033206e-25,  8.234211443146239e-27,
  1.747422048888515e+00, -1.865830633620262e-03, -8.711104982342388e-06, -2.565492387431333e-08, -8.936711859342332e-12,  4.195460948349120e-13,  2.701795263672215e-15,
  7.294121244509736e-18, -1.798484751629525e-20, -2.958373935403749e-22, -1.462943870011746e-24, -1.823878849225824e-27,  1.813800469507702e+00, -1.434986725760139e-03,
 -7.364375110070830e-06, -2.731473048932327e-08, -5.688636200576402e-11,  1.235515949023419e-13,  1.946498193481477e-15,  1.050961141696925e-17,  2.821549984291555e-20,
 -5.240467535498316e-23, -1.071664522541812e-24, -6.404931578084300e-27,  1.871201050923042e+00, -1.028548782909466e-03, -5.695833085856589e-06, -2.477888988375440e-08,
 -8.072431560018368e-11, -1.294795366698984e-13,  6.228716779699244e-16,  7.193721421306965e-18,  3.979962568332887e-20,  1.364488309211263e-22,  1.049068739288249e-25,
 -2.502901499776727e-27,  1.918801266323931e+00, -6.673654448838448e-04, -3.922671910765532e-06, -1.911204516894875e-08, -7.844264385341356e-11, -2.556407282854731e-13,
 -4.871884773629800e-16,  1.258812255296265e-18,  1.987662219987282e-20,  1.306983148674521e-22,  6.089928278289702e-25,  1.962497933908816e-27,  1.955903331790403e+00,
 -3.704954737965481e-04, -2.276798001749511e-06, -1.200818393606034e-08, -5.657094264192847e-11, -2.387908057235086e-13, -8.799564354744163e-16, -2.591689993946683e-18,
 -3.926095342717878e-21,  1.991441341315249e-23,  2.467029172856692e-25,  1.644231736225922e-27,  1.981953784638221e+00, -1.539522088113508e-04, -9.751772188010947e-07,
 -5.416488164450440e-09, -2.771202571256807e-11, -1.330835611878514e-13, -6.036939389885152e-16, -2.582683811592304e-18, -1.032115838247519e-20, -3.765705566628948e-23,
 -1.186312935662782e-25, -2.675693306992525e-28,  1.996563991866607e+00, -2.956215308684923e-05, -1.904020671888753e-07, -1.087366995535985e-09, -5.803622432027475e-12,
 -2.962486813141026e-14, -1.463666330887020e-16, -7.047127147197996e-19, -3.319901136188924e-21, -1.533990639929012e-23, -6.960944606977156e-26, -3.103546072740255e-28,
  1.067104189088184e-03, -7.842893213170871e-06,  4.321064358569398e-08, -2.114871411565303e-10,  9.695959554638595e-13, -4.263378498318687e-15,  1.820450175759610e-17,
 -7.604755167489362e-20,  3.122447703880410e-22, -1.264125714159967e-24,  5.057060020874968e-27, -2.002193004432286e-29,  9.594676772268832e-03, -7.026557825957819e-05,
  3.842677147606605e-07, -1.857126990220698e-09,  8.351521847677311e-12, -3.572312088007050e-14,  1.468901628996100e-16, -5.836438941413106e-19,  2.244965270389109e-21,
 -8.354711493721180e-24,  2.998687388385797e-26, -1.031402094987294e-28,  2.660034743502726e-02, -1.934064575362294e-04,  1.041944029645879e-06, -4.906902701789901e-09,
  2.119008472207288e-11, -8.534620540412324e-14,  3.216027180289505e-16, -1.125682870207555e-18,  3.581220368136928e-21, -9.800052092341591e-24,  1.912485362343164e-26,
  5.304826210730247e-30,  5.198477100071125e-02, -3.738789986406021e-04,  1.968538416669981e-06, -8.902432303926383e-09,  3.597923087994741e-11, -1.303014912106469e-13,
  4.115621188412186e-16, -1.034032980114252e-18,  1.280469686681883e-21,  6.460425159561054e-24, -6.635824262857635e-26,  3.794274794408835e-28,  8.559794698933450e-02,
 -6.066604913033405e-04,  3.095422083136613e-06, -1.321614163242663e-08,  4.827596592779628e-11, -1.449242497144779e-13,  2.955988906845072e-16,  1.269921785779085e-19,
 -5.437290271944480e-21,  3.598175202037443e-23, -1.646239349908282e-25,  5.651181720495591e-28,  1.272380626419367e-01, -8.851632318645741e-04,  4.336505681618563e-06,
 -1.711885319033451e-08,  5.355606126199429e-11, -1.088389200758717e-13, -7.670376137372480e-17,  2.193203612112834e-18, -1.343597421772071e-20,  5.400118986246020e-23,
 -1.351649019582081e-25, -3.860065851416714e-29,  1.766499895282699e-01, -1.201333821361801e-03,  5.592784384022758e-06, -1.986249797087537e-08,  4.815842841354430e-11,
 -1.453679987272244e-14, -6.433541936331963e-16,  4.299338595802756e-18, -1.656524233063923e-20,  3.080162246623213e-23,  1.056194285377261e-25, -1.305984623658627e-27,
  2.335234716092927e-01, -1.545784160116749e-03,  6.757874135040906e-06, -2.077153747207657e-08,  3.016949369168003e-11,  1.276543036324090e-13, -1.226998316785051e-15,
  5.155044337085521e-18, -9.188002267164150e-21, -4.106849292847696e-23,  4.417080889466701e-25, -1.997593602382983e-27,  2.974910574330099e-01, -1.907958354848750e-03,
  7.724405745547643e-06, -1.933511396100658e-08,  8.838200727173783e-14,  2.889394596869857e-13, -1.579378466726383e-15,  3.645225503202433e-18,  9.318432361505500e-21,
 -1.275685347060037e-22,  5.647162568478682e-25, -6.767138642203203e-28,  3.681258475404681e-01, -2.276340145827793e-03,  8.391081644477926e-06, -1.529058021555661e-08,
 -3.887690793371758e-11,  4.267113067010555e-13, -1.466379399967006e-15, -4.744640911283572e-19,  3.188710786086706e-20, -1.622751958565210e-22,  1.985608136091185e-25,
  2.513761369573813e-27,  4.449391508257268e-01, -2.638705496580309e-03,  8.670121853699611e-06, -8.688114170238756e-09, -8.099824225210630e-11,  4.942530095107953e-13,
 -7.700147930703797e-16, -6.129009685446915e-18,  4.542650856327178e-20, -8.821184570615235e-23, -5.877531264702429e-25,  4.995757548999353e-27,  5.273781710840549e-01,
 -2.982424518343860e-03,  8.494732087222741e-06,  7.409689737201196e-11, -1.187554213846864e-10,  4.538310044290494e-13,  4.290232961216678e-16, -1.104093332930448e-17,
  3.731803329371776e-20,  8.914606728223155e-23, -1.263200847310987e-24,  3.439374113664052e-27,  6.148238776130898e-01, -3.294815742712512e-03,  7.826122035826051e-06,
  1.025373582997051e-08, -1.440694057349085e-10,  2.901433675991288e-13,  1.827315975188056e-15, -1.253650061743548e-17,  4.131646049106495e-21,  2.781031668910554e-22,
 -1.134464588191453e-24, -2.656836775950974e-27,  7.065892514134395e-01, -3.563553697576733e-03,  6.659494726379725e-06,  2.081453445155974e-08, -1.498971891946886e-10,
  2.015662554086179e-14,  2.960229264469002e-15, -8.834839063439577e-18, -4.261132025862189e-20,  3.394491216535896e-22,  4.112506557248028e-26, -8.848863787914506e-27,
  8.019181405469991e-01, -3.777127561177847e-03,  5.028333242191315e-06,  3.052570920824880e-08, -1.319293757813644e-10, -3.046752073782264e-13,  3.348563323939934e-15,
 -2.720059769710791e-19, -7.879529063521783e-20,  1.815196770725486e-22,  1.612944024449260e-24, -8.482440888757822e-27,  8.999850029120239e-01, -3.925344165508686e-03,
  3.006251129328191e-06,  3.810726573415590e-08, -9.003432688868166e-11, -6.065792257222941e-13,  2.692526254329215e-15,  1.025165592431584e-17, -7.962317123840934e-20,
 -1.468694874880669e-22,  2.305588301732542e-24,  5.820286595299820e-28,  9.998958591887862e-01, -3.999862665647103e-03,  7.056768851003676e-07,  4.240955162326019e-08,
 -2.904686233772408e-11, -8.001560247096502e-13,  1.040889888348102e-15,  1.812108066205280e-17, -3.609085041575306e-20, -4.480301903884123e-22,  1.236536684082911e-24,
  1.160841729465371e-26,  1.100690818505480e+00, -3.994740808177361e-03, -1.727254025217330e-06,  4.260607672568119e-08,  4.145859980946190e-11, -8.180553148099731e-13,
 -1.149935307017095e-15,  1.908229765900996e-17,  3.439945458864371e-20, -4.922934741331976e-22, -1.077527138428565e-24,  1.350210833623452e-26,  1.201348568098267e+00,
 -3.906964191135143e-03, -4.121988456703648e-06,  3.836966356730547e-08,  1.086119841162606e-10, -6.363560410503081e-13, -3.127592929236721e-15,  1.168299135974471e-17,
  9.325927667763489e-20, -2.009235133921650e-22, -2.812316962816163e-24,  2.316124504423568e-27,  1.300793227535865e+00, -3.736920842998129e-03, -6.297015070270046e-06,
  2.999579350781813e-08,  1.588300050252251e-10, -2.901215036419785e-13, -4.120614340108256e-15, -1.326898605826806e-18,  1.029319432204938e-19,  2.509059061482618e-22,
 -2.328712774649103e-24, -1.215910233061577e-26,  1.397903947846939e+00, -3.488774956178551e-03, -8.076914633717292e-06,  1.843653921924645e-08,  1.810946912102389e-10,
  1.294681011272378e-13, -3.685479565555341e-15, -1.382985280861461e-17,  5.380699891902273e-20,  5.333879079154271e-22,  1.254132867689281e-25, -1.490137300846222e-26,
  1.491527575059531e+00, -3.170687304062670e-03, -9.311716890470150e-06,  5.216647237051978e-09,  1.701301731464393e-10,  4.998697530228650e-13, -1.960044900808030e-15,
 -1.945572495882308e-17, -2.455006903830985e-20,  4.252698859632984e-22,  2.364732297179695e-24, -2.680192829038938e-27,  1.580494585708317e+00, -2.794827822372700e-03,
 -9.896523496116274e-06, -7.778073912275416e-09,  1.284727241398982e-10,  7.086147959683558e-13,  3.365785195350707e-16, -1.540967766194422e-17, -8.093975753157006e-20,
  2.216264020688094e-23,  2.332278803585161e-24,  1.080012895614014e-26,  1.663638331144710e+00, -2.377130349235580e-03, -9.788695261633149e-06, -1.862172013410611e-08,
  6.651949928486882e-11,  6.970140153749841e-13,  2.212173520910994e-15, -4.482209394311506e-18, -7.990988772647350e-20, -3.307348097099644e-22,  2.817678701339928e-25,
  1.082296877701073e-26,  1.739817396338423e+00, -1.936752679671373e-03, -9.019533493731842e-06, -2.572719260787221e-08,  1.188046258107977e-13,  4.867647247410192e-13,
  2.896291067025254e-15,  6.536777892562156e-18, -2.970379853647141e-20, -3.555279883338954e-22, -1.509763976217362e-24, -1.990495586628371e-28,  1.807940595108005e+00,
 -1.495228102001407e-03, -7.697522922894262e-06, -2.820250393083705e-08, -5.392381597061481e-11,  1.738987553140980e-13,  2.253061988997148e-15,  1.137348223559754e-17,
  2.548705153718814e-20, -1.011655162736773e-22, -1.372533818804980e-24, -7.248205284339680e-27,  1.866993808015860e+00, -1.075326982505787e-03, -6.001011930760126e-06,
 -2.609031230275724e-08, -8.314733864748447e-11, -1.119650484586350e-13,  8.428690015368404e-16,  8.546478789424975e-18,  4.475776193836068e-20,  1.381074053406327e-22,
 -3.080347757012905e-26, -3.715276397028227e-27,  1.916067558638991e+00, -6.996859273736273e-04, -4.159717691385675e-06, -2.040865194655627e-08, -8.366913813862143e-11,
 -2.668338971158184e-13, -4.422951644346444e-16,  1.975018014743390e-18,  2.504123590612594e-20,  1.568044620442457e-22,  6.966189451800614e-25,  2.003473066130596e-27,
  1.954383986293889e+00, -3.893020084763888e-04, -2.426488406353602e-06, -1.295269792956289e-08, -6.156389655397606e-11, -2.607940306072836e-13, -9.541604343648820e-16,
 -2.703800782113447e-18, -3.012965261317710e-21,  3.135707821932638e-23,  3.287633380287873e-25,  2.102129376538941e-27,  1.981321950399662e+00, -1.620213631910069e-04,
 -1.042925885229303e-06, -5.881986437509071e-09, -3.052463932697357e-11, -1.484786047286008e-13, -6.808434269264271e-16, -2.935590082933568e-18, -1.176504409244647e-20,
 -4.263530222136358e-23, -1.301865921870890e-25, -2.544639646881144e-28,  1.996442611891730e+00, -3.113918812947320e-05, -2.040278084199692e-07, -1.185162727012344e-09,
 -6.432910354831974e-12, -3.338698572286708e-14, -1.676729162401333e-16, -8.203506282948844e-19, -3.925730791244796e-21, -1.841774248238510e-23, -8.481466835121613e-26,
 -3.835026485246733e-28,  1.036408277481173e-03, -7.507102046781364e-06,  4.076314023914957e-08, -1.966327119429879e-10,  8.885306518128286e-13, -3.850934051972255e-15,
  1.620848319618224e-17, -6.674647395250352e-20,  2.701747138657967e-22, -1.078407486537922e-24,  4.253704199484274e-27, -1.660730109834657e-29,  9.319624737945358e-03,
 -6.727836010477551e-05,  3.627609653418843e-07, -1.729032208947220e-09,  7.671030168862887e-12, -3.238601337366033e-14,  1.315102630337693e-16, -5.163944208868760e-19,
  1.964734355564766e-21, -7.241437796573813e-24,  2.578543158325203e-26, -8.822104041794260e-29,  2.584302775407846e-02, -1.853007999795902e-04,  9.850404465826120e-07,
 -4.581107856801078e-09,  1.955785777932434e-11, -7.799334062684201e-14,  2.916360004959098e-16, -1.016580807743552e-18,  3.242205574468220e-21, -9.034605205950935e-24,
  1.905251491786258e-26, -7.759399296278012e-30,  5.052008859519395e-02, -3.585484163270689e-04,  1.865078947950452e-06, -8.347085929551134e-09,  3.346965555462880e-11,
 -1.207666078945414e-13,  3.832143395435503e-16, -9.898177686306930e-19,  1.469079873874315e-21,  4.117068752004460e-24, -5.135039745032161e-26,  3.051347361111728e-28,
  8.321984560139029e-02, -5.825185761498001e-04,  2.941368477365832e-06, -1.246652772645402e-08,  4.544861599083599e-11, -1.378057155629575e-13,  2.969047146116003e-16,
 -2.749891369535233e-20, -4.254641114508934e-21,  2.987681007680757e-23, -1.410536583047547e-25,  5.060675218174118e-28,  1.237655131192598e-01, -8.512784901009028e-04,
  4.136148722526658e-06, -1.627945043121406e-08,  5.136560453863381e-11, -1.099897194697046e-13, -2.102856997064263e-17,  1.793312547011866e-18, -1.158932546987745e-20,
  4.859668118775673e-23, -1.342460906760786e-25,  7.339256601131295e-29,  1.719326477002028e-01, -1.157531874447251e-03,  5.359045414953244e-06, -1.909508807268543e-08,
  4.772273318364409e-11, -2.859157161013056e-14, -5.302220532362212e-16,  3.787701157587403e-18, -1.539333920725900e-20,  3.396948191491379e-23,  5.496791311572396e-26,
 -1.004669561866921e-27,  2.274468941462429e-01, -1.492709810852223e-03,  6.511591158388166e-06, -2.026995242827775e-08,  3.243961473687194e-11,  9.990396672677947e-14,
 -1.086972231051858e-15,  4.840614174963570e-18, -1.036911607676759e-20, -2.510212972464684e-23,  3.580551732372108e-25, -1.799563207662203e-27,  2.899813456332136e-01,
 -1.847090744332541e-03,  7.492576987600423e-06, -1.928949378892037e-08,  5.496544438890964e-12,  2.522887785693943e-13, -1.473797183209098e-15,  3.874230775050475e-18,
  5.124415580442711e-21, -1.056796945279541e-22,  5.274156204083042e-25, -9.943820068132919e-28,  3.591535680901022e-01, -2.209955378877492e-03,  8.204137926707759e-06,
 -1.584625160316256e-08, -3.069511572407405e-11,  3.914687469030043e-13, -1.466245097522693e-15,  4.541867036790768e-19,  2.621249142356408e-20, -1.523746975372295e-22,
  2.904021512999781e-25,  1.681711055089816e-27,  4.345223603709891e-01, -2.569782838289581e-03,  8.558411454445622e-06, -9.906065096033951e-09, -7.131105028427921e-11,
  4.738744834362903e-13, -9.217832997803783e-16, -4.730288990887248e-18,  4.187913387666855e-20, -1.074967731938083e-22, -3.809495591670819e-25,  4.385138654121274e-27,
  5.155843496667890e-01, -2.914494713523665e-03,  8.484521788919230e-06, -1.752920085006681e-09, -1.096001678044047e-10,  4.605553762051408e-13,  1.370103486274408e-16,
 -9.804851881718699e-18,  3.965607520626525e-20,  4.183890447084788e-23, -1.098022387688657e-24,  4.007944542448201e-27,  6.017705571563120e-01, -3.231753318076516e-03,
  7.935535090840305e-06,  7.997312133718873e-09, -1.378563000210028e-10,  3.298105594691871e-13,  1.479586423848146e-15, -1.225305487980905e-17,  1.330327682127836e-20,
  2.309218974836216e-22, -1.211780219898298e-24, -8.981083198110750e-28,  6.924431129543159e-01, -3.509319358858674e-03,  6.894904580847447e-06,  1.842317788827234e-08,
 -1.488043874986422e-10,  8.809082378433191e-14,  2.695598964336422e-15, -1.000329939714720e-17, -3.045180188625250e-20,  3.337042461098956e-22, -3.179664118323491e-25,
 -7.423283886550748e-27,  7.868923523523089e-01, -3.735471980759214e-03,  5.381789572071813e-06,  2.837045005509013e-08, -1.372212869824476e-10, -2.246795405452347e-13,
  3.306713708858570e-15, -2.677196123111717e-18, -7.119190007414902e-20,  2.382876425854179e-22,  1.219682220398079e-24, -9.275482260050775e-27,  8.843345866607881e-01,
 -3.899490395781778e-03,  3.454506307771189e-06,  3.657326724154090e-08, -1.014979607571279e-10, -5.388062054805471e-13,  2.943233505665508e-15,  7.636912854966942e-18,
 -8.325246934077250e-20, -5.502948977215961e-23,  2.264776639354808e-24, -2.384966398750720e-27,  9.839109097369155e-01, -3.992190699407392e-03,  1.211279764841674e-06,
  4.181830415976038e-08, -4.475980703507700e-11, -7.692310267379441e-13,  1.529760367021957e-15,  1.671861528269826e-17, -5.121236058596714e-20, -3.890029352442219e-22,
  1.697526666863515e-24,  9.236882712269809e-27,  1.084687471539755e+00, -4.006503724233192e-03, -1.212545351469143e-06,  4.313720964558173e-08,  2.486536006852947e-11,
 -8.391343655215016e-13, -6.029367543248011e-16,  1.989238907859460e-17,  1.604817540092432e-20, -5.230954645986156e-22, -4.540745994610896e-25,  1.466710230719499e-26,
  1.185657716011919e+00, -3.938069805659507e-03, -3.651558631059416e-06,  4.000167716140476e-08,  9.516244967725565e-11, -7.071630141946594e-13, -2.759929696729045e-15,
  1.453011612290804e-17,  8.403661358663216e-20, -3.101823352613471e-22, -2.621141043933150e-24,  6.358384272290889e-27,  1.285747131968354e+00, -3.785814439640243e-03,
 -5.922026771536352e-06,  3.248527503118015e-08,  1.520375746914939e-10, -3.890822056445314e-13, -4.110430131892615e-15,  2.092460176587035e-18,  1.101649613615319e-19,
  1.477335722775455e-22, -2.811185864350309e-24, -9.590735626655528e-27,  1.383821088324771e+00, -3.552455896680273e-03, -7.838221542068526e-06,  2.134983537701300e-08,
  1.827692528885594e-10,  3.658207184779213e-14, -4.045723936095979e-15, -1.180115157945417e-17,  7.293524724541144e-20,  5.246441344358495e-22, -5.770731558857698e-25,
 -1.688303264414373e-26,  1.478696301147903e+00, -3.244883622440825e-03, -9.232463501714984e-06,  8.015966641216327e-09,  1.796126354391203e-10,  4.462175706431119e-13,
 -2.513373591395320e-15, -1.997841609623240e-17, -7.576777192862599e-21,  5.163276871151687e-22,  2.158195096247698e-24, -6.790001896768437e-27,  1.569156389665540e+00,
 -2.874337334112127e-03, -9.977058307551790e-06, -5.608845010098889e-09,  1.426893426990083e-10,  7.112237542747468e-13, -1.308998419775950e-16, -1.796806457168444e-17,
 -7.835051193187824e-20,  1.246823596522899e-22,  2.784993974563353e-24,  9.600762872083874e-27,  1.653971802336479e+00, -2.456314582621888e-03, -1.000530078725132e-05,
 -1.744304923800908e-08,  8.097899590532413e-11,  7.483003034924541e-13,  2.049103222369389e-15, -7.226676064473552e-18, -9.149166674675589e-20, -3.091682487111969e-22,
  8.155060157712050e-25,  1.342005786407668e-26,  1.731924118869573e+00, -2.010143055831221e-03, -9.327914736086409e-06, -2.564357247217910e-08,  1.056342758243475e-11,
  5.583524160384197e-13,  3.064006410521391e-15,  5.369836266045263e-18, -4.358632608799720e-20, -4.154662441478452e-22, -1.470322598266983e-24,  2.112393336202677e-27,
  1.801834358609390e+00, -1.558176388893008e-03, -8.041005066548434e-06, -2.903441330598626e-08, -4.987885033749356e-11,  2.318821345751743e-13,  2.582310962457616e-15,
  1.211956402307637e-17,  2.077808935684276e-20, -1.626524287415868e-22, -1.706454929498466e-24, -7.882988323368374e-27,  1.862594468887755e+00, -1.124610191648629e-03,
 -6.322147930108156e-06, -2.743740069476882e-08, -8.516411177245380e-11, -8.869815435473090e-14,  1.102965652296368e-15,  1.005769441925469e-17,  4.966421292923357e-20,
  1.331793673209267e-22, -2.267506962849265e-25, -5.246958056540838e-27,  1.913200675720604e+00, -7.339664514381676e-04, -4.412831675187048e-06, -2.179060783323286e-08,
 -8.910699676107227e-11, -2.766894134259494e-13, -3.748882231515555e-16,  2.872206561786803e-18,  3.120888843733725e-20,  1.864170904626553e-22,  7.833538127064608e-25,
  1.911903206776283e-27,  1.952786945866932e+00, -4.093527952268123e-04, -2.588007140783514e-06, -1.398071746643937e-08, -6.701495942519784e-11, -2.846121145239421e-13,
 -1.031027771676499e-15, -2.779425718092956e-18, -1.623684949102720e-21,  4.651558852599887e-23,  4.332811682642959e-25,  2.667952487434246e-27,  1.980656719075314e+00,
 -1.706556399212439e-04, -1.116541037859985e-06, -6.395053794049892e-09, -3.366449777827392e-11, -1.658492023288252e-13, -7.685487211910490e-16, -3.337655874079565e-18,
 -1.339627013117824e-20, -4.805778475527322e-23, -1.406654379130961e-25, -2.169062176703593e-28,  1.996314698082927e+00, -3.283010036792762e-05, -2.188900861705173e-07,
 -1.293657929100861e-09, -7.142828176212121e-12, -3.770160586826569e-14, -1.925060047420117e-16, -9.572719064434373e-19, -4.654132304724839e-21, -2.217330685275296e-23,
 -1.036310309552957e-25, -4.752270900420995e-28,  1.007017469099478e-03, -7.190199333890508e-06,  3.848637179168885e-08, -1.830118533983051e-10,  8.152555267035645e-13,
 -3.483415051251040e-15,  1.445500996061864e-17, -5.869058401940386e-20,  2.342465453824283e-22, -9.220100592647349e-25,  3.586524297946866e-27, -1.381040625053030e-29,
  9.056186948672183e-03, -6.445722754434760e-05,  3.427281653299002e-07, -1.611310790275771e-09,  7.053736902081088e-12, -2.939640505265454e-14,  1.178936059974753e-16,
 -4.575022826397693e-19,  1.721708363185161e-21, -6.283757561922493e-24,  2.219135364844028e-26, -7.547834835743209e-29,  2.511724439408180e-02, -1.776351659730816e-04,
  9.318944369696264e-07, -4.280290244209167e-09,  1.806573733577232e-11, -7.132421923926030e-14,  2.645763946079420e-16, -9.178879193958664e-19,  2.930569018535493e-21,
 -8.282165815035173e-24,  1.850624947586569e-26, -1.645574326014684e-29,  4.911511442888677e-02, -3.440195214868140e-04,  1.768048890951729e-06, -7.830403712314399e-09,
  3.114407791725814e-11, -1.118966069169221e-13,  3.561771915073620e-16, -9.408070899858317e-19,  1.583384585459544e-21,  2.312734976027779e-24, -3.931012534454753e-26,
  2.441623835276315e-28,  8.093590291559330e-02, -5.595738665898854e-04,  2.796043512782155e-06, -1.176101214756874e-08,  4.276362101173634e-11, -1.307036708801108e-13,
  2.943828426468601e-16, -1.474848096193798e-19, -3.275426781479612e-21,  2.466261089950212e-23, -1.200839866248694e-25,  4.473822532104296e-28,  1.204253598040319e-01,
 -8.189569097777132e-04,  3.945653778225383e-06, -1.547521019624619e-08,  4.916462066934440e-11, -1.099321794824732e-13,  2.424782392077146e-17,  1.449417263408817e-18,
 -9.935497569031536e-21,  4.331579836840025e-23, -1.292547324819127e-25,  1.481313975825758e-28,  1.673868319651465e-01, -1.115563142547913e-03,  5.134464726518246e-06,
 -1.833675533067266e-08,  4.703195613777537e-11, -4.009875253428516e-14, -4.308762460479516e-16,  3.315023328472093e-18, -1.414080083911557e-20,  3.536178561501659e-23,
  1.648398161418052e-26, -7.524276843092928e-28,  2.215787124906788e-01, -1.441581072855253e-03,  6.271527401779641e-06, -1.973630597128025e-08,  3.418760227531174e-11,
  7.540484488432393e-14, -9.561974219703017e-16,  4.496956731125988e-18, -1.103349794750031e-20, -1.229989977425073e-23,  2.836542688770879e-25, -1.580441403602512e-27,
  2.827114004869132e-01, -1.788074157896272e-03,  7.261791117157683e-06, -1.916306753241060e-08,  1.019747681257546e-11,  2.182345456477573e-13, -1.363566408172784e-15,
  3.981322692605885e-18,  1.688551560189388e-21, -8.552117497326326e-23,  4.791666713502567e-25, -1.179336162974488e-27,  3.504437974482630e-01, -2.145090661973622e-03,
  8.011288368093329e-06, -1.627664447381109e-08, -2.321614086079165e-11,  3.565212705653560e-13, -1.442592568181879e-15,  1.207592131993556e-18,  2.095194146014809e-20,
 -1.394946117954122e-22,  3.485022708763752e-25,  9.815405264817919e-28,  4.243793842962589e-01, -2.501809722117105e-03,  8.433001559424778e-06, -1.097246634327111e-08,
 -6.206474979295373e-11,  4.503100702969464e-13, -1.036070151976754e-15, -3.454650264758508e-18,  3.777965283037559e-20, -1.190758128947996e-22, -2.030461373965645e-25,
  3.693623268643350e-27,  5.040619487767888e-01, -2.846731789869997e-03,  8.453269428269609e-06, -3.432745995597620e-09, -1.003776692780408e-10,  4.606936880267244e-13,
 -1.195915582416499e-16, -8.519884226333040e-18,  4.041506041633774e-20,  1.535000419062408e-24, -9.155110427664276e-25,  4.237145579604096e-27,  5.889710679803912e-01,
 -3.167922150009156e-03,  8.018492239950195e-06,  5.846194715047443e-09, -1.309324980334529e-10,  3.612590573789749e-13,  1.143643497706401e-15, -1.170374343388372e-17,
  2.073866609162265e-20,  1.821180778344034e-22, -1.217626875354475e-24,  5.818717879743809e-28,  6.785174972175254e-01, -3.453316128211841e-03,  7.101766755794024e-06,
  1.605982020984082e-08, -1.464188371025427e-10,  1.493249738907156e-13,  2.403649118195459e-15, -1.078860883487393e-17, -1.874180378101322e-20,  3.149274363808357e-22,
 -6.088555142397593e-25, -5.775611788855764e-27,  7.720386761085104e-01, -3.691093520413460e-03,  5.708927327683987e-06,  2.614324267785096e-08, -1.409286340205217e-10,
 -1.464671361770419e-13,  3.201210337545330e-15, -4.809471242866396e-18, -6.183453650499730e-20,  2.788334257148356e-22,  8.068331272370597e-25, -9.383145030512613e-27,
  8.687946367237351e-01, -3.870127229648807e-03,  3.883298716134218e-06,  3.486699612302744e-08, -1.115519496393253e-10, -4.659048509292766e-13,  3.119595368420777e-15,
  4.958367866878982e-18, -8.363541405116604e-20,  3.267532021831486e-23,  2.101857926652723e-24, -4.937041718025757e-27,  9.679646868946070e-01, -3.980506512851438e-03,
  1.708301669025842e-06,  4.098122075902060e-08, -5.974037746181542e-11, -7.270969595641692e-13,  1.972930970862318e-15,  1.486960514069316e-17, -6.390375853920732e-20,
 -3.137990034553235e-22,  2.041463451622143e-24,  6.329541072878329e-27,  1.068645342206521e+00, -4.014128017252678e-03, -6.930676171759143e-07,  4.340019787442093e-08,
  7.983309590469579e-12, -8.468804688520506e-13, -4.160890991259414e-17,  2.010239256583267e-17, -2.953537030413476e-21, -5.282428247571719e-22,  1.974462426186382e-25,
  1.476862593775868e-26,  1.169850087075283e+00, -3.965337407579353e-03, -3.162880904670256e-06,  4.140767498031202e-08,  8.039128467425235e-11, -7.682263580399558e-13,
 -2.317257508229313e-15,  1.702100360416789e-17,  7.106069468941648e-20, -4.082913722886215e-22, -2.256825957686261e-24,  1.012640249690803e-26,  1.270511648221348e+00,
 -3.831590632491037e-03, -5.517881948900941e-06,  3.485029021472331e-08,  1.432762497743244e-10, -4.866269867726186e-13, -4.001847036221021e-15,  5.680363527865221e-18,
  1.133664935420659e-19,  2.783494054131254e-23, -3.157570375975373e-24, -6.000491792019883e-27,  1.369487545993737e+00, -3.614087142890290e-03, -7.564470909302805e-06,
  2.427461355027190e-08,  1.825045919423552e-10, -6.419949962952822e-14, -4.340682109637356e-15, -9.170959901505368e-18,  9.122447678077252e-20,  4.863427122188482e-22,
 -1.344843937033365e-24, -1.781865049776609e-26,  1.465569726293073e+00, -3.318309053407001e-03, -9.118745722285204e-06,  1.095769571862567e-08,  1.878883995489341e-10,
  3.791742139238383e-13, -3.073254250092074e-15, -1.990746868081758e-17,  1.248112962842110e-20,  5.953820649752330e-22,  1.761999778057148e-24, -1.124973210266889e-26,
  1.557499037339493e+00, -2.954383134550425e-03, -1.003019789554115e-05, -3.212366511950859e-09,  1.568402065008637e-10,  7.017665088711878e-13, -6.682739939303596e-16,
 -2.038117198231313e-17, -7.176029389639758e-20,  2.439261984101828e-22,  3.160047182035986e-24,  7.244113547143629e-27,  1.643985166138604e+00, -2.537171074586159e-03,
 -1.020634106347936e-05, -1.602506010366496e-08,  9.641864412424157e-11,  7.947097541235602e-13,  1.804146596745897e-15, -1.032499611719711e-17, -1.018856633980009e-19,
 -2.640196689192670e-22,  1.459029599263938e-24,  1.576336293995430e-26,  1.723732356307252e+00, -2.085993517050684e-03, -9.634241929286989e-06, -2.538117767557668e-08,
  2.247714158273343e-11,  6.335210062399438e-13,  3.192507017489634e-15,  3.724645817379653e-18, -5.957172832779376e-20, -4.715729326350403e-22, -1.312646548316865e-24,
  5.183439002459994e-27,  1.795470771696818e+00, -1.623911273395137e-03, -8.394042127615034e-06, -2.979188978041835e-08, -4.459360227208141e-11,  2.979990063553430e-13,
  2.929989175415642e-15,  1.267691564282659e-17,  1.360930920424428e-20, -2.379571079982591e-22, -2.060662123749432e-24, -8.138023026188101e-27,  1.857992755643423e+00,
 -1.176527659949430e-03, -6.659626105509533e-06, -2.881268088438075e-08, -8.664960559378429e-11, -5.866365183815991e-14,  1.407536182254470e-15,  1.172142738457798e-17,
  5.423501415223222e-20,  1.189645851193951e-22, -4.976781540057497e-25, -7.126659968202003e-27,  1.910192513746456e+00, -7.703397147184589e-04, -4.683057359638566e-06,
 -2.326104948650099e-08, -9.472363369271026e-11, -2.846023968400100e-13, -2.794319176872241e-16,  3.984475442701785e-18,  3.850359048911181e-20,  2.193643417310341e-22,
  8.618637283937536e-25,  1.615863676698240e-27,  1.951107037721974e+00, -4.307465963374377e-04, -2.762401458049500e-06, -1.509986576050773e-08, -7.296097544141841e-11,
 -3.102948665519291e-13, -1.109302126691952e-15, -2.801004693772253e-18,  3.928776002406304e-22,  6.638846649823717e-23,  5.653977820101780e-25,  3.359533940817686e-27,
  1.979955732567007e+00, -1.799043463129291e-04, -1.196626270961156e-06, -6.961256485256320e-09, -3.717376059743019e-11, -1.854659027858928e-13, -8.682725486076899e-16,
 -3.795121342929546e-18, -1.522976420432964e-20, -5.385652236395888e-23, -1.487295928932773e-25, -1.422270731871942e-28,  1.996179774301563e+00, -3.464531847101227e-05,
 -2.351254146805091e-07, -1.414235890432043e-09, -7.945323041251803e-12, -4.266098990808924e-14, -2.215206212761717e-16, -1.119818778450221e-18, -5.532313406676194e-21,
 -2.676878293229736e-23, -1.269820355564617e-25, -5.905598043997567e-28,  9.788588510400368e-04, -6.890876354058280e-06,  3.636625459468838e-08, -1.705068059247616e-10,
  7.489275687894216e-13, -3.155397521380997e-15,  1.291181687269587e-17, -5.169922989341991e-20,  2.034965496339692e-22, -7.899933472048427e-25,  3.031030964984322e-27,
 -1.151330969455860e-29,  8.803721880476912e-03, -6.179087022812291e-05,  3.240506793078087e-07, -1.503004937420946e-09,  6.493096961385650e-12, -2.671465663326315e-14,
  1.058220445163735e-16, -4.058620364976890e-19,  1.510701012478034e-21, -5.459197552277317e-24,  1.911582416865132e-26, -6.460303738391813e-29,  2.442129553620339e-02,
 -1.703806567424341e-04,  8.822192849845941e-07, -4.002313865416763e-09,  1.670072313177157e-11, -6.527246959928816e-14,  2.401446145259312e-16, -8.287388989574287e-19,
  2.645544158097394e-21, -7.558211791699556e-24,  1.765158593907264e-26, -2.194314020702603e-29,  4.776674175334514e-02, -3.302426856575519e-04,  1.677001506393544e-06,
 -7.349546320279371e-09,  2.898952443325985e-11, -1.036586734005145e-13,  3.305544192617716e-16, -8.890900448874805e-19,  1.640787282267902e-21,  9.397931621859922e-25,
 -2.969939998276936e-26,  1.943705197760460e-28,  7.874146647094754e-02, -5.377586115491653e-04,  2.658931649351756e-06, -1.109732453044822e-08,  4.021980713322976e-11,
 -1.236990933281551e-13,  2.889129594641714e-16, -2.389823540513255e-19, -2.469442055092621e-21,  2.023620857778716e-23, -1.016443139646968e-25,  3.913598125293642e-28,
  1.172115051686473e-01, -7.881212836900500e-04,  3.764598642824868e-06, -1.470612062489796e-08,  4.697490414663854e-11, -1.088977487519940e-13,  6.060779391333035e-17,
  1.155447103608055e-18, -8.467477523107660e-21,  3.829140979213350e-23, -1.216276350217970e-25,  1.945245975854641e-28,  1.630053552126756e-01, -1.075354860747060e-03,
  4.918910529190232e-06, -1.759119104132387e-08,  4.613383000080460e-11, -4.937588844376520e-14, -3.441987422107665e-16,  2.882952483912939e-18, -1.286329806098746e-20,
  3.542305273598486e-23, -1.191382255980754e-26, -5.454643639416737e-28,  2.159112459476341e-01, -1.392346790575746e-03,  6.038019583399392e-06, -1.917844435239650e-08,
  3.547620323386787e-11,  5.392685294187809e-14, -8.352773637616889e-16,  4.138857784700921e-18, -1.128822321167821e-20, -2.278744505371775e-24,  2.190272848500355e-25,
 -1.357683494269876e-27,  2.756738404589211e-01, -1.730896562134001e-03,  7.032951643388062e-06, -1.896673048981331e-08,  1.424396138471256e-11,  1.868500670057552e-13,
 -1.251769966622719e-15,  3.989691854895293e-18, -1.058006523562700e-21, -6.742285638717457e-23,  4.251595257522922e-25, -1.260725816881576e-27,  3.419903701734291e-01,
 -2.081787419000838e-03,  7.813969129977899e-06, -1.659292766414069e-08, -1.642882663104179e-11,  3.223760200383820e-13, -1.400128845669788e-15,  1.800469550070156e-18,
  1.618984495071722e-20, -1.248668306168089e-22,  3.787699087025104e-25,  4.161832935315893e-28,  4.145062165836123e-01, -2.434888594097884e-03,  8.295666491554010e-06,
 -1.189483424588213e-08, -5.331435133182071e-11,  4.244162260446799e-13, -1.116528909315636e-15, -2.315551209576469e-18,  3.338398980723469e-20, -1.241567944731013e-22,
 -5.618322475764166e-26,  2.983103972739964e-27,  4.928099754159160e-01, -2.779297010128456e-03,  8.402743557457751e-06, -4.965312143164893e-09, -9.121106598672392e-11,
  4.551067578027925e-13, -3.400823362650266e-16, -7.232420609271962e-18,  3.985615367497143e-20, -3.135256958775628e-23, -7.292083176003253e-25,  4.191439676733638e-27,
  5.764280700244134e-01, -3.103528650127409e-03,  8.076320017420304e-06,  3.810457510646389e-09, -1.234589744840293e-10,  3.848547581036777e-13,  8.261486091823968e-16,
 -1.094453378458188e-17,  2.642776429353078e-20,  1.342903714973820e-22, -1.165308532769840e-24,  1.741933783143367e-27,  6.648190256185452e-01, -3.395770701895837e-03,
  7.280536814167784e-06,  1.374404137606526e-08, -1.428802368441826e-10,  2.033301057427422e-13,  2.094839887902183e-15, -1.121211560307764e-17, -7.899442475122590e-21,
  2.859954976136746e-22, -8.252313121705802e-25, -4.060060037059749e-27,  7.573675773742946e-01, -3.644205754484532e-03,  6.009033810030414e-06,  2.386907448195215e-08,
 -1.431017096017589e-10, -7.146818619107588e-14,  3.040392073633564e-15, -6.622141669187700e-18, -5.131423015215434e-20,  3.029543835582319e-22,  4.028012303132278e-25,
 -8.892739655484019e-27,  8.533788667402332e-01, -3.837418247769972e-03,  4.290699478335192e-06,  3.301172988721370e-08, -1.201116544806705e-10, -3.896693203376954e-13,
  3.221250877172346e-15,  2.316618586431473e-18, -8.100391663569882e-20,  1.117767997871549e-22,  1.838784429927173e-24, -6.917099905721754e-27,  9.520730838671675e-01,
 -3.964890338072711e-03,  2.193870068064808e-06,  3.991174918135905e-08, -7.377632539110453e-11, -6.749913672035347e-13,  2.359067997596648e-15,  1.266018638348018e-17,
 -7.367194844256746e-20, -2.274952446650598e-22,  2.250559178219217e-24,  3.153370082138028e-27,  1.052581040839829e+00, -4.017588463894169e-03, -1.720574398763256e-07,
  4.339256665321727e-08, -8.918823159634695e-12, -8.411528444692503e-13,  5.170942242017296e-16,  1.970639582501651e-17, -2.167327516690210e-20, -5.075571625269974e-22,
  8.298041073371224e-25,  1.380470928887398e-26,  1.153941307640790e+00, -3.988632206501465e-03, -2.658787605582379e-06,  4.256816409703254e-08,  6.451048750134509e-11,
 -8.178787071691800e-13, -1.811162761816555e-15,  1.904327860554154e-17,  5.485370459029115e-20, -4.886714869637415e-22, -1.739248978243227e-24,  1.326995837092169e-26,
  1.255099702202793e+00, -3.874022676290221e-03, -5.086261858438927e-06,  3.705969294013393e-08,  1.325982691254910e-10, -5.803527373091012e-13, -3.792034449850526e-15,
  9.299304809070362e-18,  1.120427018231543e-19, -1.025050505769865e-22, -3.327447648173879e-24, -1.614854419978298e-27,  1.354912080664542e+00, -3.673388222231434e-03,
 -7.255716036408361e-06,  2.717867368233568e-08,  1.801598104853014e-10, -1.711116765774666e-13, -4.554051246400662e-15, -5.983560397986987e-18,  1.075754775928324e-19,
  4.168771927521238e-22, -2.125700069022723e-24, -1.744086856995001e-26,  1.452151495807834e+00, -3.390681394774629e-03, -8.968979329065406e-06,  1.402038201317254e-08,
  1.946894716471719e-10,  2.987925998831520e-13, -3.621758637304806e-15, -1.915257747479892e-17,  3.505215592204097e-20,  6.546382269133638e-22,  1.168370399252533e-24,
 -1.569620135999573e-26,  1.545520839119759e+00, -3.034735190729553e-03, -1.005322983190297e-05, -5.917105804094677e-10,  1.706676230201969e-10,  6.786293745774599e-13,
 -1.269598027632174e-15, -2.251203734010396e-17, -6.063559749416763e-20,  3.757294736337317e-22,  3.403709942105205e-24,  3.618526729788279e-27,  1.633672001114660e+00,
 -2.619563557379511e-03, -1.038885375050135e-05, -1.435296066034003e-08,  1.127204775682612e-10,  8.341633097941756e-13,  1.468061390606131e-15, -1.372475713404085e-17,
 -1.101674230987471e-19, -1.912156762434567e-22,  2.193959956074665e-24,  1.751294868448980e-26,  1.715232315333741e+00, -2.164278645072456e-03, -9.936226559677549e-06,
 -2.491598564132579e-08,  3.592102976612423e-11,  7.111612077887345e-13,  3.267487459211307e-15,  1.537100360663832e-18, -7.742878787114131e-20, -5.184405063891941e-22,
 -1.002713454485144e-24,  9.029260285983060e-27,  1.788838541250822e+00, -1.692505272201590e-03, -8.755616403529205e-06, -3.045376540735688e-08, -3.790145488366940e-11,
  3.726189000062438e-13,  3.289634493329778e-15,  1.295874356227230e-17,  3.473244488891391e-21, -3.274954727316566e-22, -2.413771518037407e-24, -7.792607399589449e-27,
  1.853177867846893e+00, -1.231211322844279e-03, -7.013729097337435e-06, -3.020651016548654e-08, -8.745745596417510e-11, -2.074446604910378e-14,  1.760646144141936e-15,
  1.352097867142406e-17,  5.807812984209372e-20,  9.215395813146237e-23, -8.591165744530891e-25, -9.359078060230998e-27,  1.907034421183108e+00, -8.089469035634465e-04,
 -4.971472330330560e-06, -2.482248785539265e-08, -1.004729571027634e-10, -2.898232120256645e-13, -1.493815957148310e-16,  5.349728342576784e-18,  4.703706061645329e-20,
  2.551108051810526e-22,  9.211248666162775e-25,  1.018727747081366e-27,  1.949338676672653e+00, -4.535909281220426e-04, -2.950813653855359e-06, -1.631836168632557e-08,
 -7.943944065614132e-11, -3.378554627110297e-13, -1.187162092690104e-15, -2.745525009707418e-18,  3.227690716770924e-21,  9.219540207383567e-23,  7.310217288160416e-25,
  4.193523426773687e-27,  1.979216425450040e+00, -1.898218975024481e-04, -1.283856206035357e-06, -7.586880570355134e-09, -4.110036376640342e-11, -2.076365083533962e-13,
 -9.816585997379598e-16, -4.314653670863544e-18, -1.727689583013071e-20, -5.989740425395574e-23, -1.523717991483763e-25, -1.239381797122964e-29,  1.996037320400189e+00,
 -3.659643301492127e-05, -2.528881183548288e-07, -1.548486712710319e-09, -8.854354835779535e-12, -4.837467556028698e-14, -2.555061911953909e-16, -1.313305124318957e-18,
 -6.594042269706375e-21, -3.240811828521779e-23, -1.560428369841010e-25, -7.359689118299893e-28,  9.518645285797164e-04, -6.607931624892659e-06,  3.439004063369597e-08,
 -1.590124706848606e-10,  6.888048949587405e-13, -2.862174479782947e-15,  1.155129070966382e-17, -4.561993235039719e-20,  1.771224047403516e-22, -6.783004304260876e-25,
  2.567383116155641e-27, -9.621737609685367e-30,  8.561631422977571e-03, -5.926888263682830e-05,  3.066207623603201e-07, -1.403255506955358e-09,  5.983308104468586e-12,
 -2.430601096737540e-14,  9.510617715088160e-17, -3.605219157295483e-19,  1.327274280967053e-21, -4.748577031235937e-24,  1.648274569562395e-26, -5.532558210297722e-29,
  2.375359052672718e-02, -1.635105681495357e-04,  8.357527014113854e-07, -3.745240462525105e-09,  1.545107725808049e-11, -5.977813542544347e-14,  2.180851843670629e-16,
 -7.483007012902536e-19,  2.385914953549801e-21, -6.872531331667867e-24,  1.660953071613377e-26, -2.509859721372465e-29,  4.647205539701924e-02, -3.171717214814449e-04,
  1.591522903563875e-06, -6.901876631199688e-09,  2.699369833677997e-11, -9.601814504246676e-14,  3.063985153393387e-16, -8.362568443426846e-19,  1.655182142508429e-21,
 -8.966881011645077e-26, -2.206832861997493e-26,  1.538924088599794e-28,  7.663214673405791e-02, -5.170090757311424e-04,  2.529544428853039e-06, -1.047322515616226e-08,
  3.781457897295138e-11, -1.168537639752903e-13,  2.812192578164419e-16, -3.071003972361627e-19, -1.810115330782517e-21,  1.649920484443830e-23, -8.558466665456453e-26,
  3.393623099982981e-28,  1.141181537678477e-01, -7.586977761221977e-04,  3.592563198381671e-06, -1.397185630080668e-08,  4.481396264011702e-11, -1.070843092897989e-13,
  8.936752131721689e-17,  9.056220019192222e-19, -7.174413736278113e-21,  3.360624582461361e-23, -1.124470702104311e-25,  2.198095553204463e-28,  1.587813190205656e-01,
 -1.036835483116250e-03,  4.712211115402278e-06, -1.686137211469980e-08,  4.507000766534518e-11, -5.671332598760721e-14, -2.690480326980446e-16,  2.491594858381403e-18,
 -1.160195370754920e-20,  3.451827951259393e-23, -3.211194923204593e-26, -3.788488214198242e-28,  2.104370232591471e-01, -1.344953474625204e-03,  5.811316136083621e-06,
 -1.860324733870648e-08,  3.636344958993704e-11,  3.523001604319380e-14, -7.244474049310939e-16,  3.777899976462149e-18, -1.122637074019635e-20,  5.351615231165998e-24,
  1.640534253729255e-25, -1.143240821488263e-27,  2.688613457961614e-01, -1.675539204097612e-03,  6.806836434924894e-06, -1.871052551952807e-08,  1.768955768348572e-11,
  1.581421704161353e-13, -1.140874704137768e-15,  3.920173353653894e-18, -3.192546721425277e-21, -5.153191326746230e-23,  3.693602716927366e-25, -1.264841871931736e-27,
  3.337869772635416e-01, -2.020076116890885e-03,  7.613483733935879e-06, -1.680601635349020e-08, -1.031296837503631e-11,  2.894323796938816e-13, -1.343117413627954e-15,
  2.249572806211414e-18,  1.197049766433185e-20, -1.094873902559534e-22,  3.870198767583773e-25, -2.094223079994419e-29,  4.048984692294634e-01, -2.369108080160191e-03,
  8.148085646247084e-06, -1.268143314993471e-08, -4.509863910143860e-11,  3.969580841929253e-13, -1.167081918098230e-15, -1.318967133184226e-18,  2.890366016455485e-20,
 -1.239833512693782e-22,  5.987467993017605e-26,  2.299752104037871e-27,  4.818268197915496e-01, -2.712337517511874e-03,  8.334702301436473e-06, -6.352381860094605e-09,
 -8.220621401951700e-11,  4.446575729511096e-13, -5.249422993865267e-16, -5.980354957595889e-18,  3.824633990995089e-20, -5.689404134839480e-23, -5.497121135987455e-25,
  3.938912987437797e-27,  5.641434195101505e-01, -3.038768177400343e-03,  8.110450659357790e-06,  1.897665559389313e-09, -1.155879141789305e-10,  4.011046735895436e-13,
  5.322048926453783e-16, -1.003032381440873e-17,  3.044415337557583e-20,  8.947940304600401e-23, -1.069178733946229e-24,  2.574437200171532e-27,  6.513534215103037e-01,
 -3.336905230543221e-03,  7.431891561791589e-06,  1.149311494097730e-08, -1.383364103450115e-10,  2.498197053081230e-13,  1.778862210293884e-15, -1.130685480373693e-17,
  1.763695565349451e-21,  2.499083137015727e-22, -9.670758073311427e-25, -2.406897246235990e-27,  7.428886578847487e-01, -3.595026775293704e-03,  6.281690433297513e-06,
  2.157191063871185e-08, -1.438173140971090e-10, -8.991983159427864e-16,  2.833640729265544e-15, -8.087336419596833e-18, -4.020989562313876e-20,  3.114948868612812e-22,
  3.126029922336375e-26, -7.928963391175531e-27,  8.381003069629910e-01, -3.801541324197383e-03,  4.675065990651663e-06,  3.103181367231035e-08, -1.271281828098107e-10,
 -3.118696151901655e-13,  3.250529002947932e-15, -1.975503645498788e-19, -7.573345095064810e-20,  1.788031811915401e-22,  1.502918476446525e-24, -8.237113031318112e-27,
  9.362516280719938e-01, -3.945444686150261e-03,  2.665293318984484e-06,  3.862652122242168e-08, -8.668266972585843e-11, -6.143932509564577e-13,  2.679442143762913e-15,
  1.018923593243673e-17, -8.021653161096547e-20, -1.356405205226281e-22,  2.319056525631643e-24, -1.701922004283361e-29,  1.036511226796428e+00, -4.016885779380292e-03,
  3.472446850092674e-07,  4.311614129958702e-08, -2.557355907699833e-11, -8.222162301059854e-13,  1.056469194541541e-15,  1.872806346687211e-17, -3.920594716125552e-20,
 -4.627193422438960e-22,  1.398041068947375e-24,  1.187937486339034e-26,  1.137947496508350e+00, -4.007842946222854e-03, -2.142323576435200e-06,  4.346729419558318e-08,
  4.776237892339893e-11, -8.547664269389754e-13, -1.256110081647567e-15,  2.050488247088117e-17,  3.615675316545792e-20, -5.458350596587566e-22, -1.102742062154881e-24,
  1.548909566227287e-26,  1.239525097559371e+00, -3.912898752960733e-03, -4.629214900354642e-06,  3.908355976098059e-08,  1.201042929681070e-10, -6.678361813107762e-13,
 -3.482197079224103e-15,  1.279988515656457e-17,  1.059523917317361e-19, -2.356182432456484e-22, -3.292884875400200e-24,  3.228835989649246e-27,  1.340104570687782e+00,
 -3.730080669642951e-03, -6.912408918854550e-06,  3.002786450549578e-08,  1.756331008996055e-10, -2.820171463066129e-13, -4.671266561468920e-15, -2.318911295091941e-18,
  1.208713852642326e-19,  3.169372831322579e-22, -2.857784345822558e-24, -1.558542150675110e-26,  1.438446407428298e+00, -3.461706872948007e-03, -8.781863142914677e-06,
  1.717831783182877e-08,  1.997534120496498e-10,  2.055839386953160e-13, -4.138728420644052e-15, -1.764624195194506e-17,  5.928270545270450e-20,  6.863380470254779e-22,
  3.875619310118720e-25, -1.967789347553471e-26,  1.533221068591001e+00, -3.115141990218005e-03, -1.004350432916390e-05,  2.245678442048821e-09,  1.838833730049049e-10,
  6.403891630294675e-13, -1.924877615398883e-15, -2.420944731119125e-17, -4.463243020268560e-20,  5.137118711072356e-22,  3.459792399836293e-24, -1.269178413434867e-27,
  1.623026479371292e+00, -2.703331389837733e-03, -1.054971173812979e-05, -1.241419043958158e-08,  1.297228672753972e-10,  8.643811820253568e-13,  1.033507911963888e-15,
 -1.734179025237541e-17, -1.152828731248911e-19, -8.773739388355395e-23,  2.985486975727057e-24,  1.826560442391657e-26,  1.706414342767364e+00, -2.244953545641958e-03,
 -1.023128677288183e-05, -2.422319319559763e-08,  5.093041594369342e-11,  7.897998885163375e-13,  3.272982058149592e-15, -1.246130024788909e-18, -9.670717400094434e-20,
 -5.493113127339870e-22, -5.077002280092122e-25,  1.357438634326773e-26,  1.781926102041812e+00, -1.764021698501699e-03, -9.124439966887359e-06, -3.099615653110488e-08,
 -2.963015797372570e-11,  4.559252485777187e-13,  3.652126258003135e-15,  1.286196069164177e-17, -1.013467653486438e-20, -4.306195261846092e-22, -2.733625833821281e-24,
 -6.578769372993408e-27,  1.848138473589538e+00, -1.288794872499808e-03, -7.384609028590249e-06, -3.160672015809524e-08, -8.741802718891267e-11,  2.626690830832967e-14,
  2.165699123247248e-15,  1.542507839051650e-17,  6.067125942225091e-20,  4.882369517614391e-23, -1.325971097737178e-24, -1.190781047260818e-26,  1.903717164338800e+00,
 -8.499379317986616e-04, -5.279179356019178e-06, -2.647656757591629e-08, -1.062922237712478e-10, -2.914320334497824e-13,  2.291519321059795e-17,  7.009041630139101e-18,
  5.689270533011133e-20,  2.925867302665974e-22,  9.452290014152735e-25, -5.643751406218497e-30,  1.947475828551581e+00, -4.780028499683970e-04, -3.154488250393589e-06,
 -1.764502355631492e-08, -8.648762156581690e-11, -3.672549002141261e-13, -1.262049419343753e-15, -2.583113445411262e-18,  7.120053783702550e-21,  1.254060941044472e-22,
  9.367137101521307e-25,  5.182256011025602e-27,  1.978436003348436e+00, -2.004684208497396e-04, -1.378985709417623e-06, -8.279030540165894e-09, -4.549880911052396e-11,
 -2.327105460878758e-13, -1.110541493916714e-15, -4.903189450478478e-18, -1.954255202262005e-20, -6.594814343495420e-23, -1.486363883805182e-25,  1.980681836559860e-28,
  1.995886767273426e+00, -3.869634946650430e-05, -2.723530187409889e-07, -1.698242464134048e-09, -9.886276375022629e-12, -5.497306144346558e-14, -2.954172284497628e-16,
 -1.544252538309690e-18, -7.881348490390898e-21, -3.934847169040536e-23, -1.923123815728643e-25, -9.197836343594951e-28,  9.259712166684958e-04, -6.340260798237575e-06,
  3.254617485334521e-08, -1.484349004602392e-10,  6.342334659604167e-13, -2.599653199732937e-15,  1.034974913608462e-17, -4.032369509487935e-20,  1.544544984423875e-22,
 -5.835908933298644e-25,  2.179460592790646e-27, -8.060109757566795e-30,  8.329357427085167e-03, -5.688168149856822e-05,  2.903404444417779e-07, -1.311290868384263e-09,
  5.519219853940607e-12, -2.213995217811150e-14,  8.558136344467209e-17, -3.206616871531127e-19,  1.167628620784921e-21, -4.135532886080413e-24,  1.422707108848971e-26,
 -4.741261735840260e-29,  2.311264147477977e-02, -1.570002044373271e-04,  7.922545678028540e-07, -3.507310316471184e-09,  1.430620148223048e-11, -5.478711664545180e-14,
  1.981653619964545e-16, -6.757839696852839e-19,  2.150191441109037e-21, -6.230776231886860e-24,  1.546747192601013e-26, -2.658269863471618e-29,  4.522831851130853e-02,
 -3.047636294361439e-04,  1.511229679787712e-06, -6.484948670935107e-09,  2.514500534731559e-11, -8.893958659272115e-14,  2.837232190306469e-16, -7.835004058074980e-19,
  1.637603352217554e-21, -8.471316334018845e-25, -1.604332031072105e-26,  1.211237154204049e-28,  7.460380146648944e-02, -4.972653247925342e-04,  2.407419982689524e-06,
 -9.886524819471167e-09,  3.554426822940070e-11, -1.102137069834733e-13,  2.718942630662257e-16, -3.561529134670894e-19, -1.274296876051107e-21,  1.336018737769282e-23,
 -7.171051877842332e-26,  2.920920468035001e-28,  1.111397988084226e-01, -7.306158922098170e-04,  3.429132787493825e-06, -1.327184168400529e-08,  4.269564916690827e-11,
 -1.046600551505296e-13,  1.116865987608451e-16,  6.945490370589877e-19, -6.043182913375545e-21,  2.930566721887254e-23, -1.025099393076218e-25,  2.297557754051711e-28,
  1.547081081921644e-01, -9.999349693813348e-04,  4.514162866534023e-06, -1.614965398302890e-08,  4.387660857529207e-11, -6.237411697231863e-14, -2.042961829052746e-16,
  2.139936865461167e-18, -1.038605508223448e-20,  3.294151306062880e-23, -4.576827410329637e-26, -2.472167505924820e-28,  2.051487905986744e-01, -1.299345962962797e-03,
  5.591588347442959e-06, -1.801670478414613e-08,  3.690254192501243e-11,  1.907227908699047e-14, -6.236581793802467e-16,  3.422910346215565e-18, -1.092717049078413e-20,
  1.096747418151779e-23,  1.181860419309959e-25, -9.447001890759592e-28,  2.622666834605468e-01, -1.621977575388485e-03,  6.584107982431537e-06, -1.840364045855690e-08,
  2.058741554225835e-11,  1.320651966191541e-13, -1.032799299791670e-15,  3.791072707984477e-18, -4.795069086857212e-21, -3.785896235595662e-23,  3.146577221663418e-25,
 -1.214275410121597e-27,  3.258272078841202e-01, -1.959977312264109e-03,  7.411006905063524e-06, -1.692644394275534e-08, -4.841358290901272e-12,  2.579931682192016e-13,
 -1.275337877842546e-15,  2.572543695459750e-18,  8.306436211583111e-21, -9.412753700098244e-23,  3.786328697892348e-25, -3.424684140395572e-28,  3.955514259553475e-01,
 -2.304543777177362e-03,  7.991836011778378e-06, -1.334103068573588e-08, -3.744204576941563e-11,  3.686053578702085e-13, -1.191730770247150e-15, -4.648156601799560e-19,
  2.450602710157438e-20, -1.197534949365143e-22,  1.470663309740976e-25,  1.675085905770752e-27,  4.711103114952764e-01, -2.645986502360319e-03,  8.250873029584252e-06,
 -7.597275067979116e-09, -7.345190596658700e-11,  4.301858212961785e-13, -6.755941118273053e-16, -4.793154111430390e-18,  3.584316369222779e-20, -7.552410204786193e-23,
 -3.846683855527282e-25,  3.544763271406888e-27,  5.521182146568475e-01, -2.973824310369248e-03,  8.122392927363761e-06,  1.130362026387051e-10, -1.074602597928860e-10,
  4.106201753022749e-13,  2.654215589993533e-16, -9.012592345051902e-18,  3.292453846989161e-20,  4.915319741326215e-23, -9.433235147887390e-25,  3.097874731894328e-27,
  6.381255317276455e-01, -3.276935661772442e-03,  7.556700746998957e-06,  9.321915741912982e-09, -1.329386660062201e-10,  2.887277140727104e-13,  1.464358622570487e-15,
 -1.111411492857114e-17,  1.004273031640047e-20,  2.095606054609443e-22, -1.039439739537670e-24, -9.155189008691967e-28,  7.286106420978270e-01, -3.543776896178681e-03,
  6.526758058260818e-06,  1.927430533425104e-08, -1.431742738624436e-10,  6.425578885330335e-14,  2.590864958737580e-15, -9.195051830917603e-18, -2.905439259962370e-20,
  3.061296172356187e-22, -2.900859914083897e-25, -6.635497204781447e-27,  8.229712517323369e-01, -3.762686294614027e-03,  5.035051328633170e-06,  2.895209557124967e-08,
 -1.325872848113852e-10, -2.341908035149306e-13,  3.212115228489024e-15, -2.507151694037595e-18, -6.830402880891516e-20,  2.314339764674703e-22,  1.123956057351320e-24,
 -8.878352256379968e-27,  9.205153951478769e-01, -3.922292754983174e-03,  3.120096108144265e-06,  3.714488131066422e-08, -9.830587534829059e-11, -5.469569921044160e-13,
  2.928197026770765e-15,  7.562026274759762e-18, -8.343813992586109e-20, -4.377693961230697e-23,  2.252884774987676e-24, -2.929675016597789e-27,  1.020452504964978e+00,
 -4.012046443070039e-03,  8.616455993391752e-07,  4.257696294081519e-08, -4.172265233628276e-11, -7.907250903244971e-13,  1.560869126932008e-15,  1.721871846826623e-17,
 -5.473797767158716e-20, -3.970885793291684e-22,  1.863865603546357e-24,  9.188191982070254e-27,  1.121885167676183e+00, -4.022883422254734e-03, -1.616699770839873e-06,
  4.409328898594666e-08,  3.041268668728968e-11, -8.779111130911926e-13, -6.687820505765417e-16,  2.134034342819908e-17,  1.588081431255421e-20, -5.759082090387781e-22,
 -3.930166572871898e-25,  1.657203439356206e-26,  1.223802450204977e+00, -3.948024836906933e-03, -4.149137302471400e-06,  4.089396251298352e-08,  1.059428156786180e-10,
 -7.467337639324736e-13, -3.077787992803891e-15,  1.602958932650779e-17,  9.514671284743493e-20, -3.630423131074120e-22, -3.042688988810860e-24,  8.113507152767973e-27,
  1.325075998412212e+00, -3.783891299612331e-03, -6.535419670960311e-06,  3.278676595927167e-08,  1.688686953129634e-10, -3.944599055121231e-13, -4.680495247653783e-15,
  1.708176145620627e-18,  1.300660878201405e-19,  1.897919092401384e-22, -3.475037599233208e-24, -1.223122857533510e-26,  1.424460452750509e+00, -3.531082609300389e-03,
 -8.556429247055610e-06,  2.040170511051664e-08,  2.028329793329950e-10,  1.005625798325821e-13, -4.602538855913971e-15, -1.535262618377362e-17,  8.405222972533844e-20,
  6.835488177834138e-22, -5.490525112314079e-25, -2.269455216897163e-26,  1.520600047105029e+00, -3.195331260079915e-03, -9.998489494115776e-06,  5.287531486438807e-09,
  1.961735204977027e-10,  5.859143736027317e-13, -2.619767954498465e-15, -2.531528648264757e-17, -2.367647985244205e-20,  6.492954289346225e-22,  3.275755096842385e-24,
 -7.254055893379791e-27,  1.612043466501452e+00, -2.788288358498903e-03, -1.068565424024230e-05, -1.019914850239751e-08,  1.472170379698291e-10,  8.829396119332430e-13,
  4.959896388791912e-16, -2.105676162693664e-17, -1.160987158680779e-19,  4.767465853909826e-23,  3.780221617743478e-24,  1.758695719635324e-26,  1.697269008208612e+00,
 -2.327951471885997e-03, -1.051654072636824e-05, -2.327768897941441e-08,  6.750721797032138e-11,  8.675646831842024e-13,  3.191771978658585e-15, -4.659827391708343e-18,
 -1.166907587741573e-19, -5.562158142888888e-22,  1.992425543860891e-25,  1.861682530961346e-26,  1.774721658075845e+00, -1.838512368601499e-03, -9.498921670618069e-06,
 -3.139240705068586e-08, -1.960622474597289e-11,  5.478461585444835e-13,  4.005236738634540e-15,  1.226797893100641e-17, -2.766959424467370e-20, -5.451474530791478e-22,
 -2.975431470964083e-24, -4.193069191101845e-27,  1.842862704752486e+00, -1.349412585980868e-03, -7.772254906248454e-06, -3.299823100535722e-08, -8.633679785630624e-11,
  8.364713271572011e-14,  2.624967124279534e-15,  1.738337197528728e-17,  6.134065121002978e-20, -1.549722581807761e-23, -1.910233851090820e-24, -1.467261834304174e-26,
  1.900230892123197e+00, -8.934715958111293e-04, -5.607294277254289e-06, -2.822377184570783e-08, -1.120983628273939e-10, -2.883113137649758e-13,  2.462916732264188e-16,
  9.005410269072572e-18,  6.810254169976226e-20,  3.299654430677385e-22,  9.119952808001659e-25, -1.616700694462336e-27,  1.945511970357070e+00, -5.041098107748590e-04,
 -3.374779129825582e-06, -1.908925606983169e-08, -9.414131819245412e-11, -3.983818248347897e-13, -1.330453879401386e-15, -2.275341074315753e-18,  1.236700944317668e-20,
  1.677611990334017e-22,  1.189392334749276e-24,  6.328605777464386e-27,  1.977611418737330e+00, -2.119104390326310e-04, -1.482860372126313e-06, -9.045741297632982e-09,
 -5.043104509247059e-11, -2.610839136766309e-13, -1.256950831145232e-15, -5.567662688831928e-18, -2.202083427800703e-20, -7.163302201000985e-23, -1.332328408359615e-25,
  5.248974226815725e-28,  1.995727491251092e+00, -4.095946445884270e-05, -2.937185823465688e-07, -1.865619031344004e-09, -1.106029314421894e-11, -6.261180673203965e-14,
 -3.424111594756430e-16, -1.820688012919194e-18, -9.446692924710958e-21, -4.791495461582053e-23, -2.377069114838404e-25, -1.152745936989343e-27,  9.011198696648863e-04,
 -6.086847628785847e-06,  3.082416938154102e-08, -1.386899875201787e-10,  5.846356938230231e-13, -2.364268302298054e-15,  9.286838953864441e-18, -3.570114356812491e-20,
  1.349326259454082e-22, -5.031072263532240e-25,  1.854130454408810e-27, -6.767659727068775e-30,  8.106378566003131e-03, -5.462043161945142e-05,  2.751205400924264e-07,
 -1.226417123433763e-09,  5.096254327769342e-12, -2.018965337352398e-14,  7.710431236345397e-17, -2.855737606372514e-19,  1.028509106939306e-21, -3.606108341890831e-24,
  1.229329460763922e-26, -4.066317942598958e-29,  2.249705556039578e-02, -1.508267091322333e-04,  7.515048996535325e-07, -3.286924919980110e-09,  1.325652547678831e-11,
 -5.025063932736083e-14,  1.801738136720357e-16, -6.104496607486056e-19,  1.936736586339488e-21, -5.635632080887460e-24,  1.428753657175143e-26, -2.689044150523021e-29,
  4.403296029277194e-02, -2.929783629136612e-04,  1.435766694444737e-06, -6.096496296945585e-09,  2.343256067773962e-11, -8.238759625685168e-14,  2.625134441836931e-16,
 -7.316989752260793e-19,  1.596764431680155e-21, -1.390471354516593e-24, -1.131597402620995e-26,  9.470163730561071e-29,  7.265252094216754e-02, -4.784710153198914e-04,
  2.292122332588874e-06, -9.335099638773511e-09,  3.340441895975007e-11, -1.038120946776106e-13,  2.614195966646599e-16, -3.897641859290458e-19, -8.419816521742116e-22,
  1.073599661772320e-23, -5.980705049074050e-26,  2.497984304348637e-28,  1.082712088908358e-01, -7.038084231999272e-04,  3.273900882880470e-06, -1.260530503566221e-08,
  4.063071918502162e-11, -1.017671134326703e-13,  1.285797007050400e-16,  5.172756821753164e-19, -5.059544884008179e-21,  2.540785202753921e-23, -9.238758292360335e-26,
  2.288822714686538e-28,  1.507793842683607e-01, -9.645850118437244e-04,  4.324537197364492e-06, -1.545785479633341e-08,  4.258475903645695e-11, -6.659467990676192e-14,
 -1.488552565435108e-16,  1.826184760621047e-18, -9.235440372713605e-21,  3.092522316589316e-23, -5.430405878623108e-26, -1.452382283805920e-28,  2.000395170931538e-01,
 -1.255467996656347e-03,  5.378940574766330e-06, -1.742399391875258e-08,  3.714187015802017e-11,  5.215463499413232e-15, -5.326466559619691e-16,  3.080392512065746e-18,
 -1.045677015683504e-20,  1.491763506288011e-23,  8.062140823588561e-26, -7.663197228069411e-28,  2.558827283694580e-01, -1.570182294326932e-03,  6.365323587135359e-06,
 -1.805442238494006e-08,  2.298935114935145e-11,  1.085332998288433e-13, -9.289856275246605e-16,  3.618149746872821e-18, -5.944104906772075e-21, -2.631778463633584e-23,
  2.630337812471606e-25, -1.127651623154272e-27,  3.181045869802822e-01, -1.901502661713708e-03,  7.207589763950771e-06, -1.696426481716655e-08,  1.840083392281599e-14,
  2.282764425404451e-13, -1.200074141922137e-15,  2.787021326702886e-18,  5.186161806954106e-21, -7.935554210575345e-23,  3.583533562208155e-25, -5.642772820342280e-28,
  3.864600926526965e-01, -2.241259092624369e-03,  7.828387444457680e-06, -1.388268345908211e-08, -3.035656697529416e-11,  3.399323156096113e-13, -1.194406134843385e-15,
  2.516685962580800e-19,  2.031701979989135e-20, -1.125638426287177e-22,  2.084304288668360e-25,  1.127961577731279e-27,  4.606577747104887e-01, -2.580363518303704e-03,
  8.152935295589832e-06, -8.704600138929987e-09, -6.502054418742683e-11,  4.124880607112890e-13, -7.941728707490999e-16, -3.692347388089973e-18,  3.288369037274875e-20,
 -8.792779471367168e-23, -2.390021627821018e-25,  3.066915881390270e-27,  5.403528438534264e-01, -2.908868344429163e-03,  8.113705078073007e-06, -1.540366255790413e-09,
 -9.920397436670849e-11,  4.140824982017067e-13,  2.803483672292654e-17, -7.937704839199751e-18,  3.404858261984499e-20,  1.423852347514843e-23, -8.005877379529814e-25,
  3.348856639570286e-27,  6.251393543032574e-01, -3.216070312408163e-03,  7.655998082368959e-06,  7.242897977118286e-09, -1.268376562585719e-10,  3.201809753306164e-13,
  1.158739139455549e-15, -1.068012023618355e-17,  1.683238960717270e-20,  1.675673177678204e-22, -1.051019754923011e-24,  3.477637904757259e-28,  7.145413726662085e-01,
 -3.490676489282255e-03,  6.744358101166242e-06,  1.699708706903484e-08, -1.412887049650846e-10,  1.232520391192052e-13,  2.322024763295794e-15, -9.951246952109083e-18,
 -1.830908690543462e-20,  2.891132460907606e-22, -5.499555243343056e-25, -5.157954280505160e-27,  8.080032163856806e-01, -3.721052576032185e-03,  5.369607022498717e-06,
  2.679738887377817e-08, -1.365071221756567e-10, -1.581814387207594e-13,  3.112624715097809e-15, -4.551665369353965e-18, -5.925779326182758e-20,  2.685341207637976e-22,
  7.310237305890037e-25, -8.883589880999291e-27,  9.048789298627554e-01, -3.895576577244827e-03,  3.556048880536117e-06,  3.548835910501697e-08, -1.085266604577225e-10,
 -4.744419764323693e-13,  3.102438865180536e-15,  4.883884169159078e-18, -8.343009056536431e-20,  4.299986388874575e-23,  2.068092074485777e-24, -5.380055482618742e-27,
  1.004421323782992e+00, -4.003122120495265e-03,  1.368048933518454e-06,  4.178508005952976e-08, -5.712457055983733e-11, -7.476893501266381e-13,  2.016428488734609e-15,
  1.525350585873193e-17, -6.760201942628659e-20, -3.153621207479892e-22,  2.199147307839278e-24,  5.992471622961851e-27,  1.105771127794027e+00, -4.033693609378192e-03,
 -1.085242374301520e-06,  4.443875805014510e-08,  1.274257183899247e-11, -8.867533319622494e-13, -6.726799151229812e-17,  2.151520301497557e-17, -4.958544110766388e-21,
 -5.769994723963794e-22,  3.373579860555446e-25,  1.642210939492395e-26,  1.207947111755355e+00, -3.979227369008357e-03, -3.648744655362596e-06,  4.246571535487060e-08,
  9.030755024809812e-11, -8.148835804628191e-13, -2.588461569065063e-15,  1.884246278647777e-17,  7.998496360952552e-20, -4.762479383613058e-22, -2.584951390912501e-24,
  1.258814838849859e-26,  1.309838422298511e+00, -3.834555599045702e-03, -6.126047133689032e-06,  3.541947292824780e-08,  1.598625063790339e-10, -5.057421958788776e-13,
 -4.573566547504706e-15,  5.951806898829032e-18,  1.342785020256446e-19,  4.132245813585229e-23, -3.914127145601904e-24, -7.525904263471372e-27,  1.410200848014359e+00,
 -3.598499477701150e-03, -8.292090275092382e-06,  2.365698068236625e-08,  2.037064683933534e-10, -1.473036528317317e-14, -4.991099341170359e-15, -1.227545956857050e-17,
  1.080185228510953e-19,  6.410350173729355e-22, -1.588052135060529e-24, -2.425510822867698e-26,  1.507659224560578e+00, -3.275011148130512e-03, -9.915831482311845e-06,
  8.516395680281348e-09,  2.072053010136317e-10,  5.144708770007756e-13, -3.335512936789045e-15, -2.567439060914592e-17,  1.962162054496071e-21,  7.719990365644214e-22,
  2.810335425019411e-24, -1.398541702055637e-26,  1.600718625769123e+00, -2.874221763270195e-03, -1.079332691726677e-05, -7.701966768924341e-09,  1.649449519821534e-10,
  8.873511445171687e-13, -1.451372243486777e-16, -2.471379595541239e-17, -1.114793507047852e-19,  2.137638579255145e-22,  4.505898534606682e-24,  1.506365334265506e-26,
  1.687787196260211e+00, -2.413181419317552e-03, -1.078880636646187e-05, -2.205465326099282e-08,  8.561170952327548e-11,  9.421611492776718e-13,  3.006029808239916e-15,
 -8.711079995840426e-18, -1.363597261404644e-19, -5.303331661395084e-22,  1.132663566492261e-24,  2.379448108634682e-26,  1.767213233644308e+00, -1.916015043167790e-03,
 -9.877133941959119e-06, -3.161311368182024e-08, -7.660818038398801e-12,  6.479748650457528e-13,  4.333228261236760e-15,  1.104527469476664e-17, -4.947258254194078e-20,
 -6.668333938727800e-22, -3.080707870272983e-24, -3.224867926377433e-28,  1.837338157507839e+00, -1.413197873707991e-03, -8.176455254180848e-06, -3.436264380444697e-08,
 -8.399329548153296e-11,  1.527078895532203e-13,  3.138985583144254e-15,  1.932128699316875e-17,  5.924424823085147e-20, -1.056463948037516e-22, -2.617570029939110e-24,
 -1.746105341627512e-26,  1.896565100404478e+00, -9.397156175349384e-04, -5.956929982139438e-06, -3.006306399181707e-08, -1.177837346500487e-10, -2.791170133986627e-13,
  5.307880818267511e-16,  1.138161603587464e-17,  8.061507268340828e-20,  3.643825260244804e-22,  7.914658910596682e-25, -4.008339666837482e-27,  1.943440046901483e+00,
 -5.320505514593584e-04, -3.613156378138335e-06, -2.066101394664329e-08, -1.024331680583895e-10, -4.310265908547048e-13, -1.387646359129764e-15, -1.773217582103797e-18,
  1.933323645740469e-20,  2.212761900017859e-22,  1.495752414927729e-24,  7.617886614398210e-27,  1.976739343836432e+00, -2.242216426017048e-04, -1.596428421112112e-06,
 -9.896104976787707e-09, -5.596744079116036e-11, -2.932035139420448e-13, -1.423105432653371e-15, -6.314565805613110e-18, -2.468881581650725e-20, -7.636942694436775e-23,
 -1.000046540436185e-25,  1.017893262296947e-27,  1.995558807732504e+00, -4.340186939033059e-05, -3.172106178867713e-07, -2.053066083470485e-09, -1.239902082794086e-11,
 -7.147724697005167e-14, -3.978955395375582e-16, -2.152520320657420e-18, -1.135574179455417e-20, -5.851964336812530e-23, -2.946811798229427e-25, -1.448725096329863e-27,
  8.772553452800020e-04, -5.846755888887944e-06,  2.921449246044968e-08, -1.297023206155032e-10,  5.395006513550831e-13, -2.152908072922095e-15,  8.345032710799875e-18,
 -3.165933781889368e-20,  1.180870077473315e-22, -4.345674250220011e-25,  1.580664702188646e-27, -5.695395905763777e-30,  7.892207477773737e-03, -5.247697918773591e-05,
  2.608797682735175e-07, -1.148009507960972e-09,  4.710337337815158e-12, -1.843150021665644e-14,  6.955015976682637e-17, -2.546470762824832e-19,  9.071253455645082e-22,
 -3.148398700824536e-24,  1.063410966129807e-26, -3.490493150343426e-29,  2.190552798765913e-02, -1.449689114391224e-04,  7.133020071109055e-07, -3.082631355837798e-09,
  1.229340531809929e-11, -4.612475922315957e-14,  1.639191541256468e-16, -5.516122236428444e-19,  1.743856522050420e-21, -5.087695301608846e-24,  1.311297455652456e-26,
 -2.639055342910683e-29,  4.288356461026828e-02, -2.817786105631480e-04,  1.364804978965472e-06, -5.734421886488225e-09,  2.184618211924474e-11, -7.632739973352673e-14,
  2.427331205065243e-16, -6.814830349716216e-19,  1.539503560851890e-21, -1.766361749787676e-24, -7.633004386572363e-27,  7.347930991458770e-29,  7.077461399266145e-02,
 -4.605731910381505e-04,  2.183240539136872e-06, -8.816901740327282e-09,  3.139001950628073e-11, -9.767168859522073e-14,  2.501839242495419e-16, -4.109645626477390e-19,
 -4.960019580534225e-22,  8.552187432151082e-24, -4.965554116152971e-26,  2.124307686386649e-28,  1.055074150086349e-01, -6.782113727965136e-04,  3.126471161006209e-06,
 -1.197132399303339e-08,  3.862731816817833e-11, -9.852487114796347e-14,  1.409292795445870e-16,  3.693115251114072e-19, -4.208971461288977e-21,  2.191178057911379e-23,
 -8.247611795093003e-26,  2.206682192033057e-28,  1.469890782367847e-01, -9.307192106416718e-04,  4.143086541507473e-06, -1.478733111030688e-08,  4.122111368165718e-11,
 -6.958598991003921e-14, -1.016952471429723e-16,  1.548033362069400e-18, -8.162546338021117e-21,  2.864963990517471e-23, -5.891241079895207e-26, -6.790858081524584e-29,
  1.951023981996066e-01, -1.213262717619860e-03,  5.173419538086746e-06, -1.682955544168185e-08,  3.712513732632348e-11, -6.570339147681877e-15, -4.509954947922898e-16,
  2.754927752729749e-18, -9.869377187861180e-21,  1.751578134725943e-23,  5.042502954721226e-26, -6.099191334068759e-28,  2.497024812691472e-01, -1.520119907531163e-03,
  6.150945297330365e-06, -1.767040478826765e-08,  2.494515201735887e-11,  8.743104399467423e-14, -8.304689013245205e-16,  3.414714726779825e-18, -6.713841610544780e-21,
 -1.675812470452505e-23,  2.157364010802934e-25, -1.019749914608381e-27,  3.106126089374113e-01, -1.844655886362153e-03,  7.004166019200088e-06, -1.692898423270869e-08,
  4.302318928704569e-12,  2.004273134301937e-13, -1.120124188300764e-15,  2.909984753448710e-18,  2.580961035478082e-21, -6.556433827625013e-23,  3.301956403525706e-25,
 -7.033805127255633e-28,  3.776192444089441e-01, -2.179306112265752e-03,  7.659100332300589e-06, -1.431555319552945e-08, -2.384364333889323e-11,  3.114209108135537e-13,
 -1.178854593068036e-15,  8.386739921101203e-19,  1.642544761597934e-20, -1.033760661152968e-22,  2.476009506872571e-25,  6.669946970036223e-28,  4.504660819024519e-01,
 -2.515574922246012e-03,  8.042506918236095e-06, -9.679999407558432e-09, -5.696915680685625e-11,  3.923032060894004e-13, -8.833142393641804e-16, -2.692305796043738e-18,
  2.957736721916291e-20, -9.493893406203765e-23, -1.152980718579725e-25,  2.553563149934914e-27,  5.288470354244711e-01, -2.844058995589133e-03,  8.085970313197950e-06,
 -3.061413436450912e-09, -9.093296122833395e-11,  4.122116449623062e-13, -1.789324615482714e-16, -6.845839508134975e-18,  3.402048632849112e-20, -1.481581160436145e-23,
 -6.519481923252692e-25,  3.374505490643457e-27,  6.123980714309277e-01, -3.154508672496989e-03,  7.730952382026253e-06,  5.266134917719052e-09, -1.201798247074109e-10,
  3.444683451667114e-13,  8.680859776763365e-16, -1.005302976001038e-17,  2.211466125435819e-20,  1.261466611299378e-22, -1.012726469464199e-24,  1.348101015388151e-27,
  7.006878142336517e-01, -3.435943988280819e-03,  6.934850323442868e-06,  1.475912023074513e-08, -1.382892496045231e-10,  1.755802635804305e-13,  2.036719350259104e-15,
 -1.037527114110006e-17, -8.347574670370681e-21,  2.630262372497540e-22, -7.432531078706332e-25, -3.629975241704921e-27,  7.932069036926733e-01, -3.676846789419500e-03,
  5.677979625807640e-06,  2.459197768069872e-08, -1.389351130257738e-10, -8.521296582964114e-14,  2.960119739126351e-15, -6.288353489775177e-18, -4.915737279273558e-20,
  2.900807370599051e-22,  3.502548283338550e-25, -8.343536017815954e-27,  8.893561748595019e-01, -3.865454958874215e-03,  3.971190717414582e-06,  3.368010849252043e-08,
 -1.172613890413427e-10, -3.986421527789772e-13,  3.202154623226833e-15,  2.254355581444101e-18, -8.045558128396760e-20,  1.203982682894110e-22,  1.788365035242242e-24,
 -7.227427137182884e-27,  9.884338763382035e-01, -3.990188701769451e-03,  1.863501363788110e-06,  4.075422674446910e-08, -7.156112538705278e-11, -6.944242088817482e-13,
  2.411657944060465e-15,  1.292602626678109e-17, -7.731719353631432e-20, -2.231202831841294e-22,  2.388102625342401e-24,  2.586381622279896e-27,  1.089622369940751e+00,
 -4.040240369426882e-03, -5.513389737994830e-07,  4.450087520653150e-08, -4.960016299001449e-12, -8.811756511456511e-13,  5.298402159217144e-16,  2.102817847622868e-17,
 -2.531620010604624e-20, -5.493681963525321e-22,  1.034335377587421e-24,  1.506934208438546e-26,  1.191975082777761e+00, -4.006355667902067e-03, -3.131034800905163e-06,
  4.377706380616250e-08,  7.343280759343921e-11, -8.704028922485792e-13, -2.027752457085873e-15,  2.110886019995621e-17,  6.112290014689266e-20, -5.674244045903462e-22,
 -1.947362287657754e-24,  1.622218063517568e-26,  1.294404935353403e+00, -3.881821165971503e-03, -5.686019590667766e-06,  3.789045575189914e-08,  1.486660164366412e-10,
 -6.130221548910890e-13, -4.346754262392878e-15,  1.024175209924360e-17,  1.328828406202713e-19, -1.202376334212903e-22, -4.122043129078541e-24, -1.789636451006265e-27,
  1.395676052729512e+00, -3.663645321895192e-03, -7.988681792189111e-06,  2.690730935791867e-08,  2.021882638763516e-10, -1.382298756583587e-13, -5.283050160129084e-15,
 -8.463984064032327e-18,  1.296944148626276e-19,  5.561119693965817e-22, -2.655896955928956e-24, -2.394838523879889e-26,  1.494401254471171e+00, -3.353871900629001e-03,
 -9.793418230481320e-06,  1.190940237163766e-08,  2.166361142944380e-10,  4.258254898358788e-13, -4.049191659551370e-15, -2.514656044984422e-17,  3.161061208923726e-20,
  8.700565765439738e-22,  2.041944169101549e-24, -2.092105038806704e-26,  1.589048525249998e+00, -2.960891861639335e-03, -1.086933142449781e-05, -4.921303037246225e-09,
  1.825990425264763e-10,  8.751692915069364e-13, -8.856541946060760e-16, -2.812199481629686e-17, -1.003906441545649e-19,  4.060406907407900e-22,  5.073811119776622e-24,
  1.037491408655072e-26,  1.677960208321952e+00, -2.500525750117277e-03, -1.104460920608483e-05, -2.053029228480590e-08,  1.051540010897744e-10,  1.010868588985892e-12,
  2.698234884128397e-15, -1.336918315534030e-17, -1.543705527316119e-19, -4.626320224572843e-22,  2.287202889315391e-24,  2.856212458759450e-26,  1.759388735135577e+00,
 -1.996550605761833e-03, -1.025678049878045e-05, -3.162625862226181e-08,  6.362682962802744e-12,  7.554816318343829e-13,  4.616554042291517e-15,  9.054333749373489e-18,
 -7.568649016462742e-20, -7.888231434812355e-22, -2.977770119498244e-24,  5.311069159780872e-27,  1.831551899255244e+00, -1.480281509182268e-03, -8.596755778167892e-06,
 -3.567782229217566e-08, -8.014087098130936e-11,  2.347454484128559e-13,  3.705798278985870e-15,  2.113449356951051e-17,  5.336410992013665e-20, -2.264843671648755e-22,
 -3.442553609303453e-24, -1.995583245271205e-26,  1.892708596479802e+00, -9.888465408407227e-04, -6.329175654721117e-06, -3.199145656592656e-08, -1.232113135387223e-10,
 -2.622500425892747e-13,  8.876022249747154e-16,  1.417689435979452e-17,  9.425196945379937e-20,  3.915951514963941e-22,  5.444564754456536e-25, -7.404748113768108e-27,
  1.941252423743517e+00, -5.619760599705346e-04, -3.871212511482892e-06, -2.237073390580650e-08, -1.113903625680460e-10, -4.648482055507386e-13, -1.427351373159006e-15,
 -1.014872044511812e-18,  2.846056662326845e-20,  2.882136849140491e-22,  1.861239518569626e-24,  9.005546038899715e-27,  1.975816140212673e+00, -2.374837641843620e-04,
 -1.720754248858529e-06, -1.084041407476908e-08, -6.218785006661943e-11, -3.295715787748388e-13, -1.611392117960648e-15, -7.149269860162331e-18, -2.749758831021841e-20,
 -7.927945202173999e-23, -4.020466197517946e-26,  1.745965910945377e-27,  1.995379963943196e+00, -4.604158616030929e-05, -3.430866304074822e-07, -2.263426888521996e-09,
 -1.392916339590481e-11, -8.179308024010473e-14, -4.635871604977117e-16, -2.552017118886920e-18, -1.369092060148924e-20, -7.168612619685017e-23, -3.663854930549161e-25,
 -1.825639704157117e-27,  8.543260991685431e-04, -5.619122119603651e-06,  2.770847020025890e-08, -1.214041874583987e-10,  4.983756413879474e-13, -1.962851853752123e-15,
  7.509206595388266e-18, -2.811913518685283e-20,  1.035227850097286e-22, -3.760784095256758e-25,  1.350276789864360e-27, -4.803713889101474e-30,  7.686388161153220e-03,
 -5.044379172462591e-05,  2.475439690674613e-07, -1.075504823721458e-09,  4.357838350654853e-12, -1.684467950056052e-14,  6.280996300322566e-17, -2.273533605229465e-19,
  8.010832087970484e-22, -2.752247492218825e-24,  9.209229199456378e-27, -2.999056880834326e-29,  2.133683552398509e-02, -1.394071866275979e-04,  6.774608337247147e-07,
 -2.893108221679242e-09,  1.140903155813581e-11, -4.236990111986871e-14,  1.492284336380249e-16, -4.986403508202337e-19,  1.569863418117238e-21, -4.586126621536355e-24,
  1.197301876463701e-26, -2.535581419513870e-29,  4.177785947014125e-02, -2.711295948134573e-04,  1.298039781544618e-06, -5.396785220885035e-09,  2.037637298369676e-11,
 -7.072527700866728e-14,  2.243313484931970e-16, -6.332892696103924e-19,  1.471149395638979e-21, -2.012296838752137e-24, -4.787332388024973e-27,  5.649888077636511e-29,
  6.896659485328234e-02, -4.435220862842366e-04,  2.080387742827969e-06, -8.329966599703156e-09,  2.949568969798821e-11, -9.180688083319982e-14,  2.384983619408394e-16,
 -4.222762253305326e-19, -2.217137581337068e-22,  6.742956366117299e-24, -4.104400214481070e-26,  1.797491317477815e-28,  1.028436978723718e-01, -6.537638689770643e-04,
  2.986459073471573e-06, -1.136886385880418e-08,  3.669140572516844e-11, -9.503299283137055e-14,  1.494985390962861e-16,  2.466276937916619e-19, -3.477221892620984e-21,
  1.880338757097113e-23, -7.303787848379060e-26,  2.077453499862504e-28,  1.433313826301765e-01, -8.982732046212007e-04,  3.969549477798600e-06, -1.413904544208915e-08,
  3.980834940658557e-11, -7.153511578199407e-14, -6.185535279950488e-17,  1.302874536265784e-18, -7.174128637316432e-21,  2.625153795267242e-23, -6.057655342728694e-26,
 -1.071059998274101e-29,  1.903308572337514e-01, -1.172673095619135e-03,  4.975022714673182e-06, -1.623716700441113e-08,  3.689155788093446e-11, -1.650366765651735e-14,
 -3.781817196395301e-16,  2.449536053179387e-18, -9.208593465336168e-21,  1.903716540298112e-23,  2.662225608621761e-26, -4.756117063713879e-28,  2.437190835584980e-01,
 -1.471753613481958e-03,  5.941349458810903e-06, -1.725834425566089e-08,  2.650207731011967e-11,  6.862235722706847e-14, -7.379440091491391e-16,  3.191798879695391e-18,
 -7.172305935238550e-21, -8.991756240234758e-24,  1.734416173456529e-25, -9.018583566913358e-28,  3.033447674874294e-01, -1.789433683923024e-03,  6.801558857686582e-06,
 -1.682951155772801e-08,  8.048674542730606e-12,  1.745293292180676e-13, -1.037825363614562e-15,  2.957297396303161e-18,  4.506848123183544e-22, -5.300123799162420e-23,
  2.974291463279631e-25, -7.764251980831516e-28,  3.690234690387561e-01, -2.118726478215364e-03,  7.485225286806248e-06, -1.464875236021748e-08, -1.789595549264824e-11,
  2.834662203878585e-13, -1.148558666546814e-15,  1.306705504979848e-18,  1.288818483513641e-20, -9.300135583507234e-23,  2.684115201804569e-25,  2.930450409209675e-28,
  4.405317055446513e-01, -2.451714413784478e-03,  7.921133009799585e-06, -1.052991299254235e-08, -4.934065501027860e-11,  3.703028167587436e-13, -9.459670684964341e-16,
 -1.801194299520317e-18,  2.610224603289617e-20, -9.745541768695213e-23, -1.425313327991279e-26,  2.042274717636535e-27,  5.175999082052262e-01, -2.779542289962769e-03,
  8.040774918794248e-06, -4.450683248016899e-09, -8.274656543261355e-11,  4.057394162736836e-13, -3.554891824730776e-16, -5.770462214923368e-18,  3.305321893485637e-20,
 -3.795700112419851e-23, -5.061991629987175e-25,  3.225941975826346e-27,  5.999040867552599e-01, -3.092440437399865e-03,  7.782839495845660e-06,  3.399410426608882e-09,
 -1.131044873637337e-10,  3.620084770103378e-13,  5.971362211343218e-16, -9.280387955441141e-18,  2.594324031721019e-20,  8.705812301650242e-23, -9.363875508244049e-25,
  2.077786168897073e-27,  6.870560648487678e-01, -3.379794078953205e-03,  7.098808213377784e-06,  1.257714175561434e-08, -1.343124824461585e-10,  2.209537889676415e-13,
  1.743852954796231e-15, -1.049691431362522e-17,  5.517482041721872e-22,  2.305410994581534e-22, -8.703127771349434e-25, -2.163452503310864e-27,  7.785921797086748e-01,
 -3.630280432590451e-03,  5.959701679114131e-06,  2.235917885517054e-08, -1.399440830014609e-10, -1.645100351455936e-14,  2.763608446708547e-15, -7.692302151379147e-18,
 -3.854846289157465e-20,  2.970059874937748e-22,  3.039916888115545e-27, -7.380207103088036e-27,  8.739604079707551e-01, -3.832101261747011e-03,  4.363845394218941e-06,
  3.174433541640046e-08, -1.244620869211637e-10, -3.213194230613860e-13,  3.229978781166084e-15, -2.377140813515767e-19, -7.491394885193561e-20,  1.851773376943418e-22,
  1.442035692303250e-24, -8.401706182072093e-27,  9.725060060295381e-01, -3.973344987104553e-03,  2.345234407478875e-06,  3.950140360409533e-08, -8.484296941396081e-11,
 -6.324876107010107e-13,  2.737873486459733e-15,  1.034195781385819e-17, -8.361173545939135e-20, -1.263139457960297e-22,  2.427972567594103e-24, -7.378377635762117e-28,
  1.073455965442313e+00, -4.042517722243598e-03, -1.838342825485133e-08,  4.428141606351618e-08, -2.240922527583954e-11, -8.615035186297072e-13,  1.104378637149642e-15,
  1.991086912996578e-17, -4.419462830256199e-20, -4.953725408578336e-22,  1.647905271351297e-24,  1.266485826267330e-26,  1.175902917039693e+00, -4.029284012701479e-03,
 -2.599242958719154e-06,  4.481028476173475e-08,  5.558702437975786e-11, -9.117747305597559e-13, -1.412491058813332e-15,  2.272436959441209e-17,  3.947312146515945e-20,
 -6.302291919190397e-22, -1.175092799518114e-24,  1.866018317463082e-26,  1.278789609864200e+00, -3.925451111764696e-03, -5.217484852294681e-06,  4.016546638644268e-08,
  1.353880428019494e-10, -7.134276632383793e-13, -4.001331651237038e-15,  1.439287898173422e-17,  1.255840613394938e-19, -2.848631488449941e-22, -4.063307235784087e-24,
  4.506657765726733e-27,  1.380895774795221e+00, -3.726208485408136e-03, -7.646497753236004e-06,  3.011324379200350e-08,  1.981390374040706e-10, -2.673802881836573e-13,
 -5.459086911469342e-15, -4.015976617679438e-18,  1.475530413553596e-19,  4.293584151946959e-22, -3.664076129615945e-24, -2.151683595616110e-26,  1.480830061288519e+00,
 -3.431588058364802e-03, -9.629445042354173e-06,  1.543819516981235e-08,  2.241245011491335e-10,  3.203394080513745e-13, -4.734323673702817e-15, -2.362002315666822e-17,
  6.416309045624216e-20,  9.313675427334265e-22,  9.766689166657071e-25, -2.735212351896087e-26,  1.577030746342386e+00, -3.048031747242517e-03, -1.091028442895890e-05,
 -1.861120228771321e-09,  1.998242770459989e-10,  8.441165150642936e-13, -1.715563667999231e-15, -3.106066327400684e-17, -8.202694880673265e-20,  6.162310164894561e-22,
  5.384730941468867e-24,  3.377994730232061e-27,  1.667779873704865e+00, -2.589837917200963e-03, -1.128019973113653e-05, -1.868270830258919e-08,  1.259856802532584e-10,
  1.070561281261395e-12,  2.252376467666138e-15, -1.855532900384290e-17, -1.690647312934919e-19, -3.448304575394082e-22,  3.629400737479157e-24,  3.218989355363949e-26,
  1.751236024635914e+00, -2.080119991665900e-03, -1.063516644356312e-05, -3.139747771789872e-08,  2.259929507202153e-11,  8.690204548877387e-13,  4.831738076129075e-15,
  6.155594716200810e-18, -1.061530637496087e-19, -9.011746382644988e-22, -2.584646828254171e-24,  1.288418316426448e-26,  1.825490483348688e+00, -1.550789499973302e-03,
 -9.032412026122665e-06, -3.691748002929296e-08, -7.450767569527138e-11,  3.309702344150270e-13,  4.320045881287709e-15,  2.268335984805641e-17,  4.251498531118084e-20,
 -3.823312343066453e-22, -4.362435361602825e-24, -2.168158880834666e-26,  1.888649464326891e+00, -1.041049439875693e-03, -6.725070371511484e-06, -3.400349889220767e-08,
 -1.282093195107680e-10, -2.358301783989614e-13,  1.328925376676531e-15,  1.742200807645600e-17,  1.086515111860204e-19,  4.055894670934092e-22,  1.214752563075480e-25,
 -1.204703073447267e-26,  1.938940836206938e+00, -5.940505721702925e-04, -4.150667643770241e-06, -2.422922436804745e-08, -1.210316182501742e-10, -4.993326015978895e-13,
 -1.441350590314299e-15,  7.704582924119648e-20,  4.027562249939281e-20,  3.710023454272316e-22,  2.288361695113818e-24,  1.039905040542797e-26,  1.974837824658270e+00,
 -2.517875680918373e-04, -1.857033765471468e-06, -1.189032226754349e-08, -6.918275538772759e-11, -3.707492197863154e-13, -1.824320916288158e-15, -8.075001301621784e-18,
 -3.035954702042279e-20, -7.906763126394841e-23,  5.848510696668337e-26,  2.803751075210683e-27,  1.995190130674213e+00, -4.889884080399956e-05, -3.716409629767647e-07,
 -2.500010130794577e-09, -1.568234025014267e-11, -9.382864593886441e-14, -5.415862516473583e-16, -3.034411215018425e-18, -1.655597523713792e-20, -8.808121600638941e-23,
 -4.568688453929447e-25, -2.306640163492961e-27,  8.322839070163267e-04, -5.403149122044160e-06,  2.629819953343168e-08, -1.137347026034100e-10,  4.608589225703477e-13,
 -1.791716733658948e-15,  6.766285674634082e-18, -2.501300264609511e-20,  9.090732197148095e-23, -3.260660411024298e-25,  1.155751587357915e-27, -4.060515364583085e-30,
  7.488493599703835e-03, -4.851390395391828e-05,  2.350454056943110e-07, -1.008394768076036e-09,  4.035518105544940e-12, -1.541082347214186e-14,  5.678855133252129e-17,
 -2.032354004965694e-19,  7.083266963461249e-22, -2.408986722047705e-24,  7.984358266709635e-27, -2.579450913197901e-29,  2.078983057231260e-02, -1.341233290570030e-04,
  6.438114555713307e-07, -2.717152953899561e-09,  1.059634614560657e-11, -3.895043454619809e-14,  1.359456289754070e-16, -4.509560582764031e-19,  1.413118024270258e-21,
 -4.129134634049048e-24,  1.088657131956581e-26, -2.398638221284546e-29,  4.071370725686714e-02, -2.609988855096833e-04,  1.235188743348601e-06, -5.081792703464879e-09,
  1.901429787145217e-11, -6.554885830596229e-14,  2.072471967251505e-16, -5.874039240469100e-19,  1.395820203524184e-21, -2.158280622923196e-24, -2.610350597126022e-27,
  4.296530179210660e-29,  6.722517077945378e-02, -4.272709374567088e-04,  1.983200133705347e-06, -7.872417695333912e-09,  2.771583073408130e-11, -8.622539333271652e-14,
  2.266096207070206e-16, -4.257890357635410e-19, -6.692202134035128e-24,  5.250731078276312e-24, -3.377366737490621e-26,  1.514032385842717e-28,  1.002755756086481e-01,
 -6.304080649649894e-04,  2.853492997709907e-06, -1.079680957046223e-08,  3.482712246941637e-11, -9.137412886761143e-14,  1.549441653040383e-16,  1.456411070248123e-19,
 -2.850724693258055e-21,  1.606021910138837e-23, -6.423490075142861e-26,  1.920666795582023e-28,  1.398007431783454e-01, -8.671847643066863e-04,  3.803655092374058e-06,
 -1.351362618182456e-08,  3.836562630024714e-11, -7.260696355035909e-14, -2.845013757094424e-17,  1.087955539450702e-18, -6.272680529929800e-21,  2.383217628554759e-23,
 -6.009313259998358e-26,  3.031307922433249e-29,  1.857185453194045e-01, -1.133642291590378e-03,  4.783705872609603e-06, -1.565001308542046e-08,  3.647610708348457e-11,
 -2.478964346203835e-14, -3.136158922579307e-16,  2.165993172316912e-18, -8.508811307790744e-21,  1.971832278307790e-23,  8.260089404669015e-27, -3.623837130618248e-28,
  2.379258293683709e-01, -1.425043911567643e-03,  5.736835782739411e-06, -1.682426380458225e-08,  2.770452175529627e-11,  5.195795725946267e-14, -6.518263898995585e-16,
  2.958369303919553e-18, -7.380372940264796e-21, -2.812420397626733e-24,  1.363969974675009e-25, -7.822481864846389e-28,  2.962945820801245e-01, -1.735826583744886e-03,
  6.600488274281024e-06, -1.667413323563837e-08,  1.129689142488260e-11,  1.506151194853043e-13, -9.550899922249322e-16,  2.943419279436247e-18, -1.251538774156268e-21,
 -4.179708950953083e-23,  2.626173794434399e-25, -7.987308138173132e-28,  3.606672071091453e-01, -2.059552262531003e-03,  7.307904518873421e-06, -1.489121753393579e-08,
 -1.249909355856334e-11,  2.563834501236954e-13, -1.106685437121871e-15,  1.667650404903256e-18,  9.735655881331933e-21, -8.209856305942763e-23,  2.746057957051125e-25,
  1.519571860146710e-30,  4.308507675293670e-01, -2.388863651420217e-03,  7.790277712246789e-06, -1.126136405386596e-08, -4.216524183863350e-11,  3.470855500516779e-13,
 -9.852339407353871e-16, -1.021999727909635e-18,  2.260392255895385e-20, -9.637305971769991e-23,  6.485838327315620e-26,  1.560271230169510e-27,  5.066100222264537e-01,
 -2.715451617025971e-03,  7.979689191002129e-06, -5.710226348206353e-09, -7.472957006544519e-11,  3.953869255111576e-13, -5.024859793375051e-16, -4.738256872977809e-18,
  3.135586160251109e-20, -5.543902367794248e-23, -3.698936276385757e-25,  2.953213231108078e-27,  5.876590660919743e-01, -3.030044759273015e-03,  7.813015600813626e-06,
  1.648352023798911e-09, -1.057415568607429e-10,  3.733179887830937e-13,  3.493286339073499e-16, -8.407099133107404e-18,  2.842662776284837e-20,  5.158802420730237e-23,
 -8.336785031340706e-25,  2.550408916246772e-27,  6.736513742119467e-01, -3.322436093309103e-03,  7.236992838916108e-06,  1.046566882805255e-08, -1.294986469943671e-10,
  2.592887161403811e-13,  1.451385364771450e-15, -1.035334743976848e-17,  8.205339157356201e-21,  1.942262629934477e-22, -9.358060017968421e-25, -8.430991617613934e-28,
  7.641680587603145e-01, -3.581567645328616e-03,  6.214577803374548e-06,  2.012096949988473e-08, -1.396279617018282e-10,  4.716145954033783e-14,  2.532558261351053e-15,
 -8.755368492957046e-18, -2.792914515055531e-20,  2.909848878591396e-22, -2.949723467848737e-25, -6.129853199769830e-27,  8.587041886166341e-01, -3.795701085252801e-03,
  4.732630613746697e-06,  2.970573575631242e-08, -1.301151920722857e-10, -2.441441534757669e-13,  3.190838636071631e-15, -2.517901450759335e-18, -6.730024939723705e-20,
  2.352705293416862e-22,  1.058993166709420e-24, -8.901132360731005e-27,  9.566531181208960e-01, -3.952711059478767e-03,  2.810700704435371e-06,  3.804638123152979e-08,
 -9.681375436444017e-11, -5.636096233972622e-13,  2.989439633032835e-15,  7.612250808514882e-18, -8.642706683884249e-20, -3.075495251463601e-23,  2.328222845261909e-24,
 -3.721471342250444e-27,  1.057288955487431e+00, -4.040546676208245e-03,  5.102788620030831e-07,  4.378665447585751e-08, -3.932998101772350e-11, -8.284841842973575e-13,
  1.639499579719396e-15,  1.822506564582107e-17, -6.071531315124696e-20, -4.192067453359502e-22,  2.137000298498338e-24,  9.459316040286162e-27,  1.159747618187657e+00,
 -4.047913339812720e-03, -2.056790328225921e-06,  4.555216993919917e-08,  3.706471844613897e-11, -9.379176409905715e-13, -7.619907954496851e-16,  2.361705805354775e-17,
  1.614055879302897e-20, -6.604065579015709e-22, -3.264245652812603e-25,  1.966813602416758e-26,  1.263007428752416e+00, -3.965227340245200e-03, -4.722989373662867e-06,
  4.221245396661455e-08,  1.201941156477596e-10, -8.041800890791147e-13, -3.543831905530271e-15,  1.821661916536916e-17,  1.124682577126378e-19, -4.415588126731474e-22,
 -3.725650702898075e-24,  1.078860958983157e-26,  1.365870960987181e+00, -3.785881590731476e-03, -7.266317091291621e-06,  3.323354043476255e-08,  1.914749567971818e-10,
 -3.992009641484140e-13, -5.503318868629166e-15,  9.229614760610636e-19,  1.601542925133860e-19,  2.650601578211270e-22, -4.517334568774970e-24, -1.692045011579513e-26,
  1.466950897891120e+00, -3.507821177762500e-03, -9.422479925465243e-06,  1.906904764592460e-08,  2.293428127524368e-10,  1.990425162686645e-13, -5.361859067854172e-15,
 -2.102525042191487e-17,  9.809044308805715e-20,  9.447354925335383e-22, -3.456006668659535e-25, -3.246409742272030e-26,  1.564663991761424e+00, -3.135347737207732e-03,
 -1.091288569094235e-05,  1.468588994637190e-09,  2.162229859756975e-10,  7.922319837172599e-13, -2.618377944263892e-15, -3.328886571153638e-17, -5.595279858764266e-20,
  8.320380963215215e-22,  5.338695840037000e-24, -5.803806243633521e-27,  1.657238669501352e+00, -2.680940371530418e-03, -1.149158203041726e-05, -1.649289829654245e-08,
  1.478921884596025e-10,  1.117761988578417e-12,  1.655436053371559e-15, -2.413319114659374e-17, -1.785178836619098e-19, -1.706757556236461e-22,  5.090143368416190e-24,
  3.379584081921668e-26,  1.742743006269377e+00, -2.166700893029493e-03, -1.100917253844573e-05, -3.089049383281280e-08,  4.115116870091183e-11,  9.866359393314370e-13,
  4.951525928599597e-15,  2.220932174446539e-18, -1.402956769261614e-19, -9.905605040356298e-22, -1.815430412003169e-24,  2.238277100943282e-26,  1.819139973127635e+00,
 -1.624840560554557e-03, -9.482337238794675e-06, -3.805079572670370e-08, -6.679927811849923e-11,  4.424127102225705e-13,  4.971906499225642e-15,  2.378805723927273e-17,
  2.537799918448256e-20, -5.761258817594759e-22, -5.329554931459825e-24, -2.197797214147324e-26,  1.884375031485767e+00, -1.096517390079990e-03, -7.145570016853658e-06,
 -3.609067481538809e-08, -1.325653801090461e-10, -1.976757932027398e-13,  1.867612728113690e-15,  2.113227813873865e-17,  1.231972887966372e-19,  3.981603890435501e-22,
 -5.374687429513841e-25, -1.816512596501171e-26,  1.936496334322736e+00, -6.284526078721092e-04, -4.453373010651402e-06, -2.624749947940200e-08, -1.313632122709145e-10,
 -5.337404964965672e-13, -1.419010714040955e-15,  1.598147429148341e-18,  5.539310875132237e-20,  4.720701780603683e-22,  2.774041628104400e-24,  1.163204751960159e-26,
  1.973800030852059e+00, -2.672339707781725e-04, -2.006611792490397e-06, -1.305902402594500e-08, -7.705446934710938e-11, -4.173585098933222e-13, -2.064445211611843e-15,
 -9.091333250629864e-18, -3.313049370443440e-20, -7.385311557155648e-23,  2.132647706093692e-25,  4.320096581877956e-27,  1.994988392838809e+00, -5.199638194642763e-05,
 -4.032108853853262e-07, -2.766676390080299e-09, -1.769609822081940e-11, -1.079092056841696e-13, -6.344698827661452e-16, -3.618672729017652e-18, -2.008183435691460e-20,
 -1.085559188483252e-22, -5.713409069197147e-25, -2.921611605698918e-27,  8.110836113333095e-04, -5.198100105118863e-06,  2.497647096980563e-08, -1.066390436287080e-10,
  4.265934209534467e-13, -1.637412061182475e-15,  6.104945057003139e-18, -2.228319786317142e-20,  7.995978015690117e-23, -2.832184079195070e-25,  9.911490672587960e-28,
 -3.439722154384315e-30,  7.298123591727114e-03, -4.668086894906786e-05,  2.233221417690537e-07, -9.462200475970528e-10,  3.740482855552337e-12, -1.411370200791696e-14,
  5.140267997107132e-17, -1.818970368814549e-19,  6.270884425424819e-22, -2.111215404260168e-24,  6.930304915398574e-27, -2.220991785670473e-29,  2.026343572811474e-02,
 -1.291004366219437e-04,  6.121977247893071e-07, -2.553670414896845e-09,  9.848967473573972e-12, -3.583428524897176e-14,  1.239301767129391e-16, -4.080326564123646e-19,
  1.272057227058277e-21, -3.714330740513388e-24,  9.864987695888132e-27, -2.242770499825093e-29,  3.968909569078532e-02, -2.513562276295036e-04,  1.175990201605385e-06,
 -4.787787006710747e-09,  1.775175357854089e-11, -6.076731844294145e-14,  1.914134104252047e-16, -5.439975051335238e-19,  1.316667464077060e-21, -2.228230007386859e-24,
 -9.653034996410159e-28,  3.222197919688158e-29,  6.554723040049855e-02, -4.117758028933623e-04,  1.891335878479280e-06, -7.442469019375639e-09,  2.604474407003757e-11,
 -8.092968609799307e-14,  2.147111608972375e-16, -4.232269191075179e-19,  1.595541681651526e-22,  4.025561984655743e-24, -2.766256723287611e-26,  1.269873071150707e-28,
  9.779879187138646e-02, -6.080890324352160e-04,  2.727215037537082e-06, -1.025399221666144e-08,  3.303710573515495e-11, -8.761632480720154e-14,  1.578284683477671e-16,
  6.318894465941553e-20, -2.316814213940405e-21,  1.365489139037205e-23, -5.615553730601581e-26,  1.750500701161639e-28,  1.363918501536601e-01, -8.373938527278834e-04,
  3.645126664887039e-06, -1.291142041491657e-08,  3.690901255942066e-11, -7.294611956113955e-14, -6.718532314878601e-19,  9.004963490925454e-19, -5.457583113209819e-21,
  2.146426144324532e-23, -5.809729715354663e-26,  5.854747227441268e-29,  1.812593399999322e-01, -1.096113963973532e-03,  4.599389791013991e-06, -1.507075059503988e-08,
  3.590980264922115e-11, -3.161876158141222e-14, -2.566730326575216e-16,  1.905103303711264e-18, -7.796581023963984e-21,  1.975879047647560e-23, -5.553430215558921e-27,
 -2.685371923463868e-28,  2.323161751864470e-01, -1.379949180746737e-03,  5.537635865905436e-06, -1.637350048225163e-08,  2.859381395893873e-11,  3.728139102505600e-14,
 -5.723065497428597e-16,  2.721565147364102e-18, -7.391394711378258e-21,  1.989539767687298e-24,  1.045431072540229e-25, -6.666876469364003e-28,  2.894556209532230e-01,
 -1.683819742209294e-03,  6.401578625039658e-06, -1.647050206824843e-08,  1.408661886121603e-11,  1.286761034306829e-13, -8.734470909746756e-16,  2.881253659757336e-18,
 -2.575604190371191e-21, -3.199315926972140e-23,  2.276895687065465e-25, -7.837486023275902e-28,  3.525447885012197e-01, -2.001806824166814e-03,  7.128174578751143e-06,
 -1.505160832149870e-08, -7.633076202834480e-12,  2.304158790915899e-13, -1.056058875229507e-15,  1.934018479281413e-18,  6.977202523465283e-21, -7.118198776283359e-23,
  2.696424366795314e-25, -2.156473488389371e-28,  4.214190859969542e-01, -2.327092924961947e-03,  7.651318372085260e-06, -1.188176728010497e-08, -3.546189598481306e-11,
  3.231750946747293e-13, -1.004240638476995e-15, -3.535580616707376e-19,  1.919652844591013e-20, -9.253752456928159e-23,  1.237503947202406e-25,  1.125465763899905e-27,
  4.958754288987780e-01, -2.651907924290409e-03,  7.904251150572999e-06, -6.843335895777444e-09, -6.695259675591333e-11,  3.818466504622376e-13, -6.214286972150342e-16,
 -3.769409436630925e-18,  2.912415471264703e-20, -6.773508861655661e-23, -2.474739684378537e-25,  2.601745307806489e-27,  5.756639807258730e-01, -2.967489705259747e-03,
  7.822892286887187e-06,  1.659535027105232e-11, -9.820988781519537e-11,  3.789813728357810e-13,  1.268995950162231e-16, -7.473943317486805e-18,  2.971141491612120e-20,
  2.057248382262760e-23, -7.153250580183755e-25,  2.794508812508147e-27,  6.604781679219934e-01, -3.264072616197918e-03,  7.350325988094894e-06,  8.436971327372611e-09,
 -1.239878417637511e-10,  2.906791117067856e-13,  1.166166957300993e-15, -9.986178285004905e-18,  1.451793425037196e-20,  1.563971995570822e-22, -9.475001313945058e-25,
  2.750318499611356e-28,  7.499426971214249e-01, -3.530923102450721e-03,  6.442666745289334e-06,  1.789768535714789e-08, -1.380972569069378e-10,  1.049096474986085e-13,
  2.276451324361139e-15, -9.484274435396536e-18, -1.772738651728272e-20,  2.741978083379788e-22, -5.341544053381083e-25, -4.727610276528225e-27,  8.435993135817484e-01,
 -3.756449900561528e-03,  5.076460651533439e-06,  2.758896222641869e-08, -1.342392079635520e-10, -1.686452994682629e-13,  3.091514010594904e-15, -4.528585489853555e-18,
 -5.816256246673903e-20,  2.697902745549161e-22,  6.678703083326498e-25, -8.782455817863928e-27,  9.408900983455850e-01, -3.928426391908530e-03,  3.257603988295018e-06,
  3.641114869040388e-08, -1.073528339136432e-10, -4.896182654275496e-13,  3.163822944487812e-15,  4.846476883991140e-18, -8.590441599562542e-20,  5.833558113091714e-23,
  2.108501788134302e-24, -6.163637475439637e-27,  1.041138244285662e+00, -4.034374628213591e-03,  1.031403627404403e-06,  4.302712459762868e-08, -5.546604196729152e-11,
 -7.832454545652952e-13,  2.120454237096668e-15,  1.605796121701040e-17, -7.417743607989297e-20, -3.264650456197305e-22,  2.473168035282496e-24,  5.769176929923458e-27,
  1.143526530494568e+00, -4.062172507648907e-03, -1.507227704037357e-06,  4.599437057832904e-08,  1.817725954446312e-11, -9.482337402478510e-13, -9.706448059916685e-17,
  2.375233423786681e-17, -7.660705076980913e-21, -6.561948907312905e-22,  5.333231328923053e-25,  1.916347618744353e-26,  1.247074204214186e+00, -4.000953616131705e-03,
 -4.205446527932466e-06,  4.400245038686596e-08,  1.033033453139533e-10, -8.827202769405550e-13, -2.985969671474367e-15,  2.153353676404957e-17,  9.401994100361386e-20,
 -5.793600439039998e-22, -3.123140524461372e-24,  1.644584160592156e-26,  1.350613771967625e+00, -3.842365489655981e-03, -6.849419679566459e-06,  3.622611056744139e-08,
  1.821752599891942e-10, -5.303838480177573e-13, -5.404548874445302e-15,  6.164348455469222e-18,  1.662806851255811e-19,  7.127437753768145e-23, -5.124240612987583e-24,
 -1.037706065239704e-26,  1.452770391157004e+00, -3.582223065481619e-03, -9.171526254793568e-06,  2.276319421029409e-08,  2.319910975288904e-10,  6.367936939595411e-14,
 -5.901544188493242e-15, -1.734771716905527e-17,  1.314979146657562e-19,  9.012872314845025e-22, -1.848518740959799e-24, -3.543282951021471e-26,  1.551948190841683e+00,
 -3.222520337388499e-03, -1.087399427714233e-05,  5.051179341531609e-09,  2.313627929140470e-10,  7.180326635495369e-13, -3.570739999949488e-15, -3.455956999137896e-17,
 -2.224521421243944e-20,  1.037370699710899e-21,  4.848419330084148e-24, -1.670781659013285e-26,  1.646329848289288e+00, -2.773622748381661e-03, -1.167455510024895e-05,
 -1.394586409438591e-08,  1.705866439208682e-10,  1.148733980498943e-12,  8.991039828888586e-16, -2.990187286222180e-17, -1.806399257499736e-19,  6.251497522794781e-23,
  6.559509002287842e-24,  3.242413396305158e-26,  1.733897726091305e+00, -2.256244282220772e-03, -1.137523582240935e-05, -3.006774500379293e-08,  6.207452745423761e-11,
  1.105678085730415e-12,  4.945410809070185e-15, -2.850993289523022e-18, -1.769969225679545e-19, -1.040308879779803e-21, -5.909703317328032e-25,  3.349523620715483e-26,
  1.812485976919231e+00, -1.702543150344007e-03, -9.945045902308822e-06, -3.904208692383376e-08, -5.670342760721046e-11,  5.698023385257666e-13,  5.645919249381889e-15,
  2.422528855169971e-17,  5.703166594810671e-22, -8.082622869531670e-22, -6.262909475402120e-24, -1.999050645013746e-26,  1.879871838633832e+00, -1.155450644002206e-03,
 -7.591506399003011e-06, -3.824070429519935e-08, -1.360203830696074e-10, -1.452941058515435e-13,  2.516624486897271e-15,  2.529809208475553e-17,  1.369319933191582e-19,
  3.585142964501926e-22, -1.501369989662093e-24, -2.592788652122927e-26,  1.933909223584994e+00, -6.653760259425893e-04, -4.781312084710732e-06, -2.843654071831196e-08,
 -1.423738554826062e-10, -5.670429809002806e-13, -1.346733061367695e-15,  3.665073456025166e-18,  7.451089731668113e-20,  5.935464549492030e-22,  3.305624272617795e-24,
  1.242875882390499e-26,  1.972697966246572e+00, -2.839353094004723e-04, -2.171001728431774e-06, -1.436145366927408e-08, -8.591835486123570e-11, -4.700820707760906e-13,
 -2.334230640862477e-15, -1.019199651787222e-17, -3.558465823836065e-20, -6.094132270756817e-23,  4.479468199247241e-25,  6.468636729213502e-27,  1.994773738650913e+00,
 -5.535985240867631e-05, -4.381838249500609e-07, -3.067942587302123e-09, -2.001515346380464e-11, -1.244287479789198e-13, -7.454098509968112e-16, -4.328494608001561e-18,
 -2.443415216391654e-20, -1.341983125522853e-22, -7.165083231419460e-25, -3.709058436233562e-27,  7.906828904754275e-04, -5.003293416221812e-06,  2.373669994263401e-08,
 -1.000677810270901e-10,  3.952612835343313e-13, -1.498100554293507e-15,  5.515357606336491e-18, -1.988025337867322e-20,  7.044253581413388e-23, -2.464397524267861e-25,
  8.515662927428805e-28, -2.920099759555606e-30,  7.114902766075367e-03, -4.493871399164149e-05,  2.123174849983929e-07, -8.885651768796912e-10,  3.470144343942437e-12,
 -1.293895590212052e-14,  4.657944331562300e-17, -1.629946195545907e-19,  5.558475867311240e-22, -1.852611140058626e-24,  6.022214352933072e-27, -1.914608175894458e-29,
  1.975663877776312e-02, -1.243228055215232e-04,  5.824760431228790e-07, -2.401662619280945e-09,  9.161122850610137e-12, -3.299258109942985e-14,  1.130555739432268e-16,
 -3.693920234884846e-19,  1.145210655597924e-21, -3.338987180365101e-24,  8.914168577708375e-27, -2.078425569048476e-29,  3.870212944858797e-02, -2.421733820860458e-04,
  1.120201614022131e-06, -4.513237211468217e-09,  1.658113693243813e-11, -5.635149300552422e-14,  1.767592502593119e-16, -5.031524470981459e-19,  1.236073478393562e-21,
 -2.241133681853639e-24,  2.583124024115927e-28,  2.372882394690137e-29,  6.392983277660100e-02, -3.969953914221165e-04,  1.804474028044219e-06, -7.038425897775195e-09,
  2.447672467106546e-11, -7.591811899878542e-14,  2.029526126130867e-16, -4.160054754394498e-19,  2.858452676402750e-22,  3.024413571776500e-24, -2.254710088639452e-26,
  1.060770785991497e-28,  9.540930439119050e-02, -5.867546495058559e-04,  2.607281534274030e-06, -9.739210872041565e-09,  3.132275995952451e-11, -8.381514859732808e-14,
  1.586307212575552e-16, -3.502653745287140e-21, -1.863860400903124e-21,  1.155760399093854e-23, -4.883529566860145e-26,  1.576974608178228e-28,  1.330996295283551e-01,
 -8.088426591799303e-04,  3.493684760425575e-06, -1.233254024252814e-08,  3.545187222966114e-11, -7.267871380230482e-14,  2.221004525023062e-17,  7.377740046367837e-19,
 -4.726022957694795e-21,  1.919790900002431e-23, -5.508743556016729e-26,  7.683022972127033e-29,  1.769473427270175e-01, -1.060032524354701e-03,  4.421966220711175e-06,
 -1.450156981837304e-08,  3.522000374326594e-11, -3.716633691394584e-14, -2.067165062801503e-16,  1.666929232477351e-18, -7.091892617210510e-21,  1.932404673064398e-23,
 -1.562668720435921e-26, -1.920166741121004e-28,  2.268837473000612e-01, -1.336426192379429e-03,  5.343921124191887e-06, -1.591075529452002e-08,  2.920812296832177e-11,
  2.443384608763468e-14, -4.993978717342364e-16,  2.486938136390732e-18, -7.251273893799294e-21,  5.616952318310987e-24,  7.761251764759146e-26, -5.589422953661976e-28,
  2.828215211422016e-01, -1.633393677424636e-03,  6.205366226934392e-06, -1.622563971597562e-08,  1.645699588590244e-11,  1.086711580564848e-13, -7.940868619106721e-16,
  2.782097173983907e-18, -3.571639564276968e-21, -2.356477325568006e-23,  1.940287766663393e-25, -7.428369046779137e-28,  3.446504655950755e-01, -1.945505639554609e-03,
  6.946970168600861e-06, -1.513822926469476e-08, -3.273705785552535e-12,  2.057432319689761e-13, -9.991510893990486e-16,  2.118348180801828e-18,  4.606050290461795e-21,
 -6.063533579049595e-23,  2.565788782594105e-25, -3.683964615268450e-28,  4.122322193962895e-01, -2.266461865743975e-03,  7.505541870083744e-06, -1.239876128659749e-08,
 -2.923986789999811e-11,  2.990208967458391e-13, -1.006033694790274e-15,  2.084744547218902e-19,  1.596515313405765e-20, -8.671257909076759e-23,  1.647467386647591e-25,
  7.479306627296829e-28,  4.853937201750809e-01, -2.589020031343540e-03,  7.815952970856543e-06, -7.854326342378736e-09, -5.947282117487380e-11,  3.657688370770573e-13,
 -7.143034796208897e-16, -2.878145232233924e-18,  2.653406941561584e-20, -7.545800298934900e-23, -1.415270313061766e-25,  2.210208377498661e-27,  5.639191524904855e-01,
 -2.904931906695915e-03,  7.813913755846278e-06, -1.494029570208081e-09, -9.061619790801577e-11,  3.796236475183794e-13, -6.898673438733926e-17, -6.516608162591900e-18,
  2.996690189215524e-20, -5.553257522912831e-24, -5.905806822173217e-25,  2.847526010929159e-27,  6.475400768658965e-01, -3.204898307118315e-03,  7.439863327970387e-06,
  6.501101138863885e-09, -1.179167356742700e-10,  3.153692014098302e-13,  8.938524921198865e-16, -9.438793645777924e-18,  1.947151420298400e-20,  1.190175115320522e-22,
 -9.150245044781306e-25,  1.161870433226396e-27,  7.359233948082686e-01, -3.478560063748930e-03,  6.644260239780443e-06,  1.570779195448223e-08, -1.354745191262986e-10,
  1.563026247214915e-13,  2.004402097601760e-15, -9.898118081018889e-18, -8.287134473781620e-21,  2.490944516106287e-22, -7.105701538893414e-25, -3.295354770481670e-27,
  8.286567822579489e-01, -3.714550688605509e-03,  5.394542860291403e-06,  2.541813620599235e-08, -1.368814696702319e-10, -9.617174368686527e-14,  2.940149316654317e-15,
 -6.229979648533126e-18, -4.806103619508949e-20,  2.889303295460428e-22,  2.937820044664288e-25, -8.146122256505759e-27,  9.252312395183976e-01, -3.900647742045240e-03,
  3.683922229135889e-06,  3.461933063075513e-08, -1.163764849780311e-10, -4.123662202511136e-13,  3.261467635915578e-15,  2.146848761079125e-18, -8.235688061419682e-20,
  1.366786499196158e-22,  1.795738448084516e-24, -7.935797398484747e-27,  1.025020495447263e+00, -4.024074355806786e-03,  1.541896803138859e-06,  4.201726163956708e-08,
 -7.058705237407302e-11, -7.272374693863359e-13,  2.535217498060066e-15,  1.351576122292258e-17, -8.409859970589876e-20, -2.235907494735209e-22,  2.642593695442301e-24,
  1.936492075786232e-27,  1.127257225473008e+00, -4.072019096296825e-03, -9.541758684106192e-07,  4.613358810659194e-08, -7.570755645811173e-13, -9.426318446857336e-13,
  5.610563351371666e-16,  2.313496360523454e-17, -3.070064398216218e-20, -6.184706831774707e-22,  1.338734920270207e-24,  1.722399709576777e-26,  1.231006484660358e+00,
 -4.032458338216906e-03, -3.668094635959141e-06,  4.551038582397645e-08,  8.498281735813263e-11, -9.468284017770305e-13, -2.344208475988672e-15,  2.418585500428985e-17,
  7.110179627673413e-20, -6.883955062235234e-22, -2.296066756910734e-24,  2.090984513047226e-26,  1.335137541313672e+00, -3.895373293749996e-03, -6.397590223526482e-06,
  3.904907529832521e-08,  1.702875843405491e-10, -6.574195920772874e-13, -5.157354187407103e-15,  1.148606643455589e-17,  1.650676005938775e-19, -1.405545522556568e-22,
 -5.408785691672884e-24, -2.367359650979096e-27,  1.438296573626017e+00, -3.654439494608447e-03, -8.876080108474631e-06,  2.647738863903687e-08,  2.318115522415654e-10,
 -8.328163333479412e-14, -6.323610945046880e-15, -1.263798237346503e-17,  1.622348236471114e-19,  7.959049166219037e-22, -3.421483782636262e-24, -3.554694528435213e-26,
  1.538884599715471e+00, -3.309205844796958e-03, -1.079071137962895e-05,  8.862883009824312e-09,  2.447878229407622e-10,  6.206782552549358e-13, -4.542502044279502e-15,
 -3.463810467625218e-17,  1.838255666619331e-20,  1.213163137483339e-21,  3.855215186217408e-24, -2.849468499244924e-26,  1.635047572343636e+00, -2.867640438861041e-03,
 -1.182476799532499e-05, -1.103180429577315e-08,  1.937059308772579e-10,  1.159616210694883e-12, -1.835994269543601e-17, -3.559298013303220e-17, -1.733334384158181e-19,
  3.521920531771373e-22,  7.886198500339002e-24,  2.717574297396165e-26,  1.724688486145596e+00, -2.348670813943610e-03, -1.172933907371588e-05, -2.889123435546297e-08,
  8.536506679303097e-11,  1.222735297810351e-12,  4.780643418808884e-15, -9.115583426476429e-18, -2.144865328479474e-19, -1.030968622776856e-21,  1.145566598017884e-24,
  4.550106362407578e-26,  1.805513695814227e+00, -1.783992045991464e-03, -1.041859392708758e-05, -3.985058081245447e-08, -4.389752712443209e-11,  7.134175037588133e-13,
  6.319754185042104e-15,  2.372798106307966e-17, -3.323720845881863e-20, -1.075089238624302e-21, -7.040005433284827e-24, -1.469576017081548e-26,  1.875125613167275e+00,
 -1.218055444838406e-03, -8.063537391385261e-06, -4.043674590863220e-08, -1.382622913409446e-10, -7.588836003713534e-14,  3.288160549960359e-15,  2.987244121103143e-17,
  1.484585815958314e-19,  2.729837395591891e-22, -2.843901609806347e-24, -3.536297506274576e-26,  1.931169001488722e+00, -7.050310753844783e-04, -5.136598292849461e-06,
 -3.080696542199050e-08, -1.540281389979902e-10, -5.978429955880729e-13, -1.207329685438026e-15,  6.417899084661575e-18,  9.839109991131334e-20,  7.367693197725060e-22,
  3.855069577566187e-24,  1.235687081852572e-26,  1.971526363550634e+00, -3.020167775881265e-04, -2.351907719227727e-06, -1.581450368256830e-08, -9.590400018979745e-11,
 -5.296586799766810e-13, -2.635850173815895e-15, -1.136174548031996e-17, -3.738013609818431e-20, -3.651645511620314e-23,  7.951973971209412e-25,  9.480402881377689e-27,
  1.994545047193056e+00, -5.901822403226153e-05, -4.770059788632785e-07, -3.409108512876886e-09, -2.269292012829415e-11, -1.438659824234942e-13, -8.783218469603711e-16,
 -5.193552733802479e-18, -2.982301806739624e-20, -1.664016598286375e-22, -9.010032810931177e-25, -4.718419693734231e-27,  7.710420476941396e-04, -4.818097790409017e-06,
  2.257286569771508e-08, -9.397628933293569e-11,  3.665791523393655e-13, -1.372164985271879e-15,  4.988980490500972e-18, -1.776171063377135e-20,  6.215409637645257e-23,
 -2.148129598112235e-25,  7.329456026061220e-28, -2.484324440633611e-30,  6.938478766008968e-03, -4.328190064103454e-05,  2.019794896190723e-07, -8.350538770476362e-10,
  3.222184752595861e-12, -1.187386551281939e-14,  4.225490951356490e-17, -1.462297085601304e-19,  4.932939023149272e-22, -1.627770122157656e-24,  5.238911042034907e-27,
 -1.652612639458599e-29,  1.926848809894757e-02, -1.197758343649279e-04,  5.545142524960526e-07, -2.260219485686509e-09,  8.527587724456702e-12, -3.039933061439336e-14,
  1.032080614796832e-16, -3.346014812915103e-19,  1.031209367976095e-21, -3.000222470671392e-24,  8.036120792522949e-27, -1.913007185668065e-29,  3.775102239612602e-02,
 -2.334239786709963e-04,  1.067598098379212e-06, -4.256729475918691e-09,  1.549541092644721e-11, -5.227393500940410e-14,  1.632126390609949e-16, -4.648850795983386e-19,
  1.155811064827706e-21, -2.212005570000622e-24,  1.149438931074808e-27,  1.704286001252810e-29,  6.237019712405740e-02, -3.828908996674540e-04,  1.722313423378958e-06,
 -6.658684492418230e-09,  2.300613316453508e-11, -7.118590591850769e-14,  1.914476963606741e-16, -4.052816295450872e-19,  3.795650260187253e-22,  2.210421250365540e-24,
 -1.828228192441753e-26,  8.825377894569611e-29,  9.310327397935558e-02, -5.663554856185603e-04,  2.493363340451214e-06, -9.251250431810959e-09,  2.968448716824015e-11,
 -8.001555659435138e-14,  1.577575764700569e-16, -5.685274597770097e-20, -1.481321881307766e-21,  9.737917654131610e-24, -4.227292902050500e-26,  1.406918605507831e-28,
  1.299192340428926e-01, -7.814756103687526e-04,  3.349049801581801e-06, -1.177690319498019e-08,  3.400521597106670e-11, -7.191424638709362e-14,  4.085136559018430e-17,
  5.971808293754198e-19, -4.073712606797625e-21,  1.706564481887849e-23, -5.144829550887860e-26,  8.749792811410680e-29,  1.727768754177118e-01, -1.025343348266470e-03,
  4.251303142564557e-06, -1.394425051472848e-08,  3.443071581643189e-11, -4.159245103181180e-14, -1.631160239897746e-16,  1.450983318602590e-18, -6.409338624434610e-21,
  1.854909418217611e-23, -2.267417365016632e-26, -1.306413904625810e-28,  2.216223473108243e-01, -1.294430562006400e-03,  5.155810120904669e-06, -1.544014391997149e-08,
  2.958245013188661e-11,  1.325789487934244e-14, -4.329777737197458e-16,  2.258685582777166e-18, -6.998839315260800e-21,  8.259120983406545e-24,  5.520770263717459e-26,
 -4.612304965024216e-28,  2.763860056724637e-01, -1.584524943429474e-03,  6.012306862476838e-06, -1.594594964209680e-08,  1.844607811344251e-11,  9.053421110147040e-14,
 -7.179054544717650e-16,  2.655666308008891e-18, -4.288003722314808e-21, -1.644130777094253e-23,  1.625647077284760e-25, -6.852579674972830e-28,  3.369784431987974e-01,
 -1.890657099292325e-03,  6.765128767556844e-06, -1.515897209198510e-08,  6.062447801443314e-13,  1.824900793109615e-13, -9.380880598267419e-16,  2.232762894656829e-18,
  2.603704639507230e-21, -5.072903398692666e-23,  2.380168465990256e-25, -4.673316335084311e-28,  4.032855076577863e-01, -2.207020178566541e-03,  7.354142819475114e-06,
 -1.282006471063156e-08, -2.350013894456991e-11,  2.750010280292712e-13, -9.935038986891190e-16,  6.707431971463316e-19,  1.296915247257884e-20, -7.956212169096530e-23,
  1.904717179219275e-25,  4.315204101980516e-28,  4.751620762560951e-01, -2.526885042060562e-03,  7.716229983348058e-06, -8.748325625216165e-09, -5.233491981195808e-11,
  3.477518994449682e-13, -7.834193844000848e-16, -2.073428261381890e-18,  2.373804307427897e-20, -7.929225169472039e-23, -5.310609214288644e-26,  1.809566739093857e-27,
  5.524242999005915e-01, -2.842516381530953e-03,  7.787536341386751e-06, -2.883299004336029e-09, -8.305450277777402e-11,  3.758864041913371e-13, -2.380877356756851e-16,
 -5.565181142468009e-18,  2.937180560351272e-20, -2.668972409901130e-23, -4.669534862480103e-25,  2.750580012686291e-27,  6.348399708953323e-01, -3.145098934498887e-03,
  7.506768211951062e-06,  4.665969481617325e-09, -1.114158544593674e-10,  3.337243447104097e-13,  6.388839106901051e-16, -8.754102307441785e-18,  2.311157361393250e-20,
  8.364718528494176e-23, -8.487620397688581e-25,  1.811468498268438e-27,  7.221166048211315e-01, -3.424688602794441e-03,  6.819859557184800e-06,  1.356772714367633e-08,
 -1.318899795046064e-10,  2.010606242982650e-13,  1.724849622944903e-15, -1.002557258394885e-17,  1.374469198937875e-22,  2.181805765037154e-22, -8.251960045357740e-25,
 -1.933486954822711e-27,  8.138867712434343e-01, -3.670211628523869e-03,  5.686368650203844e-06,  2.321641685466743e-08, -1.381142554419724e-10, -2.786554695608403e-14,
  2.745754421241698e-15, -7.599925840016940e-18, -3.753191097427772e-20,  2.937915563502011e-22, -4.322524605971814e-26, -7.119205974593288e-27,  9.096901768949630e-01,
 -3.869546889831367e-03,  4.087923711963703e-06,  3.269559637280899e-08, -1.238377061404746e-10, -3.336624335071955e-13,  3.285517992478306e-15, -3.966870650602323e-19,
 -7.623105570174149e-20,  2.011629949037261e-22,  1.420833789298763e-24, -8.985775871419544e-27,  1.008952033149767e+00, -4.009742635807534e-03,  2.038858656022764e-06,
  4.077493984096172e-08, -8.449429634555419e-11, -6.621617594406814e-13,  2.874918654886101e-15,  1.071631916491957e-17, -9.023469421204154e-20, -1.172802906466749e-22,
  2.646327579229910e-24, -1.711448409489859e-27,  1.110957386254181e+00, -4.077439723902247e-03, -4.012646610896726e-07,  4.597160340790652e-08, -1.942324841354141e-11,
 -9.215243258989668e-13,  1.191816293831913e-15,  2.180807199775452e-17, -5.182664778390665e-20, -5.506136469881298e-22,  2.031137346264760e-24,  1.407437646963171e-26,
  1.214821451294993e+00, -4.059596939337141e-03, -3.114445824681123e-06,  4.671579608538996e-08,  6.553972222557051e-11, -9.947293406575669e-13, -1.638992181989605e-15,
  2.604873061906803e-17,  4.489709836312054e-20, -7.608762817425588e-22, -1.307401734458349e-24,  2.372974468946170e-26,  1.319456718443456e+00, -3.944634384085593e-03,
 -5.913109068978573e-06,  4.166188433461717e-08,  1.559305373908930e-10, -7.767460603265985e-13, -4.762852856320245e-15,  1.664546280676448e-17,  1.561113965978692e-19,
 -3.564355938879213e-22, -5.321296892176353e-24,  6.401839048221880e-27,  1.423538899427963e+00, -3.724114348794382e-03, -8.536179515213444e-06,  3.016469299484028e-08,
  2.286027305136778e-10, -2.386825614592228e-13, -6.600691676473460e-15, -7.017463186109617e-18,  1.880528707274691e-19,  6.284583111005847e-22, -4.927496071027569e-24,
 -3.233909989334622e-26,  1.525475893725215e+00, -3.395038631845259e-03, -1.066046758936843e-05,  1.287254524293831e-08,  2.560331467807576e-10,  5.001276285166729e-13,
 -5.497370984050275e-15, -3.332397834530789e-17,  6.449854339044005e-20,  1.338849612553713e-21,  2.345368412424033e-24, -3.996870119495179e-26,  1.623387052587787e+00,
 -2.962713660683021e-03, -1.193778956098199e-05, -7.747344699096658e-09,  2.168099423908674e-10,  1.146603504287357e-12, -1.090263805980328e-15, -4.087371251188737e-17,
 -1.547107815665321e-19,  6.890179680774196e-22,  8.883843147304622e-24,  1.738882995968008e-26,  1.715103973011803e+00, -2.443867187913994e-03, -1.206701191249054e-05,
 -2.732362284939079e-08,  1.109423006501164e-10,  1.333598443447421e-12,  4.423824287480090e-15, -1.656001920953127e-17, -2.502620029343754e-19, -9.415914421260265e-22,
  3.408548050891581e-24,  5.717853786957996e-26,  1.798207986125124e+00, -1.869264426367931e-03, -1.090051689827824e-05, -4.043033023558300e-08, -2.805940104606755e-11,
  8.729062864930329e-13,  6.963034889267060e-15,  2.198966839019319e-17, -7.714290630906367e-20, -1.367120973829588e-21, -7.490957441893476e-24, -4.982137518317194e-27,
  1.870121248389030e+00, -1.284542401157862e-03, -8.562086918856227e-06, -4.265650279460926e-08, -1.389203394970945e-10,  1.360967648376889e-14,  4.192400676596315e-15,
  3.475517163474429e-17,  1.558352317580875e-19,  1.249963961077417e-22, -4.634747604335056e-24, -4.623833005846007e-26,  1.928264289927762e+00, -7.476454103407310e-04,
 -5.521468072337160e-06, -3.336857705931461e-08, -1.662582555477509e-10, -6.242811137708868e-13, -9.793436419912636e-16,  1.002160072821440e-17,  1.278187011034458e-19,
  9.015160834699688e-22,  4.370806641045843e-24,  1.076844240635934e-26,  1.970279426097125e+00, -3.216180493658047e-04, -2.551249557421720e-06, -1.743726083188023e-08,
 -1.071562491163808e-10, -5.968727709970003e-13, -2.970874159619207e-15, -1.257192242881072e-17, -3.801150449844125e-20,  4.767216352708647e-24,  1.299366954554035e-24,
  1.365782071082704e-26,  1.994301074096947e+00, -6.300430791709885e-05, -5.201926028550018e-07, -3.796410580004941e-09, -2.579339775798699e-11, -1.668043748102818e-13,
 -1.038054647219270e-15, -6.251119488409856e-18, -3.651545272771234e-20, -2.069518326361345e-22, -1.135923721852983e-24, -6.012824448577141e-27,  7.521238182544916e-04,
 -4.641928061433355e-06,  2.147945681642818e-08, -8.832422880014336e-11,  3.402940563256163e-13, -1.258179587467209e-15,  4.518374196773289e-18, -1.589106046751926e-20,
  5.492323857292621e-23, -1.875689580719505e-25,  6.319194421310132e-28, -2.118243128729755e-30,  6.768520585150467e-03, -4.170528857300296e-05,  1.922605108362906e-07,
 -7.853449997807528e-10,  2.994525965705584e-12, -1.090714985042992e-14,  3.837294416667361e-17, -1.313428356791645e-19,  4.382972352663777e-22, -1.432071544469478e-24,
  4.562333928850585e-27, -1.428506303770652e-29,  1.879808842760278e-02, -1.154459367245617e-04,  5.281906309371045e-07, -2.128510511257719e-09,  7.943631026453775e-12,
 -2.803113200512173e-14,  9.428539751000145e-17, -3.032704884597633e-19,  9.287888809983137e-22, -2.695132918104839e-24,  7.230110414850861e-27, -1.751686741139806e-29,
  3.683409038677214e-02, -2.250833802423486e-04,  1.017971080816577e-06, -4.016958252868142e-09,  1.448807018909955e-11, -4.850892687431439e-14,  1.507017600825988e-16,
 -4.291630001138237e-19,  1.077172108717569e-21, -2.152666990163629e-24,  1.779348336516618e-27,  1.180130325739765e-29,  6.086569317385870e-02, -3.694258580675216e-04,
  1.644571613750113e-06, -6.301730291631153e-09,  2.162745070209443e-11, -6.672589466199905e-14,  1.802808550141616e-16, -3.919961709206024e-19,  4.468702421662572e-22,
  1.552156454344165e-24, -1.474114940624013e-26,  7.311859838328905e-29,  9.087705399546750e-02, -5.468446850253560e-04,  2.385145900436271e-06, -8.788896043865373e-09,
  2.812188256275772e-11, -7.625352119278308e-14,  1.555525109877469e-16, -9.896053514937246e-20, -1.159745657018226e-21,  8.165967951236387e-24, -3.644270044807644e-26,
  1.244747356552023e-28,  1.268460342679560e-01, -7.552393628271013e-04,  3.210944188040293e-06, -1.124426732141024e-08,  3.257801600545582e-11, -7.074733773891760e-14,
  5.583697731499213e-17,  4.762623027799734e-19, -3.495447152373479e-21,  1.508652587484812e-23, -4.747181373178298e-26,  9.244232075160258e-29,  1.687424762482722e-01,
 -9.919929465314896e-04,  4.087249381842767e-06, -1.340021315289230e-08,  3.356289259716156e-11, -4.504227088340112e-14, -1.252607956304448e-16,  1.256383394391566e-18,
 -5.759142782325515e-21,  1.754227455716219e-23, -2.731468810545672e-26, -8.226334102091167e-29,  2.165259559555322e-01, -1.253917144932155e-03,  4.973375288054999e-06,
 -1.496524700666689e-08,  2.974868648661210e-11,  3.600327878703504e-15, -3.728225424935518e-16,  2.039868077340804e-18, -6.666411235049870e-21,  1.008786183693289e-23,
  3.686018800490455e-26, -3.746186540169230e-28,  2.701428981735873e-01, -1.537186745124966e-03,  5.822783078810491e-06, -1.563723807081015e-08,  2.009040578134892e-11,
  7.418077517836380e-14, -6.455481923017831e-16,  2.510177160221224e-18, -4.769936478412442e-21, -1.052251237115192e-23,  1.338632488772716e-25, -6.183182604076230e-28,
  3.295229053686563e-01, -1.837263265370123e-03,  6.583395841360811e-06, -1.512127562532732e-08,  4.036010871554621e-12,  1.607339664291015e-13, -8.746659231201656e-16,
  2.288657586855917e-18,  9.436964230371398e-22, -4.163876514032426e-23,  2.160932841246472e-25, -5.228602695129095e-28,  3.945741104202024e-01, -2.148808381535033e-03,
  7.198223353132419e-06, -1.315335510251810e-08, -1.823680674308692e-11,  2.514266074769404e-13, -9.693328243447558e-16,  1.041431024121902e-18,  1.024589871648517e-20,
 -7.164316092621579e-23,  2.036118055993704e-25,  1.754575426677958e-28,  4.651773114866517e-01, -2.465588835068063e-03,  7.606452080343270e-06, -9.531083845801177e-09,
 -4.557217262797234e-11,  3.283363505800248e-13, -8.312719171524510e-16, -1.359744397853694e-18,  2.086342058671022e-20, -7.993950483518836e-23,  1.792634556448255e-26,
  1.423034495443952e-27,  5.411785846827004e-01, -2.780376510901884e-03,  7.745210460223311e-06, -4.152390772818504e-09, -7.560599289911228e-11,  3.684075952358157e-13,
 -3.809230286333082e-16, -4.644027902629725e-18,  2.810345594654327e-20, -4.300144893586667e-23, -3.501390964684744e-25,  2.544356428525967e-27,  6.223799959538251e-01,
 -3.084850615114476e-03,  7.552286656396452e-06,  2.937463007898629e-09, -1.046074468544975e-10,  3.462023038405404e-13,  4.045299599934049e-16, -7.972738995278358e-18,
  2.553228043724904e-20,  5.143135993857895e-23, -7.589406550857601e-25,  2.235931008145258e-27,  7.085279490851352e-01, -3.369514029756913e-03,  6.970150570087922e-06,
  1.149181103156834e-08, -1.274775085831979e-10,  2.390959459622683e-13,  1.445329687973271e-15, -9.902016771803555e-18,  7.380700163306625e-21,  1.838419222086427e-22,
 -8.828688331892368e-25, -7.166932397892016e-28,  7.992986180125599e-01, -3.623643877852980e-03,  5.951699687448719e-06,  2.100563607579865e-08, -1.380304819688957e-10,
  3.535301465544514e-14,  2.517726378627424e-15, -8.632648016917052e-18, -2.705874925154875e-20,  2.861607911563802e-22, -3.289706555817519e-25, -5.838624587323170e-27,
  8.942798327930312e-01, -3.835308274736405e-03,  4.468176087407295e-06,  3.066508275430657e-08, -1.297247250233306e-10, -2.552118757332458e-13,  3.241421608894741e-15,
 -2.710025479798850e-18, -6.806293686948914e-20,  2.499377666400462e-22,  1.015390216353122e-24, -9.332279471636020e-27,  9.929487494989488e-01, -3.991498533542652e-03,
  2.519621863087087e-06,  3.932093021807187e-08, -9.702494666098840e-11, -5.898924926915744e-13,  3.134060235596275e-15,  7.781478495704064e-18, -9.257856274224725e-20,
 -1.391240397891307e-23,  2.498843089542843e-24, -4.896790703909431e-27,  1.094644691674550e+00, -4.078449876954615e-03,  1.479273347891765e-07,  4.551514568197634e-08,
 -3.751928243775552e-11, -8.857983540479095e-13,  1.776362533146125e-15,  1.984929068135092e-17, -7.004730145224702e-20, -4.581162646387483e-22,  2.564395637659776e-24,
  1.005307408706809e-26,  1.198536805962790e+00, -4.082253845550292e-03, -2.548227218893546e-06,  4.760338827815790e-08,  4.531158629477772e-11, -1.025176051176308e-12,
 -8.936916799736807e-16,  2.703914945047486e-17,  1.681983985205785e-20, -7.918802670339563e-22, -2.362115424297370e-25,  2.463305648933573e-26,  1.303586795736125e+00,
 -3.989898293260683e-03, -5.398729438994091e-06,  4.402645125774951e-08,  1.392931452086118e-10, -8.849104632405779e-13, -4.229059949241943e-15,  2.139534673675111e-17,
  1.395399049123637e-19, -5.610634304363670e-22, -4.846820674280744e-24,  1.507491111370501e-26,  1.408508242911551e+00, -3.790894118709288e-03, -8.152442901489603e-06,
  3.377548585283371e-08,  2.222325955482972e-10, -3.987575522892005e-13, -6.709818599545944e-15, -6.785052477803961e-19,  2.068017790623051e-19,  4.046097754511689e-22,
 -6.216553959370646e-24, -2.570217782763568e-26,  1.511726249288261e+00, -3.479634137308335e-03, -1.048111185648854e-05,  1.704161496798082e-08,  2.646421479405858e-10,
  3.572721891285523e-13, -6.394192923524041e-15, -3.047436615304704e-17,  1.139340162831785e-19,  1.394454672682225e-21,  3.640309985459402e-25, -4.967184073666669e-26,
  1.611344690052656e+00, -3.058527145783130e-03, -1.200919287660940e-05, -4.096749628906316e-09,  2.393848626444452e-10,  1.106169575739870e-12, -2.299812704164703e-15,
 -4.535773253323708e-17, -1.233606363921883e-19,  1.055734563889466e-21,  9.346057413251919e-24,  2.851628253024475e-27,  1.705133400794762e+00, -2.541682577106820e-03,
 -1.238334653542149e-05, -2.532957594448698e-08,  1.386336232458476e-10,  1.433270857491565e-12,  3.843147507071889e-15, -2.507933894711084e-17, -2.810707432030486e-19,
 -7.518881546643491e-22,  6.146710439417143e-24,  6.676645380568651e-26,  1.790553438494226e+00, -1.958415462737312e-03, -1.138776847499523e-05, -4.073033212870011e-08,
 -8.881916550635590e-12,  1.047081153819591e-12,  7.536373075785506e-15,  1.867560845008495e-17, -1.317695482334897e-19, -1.667104483491301e-21, -7.397799969830424e-24,
  1.019014039568165e-26,  1.864842790228141e+00, -1.355124337086482e-03, -9.087273685350415e-06, -4.487124274070876e-08, -1.375602201701707e-10,  1.264713069604207e-13,
  5.235757003142221e-15,  3.977393392023805e-17,  1.564767937911114e-19, -1.044922786869907e-22, -6.924766658953833e-24, -5.789991622546279e-26,  1.925182763681323e+00,
 -7.934650255592714e-04, -5.938267670302468e-06, -3.612976707331340e-08, -1.789536709118382e-10, -6.439246945247264e-13, -6.363513632191404e-16,  1.466568754708516e-17,
  1.635259614157122e-19,  1.084852554910833e-21,  4.766761373999843e-24,  6.731301246989094e-27,  1.968950766298346e+00, -3.428951138649506e-04, -2.771190505282521e-06,
 -1.925125663279048e-08, -1.198359357360648e-10, -6.725348183873931e-13, -3.339812572293063e-15, -1.377424714742806e-17, -3.674553741194186e-20,  7.031967047830595e-23,
  2.019936618570351e-24,  1.938825245448624e-26,  1.994040435006038e+00, -6.735535489443527e-05, -5.683403401515780e-07, -4.237209244913575e-09, -2.939350870633987e-11,
 -1.939573132442066e-13, -1.230630589083566e-15, -7.548131963954692e-18, -4.485147061772294e-20, -2.581388852493075e-22, -1.435503165261033e-24, -7.672201461466896e-27,
  7.338931928752792e-04, -4.474241284791158e-06,  2.045142258239076e-08, -8.307508846101216e-11,  3.161798340083295e-13, -1.154885469917548e-15,  4.097048744594032e-18,
 -1.423685470618019e-20,  4.860414382256123e-23, -1.640617214053188e-25,  5.456842450789234e-28, -1.810287492526805e-30,  6.604717041253978e-03, -4.020410279510570e-05,
  1.831168053508883e-07, -7.391289124542059e-10,  2.785302582988817e-12, -1.002879190738479e-14,  3.488419572303574e-17, -1.181081700646677e-19,  3.898814371109407e-22,
 -1.261562977590883e-24,  3.977050631908329e-27, -1.236815053638272e-29,  1.834459695916963e-02, -1.113204613365932e-04,  5.033929833492643e-07, -2.005777275637512e-09,
  7.404966048207272e-12, -2.586691054056196e-14,  8.619572454170286e-17, -2.750473043683578e-19,  8.367882150147957e-22, -2.420884572054361e-24,  6.493500774036856e-27,
 -1.598033483716430e-29,  3.594974458205955e-02, -2.171285573136883e-04,  9.711270461961249e-07, -3.792718059514569e-09,  1.355310656054471e-11, -4.503245943753065e-14,
  1.391562223827649e-16, -3.959187546406545e-19,  1.001070583411063e-21, -2.072387345471415e-24,  2.204840941105992e-27,  7.706865605208546e-30,  5.941383212903033e-02,
 -3.565659854593556e-04,  1.570983797808539e-06, -5.966135839418102e-09,  2.033531972262076e-11, -6.252920125864396e-14,  1.695127842876748e-16, -3.769100280809595e-19,
  4.928735393662734e-22,  1.022925858840543e-24, -1.181370075306297e-26,  6.030030846966826e-29,  8.872718028131858e-02, -5.281778502723976e-04,  2.282329175617339e-06,
 -8.350944659948456e-09,  2.663389974260154e-11, -7.255744347471095e-14,  1.523042990621761e-16, -1.316396971575541e-19, -8.907311650009365e-22,  6.813251260715189e-24,
 -3.130362355464614e-26,  1.093064930093448e-28,  1.238756097281426e-01, -7.300827799751471e-04,  3.079094024187267e-06, -1.073426151502566e-08,  3.117748704769101e-11,
 -6.925937675326610e-14,  6.768544315127680e-17,  3.727393401217452e-19, -2.985526850596579e-21,  1.326947850454145e-23, -4.337539886605258e-26,  9.316882607788239e-29,
  1.648388948326760e-01, -9.599291020688754e-04,  3.929638636492278e-06, -1.287056538125575e-08,  3.263472888743523e-11, -4.764663439311041e-14, -9.256875862744183e-17,
  1.081977943244816e-18, -5.148051580068757e-21,  1.638903404307657e-23, -3.007519533309649e-26, -4.486931509285073e-29,  2.115887354484873e-01, -1.214840380432699e-03,
  4.796649051318295e-06, -1.448915914077071e-08,  2.973571893141142e-11, -4.685778246343121e-15, -3.186363441506611e-16,  1.832607236468717e-18, -6.280470703628649e-21,
  1.125557713535136e-23,  2.207373272871462e-26, -2.993517253651533e-28,  2.640861351488830e-01, -1.491349495928448e-03,  5.637111197970481e-06, -1.530474086667935e-08,
  2.142469230505514e-11,  5.951347563027129e-14, -5.774500455091795e-16,  2.352459670979993e-18, -5.058733831462042e-21, -5.691402905731099e-24,  1.082078201422239e-25,
 -5.475918950799323e-28,  3.222780392864268e-01, -1.785320585060475e-03,  6.402430440372341e-06, -1.503210074886564e-08,  7.045973025828089e-12,  1.405130590764271e-13,
 -8.103744533304981e-16,  2.296494629660422e-18, -4.053381707072331e-22, -3.346370200470160e-23,  1.925022823745919e-25, -5.446340397854856e-28,  3.860930423033681e-01,
 -2.091858542158247e-03,  7.038794234182755e-06, -1.340616921219934e-08, -1.343837093766810e-11,  2.285472630494865e-13, -9.359590504918071e-16,  1.329616477910955e-18,
  7.814628184199568e-21, -6.340697069540160e-23,  2.067439333447982e-25, -2.424203953204649e-29,  4.554359181666212e-01, -2.405206614111025e-03,  7.487917304143705e-06,
 -1.020880039179429e-08, -3.920765613768031e-11,  3.080017413320893e-13, -8.604289163726331e-16, -7.379057121102975e-19,  1.801261204801635e-20, -7.807767251032431e-23,
  7.256851921591874e-26,  1.066655444048226e-27,  5.301806581260212e-01, -2.718634150267032e-03,  7.688365019184116e-06, -5.303680569668121e-09, -6.833927638381372e-11,
  3.578051495669915e-13, -4.986162112028662e-16, -3.771974816959801e-18,  2.632958309248391e-20, -5.484580403918739e-23, -2.441084811352946e-25,  2.266174713678631e-27,
  6.101616138554538e-01, -3.024319247579798e-03,  7.577723896503700e-06,  1.319589514353368e-09, -9.760391209948544e-11,  3.533260135028872e-13,  1.929694437848020e-16,
 -7.131743124239944e-18,  2.686182998916117e-20,  2.312081715016921e-23, -6.549584045846463e-25,  2.459985882472258e-27,  6.951622402955089e-01, -3.313235516944151e-03,
  7.095978113790379e-06,  9.492217244377957e-09, -1.223710053232998e-10,  2.704893399189447e-13,  1.172325869012241e-15, -9.566799625643992e-18,  1.335865121282370e-20,
  1.482128621272128e-22, -8.911271893575403e-25,  3.067764336100848e-28,  7.849008132179949e-01, -3.575059479460830e-03,  6.190550133429191e-06,  1.880600413961323e-08,
 -1.367392118406746e-10,  9.278944963121143e-14,  2.265417719058994e-15, -9.336717213564621e-18, -1.705202688424726e-20,  2.682720460001752e-22, -5.552416890742799e-25,
 -4.436611751630896e-27,  8.790123707664498e-01, -3.798126587796566e-03,  4.823548677868865e-06,  2.855284994931649e-08, -1.340584034129387e-10, -1.785658669397698e-13,
  3.136452604845678e-15, -4.737038068010556e-18, -5.843276277943879e-20,  2.823815261080147e-22,  6.088519613243374e-25, -9.052144360863532e-27,  9.770260192994261e-01,
 -3.969481414514488e-03,  2.981782727963592e-06,  3.767830314485287e-08, -1.080547032614743e-10, -5.123950187675698e-13,  3.310525998740477e-15,  4.829771990526964e-18,
 -9.133949901763636e-20,  8.093719415006375e-23,  2.225276269489011e-24, -7.415828465845227e-27,  1.078336701992694e+00, -4.075093266973553e-03,  6.899306132387357e-07,
  4.477561002326964e-08, -5.476527538672103e-11, -8.367640936134288e-13,  2.298427931589386e-15,  1.736448697424157e-17, -8.459832748347567e-20, -3.479951277779043e-22,
  2.908928361126431e-24,  5.565634292943275e-27,  1.182170652139817e+00, -4.100343940470322e-03, -1.973316333179024e-06,  4.816343828610391e-08,  2.465510654087712e-11,
 -1.037505030667064e-12, -1.333466195613417e-16,  2.712155002957020e-17, -1.159805263381061e-20, -7.798264442791668e-22,  8.310751921086463e-25,  2.356091486724546e-26,
  1.287544220573705e+00, -4.030938351222038e-03, -4.857641208574822e-06,  4.610825372252932e-08,  1.206310099658799e-10, -9.787344554154896e-13, -3.570771387123693e-15,
  2.550147428016275e-17,  1.160334402256113e-19, -7.393080929140030e-22, -4.009375417733030e-24,  2.275562169859994e-26,  1.393216878753841e+00, -3.854432654268223e-03,
 -7.726094249262324e-06,  3.725866371921575e-08,  2.126494645963430e-10, -5.592616900282583e-13, -6.634334014954949e-15,  6.122158318489478e-18,  2.166431270326077e-19,
  1.359914448818616e-22, -7.143347054211660e-24, -1.596419072264968e-26,  1.497641412380663e+00, -3.562592564503587e-03, -1.025099881365599e-05,  2.132443274801238e-08,
  2.701861956110813e-10,  1.940305345628677e-13, -7.188891343440839e-15, -2.602687164394433e-17,  1.638495039029800e-19,  1.363133607749181e-21, -1.976744733961537e-24,
 -5.605552556873464e-26,  1.598918217143882e+00, -3.154730560376554e-03, -1.203465376596323e-05, -9.304300612674802e-11,  2.608512808303305e-10,  1.035325498601256e-12,
 -3.618866829498900e-15, -4.862508224461162e-17, -7.864220575468639e-20,  1.426822156166970e-21,  9.070969520549502e-24, -1.598679107724976e-26,  1.694766668041061e+00,
 -2.641925250819830e-03, -1.267303112374766e-05, -2.287736051415536e-08,  1.681591637169900e-10,  1.516040218320727e-12,  3.011309317738184e-15, -3.445336795269090e-17,
 -3.029867173310399e-19, -4.453199503594589e-22,  9.220281895517884e-24,  7.202300984110504e-26,  1.782534475611590e+00, -2.051473426103909e-03, -1.187666175376330e-05,
 -4.069491388903570e-08,  1.390808716446489e-11,  1.233695164886269e-12,  7.990834547337087e-15,  1.344283631252644e-17, -1.969514809750038e-19, -1.948228113411189e-21,
 -6.502964506941869e-24,  3.152985246065061e-26,  1.859273433774922e+00, -1.430013524086000e-03, -9.638827733506907e-06, -4.704475466386182e-08, -1.336811029487537e-10,
  2.660538226376687e-13,  6.418552239800948e-15,  4.466235759633337e-17,  1.470843342510563e-19, -4.358175059497900e-22, -9.723083569499804e-24, -6.906854101173781e-26,
  1.921911075419536e+00, -8.427550545583899e-04, -6.389431697708124e-06, -3.909673283034939e-08, -1.919484134115993e-10, -6.536407318200496e-13, -1.463160827765859e-16,
  2.056066037195172e-17,  2.060667561347751e-19,  1.279481872571208e-21,  4.908294031009865e-24, -1.040751720438650e-27,  1.967533336298091e+00, -3.660223448085341e-04,
 -3.014168179028403e-06, -2.128072577668216e-08, -1.341201017181429e-10, -7.574483988186734e-13, -3.741451476848340e-15, -1.489221388358601e-17, -3.253506796919333e-20,
  1.702982963195056e-22,  3.035481516141580e-24,  2.715302436397032e-26,  1.993761586423735e+00, -7.211376430379060e-05, -6.221420415509017e-07, -4.740218186686644e-09,
 -3.358600159550679e-11, -2.261998025623175e-13, -1.463551793593047e-15, -9.143843882990128e-18, -5.526467497602212e-20, -3.228982078225096e-22, -1.817920456274826e-24,
 -9.796457849049764e-27,  7.163172559322939e-04, -4.314533228839315e-06,  1.948412950358029e-08, -7.819578268180995e-11,  2.940340128145058e-13, -1.061169441148476e-15,
  3.719332723097710e-18, -1.277195994744572e-20,  4.307234855941314e-23, -1.437478413607487e-25,  4.718972515805837e-28, -1.551013298824818e-30,  6.446775374985914e-03,
 -3.877390389149970e-05,  1.745081727852659e-07, -6.961242883928498e-10,  2.592838194426519e-12, -9.229886636623090e-15,  3.174521914756677e-17, -1.063289556121615e-19,
  3.472020911545164e-22, -1.112863825748310e-24,  3.469836944339182e-27, -1.072956440660536e-29,  1.790721975505786e-02, -1.073876192285006e-04,  4.800178176863273e-07,
 -1.891326690354094e-09,  6.907706306594467e-12, -2.388768198926413e-14,  7.885652887644004e-17, -2.496157305923335e-19,  7.541461688280722e-22, -2.174776786621006e-24,
  5.822343457126592e-27, -1.454514829731007e-29,  3.509648525458185e-02, -2.095379722548496e-04,  9.268863839406395e-07, -3.582895793239507e-09,  1.268497533917350e-11,
 -4.182218724272319e-14,  1.285078860093188e-16, -3.650605672938590e-19,  9.281246582370352e-22, -1.978409261736886e-24,  2.470838710068773e-27,  4.514925163538789e-30,
  5.801225818687578e-02, -3.442790520161710e-04,  1.501301795451956e-06, -5.650557907101181e-09,  1.912457327747400e-11, -5.858572308376959e-14,  1.591850257599585e-16,
 -3.606350831535760e-19,  5.218019268485161e-22,  6.001183946839090e-25, -9.405605644390547e-27,  4.945784143668729e-29,  8.665036155887462e-02, -5.103129267938458e-04,
  2.184627445936373e-06, -7.936214158554699e-09,  2.521898963106673e-11, -6.894937389517672e-14,  1.482545435832034e-16, -1.564511717518805e-19, -6.668720945971045e-22,
  5.653089938190302e-24, -2.680636787446235e-26,  9.531251459063765e-29,  1.210037401428560e-01, -7.059568967418673e-04,  2.953230508718434e-06, -1.024641160093634e-08,
  2.980933542838354e-11, -6.752005174237133e-14,  7.685410200182679e-17,  2.845188350790217e-19, -2.538072108752807e-21,  1.161595625975267e-23, -3.931768978634408e-26,
  9.085210422471353e-29,  1.610610869149403e-01, -9.291009766263044e-04,  3.778292975454522e-06, -1.235614391780301e-08,  3.166193969959037e-11, -4.952281858735791e-14,
 -6.449268087938421e-17,  9.264448798242003e-19, -4.580093999542135e-21,  1.515545746269783e-23, -3.139823141414014e-26, -1.664236485706027e-29,  2.068050305413118e-01,
 -1.177154589282256e-03,  4.625629378809685e-06, -1.401453582149194e-08,  2.956957123665445e-11, -1.173962477428225e-14, -2.700750056168539e-16,  1.638261225706112e-18,
 -5.862370508134571e-21,  1.189478417683913e-23,  1.035435040100447e-26, -2.351217822275623e-28,  2.582097761243491e-01, -1.446981320711809e-03,  5.455547978171764e-06,
 -1.495315456438230e-08,  2.248161394935697e-11,  4.642664800954332e-14, -5.138726004053643e-16,  2.188091427270235e-18, -5.191331243400311e-21, -1.824111354712668e-24,
  8.566990041022099e-26, -4.771832634880511e-28,  3.152380563722996e-01, -1.734820559046035e-03,  6.222811020036595e-06, -1.489791799677122e-08,  9.666940679574940e-12,
  1.218331675227317e-13, -7.464249772785148e-16,  2.265687895175558e-18, -1.477213074364445e-21, -2.624344730222770e-23,  1.685360886350386e-25, -5.412315046300684e-28,
  3.778372052613865e-01, -2.036195000116656e-03,  6.876777043480927e-06, -1.358582293583054e-08, -9.088902981633058e-12,  2.065572024574525e-13, -8.955606414636543e-16,
  1.544753238579861e-18,  5.680138235714906e-21, -5.520592337085651e-23,  2.022216442741036e-25, -1.735712885762637e-28,  4.459341080704896e-01, -2.345803501736290e-03,
  7.361847394704849e-06, -1.078797049677203e-08, -3.325547214260691e-11,  2.871660696439440e-13, -8.734386852846917e-16, -2.058286562128540e-19,  1.526449414756629e-20,
 -7.433252418032786e-23,  1.123839144373999e-25,  7.502550198021492e-28,  5.194287067547657e-01, -2.657399855595933e-03,  7.618394233013651e-06, -6.340544583708922e-09,
 -6.131091204672384e-11,  3.446642976944538e-13, -5.927450111433237e-16, -2.962714267700546e-18,  2.420257562202903e-20, -6.270758968526515e-23, -1.513000290973602e-25,
  1.948159591039288e-27,  5.981856439661017e-01, -2.963660126014741e-03,  7.584422824100100e-06, -1.853554234781218e-10, -9.050674934017221e-11,  3.556587404368433e-13,
  5.405052784796590e-18, -6.263689673885796e-18,  2.724896524013387e-20, -8.852684720870474e-25, -5.449432054492759e-25,  2.515839190328655e-27,  6.820235088496223e-01,
 -3.256044929892228e-03,  7.198320332454109e-06,  7.578998020384366e-09, -1.167012881431130e-10,  2.954637061203335e-13,  9.111934650048928e-16, -9.060789799715942e-18,
  1.805829189146008e-20,  1.130911767757873e-22, -8.590840761460116e-25,  1.113094958518923e-27,  7.707010010603274e-01, -3.524669423473137e-03,  6.403165783638114e-06,
  1.663588728463199e-08, -1.343611796574281e-10,  1.439694393335219e-13,  1.997769568292954e-15, -9.732500657353373e-18, -7.837249695427065e-21,  2.425754256592741e-22,
 -7.193313809768693e-25, -3.029695319801251e-27,  8.638991594076141e-01, -3.758204370548775e-03,  5.153208533331344e-06,  2.638338611398447e-08, -1.368887673100754e-10,
 -1.050843999843777e-13,  2.979194963698410e-15, -6.440302131073433e-18, -4.792288314003106e-20,  2.989695904631720e-22,  2.263137936965147e-25, -8.263211411671633e-27,
  9.611986232317886e-01, -3.943848735608488e-03,  3.423225028552862e-06,  3.587180169319538e-08, -1.174988168180365e-10, -4.316465850117531e-13,  3.405396158952857e-15,
  1.970033508361339e-18, -8.690749138165699e-20,  1.628524558262137e-22,  1.857841574294150e-24, -9.151559225543473e-27,  1.062050748079735e+00, -4.067440740552701e-03,
  1.221438349467442e-06,  4.376864017813474e-08, -7.091117903616726e-11, -7.760840256351820e-13,  2.745012651961490e-15,  1.447975061422834e-17, -9.498496280433275e-20,
 -2.280850452591167e-22,  3.053513422459519e-24,  1.032383093991331e-27,  1.165741371126450e+00, -4.113813496768739e-03, -1.393672797144518e-06,  4.839200241493170e-08,
  3.934188587736957e-12, -1.031660108579028e-12,  6.166977208416834e-16,  2.630963479984424e-17, -3.882999745753152e-20, -7.265779174504332e-22,  1.810268267516896e-24,
  2.067187421457943e-26,  1.271346293461084e+00, -4.067554989770358e-03, -4.293421953819054e-06,  4.787734608052358e-08,  1.002592332757964e-10, -1.055470544741669e-12,
 -2.808957022349966e-15,  2.875982459940065e-17,  8.679032057173159e-20, -8.777739583667545e-22, -2.871065780134672e-24,  2.862921241264249e-26,  1.377678442753476e+00,
 -3.914396057686534e-03, -7.258972878908255e-06,  4.056299452600989e-08,  1.998899362306819e-10, -7.156427579666484e-13, -6.365521615461831e-15,  1.307675059375566e-17,
  2.162571819756694e-19, -1.603738257421449e-22, -7.586908967534613e-24, -3.899401374177181e-27,  1.483228750860690e+00, -3.643503258758440e-03, -9.969070701721559e-06,
  2.566884590696700e-08,  2.722856954937526e-10,  1.338927032231728e-14, -7.836998936148605e-15, -2.001866676668850e-17,  2.108960378723853e-19,  1.233862520382648e-21,
 -4.499024345368838e-24, -5.771638740224759e-26,  1.586106835571092e+00, -3.250939764301258e-03, -1.201006180611756e-05,  4.241043169750213e-09,  2.805777218041898e-10,
  9.319002214046813e-13, -5.007389406911936e-15, -5.025150359168920e-17, -2.097188649401891e-20,  1.769313892620742e-21,  7.894068338060418e-24, -3.785872671595615e-26,
  1.683994527501722e+00, -2.744359545638055e-03, -1.293040380789848e-05, -1.994066858307055e-08,  1.991188267697632e-10,  1.575627595987270e-12,  1.909010380254814e-15,
 -4.432805049932917e-17, -3.116138678434220e-19, -1.301442754477454e-23,  1.238364659904185e-23,  7.042533126656776e-26,  1.774135470404677e+00, -2.148434349505593e-03,
 -1.236281723498483e-05, -4.026445890382650e-08,  4.052631717659842e-11,  1.429213285178031e-12,  8.268115887818988e-15,  5.971170978138506e-18, -2.713664078559282e-19,
 -2.172928671608759e-21, -4.531499347819702e-24,  5.905009079656409e-26,  1.853395532304234e+00, -1.509418194509083e-03, -1.021599428353750e-05, -4.913227936613013e-08,
 -1.267156027948778e-10,  4.356201544101858e-13,  7.732062949434981e-15,  4.903684656792444e-17,  1.236359472542058e-19, -8.883198650972036e-22, -1.296464506071846e-23,
 -7.761455589197468e-26,  1.918434777924048e+00, -8.958003550296998e-04, -6.877450991970063e-06, -4.227247105651372e-08, -2.050056758316996e-10, -6.494548888958712e-13,
  5.288935487063570e-16,  2.792938399351528e-17,  2.556206342285491e-19,  1.471472737274758e-21,  4.595357201121677e-24, -1.424024652608172e-26,  1.966019349831991e+00,
 -3.911948294770360e-04, -3.282928530243478e-06, -2.355286180993558e-08, -1.502013743202717e-10, -8.523581014144109e-13, -4.171906101789265e-15, -1.580930720189600e-17,
 -2.390533308216075e-20,  3.184546124327949e-22,  4.447795056021318e-24,  3.752394938654887e-26,  1.993462803470780e+00, -7.732792317177402e-05, -6.824046366717977e-07,
 -5.315785439507631e-09, -3.848306857738022e-11, -2.646084785470248e-13, -1.746190678856911e-15, -1.111322438107758e-17, -6.830855011293401e-20, -4.049867561831247e-22,
 -2.306239475739309e-24, -1.250804850156603e-26,  6.993650370309574e-04, -4.162335195187759e-06,  1.857332238964917e-08, -7.365629442441820e-11,  2.736750821490215e-13,
 -9.760457393345942e-16,  3.380261513532106e-18, -1.147292992610352e-20,  3.822136029509953e-23, -1.261698520133573e-25,  4.085912257131287e-28, -1.332744759421395e-30,
  6.294419962224500e-03, -3.741056098848914e-05,  1.663976334453720e-07, -6.560752535070503e-10,  2.415624495059039e-12, -8.502508506388481e-15,  2.891771786748454e-17,
 -9.583360861945588e-20,  3.095274247842587e-22, -9.830845239577066e-25,  3.029308025579159e-27, -9.331381536546963e-30,  1.748520842791408e-02, -1.036364171248375e-04,
  4.579695980504868e-07, -1.784524917844153e-09,  6.448325897517410e-12, -2.207633995447678e-14,  7.219368934061493e-17, -2.266920040350522e-19,  6.798956814553221e-22,
 -1.954286263990085e-24,  5.211769407308215e-27, -1.322911954093093e-29,  3.427289603619477e-02, -2.022914723661254e-04,  8.850823228756270e-07, -3.386463579320770e-09,
  1.187856259763603e-11, -3.885736734944328e-14,  1.186914208321000e-16, -3.364807259886541e-19,  8.587216369924633e-22, -1.876380823441495e-24,  2.612446963699563e-27,
  2.022092747889598e-30,  5.665874059324594e-02, -3.325347502667546e-04,  1.435293056123079e-06, -5.353734272150077e-09,  1.799025512863292e-11, -5.488455154915852e-14,
  1.493237646637260e-16, -3.436602785456397e-19,  5.371327960626503e-22,  2.646047681486007e-25, -7.436895210326274e-27,  4.027896642052239e-29,  8.464347028604860e-02,
 -4.932100894953842e-04,  2.091769014509787e-06, -7.543550430818057e-09,  2.387521672152355e-11, -6.544606300796078e-14,  1.436043175434646e-16, -1.747338733932479e-19,
 -4.816859771887390e-22,  4.660857987326671e-24, -2.289841914650066e-26,  8.251672331537648e-29,  1.182263968290568e-01, -6.828148742563052e-04,  2.833091034119908e-06,
 -9.780162676266102e-09,  2.847797883600288e-11, -6.558875690094388e-14,  8.374431954488131e-17,  2.096955367237512e-19, -2.147253560779379e-21,  1.012201466512424e-23,
 -3.541199879935435e-26,  8.638523057932136e-29,  1.574042086874095e-01, -8.994591914615913e-04,  3.633025860570018e-06, -1.185755210387584e-08,  3.065802277625297e-11,
 -5.077542363169869e-14, -4.052381947783822e-17,  7.883679923119438e-19, -4.057219925566388e-21,  1.389146111375025e-23, -3.165136531705828e-26,  4.004216929505732e-30,
  2.021693684779208e-01, -1.140814229104240e-03,  4.460284780548790e-06, -1.354363797952079e-08,  2.927356844816930e-11, -1.769176942537210e-14, -2.267652010480317e-16,
  1.457577471376905e-18, -5.429044157899621e-21,  1.211862541609089e-23,  1.229749059404340e-27, -1.812819052200537e-28,  2.525080118900249e-01, -1.404048506989511e-03,
  5.278296885430524e-06, -1.458667007503168e-08,  2.329168288662949e-11,  3.481009443940254e-14, -4.549371455793157e-16,  2.021539650500504e-18, -5.200193562775432e-21,
  1.202849661218911e-24,  6.616769761941694e-26, -4.099995285915975e-28,  3.083972108190914e-01, -1.685750362572363e-03,  6.045041346052277e-06, -1.472470551474968e-08,
  1.192956947076246e-11,  1.046740700053861e-13, -6.837805293863779e-16,  2.204555657193610e-18, -2.306325287961993e-21, -1.997311270412872e-23,  1.451357986170692e-25,
 -5.200264622713281e-28,  3.698014180854077e-01, -1.981835068997149e-03,  6.713007219491648e-06, -1.369934898961498e-08, -5.169091426347270e-12,  1.856015425662025e-13,
 -8.500505899393940e-16,  1.696263165277536e-18,  3.836168320920194e-21, -4.730389636653157e-23,  1.921084268879955e-25, -2.795865965602980e-28,  4.366678515321530e-01,
 -2.287435161564070e-03,  7.229385060586910e-06, -1.127525144174727e-08, -2.772196796535816e-11,  2.661871391062936e-13, -8.727591472019457e-16,  2.407467479180155e-19,
  1.267663119772290e-20, -6.926022802930097e-23,  1.392519571764719e-25,  4.785577246236648e-28,  5.089204968995499e-01, -2.596773205705651e-03,  7.536646751799338e-06,
 -7.267172485928230e-09, -5.456616102431215e-11,  3.295283383253829e-13, -6.652050152776374e-16, -2.225357611223603e-18,  2.185593841548297e-20, -6.714262693589570e-23,
 -7.287083260861253e-26,  1.616345344724009e-27,  5.864523060980698e-01, -2.903017717959863e-03,  7.573744510013924e-06, -1.576608825690559e-09, -8.340597479378170e-11,
  3.537822197254178e-13, -1.578042554510159e-16, -5.396223823002771e-18,  2.685130020596527e-20, -2.048331011222718e-23, -4.355244828327847e-25,  2.438739068985288e-27,
  6.691150340472448e-01, -3.198125861676845e-03,  7.278263607203507e-06,  5.760154761302660e-09, -1.105935248787913e-10,  3.143567500302569e-13,  6.661468429570721e-16,
 -8.424308703596293e-18,  2.152457873306768e-20,  7.989553743994126e-23, -7.964319901848675e-25,  1.699009826354073e-27,  7.567059870609857e-01, -3.472681885558299e-03,
  6.590000962047515e-06,  1.451165554999686e-08, -1.310245124499843e-10,  1.886253137312486e-13,  1.723020295789712e-15, -9.849359262741753e-18,  3.490503874947820e-22,
  2.115330832980024e-22, -8.231783844442271e-25, -1.711688753427532e-27,  8.489507456548294e-01, -3.715749668298523e-03,  5.456610898701611e-06,  2.418017290174806e-08,
 -1.382909083334497e-10, -3.591096139697078e-14,  2.779023504103375e-15, -7.800573290414747e-18, -3.708179238510391e-20,  3.010694154891321e-22, -1.128757463001967e-25,
 -7.105806837521399e-27,  9.454806801986037e-01, -3.914773675758854e-03,  3.842136297899313e-06,  3.392721098221376e-08, -1.253115847402095e-10, -3.495634934207033e-13,
  3.422601488221864e-15, -7.036691575958368e-19, -7.980730793427858e-20,  2.287828802438272e-22,  1.431966278429198e-24, -1.007408581986784e-26,  1.045803825792703e+00,
 -4.055588782602119e-03,  1.739354299470642e-06,  4.251359894495486e-08, -8.574302064022860e-11, -7.056887348550420e-13,  3.106826211834456e-15,  1.133244010108639e-17,
 -1.009981769817562e-19, -1.063067260485982e-22,  3.004822983012121e-24, -3.161196689423820e-27,  1.149267495618170e+00, -4.122640554597205e-03, -8.132686991812254e-07,
  4.829093562611381e-08, -1.649216213701025e-11, -1.008183361710093e-12,  1.332149019540446e-15,  2.466425094086970e-17, -6.347487969422891e-20, -6.371670260804187e-22,
  2.628481264181193e-24,  1.631425331461679e-26,  1.255011053785132e+00, -4.099578609009392e-03, -3.709976629190505e-06,  4.930923470436313e-08,  7.854239532698883e-11,
 -1.112938306684450e-12, -1.969693757747424e-15,  3.101189219245423e-17,  5.343819392997122e-20, -9.662164337964055e-22, -1.525905484928272e-24,  3.207723663400959e-26,
  1.361907873000727e+00, -3.970467587948689e-03, -6.753526349072176e-06,  4.363856849481642e-08,  1.840830250896595e-10, -8.632469353684589e-13, -5.903775724013933e-15,
  1.984592831961194e-17,  2.050148189320619e-19, -4.634254565488286e-22, -7.469105773403652e-24,  9.336614235475456e-27,  1.468497288026535e+00, -3.721949704991520e-03,
 -9.634929877212522e-06,  3.001716352631405e-08,  2.706313092946088e-10, -1.806226970504056e-13, -8.296638742234710e-15, -1.259895150007475e-17,  2.514698924270896e-19,
  1.003868173203803e-21, -6.971207141037062e-24, -5.366235721671762e-26,  1.572911347397305e+00, -3.346738999849931e-03, -1.193164123259375e-05,  8.872382134024570e-09,
  2.978998478447039e-10,  7.948234812687638e-13, -6.413837745689541e-15, -4.984619772656526e-17,  4.794444374647897e-20,  2.045034032250543e-21,  5.725729927373050e-24,
 -6.063291153346382e-26,  1.672808767004338e+00, -2.848703358922637e-03, -1.314952964745685e-05, -1.650061983606587e-08,  2.309831928100380e-10,  1.605425957210298e-12,
  5.288675849756751e-16, -5.420566079891882e-17, -3.024404434822482e-19,  5.418493113479663e-22,  1.528047046621317e-23,  5.953913825935745e-26,  1.765340886346759e+00,
 -2.249256315595644e-03, -1.284112189931107e-05, -3.937654382560307e-08,  7.110309117136182e-11,  1.628599723904613e-12,  8.301759349049112e-15, -3.993512350311088e-18,
 -3.521443459304119e-19, -2.292935743181556e-21, -1.231323944219384e-24,  9.162002700424179e-26,  1.847190621864000e+00, -1.593538234833327e-03, -1.081742487025400e-05,
 -5.107947271689548e-08, -1.160341174840096e-10,  6.380798186517308e-13,  9.154923247144482e-15,  5.237466661284478e-17,  8.148557074304570e-20, -1.476566400749169e-21,
 -1.646815227828270e-23, -8.035611971597861e-26,  1.914738244563907e+00, -9.529057844208326e-04, -7.404826827784384e-06, -4.565550181844355e-08, -2.177995060645703e-10,
 -6.264026671557866e-13,  1.433642246012283e-15,  3.699074695493709e-17,  3.117025192149023e-19,  1.637280228131592e-21,  3.544350144192943e-24, -3.496534238286325e-26,
  1.964400194209207e+00, -4.186309815413956e-04, -3.580562797029585e-06, -2.609805317225838e-08, -1.682860463726092e-10, -9.578703120828441e-13, -4.623288232006015e-15,
 -1.635306198832409e-17, -8.806961697309836e-21,  5.331362657610895e-22,  6.385331916785550e-24,  5.113267050262904e-26,  1.993142153977141e+00, -8.305320290343625e-05,
 -7.500707541989849e-07, -5.976239346727430e-09, -4.422086482772480e-11, -3.105122376499249e-13, -2.090288424896919e-15, -1.355130710216118e-17, -8.468979787225337e-20,
 -5.091986720446773e-22, -2.929424296421011e-24, -1.595251233584129e-26,  6.830073747007251e-04, -4.017211134064883e-06,  1.771508945991594e-08, -6.942935935574107e-11,
  2.549401063934058e-13, -8.986402459422686e-16,  3.075481655154137e-18, -1.031947719046189e-20,  3.395981608734060e-23, -1.109426814218391e-25,  3.541027466084870e-28,
 -1.149311991773990e-30,  6.147391129550365e-03, -3.611022716650300e-05,  1.587511384023921e-07, -6.187488468531067e-10,  2.252302875257545e-12, -7.839596003582645e-15,
  2.636788684950378e-17, -8.647238247606075e-20,  2.762218749920570e-22, -8.697596940476296e-25,  2.645586693486651e-27, -8.142919014938099e-30,  1.707785708176354e-02,
 -1.000565965467953e-04,  4.371600670922683e-07, -1.684791892000899e-09,  6.023623881584949e-12, -2.041746501755230e-14,  6.614061026361127e-17, -2.060218931779116e-19,
  6.131568472827976e-22, -1.757098960346582e-24,  4.656207588776498e-27, -1.204695823265711e-29,  3.347763857740967e-02, -1.953701911392252e-04,  8.455599488034776e-07,
 -3.202472131145486e-09,  1.112915383892575e-11, -3.611878732722584e-14,  1.096446574377653e-16, -3.100621241078991e-19,  7.930687017609127e-22, -1.770715123107067e-24,
  2.656532646209603e-27,  5.555001380763937e-32,  5.535116619711549e-02, -3.213045738889862e-04,  1.372739707434221e-06, -5.074480236759603e-09,  1.692763244773867e-11,
 -5.141430194631107e-14,  1.399429544360394e-16, -3.263737076633233e-19,  5.417092200677303e-22,  1.872255654393182e-28, -5.840785583633233e-27,  3.247552257941493e-29,
  8.270353396091813e-02, -4.768316320108161e-04,  2.003495837711885e-06, -7.171832766203071e-09,  2.260035583484803e-11, -6.205986285431426e-14,  1.385199780956662e-16,
 -1.876330561464997e-19, -3.295390418853183e-22,  3.814026499121047e-24, -1.952801207907429e-26,  7.086394813784568e-29,  1.155397343012232e-01, -6.606119467576335e-04,
  2.718420038256965e-06, -9.334898152574272e-09,  2.718673919005236e-11, -6.351587289340443e-14,  8.870669882767730e-17,  1.465476594565231e-19, -1.807456631531586e-21,
  8.779889031308760e-24, -3.173778185660500e-26,  8.041978097359565e-29,  1.538636108319108e-01, -8.709558855815740e-04,  3.493644742442195e-06, -1.137519340314858e-08,
  2.963450271331521e-11, -5.149732119757373e-14, -2.019370830779017e-17,  6.662947189978339e-19, -3.579830734496821e-21,  1.263358281228067e-23, -3.113775843242882e-26,
  1.840923284766011e-29,  1.976764580047644e-01, -1.105774111817419e-03,  4.300558790017076e-06, -1.307837374117177e-08,  2.886851544979163e-11, -2.266361656127132e-14,
 -1.883196762014261e-16,  1.290823111008635e-18, -4.993684649207383e-21,  1.202198185739436e-23, -5.739620448992563e-27, -1.370155900564771e-28,  2.469751710343335e-01,
 -1.362515907580633e-03,  5.105513950866453e-06, -1.420900786433453e-08,  2.388318776473570e-11,  2.455209378968450e-14, -4.006537692215171e-16,  1.856302951927162e-18,
 -5.113427107916097e-21,  3.507430638595065e-24,  4.951294527497212e-26, -3.480159643592815e-28,  3.017498157362701e-01, -1.638093419410600e-03,  5.869556372107642e-06,
 -1.451795537262136e-08,  1.386389769846437e-11,  8.899510290310869e-14, -6.231865675827643e-16,  2.120324953261931e-18, -2.926293176638067e-21, -1.461629783695258e-23,
  1.229446635938492e-25, -4.871936305951317e-28,  3.619804431524493e-01, -1.928789710991752e-03,  6.548237749924775e-06, -1.375345029323991e-08, -1.657160387555169e-12,
  1.657826233000214e-13, -8.010821993656691e-16,  1.793231099119633e-18,  2.268367739143334e-21, -3.988858769595078e-23,  1.781471126344452e-25, -3.497119069012894e-28,
  4.276329140066635e-01, -2.230148436298803e-03,  7.091592739522392e-06, -1.167734797738394e-08, -2.260691409751805e-11,  2.453653846825149e-13, -8.607060618002840e-16,
  6.076170229350668e-19,  1.028795722304588e-20, -6.333886700684690e-23,  1.551685458554332e-25,  2.523132715019932e-28,  4.986534178193955e-01, -2.536843202818427e-03,
  7.444416954861217e-06, -8.088393747843259e-09, -4.813989166880691e-11,  3.128924786663484e-13, -7.180901775781567e-16, -1.565071003673060e-18,  1.940259288985162e-20,
 -6.873196232104186e-23, -8.970791521138638e-27,  1.290496873678347e-27,  5.749612639952184e-01, -2.842525589364459e-03,  7.547050924042485e-06, -2.854754679061916e-09,
 -7.637994357163844e-11,  3.482780842764271e-13, -2.970027639429836e-16, -4.551935571997257e-18,  2.582577977965880e-20, -3.580379642909952e-23, -3.317801280025991e-25,
  2.263462798928164e-27,  6.564393787587024e-01, -3.139652863755953e-03,  7.336978559517842e-06,  4.041745331521192e-09, -1.041652082274347e-10,  3.275939810041476e-13,
  4.402986552019992e-16, -7.695496782590089e-18,  2.384657356445208e-20,  4.965905794961516e-23, -7.126415004818949e-25,  2.077028043161106e-27,  7.429217525023804e-01,
 -3.419300656220123e-03,  6.751693990242313e-06,  1.244759656412365e-08, -1.268607841070074e-10,  2.266764842678795e-13,  1.448493372995986e-15, -9.722827359825549e-18,
  7.356656365940088e-21,  1.774545692610646e-22, -8.722856726985564e-25, -5.505758602358244e-28,  8.341768373026778e-01, -3.670973779355506e-03,  5.733484875246583e-06,
  2.196531991522044e-08, -1.383605042684063e-10,  2.804049122025383e-14,  2.545614556533697e-15, -8.815234225289285e-18, -2.639634023626951e-20,  2.906962214731946e-22,
 -3.957141371994157e-25, -5.725409650094043e-27,  9.298855893606562e-01, -3.882442666393788e-03,  4.237016632131748e-06,  3.187074675005992e-08, -1.314844839481514e-10,
 -2.679380899028509e-13,  3.368457009054103e-15, -3.115543248648709e-18, -7.064792791315096e-20,  2.770976328972880e-22,  9.826432547384739e-25, -1.023071838175063e-26,
  1.029612497058863e+00, -4.039657663375658e-03,  2.240833804377346e-06,  4.103295299560114e-08, -9.908735453698221e-11, -6.276851301148580e-13,  3.378475499482284e-15,
  8.062124144985415e-18, -1.027053669559016e-19,  1.000567634671659e-23,  2.784966248542258e-24, -6.704411774216590e-27,  1.132767582873929e+00, -4.126834745153408e-03,
 -2.360198622059589e-07,  4.786771922657079e-08, -3.628144849452563e-11, -9.681745582139854e-13,  1.991015315964853e-15,  2.228765273636040e-17, -8.436111849240254e-20,
 -5.191903494856716e-22,  3.231383545109209e-24,  1.097272099988102e-26,  1.238557155135598e+00, -4.126871922120625e-03, -3.111467787911016e-06,  5.038557271435655e-08,
  5.588209861668686e-11, -1.149630221057165e-12, -1.082717480570129e-15,  3.215638275168730e-17,  1.789996963984716e-20, -9.986173527756139e-22, -8.913498571880387e-26,
  3.276435488391713e-26,  1.345921331654690e+00, -4.022352438031401e-03, -6.212785689383869e-06,  4.643828091625698e-08,  1.654499492443800e-10, -9.975454399355496e-13,
 -5.259156444481070e-15,  2.608284563618717e-17,  1.830883130197747e-19, -7.500781876747415e-22, -6.768614308514429e-24,  2.234519282838284e-26,  1.453457715104229e+00,
 -3.797515053807059e-03, -9.248897852634814e-06,  3.430744285205484e-08,  2.650039214364058e-10, -3.830346026505468e-13, -8.531727687961766e-15, -4.031979393886642e-18,
  2.820431912602996e-19,  6.803369022429938e-22, -9.131710860831105e-24, -4.355856082063324e-26,  1.559334275354291e+00, -3.441684075156166e-03, -1.179607805730562e-05,
  1.375711728102238e-08,  3.121451352076233e-10,  6.243858900403438e-13, -7.776701427922172e-15, -4.709543735178404e-17,  1.249868016265817e-19,  2.214330900107289e-21,
  2.587200469500696e-24, -8.143729166904923e-26,  1.661202398964427e+00, -2.954626356338913e-03, -1.332430234068452e-05, -1.254786639487479e-08,  2.630901419661797e-10,
  1.598834415279491e-12, -1.120582586342276e-15, -6.344888102015309e-17, -2.713503143538783e-19,  1.199836734273239e-21,  1.745885316300359e-23,  3.755495452710534e-26,
  1.756135441172209e+00, -2.353853479334073e-03, -1.330570474717986e-05, -3.796755482269089e-08,  1.056515454961045e-10,  1.825150368608806e-12,  8.019751865325160e-15,
 -1.658387230148897e-17, -4.345120310609541e-19, -2.251332203993497e-21,  3.566088635519949e-24,  1.265002157363875e-25,  1.840639464909170e+00, -1.682559959829252e-03,
 -1.144105664139337e-05, -5.282148457278332e-08, -1.009552565144017e-10,  8.756366842718021e-13,  1.064898208051997e-14,  5.399771245718440e-17,  1.563006361916022e-20,
 -2.204735657512656e-21, -1.988710729988506e-23, -7.296569765830621e-26,  1.910804589506052e+00, -1.014396042749138e-03, -7.974007959684620e-06, -4.923827573626453e-08,
 -2.298935307483861e-10, -5.783838883961797e-13,  2.618062177801388e-15,  4.793217731621421e-17,  3.727523478176120e-19,  1.740069406293302e-21,  1.372227005534284e-24,
 -6.560556876512467e-26,  1.962666331234550e+00, -4.485754601802795e-04, -3.910547044946738e-06, -2.895007394078688e-08, -1.885902130789699e-10, -1.074336093643151e-12,
 -5.081855827105597e-15, -1.627381873367860e-17,  1.556914653159055e-20,  8.383865788890513e-22,  9.004259968495880e-24,  6.858721705848825e-26,  1.992797468213075e+00,
 -8.935314685207405e-05, -8.262449630879795e-07, -6.736315621258948e-09, -5.096517078454694e-11, -3.655564191651251e-13, -2.510591370663466e-15, -1.657873807671864e-17,
 -1.053101629469920e-19, -6.416208269658797e-22, -3.723285259804097e-24, -2.029417075154510e-26,  6.672167910928764e-04, -3.878755024282313e-06,  1.690583102291990e-08,
 -6.549018574317317e-11,  2.376826318265563e-13, -8.281768269177154e-16,  2.801168800680652e-18, -9.294028436407081e-21,  3.020907966773824e-23, -9.774276699693647e-26,
  3.070100586022062e-28, -9.958797647942289e-31,  6.005444063636684e-03, -3.486931707436324e-05,  1.515373083539157e-07, -5.839327580957820e-10,  2.101648170533369e-12,
 -7.234850839895560e-15,  2.406584204687846e-17, -7.811452226476401e-20,  2.467318273629002e-22, -7.707941096238330e-25,  2.309991429738386e-27, -7.140521552898649e-30,
  1.668449948531518e-02, -9.663857807895900e-05,  4.175076308672911e-07, -1.591596379117563e-09,  5.630692285292290e-12, -1.889715374048071e-14,  6.063743246931599e-17,
 -1.873780348575060e-19,  5.531289002688006e-22, -1.581136551895456e-24,  4.149437296453062e-27, -1.101417601152651e-29,  3.270944758651719e-02, -1.887564570673432e-04,
  8.081752987948989e-07, -3.030044600006404e-09,  1.043240416285876e-11, -3.358868685427440e-14,  1.013087757268255e-16, -2.856833741973203e-19,  7.312317367495879e-22,
 -1.664896021872339e-24,  2.622834596214360e-27, -1.537744361428590e-30,  5.408753247503193e-02, -3.105617039442760e-04,  1.313437646583016e-06, -4.811684992146086e-09,
  1.593220262014156e-11, -4.816337532404742e-14,  1.310468714668739e-16, -3.090813243765257e-19,  5.378362314106146e-22, -2.069088749836632e-25, -4.562791414400773e-27,
  2.577486924656794e-29,  8.082772686262407e-02, -4.611418591515118e-04,  1.919563099347620e-06, -6.819977826982911e-09,  2.139197218152702e-11, -5.879949807272794e-14,
  1.331382200972028e-16, -1.961262764097183e-19, -2.055720589811097e-22,  3.092068256633319e-24, -1.664731924475872e-26,  6.023128774598346e-29,  1.129400820959218e-01,
 -6.393053625559838e-04,  2.608969645146232e-06, -8.909955910457716e-09,  2.593801114022201e-11, -6.134392440759630e-14,  9.204610214023341e-17,  9.352805041356443e-20,
 -1.513397162673457e-21,  7.579145461915968e-24, -2.835059523340390e-26,  7.339400755589709e-29,  1.504348323670352e-01, -8.435447547570945e-04,  3.359953277117280e-06,
 -1.090930114818866e-08,  2.860115580805895e-11, -5.177062814728632e-14, -3.074551096825376e-18,  5.587784702212848e-19, -3.147217207227877e-21,  1.140733652345008e-23,
 -3.010733192190518e-26,  2.765191143378811e-29,  1.933211875798859e-01, -1.071989587185090e-03,  4.146373961962933e-06, -1.262033727261223e-08,  2.837288235141627e-11,
 -2.676723135290936e-14, -1.543491177290063e-16,  1.137894435954289e-18, -4.566376893029372e-21,  1.168288970667280e-23, -1.095621680522930e-26, -1.014742001441151e-28,
  2.416057249588033e-01, -1.322347298112882e-03,  4.937313202029102e-06, -1.382345363663990e-08,  2.428218781381642e-11,  1.554176058217133e-14, -3.509465629703415e-16,
  1.695046870080032e-18, -4.955046460444811e-21,  5.198531142772254e-24,  3.544631412521330e-26, -2.925279361297629e-28,  2.952902570915266e-01, -1.591829929219110e-03,
  5.696728000925773e-06, -1.428268643904647e-08,  1.549898724783048e-11,  7.474001970051588e-14, -5.652010243482926e-16,  2.019172454410710e-18, -3.369023985216216e-21,
 -1.011597377879642e-23,  1.023588293103140e-25, -4.478147148134515e-28,  3.543690105376924e-01, -1.877064180065939e-03,  6.383143338733510e-06, -1.375446704828557e-08,
  1.470336336097248e-12,  1.471661001365714e-13, -7.500617503514597e-16,  1.844187360048835e-18,  9.568047455779351e-22, -3.308451308088647e-23,  1.617547094210858e-25,
 -3.912750184520988e-28,  4.188248900683643e-01, -2.173981990471345e-03,  6.949452622930389e-06, -1.200091607485026e-08, -1.790461430508879e-11,  2.249477361692649e-13,
 -8.394179211196311e-16,  9.015646198688816e-19,  8.121631595060784e-21, -5.696696611159419e-23,  1.620942033311142e-25,  6.931978072553627e-29,  4.886245230950452e-01,
 -2.477688734686007e-03,  7.342938238373967e-06, -8.809519274053000e-09, -4.205758042586406e-11,  2.952003241947842e-13, -7.535916591462420e-16, -9.837413624756260e-19,
  1.693462810635977e-20, -6.804703353255943e-23,  4.098701195333370e-26,  9.844213124675488e-28,  5.637116688558167e-01, -2.782306458883259e-03,  7.505689887911358e-06,
 -4.021538244746529e-09, -6.949550907925713e-11,  3.397126758090655e-13, -4.130979329636337e-16, -3.748504095309688e-18,  2.432135754908697e-20, -4.715046319907147e-23,
 -2.373167042937946e-25,  2.021767538360479e-27,  6.439984267945974e-01, -3.080790863124825e-03,  7.375697518956886e-06,  2.428019495781882e-09, -9.752465836420848e-11,
  3.356631506936487e-13,  2.357385985664431e-16, -6.909121249062601e-18,  2.514387676200311e-20,  2.305054873603605e-23, -6.163792880935374e-25,  2.270359869111526e-27,
  7.293534747533018e-01, -3.364723769433832e-03,  6.889041987055269e-06,  1.045588908175583e-08, -1.220015057342273e-10,  2.582057181516875e-13,  1.180462177675993e-15,
 -9.391963795899150e-18,  1.311388184769171e-20,  1.423771415578404e-22, -8.745780304152837e-25,  4.112749322222894e-28,  8.195862942599837e-01, -3.624089135289962e-03,
  5.983815132051721e-06,  1.975927229130350e-08, -1.372091925986483e-10,  8.608742148217276e-14,  2.288511177690312e-15, -9.495998091980388e-18, -1.627299481139021e-20,
  2.702590859462348e-22, -6.154442034153676e-25, -4.258389756735815e-27,  9.144259821467053e-01, -3.847052880166196e-03,  4.606680380053638e-06,  2.972848324493570e-08,
 -1.360431623528299e-10, -1.883879402408695e-13,  3.251120189066434e-15, -5.209957798810464e-18, -6.007252378195142e-20,  3.075048590015713e-22,  5.413904581750842e-25,
 -9.728869110558220e-27,  1.013492798979720e+00, -4.019789288062289e-03,  2.723317046435441e-06,  3.935160131575323e-08, -1.108138533168268e-10, -5.442631407879237e-13,
  3.558406804431186e-15,  4.802186042164597e-18, -1.004190005635561e-19,  1.146475382217034e-22,  2.427576754249583e-24, -9.387055043731197e-27,  1.116260089672389e+00,
 -4.126436575809245e-03,  3.342797303677958e-07,  4.713511088332760e-08, -5.511819409586226e-11, -9.132229460474599e-13,  2.574648784269436e-15,  1.931483331011473e-17,
 -1.006243507371401e-19, -3.819660993803358e-22,  3.587713910893818e-24,  5.199135073875851e-27,  1.222003732411204e+00, -4.149331712090428e-03, -2.502238724888824e-06,
  5.109464046142244e-08,  3.270276636441182e-11, -1.164779342844616e-12, -1.797127674040022e-16,  3.215608863714411e-17, -1.777046042270522e-20, -9.737687075908496e-22,
  1.316359184867242e-24,  3.068130135399779e-26,  1.329736108120017e+00, -4.069782243220949e-03, -5.640323011522030e-06,  4.891927477598629e-08,  1.442993078303821e-10,
 -1.114366078352873e-12, -4.451232982356510e-15,  3.145950874617944e-17,  1.514812289071141e-19, -9.976548099980112e-22, -5.527533904589527e-24,  3.367671342837202e-26,
  1.438122380791727e+00, -3.869788052913116e-03, -8.812057062936161e-06,  3.847507491423858e-08,  2.552918276005865e-10, -5.881109220923359e-13, -8.515108898490054e-15,
  5.311277680525786e-18,  2.995365387784593e-19,  2.809785925652697e-22, -1.072196308415394e-23, -2.789494732350575e-26,  1.545379968375000e+00, -3.535306573515605e-03,
 -1.160064867445527e-05,  1.884076109956807e-08,  3.226622825577384e-10,  4.224471333035664e-13, -9.027295369202520e-15, -4.180775306677413e-17,  2.056549449786808e-19,
  2.241083692270547e-21, -1.363144638590674e-24, -9.698025430331492e-26,  1.649169855278755e+00, -3.061749094466615e-03, -1.344857127813690e-05, -8.084692983965707e-09,
  2.946491045380399e-10,  1.549685207043990e-12, -3.011245590778393e-15, -7.130349731280701e-17, -2.152686714013577e-19,  1.922170515724002e-21,  1.841281310576507e-23,
  3.934311523117023e-27,  1.746504294757037e+00, -2.462089981452654e-03, -1.374993488350650e-05, -3.597483537261624e-08,  1.440332476292785e-10,  2.010407413441778e-12,
  7.348820135359841e-15, -3.174600660050914e-17, -5.115599488543209e-19, -1.987430031582456e-21,  9.866419182038882e-24,  1.589873415897664e-25,  1.833722116835479e+00,
 -1.776649880310883e-03, -1.208398185450471e-05, -5.428226645415016e-08, -8.076433991092805e-11,  1.149333026413279e-12,  1.215485875151702e-14,  5.306843814718777e-17,
 -7.878586377865241e-20, -3.059021896193895e-21, -2.266147539610281e-23, -5.011756014445968e-26,  1.906615589691370e+00, -1.080614929299066e-03, -8.587306415332544e-06,
 -5.300521838939922e-08, -2.407169509054337e-10, -4.980392038608687e-13,  4.136612954883247e-15,  6.086679942437478e-17,  4.355825966461085e-19,  1.725556784178554e-21,
 -2.410211136671859e-24, -1.085200368930777e-25,  1.960807185808714e+00, -4.813024134350461e-04, -4.276783540317939e-06, -3.214619139616579e-08, -2.113330705307200e-10,
 -1.201681812505326e-12, -5.525478892987430e-15, -1.521692204024692e-17,  5.301618419368006e-20,  1.264988469243198e-21,  1.248393411408506e-23,  9.029303288762999e-26,
  1.992426303415286e+00, -9.630088996092381e-05, -9.122257272690958e-07, -7.613686156443209e-09, -5.891850416641968e-11, -4.317842850082178e-13, -3.025662921637054e-15,
 -2.034881599699926e-17, -1.313180715464119e-19, -8.099199399485934e-22, -4.731038115263122e-24, -2.570166982193762e-26,  6.519673766778295e-04, -3.746588490867478e-06,
  1.614223132497391e-08, -6.181620575683084e-11,  2.217708479960729e-13, -7.639655018800516e-16,  2.553957101462738e-18, -8.381350930596309e-21,  2.690118722206618e-23,
 -8.629953524118867e-26,  2.660762455577854e-28, -8.688805722045331e-31,  5.868347806169940e-03, -3.368448652833353e-05,  1.447271981397211e-07, -5.514333095646859e-10,
  1.962554296486216e-12, -6.682649945009140e-15,  2.198512340398994e-17, -7.064584699162617e-20,  2.205730764129533e-22, -6.844211252867850e-25,  2.014720444246795e-27,
 -6.307999886755346e-30,  1.630450645872085e-02, -9.337341032858246e-05,  3.989367999994138e-07, -1.504451524456466e-09,  5.266887338674509e-12, -1.750286573964373e-14,
  5.563031510445011e-17, -1.705575427357905e-19,  4.990812399019044e-22, -1.424584447090102e-24,  3.684451832875657e-27, -1.015191926251593e-29,  3.196712621943534e-02,
 -1.824337094136799e-04,  7.727945264711886e-07, -2.868370889490678e-09,  9.784310034928230e-12, -3.125067637751949e-14,  9.362836612116499e-17, -2.632228477913522e-19,
  6.731638268606029e-22, -1.561749331934026e-24,  2.524570724521328e-27, -2.903439010310544e-30,  5.286594099636804e-02, -3.002809022046902e-04,  1.257195675887257e-06,
 -4.564307912720096e-09,  1.499969538383066e-11, -4.512016500707070e-14,  1.226321864076821e-16, -2.920228584192785e-19,  5.273593317223437e-22, -3.685169546589955e-25,
 -3.560323959111399e-27,  1.990602219245329e-29,  7.901336221538535e-02, -4.461069829326023e-04,  1.839738744329320e-06, -6.486942458753850e-09,  2.024748715690432e-11,
 -5.567072418299034e-14,  1.275704352333415e-16, -2.010470614285276e-19, -1.056318247331317e-22,  2.476241282095001e-24, -1.421540622236455e-26,  5.042690978546518e-29,
  1.104239368416213e-01, -6.188543205984047e-04,  2.504500127305562e-06, -8.504641936917599e-09,  2.473340859767647e-11, -5.910862053378716e-14,  9.402637947016819e-17,
  4.925224513012616e-20, -1.260202511472353e-21,  6.507454019922571e-24, -2.529114844387423e-26,  6.554481550487553e-29,  1.471135943726473e-01, -8.171810741726968e-04,
  3.231753206747616e-06, -1.045996484537382e-08,  2.756621542737130e-11, -5.166767694026265e-14,  1.122138648775408e-17,  4.644082061267626e-19, -2.757920843982317e-21,
  1.022910939387949e-23, -2.876851671302551e-26,  3.253503952628684e-29,  1.890986229088664e-01, -1.039416696195717e-03,  3.997635421948534e-06, -1.217084464262516e-08,
  2.780299098166145e-11, -3.010540427749839e-14, -1.244712335654705e-16,  9.984069344389483e-19, -4.154677413123805e-21,  1.116401603212393e-23, -1.478668701917523e-26,
 -7.389825477359822e-29,  2.363942915469645e-01, -1.283505692787052e-03,  4.773771666903829e-06, -1.343289376744730e-08,  2.451254838421451e-11,  7.670843471811423e-15,
 -3.056751674275370e-16,  1.539729098606371e-18, -4.745344908682292e-21,  6.373683820683655e-24,  2.366196986873861e-26, -2.443939790065979e-28,  2.890130056339692e-01,
 -1.546937349525270e-03,  5.526870659423121e-06, -1.402346226275781e-08,  1.686265459072909e-11,  6.184114548339895e-14, -5.102228518240054e-16,  1.906289286633822e-18,
 -3.664137972405462e-21, -6.403454380123860e-24,  8.357163847238193e-26, -4.060626855276620e-28,  3.469618396229846e-01, -1.826658630417587e-03,  6.218324895898563e-06,
 -1.370835556616141e-08,  4.237839506250454e-12,  1.297866681669031e-13, -6.981662034836218e-16,  1.856963044941498e-18, -1.219916247152372e-22, -2.696586551330445e-23,
  1.440328969686930e-25, -4.112566692802978e-28,  4.102392348453436e-01, -2.118966948660901e-03,  6.803867731534807e-06, -1.225248377948555e-08, -1.360493123512862e-11,
  2.051321494811936e-13, -8.108349833854829e-16,  1.129898443522405e-18,  6.187848772347148e-21, -5.046724158443355e-23,  1.618435104053884e-25, -7.473385943144438e-29,
  4.788305700780271e-01, -2.419379083088102e-03,  7.233378105407258e-06, -9.436199484898761e-09, -3.633636014880597e-11,  2.768425726927720e-13, -7.739152527907697e-16,
 -4.806322822878683e-19,  1.452411544815833e-20, -6.562527995757543e-23,  7.807644276518694e-26,  7.065540515678973e-28,  5.527022024114753e-01, -2.722472363701499e-03,
  7.450982231800917e-06, -5.079685165794147e-09, -6.280845303724240e-11,  3.286251443769473e-13, -5.074273353217818e-16, -2.999042188963049e-18,  2.247378110219920e-20,
 -5.494464960838208e-23, -1.544421135020578e-25,  1.740712779096912e-27,  6.317934222572089e-01, -3.021694752859161e-03,  7.395693743378404e-06,  9.215743383116245e-10,
 -9.077001543509141e-11,  3.390909340730165e-13,  5.363962370769661e-17, -6.095801647136185e-18,  2.555419146989332e-20,  4.146523208018547e-25, -5.151439572421532e-25,
  2.308144151387769e-27,  7.160055526758566e-01, -3.309142333237691e-03,  7.002975671409651e-06,  8.546628727524979e-09, -1.165751171283485e-10,  2.834330261642217e-13,
  9.240848947950801e-16, -8.897012324219811e-18,  1.761629078388044e-20,  1.079907816642441e-22, -8.393277279297539e-25,  1.154366214039101e-27,  8.051871279736912e-01,
 -3.575307340275529e-03,  6.207820552116666e-06,  1.758059206857409e-08, -1.349600050175609e-10,  1.377710026705234e-13,  2.016759701464022e-15, -9.866156677319313e-18,
 -7.028033227600173e-21,  2.423224436644618e-22, -7.709147415381884e-25, -2.821896413826237e-27,  8.991136842931217e-01, -3.808809732738005e-03,  4.950251287457395e-06,
  2.752583666300373e-08, -1.390435472475122e-10, -1.123184659549585e-13,  3.080018119294886e-15, -6.951798211576667e-18, -4.871334329423637e-20,  3.208657530395707e-22,
  1.340554399249643e-25, -8.715348494235493e-27,  9.974601620169119e-01, -3.996144813128276e-03,  3.184554058651086e-06,  3.749617696183859e-08, -1.208360652148952e-10,
 -4.576064950900785e-13,  3.648629530005879e-15,  1.672712071106293e-18, -9.464876031507310e-20,  2.029122737562008e-22,  1.973117701893058e-24, -1.110923019610447e-26,
  1.099763251146337e+00, -4.121516210193377e-03,  8.940183488301139e-07,  4.611063862651598e-08, -7.272286201472517e-11, -8.453171551676911e-13,  3.068516766715788e-15,
  1.590288458389631e-17, -1.117522840386798e-19, -2.355738112463312e-22,  3.690624943906321e-24, -4.603441971621795e-28,  1.205370263159492e+00, -4.166889954468366e-03,
 -1.886732254489743e-06,  5.143159024208972e-08,  9.436510435052257e-12, -1.158384225411028e-12,  7.075139326771306e-16,  3.103927885557011e-17, -5.156341598835757e-20,
 -8.952901882501469e-22,  2.574400221106110e-24,  2.613677348461257e-26,  1.313370504975931e+00, -4.112519182734027e-03, -5.040192423187029e-06,  5.104426963082316e-08,
  1.210177252537030e-10, -1.210112155609824e-12, -3.508189075533926e-15,  3.569265186322508e-17,  1.119680942379531e-19, -1.186405439715318e-21, -3.848950261338815e-24,
  4.204342425843353e-26,  1.422505256535776e+00, -3.938369232181716e-03, -8.326272084275667e-06,  4.245461284653366e-08,  2.415036554499054e-10, -7.895994884950727e-13,
 -8.231282522598681e-15,  1.497344673866593e-17,  3.016867357994471e-19, -1.668415183686171e-22, -1.152407125297037e-23, -8.024229980117958e-27,  1.531054688250211e+00,
 -3.627119078515577e-03, -1.134334433154570e-05,  2.405879388728479e-08,  3.288540119271033e-10,  1.925622487551657e-13, -1.009377456875264e-14, -3.395498109683155e-17,
  2.842974384103916e-19,  2.098419568512403e-21, -5.821904988380162e-24, -1.040576026795103e-25,  1.636707183538287e+00, -3.169643258812233e-03, -1.351629309374522e-05,
 -3.126976287574629e-09,  3.247546602874325e-10,  1.452747942605013e-12, -5.092769216413820e-15, -7.694316000224322e-17, -1.328820615677017e-19,  2.649878833300540e-21,
  1.765250596573391e-23, -3.995596697173649e-26,  1.736433261199659e+00, -2.573773959135226e-03, -1.416644871357643e-05, -3.333939168213124e-08,  1.859232832533564e-10,
  2.174199598892091e-12,  6.220621817013074e-15, -4.917034949919476e-17, -5.742451264546457e-19, -1.445058795656330e-21,  1.742330532809306e-23,  1.823540205037554e-25,
  1.826418019574814e+00, -1.875947399392323e-03, -1.274231116155681e-05, -5.537425395197076e-08, -5.474208130405273e-11,  1.458487636688447e-12,  1.358765436247719e-14,
  4.860667456644722e-17, -2.056590022696334e-19, -3.998344882697063e-21, -2.398435286703736e-23, -6.054604741526773e-27,  1.902151611289344e+00, -1.151923825094839e-03,
 -9.246787443043375e-06, -5.693037321740646e-08, -2.495385214487187e-10, -3.766776960480153e-13,  6.045171810186100e-15,  7.577049726252530e-17,  4.946754765759471e-19,
  1.517955706083435e-21, -8.383945846430080e-24, -1.653764385918579e-25,  1.958811020887887e+00, -5.171190556112254e-04, -4.683642647734480e-06, -3.572713568092012e-08,
 -2.367261511753165e-10, -1.339168760619114e-12, -5.920221097380842e-15, -1.268719097782314e-17,  1.085678495275809e-19,  1.851127645986504e-21,  1.701119785870870e-23,
  1.161102661059831e-25,  1.992025902080152e+00, -1.039808614909522e-04, -1.009544446233240e-06, -8.629615795207157e-09, -6.832907341755558e-11, -5.117405472047399e-13,
 -3.658917295350130e-15, -2.505635310112298e-17, -1.641708119418979e-19, -1.023634379896671e-21, -6.002834397347496e-24, -3.231352790451580e-26,  6.372346840397215e-04,
 -3.620358636452951e-06,  1.542123321410156e-08, -5.838685438556842e-11,  2.070859695682023e-13, -7.053921897085761e-16,  2.330878175526725e-18, -7.568240196159214e-21,
  2.397705935433357e-23, -7.638913376976947e-26,  2.301924015450751e-28, -7.660914032117105e-31,  5.735884326754756e-03, -3.255261390195789e-05,  1.382940841498833e-07,
 -5.210736546962592e-10,  1.834021529864099e-12, -6.177968619369045e-15,  2.010226014802399e-17, -6.396671163280631e-20,  1.973195479282170e-22, -6.091744027450886e-25,
  1.752495015542495e-27, -5.638140068503672e-30,  1.593728345588366e-02, -9.025272314939229e-05,  3.813776816218245e-07, -1.422910835461757e-09,  4.929803604375962e-12,
 -1.622328722556514e-14,  5.107078024770398e-17, -1.553799205732261e-19,  4.503432945864630e-22, -1.285930047190991e-24,  3.253065973964469e-27, -9.494077484365555e-30,
  3.124954179354950e-02, -1.763864203923504e-04,  7.392931328574948e-07, -2.716702408509488e-09,  9.181182687979977e-12, -2.908965556690769e-14,  8.655138898313914e-17,
 -2.425619559190315e-19,  6.187242909459978e-22, -1.463701598216590e-24,  2.368420532450240e-27, -4.196376674551175e-30,  5.168459130171640e-02, -2.904384112176327e-04,
  1.203834682867043e-06, -4.331374846524896e-09,  1.412607130040964e-11, -4.227321848275908e-14,  1.146896224276326e-16, -2.753854942723041e-19,  5.117257755166271e-22,
 -4.950094996666160e-25, -2.803077636946363e-27,  1.457681520649899e-29,  7.725788476075809e-02, -4.316950224477319e-04,  1.763802984526941e-06, -6.171725548087935e-09,
  1.916423196450194e-11, -5.267688896418230e-14,  1.219064377808335e-16, -2.031065331841525e-19, -2.621261998899247e-23,  1.949248518449977e-24, -1.220159550859483e-26,
  4.117148486858001e-29,  1.079879545886585e-01, -5.992199039523010e-04,  2.404780217855508e-06, -8.118241778638983e-09,  2.357389156508660e-11, -5.683978594406672e-14,
  9.487472987411985e-17,  1.248430416134224e-20, -1.043471263364204e-21,  5.551003953396805e-24, -2.259432454622349e-26,  5.689542183603202e-29,  1.438957936519666e-01,
 -7.918217072392629e-04,  3.108845943674141e-06, -1.002715334813132e-08,  2.653655817431758e-11, -5.125196275821235e-14,  2.304306066032109e-17,  3.818274526187917e-19,
 -2.410035565179755e-21,  9.107569259472766e-24, -2.730112790311989e-26,  3.354759351086949e-29,  1.850040039213871e-01, -1.008012297718055e-03,  3.854234003368159e-06,
 -1.173096672282962e-08,  2.717319810489017e-11, -3.277190533810563e-14, -9.831756395998653e-17,  8.717676139811131e-19, -3.764143122567293e-21,  1.051397669346738e-23,
 -1.756851726412421e-26, -5.374484217764648e-29,  2.313356376475764e-01, -1.245953621797967e-03,  4.614933957238452e-06, -1.303984990647957e-08,  2.459600755988990e-11,
  8.350473018208505e-16, -2.646529885563921e-16,  1.391711694568381e-18, -4.501333166653960e-21,  7.117506043825913e-24,  1.382133383506091e-26, -2.042878745173001e-28,
  2.829126269771395e-01, -1.503390834031394e-03,  5.360246636092485e-06, -1.374441262963591e-08,  1.798127818202271e-11,  5.022286992713596e-14, -4.585185401430886e-16,
  1.785959437458531e-18, -3.838685765699026e-21, -3.405779354157310e-24,  6.660818863105510e-26, -3.654622090017767e-28,  3.397536583447046e-01, -1.777568688176661e-03,
  6.054314220104095e-06, -1.362067701663627e-08,  6.670218628714491e-12,  1.136533196268971e-13, -6.463641079692122e-16,  1.838603355990466e-18, -9.934430075857053e-22,
 -2.156879435233132e-23,  1.257850655109855e-25, -4.162445577372074e-28,  4.018712929238423e-01, -2.065127521584895e-03,  6.655663845348044e-06, -1.243838772602109e-08,
 -9.694217355027283e-12,  1.860724967469861e-13, -7.766899393313461e-16,  1.300081345008684e-18,  4.486441791665771e-21, -4.409409850566223e-23,  1.560064849066431e-25,
 -1.856684276251247e-28,  4.692680572375481e-01, -2.361974465084955e-03,  7.116834857805959e-06, -9.974299279610349e-09, -3.098607618328027e-11,  2.581574733926757e-13,
 -7.812166897303205e-16, -5.300170908376953e-20,  1.222462797551842e-20, -6.195519678956463e-23,  1.036365265291724e-25,  4.606164050221390e-28,  5.419311191508432e-01,
 -2.663124919558872e-03,  7.384211072998653e-06, -6.032729189158479e-09, -5.636412244718497e-11,  3.155186086535663e-13, -5.816372814914853e-16, -2.312577001619457e-18,
  2.040224040412866e-20, -5.967782012453864e-23, -8.439623329771276e-26,  1.441664612743763e-27,  6.198250102093975e-01, -2.962509141196802e-03,  7.398262585982275e-06,
 -4.764777838874536e-10, -8.398867140883505e-11,  3.384223761576608e-13, -1.056195076690403e-16, -5.281607834711691e-18,  2.522254567530521e-20, -1.817749921692657e-23,
 -4.150999036774335e-25,  2.221249489757170e-27,  7.028816363099414e-01, -3.252739559888005e-03,  7.094534745453108e-06,  6.727897634599042e-09, -1.107045110326703e-10,
  3.026887312057060e-13,  6.833995247376471e-16, -8.277458128943556e-18,  2.091345701445428e-20,  7.560321169127998e-23, -7.762410953856708e-25,  1.677633935283406e-27,
  7.909865083388238e-01, -3.524837390530575e-03,  6.405930686594484e-06,  1.544581092143946e-08, -1.317430370067593e-10,  1.828406357610799e-13,  1.738626485291351e-15,
 -9.957646300085954e-18,  1.114237370790166e-21,  2.094007405775559e-22, -8.655949801785710e-25, -1.508239421339002e-27,  8.839596877610015e-01, -3.767924447094493e-03,
  5.267151838526378e-06,  2.528711608281167e-08, -1.405673438830495e-10, -4.089929062426531e-14,  2.865283860523931e-15, -8.325499304984527e-18, -3.715464334660539e-20,
  3.189393009941469e-22, -2.204547162226258e-25, -7.355539787837412e-27,  9.815293380596990e-01, -3.968902096170954e-03,  3.622621340343806e-06,  3.549435055043950e-08,
 -1.291104685662133e-10, -3.698123347940924e-13,  3.654263952969128e-15, -1.224913268254366e-18, -8.604386406906551e-20,  2.717679004306507e-22,  1.464086546624100e-24,
 -1.187651330621920e-26,  1.083294965421714e+00, -4.112171791530945e-03,  1.439820065652971e-06,  4.481596747024906e-08, -8.885881132958771e-11, -7.667403000103462e-13,
  3.462660026937598e-15,  1.221947925824418e-17, -1.175947711926195e-19, -8.990288919458098e-23,  3.555952599685936e-24, -5.530414128534193e-27,  1.188676425737944e+00,
 -4.179514282739677e-03, -1.269408013131803e-06,  5.139844729658941e-08, -1.349206087588192e-11, -1.131190163227721e-12,  1.548822234178863e-15,  2.889558196143051e-17,
 -8.167913894732502e-20, -7.710943861721505e-22,  3.588428873912750e-24,  1.970098296911505e-26,  1.296843708541108e+00, -4.150359547733054e-03, -4.416856033756476e-06,
  5.278270717455689e-08,  9.605638911469311e-11, -1.281951521159218e-12, -2.465244319432321e-15,  3.856626862302615e-17,  6.694737008496791e-20, -1.301744829470574e-21,
 -1.885415710296380e-24,  4.651276586319238e-26,  1.406621876872436e+00, -4.002877167584579e-03, -7.794187847276310e-06,  4.618176389451733e-08,  2.237757204041657e-10,
 -9.810370323285922e-13, -7.678409716627163e-15,  2.444204634104773e-17,  2.873561288922166e-19, -6.284655468012686e-22, -1.139671737239090e-23,  1.395898068734463e-26,
  1.516366673451430e+00, -3.716621357116625e-03, -1.102298520157086e-05,  2.933780187610779e-08,  3.302113436965781e-10, -6.000122193577157e-14, -1.090616446474882e-14,
 -2.370267315801297e-17,  3.545464542789247e-19,  1.774258964578521e-21, -1.035800164737767e-23, -1.001769610710147e-25,  1.623812239721616e+00, -3.277833203793152e-03,
 -1.352170507972078e-05,  2.294157009027398e-09,  3.524107556108066e-10,  1.304280994886167e-12, -7.291420274829466e-15, -7.953708106855206e-17, -2.533216039349603e-20,
  3.306268287841540e-21,  1.479882910083370e-23, -9.040332692515297e-26,  1.725909044204939e+00, -2.688651913504740e-03, -1.454721290112067e-05, -3.000914154849543e-08,
  2.307777894218863e-10,  2.304853948242253e-12,  4.579820584456639e-15, -6.822811869450697e-17, -6.117559645081267e-19, -5.843393983839950e-22,  2.565703513771738e-23,
  1.883043717950445e-25,  1.818706126604946e+00, -1.980556408467885e-03, -1.341103622439283e-05, -5.599860334174797e-08, -2.220548342505934e-11,  1.800039906950280e-12,
  1.483354910579129e-14,  3.953793762305660e-17, -3.667660598353957e-19, -4.944392642905334e-21, -2.280643680703451e-23,  6.422915224204084e-26,  1.897391544172896e+00,
 -1.228699174652766e-03, -9.954128642412832e-06, -6.097462095017566e-08, -2.554399375088105e-10, -2.042981336126162e-13,  8.396025910680991e-15,  9.239432823335699e-17,
  5.413527244382184e-19,  1.017213220357080e-21, -1.716789645293404e-23, -2.359902259212592e-25,  1.956664797470357e+00, -5.563695750796077e-04, -5.136003156013049e-06,
 -3.973685395210493e-08, -2.649568458631968e-10, -1.485057854119936e-12, -6.215809147304692e-15, -8.004956907866760e-18,  1.887630780914448e-19,  2.642056556684831e-21,
  2.274417893902585e-23,  1.447439593311277e-25,  1.991593142767810e+00, -1.124908342001451e-04, -1.120013309313505e-06, -9.809780355268179e-09, -7.950207110054231e-11,
 -6.086029168668620e-13, -4.439930762157170e-15, -3.094868678472385e-17, -2.057064329334081e-19, -1.294407392014189e-21, -7.593027964830173e-24, -4.016580631818534e-26,
  6.229956299562548e-04, -3.499736065167333e-06,  1.474001530815764e-08, -5.518337267941551e-11,  1.935208092941062e-13, -6.519098202324134e-16,  2.129308050114962e-18,
 -6.843261753949256e-21,  2.138489643647691e-23, -6.783056393236636e-26,  1.983127327011790e-28, -6.869451345696137e-31,  5.607847666990091e-03, -3.147078313350615e-05,
  1.322132721794960e-07, -4.926921682314272e-10,  1.715145226652787e-12, -5.716313475145663e-15,  1.839638822344627e-17, -5.799031669165828e-20,  1.765927620847082e-22,
 -5.438757166272876e-25,  1.516098133914249e-27, -5.136153236229092e-30,  1.558226832603787e-02, -8.726868474389115e-05,  3.647655171233172e-07, -1.346564557908850e-09,
  4.617250683168275e-12, -1.504820960895320e-14,  4.691511117348726e-17, -1.416853256198760e-19,  4.062926393432459e-22, -1.164024139288094e-24,  2.845116907508530e-27,
 -9.099231809610232e-30,  3.055562180091114e-02, -1.706000232577240e-04,  7.075552576998475e-07, -2.574347236936566e-09,  8.619623137941703e-12, -2.709173378570848e-14,
  8.002904929704553e-17, -2.235879712914729e-19,  5.676881909346060e-22, -1.373056405928830e-24,  2.153599535950710e-27, -5.606423555626807e-30,  5.054177516818751e-02,
 -2.810118607524588e-04,  1.153186864594688e-06, -4.111974454005246e-09,  1.330751735637136e-11, -3.961136388044628e-14,  1.072052552831668e-16, -2.593158707948207e-19,
  4.920280064516426e-22, -5.958180811798856e-25, -2.274751896287170e-27,  9.434221535290308e-30,  7.555886372236781e-02, -4.178757077724140e-04,  1.691547787118989e-06,
 -5.873369107376799e-09,  1.813949085796412e-11, -4.981941148058151e-14,  1.162176090909652e-16, -2.029133829641900e-19,  3.558739642453068e-23,  1.494739343735078e-24,
 -1.059021756976099e-26,  3.205105899520404e-29,  1.056289434094401e-01, -5.803650113086994e-04,  2.309587296760589e-06, -7.750030109429941e-09,  2.245987535661348e-11,
 -5.456219236236102e-14,  9.478564126500760e-17, -1.787909322227686e-20, -8.593247139582949e-22,  4.694536845525696e-24, -2.029955980512246e-26,  4.720207936066203e-29,
  1.407774963820505e-01, -7.674251027970961e-04,  2.991033893682752e-06, -9.610735201215966e-09,  2.551787145800372e-11, -5.057905447699003e-14,  3.270233751023327e-17,
  3.097443703794734e-19, -2.101468505836595e-21,  8.044513095711833e-24, -2.587177805137612e-26,  3.078105005123857e-29,  1.810327412889308e-01, -9.777341715899398e-04,
  3.716049007057961e-06, -1.130155920533082e-08,  2.649607207351633e-11, -3.485187931798601e-14, -7.553849767128727e-17,  7.572310992937576e-19, -3.398818872311182e-21,
  9.768266962161468e-24, -1.962305446323855e-26, -4.085763602943511e-29,  2.264246805189022e-01, -1.209653373729783e-03,  4.460816443826388e-06, -1.264651232612738e-08,
  2.455226508708410e-11, -5.065045967444534e-15, -2.276624765443096e-16,  1.251858439859944e-18, -4.237226687944033e-21,  7.500469715372212e-24,  5.554879292652762e-27,
 -1.729995740948346e-28,  2.769837900124975e-01, -1.461163629303625e-03,  5.197071143406561e-06, -1.344925767638370e-08,  1.887966953331127e-11,  3.980453097515729e-14,
 -4.102463519463960e-16,  1.661643197284857e-18, -3.917109632212908e-21, -1.051971715678596e-24,  5.134629414820456e-26, -3.292556452001205e-28,  3.327392202303991e-01,
 -1.729785985249504e-03,  5.891578765492569e-06, -1.349659441621329e-08,  8.792306101306308e-12,  9.875407584010029e-14, -5.954382909252540e-16,  1.795324821628561e-18,
 -1.683763029162022e-21, -1.690302626283921e-23,  1.075305304437090e-25, -4.126155187490013e-28,  3.937163247836583e-01, -2.012481613947435e-03,  6.505592109359439e-06,
 -1.256472375762321e-08, -6.156146647104434e-12,  1.678835643954669e-13, -7.385078869962906e-16,  1.419436046966197e-18,  3.009164818266859e-21, -3.804383223985314e-23,
  1.458897110891375e-25, -2.705313379248798e-28,  4.599332592985458e-01, -2.305526595019124e-03,  6.994335687688957e-06, -1.042978974475908e-08, -2.601031911321453e-11,
  2.394326371547478e-13, -7.775534914960154e-16,  3.033359572336490e-19,  1.007314493087096e-20, -5.746970569941452e-23,  1.190764314860847e-25,  2.461384800572928e-28,
  5.313962873444994e-01, -2.604355658460614e-03,  7.306613095404158e-06, -6.884851340016592e-09, -5.019821536834908e-11,  3.008540570832591e-13, -6.375761629319840e-16,
 -1.694612527409790e-18,  1.820755010968724e-20, -6.187404517504330e-23, -2.761523850865373e-26,  1.139707771409929e-27,  6.080932780587994e-01, -2.903368243096986e-03,
  7.384704719297611e-06, -1.766335322941510e-09, -7.725708286317262e-11,  3.342033779231534e-13, -2.423249563350196e-16, -4.487972747807574e-18,  2.429241477648844e-20,
 -3.287448649444796e-23, -3.210818132983765e-25,  2.038705450470046e-27,  6.899846600494157e-01, -3.195689988973883e-03,  7.164844333279421e-06,  5.005869397326647e-09,
 -1.045050930635141e-10,  3.163870212463961e-13,  4.613672357348853e-16, -7.570521545941926e-18,  2.309507190760028e-20,  4.613720812898141e-23, -6.947643253092202e-25,
  1.993015709690478e-27,  7.769907773443849e-01, -3.472884088042287e-03,  6.578760846223090e-06,  1.336934936252121e-08, -1.276914883751485e-10,  2.212326551051830e-13,
  1.461396553580073e-15, -9.808167050455008e-18,  8.016623691680579e-21,  1.737961620431660e-22, -9.064377450180279e-25, -3.835689980588181e-28,  8.689741321931275e-01,
 -3.724611723426924e-03,  5.557087653848041e-06,  2.303514948360103e-08, -1.407171933978932e-10,  2.494633623398093e-14,  2.617235028846868e-15, -9.333047315132011e-18,
 -2.590551213819019e-20,  3.040939142964879e-22, -5.105790674119987e-25, -5.815351505375896e-27,  9.657143389064798e-01, -3.938253045905272e-03,  4.035930256359384e-06,
  3.337416110070326e-08, -1.356340382527707e-10, -2.828232865797339e-13,  3.582964185338820e-15, -3.811500957562146e-18, -7.533239732843628e-20,  3.198496579768051e-22,
  9.406949963566424e-25, -1.178389050874474e-26,  1.066872685769458e+00, -4.098527369727065e-03,  1.968590106458748e-06,  4.327617200008035e-08, -1.033370719135950e-10,
 -6.799579593357636e-13,  3.751829008069187e-15,  8.431559730339594e-18, -1.183415307009444e-19,  4.617661425680342e-23,  3.217954589267100e-24, -9.655421977425559e-27,
  1.171941956931081e+00, -4.187207796159451e-03, -6.546611885558165e-07,  5.100387301442914e-08, -3.568024315324473e-11, -1.084629485471621e-12,  2.317339807161204e-15,
  2.586696832190809e-17, -1.066656662492963e-19, -6.123972453296773e-22,  4.291065584927478e-24,  1.211254986645233e-26,  1.280175646431936e+00, -4.183136666334205e-03,
 -3.775097623051529e-06,  5.411165342575633e-08,  6.991423414122753e-11, -1.327960758828972e-12, -1.362521863695940e-15,  3.994825461395258e-17,  1.922409551385935e-20,
 -1.335873206987895e-21,  1.799344355739305e-25,  4.664317743393178e-26,  1.390489254894029e+00, -4.062954633697548e-03, -7.219203449284583e-06,  4.959544793373676e-08,
  2.023728660471617e-10, -1.156091272123253e-12, -6.869316533906233e-15,  3.318905363705466e-17,  2.567327689634122e-19, -1.065588219688691e-21, -1.030226860884004e-23,
  3.549249686717023e-26,  1.501326176495952e+00, -3.803307391376603e-03, -1.063931751794727e-05,  3.459715968330597e-08,  3.263469472462607e-10, -3.283752769444256e-13,
 -1.140201923366915e-14, -1.142358698184128e-17,  4.099329933973201e-19,  1.275608431910070e-21, -1.445792999564107e-23, -8.417831945305043e-26,  1.610484871838210e+00,
 -3.385798952195679e-03, -1.345951580631053e-05,  8.131148651856404e-09,  3.765660520409007e-10,  1.102584702751819e-12, -9.511148851792961e-15, -7.833774560791387e-17,
  1.032513488659286e-19,  3.803464861902294e-21,  9.689275703880772e-24, -1.413126764061615e-25,  1.714919493732094e+00, -2.806403745158086e-03, -1.488362925410279e-05,
 -2.594263770631292e-08,  2.778077960498854e-10,  2.389620927099954e-12,  2.393709316029360e-15, -8.792679543279863e-17, -6.123528558562721e-19,  6.038884940203936e-22,
  3.360835556981752e-23,  1.681397437968191e-25,  1.810565063738463e+00, -2.090535807620130e-03, -1.408389954134940e-05, -5.604619136940700e-08,  1.743746408654340e-11,
  2.167833007082670e-12,  1.574832556265240e-14,  2.478449336983661e-17, -5.602613391759398e-19, -5.773101007060439e-21, -1.790895970610402e-23,  1.630446720629914e-25,
  1.892312748941563e+00, -1.311328700151396e-03, -1.071044321078512e-05, -6.508248403900147e-08, -2.572910621917147e-10,  3.023708383418518e-14,  1.123002896259414e-14,
  1.101493050303840e-16,  5.628986436387507e-19,  9.960477597745815e-23, -2.930011702701409e-23, -3.165121332463452e-25,  1.954354018332425e+00, -5.994393478521238e-04,
 -5.639287830480420e-06, -4.422194089506703e-08, -2.961640279530061e-10, -1.636149891058787e-12, -6.339756772028520e-15, -2.541617734369559e-19,  3.018651663650359e-19,
  3.687663988632167e-21,  2.974077064365747e-23,  1.727208623776396e-25,  1.991124481877085e+00, -1.219443989056653e-04, -1.245784143093813e-06, -1.118528821591520e-08,
 -9.281393931399550e-11, -7.263490896663334e-13, -5.406094492510637e-15, -3.833909797408475e-17, -2.582211480836185e-19, -1.636029739318974e-21, -9.552872590274524e-24,
 -4.904983868420318e-26,  6.092284050320920e-04, -3.384413080111873e-06,  1.409597139269286e-08, -5.218863246925561e-11,  1.809785165647692e-13, -6.030306382166969e-16,
  1.946920633761823e-18, -6.196542518880959e-21,  1.907866221182034e-23, -6.048479037295741e-26,  1.693675078843920e-28, -6.332706736486658e-31,  5.484043149559466e-03,
 -3.043626819628091e-05,  1.264619235606420e-07, -4.661410066778273e-10,  1.605105793168548e-12, -5.293664028610217e-15,  1.684891037698670e-17, -5.264135182285243e-20,
  1.580513586902629e-22, -4.876451723060583e-25,  1.297688296905148e-27, -4.826854362476287e-30,  1.523892923979017e-02, -8.441396229590317e-05,  3.490402612221259e-07,
 -1.275036406111463e-09,  4.327232206637812e-12, -1.396842201016935e-14,  4.312379353460173e-17, -1.293332549362839e-19,  3.663401800306109e-22, -1.058187194548412e-24,
  2.446946208376324e-27, -9.072540744817149e-30,  2.988435019809825e-02, -1.650608458378536e-04,  6.774730264479261e-07, -2.440665678460076e-09,  8.096498753806486e-12,
 -2.524415449184216e-14,  7.401559502896127e-17, -2.061967149830959e-19,  5.197449123864231e-22, -1.292335138974728e-24,  1.869422894903355e-27, -7.403587992506814e-30,
  4.943587123678748e-02, -2.719801802779300e-04,  1.105094995478839e-06, -3.905254635808837e-09,  1.254044032032474e-11, -3.712380914170943e-14,  1.001614939261849e-16,
 -2.439310075956192e-19,  4.690266407052954e-22, -6.800653234199300e-25, -1.977166484975478e-27,  3.991510722281477e-30,  7.391398614677488e-02, -4.046203880015916e-04,
  1.622776353773159e-06, -5.590958740535661e-09,  1.717053551259638e-11, -4.709819221175496e-14,  1.105594993339979e-16, -2.009927791265167e-19,  8.208781292029595e-23,
  1.096566474730561e-24, -9.388470515962023e-27,  2.241734825482142e-29,  1.033438562749250e-01, -5.622542874263441e-04,  2.218707472213861e-06, -7.399278678193450e-09,
  2.139132409699712e-11, -5.229630101212455e-14,  9.392436133522041e-17, -4.282626945071967e-20, -7.044653614444724e-22,  3.920898919008024e-24, -1.846505072072192e-26,
  3.582552394530991e-29,  1.377549317951541e-01, -7.439512826652683e-04,  2.878121550622150e-06, -9.210496447345478e-09,  2.451480326718624e-11, -4.969746266269340e-14,
  4.047584978714093e-17,  2.469338396662476e-19, -1.830182455328423e-21,  7.035001982304443e-24, -2.465482664643152e-26,  2.375046584827894e-29,  1.771804125720693e-01,
 -9.485411010236406e-04,  3.582950617371871e-06, -1.088328986321246e-08,  2.578256048957324e-11, -3.642234431070363e-14, -5.580693161513218e-17,  6.539405480769559e-19,
 -3.061702900297455e-21,  8.949495872075261e-24, -2.127808712342881e-26, -3.574614699612740e-29,  2.216564883677082e-01, -1.174567206124290e-03,  4.311411040691337e-06,
 -1.225477171871553e-08,  2.439908626617006e-11, -1.012339211210617e-14, -1.944679035793313e-16,  1.120615886279476e-18, -3.964979427470506e-21,  7.577447793170532e-24,
 -1.551766012938969e-27, -1.518659564503387e-28,  2.712212738152718e-01, -1.420227432149946e-03,  5.037517080283512e-06, -1.314133363644037e-08,  1.958099633306478e-11,
  3.050274486218357e-14, -3.654782360967342e-16,  1.536058363422740e-18, -3.921419221853325e-21,  7.211739403562882e-25,  3.751760677199568e-26, -3.009594417906023e-28,
  3.259133193763704e-01, -1.683298655004255e-03,  5.730526402863607e-06, -1.334087634295218e-08,  1.062852047811717e-11,  8.506016405051566e-14, -5.460092876182289e-16,
  1.732502990797487e-18, -2.219209420716134e-21, -1.296316129334725e-23,  8.950427410803642e-26, -4.070335339346272e-28,  3.857695308472924e-01, -1.961041409290605e-03,
  6.354332155244074e-06, -1.263731005497892e-08, -2.972446961240282e-12,  1.506459609360258e-13, -6.976135763769461e-16,  1.494917797327927e-18,  1.741567995774851e-21,
 -3.246705462960978e-23,  1.324607265153273e-25, -3.377613612840137e-28,  4.508222601090346e-01, -2.250079256865070e-03,  6.866835970686692e-06, -1.080865603945752e-08,
 -2.140741098618962e-11,  2.209078203869936e-13, -7.648516821094583e-16,  5.935110571441436e-19,  8.092059218136650e-21, -5.254695940719481e-23,  1.256959592617112e-25,
  5.859109699325370e-29,  5.210952285913821e-01, -2.546246428655035e-03,  7.219371679918107e-06, -7.640732510708776e-09, -4.433766437841373e-11,  2.850466143960359e-13,
 -6.772041713021117e-16, -1.147730741793911e-18,  1.597148644737449e-20, -6.206353174749956e-23,  1.598043891009584e-26,  8.430843470123955e-28,  5.965977971206222e-01,
 -2.844395897634240e-03,  7.356311453147246e-06, -2.949333260001520e-09, -7.064090298917887e-11,  3.269662836108974e-13, -3.572997843801480e-16, -3.731858587775368e-18,
  2.289874118008090e-20, -4.399397696043680e-23, -2.367456731199904e-25,  1.784552021487916e-27,  6.773168785575056e-01, -3.138158893496562e-03,  7.215092848094095e-06,
  3.384940903498979e-09, -9.808335701613910e-11,  3.250009987016868e-13,  2.599516892367157e-16, -6.810093006484770e-18,  2.427739575156698e-20,  2.015071341488127e-23,
 -6.036420461672368e-25,  2.119425766644840e-27,  7.632054686611592e-01, -3.419646656394557e-03,  6.727086588462781e-06,  1.136349565379724e-08, -1.229381715888737e-10,
  2.530451468467656e-13,  1.191249911554514e-15, -9.458542074552032e-18,  1.361917019581449e-20,  1.374818259180374e-22, -9.027711971729347e-25,  5.095776809137116e-28,
  8.541662954152179e-01, -3.679087550453401e-03,  5.820027870319238e-06,  2.079098826965600e-08, -1.396117393667944e-10,  8.454036127356978e-14,  2.345918926459431e-15,
 -9.991279962570327e-18, -1.538318499562346e-20,  2.790173981038524e-22, -7.318164496443346e-25, -4.248106532553158e-27,  9.500283854309503e-01, -3.904400936316062e-03,
  4.423227682326849e-06,  3.116339590039754e-08, -1.404405988619838e-10, -1.983743382109889e-13,  3.444270222648652e-15, -6.031645873601793e-18, -6.326383008977104e-20,
  3.472962214925457e-22,  4.374152319346164e-25, -1.099331957250301e-26,  1.050513321717742e+00, -4.080730501686219e-03,  2.477551087877284e-06,  4.151895055883844e-08,
 -1.160188712441658e-10, -5.875065795316201e-13,  3.935317592363573e-15,  4.695180839069793e-18, -1.144735473325981e-19,  1.654357628825742e-22,  2.723350729868601e-24,
 -1.262743368257369e-26,  1.155186511613151e+00, -4.190008232600136e-03, -4.674542714108299e-08,  5.026270928264126e-08, -5.676008044729882e-11, -1.020726894975031e-12,
  2.990755938670114e-15,  2.213495578876556e-17, -1.255152480678165e-19, -4.324349969766639e-22,  4.649083764780038e-24,  4.166137596751671e-27,  1.263386834863889e+00,
 -4.210723099434914e-03, -3.119927183952924e-06,  5.501641171230751e-08,  4.311878755084758e-11, -1.347213443960736e-12, -2.425551648951001e-16,  3.979931702927910e-17,
 -2.825099220443311e-20, -1.288545683720155e-21,  2.156452716556139e-24,  4.253546619668023e-26,  1.374125773681149e+00, -4.118274448192203e-03, -6.605421412697592e-06,
  5.263981377877397e-08,  1.776823147247829e-10, -1.308913208337461e-12, -5.831321338195286e-15,  4.071459340465450e-17,  2.113830711725160e-19, -1.440708468145241e-21,
 -8.319181228517448e-24,  5.393050454886448e-26,  1.485945471771248e+00, -3.886673097643905e-03, -1.019308741647128e-05,  3.975122098076715e-08,  3.170248741947806e-10,
 -6.043414764526550e-13, -1.153216176385075e-14,  2.310581989402126e-18,  4.446177801595603e-19,  6.305318502973694e-22, -1.759545095080925e-23, -5.669855416310175e-26,
  1.596727088448789e+00, -3.492980765863993e-03, -1.332510616864834e-05,  1.431947908467277e-08,  3.961598755320139e-10,  8.484978808688644e-13, -1.163730601039879e-14,
 -7.278109687529915e-17,  2.455285322233561e-19,  4.053060706658806e-21,  2.473130938905777e-24, -1.847501073778309e-25,  1.703453880530212e+00, -2.926638813893360e-03,
 -1.516668647961842e-05, -2.111312877346904e-08,  3.259639633473799e-10,  2.415341988521033e-12, -3.373767327530281e-16, -1.069010570793835e-16, -5.647469868338871e-19,
  2.083048080307701e-21,  3.996081372173468e-23,  1.147026345915314e-25,  1.801973329814408e+00, -2.205889048605749e-03, -1.475328199902482e-05, -5.539960585120762e-08,
  6.461863174952620e-11,  2.551897911135599e-12,  1.615915592726702e-14,  3.408661114775339e-18, -7.789428895495241e-19, -6.310988581523484e-21, -8.078921012259944e-24,
  2.873286482271994e-25,  1.886891022167997e+00, -1.400206041784575e-03, -1.151606261582580e-05, -6.917857394405958e-08, -2.537307931343299e-10,  3.387979117410445e-13,
  1.456514955377606e-14,  1.279645430572612e-16,  5.418112221977579e-19, -1.375114154330362e-21, -4.502359045764845e-23, -3.969109596251753e-25,  1.951862554394818e+00,
 -6.467594008593246e-04, -6.199489461705487e-06, -4.923059749468871e-08, -3.304029509417510e-10, -1.787166656334221e-12, -6.189954936463000e-15,  1.177450605061791e-17,
  4.579296079169009e-19,  5.036121500900947e-21,  3.782962551729823e-23,  1.927664971740528e-25,  1.990615884497125e+00, -1.324739630101135e-04, -1.389421004892232e-06,
 -1.279395915723505e-08, -1.087304033800238e-10, -8.699681871759322e-13, -6.604677544866450e-15, -4.762266055280324e-17, -3.245412256459823e-19, -2.064033012707072e-21,
 -1.191443935880158e-23, -5.824319949976608e-26,  5.959123902255632e-04, -3.274102037572528e-06,  1.348669180597162e-08, -4.938698009704907e-11,  1.693714591642877e-13,
 -5.583195594075767e-16,  1.781646349529733e-18, -5.619610955308685e-21,  1.701652713857319e-23, -5.425818740401090e-26,  1.421273401060097e-28, -6.108520997489924e-31,
  5.364286646763754e-03, -2.944651889341291e-05,  1.210188976431897e-07, -4.412848203203583e-10,  1.503159746602089e-12, -4.906422033152100e-15,  1.544318943131772e-17,
 -4.785498655142828e-20,  1.413796685471713e-22, -4.399469906287957e-25,  1.087654709803939e-27, -4.769117770016799e-30,  1.490676276613657e-02, -8.168168581913353e-05,
  3.341461983291872e-07, -1.207980612764387e-09,  4.057926848253460e-12, -1.297561679649711e-14,  3.966098601937253e-17, -1.182017809268003e-19,  3.299101426528582e-22,
 -9.684005540769630e-25,  2.038529380903665e-27, -9.607541056947774e-30,  2.923476395182285e-02, -1.597560490848401e-04,  6.489459484032951e-07, -2.315066176507750e-09,
  7.608921285025284e-12, -2.353522539854264e-14,  6.846803762020570e-17, -1.902955080446585e-19,  4.744821609104391e-22, -1.224764483616020e-24,  1.490122612485703e-27,
 -1.002210142212538e-29,  4.836533997843909e-02, -2.633235171278789e-04,  1.059411737215678e-06, -3.710419081563441e-09,  1.182145832771648e-11, -3.480022126654268e-14,
  9.353776178293862e-17, -2.293288989038551e-19,  4.431468216761166e-22, -7.574417820530063e-25, -1.938866435801653e-27, -2.510204118287941e-30,  7.232105060383380e-02,
 -3.919019434673612e-04,  1.557302597278006e-06, -5.323623621169768e-09,  1.625465177612911e-11, -4.451196704272234e-14,  1.049739050035125e-16, -1.978050815559430e-19,
  1.150139020871815e-22,  7.376156836983078e-25, -8.640650429219935e-27,  1.118706827840373e-29,  1.011297842100618e-01, -5.448540532818871e-04,  2.131935575145909e-06,
 -7.065262875351195e-09,  2.036783016357830e-11, -5.005892791296801e-14,  9.242984562479892e-17, -6.325042146585624e-20, -5.762634229015954e-22,  3.209876198958521e-24,
 -1.719044459424278e-26,  2.145864844830161e-29,  1.348244859261094e-01, -7.213618212493091e-04,  2.769916391155314e-06, -8.826156173912122e-09,  2.353109502978296e-11,
 -4.864946318280557e-14,  4.660680292301324e-17,  1.922316850055819e-19, -1.594450830611753e-21,  6.066453852371865e-24, -2.386491295268201e-26,  1.102602576189648e-29,
  1.734427580747771e-01, -9.203929369462944e-04,  3.454802006883613e-06, -1.047666321262173e-08,  2.504214710147126e-11, -3.755276601623987e-14, -3.882099352005703e-17,
  5.609536058521761e-19, -2.755223564713330e-21,  8.066414388331068e-24, -2.290727251343004e-26, -4.009982097405196e-29,  2.170262801041613e-01, -1.140657527272953e-03,
  4.166688618012628e-06, -1.186624925380222e-08,  2.415241465337617e-11, -1.442818091712666e-14, -1.648261203545996e-16,  9.980763347591892e-19, -3.694885111598759e-21,
  7.385256231153728e-24, -7.996232194363224e-27, -1.434893026361018e-28,  2.656199731950172e-01, -1.380552710151818e-03,  4.881719479668432e-06, -1.282361947098564e-08,
  2.010674708799571e-11,  2.223323666387848e-14, -3.242195779801004e-16,  1.411252441852195e-18, -3.871581593046262e-21,  1.962766034869892e-24,  2.467692767899129e-26,
 -2.852953530339472e-28,  3.192708035182817e-01, -1.638091790141299e-03,  5.571510102785869e-06, -1.315790604139633e-08,  1.220256763164686e-11,  7.252963012224764e-14,
 -4.985588426454168e-16,  1.654677500507184e-18, -2.625749442339027e-21, -9.740551179250118e-24,  7.162429281543087e-26, -4.074726651399613e-28,  3.780260732421663e-01,
 -1.910813928294118e-03,  6.202495598419593e-06, -1.266166120927358e-08, -1.235364330098754e-13,  1.344107808292823e-13, -6.551442502861082e-16,  1.532939406741482e-18,
  6.643815342708117e-22, -2.748367332126579e-23,  1.162708285874540e-25, -3.980641475603291e-28,  4.419309832133740e-01, -2.195668878075082e-03,  6.735219571844004e-06,
 -1.111682057594962e-08, -1.717132896540789e-11,  2.027783474568708e-13, -7.448855816914340e-16,  8.231622562292527e-19,  6.291026353112232e-21, -4.751840550025461e-23,
  1.244964204886709e-25, -1.112650590878689e-28,  5.110251556662518e-01, -2.488869842737453e-03,  7.123611716853258e-06, -8.305420670437203e-09, -3.880157440885435e-11,
  2.684637712814959e-13, -7.025200194579182e-16, -6.722009877303364e-19,  1.375686281196774e-20, -6.076827501634171e-23,  4.666413701660779e-26,  5.520946595059970e-28,
  5.853376638891206e-01, -2.785705694539847e-03,  7.314352122324041e-06, -4.027773078316178e-09, -6.419537162482825e-11,  3.172184610972097e-13, -4.517834504023066e-16,
 -3.026118656012664e-18,  2.116263451864111e-20, -5.198089681215596e-23, -1.648585476357361e-25,  1.474558446826300e-27,  6.648799047142797e-01, -3.080301856333153e-03,
  7.246511562031008e-06,  1.867883082324910e-09, -9.153593797947507e-11,  3.290399432611089e-13,  8.022224717270893e-17, -6.026087072697847e-18,  2.459068558268618e-20,
 -2.130867859932476e-24, -5.107542774281031e-25,  2.076065666408112e-27,  7.496353323576831e-01, -3.365317560800506e-03,  6.851818269692534e-06,  9.438436418574720e-09,
 -1.176125476284239e-10,  2.785106468538994e-13,  9.332068018978250e-16, -8.950451902013346e-18,  1.792583922677825e-20,  1.020260061343959e-22, -8.653815008617410e-25,
  1.146160987782151e-27,  8.395445923574044e-01, -3.631567186546923e-03,  6.056182446328850e-06,  1.857368997492732e-08, -1.373808206812574e-10,  1.374387905325381e-13,
  2.060739197229185e-15, -1.032881645077699e-17, -5.906472450936724e-21,  2.464480994859590e-22, -8.860001811993456e-25, -2.787927189306464e-27,  9.344838674563499e-01,
 -3.867557744347533e-03,  4.783589590697202e-06,  2.888903636485223e-08, -1.435962734318310e-10, -1.179555977556198e-13,  3.248940203999899e-15, -7.853594766589030e-18,
 -5.055967201115478e-20,  3.554681758419928e-22, -1.944686867151093e-26, -9.710417715991043e-27,  1.034233150282268e+00, -4.058949599967412e-03,  2.964269655754782e-06,
  3.957381654891500e-08, -1.268159912231652e-10, -4.918890858023201e-13,  4.016537255028916e-15,  1.147217875663922e-18, -1.066966214296955e-19,  2.626515692057680e-22,
  2.124583858629232e-24, -1.439407352698766e-26,  1.138429526913567e+00, -4.187986549868354e-03,  5.502976254713440e-07,  4.919533402572589e-08, -7.640903681707776e-11,
 -9.419783654326231e-13,  3.552220818713813e-15,  1.790549764310901e-17, -1.377122022744834e-19, -2.450825338623468e-22,  4.663359954370482e-24, -3.400599513686179e-27,
  1.246498218735988e+00, -4.233032048781772e-03, -2.456479995575713e-06,  5.549081837938127e-08,  1.620586289609968e-11, -1.339806531458337e-12,  8.523349801676029e-16,
  3.817327386297217e-17, -7.265313201494852e-20, -1.166901312951873e-21,  3.869236753936946e-24,  3.478980948770584e-26,  1.357551055318750e+00, -4.168544815815841e-03,
 -5.957573568568416e-06,  5.526610137733664e-08,  1.502006131192550e-10, -1.434470555874129e-12, -4.604839910189504e-15,  4.658968646810831e-17,  1.541395173165431e-19,
 -1.721723002890476e-21, -5.636445799477261e-24,  6.696158122205812e-26,  1.470238831478458e+00, -3.966224523674866e-03, -9.686085823783268e-06,  4.471193753454740e-08,
  3.021839462184185e-10, -8.787132576822122e-13, -1.126585805258476e-14,  1.676141951670948e-17,  4.541387200030257e-19, -1.129957978351649e-22, -1.931558494760583e-23,
 -2.033662419827458e-26,  1.582543205664524e+00, -3.598785336974487e-03, -1.311473206991495e-05,  2.077794653425892e-08,  4.101769739150098e-10,  5.457710179488745e-13,
 -1.354320370727010e-14, -6.258702383387259e-17,  3.911712859000897e-19,  3.979899430117886e-21, -6.331528832452831e-24, -2.121330605744108e-25,  1.691503183693751e+00,
 -3.048893410450207e-03, -1.538716165078127e-05, -1.551274402181332e-08,  3.739371620313654e-10,  2.369364606164878e-12, -3.570089590632867e-15, -1.234561297687586e-16,
 -4.599812417928125e-19,  3.758611554952889e-21,  4.316305000253834e-23,  2.492043730899920e-26,  1.792909540837905e+00, -2.326552893679881e-03, -1.541012141091976e-05,
 -5.393635346778748e-08,  1.195270644998267e-10,  2.937834803935023e-12,  1.587118728830637e-14, -2.518788237318400e-17, -1.008542734406019e-18, -6.341009623436237e-21,
  7.587484182693751e-24,  4.255927435350580e-25,  1.881100586836693e+00, -1.495723484478610e-03, -1.237027511755391e-05, -7.316381325745389e-08, -2.431590922114818e-10,
  7.332577390074122e-13,  1.838076392789960e-14,  1.441274441351440e-16,  4.554932561993806e-19, -3.545599286388333e-21, -6.394894517936995e-23, -4.579661071236857e-25,
  1.949172452913141e+00, -6.988110230846991e-04, -6.823180608405936e-06, -5.481091894046679e-08, -3.675958606475442e-10, -1.929935090742917e-12, -5.625681826042425e-15,
  2.963783845743070e-17,  6.685311215528310e-19,  6.720720727043552e-21,  4.639291626778790e-23,  1.913886610035716e-25,  1.990062741998884e+00, -1.442343964047375e-04,
 -1.553990002237405e-06, -1.468192841443070e-08, -1.278292666900084e-10, -1.045727276682500e-12, -8.095362608044288e-15, -5.929400642742108e-17, -4.080652977886978e-19,
 -2.594345479450478e-21, -1.465818635924670e-23, -6.601440240071861e-26,  5.830280796721444e-04, -3.168533842945332e-06,  1.290994659608970e-08, -4.676409702749417e-11,
  1.586202283070375e-13, -5.173884714564587e-16,  1.631634519507300e-18, -5.105290234383216e-21,  1.515907000930530e-23, -4.911317193166880e-26,  1.149684712084775e-28,
 -6.325192190529696e-31,  5.248403903449017e-03, -2.849914785334359e-05,  1.158646089054435e-07, -4.179996005474380e-10,  1.408631717355579e-12, -4.551367877808768e-15,
  1.416426437961693e-17, -4.357626335826613e-20,  1.262736285745653e-22, -4.006972571481890e-25,  8.725643414576506e-28, -5.084055217208250e-30,  1.458529208816406e-02,
 -7.906541493824060e-05,  3.200315925504786e-07, -1.145079268179502e-09,  3.807671097976408e-12, -1.206230764638826e-14,  3.649400223291142e-17, -1.081875636364998e-19,
  2.964105859669427e-22, -8.956587470483110e-25,  1.588014461303988e-27, -1.106590268698966e-29,  2.860594982100958e-02, -1.546735702498486e-04,  6.218803618120026e-07,
 -2.197001570953269e-09,  7.154226211536597e-12, -2.195425641063310e-14,  6.334577969534920e-17, -1.758069643417232e-19,  4.313476203899669e-22, -1.175063933811132e-24,
  9.644898000375661e-28, -1.421902551024685e-29,  4.732871897655833e-02, -2.550231600240109e-04,  1.015998989297230e-06, -3.526723965191000e-09,  1.114739101990768e-11,
 -3.263079281342991e-14,  8.731087447454065e-17, -2.155998092944602e-19,  4.144350673366437e-22, -8.395801559652865e-25, -2.232287266295074e-27, -1.136500952676813e-29,
  7.077796122981882e-02, -3.796947021358388e-04,  1.494950620779349e-06, -5.070536096837475e-09,  1.538915979542810e-11, -4.205861776902506e-14,  9.949040978174653e-17,
 -1.937657460600115e-19,  1.354296329921201e-22,  3.978420294293803e-25, -8.454969128638499e-27, -3.548172829170788e-30,  9.898394972806934e-02, -5.281322365585741e-04,
  2.049075082136017e-06, -6.747267130993578e-09,  1.938868098304655e-11, -4.786384545941676e-14,  9.041710268421118e-17, -7.997313545687553e-20, -4.729051070315027e-22,
  2.535814713636416e-24, -1.665684592310313e-26,  1.585451737664008e-30,  1.319826954544563e-01, -6.996198187022244e-04,  2.666229595168799e-06, -8.457380063436995e-09,
  2.256969841557925e-11, -4.747188037533065e-14,  5.130649820841631e-17,  1.445199301734214e-19, -1.393173437903386e-21,  5.116020353876190e-24, -2.381282447113174e-26,
 -1.049488304634764e-29,  1.698156764732439e-01, -8.932506466447189e-04,  3.331461159815854e-06, -1.008204275972832e-08,  2.428299661117161e-11, -3.830569042830438e-14,
 -2.430625914163128e-17,  4.772521904334634e-19, -2.481785912737739e-21,  7.110799372185282e-24, -2.500124678492404e-26, -5.776096007801298e-29,  2.125294244219249e-01,
 -1.107887052117283e-03,  4.026602065338919e-06, -1.148232479712160e-08,  2.382648838671144e-11, -1.806177171199560e-14, -1.384958343378242e-16,  8.840197916657039e-19,
 -3.436303528235043e-21,  6.937884675215371e-24, -1.444070428301212e-26, -1.530277461996524e-28,  2.601749030331711e-01, -1.342108987900457e-03,  4.729779634274881e-06,
 -1.249876379788934e-08,  2.047672779088642e-11,  1.491221946768332e-14, -2.864271393250213e-16,  1.288658397449126e-18, -3.786172511563070e-21,  2.699263345259288e-24,
  1.211631182074712e-26, -2.898417404829996e-28,  3.128065853444112e-01, -1.594147863611857e-03,  5.414832483046661e-06, -1.295169476145446e-08,  1.353720854467587e-11,
  6.111038971676748e-14, -4.534531859923311e-16,  1.565560654324002e-18, -2.929189375076543e-21, -7.237620620221228e-24,  5.339533940238472e-26, -4.251724152830102e-28,
  3.704810953873307e-01, -1.861801558020123e-03,  6.050629788150714e-06, -1.264297174996610e-08,  2.410929920641604e-12,  1.192039058728157e-13, -6.120668499312243e-16,
  1.539231259754428e-18, -2.457070577225977e-22, -2.320203819488111e-23,  9.731517846888994e-26, -4.664917887534774e-28,  4.332552201405368e-01, -2.142325097536538e-03,
  6.600299987018375e-06, -1.136008040873560e-08, -1.329255664046381e-11,  1.851988777844569e-13, -7.192690458441818e-16,  9.980531148167901e-19,  4.668376838916427e-21,
 -4.268535075465952e-23,  1.159343650911614e-25, -2.794594390615060e-28,  5.011830085014658e-01, -2.432289761138090e-03,  7.020395920922164e-06, -8.884213273818282e-09,
 -3.360217977886757e-11,  2.514251686641270e-13, -7.155046321044790e-16, -2.665812773322749e-19,  1.160787546825267e-20, -5.850189470747360e-23,  6.450548469139605e-26,
  2.565891545670649e-28,  5.743115406138583e-01, -2.727401193603057e-03,  7.260063470108950e-06, -5.004760650616887e-09, -5.796590567411048e-11,  3.054336349415532e-13,
 -5.273236016439298e-16, -2.380007221135859e-18,  1.918733218297686e-20, -5.738032472244871e-23, -1.077530959286875e-25,  1.111807143812480e-27,  6.526747489431663e-01,
 -3.022264502682055e-03,  7.260356061290014e-06,  4.560033045510693e-10, -8.494909418975771e-11,  3.290292243794183e-13, -7.753018577552521e-17, -5.244179515422653e-18,
  2.416782924032303e-20, -2.078206946729769e-23, -4.232743848557111e-25,  1.874339331280083e-27,  7.362843639323302e-01, -3.310081529483672e-03,  6.953976231113892e-06,
  7.602330260705963e-09, -1.118383161457076e-10,  2.979682356294032e-13,  6.911300699472548e-16, -8.324632164993276e-18,  2.098904906670036e-20,  6.854658984847538e-23,
 -8.059461263165905e-25,  1.508713541550523e-27,  8.251165816733839e-01, -3.582263331564561e-03,  6.265977312032717e-06,  1.640017564238333e-08, -1.341609697199926e-10,
  1.834126389334543e-13,  1.770169974082359e-15, -1.038292598351048e-17,  2.301705432604900e-21,  2.089386793496548e-22, -9.804493102790881e-25, -1.550969140953540e-27,
  9.190923141360274e-01, -3.827941564214329e-03,  5.116408445779188e-06,  2.657678180811181e-08, -1.451943464584076e-10, -4.279086575896649e-14,  3.008306829395122e-15,
 -9.267714142931350e-18, -3.787577095922630e-20,  3.465889330166046e-22, -4.132377529456510e-25, -8.165945802638940e-27,  1.018047738166760e+00, -4.033371107093509e-03,
  3.426673451628302e-06,  3.747130009785673e-08, -1.356891569436583e-10, -3.954832492242637e-13,  4.002390413436113e-15, -2.100641234221781e-18, -9.586667346852557e-20,
  3.347003294852131e-22,  1.473094692858537e-24, -1.505123092207078e-26,  1.121690093131590e+00, -4.181244976992489e-03,  1.132700109093654e-06,  4.782686640362254e-08,
 -9.435806496349203e-11, -8.512136607304216e-13,  3.990807669016620e-15,  1.339312508045713e-17, -1.432322363385846e-19, -6.356992177758338e-23,  4.364122343449525e-24,
 -1.000569310928632e-26,  1.229531007712479e+00, -4.250017948971074e-03, -1.789914103710414e-06,  5.553721278249642e-08, -1.030064869043834e-11, -1.306824662496562e-12,
  1.882552244351389e-15,  3.520893222444999e-17, -1.115330137438701e-19, -9.844262320772508e-22,  5.178537963131113e-24,  2.437651013122090e-26,  1.340785809858038e+00,
 -4.213513994098807e-03, -5.280926060190514e-06,  5.743424400099986e-08,  1.205143381623045e-10, -1.528833892137476e-12, -3.240868256131666e-15,  5.049283708023792e-17,
  8.883134212906301e-20, -1.885939882001655e-21, -2.530555958475789e-24,  7.296992845772721e-26,  1.454222468276403e+00, -4.041486273406726e-03, -9.121159945357593e-06,
  4.939178488634005e-08,  2.819523415082266e-10, -1.141828968640637e-12, -1.059476548954931e-14,  3.107861375102561e-17,  4.360558611680415e-19, -8.916295665411085e-22,
 -1.931753918936022e-23,  2.056746239452380e-26,  1.567939966181117e+00, -3.702593571978258e-03, -1.282571828272308e-05,  2.740987243637688e-08,  4.177079421761873e-10,
  2.012495477826844e-13, -1.509931177006442e-14, -4.784447472874213e-17,  5.276085171006304e-19,  3.536922046790469e-21, -1.584570218655225e-23, -2.159525532848613e-25,
  1.679060384791716e+00, -3.172630039223673e-03, -1.553587119055317e-05, -9.156509997734188e-09,  4.201796120246227e-10,  2.240674860731985e-12, -7.210212826675539e-15,
 -1.356771968462289e-16, -2.936350258691700e-19,  5.473090404038608e-21,  4.166734593402175e-23, -9.756961293578284e-26,  1.783352720111159e+00, -2.452385700068814e-03,
 -1.604387786244818e-05, -5.153347891255852e-08,  1.820159873713081e-10,  3.306425398288466e-12,  1.468042351843556e-14, -6.101605991651807e-17, -1.226478183896627e-18,
 -5.623165759028856e-21,  2.925387258718849e-23,  5.553655160104214e-25,  1.874914116348049e+00, -1.598262410528297e-03, -1.327101874232497e-05, -7.691166894412196e-08,
 -2.237477287289948e-10,  1.224333379695572e-12,  2.259745360315486e-14,  1.561272910556258e-16,  2.768702858396489e-19, -6.514666886794525e-21, -8.458638984637670e-23,
 -4.685131250098753e-25,  1.946263727218721e+00, -7.561303577095093e-04, -7.517497476208856e-06, -6.100824957834277e-08, -4.074640173786664e-10, -2.052338969804098e-12,
 -4.457301250171684e-15,  5.527611677569724e-17,  9.458323986645643e-19,  8.735631807122627e-21,  5.402308015043325e-23,  1.455662479354211e-25,  1.989459773474650e+00,
 -1.574074795507005e-04, -1.743170736383324e-06, -1.690566157065659e-08, -1.508291853806149e-10, -1.261504816045823e-12, -9.953288785446599e-15, -7.396537147626390e-17,
 -5.127287809154855e-19, -3.240113426713502e-21, -1.765077699686887e-23, -6.872938104371178e-26,  5.705570092649708e-04, -3.067456574976466e-06,  1.236367025884046e-08,
 -4.430687551539722e-11,  1.486527488355869e-13, -4.798914086458750e-16,  1.495217863032297e-18, -4.647657181238280e-21,  1.346688897123230e-23, -4.509162553983650e-26,
  8.544903686195229e-29, -7.238465325925209e-31,  5.136229909750815e-03, -2.759191861520553e-05,  1.109808971566955e-07, -3.961716485290369e-10,  1.320907256367549e-12,
 -4.225623650750987e-15,  1.299857645182566e-17, -3.976002217031044e-20,  1.124209867132230e-22, -3.704847037008591e-25,  6.313924979830068e-28, -6.006645210520619e-30,
  1.427406534622368e-02, -7.655910834673754e-05,  3.066483680167701e-07, -1.086039922696147e-09,  3.574943550601741e-12, -1.122176017273144e-14,  3.359277677188152e-17,
 -9.920705958059322e-20,  2.651863019569197e-22, -8.426274289202213e-25,  1.041428149858856e-27, -1.412231886395563e-29,  2.799704135757235e-02, -1.498020703232302e-04,
  5.961889219335873e-07, -2.085965675816428e-09,  6.729953236279123e-12, -2.049150793827415e-14,  5.861011447318923e-17, -1.626745594613465e-19,  3.895728251651225e-22,
 -1.150820568761641e-24,  1.959359210917981e-28, -2.136098228807507e-29,  4.632461850539522e-02, -2.470614676387940e-04,  9.747272781866539e-07, -3.353474808254934e-09,
  1.051524841726363e-11, -3.060630333659687e-14,  8.145507339611279e-17, -2.028399001956481e-19,  3.824510031403196e-22, -9.424032901165335e-25, -3.006835211647369e-27,
 -2.487892362853458e-29,  6.928272209666710e-02, -3.679743601461259e-04,  1.435554203498722e-06, -4.830911019152236e-09,  1.457142825620921e-11, -3.973545262477560e-14,
  9.412732574939348e-17, -1.892687489539808e-19,  1.435757930697739e-22,  5.080570716543898e-26, -9.054110463531902e-27, -2.523542809369902e-29,  9.690370054114181e-02,
 -5.120583029934789e-04,  1.969937979570249e-06, -6.444589337710912e-09,  1.845291430296949e-11, -4.572233624434902e-14,  8.797879901387754e-17, -9.377437936468036e-20,
 -3.936621628802323e-22,  1.863044803334531e-24, -1.719993928488576e-26, -2.851801793240743e-29,  1.292262416644713e-01, -6.786898689420696e-04,  2.566876614278748e-06,
 -8.103792198664017e-09,  2.163287680133932e-11, -4.619683986221373e-14,  5.475528396794448e-17,  1.026999347033742e-19, -1.226336037303395e-21,  4.144927815894451e-24,
 -2.500590801374364e-26, -4.693156829593658e-29,  1.662952202776457e-01, -8.670763488522415e-04,  3.212782441980554e-06, -9.699671034833818e-09,  2.351208630694081e-11,
 -3.873742854916538e-14, -1.201796169485280e-17,  4.017323467866258e-19, -2.244493779541851e-21,  6.050429988664530e-24, -2.829768538716319e-26, -9.649326282759281e-29,
  2.081614383015642e-01, -1.076218934966337e-03,  3.891089027346186e-06, -1.110416326974609e-08,  2.343395565521163e-11, -2.110084029793484e-14, -1.152460696439756e-16,
  7.779291831249793e-19, -3.198633035403996e-21,  6.217079763591899e-24, -2.187028187580771e-26, -1.904866112202217e-28,  2.548812015396330e-01, -1.304865101518724e-03,
  4.581768899694951e-06, -1.216911167621752e-08,  2.070908197924060e-11,  8.457359052907353e-15, -2.520257807257047e-16,  1.169123812465911e-18, -3.683417881257401e-21,
  2.920708703803032e-24, -1.318810806625264e-27, -3.279337976972782e-28,  3.065156521968940e-01, -1.551447113855962e-03,  5.260750175658631e-06, -1.272589835470921e-08,
  1.465408255433212e-11,  5.074272275138471e-14, -4.109662107988251e-16,  1.468032673122348e-18, -3.155913258370284e-21, -5.488169244932363e-24,  3.369473143008775e-26,
 -4.781611176861592e-28,  3.631297395242459e-01, -1.814002550508819e-03,  5.899221705609953e-06, -1.258610775360004e-08,  4.651595198270473e-12,  1.050298487467696e-13,
 -5.691989044814806e-16,  1.518713880339137e-18, -1.016092388240645e-21, -1.974603070541714e-23,  7.476122073024197e-26, -5.664909532150386e-28,  4.247906564432515e-01,
 -2.090071321618427e-03,  6.462822156396354e-06, -1.154405763407662e-08, -9.758858739530636e-12,  1.682872588409407e-13, -6.894569127516613e-16,  1.123722196456246e-18,
  3.211727304072544e-21, -3.834783117858249e-23,  9.953521132783509e-26, -4.732753920232883e-28,  4.915654881844106e-01, -2.376561799705873e-03,  6.910722465526870e-06,
 -9.382554948769324e-09, -2.874579338723383e-11,  2.342035325053607e-13, -7.180815404487449e-16,  7.168824009060943e-20,  9.550136356527350e-21, -5.578825660825932e-23,
  6.880939800831184e-26, -6.918041030103533e-29,  5.635176948405807e-01, -2.669576221395624e-03,  7.194640915183241e-06, -5.884054823924312e-09, -5.198883812382553e-11,
  2.920456312675482e-13, -5.856838327877196e-16, -1.799806961671754e-18,  1.705475586071785e-20, -6.083310601235131e-23, -6.802823323838438e-26,  6.796454672446976e-28,
  6.407018593234702e-01, -2.964182372960659e-03,  7.257889687054697e-06, -8.506869882424345e-10, -7.839856244391093e-11,  3.254930422476414e-13, -2.136748865164953e-16,
 -4.485891280647168e-18,  2.313394725898379e-20, -3.615891092330300e-23, -3.482391996029626e-25,  1.506917031471671e-27,  7.231558368693108e-01, -3.254114769425082e-03,
  7.034667081067397e-06,  5.861415495694690e-09, -1.057315593625789e-10,  3.118362382610707e-13,  4.677708451934075e-16, -7.619588888825612e-18,  2.289286333684583e-20,
  3.767814458783635e-23, -7.370051662318957e-25,  1.572586517520100e-27,  8.108889792655075e-01, -3.531384503126967e-03,  6.450028226656502e-06,  1.428515584135052e-08,
 -1.300913531116601e-10,  2.224230547059184e-13,  1.481555339397873e-15, -1.019660715760120e-17,  9.103854705152890e-21,  1.686501081579071e-22, -1.027374393487805e-24,
 -6.460201808317004e-28,  9.038643744408974e-01, -3.785774143986811e-03,  5.421375388649448e-06,  2.425065801206922e-08, -1.453498486794493e-10,  2.616898540016195e-14,
  2.733691549956927e-15, -1.028396856269074e-17, -2.577843555510432e-20,  3.233398533030488e-22, -7.378351050617721e-25, -6.607591968154994e-27,  1.001971875477798e+00,
 -4.004196571876869e-03,  3.863058711551988e-06,  3.524218929549439e-08, -1.426447554173075e-10, -3.004668406809489e-13,  3.902509160447001e-15, -4.965510853858746e-18,
 -8.291642826695164e-20,  3.803909867246885e-22,  8.130955726733127e-25, -1.482930980893886e-26,  1.104986833371200e+00, -4.169914611365570e-03,  1.697019513771219e-06,
  4.618626536068816e-08, -1.103968501145471e-10, -7.514530476787157e-13,  4.301537802477753e-15,  8.805805879732856e-18, -1.424999744197865e-19,  1.005304920684246e-22,
  3.802336918547754e-24, -1.529907814658275e-26,  1.212506511566864e+00, -4.261676246154915e-03, -1.125310067469689e-06,  5.516609283377359e-08, -3.590769346818564e-11,
 -1.250247779231469e-12,  2.813404017200621e-15,  3.111471812600782e-17, -1.430165146934326e-19, -7.592749694710858e-22,  5.991978610764083e-24,  1.244289646586918e-26,
  1.323851667249294e+00, -4.252974127845300e-03, -4.581167149944742e-06,  5.911411955843680e-08,  8.927576151935441e-11, -1.589391199392031e-12, -1.797581905911601e-15,
  5.223589729104234e-17,  1.989082559243758e-20, -1.922889035883745e-21,  6.705819653594262e-25,  7.125557461019750e-26,  1.437914444269635e+00, -4.112009880014401e-03,
 -8.502188585572491e-06,  5.370683794599931e-08,  2.566515086292295e-10, -1.384119081913919e-12, -9.535086200581394e-15,  4.437218529947325e-17,  3.903765693230103e-19,
 -1.634202751901771e-21, -1.751937000373922e-23,  6.053135009319090e-26,  1.552926624190414e+00, -3.803769851941701e-03, -1.245663196453702e-05,  3.410529024116509e-08,
  4.180109288461169e-10, -1.751890228939321e-13, -1.618442518965444e-14, -2.906438860945064e-17,  6.412809638771829e-19,  2.718090579084665e-21, -2.491927654745583e-23,
 -1.917072868349234e-25,  1.666120760555448e+00, -3.297238894114441e-03, -1.560396724821081e-05, -2.085838652282069e-09,  4.629502684700234e-10,  2.021173735034894e-12,
 -1.110886971552862e-14, -1.416101877805017e-16, -6.801115221275367e-20,  7.012720754491885e-21,  3.427020331463507e-23, -2.405709606895396e-25,  1.773282635393661e+00,
 -2.583155674684468e-03, -1.664256360801517e-05, -4.807371474785985e-08,  2.515057317119655e-10,  3.633641465616728e-12,  1.239397534725165e-14, -1.032267884674553e-16,
 -1.401678783826000e-18, -3.934165746349992e-21,  5.583613608704472e-23,  6.425453037154084e-25,  1.868302801903887e+00, -1.708181120084079e-03, -1.421453094192870e-05,
 -8.026477085193713e-08, -1.934794092105437e-10,  1.819891163828206e-12,  2.705291287472394e-14,  1.605421741734516e-16, -2.339555186805993e-20, -1.029428864920494e-20,
 -1.037893447109717e-22, -3.845317391052815e-25,  1.943114128578156e+00, -8.193127181532863e-04, -8.290084793789334e-06, -6.786126878165923e-08, -4.494362188208090e-10,
 -2.137015521035200e-12, -2.435521800393193e-15,  9.100240837569575e-17,  1.300495733537338e-18,  1.099478550295861e-20,  5.801729152543409e-23,  1.876803158452905e-26,
  1.988800907437272e+00, -1.722073481834870e-04, -1.961394920293880e-06, -1.953448733158190e-08, -1.786258819206416e-10, -1.527202935177358e-12, -1.227256260636776e-14,
 -9.238110500357579e-17, -6.427980548679947e-19, -4.005072355741727e-21, -2.052974861378236e-23, -5.926769174271296e-26,  5.584816905033137e-04, -2.970634226366428e-06,
  1.184594788518714e-08, -4.200330778390225e-11,  1.394034774483546e-13, -4.455205744121073e-16,  1.370876920916168e-18, -4.242094981865412e-21,  1.189699470841628e-23,
 -4.236129377407522e-26,  4.955768399009458e-29, -9.324284101174841e-31,  5.027608319495913e-03, -2.672273470498170e-05,  1.063509094483630e-07, -3.756966534255546e-10,
  1.239426315189976e-12, -3.926622831889926e-15,  1.193368699628603e-17, -3.637161954297701e-20,  9.947021513018658e-23, -3.509968157666463e-25,  3.287895755281867e-28,
 -7.969556869028797e-30,  1.397265409833366e-02, -7.415709571134459e-05,  2.939518165196272e-07, -1.030593430088879e-09,  3.358350449766481e-12, -1.044793596186780e-14,
  3.092927214461141e-17, -9.119971015903392e-20,  2.354388541879591e-22, -8.148659309793137e-25,  3.040814035596073e-28, -1.999897243834976e-29,  2.740721610949230e-02,
 -1.451308854110550e-04,  5.717901283368072e-07, -1.981490161524670e-09,  6.333827677018881e-12, -1.913815342317783e-14,  5.422352644809491e-17, -1.508716091170361e-19,
  3.480296943446868e-22, -1.164963612437489e-24, -9.938525664387170e-28, -3.388725890151576e-29,  4.535171738458368e-02, -2.394218018975086e-04,  9.354751830244099e-07,
 -3.190023531262052e-09,  9.922218538261090e-12, -2.871818507570375e-14,  7.594161446041268e-17, -1.911699746896278e-19,  3.460449444571489e-22, -1.090298115030839e-24,
 -4.549262820589485e-27, -4.714068087658060e-29,  6.783343189089339e-02, -3.567179064279188e-04,  1.378956295675806e-06, -4.604004889941479e-09,  1.379888318138529e-11,
 -3.753947280852440e-14,  8.889188426322395e-17, -1.847176461917836e-19,  1.385383005945084e-22, -3.425680777414976e-25, -1.086673694522593e-26, -6.001855343548807e-29,
  9.488650354327625e-02, -4.966031890095648e-04,  1.894344579672057e-06, -6.156544475904278e-09,  1.755936269825169e-11, -4.364371959076374e-14,  8.518587411829056e-17,
 -1.054344174960026e-19, -3.393909996884277e-22,  1.137323266572620e-24, -1.944059586608671e-26, -7.741218800428900e-29,  1.265519445413605e-01, -6.585380236616594e-04,
  2.471677607922810e-06, -7.764985363710310e-09,  2.072229183750677e-11, -4.485250944154734e-14,  5.710251178083276e-17,  6.564665979410054e-20, -1.095762340306979e-21,
  3.087379163079708e-24, -2.832584252660091e-26, -1.096127203395548e-28,  1.628775911772153e-01, -8.418333372028980e-04,  3.098617942485125e-06, -9.329687632939480e-09,
  2.273532343390566e-11, -3.889880042436816e-14, -1.743854991933575e-18,  3.331657745793108e-19, -2.048239936477295e-21,  4.814994070470942e-24, -3.401283667949114e-26,
 -1.708525810949001e-28,  2.039179850248947e-01, -1.045616881562287e-03,  3.760074334238355e-06, -1.073273919420378e-08,  2.298598521409838e-11, -2.361672767887644e-14,
 -9.486469752494153e-17,  6.789675822400350e-19, -2.992763926249301e-21,  5.154184500625167e-24, -3.188204543981294e-26, -2.744031609640692e-28,  2.497341325500784e-01,
 -1.268789424037013e-03,  4.437732178587518e-06, -1.183673093705405e-08,  2.082032611865081e-11,  2.788342746318288e-15, -2.209249204988085e-16,  1.052897091934110e-18,
 -3.582898318432157e-21,  2.556565396214263e-24, -1.757837101623977e-26, -4.233005510143566e-28,  3.003930743005596e-01, -1.509967895945488e-03,  5.109477979290369e-06,
 -1.248383633003352e-08,  1.557357489497939e-11,  4.136120658170389e-14, -3.713032386531422e-16,  1.364099619709513e-18, -3.334549567564802e-21, -4.589951497819028e-24,
  1.035680115379354e-26, -5.969382436385282e-28,  3.559671623160162e-01, -1.767411489907617e-03,  5.748701920437477e-06, -1.249560530616552e-08,  6.619007174337243e-12,
  9.187505126383994e-14, -5.272331702489024e-16,  1.475351143158449e-18, -1.679511102121021e-21, -1.729733653478923e-23,  4.644143163972396e-26, -7.366311514629209e-28,
  4.165328955454537e-01, -2.038925263533810e-03,  6.323464801371395e-06, -1.167416157360628e-08, -6.555979915511308e-12,  1.521282279855529e-13, -6.567561534528517e-16,
  1.205132682572278e-18,  1.897218496980552e-21, -3.485378692694777e-23,  7.324041207966621e-26, -7.389797512306559e-28,  4.821690888941624e-01, -2.321733851563388e-03,
  6.795523754440379e-06, -9.805950175908531e-09, -2.423372905145910e-11,  2.170263590609501e-13, -7.120940137874914e-16,  3.456772976567866e-19,  7.589567480177102e-21,
 -5.320812446247129e-23,  5.724782843861572e-26, -4.754893891906570e-28,  5.529540376366713e-01, -2.612315230802880e-03,  7.119231560821812e-06, -6.669928715357581e-09,
 -4.629226151239780e-11,  2.774441130968704e-13, -6.287705744804419e-16, -1.289570154663660e-18,  1.482163664917451e-20, -6.310682227213651e-23, -4.964611113872893e-26,
  1.305695337001785e-28,  6.289611619591178e-01, -2.906180920115437e-03,  7.240368990946817e-06, -2.053304949643279e-09, -7.194973069015325e-11,  3.189399419994869e-13,
 -3.291299846131911e-16, -3.768999979879831e-18,  2.159612173323150e-20, -4.891408598215308e-23, -2.936931241605580e-25,  9.324191969063494e-28,  7.102523379610465e-01,
 -3.197584366216893e-03,  7.095061430513736e-06,  4.220143282109230e-09, -9.939941841196289e-11,  3.205863904822318e-13,  2.648424789884334e-16, -6.870871840815122e-18,
  2.373484352050194e-20,  9.525433504581438e-24, -6.727115779357112e-25,  1.285200090126664e-27,  7.968676778823530e-01, -3.479133624525882e-03,  6.609114120502597e-06,
  1.224111741809116e-08, -1.253102517388528e-10,  2.545925676289735e-13,  1.200984786005152e-15, -9.816117380710990e-18,  1.443031465697307e-20,  1.271570379730488e-22,
 -1.043979819385166e-24, -1.956079704706106e-28,  8.888098071878520e-01, -3.741278582007585e-03,  5.698458246717192e-06,  2.193271275985551e-08, -1.441941439318703e-10,
  8.823949265444451e-14,  2.435897826267452e-15, -1.092887438542557e-17, -1.473571565604476e-20,  2.884233707587983e-22, -9.984751655533770e-25, -5.306293515805096e-27,
  9.860195211996756e-01, -3.971639700375312e-03,  4.272089120871084e-06,  3.291683488438004e-08, -1.477302469426802e-10, -2.087620119347375e-13,  3.728424387674696e-15,
 -7.394719325472201e-18, -6.879243691371592e-20,  4.000612230327906e-22,  1.759085858327258e-25, -1.408278463269082e-26,  1.088337793542192e+00, -4.154152647848596e-03,
  2.240179018026428e-06,  4.430536709017654e-08, -1.243762155639382e-10, -6.457683100625008e-13,  4.485005724952366e-15,  4.331672990575768e-18, -1.363169670268069e-19,
  2.379123012941157e-22,  3.038257082984554e-24, -1.921561280447232e-26,  1.195445977981941e+00, -4.268042396240996e-03, -4.675765854673377e-07,  5.439548537344758e-08,
 -6.016963767995756e-11, -1.172812265435204e-12,  3.616770461417453e-15,  2.614795854938398e-17, -1.659373696474801e-19, -5.122851672346135e-22,  6.267421955596594e-24,
  8.707370004478926e-29,  1.306770995817182e+00, -4.286764132931362e-03, -3.864282473221778e-06,  6.028638286765396e-08,  5.717509033866982e-11, -1.614973606613355e-12,
 -3.364005201337892e-16,  5.177600813199981e-17, -4.811377092698623e-20, -1.835550623566674e-21,  3.629229701073200e-24,  6.205801260313434e-26,  1.421334547133215e+00,
 -4.177381833711689e-03, -7.834020566457940e-06,  5.757981635555439e-08,  2.267883899386615e-10, -1.596699549527391e-12, -8.127551555439481e-15,  5.579353296495877e-17,
  3.196695857071229e-19, -2.271246035445313e-21, -1.408995534562322e-23,  9.379021853078777e-26,  1.537514990664202e+00, -3.901672559355989e-03, -1.200742407344931e-05,
  4.074409648202116e-08,  4.105693099178014e-10, -5.709788481046017e-13, -1.669768729311017e-14, -7.185886731702365e-18,  7.192763926725274e-19,  1.566057735213770e-21,
 -3.230196637648290e-23, -1.395701231628680e-25,  1.652682164675893e+00, -3.422041858513059e-03, -1.558327072298204e-05,  5.628917997118726e-09,  5.003861940861701e-10,
  1.706976080104128e-12, -1.506471749441449e-14, -1.395059341319228e-16,  2.061787495762576e-19,  8.128942935474787e-21,  2.049832768352034e-23, -3.832807008259834e-25,
  1.762680182060766e+00, -2.718529689415273e-03, -1.719285598720682e-05, -4.345315408246802e-08,  3.268923074234509e-10,  3.891230129801350e-12,  8.857778282057132e-15,
 -1.498595994999845e-16, -1.496204875462099e-18, -1.127004827955248e-21,  8.454077542746139e-23,  6.444259646903767e-25,  1.861236474454798e+00, -1.825799700027299e-03,
 -1.519496265355480e-05, -8.303245964797569e-08, -1.502267743193140e-10,  2.522646804969652e-12,  3.147601053653034e-14,  1.530327565138706e-16, -4.723108166011785e-19,
 -1.472862513595694e-20, -1.162454327481932e-22, -1.527383371577986e-25,  1.939698902006008e+00, -8.890162482924512e-04, -9.148984032702364e-06, -7.539639089772936e-08,
 -4.925287471102648e-10, -2.159806924732138e-12,  7.578563524825497e-16,  1.393971035472137e-16,  1.737707914710736e-18,  1.326701750490512e-20,  5.369842417136012e-23,
 -2.426846577523171e-25,  1.988079139315417e+00, -1.888871790414948e-04, -2.214019153701129e-06, -2.265378038231379e-08, -2.123374749678108e-10, -1.855247856697735e-12,
 -1.517003999781944e-14, -1.154207307620911e-16, -8.023234930207969e-19, -4.870608994309646e-21, -2.249486213132824e-23, -2.426394552936815e-26,  };
  constexpr double w[11904] = {  9.964180390584942e-02, -4.251622103985195e-04,  1.927058293492784e-06, -9.109276689406448e-09,  4.414521133468208e-11,
 -2.165812840341808e-13,  1.066949609243325e-15, -5.252822317892589e-18,  2.577731721932260e-20, -1.259329211035298e-22,  6.121643156161875e-25, -2.960565365022364e-27,
  9.891606682569437e-02, -6.579401455417181e-04,  5.057502728470036e-06, -3.822856116017707e-08,  2.774110937154007e-10, -1.940405768488277e-12,  1.316683624581552e-14,
 -8.711360925970733e-17,  5.640445028511249e-19, -3.583966004656302e-21,  2.239572198779134e-23, -1.378609450963613e-25,  9.748684595038291e-02, -1.111221629300186e-03,
  1.275106468163421e-05, -1.316575027794011e-07,  1.256863889250348e-09, -1.131443085349651e-11,  9.720853432621477e-14, -8.035033073521980e-16,  6.426624436076656e-18,
 -4.995414379409050e-20,  3.786311620696602e-22, -2.805830423176925e-24,  9.539717582120723e-02, -1.761411897844191e-03,  2.764220413817577e-05, -3.713611303795466e-07,
  4.495103674675269e-09, -5.034372852669474e-11,  5.301741757133906e-13, -5.307290743054655e-15,  5.089562979518328e-17, -4.702844325691545e-19,  4.205899201925569e-21,
 -3.653321796788076e-23,  9.270808324394035e-02, -2.575394094656738e-03,  5.314218405176594e-05, -9.045858112799349e-07,  1.354718905877454e-08, -1.844801462915201e-10,
  2.330668425757604e-12, -2.768729164300055e-14,  3.122491870080821e-16, -3.366905714103618e-18,  3.490170291759127e-20, -3.492924674651878e-22,  8.949476839927356e-02,
 -3.512969612842938e-03,  9.288657900952903e-05, -1.961326460817466e-06,  3.565651442681588e-08, -5.802374826568183e-10,  8.653935138085945e-12, -1.201706402140247e-13,
  1.571114261829140e-15, -1.950027608925491e-17,  2.312406064881785e-19, -2.632773792774047e-21,  8.584213349358691e-02, -4.529676793450908e-03,  1.501393037793313e-04,
 -3.861809897518291e-06,  8.389330516894241e-08, -1.608466250530148e-09,  2.795354398879245e-11, -4.482446880015100e-13,  6.716044238923315e-15, -9.490500089946252e-17,
  1.273972273505717e-18, -1.633527713985394e-20,  8.184007448067991e-02, -5.579701423769571e-03,  2.272396558137135e-04, -7.006661360781747e-06,  1.794117828857536e-07,
 -4.003674938524736e-09,  8.017891949700784e-11, -1.469369171127120e-12,  2.498522998412914e-14, -3.982744871791579e-16,  5.998767704016371e-18, -8.589310963193472e-20,
  7.757893597899616e-02, -6.618608638667828e-03,  3.251669537917532e-04, -1.184616875402387e-05,  3.531779643700497e-07, -9.074162299298148e-09,  2.073448753004926e-10,
 -4.303126862559254e-12,  8.233173546124243e-14, -1.468479567710737e-15,  2.462641189156851e-17, -3.908515380818239e-19,  7.314546823257025e-02, -7.605674683241075e-03,
  4.432744660277387e-04, -1.882991993405734e-05,  6.463589818621344e-07, -1.893182664058629e-08,  4.891774519795205e-10, -1.140197169989060e-11,  2.435744302584188e-13,
 -4.825718661713017e-15,  8.948182442701371e-17, -1.563785869563510e-18,  6.861953192123667e-02, -8.505667460721938e-03,  5.792156496359068e-04, -2.834279800731953e-05,
  1.108617739641880e-06, -3.668014685664300e-08,  1.062896191020388e-09, -2.761270440818748e-11,  6.539341920913959e-13, -1.429484793547561e-14,  2.912243622203388e-16,
 -5.570096798887188e-18,  6.407168899207515e-02, -9.290003716596409e-03,  7.290569202388479e-04, -4.063673677518039e-05,  1.793859147820757e-06, -6.647475263676688e-08,
  2.143564813833168e-09, -6.162522874786968e-11,  1.607188273461146e-12, -3.852201362091853e-14,  8.571511061133095e-16, -1.784142664197003e-17,  5.956171218331956e-02,
 -9.937285626786883e-03,  8.875471151106315e-04, -5.576903505468833e-05,  2.753478447086467e-06, -1.133655961463442e-07,  4.038404815930654e-09, -1.276176037357177e-10,
  3.642291755542976e-12, -9.515888558833658e-14,  2.299695906327907e-15, -5.181634423359265e-17,  5.513795597394946e-02, -1.043328081751369e-02,  1.048497714652658e-03,
 -7.355722937789870e-05,  4.027750781206949e-06, -1.828520063160032e-07,  7.146131341120242e-09, -2.466448787546511e-10,  7.657707015558684e-12, -2.168533136208826e-13,
  5.661743686109037e-15, -1.373949808545044e-16,  5.083746578702316e-02, -1.077045180264086e-02,  1.205220955741356e-03, -9.355787837928295e-05,  5.636524363938434e-06,
 -2.801330161770302e-07,  1.193208322172523e-08, -4.470588741769421e-10,  1.501318856941144e-11, -4.583493250397178e-13,  1.286266218321502e-14, -3.345551717177172e-16,
  4.668666353910208e-02, -1.094716198648139e-02,  1.350974563488462e-03, -1.150728305703160e-04,  7.570701577466437e-06, -4.091067630504465e-07,  1.887272934793200e-08,
 -7.631093698638678e-10,  2.756717627569970e-11, -9.026583081697192e-13,  2.709415141607410e-14, -7.517898826690262e-16,  4.270243457280268e-02, -1.096668771478545e-02,
  1.479369971235797e-03, -1.371824793643056e-04,  9.786030178812912e-06, -5.712479005287429e-07,  2.836924767836958e-08, -1.230995351177812e-09,  4.758380785973693e-11,
 -1.662739210640701e-12,  5.312887137362896e-14, -1.565550974398044e-15,  3.889344890128422e-02, -1.083615362081226e-02,  1.584712962541488e-03, -1.588019262135379e-04,
  1.220046965242701e-05, -7.645509121812822e-07,  4.063833871905267e-08, -1.882088620929777e-09,  7.744877165074616e-11, -2.874123344932810e-12,  9.731093186304229e-14,
 -3.031796727188985e-15,  3.526157215582715e-02, -1.056548695889374e-02,  1.662259010720193e-03, -1.787534152059485e-04,  1.469590351970682e-05, -9.827526706417846e-07,
  5.559723764988821e-08, -2.733814521573259e-09,  1.191669300811281e-10, -4.674363173412412e-12,  1.669457780820955e-13, -5.475816041054577e-15,  3.180325208468825e-02,
 -1.016646087505300e-02,  1.708378031003542e-03, -1.958471156583068e-04,  1.712434211768142e-05, -1.215029957391290e-06,  7.276647022993193e-08, -3.779586886817482e-09,
  1.736772411363331e-10, -7.167811758263593e-12,  2.688614315164229e-13, -9.245085713664830e-15,  2.851079918185872e-02, -9.651870871892159e-03,  1.720633333425656e-03,
 -2.089622795149749e-04,  1.931812371310007e-05, -1.446307727575623e-06,  9.121592920897212e-08, -4.979991677632440e-09,  2.400996554981705e-10, -1.037908054189202e-11,
  4.071193356234380e-13, -1.461581742071820e-14,  2.537351074728990e-02, -9.034866050425878e-03,  1.697786566430181e-03, -2.171217481070059e-04,  2.110308400875026e-05,
 -1.658222367195353e-06,  1.095759911839782e-07, -6.257800296817924e-09,  3.151001686326479e-10, -1.420452855865093e-11,  5.802000961217291e-13, -2.165905704959612e-14,
  2.237861371643163e-02, -8.328438707382981e-03,  1.639744316434243e-03, -2.195543792177130e-04,  2.231330111851207e-05, -1.830678597391425e-06,  1.261257789352449e-07,
 -7.499143899237994e-09,  3.925946210615380e-10, -1.837623254772025e-11,  7.783838545145156e-13, -3.009435601864959e-14,  1.951202172175843e-02, -7.545063059934787e-03,
  1.547463178707143e-03, -2.157418445324976e-04,  2.280586891854211e-05, -1.943838960845203e-06,  1.389569480657009e-07, -8.562229255072374e-09,  4.639852152369283e-10,
 -2.245458502924277e-11,  9.823229273276827e-13, -3.918035776813390e-14,  1.675891597531737e-02, -6.696465971652772e-03,  1.422829190116783e-03, -2.054480954940391e-04,
  2.247420056783537e-05, -1.980308801883297e-06,  1.461963161859243e-07, -9.293465188078025e-09,  5.190284435691796e-10, -2.586207679536835e-11,  1.163788095521096e-12,
 -4.770077735030260e-14,  1.410416839205776e-02, -5.793508798502635e-03,  1.268525236445545e-03, -1.887313895065060e-04,  2.125858044528581e-05, -1.927239682769492e-06,
  1.462574814335865e-07, -9.549122005586966e-09,  5.472842884898476e-10, -2.796167605345925e-11,  1.289154323457617e-12, -5.409120769524212e-14,  1.153263019927140e-02,
 -4.846158968584976e-03,  1.087897096951074e-03, -1.659399893866205e-04,  1.915301515592358e-05, -1.778075519597938e-06,  1.380831954669327e-07, -9.219095635651897e-09,
  5.399305586321607e-10, -2.817041333522694e-11,  1.325420048441502e-12, -5.671446232217763e-14,  9.029312538431341e-03, -3.863532209671400e-03,  8.848258219732766e-04,
 -1.376934854367290e-04,  1.620782938847250e-05, -1.533706735404430e-06,  1.213386036610414e-07, -8.248414193694508e-09,  4.915912893881425e-10, -2.608607439043460e-11,
  1.247640841268657e-12, -5.423873455928652e-14,  6.579496945317993e-03, -2.853994343555323e-03,  6.636124166133021e-04, -1.048523207119344e-04,  1.252787800606292e-05,
 -1.202872480991521e-06,  9.652123561023364e-08, -6.652108103507393e-09,  4.017698915125030e-10, -2.159678092098808e-11,  1.045933356707639e-12, -4.602302654826881e-14,
  4.168922858437782e-03, -1.825363730280045e-03,  4.288898129382883e-04, -6.848009477437010e-05,  8.266845121613262e-06, -8.017658235461699e-07,  6.496739182746853e-08,
 -4.520145792111367e-09,  2.755291305565136e-10, -1.494357783044439e-11,  7.300057135507284e-13, -3.239127711930008e-14,  1.786516500779578e-03, -7.862809118613357e-04,
  1.858170010689506e-04, -2.984207099513413e-05,  3.623153413105169e-06, -3.533592404108238e-07,  2.878855148072719e-08, -2.013557201088239e-09,  1.233667158545005e-10,
 -6.724142013301629e-12,  3.300613651910096e-13, -1.471339247085870e-14,  9.797131222074677e-02, -4.101713022401802e-04,  1.821846343942419e-06, -8.436263393143010e-09,
  4.005820470516655e-11, -1.926502570964989e-13,  9.307695482707503e-16, -4.496002874583076e-18,  2.165483960881866e-20, -1.038624124510960e-22,  4.957686330000325e-25,
 -2.354785835642490e-27,  9.636242368948930e-02, -6.192424806729170e-04,  4.624164227574574e-06, -3.408407312463123e-08,  2.415755019465100e-10, -1.651745603277656e-12,
  1.096211796028958e-14, -7.096684819806659e-17,  4.497859397100824e-19, -2.798502185677970e-21,  1.712875257879338e-23, -1.033040721627174e-25,  9.323643145253378e-02,
 -1.015207215736494e-03,  1.128475672741011e-05, -1.132384811200111e-07,  1.052196386569408e-09, -9.229727313069262e-12,  7.733873897502075e-14, -6.239271826256462e-16,
  4.873570800810516e-18, -3.701519530182084e-20,  2.742622842484101e-22, -1.987595051578708e-24,  8.876721064850730e-02, -1.556949199688140e-03,  2.358628262336120e-05,
 -3.068505248961547e-07,  3.604322715247052e-09, -3.923331537892769e-11,  4.020405845890363e-13, -3.919945994676412e-15,  3.664275213854460e-17, -3.302652234259648e-19,
  2.882784972423376e-21, -2.445237389613670e-23,  8.319288908085819e-02, -2.190253800978266e-03,  4.347509806190507e-05, -7.145530327444599e-07,  1.035954466164187e-08,
 -1.368209994350057e-10,  1.678850167503284e-12, -1.939263846623894e-14,  2.128613768637974e-16, -2.235732897910403e-18,  2.259113813570184e-20, -2.205256377049809e-22,
  7.679262959854365e-02, -2.855136015481327e-03,  7.242438757461826e-05, -1.473425032030966e-06,  2.588298619270284e-08, -4.078292495544599e-10,  5.899006715269603e-12,
 -7.954627597181866e-14,  1.011014342903222e-15, -1.221021220619261e-17,  1.410046540950125e-19, -1.564539338675410e-21,  6.986142373828928e-02, -3.493337847501732e-03,
  1.108971406418115e-04, -2.744287797768407e-06,  5.752950170937614e-08, -1.066743406868934e-09,  1.796059433819730e-11, -2.794140171206722e-13,  4.066420641940714e-15,
 -5.587256313401099e-17,  7.299121443817983e-19, -9.115673083574545e-21,  6.268624598720500e-02, -4.054773617834263e-03,  1.580448525808394e-04, -4.684625216498360e-06,
  1.156648900792971e-07, -2.494501093853677e-09,  4.836627984264092e-11, -8.594426326324847e-13,  1.418797789120606e-14, -2.198088703401954e-16,  3.220832601180172e-18,
 -4.490396070885070e-20,  5.552628794144691e-02, -4.502044418400902e-03,  2.117046097779109e-04, -7.412984047572368e-06,  2.130516435577203e-07, -5.288824217262670e-09,
  1.169771256347357e-10, -2.353469352846077e-12,  4.370932139648908e-14, -7.576175420670718e-16,  1.235932478476174e-17, -1.909907862221330e-19,  4.859898194959092e-02,
 -4.812618546278034e-03,  2.686746839656671e-04, -1.097391912304062e-05,  3.632163829097900e-07, -1.028065946080031e-08,  2.571679431785664e-10, -5.811852582378100e-12,
  1.205373578404002e-13, -2.321177484511625e-15,  4.187774015291292e-17, -7.127451969255010e-19,  4.207239737047347e-02, -4.978752791030455e-03,  3.251824444286786e-04,
 -1.531343672495080e-05,  5.779457990718202e-07, -1.848947634349787e-08,  5.189593229444314e-10, -1.307825781089095e-11,  3.008422326930061e-13, -6.395103973965141e-15,
  1.268253026068266e-16, -2.363531413257857e-18,  3.606359015924342e-02, -5.005602031351031e-03,  3.774247030802977e-04, -2.027221372866489e-05,  8.644044260287198e-07,
 -3.100170333868360e-08,  9.691463251024246e-10, -2.704960548648951e-11,  6.857543531122301e-13, -1.599556497704674e-14,  3.467185700784609e-16, -7.036968758163777e-18,
  3.064177151216818e-02, -4.908171863764356e-03,  4.220630096841124e-04, -2.559884205132671e-05,  1.222581759670311e-06, -4.877896873293099e-08,  1.686529127792417e-09,
 -5.179887932640037e-11,  1.438587794811150e-12, -3.661294284213538e-14,  8.627926227940203e-16, -1.897367514944110e-17,  2.583479764813828e-02, -4.707804686230712e-03,
  4.565869799054357e-04, -3.097993423474016e-05,  1.643760812092868e-06, -7.242858249409450e-08,  2.751316358356594e-09, -9.241762341538140e-11,  2.795699603578696e-12,
 -7.721735968907442e-14,  1.968177519842476e-15, -4.666952265059409e-17,  2.163744480700375e-02, -4.428789649199258e-03,  4.795032228553058e-04, -3.607995136367239e-05,
  2.110455567124811e-06, -1.019875343529754e-07,  4.229468490414911e-09, -1.544653126987163e-10,  5.061704215733436e-12, -1.509376044557614e-13,  4.140883867718668e-15,
 -1.053792642964067e-16,  1.802013654112590e-02, -4.095508587757381e-03,  4.903512251905502e-04, -4.058209875232766e-05,  2.597883380066442e-06, -1.367749728986018e-07,
  6.154628888553292e-09, -2.430045448693618e-10,  8.580304918505897e-12, -2.748551360523087e-13,  8.077610355829789e-15, -2.196197676818941e-16,  1.493712734238169e-02,
 -3.730331745763658e-03,  4.895801234385733e-04, -4.422259133004074e-05,  3.076656667932599e-06, -1.753544803385870e-07,  8.511625231813639e-09, -3.613338969554741e-10,
  1.367668751188085e-11, -4.683470275017000e-13,  1.467650991869512e-14, -4.244461216455483e-16,  1.233351882625380e-02, -3.352303368087367e-03,  4.783370859795079e-04,
 -4.681325409040735e-05,  3.516116634641586e-06, -2.156211472302648e-07,  1.122574027949305e-08, -5.096596555968149e-10,  2.057577528244359e-11, -7.496608463370287e-13,
  2.493638818328661e-14, -7.637843406809123e-16,  1.015081995884364e-02, -2.976532774149566e-03,  4.582198639164866e-04, -4.825070027801480e-05,  3.887651675431360e-06,
 -2.549986168498885e-07,  1.416089745287013e-08, -6.840225764558770e-10,  2.931027627086856e-11, -1.130912343260126e-12,  3.975448796870439e-14, -1.284163559662418e-15,
  8.331021242111531e-03, -2.614137297542603e-03,  4.310372027498482e-04, -4.851323821118109e-05,  4.167436464410682e-06, -2.907074127733759e-07,  1.712791656356781e-08,
 -8.757822704192059e-10,  3.963982990990939e-11, -1.612336490656222e-12,  5.963575958636316e-14, -2.023133261040033e-15,  6.819322780686822e-03, -2.272562152545647e-03,
  3.986066037080731e-04, -4.764859194463352e-05,  4.338235350512917e-06, -3.200542420165326e-07,  1.990172297481812e-08, -1.071858068828106e-09,  5.100450054002882e-11,
 -2.177167947931456e-12,  8.436599070078595e-14, -2.993485615095441e-15,  5.565745803711184e-03, -1.956114889317328e-03,  3.626041007529013e-04, -4.575631397649479e-05,
  4.390157257303113e-06, -3.406939376706783e-07,  2.224453310611915e-08, -1.255762394012889e-09,  6.253098578248732e-11, -2.788742194551780e-12,  1.127352102689647e-13,
 -4.166655174075752e-15,  4.525884792680023e-03, -1.666583602179531e-03,  3.244684146031006e-04, -4.296859283599514e-05,  4.320460938559958e-06, -3.508282818001573e-07,
  2.393106498022501e-08, -1.409290733772354e-09,  7.309926322267820e-11, -3.391152298714514e-12,  1.424107054460942e-13, -5.460460990156519e-15,  3.661043745479610e-03,
 -1.403845945623469e-03,  2.853534759290009e-04, -3.943236333263769e-05,  4.132648852641315e-06, -3.493237754523819e-07,  2.477186260566307e-08, -1.514599914610863e-09,
  8.146404146456663e-11, -3.914091041473237e-12,  1.700406519733433e-13, -6.736744261836598e-15,  2.937963885236549e-03, -1.166411771421889e-03,  2.461189306533510e-04,
 -3.529458280636080e-05,  3.835145079102416e-06, -3.357480265332134e-07,  2.463168583903795e-08, -1.556343986155292e-09,  8.641312268365634e-11, -4.281537313533196e-12,
  1.916204137410030e-13, -7.812873217646002e-15,  2.328305369331239e-03, -9.518712699814988e-04,  2.073470905074608e-04, -3.069153424389738e-05,  3.439840552274901e-06,
 -3.103378502930089e-07,  2.344122407699114e-08, -1.523550023290932e-09,  8.693679829352323e-11, -4.422984416941152e-12,  2.030862332434570e-13, -8.487689418992197e-15,
  1.808001472647688e-03, -7.572414310703948e-04,  1.693758068022947e-04, -2.574223002374138e-05,  2.960731937665069e-06, -2.739196237241316e-07,  2.120173696307038e-08,
 -1.410988155907680e-09,  8.238027973655887e-11, -4.285222925489231e-12,  2.010349712106635e-13, -8.578167263085809e-15,  1.356565486965000e-03, -5.792170365884189e-04,
  1.323389240207004e-04, -2.054548299233719e-05,  2.412804682654480e-06, -2.278040742503407e-07,  1.798330103189140e-08, -1.219893191659589e-09,  7.255472096451492e-11,
 -3.842455483136278e-12,  1.834238871044874e-13, -7.959227485472556e-15,  9.564013593682232e-04, -4.143403118316801e-04,  9.620865164314701e-05, -1.517998679474961e-05,
  1.811238681842397e-06, -1.736751345886637e-07,  1.391801034523176e-08, -9.580020012962222e-10,  5.779014473625417e-11, -3.102778438062162e-12,  1.500951691188050e-13,
 -6.597134282292538e-15,  5.921613516475511e-04, -2.591130647110705e-04,  6.083816798402932e-05, -9.706952291663631e-06,  1.170983984055919e-06, -1.134900857833965e-07,
  9.189934454897852e-09, -6.389746131553180e-10,  3.892426546415150e-11, -2.109777580897311e-12,  1.030017915401094e-13, -4.567629046225113e-15,  2.505015187600398e-04,
 -1.102181665714927e-04,  2.603851420288705e-05, -4.180350124698509e-06,  5.073694054339092e-07, -4.946634767383356e-08,  4.028760520155467e-09, -2.816932409553916e-10,
  1.725336842353755e-11, -9.401103332568756e-13,  4.613231889563401e-14, -2.055866848840624e-15,  9.635915040323145e-02, -3.959908614496702e-04,  1.724333439624658e-06,
 -7.824983871615559e-09,  3.641877782781272e-11, -1.717474638969976e-13,  8.140468904369848e-16, -3.859239059170150e-18,  1.824913901700870e-20, -8.595587929865211e-23,
  4.030087726413792e-25, -1.880523805963262e-27,  9.395693957281068e-02, -5.838219148473656e-04,  4.237300972093101e-06, -3.046949727874150e-08,  2.110185724894806e-10,
 -1.410961779904569e-12,  9.162298530297902e-15, -5.806179872370461e-17,  3.603515097825262e-19, -2.196204848895201e-21,  1.317118774501080e-23, -7.785409567797086e-26,
  8.934793891057413e-02, -9.300918138197398e-04,  1.002112536655958e-05, -9.778488337856419e-08,  8.848341858424483e-10, -7.566773879568611e-12,  6.186597155471349e-14,
 -4.873361987886443e-16,  3.719105629933307e-18, -2.761129822992582e-20,  2.000687843737994e-22, -1.418461743559138e-24,  8.289478324384836e-02, -1.382063792725808e-03,
  2.022579901743509e-05, -2.549694983197079e-07,  2.907896609911557e-09, -3.077918240774315e-11,  3.070579230195269e-13, -2.917300857488287e-15,  2.659343694035895e-17,
 -2.338945464071432e-19,  1.993376076536016e-21, -1.651731402239384e-23,  7.507689015370189e-02, -1.874128374070067e-03,  3.581129449275548e-05, -5.686741221820284e-07,
  7.985749859444336e-09, -1.023433886702245e-10,  1.220259969227087e-12, -1.371180425931632e-14,  1.465463667416551e-16, -1.499903501306146e-18,  1.477907847957575e-20,
 -1.407674568184372e-22,  6.642807588036394e-02, -2.339998577767803e-03,  5.698188251181549e-05, -1.117553980363741e-06,  1.897905385988881e-08, -2.896951420793734e-10,
  4.065609030189266e-12, -5.326005644270904e-14,  6.583170757735361e-16, -7.739131675490074e-18,  8.706407826349040e-20, -9.417535233825354e-22,  5.747399106249412e-02,
 -2.723720008851514e-03,  8.285365462584409e-05, -1.973491544044510e-06,  3.994024748558939e-08, -7.165430087818559e-10,  1.169242229792275e-11, -1.765371503752578e-13,
  2.496382217150868e-15, -3.336140550930094e-17,  4.242731039986082e-19, -5.162209449892420e-21,  4.867972472420681e-02, -2.987235012530730e-03,  1.114707859292954e-04,
 -3.177382013700811e-06,  7.567063144942118e-08, -1.577689254878746e-09,  2.962564230977256e-11, -5.105838967289717e-13,  8.185321086428753e-15, -1.232799303020427e-16,
  1.757753851932642e-18, -2.386642157021744e-20,  4.041433555842603e-02, -3.113429422545915e-03,  1.401502307783880e-04, -4.717685139404138e-06,  1.307331276619629e-07,
 -3.136243278432089e-09,  6.715708425802887e-11, -1.310076800572740e-12,  2.362218332299905e-14, -3.979617463888545e-16,  6.316292664609651e-18, -9.504869709339974e-20,
  3.293460132192973e-02, -3.104868173477812e-03,  1.660232187978398e-04, -6.520388959481197e-06,  2.081048494490527e-07, -5.692558396854977e-09,  1.378668368569446e-10,
 -3.021172202535827e-12,  6.083723287910909e-14, -1.138783689376196e-15,  1.999142320766092e-17, -3.313792065684581e-19,  2.638623168308993e-02, -2.979391477311653e-03,
  1.865946324253832e-04, -8.455247267409769e-06,  3.078774156212570e-07, -9.523080279589397e-09,  2.588899955898439e-10, -6.328686730145500e-12,  1.414004270647979e-13,
 -2.922854403610382e-15,  5.642338444751404e-17, -1.024511757953866e-18,  2.081806775178220e-02, -2.764183020069949e-03,  2.001641160627505e-04, -1.035712932044103e-05,
  4.264801513173097e-07, -1.480068839700470e-08,  4.484712261510731e-10, -1.215031616278942e-11,  2.993854928107392e-13, -6.794999039789066e-15,  1.434618824545193e-16,
 -2.838719318065334e-18,  1.620370844412624e-02, -2.489841666191922e-03,  2.060225736709060e-04, -1.205601478471268e-05,  5.567585030309761e-07, -2.151958476725672e-08,
  7.219368754137604e-10, -2.154433357611810e-11,  5.820895485931065e-13, -1.442799568946665e-14,  3.314567416679652e-16, -7.112490407795020e-18,  1.246535109199279e-02,
 -2.185554279884663e-03,  2.044190185489362e-04, -1.340681095974940e-05,  6.889476410400209e-07, -2.945078381323997e-08,  1.086947967032896e-09, -3.551984557135747e-11,
  1.046551590580800e-12, -2.818349385884707e-14,  7.010810518026774e-16, -1.623863426969648e-17,  9.495893770152199e-03, -1.875903228445657e-03,  1.963551559183992e-04,
 -1.431128654398637e-05,  8.122754841717500e-07, -3.814627936382506e-08,  1.539417967431146e-09, -5.477624904492116e-11,  1.750739314227719e-12, -5.097002713701735e-14,
  1.366455999063392e-15, -3.401054226050177e-17,  7.176940138823149e-03, -1.579338202585748e-03,  1.832937521823435e-04, -1.472793331943876e-05,  9.167421285709065e-07,
 -4.699421048355566e-08,  2.061486740586513e-09, -7.943530787260659e-11,  2.740048830804378e-12, -8.582512098453079e-14,  2.468397122040321e-15, -6.573158646866710e-17,
  5.391815068075030e-03, -1.308005853512383e-03,  1.668631931863296e-04, -1.466968122317481e-05,  9.946150566045585e-07, -5.531082105500561e-08,  2.622382271718812e-09,
 -1.088465521576231e-10,  4.031861660048007e-12, -1.352309471503081e-13,  4.153863808290935e-15, -1.178412123460405e-16,  4.033781975696398e-03, -1.068484135469760e-03,
  1.486163458941962e-04, -1.419253996513459e-05,  1.041325165045629e-06, -6.244455832395369e-08,  3.182103281796517e-09, -1.415336489031117e-10,  5.602359471016093e-12,
 -2.002830305768348e-13,  6.541595221374629e-15, -1.968739066137615e-16,  3.010282006964020e-03, -8.629733852516080e-04,  1.298710619389107e-04, -1.337966528301801e-05,
  1.055664508434926e-06, -6.786661862348316e-08,  3.697000040744540e-09, -1.753096701921649e-10,  7.379818812748821e-12, -2.799224145020952e-13,  9.679466653328333e-15,
 -3.077579583379711e-16,  2.244252287520354e-03, -6.905908223646983e-04,  1.116332505734531e-04, -1.232513519753539e-05,  1.039382913592104e-06, -7.122949532766814e-08,
  4.125847615039217e-09, -2.075390452380058e-10,  9.247044738351813e-12, -3.704675514706190e-13,  1.350407874501032e-14, -4.517343802440895e-16,  1.673546238097012e-03,
 -5.485405472629749e-04,  9.458670085564805e-05, -1.112047435702915e-05,  9.963994064872429e-07, -7.238646634844774e-08,  4.435025857488746e-09, -2.354834265965538e-10,
  1.105304089928790e-11, -4.656236924405072e-13,  1.781508158087936e-14, -6.244257314308311e-16,  1.249298187348754e-03, -4.330465813359495e-04,  7.912711857057137e-05,
 -9.845397841595110e-06,  9.318723239450945e-07, -7.137579398647622e-08,  4.601852291986530e-09, -2.566516384215793e-10,  1.263146416322495e-11, -5.570233988901310e-13,
  2.227442919370566e-14, -8.146891957044637e-16,  9.338452739604795e-04, -3.400220743057950e-04,  6.541861975645848e-05, -8.562899262952562e-06,  8.513301057570212e-07,
 -6.838049349379073e-08,  4.615731791565310e-09, -2.690828635057481e-10,  1.382179674175445e-11, -6.352090967968024e-13,  2.643471252133345e-14, -1.004777057790051e-15,
  6.986036723952312e-04, -2.654997060968390e-04,  5.345578655204619e-05, -7.317941301146236e-06,  7.599886501346019e-07, -6.367688295872481e-08,  4.477354916884174e-09,
 -2.715196110929042e-10,  1.448892604840017e-11, -6.908590457509177e-13,  2.979308993579776e-14, -1.172019906969673e-15,  5.221231381246439e-04, -2.058720621640010e-04,
  4.312044263618628e-05, -6.138637702878501e-06,  6.623032888272185e-07, -5.758361001013998e-08,  4.196541859194231e-09, -2.634603546857992e-10,  1.453780615879583e-11,
 -7.160148146328056e-13,  3.186082008488441e-14, -1.291846089525953e-15,  3.884209118736008e-04, -1.579952800362723e-04,  3.422770382136697e-05, -5.038821707360609e-06,
  5.617441202170797e-07, -5.041919055570492e-08,  3.789449794934645e-09, -2.451098041928172e-10,  1.392153740363286e-11, -7.050950274754044e-13,  3.223501720510808e-14,
 -1.341592430893209e-15,  2.856177440854523e-04, -1.192030558963985e-04,  2.655979407762678e-05, -4.021113475685457e-06,  4.607495164364940e-07, -4.247199742668368e-08,
  3.275784578735102e-09, -2.172612257295453e-10,  1.264289857795348e-11, -6.555554260202447e-13,  3.065960854610102e-14, -1.304357433469109e-15,  2.048547713479362e-04,
 -8.726754697743717e-05,  1.988850562226155e-05, -3.079888825305668e-06,  3.608014960841327e-07, -3.398326518261157e-08,  2.676470251526133e-09, -1.811491713569671e-10,
  1.075061683867351e-11, -5.681466955218540e-13,  2.706582321511995e-14, -1.172144265190296e-15,  1.394494791270913e-04, -6.033283745764812e-05,  1.398833619848038e-05,
 -2.203825633062627e-06,  2.625715501656498e-07, -2.514155866416721e-08,  2.012018778021630e-09, -1.383055516758857e-10,  8.332265423048626e-12, -4.468004175040320e-13,
  2.158737686266158e-14, -9.477124824562552e-16,  8.424465356011903e-05, -3.683819550073838e-05,  8.642849942616253e-06, -1.377949423508844e-06,  1.661023654925027e-07,
 -1.608660783471863e-08,  1.301693204042826e-09, -9.044357053958712e-11,  5.505801625061058e-12, -2.982296813679004e-13,  1.455059810542187e-14, -6.448476846938575e-16,
  3.515058550123284e-05, -1.546114764017328e-05,  3.651351217072657e-06, -5.859985658447184e-07,  7.109772139699242e-08, -6.929324685006850e-09,  5.641632041700846e-10,
 -3.943344476756495e-11,  2.414459751885539e-12, -1.315180841871408e-13,  6.451716290446633e-15, -2.874295326677598e-16,  9.480219524279199e-02, -3.825621415881864e-04,
  1.633819823438302e-06, -7.268737091744809e-09,  3.317077634869242e-11, -1.534438058418786e-13,  7.137198970532275e-16, -3.321820727525006e-18,  1.542602296888914e-20,
 -7.137414225154693e-23,  3.287912561015833e-25, -1.507644463695908e-27,  9.168721134528962e-02, -5.513307155793606e-04,  3.891030798639681e-06, -2.730753657286833e-08,
  1.848730413457469e-10, -1.209341926793169e-12,  7.686807720147633e-15, -4.770021833999155e-17,  2.900008444220567e-19, -1.731909486778355e-21,  1.018070422455709e-23,
 -5.899891888626676e-26,  8.578080325580860e-02, -8.543868098487337e-04,  8.927905980193831e-06, -8.476195573262517e-08,  7.473070598707282e-10, -6.233153356736856e-12,
  4.974762854577058e-14, -3.827986233060576e-16,  2.855288765546996e-18, -2.072910687531541e-20,  1.469401216909051e-22, -1.019555133372312e-24,  7.767182124294650e-02,
 -1.231749302777465e-03,  1.742623393728814e-05, -2.129935553594463e-07,  2.359856283576689e-09, -2.430110678306688e-11,  2.361235250906327e-13, -2.186961551299999e-15,
  1.944913467927838e-17, -1.669894735913120e-19,  1.390090184095206e-21, -1.125622930557057e-23,  6.811301184385694e-02, -1.612908087397087e-03,  2.969110971563917e-05,
 -4.558074514344370e-07,  6.203186990028057e-09, -7.718049853038498e-11,  8.946130584988724e-13, -9.783269060196730e-15,  1.018505897078549e-16, -1.016216786446010e-18,
  9.767813497777006e-21, -9.081128465350056e-23,  5.790160550786402e-02, -1.933032052973454e-03,  4.521790920658535e-05, -8.554060713129565e-07,  1.405139505248519e-08,
 -2.078706976496898e-10,  2.831729694719455e-12, -3.605295377584120e-14,  4.335485058536001e-16, -4.962995375361426e-18,  5.440972365202639e-20, -5.739333740274592e-22,
  4.776880058556988e-02, -2.145752436155765e-03,  6.257826028063454e-05, -1.435378919626063e-06,  2.805751922489421e-08, -4.872171982397182e-10,  7.708218241024225e-12,
 -1.129917087692983e-13,  1.553028480491465e-15, -2.019285702161913e-17,  2.500679932573249e-19, -2.965122090118011e-21,  3.829902116580798e-02, -2.229569887656895e-03,
  7.967834105748452e-05, -2.184826735466380e-06,  5.020617787035215e-08, -1.012293954859557e-09,  1.841514768314825e-11, -3.079116897754452e-13,  4.794885287617856e-15,
 -7.022272473489633e-17,  9.745179030544216e-19, -1.288928065277004e-20,  2.988904197686310e-02, -2.187371405987675e-03,  9.427142377951841e-05, -3.051270240607551e-06,
  8.154573820765480e-08, -1.890918880732776e-09,  3.920927667378409e-11, -7.417873154638826e-13,  1.298802565891632e-14, -2.127094439873370e-16,  3.285150830653449e-18,
 -4.814722785221778e-20,  2.274576948585540e-02, -2.040669507133349e-03,  1.045118595721928e-04, -3.946982139604179e-06,  1.214839198629832e-07, -3.211876140477763e-09,
  7.532049023713649e-11, -1.600629094749264e-12,  3.129772981200701e-14, -5.695182858481691e-16,  9.729086723351786e-18, -1.570776677512558e-19,  1.691315982947491e-02,
 -1.821291055430921e-03,  1.093512995316549e-04, -4.767466944424951e-06,  1.674762653732578e-07, -5.008445111463345e-09,  1.318751976735450e-10, -3.127078022420180e-12,
  6.786095881688552e-14, -1.364015729228556e-15,  2.563060813672352e-17, -4.534307229842255e-19,  1.231509699358589e-02, -1.563211451518014e-03,  1.086717644121159e-04,
 -5.415493660052903e-06,  2.153051962113357e-07, -7.229055421125027e-09,  2.122864274888099e-10, -5.582152888572153e-12,  1.336685200143459e-13, -2.951659207869655e-15,
  6.069246813846704e-17, -1.170711943301681e-18,  8.801739688844259e-03, -1.296388367262679e-03,  1.031646921730914e-04, -5.822195213245210e-06,  2.599007414717789e-07,
 -9.728795963332131e-09,  3.166024130229885e-10, -9.178049591206480e-12,  2.411845646474579e-13, -5.820899006690760e-15,  1.303376439750455e-16, -2.728516662113321e-18,
  6.190296356639992e-03, -1.043330728734862e-03,  9.404713876281947e-05, -5.958806628425596e-06,  2.964275077727973e-07, -1.228817133961925e-08,  4.404694716584220e-10,
 -1.399824861941116e-11,  4.015817561557666e-13, -1.054100414533891e-14,  2.558287022193512e-16, -5.786511868016832e-18,  4.295519988253815e-03, -8.181970661525979e-04,
  8.273258988309085e-05, -5.836968837325242e-06,  3.212722453627588e-07, -1.465451833079817e-08,  5.752170880137965e-10, -1.993254614267095e-11,  6.211144162217901e-13,
 -1.764750406302400e-14,  4.621496398627335e-16, -1.124594402583835e-17,  2.948973083400276e-03, -6.276810968408274e-04,  7.055205272291033e-05, -5.499756701029180e-06,
  3.326409754835882e-07, -1.659263343720916e-08,  7.091607804807656e-10, -2.665425939564003e-11,  8.977374432711350e-13, -2.748230371228447e-14,  7.731742881238032e-16,
 -2.015658923767068e-17,  2.008577748196828e-03, -4.728150240107133e-04,  5.857569913979644e-05, -5.007970569002857e-06,  3.306530461310445e-07, -1.792863414665123e-08,
  8.297482166769087e-10, -3.365328692049324e-11,  1.219246623835600e-12, -4.003246783274105e-14,  1.204722569540540e-15, -3.350917814795714e-17,  1.361075551810202e-03,
 -3.509710553993196e-04,  4.754084138600558e-05, -4.426365865393032e-06,  3.170032526388257e-07, -1.857526638539184e-08,  9.258788534409298e-10, -4.031814377328349e-11,
  1.563805833949621e-12, -5.482382361097912e-14,  1.757275515677221e-15, -5.193761940192161e-17,  9.201076933398377e-04, -2.576065673232853e-04,  3.786291515514581e-05,
 -3.813063430341885e-06,  2.943764616286960e-07, -1.853478964623990e-08,  9.897268886614132e-10, -4.604259458513620e-11,  1.902900923877466e-12, -7.091376819846578e-14,
  2.410749886031878e-15, -7.540422938865715e-17,  6.221361916354357e-04, -1.875538442210760e-04,  2.969535946798310e-05, -3.213445536895206e-06,  2.658189131266208e-07,
 -1.788316056201859e-08,  1.017648534220146e-09, -5.032584312554665e-11,  2.205910047394948e-12, -8.699562649018119e-14,  3.123393960661296e-15, -1.029691309634225e-16,
  4.217424828004004e-04, -1.358383168769100e-04,  2.300719148721277e-05, -2.658242994244391e-06,  2.342194676472448e-07, -1.674364758753823e-08,  1.010106090033564e-09,
 -5.284090315690715e-11,  2.444989038626319e-12, -1.015891778106773e-13,  3.835624594692246e-15, -1.327337728307976e-16,  2.872028251698100e-04, -9.810812018002335e-05,
  1.765666033819320e-05, -2.164633364185568e-06,  2.019748460670849e-07, -1.525857040191335e-08,  9.708339217579229e-10, -5.345932725006383e-11,  2.599006096825760e-12,
 -1.132654111973423e-13,  4.478023962446192e-15, -1.619992792135808e-16,  1.967585829501451e-04, -7.079013754778039e-05,  1.344982958236900e-05, -1.738965807893424e-06,
  1.708419611448912e-07, -1.356563523401427e-08,  9.056149255431855e-10, -5.223502452007200e-11,  2.655724152044714e-12, -1.208480717800684e-13,  4.981453525996123e-15,
 -1.876136832646228e-16,  1.356901761830686e-04, -5.107980779064108e-05,  1.018105768196230e-05, -1.379961567968279e-06,  1.419364681283507e-07, -1.178205251559013e-08,
  8.210270561579762e-10, -4.935996898368207e-11,  2.612060655913760e-12, -1.235491384568400e-13,  5.286801132262839e-15, -2.064263787166106e-16,  9.413578435584695e-05,
 -3.684665320570529e-05,  7.657200252712326e-06, -1.081643739177006e-06,  1.158212440177274e-07, -9.996704721113835e-09,  7.234126267103006e-10, -4.510808494789814e-11,
  2.472789653077152e-12, -1.210208018624882e-13,  5.352306898486637e-15, -2.157442378736790e-16,  6.552546811595722e-05, -2.650959507359406e-05,  5.709411868616788e-06,
 -8.356370394899951e-07,  9.263336060269166e-08, -8.268795479900708e-09,  6.181872425829366e-10, -3.978151560997926e-11,  2.248338692204702e-12, -1.133314688491673e-13,
  5.157398033135187e-15, -2.136961821837326e-16,  4.548817848317394e-05, -1.891296290143935e-05,  4.196645576606409e-06, -6.327584981133329e-07,  7.221265699797053e-08,
 -6.630714349010445e-09,  5.094916875255494e-10, -3.366843637858020e-11,  1.952360133628158e-12, -1.008897771693342e-13,  4.703042120805427e-15, -1.994505221018605e-16,
  3.110402267120392e-05, -1.321780490253996e-05,  3.004250902230929e-06, -4.639793334741376e-07,  5.421097407935930e-08, -5.092980059647021e-09,  4.001215975632988e-10,
 -2.701615247534533e-11,  1.599603538792009e-12, -8.434601525967588e-14,  4.009429808643698e-15, -1.732739399826715e-16,  2.039905166484413e-05, -8.813061763521681e-06,
  2.040097695082651e-06, -3.209023752882845e-07,  3.817400150516570e-08, -3.649677248427404e-09,  2.916458728564844e-10, -2.001909756274830e-11,  1.204393315348771e-12,
 -6.449677105994605e-14,  3.112158221547983e-15, -1.364567257127845e-16,  1.200527907668133e-05, -5.245859482314567e-06,  1.229778402535507e-06, -1.959081894076048e-07,
  2.359663254186847e-08, -2.283502253050272e-09,  1.846362756507071e-10, -1.281936146740431e-11,  7.798272064179873e-13, -4.221108100615973e-14,  2.058081999744814e-15,
 -9.114948099103025e-17,  4.936145656840355e-06, -2.170487552075142e-06,  5.124024136117316e-07, -8.220414156301980e-08,  9.969963569537490e-09, -9.713413306171289e-10,
  7.905540219467383e-11, -5.523829833517404e-12,  3.381016665854516e-13, -1.841058373981896e-14,  9.028488000188207e-16, -4.020981943540804e-17,  9.329754780710213e-02,
 -3.698316872708964e-04,  1.549681030651860e-06, -6.761655638071842e-09,  3.026593764482050e-11, -1.373771661272131e-13,  6.272508708594443e-16, -2.866885395741455e-18,
  1.307814054922766e-20, -5.945753305957294e-23,  2.691812431261103e-25, -1.213267576751243e-27,  8.954213825007054e-02, -5.214647207359487e-04,  3.580321278220646e-06,
 -2.453347497330817e-08,  1.624280374772731e-10, -1.039892092763314e-12,  6.472281169403434e-15, -3.934398237572227e-17,  2.343975181184343e-19, -1.372165540853351e-21,
  7.908676235729181e-24, -4.494903746797584e-26,  8.249993558784266e-02, -7.868379386609314e-04,  7.978590713221104e-06, -7.374094334232367e-08,  6.337658109146195e-10,
 -5.158156930572885e-12,  4.020385727146637e-14, -3.023171866229074e-16,  2.204859176377845e-18, -1.565870325508846e-20,  1.086274129008194e-22, -7.378927993972435e-25,
  7.300831614973916e-02, -1.101956276732899e-03,  1.508176214214547e-05, -1.788357489737961e-07,  1.925884982887160e-09, -1.930382692510710e-11,  1.827693145949986e-13,
 -1.650942199634005e-15,  1.432957626169332e-17, -1.201527729719273e-19,  9.773133298882586e-22, -7.736394214104841e-24,  6.210403225136628e-02, -1.395680872587965e-03,
  2.476952654010301e-05, -3.678256825525993e-07,  4.853864868310247e-09, -5.865996072687047e-11,  6.613063589022450e-13, -7.041157638228464e-15,  7.143293092094851e-17,
 -6.950604842745391e-19,  6.519575868910464e-21, -5.918353461909448e-23,  5.083296041544510e-02, -1.608819860710034e-03,  3.617586259551823e-05, -6.604674816811787e-07,
  1.049928072688287e-08, -1.506064754269168e-10,  1.992348132773722e-12, -2.466290275617118e-14,  2.886494489832688e-16, -3.218718856262477e-18,  3.439935794033676e-20,
 -3.539672834090386e-22,  4.008782811784715e-02, -1.707073120981189e-03,  4.775551783545679e-05, -1.055344465721836e-06,  1.993328754011497e-08, -3.351779276541108e-10,
  5.143338258674183e-12, -7.322456987100870e-14,  9.785791767786695e-16, -1.238337395460615e-17,  1.493791668831859e-19, -1.726604435837599e-21,  3.050697895221239e-02,
 -1.684754818444395e-03,  5.768256605917919e-05, -1.522128429033956e-06,  3.376218292585059e-08, -6.585424708841781e-10,  1.160951430853855e-11, -1.883854528106313e-13,
  2.850396662825395e-15, -4.060338960063105e-17,  5.485654482601850e-19, -7.069318676384699e-21,  2.244390619524282e-02, -1.560054480010908e-03,  6.438474272713854e-05,
 -2.004255880454902e-06,  5.167090816494668e-08, -1.158433935026606e-09,  2.326602478433483e-11, -4.269664700273790e-13,  7.260847259388063e-15, -1.156209769841710e-16,
  1.737922292286470e-18, -2.481133472309943e-20,  1.599624431255982e-02, -1.365298235207711e-03,  6.697163072841992e-05, -2.432342243441103e-06,  7.220639013229550e-08,
 -1.845383010028518e-09,  4.190817935944226e-11, -8.637575662084466e-13,  1.640183603979848e-14, -2.901729291859472e-16,  4.824205349642255e-18, -7.586950580314011e-20,
  1.107080923813032e-02, -1.136392811759360e-03,  6.539902958854849e-05, -2.743106236496104e-06,  9.296380749371050e-08, -2.687911616435028e-09,  6.854934665937381e-11,
 -1.576751859257475e-12,  3.323500150462892e-14, -6.495965347222082e-16,  1.188159279998084e-17, -2.047963897614442e-19,  7.459593344202182e-03, -9.046401238142615e-04,
  6.035394514192142e-05, -2.895994760531682e-06,  1.111477006654726e-07, -3.610070451384419e-09,  1.027300056207764e-10, -2.621569588509509e-12,  6.100058485324858e-14,
 -1.310424185578990e-15,  2.624006118649550e-17, -4.933690194138146e-19,  4.907556580195324e-03, -6.923264267245559e-04,  5.295939892466634e-05, -2.881393285990765e-06,
  1.242936448830162e-07, -4.504766380753520e-09,  1.421729763075484e-10, -4.002801082371696e-12,  1.022868579279594e-13, -2.403273565731801e-15,  5.244007452466430e-17,
 -1.070791654684768e-18,  3.162065222269911e-03, -5.118636448616865e-04,  4.443905291526126e-05, -2.718723377129855e-06,  1.308679202394933e-07, -5.258877406893789e-09,
  1.830151717835014e-10, -5.654588035910208e-12,  1.578996002091145e-13, -4.038672058503556e-15,  9.560501043513379e-17, -2.111150670322904e-18,  2.002003108151466e-03,
 -3.673271598252874e-04,  3.585342357530776e-05, -2.447035387292948e-06,  1.305408355697720e-07, -5.780667601096543e-09,  2.205952517384111e-10, -7.441123764432859e-12,
  2.259717517704315e-13, -6.263544479406037e-15,  1.601700542626028e-16, -3.809246434541169e-18,  1.249855831014716e-03, -2.570451171828010e-04,  2.795823918747160e-05,
 -2.112830342217911e-06,  1.240908271061146e-07, -6.019540004136988e-09,  2.505229278480394e-10, -9.179852853023999e-12,  3.017496864931350e-13, -9.024006792273092e-15,
  2.482318490178943e-16, -6.332794316730043e-18,  7.722046297759845e-04, -1.761953430378394e-04,  2.117869702235186e-05, -1.759448643971084e-06,  1.130436412588583e-07,
 -5.972397771831301e-09,  2.696436274960329e-10, -1.068021378402905e-11,  3.782487980412961e-13, -1.215125769043477e-14,  3.580778219592169e-16, -9.760630927495108e-18,
  4.739141935404154e-04, -1.188364247507267e-04,  1.566135864183251e-05, -1.420446986638113e-06,  9.921820298578556e-08, -5.676894552606849e-09,  2.765892539498045e-10,
 -1.178436265573040e-11,  4.476081336022389e-13, -1.537975252429263e-14,  4.835194088481657e-16, -1.402706596685328e-17,  2.899963630379718e-04, -7.920915091597807e-05,
  1.135948378953184e-05, -1.117289048833761e-06,  8.433185742267472e-08, -5.196407443365659e-09,  2.718055642348726e-10, -1.239656123529341e-11,  5.026895907239526e-13,
 -1.839398545985080e-14,  6.144073056964310e-16, -1.889502373200961e-17,  1.775897829778415e-04, -5.239718250208070e-05,  8.118086233460555e-06, -8.602880658704919e-07,
  6.974920612089768e-08, -4.603023948440463e-09,  2.571506537921036e-10, -1.249381248099594e-11,  5.384033235894571e-13, -2.088889745583157e-14,  7.382563660061296e-16,
 -2.397222499842405e-17,  1.092222927215048e-04, -3.453670185714607e-05,  5.740587683177310e-06, -6.512749102996353e-07,  5.638612330439856e-08, -3.963544005817047e-09,
  2.352759345359442e-10, -1.211809323932239e-11,  5.524015077394991e-13, -2.262476330138570e-14,  8.424840186131355e-16, -2.876890192187061e-17,  6.768177393730615e-05,
 -2.276502168068016e-05,  4.032087748439843e-06, -4.866745561162298e-07,  4.473270750478143e-08, -3.330924488577319e-09,  2.090075184316969e-10, -1.135634272142688e-11,
  5.450549154506036e-13, -2.346152235535698e-14,  9.165745787149913e-16, -3.278027553218995e-17,  4.237150019803514e-05, -1.505221077520857e-05,  2.822143445945312e-06,
 -3.601702947179190e-07,  3.494240577930046e-08, -2.741191020503214e-09,  1.808759615897121e-10, -1.031637845855195e-11,  5.188693332091586e-13, -2.336666782114227e-14,
  9.535838573179058e-16, -3.556946103645802e-17,  2.684967792547147e-05, -1.000552798113965e-05,  1.973000566826969e-06, -2.646197797491927e-07,  2.694084771976852e-08,
 -2.214396666541900e-09,  1.528497803207634e-10, -9.105556603676096e-12,  4.776222510440077e-13, -2.240008150055659e-14,  9.507008018917091e-16, -3.682908534732443e-17,
  1.723206986406784e-05, -6.692445772310524e-06,  1.379184905106652e-06, -1.932185120585931e-07,  2.052425519184649e-08, -1.757792182994884e-09,  1.262545394696767e-10,
 -7.815954486065413e-12,  4.254945900287533e-13, -2.068493283452772e-14,  9.089199622699895e-16, -3.640990803687073e-17,  1.118545832818416e-05, -4.499192894042845e-06,
  9.629560385006680e-07, -1.400687232185108e-07,  1.543372996062097e-08, -1.369650787086232e-09,  1.018212624683354e-10, -6.516828616870775e-12,  3.663839930592216e-13,
 -1.837491242147922e-14,  8.321132327309256e-16, -3.431662078088915e-17,  7.307427715167523e-06, -3.025991652515366e-06,  6.684853446862014e-07, -1.003506438420430e-07,
  1.140342031207977e-08, -1.042746935986353e-09,  7.980170773464714e-11, -5.253078888622677e-12,  3.034763137717662e-13, -1.562579158456679e-14,  7.258681663373364e-16,
 -3.067989239620364e-17,  4.750171690905008e-06, -2.013317110148500e-06,  4.562833644623001e-07, -7.026611878015523e-08,  8.186755680274752e-09, -7.670251488708940e-10,
  6.010082017296763e-11, -4.047627516671923e-12,  2.390645408858959e-13, -1.257561361764149e-14,  5.964085193274855e-16, -2.571741117643227e-17,  2.994426553732758e-06,
 -1.291716366856022e-06,  2.985079715413798e-07, -4.687507635541341e-08,  5.566930128016246e-09, -5.313750544278459e-10,  4.239573466973238e-11, -2.905706027291053e-12,
  1.745570023904185e-13, -9.334456692408757e-15,  4.497949806776263e-16, -1.969565499031199e-17,  1.713857494448655e-06, -7.483204053840680e-07,  1.752780259621604e-07,
 -2.789850048517735e-08,  3.357469106429798e-09, -3.246427770700262e-10,  2.622847580535707e-11, -1.819632816644294e-12,  1.106080280920970e-13, -5.982669353945406e-15,
  2.914879235385138e-16, -1.290063700447427e-17,  6.937322743844281e-07, -3.049402744152322e-07,  7.196200879215685e-08, -1.154032451813825e-08,  1.399108541100374e-09,
 -1.362591689785623e-10,  1.108573340091159e-11, -7.743108243936212e-13,  4.737701655381697e-14, -2.578911822829746e-15,  1.264257761104107e-16, -5.628697283644583e-18,
  9.184251342202952e-02, -3.577507697926235e-04,  1.471358601007811e-06, -6.298589513756344e-09,  2.766266870919981e-11, -1.232410341656682e-13,  5.525295353733367e-16,
 -2.480654352825883e-18,  1.111928264204863e-20, -4.968535402986976e-23,  2.211255756615624e-25, -9.799397462679210e-28,  8.751176031877921e-02, -4.939571044851119e-04,
  3.300852692332216e-06, -2.209292912346168e-08,  1.430985053343250e-10, -8.969728942066701e-13,  5.468647482524533e-15, -3.257623960318988e-17,  1.902477901103812e-19,
 -1.092054872174682e-21,  6.173426775521475e-24, -3.442150526504193e-26,  7.947487041434206e-02, -7.263839074549381e-04,  7.151298815917343e-06, -6.437631065521758e-08,
  5.396050410980800e-10, -4.287362548177391e-12,  3.264763851038485e-14, -2.400020835799186e-16,  1.712124017005927e-18, -1.189904947059783e-20,  8.081130480996485e-23,
 -5.375972134499152e-25,  6.882891043480384e-02, -9.893903226404579e-04,  1.310860879785114e-05, -1.508867037757007e-07,  1.580180505684931e-09, -1.542400682309130e-11,
  1.423624855180596e-13, -1.254677441899929e-15,  1.063281461861493e-17, -8.710136397359237e-20,  6.925146653147682e-22, -5.360931952441327e-24,  5.689141943633812e-02,
 -1.213943917234831e-03,  2.078549458084252e-05, -2.987497589410157e-07,  3.824652830642494e-09, -4.491757508825620e-11,  4.927255955506848e-13, -5.110012019132161e-15,
  5.053868929137982e-17, -4.797483562590305e-19,  4.392910542126472e-21, -3.895133699963382e-23,  4.493004908050367e-02, -1.348472731272744e-03,  2.916660002822523e-05,
 -5.141953002020173e-07,  7.914351544733364e-09, -1.101313750400314e-10,  1.415412581991613e-12, -1.704226721160728e-14,  1.941997879333603e-16, -2.110198203184046e-18,
  2.199242479746795e-20, -2.208280322628385e-22,  3.395045138323718e-02, -1.370732774020255e-03,  3.680372566727354e-05, -7.839717536947149e-07,  1.431473566203176e-08,
 -2.331768144297239e-10,  3.471869612656589e-12, -4.802346200790290e-14,  6.242352582026582e-16, -7.690535737162990e-18,  9.039220866442399e-20, -1.018772914871032e-21,
  2.458695780515861e-02, -1.288083976131215e-03,  4.226810618201002e-05, -1.073785406504121e-06,  2.299840210017281e-08, -4.341176371392192e-10,  7.418954296871665e-12,
 -1.168672046858195e-13,  1.718629982684629e-15, -2.381853238384432e-17,  3.133617766925790e-19, -3.935585189324434e-21,  1.709926662698162e-02, -1.128708462722124e-03,
  4.461772076868449e-05, -1.336169173908924e-06,  3.323867634671765e-08, -7.206692342019557e-10,  1.402264212967354e-11, -2.496802301481764e-13,  4.124799212719105e-15,
 -6.387735673953760e-17,  9.346498106123792e-19, -1.300018835713602e-20,  1.144617072371725e-02, -9.291242986964848e-04,  4.365425959752909e-05, -1.524920665461257e-06,
  4.366762423027522e-08, -1.078966616617600e-09,  2.373251133077669e-11, -4.744765901572503e-13,  8.750896982913655e-15, -1.505362559756772e-16,  2.435929382065989e-18,
 -3.732079619405613e-20,  7.394108040249177e-03, -7.231550082366547e-04,  3.988545651141985e-05, -1.609459042267735e-06,  5.262142166811346e-08, -1.471056377060552e-09,
  3.633819857955464e-11, -8.108230950588250e-13,  1.660071842375250e-14, -3.155288321212708e-16,  5.617909160444703e-18, -9.434705593247263e-20,  4.623008902934859e-03,
 -5.353106461244981e-04,  3.426374414488260e-05, -1.582766428198848e-06,  5.863412553643151e-08, -1.842096464908290e-09,  5.079270366136470e-11, -1.257826225739629e-12,
  2.843880010243669e-14, -5.942971321121718e-16,  1.158816106103911e-17, -2.123664992829682e-19,  2.806631622851683e-03, -3.789583262530475e-04,  2.785218200283684e-05,
 -1.460414178339797e-06,  6.085997567986650e-08, -2.135153178693882e-09,  6.533974162165671e-11, -1.786310078936313e-12,  4.438091964932493e-14, -1.014969183662867e-15,
  2.157873058698739e-17, -4.297207444734314e-19,  1.660397751199916e-03, -2.579276691194596e-04,  2.155423881403017e-05, -1.272657627573244e-06,  5.925352214026553e-08,
 -2.307344692755264e-09,  7.793536638370786e-11, -2.340334350239834e-12,  6.359445356656080e-14, -1.584578850447356e-15,  3.657823915284981e-17, -7.883656956670468e-19,
  9.609047193386376e-04, -1.696681846441743e-04,  1.597424830316403e-05, -1.054062098936127e-06,  5.447093462092550e-08, -2.340595118550125e-09,  8.679942538227690e-11,
 -2.849040208159713e-12,  8.428678752992528e-14, -2.278382825255322e-15,  5.687262529986750e-17, -1.321491374328472e-18,  5.462457073450202e-04, -1.084353306424063e-04,
  1.140356721688647e-05, -8.348479712874921e-07,  4.758294599854399e-08, -2.243421858926699e-09,  9.087022791615968e-11, -3.244617303394294e-12,  1.040405958728719e-13,
 -3.038186247075400e-15,  8.168176703975672e-17, -2.038389464753762e-18,  3.063674211160026e-04, -6.768531522071581e-05,  7.886507623668103e-06, -6.361355963145099e-07,
  3.974358075088802e-08, -2.044620930393827e-09,  8.999797777133492e-11, -3.479239665250922e-12,  1.203878828271799e-13, -3.782060789843497e-15,  1.090826231818775e-16,
 -2.912579663413462e-18,  1.703103142308209e-04, -4.148330255858087e-05,  5.314027473650086e-06, -4.690985593798568e-07,  3.193321274130962e-08, -1.782782951425962e-09,
  8.484725588633309e-11, -3.534762716176641e-12,  1.314026177098870e-13, -4.422578791707419e-15,  1.363015510042864e-16, -3.879189453918090e-18,  9.428493243408023e-05,
 -2.509666682806736e-05,  3.508358757748472e-06, -3.367244595242304e-07,  2.482817947541889e-08, -1.496081443058748e-09,  7.660032322266587e-11, -3.422808505791220e-12,
  1.360973498870528e-13, -4.886826035112523e-15,  1.602942985143725e-16, -4.844167094163979e-18,  5.223121555108755e-05, -1.506654774071618e-05,  2.282056378479716e-06,
 -2.366142834378558e-07,  1.878713143979907e-08, -1.215281390087107e-09,  6.660378138067835e-11, -3.177053403810260e-12,  1.345156424137626e-13, -5.131116898493857e-15,
  1.784067749027106e-16, -5.702823122334090e-18,  2.909115806746856e-05, -9.021925833800350e-06,  1.470314769304792e-06, -1.636528922910761e-07,  1.391116314926530e-08,
 -9.607988164766917e-10,  5.607830108520026e-11, -2.841929061101542e-12,  1.275470540468387e-13, -5.146290267618404e-15,  1.888899687988469e-16, -6.361300406292654e-18,
  1.636418914112251e-05, -5.414832312868377e-06,  9.430517483730757e-07, -1.119770220200763e-07,  1.013120608244890e-08, -7.430434874123127e-10,  4.594987915767557e-11,
 -2.461959802708971e-12,  1.165832747688246e-13, -4.953658461501902e-15,  1.911258860717725e-16, -6.753865690364220e-18,  9.334606317286990e-06, -3.271687540068229e-06,
  6.048590099895509e-07, -7.614171564409109e-08,  7.289718459364770e-09, -5.646190621194234e-10,  3.680162103375509e-11, -2.074371269620927e-12,  1.031534803219267e-13,
 -4.594867084083270e-15,  1.855493389674978e-16, -6.851351174400814e-18,  5.417477765032837e-06, -1.997160784200309e-06,  3.893662168354049e-07, -5.164171531899044e-08,
  5.201049838484128e-09, -4.230625753961625e-10,  2.891020322694727e-11, -1.705660332292855e-12,  8.863926511531063e-14, -4.119982181787115e-15,  1.733545287705773e-16,
 -6.659941494542325e-18,  3.205405977094627e-06, -1.234537651410722e-06,  2.521577552548491e-07, -3.501734808937992e-08,  3.688070901343652e-09, -3.132734240219982e-10,
  2.232315614682068e-11, -1.371414528345533e-12,  7.411053713694198e-14, -3.577298860971889e-15,  1.561179278483409e-16, -6.212770099987231e-18,  1.933491037760243e-06,
 -7.729199334109222e-07,  1.643259793756235e-07, -2.374491784274139e-08,  2.599614108536887e-09, -2.292703798858062e-10,  1.694223589335402e-11, -1.078090929887971e-12,
  6.027431869779668e-14, -3.006659916911717e-15,  1.354526773379226e-16, -5.558282391508286e-18,  1.184743879667449e-06, -4.884763561686404e-07,  1.074027368453627e-07,
 -1.604742175261591e-08,  1.815238759226988e-09, -1.652545639131894e-10,  1.259295136679418e-11, -8.255331283753956e-13,  4.750216762868116e-14, -2.436460434628682e-15,
  1.127618367635258e-16, -4.749034722450214e-18,  7.299507706503412e-07, -3.085133825192166e-07,  6.970329505125739e-08, -1.070104641346433e-08,  1.243039936852182e-09,
 -1.161220984390346e-10,  9.073165292793711e-12, -6.093871032454096e-13,  3.589735631753506e-14, -1.883519512047052e-15,  8.910787457921746e-17, -3.833273918560351e-18,
  4.411943513964329e-07, -1.900084763999883e-07,  4.383036487000515e-08, -6.870281936868839e-09,  8.144759908324540e-10, -7.760953063835663e-11,  6.181734328770997e-12,
 -4.229969135929230e-13,  2.537130826137813e-14, -1.354680220541463e-15,  6.518173022512000e-17, -2.850149178046360e-18,  2.451310494970002e-07, -1.069444056270220e-07,
  2.502671638067611e-08, -3.979800765393281e-09,  4.785235287790906e-10, -4.622928694298457e-11,  3.731770514276538e-12, -2.586821769465486e-13,  1.571160755542537e-14,
 -8.491615699211574e-16,  4.134158270046247e-17, -1.828350032241705e-18,  9.757999122579301e-08, -4.287756561343991e-08,  1.011452159969274e-08, -1.621378478110621e-09,
  1.964914095256763e-10, -1.912874178097457e-11,  1.555667628861617e-12, -1.086182529656842e-13,  6.643450646086343e-15, -3.614967684161635e-16,  1.771531266232309e-17,
 -7.884425873693243e-19,  9.043458376891890e-02, -3.462748917950536e-04,  1.398352075010600e-06, -5.875007794397782e-09,  2.532502998981078e-11, -1.107752115772362e-13,
  4.877954546180263e-16, -2.151829804509438e-18,  9.479960193176550e-21, -4.164495994827608e-23,  1.822451162421413e-25, -7.942869645804758e-28,  8.558711969013713e-02,
 -4.685731393103296e-04,  3.048905278258154e-06, -1.994003578295802e-08,  1.264010471127104e-10, -7.760177278265481e-13,  4.636156964713240e-15, -2.707248480347877e-17,
  1.550367124466385e-19, -8.729116844197767e-22,  4.841417372781191e-24, -2.649083987913127e-26,  7.667906191753160e-02, -6.721230583761951e-04,  6.427887430904374e-06,
 -5.638821377937597e-08,  4.611792928966580e-10, -3.578643482219770e-12,  2.663440782657672e-14, -1.914875675612815e-16,  1.336664096022238e-18, -9.093998931075045e-21,
  6.048382864236215e-23, -3.941839314392505e-25,  6.507019682531150e-02, -8.913564999518043e-04,  1.144005612688320e-05, -1.278973042113006e-07,  1.303208829535486e-09,
 -1.239314755727288e-11,  1.115592282140650e-13, -9.596808321701864e-16,  7.943756218190807e-18, -6.359745443196631e-20,  4.944268865990593e-22, -3.744280762857754e-24,
  5.234689032986566e-02, -1.061023972631813e-03,  1.753997438859582e-05, -2.441451640513244e-07,  3.033846875005490e-09, -3.464120086947501e-11,  3.699138700362721e-13,
 -3.738284491313978e-15,  3.605718565117690e-17, -3.340473757902918e-19,  2.987052864287523e-21, -2.587905787573986e-23,  3.996657750154011e-02, -1.137824767275894e-03,
  2.368891143083954e-05, -4.034914488767742e-07,  6.016123222554509e-09, -8.125001120437225e-11,  1.014918885787171e-12, -1.189090222407007e-14,  1.319759265398460e-16,
 -1.397932520839981e-18,  1.421233800793681e-20, -1.393010946005926e-22,  2.900186208476748e-02, -1.110367135360776e-03,  2.862988961396441e-05, -5.881365758971311e-07,
  1.038619534989496e-08, -1.639634717877573e-10,  2.369758642049573e-12, -3.185900158170495e-14,  4.029328267592206e-16, -4.834454852330459e-18,  5.538328154196604e-20,
 -6.088281871324484e-22,  2.003733826548689e-02, -9.958273685844495e-04,  3.133255658153902e-05, -7.666056064618775e-07,  1.586058917017817e-08, -2.898290617933510e-10,
  4.803178824249695e-12, -7.347383452902559e-14,  1.050468494051387e-15, -1.416811937756736e-17,  1.815606644021788e-19, -2.222828788061740e-21,  1.320822333740957e-02,
 -8.278493127519910e-04,  3.135229019012855e-05, -9.035053993357076e-07,  2.169337608851509e-08, -4.549951853087555e-10,  8.579415807641221e-12, -1.482525366662116e-13,
  2.379833746366911e-15, -3.584922466711135e-17,  5.107143803244332e-19, -6.922162179395538e-21,  8.327082273030374e-03, -6.426681051952597e-04,  2.892433234276723e-05,
 -9.719319663379194e-07,  2.685248440528914e-08, -6.415741467011633e-10,  1.367037128897984e-11, -2.651552203683249e-13,  4.750524939290365e-15, -7.947236580848039e-17,
  1.251848230046903e-18, -1.868680623435021e-20,  5.034940850867682e-03, -4.689748728966269e-04,  2.478744311736797e-05, -9.622600072725199e-07,  3.035327192456195e-08,
 -8.204730400610047e-10,  1.963238066368890e-11, -4.249786111670087e-13,  8.452077118858237e-15, -1.562300863252950e-16,  2.707866138167845e-18, -4.431041147738368e-20,
  2.928997506449372e-03, -3.236473985060785e-04,  1.986942762836332e-05, -8.834715688176117e-07,  3.158761220033799e-08, -9.598379660914917e-10,  2.564327754003259e-11,
 -6.162130206532735e-13,  1.353704129706442e-14, -2.751788456545509e-16,  5.224777030203527e-18, -9.332246806331900e-20,  1.645139883670766e-03, -2.124527551069716e-04,
  1.499621041900985e-05, -7.575748867558057e-07,  3.049228922719713e-08, -1.035328329365716e-09,  3.071552003923308e-11, -8.152758239177168e-13,  1.969095926374351e-14,
 -4.382669154160750e-16,  9.077545729786364e-18, -1.762755342973699e-19,  8.956767727334257e-04, -1.334071476601280e-04,  1.072482383967027e-05, -6.108792340535370e-07,
  2.750001841451678e-08, -1.037365229282874e-09,  3.399838253056822e-11, -9.920135981500453e-13,  2.622491984410804e-14, -6.364219805821657e-16,  1.432268126951035e-17,
 -3.012323818986013e-19,  4.747226998112562e-04, -8.059076654794807e-05,  7.313806917958681e-06, -4.663115644037143e-07,  2.333206241247945e-08, -9.724210962563722e-10,
  3.503036096577608e-11, -1.118422678574770e-12,  3.222273446963945e-14, -8.491585043921382e-16,  2.068449683774711e-17, -4.694380414019840e-19,  2.460999757802949e-04,
 -4.710684981540836e-05,  4.785991149015639e-06, -3.391968609321193e-07,  1.875002279440567e-08, -8.587375551287519e-10,  3.383609232008963e-11, -1.176720937053915e-12,
  3.679179836334874e-14, -1.048676144369159e-15,  2.754436650697380e-17, -6.721306079146954e-19,  1.254202649373805e-04, -2.680031534572063e-05,  3.024316676630967e-06,
 -2.366688893657211e-07,  1.436821675791714e-08, -7.193085837980259e-10,  3.085019886547951e-11, -1.163409191106963e-12,  3.931033352681135e-14, -1.207094060646410e-15,
  3.405928567945529e-17, -8.903983590640484e-19,  6.317628713128955e-05, -1.493090368877131e-05,  1.857350052824151e-06, -1.594449777055872e-07,  1.056981825347193e-08,
 -5.753768007752824e-10,  2.673133551989850e-11, -1.088245212716758e-12,  3.957030761475226e-14, -1.303830359143387e-15,  3.937114595413826e-17, -1.098718141076281e-18,
  3.163269783344734e-05, -8.196305382795165e-06,  1.115796642413779e-06, -1.044081096323480e-07,  7.514411732824346e-09, -4.424623968586569e-10,  2.215978717931083e-11,
 -9.694792680356702e-13,  3.777474079238945e-14, -1.330212813095705e-15,  4.282291115522833e-17, -1.271016169482016e-18,  1.583664902113492e-05, -4.461403111936805e-06,
  6.599728717008195e-07, -6.689215869432440e-08,  5.197061252865860e-09, -3.292681764409240e-10,  1.769022080793330e-11, -8.279019366106981e-13,  3.441756615314910e-14,
 -1.289977053528817e-15,  4.409943069882163e-17, -1.386896390173045e-18,  7.974730443363799e-06, -2.423150766343122e-06,  3.868264006766851e-07, -4.220396221337755e-08,
  3.519400169849437e-09, -2.386498125548900e-10,  1.368602234922242e-11, -6.819609519322942e-13,  3.011416605519853e-14, -1.196246039955145e-15,  4.325294124167715e-17,
 -1.435763636615831e-18,  4.062869969763448e-06, -1.321335764758494e-06,  2.260828033210736e-07, -2.638666384762257e-08,  2.348134823671431e-09, -1.695000178162467e-10,
  1.032311048981601e-11, -5.450553146651690e-13,  2.544937082395722e-14, -1.066795902458078e-15,  4.062646558763393e-17, -1.417730026242908e-18,  2.105745331366798e-06,
 -7.275683884839106e-07,  1.325292899041095e-07, -1.644335447129266e-08,  1.552423045718148e-09, -1.186364840240171e-10,  7.633434734805666e-12, -4.249591067112162e-13,
  2.088134717722388e-14, -9.195111131037068e-16,  3.672296857646079e-17, -1.341631748385330e-18,  1.115652211187624e-06, -4.065894359304163e-07,  7.831718300802617e-08,
 -1.026497026496397e-08,  1.022056201507445e-09, -8.222368815333077e-11,  5.559461265985286e-12, -3.246668340436656e-13,  1.670714642739707e-14, -7.692387286325549e-16,
  3.207315639962989e-17, -1.221432322984290e-18,  6.064151561892744e-07, -2.314826376210871e-07,  4.683448334280790e-08, -6.443463742320860e-09,  6.725146413581663e-10,
 -5.662786069239913e-11,  4.001337259253262e-12, -2.438353404727843e-13,  1.307424066211399e-14, -6.263613483606107e-16,  2.713779806598067e-17, -1.072456270194307e-18,
  3.386896557831150e-07, -1.344979437774741e-07,  2.839160743493023e-08, -4.073733950542788e-09,  4.429511152625372e-10, -3.880785370588649e-11,  2.849503431344474e-12,
 -1.802108561798963e-13,  1.001571696028719e-14, -4.967655650781336e-16,  2.225673843411651e-17, -9.084737160639100e-19,  1.939708347753926e-07, -7.960393916489875e-08,
  1.741443981144905e-08, -2.588927666885451e-09,  2.914245489768906e-10, -2.640533765595932e-11,  2.003006083248640e-12, -1.307301229706739e-13,  7.490469810440717e-15,
 -3.826265443616823e-16,  1.763847479681415e-17, -7.400347832462445e-19,  1.129150245203496e-07, -4.757951298711103e-08,  1.071420406114740e-08, -1.639456631041305e-09,
  1.898281069483986e-10, -1.767806777499480e-11,  1.377108213566992e-12, -9.222243464315038e-14,  5.417309154190545e-15, -2.834728473962770e-16,  1.337575875200397e-17,
 -5.739517655285500e-19,  6.526333764012899e-08, -2.805759996684291e-08,  6.459668324149139e-09, -1.010573925225255e-09,  1.195772361346210e-10, -1.137327276391089e-11,
  9.042861805694389e-13, -6.177077368616197e-14,  3.698824082869154e-15, -1.971771418160886e-16,  9.472569702211781e-18, -4.135764881572561e-19,  3.513143070570639e-08,
 -1.531365765994879e-08,  3.580179820807398e-09, -5.687753643103912e-10,  6.832327749039827e-11, -6.594453363978601e-12,  5.318435683903123e-13, -3.683445259783016e-14,
  2.235312791740832e-15, -1.207115868280324e-16,  5.872152586938585e-18, -2.594970739632453e-19,  1.373764188706966e-08, -6.034209316999781e-09,  1.422832788853532e-09,
 -2.279863094509723e-10,  2.761756738678578e-11, -2.687501493320320e-12,  2.184756488738946e-13, -1.524812995049707e-14,  9.322635496935956e-16, -5.070890959002358e-17,
  2.484088785260151e-18, -1.105174285463737e-19,  8.907142084224914e-02, -3.353633515059206e-04,  1.330212078638703e-06, -5.486915149091764e-09,  2.322188777832992e-11,
 -9.975819256193638e-14,  4.315755084216102e-16, -1.871117197823088e-18,  8.103959271475861e-21, -3.500807154098976e-23,  1.506782945762832e-25, -6.460162252250732e-28,
  8.376014120545522e-02, -4.451057792262990e-04,  2.821266080096755e-06, -1.803598432008598e-08,  1.119347486325464e-10, -6.733134573790591e-13,  3.943113476649798e-15,
 -2.257889583676012e-17,  1.268342225090835e-19, -7.006783207373912e-22,  3.813934084581164e-24, -2.048542496749677e-26,  7.408930057353338e-02, -6.232863750243613e-04,
  5.793247896931952e-06, -4.954893650255200e-08,  3.955881414357267e-10, -2.999210750806877e-12,  2.182550724764269e-14, -1.535174324313971e-16,  1.048952467618007e-18,
 -6.988650120584706e-21,  4.553513127947104e-23, -2.908177814506400e-25,  6.167856826238467e-02, -8.056385845413963e-04,  1.002266449707574e-05, -1.088920385000240e-07,
  1.080083485281361e-09, -1.001144082535124e-11,  8.792823390032529e-14, -7.385960701543301e-16,  5.973835748664473e-18, -4.675858267348446e-20,  3.555763535338981e-22,
 -2.635114059392974e-24,  4.836597831639760e-02, -9.316476273925361e-04,  1.488008915516419e-05, -2.006972158613108e-07,  2.421953275405102e-09, -2.689928803173582e-11,
  2.797400163145353e-13, -2.755861594095251e-15,  2.593349212826795e-17, -2.345646003049951e-19,  2.049012400656805e-21, -1.735123650569334e-23,  3.576579321667759e-02,
 -9.661601105811412e-04,  1.937493401984538e-05, -3.190151996743642e-07,  4.610017390863354e-09, -6.045293175821885e-11,  7.342511510341159e-13, -8.374120637096613e-15,
  9.056068594074948e-17, -9.354090055287508e-19,  9.280170408670488e-21, -8.881604438061429e-23,  2.497745668650296e-02, -9.069640828824290e-04,  2.247034960202115e-05,
 -4.453804440657973e-07,  7.610311135009071e-09, -1.164836145341259e-10,  1.634826017448292e-12, -2.136964930880826e-14,  2.630593481669465e-16, -3.074799186131336e-18,
  3.434302562564793e-20, -3.683417553592774e-22,  1.650264465191030e-02, -7.780529671043973e-04,  2.348314837559402e-05, -5.535821946993793e-07,  1.106793178440552e-08,
 -1.958670202993941e-10,  3.148828087616309e-12, -4.678932085866127e-14,  6.505622978549188e-16, -8.541574741674957e-18,  1.066453881135108e-19, -1.273082207678331e-21,
  1.033729847191413e-02, -6.151239873060559e-04,  2.232521774688383e-05, -6.192935911418935e-07,  1.435617903754143e-08, -2.913615726382805e-10,  5.325492537588120e-12,
 -8.933193686559894e-14,  1.393742504060358e-15, -2.042695058196613e-17,  2.833940350138522e-19, -3.743723107576492e-21,  6.154489956660176e-03, -4.514930675567326e-04,
  1.946707112268359e-05, -6.293638958538163e-07,  1.677921949805493e-08, -3.877335835915574e-10,  8.004738564070037e-12, -1.506586692830165e-13,  2.622483518087764e-15,
 -4.267189896082484e-17,  6.544149687328115e-19, -9.519027250648767e-21,  3.492707553924018e-03, -3.097065754859832e-04,  1.568578948629486e-05, -5.858385557428175e-07,
  1.783007683331830e-08, -4.660601671073767e-10,  1.080350346456079e-11, -2.268969481466394e-13,  4.383863961960620e-15, -7.880993990867636e-17,  1.329844600323332e-18,
 -2.120466499811124e-20,  1.895623022424334e-03, -1.997744019756456e-04,  1.176086482003828e-05, -5.032951918867793e-07,  1.736648149953253e-08, -5.103852101285845e-10,
  1.321149937665766e-11, -3.080646722213299e-13,  6.575552416924233e-15, -1.300221355357936e-16,  2.403840223585869e-18, -4.184687012529374e-20,  9.876131039977475e-04,
 -1.219001520852678e-04,  8.260511105238961e-06, -4.019429426189776e-07,  1.562256871813598e-08, -5.132898968078856e-10,  1.476098370040315e-11, -3.803442110648614e-13,
  8.929215272990173e-15, -1.933988384428316e-16,  3.902069370743789e-18, -7.388164127377387e-20,  4.960125987341011e-04, -7.078030916179638e-05,  5.471003702833663e-06,
 -3.004982043063478e-07,  1.307526540236129e-08, -4.776680396956357e-10,  1.518614367505397e-11, -4.304499328318512e-13,  1.106829631159952e-14, -2.615527536558156e-16,
  5.737506994861226e-18, -1.177306938386589e-19,  2.412698747066484e-04, -3.934370014555607e-05,  3.439380693661522e-06, -2.117701498159381e-07,  1.025462918252382e-08,
 -4.143664990958468e-10,  1.449489383886598e-11, -4.499962099358437e-13,  1.262184853555864e-14, -3.241737815663181e-16,  7.703511514671382e-18, -1.707157461664631e-19,
  1.142518442662879e-04, -2.106623219796764e-05,  2.066097620271530e-06, -1.416631410781318e-07,  7.590352547185969e-09, -3.375161142884016e-10,  1.293056298250608e-11,
 -4.377952342940729e-13,  1.334158195419577e-14, -3.710278421637120e-16,  9.517355233698004e-18, -2.270073406855938e-19,  5.296987967640427e-05, -1.093586107742192e-05,
  1.194139216321478e-06, -9.059141253803997e-08,  5.340704186663550e-09, -2.600218256408985e-10,  1.085996784621610e-11, -3.992968475012722e-13,  1.316829056688129e-14,
 -3.950455732885297e-16,  1.089966767422680e-17, -2.788694105514790e-19,  2.419128509278311e-05, -5.541203768846618e-06,  6.687395883627504e-07, -5.578105062605366e-08,
  3.598258669947454e-09, -1.908552948560409e-10,  8.650103928513414e-12, -3.439131540944853e-13,  1.222483595139637e-14, -3.941306583520607e-16,  1.165481341268221e-17,
 -3.187626619771110e-19,  1.095459286730283e-05, -2.759911973655438e-06,  3.655208481279151e-07, -3.331607689026064e-08,  2.338579927699329e-09, -1.344554007506158e-10,
  6.582288124747112e-12, -2.817635493338294e-13,  1.075161037654492e-14, -3.710898848207394e-16,  1.171800279239936e-17, -3.414038943841493e-19,  4.952644829909224e-06,
 -1.361094106328258e-06,  1.964500327005621e-07, -1.944646513678283e-08,  1.477139899943313e-09, -9.159031365034132e-11,  4.820325057488244e-12, -2.211781526034183e-13,
  9.022206412179196e-15, -3.320532528810281e-16,  1.115458270037462e-17, -3.449460530286471e-19,  2.251549170084953e-06, -6.695966605479058e-07,  1.046045963864729e-07,
 -1.117688099673334e-08,  9.135824497824418e-10, -6.077471010027196e-11,  3.421939073182551e-12, -1.675388890370535e-13,  7.274347576519685e-15, -2.843128996193607e-16,
  1.012073139334952e-17, -3.309487791527012e-19,  1.036710161477080e-06, -3.310580769589031e-07,  5.559844189139882e-08, -6.372785015427418e-09,  5.573443812041926e-10,
 -3.956710343903818e-11,  2.371562256482928e-12, -1.233114045799430e-13,  5.673369502691809e-15, -2.344733495431325e-16,  8.808487802185381e-18, -3.033854691797716e-19,
  4.868692474574673e-07, -1.656896842783984e-07,  2.971149592928739e-08, -3.630517344249908e-09,  3.377494738632035e-10, -2.544832284260995e-11,  1.615326969506641e-12,
 -8.876040772275734e-14,  4.307073645232404e-15, -1.873873382733292e-16,  7.397361965044669e-18, -2.672535103356841e-19,  2.347207551248610e-07, -8.450202444776412e-08,
  1.606956252020212e-08, -2.079974588843666e-09,  2.046032970491454e-10, -1.626930970850183e-11,  1.087761652100013e-12, -6.284276156275816e-14,  3.200477069558249e-15,
 -1.458943841077719e-16,  6.024837425793652e-18, -2.273320962437898e-19,  1.167867144019596e-07, -4.415749290469974e-08,  8.844298587181110e-09, -1.204765231882142e-09,
  1.245391310041392e-10, -1.038974722043713e-11,  7.276137145277933e-13, -4.396015829333217e-14,  2.337685678020666e-15, -1.111054789865120e-16,  4.776981203222938e-18,
 -1.873939938628072e-19,  6.016978772923934e-08, -2.372512515251604e-08,  4.970197654498110e-09, -7.077980790670310e-10,  7.640134739408530e-11, -6.646640444805301e-12,
  4.847299269344271e-13, -3.045567845233401e-14,  1.682019145216900e-15, -8.292062110944822e-17,  3.693439283982852e-18, -1.499125657237829e-19,  3.209048115930945e-08,
 -1.310403650458210e-08,  2.851196283392454e-09, -4.216050406336047e-10,  4.721103107672952e-11, -4.256131785626209e-12,  3.212835270830935e-13, -2.087087577816267e-14,
  1.190437625695045e-15, -6.054472652480466e-17,  2.779291311342253e-18, -1.161359859068556e-19,  1.759058934581494e-08, -7.388203125850790e-09,  1.657810671533754e-09,
 -2.527781816133822e-10,  2.916776617117543e-11, -2.707243153413688e-12,  2.102128637236513e-13, -1.403379984452369e-14,  8.218969075116703e-16, -4.288310293024465e-17,
  2.017801425789746e-18, -8.635078567289259e-20,  9.695080880618309e-09, -4.160206692871610e-09,  9.558098945987770e-10, -1.492203213349010e-10,  1.762086647935064e-11,
 -1.672664424739985e-12,  1.327398039509806e-13, -9.050605185666624e-15,  5.409840055022482e-16, -2.878919766136177e-17,  1.380760084855905e-18, -6.018799216440368e-20,
  5.045735525032927e-09, -2.197380756032885e-09,  5.131959903103835e-10, -8.144601847923345e-11,  9.773649079099161e-12, -9.424038866004503e-13,  7.593195421309589e-14,
 -5.253994841855962e-15,  3.185522616214221e-16, -1.718740184580551e-17,  8.353895539761827e-19, -3.688644515706974e-20,  1.935820340404437e-09, -8.499705139218607e-10,
  2.003302441843854e-10, -3.208545300815353e-11,  3.885021497552861e-12, -3.778927324883543e-13,  3.070707282613575e-14, -2.142256320645742e-15,  1.309233059950370e-16,
 -7.118522253194429e-18,  3.485811018490584e-19, -1.550254049133895e-20,  8.775084254572227e-02, -3.249788585129825e-04,  1.266534333210079e-06, -5.130780781325724e-09,
  2.132620500764785e-11, -9.000089607652017e-14,  3.826333193495539e-16, -1.630845267118936e-18,  6.945646038889193e-21, -2.951254935591789e-23,  1.249626857234715e-25,
 -5.271721339837548e-28,  8.202352928546497e-02, -4.233719226463219e-04,  2.615151704863720e-06, -1.634782366342251e-08,  9.936589285450688e-11, -5.858289070984676e-13,
  3.364134194917571e-15, -1.889602317621406e-17,  1.041518464602406e-19, -5.647124774021285e-22,  3.017604395344701e-24, -1.591505152614106e-26,  7.168522744043364e-02,
 -5.792155217098729e-04,  5.234745997047839e-06, -4.367233560206640e-08,  3.405125308110995e-10, -2.523407916900642e-12,  1.796149578389455e-14, -1.236484531557784e-16,
  8.272825863594591e-19, -5.399350741973736e-21,  3.447500500691751e-23, -2.158389265071593e-25,  5.860849634798396e-02, -7.304048095638184e-04,  8.813393589159498e-06,
 -9.310453664952261e-08,  8.993876879740812e-10, -8.129192668850068e-12,  6.968909733067049e-14, -5.718328532941074e-16,  4.520879409643279e-18, -3.460817390903286e-20,
  2.575175558755598e-22, -1.868166647987204e-24,  4.486309520312579e-02, -8.216202499138711e-04,  1.268759033951743e-05, -1.659097118827576e-07,  1.945308306202863e-09,
 -2.102499350809195e-11,  2.130293190264020e-13, -2.046661413754978e-15,  1.879737954934029e-17, -1.660503022067467e-19,  1.417482587576831e-21, -1.173616523706527e-23,
  3.218856304277956e-02, -8.253054843348344e-04,  1.595231136848674e-05, -2.540441318692961e-07,  3.559755639828925e-09, -4.534587247196231e-11,  5.357542256374549e-13,
 -5.950332101782620e-15,  6.272237693099436e-17, -6.319845493259707e-19,  6.120405107504352e-21, -5.721362401906747e-23,  2.167798225423511e-02, -7.466736923925410e-04,
  1.778588310964504e-05, -3.403085792270951e-07,  5.629044905842261e-09, -8.357030031660045e-11,  1.139406900316311e-12, -1.448645582272183e-14,  1.736298743861528e-16,
 -1.977776668712084e-18,  2.154386673258232e-20, -2.255066306799982e-22,  1.372797957762954e-02, -6.140223403712577e-04,  1.778558931036120e-05, -4.041344187305864e-07,
  7.811243031503982e-09, -1.339211185703633e-10,  2.089242905197079e-12, -3.016632793529736e-14,  4.080276659632927e-16, -5.216555216131703e-18,  6.347468091507559e-20,
 -7.390199918918440e-22,  8.191920668875335e-03, -4.627450910007915e-04,  1.609996109961524e-05, -4.300358972211336e-07,  9.627884991095103e-09, -1.891340712237276e-10,
  3.351955390681032e-12, -5.459648130955638e-14,  8.280974661004321e-16, -1.181117678929923e-17,  1.596120376612960e-19, -2.055503579437834e-21,  4.617902871371296e-03,
 -3.219300427343484e-04,  1.329987268859511e-05, -4.137757934211138e-07,  1.064757477984171e-08, -2.380154888519055e-10,  4.761998042029121e-12, -8.698583450720392e-14,
  1.471378768280488e-15, -2.329073591117893e-17,  3.478082640270280e-19, -4.930599184149774e-21,  2.466346391439449e-03, -2.081172858223414e-04,  1.010016636662131e-05,
 -3.629443438786667e-07,  1.065911770877644e-08, -2.694565375058802e-10,  6.051661780306309e-12, -1.233264901181544e-13,  2.315058167222792e-15, -4.048092201599851e-17,
  6.650679646950447e-19, -1.033434584213327e-20,  1.252219837335646e-03, -1.257988246176665e-04,  7.100363325930986e-06, -2.924198398964452e-07,  9.737534448074708e-09,
 -2.767828337041304e-10,  6.941850990648170e-12, -1.570735567301217e-13,  3.257590959426590e-15, -6.265851520345714e-17,  1.127994993186712e-18, -1.913834879324212e-20,
  6.067415604220444e-04, -7.153100570150908e-05,  4.651885724753106e-06, -2.179728196430983e-07,  8.179825077930432e-09, -2.600291876722380e-10,  7.247732905789483e-12,
 -1.812752578677043e-13,  4.136302052962248e-15, -8.717384246487660e-17,  1.713183551276177e-18, -3.162483545736311e-20,  2.817935502072488e-04, -3.849488435511170e-05,
  2.859457443773964e-06, -1.513935876409978e-07,  6.365294507980861e-09, -2.251450219939826e-10,  6.941966789428225e-12, -1.911112385212754e-13,  4.778864075970253e-15,
 -1.099445125660649e-16,  2.350433406295952e-18, -4.704688971552375e-20,  1.260702512619237e-04, -1.972975567401717e-05,  1.660335098667188e-06, -9.867599612618855e-08,
  4.622314729584556e-09, -1.810194945172220e-10,  6.146810710008646e-12, -1.854990799575857e-13,  5.063932243212655e-15, -1.267220807072511e-16,  2.936999128250261e-18,
 -6.353746867952103e-20,  5.463279065093831e-05, -9.693829299797223e-06,  9.170739874888536e-07, -6.079412189099656e-08,  3.155611037150597e-09, -1.361687007748949e-10,
  5.070019116314741e-12, -1.670490588736779e-13,  4.959875625296267e-15, -1.345300631922106e-16,  3.368955768011493e-18, -7.851907302913254e-20,  2.307389710729670e-05,
 -4.597589888004424e-06,  4.853682286386136e-07, -3.566972631381492e-08,  2.040686061678122e-09, -9.656698288245667e-11,  3.925423053629630e-12, -1.406455779566764e-13,
  4.524926976774377e-15, -1.325611866145584e-16,  3.574923873886751e-18, -8.947742747837049e-20,  9.561954304764989e-06, -2.120391787017547e-06,  2.480304414044958e-07,
 -2.008574572915273e-08,  1.259852134301981e-09, -6.506733385786849e-11,  2.875116726339452e-12, -1.115703290596121e-13,  3.874840295156340e-15, -1.221710411911803e-16,
  3.536095795321284e-18, -9.473962770682882e-20,  3.916666360265619e-06, -9.583724869392076e-07,  1.233588337220358e-07, -1.094255953354976e-08,  7.485206183466276e-10,
 -4.199046603257955e-11,  2.007970666782337e-12, -8.404610000792499e-14,  3.138811209617201e-15, -1.061215588562620e-16,  3.285158431960630e-18, -9.390320564074062e-20,
  1.598262019846518e-06, -4.280042479269959e-07,  6.021184163647545e-08, -5.815815120503670e-09,  4.315414075647059e-10, -2.616647420133764e-11,  1.348019429440347e-12,
 -6.060131467453204e-14,  2.424029683255708e-15, -8.755006516667943e-17,  2.888283040102423e-18, -8.777662072212978e-20,  6.551574256167231e-07, -1.904891551335182e-07,
  2.909213733752157e-08, -3.041435469761533e-09,  2.434705978188852e-10, -1.587661422792922e-11,  8.770312814708873e-13, -4.216115580443290e-14,  1.798735043130556e-15,
 -6.912675551065286e-17,  2.421130917721122e-18, -7.794658498302589e-20,  2.721009706438006e-07, -8.523176166003909e-08,  1.403619998441249e-08, -1.578627585192751e-09,
  1.355716013370757e-10, -9.458105916158779e-12,  5.574992178071786e-13, -2.852655858713523e-14,  1.292414346218908e-15, -5.262953322219525e-17,  1.949204711688712e-18,
 -6.622339650172010e-20,  1.154850726094786e-07, -3.867468177986444e-08,  6.821265865172012e-09, -8.201907020076500e-10,  7.512925094568886e-11, -5.577128090838788e-12,
  3.489872850938395e-13, -1.891533512713324e-14,  9.058512126122696e-16, -3.891486420552450e-17,  1.517613416345374e-18, -5.419049708488288e-20,  5.050011800154649e-08,
 -1.794539490818458e-08,  3.366573567426275e-09, -4.300056905835974e-10,  4.176016707558964e-11, -3.279934035710645e-12,  2.167133037272535e-13, -1.237838831247842e-14,
  6.235510454031009e-16, -2.812715796602680e-17,  1.149832469628840e-18, -4.296588372039501e-20,  2.291735282382228e-08, -8.577380957290718e-09,  1.699574480989114e-09,
 -2.290820599788984e-10,  2.343987401487628e-11, -1.936323320462214e-12,  1.343258580871254e-13, -8.041948162866535e-15,  4.239183548876276e-16, -1.997880044829880e-17,
  8.520440295612723e-19, -3.316472609429437e-20,  1.085016926402688e-08, -4.245821595453038e-09,  8.822472629401353e-10, -1.246347799392651e-10,  1.334901689864794e-11,
 -1.152623745574741e-12,  8.345312008365869e-14, -5.206980906395427e-15,  2.856517909446044e-16, -1.399153690590248e-17,  6.193474537645343e-19, -2.498889665349340e-20,
  5.368321640789733e-09, -2.180405637186088e-09,  4.716694467361520e-10, -6.934585520740584e-11,  7.722041508112255e-12, -6.924033690567072e-13,  5.199621925905569e-14,
 -3.360823767629227e-15,  1.907715007466917e-16, -9.657437871825602e-18,  4.413388620242424e-19, -1.836253959585068e-20,  2.761159669842650e-09, -1.155669861756724e-09,
  2.583286923222485e-10, -3.924016604178757e-11,  4.511183086625032e-12, -4.172169286077143e-13,  3.228455262500313e-14, -2.148150413485856e-15,  1.254042971614870e-16,
 -6.522842485716605e-18,  3.060079771701003e-19, -1.305790930188762e-20,  1.446792869904389e-09, -6.195708123407336e-10,  1.420294360087344e-10, -2.212423669656113e-11,
  2.606895275232641e-12, -2.469388490271724e-13,  1.955671488174527e-14, -1.330810982724372e-15,  7.939560838990253e-17, -4.217385428188428e-18,  2.019114715545936e-19,
 -8.786381286034914e-21,  7.263509106790806e-10, -3.160072969645986e-10,  7.372189649460984e-11, -1.168701249598976e-11,  1.400941600585947e-12, -1.349405087576355e-13,
  1.086138344612449e-14, -7.507908574339723e-16,  4.547702830684434e-17, -2.451413741586276e-18,  1.190427542799293e-19, -5.251718815139149e-21,  2.730484263828849e-10,
 -1.198395799428648e-10,  2.823204298864819e-11, -4.519609690530914e-12,  5.469973503803417e-13, -5.318178230774513e-14,  4.319558465801382e-15, -3.012195642967153e-16,
  1.840109865008987e-17, -1.000082617226277e-18,  4.895231365978965e-20, -2.176206636724754e-21,  8.647080973455486e-02, -3.150871942320237e-04,  1.206954453806061e-06,
 -4.803477776760564e-09,  1.961444608214649e-11, -8.134149327038721e-14,  3.399282034494673e-16, -1.424662676677725e-18,  5.967849932148695e-21, -2.494830964396887e-23,
  1.039449703142435e-25, -4.315807615282355e-28,  8.037067860490571e-02, -4.032092398457878e-04,  2.428144033919490e-06, -1.484748851898494e-08,  8.841572034358553e-11,
 -5.110801215101686e-13,  2.878807836049426e-15, -1.586644528465384e-17,  8.583621965161153e-20, -4.569168734898813e-22,  2.397601595272271e-24, -1.241991567580800e-26,
  6.944892807675405e-02, -5.393448954775002e-04,  4.741774501291551e-06, -3.860558410908415e-08,  2.940894281061693e-10, -2.131056973234227e-12,  1.484253558480435e-14,
 -1.000368013569469e-16,  6.555995502727690e-19, -4.192932592163276e-21,  2.624382147036165e-23, -1.611151630386341e-25,  5.582114524847219e-02, -6.641338370071815e-04,
  7.777395269661855e-06, -7.992929369995942e-08,  7.523121486948833e-10, -6.633526585179529e-12,  5.552912666652552e-14, -4.452612317009086e-16,  3.442173265772916e-18,
 -2.578018680332744e-20,  1.877651174140664e-22, -1.333843148251553e-24,  4.176771353624124e-02, -7.275843147158375e-04,  1.087039629352791e-05, -1.378893161323132e-07,
  1.571622839319045e-09, -1.653715263567761e-11,  1.633178989764751e-13, -1.530782739164708e-15,  1.372691780280031e-17, -1.184701843607658e-19,  9.886193270443208e-22,
 -8.005715148653962e-24,  2.912455219969583e-02, -7.089775105501013e-04,  1.321770756446137e-05, -2.036975779675743e-07,  2.769012580399985e-09, -3.427972589695084e-11,
  3.941346105030615e-13, -4.264508082426900e-15,  4.383180256223043e-17, -4.309683678462935e-19,  4.075501597495813e-21, -3.722375148509183e-23,  1.895200361704510e-02,
 -6.193083544749185e-04,  1.419187356882804e-05, -2.622567253195206e-07,  4.201227098774052e-09, -6.052442806319865e-11,  8.019507369331102e-13, -9.920820565319555e-15,
  1.158152075157225e-16, -1.286025370107013e-18,  1.366640890854018e-20, -1.396497864584170e-22,  1.152849724648935e-02, -4.891986051161696e-04,  1.360556732938528e-05,
 -2.981202371690761e-07,  5.572769680504178e-09, -9.259720602995762e-11,  1.402307019446613e-12, -1.968139177578924e-14,  2.590494768362368e-16, -3.225884958657710e-18,
  3.826465173015690e-20, -4.346178156857823e-22,  6.569207904554834e-03, -3.522298044702851e-04,  1.175183681840868e-05, -3.023507560326276e-07,  6.539803706435892e-09,
 -1.243900076104377e-10,  2.138176134144739e-12, -3.382596168545108e-14,  4.989090172638134e-16, -6.926761306713777e-18,  9.119854885344122e-20, -1.145180058762468e-21,
  3.515191621433288e-03, -2.328213531966739e-04,  9.217702660231520e-06, -2.760288690697774e-07,  6.857388718386131e-09, -1.483225706001443e-10,  2.876459609083717e-12,
 -5.100602573249405e-14,  8.385727728372692e-16, -1.291544893927125e-17,  1.878394302681635e-19, -2.595594245581637e-21,  1.771507390123889e-03, -1.422015796985268e-04,
  6.612950730511599e-06, -2.286592019781657e-07,  6.480834914436268e-09, -1.584659569840132e-10,  3.448607478551916e-12, -6.820237723752188e-14,  1.244042788182214e-15,
 -2.116108185808049e-17,  3.385282348574271e-19, -5.126722874289016e-21,  8.436569419164947e-04, -8.075200690525512e-05,  4.369145985734242e-06, -1.731597128028246e-07,
  5.564727592100426e-09, -1.529850697069135e-10,  3.717768439088257e-12, -8.163271826479347e-14,  1.645040004192980e-15, -3.078028642816735e-17,  5.395735364263383e-19,
 -8.922722934835513e-21,  3.811697950379100e-04, -4.289513545147468e-05,  2.676330108298728e-06, -1.207388697950898e-07,  4.374086612967921e-09, -1.345218140659543e-10,
  3.633857355652246e-12, -8.821677368534328e-14,  1.956304929387068e-15, -4.011615089742377e-17,  7.678722876530928e-19, -1.381881647903340e-20,  1.641169055187876e-04,
 -2.144608021556770e-05,  1.530216324537629e-06, -7.806941843757834e-08,  3.170889618655069e-09, -1.085672655543070e-10,  3.245904621422972e-12, -8.677481598866439e-14,
  2.109810255913513e-15, -4.724948067002007e-17,  9.842797752951106e-19, -1.921568299706886e-20,  6.768572702242638e-05, -1.015692222846567e-05,  8.223209040336760e-07,
 -4.715012881936060e-08,  2.135762818575720e-09, -8.103488981714982e-11,  2.670288461099450e-12, -7.831172289254225e-14,  2.080135059442715e-15, -5.070584400802240e-17,
  1.145901560287046e-18, -2.419440304621971e-20,  2.689501229856461e-05, -4.587811601151000e-06,  4.183502040053616e-07, -2.679701892335283e-08,  1.346790768967253e-09,
 -5.637098525428277e-11,  2.038994785699874e-12, -6.535276756422522e-14,  1.889837202454646e-15, -4.997742695117038e-17,  1.221446023539539e-18, -2.780825838140321e-20,
  1.036364357884323e-05, -1.990872061595429e-06,  2.030281119799401e-07, -1.444339116782203e-08,  8.013760356698044e-10, -3.683690000175009e-11,  1.456644663578175e-12,
 -5.083411211815936e-14,  1.594759825798939e-15, -4.560370826488105e-17,  1.201591041743785e-18, -2.940974713766058e-20,  3.901035864056470e-06, -8.365334289345895e-07,
  9.475512690143864e-08, -7.443649363617100e-09,  4.536569488531775e-10, -2.279895022990131e-11,  9.815602779137607e-13, -3.715592235978928e-14,  1.260116441307912e-15,
 -3.883482849975431e-17,  1.099656805413814e-18, -2.884752491436291e-20,  1.445982301195076e-06, -3.432376777659184e-07,  4.289612179902824e-08, -3.699898289002229e-09,
  2.464410516282349e-10, -1.347910024549192e-11,  6.291850350687077e-13, -2.573430772415350e-14,  9.400621279258087e-16, -3.111565419391760e-17,  9.437843759157110e-19,
 -2.645326567774446e-20,  5.324348718589120e-07, -1.387749219857175e-07,  1.900944920015728e-08, -1.789929603326302e-09,  1.296312955358655e-10, -7.680433831237012e-12,
  3.870275588968105e-13, -1.703523234092698e-14,  6.677381172256377e-16, -2.365263824875741e-17,  7.658515889582194e-19, -2.286021764207966e-20,  1.965974871658862e-07,
 -5.582197286439524e-08,  8.325956386161676e-09, -8.508693774581570e-10,  6.664916473679746e-11, -4.256876210807054e-12,  2.305295765564072e-13, -1.087346007389671e-14,
  4.555174353604555e-16, -1.720210063406323e-17,  5.924402750206045e-19, -1.876720050140505e-20,  7.351955822433601e-08, -2.256513510390895e-08,  3.640381289723647e-09,
 -4.013677688017848e-10,  3.381855301272315e-11, -2.316687399373631e-12,  1.341899408145675e-13, -6.752307352169618e-15,  3.010412471065690e-16, -1.207119939881521e-17,
  4.404867654822627e-19, -1.475346258212093e-20,  2.812910574958997e-08, -9.260967287909350e-09,  1.605109708089164e-09, -1.897518155409958e-10,  1.710001626039402e-11,
 -1.249695007195868e-12,  7.703499509477329e-14, -4.115684153982581e-15,  1.943943669958415e-16, -8.240919773429645e-18,  3.173039502560957e-19, -1.119205216760112e-20,
  1.112211371796350e-08, -3.897879022426135e-09,  7.207840007478088e-10, -9.077900658078369e-11,  8.697363552874620e-12, -6.742719058297462e-13,  4.399725200213737e-14,
 -2.483075491638266e-15,  1.236484122125010e-16, -5.516034528061136e-18,  2.231020904691428e-19, -8.251699111008209e-21,  4.586803620831044e-09, -1.698151210091690e-09,
  3.326478979567818e-10, -4.433605670672078e-11,  4.487517728903050e-12, -3.668516576297282e-13,  2.519472315821479e-14, -1.493889024642447e-15,  7.802048168305954e-17,
 -3.644345197130059e-18,  1.540928303723530e-19, -5.948593255557512e-21,  1.987744570211147e-09, -7.715117465077038e-10,  1.589243741612464e-10, -2.225959435645700e-11,
  2.364400401311597e-12, -2.025268456033330e-13,  1.455095650756269e-14, -9.011897746300434e-16,  4.908751528662041e-17, -2.387923913655757e-18,  1.050079253614656e-19,
 -4.209983883929909e-21,  9.087364883254451e-10, -3.669713256190982e-10,  7.889123101444931e-11, -1.152758842740152e-11,  1.276010649777984e-12, -1.137561329517560e-13,
  8.495172454581084e-15, -5.461610649916183e-16,  3.084252432514874e-17, -1.553614172579976e-18,  7.066072227067928e-20, -2.926473590465010e-21,  4.369318834724732e-10,
 -1.821897340408555e-10,  4.055853227157088e-11, -6.135831077033459e-12,  7.026080240189079e-13, -6.473229880686716e-14,  4.990554282781442e-15, -3.308807651148235e-16,
  1.924989708639040e-17, -9.979674159053705e-19,  4.666892994162141e-20, -1.985353618573815e-21,  2.169577514087439e-10, -9.270732876014948e-11,  2.120118601037987e-11,
 -3.294675582401988e-12,  3.873071628947712e-13, -3.660496838629747e-14,  2.892663355596908e-15, -1.964275505256631e-16,  1.169495290072619e-17, -6.200006923534613e-19,
  2.962692207217066e-20, -1.286894802803007e-21,  1.048164804272758e-10, -4.555325942979532e-11,  1.061468065085059e-11, -1.680743232182831e-12,  2.012406015373981e-13,
 -1.936195463781833e-14,  1.556746310181777e-15, -1.074959795897300e-16,  6.504596345236201e-18, -3.502789232092253e-19,  1.699351050430774e-20, -7.489945356821366e-22,
  3.855298246394855e-11, -1.691339622912028e-11,  3.982553816879779e-12, -6.372453995391187e-13,  7.708675339769916e-14, -7.491176061384411e-15,  6.081678097014050e-16,
 -4.239052117411372e-17,  2.588423955655962e-18, -1.406170956587542e-19,  6.880032227133586e-21, -3.057294106145609e-22,  8.522941453706302e-02, -3.056569112305179e-04,
  1.151143421633641e-06, -4.502231196889839e-09,  1.806607595779333e-11, -7.364112538517947e-14,  3.025817381997218e-16, -1.247294938969827e-18,  5.140194537837276e-21,
 -2.114639613732656e-23,  8.671217468865918e-26, -3.544316635718930e-28,  7.879559649820438e-02, -3.844734711278233e-04,  2.258136528361353e-06, -1.351100150026191e-08,
  7.885058863444166e-11, -4.470240379250864e-13,  2.470655187336638e-15, -1.336537839441172e-17,  7.098954268526408e-20, -3.711006390271190e-22,  1.912746327715565e-24,
 -9.734497994245456e-27,  6.736459167500836e-02, -5.031868932015081e-04,  4.305393771103943e-06, -3.422267912606229e-08,  2.548152990198510e-10, -1.806210395470394e-12,
  1.231388959885852e-14, -8.128322904185506e-17,  5.219585984753588e-19, -3.272235210727023e-21,  2.008322347070059e-23, -1.209361379021957e-25,  5.328324976070128e-02,
 -6.055562847326790e-04,  6.886311072976606e-06, -6.888527904135579e-08,  6.320196232108849e-10, -5.438796852503629e-12,  4.447408965390492e-14, -3.486189468159953e-16,
  2.636243840331902e-18, -1.932336813903569e-20,  1.378012462140646e-22, -9.588701831389481e-25,  3.902139505159697e-02, -6.468361718639160e-04,  9.356337852625142e-06,
 -1.151900565362534e-07,  1.276845014497492e-09, -1.308591357796814e-11,  1.260151508341380e-13, -1.152767194921872e-15,  1.009640061590321e-17, -8.516206120765629e-20,
  6.949467352351936e-22, -5.505826988355510e-24,  2.648564304038250e-02, -6.123091190120863e-04,  1.101809759858339e-05, -1.644021010327006e-07,  2.169100614918267e-09,
 -2.610815950287101e-11,  2.922396727690466e-13, -3.081610561823608e-15,  3.089537158105171e-17, -2.965307418278946e-19,  2.739102858877393e-21, -2.445128426674332e-23,
  1.668340866638528e-02, -5.173045980659230e-04,  1.141131093596947e-05, -2.037626812430066e-07,  3.162701955360247e-09, -4.423150207780152e-11,  5.697809108355795e-13,
 -6.860927197848357e-15,  7.803790441652790e-17, -8.450094471446132e-19,  8.763112931454824e-21, -8.744222381688065e-23,  9.768703051453314e-03, -3.932777781716339e-04,
  1.050744537550505e-05, -2.221146584344741e-07,  4.017163293191420e-09, -6.471566406341088e-11,  9.517313622101730e-13, -1.298825811732831e-14,  1.664077213677090e-16,
 -2.019015206755551e-18,  2.335293499456260e-20, -2.588328752748166e-22,  5.327622440335352e-03, -2.711215542619010e-04,  8.677575429752946e-06, -2.151204040755852e-07,
  4.496878795657926e-09, -8.284273058089614e-11,  1.381573951848743e-12, -2.123465613843367e-14,  3.046403475169072e-16, -4.118157667760765e-18,  5.283830328331175e-20,
 -6.470899259056927e-22,  2.712775257165121e-03, -1.706671956917135e-04,  6.476716318320106e-06, -1.867274142312123e-07,  4.479626534220264e-09, -9.377610097276109e-11,
  1.763247173158987e-12, -3.035830454222109e-14,  4.852119298505828e-16, -7.272702914825274e-18,  1.030323790843358e-19, -1.387997133680972e-21,  1.293334489168288e-03,
 -9.872540365384684e-05,  4.399582618438775e-06, -1.463999432947044e-07,  4.005068406118144e-09, -9.473725888969667e-11,  1.998101937194067e-12, -3.835409300496614e-14,
  6.798896333127573e-16, -1.125153104225221e-17,  1.752921593080444e-19, -2.587518705961771e-21,  5.792608255773522e-04, -5.280140480038567e-05,  2.738285258010346e-06,
 -1.044356238641313e-07,  3.239032215582668e-09, -8.613074627831660e-11,  2.028217218792531e-12, -4.321919441154257e-14,  8.463161313071275e-16, -1.540509950948202e-17,
  2.629747354456437e-19, -4.238653906861431e-21,  2.446786975113565e-04, -2.626760206992102e-05,  1.571919181537084e-06, -6.826619847034396e-08,  2.387283896773450e-09,
 -7.102471919623851e-11,  1.859344294629289e-12, -4.381005653938441e-14,  9.441831757945418e-16, -1.883794349104154e-17,  3.511887299767445e-19, -6.161181016387677e-21,
  9.791305257606624e-05, -1.223032911733191e-05,  8.378791394369570e-07, -4.117988033684401e-08,  1.615386610225966e-09, -5.352890008042331e-11,  1.551576377816043e-12,
 -4.027390627182778e-14,  9.519795336832034e-16, -2.075065256824752e-17,  4.211607172103255e-19, -8.018395966121672e-21,  3.731406224744726e-05, -5.364402309432983e-06,
  4.175960135521906e-07, -2.309051180015499e-08,  1.011044571531020e-09, -3.715429262667186e-11,  1.187785570679813e-12, -3.384347069758197e-14,  8.744947367695758e-16,
 -2.076012764530997e-17,  4.573674788003007e-19, -9.422913710702513e-21,  1.362350800947428e-05, -2.232003815572619e-06,  1.960411872664047e-07, -1.212648359570838e-08,
  5.898330919595007e-10, -2.393647700817396e-11,  8.407768071981684e-13, -2.620517361132118e-14,  7.377957400842685e-16, -1.901732318846763e-17,  4.534643438476208e-19,
 -1.008174974919337e-20,  4.797863115920964e-06, -8.876470515419075e-07,  8.737082989118345e-08, -6.012612244105692e-09,  3.233393312703240e-10, -1.442992873493581e-11,
  5.547949199012424e-13, -1.884936724887218e-14,  5.763740721771676e-16, -1.608171805561692e-17,  4.138341943690934e-19, -9.901177036640396e-21,  1.642454175893439e-06,
 -3.402042435036504e-07,  3.728115183940287e-08, -2.838748796228034e-09,  1.679852390294292e-10, -8.209622509476456e-12,  3.441739366878804e-13, -1.270186549246999e-14,
  4.204386792032524e-16, -1.265891689562578e-17,  3.505172245732142e-19, -8.999325379920502e-21,  5.512797065260622e-07, -1.267968515614125e-07,  1.537047459374235e-08,
 -1.287956604003714e-09,  8.346783474754326e-11, -4.447878651629331e-12,  2.025299677177813e-13, -8.089548904012703e-15,  2.888734696744254e-16, -9.355571403872657e-18,
  2.778902201128077e-19, -7.633788968531775e-21,  1.831625080549561e-07, -4.640989581074522e-08,  6.183638730279447e-09, -5.670796236960570e-10,  4.005076702323834e-11,
 -2.316855429437388e-12,  1.141149622430057e-13, -4.914405123900252e-15,  1.886470250035560e-16, -6.549550198088829e-18,  2.080195779384777e-19, -6.095281832046411e-21,
  6.087319770062404e-08, -1.685974478011021e-08,  2.453294745265722e-09, -2.448444328091098e-10,  1.875012249864451e-11, -1.172007282191234e-12,  6.217446534264383e-14,
 -2.875306235092655e-15,  1.181974784555875e-16, -4.383303521292334e-18,  1.483502755292677e-19, -4.621299924646666e-21,  2.046512224379850e-08, -6.147994589370409e-09,
  9.706453960571269e-10, -1.048123621993269e-10,  8.657011356560023e-12, -5.818372252782358e-13,  3.309268938344679e-14, -1.636348826162463e-15,  7.174180528752295e-17,
 -2.830802358008254e-18,  1.017129214807275e-19, -3.356497361394665e-21,  7.042209483264671e-09, -2.277033294711839e-09,  3.874464016682447e-10, -4.499196157306072e-11,
  3.985632269111870e-12, -2.865286064970422e-13,  1.738657004509290e-14, -9.149804605581732e-16,  4.259537289759548e-17, -1.780788103385306e-18,  6.765558542793384e-20,
 -2.355915813496344e-21,  2.510030466690882e-09, -8.667895589428545e-10,  1.578543499274182e-10, -1.958736838064344e-11,  1.849940881877770e-12, -1.414601193156771e-13,
  9.109527198886547e-15, -5.076483365251150e-16,  2.497373342676120e-17, -1.101160761119040e-18,  4.404043276710058e-20, -1.611422743258088e-21,  9.372874556445469e-10,
 -3.429971015534450e-10,  6.637413503529413e-11, -8.741469802513735e-12,  8.746341167754957e-13, -7.071242049696973e-14,  4.804959891296298e-15, -2.820047840565463e-16,
  1.458408643397798e-17, -6.748205079214251e-19,  2.827525215870072e-20, -1.082058851451232e-21,  3.703014670764644e-10, -1.424744593978828e-10,  2.907652796529636e-11,
 -4.035479198636366e-12,  4.248665885518046e-13, -3.608355046726539e-14,  2.571314905005047e-15, -1.579992580259791e-16,  8.541170049450773e-18, -4.124779575461048e-19,
  1.801178036222479e-20, -7.172832571430818e-22,  1.557794787641823e-10, -6.251876582375952e-11,  1.335076379689524e-11, -1.937990835708285e-12,  2.131517626318961e-13,
 -1.888550648428232e-14,  1.401989686596444e-15, -8.962101274856050e-17,  5.033265549736603e-18, -2.521995771597025e-19,  1.141213567929414e-20, -4.703367757432746e-22,
  6.974187397382646e-11, -2.896310975278267e-11,  6.419318154453777e-12, -9.669012563406522e-13,  1.102493900192758e-13, -1.011580435271984e-14,  7.767986194219789e-16,
 -5.130677190476141e-17,  2.973969349506034e-18, -1.536343952666754e-19,  7.160125462967623e-21, -3.036053031964909e-22,  3.270478153522340e-11, -1.394220039034479e-11,
  3.180221133805895e-12, -4.929411141774049e-13,  5.780307786847546e-14, -5.449827424019225e-15,  4.296588346297459e-16, -2.911032973552189e-17,  1.729405967098319e-18,
 -9.149094632043343e-20,  4.363072052158701e-21, -1.891482220585148e-22,  1.516518006429523e-11, -6.583294729808232e-12,  1.532083410428668e-12, -2.422859828655632e-13,
  2.897379814949134e-14, -2.784305345795373e-15,  2.236038658623265e-16, -1.542281175956411e-17,  9.322177362351308e-19, -5.014781862523319e-20,  2.430395829306521e-21,
 -1.070148230963628e-22,  5.449336082421885e-12, -2.389562270834746e-12,  5.623757290876610e-13, -8.993871611017633e-14,  1.087420199416413e-14, -1.056208096466161e-15,
  8.570566082423211e-17, -5.970990027275270e-18,  3.644260732526960e-19, -1.978852644101747e-20,  9.677693353607810e-22, -4.298627730278939e-23,  8.402486981027132e-02,
 -2.966590664109017e-04,  1.098803633866582e-06, -4.224573543666717e-09,  1.666313736214456e-11, -6.678034803830837e-14,  2.698504445363291e-16, -1.094348947094259e-18,
  4.437776509679844e-21, -1.797046677742352e-23,  7.253893822580241e-26, -2.919623465425426e-28,  7.729283537044102e-02, -3.670361187714614e-04,  2.103289230172050e-06,
 -1.231781696698637e-08,  7.047402857021095e-11, -3.919742187476646e-13,  2.126320131664858e-15, -1.129349876490416e-17,  5.890985282950636e-20, -3.025081834631981e-22,
  1.531955534927625e-24, -7.661829630301488e-27,  6.541822383524386e-02, -4.703197666944625e-04,  3.918041769773191e-06, -3.041931189430627e-08,  2.214713861060741e-10,
 -1.536204359255051e-12,  1.025513524051755e-14, -6.632015229316526e-17,  4.174223030250020e-19, -2.565944973890261e-21,  1.544705919958114e-23, -9.126577448414739e-26,
  5.096620256925136e-02, -5.536082862001408e-04,  6.116951188280642e-06, -5.958833357625200e-08,  5.331734706408494e-10, -4.479628693622080e-12,  3.579635067331528e-14,
 -2.744028999416752e-16,  2.030434935499314e-18, -1.457045584304259e-20,  1.017706267902782e-22, -6.938708285595965e-25,  3.657546269123649e-02, -5.771861648382290e-04,
  8.088501400471250e-06, -9.670031071698121e-08,  1.042933226139224e-09, -1.041502327466493e-11,  9.783563163701547e-14, -8.738109753478414e-16,  7.477598444579787e-18,
 -6.166408298590135e-20,  4.922249538888133e-22, -3.816538445601697e-24,  2.420098513053719e-02, -5.315029901569688e-04,  9.237433498488176e-06, -1.335201624761714e-07,
  1.710623963775290e-09, -2.002726761599794e-11,  2.183302751965117e-13, -2.244552655499780e-15,  2.195809989173890e-17, -2.057962434506186e-19,  1.857454564102142e-21,
 -1.621058437232279e-23,  1.478241683141526e-02, -4.349971738827653e-04,  9.242825126557194e-06, -1.595540727968020e-07,  2.400606088165989e-09, -3.260571040966804e-11,
  4.085047326199234e-13, -4.789657367099193e-15,  5.309825854921816e-17, -5.608521900589083e-19,  5.677670157708211e-21, -5.533961735654217e-23,  8.348252708671488e-03,
 -3.188779278126853e-04,  8.188711378482983e-06, -1.670671176145052e-07,  2.924654815711456e-09, -4.569766215142862e-11,  6.528508079211694e-13, -8.666021483810824e-15,
  1.081121958726467e-16, -1.278408412595483e-18,  1.442268846910696e-20, -1.560297787153652e-22,  4.367202673650609e-03, -2.109187242709190e-04,  6.478482305605700e-06,
 -1.548075643942953e-07,  3.128602540475549e-09, -5.584189254930011e-11,  9.038096107602914e-13, -1.350017892420847e-14,  1.884395376083523e-16, -2.480883869222098e-18,
  3.102744968108271e-20, -3.706730867136417e-22,  2.121092110059990e-03, -1.267268406763985e-04,  4.610867292852610e-06, -1.280185773310951e-07,  2.966567046479612e-09,
 -6.012021588444034e-11,  1.096276323645056e-12, -1.833106959819326e-14,  2.848869953244846e-16, -4.156452549788112e-18,  5.737012816661570e-20, -7.536059976184840e-22,
  9.590672028707716e-04, -6.959528253017542e-05,  2.972282488723506e-06, -9.519654372010931e-08,  2.514158124729228e-09, -5.754219183830095e-11,  1.176379365135923e-12,
 -2.192055120344847e-14,  3.776909708919658e-16, -6.081960634176170e-18,  9.228838003588479e-20, -1.328000442810156e-21,  4.050212416806950e-04, -3.514259149678045e-05,
  1.746721075140418e-06, -6.410953673310148e-08,  1.919047654513483e-09, -4.936287159215262e-11,  1.126459629147280e-12, -2.329666272372647e-14,  4.433301713218184e-16,
 -7.851024156695813e-18,  1.305196745489059e-19, -2.050606997920571e-21,  1.603627340892475e-04, -1.641373652998676e-05,  9.418741164253745e-07, -3.937184089242122e-08,
  1.328971668669204e-09, -3.824785867149181e-11,  9.703414826454294e-13, -2.219035538435304e-14,  4.647717171133504e-16, -9.022090193257161e-18,  1.638122444989280e-19,
 -2.801588925226711e-21,  5.979567254092495e-05, -7.134443605021411e-06,  4.691067366425819e-07, -2.220435902010172e-08,  8.410814209686956e-10, -2.696983166117777e-11,
  7.578017701695228e-13, -1.909632017424954e-14,  4.387956669875806e-16, -9.308373825209605e-18,  1.840528150570304e-19, -3.416981306822664e-21,  2.110786291313308e-05,
 -2.904782096288664e-06,  2.173050703856771e-07, -1.158265837423780e-08,  4.900848646051560e-10, -1.743856134541189e-11,  5.407264591428745e-13, -1.496536337672302e-14,
  3.760956582519729e-16, -8.693474304072694e-18,  1.866783041447171e-19, -3.752212757515758e-21,  7.096731743153157e-06, -1.115639739177468e-06,  9.431913529343502e-08,
 -5.631116115086950e-09,  2.649552351841990e-10, -1.042094396172748e-11,  3.553306797148005e-13, -1.076602024809534e-14,  2.950258652600933e-16, -7.409883115306361e-18,
  1.723369226987067e-19, -3.740660865705067e-21,  2.288485791895786e-06, -4.073301563249518e-07,  3.866674668608988e-08, -2.572344643844452e-09,  1.339992740122751e-10,
 -5.802885488722850e-12,  2.168238270481682e-13, -7.168795216983985e-15,  2.135725974511516e-16, -5.812062134471221e-18,  1.460168194601086e-19, -3.413788561271433e-21,
  7.134992356951905e-07, -1.425912204507497e-07,  1.510352779492949e-08, -1.113866694050023e-09,  6.395606638208112e-11, -3.037590471490888e-12,  1.239336741856312e-13,
 -4.456842970327106e-15,  1.439126823896660e-16, -4.231279917975250e-18,  1.145162033866375e-19, -2.876272954678991e-21,  2.170454521353670e-07, -4.831453260976733e-08,
  5.675218283007493e-09, -4.615960572782712e-10,  2.908281493139003e-11, -1.508854389727002e-12,  6.697566734498374e-14, -2.610876871218660e-15,  9.108737529875331e-17,
 -2.884852240642122e-18,  8.387054169645153e-20, -2.256941372435398e-21,  6.508392959600360e-08, -1.601228150839639e-08,  2.073044452551908e-09, -1.849853316678878e-10,
  1.273001322676506e-11, -7.184394216212912e-13,  3.456257754659397e-14, -1.455329559668375e-15,  5.467424658991867e-17, -1.859381543446369e-18,  5.789455919179046e-20,
 -1.664336294304988e-21,  1.945871856831171e-08, -5.250705261601558e-09,  7.446014320846835e-10, -7.250308257911999e-11,  5.423338973663848e-12, -3.314859693468984e-13,
  1.721309002170158e-14, -7.799158460206079e-16,  3.143851735466605e-17, -1.144170790377301e-18,  3.803063093384107e-20, -1.164325618814248e-21,  5.873367906451361e-09,
 -1.725012882883629e-09,  2.662451619889116e-10, -2.813003794001051e-11,  2.275514939533823e-12, -1.499240395998502e-13,  8.366412930405570e-15, -4.062316387609620e-16,
  1.750205739040218e-17, -6.791268743123408e-19,  2.401193668661553e-20, -7.802335356354538e-22,  1.813783739838885e-09, -5.753669052487086e-10,  9.601688813345596e-11,
 -1.094231609325584e-11,  9.520199402784096e-13, -6.727074285270817e-14,  4.015142065856701e-15, -2.079830953007435e-16,  9.536508841622122e-18, -3.929287026184124e-19,
  1.472065084848294e-20, -5.057638234297289e-22,  5.810520212748934e-10, -1.975302613988232e-10,  3.539545268556954e-11, -4.323486099347757e-12,  4.022030023146864e-13,
 -3.031240176054207e-14,  1.925049738966582e-15, -1.058563489703853e-16,  5.141377176599437e-18, -2.239285649899665e-19,  8.850771436151071e-21, -3.201958539019910e-22,
  1.957532723746515e-10, -7.075076498412354e-11,  1.351438944040273e-11, -1.757392974145135e-12,  1.736980003326094e-13, -1.387895985250151e-14,  9.325008625740126e-16,
 -5.413915504092931e-17,  2.770877865066974e-18, -1.269367578789440e-19,  5.267868516024271e-21, -1.997453191049683e-22,  7.021765499240590e-11, -2.676395772743407e-11,
  5.407949679493628e-12, -7.432612518495234e-13,  7.751688087553237e-14, -6.523861647558279e-15,  4.608470375347019e-16, -2.808097511852444e-17,  1.505820919489568e-18,
 -7.215924092807702e-20,  3.127611534038305e-21, -1.236637016727595e-22,  2.706532462341504e-11, -1.078980795487022e-11,  2.287681285674863e-12, -3.297393982208680e-13,
  3.601906688377270e-14, -3.170325327763854e-15,  2.338624139488161e-16, -1.485840617452801e-17,  8.295861192527262e-19, -4.133360971917078e-20,  1.860230937822949e-21,
 -7.626840562674404e-23,  1.123562184503302e-11, -4.645708776253532e-12,  1.024790609317365e-12, -1.536342993665026e-13,  1.743814116681941e-14, -1.592980615013560e-15,
  1.218076806852995e-16, -8.012465753846916e-18,  4.626155461064106e-19, -2.380832316534154e-20,  1.105552200635873e-21, -4.671422574828132e-23,  4.957713738696436e-12,
 -2.108154946977337e-12,  4.795372123801320e-13, -7.412433538933096e-14,  8.668590824634131e-15, -8.151730140622818e-16,  6.410614616144647e-17, -4.332824211989688e-18,
  2.568071206158826e-19, -1.355536476801975e-20,  6.450358143796270e-22, -2.790541303131660e-23,  2.200295787336387e-12, -9.539947979820642e-13,  2.217159125674120e-13,
 -3.501505793812624e-14,  4.181738713420120e-15, -4.013374543288652e-16,  3.219074465322560e-17, -2.217643626599812e-18,  1.338872782083441e-19, -7.194233155516795e-21,
  3.482861113289062e-22, -1.531957176742254e-23,  7.711201779617011e-13, -3.379773174052871e-13,  7.949884242479063e-14, -1.270701915100093e-14,  1.535536300395278e-15,
 -1.490673216529945e-16,  1.208976563566859e-17, -8.418514552257502e-19,  5.135522514300788e-20, -2.787275966327407e-21,  1.362494663860888e-22, -6.049156025682930e-24,
  8.285549960281534e-02, -2.880669837672353e-04,  1.049665449560387e-06, -3.968306453540510e-09,  1.538989299214684e-11, -6.065616996849572e-14,  2.411033934478898e-16,
 -9.621552596345644e-19,  3.840116119648226e-21, -1.531013617269876e-23,  6.084690448794435e-26, -2.412190486081301e-28,  7.585743366751835e-02, -3.507824695140036e-04,
  1.961990927088979e-06, -1.125027946992255e-08,  6.312030706713152e-11, -3.445337887011385e-13,  1.834937257163654e-15, -9.571430226008189e-18,  4.904595069201447e-20,
 -2.474697946179562e-22,  1.231653971663130e-24, -6.055052507216579e-27,  6.359740364128498e-02, -4.403775704672407e-04,  3.573299040869813e-06, -2.710879498248301e-08,
  1.930655707867988e-10, -1.310936562224985e-12,  8.572096093431745e-15, -5.432880015602004e-17,  3.352666366497271e-19, -2.021416215742072e-21,  1.193961377512490e-23,
 -6.923326137053898e-26,  4.884530805836775e-02, -5.073944117441199e-04,  5.450263654597770e-06, -5.173010636182480e-08,  4.515856609515939e-10, -3.705831590875991e-12,
  2.894912287950227e-14, -2.170919183472746e-16,  1.572371892803670e-18, -1.105008612465015e-20,  7.561854622024824e-23, -5.053167695364043e-25,  3.438916544132336e-02,
 -5.168511320946897e-04,  7.021736990650143e-06, -8.156006237354779e-08,  8.562630158832300e-10, -8.335452648838878e-12,  7.641046516511454e-14, -6.665519846977296e-16,
  5.575058382095572e-18, -4.496288869111200e-20,  3.511959842236866e-22, -2.665772045970118e-24,  2.221324352573052e-02, -4.635758925771182e-04,  7.787060551598202e-06,
 -1.090898617266897e-07,  1.357770297414932e-09, -1.546847567013140e-11,  1.643009492607770e-13, -1.647379733178935e-15,  1.573112238707255e-17, -1.440167036841075e-19,
  1.270495359825390e-21, -1.084355981308352e-23,  1.317904781858944e-02, -3.681065164704781e-04,  7.538723427572826e-06, -1.258709664792626e-07,  1.836588555112047e-09,
 -2.423611779645182e-11,  2.954339467919729e-13, -3.374088166403612e-15,  3.646972614806118e-17, -3.758824703429142e-19,  3.715616377880583e-21, -3.538553291672338e-23,
  7.192101267597986e-03, -2.606562646196507e-04,  6.437060410529220e-06, -1.268089242270566e-07,  2.149584671320030e-09, -3.258894531808315e-11,  4.524400236714759e-13,
 -5.843621022487590e-15,  7.100787962095042e-17, -8.185772982225512e-19,  9.010178047156106e-21, -9.516861512838200e-23,  3.616516517483165e-03, -1.657484633413352e-04,
  4.887775616054182e-06, -1.126233000287509e-07,  2.201260780713138e-09, -3.807981338985302e-11,  5.983381765694133e-13, -8.688208464738091e-15,  1.180251850740504e-16,
 -1.513708951061453e-18,  1.845795405083299e-20, -2.151588604994486e-22,  1.679258618960964e-03, -9.526077971956849e-05,  3.323950344890499e-06, -8.890079997776540e-08,
  1.990484333803415e-09, -3.906256769915466e-11,  6.909589074762694e-13, -1.122355286880579e-14,  1.696471274247582e-16, -2.409776926824531e-18,  3.241256526927187e-20,
 -4.152392324681671e-22,  7.218691775367067e-04, -4.978104810776245e-05,  2.037758086924349e-06, -6.282923982286272e-08,  1.602213722050701e-09, -3.548806989685144e-11,
  7.033799965528089e-13, -1.272572452165675e-14,  2.131571770116957e-16, -3.340488097277997e-18,  4.937764537954378e-20, -6.927419150751905e-22,  2.881748851929899e-04,
 -2.379058247804827e-05,  1.133270670038611e-06, -4.002989586890136e-08,  1.156598829653189e-09, -2.878150566670203e-11,  6.365510709421374e-13, -1.277825890657691e-14,
  2.363333892391981e-16, -4.072213649504579e-18,  6.593507303215149e-20, -1.009829443505843e-21,  1.072283989808489e-04, -1.045796579683272e-05,  5.753364392365413e-07,
 -2.314708481213680e-08,  7.541281591975623e-10, -2.099523772045080e-11,  5.161893076424621e-13, -1.145723960382881e-14,  2.332138845722226e-16, -4.404710179446713e-18,
  7.789192962809726e-20, -1.298634451606863e-21,  3.735211257224764e-05, -4.253997870968830e-06,  2.683633494769329e-07, -1.223082521552566e-08,  4.472970435713482e-10,
 -1.387754769753478e-11,  3.779550300948677e-13, -9.245717344980445e-15,  2.065038080277478e-16, -4.262991810806041e-18,  8.211148502068527e-20, -1.486388788591279e-21,
  1.224359234950313e-05, -1.611551057954650e-06,  1.157983460903296e-07, -5.947620333012484e-09,  2.431126585171061e-10, -8.374195505287157e-12,  2.518005392870306e-13,
 -6.767940462734444e-15,  1.653939803311546e-16, -3.721897545231133e-18,  7.788615875341330e-20, -1.527071359016083e-21,  3.799426439159626e-06, -5.725824669031803e-07,
  4.656464260082635e-08, -2.681877212238741e-09,  1.220165056183976e-10, -4.649418933820926e-12,  1.538467067363813e-13, -4.529992350843793e-15,  1.207918151973044e-16,
 -2.955375581115552e-18,  6.702607038838683e-20, -1.419990567967568e-21,  1.124120809660674e-06, -1.922943058875586e-07,  1.759077147025570e-08, -1.130563463484310e-09,
  5.701762136344911e-11, -2.394839877934601e-12,  8.692480125217871e-14, -2.795644509462829e-15,  8.111637614265951e-17, -2.152258663262163e-18,  5.277126402372423e-20,
 -1.205207494727132e-21,  3.197133976078308e-07, -6.157777520102012e-08,  6.298814031316148e-09, -4.495759883973017e-10,  2.503043036191820e-11, -1.154655594521677e-12,
  4.582273604864683e-14, -1.604899010937509e-15,  5.053006871629333e-17, -1.450128184154284e-18,  3.834407142552993e-20, -9.417721014853305e-22,  8.824222104938787e-08,
 -1.898791162652176e-08,  2.159141735725429e-09, -1.703158892502625e-10,  1.042448292463358e-11, -5.261881094963566e-13,  2.275443576960756e-14, -8.651882336938516e-16,
  2.947319804884435e-17, -9.123570431100751e-19,  2.594861505569754e-20, -6.836895036953440e-22,  2.389263700281716e-08, -5.700549635311393e-09,  7.163723812219221e-10,
 -6.214300700955380e-11,  4.163349028001738e-12, -2.290559262966296e-13,  1.075519489642348e-14, -4.424955768768914e-16,  1.625916876659257e-17, -5.413127328744302e-19,
  1.651378253156079e-20, -4.655080287135587e-22,  6.424519553348325e-09, -1.686902815621765e-09,  2.328810202867259e-10, -2.210216205780186e-11,  1.613441402004408e-12,
 -9.635287375217521e-14,  4.893678465078348e-15, -2.170835430996624e-16,  8.575014213396029e-18, -3.060680488493839e-19,  9.985022021994713e-21, -3.002615249742818e-22,
  1.739104524214792e-09, -4.987703345020373e-10,  7.517679514437986e-11, -7.763900388466768e-12,  6.145349724756082e-13, -3.965765430248079e-14,  2.169635162597049e-15,
 -1.033680489604231e-16,  4.373337506931801e-18, -1.667660109462441e-19,  5.798501712005368e-21, -1.854110199492131e-22,  4.810361368860492e-10, -1.495385468460552e-10,
  2.444928374009596e-11, -2.731796338672061e-12,  2.332224350043574e-13, -1.618436002618717e-14,  9.494157793626279e-16, -4.837150186012233e-17,  2.183010164134339e-18,
 -8.858580574180118e-20,  3.270564965312456e-21, -1.108012444553268e-22,  1.381165703955140e-10, -4.617585096797853e-11,  8.133634504148761e-12, -9.771219123608286e-13,
  8.945897934130517e-14, -6.639785415406415e-15,  4.155384239436267e-16, -2.253135685797073e-17,  1.079695495682685e-18, -4.642137034027709e-20,  1.812163974623189e-21,
 -6.478259157009184e-23,  4.183007104574235e-11, -1.491916560829036e-11,  2.810622353373983e-12, -3.605922597920260e-13,  3.518035158223670e-14, -2.776176449235751e-15,
  1.843089034600464e-16, -1.057859630894130e-17,  5.354946493702496e-19, -2.427376132899140e-20,  9.971873972944993e-22, -3.744466680477390e-23,  1.356684992516905e-11,
 -5.119254564641038e-12,  1.023445857499818e-12, -1.392008421381964e-13,  1.437210706189609e-14, -1.197902258459541e-15,  8.383659929955690e-17, -5.063039605155890e-18,
  2.691842234291739e-19, -1.279359527363461e-20,  5.501455202409781e-22, -2.158794318730318e-23,  4.770106289028604e-12, -1.888015204294557e-12,  3.972309345082227e-13,
 -5.682320048724103e-14,  6.161686063137683e-15, -5.385188256662011e-16,  3.945538016632541e-17, -2.490477494385302e-18,  1.381808500774023e-19, -6.843403498169140e-21,
  3.062101140382681e-22, -1.248485947720496e-23,  1.828146948499812e-12, -7.523472000481648e-13,  1.651132685904463e-13, -2.462862834627076e-14,  2.781775426027407e-15,
 -2.529165484707452e-16,  1.925143750409235e-17, -1.260816838408089e-18,  7.248972889117597e-20, -3.715571929393322e-21,  1.718635725287658e-22, -7.234853621675666e-24,
  7.560793557169551e-13, -3.206280416253945e-13,  7.271446313128802e-14, -1.120644266463751e-14,  1.306768038993051e-15, -1.225418661413176e-16,  9.610862227432296e-18,
 -6.478950612613654e-19,  3.830481225575498e-20, -2.017020961340930e-21,  9.575789262138512e-23, -4.133428023024103e-24,  3.201976583502369e-13, -1.386475114983703e-13,
  3.217591891928152e-14, -5.074087970167988e-15,  6.051226193853997e-16, -5.799595645492767e-17,  4.645578834764719e-18, -3.196249357046513e-19,  1.927290579138694e-20,
 -1.034355193895331e-21,  5.001684646070590e-23, -2.197556659008639e-24,  1.092499067364601e-13, -4.785916781595493e-14,  1.125097174165003e-14, -1.797307409024086e-15,
  2.170658503390733e-16, -2.106064226236008e-17,  1.707144961808424e-18, -1.188111289637514e-19,  7.244045973733845e-21, -3.929679236386936e-22,  1.919985902924839e-23,
 -8.520205881761262e-25,  8.171973051433162e-02, -2.798560430288615e-04,  1.003484162753603e-06, -3.731467670292754e-09,  1.423252190159745e-11, -5.517957981481726e-14,
  2.158037923507763e-16, -8.476404271493676e-19,  3.330320612676710e-21, -1.307574990917316e-23,  5.117332204838424e-26, -1.998746323175322e-28,  7.448486418985412e-02,
 -3.356098953738776e-04,  1.832827239888205e-06, -1.029317523632356e-08,  5.664919106774082e-11, -3.035418492755054e-13,  1.587635379970225e-15, -8.135491310192070e-18,
  4.096322192157276e-20, -2.031411967250705e-22,  9.938772819699613e-25, -4.804132232954350e-27,  6.189107747416613e-02, -4.130418089470715e-04,  3.265697423766910e-06,
 -2.421881391551451e-08,  1.687869165575395e-10, -1.122312495248874e-12,  7.190773453441628e-15, -4.467807056000317e-17,  2.704059245424489e-19, -1.599566904360338e-21,
  9.272487359916416e-24, -5.278408029132076e-26,  4.689916942109899e-02, -4.661579137809044e-04,  4.870525623328041e-06, -4.506188811837085e-08,  3.839523515410240e-10,
 -3.078657555818527e-12,  2.351909193124526e-14, -1.725979411161414e-16,  1.224053500729471e-18, -8.427006623757313e-21,  5.651719553569320e-23, -3.702729247106668e-25,
  3.242822301952417e-02, -4.643712682562844e-04,  6.120022345534413e-06, -6.909988842613201e-08,  7.064789101305607e-10, -6.706807641373232e-12,  6.001937508452680e-14,
 -5.115512886034842e-16,  4.183341343481646e-18, -3.300684070633537e-20,  2.523472636848897e-22, -1.875726497579864e-24,  2.047573414291794e-02, -4.061686020400605e-04,
  6.598772457400167e-06, -8.964096237117470e-08,  1.084371615527274e-09, -1.202635042652088e-11,  1.245073147311727e-13, -1.217991689564952e-15,  1.135692502366359e-17,
 -1.015935968537062e-19,  8.762769564731785e-22, -7.316239784185341e-24,  1.181833478419951e-02, -3.133734697004987e-04,  6.189754020815790e-06, -1.000079819460402e-07,
  1.415749908618402e-09, -1.815907060873733e-11,  2.154517723183453e-13, -2.397671287610562e-15,  2.527620912932298e-17, -2.542852180697378e-19,  2.455207506478121e-21,
 -2.285266454745695e-23,  6.243596342386921e-03, -2.147078833649125e-04,  5.101974252504411e-06, -9.709115654014849e-08,  1.594357931320593e-09, -2.346200787858913e-11,
  3.166522375301485e-13, -3.980749873225994e-15,  4.712988541948446e-17, -5.298310858827830e-19,  5.691554411880709e-21, -5.870926286212915e-23,  3.023942594800116e-03,
 -1.315066276288303e-04,  3.724802927477541e-06, -8.279129641774952e-08,  1.565569983031187e-09, -2.625783721429679e-11,  4.006693179906862e-13, -5.657467062662210e-15,
  7.481729279570990e-17, -9.350164639215228e-19,  1.111915088190863e-20, -1.264973367487257e-22,  1.345335085979736e-03, -7.244901388134767e-05,  2.425097102483949e-06,
 -6.249880796713475e-08,  1.352468255802720e-09, -2.570924797151155e-11,  4.412559649740768e-13, -6.964501725997905e-15,  1.024098717943784e-16, -1.416609771833282e-18,
  1.857172971044365e-20, -2.320865677174642e-22,  5.511250590346267e-04, -3.610751733525185e-05,  1.416868181752822e-06, -4.206328573496445e-08,  1.035958798459404e-09,
 -2.221085016235015e-11,  4.268827807017173e-13, -7.500223446689651e-15,  1.221528600711869e-16, -1.863336342416890e-18,  2.683480822111532e-20, -3.671083766913754e-22,
  2.084951944545268e-04, -1.637015929710016e-05,  7.473395737612708e-07, -2.540713876660597e-08,  7.086616204856086e-10, -1.706239616927339e-11,  3.657790513957665e-13,
 -7.128044107400382e-15,  1.281426123636335e-16, -2.148583116796081e-18,  3.388578059680258e-20, -5.059567791333866e-22,  7.309516603040045e-05, -6.789236924102796e-06,
  3.580260418597685e-07, -1.386274772131410e-08,  4.359305990022078e-10, -1.174052319776517e-11,  2.797440931879172e-13, -6.026693727373713e-15,  1.192251985775396e-16,
 -2.190991628851810e-18,  3.773672293523801e-20, -6.133452808615612e-22,  2.384790241003763e-05, -2.590785845865716e-06,  1.567595467299035e-07, -6.877827943495352e-09,
  2.428167840246136e-10, -7.288423007003278e-12,  1.923893516747389e-13, -4.568383944720019e-15,  9.917493339450109e-17, -1.992238545218194e-18,  3.737916718712563e-20,
 -6.597263636292950e-22,  7.277059308471755e-06, -9.154000516563930e-07,  6.314912973784120e-08, -3.124409719195357e-09,  1.233456603645970e-10, -4.112116893581204e-12,
  1.198802959806696e-13, -3.128729866167947e-15,  7.433934438537372e-17, -1.628365475297962e-18,  3.320352010684893e-20, -6.349370090996373e-22,  2.089259323501353e-06,
 -3.015567377924285e-07,  2.357559366147328e-08, -1.309270059591223e-09,  5.757627125329678e-11, -2.124837366176345e-12,  6.821054926371422e-14, -1.951332177160512e-15,
  5.061719118009548e-17, -1.206131584597166e-18,  2.666808570012790e-20, -5.513282632053983e-22,  5.683573959367614e-07, -9.334361562612240e-08,  8.222514163041851e-09,
 -5.102352291873177e-10,  2.490015911113200e-11, -1.013908497216421e-12,  3.573491200741078e-14, -1.117549219960028e-15,  3.156951239628238e-17, -8.164145839818837e-19,
  1.953019476897450e-20, -4.355810480864913e-22,  1.477235357695432e-07, -2.738986951758999e-08,  2.703307777259233e-09, -1.866002820845821e-10,  1.006741370217943e-11,
 -4.508078797300647e-13,  1.739253640835460e-14, -5.929927902313107e-16,  1.819643719796715e-17, -5.094970701607545e-19,  1.315691203070556e-20, -3.158762168192429e-22,
  3.704223621878762e-08, -7.695779289941354e-09,  8.463170513042616e-10, -6.469003080005514e-11,  3.843601070983167e-12, -1.886285414642220e-13,  7.941787880828350e-15,
 -2.943657564027336e-16,  9.786184350527257e-18, -2.959378098754234e-19,  8.230028918145528e-21, -2.122154963018250e-22,  9.062817404439984e-09, -2.094352143014257e-09,
  2.552011072489897e-10, -2.150101183865678e-11,  1.401220124936501e-12, -7.509503055223117e-14,  3.439078546611466e-15, -1.381598189558883e-16,  4.962146987234802e-18,
 -1.616324793478783e-19,  4.828512503974734e-21, -1.333949235461443e-22,  2.191674280223988e-09, -5.592762712755045e-10,  7.508139433387358e-11, -6.938632858626769e-12,
  4.938681098702599e-13, -2.879229254625119e-14,  1.429189238993578e-15, -6.202552304042604e-17,  2.399256272984896e-18, -8.393330457565010e-20,  2.685885882465630e-21,
 -7.928551718005724e-23,  5.316340236986197e-10, -1.487043359958935e-10,  2.186354259595487e-11, -2.204888361447342e-12,  1.706111543986949e-13, -1.077462899079440e-14,
  5.774358283608384e-16, -2.697363976295554e-17,  1.119868234829011e-18, -4.193722935045865e-20,  1.433045100714206e-21, -4.506452519306090e-23,  1.314819628531647e-10,
 -4.000856866851822e-11,  6.401908619982241e-12, -7.006174381360334e-13,  5.863912929459627e-14, -3.992854680294845e-15,  2.300273134346591e-16, -1.151827754883536e-17,
  5.112643217072362e-19, -2.041930353168703e-20,  7.424418244128857e-22, -2.478655476876740e-23,  3.374597224563665e-11, -1.108367286587310e-11,  1.917230000236060e-12,
 -2.263126882244107e-13,  2.037357153716333e-14, -1.487972117592811e-15,  9.169607796231115e-17, -4.899029820301064e-18,  2.314590745959200e-19, -9.817288802587579e-21,
  3.782744080660915e-22, -1.335472533026796e-23,  9.155730551916732e-12, -3.219491065951669e-12,  5.976567205236729e-13, -7.558614256597839e-14,  7.273441532597920e-15,
 -5.664315455761944e-16,  3.713191844670976e-17, -2.105517257940801e-18,  1.053494497800131e-19, -4.722425163051138e-21,  1.919325204189088e-22, -7.133404572578868e-24,
  2.673743263316392e-12, -9.980430400650723e-13,  1.972699513039051e-13, -2.653372966844308e-14,  2.710248108786921e-15, -2.235766706547956e-16,  1.549307444179732e-17,
 -9.268080219351810e-19,  4.882811832377909e-20, -2.300455307494970e-21,  9.809573593447173e-23, -3.818437429667885e-24,  8.536110817166324e-13, -3.352523121856762e-13,
  6.995457539721065e-14, -9.925814875132264e-15,  1.067883469985690e-15, -9.262713372835146e-17,  6.737308611037741e-18, -4.223105670772300e-19,  2.327487921268739e-20,
 -1.145295380942592e-21,  5.093081241130875e-23, -2.064292229342134e-24,  3.006387281902201e-13, -1.230947034755018e-13,  2.686645433006738e-14, -3.985709531548954e-15,
  4.478127847052663e-16, -4.050824206230171e-17,  3.068353595018381e-18, -2.000106344900995e-19,  1.144764867729152e-20, -5.842258476835368e-22,  2.691084311147905e-23,
 -1.128329072491391e-24,  1.160558181648910e-13, -4.907015245412472e-14,  1.109258848507596e-14, -1.704069686745822e-15,  1.980907323163896e-16, -1.852005485562634e-17,
  1.448304620802803e-18, -9.736192817369488e-20,  5.740775212643778e-21, -3.015118435025309e-22,  1.427866227963797e-23, -6.148730951406082e-25,  4.674716296195865e-14,
 -2.021314674676070e-14,  4.683524849440429e-15, -7.374315255577688e-16,  8.781019475302790e-17, -8.403442255143537e-18,  6.721690274947009e-19, -4.618273720693361e-20,
  2.781040358110738e-21, -1.490633647470912e-22,  7.199095822702953e-24, -3.159236598029236e-25,  1.549782097564192e-14, -6.785472183547673e-15,  1.594197257706159e-15,
 -2.545126624570098e-16,  3.071971830659775e-17, -2.978801272984518e-18,  2.413185075517755e-19, -1.678548700026294e-20,  1.022871008052238e-21, -5.545819838406891e-23,
  2.708205729898340e-24, -1.201199361328577e-25,  8.061608385424106e-02, -2.720034910129230e-04,  9.600373443060337e-07, -3.512302502806765e-09,  1.317886120838921e-11,
 -5.027347478421850e-14,  1.934937981453981e-16, -7.482233088710516e-19,  2.894414885063041e-21, -1.119426809956233e-23,  4.314666944380214e-26, -1.660894126988762e-28,
  7.317098872435730e-02, -3.214263895932942e-04,  1.714553622557342e-06, -9.433359467485972e-09,  5.094167309230012e-11, -2.680304950875385e-13,  1.377146146789134e-15,
 -6.934399648100226e-18,  3.431759912457509e-20, -1.673084611787013e-22,  8.048746741490341e-25, -3.826231972161435e-27,  6.028938340660981e-02, -3.880344696208476e-04,
  2.990563727094180e-06, -2.168882488210498e-08,  1.479699589460951e-10, -9.638187330087430e-13,  6.052757698633902e-15, -3.687915271192266e-17,  2.189738810012076e-19,
 -1.271227001758136e-21,  7.234297341116346e-24, -4.043915489359481e-26,  4.510918298194491e-02, -4.292567325363493e-04,  4.364705516855014e-06, -3.938213374991242e-08,
  3.276540703196560e-10, -2.568031550553452e-12,  1.919205412193185e-14, -1.378758396480528e-16,  9.577334476348451e-19, -6.461199051539035e-21,  4.248085265756531e-23,
 -2.729382630006636e-25,  3.066366517227364e-02, -4.185454308558539e-04,  5.354460007899051e-06, -5.879566104579519e-08,  5.856609695424511e-10, -5.424128994953998e-12,
  4.740445056334035e-14, -3.948988191747631e-16,  3.158519714338582e-18, -2.438812880849829e-20,  1.825597757351471e-22, -1.329232536202017e-24,  1.895022094078432e-02,
 -3.574035194317776e-04,  5.619739117955343e-06, -7.406377251936866e-08,  8.711626882172654e-10, -9.409505704335616e-12,  9.498644051861560e-14, -9.069060110062265e-16,
  8.259926460342710e-18, -7.222273689803913e-20,  6.092523440961350e-22, -4.977589540604706e-24,  1.065678578894726e-02, -2.682966201741998e-04,  5.114436676930046e-06,
 -8.000176909410253e-08,  1.099277791158777e-09, -1.371027341634929e-11,  1.583890689697813e-13, -1.718152285052683e-15,  1.767155534551589e-17, -1.735843261660492e-19,
  1.637555580905002e-21, -1.490124051957004e-23,  5.459585848514034e-03, -1.781519555087618e-04,  4.075694719700010e-06, -7.495747825821707e-08,  1.192897287549886e-09,
 -1.704563444086634e-11,  2.237242352329800e-13, -2.738436309378381e-15,  3.159937521754207e-17, -3.465270574384509e-19,  3.633901966085861e-21, -3.661683197356590e-23,
  2.551773322682987e-03, -1.052931177672816e-04,  2.865828086148064e-06, -6.147031981351923e-08,  1.125019309431803e-09, -1.830042609878805e-11,  2.712723206637114e-13,
 -3.725863552549002e-15,  4.798080037277987e-17, -5.844564465807995e-19,  6.779956036246944e-21, -7.529665162425085e-23,  1.090062838811289e-03, -5.571595227894007e-05,
  1.789677776163103e-06, -4.445759425189453e-08,  9.301203030530260e-10, -1.713131398623813e-11,  2.853799169463710e-13, -4.377828156265131e-15,  6.264028622968778e-17,
 -8.439979360175358e-19,  1.078708677724867e-20, -1.315236324001168e-22,  4.265255274097681e-04, -2.654029751121145e-05,  9.985272271503785e-07, -2.854920799295574e-08,
  6.792275826545971e-10, -1.409932280539190e-11,  2.628287345798040e-13, -4.485405769090955e-15,  7.104411998352607e-17, -1.055050133779599e-18,  1.480613524613681e-20,
 -1.975430273702984e-22,  1.532825106090938e-04, -1.144137133194631e-05,  5.006021196833457e-07, -1.638191420667992e-08,  4.411565974568616e-10, -1.027845173824454e-11,
  2.136133926830562e-13, -4.041602908721774e-15,  7.063237935492298e-17, -1.152574600118691e-18,  1.770775240942492e-20, -2.577919407970552e-22,  5.075960766577908e-05,
 -4.487599260300932e-06,  2.268153571285868e-07, -8.452013923926452e-09,  2.565430989524281e-10, -6.684154744653436e-12,  1.543583752686287e-13, -3.227908022447115e-15,
  6.206535309995001e-17, -1.109824878272512e-18,  1.861859138796620e-20, -2.950202556999590e-22,  1.555065046777219e-05, -1.610439911236532e-06,  9.343334791142609e-08,
 -3.945827961499328e-09,  1.344663357071336e-10, -3.904643427910115e-12,  9.989208670183258e-14, -2.302394476981315e-15,  4.858012428415230e-17, -9.495965295376445e-19,
  1.735457297576714e-20, -2.986347142812868e-22,  4.428633992787724e-06, -5.319938483323531e-07,  3.521868066425468e-08, -1.678056596267625e-09,  6.396751917204767e-11,
 -2.063627316911617e-12,  5.832005787792720e-14, -1.477750997443791e-15,  3.413395119579676e-17, -7.277095762502315e-19,  1.445700213342537e-20, -2.696027532579522e-22,
  1.179218008477547e-06, -1.628685193732074e-07,  1.223358136299605e-08, -6.548107321266961e-10,  2.782357197347684e-11, -9.941872626745275e-13,  3.095398855423913e-14,
 -8.601284733507814e-16,  2.170006048127808e-17, -5.034870605365320e-19,  1.085087091317491e-20, -2.188644782359300e-22,  2.956207113768687e-07, -4.656588781431113e-08,
  3.947081072981823e-09, -2.363463841027903e-10,  1.115550341949508e-11, -4.401821768222496e-13,  1.505875397119570e-14, -4.577707883947449e-16,  1.258587513847099e-17,
 -3.171396363235975e-19,  7.399671954866880e-21, -1.611205082496497e-22,  7.035421941499583e-08, -1.254364006563140e-08,  1.193523106789812e-09, -7.961863746601482e-11,
  4.160033333015797e-12, -1.807277740001825e-13,  6.775254419646443e-15, -2.247680441191445e-16,  6.719263379796580e-18, -1.834853359969590e-19,  4.625598361320712e-21,
 -1.085142282374292e-22,  1.605210554144869e-08, -3.216043048936582e-09,  3.417131395686124e-10, -2.528948829882384e-11,  1.457566433856554e-12, -6.950188614889163e-14,
  2.847300924642033e-15, -1.028218625840168e-16,  3.334222963259031e-18, -9.845033015023252e-20,  2.675875963864542e-21, -6.749594415385169e-23,  3.552188264719516e-09,
 -7.940920291895289e-10,  9.372577335548341e-11, -7.662314918984145e-12,  4.853414040512915e-13, -2.531819791011573e-14,  1.130101089521876e-15, -4.430224357972108e-17,
  1.554349404864796e-18, -4.950711135938947e-20,  1.447443851767012e-21, -3.916935703915635e-23,  7.727901212775915e-10, -1.914063426850336e-10,  2.495992742543507e-11,
 -2.243866098744659e-12,  1.555833871857401e-13, -8.847573112849362e-15,  4.288919096461097e-16, -1.819728523768332e-17,  6.888394633907247e-19, -2.360330513974550e-20,
  7.404307853704028e-22, -2.144344694827061e-23,  1.678833435017031e-10, -4.574077370523425e-11,  6.552746359947661e-12, -6.446357291910048e-13,  4.871704729323802e-14,
 -3.008237111748744e-15,  1.577982657038400e-16, -7.221758505831735e-18,  2.940075511835308e-19, -1.080521613134299e-20,  3.626301642576837e-22, -1.120793456994959e-23,
  3.706953164237961e-11, -1.102779881022306e-11,  1.725067207196262e-12, -1.847237695901956e-13,  1.514267816842628e-14, -1.010848856280211e-15,  5.714234265523729e-17,
 -2.809979960104009e-18,  1.225839500286455e-19, -4.815189448784017e-21,  1.723097729761588e-22, -5.665278892869532e-24,  8.483823694200599e-12, -2.734406864310332e-12,
  4.640011856774733e-13, -5.376507159364499e-14,  4.754946626184310e-15, -3.414285604151411e-16,  2.070169191598596e-17, -1.088978424161648e-18,  5.068999486495292e-20,
 -2.119556178080354e-21,  8.055923570384448e-23, -2.807004806084617e-24,  2.055008544835704e-12, -7.117451415739960e-13,  1.300729781248117e-13, -1.620201043438691e-14,
  1.536451234264995e-15, -1.179902821164067e-16,  7.631776317131001e-18, -4.272312722125368e-19,  2.111519814109189e-20, -9.354180373988006e-22,  3.759008393229445e-23,
 -1.382005050995464e-24,  5.380895203452887e-13, -1.985360763294961e-13,  3.876677617210294e-14, -5.152630689925043e-15,  5.203090628658628e-16, -4.245236379742024e-17,
  2.910947215547352e-18, -1.723844926728086e-19,  8.994376731723924e-21, -4.198353183071859e-22,  1.774359131497164e-23, -6.848018234099416e-25,  1.552528991044636e-13,
 -6.046751639703835e-14,  1.250558702574171e-14, -1.758987975295821e-15,  1.876542834172580e-16, -1.614554571173864e-17,  1.165259899078808e-18, -7.249829534366682e-20,
  3.967112593135532e-21, -1.938747658854048e-22,  8.564859198885241e-24, -3.449580934579547e-25,  5.000714779777575e-14, -2.036259093345451e-14,  4.417967606571870e-15,
 -6.515862170717954e-16,  7.279423847997332e-17, -6.548916919618417e-18,  4.934574925327788e-19, -3.200415456133434e-20,  1.822912592934586e-21, -9.259982410106992e-23,
  4.246354229755334e-24, -1.772820855098291e-25,  1.793889817804649e-14, -7.560599698193304e-15,  1.703156569008317e-15, -2.607389269023784e-16,  3.020804994027107e-17,
 -2.815086787482274e-18,  2.194587815860489e-19, -1.470881153600215e-20,  8.647778709933647e-22, -4.529312492707255e-23,  2.139220304450664e-24, -9.188416905350393e-26,
  6.848541874013353e-15, -2.956737503760598e-15,  6.839414104748293e-16, -1.075072524005286e-16,  1.278053215469127e-17, -1.221156783293675e-18,  9.752732271565963e-20,
 -6.690897744054097e-21,  4.023385890855516e-22, -2.153559996316263e-23,  1.038692029027397e-24, -4.552349639219283e-26,  2.201422504068156e-15, -9.633049658123366e-16,
  2.261762706674136e-16, -3.608557891311754e-17,  4.352762400578649e-18, -4.218118326365981e-19,  3.415104793099198e-20, -2.374052763645012e-21,  1.445862861138970e-22,
 -7.834809778096417e-24,  3.823906715661347e-25, -1.695159641694699e-26,  7.954316851466546e-02, -2.644882729393785e-04,  9.191225027531310e-07, -3.309239102966657e-09,
  1.221818580674143e-11, -4.587092125787091e-14,  1.737819545517471e-16, -6.617306134415784e-19,  2.520804186714590e-21, -9.606011667655235e-24,  3.646765758426587e-26,
 -1.384044132128715e-28,  7.191201812740267e-02, -3.081493017902852e-04,  1.606072451348480e-06, -8.659445630721840e-09,  4.589646954166107e-11, -2.371902044866607e-13,
  1.197494232773595e-15, -5.926707221477499e-18,  2.883563528636574e-20, -1.382411730195613e-22,  6.540744435914970e-25, -3.058701940757871e-27,  5.878350114857685e-02,
 -3.651121909821347e-04,  2.743891464901470e-06, -1.946796110677865e-08,  1.300665239618579e-10, -8.301925062039211e-13,  5.111740744721151e-15, -3.055166760270930e-17,
  1.780166249814579e-19, -1.014510493258283e-21,  5.669258317946082e-24, -3.112754482214264e-26,  4.345911916789438e-02, -3.961440559999855e-04,  3.921957426799301e-06,
 -3.452678014779163e-08,  2.806038568821279e-10, -2.150489125831235e-12,  1.572783608289451e-14, -1.106441828497049e-16,  7.530294484174323e-19, -4.979729917441392e-21,
  3.210583780134502e-23, -2.023513504384525e-25,  2.907090084669046e-02, -3.783805036693033e-04,  4.701746040513393e-06, -5.023469464102537e-08,  4.877155859360847e-10,
 -4.408450528387028e-12,  3.763973457612031e-14, -3.065712804026943e-16,  2.399024842133048e-18, -1.813340659756447e-20,  1.329437778723267e-22, -9.484487807670723e-25,
  1.760521047596538e-02, -3.157772498250408e-04,  4.808774053917360e-06, -6.151495368568232e-08,  7.038572038113193e-10, -7.406927939032883e-12,  7.293385651163452e-14,
 -6.798824115977264e-16,  6.050479211092999e-18, -5.172699473867391e-20,  4.268940009662771e-22, -3.413838452624727e-24,  9.659746404498801e-03, -2.309417826410389e-04,
  4.251524292775240e-06, -6.441570575348561e-08,  8.594962229752700e-10, -1.042768653942845e-11,  1.173414372062369e-13, -1.241184646796546e-15,  1.245900713427895e-17,
 -1.195312126049467e-19,  1.102082938701573e-21, -9.807115686330267e-24,  4.806918525895819e-03, -1.488440241825877e-04,  3.280351425753425e-06, -5.833083930680153e-08,
  9.000126730328879e-10, -1.249270077049776e-11,  1.595122674511328e-13, -1.901676354713950e-15,  2.139409361652996e-17, -2.289283897324195e-19,  2.344234345694600e-21,
 -2.308111991250361e-23,  2.172180384486020e-03, -8.503674583937799e-05,  2.225163763605711e-06, -4.607692051368642e-08,  8.164863840328185e-10, -1.288600079110914e-11,
  1.856191839530685e-13, -2.480642472910079e-15,  3.111656120167089e-17, -3.695410369442237e-19,  4.182848662503865e-21, -4.535928224226024e-23,  8.927807436131202e-04,
 -4.330331525820012e-05,  1.335272176066250e-06, -3.198247841116576e-08,  6.471177806874103e-10, -1.155199446941898e-11,  1.868298804827224e-13, -2.786346327154889e-15,
  3.880466337376942e-17, -5.093951134795694e-19,  6.348572264052188e-21, -7.553872504824837e-23,  3.344061686063024e-04, -1.975709073508155e-05,  7.128407606084399e-07,
 -1.963322128916876e-08,  4.513395012474270e-10, -9.073027385004505e-12,  1.640811995163245e-13, -2.720485502340240e-15,  4.191404074337440e-17, -6.061024984128436e-19,
  8.290009167990548e-21, -1.078879461750412e-22,  1.144325069744544e-04, -8.116879105863026e-06,  3.403936564693537e-07, -1.072373708443366e-08,  2.788618860189425e-10,
 -6.288252379863583e-12,  1.267136460474610e-13, -2.328036715369370e-15,  3.955769027711649e-17, -6.282935582786150e-19,  9.404631400170541e-21, -1.335085431791051e-22,
  3.588249983579221e-05, -3.017983205559731e-06,  1.461846121198786e-07, -5.242624631577371e-09,  1.536052119087762e-10, -3.872046724983749e-12,  8.667011213785612e-14,
 -1.759412852825253e-15,  3.288275252999772e-17, -5.721855241425276e-19,  9.350317960352881e-21, -1.444510526266361e-22,  1.034869877999801e-05, -1.020984057831954e-06,
  5.678398161405212e-08, -2.307970708200414e-09,  7.591515661236593e-11, -2.132537592970196e-12,  5.287404389487971e-14, -1.182919384231001e-15,  2.425892263428823e-17,
 -4.614140481352981e-19,  8.213891596127832e-21, -1.378042591502499e-22,  2.757600036905352e-06, -3.160963745334867e-07,  2.007353433045093e-08, -9.208298116806315e-10,
  3.388829775236485e-11, -1.057766551605482e-12,  2.897539877232545e-14, -7.127392667523849e-16,  1.600329051633212e-17, -3.320320271010550e-19,  6.426135795254545e-21,
 -1.168577343699359e-22,  6.826943358489372e-07, -9.014727839912872e-08,  6.502111233023905e-09, -3.353046357045420e-10,  1.376204668926658e-11, -4.759893014210897e-13,
  1.437037872179603e-14, -3.877855443542056e-16,  9.513411338403781e-18, -2.148895130377954e-19,  4.513305266779287e-21, -8.880219416239136e-23,  1.580875184778478e-07,
 -2.385979325348840e-08,  1.944745268215385e-09, -1.123075195809205e-10,  5.124640148498021e-12, -1.958777069236041e-13,  6.502102558497431e-15, -1.920703587055404e-16,
  5.138089513256487e-18, -1.261165172349016e-19,  2.869356310701808e-21, -6.097997361597479e-23,  3.452147362766198e-08, -5.912012770766148e-09,  5.418582607725525e-10,
 -3.490952347035015e-11,  1.765434507456616e-12, -7.437248604813277e-14,  2.707954345261006e-15, -8.737507159817895e-17,  2.543617075328591e-18, -6.771616399691685e-20,
  1.665932809110615e-21, -3.817529839841906e-23,  7.179127610838340e-09, -1.385400925924063e-09,  1.420901836272346e-10, -1.017348335001749e-11,  5.683835053193161e-13,
 -2.631697494440937e-14,  1.048453599622712e-15, -3.686831117657172e-17,  1.165544701119178e-18, -3.358786037086208e-20,  8.918346728097134e-22, -2.199609049228231e-23,
  1.438652496227582e-09, -3.107196135494228e-10,  3.548613688438950e-11, -2.812489874774957e-12,  1.730085477101058e-13, -8.778396379068544e-15,  3.816454193696681e-16,
 -1.459030202631877e-17,  4.997651785771706e-19, -1.555616552090170e-20,  4.448931416003992e-22, -1.178688145834075e-23,  2.817135554278997e-10, -6.763628272148290e-11,
  8.557823651179464e-12, -7.476525576938787e-13,  5.045537265623084e-14, -2.796459113768111e-15,  1.322857185868024e-16, -5.483299714225759e-18,  2.029873976545025e-19,
 -6.808431405400639e-21,  2.092457944996048e-22, -5.941855820905118e-24,  5.479526725435915e-11, -1.452301368241400e-11,  2.024879836005703e-12, -1.941172583225033e-13,
  1.431410238260807e-14, -8.634764788039620e-16,  4.429704163621533e-17, -1.984668108558066e-18,  7.917320519225613e-20, -2.853636922899290e-21,  9.399777815693096e-23,
 -2.853626540379775e-24,  1.078894665049721e-11, -3.133917832382763e-12,  4.787044621888906e-13, -5.010414505078519e-14,  4.018889564798542e-15, -2.627761119720689e-16,
  1.456356436657412e-17, -7.027582497552529e-19,  3.010815252658525e-20, -1.162359887894321e-21,  4.090909330834442e-23, -1.323763625385451e-24,  2.196835156061203e-12,
 -6.940173581841128e-13,  1.154027747216743e-13, -1.311302158350672e-14,  1.138216250973497e-15, -8.028265120132250e-17,  4.785390372344128e-18, -2.476540183298882e-19,
  1.134922581003716e-20, -4.675090226385644e-22,  1.751565042980389e-23, -6.019753912199997e-25,  4.735323532684771e-13, -1.613720473514476e-13,  2.900394119682453e-14,
 -3.554879146457487e-15,  3.319301172166191e-16, -2.511521832435588e-17,  1.601619774582964e-18, -8.845150037276133e-20,  4.315145020962748e-21, -1.887985389196286e-22,
  7.496858317239761e-24, -2.724871565141174e-25,  1.107105405434962e-13, -4.034189766921673e-14,  7.775286046817649e-15, -1.020393387168648e-15,  1.017867719827762e-16,
 -8.208112356210395e-18,  5.565482101200913e-19, -3.260618331104022e-20,  1.683843650709555e-21, -7.782577406786234e-23,  3.258174634508853e-24, -1.246119093548257e-25,
  2.872920107626452e-14, -1.108894428081911e-14,  2.271532145558147e-15, -3.165246939861081e-16,  3.346390128974449e-17, -2.854304029403586e-18,  2.042937244905254e-19,
 -1.260941202950126e-20,  6.847305993755471e-22, -3.321856640809698e-23,  1.457214238247509e-24, -5.829649914012027e-26,  8.420385213132496e-15, -3.408328642498729e-15,
  7.347566042534129e-16, -1.076831582397726e-16,  1.195686448862183e-17, -1.069387313750722e-18,  8.012397280463597e-20, -5.168514028566505e-21,  2.928649409854584e-22,
 -1.480284468117056e-23,  6.755719834674548e-25, -2.807555521608693e-26,  2.793760843801110e-15, -1.173390279317050e-15,  2.633292668761768e-16, -4.016298436638494e-17,
  4.636248065170690e-18, -4.305426165093976e-19,  3.345150825870873e-20, -2.234785195777419e-21,  1.309825491789624e-22, -6.839821782039931e-24,  3.221233858642754e-25,
 -1.379790541146635e-26,  1.007077296499898e-15, -4.340698448727039e-16,  1.002247127735854e-16, -1.572557897093361e-17,  1.866168785104295e-18, -1.780046028889541e-19,
  1.419285531261740e-20, -9.721588411744016e-22,  5.836855208708365e-23, -3.119627518893136e-24,  1.502499290302541e-25, -6.576103715895033e-27,  3.131518018438345e-16,
 -1.369463745526937e-16,  3.213200039686839e-17, -5.123026434850984e-18,  6.175395022314480e-19, -5.980425179391335e-20,  4.838805562144630e-21, -3.361652361732367e-22,
  2.046092332053122e-23, -1.108075889042066e-24,  5.405032137824887e-26, -2.394743677222398e-27,  7.849967448245543e-02, -2.572908813298999e-04,  8.805550217750299e-07,
 -3.120867005468946e-09,  1.134102003421783e-11, -4.191369036282427e-14,  1.563327702093003e-16, -5.863278969836803e-19,  2.199841339463614e-21, -8.262082337417341e-24,
  3.089436307480239e-26, -1.156592340909253e-28,  7.070447712295724e-02, -2.957042423866965e-04,  1.506413527761837e-06, -7.961545621783808e-09,  4.142714229969721e-11,
 -2.103418710981588e-13,  1.043751166255909e-15, -5.078796110030829e-18,  2.429918718488634e-20, -1.145814054251222e-22,  5.333143895705620e-25, -2.453947802341467e-27,
  5.736552341772817e-02, -3.440613632858867e-04,  2.522235215114974e-06, -1.751334150260415e-08,  1.146233894972563e-10, -7.171646262493926e-13,  4.330852159269330e-15,
 -2.539827026727216e-17,  1.452665041365613e-19, -8.129131958906084e-22,  4.461947242557024e-24, -2.406949817773761e-26,  4.193477383143251e-02, -3.663524983184905e-04,
  3.533218382236683e-06, -3.036169398075229e-08,  2.411312146524520e-10, -1.807631747581196e-12,  1.294187704905789e-14, -8.918412166429534e-17,  5.948805449589490e-19,
 -3.857231495939379e-21,  2.439351830087732e-23, -1.508570916515277e-25,  2.762896776486710e-02, -3.430515378912532e-04,  4.142992198974676e-06, -4.309028500427218e-08,
  4.079272087505960e-10, -3.599998393924990e-12,  3.003923432872508e-14, -2.392973719202210e-16,  1.832675719617613e-18, -1.356478068974611e-20,  9.742957897116085e-23,
 -6.812543320679476e-25,  1.641462290371689e-02, -2.800789972544838e-04,  4.133567618016950e-06, -5.134934094056361e-08,  5.717869738891321e-10, -5.864687042847536e-12,
  5.634971570251729e-14, -5.130390216906989e-16,  4.462626919592017e-18, -3.731496435627124e-20,  3.013662517570812e-22, -2.359621582318696e-24,  8.799418402908578e-03,
 -1.998026707088729e-04,  3.554630398339270e-06, -5.219023643390061e-08,  6.765064358399602e-10, -7.987169874912731e-12,  8.757909867620314e-14, -9.036159473595291e-16,
  8.855361999244017e-18, -8.300428316374352e-20,  7.481841714037902e-22, -6.512652762977160e-24,  4.259917076760629e-03, -1.251740116819450e-04,  2.659164851359210e-06,
 -4.573826834889625e-08,  6.844983054082896e-10, -9.233022584890399e-12,  1.147292935066431e-13, -1.332645945725598e-15,  1.462143774624302e-17, -1.527116071694839e-19,
  1.527429412576817e-21, -1.469878954503517e-23,  1.864423729767596e-03, -6.924316731191731e-05,  1.742842729795658e-06, -3.485458928682530e-08,  5.982221319530565e-10,
 -9.163346447124877e-12,  1.283108917759391e-13, -1.669013869429205e-15,  2.039865005266750e-17, -2.362538182692099e-19,  2.609975322244435e-21, -2.764285254253608e-23,
  7.387283567213961e-04, -3.399637913139535e-05,  1.006703752693561e-06, -2.325748940293147e-08,  4.552568060337285e-10, -7.879312805019683e-12,  1.237548906224016e-13,
 -1.794836397592077e-15,  2.433551577661315e-17, -3.113156794313145e-19,  3.784260251400340e-21, -4.395040452518026e-23,  2.654478715405592e-04, -1.488651417296698e-05,
  5.152108556028205e-07, -1.367292145657416e-08,  3.037937638881987e-10, -5.915684449076406e-12,  1.038124643439674e-13, -1.672614132909943e-15,  2.507203832306920e-17,
 -3.531068195153822e-19,  4.708019457980661e-21, -5.977666011262151e-23,  8.669199590359691e-05, -5.841203864860093e-06,  2.348096458950600e-07, -7.122666388547185e-09,
  1.788873055140003e-10, -3.904867113569863e-12,  7.630802216903688e-14, -1.361608271880126e-15,  2.249853676633712e-17, -3.478709213422369e-19,  5.073917212110110e-21,
 -7.024717092668526e-23,  2.580313913787647e-05, -2.063598159253558e-06,  9.578865937445615e-08, -3.306281931498052e-09,  9.351699690212203e-11, -2.280952883673299e-12,
  4.949191926691037e-14, -9.754015472552105e-16,  1.772137393491518e-17, -3.001014392869703e-19,  4.777384701097153e-21, -7.196244975876131e-23,  7.023281298562786e-06,
 -6.596895050525051e-07,  3.516469425450657e-08, -1.375446092034763e-09,  4.366693457548430e-11, -1.186645382464821e-12,  2.851464775255695e-14, -6.192298882436710e-16,
  1.234279208401436e-17, -2.284433199160317e-19,  3.961188533110797e-21, -6.479328987716139e-23,  1.755574029097886e-06, -1.918825410516202e-07,  1.168480886193787e-08,
 -5.159457601643566e-10,  1.832851062751844e-11, -5.534614941967469e-13,  1.469404109221603e-14, -3.508546715973050e-16,  7.657182674300197e-18, -1.546002554655941e-19,
  2.914753042641535e-21, -5.168235279490646e-23,  4.051202646040145e-07, -5.109959125945925e-08,  3.537384764104614e-09, -1.756846754673500e-10,  6.963101802865183e-12,
 -2.330644544804096e-13,  6.821555111205636e-15, -1.787335238450743e-16,  4.263105847646075e-18, -9.373223587189137e-20,  1.918256279622365e-21, -3.681207606456127e-23,
  8.686396476837902e-08, -1.254922406760919e-08,  9.829113094257405e-10, -5.471608188607903e-11,  2.412708413007205e-12, -8.929993898382078e-14,  2.875382842431223e-15,
 -8.251354990348767e-17,  2.147122787022663e-18, -5.132407955303708e-20,  1.138360735668078e-21, -2.360729042192153e-23,  1.744347607405042e-08, -2.866255625676275e-09,
  2.528488712040086e-10, -1.572223170964944e-11,  7.691491181513694e-13, -3.140476725002619e-14,  1.110107830561742e-15, -3.482378694287007e-17,  9.868614949093514e-19,
 -2.560387437663271e-20,  6.145037209770396e-22, -1.375043170753341e-23,  3.312682459655003e-09, -6.150034508141108e-10,  6.082921055712815e-11, -4.210257274227130e-12,
  2.278617337640091e-13, -1.023837132983093e-14,  3.964446333491186e-16, -1.356807882749841e-17,  4.179791212712475e-19, -1.175017518803761e-20,  3.046593366068624e-22,
 -7.344253901635851e-24,  6.020124152244562e-10, -1.254589328568668e-10,  1.384979312726820e-11, -1.063211881836153e-12,  6.346624176895468e-14, -3.129986536851759e-15,
  1.324533408561224e-16, -4.935127067366184e-18,  1.649417794536192e-19, -5.014762693892513e-21,  1.402166664311949e-22, -3.635198588723773e-24,  1.061923003526192e-10,
 -2.468115911420704e-11,  3.026628459630677e-12, -2.567145631448513e-13,  1.684668721678137e-14, -9.092935191221394e-16,  4.194347609200424e-17, -1.697307775490320e-18,
  6.140708877862350e-20, -2.014885439625140e-21,  6.063203081443303e-23, -1.687245859423719e-24,  1.849367756811263e-11, -4.761809742043229e-12,  6.453994867974180e-13,
 -6.022982803585919e-14,  4.329423017577246e-15, -2.549115596625677e-16,  1.277887616744413e-17, -5.600746065050755e-19,  2.187752073918703e-20, -7.728016544943543e-22,
  2.496859140222495e-23, -7.440862732563904e-25,  3.243992777469483e-12, -9.188739316118903e-13,  1.368944919732932e-13, -1.398990808932851e-14,  1.096908637551363e-15,
 -7.018566105232816e-17,  3.810381747393625e-18, -1.802814189018696e-19,  7.579627944138983e-21, -2.873886845887612e-22,  9.941129724341125e-24, -3.163907366911339e-25,
  5.865071090405753e-13, -1.813899690354671e-13,  2.952254172118799e-14, -3.286155614823401e-15,  2.796804454578236e-16, -1.936001265976080e-17,  1.133495318128196e-18,
 -5.766508833606850e-20,  2.599691384722607e-21, -1.054226953752728e-22,  3.890804589592099e-24, -1.318056818290900e-25,  1.121516077370656e-13, -3.756424728173828e-14,
  6.633059985651331e-15, -7.991745091190846e-16,  7.340689802970156e-17, -5.467847025650425e-18,  3.435029777988359e-19, -1.870050289994652e-20,  8.998874789079911e-22,
 -3.885859842776816e-23,  1.523697938476408e-24, -5.471771190273040e-26,  2.331560700945477e-14, -8.382925391381548e-15,  1.593314854219113e-15, -2.062824051639501e-16,
  2.031077142155034e-17, -1.617556541255204e-18,  1.083763279420633e-19, -6.277265867363691e-21,  3.206436020605229e-22, -1.466539720673812e-23,  6.078300392096644e-25,
 -2.302453409572126e-26,  5.414951714656338e-15, -2.069828156550383e-15,  4.196579830062192e-16, -5.789135980534048e-17,  6.061381695151687e-18, -5.122191604215600e-19,
  3.633633361329703e-20, -2.223694540128565e-21,  1.197706043400721e-22, -5.765135838895699e-24,  2.510095735060352e-25, -9.969822544746771e-27,  1.436585858202519e-15,
 -5.777403013897250e-16,  1.236865572072285e-16, -1.800382977355849e-17,  1.985968986495646e-18, -1.764979740786342e-19,  1.314404114009480e-20, -8.429522924825197e-22,
  4.749853527609047e-23, -2.387994533008825e-24,  1.084251275875554e-25, -4.483862290886401e-27,  4.386358586415165e-16, -1.835358279200300e-16,  4.102030455484302e-17,
 -6.231148818286798e-18,  7.164821840182024e-19, -6.628483739091217e-20,  5.131415546946830e-21, -3.416202657949414e-22,  1.995576481273341e-23, -1.038735550490570e-24,
  4.876893222252773e-26, -2.082817609896666e-27,  1.486883631047030e-16, -6.397295455818551e-17,  1.474200346208600e-17, -2.308545572556289e-18,  2.734358759384676e-19,
 -2.603370966945900e-20,  2.072065389702445e-21, -1.416863903641905e-22,  8.492872961579360e-24, -4.531999018055078e-25,  2.179406040403695e-26, -9.524791132036037e-28,
  4.461326308988802e-17, -1.949744091355761e-17,  4.571407553971615e-18, -7.283201008557071e-19,  8.773022045531844e-20, -8.490097261528888e-21,  6.864721490829948e-22,
 -4.765954092745732e-23,  2.898962873191873e-24, -1.568971926444004e-25,  7.648562529566005e-27, -3.386761110817775e-28,  7.748436692418374e-02, -2.503932204260139e-04,
  8.441663380321050e-07, -2.945918459613700e-09,  1.053897627481368e-11, -3.835102196766528e-14,  1.408580481286505e-16, -5.204630321621077e-19,  1.923476948330279e-21,
 -7.122310909418678e-24,  2.623054387341855e-26, -9.692870660830236e-29,  6.954517318973860e-02, -2.840241312825152e-04,  1.414717440723321e-06, -7.331051809581423e-09,
  3.745972489714859e-11, -1.869141220374067e-13,  9.118389716742987e-16, -4.363305944365843e-18,  2.053359205063494e-20, -9.525939314613146e-23,  4.362665862511186e-25,
 -1.975655864953025e-27,  5.602834533705543e-02, -3.246939989576096e-04,  2.322623288699637e-06, -1.578869885531119e-08,  1.012645025319002e-10, -6.212585681383366e-13,
  3.680614596849112e-15, -2.118550224743103e-17,  1.189745654700921e-19, -6.539282003688240e-22,  3.526404414444556e-24, -1.869420736520972e-26,  4.052367694858099e-02,
 -3.394811669014933e-04,  3.190886050457899e-06, -2.677675133007880e-08,  2.078929567855862e-10, -1.524963357163504e-12,  1.069162383801866e-14, -7.219364152030472e-17,
  4.720944035024249e-19, -3.002276087196582e-21,  1.862899861486828e-23, -1.130747259800973e-25,  2.631992436381881e-02, -3.118702061292649e-04,  3.662814728058419e-06,
 -3.710244265577863e-08,  3.426263584267160e-10, -2.953259441613313e-12,  2.409157532552842e-14, -1.877678311910184e-16,  1.407826938760016e-18, -1.020678284625141e-20,
  7.184246455308429e-23, -4.924843213733366e-25,  1.535674983318082e-02, -2.493281586701028e-04,  3.568621724570586e-06, -4.307022818434629e-08,  4.669320101525491e-10,
 -4.669700945905986e-12,  4.379741284228484e-14, -3.895906803313167e-16,  3.313390621541292e-18, -2.710585043736194e-20,  2.142942613425913e-22, -1.643254942535300e-24,
  8.053360005878241e-03, -1.736981881341942e-04,  2.988368389655089e-06, -4.253793726211923e-08,  5.358871032396935e-10, -6.159433094274002e-12,  6.583398308398823e-14,
 -6.627961287640893e-16,  6.343333517005758e-18, -5.810862455284078e-20,  5.122121854434403e-22, -4.362567725914579e-24,  3.798537055571839e-03, -1.059230677574024e-04,
  2.170375781100588e-06, -3.612576880528982e-08,  5.246035727369359e-10, -6.879104995922799e-12,  8.321640830464210e-14, -9.420883486279940e-16,  1.008372125555822e-17,
 -1.028270844181355e-19,  1.004861699336617e-21, -9.453817190098729e-24,  1.612900228543083e-03, -5.682364439992942e-05,  1.376470733570041e-06, -2.659650917259438e-08,
  4.423148007074327e-10, -6.578105356946095e-12,  8.956945265204352e-14, -1.134350624661383e-15,  1.351234257655508e-17, -1.526634023406660e-19,  1.646472935501936e-21,
 -1.703575649913323e-23,  6.172427839405472e-04, -2.694628568649838e-05,  7.665977812420741e-07, -1.708832090950126e-08,  3.237153957719551e-10, -5.433660912319103e-12,
  8.290519458743077e-14, -1.169608512512989e-15,  1.544323447825815e-17, -1.925735925755733e-19,  2.283692740707844e-21, -2.589430184542084e-23,  2.132118670921547e-04,
 -1.134668091152590e-05,  3.767942656921603e-07, -9.637790097720390e-09,  2.070246333619435e-10, -3.906086382433299e-12,  6.653262034742287e-14, -1.041942215733920e-15,
  1.519904073673209e-17, -2.085232840436070e-19,  2.710792799058029e-21, -3.358506604952240e-23,  6.660442191364827e-05, -4.261305140023917e-06,  1.642237508962922e-07,
 -4.797376964354322e-09,  1.163917665403913e-10, -2.459927809571830e-12,  4.662741108808503e-14, -8.082006224759418e-16,  1.298847095696677e-17, -1.955352784117665e-19,
  2.779475749490494e-21, -3.753429754677062e-23,  1.886190418311421e-05, -1.433643373341518e-06,  6.377168102564341e-08, -2.118673934955293e-09,  5.785695622240319e-11,
 -1.365603929453930e-12,  2.872664043053343e-14, -5.497130876629758e-16,  9.709845542248218e-18, -1.600407630532993e-19,  2.482147652636582e-21, -3.645887784546427e-23,
  4.857286692364083e-06, -4.341043962164366e-07,  2.217425974073018e-08, -8.346349767773245e-10,  2.557512353945143e-11, -6.723530519198029e-13,  1.565890818286216e-14,
 -3.300911559697617e-16,  6.395249488925454e-18, -1.151818343401650e-19,  1.945511545870777e-21, -3.102706226822915e-23,  1.141856701242804e-06, -1.189156517647858e-07,
  6.941723251252417e-09, -2.949831427434621e-10,  1.011399762373519e-11, -2.954394293394602e-13,  7.601691675835839e-15, -1.761811120448558e-16,  3.737187536980058e-18,
 -7.342402064804346e-20,  1.348443967720941e-21, -2.331240378230278e-23,  2.462384847119566e-07, -2.964332527237023e-08,  1.968558843726526e-09, -9.412954508906555e-11,
  3.601759068964731e-12, -1.166438482548409e-13,  3.309274456114034e-15, -8.417630712424592e-17,  1.951757066454778e-18, -4.176535404135638e-20,  8.327557715219614e-22,
 -1.558484922077685e-23,  4.900927720845917e-08, -6.770824616576209e-09,  5.092937379080759e-10, -2.731621922930691e-11,  1.163542378556891e-12, -4.168831615505482e-14,
  1.301703566434090e-15, -3.627885494468053e-17,  9.180626280739414e-19, -2.136649188380615e-20,  4.618969363223593e-22, -9.345113268324648e-24,  9.071675461517681e-09,
 -1.428672163938602e-09,  1.212102342827118e-10, -7.269796793387271e-12,  3.438625297671071e-13, -1.360191858695073e-14,  4.665907784757556e-16, -1.422498997242470e-17,
  3.922829778201967e-19, -9.915565093340475e-21,  2.320898941432995e-22, -5.069745021716098e-24,  1.576500295524893e-09, -2.812333796524316e-10,  2.680116731097900e-11,
 -1.791910070287459e-12,  9.388362766862419e-14, -4.091339321856363e-15,  1.538968454257426e-16, -5.123761574116996e-18,  1.537414371563705e-19, -4.214375432400048e-21,
  1.066587793412915e-22, -2.512083660144749e-24,  2.602413109802923e-10, -5.226345599522227e-11,  5.571163014287869e-12, -4.138923907477308e-13,  2.395647695508352e-14,
 -1.147556610991669e-15,  4.723837418972386e-17, -1.714377048264866e-18,  5.587663366897980e-20, -1.658468880041537e-21,  4.531459115938041e-23, -1.149070199406554e-24,
  4.139644791700075e-11, -9.301456791903382e-12,  1.104249173729311e-12, -9.084230594699119e-14,  5.791994930373560e-15, -3.042006147892977e-16,  1.367278833088589e-17,
 -5.397879957473222e-19,  1.907361221329339e-20, -6.118641808497279e-22,  1.801766104599697e-23, -4.910733902255394e-25,  6.456865755082243e-12, -1.612902944137805e-12,
  2.122576423364057e-13, -1.926218201721694e-14,  1.348423408138306e-15, -7.742423958128242e-17,  3.789700161338754e-18, -1.623555616546013e-19,  6.205403369158410e-21,
 -2.146817413723067e-22,  6.799057844883918e-24, -1.987747453708317e-25,  1.008378608402717e-12, -2.781487121773959e-13,  4.036744692300068e-14, -4.023523311728616e-15,
  3.080695221393290e-16, -1.927174453726623e-17,  1.024007704406855e-18, -4.746541572858687e-20,  1.956864642863147e-21, -7.281713023607830e-23,  2.473933773555022e-24,
 -7.739080634658659e-26,  1.615997356657224e-13, -4.886382397174806e-14,  7.775127853209762e-15, -8.468693497889909e-16,  7.059996035803219e-17, -4.791671586933146e-18,
  2.753203198101580e-19, -1.375746379169401e-20,  6.096732207054066e-22, -2.432080765928809e-23,  8.835854036124492e-25, -2.948468809636409e-26,  2.733304223757232e-14,
 -8.987545200973404e-15,  1.557439162457387e-15, -1.842687749000798e-16,  1.663426520240132e-17, -1.218659236095469e-18,  7.535671227235520e-20, -4.040888027263754e-21,
  1.916596424565502e-22, -8.162378848038918e-24,  3.158396925936811e-25, -1.119901465409661e-26,  5.032321029297186e-15, -1.783479180060756e-15,  3.339642037273843e-16,
 -4.261610566528383e-17,  4.138152753822628e-18, -3.252153112932550e-19,  2.151454112075127e-20, -1.231108440841111e-21,  6.215910292398573e-23, -2.811558530067530e-24,
  1.152945121688441e-25, -4.323047479159221e-27,  1.040789447832273e-15, -3.936747952241459e-16,  7.893907866483733e-17, -1.077249982477625e-17,  1.116240264208337e-18,
 -9.339292743893629e-20,  6.562320562918518e-21, -3.979497777511268e-22,  2.124760315226167e-23, -1.014230096439632e-24,  4.380627585150526e-26, -1.726647698990960e-27,
  2.485692834438381e-16, -9.926636975966620e-17,  2.109281148697217e-17, -3.047746854267056e-18,  3.338106509410808e-19, -2.946487400054284e-20,  2.179990007359146e-21,
 -1.389342009140918e-22,  7.781828709885142e-24, -3.889906722465014e-25,  1.756482331018913e-26, -7.225667920130016e-28,  6.947378310391489e-17, -2.895064675424543e-17,
  6.441795391759176e-18, -9.742541619270752e-19,  1.115492066303204e-19, -1.027784291387623e-20,  7.925426170766855e-22, -5.256494161678928e-23,  3.059531767761380e-24,
 -1.587046262677120e-25,  7.426544557042362e-27, -3.161661546340033e-28,  2.204861053345759e-17, -9.467979087988242e-18,  2.177164942911159e-18, -3.402154518143381e-19,
  4.021400619354290e-20, -3.821156095776533e-21,  3.035503771422637e-22, -2.071836248319853e-23,  1.239687793122064e-24, -6.604001588450360e-26,  3.170612597197450e-27,
 -1.383492491346457e-28,  6.366094503961574e-18, -2.780262468126983e-18,  6.513621919843420e-19, -1.036950424277494e-19,  1.248113091218209e-20, -1.206964594412007e-21,
  9.751933891562829e-23, -6.765697523589898e-24,  4.112530088636942e-25, -2.224302790101416e-26,  1.083625372553465e-27, -4.795272800948449e-29,  7.649608078567055e-02,
 -2.437784843305770e-04,  8.098023283054856e-07, -2.783252156475723e-09,  9.804616323151787e-12, -3.513857897662437e-14,  1.271096517951028e-16, -4.628197737192683e-19,
  1.684975692130925e-21, -6.153621690717529e-24,  2.231641089641850e-26, -8.147399028923740e-29,  6.843116900316704e-02, -2.730483697837216e-04,  1.330221330516914e-06,
 -6.760453675003970e-09,  3.393075854241627e-11, -1.664248604172708e-13,  7.983729734626978e-16, -3.757895268779799e-18,  1.739850295573568e-20, -7.942920605345100e-23,
  3.580054455477005e-25, -1.596003085333944e-27,  5.476556905139292e-02, -3.068442403500509e-04,  2.142485277905883e-06, -1.426326287956415e-08,  8.967676446475920e-11,
 -5.396327518605974e-13,  3.137367244067786e-15, -1.772928502583725e-17,  9.778582339988656e-20, -5.280326213754655e-22,  2.798292185831525e-24, -1.458162913885899e-26,
  3.921484830963412e-02, -3.151850463340109e-04,  2.888559637291659e-06, -2.368117408239553e-08,  1.798043608744189e-10, -1.291009312080082e-12,  8.866423496837417e-15,
 -5.868130718692806e-17,  3.763077388296795e-19, -2.347802302272299e-21,  1.429741388813200e-23, -8.519833925975752e-26,  2.512835468620876e-02, -2.842597045505221e-04,
  3.248625485329378e-06, -3.206322714094753e-08,  2.889422279312169e-10, -2.433381612537254e-12,  1.941326514924834e-14, -1.480816067006169e-16,  1.087283179894004e-18,
 -7.723638553613004e-21,  5.329063977070366e-23, -3.582387699080560e-25,  1.441343219851413e-02, -2.227262947899429e-04,  3.093697817772598e-06, -3.629286068717246e-08,
  3.832240778028342e-10, -3.738330107788743e-12,  3.423759971356849e-14, -2.976525015112053e-16,  2.475909257878430e-18, -1.982228593475095e-20,  1.534483332309090e-22,
 -1.152718064044073e-24,  7.403342367770787e-03, -1.516961350385595e-04,  2.525554862731387e-06, -3.486932597506322e-08,  4.271062039902138e-10, -4.780979821104303e-12,
  4.982917923804008e-14, -4.896728199661111e-16,  4.578220358439672e-18, -4.099959196585134e-20,  3.535207358521319e-22, -2.946925586390425e-24,  3.407013737452410e-03,
 -9.016119947646327e-05,  1.783016778430511e-06, -2.873260815149158e-08,  4.050316332348875e-10, -5.165152120253782e-12,  6.084987028554471e-14, -6.716264955051586e-16,
  7.015295314490180e-18, -6.986588053802963e-20,  6.672596828117107e-22, -6.138915732917965e-24,  1.405765408857430e-03, -4.697749149036090e-05,  1.095784112170028e-06,
 -2.046515145519326e-08,  3.299091696256301e-10, -4.765377252373118e-12,  6.311773550009316e-14, -7.785131918903565e-16,  9.041058818659298e-18, -9.967159279150089e-20,
  1.049705804305068e-21, -1.061312412507466e-23,  5.205387328654204e-04, -2.155330051152598e-05,  5.893504110143061e-07, -1.268035820519923e-08,  2.325503021486154e-10,
 -3.786908504908846e-12,  5.614638494488497e-14, -7.707282631106814e-16,  9.912839268019782e-18, -1.205215559264818e-19,  1.394667054312455e-21, -1.544257796509886e-23,
  1.731937037448220e-04, -8.744049115423318e-06,  2.786932633450074e-07, -6.872623763089790e-09,  1.427647261692121e-10, -2.610690286816437e-12,  4.317285872032983e-14,
 -6.573403370784719e-16,  9.333462860748153e-18, -1.247666013106197e-19,  1.581755285428603e-21, -1.912624622868420e-23,  5.186240026429781e-05, -3.149509764450191e-06,
  1.163830822210027e-07, -3.274820450611393e-09,  7.676847414491371e-11, -1.571269217524194e-12,  2.889449437911222e-14, -4.866029924412025e-16,  7.607313684948259e-18,
 -1.115263898855236e-19,  1.545251099974170e-21, -2.035685608316826e-23,  1.400641645765721e-05, -1.011285161759366e-06,  4.310898954862500e-08, -1.378663328009221e-09,
  3.635365497834827e-11, -8.304662918758244e-13,  1.693890177673480e-14, -3.147729853146713e-16,  5.406195670178887e-18, -8.673809834747776e-20,  1.310781507366484e-21,
 -1.877632422679476e-23,  3.420848374885832e-06, -2.907197452898896e-07,  1.422855995274306e-08, -5.153609654293141e-10,  1.524257164798810e-11, -3.876785692124294e-13,
  8.751428243399046e-15, -1.790880120705646e-16,  3.372702101503853e-18, -5.911394425948682e-20,  9.726672469051307e-22, -1.512489901963977e-23,  7.582066938248638e-07,
 -7.518215372015798e-08,  4.205929714566417e-09, -1.719789834675663e-10,  5.690723730211754e-12, -1.607965304812645e-13,  4.009517388601691e-15, -9.019734217856121e-17,
  1.859577010508052e-18, -3.555092447443465e-20,  6.359744899360843e-22, -1.072005624951078e-23,  1.531886151653161e-07, -1.758617508022736e-08,  1.119847948646523e-09,
 -5.153927952666641e-11,  1.903516473201618e-12, -5.963575802179497e-14,  1.639766031057239e-15, -4.048751495346234e-17,  9.124831953773491e-19, -1.900192131187779e-20,
  3.690956922765540e-22, -6.735684675975542e-24,  2.837395952656935e-08, -3.745008216011183e-09,  2.703657658089789e-10, -1.396589122102647e-11,  5.744525855283014e-13,
 -1.991811389189324e-14,  6.029631354174709e-16, -1.631722079150032e-17,  4.014776708200446e-19, -9.095642747628163e-21,  1.916092509894173e-22, -3.781373934599680e-24,
  4.852898824965472e-09, -7.317135297980506e-10,  5.966040902862932e-11, -3.449441566072040e-12,  1.576776917132449e-13, -6.039993013582692e-15,  2.009919420550099e-16,
 -5.953236047149481e-18,  1.597098676913051e-19, -3.931786030010893e-21,  8.972761557628481e-23, -1.912828553767995e-24,  7.734416211276399e-10, -1.324214041832061e-10,
  1.214824295034910e-11, -7.840248757493609e-13,  3.974180985040285e-14, -1.678819107442044e-15,  6.131513777888373e-17, -1.984971422793893e-18,  5.798813491879449e-20,
 -1.549392236629519e-21,  3.826077578221492e-23, -8.801119823685490e-25,  1.161902678465694e-10, -2.245729794226429e-11,  2.309253666423655e-12, -1.658853774044180e-13,
  9.303206824692308e-15, -4.325590920839461e-16,  1.731019976401620e-17, -6.115678019041441e-19,  1.942812843530473e-20, -5.626641185112655e-22,  1.501605780718549e-23,
 -3.722611651234902e-25,  1.668899745006286e-11, -3.620269560899357e-12,  4.156165993409618e-13, -3.313009527429179e-14,  2.050521600338892e-15, -1.047126669767731e-16,
  4.582694159217085e-18, -1.763871352127558e-19,  6.083541461626473e-21, -1.906829853873559e-22,  5.491651814474898e-24, -1.465175765046818e-25,  2.332809869128651e-12,
 -5.645372165051350e-13,  7.204853427647578e-14, -6.351346824328983e-15,  4.325870559672418e-16, -2.420110113267171e-17,  1.155675971068585e-18, -4.835922709813762e-20,
  1.807276168392186e-21, -6.119465007317932e-23,  1.898532933204982e-24, -5.441894528386321e-26,  3.242555726348456e-13, -8.697770978375633e-14,  1.228140536552908e-14,
 -1.192573093535024e-15,  8.907820393590363e-17, -5.442896928622364e-18,  2.828101905342713e-19, -1.283233376435713e-20,  5.183720510645103e-22, -1.891687701197191e-23,
  6.308012627565343e-25, -1.938302980507524e-26,  4.599443305594798e-14, -1.357914620012952e-14,  2.109785150535360e-15, -2.246121484332372e-16,  1.832251560825817e-17,
 -1.218116231763444e-18,  6.862568826676689e-20, -3.365327604741001e-21,  1.464841752518681e-22, -5.743988096966029e-24,  2.052765798418413e-25, -6.742888934596052e-27,
  6.862825822507142e-15, -2.212601149102165e-15,  3.758371922703297e-16, -4.362000765130339e-17,  3.865977926949002e-18, -2.783115257653644e-19,  1.692449714719035e-20,
 -8.931918071015504e-22,  4.172339895437619e-23, -1.751189757784618e-24,  6.682179000581685e-26, -2.337906908858944e-27,  1.114575052830948e-15, -3.889535010371735e-16,
  7.168165293091455e-17, -9.006889090082531e-18,  8.617520441635997e-19, -6.677420976157604e-20,  4.358214483868846e-21, -2.461917568688440e-22,  1.227803837005492e-23,
 -5.488449902672508e-25,  2.225392833771585e-26, -8.254623309656640e-28,  2.042516588472027e-16, -7.638503746529033e-17,  1.513526097004881e-17, -2.041609586385195e-18,
  2.092036101896300e-19, -1.731763442176198e-20,  1.204477831002064e-21, -7.233214378034722e-23,  3.826127826554219e-24, -1.810118345413014e-25,  7.751618103919074e-27,
 -3.030460840017524e-28,  4.366438335726723e-17, -1.730511497246642e-17,  3.647384074754007e-18, -5.228424624623656e-19,  5.682796176927356e-20, -4.979355169766031e-21,
  3.658187002711189e-22, -2.315768634691212e-23,  1.288748074255374e-24, -6.402437330444274e-26,  2.873974262273409e-27, -1.175609803345008e-28,  1.110826084209494e-17,
 -4.608355290362047e-18,  1.020467320894212e-18, -1.536029824380853e-19,  1.750642572592716e-20, -1.605884290695662e-21,  1.233090170812816e-22, -8.145262984687504e-24,
  4.722526449216152e-25, -2.440562618122942e-26,  1.137981218536397e-27, -4.828132358386592e-29,  3.284963969016650e-18, -1.407634949002700e-18,  3.229382140136123e-19,
 -5.034846173039594e-20,  5.938029520660882e-21, -5.630238536975191e-22,  4.463392083509460e-23, -3.040371781938942e-24,  1.815742440355338e-25, -9.654994613494569e-27,
  4.627238181967200e-28, -2.015676137212807e-29,  9.099734898533423e-19, -3.971181611437049e-19,  9.296044761447307e-20, -1.478680501114619e-20,  1.778351793993253e-21,
 -1.718362009775954e-22,  1.387321069212723e-23, -9.617777393433490e-25,  5.841936013258987e-26, -3.157450600114721e-27,  1.537183959919868e-28, -6.797881397965752e-30,
  7.553371585432256e-02, -2.374310473072096e-04,  7.773218792632553e-07, -2.631839015944397e-09,  9.131332026894511e-12, -3.223756060915052e-14,  1.148734527025587e-16,
 -4.122795278712592e-19,  1.478685336449251e-21, -5.328726530745471e-24,  1.902129446774160e-26, -6.870489377454764e-29,  6.735975797504599e-02, -2.627221181247657e-04,
  1.252246676058938e-06, -6.243183113813588e-09,  3.078566222176743e-11, -1.484661954930716e-13,  7.005355017192125e-16, -3.244262227975742e-18,  1.478075644017589e-20,
 -6.641947287531686e-23,  2.946819209798152e-25, -1.293585467109730e-27,  5.357142123340402e-02, -2.903653971399748e-04,  1.979591741026560e-06, -1.291084740037616e-08,
  7.959862315020637e-11, -4.699562063065943e-13,  2.682044648029543e-15, -1.488387710853018e-17,  8.064592621443698e-20, -4.279421815846327e-22,  2.229222557861609e-24,
 -1.142109228578139e-26,  3.799859185831155e-02, -2.931662487007341e-04,  2.620830682981178e-06, -2.099983910987550e-08,  1.559857419086454e-10, -1.096645663776131e-12,
  7.379972895348505e-15, -4.788835004517053e-17,  3.012378740792034e-19, -1.844345955526585e-21,  1.102579225958103e-23, -6.451953245311246e-26,  2.404096334680167e-02,
 -2.597346842781754e-04,  2.890077494765348e-06, -2.780551980857885e-08,  2.446172103533185e-10, -2.013529991605032e-12,  1.571504653704461e-14, -1.173549092465735e-16,
  8.440857286263135e-19, -5.876652303706180e-21,  3.975717527716712e-23, -2.621578997422736e-25,  1.356940794243488e-02, -1.996199382545810e-04,  2.692642950331027e-06,
 -3.071744305571764e-08,  3.160430421608021e-10, -3.008305414138279e-12,  2.691316314095768e-14, -2.287489362362400e-16,  1.861573216086819e-18, -1.459002690972589e-20,
  1.106237466837034e-22, -8.143172928010738e-25,  6.834471569274670e-03, -1.330561178246644e-04,  2.145168121727434e-06, -2.873998663267856e-08,  3.424151392302058e-10,
 -3.734326905784577e-12,  3.796557519659168e-14, -3.642911753105376e-16,  3.328346652581396e-18, -2.914743869360267e-20,  2.459149868628855e-22, -2.006868815978887e-24,
  3.072859323740273e-03, -7.717342733548648e-05,  1.473940113667043e-06, -2.300514367832813e-08,  3.149311815891469e-10, -3.907206557005933e-12,  4.484294476051888e-14,
 -4.827140766095803e-16,  4.921880569910638e-18, -4.788611622851163e-20,  4.470857968156411e-22, -4.023446958462272e-24,  1.233950403893008e-03, -3.911055375477895e-05,
  8.789761132918054e-07, -1.587362262963856e-08,  2.481400899701404e-10, -3.482486417234784e-12,  4.488322299158261e-14, -5.393392877907239e-16,  6.108205013182726e-18,
 -6.572560805899368e-20,  6.761172583383003e-22, -6.681519297052513e-24,  4.428736982225646e-04, -1.738921513985029e-05,  4.572301436346611e-07, -9.498984096716058e-09,
  1.687087944315994e-10, -2.666169744848977e-12,  3.842437878478355e-14, -5.133729900773031e-16,  6.433499329340017e-18, -7.628404484614487e-20,  8.616080472747494e-22,
 -9.318397597491373e-24,  1.422042955143834e-04, -6.809188207375868e-06,  2.083707535061839e-07, -4.955501030588497e-09,  9.957983889512481e-11, -1.765409443506504e-12,
  2.835185527705610e-14, -4.197999363522734e-16,  5.803355603135607e-18, -7.560491090783141e-20,  9.349372715861299e-22, -1.103571026117603e-23,  4.090421697094077e-05,
 -2.356920140333338e-06,  8.352846099963929e-08, -2.264430719500163e-09,  5.130200003369032e-11, -1.017114923864339e-12,  1.814998064472290e-14, -2.970356661530400e-16,
  4.518231867856737e-18, -6.451705020045425e-20,  8.714751044762485e-22, -1.120168390559541e-23,  1.055870097298407e-05, -7.238332606727202e-07,  2.957100740943035e-08,
 -9.104697514785829e-10,  2.318574723291113e-11, -5.127073941281296e-13,  1.014155740671672e-14, -1.830390188274678e-16,  3.057161150423094e-18, -4.775234482410156e-20,
  7.032227736321952e-22, -9.824897706768144e-24,  2.451619200675587e-06, -1.980053952015804e-07,  9.284433093663694e-09, -3.236048120002520e-10,  9.238739378920368e-12,
 -2.273491389685022e-13,  4.974840521963107e-15, -9.883652677666922e-17,  1.809467916956544e-18, -3.086598497251338e-20,  4.947755500245824e-22, -7.502118355510925e-24,
  5.136036736822524e-07, -4.845609200116621e-08,  2.597217006561615e-09, -1.021777261889335e-10,  3.262816027350234e-12, -8.917765679016598e-14,  2.154975401602281e-15,
 -4.705401079626310e-17,  9.428726544201013e-19, -1.754017979926590e-20,  3.056445775539753e-22, -5.023141099837705e-24,  9.747136063065962e-08, -1.066197253618661e-08,
  6.507548448723004e-10, -2.881975843238001e-11,  1.027219263337107e-12, -3.112857730699187e-14,  8.294538898045568e-16, -1.987803767156081e-17,  4.354202429415439e-19,
 -8.823257388845957e-21,  1.669462761892762e-22, -2.970595937965414e-24,  1.684465171062844e-08, -2.122038165198740e-09,  1.469543941520282e-10, -7.307918365149841e-12,
  2.901824219690954e-13, -9.734597193639647e-15,  2.856346922113618e-16, -7.504047748994243e-18,  1.794853535672864e-19, -3.957658168360310e-21,  8.123099681722217e-23,
 -1.563434042919144e-24,  2.668743870536497e-09, -3.848374364804051e-10,  3.013370005552398e-11, -1.678649155473145e-12,  7.412223122175448e-14, -2.748533967698460e-15,
  8.869592127458473e-17, -2.551548932081754e-18,  6.657180651240409e-20, -1.595777272080072e-21,  3.549727702523344e-23, -7.383424358956832e-25,  3.909943436034483e-10,
 -6.417173394314246e-11,  5.662324829311789e-12, -3.525059658835537e-13,  1.727729965974858e-14, -7.071169260530508e-16,  2.506427764093539e-17, -7.886530902768695e-19,
  2.242245290237425e-20, -5.837466598874407e-22,  1.406023803491598e-23, -3.157740195484953e-25,  5.356218125817719e-11, -9.950627653513226e-12,  9.860493046726906e-13,
 -6.843373493237682e-14,  3.715967776373891e-15, -1.675977676195273e-16,  6.516400210093843e-18, -2.239999051144739e-19,  6.932316340711752e-21, -1.958086546528446e-22,
  5.101746288263198e-24, -1.235966130121211e-25,  6.957823920841474e-12, -1.455150145395036e-12,  1.613656845568965e-13, -1.245187190133237e-14,  7.474998322440843e-16,
 -3.708666584430488e-17,  1.579284980918435e-18, -5.922495753395244e-20,  1.992555049899316e-21, -6.098881354473151e-23,  1.716929381550949e-24, -4.481795232441802e-26,
  8.723741658626060e-13, -2.042298520132281e-13,  2.524667718096262e-14, -2.159647435090948e-15,  1.429763123390116e-16, -7.786813013313073e-18,  3.624816067723376e-19,
 -1.480424432576545e-20,  5.405921266723717e-22, -1.790339540291211e-23,  5.437742623694561e-25, -1.527250653870145e-26,  1.079241858866540e-13, -2.811102402064650e-14,
  3.857032369271513e-15, -3.644689002777582e-16,  2.653044214148239e-17, -1.581899234627497e-18,  8.030553352974467e-20, -3.563990150908979e-21,  1.409581157955005e-22,
 -5.041000576588743e-24,  1.648725609517463e-25, -4.973013099476069e-27,  1.353484370580238e-14, -3.896084591295314e-15,  5.903202326622018e-16, -6.135733370769647e-17,
  4.892385832059397e-18, -3.182863973265201e-19,  1.756566328069715e-20, -8.446415777403710e-22,  3.608186801608038e-23, -1.389701757136639e-24,  4.881887547071224e-26,
 -1.577442187023507e-27,  1.777263920661552e-15, -5.610882496558108e-16,  9.330948708911524e-17, -1.061131027977762e-17,  9.223843353210469e-19, -6.518615835745934e-20,
  3.894847612859519e-21, -2.021263679849198e-22,  9.291582896590189e-24, -3.840434756196869e-25,  1.444066104742024e-26, -4.981898249926173e-28,  2.536517292242746e-16,
 -8.706017024491215e-17,  1.577366154075899e-17, -1.949607037088936e-18,  1.836171929621703e-19, -1.401561752205673e-20,  9.017478803765019e-22, -5.024657707933571e-23,
  2.473341873526465e-24, -1.091882567545694e-25,  4.374588149605319e-27, -1.604208412751401e-28,  4.097951462438382e-17, -1.513836899977929e-17,  2.961373689977128e-18,
 -3.945123030215276e-19,  3.994483636677727e-20, -3.268981053606653e-21,  2.248941022897363e-22, -1.336529907482565e-23,  6.999644060292506e-25, -3.280061915891028e-26,
  1.391888428699888e-27, -5.394288684128156e-29,  7.795643368833952e-18, -3.064114186255225e-18,  6.401683706506036e-19, -9.098054939233989e-20,  9.807193908375169e-21,
 -8.525351970888411e-22,  6.216013814397584e-23, -3.906546004666500e-24,  2.159014086738111e-25, -1.065499379686169e-26,  4.752638974754558e-28, -1.932335545474927e-29,
  1.794379565253834e-18, -7.408012720624181e-19,  1.631834337377291e-19, -2.443625802815466e-20,  2.771198752852476e-21, -2.529916314846630e-22,  1.933729706125314e-23,
 -1.271744998013363e-24,  7.342514389657941e-26, -3.779318277588752e-27,  1.755437768435010e-28, -7.420453510712897e-30,  4.919222175130775e-19, -2.103089281709327e-19,
  4.812771673502343e-20, -7.484816216465099e-21,  8.806207712826023e-22, -8.330349196793284e-23,  6.589167053798906e-24, -4.478780932800476e-25,  2.669268682040518e-26,
 -1.416546075441745e-27,  6.776028339686487e-29, -2.946343815678962e-30,  1.303113137707574e-19, -5.682356611084843e-20,  1.328995923349681e-20, -2.112106738996097e-21,
  2.537948690550513e-22, -2.450267337391937e-23,  1.976606210109808e-24, -1.369219423100283e-25,  8.310379931501342e-27, -4.488246319666294e-28,  2.183493575155176e-29,
 -9.649304879537304e-31,  7.459623223842678e-02, -2.313363648705448e-04,  7.465956168844732e-07, -2.490749749152606e-09,  8.513242293539985e-12, -2.961394888694450e-14,
  1.039642515443162e-16, -3.678898145936698e-19,  1.299847855329842e-21, -4.625081799503341e-24,  1.623776615315932e-26, -5.815107675895119e-29,  6.632844249890896e-02,
 -2.529956636888406e-04,  1.180188791504255e-06, -5.773483562566922e-09,  2.797737598043639e-11, -1.326920990594740e-13,  6.159740730765151e-16, -2.807367453692905e-18,
  1.258879993610476e-20, -5.569548065279424e-23,  2.432766881840274e-25, -1.051873113068122e-27,  5.244068154016686e-02, -2.751274253554134e-04,  1.832003822989262e-06,
 -1.170910166121927e-08,  7.081088197572302e-11, -4.103101450482556e-13,  2.299226674524346e-15, -1.253342888166433e-17,  6.673097740398662e-20, -3.480600370269699e-22,
  1.782631894416471e-24, -8.981685417725450e-27,  3.686632194360192e-02, -2.731667739570809e-04,  2.383113431601432e-06, -1.867034411751326e-08,  1.357207911994020e-10,
 -9.345859628024434e-13,  6.164648232371748e-15, -3.923121715897997e-17,  2.421407431478906e-19, -1.455224707664127e-21,  8.542419275578368e-24, -4.909954441205944e-26,
  2.304624268919805e-02, -2.378851261493782e-04,  2.578629034118934e-06, -2.419438152677162e-08,  2.078670437431127e-10, -1.672932951325527e-12,  1.277751928139961e-14,
 -9.344340381708198e-17,  6.585749771739642e-19, -4.495051055703655e-21,  2.982594334442229e-23, -1.929657718306104e-25,  1.281179155742971e-02, -1.794716231674870e-04,
  2.352496293673196e-06, -2.610905099479189e-08,  2.618501259168988e-10, -2.432974130756339e-12,  2.126892228889779e-14, -1.767938769565224e-16,  1.408044578173574e-18,
 -1.080625838343019e-20,  8.027350648938481e-23, -5.791855642880327e-25,  6.334509937935359e-03, -1.171865262035165e-04,  1.830846865822015e-06, -2.381259290568014e-08,
  2.760724466858140e-10, -2.934425361917562e-12,  2.911137266110601e-14, -2.728347041735942e-16,  2.436704707883196e-18, -2.087330319088721e-20,  1.723640165402629e-22,
 -1.377452169118667e-24,  2.786113821043888e-03, -6.640607266773747e-05,  1.225710615480891e-06, -1.853721711466930e-08,  2.465402056535562e-10, -2.976847835330396e-12,
  3.329553183448787e-14, -3.496635706399549e-16,  3.481347426480364e-18, -3.309871472751962e-20,  3.021784826413275e-22, -2.660697618139845e-24,  1.090454167983945e-03,
 -3.277812172826998e-05,  7.101921057621020e-07, -1.240681470228260e-08,  1.881446227005834e-10, -2.566432785677381e-12,  3.219662120494464e-14, -3.770404183498395e-16,
  4.165487377268898e-18, -4.375994568197366e-20,  4.398150479896299e-22, -4.249224709867810e-24,  3.799704207215866e-04, -1.414518615237467e-05,  3.578285984729132e-07,
 -7.180624238307426e-09,  1.235531880319080e-10, -1.895532593313488e-12,  2.656244428489253e-14, -3.455159106009611e-16,  4.220066982374617e-18, -4.881331533594960e-20,
  5.382586882506086e-22, -5.687290884819327e-24,  1.179598375211422e-04, -5.355462150741465e-06,  1.574089171850981e-07, -3.611367100673208e-09,  7.022263938988006e-11,
 -1.207311342090181e-12,  1.883462202434473e-14, -2.712769809598553e-16,  3.652085966942100e-18, -4.637967700604790e-20,  5.595597581404306e-22, -6.448828939617810e-24,
  3.265873461630468e-05, -1.784836164947215e-06,  6.067857958709694e-08, -1.585228672077521e-09,  3.471815467745416e-11, -6.669088965474627e-13,  1.155088865668150e-14,
 -1.837452503452117e-16,  2.720002658973272e-18, -3.783724177660968e-20,  4.983544088795694e-22, -6.251115390833604e-24,  8.075282776359863e-06, -5.253625308485836e-07,
  2.057132990829368e-08, -6.098686229877851e-10,  1.500147724609571e-11, -3.211698361861940e-13,  6.161938893649933e-15, -1.080327815576781e-16,  1.755007035976436e-18,
 -2.669178013488669e-20,  3.831011022118904e-22, -5.221061634679649e-24,  1.786694567504033e-06, -1.370576833748224e-07,  6.156743854571137e-09, -2.065087836502178e-10,
  5.691465850047802e-12, -1.355236181851123e-13,  2.874910439156258e-15, -5.545712048245421e-17,  9.870850441727318e-19, -1.638854259603496e-20,  2.559519020633981e-22,
 -3.784551102238470e-24,  3.546640349623073e-07, -3.181469240865236e-08,  1.633468903198179e-09, -6.182434285179978e-11,  1.905158982952248e-12, -5.036766359413208e-14,
  1.179552159033767e-15, -2.499968548040715e-17,  4.868974901210169e-19, -8.813991218215008e-21,  1.496089093196719e-22, -2.397307187857269e-24,  6.338514637630690e-08,
 -6.601003115993445e-09,  3.860332914824149e-10, -1.644747870342384e-11,  5.656744144806702e-13, -1.657927381879296e-14,  4.280777636855555e-16, -9.956751321414558e-18,
  2.119623355323657e-19, -4.179291144593478e-21,  7.702522655634148e-23, -1.336286499423662e-24,  1.024695561355068e-08, -1.230942662914154e-09,  8.172820623024146e-11,
 -3.911319048335175e-12,  1.498912772795682e-13, -4.863870163117001e-15,  1.383072317131644e-16, -3.526850243772374e-18,  8.199222551340972e-20, -1.759369080067140e-21,
  3.517880105575222e-23, -6.602445306073380e-25,  1.507728860680189e-09, -2.077131935701476e-10,  1.560900767559093e-11, -8.373539959392815e-13,  3.570169837151965e-14,
 -1.281087446537723e-15,  4.007838298610447e-17, -1.119481785348184e-18,  2.839885167751233e-20, -6.626777335702387e-22,  1.436521741575185e-23, -2.914685099572095e-25,
  2.035597693353206e-10, -3.198858026015929e-11,  2.712570629599301e-12, -1.627886181545158e-13,  7.710586771871687e-15, -3.056011800969030e-16,  1.050833175337723e-17,
 -3.212470631835881e-19,  8.885678426456978e-21, -2.253212182227660e-22,  5.291813269222327e-24, -1.159982702042933e-25,  2.548507954869411e-11, -4.544858985542948e-12,
  4.335894786845868e-13, -2.904941836159417e-14,  1.526219594894004e-15, -6.673160694740705e-17,  2.519495641135857e-18, -8.422281779846209e-20,  2.538035984700166e-21,
 -6.988623487048326e-23,  1.776943521592592e-24, -4.205133190111765e-26,  2.999426705635445e-12, -6.039371888930026e-13,  6.461983055425717e-14, -4.822533918071323e-15,
  2.805619076139279e-16, -1.351405528739724e-17,  5.595714975656339e-19, -2.043270740963849e-20,  6.701821967049190e-22, -2.002059449370956e-23,  5.506331693477127e-25,
 -1.405584212189845e-26,  3.377252762139062e-13, -7.637444493427269e-14,  9.133938266862780e-15, -7.573834748439968e-16,  4.869239209401719e-17, -2.579400967391137e-18,
  1.169574851349320e-19, -4.658723905823359e-21,  1.661079161711290e-22, -5.377137562091551e-24,  1.597885744929911e-25, -4.394831448707470e-27,  3.719911822737976e-14,
 -9.394627808042796e-15,  1.250932205797440e-15, -1.148985658678634e-16,  8.142296463723105e-18, -4.733094216607860e-19,  2.345483354735685e-20, -1.017297920408332e-21,
  3.936274732789000e-23, -1.378527723893915e-24,  4.419127928250241e-26, -1.307570609899557e-27,  4.121423786639953e-15, -1.155027008382254e-15,  1.704415720235943e-16,
 -1.727519903348676e-17,  1.344956736598992e-18, -8.553900878634313e-20,  4.620131425371669e-21, -2.176459695189075e-22,  9.117253598821088e-24, -3.446432760302529e-25,
  1.189206251487104e-26, -3.777275130253425e-28,  4.752561688163553e-16, -1.467190332134452e-16,  2.385756718053888e-17, -2.655330061574015e-18,  2.261315833113486e-19,
 -1.567256436785927e-20,  9.192172096838664e-22, -4.686751119200186e-23,  2.118411768791367e-24, -8.615848416851700e-26,  3.190099134081676e-27, -1.084437823601066e-28,
  5.939253401805617e-17, -2.002519211502300e-17,  3.562766525871705e-18, -4.326922098910011e-19,  4.007426660120139e-20, -3.010420891136391e-21,  1.907608008752009e-22,
 -1.047625114911572e-23,  5.085871811990232e-25, -2.215677812987043e-26,  8.765313648160977e-28, -3.175669866020268e-29,  8.416992233430293e-18, -3.068362108574905e-18,
  5.920088129267472e-19, -7.781778779197230e-20,  7.778682672539323e-21, -6.288350481183155e-22,  4.275880655712758e-23, -2.512935736974738e-24,  1.302124692083843e-25,
 -6.040017779226875e-27,  2.538244267675832e-28, -9.746003186826092e-30,  1.416239802600382e-18, -5.516718477936375e-19,  1.141650253631801e-19, -1.607487619196806e-20,
  1.717358558759631e-21, -1.480177581587753e-22,  1.070445889739756e-23, -6.675077562980643e-25,  3.661684256388080e-26, -1.794253735571813e-27,  7.948879673715360e-29,
 -3.210912468487723e-30,  2.930836724844182e-19, -1.203572957558448e-19,  2.636122333458799e-20, -3.925429208587707e-21,  4.427616208842088e-22, -4.021193496155411e-23,
  3.058356762453816e-24, -2.001843512605686e-25,  1.150542558639694e-26, -5.896370921706770e-28,  2.727416247623651e-29, -1.148345229098376e-30,  7.407441678173348e-20,
 -3.158933281968979e-20,  7.209235287739277e-21, -1.118149649356457e-21,  1.312107427126312e-22, -1.238078423570709e-23,  9.769305656699209e-25, -6.624973357650515e-26,
  3.939572521560151e-27, -2.086217350387098e-28,  9.958955015408101e-30, -4.321851576608920e-31,  1.869776032594718e-20, -8.146403890073202e-21,  1.903488316109853e-21,
 -3.022256901553293e-22,  3.628238929795180e-23, -3.499735110283423e-24,  2.820735611381467e-25, -1.952305150997579e-26,  1.183967028506099e-27, -6.389263244602047e-29,
  3.105934256826325e-30, -1.371557370021515e-31,  7.368264622266120e-02, -2.254808844709929e-04,  7.175047757233587e-07, -2.359143954569243e-09,  7.945104016702731e-12,
 -2.723786706559320e-14,  9.422150317737113e-17, -3.288382162691676e-19,  1.144444154345680e-21, -4.024057382611426e-24,  1.387686325389447e-26, -4.944051588871712e-29,
  6.533491456388008e-02, -2.438238673244430e-04,  1.113507770832462e-06, -5.346298982783707e-09,  2.546522830266131e-11, -1.188082633510783e-13,  5.427190264983848e-16,
 -2.434815223051533e-18,  1.074832115022553e-20, -4.682991023112011e-23,  2.014123407988434e-25, -8.580533083207162e-28,  5.136862040113939e-02, -2.610147758589614e-04,
  1.698031039078972e-06, -1.063889410181452e-08,  6.312926732988541e-11, -3.591097420656317e-13,  1.976396260038738e-15, -1.058549517102794e-17,  5.539451849318629e-20,
 -2.840672125615810e-22,  1.430765274019124e-24, -7.090958120416180e-27,  3.581041602400183e-02, -2.549624971027981e-04,  2.171506727016131e-06, -1.664066483713426e-08,
  1.184239390930100e-10, -7.989866625565143e-13,  5.167224330604108e-15, -3.225897812527466e-17,  1.954161624151363e-19, -1.153092259212550e-21,  6.648260553597291e-24,
 -3.754259481572338e-26,  2.213419807571384e-02, -2.183633232096701e-04,  2.307199196956986e-06, -2.112036478810783e-08,  1.772747613595743e-10, -1.395429749288444e-12,
  1.043336861185807e-14, -7.474352822660341e-17,  5.163287894544593e-19, -3.455897123807890e-21,  2.249622399796865e-23, -1.428383393958022e-25,  1.212965660956948e-02,
 -1.618371899612762e-04,  2.062804982948514e-06, -2.228258603765539e-08,  2.179190811986553e-10, -1.977169726220765e-12,  1.689515981740471e-14, -1.373877510914118e-16,
  1.071162155836264e-18, -8.052315895142939e-21,  5.861935114459880e-23, -4.146679589326580e-25,  5.893348052829890e-03, -1.036118900068725e-04,  1.569778217660651e-06,
 -1.982942789794433e-08,  2.237946347889894e-10, -2.319263287239078e-12,  2.245952051703212e-14, -2.056626191075589e-16,  1.796032836249472e-18, -1.505374597020087e-20,
  1.217000525597712e-22, -9.526454502005422e-25,  2.538781113775303e-03, -5.742737361167625e-05,  1.025099211160443e-06, -1.502856774291275e-08,  1.942618134080329e-10,
 -2.283676406545702e-12,  2.490085926867798e-14, -2.552036546508268e-16,  2.481826366312980e-18, -2.306455579833773e-20,  2.059620874415745e-22, -1.774830617000807e-24,
  9.698292643616124e-04, -2.764458163970687e-05,  5.778051723694557e-07, -9.768481543361239e-09,  1.437601106857602e-10, -1.906679767656791e-12,  2.329104187053913e-14,
 -2.658899306697534e-16,  2.866381607254099e-18, -2.940733761494507e-20,  2.888480610066558e-22, -2.729004532958429e-24,  3.286131168325950e-04, -1.159629231686923e-05,
  2.823749926439677e-07, -5.475455214463032e-09,  9.130637150887263e-11, -1.360353953112305e-12,  1.854142474758234e-14, -2.348794739538180e-16,  2.796751408887108e-18,
 -3.156595428409752e-20,  3.399035898397789e-22, -3.509575946717744e-24,  9.880680017798725e-05, -4.252123343468469e-06,  1.200900925523848e-07, -2.658777648220609e-09,
  5.004369027847508e-11, -8.346245752396368e-13,  1.265185097196304e-14, -1.773051739146889e-16,  2.325144200267226e-18, -2.879090477605920e-20,  3.389668529906896e-22,
 -3.815043258766808e-24,  2.638187861315233e-05, -1.366979026829251e-06,  4.459302320721560e-08, -1.122968430698579e-09,  2.378140745118062e-11, -4.427237510308874e-13,
  7.444406586576034e-15, -1.151327153168643e-16,  1.658971807731516e-18, -2.248647694087879e-20,  2.888426896078332e-22, -3.536299698690780e-24,  6.261800902551313e-06,
 -3.864258367876287e-07,  1.450454601009010e-08, -4.141217050730508e-10,  9.841309475349835e-12, -2.040285015886332e-13,  3.797548179948799e-15, -6.468727950982742e-17,
  1.022267819107570e-18, -1.514101455233952e-20,  2.118328397047277e-22, -2.816496967911176e-24,  1.323218771081510e-06, -9.635209771501984e-08,  4.146415292361860e-09,
 -1.338503084854642e-10,  3.561562070473742e-12, -8.207187116433935e-14,  1.688031287284032e-15, -3.161986326976308e-17,  5.472305226091812e-19, -8.844202828366603e-21,
  1.345889527816113e-22, -1.940818304426987e-24,  2.494840486171906e-07, -2.126393692372905e-08,  1.045630335324659e-09, -3.807219705384919e-11,  1.132189376061596e-12,
 -2.895417337622579e-14,  6.571649677513730e-16, -1.351994664450682e-17,  2.559436090228467e-19, -4.508704841415295e-21,  7.455130990473590e-23, -1.164777662146463e-24,
  4.209570704570674e-08, -4.170346337486840e-09,  2.336048673286687e-10, -9.573749477534757e-12,  3.176860653794779e-13, -9.004720150541673e-15,  2.252839568073808e-16,
 -5.085365164876484e-18,  1.052093646202070e-19, -2.018403161958982e-21,  3.623319563201210e-23, -6.128550264993868e-25,  6.382682877437840e-09, -7.304586129652572e-10,
  4.647563348836361e-11, -2.139830951382303e-12,  7.912394600260815e-14, -2.483092485530561e-15,  6.841621124861925e-17, -1.693166897645408e-18,  3.825460355194213e-20,
 -7.987154764436290e-22,  1.555634806841236e-23, -2.846747864241559e-25,  8.744945671836913e-10, -1.149772524164305e-10,  8.286677755968450e-12, -4.278963300007529e-13,
  1.760961843966459e-14, -6.112844907671356e-16,  1.853475073577488e-17, -5.025677907443783e-19,  1.239304734462756e-20, -2.814539851388371e-22,  5.944514030633552e-24,
 -1.176324517818974e-25,  1.090791650489726e-10, -1.639320658001928e-11,  1.334865394362145e-12, -7.717614450841854e-14,  3.530843706618488e-15, -1.354586149142581e-16,
  4.516783822532804e-18, -1.341075851341772e-19,  3.607565308100788e-21, -8.907573304193517e-23,  2.039228790315255e-24, -4.361652192388971e-26,  1.251038421213052e-11,
 -2.138870926124739e-12,  1.962632555890505e-13, -1.268380739282601e-14,  6.443497250213532e-16, -2.729624986029457e-17,  1.000231494130990e-18, -3.250005555508786e-20,
  9.532242833791476e-22, -2.557679030143699e-23,  6.343789968040198e-25, -1.465906559026694e-26,  1.336711205371185e-12, -2.587623044037514e-13,  2.668518428418197e-14,
 -1.924274552924269e-15,  1.084051837254653e-16, -5.065784930251932e-18,  2.038266009155480e-19, -7.242621322414080e-21,  2.314620499544473e-22, -6.744934540846280e-24,
  1.811455038446363e-25, -4.519681933646376e-27,  1.353620701361375e-13, -2.952595307168780e-14,  3.412013639268439e-15, -2.739632581912798e-16,  1.708825644336857e-17,
 -8.797356788155588e-19,  3.882477380280656e-20, -1.507215281119669e-21,  5.243811073462286e-23, -1.658166192042143e-24,  4.818070308369322e-26, -1.296957254576435e-27,
  1.328340033820015e-14, -3.247725152335205e-15,  4.191254935762609e-16, -3.737649283404823e-17,  2.575900266805771e-18, -1.458411555381863e-19,  7.048686781697462e-21,
 -2.985349185606871e-22,  1.129234821011902e-23, -3.869944634171256e-25,  1.215117963978375e-26, -3.524696908547990e-28,  1.299639522876041e-15, -3.540576512398267e-16,
  5.081546933637131e-17, -5.016326436728554e-18,  3.809100211876622e-19, -2.365893437128423e-20,  1.249450312321701e-21, -5.761301727742041e-23,  2.364672262367895e-24,
 -8.766175996648928e-26,  2.968908708318730e-27, -9.263349363168718e-29,  1.313743932600995e-16, -3.960199365023946e-17,  6.288179224905915e-18, -6.841306520744266e-19,
  5.701590171851497e-20, -3.871329294110923e-21,  2.226699382673763e-22, -1.114406062617696e-23,  4.948617480746874e-25, -1.978879591708252e-26,  7.209319234613384e-28,
 -2.413090521636758e-29,  1.432767982903449e-17, -4.739333756708227e-18,  8.269716914894833e-19, -9.857417315970343e-20,  8.968272311353855e-21, -6.623740213562152e-22,
  4.130018594488526e-23, -2.233503039826553e-24,  1.068494444792325e-25, -4.590152087306574e-27,  1.791718107198499e-28, -6.408858253596395e-30,  1.772358398016573e-18,
 -6.368984668044596e-19,  1.210714965168988e-19, -1.568722046516617e-20,  1.546670200306936e-21, -1.234042839198086e-22,  8.286828050102552e-24, -4.812452531484616e-25,
  2.465459354490679e-26, -1.131271372735793e-27,  4.704945055169001e-29, -1.788734639423836e-30,  2.621400990215502e-19, -1.011166770259360e-19,  2.071044842967842e-20,
 -2.886905689426942e-21,  3.054572981682941e-22, -2.608522719475939e-23,  1.869907453523822e-24, -1.156276641725143e-25,  6.292201388129535e-27, -3.059699267933683e-28,
  1.345618053183193e-29, -5.397738376546375e-31,  4.844823432051604e-20, -1.978046912627537e-20,  4.305511842796089e-21, -6.372270142591275e-22,  7.145340653871321e-23,
 -6.453004728357677e-24,  4.881543820651213e-25, -3.178817971941989e-26,  1.818044098503604e-27, -9.273577798740647e-29,  4.270358067967485e-30, -1.790297204699690e-31,
  1.122163242128605e-20, -4.772408612494509e-21,  1.085899335285987e-21, -1.679269324885227e-22,  1.964950700641222e-23, -1.849014499713063e-24,  1.455173078057739e-25,
 -9.843321894581260e-27,  5.839279004163263e-28, -3.085077907775646e-29,  1.469462600132979e-30, -6.363483532705728e-32,  2.688520679248579e-21, -1.170284870507915e-21,
  2.731709111981284e-22, -4.332859447784232e-23,  5.196462804986418e-24, -5.007584300422159e-25,  4.032271655176550e-26, -2.788319682459023e-27,  1.689486748944802e-28,
 -9.109587355137846e-30,  4.424710558375761e-31, -1.952377096738482e-32,  7.279202646357046e-02, -2.198519647252918e-04,  6.899401908753200e-07, -2.236260541956673e-09,
  7.422234864048334e-12, -2.508303244891974e-14,  8.550570570524237e-17, -2.944308516667157e-19,  1.009065482387871e-21, -3.510279651754578e-24,  1.186411960172052e-26,
 -4.228429000785012e-29,  6.437703844640372e-02, -2.351656770698101e-04,  1.051720662253866e-06, -4.957179446082767e-09,  2.321398789210492e-11, -1.065637426332703e-13,
  4.791166771978712e-16, -2.116358976146411e-18,  9.198807178722004e-21, -3.948015667948694e-23,  1.672098578529769e-25, -7.021610329313937e-28,  5.035094478085882e-02,
 -2.479245528913672e-04,  1.576195788457737e-06, -9.683803449963806e-09,  5.639839619395315e-11, -3.150417205206889e-13,  1.703357121035462e-15, -8.966030005184569e-18,
  4.612729336184500e-20, -2.326168036548600e-22,  1.152460938568120e-24, -5.619521399990913e-27,  3.482408937966372e-02, -2.383581560451291e-04,  1.982681132728095e-06,
 -1.486727648342090e-08,  1.036146719244058e-10, -6.851422687941989e-13,  4.345626883450348e-15, -2.662158092388421e-17,  1.583187732949221e-19, -9.174584097235838e-22,
  5.196744480101893e-24, -2.883822736503894e-26,  2.129612020656386e-02, -2.008733244716615e-04,  2.069894417042933e-06, -1.849431163524939e-08,  1.517098395217562e-10,
 -1.168384722134117e-12,  8.554332309627262e-15, -6.004951552610800e-17,  4.067061944562848e-19, -2.670156233962630e-21,  1.705641944676181e-23, -1.063114182166114e-25,
  1.151369914430287e-02, -1.463479086215208e-04,  1.815097202271458e-06, -1.909143813029353e-08,  1.821378670583310e-10, -1.614227366535452e-12,  1.348763527989371e-14,
 -1.073295651272830e-16,  8.194304505127101e-19, -6.035393945088478e-21,  4.306910129446534e-23, -2.987795932280893e-25,  5.502591425476649e-03, -9.194794893436723e-05,
  1.351868441288130e-06, -1.659235581642891e-08,  1.823647665897765e-10, -1.843312060458362e-12,  1.743037094307958e-14, -1.559972519225063e-16,  1.332483166273699e-18,
 -1.093094693790276e-20,  8.653922203930477e-23, -6.637082260009539e-25,  2.324401307384851e-03, -4.989838362756729e-05,  8.619972170794241e-07, -1.225557360993631e-08,
  1.540290097708143e-10, -1.763543863803935e-12,  1.875269902978433e-14, -1.876214538618300e-16,  1.782727005732071e-18, -1.619914006788536e-20,  1.415277085204921e-22,
 -1.193880379606172e-24,  8.678050329518413e-04, -2.345463730718114e-05,  4.732178439153770e-07, -7.745373601877380e-09,  1.106630156198351e-10, -1.427572874962967e-12,
  1.698574475955926e-14, -1.890898252096318e-16,  1.989673635228759e-18, -1.994043780180316e-20,  1.914622243177476e-22, -1.769382123899223e-24,  2.863623335146371e-04,
 -9.577199954459847e-06,  2.246097278190430e-07, -4.210098573960289e-09,  6.806465677355122e-11, -9.851293725396328e-13,  1.306400268798203e-14, -1.612162838210809e-16,
  1.871958810876079e-18, -2.062156657780421e-20,  2.168955283094328e-22, -2.188952272564064e-24,  8.353535086015710e-05, -3.406581295051460e-06,  9.248727128540671e-08,
 -1.976668609615104e-09,  3.602521944965239e-11, -5.830186431039403e-13,  8.590067534507526e-15, -1.171637974355029e-16,  1.497040268922497e-18, -1.807849325588866e-20,
  2.077523756331934e-22, -2.283963544714610e-24,  2.155042341557025e-05, -1.058283688446648e-06,  3.313691019606746e-08, -8.045911950709407e-10,  1.648056559765556e-11,
 -2.974189476972112e-13,  4.856506315472411e-15, -7.304052445694309e-17,  1.024680273181247e-18, -1.353612703956013e-20,  1.696060773399849e-22, -2.027114116677106e-24,
  4.920104328419225e-06, -2.878712329185332e-07,  1.035969773914237e-08, -2.849085493047061e-10,  6.542602255515440e-12, -1.313764225192031e-13,  2.372727932624729e-15,
 -3.927576923910019e-17,  6.039095911899879e-19, -8.712201676066599e-21,  1.188332744267973e-22, -1.541662575127103e-24,  9.951999196772711e-07, -6.874865549298764e-08,
  2.834340019419553e-09, -8.806447555666243e-11,  2.262639617306606e-12, -5.046541036768072e-14,  1.006510140000152e-15, -1.831063105923729e-17,  3.081646124181886e-19,
 -4.848711105124262e-21,  7.190491751107674e-23, -1.011343052409921e-24,  1.786479433290622e-07, -1.445742451761713e-08,  6.808048448308960e-10, -2.384668759569632e-11,
  6.843765661807360e-13, -1.693106215303493e-14,  3.724553121142651e-16, -7.438532819088373e-18,  1.368835474364780e-19, -2.346700519136046e-21,  3.780105265088159e-23,
 -5.758832979518657e-25,  2.853048167617839e-08, -2.686630602251647e-09,  1.441087198425985e-10, -5.680096626388474e-12,  1.818400663922771e-13, -4.984458171249314e-15,
  1.208290862054397e-16, -2.647003097592729e-18,  5.321983423295246e-20, -9.934186657129448e-22,  1.736978223215129e-23, -2.864333049897430e-25,  4.067882231527791e-09,
 -4.431093792589373e-10,  2.700499248525820e-11, -1.195860573489539e-12,  4.265792772289403e-14, -1.294491558805320e-15,  3.455535088910667e-17, -8.298667519593394e-19,
  1.822000146077215e-20, -3.701187619354364e-22,  7.021170378293501e-24, -1.252650690616394e-25,  5.203616614895787e-10, -6.522601510304567e-11,  4.505923696438331e-12,
 -2.238624143483491e-13,  8.889574531753415e-15, -2.984418355396213e-16,  8.768244654042433e-18, -2.307436405038234e-19,  5.530038336856074e-21, -1.222095828894130e-22,
  2.514414444087746e-24, -4.851818901356185e-26,  6.012465530589666e-11, -8.631481791935738e-12,  6.743925227340724e-13, -3.754122355606534e-14,  1.658173929727903e-15,
 -6.155207292730675e-17,  1.989542708746518e-18, -5.735272530348827e-20,  1.500005092655355e-21, -3.605351986326363e-23,  8.043409608988256e-25, -1.678221868216093e-26,
  6.332934231150136e-12, -1.036658272386027e-12,  9.140775906543951e-14, -5.694092488512132e-15,  2.795234530710280e-16, -1.146646349575425e-17,  4.075957611491753e-19,
 -1.286724260544021e-20,  3.671620565998437e-22, -9.596098131440110e-24,  2.320894909997735e-25, -5.234897251527653e-27,  6.156763139033412e-13, -1.144227973053907e-13,
  1.136077927151500e-14, -7.908682571350212e-16,  4.311032211900718e-17, -1.953076739016479e-18,  7.631444484328807e-20, -2.637281255966784e-21,  8.207754526237774e-23,
 -2.331935171622707e-24,  6.112545608528768e-26, -1.490008372628480e-27,  5.616966806639653e-14, -1.179983852971691e-14,  1.315989739949450e-15, -1.022134121312461e-16,
  6.179834925038018e-18, -3.089376463654050e-19,  1.326014367875830e-20, -5.013478304468105e-22,  1.700889108225921e-23, -5.250615241497081e-25,  1.490913598158373e-26,
 -3.925720230151091e-28,  4.915774821696970e-15, -1.161722560717752e-15,  1.451124097089375e-16, -1.254963626799524e-17,  8.402543832681260e-19, -4.629200896366792e-20,
  2.180211602133427e-21, -9.009623416999851e-23,  3.329044501138179e-24, -1.115632452902124e-25,  3.428737489512749e-27, -9.743907019053309e-29,  4.247025925493542e-16,
 -1.122933228859352e-16,  1.565359754962013e-17, -1.503177453015990e-18,  1.112018186071348e-19, -6.738375354847083e-21,  3.476156296392626e-22, -1.567546940874869e-23,
  6.298625812007687e-25, -2.288110603732669e-26,  7.600453327427296e-28, -2.327839458628627e-29,  3.758061030707172e-17, -1.104468997092304e-17,  1.710130562652140e-18,
 -1.816433491181574e-19,  1.479756078462861e-20, -9.832790770755606e-22,  5.540782752047403e-23, -2.719433005702483e-24,  1.185337979919940e-25, -4.656594194198899e-27,
  1.667915307738465e-28, -5.493024025217648e-30,  3.565799527226963e-18, -1.155554722046343e-18,  1.974972417807898e-19, -2.307767767298815e-20,  2.060218582322957e-21,
 -1.494482751914234e-22,  9.160229128608735e-24, -4.873767382035083e-25,  2.295652881280156e-26, -9.716840152715707e-28,  3.739544763691657e-29, -1.319652561932730e-30,
  3.831685379965490e-19, -1.355720589805408e-19,  2.536300919348902e-20, -3.235922646334136e-21,  3.143727007374473e-22, -2.473304581192148e-23,  1.638810269947465e-24,
 -9.396707678193016e-26,  4.755920481530110e-27, -2.157113227861336e-28,  8.872715108990546e-30, -3.337840250730656e-31,  4.950294732357947e-20, -1.889234712657118e-20,
  3.826368055927410e-21, -5.275912595132541e-22,  5.524346083789839e-23, -4.670870337781699e-24,  3.316642882105700e-25, -2.032398983602667e-26,  1.096480758689999e-27,
 -5.288106809362541e-29,  2.307427305702851e-30, -9.186762249808779e-32,  8.113539572498069e-21, -3.291601120364084e-21,  7.116115014051081e-22, -1.046219384396055e-22,
  1.165662808642355e-23, -1.046295723636214e-24,  7.868871696362308e-26, -5.095651941684455e-27,  2.898863744274482e-28, -1.471175923276069e-29,  6.741775876583635e-31,
 -2.813366364178011e-32,  1.711168993534719e-21, -7.255546223828277e-22,  1.645525903573348e-22, -2.536523286983014e-23,  2.958836787376263e-24, -2.775968843344525e-25,
  2.178455013939338e-26, -1.469564591422114e-27,  8.695017825168838e-29, -4.582372848631026e-30,  2.177419791548218e-31, -9.407722180578449e-33,  3.874560350816713e-22,
 -1.684888705679519e-22,  3.928608827963864e-23, -6.224503877262730e-24,  7.457183605281315e-25, -7.178704261982813e-26,  5.774747353761438e-27, -3.989383280461009e-28,
  2.414972514402269e-29, -1.300960217152656e-30,  6.313515318719419e-32, -2.783458610355879e-33,  7.192349049268976e-02, -2.144378022718796e-04,  6.638013977895656e-07,
 -2.121409308683362e-09,  6.940446188827789e-12, -2.312628907678714e-14,  7.769533802629942e-17, -2.640746157341889e-19,  8.908057837669067e-22, -3.071121601599032e-24,
  1.013613194265048e-26, -3.646749099207935e-29,  6.345283522869424e-02, -2.269837001959510e-04,  9.943946898112859e-07, -4.602200636160204e-09,  2.119306763764415e-11,
 -9.574404467861533e-14,  4.237748898011365e-16, -1.843504915903002e-18,  7.890825339610406e-21, -3.337069347904218e-23,  1.391783896595428e-25, -5.764237451727424e-28,
  4.938375077616265e-02, -2.357649336300300e-04,  1.465203434327121e-06, -8.829697060270485e-09,  5.048686284920091e-11, -2.770143706491830e-13,  1.471775124585322e-15,
 -7.615508641693122e-18,  3.852657699078000e-20, -1.911045906212483e-22,  9.315146248410753e-25, -4.469856881732997e-27,  3.390128820049364e-02, -2.231831588815700e-04,
  1.813786316950327e-06, -1.331364131327212e-08,  9.089723344417031e-11, -5.892487371837049e-13,  3.666456422941565e-15, -2.204607260671472e-17,  1.287452369185638e-19,
 -7.328942994735872e-22,  4.079376433633205e-24, -2.225098713426748e-26,  2.052439565475571e-02, -1.851623372244696e-04,  1.861790320890093e-06, -1.624328721481820e-08,
  1.302662325925483e-10, -9.818710635377933e-13,  7.041587727204743e-15, -4.844988150563567e-17,  3.218122110493817e-19, -2.072971624527226e-21,  1.299745050630426e-23,
 -7.954484299442776e-26,  1.095596495978696e-02, -1.326963227570171e-04,  1.602474092743001e-06, -1.641889168740707e-08,  1.528614316551130e-10, -1.323813273706527e-12,
  1.081907831178584e-14, -8.427578665742793e-17,  6.302404390425275e-19, -4.549321370898413e-21,  3.183182339874986e-23, -2.166116237804514e-25,  5.155235017258643e-03,
 -8.188249246744230e-05,  1.169120370177996e-06, -1.394812311756643e-08,  1.493514537634425e-10, -1.472921037814712e-12,  1.360469377088630e-14, -1.190391311476938e-16,
  9.948295561119835e-19, -7.989732743934467e-21,  6.196023484486191e-23, -4.657065528260575e-25,  2.137724107601630e-03, -4.355130766692015e-05,  7.286277756060407e-07,
 -1.005049966794900e-08,  1.228644182896650e-10, -1.370575740208297e-12,  1.421752297367548e-14, -1.389073560173129e-16,  1.289954320896559e-18, -1.146402195095939e-20,
  9.801898944315359e-23, -8.096368266382435e-25,  7.810091255417438e-04, -2.001260659547255e-05,  3.900219353296862e-07, -6.182706299843692e-09,  8.579383043739480e-11,
 -1.076868514141648e-12,  1.248440328930564e-14, -1.355677709200254e-16,  1.392766921289636e-18, -1.363899179806878e-20,  1.280498595327600e-22, -1.157789344945459e-24,
  2.513516151624916e-04, -7.965287149166525e-06,  1.800238304970634e-07, -3.263070534478938e-09,  5.116406765091557e-11, -7.196234206592960e-13,  9.287909435350067e-15,
 -1.116890042276680e-16,  1.265021319372764e-18, -1.360498695571419e-20,  1.398065963375650e-22, -1.379440431273551e-24,  7.125134588362845e-05, -2.752582938840902e-06,
  7.187433222158474e-08, -1.483371815840732e-09,  2.618635428398708e-11, -4.113592984946220e-13,  5.892703349048414e-15, -7.824577388166049e-17,  9.743729736653267e-19,
 -1.147845642857928e-20,  1.287802652369625e-22, -1.383209696636006e-24,  1.779211072342220e-05, -8.277402030405283e-07,  2.488641635504241e-08, -5.827903158691023e-10,
  1.154948832425649e-11, -2.021066055266245e-13,  3.205584203091312e-15, -4.689482956469162e-17,  6.406692873364158e-19, -8.250073716084588e-21,  1.008557158708043e-22,
 -1.176981811377423e-24,  3.914993825960115e-06, -2.170709727108169e-07,  7.491264367877925e-09, -1.984911345490499e-10,  4.405616819953981e-12, -8.570388766005802e-14,
  1.502252098790149e-15, -2.416959986807614e-17,  3.616609908223129e-19, -5.082786066478563e-21,  6.760166063680989e-23, -8.558794736845026e-25,  7.596393342100778e-07,
 -4.975456309255342e-08,  1.965291864295076e-09, -5.878037384672330e-11,  1.458505791697387e-12, -3.149061838516133e-14,  6.091336154757324e-16, -1.076389325128369e-17,
  1.761896420241291e-19, -2.699215743776572e-21,  3.901269906913094e-23, -5.352550517872768e-25,  1.301312307558841e-07, -9.992374702630085e-09,  4.505694482173413e-10,
 -1.518276668066361e-11,  4.205352258596583e-13, -1.006524681079939e-14,  2.146245975752509e-16, -4.161436162766636e-18,  7.444547870421997e-20, -1.242160610830847e-21,
  1.949387143286640e-23, -2.896007992443974e-25,  1.971900128463281e-08, -1.763610080651126e-09,  9.056349019235378e-11, -3.432725482882277e-12,  1.060165048840170e-13,
 -2.810308337705405e-15,  6.600898808729215e-17, -1.403401368532694e-18,  2.742162884604840e-20, -4.980377907612796e-22,  8.481866905627721e-24, -1.363642415622371e-25,
  2.650751774127695e-09, -2.745775684257369e-10,  1.602238159427226e-11, -6.822477735942270e-13,  2.347377843715115e-14, -6.887259286189679e-16,  1.781034835667369e-17,
 -4.150340427850386e-19,  8.854196384026544e-21, -1.749835032110218e-22,  3.232882768060625e-24, -5.622905426591313e-26,  3.174361822750455e-10, -3.789501096097087e-11,
  2.507802008346970e-12, -1.198290261649136e-13,  4.590115130750318e-15, -1.489995184488836e-16,  4.240914378470044e-18, -1.082947541190419e-19,  2.522021036241300e-21,
 -5.422577291434343e-23,  1.086662882307483e-24, -2.044352528268139e-26,  3.406760735194487e-11, -4.666362557934180e-12,  3.495754497627573e-13, -1.872625425696403e-14,
  7.981963100835837e-16, -2.865805156299476e-17,  8.976441773133271e-19, -2.511620946829802e-20,  6.384874532497287e-22, -1.493501694340169e-23,  3.246220398840919e-25,
 -6.605545385688460e-27,  3.304141628356433e-12, -5.171817744340694e-13,  4.378171590376817e-14, -2.626993789671917e-15,  1.245430428915275e-16, -4.944690312791209e-18,
  1.704290977630262e-19, -5.225052767644543e-21,  1.449959625675651e-22, -3.689947444638102e-24,  8.699377864876729e-26, -1.914657839881169e-27,  2.929767363397427e-13,
 -5.220034025312313e-14,  4.984649969477651e-15, -3.346984468073968e-16,  1.764016542405503e-17, -7.742782602493996e-19,  2.936297585708499e-20, -9.863416886752662e-22,
  2.987845370121592e-23, -8.272488687256231e-25,  2.115436129763547e-26, -5.035742848252172e-28,  2.412906039906247e-14, -4.874365679081593e-15,  5.240100286080554e-16,
 -3.933018078012681e-17,  2.302878095606964e-18, -1.117009852992348e-19,  4.659487070895110e-21, -1.714590897724228e-22,  5.668767854216495e-24, -1.707332364987712e-25,
  4.734922484669216e-27, -1.218878810990423e-28,  1.885756428069961e-15, -4.300690615099938e-16,  5.192778827758112e-17, -4.350082247045769e-18,  2.826703395908210e-19,
 -1.513963426085821e-20,  6.942263266324192e-22, -2.796954007789893e-23,  1.008786684928608e-24, -3.303526000659375e-26,  9.931205223554573e-28, -2.763260701190448e-29,
  1.439142401230346e-16, -3.687045271166390e-17,  4.984980628356641e-18, -4.650737899027379e-19,  3.348092500243343e-20, -1.977252197234853e-21,  9.954314378516502e-23,
 -4.385969267428418e-24,  1.723864909438952e-25, -6.131753303537517e-27,  1.996178548438965e-28, -5.997188136293004e-30,  1.113597437846472e-17, -3.185697303906835e-18,
  4.803140697270289e-19, -4.974264208826026e-20,  3.956389160341524e-21, -2.570006768759670e-22,  1.417363910284685e-23, -6.815581370046518e-25,  2.913427742122540e-26,
 -1.123459258858189e-27,  3.953205606200762e-29, -1.280025109253029e-30,  9.167696845184901e-19, -2.906313083996593e-19,  4.858629004251959e-20, -5.558472260300199e-21,
  4.863473121688625e-22, -3.461290817747220e-23,  2.083448990910877e-24, -1.089571603743945e-25,  5.048566876519328e-27, -2.103721405407879e-28,  7.976089593452064e-30,
 -2.774827919707439e-31,  8.517894483356590e-20, -2.963640857826099e-20,  5.449894686705051e-21, -6.838916173480015e-22,  6.539905408017266e-23, -5.068480296436686e-24,
  3.310721617866396e-25, -1.872682797123495e-26,  9.356178509042847e-28, -4.191547653131771e-29,  1.703885367864502e-30, -6.338270683051866e-32,  9.551182336463553e-21,
 -3.602967944396757e-21,  7.209090527350385e-22, -9.823515638212656e-23,  1.017062958997173e-23, -8.507324160448362e-25,  5.979241238181524e-26, -3.628451652484982e-27,
  1.939451452393398e-28, -9.271115540366077e-30,  4.011349255267753e-31, -1.584271627568849e-32,  1.378054072820228e-21, -5.551810405278108e-22,  1.191362503512875e-22,
 -1.738889838133282e-23,  1.923961270471335e-24, -1.715487842315795e-25,  1.282005038345561e-26, -8.251826921577961e-28,  4.667386517008505e-29, -2.355710704456504e-30,
  1.073871241105237e-31, -4.458955122067598e-33,  2.628075657370573e-22, -1.110664918238117e-22,  2.509952659688905e-23, -3.855429599809462e-24,  4.482106575857081e-25,
 -4.191446884493855e-26,  3.279046916543696e-27, -2.205449289172654e-28,  1.301203991601343e-29, -6.838898702841192e-31,  3.241232813790070e-32, -1.396935874708043e-33,
  5.597489313837147e-23, -2.431519476689425e-23,  5.662814499375000e-24, -8.961634721394640e-25,  1.072405163389797e-25, -1.031210412097869e-26,  8.286434479703759e-28,
 -5.718605837050523e-29,  3.458294944101943e-30, -1.861206019144233e-31,  9.023952118648186e-33, -3.974846881331388e-34,  7.107620149845988e-02, -2.092273654409913e-04,
  6.389958270214073e-07, -2.013963518513133e-09,  6.495984591004378e-12, -2.134720831753782e-14,  7.068424901599926e-17, -2.372625962826335e-19,  7.871700120037960e-22,
 -2.696324279642355e-24,  8.637378217060858e-27, -3.184712155043387e-29,  6.256046892638469e-02, -2.192438258194207e-04,  9.411413688784588e-07, -4.277895049319708e-09,
  1.937585453779394e-11, -8.616540457182449e-14,  3.755186222183232e-16, -1.609193260635485e-18,  6.783866020094483e-21, -2.827931941499097e-23,  1.161301643761636e-25,
 -4.747673646114030e-28,  4.846348208671342e-02, -2.244538081306108e-04,  1.363917003497141e-06, -8.064380431441649e-09,  4.528322340823320e-11, -2.441173754638584e-13,
  1.274815658237916e-15, -6.485910670507249e-18,  3.227269419297037e-20, -1.574961930024513e-22,  7.554662819573843e-25, -3.568144381147022e-27,  3.303659807087912e-02,
 -2.092880646863896e-04,  1.662374784587432e-06, -1.194898612142282e-08,  7.994451424095330e-11, -5.082190193318609e-13,  3.103091744807429e-15, -1.831869818576994e-17,
  1.050767550085365e-19, -5.877264945803811e-22,  3.215444973285804e-24, -1.724276837202542e-26,  1.981234858818091e-02, -1.710136950239498e-04,  1.678756929667214e-06,
 -1.430738578932500e-08,  1.122146419990602e-10, -8.280539756187040e-13,  5.818621612698740e-15, -3.925204566829248e-17,  2.557575420755890e-19, -1.616831434507083e-21,
  9.952976884965346e-24, -5.982327145875995e-26,  1.044962757513761e-02, -1.206249828667700e-04,  1.419291975415991e-06, -1.417157398643447e-08,  1.288017738338770e-10,
 -1.090336092060016e-12,  8.718732802818205e-15, -6.650025471418218e-17,  4.872596919868584e-19, -3.447974504749441e-21,  2.366173665496183e-23, -1.579825218504368e-25,
  4.845405453808080e-03, -7.316054477599269e-05,  1.015163022918919e-06, -1.177749847887436e-08,  1.229057015716680e-10, -1.183057842537365e-12,  1.067723283633246e-14,
 -9.136571656893495e-17,  7.472787947940229e-19, -5.877241233337036e-21,  4.465754693140566e-23, -3.290325515382617e-25,  1.974457660782776e-03, -3.817325938930429e-05,
  6.189688171871981e-07, -8.286664553644000e-09,  9.857264881710403e-11, -1.071719500337205e-12,  1.084899000042650e-14, -1.035399495206262e-16,  9.400072401989087e-19,
 -8.172786491485776e-21,  6.840411269995837e-23, -5.533918197530946e-25,  7.067600770692133e-04, -1.716740222427886e-05,  3.234043480681819e-07, -4.967229792329459e-09,
  6.696947324491400e-11, -8.181780240305715e-13,  9.245161183882493e-15, -9.795844448703257e-17,  9.828746796197602e-19, -9.407453581764975e-21,  8.638344769376448e-23,
 -7.643645600502853e-25,  2.221411524293924e-04, -6.668827368537007e-06,  1.453402961819346e-07, -2.548460186444262e-09,  3.876923875898513e-11, -5.300834985574616e-13,
  6.660774812296766e-15, -7.807397145704436e-17,  8.628104041080732e-19, -9.061610271701891e-21,  9.100059366692588e-23, -8.780357609131242e-25,  6.128755704723505e-05,
 -2.242246239755125e-06,  5.633926134126959e-08, -1.123209623665994e-09,  1.921266509472809e-11, -2.930506800018617e-13,  4.082672921888905e-15, -5.279121834646149e-17,
  6.408617844301139e-19, -7.366473023642448e-21,  8.070658261992680e-23, -8.471085941491826e-25,  1.483910218640583e-05, -6.537634494539770e-07,  1.888070682353680e-08,
 -4.265634969895979e-10,  8.181241087954286e-12, -1.388614980260480e-13,  2.139914219051929e-15, -3.045800381930241e-17,  4.053197031095732e-19, -5.089045043752799e-21,
  6.071077856268563e-23, -6.919157629076287e-25,  3.153019589747628e-06, -1.655887010739652e-07,  5.481514473060986e-09, -1.399635126232765e-10,  3.003366687584414e-12,
 -5.661514647019614e-14,  9.633529578704020e-16, -1.506798592474422e-17,  2.194624111598075e-19, -3.005293594777823e-21,  3.898209500059784e-23, -4.817223356814525e-25,
  5.881013337231132e-07, -3.650014359394343e-08,  1.381478396703114e-09, -3.978053247155355e-11,  9.534204382948336e-13, -1.993103720335763e-14,  3.739763186163759e-16,
 -6.420145934338267e-18,  1.022246689952982e-19, -1.525073128826177e-21,  2.148597147088985e-23, -2.875942067775201e-25,  9.636033970825194e-08, -7.015865917120628e-09,
  3.029134958344922e-10, -9.820026663590786e-12,  2.625357323979524e-13, -6.079801825356337e-15,  1.256773246097765e-16, -2.366015704471005e-18,  4.115171544993334e-20,
 -6.683464876178532e-22,  1.021960974880917e-23, -1.480613776542265e-25,  1.388839955521759e-08, -1.178808691137134e-09,  5.793975585595172e-11, -2.111802742790713e-12,
  6.291941141821457e-14, -1.612965726369832e-15,  3.670987255019742e-17, -7.574822507559430e-19,  1.438437483800294e-20, -2.542050173405822e-22,  4.216892304642061e-24,
 -6.609845820337824e-26,  1.764751162978179e-09, -1.736750264920776e-10,  9.700006969833633e-12, -3.970805230120869e-13,  1.317611531087498e-14, -3.737474170000384e-16,
  9.362392481042901e-18, -2.116870178345598e-19,  4.387987890821647e-21, -8.436261554591106e-23,  1.517919585471630e-24, -2.573656301931940e-26,  1.983777005045577e-10,
 -2.253095126064588e-11,  1.427611629449340e-12, -6.558431483531492e-14,  2.422775760302905e-15, -7.602733059764078e-17,  2.096005829252235e-18, -5.192855590162139e-20,
  1.174981054634726e-21, -2.457602900879780e-23,  4.796276749442865e-25, -8.796406508372130e-27,  1.982955559665739e-11, -2.588503245818684e-12,  1.857989491002913e-13,
 -9.573024827389751e-15,  3.936163029371001e-16, -1.366439584924947e-17,  4.146381590410101e-19, -1.125783469960940e-20,  2.781044743987535e-22, -6.329379124697832e-24,
  1.340043674405585e-25, -2.658764391363952e-27,  1.775743481385785e-12, -2.654335610348299e-13,  2.155410349397280e-14, -1.244890511559703e-15,  5.696652148704070e-17,
 -2.187974173582647e-18,  7.309176434350525e-20, -2.175403415380833e-21,  5.868718080782123e-23, -1.453748462460820e-24,  3.339841811879233e-26, -7.170440395602794e-28,
  1.439795250976034e-13, -2.455847446080528e-14,  2.253084884442336e-15, -1.457997598143474e-16,  7.424544153598008e-18, -3.155368681077383e-19,  1.160713409399930e-20,
 -3.787967913462294e-22,  1.116327466534109e-23, -3.010645303416232e-25,  7.507498166807899e-27, -1.744526379962561e-28,  1.072849257683099e-14, -2.080886061055866e-15,
  2.153747074912162e-16, -1.560551457735347e-17,  8.841426210807905e-19, -4.157807805624882e-20,  1.684393771185250e-21, -6.028587061102661e-23,  1.941206927548625e-24,
 -5.700968354570414e-26,  1.543337487213508e-27, -3.882083560210961e-29,  7.499893295123725e-16, -1.647923172441718e-16,  1.920779895677291e-17, -1.556853573044579e-18,
  9.808275722244857e-20, -5.102343117058535e-21,  2.276060304493933e-22, -8.933185151062429e-24,  3.142718023980904e-25, -1.004992970203229e-26,  2.953359905917242e-28,
 -8.040603396989281e-30,  5.059557101515777e-17, -1.253884266441960e-17,  1.641883202887594e-18, -1.486322880768825e-19,  1.040085164799655e-20, -5.980048926089961e-22,
  2.935244790635675e-23, -1.262541621832991e-24,  4.849917825592799e-26, -1.687818091764227e-27,  5.381090723580736e-29, -1.584699933924233e-30,  3.421514731964707e-18,
 -9.511567107390230e-19,  1.394356110800824e-19, -1.406086906561348e-20,  1.090575420327927e-21, -6.917609665383757e-23,  3.729992467640816e-24, -1.755601604279723e-25,
  7.353142689790118e-27, -2.780889981356681e-28,  9.605350590903712e-30, -3.055503016406695e-31,  2.438171686001167e-19, -7.549375889838579e-20,  1.232695969993685e-20,
 -1.378907383330138e-21,  1.181051860241110e-22, -8.237335963138516e-24,  4.864151735149442e-25, -2.497872207022638e-26,  1.137510012623932e-27, -4.662313498718989e-29,
  1.740030767783767e-30, -5.963106893717203e-32,  1.950102863221935e-20, -6.663018507669855e-21,  1.202821955160817e-21, -1.482786202577499e-22,  1.394164796356200e-23,
 -1.063265063088025e-24,  6.840028135902352e-26, -3.813276920543845e-27,  1.879041733314118e-28, -8.308065849019024e-30,  3.335169732726011e-31, -1.225907544601145e-32,
  1.885724456036568e-21, -7.023795382653014e-22,  1.386944257855611e-22, -1.865929559048041e-23,  1.908426509990461e-24, -1.577888598272619e-25,  1.096813740973560e-26,
 -6.586368630516368e-28,  3.485473053604687e-29, -1.650362323745688e-30,  7.076126336387468e-32, -2.770653441579837e-33,  2.376658831771242e-22, -9.501882009314496e-23,
  2.022501822027316e-23, -2.928707123910249e-24,  3.215893899416775e-25, -2.846734353162405e-26,  2.112773400393398e-27, -1.351016970103356e-28,  7.593954517138780e-30,
 -3.810026101384944e-31,  1.726993380167975e-32, -7.132198527879591e-34,  4.067983842879563e-23, -1.712966257111953e-23,  3.855920796160547e-24, -5.900147842494371e-25,
  6.833790251589815e-26, -6.367979775876923e-27,  4.964924865954625e-28, -3.328560059609663e-29,  1.957775469155604e-30, -1.025941163293966e-31,  4.848669980647101e-33,
 -2.084117800370827e-34,  8.107951504746723e-24, -3.517971149673111e-24,  8.182608999668231e-25, -1.293286073735325e-25,  1.545711967288866e-26, -1.484556827094330e-27,
  1.191558451465670e-28, -8.213986449195649e-30,  4.962031530839080e-31, -2.667733337741104e-32,  1.292145122555454e-33, -5.686145402476766e-35,  7.024936536112004e-02,
 -2.042103340258295e-04,  6.154380826819064e-07, -1.913353354782695e-09,  6.085480871347277e-12, -1.972774753988616e-14,  6.437941584056611e-17, -2.135622311033033e-19,
  6.959937807249167e-22, -2.377746196185904e-24,  7.316930308748368e-27, -2.835965183535652e-29,  6.169823403655487e-02, -2.119148914626527e-04,  8.916113865242949e-07,
 -3.981193055091903e-09,  1.773914416402607e-11, -7.767002572793862e-14,  3.333534980212963e-16, -1.407541220460513e-18,  5.844624251357049e-21, -2.402641306793246e-23,
  9.711430491007232e-26, -3.924455466324729e-28,  4.758689354612166e-02, -2.139176058829982e-04,  1.271335731320816e-06, -7.377304988807778e-09,  4.069270322774000e-11,
 -2.155894053804761e-13,  1.106855825913800e-15, -5.538363664558901e-18,  2.711096748629640e-20, -1.301962556359772e-22,  6.146959507175337e-25, -2.858265195847573e-27,
  3.222516539805687e-02, -1.965416198780564e-04,  1.526338846824785e-06, -1.074731030509912e-08,  7.048521289664048e-11, -4.395386405236646e-13,  2.634230551565775e-15,
 -1.527135987920011e-17,  8.606194818218338e-20, -4.730817685137483e-22,  2.544615979539707e-24, -1.341784543368691e-26,  1.915410804855417e-02, -1.582410828585018e-04,
  1.517317985639886e-06, -1.263721037454282e-08,  9.696556901508053e-11, -7.007220823739404e-13,  4.825912810827248e-15, -3.192712810566315e-17,  2.041260195051466e-19,
 -1.266739210384286e-21,  7.657870957746865e-24, -4.521529955446198e-26,  9.988806639863314e-03, -1.099174349973015e-04,  1.260913607396523e-06, -1.227443294278936e-08,
  1.089453672395531e-10, -9.017771432252084e-13,  7.057585236176920e-15, -5.272408338478223e-17,  3.786177054628061e-19, -2.627128953629849e-21,  1.768655006156394e-23,
 -1.158916064773909e-25,  4.568155727035283e-03, -6.557284208840943e-05,  8.848940061736049e-07, -9.987196971581463e-09,  1.016130414280046e-10, -9.549848159428917e-13,
  8.424269261212309e-15, -7.051977307825842e-17,  5.646445905949073e-19, -4.350017246135722e-21,  3.239412545033413e-23, -2.340252203537856e-25,  1.831074152061375e-03,
 -3.359399874779694e-05,  5.283277547838672e-07, -6.867758062033262e-09,  7.952366617087523e-11, -8.429881916954854e-13,  8.330269655379244e-15, -7.768335729946295e-17,
  6.896858462504993e-19, -5.867941004874529e-21,  4.808953247359350e-23, -3.811360783718880e-25,  6.429115982386610e-04, -1.480154846208692e-05,  2.697233115907268e-07,
 -4.015443422324833e-09,  5.261970360671844e-11, -6.259447376338509e-13,  6.896138478885760e-15, -7.131890971284150e-17,  6.990694790699824e-19, -6.541580406230981e-21,
  5.876452675629930e-23, -5.089930322655294e-25,  1.976114966612844e-04, -5.618638626733946e-06,  1.181569971785476e-07, -2.004970836607035e-09,  2.960401387205569e-11,
 -3.936158948476415e-13,  4.816803913056210e-15, -5.505018301073466e-17,  5.937603039090514e-19, -6.091239696416356e-21,  5.979469398843206e-23, -5.643214235707191e-25,
  5.314146744560695e-05, -1.840633550750063e-06,  4.452771419408242e-08, -8.578350988429663e-10,  1.422277479175470e-11, -2.107114661245981e-13,  2.855810344149764e-15,
 -3.596993780094295e-17,  4.257903671828149e-19, -4.776793828093320e-21,  5.111776714488059e-23, -5.244333977495112e-25,  1.249660539123166e-05, -5.211618248014006e-07,
  1.446400119571541e-08, -3.153566372100531e-10,  5.855424650530569e-12, -9.642570000071556e-14,  1.444157052088852e-15, -2.000408750286984e-17,  2.593627299382750e-19,
 -3.175848580649815e-21,  3.698021027980744e-23, -4.116829002066781e-25,  2.568781102827343e-06, -1.277164699854164e-07,  4.056618555688434e-09, -9.984220888414626e-11,
  2.071807492830669e-12, -3.785409571137127e-14,  6.254310188297103e-16, -9.512389913840428e-18,  1.348835096588632e-19, -1.800106559818617e-21,  2.277613289806102e-23,
 -2.747664192425128e-25,  4.615109156631369e-07, -2.712585699239227e-08,  9.839132599859179e-10, -2.728217171423551e-11,  6.317079989268770e-13, -1.278849005413328e-14,
  2.328083292373677e-16, -3.883483441531007e-18,  6.015971774019820e-20, -8.741533336231539e-22,  1.200639221412175e-23, -1.568079847279540e-25,  7.248701649680519e-08,
 -5.000787936661714e-09,  2.067391280293604e-10, -6.448446636634033e-12,  1.664201739937905e-13, -3.729420283996050e-15,  7.474412411681058e-17, -1.366434251474942e-18,
  2.310923447453930e-20, -3.653605050929905e-22,  5.443911963549030e-24, -7.692459681187195e-26,  9.960984781871155e-09, -8.017161430092844e-10,  3.771122542326069e-11,
 -1.321670330528976e-12,  3.798925512147692e-14, -9.418478178809410e-16,  2.077163397830380e-17, -4.160021180840706e-19,  7.677946806325214e-21, -1.320336213652315e-22,
  2.133498082791722e-24, -3.260605799742180e-26,  1.199472650483133e-09, -1.120486695108559e-10,  5.987931122410718e-12, -2.356157211280436e-13,  7.539495630046908e-15,
 -2.067461811766425e-16,  5.016652267292031e-18, -1.100542358925423e-19,  2.216536083391970e-21, -4.145601252490149e-23,  7.264121095281488e-25, -1.200619693180187e-26,
  1.269089678234772e-10, -1.369909117836773e-11,  8.306745799390587e-13, -3.667830815208346e-14,  1.306413556473171e-15, -3.962418702997289e-17,  1.057966066039430e-18,
 -2.542725404431449e-20,  5.589334788103319e-22, -1.137156319572728e-23,  2.161090627969614e-25, -3.863414761429787e-27,  1.184839501638871e-11, -1.472277255445359e-12,
  1.011882329510144e-13, -5.012234825168602e-15,  1.987310327626506e-16, -6.668618290317411e-18,  1.959862259667989e-19, -5.162354422883844e-21,  1.238980396654847e-22,
 -2.743035086122712e-24,  5.655779893457060e-26, -1.093965611903953e-27,  9.824245513601690e-13, -1.400562876257173e-13,  1.090029495722966e-14, -6.056218236746851e-16,
  2.673602074252696e-17, -9.929631691221111e-19,  3.213762731810949e-20, -9.282345342862708e-22,  2.433652837696643e-23, -5.866160398527648e-25,  1.312904138231304e-26,
 -2.748832871492461e-28,  7.303798732211242e-14, -1.190933268731741e-14,  1.048669412843115e-15, -6.534766319554477e-17,  3.213031022567322e-18, -1.321375264215375e-19,
  4.712422686960919e-21, -1.493379230012707e-22,  4.279719638812461e-24, -1.123802490264575e-25,  2.731639954601789e-27, -6.193804942155890e-29,  4.936139194239583e-15,
 -9.178044184422490e-16,  9.134977169140003e-17, -6.383586353159083e-18,  3.496582739319744e-19, -1.593010682921525e-20,  6.263298536495252e-22, -2.178988011828462e-23,
  6.829483801980573e-25, -1.954679022993876e-26,  5.162745909625177e-28, -1.268313375494589e-29,  3.092607425516334e-16, -6.535960328740404e-17,  7.344257561099991e-18,
 -5.753030745246485e-19,  3.510506620088507e-20, -1.772142917415110e-21,  7.683960330701786e-23, -2.935733322245432e-24,  1.006683765688689e-25, -3.141522963393137e-27,
  9.018790325315193e-29, -2.401106407636327e-30,  1.846306549067192e-17, -4.418362547030765e-18,  5.595145976006058e-19, -4.908416219104538e-20,  3.334901182815619e-21,
 -1.864838247437843e-22,  8.915760176404282e-24, -3.740449378183407e-25,  1.403153045839149e-26, -4.773848533611011e-28,  1.489442977524623e-29, -4.296604696243042e-31,
  1.090981849391275e-18, -2.942031058393773e-19,  4.187023901267180e-20, -4.105694212308057e-21,  3.101468072519484e-22, -1.918852360164364e-23,  1.010518354068270e-24,
 -4.650887993098368e-26,  1.906920068627509e-27, -7.066886605014307e-29,  2.394100100861272e-30, -7.476146255233942e-32,  6.716380911987393e-20, -2.027782917922910e-20,
  3.229104367389117e-21, -3.526962689029893e-22,  2.953452690593147e-23, -2.016363651218484e-24,  1.166797883900318e-25, -5.877748793015116e-27,  2.628198037772972e-28,
 -1.058629405014212e-29,  3.885868058911195e-31, -1.310774286946726e-32,  4.605310167861821e-21, -1.542954606279573e-21,  2.730539664442334e-22, -3.302529757491643e-23,
  3.049429002694696e-24, -2.286066282118492e-25,  1.446874554079641e-26, -7.942429455415910e-28,  3.856595802515599e-29, -1.681462613501416e-30,  6.660550827829381e-32,
 -2.417305496839547e-33,  3.815925433135696e-22, -1.401783952184770e-22,  2.728619042436082e-23, -3.620487422667854e-24,  3.654396973281426e-25, -2.983804740800089e-26,
  2.049531877791478e-27, -1.216896974765392e-28,  6.370849521568220e-30, -2.985855664206036e-31,  1.267798592496212e-32, -4.918228277715919e-34,  4.167547626420366e-23,
 -1.652214709543062e-23,  3.485614105133036e-24, -5.003862909202517e-25,  5.449193969858117e-26, -4.785749102906656e-27,  3.525299793441505e-28, -2.238226930788253e-29,
  1.249575865182980e-30, -6.228967661607235e-32,  2.806117249423995e-33, -1.152118703914634e-34,  6.350943846403466e-24, -2.663608478905629e-24,  5.970035537831211e-25,
 -9.096539694520834e-26,  1.049325469284898e-26, -9.740102300756160e-28,  7.565988411568946e-29, -5.054471082590366e-30,  2.962921340532370e-31, -1.547694981066788e-32,
  7.292143070290510e-34, -3.125274256476679e-35,  1.177799135100619e-24, -5.103935631449746e-25,  1.185502721901171e-25, -1.871144796605527e-26,  2.233366032916062e-27,
 -2.142232056368483e-28,  1.717290857412215e-29, -1.182392004095019e-30,  7.134532538191501e-32, -3.831471568290334e-33,  1.853828252461116e-34, -8.149470817262394e-36,
  6.944222791744988e-02, -1.993770445252741e-04,  5.930492947650855e-07, -1.819060138516698e-09,  5.705905299472679e-12, -1.825195888920848e-14,  5.869899904536975e-17,
 -1.926059181750660e-19,  6.153695530926219e-22, -2.109254910490421e-24,  6.124517953128339e-27, -2.604440791837508e-29,  6.086454434187532e-02, -2.049683878891749e-04,
  8.454901378516680e-07, -3.709372289165642e-09,  1.626266211336327e-11, -7.012211468741942e-14,  2.964358603149990e-16, -1.233635254771467e-18,  5.045624123029790e-21,
 -2.046653861305771e-23,  8.136473643989823e-26, -3.257666444055550e-28,  4.675101902457002e-02, -2.040902808300198e-04,  1.186576817380551e-06, -6.759323717363657e-09,
  3.663448838018405e-11, -1.907918895714624e-13,  9.632551952667311e-16, -4.741295644020256e-18,  2.283778226160184e-20, -1.079490232717999e-22,  5.017469965762686e-25,
 -2.297381572973207e-27,  3.146262975725567e-02, -1.848282545014532e-04,  1.403858350901829e-06, -9.686578023954407e-09,  6.229356399048158e-11, -3.811521460047905e-13,
  2.242761554082212e-15, -1.277132680030423e-17,  7.072932581420674e-20, -3.821848204660950e-22,  2.021576557007155e-24, -1.048374197632180e-26,  1.854449625715769e-02,
 -1.466837761059032e-04,  1.374537264194271e-06, -1.119187499943027e-08,  8.404057901359440e-11, -5.949296858834358e-13,  4.016946077849238e-15, -2.606929970865152e-17,
  1.635893078676568e-19, -9.967799271238153e-22,  5.919193754720163e-24, -3.433918966212518e-26,  9.568418760943241e-03, -1.003909790845488e-04,  1.123512491149971e-06,
 -1.066686669375799e-08,  9.249078839851284e-11, -7.488240510328484e-13,  5.737632243758749e-15, -4.199438406545075e-17,  2.956357949391341e-19, -2.011986654306787e-21,
  1.329157995606123e-23, -8.549337172471695e-26,  4.319300827439094e-03, -5.894682014293486e-05,  7.742060388198335e-07, -8.503837016003065e-09,  8.438519996101460e-11,
 -7.745914747576926e-13,  6.680806897119583e-15, -5.472550525996172e-17,  4.290832182003675e-19, -3.238901061234464e-21,  2.364497941650045e-23, -1.675302278787794e-25,
  1.704658383904503e-03, -2.967661292501192e-05,  4.530258269511123e-07, -5.720091895274847e-09,  6.449908760382958e-11, -6.668521108749228e-13,  6.434825968448220e-15,
 -5.865257483402606e-17,  5.093717921515477e-19, -4.242114035910685e-21,  3.404964587232837e-23, -2.644405982634659e-25,  5.877348249432180e-04, -1.282308690149327e-05,
  2.262037363877118e-07, -3.265322871066383e-09,  4.160632738855735e-11, -4.820751339654486e-13,  5.179986427521446e-15, -5.230342202745034e-17,  5.009902437856447e-19,
 -4.584556580392897e-21,  4.030099272011084e-23, -3.417788314072356e-25,  1.768857038698711e-04, -4.762128899439647e-06,  9.669854782920932e-08, -1.588491937460192e-09,
  2.277316792884053e-11, -2.945496674620179e-13,  3.511467371528995e-15, -3.914133698245488e-17,  4.121475918054687e-19, -4.131106998667714e-21,  3.965064317545119e-23,
 -3.661113681818176e-25,  4.643124901233574e-05, -1.522017008451597e-06,  3.547119961809520e-08, -6.605771984004060e-10,  1.061969103483314e-11, -1.528640872580221e-13,
  2.016126267705382e-15, -2.474255578632466e-17,  2.856735734608168e-19, -3.128710730725149e-21,  3.271072001548779e-23, -3.280912429960647e-25,  1.062148458832048e-05,
 -4.191294718384330e-07,  1.118381898224798e-08, -2.353895990429803e-10,  4.232572286631979e-12, -6.764569644667706e-14,  9.848964879771868e-16, -1.328031116156066e-17,
  1.678018819137248e-19, -2.004303901938437e-21,  2.278496436338221e-23, -2.478206561829948e-25,  2.115958992286738e-06, -9.954507194424066e-08,  3.034835816163219e-09,
 -7.201687469330211e-11,  1.445542672639943e-12, -2.560630747860721e-14,  4.108984898856977e-16, -6.078357168195970e-18,  8.392950038496812e-20, -1.091831944991845e-21,
  1.347798332128022e-23, -1.587593518827262e-25,  3.668958807821746e-07, -2.040990558640569e-08,  7.096217988675636e-10, -1.895081940416113e-11,  4.240164039460359e-13,
 -8.314473057306080e-15,  1.468815174971893e-16, -2.381199388579614e-18,  3.589486097362780e-20, -5.080831433138680e-22,  6.804392856817933e-24, -8.672413198375666e-26,
  5.535876604882396e-08, -3.616228526434821e-09,  1.431561701048892e-10, -4.296611911317899e-12,  1.070565652694914e-13, -2.321920135714870e-15,  4.512476221649792e-17,
 -8.011961114469591e-19,  1.317710769351499e-20, -2.028302529845395e-22,  2.945300286459874e-24, -4.059540833670617e-26,  7.269953188235068e-09, -5.544068818800229e-10,
  2.495453910648384e-11, -8.409635027783280e-13,  2.332078671465456e-14, -5.592077208911389e-16,  1.195167555735131e-17, -2.323392778416582e-19,  4.168075175352252e-21,
 -6.975116649980224e-23,  1.097959059539176e-24, -1.636153448399015e-26,  8.317067495926737e-10, -7.368045724853773e-11,  3.766521384710856e-12, -1.424408595632378e-13,
  4.395191954053750e-15, -1.165111851304959e-16,  2.738477443359377e-18, -5.828914255082869e-20,  1.140653966181246e-21, -2.075371422244001e-23,  3.541508214327369e-25,
 -5.705970891894277e-27,  8.304808413225492e-11, -8.511243833366332e-12,  4.936840857725867e-13, -2.094599666389563e-14,  7.192062378436610e-16, -2.108138993804520e-17,
  5.450716427586169e-19, -1.270738552527423e-20,  2.713423440908871e-22, -5.369371337690644e-24,  9.935826116485145e-26, -1.731278315093572e-27,  7.262145446234732e-12,
 -8.579946211482600e-13,  5.642899969805914e-14, -2.686068370140335e-15,  1.026655078756414e-16, -3.329172650454412e-18,  9.474181454123132e-20, -2.420559756078327e-21,
  5.643102396688218e-23, -1.215136859403289e-24,  2.439603165470394e-26, -4.599513330039376e-28,  5.591498249449921e-13, -7.592682462537258e-14,  5.659069310814880e-15,
 -3.022841486763678e-16,  1.286807798021420e-17, -4.619467395146661e-19,  1.448024133376222e-20, -4.057471078968973e-22,  1.033539785270474e-23, -2.423553783308496e-25,
  5.282756882323387e-27, -1.078354768722929e-28,  3.822480436859909e-14, -5.949719940013583e-15,  5.023372966303791e-16, -3.012084375646181e-17,  1.429053290263803e-18,
 -5.683973465477782e-20,  1.964265899426737e-21, -6.041937788353631e-23,  1.683064515111709e-24, -4.301423610750808e-26,  1.018783737803966e-27, -2.253267732549437e-29,
  2.349323885809015e-15, -4.180934337849756e-16,  3.997012668589975e-17, -2.691262175950545e-18,  1.424031269164785e-19, -6.280846977902241e-21,  2.395128939309211e-22,
 -8.094763758391615e-24,  2.468171642447794e-25, -6.880962857330237e-27,  1.772289051888272e-28, -4.250289969728471e-30,  1.322142071771007e-16, -2.683033985749695e-17,
  2.902569884861172e-18, -2.194941840908547e-19,  1.295983681574920e-20, -6.343085800680866e-22,  2.671242707163062e-23, -9.927375962229175e-25,  3.315815926048560e-26,
 -1.009129361726601e-27,  2.828420851635640e-29, -7.359440750071384e-31,  6.995643087124464e-18, -1.613685327227752e-18,  1.973295642426297e-19, -1.675430352431943e-20,
  1.103980268982463e-21, -5.997861971937748e-23,  2.790505576888083e-24, -1.140863903073647e-25,  4.175937191697015e-27, -1.387896343603246e-28,  4.234556018621864e-30,
 -1.195734314770264e-31,  3.613039094729495e-19, -9.434209908087384e-20,  1.301420472919304e-20, -1.239188854498266e-21,  9.105656109068155e-23, -5.488613562022790e-24,
  2.820057406259585e-25, -1.267936184981708e-26,  5.084462383068087e-28, -1.844805151249128e-29,  6.124844084511172e-31, -1.876118756575229e-32,  1.918764335092624e-20,
 -5.638711848252431e-21,  8.743156419942660e-22, -9.311196818947113e-23,  7.613131637320371e-24, -5.081616953043221e-25,  2.878406480907339e-26, -1.420919921449105e-27,
  6.232424675456912e-29, -2.464823900723789e-30,  8.890869613236104e-32, -2.949538322080642e-33,  1.123671945672294e-21, -3.685751299376149e-22,  6.384748928091293e-23,
 -7.566107184930448e-24,  6.852295185882489e-25, -5.043651704851576e-26,  3.137212684793041e-27, -1.693989000989026e-28,  8.097736481980636e-30, -3.478408055251481e-31,
  1.358453329422654e-32, -4.864122521227203e-34,  7.928041629652437e-23, -2.868687217718732e-23,  5.497738693597228e-24, -7.186143542184377e-25,  7.150688085451592e-26,
 -5.760009687758158e-27,  3.905990475316242e-28, -2.291070377064565e-29,  1.185647525742399e-30, -5.496018764548419e-32,  2.309306789766162e-33, -8.869864171013581e-35,
  7.440921189334574e-24, -2.922711885768064e-24,  6.106035172326171e-25, -8.683025979928780e-26,  9.370611947003634e-27, -8.159216397155127e-28,  5.961357635906563e-29,
 -3.755625757857404e-30,  2.081315746720912e-31, -1.030258660526113e-32,  4.610400777374802e-34, -1.880953238194947e-35,  1.000860549074575e-24, -4.179124445476637e-25,
  9.322411619674212e-26, -1.413869026926480e-26,  1.623700447265893e-27, -1.500757519346807e-28,  1.161052748191875e-29, -7.726554727261889e-31,  4.512680096935529e-32,
 -2.348983380763158e-33,  1.103065694190588e-34, -4.712559839789144e-36,  1.716248562741095e-25, -7.427071458959924e-26,  1.722502669300561e-26, -2.714659649704596e-27,
  3.235470855451204e-28, -3.099103731037417e-29,  2.481009917274883e-30, -1.706018692066401e-31,  1.028128229061066e-32, -5.514773284042080e-34,  2.665211508863988e-35,
 -1.170339633877884e-36,  6.865407243460074e-02, -1.947184403021841e-04,  5.717565367477180e-07, -1.730611218109896e-09,  5.354528259508184e-12, -1.690574185117799e-14,
  5.357062784680648e-17, -1.740839581737883e-19,  5.435735883549046e-22, -1.886803878819320e-24,  5.004991817075807e-27, -2.509599143026694e-29,  6.005792282766183e-02,
 -1.983781973433594e-04,  8.024938261762153e-07, -3.460014105803107e-09,  1.492865802458805e-11, -6.340456952555644e-14,  2.640480688280467e-16, -1.083362893569576e-18,
  4.364110546587193e-21, -1.748192027523677e-23,  6.825823825203422e-26, -2.719043359389460e-28,  4.595314311703573e-02, -1.949124313097576e-04,  1.108859869947822e-06,
 -6.202486216901687e-09,  3.303949062096253e-11, -1.691877158697127e-13,  8.401725361758456e-16, -4.068981052691087e-18,  1.928978750253034e-20, -8.976246000708992e-23,
  4.108172916251277e-25, -1.852663721753988e-27,  3.074506547305450e-02, -1.740459605260541e-04,  1.293357188290342e-06, -8.748057921569395e-09,  5.518108827860878e-11,
 -3.313734538294810e-13,  1.914889012707426e-15, -1.071337929680044e-17,  5.832156365985290e-20, -3.098393608359936e-22,  1.612141971241013e-24, -8.223217196498950e-27,
  1.797893428722076e-02, -1.362027004067287e-04,  1.247926320383335e-06, -9.937414333684566e-09,  7.304984936116574e-11, -5.067223191704724e-13,  3.355208574603202e-15,
 -2.136568923646121e-17,  1.316266017873831e-19, -7.876641220423223e-22,  4.595788332153755e-24, -2.620085816055040e-26,  9.184054437315610e-03, -9.189082277512297e-05,
  1.003918170536569e-06, -9.299725431234135e-09,  7.880134948825066e-11, -6.242254034954102e-13,  4.684036533490656e-15, -3.359725988116606e-17,  2.319324277023507e-19,
 -1.548546395878523e-21,  1.004098577721812e-23, -6.341239434459214e-26,  4.095285471784085e-03, -5.313952649177919e-05,  6.797766039700232e-07, -7.269391071179283e-09,
  7.038023086016678e-11, -6.311898664803141e-13,  5.324415566195307e-15, -4.269140770887925e-17,  3.278692772343832e-19, -2.425549045629449e-21,  1.736314597669103e-23,
 -1.206821360214186e-25,  1.592789115175185e-03, -2.631038871148756e-05,  3.901622452646343e-07, -4.786938772252677e-09,  5.258233241689272e-11, -5.304139100431037e-13,
  4.999544216971643e-15, -4.455445050490626e-17,  3.786049853749672e-19, -3.087184193577428e-21,  2.427559241878881e-23, -1.847892488937384e-25,  5.398286357490094e-04,
 -1.115956680267505e-05,  1.907164939286429e-07, -2.670466137446851e-09,  3.309815094400144e-11, -3.736598929766773e-13,  3.917181382387847e-15, -3.862851775443325e-17,
  3.616711344525532e-19, -3.237455775908584e-21,  2.785601875849733e-23, -2.313590921607119e-25,  1.592718296106136e-04, -4.059013541350379e-06,  7.964234112468448e-08,
 -1.267017715062248e-09,  1.764331076386427e-11, -2.220628195307089e-13,  2.579807071075756e-15, -2.805497878063033e-17,  2.884781156041050e-19, -2.825920656211076e-21,
  2.652644875873713e-23, -2.396868124362497e-25,  4.086430810199795e-05, -1.267282932184746e-06,  2.847078779199994e-08, -5.127095809236047e-10,  7.995091272916460e-12,
 -1.118532577405671e-13,  1.436032995935112e-15, -1.717637879078754e-17,  1.934830709567932e-19, -2.069201496259838e-21,  2.114076402627703e-23, -2.073526656345927e-25,
  9.107517735928288e-06, -3.399014246205027e-07,  8.724663861759042e-09, -1.773237569341558e-10,  3.088788043596737e-12, -4.792446641889428e-14,  6.785162393779573e-16,
 -8.908552811303396e-18,  1.097246991207788e-19, -1.278757418958120e-21,  1.419530852465535e-23, -1.508762604227579e-25,  1.761370627881577e-06, -7.836571487137774e-08,
  2.294094976376724e-09, -5.250222644420511e-11,  1.019673336610745e-12, -1.751649368388251e-14,  2.730654559184743e-16, -3.929742766975202e-18,  5.285057420262394e-20,
 -6.703239361209338e-22,  8.074725558075900e-24, -9.288685406422729e-26,  2.953175458014360e-07, -1.553873544403042e-08,  5.179936600305650e-10, -1.332587234075070e-11,
  2.881833199446271e-13, -5.474796215385318e-15,  9.387438714935247e-17, -1.479346171897169e-18,  2.170409591431958e-20, -2.993249824463228e-22,  3.909312678195648e-24,
 -4.863111920880435e-26,  4.289470397080552e-08, -2.651278836818831e-09,  1.005134463986766e-10, -2.903220594598779e-12,  6.985132009993659e-14, -1.466492202320980e-15,
  2.764078676208808e-17, -4.767102253161534e-19,  7.625780855234589e-21, -1.142966915541542e-22,  1.617684719085254e-24, -2.175135150348056e-26,  5.395634948516865e-09,
 -3.895522791461262e-10,  1.677772919784532e-11, -5.436868702528620e-13,  1.454713716197373e-14, -3.374104686088496e-16,  6.989125899111639e-18, -1.318948828210858e-19,
  2.300088370503126e-21, -3.746059137339515e-23,  5.744747706750179e-25, -8.347800918068139e-27,  5.879042144899688e-10, -4.934633345756071e-11,  2.412484337001208e-12,
 -8.767727905407336e-14,  2.608710529600401e-15, -6.685180321857029e-17,  1.522048272088624e-18, -3.143428525400115e-20,  5.976944579976901e-22, -1.057939048509138e-23,
  1.758161228109110e-25, -2.761375691235087e-27,  5.554924810508721e-11, -5.399516860603335e-12,  2.994720407436907e-13, -1.220631233897323e-14,  4.039773751807551e-16,
 -1.144264992663721e-17,  2.864783165758544e-19, -6.478025424578283e-21,  1.343633991592450e-22, -2.585890783547154e-24,  4.659037087996610e-26, -7.912261447355757e-28,
  4.562529097333206e-12, -5.119276876913817e-13,  3.219986782083399e-14, -1.472375633218306e-15,  5.423501998453393e-17, -1.699175579581885e-18,  4.681438111229629e-20,
 -1.159937213595970e-21,  2.626378143804090e-23, -5.499760130707623e-25,  1.075008284383315e-26, -1.975278410552147e-28,  3.271636671232991e-13, -4.226004032917595e-14,
  3.014139489324695e-15, -1.547050335806015e-16,  6.347758693769444e-18, -2.201839831741544e-19,  6.682482809750409e-21, -1.816065690125314e-22,  4.493262863940935e-24,
 -1.024735336979457e-25,  2.174941695294168e-27, -4.327495916158940e-29,  2.062693108946586e-14, -3.060341822412204e-15,  2.475160130072668e-16, -1.427054558300399e-17,
  6.529208796669784e-19, -2.510354948134648e-20,  8.402661686996031e-22, -2.507632719926624e-23,  6.787373078976867e-25, -1.687694294276975e-26,  3.893600198497141e-28,
 -8.397230515079987e-30,  1.156189025006989e-15, -1.966233549411131e-16,  1.803456865528654e-17, -1.168942125558385e-18,  5.970436594229029e-20, -2.547622987722426e-21,
  9.416906673542946e-23, -3.090048394323419e-24,  9.161144136409171e-26, -2.486556515046013e-27,  6.242563739651569e-29, -1.460807718053719e-30,  5.859461216580172e-17,
 -1.139771611872379e-17,  1.185539275848927e-18, -8.645093672275042e-20,  4.934418979585839e-21, -2.339598043582429e-22,  9.561950546436661e-24, -3.454217050544831e-25,
  1.123048068766305e-26, -3.331151401525394e-28,  9.110143216448481e-30, -2.315367526791784e-31,  2.752892569291156e-18, -6.109630332258287e-19,  7.203841686025519e-20,
 -5.912197984628003e-21,  3.773887603792275e-22, -1.990038128507785e-23,  9.001503163080950e-25, -3.583270909482067e-26,  1.278767033840125e-27, -4.148656295112872e-29,
  1.236929542759662e-30, -3.416671225658170e-32,  1.243628039410613e-19, -3.138359229760903e-20,  4.189571126172936e-21, -3.868251312678365e-22,  2.761415652815566e-23,
 -1.619796318886158e-24,  8.111262222282362e-26, -3.559170513458881e-27,  1.394596032822559e-28, -4.949809566574906e-30,  1.609195561454349e-31, -4.831339590501398e-33,
  5.691771021071744e-21, -1.625054983883388e-21,  2.449441136298876e-22, -2.539683509570202e-23,  2.024799898316066e-24, -1.319729220540677e-25,  7.309089393727817e-27,
 -3.532010827856611e-28,  1.518163905773589e-29, -5.889592496401649e-31,  2.085813399009911e-32, -6.799757279226522e-34,  2.837312451092099e-22, -9.095903848605577e-23,
  1.539936829928456e-23, -1.785407970043793e-24,  1.583869298767127e-25, -1.143240234198954e-26,  6.980742038153575e-28, -3.703854863348711e-29,  1.741326504386439e-30,
 -7.362543136388661e-32,  2.832393715525138e-33, -9.997549515103729e-35,  1.694170131457804e-23, -6.029841446419229e-24,  1.136224446470802e-24, -1.461243938495614e-25,
  1.431780825802149e-26, -1.136598275095904e-27,  7.601600813449144e-29, -4.400637112393663e-30,  2.249196090099262e-31, -1.030351400689073e-32,  4.280911329771703e-34,
 -1.626798441422858e-35,  1.354811175226151e-24, -5.267427292571221e-25,  1.088726039633412e-25, -1.532236004166554e-26,  1.637297699288035e-27, -1.412311835041391e-28,
  1.022728021127741e-29, -6.388947521757929e-31,  3.512400626015264e-32, -1.725466209345714e-33,  7.665785745491302e-35, -3.106090483138358e-36,  1.593623367636741e-25,
 -6.621705712827182e-26,  1.469380363956558e-26, -2.217130013935831e-27,  2.533711681556726e-28, -2.330944339297090e-29,  1.795324581253910e-30, -1.189712452627778e-31,
  6.920638399640992e-33, -3.588659003934393e-34,  1.679091269834957e-35, -7.148741557424506e-37,  2.509330540059761e-26, -1.084283711967841e-26,  2.510559618082234e-27,
 -3.950198128194423e-28,  4.700625614586323e-29, -4.495669963805798e-30,  3.593792021095484e-31, -2.467742181790567e-32,  1.485180653122973e-33, -7.956076730490938e-35,
  3.840293429774055e-36, -1.684335103773972e-37,  6.788421727434897e-02, -1.902260261659494e-04,  5.514923008911507e-07, -1.647575451262439e-09,  5.028885447578883e-12,
 -1.567663486544926e-14,  4.892984955539713e-17, -1.577399269960636e-19,  4.789854576607870e-22, -1.708790744837392e-24,  3.889384457734488e-27, -2.597251805113202e-29,
  5.927699258673393e-02, -1.921203610040523e-04,  7.623660488872253e-07, -3.230966026822029e-09,  1.372156025916383e-11, -5.741620842518563e-14,  2.355780426108601e-16,
 -9.532765726219137e-19,  3.781147526291860e-21, -1.497745201145935e-23,  5.727902807919032e-26, -2.287912449938460e-28,  4.519077611761334e-02, -1.863305351818728e-04,
  1.037493608538269e-06, -5.699866335457502e-09,  2.984849748086034e-11, -1.503238770565216e-13,  7.344188180325568e-16, -3.500392266850174e-18,  1.633549410454986e-20,
 -7.485010740697713e-23,  3.373749920526673e-25, -1.498856560674002e-27,  3.006893103886251e-02, -1.641044885000579e-04,  1.193466989895622e-06, -7.915781571412762e-09,
  4.898994236440749e-11, -2.888148006277769e-13,  1.639450400582867e-15, -9.013785308918613e-18,  4.824593326084436e-20, -2.520427735917751e-22,  1.290412896594295e-24,
 -6.474089581107681e-27,  1.745336213351683e-02, -1.266771589414290e-04,  1.135369333729660e-06, -8.845512284772264e-09,  6.367454875312002e-11, -4.329252091916632e-13,
  2.811915629991556e-15, -1.757399005933659e-17,  1.063196128037413e-19, -6.249615978541807e-22,  3.583849915266820e-24, -2.008113707070414e-26,  8.831876114703647e-03,
 -8.428534093279558e-05,  8.994933525204626e-07, -8.132977311163248e-09,  6.736893704251153e-11, -5.223074070875035e-13,  3.839360848593553e-15, -2.699501248419798e-17,
  1.827890950367253e-19, -1.197594866885697e-21,  7.623878874347315e-24, -4.728256343070875e-26,  3.893077133324218e-03, -4.803201724337811e-05,  5.989052569921873e-07,
 -6.237740798682721e-09,  5.894327065450072e-11, -5.166387666716382e-13,  4.263713250327232e-15, -3.347239843024990e-17,  2.518693713607063e-19, -1.826617494202674e-21,
  1.282490474800335e-23, -8.746355118050084e-26,  1.493445528474410e-03, -2.340532729918824e-05,  3.374368264029099e-07, -4.024369053716728e-09,  4.307955812221115e-11,
 -4.241224739250737e-13,  3.906176179959014e-15, -3.404472108572331e-17,  2.831483716638972e-19, -2.261167355174272e-21,  1.742319658753409e-23, -1.300256503561019e-25,
  4.980508775766911e-04, -9.753551040211414e-06,  1.616173023856990e-07, -2.195918822703083e-09,  2.648379555478649e-11, -2.914193867031197e-13,  2.981515592340619e-15,
 -2.872320988644591e-17,  2.629465737705335e-19, -2.303002121271769e-21,  1.940066154719115e-23, -1.578433333063954e-25,  1.442201155752997e-04, -3.478209615250152e-06,
  6.599553494383610e-08, -1.017140177512743e-09,  1.376259667073581e-11, -1.686179457211010e-13,  1.909560662198771e-15, -2.026561080792778e-17,  2.035490618352774e-19,
 -1.949231146268511e-21,  1.789888927658487e-23, -1.583053934100902e-25,  3.621460340384518e-05, -1.062110639385647e-06,  2.301762593100893e-08, -4.009638141620880e-10,
  6.067061652629669e-12, -8.252350238117939e-14,  1.031644106576173e-15, -1.202988945829739e-17,  1.322439240566947e-19, -1.381370326998433e-21,  1.379512163357003e-23,
 -1.323419800676153e-25,  7.875126867840679e-06, -2.778429943546948e-07,  6.864322674200879e-09, -1.347644575417101e-10,  2.274821344894795e-12, -3.427550351522895e-14,
  4.720248323704532e-16, -6.036127720757593e-18,  7.248942562540103e-20, -8.244784041709585e-22,  8.939348592154078e-24, -9.286700011875838e-26,  1.480982273536138e-06,
 -6.228019514238603e-08,  1.751454916537747e-09, -3.866825274356374e-11,  7.268670895905721e-13, -1.211246067895065e-14,  1.834839798747210e-16, -2.569498221506164e-18,
  3.366601420744542e-20, -4.164042479837409e-22,  4.895771382363738e-24, -5.501022250702538e-26,  2.405383501075499e-07, -1.196363315743646e-08,  3.824966104906988e-10,
 -9.481283493351625e-12,  1.982290663001037e-13, -3.649362253660988e-15,  6.074931406593192e-17, -9.307885411287385e-19,  1.329369162562391e-20, -1.786600951859792e-22,
  2.275960431282142e-24, -2.763845362644491e-26,  3.370131278203379e-08, -1.969541863547877e-09,  7.151809183289107e-11, -1.988281465200833e-12,  4.620195151784886e-14,
 -9.391109511532366e-16,  1.716992787521962e-17, -2.876913736660147e-19,  4.476877074395975e-21, -6.534715702825905e-23,  9.015948683057273e-25, -1.182784304635100e-26,
  4.069526877574592e-09, -2.779299232557701e-10,  1.145374051103580e-11, -3.569250666078617e-13,  9.215401656132127e-15, -2.067746800435341e-16,  4.151664126924502e-18,
 -7.606571064003926e-20,  1.289605843571944e-21, -2.044306396422486e-23,  3.054536678260157e-25, -4.328599954194353e-27,  4.233375336346062e-10, -3.363546094589254e-11,
  1.572367120703652e-12, -5.491389203540621e-14,  1.575508945656507e-15, -3.903198857781523e-17,  8.608539119910716e-19, -1.725131900523752e-20,  3.187336239781101e-22,
 -5.488679515946758e-24,  8.883591782355857e-26, -1.360176802715089e-27,  3.794997197657802e-11, -3.495001615012629e-12,  1.852864197025789e-13, -7.253847751509585e-15,
  2.313749064047365e-16, -6.332593621445923e-18,  1.535106358592099e-19, -3.366844594793172e-21,  6.783062865333850e-23, -1.269598430098672e-24,  2.227129335195757e-26,
 -3.686191260054724e-28,  2.935976940778706e-12, -3.124856025978908e-13,  1.878769277897017e-14, -8.249796112636053e-16,  2.927899790659763e-17, -8.860998509521800e-19,
  2.363165991549699e-20, -5.677715003489084e-22,  1.248432503453658e-23, -2.542036542872032e-25,  4.837005157220537e-27, -8.661038581967779e-29,  1.966505496979643e-13,
 -2.413177301421255e-14,  1.645864408019458e-15, -8.113137011312408e-17,  3.207418725405148e-18, -1.074659257179246e-19,  3.156984519281200e-21, -8.319051118515486e-23,
  1.998777552641417e-24, -4.432476337080986e-26,  9.158449549714266e-28, -1.775878431555574e-29,  1.146938239674597e-14, -1.619672058922291e-15,  1.253710211776143e-16,
 -6.945503564813804e-18,  3.062832265723288e-19, -1.137797988600731e-20,  3.687233306529891e-22, -1.067224016875186e-23,  2.805792599907831e-25, -6.785566531998799e-27,
  1.524390291432519e-28, -3.204826489795970e-30,  5.880820710732561e-16, -9.541609220336935e-17,  8.387178239290399e-18, -5.228647092613912e-19,  2.575929772786023e-20,
 -1.062714991381606e-21,  3.805437917908070e-23, -1.211760885321797e-24,  3.491437422881052e-26, -9.222100191939000e-28,  2.255724183511474e-29, -5.148517453836499e-31,
  2.691323654584651e-17, -5.009280622899903e-18,  5.003157646681611e-19, -3.514345235102518e-20,  1.937314450794524e-21, -8.891096100014025e-23,  3.523973994893185e-24,
 -1.236583200514466e-25,  3.911025721578432e-27, -1.129974174178899e-28,  3.013621590794965e-30, -7.477289981942621e-32,  1.125246956984429e-18, -2.398222155806979e-19,
  2.722477528598879e-20, -2.156997871389750e-21,  1.332334236554953e-22, -6.812260914677882e-24,  2.993082334266732e-25, -1.159133953281680e-26,  4.029937035659218e-28,
 -1.275289304730105e-29,  3.713056143114837e-31, -1.002615425137488e-32,  4.451775642187672e-20, -1.083604109284339e-20,  1.397587514363177e-21, -1.249479232929257e-22,
  8.654398812165054e-24, -4.934488110835083e-25,  2.405711466870947e-26, -1.029198593944648e-27,  3.936890572089575e-29, -1.365697388067313e-30,  4.344079178919920e-32,
 -1.277365218179847e-33,  1.755118428028408e-21, -4.858888951592741e-22,  7.107249335540440e-23, -7.163516327202365e-24,  5.561271751858464e-25, -3.535030281237026e-26,
  1.912029136205861e-27, -9.034935079024656e-29,  3.801824384045827e-30, -1.445387123093422e-31,  5.021315114844654e-33, -1.607221639674547e-34,  7.426217404608317e-23,
 -2.322549058451116e-23,  3.836514226306502e-24, -4.345293313187263e-25,  3.770659313966930e-26, -2.665571190237794e-27,  1.595901723181831e-28, -8.311248002079348e-30,
  3.839005384630560e-31, -1.596164447370221e-32,  6.043242579867300e-34, -2.100959098184881e-35,  3.730681368664759e-24, -1.304087748309799e-24,  2.412634997997970e-25,
 -3.048691290894296e-26,  2.937852456082359e-27, -2.295704941351839e-28,  1.512655724006758e-29, -8.634180500069187e-31,  4.354345462443089e-32, -1.969550241874887e-33,
  8.084979923646226e-35, -3.037410547651193e-36,  2.519810223081379e-25, -9.686942591252609e-26,  1.978767498190427e-26, -2.753377756228734e-27,  2.910523277128321e-28,
 -2.484977368218736e-29,  1.782117488324516e-30, -1.103093476924545e-31,  6.011766226793058e-33, -2.928963149019581e-34,  1.291085183547859e-35, -5.192542460626486e-37,
  2.566389794634018e-26, -1.060581587707762e-26,  2.339844203270097e-27, -3.510657288657228e-28,  3.990309091301988e-29, -3.652147136906064e-30,  2.799234619977699e-31,
 -1.846401593666178e-32,  1.069350357594255e-33, -5.521937364979625e-35,  2.573408797334913e-36, -1.091509907811279e-37,  3.682472010983677e-27, -1.588579028507492e-27,
  3.671590913433312e-28, -5.766738868110705e-29,  6.850463226069529e-30, -6.540946155214165e-31,  5.220479644540115e-32, -3.579292985392739e-33,  2.151018929692605e-34,
 -1.150687864313085e-35,  5.546785416549681e-37, -2.429678585455311e-38,  6.713201373095441e-02, -1.858918269449217e-04,  5.321940245499560e-07, -1.569559212396905e-09,
  4.726746873811949e-12, -1.455364290403047e-14,  4.471867001898519e-17, -1.433689099825757e-19,  4.199868436499181e-22, -1.576894973611053e-24,  2.679114780024032e-27,
 -2.960973249744147e-29,  5.852046860255924e-02, -1.861728720387494e-04,  7.248748025162413e-07, -3.020309297691474e-09,  1.262768139358901e-11, -5.206944657749792e-14,
  2.105022364782279e-16, -8.404837153906323e-19,  3.280871463410671e-21, -1.287705765553211e-23,  4.798593104138233e-26, -1.951122486100866e-28,  4.446163185299596e-02,
 -1.782962835378852e-04,  9.718644681354476e-07, -5.245416805963117e-09,  2.701063660769791e-11, -1.338172878691359e-13,  6.433388954964327e-16, -3.018289236940393e-18,
  1.386871365747443e-20, -6.258636583376467e-23,  2.778671085237885e-25, -1.216464133175175e-27,  2.943102520764570e-02, -1.549238103547134e-04,  1.102996725637377e-06,
 -7.176097794888600e-09,  4.358753847964833e-11, -2.523302066827875e-13,  1.407382459794561e-15, -7.605661350462811e-18,  4.003675428731368e-20, -2.056985046657266e-22,
  1.036691598276205e-24, -5.114599997303161e-27,  1.696417076063014e-02, -1.180021044111900e-04,  1.035061648840070e-06, -7.892481444718302e-09,  5.565294866434078e-11,
 -3.709794836974612e-13,  2.364280487624753e-15, -1.450571230136969e-17,  8.620184813857436e-20, -4.978239826633344e-22,  2.806667394980909e-24, -1.545682228092171e-26,
  8.508533400778378e-03, -7.746221528219273e-05,  8.080358626729307e-07, -7.133882568348025e-09,  5.778626508246259e-11, -4.386099345608966e-13,  3.159305816433044e-15,
 -2.178055914762923e-17,  1.446981436038047e-19, -9.304961021195796e-22,  5.817213158764699e-24, -3.543507611354556e-26,  3.710079122683265e-03, -4.352490486299735e-05,
  5.293871168595618e-07, -5.372053805224210e-09,  4.956233251475506e-11, -4.247030134345429e-13,  3.430102499372264e-15, -2.637276540277584e-17,  1.944874914372556e-19,
 -1.383032549764706e-21,  9.526646407439896e-24, -6.376194220971717e-26,  1.404933088870950e-03, -2.088789787325385e-05,  2.930157709545382e-07, -3.398168669241025e-09,
  3.546236646097715e-11, -3.408600769860745e-13,  3.068434889587260e-15, -2.616233996736631e-17,  2.130249709366041e-19, -1.666489755627945e-21,  1.258624961730484e-23,
 -9.210671559894028e-26,  4.614652764388657e-04, -8.559232121644933e-06,  1.376282700047333e-07, -1.815174569121778e-09,  2.131043465760621e-11, -2.286347664729167e-13,
  2.283595938523016e-15, -2.149827653404678e-17,  1.924810964845854e-19, -1.649928200827702e-21,  1.361143555420088e-23, -1.085070995543508e-25,  1.312908692184162e-04,
 -2.995565666200748e-06,  5.500734324334219e-08, -8.216079059299239e-10,  1.080611565259622e-11, -1.289219180480469e-13,  1.423675819696819e-15, -1.474917878348208e-17,
  1.447451066107824e-19, -1.355371206667244e-21,  1.217790343284798e-23, -1.054504967498435e-25,  3.230614434165673e-05, -8.956828854576987e-07,  1.873809680899071e-08,
 -3.158557986693367e-10,  4.639191797866452e-12, -6.137029905295397e-14,  7.472745668013993e-16, -8.497687485625000e-18,  9.118736601804446e-20, -9.305803372496670e-22,
  9.085972212027154e-24, -8.527575365530869e-26,  6.864151508766584e-06, -2.288267225768396e-07,  5.444757653616021e-09, -1.032889527496895e-10,  1.690153986933644e-12,
 -2.473806715677645e-14,  3.314757530747329e-16, -4.129624983175836e-18,  4.836791444007982e-20, -5.370166556032128e-22,  5.688312010184307e-24, -5.777128575307116e-26,
  1.257202647987775e-06, -4.994389368500070e-08,  1.349934009066157e-09, -2.875954634868402e-11,  5.234013505326408e-13, -8.463068864370206e-15,  1.246111429934930e-16,
 -1.698515399052907e-18,  2.168570960818985e-20, -2.616268358205449e-22,  3.002910230627290e-24, -3.296447719764098e-26,  1.981525909075745e-07, -9.309916664684528e-09,
  2.855769406963318e-10, -6.822365937488796e-12,  1.379359534093783e-13, -2.461422696371410e-15,  3.978861832242838e-17, -5.928602639524151e-19,  8.244429892748551e-21,
 -1.079962602314311e-22,  1.342164543176152e-24, -1.591347754676889e-26,  2.683235293772155e-08, -1.481562197737835e-09,  5.153997565551213e-11, -1.379391561500269e-12,
  3.096330220866426e-14, -6.094565316323355e-16,  1.081084150719686e-17, -1.760159536773614e-19,  2.664980358505481e-21, -3.788943890811536e-23,  5.096749127352383e-25,
 -6.524547295154077e-27,  3.117105361273293e-09, -2.012082200705356e-10,  7.934589488759538e-12, -2.377970163776177e-13,  5.925284680131688e-15, -1.286337046166710e-16,
  2.503804475764837e-18, -4.454374658390154e-20,  7.342790554919969e-22, -1.133079316299595e-23,  1.649720165743693e-25, -2.280116635166123e-27,  3.103151676875996e-10,
 -2.331662642895020e-11,  1.042120927367153e-12, -3.497392912840295e-14,  9.676106396109995e-16, -2.317607060005452e-17,  4.951904870263885e-19, -9.629714969055905e-21,
  1.728933798861814e-22, -2.896705302820501e-24,  4.566385706419587e-26, -6.816183541267853e-28,  2.646087681452836e-11, -2.306428893598212e-12,  1.168431299477105e-13,
 -4.393012104714389e-15,  1.350380862087330e-16, -3.571111417072155e-18,  8.381958713936414e-20, -1.783039120800617e-21,  3.489203738325323e-23, -6.351500047664123e-25,
  1.084789778618115e-26, -1.749852430546453e-28,  1.933629560399533e-12, -1.949897349713779e-13,  1.120068934519416e-14, -4.721654485930051e-16,  1.614264603382305e-17,
 -4.718527340053961e-19,  1.217974289695250e-20, -2.837254330905874e-22,  6.057858257340115e-24, -1.199302864723232e-25,  2.221335156989414e-27, -3.875681501957047e-29,
  1.213370479971823e-13, -1.412681041237988e-14,  9.207201157948867e-16, -4.356912208290802e-17,  1.659008804973340e-18, -5.367770161404766e-20,  1.525958530819357e-21,
 -3.898166972762582e-23,  9.093426475849448e-25, -1.960480549518694e-26,  3.942774078758964e-28, -7.449402664094974e-30,  6.566981293496963e-15, -8.813889193140807e-16,
  6.523695669293964e-17, -3.470505664173208e-18,  1.474320241347778e-19, -5.289515759497310e-21,  1.658985286182419e-22, -4.655415468684507e-24,  1.188460290322401e-25,
 -2.794639825509775e-27,  6.111763273405816e-29, -1.252220684916984e-30,  3.089825839784154e-16, -4.775182022528617e-17,  4.018243013490763e-18, -2.407314224167745e-19,
  1.143166174619205e-20, -4.557084260538380e-22,  1.580006882973754e-23, -4.879959555797278e-25,  1.365876136366842e-26, -3.509379831585368e-28,  8.359951297629592e-30,
 -1.860367933311761e-31,  1.280755626515772e-17, -2.276936777297117e-18,  2.180857758421572e-19, -1.474077915954315e-20,  7.841158176742242e-22, -3.480539602279034e-23,
  1.336875255292040e-24, -4.553958277916715e-26,  1.400279032972210e-27, -3.938487642993462e-29,  1.023780953741671e-30, -2.478572705127152e-32,  4.777664869889008e-19,
 -9.759689447389628e-20,  1.065088827778061e-20, -8.136323499060047e-22,  4.857835531689262e-23, -2.406053531542411e-24,  1.025943936980148e-25, -3.862212587622427e-27,
  1.307148671661691e-28, -4.032004661553204e-30,  1.145610222909106e-31, -3.022081267705154e-33,  1.658116715063348e-20, -3.885029535278117e-21,  4.833024121567790e-22,
 -4.177817986668035e-23,  2.804112583516104e-24, -1.552310463692718e-25,  7.360327810654346e-27, -3.067086871652282e-28,  1.144303077846261e-29, -3.876443507485295e-31,
  1.205453050689790e-32, -3.468923347570005e-34,  5.631909006686832e-22, -1.508693141924842e-22,  2.137765256217083e-23, -2.091297468071459e-24,  1.578689858456663e-25,
 -9.774048935764759e-27,  5.156864265910463e-28, -2.380192343328892e-29,  9.795013966131785e-31, -3.645906932433630e-32,  1.241333894640908e-33, -3.897759794957830e-35,
  2.017985424779952e-23, -6.145037635354653e-24,  9.886570986691020e-25, -1.092155650864462e-25,  9.256986920822358e-27, -6.400584945708121e-28,  3.752781215587712e-29,
 -1.916128625472373e-30,  8.686398026768669e-32, -3.547930561771637e-33,  1.320763230774841e-34, -4.518500277324328e-36,  8.482131534168125e-25, -2.907165956327839e-25,
  5.272282202597195e-26, -6.536655082852255e-27,  6.186664462933700e-28, -4.752959138347623e-29,  3.081900609043608e-30, -1.732642793875719e-31,  8.613311446403176e-33,
 -3.843236908879462e-34,  1.557368423945678e-35, -5.779457394471851e-37,  4.796068865964037e-26, -1.820906893471482e-26,  3.671767196385011e-27, -5.045846617794849e-28,
  5.271089069003258e-29, -4.450302021793826e-30,  3.157954652375756e-31, -1.935231756816915e-32,  1.044734069485519e-33, -5.044480667140596e-35,  2.204739512927193e-36,
 -8.795846846442080e-38,  4.184907015928807e-27, -1.719004291641216e-27,  3.768109353416595e-28, -5.618346676140614e-29,  6.347962859907873e-30, -5.777171414801057e-31,
  4.404269021975786e-32, -2.890349941315805e-33,  1.665900346396198e-34, -8.563139325908609e-36,  3.973413064583177e-37, -1.678398105725780e-38,  5.425976207612936e-28,
 -2.336465667488359e-28,  5.389471104773292e-29, -8.448429634140611e-30,  1.001725444364657e-30, -9.547409889822874e-32,  7.606854048231916e-33, -5.206838127671554e-34,
  3.124166875244185e-35, -1.668745466705571e-36,  8.032381121524519e-38, -3.513581719620360e-39,  6.639684402744178e-02, -1.817083496649156e-04,  5.138036615234335e-07,
 -1.496202870349223e-09,  4.446088964457964e-12, -1.352709988438714e-14,  4.088409264717319e-17, -1.308196001464345e-19,  3.648161168881661e-22, -1.497783680960196e-24,
  1.217023759470360e-27, -3.782073865429787e-29,  5.778715031461942e-02, -1.805154911366299e-04,  6.898098503238666e-07, -2.826330805253507e-09,  1.163496632390178e-11,
 -4.728834730381690e-14,  1.883713785228875e-16, -7.425588676952445e-19,  2.849851598031441e-21, -1.112139523958448e-23,  3.997701256997305e-26, -1.704337743280357e-28,
  4.376360800926798e-02, -1.707659989973233e-04,  9.114268092352372e-07, -4.833846330178625e-09,  2.448209732051734e-11, -1.193431579843466e-13,  5.647159716969180e-16,
 -2.608495432681328e-18,  1.180341519028783e-20, -5.247197960354057e-23,  2.294974264608726e-25, -9.903902345854644e-28,  2.882844877694320e-02, -1.464328054010640e-04,
  1.020907170885745e-06, -6.517304671723066e-09,  3.886217667575452e-11, -2.209703237005231e-13,  1.211301777482424e-15, -6.435384254927466e-18,  3.332684417909070e-20,
 -1.684001739414271e-22,  8.359511382538570e-25, -4.052685815393374e-27,  1.650814415248835e-02, -1.100858572499459e-04,  9.454593305661199e-07, -7.058440652878398e-09,
  4.876943074003547e-11, -3.188147820802033e-13,  1.994191855306026e-15, -1.201359511872465e-17,  7.014725907918906e-20, -3.980556350835230e-22,  2.207295439531678e-24,
 -1.194499601120232e-26,  8.211092281833539e-03, -7.132527779398378e-05,  7.277000709222475e-07, -6.275558500419530e-09,  4.972547986626892e-11, -3.696110531271695e-13,
  2.609542437921970e-15, -1.764415559158747e-17,  1.150384783279467e-19, -7.262228876331133e-22,  4.460075186802555e-24, -2.668573773545516e-26,  3.544059636987761e-03,
 -3.953480324214515e-05,  4.694139830966317e-07, -4.642775094018705e-09,  4.183513192945865e-11, -3.505820412871792e-13,  2.771804700127228e-15, -2.087740183545596e-17,
  1.509314552789492e-19, -1.052660150101551e-21,  7.115670518983496e-24, -4.674766837120997e-26,  1.325824454662329e-03, -1.869773133221778e-05,  2.554294788653585e-07,
 -2.881543063319845e-09,  2.932601093117054e-11, -2.752900343162641e-13,  2.422954929412006e-15, -2.021567905832257e-17,  1.611951758532982e-19, -1.235620645410462e-21,
  9.149338734878006e-24, -6.567064003681003e-26,  4.293001952173611e-04, -7.539867048489277e-06,  1.177501933338649e-07, -1.508004177408768e-09,  1.724042142527491e-11,
 -1.804072183725400e-13,  1.759644688905281e-15, -1.619283459227411e-17,  1.418331177542965e-19, -1.190189158298035e-21,  9.617923659323756e-24, -7.514144298300673e-26,
  1.201301874203173e-04, -2.592189396985298e-06,  4.610599843148144e-08, -6.676126308336128e-10,  8.538433584030258e-12, -9.922795969857184e-14,  1.068830506741119e-15,
 -1.081239590515205e-17,  1.037061047582200e-19, -9.497969009632609e-22,  8.352266621241933e-24, -7.082516939301812e-26,  2.900088328399206e-05, -7.597646599441847e-07,
  1.535563414871223e-08, -2.505488705866205e-10,  3.573440291075117e-12, -4.598981633380555e-14,  5.456155400509205e-16, -6.052296775004216e-18,  6.341487830123106e-20,
 -6.324194959604424e-22,  6.038509290958615e-24, -5.545807241299792e-26,  6.028713538408386e-06, -1.898017859479493e-07,  4.352517717716514e-09, -7.980871700381926e-11,
  1.266414276975629e-12, -1.801171285439336e-14,  2.348952150515971e-16, -2.851791798007432e-18,  3.258423607038761e-20, -3.532396343424359e-22,  3.656236073181766e-24,
 -3.631034323253119e-26,  1.077025556359182e-06, -4.039439774153118e-08,  1.049965701118566e-09, -2.159158574760612e-11,  3.805655540004431e-13, -5.972626199195945e-15,
  8.550216952676178e-17, -1.134655359214368e-18,  1.411997426618215e-20, -1.661982388948715e-22,  1.862659971311722e-24, -1.998051000495222e-26,  1.650120830797094e-07,
 -7.318686390119798e-09,  2.154797052391671e-10, -4.962484256739537e-12,  9.705223594444019e-14, -1.679138280812985e-15,  2.636419112954533e-17, -3.821133890818284e-19,
  5.174979460993628e-21, -6.608629491067613e-23,  8.014040788820431e-25, -9.278957899696356e-27,  2.163668456244478e-08, -1.127873620936635e-09,  3.759898381023553e-11,
 -9.689115950644834e-13,  2.101449508674072e-14, -4.006335610858546e-16,  6.896351945368539e-18, -1.091267501191889e-19,  1.607854974642354e-21, -2.226991978695177e-23,
  2.921152610174146e-25, -3.649553798278223e-27,  2.423195233289252e-09, -1.477103213184441e-10,  5.574477068882533e-12, -1.606895958990342e-13,  3.864772679666054e-15,
 -8.118974558518846e-17,  1.532271293840672e-18, -2.647321441543613e-20,  4.243740228642386e-22, -6.375519060324559e-24,  9.046269445953381e-26, -1.219579746579797e-27,
  2.313944753164865e-10, -1.642666328265015e-11,  7.018940021251949e-13, -2.263614977186051e-14,  6.039585207875674e-16, -1.398696790732699e-17,  2.895476023852426e-19,
 -5.464482982464786e-21,  9.534790930032533e-23, -1.554383976002428e-24,  2.386747309035326e-26, -3.473489887790053e-28,  1.881628225317564e-11, -1.550611957387287e-12,
  7.504630901686766e-14, -2.709428285118486e-15,  8.026084728804531e-17, -2.050841420490922e-18,  4.660850753688275e-20, -9.616554387591450e-22,  1.827915885474763e-23,
 -3.236110827405901e-25,  5.381323905603210e-27, -8.460041342627723e-29,  1.302365607301768e-12, -1.242833615183303e-13,  6.817890372696774e-15, -2.758497957948925e-16,
  9.083513922206960e-18, -2.564152980254928e-19,  6.405595676357847e-21, -1.446672611384448e-22,  2.999116714096328e-24, -5.772586504032814e-26,  1.040688336857629e-27,
 -1.769168215616530e-29,  7.679385817767502e-14, -8.471407361222378e-15,  5.272859949316311e-16, -2.394290740170049e-17,  8.778514731253732e-19, -2.742168993350989e-20,
  7.542303429314138e-22, -1.867505189877112e-23,  4.228978155695569e-25, -8.862525356845475e-27,  1.734591498906446e-28, -3.192881364117874e-30,  3.869007443010941e-15,
 -4.928029126392514e-16,  3.484925368036176e-17, -1.779215822532396e-18,  7.277920687141412e-20, -2.520850355208245e-21,  7.649266998321841e-23, -2.080491987504204e-24,
  5.155821964068482e-26, -1.178517940896571e-27,  2.508413605595926e-29, -5.007427020450680e-31,  1.675923761425601e-16, -2.463030455721140e-17,  1.982036873901154e-18,
 -1.140216582914672e-19,  5.215735469235236e-21, -2.007927997544727e-22,  6.737384462642700e-24, -2.017437122370652e-25,  5.483066570318697e-27, -1.369832405906546e-28,
  3.176857189929831e-30, -6.890291995852304e-32,  6.312256344322554e-18, -1.069939885944015e-18,  9.814994651279000e-20, -6.377315215958307e-21,  3.270645217929535e-22,
 -1.403101998974908e-23,  5.219293730629233e-25, -1.724857229609207e-26,  5.153370803822232e-28, -1.410303635343884e-29,  3.571319804836400e-31, -8.432439185826725e-33,
  2.106968140726998e-19, -4.117199692226230e-20,  4.312986212848085e-21, -3.172801011832117e-22,  1.829144336416573e-23, -8.767711837262899e-25,  3.625146158760892e-26,
 -1.325547494673934e-27,  4.364067946934672e-29, -1.311219935887002e-30,  3.633313126945882e-32, -9.357722299060639e-34,  6.428343134763907e-21, -1.446799296699685e-21,
  1.733065046139257e-22, -1.446440317295240e-23,  9.395820544307318e-25, -5.044312226046708e-26,  2.323737765963283e-27, -9.422655294141814e-29,  3.425795389638282e-30,
 -1.132350955310799e-31,  3.439755905660899e-33, -9.679937971551404e-35,  1.882387211009100e-22, -4.868905742608153e-23,  6.670983191731781e-24, -6.323836301015269e-25,
  4.635243060463999e-26, -2.791542337963427e-27,  1.434983744669512e-28, -6.462331360406706e-30,  2.598128181079265e-31, -9.459093246636413e-33,  3.153452969972942e-34,
 -9.705240607133910e-36,  5.702148415175432e-24, -1.687127183772626e-24,  2.638831467549172e-25, -2.838468833338730e-26,  2.346393572614881e-27, -1.584631440079703e-28,
  9.087127365622860e-30, -4.543559051950087e-31,  2.019273145316427e-32, -8.093908350079532e-34,  2.959672084191167e-35, -9.954897355121525e-37,  1.995165737274609e-25,
 -6.692679408809890e-26,  1.187779971824594e-26, -1.442626058346946e-27,  1.339124432022745e-28, -1.010137030578326e-29,  6.437811205215679e-31, -3.560804897176999e-32,
  1.743057798931930e-33, -7.664682351979358e-35,  3.063159655728352e-36, -1.121914474570041e-37,  9.360214730300840e-27, -3.505057425750733e-27,  6.967842323316846e-28,
 -9.445391664980111e-29,  9.740048301630420e-30, -8.123397783509976e-31,  5.698214856587293e-32, -3.454048845953503e-33,  1.845534277136375e-34, -8.824567972523771e-36,
  3.821356526671969e-37, -1.511252066039094e-38,  6.918897836339376e-28, -2.822881061275524e-28,  6.143718055632737e-29, -9.097143261032687e-30,  1.021088629184675e-30,
 -9.234799038622092e-32,  6.998669087509361e-33, -4.567306049893017e-34,  2.618525919376652e-35, -1.339246892378830e-36,  6.184785562828221e-38, -2.600759279995415e-39,
  8.030579077265707e-29, -3.451103435749418e-29,  7.943259126714494e-30, -1.242506110141957e-30,  1.470195825527874e-31, -1.398472894226319e-32,  1.112125330239417e-33,
 -7.598708231541914e-35,  4.551474079914893e-36, -2.427131534374453e-37,  1.166444802816686e-38, -5.094691662032949e-40,  6.567811945656710e-02, -1.776685489952172e-04,
  4.962672930811811e-07, -1.427177692347125e-09,  4.185069057366708e-12, -1.258856744248458e-14,  3.737652248885580e-17, -1.200022948966104e-19,  3.113357367659600e-22,
 -1.486402788630974e-24, -7.649157745087599e-28, -5.396720171245877e-29,  5.707591488156649e-02, -1.751295818186160e-04,  6.569804039201435e-07, -2.647498731754792e-09,
  1.073277611236660e-11, -4.300698820066666e-14,  1.687983917353284e-16, -6.574752630170280e-19,  2.476505811094419e-21, -9.667139593311711e-24,  3.284473866778337e-26,
 -1.555097266687651e-28,  4.309476863774699e-02, -1.637001267543903e-04,  8.556944874406251e-07, -4.460515375441762e-09,  2.222506332596222e-11, -1.066254321112262e-13,
  4.966942060099528e-16, -2.259320095792680e-18,  1.006967798309624e-20, -4.410731568505396e-23,  1.900564629239144e-25, -8.089152335571833e-28,  2.825857124773573e-02,
 -1.385681340545071e-04,  9.462893975809258e-07, -5.929344725471855e-09,  3.471948703155554e-11, -1.939462395572627e-13,  1.045174131707172e-15, -5.459803130363795e-18,
  2.782574317031199e-20, -1.382683608883118e-22,  6.767124950329076e-25, -3.218005582808508e-27,  1.608240974045567e-02, -1.028481907251167e-04,  8.652376119224606e-07,
 -6.326649669702482e-09,  4.284575117357694e-11, -2.747497492118966e-13,  1.687198676314226e-15, -9.982099168612086e-18,  5.728760322621268e-20, -3.194338383471586e-22,
  1.743300966692754e-24, -9.263444597438893e-27,  7.936975810097235e-03, -6.579191920943633e-05,  6.569336528011365e-07, -5.535846533858546e-09,  4.292158367921765e-11,
 -3.125174723431158e-13,  2.163345803079788e-15, -1.434896791111967e-17,  9.184167908804863e-20, -5.692509496323414e-22,  3.435770319720722e-24, -2.018896394701247e-26,
  3.393093587389102e-03, -3.599147577634484e-05,  4.174966582223510e-07, -4.026081040203794e-09,  3.544405314693144e-11, -2.905609142078962e-13,  2.249527273674980e-15,
 -1.660277815719447e-17,  1.176993676552981e-19, -8.052647356881500e-22,  5.343433123327934e-24, -3.446085525496589e-26,  1.254912137970869e-03, -1.678503172157755e-05,
  2.234943005873580e-07, -2.453396229879956e-09,  2.435871703398270e-11, -2.233874119339336e-13,  1.922916827092814e-15, -1.570380486340385e-17,  1.226589349979168e-19,
 -9.214995603239521e-22,  6.691572247271188e-24, -4.711675263999405e-26,  4.009163984734108e-04, -6.665820348516439e-06,  1.011971875847924e-07, -1.258873423730065e-09,
  1.402035818601792e-11, -1.431407572199606e-13,  1.363839402910464e-15, -1.227148911350496e-17,  1.051822855414177e-19, -8.642721404008186e-22,  6.843111747560488e-24,
 -5.240704775071180e-26,  1.104514779675005e-04, -2.253206618220717e-06,  3.885309492185734e-08, -5.455769824839147e-10,  6.787683122475158e-12, -7.686342238443988e-14,
  8.078301306876204e-16, -7.982041340947094e-18,  7.484487662673554e-20, -6.706114162077179e-22,  5.773139523050206e-24, -4.795136139777645e-26,  2.618975860683478e-05,
 -6.480395090380868e-07,  1.266390131318738e-08, -2.000744601612671e-10,  2.771966622688365e-12, -3.471878796499379e-14,  4.014450691430207e-16, -4.345064298257706e-18,
  4.446532548075346e-20, -4.334510457401429e-22,  4.048337070239310e-24, -3.639072902899547e-26,  5.333533775342300e-06, -1.584935123821065e-07,  3.505423963797323e-09,
 -6.214682967788361e-11,  9.566495208585404e-13, -1.322541844496081e-14,  1.679155333628767e-16, -1.987190240327752e-18,  2.215569733731383e-20, -2.345767899264018e-22,
  2.373121098069957e-24, -2.305039859457380e-26,  9.307414753836359e-07, -3.293595856420511e-08,  8.237927449190702e-10, -1.635661164669841e-11,  2.793023105082459e-13,
 -4.255814390580644e-15,  5.925145721684650e-17, -7.657265238515613e-19,  9.290010663088814e-21, -1.067069795106700e-22,  1.167997094223374e-24, -1.224539977047183e-26,
  1.388420279230785e-07, -5.808995501558130e-09,  1.642408534603145e-10, -3.647258885123204e-12,  6.901837081466559e-14, -1.158070447072588e-15,  1.766562646133089e-17,
 -2.491121141230755e-19,  3.286371694035840e-21, -4.092281274241875e-23,  4.843224717683908e-25, -5.477106612045184e-27,  1.766047101358564e-08, -8.684288651100464e-10,
  2.775154222011048e-11, -6.887312393827550e-13,  1.443662334582431e-14, -2.666410073524656e-16,  4.455022056543503e-18, -6.852843748315597e-20,  9.827535193071855e-22,
 -1.326304143360363e-23,  1.696732346088908e-25, -2.069171258511655e-27,  1.910669490284168e-09, -1.098879620533242e-10,  3.969479547446392e-12, -1.100724173949293e-13,
  2.555795607196994e-15, -5.196517878867447e-17,  9.510670603266866e-19, -1.596020524389551e-20,  2.488374595008800e-22, -3.640098918268160e-24,  5.034193667358431e-26,
 -6.620928216088843e-28,  1.754044716692540e-10, -1.175281207911981e-11,  4.801033383670301e-13, -1.487958005144025e-14,  3.829013990760696e-16, -8.574902682676192e-18,
  1.720042298839750e-19, -3.150680862286936e-21,  5.343297758487122e-23, -8.476572907044706e-25,  1.267907437292415e-26, -1.799176194329509e-28,  1.363581631947626e-11,
 -1.061226564090368e-12,  4.905910409480555e-14, -1.700702237100575e-15,  4.854982842930246e-17, -1.198697726933642e-18,  2.637856704817330e-20, -5.279141042247241e-22,
  9.747419435862233e-24, -1.678382718434912e-25,  2.717491158716684e-27, -4.163814197440863e-29,  8.963889115778669e-13, -8.085191868320017e-14,  4.234191406570919e-15,
 -1.643912886928597e-16,  5.213281124596200e-18, -1.421110428153341e-19,  3.435620230077440e-21, -7.522272457621967e-23,  1.514116139475179e-24, -2.833276410224311e-26,
  4.971520032631708e-28, -8.234473857663764e-30,  4.981437766069493e-14, -5.199677218979771e-15,  3.089054713327459e-16, -1.345486639851504e-17,  4.748847731830172e-19,
 -1.431873623985333e-20,  3.809827125607683e-22, -9.142010901606791e-24,  2.009396626341091e-25, -4.092811253540780e-27,  7.794898522485394e-29, -1.397691192658676e-30,
  2.343769702496377e-15, -2.828852120069943e-16,  1.909779523381760e-17, -9.352318919973483e-19,  3.682121002897245e-20, -1.230852510250754e-21,  3.612414292881344e-23,
 -9.520503292204006e-25,  2.289771398417551e-26, -5.086609509703136e-28,  1.053461776793787e-29, -2.048534485231087e-31,  9.378034483374170e-17, -1.308476079873032e-17,
  1.005922030226690e-18, -5.552586284277411e-20,  2.445205554744078e-21, -9.086202715403191e-23,  2.949188605738959e-24, -8.558279230602754e-26,  2.257746949974955e-27,
 -5.482651568295529e-29,  1.237461740364842e-30, -2.615025729934792e-32,  3.220411277016201e-18, -5.194925929716314e-19,  4.558515334092346e-20, -2.844496206457060e-21,
  1.405358569889621e-22, -5.822763984408746e-24,  2.096326517244474e-25, -6.717322247262235e-27,  1.949025406986966e-28, -5.187155662807548e-30,  1.279025488114857e-31,
 -2.943997677175219e-33,  9.649242643664599e-20, -1.800064685623159e-20,  1.807368527215555e-21, -1.278824939499541e-22,  7.111487833347608e-24, -3.295952277039263e-25,
  1.320340042558421e-26, -4.685831511947507e-28,  1.499640078804915e-29, -4.386057055185685e-31,  1.184522663790669e-32, -2.976813791648215e-34,  2.594745370859059e-21,
 -5.597504751303048e-22,  6.445289125235482e-23, -5.186327553177852e-24,  3.256406430832547e-25, -1.693572712150932e-26,  7.572048785850837e-28, -2.985034265234740e-29,
  1.056649914805094e-30, -3.405037119305810e-32,  1.009628773717083e-33, -2.776435459988201e-35,  6.558905152220687e-23, -1.634373163272409e-23,  2.161187455327550e-24,
 -1.982029310520787e-25,  1.408587156146103e-26, -8.241017777361218e-28,  4.122443266362854e-29, -1.809387619748331e-30,  7.099584446633930e-32, -2.525746850650191e-33,
  8.237286241623420e-35, -2.482689671039001e-36,  1.677969910181825e-24, -4.813169639856271e-25,  7.304511628153181e-26, -7.637379144095290e-27,  6.147713481144730e-28,
 -4.049478986460704e-29,  2.268258512972512e-30, -1.109257567430342e-31,  4.827509976465933e-33, -1.896939732203920e-34,  6.806770751443440e-36, -2.248794185547216e-37,
  4.865202312194966e-26, -1.594106863964496e-26,  2.763549301648743e-27, -3.282648740843306e-28,  2.984000636331681e-29, -2.207013477774190e-30,  1.380726152591581e-31,
 -7.504445875319128e-33,  3.613281890264262e-34, -1.564185264449451e-35,  6.159162888568934e-37, -2.224379153612780e-38,  1.877101089155262e-27, -6.922448128016835e-28,
  1.354736227213949e-28, -1.809092045932815e-29,  1.839259004621538e-30, -1.513610027286824e-31,  1.048439479013769e-32, -6.280177074665502e-34,  3.318120034016600e-35,
 -1.569843094461352e-36,  6.730073249512246e-38, -2.636432275872932e-39,  1.161462634867169e-28, -4.703017793546555e-29,  1.015438839003737e-29, -1.492047977855285e-30,
  1.662506882756082e-31, -1.493216032318463e-32,  1.124275805813807e-33, -7.291843887998980e-35,  4.156247529081690e-36, -2.114023791263830e-37,  9.711951795545573e-39,
 -4.063864823639906e-40,  1.194385124437029e-29, -5.121418167540045e-30,  1.175939919421601e-30, -1.835097744589135e-31,  2.166455550720930e-32, -2.056299835241464e-33,
  1.631877675986293e-34, -1.112800125869182e-35,  6.652929119339779e-37, -3.541401610967665e-38,  1.699035608124711e-39, -7.408798745292224e-41,  };
  int offset = -31;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 31;
    if (std::isnan(t)) {
      fill_n(rr+offset, 31, 0.5);
      fill_n(ww+offset, 31, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 31; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=31; ++j) {
        const int boxof = it*372+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
