/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef UPNPNAT_H_
#define UPNPNAT_H_

#include <string>
#include <list>
#include "BitStorm.h"
#include "Socket.h"
#include "xmlnode.h"

class IUPnpNatExplorerEventHandler
{
public:
	virtual ~IUPnpNatExplorerEventHandler() {};
	
	virtual void OnGetDescriptionUrl(const char* url) = 0;
};

class CUPnpNatExplorer :
	public CSocket,
	public ITimerCallback
{
public:
	CUPnpNatExplorer();
	virtual ~CUPnpNatExplorer();	
private:
	ISocketReactor* _reactor;
	IUPnpNatExplorerEventHandler* _eventHandler;
	unsigned int _discoverTimerID;	
	bool _found;
private:
	void discover();	
	void parseDiscoverReponse(char* buffer, int len);
public:
	void setSocketReactor(ISocketReactor* reactor);
	void setEventHandler(IUPnpNatExplorerEventHandler* handler);
	void start();
	void stop();
	
	int handleRead();
	int handleWrite();
	void handleClose();			
	
	void onTimer(unsigned int id);
};


class IUPnpNatDescriptionParserEventHandler
{
public:
	virtual ~IUPnpNatDescriptionParserEventHandler() {};
	
	virtual void OnGetControlUrl(const char* controlUrl, const char* service) = 0;
};


typedef enum {DPS_INIT, DPS_WORKING, DPS_OK, DPS_ERROR} TDescriptionParserState;

class CUPnpNatDescriptionParser :
	public CSocket,
	public ITimerCallback
{
public:
	CUPnpNatDescriptionParser();
	virtual ~CUPnpNatDescriptionParser();	
private:	
	ISocketReactor* _reactor;
	std::string _url;	
	IUPnpNatDescriptionParserEventHandler* _eventHandler;
	std::string _recvBuffer;
	unsigned int _timeoutTimerID;
	TDescriptionParserState _state;
private:
	void connect();
	void sendRequest();
	bool parseResponse(const char* response, const char* httpUrl, const char* serviceType);
	bool compareService(xmlnode* service, const char* serviceType);
	bool compareDevice(xmlnode* device, const char* deviceType);
public:
	void setSocketReactor(ISocketReactor* reactor);
	void setDescriptionUrl(const char* url);
	void setEventHandler(IUPnpNatDescriptionParserEventHandler* handler);
	void start();
	void stop();
	TDescriptionParserState getState();
	
	int handleRead();
	int handleWrite();
	void handleClose();			
	
	void onTimer(unsigned int id);
};

typedef enum {CS_INIT, CS_WORKING, CS_OK, CS_ERROR} TControllerState;

class CPnpNatController :
	public CSocket,
	public ITimerCallback
{
public:
	CPnpNatController();
	virtual ~CPnpNatController();
	
	static const char* ActionAdd;
	static const char* ActionDelete;
private:
	ISocketReactor* _reactor;
	TControllerState _state;
	std::string _controlUrl;
	std::string _service;
	unsigned short _port;
	std::string _protocol;
	std::string _actionName;
	unsigned int _timeoutTimerID;
	
	std::string _localIP;
	std::string _recvBuffer;
private:
	void sendRequest();	
public:
	void setSocketReactor(ISocketReactor* reactor);
	void setControlUrl(const char*controlUrl, const char* service);
	void setAction(const char* action, unsigned short port, const char* protocol);
	void start();
	void stop();	
	TControllerState getState();
	
	int handleRead();
	int handleWrite();
	void handleClose();		
	
	void onTimer(unsigned int id);
};

typedef struct
{
	unsigned int port;
	std::string protocol;
	CPnpNatController* controller;
} TNatPortInfo;

typedef std::list<TNatPortInfo> TNatPortInfoList;

class CUPnpNat :
	 public IUPnpNAT,
	 public ITimerCallback,
	 public IUPnpNatExplorerEventHandler,
	 public IUPnpNatDescriptionParserEventHandler
{
public:
	CUPnpNat();
	virtual ~CUPnpNat();
private:
	CUPnpNatExplorer _natExplorer;
	CUPnpNatDescriptionParser _natParser;
	CPnpNatController _natController;
	
	ISocketReactor* _reactor;	
	TUPnpNATState _state;
	
	std::string _controlUrl;
	std::string _service;
	
	TNatPortInfoList _portList;

	unsigned int _discoverTimerID;
	unsigned int _controlTimerID;
public:	
	void setReactor(ISocketReactor* reactor);
	void start();
	void stop();
	TUPnpNATState getState();
	void addPortMapping(unsigned int port,const char* protocol);
	void removePortMapping(unsigned int port,const char* protocol);	
	
	void onTimer(unsigned int id);
	
	void OnGetDescriptionUrl(const char* url);
	void OnGetControlUrl(const char* controlUrl, const char* service);
};

#endif /*UPNPNAT_H_*/
