/* KeyboardLayoutApplet.c generated by valac 0.32.1, the Vala compiler
 * generated from KeyboardLayoutApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <libpeas/peas.h>
#include <plugin.h>
#include <stdlib.h>
#include <string.h>
#include <ibus.h>
#include <gio/gio.h>
#include <libgnome-desktop/gnome-bg-crossfade.h>
#include <libgnome-desktop/gnome-bg-slide-show.h>
#include <libgnome-desktop/gnome-bg.h>
#include <libgnome-desktop/gnome-desktop-thumbnail.h>
#include <libgnome-desktop/gnome-idle-monitor.h>
#include <libgnome-desktop/gnome-languages.h>
#include <libgnome-desktop/gnome-pnp-ids.h>
#include <libgnome-desktop/gnome-rr-config.h>
#include <libgnome-desktop/gnome-rr.h>
#include <libgnome-desktop/gnome-wall-clock.h>
#include <libgnome-desktop/gnome-xkb-info.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>


#define TYPE_KEYBOARD_LAYOUT_PLUGIN (keyboard_layout_plugin_get_type ())
#define KEYBOARD_LAYOUT_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYBOARD_LAYOUT_PLUGIN, KeyboardLayoutPlugin))
#define KEYBOARD_LAYOUT_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYBOARD_LAYOUT_PLUGIN, KeyboardLayoutPluginClass))
#define IS_KEYBOARD_LAYOUT_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYBOARD_LAYOUT_PLUGIN))
#define IS_KEYBOARD_LAYOUT_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYBOARD_LAYOUT_PLUGIN))
#define KEYBOARD_LAYOUT_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYBOARD_LAYOUT_PLUGIN, KeyboardLayoutPluginClass))

typedef struct _KeyboardLayoutPlugin KeyboardLayoutPlugin;
typedef struct _KeyboardLayoutPluginClass KeyboardLayoutPluginClass;
typedef struct _KeyboardLayoutPluginPrivate KeyboardLayoutPluginPrivate;

#define TYPE_KEYBOARD_LAYOUT_APPLET (keyboard_layout_applet_get_type ())
#define KEYBOARD_LAYOUT_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYBOARD_LAYOUT_APPLET, KeyboardLayoutApplet))
#define KEYBOARD_LAYOUT_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYBOARD_LAYOUT_APPLET, KeyboardLayoutAppletClass))
#define IS_KEYBOARD_LAYOUT_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYBOARD_LAYOUT_APPLET))
#define IS_KEYBOARD_LAYOUT_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYBOARD_LAYOUT_APPLET))
#define KEYBOARD_LAYOUT_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYBOARD_LAYOUT_APPLET, KeyboardLayoutAppletClass))

typedef struct _KeyboardLayoutApplet KeyboardLayoutApplet;
typedef struct _KeyboardLayoutAppletClass KeyboardLayoutAppletClass;

#define TYPE_APPLET_IBUS_MANAGER (applet_ibus_manager_get_type ())
#define APPLET_IBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLET_IBUS_MANAGER, AppletIBusManager))
#define APPLET_IBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLET_IBUS_MANAGER, AppletIBusManagerClass))
#define IS_APPLET_IBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLET_IBUS_MANAGER))
#define IS_APPLET_IBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLET_IBUS_MANAGER))
#define APPLET_IBUS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLET_IBUS_MANAGER, AppletIBusManagerClass))

typedef struct _AppletIBusManager AppletIBusManager;
typedef struct _AppletIBusManagerClass AppletIBusManagerClass;
typedef struct _AppletIBusManagerPrivate AppletIBusManagerPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_INPUT_SOURCE (input_source_get_type ())
#define INPUT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_SOURCE, InputSource))
#define INPUT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_SOURCE, InputSourceClass))
#define IS_INPUT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_SOURCE))
#define IS_INPUT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_SOURCE))
#define INPUT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_SOURCE, InputSourceClass))

typedef struct _InputSource InputSource;
typedef struct _InputSourceClass InputSourceClass;
typedef struct _InputSourcePrivate InputSourcePrivate;
#define _input_source_unref0(var) ((var == NULL) ? NULL : (var = (input_source_unref (var), NULL)))
typedef struct _ParamSpecInputSource ParamSpecInputSource;

#define TYPE_INPUT_SOURCE_MENU_ITEM (input_source_menu_item_get_type ())
#define INPUT_SOURCE_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_SOURCE_MENU_ITEM, InputSourceMenuItem))
#define INPUT_SOURCE_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_SOURCE_MENU_ITEM, InputSourceMenuItemClass))
#define IS_INPUT_SOURCE_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_SOURCE_MENU_ITEM))
#define IS_INPUT_SOURCE_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_SOURCE_MENU_ITEM))
#define INPUT_SOURCE_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_SOURCE_MENU_ITEM, InputSourceMenuItemClass))

typedef struct _InputSourceMenuItem InputSourceMenuItem;
typedef struct _InputSourceMenuItemClass InputSourceMenuItemClass;
typedef struct _InputSourceMenuItemPrivate InputSourceMenuItemPrivate;
typedef struct _KeyboardLayoutAppletPrivate KeyboardLayoutAppletPrivate;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _KeyboardLayoutPlugin {
	PeasExtensionBase parent_instance;
	KeyboardLayoutPluginPrivate * priv;
};

struct _KeyboardLayoutPluginClass {
	PeasExtensionBaseClass parent_class;
};

typedef enum  {
	INPUT_METHOD_ERROR_UNKNOWN_IME
} InputMethodError;
#define INPUT_METHOD_ERROR input_method_error_quark ()
struct _AppletIBusManager {
	GObject parent_instance;
	AppletIBusManagerPrivate * priv;
};

struct _AppletIBusManagerClass {
	GObjectClass parent_class;
};

struct _AppletIBusManagerPrivate {
	GHashTable* engines;
	gboolean did_ibus_init;
	gboolean ibus_available;
	IBusBus* bus;
};

struct _InputSource {
	GTypeInstance parent_instance;
	volatile int ref_count;
	InputSourcePrivate * priv;
	gboolean xkb;
	gchar* layout;
	gchar* variant;
	gchar* description;
	guint idx;
	gchar* ibus_engine;
};

struct _InputSourceClass {
	GTypeClass parent_class;
	void (*finalize) (InputSource *self);
};

struct _ParamSpecInputSource {
	GParamSpec parent_instance;
};

struct _InputSourceMenuItem {
	GtkButton parent_instance;
	InputSourceMenuItemPrivate * priv;
	guint idx;
};

struct _InputSourceMenuItemClass {
	GtkButtonClass parent_class;
};

struct _InputSourceMenuItemPrivate {
	GtkLabel* tick_label;
};

struct _KeyboardLayoutApplet {
	BudgieApplet parent_instance;
	KeyboardLayoutAppletPrivate * priv;
};

struct _KeyboardLayoutAppletClass {
	BudgieAppletClass parent_class;
};

struct _KeyboardLayoutAppletPrivate {
	GtkEventBox* widget;
	GtkEventBox* img_wrap;
	GtkImage* img;
	GSettings* settings;
	GArray* sources;
	InputSource* fallback;
	GnomeXkbInfo* xkb;
	GtkStack* label_stack;
	GtkPopover* popover;
	GtkListBox* listbox;
	BudgiePopoverManager* manager;
	AppletIBusManager* ibus_manager;
};


static gpointer keyboard_layout_plugin_parent_class = NULL;
static BudgiePluginIface* keyboard_layout_plugin_budgie_plugin_parent_iface = NULL;
static GType keyboard_layout_plugin_type_id = 0;
static gpointer applet_ibus_manager_parent_class = NULL;
static GType applet_ibus_manager_type_id = 0;
static gpointer input_source_parent_class = NULL;
static GType input_source_type_id = 0;
static gpointer input_source_menu_item_parent_class = NULL;
static GType input_source_menu_item_type_id = 0;
static gpointer keyboard_layout_applet_parent_class = NULL;
static GType keyboard_layout_applet_type_id = 0;

GType keyboard_layout_plugin_get_type (void) G_GNUC_CONST;
GType keyboard_layout_plugin_register_type (GTypeModule * module);
enum  {
	KEYBOARD_LAYOUT_PLUGIN_DUMMY_PROPERTY
};
static BudgieApplet* keyboard_layout_plugin_real_get_panel_widget (BudgiePlugin* base, const gchar* uuid);
KeyboardLayoutApplet* keyboard_layout_applet_new (void);
KeyboardLayoutApplet* keyboard_layout_applet_construct (GType object_type);
GType keyboard_layout_applet_get_type (void) G_GNUC_CONST;
GType keyboard_layout_applet_register_type (GTypeModule * module);
KeyboardLayoutPlugin* keyboard_layout_plugin_new (void);
KeyboardLayoutPlugin* keyboard_layout_plugin_construct (GType object_type);
#define DEFAULT_LOCALE "en_US"
#define DEFAULT_LAYOUT "us"
#define DEFAULT_VARIANT ""
GQuark input_method_error_quark (void);
GType applet_ibus_manager_get_type (void) G_GNUC_CONST;
GType applet_ibus_manager_register_type (GTypeModule * module);
#define APPLET_IBUS_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APPLET_IBUS_MANAGER, AppletIBusManagerPrivate))
enum  {
	APPLET_IBUS_MANAGER_DUMMY_PROPERTY
};
AppletIBusManager* applet_ibus_manager_new (void);
AppletIBusManager* applet_ibus_manager_construct (GType object_type);
static void applet_ibus_manager_reset_ibus (AppletIBusManager* self);
void applet_ibus_manager_do_init (AppletIBusManager* self);
static void _g_free0_ (gpointer var);
static void applet_ibus_manager_ibus_connected (AppletIBusManager* self);
static void _applet_ibus_manager_ibus_connected_ibus_bus_connected (IBusBus* _sender, gpointer self);
static void applet_ibus_manager_ibus_disconnected (AppletIBusManager* self);
static void _applet_ibus_manager_ibus_disconnected_ibus_bus_disconnected (IBusBus* _sender, gpointer self);
static void applet_ibus_manager_on_engines_get (AppletIBusManager* self, GObject* o, GAsyncResult* res);
static void _applet_ibus_manager_on_engines_get_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
IBusEngineDesc* applet_ibus_manager_get_engine (AppletIBusManager* self, const gchar* name);
static void applet_ibus_manager_finalize (GObject* obj);
gpointer input_source_ref (gpointer instance);
void input_source_unref (gpointer instance);
GParamSpec* param_spec_input_source (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_input_source (GValue* value, gpointer v_object);
void value_take_input_source (GValue* value, gpointer v_object);
gpointer value_get_input_source (const GValue* value);
GType input_source_get_type (void) G_GNUC_CONST;
GType input_source_register_type (GTypeModule * module);
enum  {
	INPUT_SOURCE_DUMMY_PROPERTY
};
InputSource* input_source_new (AppletIBusManager* iman, const gchar* id, guint idx, const gchar* layout, const gchar* variant, const gchar* description, gboolean xkb, GError** error);
InputSource* input_source_construct (GType object_type, AppletIBusManager* iman, const gchar* id, guint idx, const gchar* layout, const gchar* variant, const gchar* description, gboolean xkb, GError** error);
static void input_source_finalize (InputSource* obj);
GType input_source_menu_item_get_type (void) G_GNUC_CONST;
GType input_source_menu_item_register_type (GTypeModule * module);
#define INPUT_SOURCE_MENU_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_INPUT_SOURCE_MENU_ITEM, InputSourceMenuItemPrivate))
enum  {
	INPUT_SOURCE_MENU_ITEM_DUMMY_PROPERTY
};
InputSourceMenuItem* input_source_menu_item_new (const gchar* description, guint idx);
InputSourceMenuItem* input_source_menu_item_construct (GType object_type, const gchar* description, guint idx);
void input_source_menu_item_set_ticked (InputSourceMenuItem* self, gboolean ticked);
static void input_source_menu_item_finalize (GObject* obj);
#define KEYBOARD_LAYOUT_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KEYBOARD_LAYOUT_APPLET, KeyboardLayoutAppletPrivate))
enum  {
	KEYBOARD_LAYOUT_APPLET_DUMMY_PROPERTY
};
static gboolean __lambda4_ (KeyboardLayoutApplet* self, GdkEventButton* e);
static gboolean ___lambda4__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void keyboard_layout_applet_update_fallback (KeyboardLayoutApplet* self);
static void keyboard_layout_applet_on_ibus_ready (KeyboardLayoutApplet* self);
static void _keyboard_layout_applet_on_ibus_ready_applet_ibus_manager_ready (AppletIBusManager* _sender, gpointer self);
static void keyboard_layout_applet_on_settings_changed (KeyboardLayoutApplet* self, const gchar* key);
static void _keyboard_layout_applet_on_settings_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void keyboard_layout_applet_on_row_activate (KeyboardLayoutApplet* self, GtkButton* item);
static void keyboard_layout_applet_reset_keyboards (KeyboardLayoutApplet* self);
static void _keyboard_layout_applet_on_row_activate_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void keyboard_layout_applet_update_sources (KeyboardLayoutApplet* self);
static void keyboard_layout_applet_update_current (KeyboardLayoutApplet* self);
static gchar* keyboard_layout_applet_get_xkb_description (KeyboardLayoutApplet* self, const gchar* id);
static void keyboard_layout_applet_real_update_popovers (BudgieApplet* base, BudgiePopoverManager* manager);
static void keyboard_layout_applet_finalize (GObject* obj);
void peas_register_types (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static BudgieApplet* keyboard_layout_plugin_real_get_panel_widget (BudgiePlugin* base, const gchar* uuid) {
	KeyboardLayoutPlugin * self;
	BudgieApplet* result = NULL;
	KeyboardLayoutApplet* _tmp0_ = NULL;
	self = (KeyboardLayoutPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = keyboard_layout_applet_new ();
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}


KeyboardLayoutPlugin* keyboard_layout_plugin_construct (GType object_type) {
	KeyboardLayoutPlugin * self = NULL;
	self = (KeyboardLayoutPlugin*) g_object_new (object_type, NULL);
	return self;
}


KeyboardLayoutPlugin* keyboard_layout_plugin_new (void) {
	return keyboard_layout_plugin_construct (TYPE_KEYBOARD_LAYOUT_PLUGIN);
}


static void keyboard_layout_plugin_class_init (KeyboardLayoutPluginClass * klass) {
	keyboard_layout_plugin_parent_class = g_type_class_peek_parent (klass);
}


static void keyboard_layout_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface) {
	keyboard_layout_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*)(BudgiePlugin*, const gchar*)) keyboard_layout_plugin_real_get_panel_widget;
}


static void keyboard_layout_plugin_instance_init (KeyboardLayoutPlugin * self) {
}


GType keyboard_layout_plugin_get_type (void) {
	return keyboard_layout_plugin_type_id;
}


GType keyboard_layout_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardLayoutPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_layout_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardLayoutPlugin), 0, (GInstanceInitFunc) keyboard_layout_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) keyboard_layout_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	keyboard_layout_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "KeyboardLayoutPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, keyboard_layout_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return keyboard_layout_plugin_type_id;
}


GQuark input_method_error_quark (void) {
	return g_quark_from_static_string ("input_method_error-quark");
}


AppletIBusManager* applet_ibus_manager_construct (GType object_type) {
	AppletIBusManager * self = NULL;
	self = (AppletIBusManager*) g_object_new (object_type, NULL);
	applet_ibus_manager_reset_ibus (self);
	return self;
}


AppletIBusManager* applet_ibus_manager_new (void) {
	return applet_ibus_manager_construct (TYPE_APPLET_IBUS_MANAGER);
}


/**
     * Run init separately so that the owner can connect to the ready() signal
     */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _applet_ibus_manager_ibus_connected_ibus_bus_connected (IBusBus* _sender, gpointer self) {
	applet_ibus_manager_ibus_connected ((AppletIBusManager*) self);
}


static void _applet_ibus_manager_ibus_disconnected_ibus_bus_disconnected (IBusBus* _sender, gpointer self) {
	applet_ibus_manager_ibus_disconnected ((AppletIBusManager*) self);
}


void applet_ibus_manager_do_init (AppletIBusManager* self) {
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	IBusBus* _tmp6_ = NULL;
	IBusBus* _tmp7_ = NULL;
	IBusBus* _tmp8_ = NULL;
	IBusBus* _tmp9_ = NULL;
	IBusBus* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->engines);
	self->priv->engines = _tmp2_;
	_tmp3_ = g_find_program_in_path ("ibus-daemon");
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == NULL;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		g_message ("KeyboardLayoutApplet.vala:53: ibus-daemon unsupported on this system");
		self->priv->ibus_available = FALSE;
		g_signal_emit_by_name (self, "ready");
		return;
	}
	_tmp6_ = ibus_bus_new_async ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->bus);
	self->priv->bus = _tmp6_;
	_tmp7_ = self->priv->bus;
	g_signal_connect_object (_tmp7_, "connected", (GCallback) _applet_ibus_manager_ibus_connected_ibus_bus_connected, self, 0);
	_tmp8_ = self->priv->bus;
	g_signal_connect_object (_tmp8_, "disconnected", (GCallback) _applet_ibus_manager_ibus_disconnected_ibus_bus_disconnected, self, 0);
	_tmp9_ = self->priv->bus;
	ibus_bus_set_watch_dbus_signal (_tmp9_, TRUE);
	_tmp10_ = self->priv->bus;
	_tmp11_ = ibus_bus_is_connected (_tmp10_);
	if (_tmp11_) {
		applet_ibus_manager_ibus_connected (self);
	}
}


/**
     * Something on ibus changed so we'll reset our state
     */
static void applet_ibus_manager_reset_ibus (AppletIBusManager* self) {
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->engines);
	self->priv->engines = _tmp2_;
}


static void applet_ibus_manager_on_engines_get (AppletIBusManager* self, GObject* o, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GList* engines = NULL;
		IBusBus* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		GList* _tmp3_ = NULL;
		_tmp0_ = self->priv->bus;
		_tmp1_ = res;
		_tmp2_ = ibus_bus_list_engines_async_finish (_tmp0_, _tmp1_, &_inner_error_);
		engines = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		applet_ibus_manager_reset_ibus (self);
		_tmp3_ = engines;
		{
			GList* engine_collection = NULL;
			GList* engine_it = NULL;
			engine_collection = _tmp3_;
			for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
				IBusEngineDesc* engine = NULL;
				engine = (IBusEngineDesc*) engine_it->data;
				{
					GHashTable* _tmp4_ = NULL;
					IBusEngineDesc* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
					gchar* _tmp7_ = NULL;
					IBusEngineDesc* _tmp8_ = NULL;
					_tmp4_ = self->priv->engines;
					_tmp5_ = engine;
					_tmp6_ = ibus_engine_desc_get_name (_tmp5_);
					_tmp7_ = g_strdup (_tmp6_);
					_tmp8_ = engine;
					g_hash_table_insert (_tmp4_, _tmp7_, _tmp8_);
				}
			}
		}
		_g_list_free0 (engines);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_message ("KeyboardLayoutApplet.vala:93: Failed to get engines: %s", _tmp10_);
		applet_ibus_manager_reset_ibus (self);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_signal_emit_by_name (self, "ready");
}


/**
     * We gained connection to the ibus daemon
     */
static void _applet_ibus_manager_on_engines_get_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	applet_ibus_manager_on_engines_get ((AppletIBusManager*) self, source_object, res);
	g_object_unref (self);
}


static void applet_ibus_manager_ibus_connected (AppletIBusManager* self) {
	gboolean _tmp0_ = FALSE;
	IBusBus* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->did_ibus_init;
	if (!_tmp0_) {
		ibus_init ();
		self->priv->did_ibus_init = TRUE;
	}
	_tmp1_ = self->priv->bus;
	ibus_bus_list_engines_async (_tmp1_, -1, NULL, _applet_ibus_manager_on_engines_get_gasync_ready_callback, g_object_ref (self));
}


/**
     * Lost connection to ibus
     */
static void applet_ibus_manager_ibus_disconnected (AppletIBusManager* self) {
	g_return_if_fail (self != NULL);
	applet_ibus_manager_reset_ibus (self);
}


/**
     * Attempt to grab the ibus engine for the given name if it
     * exists, or returns null
     */
IBusEngineDesc* applet_ibus_manager_get_engine (AppletIBusManager* self, const gchar* name) {
	IBusEngineDesc* result = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->engines;
	_tmp1_ = name;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	result = (IBusEngineDesc*) _tmp2_;
	return result;
}


static void applet_ibus_manager_class_init (AppletIBusManagerClass * klass) {
	applet_ibus_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AppletIBusManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = applet_ibus_manager_finalize;
	g_signal_new ("ready", TYPE_APPLET_IBUS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void applet_ibus_manager_instance_init (AppletIBusManager * self) {
	self->priv = APPLET_IBUS_MANAGER_GET_PRIVATE (self);
	self->priv->engines = NULL;
	self->priv->did_ibus_init = FALSE;
	self->priv->ibus_available = TRUE;
	self->priv->bus = NULL;
}


static void applet_ibus_manager_finalize (GObject* obj) {
	AppletIBusManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLET_IBUS_MANAGER, AppletIBusManager);
	_g_hash_table_unref0 (self->priv->engines);
	_g_object_unref0 (self->priv->bus);
	G_OBJECT_CLASS (applet_ibus_manager_parent_class)->finalize (obj);
}


/**
 * Reflects the ibus-manager in budgie-wm, with very limited functionality,
 * simply to enable us to mimick the behaviour over there.
 */
GType applet_ibus_manager_get_type (void) {
	return applet_ibus_manager_type_id;
}


GType applet_ibus_manager_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (AppletIBusManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) applet_ibus_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppletIBusManager), 0, (GInstanceInitFunc) applet_ibus_manager_instance_init, NULL };
	applet_ibus_manager_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "AppletIBusManager", &g_define_type_info, 0);
	return applet_ibus_manager_type_id;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


InputSource* input_source_construct (GType object_type, AppletIBusManager* iman, const gchar* id, guint idx, const gchar* layout, const gchar* variant, const gchar* description, gboolean xkb, GError** error) {
	InputSource* self = NULL;
	guint _tmp0_ = 0U;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	AppletIBusManager* _tmp11_ = NULL;
	IBusEngineDesc* engine = NULL;
	AppletIBusManager* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	IBusEngineDesc* _tmp14_ = NULL;
	IBusEngineDesc* _tmp15_ = NULL;
	IBusEngineDesc* _tmp16_ = NULL;
	gchar* language = NULL;
	IBusEngineDesc* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp28_ = NULL;
	IBusEngineDesc* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* e_variant = NULL;
	IBusEngineDesc* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_ = NULL;
	IBusEngineDesc* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	self = (InputSource*) g_type_create_instance (object_type);
	_tmp0_ = idx;
	self->idx = _tmp0_;
	_tmp1_ = layout;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->layout);
	self->layout = _tmp2_;
	_tmp3_ = variant;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->variant);
	self->variant = _tmp4_;
	_tmp5_ = xkb;
	self->xkb = _tmp5_;
	_tmp6_ = description;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp7_ = description;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (self->description);
		self->description = _tmp8_;
	} else {
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp9_ = self->layout;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (self->description);
		self->description = _tmp10_;
	}
	_tmp11_ = iman;
	if (_tmp11_ == NULL) {
		return self;
	}
	_tmp12_ = iman;
	_tmp13_ = id;
	_tmp14_ = applet_ibus_manager_get_engine (_tmp12_, _tmp13_);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	engine = _tmp15_;
	_tmp16_ = engine;
	if (_tmp16_ == NULL) {
		gboolean _tmp17_ = FALSE;
		_tmp17_ = xkb;
		if (!_tmp17_) {
			GError* _tmp18_ = NULL;
			_tmp18_ = g_error_new_literal (INPUT_METHOD_ERROR, INPUT_METHOD_ERROR_UNKNOWN_IME, "Unknown input method: id");
			_inner_error_ = _tmp18_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (engine);
			_input_source_unref0 (self);
			return NULL;
		}
		_g_object_unref0 (engine);
		return self;
	}
	_tmp19_ = engine;
	_tmp20_ = ibus_engine_desc_get_language (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = gnome_get_language_from_code (_tmp21_, NULL);
	language = _tmp22_;
	_tmp23_ = language;
	if (_tmp23_ == NULL) {
		IBusEngineDesc* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		_tmp24_ = engine;
		_tmp25_ = ibus_engine_desc_get_language (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = gnome_get_language_from_locale (_tmp26_, NULL);
		_g_free0 (language);
		language = _tmp27_;
	}
	_tmp28_ = language;
	_tmp29_ = engine;
	_tmp30_ = ibus_engine_desc_get_name (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strdup_printf ("%s (%s)", _tmp28_, _tmp31_);
	_g_free0 (self->description);
	self->description = _tmp32_;
	_tmp33_ = engine;
	_tmp34_ = ibus_engine_desc_get_layout_variant (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strdup (_tmp35_);
	e_variant = _tmp36_;
	_tmp38_ = e_variant;
	if (_tmp38_ != NULL) {
		const gchar* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		_tmp39_ = e_variant;
		_tmp40_ = strlen (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp37_ = _tmp41_ > 0;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		const gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		_tmp42_ = e_variant;
		_tmp43_ = g_strdup (_tmp42_);
		_g_free0 (self->variant);
		self->variant = _tmp43_;
	}
	_tmp44_ = engine;
	_tmp45_ = ibus_engine_desc_get_language (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = g_strdup (_tmp46_);
	_g_free0 (self->layout);
	self->layout = _tmp47_;
	_tmp48_ = id;
	_tmp49_ = g_strdup (_tmp48_);
	_g_free0 (self->ibus_engine);
	self->ibus_engine = _tmp49_;
	_g_free0 (e_variant);
	_g_free0 (language);
	_g_object_unref0 (engine);
	return self;
}


InputSource* input_source_new (AppletIBusManager* iman, const gchar* id, guint idx, const gchar* layout, const gchar* variant, const gchar* description, gboolean xkb, GError** error) {
	return input_source_construct (TYPE_INPUT_SOURCE, iman, id, idx, layout, variant, description, xkb, error);
}


static void value_input_source_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_input_source_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		input_source_unref (value->data[0].v_pointer);
	}
}


static void value_input_source_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = input_source_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_input_source_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_input_source_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		InputSource* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = input_source_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_input_source_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	InputSource** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = input_source_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_input_source (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecInputSource* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_INPUT_SOURCE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_input_source (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INPUT_SOURCE), NULL);
	return value->data[0].v_pointer;
}


void value_set_input_source (GValue* value, gpointer v_object) {
	InputSource* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INPUT_SOURCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_INPUT_SOURCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		input_source_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		input_source_unref (old);
	}
}


void value_take_input_source (GValue* value, gpointer v_object) {
	InputSource* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INPUT_SOURCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_INPUT_SOURCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		input_source_unref (old);
	}
}


static void input_source_class_init (InputSourceClass * klass) {
	input_source_parent_class = g_type_class_peek_parent (klass);
	((InputSourceClass *) klass)->finalize = input_source_finalize;
}


static void input_source_instance_init (InputSource * self) {
	self->xkb = FALSE;
	self->layout = NULL;
	self->variant = NULL;
	self->description = NULL;
	self->idx = (guint) 0;
	self->ibus_engine = NULL;
	self->ref_count = 1;
}


static void input_source_finalize (InputSource* obj) {
	InputSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INPUT_SOURCE, InputSource);
	g_signal_handlers_destroy (self);
	_g_free0 (self->layout);
	_g_free0 (self->variant);
	_g_free0 (self->description);
	_g_free0 (self->ibus_engine);
}


GType input_source_get_type (void) {
	return input_source_type_id;
}


GType input_source_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { value_input_source_init, value_input_source_free_value, value_input_source_copy_value, value_input_source_peek_pointer, "p", value_input_source_collect_value, "p", value_input_source_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (InputSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) input_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InputSource), 0, (GInstanceInitFunc) input_source_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	input_source_type_id = g_type_register_fundamental (g_type_fundamental_next (), "InputSource", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return input_source_type_id;
}


gpointer input_source_ref (gpointer instance) {
	InputSource* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void input_source_unref (gpointer instance) {
	InputSource* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		INPUT_SOURCE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


InputSourceMenuItem* input_source_menu_item_construct (GType object_type, const gchar* description, guint idx) {
	InputSourceMenuItem * self = NULL;
	guint _tmp0_ = 0U;
	GtkBox* layout = NULL;
	GtkBox* _tmp1_ = NULL;
	GtkLabel* desc_label = NULL;
	const gchar* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkStyleContext* _tmp7_ = NULL;
	GtkStyleContext* _tmp8_ = NULL;
	self = (InputSourceMenuItem*) g_object_new (object_type, "can-focus", FALSE, NULL);
	_tmp0_ = idx;
	self->idx = _tmp0_;
	gtk_button_set_relief ((GtkButton*) self, GTK_RELIEF_NONE);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_FILL);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp1_);
	layout = _tmp1_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) layout);
	_tmp2_ = description;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	desc_label = _tmp3_;
	gtk_box_pack_start (layout, (GtkWidget*) desc_label, FALSE, FALSE, (guint) 0);
	gtk_widget_set_halign ((GtkWidget*) desc_label, GTK_ALIGN_START);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
	_tmp4_ = (GtkLabel*) gtk_label_new ("  ✓");
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->tick_label);
	self->priv->tick_label = _tmp4_;
	_tmp5_ = self->priv->tick_label;
	gtk_box_pack_end (layout, (GtkWidget*) _tmp5_, FALSE, FALSE, (guint) 0);
	_tmp6_ = self->priv->tick_label;
	gtk_widget_hide ((GtkWidget*) _tmp6_);
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp7_, "indicator-item");
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp8_, "menuitem");
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	_g_object_unref0 (desc_label);
	_g_object_unref0 (layout);
	return self;
}


InputSourceMenuItem* input_source_menu_item_new (const gchar* description, guint idx) {
	return input_source_menu_item_construct (TYPE_INPUT_SOURCE_MENU_ITEM, description, idx);
}


void input_source_menu_item_set_ticked (InputSourceMenuItem* self, gboolean ticked) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = ticked;
	if (_tmp0_) {
		GtkLabel* _tmp1_ = NULL;
		_tmp1_ = self->priv->tick_label;
		gtk_widget_show ((GtkWidget*) _tmp1_);
	} else {
		GtkLabel* _tmp2_ = NULL;
		_tmp2_ = self->priv->tick_label;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
	}
}


static void input_source_menu_item_class_init (InputSourceMenuItemClass * klass) {
	input_source_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (InputSourceMenuItemPrivate));
	G_OBJECT_CLASS (klass)->finalize = input_source_menu_item_finalize;
}


static void input_source_menu_item_instance_init (InputSourceMenuItem * self) {
	self->priv = INPUT_SOURCE_MENU_ITEM_GET_PRIVATE (self);
}


static void input_source_menu_item_finalize (GObject* obj) {
	InputSourceMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INPUT_SOURCE_MENU_ITEM, InputSourceMenuItem);
	_g_object_unref0 (self->priv->tick_label);
	G_OBJECT_CLASS (input_source_menu_item_parent_class)->finalize (obj);
}


GType input_source_menu_item_get_type (void) {
	return input_source_menu_item_type_id;
}


GType input_source_menu_item_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (InputSourceMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) input_source_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InputSourceMenuItem), 0, (GInstanceInitFunc) input_source_menu_item_instance_init, NULL };
	input_source_menu_item_type_id = g_type_module_register_type (module, gtk_button_get_type (), "InputSourceMenuItem", &g_define_type_info, 0);
	return input_source_menu_item_type_id;
}


static gboolean __lambda4_ (KeyboardLayoutApplet* self, GdkEventButton* e) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkPopover* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp2_ = self->priv->popover;
	_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
	if (_tmp3_) {
		GtkPopover* _tmp4_ = NULL;
		_tmp4_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
	} else {
		BudgiePopoverManager* _tmp5_ = NULL;
		GtkEventBox* _tmp6_ = NULL;
		_tmp5_ = self->priv->manager;
		_tmp6_ = self->priv->widget;
		budgie_popover_manager_show_popover (_tmp5_, (GtkWidget*) _tmp6_);
	}
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda4__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda4_ ((KeyboardLayoutApplet*) self, event);
	return result;
}


static void _keyboard_layout_applet_on_ibus_ready_applet_ibus_manager_ready (AppletIBusManager* _sender, gpointer self) {
	keyboard_layout_applet_on_ibus_ready ((KeyboardLayoutApplet*) self);
}


KeyboardLayoutApplet* keyboard_layout_applet_construct (GType object_type) {
	KeyboardLayoutApplet * self = NULL;
	GtkEventBox* _tmp0_ = NULL;
	GtkEventBox* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkBox* layout = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkEventBox* _tmp4_ = NULL;
	GtkImage* _tmp5_ = NULL;
	GtkEventBox* _tmp6_ = NULL;
	GtkEventBox* _tmp7_ = NULL;
	GtkImage* _tmp8_ = NULL;
	GtkEventBox* _tmp9_ = NULL;
	GtkImage* _tmp10_ = NULL;
	GtkEventBox* _tmp11_ = NULL;
	GtkStack* _tmp12_ = NULL;
	GtkStack* _tmp13_ = NULL;
	GtkStack* _tmp14_ = NULL;
	GtkEventBox* _tmp15_ = NULL;
	GtkPopover* _tmp16_ = NULL;
	GtkPopover* _tmp17_ = NULL;
	GtkStyleContext* _tmp18_ = NULL;
	GtkListBox* _tmp19_ = NULL;
	GtkListBox* _tmp20_ = NULL;
	GtkListBox* _tmp21_ = NULL;
	GtkListBox* _tmp22_ = NULL;
	GtkStyleContext* _tmp23_ = NULL;
	GtkPopover* _tmp24_ = NULL;
	GtkListBox* _tmp25_ = NULL;
	GtkPopover* _tmp26_ = NULL;
	GtkWidget* _tmp27_ = NULL;
	GnomeXkbInfo* _tmp28_ = NULL;
	GSettings* _tmp29_ = NULL;
	AppletIBusManager* _tmp30_ = NULL;
	AppletIBusManager* _tmp31_ = NULL;
	AppletIBusManager* _tmp32_ = NULL;
	self = (KeyboardLayoutApplet*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp0_;
	_tmp1_ = self->priv->widget;
	g_signal_connect_object ((GtkWidget*) _tmp1_, "button-press-event", (GCallback) ___lambda4__gtk_widget_button_press_event, self, 0);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, "keyboard-indicator");
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp3_);
	layout = _tmp3_;
	_tmp4_ = self->priv->widget;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) layout);
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("input-keyboard-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->img);
	self->priv->img = _tmp5_;
	_tmp6_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->img_wrap);
	self->priv->img_wrap = _tmp6_;
	_tmp7_ = self->priv->img_wrap;
	_tmp8_ = self->priv->img;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->img_wrap;
	gtk_box_pack_start (layout, (GtkWidget*) _tmp9_, FALSE, FALSE, (guint) 0);
	_tmp10_ = self->priv->img;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp10_, 4);
	_tmp11_ = self->priv->widget;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp11_);
	_tmp12_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->label_stack);
	self->priv->label_stack = _tmp12_;
	_tmp13_ = self->priv->label_stack;
	gtk_stack_set_transition_type (_tmp13_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP_DOWN);
	_tmp14_ = self->priv->label_stack;
	gtk_box_pack_start (layout, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
	_tmp15_ = self->priv->img_wrap;
	_tmp16_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) _tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp16_;
	_tmp17_ = self->priv->popover;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, "user-menu");
	_tmp19_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->listbox);
	self->priv->listbox = _tmp19_;
	_tmp20_ = self->priv->listbox;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp20_, FALSE);
	_tmp21_ = self->priv->listbox;
	gtk_list_box_set_selection_mode (_tmp21_, GTK_SELECTION_NONE);
	_tmp22_ = self->priv->listbox;
	_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) _tmp22_);
	gtk_style_context_add_class (_tmp23_, "content-box");
	_tmp24_ = self->priv->popover;
	_tmp25_ = self->priv->listbox;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->popover;
	_tmp27_ = gtk_bin_get_child ((GtkBin*) _tmp26_);
	gtk_widget_show_all (_tmp27_);
	_tmp28_ = gnome_xkb_info_new ();
	_g_object_unref0 (self->priv->xkb);
	self->priv->xkb = _tmp28_;
	_tmp29_ = g_settings_new ("org.gnome.desktop.input-sources");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp29_;
	_tmp30_ = applet_ibus_manager_new ();
	_g_object_unref0 (self->priv->ibus_manager);
	self->priv->ibus_manager = _tmp30_;
	keyboard_layout_applet_update_fallback (self);
	_tmp31_ = self->priv->ibus_manager;
	g_signal_connect_object (_tmp31_, "ready", (GCallback) _keyboard_layout_applet_on_ibus_ready_applet_ibus_manager_ready, self, 0);
	_tmp32_ = self->priv->ibus_manager;
	applet_ibus_manager_do_init (_tmp32_);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (layout);
	return self;
}


KeyboardLayoutApplet* keyboard_layout_applet_new (void) {
	return keyboard_layout_applet_construct (TYPE_KEYBOARD_LAYOUT_APPLET);
}


/**
     * Only begin listing sources and such when ibus becomes available
     * or we explicitly find it won't work
     */
static void _keyboard_layout_applet_on_settings_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	keyboard_layout_applet_on_settings_changed ((KeyboardLayoutApplet*) self, key);
}


static void keyboard_layout_applet_on_ibus_ready (KeyboardLayoutApplet* self) {
	GSettings* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_signal_connect_object (_tmp0_, "changed", (GCallback) _keyboard_layout_applet_on_settings_changed_g_settings_changed, self, 0);
	keyboard_layout_applet_on_settings_changed (self, "sources");
	keyboard_layout_applet_on_settings_changed (self, "current");
}


/**
     * Tell the WM to change the keyboard to the current selection
     */
static void keyboard_layout_applet_on_row_activate (KeyboardLayoutApplet* self, GtkButton* item) {
	InputSourceMenuItem* btn = NULL;
	GtkButton* _tmp0_ = NULL;
	InputSourceMenuItem* _tmp1_ = NULL;
	guint idx = 0U;
	guint _tmp2_ = 0U;
	GSettings* _tmp3_ = NULL;
	GtkPopover* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_INPUT_SOURCE_MENU_ITEM) ? ((InputSourceMenuItem*) _tmp0_) : NULL);
	btn = _tmp1_;
	_tmp2_ = btn->idx;
	idx = _tmp2_;
	_tmp3_ = self->priv->settings;
	g_settings_set_uint (_tmp3_, "current", idx);
	_tmp4_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp4_);
	_g_object_unref0 (btn);
}


/**
     * Reset the menu/stack
     */
static gpointer _input_source_ref0 (gpointer self) {
	return self ? input_source_ref (self) : NULL;
}


static void _keyboard_layout_applet_on_row_activate_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	keyboard_layout_applet_on_row_activate ((KeyboardLayoutApplet*) self, _sender);
}


static void keyboard_layout_applet_reset_keyboards (KeyboardLayoutApplet* self) {
	GtkStack* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GtkListBox* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->label_stack;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp2_ = NULL;
			GtkWidget* child = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp2_;
			{
				GtkWidget* _tmp3_ = NULL;
				_tmp3_ = child;
				gtk_widget_destroy (_tmp3_);
				_g_object_unref0 (child);
			}
		}
		_g_list_free0 (child_collection);
	}
	_tmp4_ = self->priv->listbox;
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp5_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp6_ = NULL;
			GtkWidget* child = NULL;
			_tmp6_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp6_;
			{
				GtkWidget* _tmp7_ = NULL;
				_tmp7_ = child;
				gtk_widget_destroy (_tmp7_);
				_g_object_unref0 (child);
			}
		}
		_g_list_free0 (child_collection);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_ = 0;
				GArray* _tmp11_ = NULL;
				guint _tmp12_ = 0U;
				InputSource* kbinfo = NULL;
				GArray* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				InputSource* _tmp15_ = NULL;
				InputSource* _tmp16_ = NULL;
				GtkEventBox* wrap = NULL;
				GtkEventBox* _tmp17_ = NULL;
				GtkLabel* displ_label = NULL;
				InputSource* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				GtkLabel* _tmp20_ = NULL;
				GtkEventBox* _tmp21_ = NULL;
				GtkLabel* _tmp22_ = NULL;
				GtkLabel* _tmp23_ = NULL;
				GtkEventBox* _tmp24_ = NULL;
				GtkStyleContext* _tmp25_ = NULL;
				GtkStack* _tmp26_ = NULL;
				GtkEventBox* _tmp27_ = NULL;
				InputSource* _tmp28_ = NULL;
				guint _tmp29_ = 0U;
				gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
				GtkEventBox* _tmp32_ = NULL;
				InputSourceMenuItem* menu_label = NULL;
				InputSource* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				InputSource* _tmp35_ = NULL;
				guint _tmp36_ = 0U;
				InputSourceMenuItem* _tmp37_ = NULL;
				InputSourceMenuItem* _tmp38_ = NULL;
				InputSourceMenuItem* _tmp39_ = NULL;
				GtkListBox* _tmp40_ = NULL;
				InputSourceMenuItem* _tmp41_ = NULL;
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = self->priv->sources;
				_tmp12_ = _tmp11_->len;
				if (!(((guint) _tmp10_) < _tmp12_)) {
					break;
				}
				_tmp13_ = self->priv->sources;
				_tmp14_ = i;
				_tmp15_ = g_array_index (_tmp13_, InputSource*, (guint) _tmp14_);
				_tmp16_ = _input_source_ref0 (_tmp15_);
				kbinfo = _tmp16_;
				_tmp17_ = (GtkEventBox*) gtk_event_box_new ();
				g_object_ref_sink (_tmp17_);
				wrap = _tmp17_;
				_tmp18_ = kbinfo;
				_tmp19_ = _tmp18_->layout;
				_tmp20_ = (GtkLabel*) gtk_label_new (_tmp19_);
				g_object_ref_sink (_tmp20_);
				displ_label = _tmp20_;
				_tmp21_ = wrap;
				_tmp22_ = displ_label;
				gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
				_tmp23_ = displ_label;
				gtk_widget_set_halign ((GtkWidget*) _tmp23_, GTK_ALIGN_START);
				_tmp24_ = wrap;
				_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) _tmp24_);
				gtk_style_context_add_class (_tmp25_, "keyboard-label");
				_tmp26_ = self->priv->label_stack;
				_tmp27_ = wrap;
				_tmp28_ = kbinfo;
				_tmp29_ = _tmp28_->idx;
				_tmp30_ = g_strdup_printf ("%u", _tmp29_);
				_tmp31_ = _tmp30_;
				gtk_stack_add_named (_tmp26_, (GtkWidget*) _tmp27_, _tmp31_);
				_g_free0 (_tmp31_);
				_tmp32_ = wrap;
				gtk_widget_show_all ((GtkWidget*) _tmp32_);
				_tmp33_ = kbinfo;
				_tmp34_ = _tmp33_->description;
				_tmp35_ = kbinfo;
				_tmp36_ = _tmp35_->idx;
				_tmp37_ = input_source_menu_item_new (_tmp34_, _tmp36_);
				g_object_ref_sink (_tmp37_);
				menu_label = _tmp37_;
				_tmp38_ = menu_label;
				g_signal_connect_object ((GtkButton*) _tmp38_, "clicked", (GCallback) _keyboard_layout_applet_on_row_activate_gtk_button_clicked, self, 0);
				_tmp39_ = menu_label;
				gtk_widget_show_all ((GtkWidget*) _tmp39_);
				_tmp40_ = self->priv->listbox;
				_tmp41_ = menu_label;
				gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _tmp41_);
				_g_object_unref0 (menu_label);
				_g_object_unref0 (displ_label);
				_g_object_unref0 (wrap);
				_input_source_unref0 (kbinfo);
			}
		}
	}
}


static void keyboard_layout_applet_on_settings_changed (KeyboardLayoutApplet* self, const gchar* key) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	if (g_strcmp0 (_tmp0_, "sources") == 0) {
		keyboard_layout_applet_update_sources (self);
	} else {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = key;
		if (g_strcmp0 (_tmp1_, "current") == 0) {
			keyboard_layout_applet_update_current (self);
		}
	}
}


static void keyboard_layout_applet_update_sources (KeyboardLayoutApplet* self) {
	GArray* _tmp0_ = NULL;
	GVariant* val = NULL;
	GSettings* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GArray* _tmp47_ = NULL;
	guint _tmp48_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_g_array_unref0 (self->priv->sources);
	self->priv->sources = NULL;
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (InputSource*));
	_g_array_unref0 (self->priv->sources);
	self->priv->sources = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_value (_tmp1_, "sources");
	val = _tmp2_;
	{
		gsize i = 0UL;
		i = (gsize) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gsize _tmp5_ = 0UL;
				GVariant* _tmp6_ = NULL;
				gsize _tmp7_ = 0UL;
				InputSource* source = NULL;
				gchar* id = NULL;
				gchar* type = NULL;
				GVariant* _tmp8_ = NULL;
				gsize _tmp9_ = 0UL;
				const gchar* _tmp10_ = NULL;
				if (!_tmp3_) {
					gsize _tmp4_ = 0UL;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = val;
				_tmp7_ = g_variant_n_children (_tmp6_);
				if (!(_tmp5_ < _tmp7_)) {
					break;
				}
				source = NULL;
				id = NULL;
				type = NULL;
				_tmp8_ = val;
				_tmp9_ = i;
				g_variant_get_child (_tmp8_, _tmp9_, "(ss)", &id, &type, NULL);
				_tmp10_ = id;
				if (g_strcmp0 (_tmp10_, "xkb") == 0) {
					gchar** spl = NULL;
					const gchar* _tmp11_ = NULL;
					gchar** _tmp12_ = NULL;
					gchar** _tmp13_ = NULL;
					gint spl_length1 = 0;
					gint _spl_size_ = 0;
					gchar* variant = NULL;
					gchar* _tmp14_ = NULL;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					gchar* desc = NULL;
					const gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					InputSource* _tmp21_ = NULL;
					AppletIBusManager* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					gsize _tmp24_ = 0UL;
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					const gchar* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					InputSource* _tmp29_ = NULL;
					InputSource* _tmp30_ = NULL;
					GArray* _tmp31_ = NULL;
					InputSource* _tmp32_ = NULL;
					InputSource* _tmp33_ = NULL;
					_tmp11_ = type;
					_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "+", 0);
					spl = _tmp13_;
					spl_length1 = _vala_array_length (_tmp12_);
					_spl_size_ = spl_length1;
					_tmp14_ = g_strdup ("");
					variant = _tmp14_;
					_tmp15_ = spl;
					_tmp15__length1 = spl_length1;
					if (_tmp15__length1 > 1) {
						gchar** _tmp16_ = NULL;
						gint _tmp16__length1 = 0;
						const gchar* _tmp17_ = NULL;
						gchar* _tmp18_ = NULL;
						_tmp16_ = spl;
						_tmp16__length1 = spl_length1;
						_tmp17_ = _tmp16_[1];
						_tmp18_ = g_strdup (_tmp17_);
						_g_free0 (variant);
						variant = _tmp18_;
					}
					_tmp19_ = type;
					_tmp20_ = keyboard_layout_applet_get_xkb_description (self, _tmp19_);
					desc = _tmp20_;
					_tmp22_ = self->priv->ibus_manager;
					_tmp23_ = type;
					_tmp24_ = i;
					_tmp25_ = spl;
					_tmp25__length1 = spl_length1;
					_tmp26_ = _tmp25_[0];
					_tmp27_ = variant;
					_tmp28_ = desc;
					_tmp29_ = input_source_new (_tmp22_, _tmp23_, (guint) _tmp24_, _tmp26_, _tmp27_, _tmp28_, TRUE, &_inner_error_);
					_tmp21_ = _tmp29_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (desc);
						_g_free0 (variant);
						spl = (_vala_array_free (spl, spl_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (type);
						_g_free0 (id);
						_input_source_unref0 (source);
						_g_variant_unref0 (val);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp30_ = _tmp21_;
					_tmp21_ = NULL;
					_input_source_unref0 (source);
					source = _tmp30_;
					_tmp31_ = self->priv->sources;
					_tmp32_ = source;
					_tmp33_ = _input_source_ref0 (_tmp32_);
					g_array_append_val (_tmp31_, _tmp33_);
					_input_source_unref0 (_tmp21_);
					_g_free0 (desc);
					_g_free0 (variant);
					spl = (_vala_array_free (spl, spl_length1, (GDestroyNotify) g_free), NULL);
				} else {
					{
						InputSource* _tmp34_ = NULL;
						AppletIBusManager* _tmp35_ = NULL;
						const gchar* _tmp36_ = NULL;
						gsize _tmp37_ = 0UL;
						InputSource* _tmp38_ = NULL;
						InputSource* _tmp39_ = NULL;
						GArray* _tmp40_ = NULL;
						InputSource* _tmp41_ = NULL;
						InputSource* _tmp42_ = NULL;
						_tmp35_ = self->priv->ibus_manager;
						_tmp36_ = type;
						_tmp37_ = i;
						_tmp38_ = input_source_new (_tmp35_, _tmp36_, (guint) _tmp37_, NULL, NULL, NULL, FALSE, &_inner_error_);
						_tmp34_ = _tmp38_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							goto __catch1_g_error;
						}
						_tmp39_ = _tmp34_;
						_tmp34_ = NULL;
						_input_source_unref0 (source);
						source = _tmp39_;
						_tmp40_ = self->priv->sources;
						_tmp41_ = source;
						_tmp42_ = _input_source_ref0 (_tmp41_);
						g_array_append_val (_tmp40_, _tmp42_);
						_input_source_unref0 (_tmp34_);
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp43_ = NULL;
						const gchar* _tmp44_ = NULL;
						GError* _tmp45_ = NULL;
						const gchar* _tmp46_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp43_ = id;
						_tmp44_ = type;
						_tmp45_ = e;
						_tmp46_ = _tmp45_->message;
						g_message ("KeyboardLayoutApplet.vala:416: Error adding source %s|%s: %s", _tmp43_, _tmp44_, _tmp46_);
						_g_error_free0 (e);
					}
					__finally1:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (type);
						_g_free0 (id);
						_input_source_unref0 (source);
						_g_variant_unref0 (val);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_g_free0 (type);
				_g_free0 (id);
				_input_source_unref0 (source);
			}
		}
	}
	_tmp47_ = self->priv->sources;
	_tmp48_ = _tmp47_->len;
	if (_tmp48_ == ((guint) 0)) {
		InputSource* _tmp49_ = NULL;
		GArray* _tmp50_ = NULL;
		guint _tmp51_ = 0U;
		GArray* _tmp52_ = NULL;
		InputSource* _tmp53_ = NULL;
		InputSource* _tmp54_ = NULL;
		_tmp49_ = self->priv->fallback;
		_tmp50_ = self->priv->sources;
		_tmp51_ = _tmp50_->len;
		_tmp49_->idx = _tmp51_;
		_tmp52_ = self->priv->sources;
		_tmp53_ = self->priv->fallback;
		_tmp54_ = _input_source_ref0 (_tmp53_);
		g_array_append_val (_tmp52_, _tmp54_);
	}
	keyboard_layout_applet_reset_keyboards (self);
	_g_variant_unref0 (val);
}


static gchar* keyboard_layout_applet_get_xkb_description (KeyboardLayoutApplet* self, const gchar* id) {
	gchar* result = NULL;
	gchar* display_name = NULL;
	gchar* short_name = NULL;
	gchar* xkb_layout = NULL;
	gchar* xkb_variant = NULL;
	GnomeXkbInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	xkb_variant = NULL;
	_tmp0_ = self->priv->xkb;
	_tmp1_ = id;
	_tmp6_ = gnome_xkb_info_get_layout_info (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	_g_free0 (display_name);
	_tmp7_ = g_strdup (_tmp2_);
	display_name = _tmp7_;
	_g_free0 (short_name);
	_tmp8_ = g_strdup (_tmp3_);
	short_name = _tmp8_;
	_g_free0 (xkb_layout);
	_tmp9_ = g_strdup (_tmp4_);
	xkb_layout = _tmp9_;
	_g_free0 (xkb_variant);
	_tmp10_ = g_strdup (_tmp5_);
	xkb_variant = _tmp10_;
	if (_tmp6_) {
		result = display_name;
		_g_free0 (xkb_variant);
		_g_free0 (xkb_layout);
		_g_free0 (short_name);
		return result;
	}
	_tmp11_ = id;
	_tmp12_ = g_strdup (_tmp11_);
	result = _tmp12_;
	_g_free0 (xkb_variant);
	_g_free0 (xkb_layout);
	_g_free0 (short_name);
	_g_free0 (display_name);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void keyboard_layout_applet_update_fallback (KeyboardLayoutApplet* self) {
	gchar* type = NULL;
	gchar* id = NULL;
	gchar* locale = NULL;
	gchar** _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* display_name = NULL;
	gchar* short_name = NULL;
	gchar* xkb_layout = NULL;
	gchar* xkb_variant = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GnomeXkbInfo* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	type = NULL;
	id = NULL;
	_tmp1_ = _tmp0_ = g_get_language_names ();
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_strdup (_tmp2_);
	locale = _tmp3_;
	display_name = NULL;
	short_name = NULL;
	xkb_layout = NULL;
	xkb_variant = NULL;
	_tmp4_ = locale;
	_tmp5_ = string_contains (_tmp4_, "_");
	if (!_tmp5_) {
		gchar* _tmp6_ = NULL;
		_tmp6_ = g_strdup (DEFAULT_LOCALE);
		_g_free0 (locale);
		locale = _tmp6_;
	}
	_tmp7_ = locale;
	_tmp10_ = gnome_get_input_source_from_locale (_tmp7_, &_tmp8_, &_tmp9_);
	_g_free0 (type);
	_tmp11_ = g_strdup (_tmp8_);
	type = _tmp11_;
	_g_free0 (id);
	_tmp12_ = g_strdup (_tmp9_);
	id = _tmp12_;
	if (!_tmp10_) {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gnome_get_input_source_from_locale (DEFAULT_LOCALE, &_tmp13_, &_tmp14_);
		_g_free0 (type);
		_tmp15_ = g_strdup (_tmp13_);
		type = _tmp15_;
		_g_free0 (id);
		_tmp16_ = g_strdup (_tmp14_);
		id = _tmp16_;
	}
	_tmp17_ = self->priv->xkb;
	_tmp18_ = id;
	_tmp23_ = gnome_xkb_info_get_layout_info (_tmp17_, _tmp18_, &_tmp19_, &_tmp20_, &_tmp21_, &_tmp22_);
	_g_free0 (display_name);
	_tmp24_ = g_strdup (_tmp19_);
	display_name = _tmp24_;
	_g_free0 (short_name);
	_tmp25_ = g_strdup (_tmp20_);
	short_name = _tmp25_;
	_g_free0 (xkb_layout);
	_tmp26_ = g_strdup (_tmp21_);
	xkb_layout = _tmp26_;
	_g_free0 (xkb_variant);
	_tmp27_ = g_strdup (_tmp22_);
	xkb_variant = _tmp27_;
	if (_tmp23_) {
		InputSource* _tmp28_ = NULL;
		AppletIBusManager* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		InputSource* _tmp34_ = NULL;
		InputSource* _tmp35_ = NULL;
		_tmp29_ = self->priv->ibus_manager;
		_tmp30_ = id;
		_tmp31_ = xkb_layout;
		_tmp32_ = xkb_variant;
		_tmp33_ = display_name;
		_tmp34_ = input_source_new (_tmp29_, _tmp30_, (guint) 0, _tmp31_, _tmp32_, _tmp33_, TRUE, &_inner_error_);
		_tmp28_ = _tmp34_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (xkb_variant);
			_g_free0 (xkb_layout);
			_g_free0 (short_name);
			_g_free0 (display_name);
			_g_free0 (locale);
			_g_free0 (id);
			_g_free0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp35_ = _tmp28_;
		_tmp28_ = NULL;
		_input_source_unref0 (self->priv->fallback);
		self->priv->fallback = _tmp35_;
		_input_source_unref0 (_tmp28_);
	} else {
		InputSource* _tmp36_ = NULL;
		AppletIBusManager* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		InputSource* _tmp39_ = NULL;
		InputSource* _tmp40_ = NULL;
		_tmp37_ = self->priv->ibus_manager;
		_tmp38_ = id;
		_tmp39_ = input_source_new (_tmp37_, _tmp38_, (guint) 0, DEFAULT_LAYOUT, DEFAULT_VARIANT, NULL, TRUE, &_inner_error_);
		_tmp36_ = _tmp39_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (xkb_variant);
			_g_free0 (xkb_layout);
			_g_free0 (short_name);
			_g_free0 (display_name);
			_g_free0 (locale);
			_g_free0 (id);
			_g_free0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp40_ = _tmp36_;
		_tmp36_ = NULL;
		_input_source_unref0 (self->priv->fallback);
		self->priv->fallback = _tmp40_;
		_input_source_unref0 (_tmp36_);
	}
	_g_free0 (xkb_variant);
	_g_free0 (xkb_layout);
	_g_free0 (short_name);
	_g_free0 (display_name);
	_g_free0 (locale);
	_g_free0 (id);
	_g_free0 (type);
}


/**
     * Update our knowledge of the currently selected keyboard layout
     */
static void keyboard_layout_applet_update_current (KeyboardLayoutApplet* self) {
	guint id = 0U;
	GSettings* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkWidget* child = NULL;
	GtkStack* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkWidget* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkListBox* _tmp10_ = NULL;
	GList* _tmp11_ = NULL;
	GtkStack* _tmp21_ = NULL;
	GtkWidget* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_uint (_tmp0_, "current");
	id = _tmp1_;
	_tmp2_ = self->priv->label_stack;
	_tmp3_ = id;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_stack_get_child_by_name (_tmp2_, _tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp5_);
	child = _tmp8_;
	_tmp9_ = child;
	if (_tmp9_ == NULL) {
		g_message ("KeyboardLayoutApplet.vala:474: WARNING: Missing child in layout!!");
		_g_object_unref0 (child);
		return;
	}
	_tmp10_ = self->priv->listbox;
	_tmp11_ = gtk_container_get_children ((GtkContainer*) _tmp10_);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp11_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* _tmp12_ = NULL;
			GtkWidget* row = NULL;
			_tmp12_ = _g_object_ref0 ((GtkWidget*) row_it->data);
			row = _tmp12_;
			{
				InputSourceMenuItem* item = NULL;
				GtkWidget* _tmp13_ = NULL;
				GtkWidget* _tmp14_ = NULL;
				InputSourceMenuItem* _tmp15_ = NULL;
				InputSourceMenuItem* _tmp16_ = NULL;
				guint _tmp17_ = 0U;
				guint _tmp18_ = 0U;
				_tmp13_ = row;
				_tmp14_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_bin_get_type (), GtkBin));
				_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, TYPE_INPUT_SOURCE_MENU_ITEM) ? ((InputSourceMenuItem*) _tmp14_) : NULL);
				item = _tmp15_;
				_tmp16_ = item;
				_tmp17_ = _tmp16_->idx;
				_tmp18_ = id;
				if (_tmp17_ == _tmp18_) {
					InputSourceMenuItem* _tmp19_ = NULL;
					_tmp19_ = item;
					input_source_menu_item_set_ticked (_tmp19_, TRUE);
				} else {
					InputSourceMenuItem* _tmp20_ = NULL;
					_tmp20_ = item;
					input_source_menu_item_set_ticked (_tmp20_, FALSE);
				}
				_g_object_unref0 (item);
				_g_object_unref0 (row);
			}
		}
		_g_list_free0 (row_collection);
	}
	_tmp21_ = self->priv->label_stack;
	_tmp22_ = child;
	gtk_stack_set_visible_child (_tmp21_, _tmp22_);
	_g_object_unref0 (child);
}


static void keyboard_layout_applet_real_update_popovers (BudgieApplet* base, BudgiePopoverManager* manager) {
	KeyboardLayoutApplet * self;
	BudgiePopoverManager* _tmp0_ = NULL;
	BudgiePopoverManager* _tmp1_ = NULL;
	BudgiePopoverManager* _tmp2_ = NULL;
	GtkEventBox* _tmp3_ = NULL;
	GtkPopover* _tmp4_ = NULL;
	self = (KeyboardLayoutApplet*) base;
	_tmp0_ = manager;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp1_;
	_tmp2_ = manager;
	_tmp3_ = self->priv->widget;
	_tmp4_ = self->priv->popover;
	budgie_popover_manager_register_popover (_tmp2_, (GtkWidget*) _tmp3_, _tmp4_);
}


static void keyboard_layout_applet_class_init (KeyboardLayoutAppletClass * klass) {
	keyboard_layout_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KeyboardLayoutAppletPrivate));
	((BudgieAppletClass *) klass)->update_popovers = keyboard_layout_applet_real_update_popovers;
	G_OBJECT_CLASS (klass)->finalize = keyboard_layout_applet_finalize;
}


static void keyboard_layout_applet_instance_init (KeyboardLayoutApplet * self) {
	self->priv = KEYBOARD_LAYOUT_APPLET_GET_PRIVATE (self);
	self->priv->manager = NULL;
	self->priv->ibus_manager = NULL;
}


static void keyboard_layout_applet_finalize (GObject* obj) {
	KeyboardLayoutApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEYBOARD_LAYOUT_APPLET, KeyboardLayoutApplet);
	_g_object_unref0 (self->priv->widget);
	_g_object_unref0 (self->priv->img_wrap);
	_g_object_unref0 (self->priv->img);
	_g_object_unref0 (self->priv->settings);
	_g_array_unref0 (self->priv->sources);
	_input_source_unref0 (self->priv->fallback);
	_g_object_unref0 (self->priv->xkb);
	_g_object_unref0 (self->priv->label_stack);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->listbox);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->ibus_manager);
	G_OBJECT_CLASS (keyboard_layout_applet_parent_class)->finalize (obj);
}


GType keyboard_layout_applet_get_type (void) {
	return keyboard_layout_applet_type_id;
}


GType keyboard_layout_applet_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardLayoutAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_layout_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardLayoutApplet), 0, (GInstanceInitFunc) keyboard_layout_applet_instance_init, NULL };
	keyboard_layout_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "KeyboardLayoutApplet", &g_define_type_info, 0);
	return keyboard_layout_applet_type_id;
}


void peas_register_types (GTypeModule* module) {
	PeasObjectModule* objmodule = NULL;
	GTypeModule* _tmp0_ = NULL;
	PeasObjectModule* _tmp1_ = NULL;
	g_return_if_fail (module != NULL);
	keyboard_layout_plugin_register_type (module);
	applet_ibus_manager_register_type (module);
	input_source_register_type (module);
	input_source_menu_item_register_type (module);
	keyboard_layout_applet_register_type (module);
	_tmp0_ = module;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, peas_object_module_get_type ()) ? ((PeasObjectModule*) _tmp0_) : NULL);
	objmodule = _tmp1_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_KEYBOARD_LAYOUT_PLUGIN);
	_g_object_unref0 (objmodule);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



