#ifndef H_CDW_MAIN
#define H_CDW_MAIN





#include <dirent.h> /* PATH_MAX */
#include <limits.h> /* PATH_MAX on Alpine Linux */





/* About 'ENTER' and 'ESCAPE':
   ncurses defines some symbolic names for the two keys, but
   they tend not to work. '10' and '27' seem to work fine. */
#define CDW_KEY_ENTER    10
#define CDW_KEY_ESCAPE   27
#define CDW_KEY_TAB     '\t'
#define CDW_KEY_BTAB    KEY_BTAB
#define CDW_KEY_SPACE    ' '
/* End of Transmission, Ctrl+D. Right now used in place where child
   process is waiting for keyboard input. */
#define CDW_KEY_EOT       4


/* Length of input fields. Does not include +1 for NUL terminating a
   (char *) string. */
/* I think that I'm presenting almost all of mkudffs options (with
   perhaps one exception), so the field for "other" options doesn't
   need to be very long. */
#define CDW_MKUDFFS_OTHER_OPTIONS_LEN_MAX    200
/* rsync provides quite a few command-line options. 600 should be
   enough to store them. */
#define CDW_RSYNC_OPTIONS_LEN_MAX            600


/* Boolean, but with three values.
   FIXME: this is not a good idea, seriously. Fix this, get rid of this enum. */
enum {
       	CDW_UNKNOWN = -1, /* Sometimes may be used as initial value. */
	CDW_FALSE   =  0,
	CDW_TRUE    = +1
};


#define CDW_1_GIGA    1073741824   /* 1024 * 1024 * 1024 */
#define CDW_1_MEGA       1048576   /* 1024 * 1024 */



/**
 * \brief Return values of most of cdw functions
 *
 * Introduced to avoid using magic numbers and to increase redability of code.
 */
typedef enum cdw_return_value {
	CDW_OK = 0,        /**< \brief usually means that function call was successful, also means pressing CDW_ENTER in buttonless widgets or OK/YES button in widgets with buttons */
	CDW_CANCEL = -1,   /**< \brief use e.g after user pressed CDW_ESCAPE in buttonless widgets, when user selected Cancel in widgets with buttons or sometimes when function returns with failure */
	CDW_NO = -2,       /**< \brief use after user pressed NO in widgets with buttons */
	CDW_ERROR = -3     /**< \brief general error, may be used when no other error applies */
} cdw_rv_t;


typedef long long signed int cdw_id_t;

typedef struct {
	cdw_id_t id;
	const char *label;
} cdw_id_clabel_t;

typedef struct {
	cdw_id_t id;
	char *label;
} cdw_id_label_t;


/* Some widgets have table of return keys - keys on which a driver
   returns control to caller. 20 keys seems to be reasonable limit at
   this time. There is no guard, code handling return keys must use
   n_return_keys variable. */
#define CDW_WIDGET_N_RETURN_KEYS_MAX 20
#define N_RETURN_KEYS_MAX CDW_WIDGET_N_RETURN_KEYS_MAX


typedef struct cdw_widget_s cdw_widget_t;
/* Common information about widgets.

   Does a widget type have this variable as a field?

   CDW_WIDGET_ID_STATIC_LABEL      - no
   CDW_WIDGET_ID_CHECKBOX          - yes
   CDW_WIDGET_ID_DROPDOWN          - yes
   CDW_WIDGET_ID_BUTTON            - yes
   CDW_WIDGET_ID_TEXT              - no
   CDW_WIDGET_ID_SAFE_INPUT_LINE   - yes
   CDW_WIDGET_ID_DYNAMIC_LABEL     - yes
   CDW_WIDGET_ID_FILE_SELECTOR     - yes (fs browser)
 */
struct cdw_widget_s {

	int type_id; /* STATIC_LABEL, CHECKBOX, DROPDOWN, etc. */

	int return_keys[CDW_WIDGET_N_RETURN_KEYS_MAX];
	int n_return_keys;

	void (* add_return_key)(cdw_widget_t *widget, int key);

	void *self; /* A widget of type 'static label', 'checkbox', etc., owning this cdw_widget_t variable. */
};





/* ugly, this belong to user interface */
struct cdw_form_type;
typedef struct cdw_form_type cdw_form_t;
typedef int (* cdw_form_widget_function_t)(cdw_form_t *, void *);

typedef void (* cdw_deallocator_t)(void *ptr);


#endif /* H_CDW_MAIN */
