// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/core_extensions_api_provider.h"

#include "extensions/common/api/api_features.h"
#include "extensions/common/api/behavior_features.h"
#include "extensions/common/api/generated_schemas.h"
#include "extensions/common/api/manifest_features.h"
#include "extensions/common/api/permission_features.h"
#include "extensions/common/common_manifest_handlers.h"
#include "extensions/common/extensions_aliases.h"
#include "extensions/common/features/json_feature_provider_source.h"
#include "extensions/common/permissions/permissions_info.h"
#include "extensions/grit/extensions_resources.h"

namespace extensions {

CoreExtensionsAPIProvider::CoreExtensionsAPIProvider() {}
CoreExtensionsAPIProvider::~CoreExtensionsAPIProvider() = default;

void CoreExtensionsAPIProvider::AddAPIFeatures(FeatureProvider* provider) {
  AddCoreAPIFeatures(provider);
}

void CoreExtensionsAPIProvider::AddManifestFeatures(FeatureProvider* provider) {
  AddCoreManifestFeatures(provider);
}

void CoreExtensionsAPIProvider::AddPermissionFeatures(
    FeatureProvider* provider) {
  AddCorePermissionFeatures(provider);
}

void CoreExtensionsAPIProvider::AddBehaviorFeatures(FeatureProvider* provider) {
  AddCoreBehaviorFeatures(provider);
}

void CoreExtensionsAPIProvider::AddAPIJSONSources(
    JSONFeatureProviderSource* json_source) {
  json_source->LoadJSON(IDR_EXTENSION_API_FEATURES);
}

bool CoreExtensionsAPIProvider::IsAPISchemaGenerated(const std::string& name) {
  return api::GeneratedSchemas::IsGenerated(name);
}

base::StringPiece CoreExtensionsAPIProvider::GetAPISchema(
    const std::string& name) {
  return api::GeneratedSchemas::Get(name);
}

void CoreExtensionsAPIProvider::AddPermissionsProviders(
    PermissionsInfo* permissions_info) {
  permissions_info->AddProvider(api_permissions_,
                                GetExtensionsPermissionAliases());
}

void CoreExtensionsAPIProvider::RegisterManifestHandlers() {
  RegisterCommonManifestHandlers();
}

}  // namespace extensions
