/*
 * $Id: osr_python.i 32939 2016-01-11 18:01:28Z rouault $
 *
 * python specific code for ogr bindings.
 */

%feature("autodoc");

#ifndef FROM_GDAL_I
%include "python_exceptions.i"
%include "python_strings.i"
#endif

%{
static PyObject *
py_OPTGetProjectionMethods(PyObject *self, PyObject *args) {

    PyObject *py_MList;
    char     **papszMethods;
    int      iMethod;

    self = self;
    args = args;

    papszMethods = OPTGetProjectionMethods();
    py_MList = PyList_New(CSLCount(papszMethods));

    for( iMethod = 0; papszMethods[iMethod] != NULL; iMethod++ )
    {
	char    *pszUserMethodName;
	char    **papszParameters;
	PyObject *py_PList;
	int       iParam;

	papszParameters = OPTGetParameterList( papszMethods[iMethod],
					       &pszUserMethodName );
        if( papszParameters == NULL )
        {
            CSLDestroy( papszMethods );
            return NULL;
        }

	py_PList = PyList_New(CSLCount(papszParameters));
	for( iParam = 0; papszParameters[iParam] != NULL; iParam++ )
       	{
	    char    *pszType;
	    char    *pszUserParamName;
            double  dfDefault;

	    OPTGetParameterInfo( papszMethods[iMethod],
				 papszParameters[iParam],
				 &pszUserParamName,
				 &pszType, &dfDefault );
	    PyList_SetItem(py_PList, iParam,
			   Py_BuildValue("(sssd)",
					 papszParameters[iParam],
					 pszUserParamName,
                                         pszType, dfDefault ));
	}

	CSLDestroy( papszParameters );

	PyList_SetItem(py_MList, iMethod,
		       Py_BuildValue("(ssO)",
		                     papszMethods[iMethod],
				     pszUserMethodName,
		                     py_PList));

        Py_XDECREF( py_PList );
    }

    CSLDestroy( papszMethods );

    return py_MList;
}
%}
%native(GetProjectionMethods) py_OPTGetProjectionMethods;

%include typemaps_python.i
