/*
  Copyright (c) 2015 Red Hat, Inc. <http://www.redhat.com>
  This file is part of GlusterFS.

  This file is licensed to you under your choice of the GNU Lesser
  General Public License, version 3 or any later version (LGPLv3 or
  later), or the GNU General Public License, version 2 (GPLv2), in all
  cases as published by the Free Software Foundation.
*/

#ifndef _RPC_TRANS_RDMA_MESSAGES_H_
#define _RPC_TRANS_RDMA_MESSAGES_H_

#include "glfs-message-id.h"

/* To add new message IDs, append new identifiers at the end of the list.
 *
 * Never remove a message ID. If it's not used anymore, you can rename it or
 * leave it as it is, but not delete it. This is to prevent reutilization of
 * IDs by other messages.
 *
 * The component name must match one of the entries defined in
 * glfs-message-id.h.
 */

GLFS_MSGID(RPC_TRANS_RDMA,
        RDMA_MSG_PORT_BIND_FAILED,
        RDMA_MSG_POST_CREATION_FAILED,
        RDMA_MSG_DEREGISTER_ARENA_FAILED,
        RDMA_MSG_MR_ALOC_FAILED,
        RDMA_MSG_PREREG_BUFFER_FAILED,
        RDMA_MSG_CQ_CREATION_FAILED,
        RDMA_MSG_REQ_NOTIFY_CQ_REVQ_FAILED,
        RDMA_MSG_QUERY_DEVICE_FAILED,
        RDMA_MSG_REQ_NOTIFY_CQ_SENDQ_FAILED,
        RDMA_MSG_SEND_COMP_CHAN_FAILED,
        RDMA_MSG_RECV_COMP_CHAN_FAILED,
        RDMA_MSG_ALOC_PROT_DOM_FAILED,
        RDMA_MSG_CRE_SRQ_FAILED,
        RDMA_MSG_ALOC_POST_FAILED,
        RDMA_MSG_SEND_COMP_THREAD_FAILED,
        RDMA_MSG_RECV_COMP_THREAD_FAILED,
        RDMA_MSG_ASYNC_EVENT_THEAD_FAILED,
        RDMA_MSG_GET_DEVICE_NAME_FAILED,
        RDMA_MSG_GET_IB_DEVICE_FAILED,
        RDMA_MSG_CREAT_INC_TRANS_FAILED,
        RDMA_MSG_CREAT_QP_FAILED,
        RDMA_MSG_ACCEPT_FAILED,
        RDMA_MSG_CONNECT_FAILED,
        RDMA_MSG_ROUTE_RESOLVE_FAILED,
        RDMA_MSG_GET_DEVICE_FAILED,
        RDMA_MSG_PEER_DISCONNECTED,
        RDMA_MSG_ENCODE_ERROR,
        RDMA_MSG_POST_SEND_FAILED,
        RDMA_MSG_READ_CHUNK_VECTOR_FAILED,
        RDMA_MSG_WRITE_CHUNK_VECTOR_FAILED,
        RDMA_MSG_WRITE_REPLY_CHUNCK_CONFLICT,
        RDMA_MSG_CHUNK_COUNT_GREAT_MAX_SEGMENTS,
        RDMA_MSG_CREATE_READ_CHUNK_FAILED,
        RDMA_MSG_CREATE_WRITE_REPLAY_FAILED,
        RDMA_MSG_SEND_SIZE_GREAT_INLINE_THRESHOLD,
        RDMA_MSG_REG_ACCESS_LOCAL_WRITE_FAILED,
        RDMA_MSG_WRITE_PEER_FAILED,
        RDMA_MSG_SEND_REPLY_FAILED,
        RDMA_MSG_INVALID_CHUNK_TYPE,
        RDMA_MSG_PROC_IOQ_ENTRY_FAILED,
        RDMA_MSG_NEW_IOQ_ENTRY_FAILED,
        RDMA_MSG_RPC_REPLY_CREATE_FAILED,
        RDMA_MSG_GET_READ_CHUNK_FAILED,
        RDMA_MSG_GET_WRITE_CHUNK_FAILED,
        RDMA_MSG_REPLY_INFO_ALLOC_FAILED,
        RDMA_MSG_RDMA_ERROR_RECEIVED,
        RDMA_MSG_GET_REQ_INFO_RPC_FAILED,
        RDMA_MSG_POLL_IN_NOTIFY_FAILED,
        RDMA_MSG_HEADER_DECODE_FAILED,
        RDMA_MSG_EVENT_SRQ_LIMIT_REACHED,
        RDMA_MSG_UNRECG_MQ_VALUE,
        RDMA_MSG_BUFFER_ERROR,
        RDMA_MSG_OPTION_SET_FAILED,
        RDMA_MSG_LISTEN_FAILED,
        RDMA_MSG_INIT_IB_DEVICE_FAILED,
        RDMA_MSG_WRITE_CLIENT_ERROR,
        RDMA_MSG_CHUNKLIST_ERROR,
        RDMA_MSG_INVALID_ENTRY,
        RDMA_MSG_READ_CLIENT_ERROR,
        RDMA_MSG_RPC_ST_ERROR,
        RDMA_MSG_PEER_READ_FAILED,
        RDMA_MSG_POST_MISSING,
        RDMA_MSG_PEER_REQ_FAILED,
        RDMA_MSG_PEER_REP_FAILED,
        RDMA_MSG_EVENT_ERROR,
        RDMA_MSG_IBV_GET_CQ_FAILED,
        RDMA_MSG_IBV_REQ_NOTIFY_CQ_FAILED,
        RDMA_MSG_RECV_ERROR,
        RDMA_MSG_IBV_POLL_CQ_ERROR,
        RDMA_MSG_RDMA_HANDLE_FAILED,
        RDMA_MSG_CM_EVENT_FAILED,
        RDMA_MSG_CLIENT_BIND_FAILED,
        RDMA_MSG_RDMA_RESOLVE_ADDR_FAILED,
        RDMA_MSG_NW_ADDR_UNKNOWN,
        RDMA_MSG_RDMA_BIND_ADDR_FAILED,
        RDMA_MSG_SEND_CLIENT_ERROR,
        RDMA_MSG_UNRECG_MTU_VALUE
);

#endif /* !_RPC_TRANS_RDMA_MESSAGES_H_ */

