/* nibbles-view.c generated by valac 0.40.8, the Vala compiler
 * generated from nibbles-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <clutter-gtk/clutter-gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <canberra-gtk.h>
#include <canberra.h>


#define TYPE_WORM_ACTOR (worm_actor_get_type ())
#define WORM_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_ACTOR, WormActor))
#define WORM_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_ACTOR, WormActorClass))
#define IS_WORM_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_ACTOR))
#define IS_WORM_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_ACTOR))
#define WORM_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_ACTOR, WormActorClass))

typedef struct _WormActor WormActor;
typedef struct _WormActorClass WormActorClass;
typedef struct _WormActorPrivate WormActorPrivate;
enum  {
	WORM_ACTOR_0_PROPERTY,
	WORM_ACTOR_NUM_PROPERTIES
};
static GParamSpec* worm_actor_properties[WORM_ACTOR_NUM_PROPERTIES];

#define TYPE_BONUS_TEXTURE (bonus_texture_get_type ())
#define BONUS_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS_TEXTURE, BonusTexture))
#define BONUS_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS_TEXTURE, BonusTextureClass))
#define IS_BONUS_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS_TEXTURE))
#define IS_BONUS_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS_TEXTURE))
#define BONUS_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS_TEXTURE, BonusTextureClass))

typedef struct _BonusTexture BonusTexture;
typedef struct _BonusTextureClass BonusTextureClass;
typedef struct _BonusTexturePrivate BonusTexturePrivate;
enum  {
	BONUS_TEXTURE_0_PROPERTY,
	BONUS_TEXTURE_NUM_PROPERTIES
};
static GParamSpec* bonus_texture_properties[BONUS_TEXTURE_NUM_PROPERTIES];

#define TYPE_WARP_TEXTURE (warp_texture_get_type ())
#define WARP_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_TEXTURE, WarpTexture))
#define WARP_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_TEXTURE, WarpTextureClass))
#define IS_WARP_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_TEXTURE))
#define IS_WARP_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_TEXTURE))
#define WARP_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_TEXTURE, WarpTextureClass))

typedef struct _WarpTexture WarpTexture;
typedef struct _WarpTextureClass WarpTextureClass;
typedef struct _WarpTexturePrivate WarpTexturePrivate;
enum  {
	WARP_TEXTURE_0_PROPERTY,
	WARP_TEXTURE_NUM_PROPERTIES
};
static GParamSpec* warp_texture_properties[WARP_TEXTURE_NUM_PROPERTIES];

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;
typedef struct _NibblesViewPrivate NibblesViewPrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
enum  {
	NIBBLES_VIEW_0_PROPERTY,
	NIBBLES_VIEW_NAME_LABELS_PROPERTY,
	NIBBLES_VIEW_GAME_PROPERTY,
	NIBBLES_VIEW_NUM_PROPERTIES
};
static GParamSpec* nibbles_view_properties[NIBBLES_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

#define TYPE_BONI (boni_get_type ())
#define BONI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONI, Boni))
#define BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONI, BoniClass))
#define IS_BONI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONI))
#define IS_BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONI))
#define BONI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONI, BoniClass))

typedef struct _Boni Boni;
typedef struct _BoniClass BoniClass;

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;
typedef struct _WarpManagerPrivate WarpManagerPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _NibblesGamePrivate NibblesGamePrivate;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _WormPrivate WormPrivate;

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;
#define _position_free0(var) ((var == NULL) ? NULL : (var = (position_free (var), NULL)))

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _BoniPrivate BoniPrivate;
typedef struct _BonusPrivate BonusPrivate;

#define TYPE_BONUS_TYPE (bonus_type_get_type ())
typedef struct _WarpPrivate WarpPrivate;

struct _WormActor {
	ClutterActor parent_instance;
	WormActorPrivate * priv;
};

struct _WormActorClass {
	ClutterActorClass parent_class;
};

struct _BonusTexture {
	GtkClutterTexture parent_instance;
	BonusTexturePrivate * priv;
};

struct _BonusTextureClass {
	GtkClutterTextureClass parent_class;
};

struct _WarpTexture {
	GtkClutterTexture parent_instance;
	WarpTexturePrivate * priv;
};

struct _WarpTextureClass {
	GtkClutterTextureClass parent_class;
};

struct _NibblesView {
	GtkClutterEmbed parent_instance;
	NibblesViewPrivate * priv;
	gboolean is_muted;
};

struct _NibblesViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _NibblesViewPrivate {
	GdkPixbuf* wall_pixmaps[11];
	GdkPixbuf* worm_pixmaps[6];
	GdkPixbuf* boni_pixmaps[9];
	ClutterStage* stage;
	ClutterActor* level;
	ClutterActor* _name_labels;
	GeeHashMap* worm_actors;
	GeeHashMap* bonus_actors;
	GeeHashMap* warp_actors;
	NibblesGame* _game;
};

struct _WarpManager {
	GObject parent_instance;
	WarpManagerPrivate * priv;
	GeeLinkedList* warps;
};

struct _WarpManagerClass {
	GObjectClass parent_class;
};

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint* board;
	gint board_length1;
	gint board_length2;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Block6Data {
	int _ref_count_;
	NibblesView* self;
	Worm* worm;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Position {
	gint x;
	gint y;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Block7Data {
	int _ref_count_;
	NibblesView* self;
	Worm* worm;
};

struct _Boni {
	GObject parent_instance;
	BoniPrivate * priv;
	GeeLinkedList* bonuses;
	gint missed;
	gint numleft;
	gint numboni;
	gint numbonuses;
};

struct _BoniClass {
	GObjectClass parent_class;
};

typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;

struct _Bonus {
	GObject parent_instance;
	BonusPrivate * priv;
	gint x;
	gint y;
	BonusType type;
	gboolean fake;
	gint countdown;
};

struct _BonusClass {
	GObjectClass parent_class;
};

struct _Warp {
	GObject parent_instance;
	WarpPrivate * priv;
	gint x;
	gint y;
	gint wx;
	gint wy;
};

struct _WarpClass {
	GObjectClass parent_class;
};


static gpointer worm_actor_parent_class = NULL;
static gpointer bonus_texture_parent_class = NULL;
static gpointer warp_texture_parent_class = NULL;
static gpointer nibbles_view_parent_class = NULL;
extern gchar** nibbles_view_color_lookup;
extern gint nibbles_view_color_lookup_length1;
gchar** nibbles_view_color_lookup = NULL;
gint nibbles_view_color_lookup_length1 = 0;

GType worm_actor_get_type (void) G_GNUC_CONST;
static void worm_actor_real_show (ClutterActor* base);
#define NIBBLES_GAME_GAMEDELAY 35
static void worm_actor_real_hide (ClutterActor* base);
WormActor* worm_actor_new (void);
WormActor* worm_actor_construct (GType object_type);
GType bonus_texture_get_type (void) G_GNUC_CONST;
#define BONUS_TEXTURE_SIZE_MULTIPLIER ((gfloat) 2)
static void bonus_texture_real_show (ClutterActor* base);
void bonus_texture_set_size (BonusTexture* self,
                             gfloat width,
                             gfloat height);
BonusTexture* bonus_texture_new (void);
BonusTexture* bonus_texture_construct (GType object_type);
GType warp_texture_get_type (void) G_GNUC_CONST;
#define WARP_TEXTURE_SIZE_MULTIPLIER ((gfloat) 2)
static void warp_texture_real_show (ClutterActor* base);
static void warp_texture_real_hide (ClutterActor* base);
void warp_texture_set_size (WarpTexture* self,
                            gfloat width,
                            gfloat height);
WarpTexture* warp_texture_new (void);
WarpTexture* warp_texture_construct (GType object_type);
GType nibbles_view_get_type (void) G_GNUC_CONST;
GType worm_get_type (void) G_GNUC_CONST;
GType bonus_get_type (void) G_GNUC_CONST;
GType warp_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
#define NIBBLES_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NIBBLES_VIEW, NibblesViewPrivate))
#define NIBBLES_VIEW_NUM_COLORS 6
NibblesView* nibbles_view_new (NibblesGame* game);
NibblesView* nibbles_view_construct (GType object_type,
                                     NibblesGame* game);
void nibbles_view_set_game (NibblesView* self,
                            NibblesGame* value);
#define NIBBLES_GAME_MINIMUM_TILE_SIZE 7
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
static void nibbles_view_load_pixmap (NibblesView* self);
void nibbles_view_new_level (NibblesView* self,
                             gint level);
NibblesGame* nibbles_view_get_game (NibblesView* self);
GType boni_get_type (void) G_GNUC_CONST;
Boni* nibbles_game_get_boni (NibblesGame* self);
void boni_reset (Boni* self,
                 gint numworms);
gint nibbles_game_get_numworms (NibblesGame* self);
GType warp_manager_get_type (void) G_GNUC_CONST;
WarpManager* nibbles_game_get_warp_manager (NibblesGame* self);
#define NIBBLES_GAME_EMPTYCHAR 'a'
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
GType worm_direction_get_type (void) G_GNUC_CONST;
void worm_set_start (Worm* self,
                     gint xhead,
                     gint yhead,
                     WormDirection direction);
static void nibbles_view_load_level (NibblesView* self);
gint nibbles_game_get_tile_size (NibblesGame* self);
void warp_manager_add_warp (WarpManager* self,
                            gint* board,
                            int board_length1,
                            int board_length2,
                            gint x,
                            gint y,
                            gint wx,
                            gint wy);
GdkPixbuf* nibbles_view_load_pixmap_file (NibblesView* self,
                                          const gchar* pixmap,
                                          gint xsize,
                                          gint ysize);
void nibbles_view_connect_worm_signals (NibblesView* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void nibbles_view_worm_added_cb (NibblesView* self,
                                 Worm* worm);
static void _nibbles_view_worm_added_cb_worm_added (Worm* _sender,
                                             gpointer self);
static void nibbles_view_worm_finish_added_cb (NibblesView* self,
                                        Worm* worm);
static void _nibbles_view_worm_finish_added_cb_worm_finish_added (Worm* _sender,
                                                           gpointer self);
static void nibbles_view_worm_moved_cb (NibblesView* self,
                                 Worm* worm);
static void _nibbles_view_worm_moved_cb_worm_moved (Worm* _sender,
                                             gpointer self);
static void nibbles_view_worm_rescaled_cb (NibblesView* self,
                                    Worm* worm,
                                    gint tile_size);
static void _nibbles_view_worm_rescaled_cb_worm_rescaled (Worm* _sender,
                                                   gint tile_size,
                                                   gpointer self);
static void nibbles_view_worm_died_cb (NibblesView* self,
                                Worm* worm);
static void _nibbles_view_worm_died_cb_worm_died (Worm* _sender,
                                           gpointer self);
static void nibbles_view_worm_tail_reduced_cb (NibblesView* self,
                                        Worm* worm,
                                        gint erase_size);
static void _nibbles_view_worm_tail_reduced_cb_worm_tail_reduced (Worm* _sender,
                                                           gint erase_size,
                                                           gpointer self);
static void nibbles_view_worm_reversed_cb (NibblesView* self,
                                    Worm* worm);
static void _nibbles_view_worm_reversed_cb_worm_reversed (Worm* _sender,
                                                   gpointer self);
static void ____lambda6_ (Block6Data* _data6_);
gboolean worm_get_is_materialized (Worm* self);
static void _____lambda6__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
void nibbles_view_board_rescale (NibblesView* self,
                                 gint tile_size);
ClutterActor* nibbles_view_get_name_labels (NibblesView* self);
gint worm_get_id (Worm* self);
gint worm_get_length (Worm* self);
GType position_get_type (void) G_GNUC_CONST;
Position* position_dup (const Position* self);
void position_free (Position* self);
GeeLinkedList* worm_get_list (Worm* self);
void worm_get_head (Worm* self,
                    Position * result);
static void nibbles_view_animate_end_game_cb (NibblesView* self);
void nibbles_view_create_name_labels (NibblesView* self);
static void nibbles_view_set_name_labels (NibblesView* self,
                                   ClutterActor* value);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
gchar* nibbles_view_colorval_name (gint colorval);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
void worm_dematerialize (Worm* self,
                         gint* board,
                         int board_length1,
                         int board_length2,
                         gint rounds);
static gboolean __lambda5_ (Block7Data* _data7_);
static gboolean ___lambda5__gsource_func (gpointer self);
static void nibbles_view_play_sound (NibblesView* self,
                              const gchar* name);
static void nibbles_view_bonus_added_cb (NibblesView* self);
GType bonus_type_get_type (void) G_GNUC_CONST;
static void nibbles_view_bonus_removed_cb (NibblesView* self,
                                    Bonus* bonus);
static void nibbles_view_bonus_applied_cb (NibblesView* self,
                                    Bonus* bonus,
                                    Worm* worm);
void nibbles_view_boni_rescale (NibblesView* self,
                                gint tile_size);
static void nibbles_view_warp_added_cb (NibblesView* self,
                                 Warp* warp);
void nibbles_view_warps_rescale (NibblesView* self,
                                 gint tile_size);
static void _nibbles_view_bonus_added_cb_boni_bonus_added (Boni* _sender,
                                                    gpointer self);
static void _nibbles_view_bonus_removed_cb_boni_bonus_removed (Boni* _sender,
                                                        Bonus* bonus,
                                                        gpointer self);
static void _nibbles_view_bonus_applied_cb_nibbles_game_bonus_applied (NibblesGame* _sender,
                                                                Bonus* bonus,
                                                                Worm* worm,
                                                                gpointer self);
static void _nibbles_view_warp_added_cb_warp_manager_warp_added (WarpManager* _sender,
                                                          Warp* warp,
                                                          gpointer self);
static void _nibbles_view_animate_end_game_cb_nibbles_game_animate_end_game (NibblesGame* _sender,
                                                                      gpointer self);
static void nibbles_view_finalize (GObject * obj);
static void _vala_nibbles_view_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_nibbles_view_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static void
worm_actor_real_show (ClutterActor* base)
{
	WormActor * self;
	self = (WormActor*) base;
	CLUTTER_ACTOR_CLASS (worm_actor_parent_class)->show (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	clutter_actor_set_scale ((ClutterActor*) self, 3.0, 3.0);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_CIRC);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 26));
	clutter_actor_set_scale ((ClutterActor*) self, 1.0, 1.0);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0xff);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}


static void
worm_actor_real_hide (ClutterActor* base)
{
	WormActor * self;
	self = (WormActor*) base;
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_IN_QUAD);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
	clutter_actor_set_scale ((ClutterActor*) self, (gdouble) 0.4f, (gdouble) 0.4f);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}


WormActor*
worm_actor_construct (GType object_type)
{
	WormActor * self = NULL;
	self = (WormActor*) g_object_new (object_type, NULL);
	return self;
}


WormActor*
worm_actor_new (void)
{
	return worm_actor_construct (TYPE_WORM_ACTOR);
}


static void
worm_actor_class_init (WormActorClass * klass)
{
	worm_actor_parent_class = g_type_class_peek_parent (klass);
	((ClutterActorClass *) klass)->show = (void (*) (ClutterActor *)) worm_actor_real_show;
	((ClutterActorClass *) klass)->hide = (void (*) (ClutterActor *)) worm_actor_real_hide;
}


static void
worm_actor_instance_init (WormActor * self)
{
}


GType
worm_actor_get_type (void)
{
	static volatile gsize worm_actor_type_id__volatile = 0;
	if (g_once_init_enter (&worm_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WormActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) worm_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WormActor), 0, (GInstanceInitFunc) worm_actor_instance_init, NULL };
		GType worm_actor_type_id;
		worm_actor_type_id = g_type_register_static (clutter_actor_get_type (), "WormActor", &g_define_type_info, 0);
		g_once_init_leave (&worm_actor_type_id__volatile, worm_actor_type_id);
	}
	return worm_actor_type_id__volatile;
}


static void
bonus_texture_real_show (ClutterActor* base)
{
	BonusTexture * self;
	self = (BonusTexture*) base;
	CLUTTER_ACTOR_CLASS (bonus_texture_parent_class)->show ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	clutter_actor_set_scale ((ClutterActor*) self, 3.0, 3.0);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_BOUNCE);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 20));
	clutter_actor_set_scale ((ClutterActor*) self, 1.0, 1.0);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0xff);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}


void
bonus_texture_set_size (BonusTexture* self,
                        gfloat width,
                        gfloat height)
{
	g_return_if_fail (self != NULL);
	clutter_actor_set_size ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture), BONUS_TEXTURE_SIZE_MULTIPLIER * width, BONUS_TEXTURE_SIZE_MULTIPLIER * height);
}


BonusTexture*
bonus_texture_construct (GType object_type)
{
	BonusTexture * self = NULL;
	self = (BonusTexture*) g_object_new (object_type, NULL);
	return self;
}


BonusTexture*
bonus_texture_new (void)
{
	return bonus_texture_construct (TYPE_BONUS_TEXTURE);
}


static void
bonus_texture_class_init (BonusTextureClass * klass)
{
	bonus_texture_parent_class = g_type_class_peek_parent (klass);
	((ClutterActorClass *) klass)->show = (void (*) (ClutterActor *)) bonus_texture_real_show;
}


static void
bonus_texture_instance_init (BonusTexture * self)
{
}


GType
bonus_texture_get_type (void)
{
	static volatile gsize bonus_texture_type_id__volatile = 0;
	if (g_once_init_enter (&bonus_texture_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BonusTextureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bonus_texture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BonusTexture), 0, (GInstanceInitFunc) bonus_texture_instance_init, NULL };
		GType bonus_texture_type_id;
		bonus_texture_type_id = g_type_register_static (gtk_clutter_texture_get_type (), "BonusTexture", &g_define_type_info, 0);
		g_once_init_leave (&bonus_texture_type_id__volatile, bonus_texture_type_id);
	}
	return bonus_texture_type_id__volatile;
}


static void
warp_texture_real_show (ClutterActor* base)
{
	WarpTexture * self;
	self = (WarpTexture*) base;
	CLUTTER_ACTOR_CLASS (warp_texture_parent_class)->show ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	clutter_actor_set_scale ((ClutterActor*) self, 3.0, 3.0);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_CIRC);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
	clutter_actor_set_scale ((ClutterActor*) self, 1.0, 1.0);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0xff);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}


static void
warp_texture_real_hide (ClutterActor* base)
{
	WarpTexture * self;
	self = (WarpTexture*) base;
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_IN_QUAD);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
	clutter_actor_set_scale ((ClutterActor*) self, (gdouble) 0.4f, (gdouble) 0.4f);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}


void
warp_texture_set_size (WarpTexture* self,
                       gfloat width,
                       gfloat height)
{
	g_return_if_fail (self != NULL);
	clutter_actor_set_size ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture), WARP_TEXTURE_SIZE_MULTIPLIER * width, WARP_TEXTURE_SIZE_MULTIPLIER * height);
}


WarpTexture*
warp_texture_construct (GType object_type)
{
	WarpTexture * self = NULL;
	self = (WarpTexture*) g_object_new (object_type, NULL);
	return self;
}


WarpTexture*
warp_texture_new (void)
{
	return warp_texture_construct (TYPE_WARP_TEXTURE);
}


static void
warp_texture_class_init (WarpTextureClass * klass)
{
	warp_texture_parent_class = g_type_class_peek_parent (klass);
	((ClutterActorClass *) klass)->show = (void (*) (ClutterActor *)) warp_texture_real_show;
	((ClutterActorClass *) klass)->hide = (void (*) (ClutterActor *)) warp_texture_real_hide;
}


static void
warp_texture_instance_init (WarpTexture * self)
{
}


GType
warp_texture_get_type (void)
{
	static volatile gsize warp_texture_type_id__volatile = 0;
	if (g_once_init_enter (&warp_texture_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WarpTextureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) warp_texture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WarpTexture), 0, (GInstanceInitFunc) warp_texture_instance_init, NULL };
		GType warp_texture_type_id;
		warp_texture_type_id = g_type_register_static (gtk_clutter_texture_get_type (), "WarpTexture", &g_define_type_info, 0);
		g_once_init_leave (&warp_texture_type_id__volatile, warp_texture_type_id);
	}
	return warp_texture_type_id__volatile;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


NibblesView*
nibbles_view_construct (GType object_type,
                        NibblesGame* game)
{
	NibblesView * self = NULL;
	ClutterActor* _tmp0_;
	ClutterStage* _tmp1_;
	ClutterColor stage_color = {0};
	ClutterColor _tmp2_ = {0};
	ClutterStage* _tmp3_;
	ClutterColor _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp6_;
	GeeHashMap* _tmp7_;
	g_return_val_if_fail (game != NULL, NULL);
	self = (NibblesView*) g_object_new (object_type, NULL);
	nibbles_view_set_game (self, game);
	_tmp0_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, clutter_stage_get_type (), ClutterStage));
	_g_object_unref0 (self->priv->stage);
	self->priv->stage = _tmp1_;
	_tmp2_.red = (guint8) 0x00;
	_tmp2_.green = (guint8) 0x00;
	_tmp2_.blue = (guint8) 0x00;
	_tmp2_.alpha = (guint8) 0xff;
	stage_color = _tmp2_;
	_tmp3_ = self->priv->stage;
	_tmp4_ = stage_color;
	clutter_actor_set_background_color ((ClutterActor*) _tmp3_, &_tmp4_);
	gtk_widget_set_size_request ((GtkWidget*) self, NIBBLES_GAME_MINIMUM_TILE_SIZE * NIBBLES_GAME_WIDTH, NIBBLES_GAME_MINIMUM_TILE_SIZE * NIBBLES_GAME_HEIGHT);
	_tmp5_ = gee_hash_map_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WORM_ACTOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->worm_actors);
	self->priv->worm_actors = _tmp5_;
	_tmp6_ = gee_hash_map_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_BONUS_TEXTURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->bonus_actors);
	self->priv->bonus_actors = _tmp6_;
	_tmp7_ = gee_hash_map_new (TYPE_WARP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WARP_TEXTURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->warp_actors);
	self->priv->warp_actors = _tmp7_;
	nibbles_view_load_pixmap (self);
	return self;
}


NibblesView*
nibbles_view_new (NibblesGame* game)
{
	return nibbles_view_construct (TYPE_NIBBLES_VIEW, game);
}


static gchar*
g_file_stream_read_line (FILE* self)
{
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_;
		GString* _tmp1_;
		gint _tmp3_;
		GString* _tmp4_;
		gint _tmp5_;
		c = fgetc (self);
		_tmp0_ = c;
		if (!(_tmp0_ != EOF)) {
			break;
		}
		_tmp1_ = ret;
		if (_tmp1_ == NULL) {
			GString* _tmp2_;
			_tmp2_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp2_;
		}
		_tmp3_ = c;
		if (_tmp3_ == ((gint) '\n')) {
			break;
		}
		_tmp4_ = ret;
		_tmp5_ = c;
		g_string_append_c ((GString*) _tmp4_, (gchar) _tmp5_);
	}
	_tmp6_ = ret;
	if (_tmp6_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = ret;
		_tmp8_ = ((GString*) _tmp7_)->str;
		_tmp9_ = g_strdup (_tmp8_);
		result = _tmp9_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


void
nibbles_view_new_level (NibblesView* self,
                        gint level)
{
	gchar* level_name = NULL;
	gchar* filename = NULL;
	gchar* tmpboard = NULL;
	gint count = 0;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* file = NULL;
	const gchar* _tmp3_;
	FILE* _tmp4_;
	FILE* _tmp5_;
	GeeHashMap* _tmp17_;
	GeeHashMap* _tmp28_;
	GeeHashMap* _tmp39_;
	NibblesGame* _tmp40_;
	NibblesGame* _tmp41_;
	Boni* _tmp42_;
	Boni* _tmp43_;
	NibblesGame* _tmp44_;
	NibblesGame* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	NibblesGame* _tmp48_;
	NibblesGame* _tmp49_;
	WarpManager* _tmp50_;
	WarpManager* _tmp51_;
	GeeLinkedList* _tmp52_;
	g_return_if_fail (self != NULL);
	count = 0;
	_tmp0_ = g_strdup_printf ("level%03d.gnl", level);
	_g_free0 (level_name);
	level_name = _tmp0_;
	_tmp1_ = level_name;
	_tmp2_ = g_build_filename (PKGDATADIR, "levels", _tmp1_, NULL, NULL);
	_g_free0 (filename);
	filename = _tmp2_;
	_tmp3_ = filename;
	_tmp4_ = g_fopen (_tmp3_, "r");
	_fclose0 (file);
	file = _tmp4_;
	_tmp5_ = file;
	if (_tmp5_ == NULL) {
		const gchar* _tmp6_;
		_tmp6_ = filename;
		g_error ("nibbles-view.vala:198: Nibbles couldn't find pixmap file: %s", _tmp6_);
	}
	{
		GeeIterator* _actor_it = NULL;
		GeeHashMap* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeCollection* _tmp10_;
		GeeIterator* _tmp11_;
		GeeIterator* _tmp12_;
		_tmp7_ = self->priv->worm_actors;
		_tmp8_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_actor_it = _tmp12_;
		while (TRUE) {
			GeeIterator* _tmp13_;
			WormActor* actor = NULL;
			GeeIterator* _tmp14_;
			gpointer _tmp15_;
			WormActor* _tmp16_;
			_tmp13_ = _actor_it;
			if (!gee_iterator_next (_tmp13_)) {
				break;
			}
			_tmp14_ = _actor_it;
			_tmp15_ = gee_iterator_get (_tmp14_);
			actor = (WormActor*) _tmp15_;
			_tmp16_ = actor;
			clutter_actor_destroy ((ClutterActor*) _tmp16_);
			_g_object_unref0 (actor);
		}
		_g_object_unref0 (_actor_it);
	}
	_tmp17_ = self->priv->worm_actors;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp17_);
	{
		GeeIterator* _actor_it = NULL;
		GeeHashMap* _tmp18_;
		GeeCollection* _tmp19_;
		GeeCollection* _tmp20_;
		GeeCollection* _tmp21_;
		GeeIterator* _tmp22_;
		GeeIterator* _tmp23_;
		_tmp18_ = self->priv->bonus_actors;
		_tmp19_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
		_tmp23_ = _tmp22_;
		_g_object_unref0 (_tmp21_);
		_actor_it = _tmp23_;
		while (TRUE) {
			GeeIterator* _tmp24_;
			BonusTexture* actor = NULL;
			GeeIterator* _tmp25_;
			gpointer _tmp26_;
			BonusTexture* _tmp27_;
			_tmp24_ = _actor_it;
			if (!gee_iterator_next (_tmp24_)) {
				break;
			}
			_tmp25_ = _actor_it;
			_tmp26_ = gee_iterator_get (_tmp25_);
			actor = (BonusTexture*) _tmp26_;
			_tmp27_ = actor;
			clutter_actor_destroy ((ClutterActor*) _tmp27_);
			_g_object_unref0 (actor);
		}
		_g_object_unref0 (_actor_it);
	}
	_tmp28_ = self->priv->bonus_actors;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp28_);
	{
		GeeIterator* _actor_it = NULL;
		GeeHashMap* _tmp29_;
		GeeCollection* _tmp30_;
		GeeCollection* _tmp31_;
		GeeCollection* _tmp32_;
		GeeIterator* _tmp33_;
		GeeIterator* _tmp34_;
		_tmp29_ = self->priv->warp_actors;
		_tmp30_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = _tmp31_;
		_tmp33_ = gee_iterable_iterator ((GeeIterable*) _tmp32_);
		_tmp34_ = _tmp33_;
		_g_object_unref0 (_tmp32_);
		_actor_it = _tmp34_;
		while (TRUE) {
			GeeIterator* _tmp35_;
			WarpTexture* actor = NULL;
			GeeIterator* _tmp36_;
			gpointer _tmp37_;
			WarpTexture* _tmp38_;
			_tmp35_ = _actor_it;
			if (!gee_iterator_next (_tmp35_)) {
				break;
			}
			_tmp36_ = _actor_it;
			_tmp37_ = gee_iterator_get (_tmp36_);
			actor = (WarpTexture*) _tmp37_;
			_tmp38_ = actor;
			clutter_actor_destroy ((ClutterActor*) _tmp38_);
			_g_object_unref0 (actor);
		}
		_g_object_unref0 (_actor_it);
	}
	_tmp39_ = self->priv->warp_actors;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp39_);
	_tmp40_ = nibbles_view_get_game (self);
	_tmp41_ = _tmp40_;
	_tmp42_ = nibbles_game_get_boni (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = nibbles_view_get_game (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = nibbles_game_get_numworms (_tmp45_);
	_tmp47_ = _tmp46_;
	boni_reset (_tmp43_, _tmp47_);
	_tmp48_ = nibbles_view_get_game (self);
	_tmp49_ = _tmp48_;
	_tmp50_ = nibbles_game_get_warp_manager (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = _tmp51_->warps;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp52_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp53_ = FALSE;
			_tmp53_ = TRUE;
			while (TRUE) {
				gint _tmp55_;
				FILE* _tmp56_;
				gchar* _tmp57_;
				const gchar* _tmp58_;
				if (!_tmp53_) {
					gint _tmp54_;
					_tmp54_ = i;
					i = _tmp54_ + 1;
				}
				_tmp53_ = FALSE;
				_tmp55_ = i;
				if (!(_tmp55_ < NIBBLES_GAME_HEIGHT)) {
					break;
				}
				_tmp56_ = file;
				_tmp57_ = g_file_stream_read_line (_tmp56_);
				_g_free0 (tmpboard);
				tmpboard = _tmp57_;
				_tmp58_ = tmpboard;
				if (_tmp58_ == NULL) {
					const gchar* _tmp59_;
					_tmp59_ = filename;
					g_error ("nibbles-view.vala:218: Level file appears to be damaged: %s", _tmp59_);
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp60_ = FALSE;
						_tmp60_ = TRUE;
						while (TRUE) {
							gint _tmp62_;
							NibblesGame* _tmp63_;
							NibblesGame* _tmp64_;
							gint* _tmp65_;
							gint _tmp65__length1;
							gint _tmp65__length2;
							gint _tmp66_;
							gint _tmp67_;
							const gchar* _tmp68_;
							gint _tmp69_;
							gint _tmp70_;
							NibblesGame* _tmp71_;
							NibblesGame* _tmp72_;
							gint* _tmp73_;
							gint _tmp73__length1;
							gint _tmp73__length2;
							gint _tmp74_;
							gint _tmp75_;
							gint _tmp76_;
							if (!_tmp60_) {
								gint _tmp61_;
								_tmp61_ = j;
								j = _tmp61_ + 1;
							}
							_tmp60_ = FALSE;
							_tmp62_ = j;
							if (!(_tmp62_ < NIBBLES_GAME_WIDTH)) {
								break;
							}
							_tmp63_ = nibbles_view_get_game (self);
							_tmp64_ = _tmp63_;
							_tmp65_ = _tmp64_->board;
							_tmp65__length1 = _tmp64_->board_length1;
							_tmp65__length2 = _tmp64_->board_length2;
							_tmp66_ = j;
							_tmp67_ = i;
							_tmp68_ = tmpboard;
							_tmp69_ = j;
							_tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_] = (gint) string_get (_tmp68_, (glong) _tmp69_);
							_tmp70_ = _tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_];
							_tmp71_ = nibbles_view_get_game (self);
							_tmp72_ = _tmp71_;
							_tmp73_ = _tmp72_->board;
							_tmp73__length1 = _tmp72_->board_length1;
							_tmp73__length2 = _tmp72_->board_length2;
							_tmp74_ = j;
							_tmp75_ = i;
							_tmp76_ = _tmp73_[(_tmp74_ * _tmp73__length2) + _tmp75_];
							switch (_tmp76_) {
								case 'm':
								{
									NibblesGame* _tmp77_;
									NibblesGame* _tmp78_;
									gint* _tmp79_;
									gint _tmp79__length1;
									gint _tmp79__length2;
									gint _tmp80_;
									gint _tmp81_;
									gint _tmp82_;
									gint _tmp83_;
									NibblesGame* _tmp84_;
									NibblesGame* _tmp85_;
									gint _tmp86_;
									gint _tmp87_;
									_tmp77_ = nibbles_view_get_game (self);
									_tmp78_ = _tmp77_;
									_tmp79_ = _tmp78_->board;
									_tmp79__length1 = _tmp78_->board_length1;
									_tmp79__length2 = _tmp78_->board_length2;
									_tmp80_ = j;
									_tmp81_ = i;
									_tmp79_[(_tmp80_ * _tmp79__length2) + _tmp81_] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp82_ = _tmp79_[(_tmp80_ * _tmp79__length2) + _tmp81_];
									_tmp83_ = count;
									_tmp84_ = nibbles_view_get_game (self);
									_tmp85_ = _tmp84_;
									_tmp86_ = nibbles_game_get_numworms (_tmp85_);
									_tmp87_ = _tmp86_;
									if (_tmp83_ < _tmp87_) {
										NibblesGame* _tmp88_;
										NibblesGame* _tmp89_;
										GeeLinkedList* _tmp90_;
										GeeLinkedList* _tmp91_;
										gint _tmp92_;
										gpointer _tmp93_;
										Worm* _tmp94_;
										gint _tmp95_;
										gint _tmp96_;
										WormActor* actors = NULL;
										WormActor* _tmp97_;
										ClutterStage* _tmp98_;
										WormActor* _tmp99_;
										GeeHashMap* _tmp100_;
										NibblesGame* _tmp101_;
										NibblesGame* _tmp102_;
										GeeLinkedList* _tmp103_;
										GeeLinkedList* _tmp104_;
										gint _tmp105_;
										gpointer _tmp106_;
										Worm* _tmp107_;
										WormActor* _tmp108_;
										gint _tmp109_;
										_tmp88_ = nibbles_view_get_game (self);
										_tmp89_ = _tmp88_;
										_tmp90_ = nibbles_game_get_worms (_tmp89_);
										_tmp91_ = _tmp90_;
										_tmp92_ = count;
										_tmp93_ = gee_abstract_list_get ((GeeAbstractList*) _tmp91_, _tmp92_);
										_tmp94_ = (Worm*) _tmp93_;
										_tmp95_ = j;
										_tmp96_ = i;
										worm_set_start (_tmp94_, _tmp95_, _tmp96_, WORM_DIRECTION_UP);
										_g_object_unref0 (_tmp94_);
										_tmp97_ = worm_actor_new ();
										g_object_ref_sink (_tmp97_);
										actors = _tmp97_;
										_tmp98_ = self->priv->stage;
										_tmp99_ = actors;
										clutter_actor_add_child ((ClutterActor*) _tmp98_, (ClutterActor*) _tmp99_);
										_tmp100_ = self->priv->worm_actors;
										_tmp101_ = nibbles_view_get_game (self);
										_tmp102_ = _tmp101_;
										_tmp103_ = nibbles_game_get_worms (_tmp102_);
										_tmp104_ = _tmp103_;
										_tmp105_ = count;
										_tmp106_ = gee_abstract_list_get ((GeeAbstractList*) _tmp104_, _tmp105_);
										_tmp107_ = (Worm*) _tmp106_;
										_tmp108_ = actors;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp100_, _tmp107_, _tmp108_);
										_g_object_unref0 (_tmp107_);
										_tmp109_ = count;
										count = _tmp109_ + 1;
										_g_object_unref0 (actors);
									}
									break;
								}
								case 'n':
								{
									NibblesGame* _tmp110_;
									NibblesGame* _tmp111_;
									gint* _tmp112_;
									gint _tmp112__length1;
									gint _tmp112__length2;
									gint _tmp113_;
									gint _tmp114_;
									gint _tmp115_;
									gint _tmp116_;
									NibblesGame* _tmp117_;
									NibblesGame* _tmp118_;
									gint _tmp119_;
									gint _tmp120_;
									_tmp110_ = nibbles_view_get_game (self);
									_tmp111_ = _tmp110_;
									_tmp112_ = _tmp111_->board;
									_tmp112__length1 = _tmp111_->board_length1;
									_tmp112__length2 = _tmp111_->board_length2;
									_tmp113_ = j;
									_tmp114_ = i;
									_tmp112_[(_tmp113_ * _tmp112__length2) + _tmp114_] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp115_ = _tmp112_[(_tmp113_ * _tmp112__length2) + _tmp114_];
									_tmp116_ = count;
									_tmp117_ = nibbles_view_get_game (self);
									_tmp118_ = _tmp117_;
									_tmp119_ = nibbles_game_get_numworms (_tmp118_);
									_tmp120_ = _tmp119_;
									if (_tmp116_ < _tmp120_) {
										NibblesGame* _tmp121_;
										NibblesGame* _tmp122_;
										GeeLinkedList* _tmp123_;
										GeeLinkedList* _tmp124_;
										gint _tmp125_;
										gpointer _tmp126_;
										Worm* _tmp127_;
										gint _tmp128_;
										gint _tmp129_;
										WormActor* actors = NULL;
										WormActor* _tmp130_;
										ClutterStage* _tmp131_;
										WormActor* _tmp132_;
										GeeHashMap* _tmp133_;
										NibblesGame* _tmp134_;
										NibblesGame* _tmp135_;
										GeeLinkedList* _tmp136_;
										GeeLinkedList* _tmp137_;
										gint _tmp138_;
										gpointer _tmp139_;
										Worm* _tmp140_;
										WormActor* _tmp141_;
										gint _tmp142_;
										_tmp121_ = nibbles_view_get_game (self);
										_tmp122_ = _tmp121_;
										_tmp123_ = nibbles_game_get_worms (_tmp122_);
										_tmp124_ = _tmp123_;
										_tmp125_ = count;
										_tmp126_ = gee_abstract_list_get ((GeeAbstractList*) _tmp124_, _tmp125_);
										_tmp127_ = (Worm*) _tmp126_;
										_tmp128_ = j;
										_tmp129_ = i;
										worm_set_start (_tmp127_, _tmp128_, _tmp129_, WORM_DIRECTION_LEFT);
										_g_object_unref0 (_tmp127_);
										_tmp130_ = worm_actor_new ();
										g_object_ref_sink (_tmp130_);
										actors = _tmp130_;
										_tmp131_ = self->priv->stage;
										_tmp132_ = actors;
										clutter_actor_add_child ((ClutterActor*) _tmp131_, (ClutterActor*) _tmp132_);
										_tmp133_ = self->priv->worm_actors;
										_tmp134_ = nibbles_view_get_game (self);
										_tmp135_ = _tmp134_;
										_tmp136_ = nibbles_game_get_worms (_tmp135_);
										_tmp137_ = _tmp136_;
										_tmp138_ = count;
										_tmp139_ = gee_abstract_list_get ((GeeAbstractList*) _tmp137_, _tmp138_);
										_tmp140_ = (Worm*) _tmp139_;
										_tmp141_ = actors;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp133_, _tmp140_, _tmp141_);
										_g_object_unref0 (_tmp140_);
										_tmp142_ = count;
										count = _tmp142_ + 1;
										_g_object_unref0 (actors);
									}
									break;
								}
								case 'o':
								{
									NibblesGame* _tmp143_;
									NibblesGame* _tmp144_;
									gint* _tmp145_;
									gint _tmp145__length1;
									gint _tmp145__length2;
									gint _tmp146_;
									gint _tmp147_;
									gint _tmp148_;
									gint _tmp149_;
									NibblesGame* _tmp150_;
									NibblesGame* _tmp151_;
									gint _tmp152_;
									gint _tmp153_;
									_tmp143_ = nibbles_view_get_game (self);
									_tmp144_ = _tmp143_;
									_tmp145_ = _tmp144_->board;
									_tmp145__length1 = _tmp144_->board_length1;
									_tmp145__length2 = _tmp144_->board_length2;
									_tmp146_ = j;
									_tmp147_ = i;
									_tmp145_[(_tmp146_ * _tmp145__length2) + _tmp147_] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp148_ = _tmp145_[(_tmp146_ * _tmp145__length2) + _tmp147_];
									_tmp149_ = count;
									_tmp150_ = nibbles_view_get_game (self);
									_tmp151_ = _tmp150_;
									_tmp152_ = nibbles_game_get_numworms (_tmp151_);
									_tmp153_ = _tmp152_;
									if (_tmp149_ < _tmp153_) {
										NibblesGame* _tmp154_;
										NibblesGame* _tmp155_;
										GeeLinkedList* _tmp156_;
										GeeLinkedList* _tmp157_;
										gint _tmp158_;
										gpointer _tmp159_;
										Worm* _tmp160_;
										gint _tmp161_;
										gint _tmp162_;
										WormActor* actors = NULL;
										WormActor* _tmp163_;
										ClutterStage* _tmp164_;
										WormActor* _tmp165_;
										GeeHashMap* _tmp166_;
										NibblesGame* _tmp167_;
										NibblesGame* _tmp168_;
										GeeLinkedList* _tmp169_;
										GeeLinkedList* _tmp170_;
										gint _tmp171_;
										gpointer _tmp172_;
										Worm* _tmp173_;
										WormActor* _tmp174_;
										gint _tmp175_;
										_tmp154_ = nibbles_view_get_game (self);
										_tmp155_ = _tmp154_;
										_tmp156_ = nibbles_game_get_worms (_tmp155_);
										_tmp157_ = _tmp156_;
										_tmp158_ = count;
										_tmp159_ = gee_abstract_list_get ((GeeAbstractList*) _tmp157_, _tmp158_);
										_tmp160_ = (Worm*) _tmp159_;
										_tmp161_ = j;
										_tmp162_ = i;
										worm_set_start (_tmp160_, _tmp161_, _tmp162_, WORM_DIRECTION_DOWN);
										_g_object_unref0 (_tmp160_);
										_tmp163_ = worm_actor_new ();
										g_object_ref_sink (_tmp163_);
										actors = _tmp163_;
										_tmp164_ = self->priv->stage;
										_tmp165_ = actors;
										clutter_actor_add_child ((ClutterActor*) _tmp164_, (ClutterActor*) _tmp165_);
										_tmp166_ = self->priv->worm_actors;
										_tmp167_ = nibbles_view_get_game (self);
										_tmp168_ = _tmp167_;
										_tmp169_ = nibbles_game_get_worms (_tmp168_);
										_tmp170_ = _tmp169_;
										_tmp171_ = count;
										_tmp172_ = gee_abstract_list_get ((GeeAbstractList*) _tmp170_, _tmp171_);
										_tmp173_ = (Worm*) _tmp172_;
										_tmp174_ = actors;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp166_, _tmp173_, _tmp174_);
										_g_object_unref0 (_tmp173_);
										_tmp175_ = count;
										count = _tmp175_ + 1;
										_g_object_unref0 (actors);
									}
									break;
								}
								case 'p':
								{
									NibblesGame* _tmp176_;
									NibblesGame* _tmp177_;
									gint* _tmp178_;
									gint _tmp178__length1;
									gint _tmp178__length2;
									gint _tmp179_;
									gint _tmp180_;
									gint _tmp181_;
									gint _tmp182_;
									NibblesGame* _tmp183_;
									NibblesGame* _tmp184_;
									gint _tmp185_;
									gint _tmp186_;
									_tmp176_ = nibbles_view_get_game (self);
									_tmp177_ = _tmp176_;
									_tmp178_ = _tmp177_->board;
									_tmp178__length1 = _tmp177_->board_length1;
									_tmp178__length2 = _tmp177_->board_length2;
									_tmp179_ = j;
									_tmp180_ = i;
									_tmp178_[(_tmp179_ * _tmp178__length2) + _tmp180_] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp181_ = _tmp178_[(_tmp179_ * _tmp178__length2) + _tmp180_];
									_tmp182_ = count;
									_tmp183_ = nibbles_view_get_game (self);
									_tmp184_ = _tmp183_;
									_tmp185_ = nibbles_game_get_numworms (_tmp184_);
									_tmp186_ = _tmp185_;
									if (_tmp182_ < _tmp186_) {
										NibblesGame* _tmp187_;
										NibblesGame* _tmp188_;
										GeeLinkedList* _tmp189_;
										GeeLinkedList* _tmp190_;
										gint _tmp191_;
										gpointer _tmp192_;
										Worm* _tmp193_;
										gint _tmp194_;
										gint _tmp195_;
										WormActor* actors = NULL;
										WormActor* _tmp196_;
										ClutterStage* _tmp197_;
										WormActor* _tmp198_;
										GeeHashMap* _tmp199_;
										NibblesGame* _tmp200_;
										NibblesGame* _tmp201_;
										GeeLinkedList* _tmp202_;
										GeeLinkedList* _tmp203_;
										gint _tmp204_;
										gpointer _tmp205_;
										Worm* _tmp206_;
										WormActor* _tmp207_;
										gint _tmp208_;
										_tmp187_ = nibbles_view_get_game (self);
										_tmp188_ = _tmp187_;
										_tmp189_ = nibbles_game_get_worms (_tmp188_);
										_tmp190_ = _tmp189_;
										_tmp191_ = count;
										_tmp192_ = gee_abstract_list_get ((GeeAbstractList*) _tmp190_, _tmp191_);
										_tmp193_ = (Worm*) _tmp192_;
										_tmp194_ = j;
										_tmp195_ = i;
										worm_set_start (_tmp193_, _tmp194_, _tmp195_, WORM_DIRECTION_RIGHT);
										_g_object_unref0 (_tmp193_);
										_tmp196_ = worm_actor_new ();
										g_object_ref_sink (_tmp196_);
										actors = _tmp196_;
										_tmp197_ = self->priv->stage;
										_tmp198_ = actors;
										clutter_actor_add_child ((ClutterActor*) _tmp197_, (ClutterActor*) _tmp198_);
										_tmp199_ = self->priv->worm_actors;
										_tmp200_ = nibbles_view_get_game (self);
										_tmp201_ = _tmp200_;
										_tmp202_ = nibbles_game_get_worms (_tmp201_);
										_tmp203_ = _tmp202_;
										_tmp204_ = count;
										_tmp205_ = gee_abstract_list_get ((GeeAbstractList*) _tmp203_, _tmp204_);
										_tmp206_ = (Worm*) _tmp205_;
										_tmp207_ = actors;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp199_, _tmp206_, _tmp207_);
										_g_object_unref0 (_tmp206_);
										_tmp208_ = count;
										count = _tmp208_ + 1;
										_g_object_unref0 (actors);
									}
									break;
								}
								default:
								{
									break;
								}
							}
						}
					}
				}
			}
		}
	}
	nibbles_view_load_level (self);
	_fclose0 (file);
	_g_free0 (tmpboard);
	_g_free0 (filename);
	_g_free0 (level_name);
}


static void
nibbles_view_load_level (NibblesView* self)
{
	gint x_pos = 0;
	gint y_pos = 0;
	GtkClutterTexture* tmp = NULL;
	gboolean is_wall = FALSE;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp4_;
	ClutterStage* _tmp112_;
	ClutterActor* _tmp113_;
	ClutterActor* _tmp114_;
	ClutterActor* _tmp115_;
	ClutterActor* _tmp116_;
	ClutterActor* _tmp117_;
	ClutterActor* _tmp118_;
	ClutterActor* _tmp119_;
	ClutterActor* _tmp120_;
	ClutterActor* _tmp121_;
	ClutterActor* _tmp122_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tmp = NULL;
	is_wall = TRUE;
	_tmp0_ = self->priv->level;
	if (_tmp0_ != NULL) {
		ClutterActor* _tmp1_;
		ClutterStage* _tmp2_;
		ClutterActor* _tmp3_;
		_tmp1_ = self->priv->level;
		clutter_actor_remove_all_children (_tmp1_);
		_tmp2_ = self->priv->stage;
		_tmp3_ = self->priv->level;
		clutter_actor_remove_child ((ClutterActor*) _tmp2_, _tmp3_);
	}
	_tmp4_ = clutter_actor_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->level);
	self->priv->level = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				NibblesGame* _tmp9_;
				NibblesGame* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				if (!(_tmp7_ < NIBBLES_GAME_HEIGHT)) {
					break;
				}
				_tmp8_ = i;
				_tmp9_ = nibbles_view_get_game (self);
				_tmp10_ = _tmp9_;
				_tmp11_ = nibbles_game_get_tile_size (_tmp10_);
				_tmp12_ = _tmp11_;
				y_pos = _tmp8_ * _tmp12_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							gint _tmp15_;
							gboolean _tmp92_;
							if (!_tmp13_) {
								gint _tmp14_;
								_tmp14_ = j;
								j = _tmp14_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp15_ = j;
							if (!(_tmp15_ < NIBBLES_GAME_WIDTH)) {
								break;
							}
							is_wall = TRUE;
							{
								NibblesGame* _tmp16_;
								NibblesGame* _tmp17_;
								gint* _tmp18_;
								gint _tmp18__length1;
								gint _tmp18__length2;
								gint _tmp19_;
								gint _tmp20_;
								gint _tmp21_;
								_tmp16_ = nibbles_view_get_game (self);
								_tmp17_ = _tmp16_;
								_tmp18_ = _tmp17_->board;
								_tmp18__length1 = _tmp17_->board_length1;
								_tmp18__length2 = _tmp17_->board_length2;
								_tmp19_ = j;
								_tmp20_ = i;
								_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
								switch (_tmp21_) {
									case 'a':
									{
										is_wall = FALSE;
										break;
									}
									case 'b':
									{
										GtkClutterTexture* _tmp22_;
										GtkClutterTexture* _tmp23_;
										GdkPixbuf* _tmp24_;
										_tmp22_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp22_);
										_g_object_unref0 (tmp);
										tmp = _tmp22_;
										_tmp23_ = tmp;
										_tmp24_ = self->priv->wall_pixmaps[0];
										gtk_clutter_texture_set_from_pixbuf (_tmp23_, _tmp24_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'c':
									{
										GtkClutterTexture* _tmp25_;
										GtkClutterTexture* _tmp26_;
										GdkPixbuf* _tmp27_;
										_tmp25_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp25_);
										_g_object_unref0 (tmp);
										tmp = _tmp25_;
										_tmp26_ = tmp;
										_tmp27_ = self->priv->wall_pixmaps[1];
										gtk_clutter_texture_set_from_pixbuf (_tmp26_, _tmp27_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'd':
									{
										GtkClutterTexture* _tmp28_;
										GtkClutterTexture* _tmp29_;
										GdkPixbuf* _tmp30_;
										_tmp28_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp28_);
										_g_object_unref0 (tmp);
										tmp = _tmp28_;
										_tmp29_ = tmp;
										_tmp30_ = self->priv->wall_pixmaps[2];
										gtk_clutter_texture_set_from_pixbuf (_tmp29_, _tmp30_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'e':
									{
										GtkClutterTexture* _tmp31_;
										GtkClutterTexture* _tmp32_;
										GdkPixbuf* _tmp33_;
										_tmp31_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp31_);
										_g_object_unref0 (tmp);
										tmp = _tmp31_;
										_tmp32_ = tmp;
										_tmp33_ = self->priv->wall_pixmaps[3];
										gtk_clutter_texture_set_from_pixbuf (_tmp32_, _tmp33_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'f':
									{
										GtkClutterTexture* _tmp34_;
										GtkClutterTexture* _tmp35_;
										GdkPixbuf* _tmp36_;
										_tmp34_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp34_);
										_g_object_unref0 (tmp);
										tmp = _tmp34_;
										_tmp35_ = tmp;
										_tmp36_ = self->priv->wall_pixmaps[4];
										gtk_clutter_texture_set_from_pixbuf (_tmp35_, _tmp36_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'g':
									{
										GtkClutterTexture* _tmp37_;
										GtkClutterTexture* _tmp38_;
										GdkPixbuf* _tmp39_;
										_tmp37_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp37_);
										_g_object_unref0 (tmp);
										tmp = _tmp37_;
										_tmp38_ = tmp;
										_tmp39_ = self->priv->wall_pixmaps[5];
										gtk_clutter_texture_set_from_pixbuf (_tmp38_, _tmp39_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'h':
									{
										GtkClutterTexture* _tmp40_;
										GtkClutterTexture* _tmp41_;
										GdkPixbuf* _tmp42_;
										_tmp40_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp40_);
										_g_object_unref0 (tmp);
										tmp = _tmp40_;
										_tmp41_ = tmp;
										_tmp42_ = self->priv->wall_pixmaps[6];
										gtk_clutter_texture_set_from_pixbuf (_tmp41_, _tmp42_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'i':
									{
										GtkClutterTexture* _tmp43_;
										GtkClutterTexture* _tmp44_;
										GdkPixbuf* _tmp45_;
										_tmp43_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp43_);
										_g_object_unref0 (tmp);
										tmp = _tmp43_;
										_tmp44_ = tmp;
										_tmp45_ = self->priv->wall_pixmaps[7];
										gtk_clutter_texture_set_from_pixbuf (_tmp44_, _tmp45_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'j':
									{
										GtkClutterTexture* _tmp46_;
										GtkClutterTexture* _tmp47_;
										GdkPixbuf* _tmp48_;
										_tmp46_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp46_);
										_g_object_unref0 (tmp);
										tmp = _tmp46_;
										_tmp47_ = tmp;
										_tmp48_ = self->priv->wall_pixmaps[8];
										gtk_clutter_texture_set_from_pixbuf (_tmp47_, _tmp48_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'k':
									{
										GtkClutterTexture* _tmp49_;
										GtkClutterTexture* _tmp50_;
										GdkPixbuf* _tmp51_;
										_tmp49_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp49_);
										_g_object_unref0 (tmp);
										tmp = _tmp49_;
										_tmp50_ = tmp;
										_tmp51_ = self->priv->wall_pixmaps[9];
										gtk_clutter_texture_set_from_pixbuf (_tmp50_, _tmp51_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'l':
									{
										GtkClutterTexture* _tmp52_;
										GtkClutterTexture* _tmp53_;
										GdkPixbuf* _tmp54_;
										_tmp52_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp52_);
										_g_object_unref0 (tmp);
										tmp = _tmp52_;
										_tmp53_ = tmp;
										_tmp54_ = self->priv->wall_pixmaps[10];
										gtk_clutter_texture_set_from_pixbuf (_tmp53_, _tmp54_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'Q':
									case 'R':
									case 'S':
									case 'T':
									case 'U':
									case 'V':
									case 'W':
									case 'X':
									case 'Y':
									case 'Z':
									{
										NibblesGame* _tmp55_;
										NibblesGame* _tmp56_;
										WarpManager* _tmp57_;
										WarpManager* _tmp58_;
										NibblesGame* _tmp59_;
										NibblesGame* _tmp60_;
										gint* _tmp61_;
										gint _tmp61__length1;
										gint _tmp61__length2;
										gint _tmp62_;
										gint _tmp63_;
										NibblesGame* _tmp64_;
										NibblesGame* _tmp65_;
										gint* _tmp66_;
										gint _tmp66__length1;
										gint _tmp66__length2;
										gint _tmp67_;
										gint _tmp68_;
										gint _tmp69_;
										is_wall = FALSE;
										_tmp55_ = nibbles_view_get_game (self);
										_tmp56_ = _tmp55_;
										_tmp57_ = nibbles_game_get_warp_manager (_tmp56_);
										_tmp58_ = _tmp57_;
										_tmp59_ = nibbles_view_get_game (self);
										_tmp60_ = _tmp59_;
										_tmp61_ = _tmp60_->board;
										_tmp61__length1 = _tmp60_->board_length1;
										_tmp61__length2 = _tmp60_->board_length2;
										_tmp62_ = j;
										_tmp63_ = i;
										_tmp64_ = nibbles_view_get_game (self);
										_tmp65_ = _tmp64_;
										_tmp66_ = _tmp65_->board;
										_tmp66__length1 = _tmp65_->board_length1;
										_tmp66__length2 = _tmp65_->board_length2;
										_tmp67_ = j;
										_tmp68_ = i;
										_tmp69_ = _tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_];
										warp_manager_add_warp (_tmp58_, _tmp61_, _tmp61__length1, _tmp61__length2, _tmp62_ - 1, _tmp63_ - 1, -_tmp69_, 0);
										break;
									}
									case 'r':
									case 's':
									case 't':
									case 'u':
									case 'v':
									case 'w':
									case 'x':
									case 'y':
									case 'z':
									{
										NibblesGame* _tmp70_;
										NibblesGame* _tmp71_;
										WarpManager* _tmp72_;
										WarpManager* _tmp73_;
										NibblesGame* _tmp74_;
										NibblesGame* _tmp75_;
										gint* _tmp76_;
										gint _tmp76__length1;
										gint _tmp76__length2;
										NibblesGame* _tmp77_;
										NibblesGame* _tmp78_;
										gint* _tmp79_;
										gint _tmp79__length1;
										gint _tmp79__length2;
										gint _tmp80_;
										gint _tmp81_;
										gint _tmp82_;
										gint _tmp83_;
										gint _tmp84_;
										NibblesGame* _tmp85_;
										NibblesGame* _tmp86_;
										gint* _tmp87_;
										gint _tmp87__length1;
										gint _tmp87__length2;
										gint _tmp88_;
										gint _tmp89_;
										gint _tmp90_;
										is_wall = FALSE;
										_tmp70_ = nibbles_view_get_game (self);
										_tmp71_ = _tmp70_;
										_tmp72_ = nibbles_game_get_warp_manager (_tmp71_);
										_tmp73_ = _tmp72_;
										_tmp74_ = nibbles_view_get_game (self);
										_tmp75_ = _tmp74_;
										_tmp76_ = _tmp75_->board;
										_tmp76__length1 = _tmp75_->board_length1;
										_tmp76__length2 = _tmp75_->board_length2;
										_tmp77_ = nibbles_view_get_game (self);
										_tmp78_ = _tmp77_;
										_tmp79_ = _tmp78_->board;
										_tmp79__length1 = _tmp78_->board_length1;
										_tmp79__length2 = _tmp78_->board_length2;
										_tmp80_ = j;
										_tmp81_ = i;
										_tmp82_ = _tmp79_[(_tmp80_ * _tmp79__length2) + _tmp81_];
										_tmp83_ = j;
										_tmp84_ = i;
										warp_manager_add_warp (_tmp73_, _tmp76_, _tmp76__length1, _tmp76__length2, -((_tmp82_ - 'a') + 'A'), 0, _tmp83_, _tmp84_);
										_tmp85_ = nibbles_view_get_game (self);
										_tmp86_ = _tmp85_;
										_tmp87_ = _tmp86_->board;
										_tmp87__length1 = _tmp86_->board_length1;
										_tmp87__length2 = _tmp86_->board_length2;
										_tmp88_ = j;
										_tmp89_ = i;
										_tmp87_[(_tmp88_ * _tmp87__length2) + _tmp89_] = (gint) NIBBLES_GAME_EMPTYCHAR;
										_tmp90_ = _tmp87_[(_tmp88_ * _tmp87__length2) + _tmp89_];
										break;
									}
									default:
									{
										is_wall = FALSE;
										break;
									}
								}
							}
							goto __finally2;
							__catch2_g_error:
							{
								GError* e = NULL;
								const gchar* _tmp91_;
								e = _inner_error_;
								_inner_error_ = NULL;
								_tmp91_ = e->message;
								g_error ("nibbles-view.vala:387: Error loading level: %s", _tmp91_);
								_g_error_free0 (e);
							}
							__finally2:
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								_g_object_unref0 (tmp);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp92_ = is_wall;
							if (_tmp92_) {
								gint _tmp93_;
								NibblesGame* _tmp94_;
								NibblesGame* _tmp95_;
								gint _tmp96_;
								gint _tmp97_;
								GtkClutterTexture* _tmp98_;
								NibblesGame* _tmp99_;
								NibblesGame* _tmp100_;
								gint _tmp101_;
								gint _tmp102_;
								NibblesGame* _tmp103_;
								NibblesGame* _tmp104_;
								gint _tmp105_;
								gint _tmp106_;
								GtkClutterTexture* _tmp107_;
								gint _tmp108_;
								gint _tmp109_;
								ClutterActor* _tmp110_;
								GtkClutterTexture* _tmp111_;
								_tmp93_ = j;
								_tmp94_ = nibbles_view_get_game (self);
								_tmp95_ = _tmp94_;
								_tmp96_ = nibbles_game_get_tile_size (_tmp95_);
								_tmp97_ = _tmp96_;
								x_pos = _tmp93_ * _tmp97_;
								_tmp98_ = tmp;
								_tmp99_ = nibbles_view_get_game (self);
								_tmp100_ = _tmp99_;
								_tmp101_ = nibbles_game_get_tile_size (_tmp100_);
								_tmp102_ = _tmp101_;
								_tmp103_ = nibbles_view_get_game (self);
								_tmp104_ = _tmp103_;
								_tmp105_ = nibbles_game_get_tile_size (_tmp104_);
								_tmp106_ = _tmp105_;
								clutter_actor_set_size ((ClutterActor*) _tmp98_, (gfloat) _tmp102_, (gfloat) _tmp106_);
								_tmp107_ = tmp;
								_tmp108_ = x_pos;
								_tmp109_ = y_pos;
								clutter_actor_set_position ((ClutterActor*) _tmp107_, (gfloat) _tmp108_, (gfloat) _tmp109_);
								_tmp110_ = self->priv->level;
								_tmp111_ = tmp;
								clutter_actor_add_child (_tmp110_, (ClutterActor*) _tmp111_);
							}
						}
					}
				}
			}
		}
	}
	_tmp112_ = self->priv->stage;
	_tmp113_ = self->priv->level;
	clutter_actor_add_child ((ClutterActor*) _tmp112_, _tmp113_);
	_tmp114_ = self->priv->level;
	clutter_actor_set_opacity (_tmp114_, (guint8) 0);
	_tmp115_ = self->priv->level;
	clutter_actor_set_scale (_tmp115_, 0.2, 0.2);
	_tmp116_ = self->priv->level;
	clutter_actor_save_easing_state (_tmp116_);
	_tmp117_ = self->priv->level;
	clutter_actor_set_easing_mode (_tmp117_, CLUTTER_EASE_OUT_BOUNCE);
	_tmp118_ = self->priv->level;
	clutter_actor_set_easing_duration (_tmp118_, (guint) (NIBBLES_GAME_GAMEDELAY * NIBBLES_GAME_GAMEDELAY));
	_tmp119_ = self->priv->level;
	clutter_actor_set_scale (_tmp119_, 1.0, 1.0);
	_tmp120_ = self->priv->level;
	clutter_actor_set_pivot_point (_tmp120_, 0.5f, 0.5f);
	_tmp121_ = self->priv->level;
	clutter_actor_set_opacity (_tmp121_, (guint8) 0xff);
	_tmp122_ = self->priv->level;
	clutter_actor_restore_easing_state (_tmp122_);
	_g_object_unref0 (tmp);
}


GdkPixbuf*
nibbles_view_load_pixmap_file (NibblesView* self,
                               const gchar* pixmap,
                               gint xsize,
                               gint ysize)
{
	GdkPixbuf* result = NULL;
	gchar* filename = NULL;
	gchar* _tmp0_;
	GdkPixbuf* image = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pixmap != NULL, NULL);
	_tmp0_ = g_build_filename (PKGDATADIR, "pixmaps", pixmap, NULL, NULL);
	filename = _tmp0_;
	if (filename == NULL) {
		g_error ("nibbles-view.vala:422: Nibbles couldn't find pixmap file: %s", filename);
	}
	image = NULL;
	{
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		_tmp2_ = gdk_pixbuf_new_from_file_at_scale (filename, xsize, ysize, TRUE, &_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (image);
		image = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("nibbles-view.vala:431: Failed to load pixmap file: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (image);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = image;
	_g_free0 (filename);
	return result;
}


static void
nibbles_view_load_pixmap (NibblesView* self)
{
	gchar** bonus_files = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint bonus_files_length1;
	gint _bonus_files_size_;
	gchar** small_files = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gint small_files_length1;
	gint _small_files_size_;
	gchar** worm_files = NULL;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gint worm_files_length1;
	gint _worm_files_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("bonus1.svg");
	_tmp1_ = g_strdup ("bonus2.svg");
	_tmp2_ = g_strdup ("bonus3.svg");
	_tmp3_ = g_strdup ("life.svg");
	_tmp4_ = g_strdup ("diamond.svg");
	_tmp5_ = g_strdup ("questionmark.svg");
	_tmp6_ = g_new0 (gchar*, 6 + 1);
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp2_;
	_tmp6_[3] = _tmp3_;
	_tmp6_[4] = _tmp4_;
	_tmp6_[5] = _tmp5_;
	bonus_files = _tmp6_;
	bonus_files_length1 = 6;
	_bonus_files_size_ = bonus_files_length1;
	_tmp7_ = g_strdup ("wall-straight-up.svg");
	_tmp8_ = g_strdup ("wall-straight-side.svg");
	_tmp9_ = g_strdup ("wall-corner-bottom-left.svg");
	_tmp10_ = g_strdup ("wall-corner-bottom-right.svg");
	_tmp11_ = g_strdup ("wall-corner-top-left.svg");
	_tmp12_ = g_strdup ("wall-corner-top-right.svg");
	_tmp13_ = g_strdup ("wall-tee-up.svg");
	_tmp14_ = g_strdup ("wall-tee-right.svg");
	_tmp15_ = g_strdup ("wall-tee-left.svg");
	_tmp16_ = g_strdup ("wall-tee-down.svg");
	_tmp17_ = g_strdup ("wall-cross.svg");
	_tmp18_ = g_new0 (gchar*, 11 + 1);
	_tmp18_[0] = _tmp7_;
	_tmp18_[1] = _tmp8_;
	_tmp18_[2] = _tmp9_;
	_tmp18_[3] = _tmp10_;
	_tmp18_[4] = _tmp11_;
	_tmp18_[5] = _tmp12_;
	_tmp18_[6] = _tmp13_;
	_tmp18_[7] = _tmp14_;
	_tmp18_[8] = _tmp15_;
	_tmp18_[9] = _tmp16_;
	_tmp18_[10] = _tmp17_;
	small_files = _tmp18_;
	small_files_length1 = 11;
	_small_files_size_ = small_files_length1;
	_tmp19_ = g_strdup ("snake-red.svg");
	_tmp20_ = g_strdup ("snake-green.svg");
	_tmp21_ = g_strdup ("snake-blue.svg");
	_tmp22_ = g_strdup ("snake-yellow.svg");
	_tmp23_ = g_strdup ("snake-cyan.svg");
	_tmp24_ = g_strdup ("snake-magenta.svg");
	_tmp25_ = g_new0 (gchar*, 6 + 1);
	_tmp25_[0] = _tmp19_;
	_tmp25_[1] = _tmp20_;
	_tmp25_[2] = _tmp21_;
	_tmp25_[3] = _tmp22_;
	_tmp25_[4] = _tmp23_;
	_tmp25_[5] = _tmp24_;
	worm_files = _tmp25_;
	worm_files_length1 = 6;
	_worm_files_size_ = worm_files_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				gint _tmp28_;
				gchar** _tmp29_;
				gint _tmp29__length1;
				gint _tmp30_;
				gchar** _tmp31_;
				gint _tmp31__length1;
				gint _tmp32_;
				const gchar* _tmp33_;
				NibblesGame* _tmp34_;
				NibblesGame* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				NibblesGame* _tmp38_;
				NibblesGame* _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				GdkPixbuf* _tmp42_;
				GdkPixbuf* _tmp43_;
				if (!_tmp26_) {
					gint _tmp27_;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				_tmp28_ = i;
				_tmp29_ = bonus_files;
				_tmp29__length1 = bonus_files_length1;
				if (!(_tmp28_ < _tmp29__length1)) {
					break;
				}
				_tmp30_ = i;
				_tmp31_ = bonus_files;
				_tmp31__length1 = bonus_files_length1;
				_tmp32_ = i;
				_tmp33_ = _tmp31_[_tmp32_];
				_tmp34_ = nibbles_view_get_game (self);
				_tmp35_ = _tmp34_;
				_tmp36_ = nibbles_game_get_tile_size (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = nibbles_view_get_game (self);
				_tmp39_ = _tmp38_;
				_tmp40_ = nibbles_game_get_tile_size (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = nibbles_view_load_pixmap_file (self, _tmp33_, 2 * _tmp37_, 2 * _tmp41_);
				_g_object_unref0 (self->priv->boni_pixmaps[_tmp30_]);
				self->priv->boni_pixmaps[_tmp30_] = _tmp42_;
				_tmp43_ = self->priv->boni_pixmaps[_tmp30_];
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp44_ = FALSE;
			_tmp44_ = TRUE;
			while (TRUE) {
				gint _tmp46_;
				gchar** _tmp47_;
				gint _tmp47__length1;
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				gint _tmp50_;
				const gchar* _tmp51_;
				NibblesGame* _tmp52_;
				NibblesGame* _tmp53_;
				gint _tmp54_;
				gint _tmp55_;
				NibblesGame* _tmp56_;
				NibblesGame* _tmp57_;
				gint _tmp58_;
				gint _tmp59_;
				GdkPixbuf* _tmp60_;
				GdkPixbuf* _tmp61_;
				if (!_tmp44_) {
					gint _tmp45_;
					_tmp45_ = i;
					i = _tmp45_ + 1;
				}
				_tmp44_ = FALSE;
				_tmp46_ = i;
				_tmp47_ = small_files;
				_tmp47__length1 = small_files_length1;
				if (!(_tmp46_ < _tmp47__length1)) {
					break;
				}
				_tmp48_ = i;
				_tmp49_ = small_files;
				_tmp49__length1 = small_files_length1;
				_tmp50_ = i;
				_tmp51_ = _tmp49_[_tmp50_];
				_tmp52_ = nibbles_view_get_game (self);
				_tmp53_ = _tmp52_;
				_tmp54_ = nibbles_game_get_tile_size (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = nibbles_view_get_game (self);
				_tmp57_ = _tmp56_;
				_tmp58_ = nibbles_game_get_tile_size (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = nibbles_view_load_pixmap_file (self, _tmp51_, 2 * _tmp55_, 2 * _tmp59_);
				_g_object_unref0 (self->priv->wall_pixmaps[_tmp48_]);
				self->priv->wall_pixmaps[_tmp48_] = _tmp60_;
				_tmp61_ = self->priv->wall_pixmaps[_tmp48_];
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp62_ = FALSE;
			_tmp62_ = TRUE;
			while (TRUE) {
				gint _tmp64_;
				gchar** _tmp65_;
				gint _tmp65__length1;
				gint _tmp66_;
				gchar** _tmp67_;
				gint _tmp67__length1;
				gint _tmp68_;
				const gchar* _tmp69_;
				NibblesGame* _tmp70_;
				NibblesGame* _tmp71_;
				gint _tmp72_;
				gint _tmp73_;
				NibblesGame* _tmp74_;
				NibblesGame* _tmp75_;
				gint _tmp76_;
				gint _tmp77_;
				GdkPixbuf* _tmp78_;
				GdkPixbuf* _tmp79_;
				if (!_tmp62_) {
					gint _tmp63_;
					_tmp63_ = i;
					i = _tmp63_ + 1;
				}
				_tmp62_ = FALSE;
				_tmp64_ = i;
				_tmp65_ = worm_files;
				_tmp65__length1 = worm_files_length1;
				if (!(_tmp64_ < _tmp65__length1)) {
					break;
				}
				_tmp66_ = i;
				_tmp67_ = worm_files;
				_tmp67__length1 = worm_files_length1;
				_tmp68_ = i;
				_tmp69_ = _tmp67_[_tmp68_];
				_tmp70_ = nibbles_view_get_game (self);
				_tmp71_ = _tmp70_;
				_tmp72_ = nibbles_game_get_tile_size (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = nibbles_view_get_game (self);
				_tmp75_ = _tmp74_;
				_tmp76_ = nibbles_game_get_tile_size (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = nibbles_view_load_pixmap_file (self, _tmp69_, _tmp73_, _tmp77_);
				_g_object_unref0 (self->priv->worm_pixmaps[_tmp66_]);
				self->priv->worm_pixmaps[_tmp66_] = _tmp78_;
				_tmp79_ = self->priv->worm_pixmaps[_tmp66_];
			}
		}
	}
	worm_files = (_vala_array_free (worm_files, worm_files_length1, (GDestroyNotify) g_free), NULL);
	small_files = (_vala_array_free (small_files, small_files_length1, (GDestroyNotify) g_free), NULL);
	bonus_files = (_vala_array_free (bonus_files, bonus_files_length1, (GDestroyNotify) g_free), NULL);
}


static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		NibblesView* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->worm);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void
_nibbles_view_worm_added_cb_worm_added (Worm* _sender,
                                        gpointer self)
{
	nibbles_view_worm_added_cb ((NibblesView*) self, _sender);
}


static void
_nibbles_view_worm_finish_added_cb_worm_finish_added (Worm* _sender,
                                                      gpointer self)
{
	nibbles_view_worm_finish_added_cb ((NibblesView*) self, _sender);
}


static void
_nibbles_view_worm_moved_cb_worm_moved (Worm* _sender,
                                        gpointer self)
{
	nibbles_view_worm_moved_cb ((NibblesView*) self, _sender);
}


static void
_nibbles_view_worm_rescaled_cb_worm_rescaled (Worm* _sender,
                                              gint tile_size,
                                              gpointer self)
{
	nibbles_view_worm_rescaled_cb ((NibblesView*) self, _sender, tile_size);
}


static void
_nibbles_view_worm_died_cb_worm_died (Worm* _sender,
                                      gpointer self)
{
	nibbles_view_worm_died_cb ((NibblesView*) self, _sender);
}


static void
_nibbles_view_worm_tail_reduced_cb_worm_tail_reduced (Worm* _sender,
                                                      gint erase_size,
                                                      gpointer self)
{
	nibbles_view_worm_tail_reduced_cb ((NibblesView*) self, _sender, erase_size);
}


static void
_nibbles_view_worm_reversed_cb_worm_reversed (Worm* _sender,
                                              gpointer self)
{
	nibbles_view_worm_reversed_cb ((NibblesView*) self, _sender);
}


static void
____lambda6_ (Block6Data* _data6_)
{
	NibblesView* self;
	guint8 opacity = 0U;
	gint _tmp0_ = 0;
	Worm* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	WormActor* actors = NULL;
	GeeHashMap* _tmp4_;
	Worm* _tmp5_;
	gpointer _tmp6_;
	self = _data6_->self;
	_tmp1_ = _data6_->worm;
	_tmp2_ = worm_get_is_materialized (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 0xff;
	} else {
		_tmp0_ = 0x50;
	}
	opacity = (guint8) _tmp0_;
	_tmp4_ = self->priv->worm_actors;
	_tmp5_ = _data6_->worm;
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
	actors = (WormActor*) _tmp6_;
	clutter_actor_save_easing_state ((ClutterActor*) actors);
	clutter_actor_set_easing_duration ((ClutterActor*) actors, (guint) (NIBBLES_GAME_GAMEDELAY * 10));
	clutter_actor_set_opacity ((ClutterActor*) actors, opacity);
	clutter_actor_restore_easing_state ((ClutterActor*) actors);
	_g_object_unref0 (actors);
}


static void
_____lambda6__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	____lambda6_ (self);
}


void
nibbles_view_connect_worm_signals (NibblesView* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp0_;
		NibblesGame* _tmp1_;
		GeeLinkedList* _tmp2_;
		GeeLinkedList* _tmp3_;
		GeeLinkedList* _tmp4_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _worm_index = 0;
		_tmp0_ = nibbles_view_get_game (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = nibbles_game_get_worms (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_worm_list = _tmp4_;
		_tmp5_ = _worm_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_worm_size = _tmp7_;
		_worm_index = -1;
		while (TRUE) {
			Block6Data* _data6_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GeeLinkedList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			Worm* _tmp14_;
			Worm* _tmp15_;
			Worm* _tmp16_;
			Worm* _tmp17_;
			Worm* _tmp18_;
			Worm* _tmp19_;
			Worm* _tmp20_;
			Worm* _tmp21_;
			_data6_ = g_slice_new0 (Block6Data);
			_data6_->_ref_count_ = 1;
			_data6_->self = g_object_ref (self);
			_tmp8_ = _worm_index;
			_worm_index = _tmp8_ + 1;
			_tmp9_ = _worm_index;
			_tmp10_ = _worm_size;
			if (!(_tmp9_ < _tmp10_)) {
				block6_data_unref (_data6_);
				_data6_ = NULL;
				break;
			}
			_tmp11_ = _worm_list;
			_tmp12_ = _worm_index;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
			_data6_->worm = (Worm*) _tmp13_;
			_tmp14_ = _data6_->worm;
			g_signal_connect_object (_tmp14_, "added", (GCallback) _nibbles_view_worm_added_cb_worm_added, self, 0);
			_tmp15_ = _data6_->worm;
			g_signal_connect_object (_tmp15_, "finish-added", (GCallback) _nibbles_view_worm_finish_added_cb_worm_finish_added, self, 0);
			_tmp16_ = _data6_->worm;
			g_signal_connect_object (_tmp16_, "moved", (GCallback) _nibbles_view_worm_moved_cb_worm_moved, self, 0);
			_tmp17_ = _data6_->worm;
			g_signal_connect_object (_tmp17_, "rescaled", (GCallback) _nibbles_view_worm_rescaled_cb_worm_rescaled, self, 0);
			_tmp18_ = _data6_->worm;
			g_signal_connect_object (_tmp18_, "died", (GCallback) _nibbles_view_worm_died_cb_worm_died, self, 0);
			_tmp19_ = _data6_->worm;
			g_signal_connect_object (_tmp19_, "tail-reduced", (GCallback) _nibbles_view_worm_tail_reduced_cb_worm_tail_reduced, self, 0);
			_tmp20_ = _data6_->worm;
			g_signal_connect_object (_tmp20_, "reversed", (GCallback) _nibbles_view_worm_reversed_cb_worm_reversed, self, 0);
			_tmp21_ = _data6_->worm;
			g_signal_connect_data ((GObject*) _tmp21_, "notify::is-materialized", (GCallback) _____lambda6__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
			block6_data_unref (_data6_);
			_data6_ = NULL;
		}
		_g_object_unref0 (_worm_list);
	}
}


void
nibbles_view_board_rescale (NibblesView* self,
                            gint tile_size)
{
	gint board_width = 0;
	gint board_height = 0;
	gfloat x_pos = 0.0F;
	gfloat y_pos = 0.0F;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	GList* _tmp2_;
	ClutterActor* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->level;
	if (_tmp0_ == NULL) {
		return;
	}
	board_width = NIBBLES_GAME_WIDTH * tile_size;
	board_height = NIBBLES_GAME_HEIGHT * tile_size;
	_tmp1_ = self->priv->level;
	_tmp2_ = clutter_actor_get_children (_tmp1_);
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp2_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor = NULL;
			actor = (ClutterActor*) actor_it->data;
			{
				ClutterActor* _tmp3_;
				gfloat _tmp4_ = 0.0F;
				gfloat _tmp5_ = 0.0F;
				ClutterActor* _tmp6_;
				gfloat _tmp7_;
				NibblesGame* _tmp8_;
				NibblesGame* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gfloat _tmp12_;
				NibblesGame* _tmp13_;
				NibblesGame* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				ClutterActor* _tmp17_;
				_tmp3_ = actor;
				clutter_actor_get_position (_tmp3_, &_tmp4_, &_tmp5_);
				x_pos = _tmp4_;
				y_pos = _tmp5_;
				_tmp6_ = actor;
				_tmp7_ = x_pos;
				_tmp8_ = nibbles_view_get_game (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = nibbles_game_get_tile_size (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = y_pos;
				_tmp13_ = nibbles_view_get_game (self);
				_tmp14_ = _tmp13_;
				_tmp15_ = nibbles_game_get_tile_size (_tmp14_);
				_tmp16_ = _tmp15_;
				clutter_actor_set_position (_tmp6_, (_tmp7_ / _tmp11_) * tile_size, (_tmp12_ / _tmp16_) * tile_size);
				_tmp17_ = actor;
				clutter_actor_set_size (_tmp17_, (gfloat) tile_size, (gfloat) tile_size);
			}
		}
		(actor_collection == NULL) ? NULL : (actor_collection = (g_list_free (actor_collection), NULL));
	}
	_tmp18_ = self->priv->_name_labels;
	g_object_get (_tmp18_, "visible", &_tmp19_, NULL);
	_tmp20_ = _tmp19_;
	if (!_tmp20_) {
		return;
	}
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp21_;
		NibblesGame* _tmp22_;
		GeeLinkedList* _tmp23_;
		GeeLinkedList* _tmp24_;
		GeeLinkedList* _tmp25_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _worm_index = 0;
		_tmp21_ = nibbles_view_get_game (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = nibbles_game_get_worms (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _g_object_ref0 (_tmp24_);
		_worm_list = _tmp25_;
		_tmp26_ = _worm_list;
		_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_worm_size = _tmp28_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp32_;
			gint _tmp33_;
			gpointer _tmp34_;
			ClutterActor* actor = NULL;
			ClutterActor* _tmp35_;
			Worm* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			ClutterActor* _tmp39_;
			ClutterActor* _tmp40_;
			gint middle = 0;
			Worm* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gboolean _tmp44_ = FALSE;
			Worm* _tmp45_;
			WormDirection _tmp46_;
			_tmp29_ = _worm_index;
			_worm_index = _tmp29_ + 1;
			_tmp30_ = _worm_index;
			_tmp31_ = _worm_size;
			if (!(_tmp30_ < _tmp31_)) {
				break;
			}
			_tmp32_ = _worm_list;
			_tmp33_ = _worm_index;
			_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _tmp33_);
			worm = (Worm*) _tmp34_;
			_tmp35_ = self->priv->_name_labels;
			_tmp36_ = worm;
			_tmp37_ = worm_get_id (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = clutter_actor_get_child_at_index (_tmp35_, _tmp38_);
			_tmp40_ = _g_object_ref0 (_tmp39_);
			actor = _tmp40_;
			_tmp41_ = worm;
			_tmp42_ = worm_get_length (_tmp41_);
			_tmp43_ = _tmp42_;
			middle = _tmp43_ / 2;
			_tmp45_ = worm;
			_tmp46_ = _tmp45_->direction;
			if (_tmp46_ == WORM_DIRECTION_UP) {
				_tmp44_ = TRUE;
			} else {
				Worm* _tmp47_;
				WormDirection _tmp48_;
				_tmp47_ = worm;
				_tmp48_ = _tmp47_->direction;
				_tmp44_ = _tmp48_ == WORM_DIRECTION_DOWN;
			}
			if (_tmp44_) {
				ClutterActor* _tmp49_;
				Worm* _tmp50_;
				GeeLinkedList* _tmp51_;
				GeeLinkedList* _tmp52_;
				gint _tmp53_;
				gpointer _tmp54_;
				Position* _tmp55_;
				gint _tmp56_;
				ClutterActor* _tmp57_;
				gfloat _tmp58_;
				gfloat _tmp59_;
				ClutterActor* _tmp60_;
				Worm* _tmp61_;
				GeeLinkedList* _tmp62_;
				GeeLinkedList* _tmp63_;
				gint _tmp64_;
				gpointer _tmp65_;
				Position* _tmp66_;
				gint _tmp67_;
				_tmp49_ = actor;
				_tmp50_ = worm;
				_tmp51_ = worm_get_list (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = middle;
				_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp52_, _tmp53_);
				_tmp55_ = (Position*) _tmp54_;
				_tmp56_ = (*_tmp55_).x;
				_tmp57_ = actor;
				_tmp58_ = clutter_actor_get_width (_tmp57_);
				_tmp59_ = _tmp58_;
				clutter_actor_set_x (_tmp49_, ((_tmp56_ * tile_size) - (_tmp59_ / 2)) + (tile_size / 2));
				_position_free0 (_tmp55_);
				_tmp60_ = actor;
				_tmp61_ = worm;
				_tmp62_ = worm_get_list (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = middle;
				_tmp65_ = gee_abstract_list_get ((GeeAbstractList*) _tmp63_, _tmp64_);
				_tmp66_ = (Position*) _tmp65_;
				_tmp67_ = (*_tmp66_).y;
				clutter_actor_set_y (_tmp60_, (gfloat) ((_tmp67_ * tile_size) - (5 * tile_size)));
				_position_free0 (_tmp66_);
			} else {
				gboolean _tmp68_ = FALSE;
				Worm* _tmp69_;
				WormDirection _tmp70_;
				_tmp69_ = worm;
				_tmp70_ = _tmp69_->direction;
				if (_tmp70_ == WORM_DIRECTION_LEFT) {
					_tmp68_ = TRUE;
				} else {
					Worm* _tmp71_;
					WormDirection _tmp72_;
					_tmp71_ = worm;
					_tmp72_ = _tmp71_->direction;
					_tmp68_ = _tmp72_ == WORM_DIRECTION_RIGHT;
				}
				if (_tmp68_) {
					ClutterActor* _tmp73_;
					Worm* _tmp74_;
					GeeLinkedList* _tmp75_;
					GeeLinkedList* _tmp76_;
					gint _tmp77_;
					gpointer _tmp78_;
					Position* _tmp79_;
					gint _tmp80_;
					ClutterActor* _tmp81_;
					gfloat _tmp82_;
					gfloat _tmp83_;
					ClutterActor* _tmp84_;
					Worm* _tmp85_;
					Position _tmp86_ = {0};
					Position _tmp87_;
					gint _tmp88_;
					_tmp73_ = actor;
					_tmp74_ = worm;
					_tmp75_ = worm_get_list (_tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = middle;
					_tmp78_ = gee_abstract_list_get ((GeeAbstractList*) _tmp76_, _tmp77_);
					_tmp79_ = (Position*) _tmp78_;
					_tmp80_ = (*_tmp79_).x;
					_tmp81_ = actor;
					_tmp82_ = clutter_actor_get_width (_tmp81_);
					_tmp83_ = _tmp82_;
					clutter_actor_set_x (_tmp73_, ((_tmp80_ * tile_size) - (_tmp83_ / 2)) + (tile_size / 2));
					_position_free0 (_tmp79_);
					_tmp84_ = actor;
					_tmp85_ = worm;
					worm_get_head (_tmp85_, &_tmp86_);
					_tmp87_ = _tmp86_;
					_tmp88_ = _tmp87_.y;
					clutter_actor_set_y (_tmp84_, (gfloat) ((_tmp88_ * tile_size) - (3 * tile_size)));
				}
			}
			_g_object_unref0 (actor);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
}


static void
nibbles_view_animate_end_game_cb (NibblesView* self)
{
	ClutterActor* _tmp37_;
	ClutterActor* _tmp38_;
	ClutterActor* _tmp39_;
	ClutterActor* _tmp40_;
	ClutterActor* _tmp41_;
	ClutterActor* _tmp42_;
	ClutterActor* _tmp43_;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp0_;
		NibblesGame* _tmp1_;
		GeeLinkedList* _tmp2_;
		GeeLinkedList* _tmp3_;
		GeeLinkedList* _tmp4_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _worm_index = 0;
		_tmp0_ = nibbles_view_get_game (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = nibbles_game_get_worms (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_worm_list = _tmp4_;
		_tmp5_ = _worm_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_worm_size = _tmp7_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			GeeHashMap* _tmp14_;
			Worm* _tmp15_;
			gpointer _tmp16_;
			WormActor* _tmp17_;
			_tmp8_ = _worm_index;
			_worm_index = _tmp8_ + 1;
			_tmp9_ = _worm_index;
			_tmp10_ = _worm_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _worm_list;
			_tmp12_ = _worm_index;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
			worm = (Worm*) _tmp13_;
			_tmp14_ = self->priv->worm_actors;
			_tmp15_ = worm;
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
			_tmp17_ = (WormActor*) _tmp16_;
			clutter_actor_hide ((ClutterActor*) _tmp17_);
			_g_object_unref0 (_tmp17_);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	{
		GeeLinkedList* _warp_list = NULL;
		NibblesGame* _tmp18_;
		NibblesGame* _tmp19_;
		WarpManager* _tmp20_;
		WarpManager* _tmp21_;
		GeeLinkedList* _tmp22_;
		GeeLinkedList* _tmp23_;
		gint _warp_size = 0;
		GeeLinkedList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _warp_index = 0;
		_tmp18_ = nibbles_view_get_game (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = nibbles_game_get_warp_manager (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_->warps;
		_tmp23_ = _g_object_ref0 (_tmp22_);
		_warp_list = _tmp23_;
		_tmp24_ = _warp_list;
		_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_warp_size = _tmp26_;
		_warp_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			Warp* warp = NULL;
			GeeLinkedList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			GeeHashMap* _tmp33_;
			Warp* _tmp34_;
			gpointer _tmp35_;
			WarpTexture* _tmp36_;
			_tmp27_ = _warp_index;
			_warp_index = _tmp27_ + 1;
			_tmp28_ = _warp_index;
			_tmp29_ = _warp_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _warp_list;
			_tmp31_ = _warp_index;
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_);
			warp = (Warp*) _tmp32_;
			_tmp33_ = self->priv->warp_actors;
			_tmp34_ = warp;
			_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp33_, _tmp34_);
			_tmp36_ = (WarpTexture*) _tmp35_;
			clutter_actor_hide ((ClutterActor*) _tmp36_);
			_g_object_unref0 (_tmp36_);
			_g_object_unref0 (warp);
		}
		_g_object_unref0 (_warp_list);
	}
	_tmp37_ = self->priv->level;
	clutter_actor_save_easing_state (_tmp37_);
	_tmp38_ = self->priv->level;
	clutter_actor_set_easing_mode (_tmp38_, CLUTTER_EASE_IN_QUAD);
	_tmp39_ = self->priv->level;
	clutter_actor_set_easing_duration (_tmp39_, (guint) (NIBBLES_GAME_GAMEDELAY * 20));
	_tmp40_ = self->priv->level;
	clutter_actor_set_scale (_tmp40_, (gdouble) 0.4f, (gdouble) 0.4f);
	_tmp41_ = self->priv->level;
	clutter_actor_set_pivot_point (_tmp41_, 0.5f, 0.5f);
	_tmp42_ = self->priv->level;
	clutter_actor_set_opacity (_tmp42_, (guint8) 0);
	_tmp43_ = self->priv->level;
	clutter_actor_restore_easing_state (_tmp43_);
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void
nibbles_view_create_name_labels (NibblesView* self)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp123_;
	ClutterActor* _tmp124_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	nibbles_view_set_name_labels (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp2_;
		NibblesGame* _tmp3_;
		GeeLinkedList* _tmp4_;
		GeeLinkedList* _tmp5_;
		GeeLinkedList* _tmp6_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _worm_index = 0;
		_tmp2_ = nibbles_view_get_game (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = nibbles_game_get_worms (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_worm_list = _tmp6_;
		_tmp7_ = _worm_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_worm_size = _tmp9_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_;
			gint color = 0;
			NibblesGame* _tmp16_;
			NibblesGame* _tmp17_;
			GeeHashMap* _tmp18_;
			GeeHashMap* _tmp19_;
			Worm* _tmp20_;
			gpointer _tmp21_;
			WormProperties* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gchar* player_id = NULL;
			Worm* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gchar* _tmp28_;
			ClutterText* label = NULL;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			ClutterText* _tmp33_;
			ClutterText* _tmp34_;
			ClutterText* _tmp35_;
			ClutterText* _tmp36_;
			gint _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			ClutterColor _tmp40_ = {0};
			gint middle = 0;
			Worm* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gboolean _tmp44_ = FALSE;
			Worm* _tmp45_;
			WormDirection _tmp46_;
			ClutterActor* _tmp121_;
			ClutterText* _tmp122_;
			_tmp10_ = _worm_index;
			_worm_index = _tmp10_ + 1;
			_tmp11_ = _worm_index;
			_tmp12_ = _worm_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _worm_list;
			_tmp14_ = _worm_index;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
			worm = (Worm*) _tmp15_;
			_tmp16_ = nibbles_view_get_game (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = nibbles_game_get_worm_props (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = worm;
			_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, _tmp20_);
			_tmp22_ = (WormProperties*) _tmp21_;
			_tmp23_ = (*_tmp22_).color;
			_tmp24_ = _tmp23_;
			_worm_properties_free0 (_tmp22_);
			color = _tmp24_;
			_tmp25_ = worm;
			_tmp26_ = worm_get_id (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strdup_printf (_ ("Player %d"), _tmp27_ + 1);
			player_id = _tmp28_;
			_tmp29_ = player_id;
			_tmp30_ = string_to_string (_tmp29_);
			_tmp31_ = g_strconcat ("<b>", _tmp30_, "</b>", NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = (ClutterText*) clutter_text_new_with_text ("Monospace 10", _tmp32_);
			g_object_ref_sink (_tmp33_);
			_tmp34_ = _tmp33_;
			_g_free0 (_tmp32_);
			label = _tmp34_;
			_tmp35_ = label;
			clutter_text_set_use_markup (_tmp35_, TRUE);
			_tmp36_ = label;
			_tmp37_ = color;
			_tmp38_ = nibbles_view_colorval_name (_tmp37_);
			_tmp39_ = _tmp38_;
			clutter_color_from_string (&_tmp40_, _tmp39_);
			clutter_text_set_color (_tmp36_, &_tmp40_);
			_g_free0 (_tmp39_);
			_tmp41_ = worm;
			_tmp42_ = worm_get_length (_tmp41_);
			_tmp43_ = _tmp42_;
			middle = _tmp43_ / 2;
			_tmp45_ = worm;
			_tmp46_ = _tmp45_->direction;
			if (_tmp46_ == WORM_DIRECTION_UP) {
				_tmp44_ = TRUE;
			} else {
				Worm* _tmp47_;
				WormDirection _tmp48_;
				_tmp47_ = worm;
				_tmp48_ = _tmp47_->direction;
				_tmp44_ = _tmp48_ == WORM_DIRECTION_DOWN;
			}
			if (_tmp44_) {
				ClutterText* _tmp49_;
				Worm* _tmp50_;
				GeeLinkedList* _tmp51_;
				GeeLinkedList* _tmp52_;
				gint _tmp53_;
				gpointer _tmp54_;
				Position* _tmp55_;
				gint _tmp56_;
				NibblesGame* _tmp57_;
				NibblesGame* _tmp58_;
				gint _tmp59_;
				gint _tmp60_;
				ClutterText* _tmp61_;
				gfloat _tmp62_;
				gfloat _tmp63_;
				NibblesGame* _tmp64_;
				NibblesGame* _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				ClutterText* _tmp68_;
				Worm* _tmp69_;
				GeeLinkedList* _tmp70_;
				GeeLinkedList* _tmp71_;
				gint _tmp72_;
				gpointer _tmp73_;
				Position* _tmp74_;
				gint _tmp75_;
				NibblesGame* _tmp76_;
				NibblesGame* _tmp77_;
				gint _tmp78_;
				gint _tmp79_;
				NibblesGame* _tmp80_;
				NibblesGame* _tmp81_;
				gint _tmp82_;
				gint _tmp83_;
				_tmp49_ = label;
				_tmp50_ = worm;
				_tmp51_ = worm_get_list (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = middle;
				_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp52_, _tmp53_);
				_tmp55_ = (Position*) _tmp54_;
				_tmp56_ = (*_tmp55_).x;
				_tmp57_ = nibbles_view_get_game (self);
				_tmp58_ = _tmp57_;
				_tmp59_ = nibbles_game_get_tile_size (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = label;
				_tmp62_ = clutter_actor_get_width ((ClutterActor*) _tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = nibbles_view_get_game (self);
				_tmp65_ = _tmp64_;
				_tmp66_ = nibbles_game_get_tile_size (_tmp65_);
				_tmp67_ = _tmp66_;
				clutter_actor_set_x ((ClutterActor*) _tmp49_, ((_tmp56_ * _tmp60_) - (_tmp63_ / 2)) + (_tmp67_ / 2));
				_position_free0 (_tmp55_);
				_tmp68_ = label;
				_tmp69_ = worm;
				_tmp70_ = worm_get_list (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = middle;
				_tmp73_ = gee_abstract_list_get ((GeeAbstractList*) _tmp71_, _tmp72_);
				_tmp74_ = (Position*) _tmp73_;
				_tmp75_ = (*_tmp74_).y;
				_tmp76_ = nibbles_view_get_game (self);
				_tmp77_ = _tmp76_;
				_tmp78_ = nibbles_game_get_tile_size (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = nibbles_view_get_game (self);
				_tmp81_ = _tmp80_;
				_tmp82_ = nibbles_game_get_tile_size (_tmp81_);
				_tmp83_ = _tmp82_;
				clutter_actor_set_y ((ClutterActor*) _tmp68_, (gfloat) ((_tmp75_ * _tmp79_) - (5 * _tmp83_)));
				_position_free0 (_tmp74_);
			} else {
				gboolean _tmp84_ = FALSE;
				Worm* _tmp85_;
				WormDirection _tmp86_;
				_tmp85_ = worm;
				_tmp86_ = _tmp85_->direction;
				if (_tmp86_ == WORM_DIRECTION_LEFT) {
					_tmp84_ = TRUE;
				} else {
					Worm* _tmp87_;
					WormDirection _tmp88_;
					_tmp87_ = worm;
					_tmp88_ = _tmp87_->direction;
					_tmp84_ = _tmp88_ == WORM_DIRECTION_RIGHT;
				}
				if (_tmp84_) {
					ClutterText* _tmp89_;
					Worm* _tmp90_;
					GeeLinkedList* _tmp91_;
					GeeLinkedList* _tmp92_;
					gint _tmp93_;
					gpointer _tmp94_;
					Position* _tmp95_;
					gint _tmp96_;
					NibblesGame* _tmp97_;
					NibblesGame* _tmp98_;
					gint _tmp99_;
					gint _tmp100_;
					ClutterText* _tmp101_;
					gfloat _tmp102_;
					gfloat _tmp103_;
					NibblesGame* _tmp104_;
					NibblesGame* _tmp105_;
					gint _tmp106_;
					gint _tmp107_;
					ClutterText* _tmp108_;
					Worm* _tmp109_;
					Position _tmp110_ = {0};
					Position _tmp111_;
					gint _tmp112_;
					NibblesGame* _tmp113_;
					NibblesGame* _tmp114_;
					gint _tmp115_;
					gint _tmp116_;
					NibblesGame* _tmp117_;
					NibblesGame* _tmp118_;
					gint _tmp119_;
					gint _tmp120_;
					_tmp89_ = label;
					_tmp90_ = worm;
					_tmp91_ = worm_get_list (_tmp90_);
					_tmp92_ = _tmp91_;
					_tmp93_ = middle;
					_tmp94_ = gee_abstract_list_get ((GeeAbstractList*) _tmp92_, _tmp93_);
					_tmp95_ = (Position*) _tmp94_;
					_tmp96_ = (*_tmp95_).x;
					_tmp97_ = nibbles_view_get_game (self);
					_tmp98_ = _tmp97_;
					_tmp99_ = nibbles_game_get_tile_size (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = label;
					_tmp102_ = clutter_actor_get_width ((ClutterActor*) _tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = nibbles_view_get_game (self);
					_tmp105_ = _tmp104_;
					_tmp106_ = nibbles_game_get_tile_size (_tmp105_);
					_tmp107_ = _tmp106_;
					clutter_actor_set_x ((ClutterActor*) _tmp89_, ((_tmp96_ * _tmp100_) - (_tmp103_ / 2)) + (_tmp107_ / 2));
					_position_free0 (_tmp95_);
					_tmp108_ = label;
					_tmp109_ = worm;
					worm_get_head (_tmp109_, &_tmp110_);
					_tmp111_ = _tmp110_;
					_tmp112_ = _tmp111_.y;
					_tmp113_ = nibbles_view_get_game (self);
					_tmp114_ = _tmp113_;
					_tmp115_ = nibbles_game_get_tile_size (_tmp114_);
					_tmp116_ = _tmp115_;
					_tmp117_ = nibbles_view_get_game (self);
					_tmp118_ = _tmp117_;
					_tmp119_ = nibbles_game_get_tile_size (_tmp118_);
					_tmp120_ = _tmp119_;
					clutter_actor_set_y ((ClutterActor*) _tmp108_, (gfloat) ((_tmp112_ * _tmp116_) - (3 * _tmp120_)));
				}
			}
			_tmp121_ = self->priv->_name_labels;
			_tmp122_ = label;
			clutter_container_add ((ClutterContainer*) _tmp121_, (ClutterActor*) _tmp122_, NULL);
			_g_object_unref0 (label);
			_g_free0 (player_id);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	_tmp123_ = self->priv->level;
	_tmp124_ = self->priv->_name_labels;
	clutter_actor_add_child (_tmp123_, _tmp124_);
}


static void
nibbles_view_worm_added_cb (NibblesView* self,
                            Worm* worm)
{
	GtkClutterTexture* actor = NULL;
	GtkClutterTexture* _tmp0_;
	NibblesGame* _tmp11_;
	NibblesGame* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	NibblesGame* _tmp15_;
	NibblesGame* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GeeLinkedList* _tmp19_;
	GeeLinkedList* _tmp20_;
	gpointer _tmp21_;
	Position* _tmp22_;
	gint _tmp23_;
	NibblesGame* _tmp24_;
	NibblesGame* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GeeLinkedList* _tmp28_;
	GeeLinkedList* _tmp29_;
	gpointer _tmp30_;
	Position* _tmp31_;
	gint _tmp32_;
	NibblesGame* _tmp33_;
	NibblesGame* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	WormActor* actors = NULL;
	GeeHashMap* _tmp37_;
	gpointer _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
	g_object_ref_sink (_tmp0_);
	actor = _tmp0_;
	{
		NibblesGame* _tmp1_;
		NibblesGame* _tmp2_;
		GeeHashMap* _tmp3_;
		GeeHashMap* _tmp4_;
		gpointer _tmp5_;
		WormProperties* _tmp6_;
		gint _tmp7_;
		GdkPixbuf* _tmp8_;
		_tmp1_ = nibbles_view_get_game (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = nibbles_game_get_worm_props (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, worm);
		_tmp6_ = (WormProperties*) _tmp5_;
		_tmp7_ = (*_tmp6_).color;
		_tmp8_ = self->priv->worm_pixmaps[_tmp7_];
		gtk_clutter_texture_set_from_pixbuf (actor, _tmp8_, &_inner_error_);
		_worm_properties_free0 (_tmp6_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch4_clutter_texture_error;
			}
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_clutter_texture_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e->message;
		g_error ("nibbles-view.vala:618: Nibbles failed to set texture: %s", _tmp9_);
		_g_error_free0 (e);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e->message;
		g_error ("nibbles-view.vala:622: Nibbles failed to set texture: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (actor);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = nibbles_view_get_game (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = nibbles_game_get_tile_size (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = nibbles_view_get_game (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = nibbles_game_get_tile_size (_tmp16_);
	_tmp18_ = _tmp17_;
	clutter_actor_set_size ((ClutterActor*) actor, (gfloat) _tmp14_, (gfloat) _tmp18_);
	_tmp19_ = worm_get_list (worm);
	_tmp20_ = _tmp19_;
	_tmp21_ = gee_linked_list_first (_tmp20_);
	_tmp22_ = (Position*) _tmp21_;
	_tmp23_ = (*_tmp22_).x;
	_tmp24_ = nibbles_view_get_game (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = nibbles_game_get_tile_size (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = worm_get_list (worm);
	_tmp29_ = _tmp28_;
	_tmp30_ = gee_linked_list_first (_tmp29_);
	_tmp31_ = (Position*) _tmp30_;
	_tmp32_ = (*_tmp31_).y;
	_tmp33_ = nibbles_view_get_game (self);
	_tmp34_ = _tmp33_;
	_tmp35_ = nibbles_game_get_tile_size (_tmp34_);
	_tmp36_ = _tmp35_;
	clutter_actor_set_position ((ClutterActor*) actor, (gfloat) (_tmp23_ * _tmp27_), (gfloat) (_tmp32_ * _tmp36_));
	_position_free0 (_tmp31_);
	_position_free0 (_tmp22_);
	_tmp37_ = self->priv->worm_actors;
	_tmp38_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp37_, worm);
	actors = (WormActor*) _tmp38_;
	clutter_actor_add_child ((ClutterActor*) actors, (ClutterActor*) actor);
	_g_object_unref0 (actors);
	_g_object_unref0 (actor);
}


static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		NibblesView* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->worm);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static gboolean
__lambda5_ (Block7Data* _data7_)
{
	NibblesView* self;
	gboolean result = FALSE;
	self = _data7_->self;
	_data7_->worm->is_stopped = FALSE;
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ (self);
	return result;
}


static void
nibbles_view_worm_finish_added_cb (NibblesView* self,
                                   Worm* worm)
{
	Block7Data* _data7_;
	Worm* _tmp0_;
	WormActor* actors = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	NibblesGame* _tmp3_;
	NibblesGame* _tmp4_;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (worm);
	_g_object_unref0 (_data7_->worm);
	_data7_->worm = _tmp0_;
	_tmp1_ = self->priv->worm_actors;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _data7_->worm);
	actors = (WormActor*) _tmp2_;
	clutter_actor_set_opacity ((ClutterActor*) actors, (guint8) 0);
	clutter_actor_set_scale ((ClutterActor*) actors, 3.0, 3.0);
	clutter_actor_save_easing_state ((ClutterActor*) actors);
	clutter_actor_set_easing_mode ((ClutterActor*) actors, CLUTTER_EASE_OUT);
	clutter_actor_set_easing_duration ((ClutterActor*) actors, (guint) (NIBBLES_GAME_GAMEDELAY * 20));
	clutter_actor_set_scale ((ClutterActor*) actors, 1.0, 1.0);
	clutter_actor_set_pivot_point ((ClutterActor*) actors, 0.5f, 0.5f);
	clutter_actor_set_opacity ((ClutterActor*) actors, (guint8) 0xff);
	clutter_actor_restore_easing_state ((ClutterActor*) actors);
	_tmp3_ = nibbles_view_get_game (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->board;
	_tmp5__length1 = _tmp4_->board_length1;
	_tmp5__length2 = _tmp4_->board_length2;
	worm_dematerialize (_data7_->worm, _tmp5_, _tmp5__length1, _tmp5__length2, 3);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (NIBBLES_GAME_GAMEDELAY * 27), ___lambda5__gsource_func, block7_data_ref (_data7_), block7_data_unref);
	_g_object_unref0 (actors);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


static void
nibbles_view_worm_moved_cb (NibblesView* self,
                            Worm* worm)
{
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	ClutterActor* tail_actor = NULL;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->worm_actors;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, worm);
	actors = (WormActor*) _tmp1_;
	_tmp2_ = clutter_actor_get_first_child ((ClutterActor*) actors);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	tail_actor = _tmp4_;
	clutter_actor_remove_child ((ClutterActor*) actors, tail_actor);
	nibbles_view_worm_added_cb (self, worm);
	_g_object_unref0 (tail_actor);
	_g_object_unref0 (actors);
}


static void
nibbles_view_worm_rescaled_cb (NibblesView* self,
                               Worm* worm,
                               gint tile_size)
{
	gfloat x_pos = 0.0F;
	gfloat y_pos = 0.0F;
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	WormActor* _tmp2_;
	WormActor* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->worm_actors;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, worm);
	actors = (WormActor*) _tmp1_;
	_tmp2_ = actors;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (actors);
		return;
	}
	_tmp3_ = actors;
	_tmp4_ = clutter_actor_get_children ((ClutterActor*) _tmp3_);
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp4_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor = NULL;
			actor = (ClutterActor*) actor_it->data;
			{
				ClutterActor* _tmp5_;
				gfloat _tmp6_ = 0.0F;
				gfloat _tmp7_ = 0.0F;
				ClutterActor* _tmp8_;
				gfloat _tmp9_;
				NibblesGame* _tmp10_;
				NibblesGame* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gfloat _tmp14_;
				NibblesGame* _tmp15_;
				NibblesGame* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				ClutterActor* _tmp19_;
				_tmp5_ = actor;
				clutter_actor_get_position (_tmp5_, &_tmp6_, &_tmp7_);
				x_pos = _tmp6_;
				y_pos = _tmp7_;
				_tmp8_ = actor;
				_tmp9_ = x_pos;
				_tmp10_ = nibbles_view_get_game (self);
				_tmp11_ = _tmp10_;
				_tmp12_ = nibbles_game_get_tile_size (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = y_pos;
				_tmp15_ = nibbles_view_get_game (self);
				_tmp16_ = _tmp15_;
				_tmp17_ = nibbles_game_get_tile_size (_tmp16_);
				_tmp18_ = _tmp17_;
				clutter_actor_set_position (_tmp8_, (_tmp9_ / _tmp13_) * tile_size, (_tmp14_ / _tmp18_) * tile_size);
				_tmp19_ = actor;
				clutter_actor_set_size (_tmp19_, (gfloat) tile_size, (gfloat) tile_size);
			}
		}
		(actor_collection == NULL) ? NULL : (actor_collection = (g_list_free (actor_collection), NULL));
	}
	_g_object_unref0 (actors);
}


static void
nibbles_view_worm_died_cb (NibblesView* self,
                           Worm* worm)
{
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	ClutterActor* group = NULL;
	ClutterActor* _tmp0_;
	WormActor* actors = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	WormActor* _tmp3_;
	GList* _tmp4_;
	WormActor* _tmp36_;
	ClutterActor* _tmp37_;
	ClutterActor* _tmp38_;
	ClutterActor* _tmp39_;
	ClutterActor* _tmp40_;
	ClutterActor* _tmp41_;
	ClutterActor* _tmp42_;
	ClutterActor* _tmp43_;
	ClutterActor* _tmp44_;
	ClutterActor* _tmp45_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = clutter_actor_new ();
	g_object_ref_sink (_tmp0_);
	group = _tmp0_;
	_tmp1_ = self->priv->worm_actors;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, worm);
	actors = (WormActor*) _tmp2_;
	_tmp3_ = actors;
	_tmp4_ = clutter_actor_get_children ((ClutterActor*) _tmp3_);
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp4_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor = NULL;
			actor = (ClutterActor*) actor_it->data;
			{
				GtkClutterTexture* texture = NULL;
				GtkClutterTexture* _tmp5_;
				gint color = 0;
				NibblesGame* _tmp6_;
				NibblesGame* _tmp7_;
				GeeHashMap* _tmp8_;
				GeeHashMap* _tmp9_;
				gpointer _tmp10_;
				WormProperties* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				ClutterActor* _tmp19_;
				gfloat _tmp20_ = 0.0F;
				gfloat _tmp21_ = 0.0F;
				GtkClutterTexture* _tmp22_;
				gfloat _tmp23_;
				gfloat _tmp24_;
				GtkClutterTexture* _tmp25_;
				NibblesGame* _tmp26_;
				NibblesGame* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				NibblesGame* _tmp30_;
				NibblesGame* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				ClutterActor* _tmp34_;
				GtkClutterTexture* _tmp35_;
				_tmp5_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
				g_object_ref_sink (_tmp5_);
				texture = _tmp5_;
				_tmp6_ = nibbles_view_get_game (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = nibbles_game_get_worm_props (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, worm);
				_tmp11_ = (WormProperties*) _tmp10_;
				_tmp12_ = (*_tmp11_).color;
				_tmp13_ = _tmp12_;
				_worm_properties_free0 (_tmp11_);
				color = _tmp13_;
				{
					GtkClutterTexture* _tmp14_;
					gint _tmp15_;
					GdkPixbuf* _tmp16_;
					_tmp14_ = texture;
					_tmp15_ = color;
					_tmp16_ = self->priv->worm_pixmaps[_tmp15_];
					gtk_clutter_texture_set_from_pixbuf (_tmp14_, _tmp16_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
							goto __catch5_clutter_texture_error;
						}
						goto __catch5_g_error;
					}
				}
				goto __finally5;
				__catch5_clutter_texture_error:
				{
					GError* e = NULL;
					const gchar* _tmp17_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp17_ = e->message;
					g_error ("nibbles-view.vala:694: Nibbles failed to set texture: %s", _tmp17_);
					_g_error_free0 (e);
				}
				goto __finally5;
				__catch5_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp18_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp18_ = e->message;
					g_error ("nibbles-view.vala:698: Nibbles failed to set texture: %s", _tmp18_);
					_g_error_free0 (e);
				}
				__finally5:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (texture);
					(actor_collection == NULL) ? NULL : (actor_collection = (g_list_free (actor_collection), NULL));
					_g_object_unref0 (actors);
					_g_object_unref0 (group);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp19_ = actor;
				clutter_actor_get_position (_tmp19_, &_tmp20_, &_tmp21_);
				x = _tmp20_;
				y = _tmp21_;
				_tmp22_ = texture;
				_tmp23_ = x;
				_tmp24_ = y;
				clutter_actor_set_position ((ClutterActor*) _tmp22_, _tmp23_, _tmp24_);
				_tmp25_ = texture;
				_tmp26_ = nibbles_view_get_game (self);
				_tmp27_ = _tmp26_;
				_tmp28_ = nibbles_game_get_tile_size (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = nibbles_view_get_game (self);
				_tmp31_ = _tmp30_;
				_tmp32_ = nibbles_game_get_tile_size (_tmp31_);
				_tmp33_ = _tmp32_;
				clutter_actor_set_size ((ClutterActor*) _tmp25_, (gfloat) _tmp29_, (gfloat) _tmp33_);
				_tmp34_ = group;
				_tmp35_ = texture;
				clutter_actor_add_child (_tmp34_, (ClutterActor*) _tmp35_);
				_g_object_unref0 (texture);
			}
		}
		(actor_collection == NULL) ? NULL : (actor_collection = (g_list_free (actor_collection), NULL));
	}
	_tmp36_ = actors;
	clutter_actor_remove_all_children ((ClutterActor*) _tmp36_);
	_tmp37_ = self->priv->level;
	_tmp38_ = group;
	clutter_actor_add_child (_tmp37_, _tmp38_);
	_tmp39_ = group;
	clutter_actor_save_easing_state (_tmp39_);
	_tmp40_ = group;
	clutter_actor_set_easing_mode (_tmp40_, CLUTTER_EASE_OUT_QUAD);
	_tmp41_ = group;
	clutter_actor_set_easing_duration (_tmp41_, (guint) (NIBBLES_GAME_GAMEDELAY * 9));
	_tmp42_ = group;
	clutter_actor_set_scale (_tmp42_, (gdouble) 2.0f, (gdouble) 2.0f);
	_tmp43_ = group;
	clutter_actor_set_pivot_point (_tmp43_, 0.5f, 0.5f);
	_tmp44_ = group;
	clutter_actor_set_opacity (_tmp44_, (guint8) 0);
	_tmp45_ = group;
	clutter_actor_restore_easing_state (_tmp45_);
	nibbles_view_play_sound (self, "crash");
	_g_object_unref0 (actors);
	_g_object_unref0 (group);
}


static void
nibbles_view_worm_tail_reduced_cb (NibblesView* self,
                                   Worm* worm,
                                   gint erase_size)
{
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	ClutterActor* group = NULL;
	ClutterActor* _tmp0_;
	WormActor* worm_actors = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	gint color = 0;
	NibblesGame* _tmp3_;
	NibblesGame* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp6_;
	gpointer _tmp7_;
	WormProperties* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	ClutterActor* _tmp43_;
	ClutterActor* _tmp44_;
	ClutterActor* _tmp45_;
	ClutterActor* _tmp46_;
	ClutterActor* _tmp47_;
	ClutterActor* _tmp48_;
	ClutterActor* _tmp49_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = clutter_actor_new ();
	g_object_ref_sink (_tmp0_);
	group = _tmp0_;
	_tmp1_ = self->priv->worm_actors;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, worm);
	worm_actors = (WormActor*) _tmp2_;
	_tmp3_ = nibbles_view_get_game (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = nibbles_game_get_worm_props (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, worm);
	_tmp8_ = (WormProperties*) _tmp7_;
	_tmp9_ = (*_tmp8_).color;
	_tmp10_ = _tmp9_;
	_worm_properties_free0 (_tmp8_);
	color = _tmp10_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_;
				GtkClutterTexture* texture = NULL;
				GtkClutterTexture* _tmp14_;
				WormActor* _tmp20_;
				ClutterActor* _tmp21_;
				ClutterActor* _tmp22_;
				gfloat _tmp23_ = 0.0F;
				gfloat _tmp24_ = 0.0F;
				WormActor* _tmp25_;
				WormActor* _tmp26_;
				ClutterActor* _tmp27_;
				ClutterActor* _tmp28_;
				GtkClutterTexture* _tmp29_;
				gfloat _tmp30_;
				gfloat _tmp31_;
				GtkClutterTexture* _tmp32_;
				NibblesGame* _tmp33_;
				NibblesGame* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				NibblesGame* _tmp37_;
				NibblesGame* _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				ClutterActor* _tmp41_;
				GtkClutterTexture* _tmp42_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = i;
				if (!(_tmp13_ < erase_size)) {
					break;
				}
				_tmp14_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
				g_object_ref_sink (_tmp14_);
				texture = _tmp14_;
				{
					GtkClutterTexture* _tmp15_;
					gint _tmp16_;
					GdkPixbuf* _tmp17_;
					_tmp15_ = texture;
					_tmp16_ = color;
					_tmp17_ = self->priv->worm_pixmaps[_tmp16_];
					gtk_clutter_texture_set_from_pixbuf (_tmp15_, _tmp17_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
							goto __catch6_clutter_texture_error;
						}
						goto __catch6_g_error;
					}
				}
				goto __finally6;
				__catch6_clutter_texture_error:
				{
					GError* e = NULL;
					const gchar* _tmp18_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp18_ = e->message;
					g_error ("nibbles-view.vala:738: Nibbles failed to set texture: %s", _tmp18_);
					_g_error_free0 (e);
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp19_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp19_ = e->message;
					g_error ("nibbles-view.vala:742: Nibbles failed to set texture: %s", _tmp19_);
					_g_error_free0 (e);
				}
				__finally6:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (texture);
					_g_object_unref0 (worm_actors);
					_g_object_unref0 (group);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp20_ = worm_actors;
				_tmp21_ = clutter_actor_get_first_child ((ClutterActor*) _tmp20_);
				_tmp22_ = _tmp21_;
				clutter_actor_get_position (_tmp22_, &_tmp23_, &_tmp24_);
				x = _tmp23_;
				y = _tmp24_;
				_tmp25_ = worm_actors;
				_tmp26_ = worm_actors;
				_tmp27_ = clutter_actor_get_first_child ((ClutterActor*) _tmp26_);
				_tmp28_ = _tmp27_;
				clutter_actor_remove_child ((ClutterActor*) _tmp25_, _tmp28_);
				_tmp29_ = texture;
				_tmp30_ = x;
				_tmp31_ = y;
				clutter_actor_set_position ((ClutterActor*) _tmp29_, _tmp30_, _tmp31_);
				_tmp32_ = texture;
				_tmp33_ = nibbles_view_get_game (self);
				_tmp34_ = _tmp33_;
				_tmp35_ = nibbles_game_get_tile_size (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = nibbles_view_get_game (self);
				_tmp38_ = _tmp37_;
				_tmp39_ = nibbles_game_get_tile_size (_tmp38_);
				_tmp40_ = _tmp39_;
				clutter_actor_set_size ((ClutterActor*) _tmp32_, (gfloat) _tmp36_, (gfloat) _tmp40_);
				_tmp41_ = group;
				_tmp42_ = texture;
				clutter_actor_add_child (_tmp41_, (ClutterActor*) _tmp42_);
				_g_object_unref0 (texture);
			}
		}
	}
	_tmp43_ = self->priv->level;
	_tmp44_ = group;
	clutter_actor_add_child (_tmp43_, _tmp44_);
	_tmp45_ = group;
	clutter_actor_save_easing_state (_tmp45_);
	_tmp46_ = group;
	clutter_actor_set_easing_mode (_tmp46_, CLUTTER_EASE_OUT_EXPO);
	_tmp47_ = group;
	clutter_actor_set_easing_duration (_tmp47_, (guint) (NIBBLES_GAME_GAMEDELAY * 25));
	_tmp48_ = group;
	clutter_actor_set_opacity (_tmp48_, (guint8) 0);
	_tmp49_ = group;
	clutter_actor_restore_easing_state (_tmp49_);
	_g_object_unref0 (worm_actors);
	_g_object_unref0 (group);
}


static void
nibbles_view_worm_reversed_cb (NibblesView* self,
                               Worm* worm)
{
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gint count = 0;
	WormActor* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->worm_actors;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, worm);
	actors = (WormActor*) _tmp1_;
	count = 0;
	_tmp2_ = actors;
	_tmp3_ = clutter_actor_get_children ((ClutterActor*) _tmp2_);
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp3_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor = NULL;
			actor = (ClutterActor*) actor_it->data;
			{
				ClutterActor* _tmp4_;
				GeeLinkedList* _tmp5_;
				GeeLinkedList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				Position* _tmp9_;
				gint _tmp10_;
				NibblesGame* _tmp11_;
				NibblesGame* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				GeeLinkedList* _tmp15_;
				GeeLinkedList* _tmp16_;
				gint _tmp17_;
				gpointer _tmp18_;
				Position* _tmp19_;
				gint _tmp20_;
				NibblesGame* _tmp21_;
				NibblesGame* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				_tmp4_ = actor;
				_tmp5_ = worm_get_list (worm);
				_tmp6_ = _tmp5_;
				_tmp7_ = count;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tmp7_);
				_tmp9_ = (Position*) _tmp8_;
				_tmp10_ = (*_tmp9_).x;
				_tmp11_ = nibbles_view_get_game (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = nibbles_game_get_tile_size (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = worm_get_list (worm);
				_tmp16_ = _tmp15_;
				_tmp17_ = count;
				_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
				_tmp19_ = (Position*) _tmp18_;
				_tmp20_ = (*_tmp19_).y;
				_tmp21_ = nibbles_view_get_game (self);
				_tmp22_ = _tmp21_;
				_tmp23_ = nibbles_game_get_tile_size (_tmp22_);
				_tmp24_ = _tmp23_;
				clutter_actor_set_position (_tmp4_, (gfloat) (_tmp10_ * _tmp14_), (gfloat) (_tmp20_ * _tmp24_));
				_position_free0 (_tmp19_);
				_position_free0 (_tmp9_);
				_tmp25_ = count;
				count = _tmp25_ + 1;
			}
		}
		(actor_collection == NULL) ? NULL : (actor_collection = (g_list_free (actor_collection), NULL));
	}
	_g_object_unref0 (actors);
}


static void
nibbles_view_bonus_added_cb (NibblesView* self)
{
	Bonus* bonus = NULL;
	NibblesGame* _tmp0_;
	NibblesGame* _tmp1_;
	Boni* _tmp2_;
	Boni* _tmp3_;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	BonusTexture* actor = NULL;
	BonusTexture* _tmp6_;
	NibblesGame* _tmp11_;
	NibblesGame* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	NibblesGame* _tmp15_;
	NibblesGame* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	NibblesGame* _tmp20_;
	NibblesGame* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	NibblesGame* _tmp25_;
	NibblesGame* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	ClutterActor* _tmp29_;
	BonusType _tmp30_;
	GeeHashMap* _tmp31_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = nibbles_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = nibbles_game_get_boni (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->bonuses;
	_tmp5_ = gee_linked_list_last (_tmp4_);
	bonus = (Bonus*) _tmp5_;
	_tmp6_ = bonus_texture_new ();
	g_object_ref_sink (_tmp6_);
	actor = _tmp6_;
	{
		BonusType _tmp7_;
		GdkPixbuf* _tmp8_;
		_tmp7_ = bonus->type;
		_tmp8_ = self->priv->boni_pixmaps[_tmp7_];
		gtk_clutter_texture_set_from_pixbuf ((GtkClutterTexture*) actor, _tmp8_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch7_clutter_texture_error;
			}
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_clutter_texture_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e->message;
		g_error ("nibbles-view.vala:788: Nibbles failed to set texture: %s", _tmp9_);
		_g_error_free0 (e);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e->message;
		g_error ("nibbles-view.vala:792: Nibbles failed to set texture: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (actor);
		_g_object_unref0 (bonus);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = nibbles_view_get_game (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = nibbles_game_get_tile_size (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = nibbles_view_get_game (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = nibbles_game_get_tile_size (_tmp16_);
	_tmp18_ = _tmp17_;
	bonus_texture_set_size (actor, (gfloat) _tmp14_, (gfloat) _tmp18_);
	_tmp19_ = bonus->x;
	_tmp20_ = nibbles_view_get_game (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = nibbles_game_get_tile_size (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = bonus->y;
	_tmp25_ = nibbles_view_get_game (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = nibbles_game_get_tile_size (_tmp26_);
	_tmp28_ = _tmp27_;
	clutter_actor_set_position ((ClutterActor*) actor, (gfloat) (_tmp19_ * _tmp23_), (gfloat) (_tmp24_ * _tmp28_));
	_tmp29_ = self->priv->level;
	clutter_actor_add_child (_tmp29_, (ClutterActor*) actor);
	_tmp30_ = bonus->type;
	if (_tmp30_ != BONUS_TYPE_REGULAR) {
		nibbles_view_play_sound (self, "appear");
	}
	_tmp31_ = self->priv->bonus_actors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, bonus, actor);
	_g_object_unref0 (actor);
	_g_object_unref0 (bonus);
}


static void
nibbles_view_bonus_removed_cb (NibblesView* self,
                               Bonus* bonus)
{
	BonusTexture* bonus_actor = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GeeHashMap* _tmp2_;
	ClutterActor* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bonus != NULL);
	_tmp0_ = self->priv->bonus_actors;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, bonus);
	bonus_actor = (BonusTexture*) _tmp1_;
	_tmp2_ = self->priv->bonus_actors;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp2_, bonus, NULL);
	clutter_actor_hide ((ClutterActor*) bonus_actor);
	_tmp3_ = self->priv->level;
	clutter_actor_remove_child (_tmp3_, (ClutterActor*) bonus_actor);
	_g_object_unref0 (bonus_actor);
}


static void
nibbles_view_bonus_applied_cb (NibblesView* self,
                               Bonus* bonus,
                               Worm* worm)
{
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	ClutterActor* actor = NULL;
	WormActor* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	BonusType _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bonus != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->worm_actors;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, worm);
	actors = (WormActor*) _tmp1_;
	_tmp2_ = actors;
	_tmp3_ = clutter_actor_get_last_child ((ClutterActor*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	actor = _tmp5_;
	_tmp6_ = actor;
	clutter_actor_save_easing_state (_tmp6_);
	_tmp7_ = actor;
	clutter_actor_set_easing_mode (_tmp7_, CLUTTER_EASE_OUT_QUINT);
	_tmp8_ = actor;
	clutter_actor_set_easing_duration (_tmp8_, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
	_tmp9_ = actor;
	clutter_actor_set_scale (_tmp9_, (gdouble) 1.45f, (gdouble) 1.45f);
	_tmp10_ = actor;
	clutter_actor_set_pivot_point (_tmp10_, 0.5f, 0.5f);
	_tmp11_ = actor;
	clutter_actor_restore_easing_state (_tmp11_);
	_tmp12_ = bonus->type;
	switch (_tmp12_) {
		case BONUS_TYPE_REGULAR:
		{
			nibbles_view_play_sound (self, "gobble");
			break;
		}
		case BONUS_TYPE_DOUBLE:
		{
			nibbles_view_play_sound (self, "bonus");
			break;
		}
		case BONUS_TYPE_HALF:
		{
			nibbles_view_play_sound (self, "bonus");
			break;
		}
		case BONUS_TYPE_LIFE:
		{
			nibbles_view_play_sound (self, "life");
			break;
		}
		case BONUS_TYPE_REVERSE:
		{
			nibbles_view_play_sound (self, "reverse");
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_g_object_unref0 (actor);
	_g_object_unref0 (actors);
}


void
nibbles_view_boni_rescale (NibblesView* self,
                           gint tile_size)
{
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _bonus_list = NULL;
		NibblesGame* _tmp0_;
		NibblesGame* _tmp1_;
		Boni* _tmp2_;
		Boni* _tmp3_;
		GeeLinkedList* _tmp4_;
		GeeLinkedList* _tmp5_;
		gint _bonus_size = 0;
		GeeLinkedList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _bonus_index = 0;
		_tmp0_ = nibbles_view_get_game (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = nibbles_game_get_boni (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->bonuses;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_bonus_list = _tmp5_;
		_tmp6_ = _bonus_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_bonus_size = _tmp8_;
		_bonus_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			Bonus* bonus = NULL;
			GeeLinkedList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			BonusTexture* actor = NULL;
			GeeHashMap* _tmp15_;
			Bonus* _tmp16_;
			gpointer _tmp17_;
			BonusTexture* _tmp18_;
			_tmp9_ = _bonus_index;
			_bonus_index = _tmp9_ + 1;
			_tmp10_ = _bonus_index;
			_tmp11_ = _bonus_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _bonus_list;
			_tmp13_ = _bonus_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			bonus = (Bonus*) _tmp14_;
			_tmp15_ = self->priv->bonus_actors;
			_tmp16_ = bonus;
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
			actor = (BonusTexture*) _tmp17_;
			_tmp18_ = actor;
			bonus_texture_set_size (_tmp18_, (gfloat) tile_size, (gfloat) tile_size);
			_g_object_unref0 (actor);
			_g_object_unref0 (bonus);
		}
		_g_object_unref0 (_bonus_list);
	}
}


static void
nibbles_view_warp_added_cb (NibblesView* self,
                            Warp* warp)
{
	WarpTexture* actor = NULL;
	WarpTexture* _tmp0_;
	NibblesGame* _tmp4_;
	NibblesGame* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	NibblesGame* _tmp8_;
	NibblesGame* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	NibblesGame* _tmp13_;
	NibblesGame* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	NibblesGame* _tmp18_;
	NibblesGame* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	ClutterActor* _tmp22_;
	GeeHashMap* _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (warp != NULL);
	_tmp0_ = warp_texture_new ();
	g_object_ref_sink (_tmp0_);
	actor = _tmp0_;
	{
		GdkPixbuf* _tmp1_;
		_tmp1_ = self->priv->boni_pixmaps[BONUS_TYPE_WARP];
		gtk_clutter_texture_set_from_pixbuf ((GtkClutterTexture*) actor, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch8_clutter_texture_error;
			}
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_clutter_texture_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e->message;
		g_error ("nibbles-view.vala:869: Nibbles failed to set texture: %s", _tmp2_);
		_g_error_free0 (e);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e->message;
		g_error ("nibbles-view.vala:873: Nibbles failed to set texture: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (actor);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = nibbles_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = nibbles_game_get_tile_size (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = nibbles_view_get_game (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = nibbles_game_get_tile_size (_tmp9_);
	_tmp11_ = _tmp10_;
	warp_texture_set_size (actor, (gfloat) _tmp7_, (gfloat) _tmp11_);
	_tmp12_ = warp->x;
	_tmp13_ = nibbles_view_get_game (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = nibbles_game_get_tile_size (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = warp->y;
	_tmp18_ = nibbles_view_get_game (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = nibbles_game_get_tile_size (_tmp19_);
	_tmp21_ = _tmp20_;
	clutter_actor_set_position ((ClutterActor*) actor, (gfloat) (_tmp12_ * _tmp16_), (gfloat) (_tmp17_ * _tmp21_));
	_tmp22_ = self->priv->level;
	clutter_actor_add_child (_tmp22_, (ClutterActor*) actor);
	_tmp23_ = self->priv->warp_actors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, warp, actor);
	_g_object_unref0 (actor);
}


void
nibbles_view_warps_rescale (NibblesView* self,
                            gint tile_size)
{
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _warp_list = NULL;
		NibblesGame* _tmp0_;
		NibblesGame* _tmp1_;
		WarpManager* _tmp2_;
		WarpManager* _tmp3_;
		GeeLinkedList* _tmp4_;
		GeeLinkedList* _tmp5_;
		gint _warp_size = 0;
		GeeLinkedList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _warp_index = 0;
		_tmp0_ = nibbles_view_get_game (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = nibbles_game_get_warp_manager (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->warps;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_warp_list = _tmp5_;
		_tmp6_ = _warp_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_warp_size = _tmp8_;
		_warp_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			Warp* warp = NULL;
			GeeLinkedList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			WarpTexture* actor = NULL;
			GeeHashMap* _tmp15_;
			Warp* _tmp16_;
			gpointer _tmp17_;
			WarpTexture* _tmp18_;
			_tmp9_ = _warp_index;
			_warp_index = _tmp9_ + 1;
			_tmp10_ = _warp_index;
			_tmp11_ = _warp_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _warp_list;
			_tmp13_ = _warp_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			warp = (Warp*) _tmp14_;
			_tmp15_ = self->priv->warp_actors;
			_tmp16_ = warp;
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
			actor = (WarpTexture*) _tmp17_;
			_tmp18_ = actor;
			warp_texture_set_size (_tmp18_, (gfloat) tile_size, (gfloat) tile_size);
			_g_object_unref0 (actor);
			_g_object_unref0 (warp);
		}
		_g_object_unref0 (_warp_list);
	}
}


static void
nibbles_view_play_sound (NibblesView* self,
                         const gchar* name)
{
	gboolean _tmp0_;
	gchar* filename = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* path = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->is_muted;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = string_to_string (name);
	_tmp2_ = g_strconcat (_tmp1_, ".ogg", NULL);
	filename = _tmp2_;
	_tmp3_ = filename;
	_tmp4_ = g_build_filename (SOUND_DIRECTORY, _tmp3_, NULL, NULL);
	path = _tmp4_;
	_tmp5_ = path;
	ca_gtk_play_for_widget ((GtkWidget*) self, (guint32) 0, CA_PROP_MEDIA_NAME, name, CA_PROP_MEDIA_FILENAME, _tmp5_, NULL);
	_g_free0 (path);
	_g_free0 (filename);
}


gchar*
nibbles_view_colorval_name (gint colorval)
{
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = nibbles_view_color_lookup;
	_tmp0__length1 = nibbles_view_color_lookup_length1;
	_tmp1_ = _tmp0_[colorval];
	_tmp2_ = g_strdup (_ (_tmp1_));
	result = _tmp2_;
	return result;
}


ClutterActor*
nibbles_view_get_name_labels (NibblesView* self)
{
	ClutterActor* result;
	ClutterActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name_labels;
	result = _tmp0_;
	return result;
}


static void
nibbles_view_set_name_labels (NibblesView* self,
                              ClutterActor* value)
{
	g_return_if_fail (self != NULL);
	if (nibbles_view_get_name_labels (self) != value) {
		ClutterActor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_name_labels);
		self->priv->_name_labels = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, nibbles_view_properties[NIBBLES_VIEW_NAME_LABELS_PROPERTY]);
	}
}


NibblesGame*
nibbles_view_get_game (NibblesView* self)
{
	NibblesGame* result;
	NibblesGame* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static void
_nibbles_view_bonus_added_cb_boni_bonus_added (Boni* _sender,
                                               gpointer self)
{
	nibbles_view_bonus_added_cb ((NibblesView*) self);
}


static void
_nibbles_view_bonus_removed_cb_boni_bonus_removed (Boni* _sender,
                                                   Bonus* bonus,
                                                   gpointer self)
{
	nibbles_view_bonus_removed_cb ((NibblesView*) self, bonus);
}


static void
_nibbles_view_bonus_applied_cb_nibbles_game_bonus_applied (NibblesGame* _sender,
                                                           Bonus* bonus,
                                                           Worm* worm,
                                                           gpointer self)
{
	nibbles_view_bonus_applied_cb ((NibblesView*) self, bonus, worm);
}


static void
_nibbles_view_warp_added_cb_warp_manager_warp_added (WarpManager* _sender,
                                                     Warp* warp,
                                                     gpointer self)
{
	nibbles_view_warp_added_cb ((NibblesView*) self, warp);
}


static void
_nibbles_view_animate_end_game_cb_nibbles_game_animate_end_game (NibblesGame* _sender,
                                                                 gpointer self)
{
	nibbles_view_animate_end_game_cb ((NibblesView*) self);
}


void
nibbles_view_set_game (NibblesView* self,
                       NibblesGame* value)
{
	NibblesGame* _tmp0_;
	NibblesGame* _tmp2_;
	NibblesGame* _tmp3_;
	Boni* _tmp4_;
	Boni* _tmp5_;
	NibblesGame* _tmp6_;
	Boni* _tmp7_;
	Boni* _tmp8_;
	NibblesGame* _tmp9_;
	NibblesGame* _tmp10_;
	WarpManager* _tmp11_;
	WarpManager* _tmp12_;
	NibblesGame* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		NibblesGame* _tmp1_;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp2_;
	_tmp3_ = self->priv->_game;
	_tmp4_ = nibbles_game_get_boni (_tmp3_);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "bonus-added", (GCallback) _nibbles_view_bonus_added_cb_boni_bonus_added, self, 0);
	_tmp6_ = self->priv->_game;
	_tmp7_ = nibbles_game_get_boni (_tmp6_);
	_tmp8_ = _tmp7_;
	g_signal_connect_object (_tmp8_, "bonus-removed", (GCallback) _nibbles_view_bonus_removed_cb_boni_bonus_removed, self, 0);
	_tmp9_ = self->priv->_game;
	g_signal_connect_object (_tmp9_, "bonus-applied", (GCallback) _nibbles_view_bonus_applied_cb_nibbles_game_bonus_applied, self, 0);
	_tmp10_ = self->priv->_game;
	_tmp11_ = nibbles_game_get_warp_manager (_tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_connect_object (_tmp12_, "warp-added", (GCallback) _nibbles_view_warp_added_cb_warp_manager_warp_added, self, 0);
	_tmp13_ = self->priv->_game;
	g_signal_connect_object (_tmp13_, "animate-end-game", (GCallback) _nibbles_view_animate_end_game_cb_nibbles_game_animate_end_game, self, 0);
	g_object_notify_by_pspec ((GObject *) self, nibbles_view_properties[NIBBLES_VIEW_GAME_PROPERTY]);
}


static void
nibbles_view_class_init (NibblesViewClass * klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	nibbles_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NibblesViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_nibbles_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_nibbles_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = nibbles_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_VIEW_NAME_LABELS_PROPERTY, nibbles_view_properties[NIBBLES_VIEW_NAME_LABELS_PROPERTY] = g_param_spec_object ("name-labels", "name-labels", "name-labels", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_VIEW_GAME_PROPERTY, nibbles_view_properties[NIBBLES_VIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_NIBBLES_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_strdup (N_ ("red"));
	_tmp1_ = g_strdup (N_ ("green"));
	_tmp2_ = g_strdup (N_ ("blue"));
	_tmp3_ = g_strdup (N_ ("yellow"));
	_tmp4_ = g_strdup (N_ ("cyan"));
	_tmp5_ = g_strdup (N_ ("purple"));
	_tmp6_ = g_new0 (gchar*, 6 + 1);
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp2_;
	_tmp6_[3] = _tmp3_;
	_tmp6_[4] = _tmp4_;
	_tmp6_[5] = _tmp5_;
	nibbles_view_color_lookup = _tmp6_;
	nibbles_view_color_lookup_length1 = 6;
}


static void
nibbles_view_instance_init (NibblesView * self)
{
	self->priv = NIBBLES_VIEW_GET_PRIVATE (self);
}


static void
nibbles_view_finalize (GObject * obj)
{
	NibblesView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_VIEW, NibblesView);
	_vala_array_destroy (self->priv->wall_pixmaps, 11, (GDestroyNotify) g_object_unref);
	_vala_array_destroy (self->priv->worm_pixmaps, 6, (GDestroyNotify) g_object_unref);
	_vala_array_destroy (self->priv->boni_pixmaps, 9, (GDestroyNotify) g_object_unref);
	_g_object_unref0 (self->priv->stage);
	_g_object_unref0 (self->priv->level);
	_g_object_unref0 (self->priv->_name_labels);
	_g_object_unref0 (self->priv->worm_actors);
	_g_object_unref0 (self->priv->bonus_actors);
	_g_object_unref0 (self->priv->warp_actors);
	_g_object_unref0 (self->priv->_game);
	G_OBJECT_CLASS (nibbles_view_parent_class)->finalize (obj);
}


GType
nibbles_view_get_type (void)
{
	static volatile gsize nibbles_view_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesView), 0, (GInstanceInitFunc) nibbles_view_instance_init, NULL };
		GType nibbles_view_type_id;
		nibbles_view_type_id = g_type_register_static (gtk_clutter_embed_get_type (), "NibblesView", &g_define_type_info, 0);
		g_once_init_leave (&nibbles_view_type_id__volatile, nibbles_view_type_id);
	}
	return nibbles_view_type_id__volatile;
}


static void
_vala_nibbles_view_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	NibblesView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_VIEW, NibblesView);
	switch (property_id) {
		case NIBBLES_VIEW_NAME_LABELS_PROPERTY:
		g_value_set_object (value, nibbles_view_get_name_labels (self));
		break;
		case NIBBLES_VIEW_GAME_PROPERTY:
		g_value_set_object (value, nibbles_view_get_game (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_nibbles_view_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	NibblesView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_VIEW, NibblesView);
	switch (property_id) {
		case NIBBLES_VIEW_NAME_LABELS_PROPERTY:
		nibbles_view_set_name_labels (self, g_value_get_object (value));
		break;
		case NIBBLES_VIEW_GAME_PROPERTY:
		nibbles_view_set_game (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



