// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/appengine/v1/version.proto
// DO NOT EDIT!

package google_appengine_v1 // import "google.golang.org/genproto/googleapis/appengine/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf1 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf2 "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Available inbound services.
type InboundServiceType int32

const (
	// Not specified.
	InboundServiceType_INBOUND_SERVICE_UNSPECIFIED InboundServiceType = 0
	// Allows an application to receive mail.
	InboundServiceType_INBOUND_SERVICE_MAIL InboundServiceType = 1
	// Allows an application to receive email-bound notifications.
	InboundServiceType_INBOUND_SERVICE_MAIL_BOUNCE InboundServiceType = 2
	// Allows an application to receive error stanzas.
	InboundServiceType_INBOUND_SERVICE_XMPP_ERROR InboundServiceType = 3
	// Allows an application to receive instant messages.
	InboundServiceType_INBOUND_SERVICE_XMPP_MESSAGE InboundServiceType = 4
	// Allows an application to receive user subscription POSTs.
	InboundServiceType_INBOUND_SERVICE_XMPP_SUBSCRIBE InboundServiceType = 5
	// Allows an application to receive a user's chat presence.
	InboundServiceType_INBOUND_SERVICE_XMPP_PRESENCE InboundServiceType = 6
	// Registers an application for notifications when a client connects or
	// disconnects from a channel.
	InboundServiceType_INBOUND_SERVICE_CHANNEL_PRESENCE InboundServiceType = 7
	// Enables warmup requests.
	InboundServiceType_INBOUND_SERVICE_WARMUP InboundServiceType = 9
)

var InboundServiceType_name = map[int32]string{
	0: "INBOUND_SERVICE_UNSPECIFIED",
	1: "INBOUND_SERVICE_MAIL",
	2: "INBOUND_SERVICE_MAIL_BOUNCE",
	3: "INBOUND_SERVICE_XMPP_ERROR",
	4: "INBOUND_SERVICE_XMPP_MESSAGE",
	5: "INBOUND_SERVICE_XMPP_SUBSCRIBE",
	6: "INBOUND_SERVICE_XMPP_PRESENCE",
	7: "INBOUND_SERVICE_CHANNEL_PRESENCE",
	9: "INBOUND_SERVICE_WARMUP",
}
var InboundServiceType_value = map[string]int32{
	"INBOUND_SERVICE_UNSPECIFIED":      0,
	"INBOUND_SERVICE_MAIL":             1,
	"INBOUND_SERVICE_MAIL_BOUNCE":      2,
	"INBOUND_SERVICE_XMPP_ERROR":       3,
	"INBOUND_SERVICE_XMPP_MESSAGE":     4,
	"INBOUND_SERVICE_XMPP_SUBSCRIBE":   5,
	"INBOUND_SERVICE_XMPP_PRESENCE":    6,
	"INBOUND_SERVICE_CHANNEL_PRESENCE": 7,
	"INBOUND_SERVICE_WARMUP":           9,
}

func (x InboundServiceType) String() string {
	return proto.EnumName(InboundServiceType_name, int32(x))
}
func (InboundServiceType) EnumDescriptor() ([]byte, []int) { return fileDescriptor8, []int{0} }

// Run states of a version.
type ServingStatus int32

const (
	// Not specified.
	ServingStatus_SERVING_STATUS_UNSPECIFIED ServingStatus = 0
	// Currently serving. Instances are created according to the
	// scaling settings of the version.
	ServingStatus_SERVING ServingStatus = 1
	// Disabled. No instances will be created and the scaling
	// settings are ignored until the state of the version changes
	// to `SERVING`.
	ServingStatus_STOPPED ServingStatus = 2
)

var ServingStatus_name = map[int32]string{
	0: "SERVING_STATUS_UNSPECIFIED",
	1: "SERVING",
	2: "STOPPED",
}
var ServingStatus_value = map[string]int32{
	"SERVING_STATUS_UNSPECIFIED": 0,
	"SERVING":                    1,
	"STOPPED":                    2,
}

func (x ServingStatus) String() string {
	return proto.EnumName(ServingStatus_name, int32(x))
}
func (ServingStatus) EnumDescriptor() ([]byte, []int) { return fileDescriptor8, []int{1} }

// A Version resource is a specific set of source code and configuration files
// that are deployed into a service.
type Version struct {
	// Full path to the Version resource in the API.  Example:
	// `apps/myapp/services/default/versions/v1`.
	//
	// @OutputOnly
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Relative name of the version within the service.  Example: `v1`.
	// Version names can contain only lowercase letters, numbers, or hyphens.
	// Reserved names: "default", "latest", and any name with the prefix "ah-".
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// Controls how instances are created.
	//
	// Defaults to `AutomaticScaling`.
	//
	// Types that are valid to be assigned to Scaling:
	//	*Version_AutomaticScaling
	//	*Version_BasicScaling
	//	*Version_ManualScaling
	Scaling isVersion_Scaling `protobuf_oneof:"scaling"`
	// Before an application can receive email or XMPP messages, the application
	// must be configured to enable the service.
	InboundServices []InboundServiceType `protobuf:"varint,6,rep,packed,name=inbound_services,json=inboundServices,enum=google.appengine.v1.InboundServiceType" json:"inbound_services,omitempty"`
	// Instance class that is used to run this version. Valid values are:
	// * AutomaticScaling: `F1`, `F2`, `F4`, `F4_1G`
	// * ManualScaling or BasicScaling: `B1`, `B2`, `B4`, `B8`, `B4_1G`
	//
	// Defaults to `F1` for AutomaticScaling and `B1` for ManualScaling or
	// BasicScaling.
	InstanceClass string `protobuf:"bytes,7,opt,name=instance_class,json=instanceClass" json:"instance_class,omitempty"`
	// Extra network settings. Only applicable for VM runtimes.
	Network *Network `protobuf:"bytes,8,opt,name=network" json:"network,omitempty"`
	// Machine resources for this version. Only applicable for VM runtimes.
	Resources *Resources `protobuf:"bytes,9,opt,name=resources" json:"resources,omitempty"`
	// Desired runtime. Example: `python27`.
	Runtime string `protobuf:"bytes,10,opt,name=runtime" json:"runtime,omitempty"`
	// Whether multiple requests can be dispatched to this version at once.
	Threadsafe bool `protobuf:"varint,11,opt,name=threadsafe" json:"threadsafe,omitempty"`
	// Whether to deploy this version in a container on a virtual machine.
	Vm bool `protobuf:"varint,12,opt,name=vm" json:"vm,omitempty"`
	// Metadata settings that are supplied to this version to enable
	// beta runtime features.
	BetaSettings map[string]string `protobuf:"bytes,13,rep,name=beta_settings,json=betaSettings" json:"beta_settings,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// App Engine execution environment for this version.
	//
	// Defaults to `standard`.
	Env string `protobuf:"bytes,14,opt,name=env" json:"env,omitempty"`
	// Current serving status of this version. Only the versions with a
	// `SERVING` status create instances and can be billed.
	//
	// `SERVING_STATUS_UNSPECIFIED` is an invalid value. Defaults to `SERVING`.
	ServingStatus ServingStatus `protobuf:"varint,15,opt,name=serving_status,json=servingStatus,enum=google.appengine.v1.ServingStatus" json:"serving_status,omitempty"`
	// Email address of the user who created this version.
	//
	// @OutputOnly
	CreatedBy string `protobuf:"bytes,16,opt,name=created_by,json=createdBy" json:"created_by,omitempty"`
	// Time that this version was created.
	//
	// @OutputOnly
	CreateTime *google_protobuf2.Timestamp `protobuf:"bytes,17,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// Total size in bytes of all the files that are included in this version
	// and curerntly hosted on the App Engine disk.
	//
	// @OutputOnly
	DiskUsageBytes int64 `protobuf:"varint,18,opt,name=disk_usage_bytes,json=diskUsageBytes" json:"disk_usage_bytes,omitempty"`
	// An ordered list of URL-matching patterns that should be applied to incoming
	// requests. The first matching URL handles the request and other request
	// handlers are not attempted.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	Handlers []*UrlMap `protobuf:"bytes,100,rep,name=handlers" json:"handlers,omitempty"`
	// Custom static error pages. Limited to 10KB per page.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	ErrorHandlers []*ErrorHandler `protobuf:"bytes,101,rep,name=error_handlers,json=errorHandlers" json:"error_handlers,omitempty"`
	// Configuration for third-party Python runtime libraries that are required
	// by the application.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	Libraries []*Library `protobuf:"bytes,102,rep,name=libraries" json:"libraries,omitempty"`
	// Serving configuration for
	// [Google Cloud Endpoints](https://cloud.google.com/appengine/docs/python/endpoints/).
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	ApiConfig *ApiConfigHandler `protobuf:"bytes,103,opt,name=api_config,json=apiConfig" json:"api_config,omitempty"`
	// Environment variables available to the application.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	EnvVariables map[string]string `protobuf:"bytes,104,rep,name=env_variables,json=envVariables" json:"env_variables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Duration that static files should be cached by web proxies and browsers.
	// Only applicable if the corresponding
	// [StaticFilesHandler](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#staticfileshandler)
	// does not specify its own expiration time.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	DefaultExpiration *google_protobuf1.Duration `protobuf:"bytes,105,opt,name=default_expiration,json=defaultExpiration" json:"default_expiration,omitempty"`
	// Configures health checking for VM instances. Unhealthy instances are
	// stopped and replaced with new instances. Only applicable for VM
	// runtimes.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	HealthCheck *HealthCheck `protobuf:"bytes,106,opt,name=health_check,json=healthCheck" json:"health_check,omitempty"`
	// Files that match this pattern will not be built into this version.
	// Only applicable for Go runtimes.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	NobuildFilesRegex string `protobuf:"bytes,107,opt,name=nobuild_files_regex,json=nobuildFilesRegex" json:"nobuild_files_regex,omitempty"`
	// Code and application artifacts that make up this version.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	Deployment *Deployment `protobuf:"bytes,108,opt,name=deployment" json:"deployment,omitempty"`
	// Serving URL for this version. Example:
	// "https://myversion-dot-myservice-dot-myapp.appspot.com"
	//
	// @OutputOnly
	VersionUrl string `protobuf:"bytes,109,opt,name=version_url,json=versionUrl" json:"version_url,omitempty"`
}

func (m *Version) Reset()                    { *m = Version{} }
func (m *Version) String() string            { return proto.CompactTextString(m) }
func (*Version) ProtoMessage()               {}
func (*Version) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{0} }

type isVersion_Scaling interface {
	isVersion_Scaling()
}

type Version_AutomaticScaling struct {
	AutomaticScaling *AutomaticScaling `protobuf:"bytes,3,opt,name=automatic_scaling,json=automaticScaling,oneof"`
}
type Version_BasicScaling struct {
	BasicScaling *BasicScaling `protobuf:"bytes,4,opt,name=basic_scaling,json=basicScaling,oneof"`
}
type Version_ManualScaling struct {
	ManualScaling *ManualScaling `protobuf:"bytes,5,opt,name=manual_scaling,json=manualScaling,oneof"`
}

func (*Version_AutomaticScaling) isVersion_Scaling() {}
func (*Version_BasicScaling) isVersion_Scaling()     {}
func (*Version_ManualScaling) isVersion_Scaling()    {}

func (m *Version) GetScaling() isVersion_Scaling {
	if m != nil {
		return m.Scaling
	}
	return nil
}

func (m *Version) GetAutomaticScaling() *AutomaticScaling {
	if x, ok := m.GetScaling().(*Version_AutomaticScaling); ok {
		return x.AutomaticScaling
	}
	return nil
}

func (m *Version) GetBasicScaling() *BasicScaling {
	if x, ok := m.GetScaling().(*Version_BasicScaling); ok {
		return x.BasicScaling
	}
	return nil
}

func (m *Version) GetManualScaling() *ManualScaling {
	if x, ok := m.GetScaling().(*Version_ManualScaling); ok {
		return x.ManualScaling
	}
	return nil
}

func (m *Version) GetNetwork() *Network {
	if m != nil {
		return m.Network
	}
	return nil
}

func (m *Version) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Version) GetBetaSettings() map[string]string {
	if m != nil {
		return m.BetaSettings
	}
	return nil
}

func (m *Version) GetCreateTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Version) GetHandlers() []*UrlMap {
	if m != nil {
		return m.Handlers
	}
	return nil
}

func (m *Version) GetErrorHandlers() []*ErrorHandler {
	if m != nil {
		return m.ErrorHandlers
	}
	return nil
}

func (m *Version) GetLibraries() []*Library {
	if m != nil {
		return m.Libraries
	}
	return nil
}

func (m *Version) GetApiConfig() *ApiConfigHandler {
	if m != nil {
		return m.ApiConfig
	}
	return nil
}

func (m *Version) GetEnvVariables() map[string]string {
	if m != nil {
		return m.EnvVariables
	}
	return nil
}

func (m *Version) GetDefaultExpiration() *google_protobuf1.Duration {
	if m != nil {
		return m.DefaultExpiration
	}
	return nil
}

func (m *Version) GetHealthCheck() *HealthCheck {
	if m != nil {
		return m.HealthCheck
	}
	return nil
}

func (m *Version) GetDeployment() *Deployment {
	if m != nil {
		return m.Deployment
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Version) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Version_OneofMarshaler, _Version_OneofUnmarshaler, _Version_OneofSizer, []interface{}{
		(*Version_AutomaticScaling)(nil),
		(*Version_BasicScaling)(nil),
		(*Version_ManualScaling)(nil),
	}
}

func _Version_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Version)
	// scaling
	switch x := m.Scaling.(type) {
	case *Version_AutomaticScaling:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AutomaticScaling); err != nil {
			return err
		}
	case *Version_BasicScaling:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BasicScaling); err != nil {
			return err
		}
	case *Version_ManualScaling:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ManualScaling); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Version.Scaling has unexpected type %T", x)
	}
	return nil
}

func _Version_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Version)
	switch tag {
	case 3: // scaling.automatic_scaling
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AutomaticScaling)
		err := b.DecodeMessage(msg)
		m.Scaling = &Version_AutomaticScaling{msg}
		return true, err
	case 4: // scaling.basic_scaling
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BasicScaling)
		err := b.DecodeMessage(msg)
		m.Scaling = &Version_BasicScaling{msg}
		return true, err
	case 5: // scaling.manual_scaling
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ManualScaling)
		err := b.DecodeMessage(msg)
		m.Scaling = &Version_ManualScaling{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Version_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Version)
	// scaling
	switch x := m.Scaling.(type) {
	case *Version_AutomaticScaling:
		s := proto.Size(x.AutomaticScaling)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Version_BasicScaling:
		s := proto.Size(x.BasicScaling)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Version_ManualScaling:
		s := proto.Size(x.ManualScaling)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Automatic scaling is based on request rate, response latencies, and other
// application metrics.
type AutomaticScaling struct {
	// Amount of time that the
	// [Autoscaler](https://cloud.google.com/compute/docs/autoscaler/)
	// should wait between changes to the number of virtual machines.
	// Only applicable for VM runtimes.
	CoolDownPeriod *google_protobuf1.Duration `protobuf:"bytes,1,opt,name=cool_down_period,json=coolDownPeriod" json:"cool_down_period,omitempty"`
	// Target scaling by CPU usage.
	CpuUtilization *CpuUtilization `protobuf:"bytes,2,opt,name=cpu_utilization,json=cpuUtilization" json:"cpu_utilization,omitempty"`
	// Number of concurrent requests an automatic scaling instance can accept
	// before the scheduler spawns a new instance.
	//
	// Defaults to a runtime-specific value.
	MaxConcurrentRequests int32 `protobuf:"varint,3,opt,name=max_concurrent_requests,json=maxConcurrentRequests" json:"max_concurrent_requests,omitempty"`
	// Maximum number of idle instances that should be maintained for this
	// version.
	MaxIdleInstances int32 `protobuf:"varint,4,opt,name=max_idle_instances,json=maxIdleInstances" json:"max_idle_instances,omitempty"`
	// Maximum number of instances that should be started to handle requests.
	MaxTotalInstances int32 `protobuf:"varint,5,opt,name=max_total_instances,json=maxTotalInstances" json:"max_total_instances,omitempty"`
	// Maximum amount of time that a request should wait in the pending queue
	// before starting a new instance to handle it.
	MaxPendingLatency *google_protobuf1.Duration `protobuf:"bytes,6,opt,name=max_pending_latency,json=maxPendingLatency" json:"max_pending_latency,omitempty"`
	// Minimum number of idle instances that should be maintained for
	// this version. Only applicable for the default version of a service.
	MinIdleInstances int32 `protobuf:"varint,7,opt,name=min_idle_instances,json=minIdleInstances" json:"min_idle_instances,omitempty"`
	// Minimum number of instances that should be maintained for this version.
	MinTotalInstances int32 `protobuf:"varint,8,opt,name=min_total_instances,json=minTotalInstances" json:"min_total_instances,omitempty"`
	// Minimum amount of time a request should wait in the pending queue before
	// starting a new instance to handle it.
	MinPendingLatency *google_protobuf1.Duration `protobuf:"bytes,9,opt,name=min_pending_latency,json=minPendingLatency" json:"min_pending_latency,omitempty"`
	// Target scaling by request utilization.
	RequestUtilization *RequestUtilization `protobuf:"bytes,10,opt,name=request_utilization,json=requestUtilization" json:"request_utilization,omitempty"`
	// Target scaling by disk usage.
	DiskUtilization *DiskUtilization `protobuf:"bytes,11,opt,name=disk_utilization,json=diskUtilization" json:"disk_utilization,omitempty"`
	// Target scaling by network usage.
	NetworkUtilization *NetworkUtilization `protobuf:"bytes,12,opt,name=network_utilization,json=networkUtilization" json:"network_utilization,omitempty"`
}

func (m *AutomaticScaling) Reset()                    { *m = AutomaticScaling{} }
func (m *AutomaticScaling) String() string            { return proto.CompactTextString(m) }
func (*AutomaticScaling) ProtoMessage()               {}
func (*AutomaticScaling) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{1} }

func (m *AutomaticScaling) GetCoolDownPeriod() *google_protobuf1.Duration {
	if m != nil {
		return m.CoolDownPeriod
	}
	return nil
}

func (m *AutomaticScaling) GetCpuUtilization() *CpuUtilization {
	if m != nil {
		return m.CpuUtilization
	}
	return nil
}

func (m *AutomaticScaling) GetMaxPendingLatency() *google_protobuf1.Duration {
	if m != nil {
		return m.MaxPendingLatency
	}
	return nil
}

func (m *AutomaticScaling) GetMinPendingLatency() *google_protobuf1.Duration {
	if m != nil {
		return m.MinPendingLatency
	}
	return nil
}

func (m *AutomaticScaling) GetRequestUtilization() *RequestUtilization {
	if m != nil {
		return m.RequestUtilization
	}
	return nil
}

func (m *AutomaticScaling) GetDiskUtilization() *DiskUtilization {
	if m != nil {
		return m.DiskUtilization
	}
	return nil
}

func (m *AutomaticScaling) GetNetworkUtilization() *NetworkUtilization {
	if m != nil {
		return m.NetworkUtilization
	}
	return nil
}

// A service with basic scaling will create an instance when the application
// receives a request. The instance will be turned down when the app becomes
// idle. Basic scaling is ideal for work that is intermittent or driven by
// user activity.
type BasicScaling struct {
	// Duration of time after the last request that an instance must wait before
	// the instance is shut down.
	IdleTimeout *google_protobuf1.Duration `protobuf:"bytes,1,opt,name=idle_timeout,json=idleTimeout" json:"idle_timeout,omitempty"`
	// Maximum number of instances to create for this version.
	MaxInstances int32 `protobuf:"varint,2,opt,name=max_instances,json=maxInstances" json:"max_instances,omitempty"`
}

func (m *BasicScaling) Reset()                    { *m = BasicScaling{} }
func (m *BasicScaling) String() string            { return proto.CompactTextString(m) }
func (*BasicScaling) ProtoMessage()               {}
func (*BasicScaling) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{2} }

func (m *BasicScaling) GetIdleTimeout() *google_protobuf1.Duration {
	if m != nil {
		return m.IdleTimeout
	}
	return nil
}

// A service with manual scaling runs continuously, allowing you to perform
// complex initialization and rely on the state of its memory over time.
type ManualScaling struct {
	// Number of instances to assign to the service at the start. This number
	// can later be altered by using the
	// [Modules API](https://cloud.google.com/appengine/docs/python/modules/functions)
	// `set_num_instances()` function.
	Instances int32 `protobuf:"varint,1,opt,name=instances" json:"instances,omitempty"`
}

func (m *ManualScaling) Reset()                    { *m = ManualScaling{} }
func (m *ManualScaling) String() string            { return proto.CompactTextString(m) }
func (*ManualScaling) ProtoMessage()               {}
func (*ManualScaling) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{3} }

// Target scaling by CPU usage.
type CpuUtilization struct {
	// Period of time over which CPU utilization is calculated.
	AggregationWindowLength *google_protobuf1.Duration `protobuf:"bytes,1,opt,name=aggregation_window_length,json=aggregationWindowLength" json:"aggregation_window_length,omitempty"`
	// Target CPU utilization ratio to maintain when scaling. Must be between 0
	// and 1.
	TargetUtilization float64 `protobuf:"fixed64,2,opt,name=target_utilization,json=targetUtilization" json:"target_utilization,omitempty"`
}

func (m *CpuUtilization) Reset()                    { *m = CpuUtilization{} }
func (m *CpuUtilization) String() string            { return proto.CompactTextString(m) }
func (*CpuUtilization) ProtoMessage()               {}
func (*CpuUtilization) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{4} }

func (m *CpuUtilization) GetAggregationWindowLength() *google_protobuf1.Duration {
	if m != nil {
		return m.AggregationWindowLength
	}
	return nil
}

// Target scaling by request utilization. Only applicable for VM runtimes.
type RequestUtilization struct {
	// Target requests per second.
	TargetRequestCountPerSecond int32 `protobuf:"varint,1,opt,name=target_request_count_per_second,json=targetRequestCountPerSecond" json:"target_request_count_per_second,omitempty"`
	// Target number of concurrent requests.
	TargetConcurrentRequests int32 `protobuf:"varint,2,opt,name=target_concurrent_requests,json=targetConcurrentRequests" json:"target_concurrent_requests,omitempty"`
}

func (m *RequestUtilization) Reset()                    { *m = RequestUtilization{} }
func (m *RequestUtilization) String() string            { return proto.CompactTextString(m) }
func (*RequestUtilization) ProtoMessage()               {}
func (*RequestUtilization) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{5} }

// Target scaling by disk usage. Only applicable for VM runtimes.
type DiskUtilization struct {
	// Target bytes written per second.
	TargetWriteBytesPerSecond int32 `protobuf:"varint,14,opt,name=target_write_bytes_per_second,json=targetWriteBytesPerSecond" json:"target_write_bytes_per_second,omitempty"`
	// Target ops written per second.
	TargetWriteOpsPerSecond int32 `protobuf:"varint,15,opt,name=target_write_ops_per_second,json=targetWriteOpsPerSecond" json:"target_write_ops_per_second,omitempty"`
	// Target bytes read per second.
	TargetReadBytesPerSecond int32 `protobuf:"varint,16,opt,name=target_read_bytes_per_second,json=targetReadBytesPerSecond" json:"target_read_bytes_per_second,omitempty"`
	// Target ops read per seconds.
	TargetReadOpsPerSecond int32 `protobuf:"varint,17,opt,name=target_read_ops_per_second,json=targetReadOpsPerSecond" json:"target_read_ops_per_second,omitempty"`
}

func (m *DiskUtilization) Reset()                    { *m = DiskUtilization{} }
func (m *DiskUtilization) String() string            { return proto.CompactTextString(m) }
func (*DiskUtilization) ProtoMessage()               {}
func (*DiskUtilization) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{6} }

// Target scaling by network usage. Only applicable for VM runtimes.
type NetworkUtilization struct {
	// Target bytes sent per second.
	TargetSentBytesPerSecond int32 `protobuf:"varint,1,opt,name=target_sent_bytes_per_second,json=targetSentBytesPerSecond" json:"target_sent_bytes_per_second,omitempty"`
	// Target packets sent per second.
	TargetSentPacketsPerSecond int32 `protobuf:"varint,11,opt,name=target_sent_packets_per_second,json=targetSentPacketsPerSecond" json:"target_sent_packets_per_second,omitempty"`
	// Target bytes received per second.
	TargetReceivedBytesPerSecond int32 `protobuf:"varint,12,opt,name=target_received_bytes_per_second,json=targetReceivedBytesPerSecond" json:"target_received_bytes_per_second,omitempty"`
	// Target packets received per second.
	TargetReceivedPacketsPerSecond int32 `protobuf:"varint,13,opt,name=target_received_packets_per_second,json=targetReceivedPacketsPerSecond" json:"target_received_packets_per_second,omitempty"`
}

func (m *NetworkUtilization) Reset()                    { *m = NetworkUtilization{} }
func (m *NetworkUtilization) String() string            { return proto.CompactTextString(m) }
func (*NetworkUtilization) ProtoMessage()               {}
func (*NetworkUtilization) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{7} }

// Extra network settings. Only applicable for VM runtimes.
type Network struct {
	// List of ports, or port pairs, to forward from the virtual machine to the
	// application container.
	ForwardedPorts []string `protobuf:"bytes,1,rep,name=forwarded_ports,json=forwardedPorts" json:"forwarded_ports,omitempty"`
	// Tag to apply to the VM instance during creation.
	InstanceTag string `protobuf:"bytes,2,opt,name=instance_tag,json=instanceTag" json:"instance_tag,omitempty"`
	// Google Cloud Platform network where the virtual machines are created.
	// Specify the short name, not the resource path.
	//
	// Defaults to `default`.
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
}

func (m *Network) Reset()                    { *m = Network{} }
func (m *Network) String() string            { return proto.CompactTextString(m) }
func (*Network) ProtoMessage()               {}
func (*Network) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{8} }

// Machine resources for a version.
type Resources struct {
	// Number of CPU cores needed.
	Cpu float64 `protobuf:"fixed64,1,opt,name=cpu" json:"cpu,omitempty"`
	// Disk size (GB) needed.
	DiskGb float64 `protobuf:"fixed64,2,opt,name=disk_gb,json=diskGb" json:"disk_gb,omitempty"`
	// Memory (GB) needed.
	MemoryGb float64 `protobuf:"fixed64,3,opt,name=memory_gb,json=memoryGb" json:"memory_gb,omitempty"`
}

func (m *Resources) Reset()                    { *m = Resources{} }
func (m *Resources) String() string            { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()               {}
func (*Resources) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{9} }

func init() {
	proto.RegisterType((*Version)(nil), "google.appengine.v1.Version")
	proto.RegisterType((*AutomaticScaling)(nil), "google.appengine.v1.AutomaticScaling")
	proto.RegisterType((*BasicScaling)(nil), "google.appengine.v1.BasicScaling")
	proto.RegisterType((*ManualScaling)(nil), "google.appengine.v1.ManualScaling")
	proto.RegisterType((*CpuUtilization)(nil), "google.appengine.v1.CpuUtilization")
	proto.RegisterType((*RequestUtilization)(nil), "google.appengine.v1.RequestUtilization")
	proto.RegisterType((*DiskUtilization)(nil), "google.appengine.v1.DiskUtilization")
	proto.RegisterType((*NetworkUtilization)(nil), "google.appengine.v1.NetworkUtilization")
	proto.RegisterType((*Network)(nil), "google.appengine.v1.Network")
	proto.RegisterType((*Resources)(nil), "google.appengine.v1.Resources")
	proto.RegisterEnum("google.appengine.v1.InboundServiceType", InboundServiceType_name, InboundServiceType_value)
	proto.RegisterEnum("google.appengine.v1.ServingStatus", ServingStatus_name, ServingStatus_value)
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/appengine/v1/version.proto", fileDescriptor8)
}

var fileDescriptor8 = []byte{
	// 1784 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x57, 0x5d, 0x73, 0xdb, 0xc6,
	0x15, 0x0d, 0x29, 0x4b, 0x14, 0x2f, 0x3f, 0x44, 0xad, 0xd3, 0x08, 0x96, 0x64, 0x99, 0x66, 0x92,
	0xb1, 0x9a, 0x69, 0xc8, 0x89, 0x3b, 0x93, 0xb6, 0x8e, 0xa7, 0x8e, 0x48, 0xd1, 0x16, 0x5b, 0x7d,
	0x70, 0x00, 0xd1, 0xce, 0x1b, 0x66, 0x09, 0xac, 0xc0, 0xad, 0x80, 0x05, 0xb2, 0x58, 0x50, 0x62,
	0xff, 0x43, 0x1f, 0xdb, 0xe9, 0x8f, 0xe8, 0x63, 0xdf, 0xfa, 0xe7, 0x3a, 0xbb, 0x00, 0x48, 0x90,
	0x44, 0xac, 0x24, 0x6f, 0xd8, 0xbb, 0xe7, 0x9c, 0x3d, 0xb8, 0x7b, 0xf7, 0x2e, 0x00, 0xdf, 0x3b,
	0xbe, 0xef, 0xb8, 0xa4, 0xed, 0xf8, 0x2e, 0x66, 0x4e, 0xdb, 0xe7, 0x4e, 0xc7, 0x21, 0x2c, 0xe0,
	0xbe, 0xf0, 0x3b, 0xf1, 0x14, 0x0e, 0x68, 0xd8, 0xc1, 0x41, 0x40, 0x98, 0x43, 0x19, 0xe9, 0x4c,
	0xbf, 0xe9, 0x4c, 0x09, 0x0f, 0xa9, 0xcf, 0xda, 0x0a, 0x85, 0x1e, 0x27, 0x0a, 0x73, 0x48, 0x7b,
	0xfa, 0xcd, 0xfe, 0xe0, 0xe7, 0xca, 0xd2, 0x4e, 0x48, 0xf8, 0x94, 0x5a, 0xc4, 0xf2, 0xd9, 0x0d,
	0x75, 0x3a, 0x98, 0x31, 0x5f, 0x60, 0x41, 0x7d, 0x16, 0xc6, 0xfa, 0xfb, 0x27, 0xbf, 0xc2, 0x21,
	0x0e, 0x02, 0x73, 0x86, 0x3d, 0x37, 0x91, 0x78, 0xf3, 0x2b, 0x24, 0x6c, 0x12, 0xb8, 0xfe, 0x2c,
	0x11, 0xf8, 0x93, 0x43, 0xc5, 0x24, 0x1a, 0xb7, 0x2d, 0xdf, 0xeb, 0xc4, 0x22, 0x1d, 0x35, 0x31,
	0x8e, 0x6e, 0x3a, 0x81, 0x98, 0x05, 0x24, 0xec, 0xd8, 0x11, 0x57, 0xb6, 0xe7, 0x0f, 0x09, 0xf5,
	0xbb, 0x87, 0xa9, 0x82, 0x7a, 0x24, 0x14, 0xd8, 0x0b, 0x16, 0x4f, 0x31, 0xb9, 0xf5, 0xcf, 0x1a,
	0x94, 0xde, 0xc7, 0xd9, 0x46, 0x08, 0x1e, 0x31, 0xec, 0x11, 0xad, 0xd0, 0x2c, 0x1c, 0x97, 0x75,
	0xf5, 0x8c, 0xea, 0x50, 0xa4, 0xb6, 0x56, 0x54, 0x91, 0x22, 0xb5, 0xd1, 0x35, 0xec, 0xe2, 0x48,
	0xf8, 0x1e, 0x16, 0xd4, 0x32, 0x43, 0x0b, 0xbb, 0x94, 0x39, 0xda, 0x46, 0xb3, 0x70, 0x5c, 0x79,
	0xf9, 0x65, 0x3b, 0x67, 0x9f, 0xda, 0x27, 0x29, 0xda, 0x88, 0xc1, 0x67, 0x9f, 0xe8, 0x0d, 0xbc,
	0x12, 0x43, 0x67, 0x50, 0x1b, 0xe3, 0x30, 0xa3, 0xf8, 0x48, 0x29, 0x3e, 0xcf, 0x55, 0xec, 0x4a,
	0xe4, 0x42, 0xad, 0x3a, 0xce, 0x8c, 0xd1, 0x5f, 0xa1, 0xee, 0x61, 0x16, 0x61, 0x77, 0x2e, 0xb5,
	0xa9, 0xa4, 0x5a, 0xb9, 0x52, 0x17, 0x0a, 0xba, 0xd0, 0xaa, 0x79, 0xd9, 0x00, 0xd2, 0xa1, 0x41,
	0xd9, 0xd8, 0x8f, 0x98, 0x6d, 0x26, 0x35, 0x14, 0x6a, 0x5b, 0xcd, 0x8d, 0xe3, 0xfa, 0xcb, 0x17,
	0xb9, 0x72, 0x83, 0x18, 0x6c, 0xc4, 0xd8, 0xeb, 0x59, 0x40, 0xf4, 0x1d, 0xba, 0x14, 0x0b, 0xd1,
	0x97, 0x50, 0xa7, 0x2c, 0x14, 0x98, 0x59, 0xc4, 0xb4, 0x5c, 0x1c, 0x86, 0x5a, 0x49, 0x25, 0xb7,
	0x96, 0x46, 0x7b, 0x32, 0x88, 0xbe, 0x85, 0x12, 0x23, 0xe2, 0xce, 0xe7, 0xb7, 0xda, 0xb6, 0x7a,
	0x81, 0xc3, 0xdc, 0x15, 0x2f, 0x63, 0x8c, 0x9e, 0x82, 0xd1, 0x6b, 0x28, 0x73, 0x12, 0xfa, 0x11,
	0x97, 0x5e, 0xcb, 0x8a, 0x79, 0x94, 0xcb, 0xd4, 0x53, 0x94, 0xbe, 0x20, 0x20, 0x0d, 0x4a, 0x3c,
	0x62, 0xb2, 0x46, 0x34, 0x50, 0xae, 0xd2, 0x21, 0x3a, 0x02, 0x10, 0x13, 0x4e, 0xb0, 0x1d, 0xe2,
	0x1b, 0xa2, 0x55, 0x9a, 0x85, 0xe3, 0x6d, 0x3d, 0x13, 0x91, 0x75, 0x32, 0xf5, 0xb4, 0xaa, 0x8a,
	0x17, 0xa7, 0x1e, 0x32, 0xa0, 0x36, 0x26, 0x02, 0x9b, 0x21, 0x11, 0x82, 0x32, 0x27, 0xd4, 0x6a,
	0xcd, 0x8d, 0xe3, 0xca, 0xcb, 0x76, 0xae, 0x97, 0xa4, 0x00, 0xdb, 0x5d, 0x22, 0xb0, 0x91, 0x10,
	0xfa, 0x4c, 0xf0, 0x99, 0x5e, 0x1d, 0x67, 0x42, 0xa8, 0x01, 0x1b, 0x84, 0x4d, 0xb5, 0xba, 0xb2,
	0x26, 0x1f, 0xd1, 0x00, 0xea, 0x6a, 0x67, 0x98, 0x63, 0x86, 0x02, 0x8b, 0x28, 0xd4, 0x76, 0x9a,
	0x85, 0xe3, 0xfa, 0x4f, 0x6c, 0xb7, 0x11, 0x43, 0x0d, 0x85, 0xd4, 0x6b, 0x61, 0x76, 0x88, 0x9e,
	0x02, 0x58, 0x9c, 0x60, 0x41, 0x6c, 0x73, 0x3c, 0xd3, 0x1a, 0x6a, 0x8d, 0x72, 0x12, 0xe9, 0xce,
	0xd0, 0x77, 0x50, 0x89, 0x07, 0xa6, 0x4a, 0xcf, 0xae, 0x4a, 0xed, 0x7e, 0xba, 0x4c, 0x7a, 0xe0,
	0xda, 0xd7, 0xe9, 0xf9, 0xd2, 0x13, 0x35, 0x19, 0x40, 0xc7, 0xd0, 0xb0, 0x69, 0x78, 0x6b, 0x46,
	0x21, 0x76, 0x88, 0x39, 0x9e, 0x09, 0x12, 0x6a, 0xa8, 0x59, 0x38, 0xde, 0xd0, 0xeb, 0x32, 0x3e,
	0x92, 0xe1, 0xae, 0x8c, 0xa2, 0x3f, 0xc0, 0xf6, 0x04, 0x33, 0xdb, 0x25, 0x3c, 0xd4, 0x6c, 0x95,
	0xb2, 0x83, 0xdc, 0x57, 0x19, 0x71, 0xf7, 0x02, 0x07, 0xfa, 0x1c, 0x8c, 0xce, 0xa0, 0x4e, 0x38,
	0xf7, 0xb9, 0x39, 0xa7, 0x13, 0x45, 0xcf, 0x3f, 0x43, 0x7d, 0x09, 0x3d, 0x8b, 0x91, 0x7a, 0x8d,
	0x64, 0x46, 0x21, 0x7a, 0x05, 0x65, 0x97, 0x8e, 0x39, 0xe6, 0x94, 0x84, 0xda, 0x8d, 0x12, 0xc9,
	0x2f, 0xbe, 0x73, 0x85, 0x9a, 0xe9, 0x0b, 0x38, 0x3a, 0x05, 0xc0, 0x01, 0x35, 0xe3, 0x56, 0xab,
	0x39, 0x1f, 0xeb, 0x0b, 0x01, 0xed, 0x29, 0x54, 0xea, 0xa2, 0x8c, 0xd3, 0x88, 0x2c, 0x1e, 0xc2,
	0xa6, 0xe6, 0x14, 0x73, 0x8a, 0xc7, 0x2e, 0x09, 0xb5, 0xc9, 0xcf, 0x28, 0x9e, 0x3e, 0x9b, 0xbe,
	0x4f, 0x09, 0x49, 0xf1, 0x90, 0x4c, 0x08, 0x9d, 0x01, 0xb2, 0xc9, 0x0d, 0x8e, 0x5c, 0x61, 0x92,
	0xfb, 0x80, 0xc6, 0x2d, 0x54, 0xa3, 0xca, 0xe2, 0x93, 0xb5, 0x7d, 0x3c, 0x4d, 0x7a, 0xac, 0xbe,
	0x9b, 0x90, 0xfa, 0x73, 0x0e, 0xea, 0x41, 0x75, 0x42, 0xb0, 0x2b, 0x26, 0xa6, 0x35, 0x21, 0xd6,
	0xad, 0xf6, 0x37, 0xa5, 0xd1, 0xcc, 0x75, 0x77, 0xa6, 0x80, 0x3d, 0x89, 0xd3, 0x2b, 0x93, 0xc5,
	0x00, 0xb5, 0xe1, 0x31, 0xf3, 0xc7, 0x11, 0x75, 0x6d, 0xf3, 0x86, 0xba, 0x24, 0x34, 0x39, 0x71,
	0xc8, 0xbd, 0x76, 0xab, 0xea, 0x6e, 0x37, 0x99, 0x7a, 0x2b, 0x67, 0x74, 0x39, 0x81, 0xde, 0x00,
	0xc4, 0x17, 0x86, 0x47, 0x98, 0xd0, 0x5c, 0xb5, 0xe4, 0xb3, 0xdc, 0x25, 0x4f, 0xe7, 0x30, 0x3d,
	0x43, 0x41, 0xcf, 0xa0, 0x92, 0x5c, 0xab, 0x66, 0xc4, 0x5d, 0xcd, 0x53, 0x0b, 0x41, 0x12, 0x1a,
	0x71, 0x77, 0xff, 0x0d, 0xec, 0xae, 0x1d, 0x40, 0x79, 0xe4, 0x6e, 0xc9, 0x2c, 0xb9, 0x12, 0xe4,
	0x23, 0xfa, 0x14, 0x36, 0xa7, 0xd8, 0x8d, 0x48, 0x72, 0x29, 0xc4, 0x83, 0x57, 0xc5, 0x3f, 0x16,
	0xa4, 0xc0, 0xda, 0x26, 0xfc, 0x12, 0x81, 0x6e, 0x19, 0x4a, 0x49, 0xd7, 0x6e, 0xfd, 0x77, 0x0b,
	0x1a, 0xab, 0x57, 0x07, 0xea, 0x41, 0xc3, 0xf2, 0x7d, 0xd7, 0xb4, 0xfd, 0x3b, 0x66, 0x06, 0x84,
	0x53, 0xdf, 0x56, 0xc2, 0x1f, 0xdd, 0xc0, 0xba, 0xa4, 0x9c, 0xfa, 0x77, 0x6c, 0xa8, 0x08, 0xe8,
	0x1c, 0x76, 0xac, 0x20, 0x32, 0x23, 0x41, 0x5d, 0xfa, 0xf7, 0xb8, 0x08, 0x8a, 0x4a, 0xe3, 0xf3,
	0xdc, 0x6c, 0xf6, 0x82, 0x68, 0xb4, 0x80, 0xea, 0x75, 0x6b, 0x69, 0x8c, 0xbe, 0x85, 0x3d, 0x0f,
	0xdf, 0xcb, 0x82, 0xb7, 0x22, 0xce, 0x09, 0x13, 0x26, 0x27, 0x3f, 0x46, 0x24, 0x14, 0xa1, 0xba,
	0x15, 0x37, 0xf5, 0xdf, 0x78, 0xf8, 0xbe, 0x37, 0x9f, 0xd5, 0x93, 0x49, 0xf4, 0x3b, 0x40, 0x92,
	0x47, 0x6d, 0x97, 0x98, 0x69, 0xe7, 0x0f, 0xd5, 0xb5, 0xb7, 0xa9, 0x37, 0x3c, 0x7c, 0x3f, 0xb0,
	0x5d, 0x32, 0x48, 0xe3, 0xb2, 0x58, 0x24, 0x5a, 0xf8, 0x02, 0xbb, 0x19, 0xf8, 0xa6, 0x82, 0xef,
	0x7a, 0xf8, 0xfe, 0x5a, 0xce, 0x2c, 0xf0, 0x83, 0x18, 0x1f, 0x10, 0x66, 0xcb, 0xd6, 0xe8, 0x62,
	0x41, 0x98, 0x35, 0xd3, 0xb6, 0x1e, 0x2c, 0x76, 0x0f, 0xdf, 0x0f, 0x63, 0xd2, 0x79, 0xcc, 0x51,
	0x46, 0x29, 0x5b, 0x35, 0x5a, 0x4a, 0x8c, 0x52, 0xb6, 0x6e, 0x94, 0xb2, 0x35, 0xa3, 0xdb, 0x89,
	0x51, 0xca, 0x72, 0x8c, 0x52, 0xb6, 0x66, 0xb4, 0xfc, 0xb0, 0x51, 0xca, 0x56, 0x8c, 0xfe, 0x00,
	0x8f, 0x93, 0xd4, 0x2f, 0xed, 0x2d, 0x28, 0xa9, 0x17, 0x3f, 0x71, 0x07, 0x2a, 0x7c, 0x76, 0x7f,
	0x11, 0x5f, 0x8b, 0xa1, 0xab, 0xb4, 0x7b, 0x67, 0x64, 0x2b, 0x4a, 0xf6, 0x8b, 0xfc, 0x03, 0x28,
	0x5b, 0x7a, 0x46, 0x73, 0xc7, 0x5e, 0x0e, 0x48, 0xab, 0xc9, 0x7d, 0xbd, 0xa4, 0x59, 0xfd, 0x88,
	0xd5, 0xe4, 0xa2, 0x5f, 0xb2, 0xca, 0xd6, 0x62, 0xad, 0x1f, 0xa1, 0x9a, 0xfd, 0x3c, 0x42, 0xaf,
	0xa1, 0xaa, 0x76, 0x4e, 0xde, 0x59, 0x7e, 0x24, 0x1e, 0x3e, 0x2d, 0x15, 0x09, 0xbf, 0x8e, 0xd1,
	0xe8, 0x73, 0xa8, 0xa9, 0x22, 0x9d, 0xef, 0x63, 0x51, 0xed, 0x63, 0x55, 0xd6, 0x67, 0x1a, 0x6b,
	0x7d, 0x0d, 0xb5, 0xa5, 0xcf, 0x28, 0x74, 0x08, 0xe5, 0x05, 0xa3, 0xa0, 0x18, 0x8b, 0x40, 0xeb,
	0x5f, 0x05, 0xa8, 0x2f, 0x9f, 0x29, 0x34, 0x82, 0x27, 0xd8, 0x71, 0x38, 0x71, 0xd4, 0xd0, 0xbc,
	0xa3, 0xcc, 0xf6, 0xef, 0x4c, 0x97, 0x30, 0x47, 0x4c, 0x1e, 0x76, 0xbc, 0x97, 0xe1, 0x7e, 0x50,
	0xd4, 0x73, 0xc5, 0x44, 0x5f, 0x03, 0x12, 0x98, 0x3b, 0x44, 0xac, 0x9d, 0xf5, 0x82, 0xbe, 0x1b,
	0xcf, 0x64, 0x53, 0xf7, 0xef, 0x02, 0xa0, 0xf5, 0x82, 0x40, 0xa7, 0xf0, 0x2c, 0x51, 0x49, 0xab,
	0xcb, 0xf2, 0x23, 0x26, 0x64, 0xfb, 0x31, 0x43, 0xf9, 0x4f, 0x61, 0x27, 0xef, 0x78, 0x10, 0xc3,
	0x12, 0x89, 0x9e, 0x04, 0x0d, 0x09, 0x37, 0x14, 0x04, 0xbd, 0x86, 0xfd, 0x44, 0x25, 0xaf, 0x53,
	0xc4, 0x69, 0xd5, 0x62, 0xc4, 0x7a, 0xb3, 0x68, 0xfd, 0xa3, 0x08, 0x3b, 0x2b, 0x45, 0x85, 0xbe,
	0x87, 0xa7, 0x89, 0xe2, 0x1d, 0xa7, 0x22, 0xf9, 0xa8, 0xc8, 0xba, 0xaa, 0x2b, 0xd1, 0x27, 0x31,
	0xe8, 0x83, 0xc4, 0xa8, 0x2f, 0x8c, 0xac, 0xa7, 0x83, 0x25, 0x05, 0x3f, 0x58, 0xe2, 0xef, 0x28,
	0xfe, 0x5e, 0x86, 0x7f, 0x15, 0x64, 0xd8, 0x7f, 0x86, 0xc3, 0x79, 0x5e, 0xb0, 0xbd, 0xbe, 0x7c,
	0x23, 0xfb, 0x4e, 0x3a, 0xc1, 0xf6, 0xca, 0xea, 0xaf, 0xe6, 0x19, 0x51, 0xfc, 0x95, 0xc5, 0x77,
	0x15, 0xfb, 0xb3, 0x05, 0x3b, 0xbb, 0x76, 0xeb, 0x3f, 0x45, 0x40, 0xeb, 0x07, 0x22, 0x63, 0x29,
	0x94, 0xe9, 0x5d, 0xb3, 0x54, 0xc8, 0x5a, 0x32, 0x08, 0x13, 0x2b, 0x96, 0xba, 0x70, 0x94, 0xe5,
	0x07, 0xd8, 0xba, 0x25, 0x62, 0x49, 0xa1, 0xa2, 0x14, 0xf6, 0x17, 0x0a, 0xc3, 0x18, 0xb3, 0xd0,
	0x78, 0x0b, 0xcd, 0xf9, 0x6b, 0x59, 0x84, 0x4e, 0x49, 0x4e, 0x6a, 0xaa, 0x4a, 0xe5, 0x30, 0x7d,
	0xb9, 0x18, 0xb6, 0xe2, 0xe5, 0x2f, 0xd0, 0x5a, 0xd5, 0xc9, 0xf1, 0x53, 0x53, 0x4a, 0x47, 0xcb,
	0x4a, 0xab, 0x9e, 0x5a, 0x14, 0x4a, 0x49, 0xb6, 0xd0, 0x0b, 0xd8, 0xb9, 0xf1, 0xf9, 0x1d, 0xe6,
	0xb6, 0x14, 0xf4, 0xb9, 0x90, 0x27, 0x74, 0xe3, 0xb8, 0xac, 0xd7, 0xe7, 0xe1, 0xa1, 0x8c, 0xa2,
	0xe7, 0x50, 0x9d, 0xff, 0xa6, 0x08, 0xec, 0x24, 0x77, 0x75, 0x25, 0x8d, 0x5d, 0x63, 0x67, 0xfe,
	0xbb, 0xb8, 0xb1, 0xf8, 0x5d, 0x6c, 0x19, 0x50, 0x9e, 0xff, 0x58, 0xc8, 0xab, 0xdf, 0x0a, 0x22,
	0x95, 0xf6, 0x82, 0x2e, 0x1f, 0xd1, 0x1e, 0x94, 0x54, 0x27, 0x75, 0xc6, 0xc9, 0x39, 0xdc, 0x92,
	0xc3, 0x77, 0x63, 0x74, 0x00, 0x65, 0x8f, 0x78, 0x3e, 0x9f, 0xc9, 0xa9, 0x0d, 0x35, 0xb5, 0x1d,
	0x07, 0xde, 0x8d, 0xbf, 0xfa, 0x5f, 0x11, 0xd0, 0xfa, 0xaf, 0x15, 0x7a, 0x06, 0x07, 0x83, 0xcb,
	0xee, 0xd5, 0xe8, 0xf2, 0xd4, 0x34, 0xfa, 0xfa, 0xfb, 0x41, 0xaf, 0x6f, 0x8e, 0x2e, 0x8d, 0x61,
	0xbf, 0x37, 0x78, 0x3b, 0xe8, 0x9f, 0x36, 0x3e, 0x41, 0x1a, 0x7c, 0xba, 0x0a, 0xb8, 0x38, 0x19,
	0x9c, 0x37, 0x0a, 0x79, 0x54, 0x39, 0x63, 0xca, 0x50, 0xaf, 0xdf, 0x28, 0xa2, 0x23, 0xd8, 0x5f,
	0x05, 0xfc, 0x70, 0x31, 0x1c, 0x9a, 0x7d, 0x5d, 0xbf, 0xd2, 0x1b, 0x1b, 0xa8, 0x09, 0x87, 0xb9,
	0xf3, 0x17, 0x7d, 0xc3, 0x38, 0x79, 0xd7, 0x6f, 0x3c, 0x42, 0x2d, 0x38, 0xca, 0x45, 0x18, 0xa3,
	0xae, 0xd1, 0xd3, 0x07, 0xdd, 0x7e, 0x63, 0x13, 0x3d, 0x87, 0xa7, 0xb9, 0x98, 0xa1, 0xde, 0x37,
	0xfa, 0xd2, 0xc8, 0x16, 0xfa, 0x02, 0x9a, 0xab, 0x90, 0xde, 0xd9, 0xc9, 0xe5, 0x65, 0xff, 0x7c,
	0x81, 0x2a, 0xa1, 0x7d, 0xf8, 0x6c, 0x15, 0xf5, 0xe1, 0x44, 0xbf, 0x18, 0x0d, 0x1b, 0xe5, 0xaf,
	0x06, 0x50, 0x5b, 0xfa, 0xef, 0x91, 0xef, 0xa6, 0x40, 0x97, 0xef, 0x4c, 0xe3, 0xfa, 0xe4, 0x7a,
	0x64, 0xac, 0xa4, 0xad, 0x02, 0xa5, 0x64, 0xbe, 0x51, 0x50, 0x83, 0xeb, 0xab, 0xe1, 0xb0, 0x7f,
	0xda, 0x28, 0x76, 0x7f, 0x0b, 0x7b, 0x96, 0xef, 0xe5, 0xdd, 0x4f, 0xdd, 0x6a, 0xf2, 0x19, 0x3e,
	0x94, 0xfd, 0x79, 0x58, 0x18, 0x6f, 0xa9, 0x46, 0xfd, 0xfb, 0xff, 0x07, 0x00, 0x00, 0xff, 0xff,
	0xfa, 0x40, 0xf2, 0x62, 0xfe, 0x11, 0x00, 0x00,
}
