// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/cloud/vision/v1/image_annotator.proto
// DO NOT EDIT!

package v1 // import "google.golang.org/genproto/googleapis/cloud/vision/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"
import google_type "google.golang.org/genproto/googleapis/type/color"
import google_type1 "google.golang.org/genproto/googleapis/type/latlng"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A bucketized representation of likelihood meant to give our clients highly
// stable results across model upgrades.
type Likelihood int32

const (
	// Unknown likelihood.
	Likelihood_UNKNOWN Likelihood = 0
	// The image very unlikely belongs to the vertical specified.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// The image unlikely belongs to the vertical specified.
	Likelihood_UNLIKELY Likelihood = 2
	// The image possibly belongs to the vertical specified.
	Likelihood_POSSIBLE Likelihood = 3
	// The image likely belongs to the vertical specified.
	Likelihood_LIKELY Likelihood = 4
	// The image very likely belongs to the vertical specified.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "UNKNOWN",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"UNKNOWN":       0,
	"VERY_UNLIKELY": 1,
	"UNLIKELY":      2,
	"POSSIBLE":      3,
	"LIKELY":        4,
	"VERY_LIKELY":   5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

// Type of image feature.
type Feature_Type int32

const (
	// Unspecified feature type.
	Feature_TYPE_UNSPECIFIED Feature_Type = 0
	// Run face detection.
	Feature_FACE_DETECTION Feature_Type = 1
	// Run landmark detection.
	Feature_LANDMARK_DETECTION Feature_Type = 2
	// Run logo detection.
	Feature_LOGO_DETECTION Feature_Type = 3
	// Run label detection.
	Feature_LABEL_DETECTION Feature_Type = 4
	// Run OCR.
	Feature_TEXT_DETECTION Feature_Type = 5
	// Run various computer vision models to compute image safe-search properties.
	Feature_SAFE_SEARCH_DETECTION Feature_Type = 6
	// Compute a set of properties about the image (such as the image's dominant colors).
	Feature_IMAGE_PROPERTIES Feature_Type = 7
)

var Feature_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "FACE_DETECTION",
	2: "LANDMARK_DETECTION",
	3: "LOGO_DETECTION",
	4: "LABEL_DETECTION",
	5: "TEXT_DETECTION",
	6: "SAFE_SEARCH_DETECTION",
	7: "IMAGE_PROPERTIES",
}
var Feature_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":      0,
	"FACE_DETECTION":        1,
	"LANDMARK_DETECTION":    2,
	"LOGO_DETECTION":        3,
	"LABEL_DETECTION":       4,
	"TEXT_DETECTION":        5,
	"SAFE_SEARCH_DETECTION": 6,
	"IMAGE_PROPERTIES":      7,
}

func (x Feature_Type) String() string {
	return proto.EnumName(Feature_Type_name, int32(x))
}
func (Feature_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0, 0} }

// Face landmark (feature) type.
// Left and right are defined from the vantage of the viewer of the image,
// without considering mirror projections typical of photos. So, LEFT_EYE,
// typically is the person's right eye.
type FaceAnnotation_Landmark_Type int32

const (
	// Unknown face landmark detected. Should not be filled.
	FaceAnnotation_Landmark_UNKNOWN_LANDMARK FaceAnnotation_Landmark_Type = 0
	// Left eye.
	FaceAnnotation_Landmark_LEFT_EYE FaceAnnotation_Landmark_Type = 1
	// Right eye.
	FaceAnnotation_Landmark_RIGHT_EYE FaceAnnotation_Landmark_Type = 2
	// Left of left eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 3
	// Right of left eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 4
	// Left of right eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 5
	// Right of right eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 6
	// Midpoint between eyes.
	FaceAnnotation_Landmark_MIDPOINT_BETWEEN_EYES FaceAnnotation_Landmark_Type = 7
	// Nose tip.
	FaceAnnotation_Landmark_NOSE_TIP FaceAnnotation_Landmark_Type = 8
	// Upper lip.
	FaceAnnotation_Landmark_UPPER_LIP FaceAnnotation_Landmark_Type = 9
	// Lower lip.
	FaceAnnotation_Landmark_LOWER_LIP FaceAnnotation_Landmark_Type = 10
	// Mouth left.
	FaceAnnotation_Landmark_MOUTH_LEFT FaceAnnotation_Landmark_Type = 11
	// Mouth right.
	FaceAnnotation_Landmark_MOUTH_RIGHT FaceAnnotation_Landmark_Type = 12
	// Mouth center.
	FaceAnnotation_Landmark_MOUTH_CENTER FaceAnnotation_Landmark_Type = 13
	// Nose, bottom right.
	FaceAnnotation_Landmark_NOSE_BOTTOM_RIGHT FaceAnnotation_Landmark_Type = 14
	// Nose, bottom left.
	FaceAnnotation_Landmark_NOSE_BOTTOM_LEFT FaceAnnotation_Landmark_Type = 15
	// Nose, bottom center.
	FaceAnnotation_Landmark_NOSE_BOTTOM_CENTER FaceAnnotation_Landmark_Type = 16
	// Left eye, top boundary.
	FaceAnnotation_Landmark_LEFT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 17
	// Left eye, right corner.
	FaceAnnotation_Landmark_LEFT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 18
	// Left eye, bottom boundary.
	FaceAnnotation_Landmark_LEFT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 19
	// Left eye, left corner.
	FaceAnnotation_Landmark_LEFT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 20
	// Right eye, top boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 21
	// Right eye, right corner.
	FaceAnnotation_Landmark_RIGHT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 22
	// Right eye, bottom boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 23
	// Right eye, left corner.
	FaceAnnotation_Landmark_RIGHT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 24
	// Left eyebrow, upper midpoint.
	FaceAnnotation_Landmark_LEFT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 25
	// Right eyebrow, upper midpoint.
	FaceAnnotation_Landmark_RIGHT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 26
	// Left ear tragion.
	FaceAnnotation_Landmark_LEFT_EAR_TRAGION FaceAnnotation_Landmark_Type = 27
	// Right ear tragion.
	FaceAnnotation_Landmark_RIGHT_EAR_TRAGION FaceAnnotation_Landmark_Type = 28
	// Left eye pupil.
	FaceAnnotation_Landmark_LEFT_EYE_PUPIL FaceAnnotation_Landmark_Type = 29
	// Right eye pupil.
	FaceAnnotation_Landmark_RIGHT_EYE_PUPIL FaceAnnotation_Landmark_Type = 30
	// Forehead glabella.
	FaceAnnotation_Landmark_FOREHEAD_GLABELLA FaceAnnotation_Landmark_Type = 31
	// Chin gnathion.
	FaceAnnotation_Landmark_CHIN_GNATHION FaceAnnotation_Landmark_Type = 32
	// Chin left gonion.
	FaceAnnotation_Landmark_CHIN_LEFT_GONION FaceAnnotation_Landmark_Type = 33
	// Chin right gonion.
	FaceAnnotation_Landmark_CHIN_RIGHT_GONION FaceAnnotation_Landmark_Type = 34
)

var FaceAnnotation_Landmark_Type_name = map[int32]string{
	0:  "UNKNOWN_LANDMARK",
	1:  "LEFT_EYE",
	2:  "RIGHT_EYE",
	3:  "LEFT_OF_LEFT_EYEBROW",
	4:  "RIGHT_OF_LEFT_EYEBROW",
	5:  "LEFT_OF_RIGHT_EYEBROW",
	6:  "RIGHT_OF_RIGHT_EYEBROW",
	7:  "MIDPOINT_BETWEEN_EYES",
	8:  "NOSE_TIP",
	9:  "UPPER_LIP",
	10: "LOWER_LIP",
	11: "MOUTH_LEFT",
	12: "MOUTH_RIGHT",
	13: "MOUTH_CENTER",
	14: "NOSE_BOTTOM_RIGHT",
	15: "NOSE_BOTTOM_LEFT",
	16: "NOSE_BOTTOM_CENTER",
	17: "LEFT_EYE_TOP_BOUNDARY",
	18: "LEFT_EYE_RIGHT_CORNER",
	19: "LEFT_EYE_BOTTOM_BOUNDARY",
	20: "LEFT_EYE_LEFT_CORNER",
	21: "RIGHT_EYE_TOP_BOUNDARY",
	22: "RIGHT_EYE_RIGHT_CORNER",
	23: "RIGHT_EYE_BOTTOM_BOUNDARY",
	24: "RIGHT_EYE_LEFT_CORNER",
	25: "LEFT_EYEBROW_UPPER_MIDPOINT",
	26: "RIGHT_EYEBROW_UPPER_MIDPOINT",
	27: "LEFT_EAR_TRAGION",
	28: "RIGHT_EAR_TRAGION",
	29: "LEFT_EYE_PUPIL",
	30: "RIGHT_EYE_PUPIL",
	31: "FOREHEAD_GLABELLA",
	32: "CHIN_GNATHION",
	33: "CHIN_LEFT_GONION",
	34: "CHIN_RIGHT_GONION",
}
var FaceAnnotation_Landmark_Type_value = map[string]int32{
	"UNKNOWN_LANDMARK":             0,
	"LEFT_EYE":                     1,
	"RIGHT_EYE":                    2,
	"LEFT_OF_LEFT_EYEBROW":         3,
	"RIGHT_OF_LEFT_EYEBROW":        4,
	"LEFT_OF_RIGHT_EYEBROW":        5,
	"RIGHT_OF_RIGHT_EYEBROW":       6,
	"MIDPOINT_BETWEEN_EYES":        7,
	"NOSE_TIP":                     8,
	"UPPER_LIP":                    9,
	"LOWER_LIP":                    10,
	"MOUTH_LEFT":                   11,
	"MOUTH_RIGHT":                  12,
	"MOUTH_CENTER":                 13,
	"NOSE_BOTTOM_RIGHT":            14,
	"NOSE_BOTTOM_LEFT":             15,
	"NOSE_BOTTOM_CENTER":           16,
	"LEFT_EYE_TOP_BOUNDARY":        17,
	"LEFT_EYE_RIGHT_CORNER":        18,
	"LEFT_EYE_BOTTOM_BOUNDARY":     19,
	"LEFT_EYE_LEFT_CORNER":         20,
	"RIGHT_EYE_TOP_BOUNDARY":       21,
	"RIGHT_EYE_RIGHT_CORNER":       22,
	"RIGHT_EYE_BOTTOM_BOUNDARY":    23,
	"RIGHT_EYE_LEFT_CORNER":        24,
	"LEFT_EYEBROW_UPPER_MIDPOINT":  25,
	"RIGHT_EYEBROW_UPPER_MIDPOINT": 26,
	"LEFT_EAR_TRAGION":             27,
	"RIGHT_EAR_TRAGION":            28,
	"LEFT_EYE_PUPIL":               29,
	"RIGHT_EYE_PUPIL":              30,
	"FOREHEAD_GLABELLA":            31,
	"CHIN_GNATHION":                32,
	"CHIN_LEFT_GONION":             33,
	"CHIN_RIGHT_GONION":            34,
}

func (x FaceAnnotation_Landmark_Type) String() string {
	return proto.EnumName(FaceAnnotation_Landmark_Type_name, int32(x))
}
func (FaceAnnotation_Landmark_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{3, 0, 0}
}

// The <em>Feature</em> indicates what type of image detection task to perform.
// Users describe the type of Google Cloud Vision API tasks to perform over
// images by using <em>Feature</em>s. Features encode the Cloud Vision API
// vertical to operate on and the number of top-scoring results to return.
type Feature struct {
	// The feature type.
	Type Feature_Type `protobuf:"varint,1,opt,name=type,enum=google.cloud.vision.v1.Feature_Type" json:"type,omitempty"`
	// Maximum number of results of this type.
	MaxResults int32 `protobuf:"varint,2,opt,name=max_results,json=maxResults" json:"max_results,omitempty"`
}

func (m *Feature) Reset()                    { *m = Feature{} }
func (m *Feature) String() string            { return proto.CompactTextString(m) }
func (*Feature) ProtoMessage()               {}
func (*Feature) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

// External image source (Google Cloud Storage image location).
type ImageSource struct {
	// Google Cloud Storage image URI. It must be in the following form:
	// `gs://bucket_name/object_name`. For more
	// details, please see: https://cloud.google.com/storage/docs/reference-uris.
	// NOTE: Cloud Storage object versioning is not supported!
	GcsImageUri string `protobuf:"bytes,1,opt,name=gcs_image_uri,json=gcsImageUri" json:"gcs_image_uri,omitempty"`
}

func (m *ImageSource) Reset()                    { *m = ImageSource{} }
func (m *ImageSource) String() string            { return proto.CompactTextString(m) }
func (*ImageSource) ProtoMessage()               {}
func (*ImageSource) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

// Client image to perform Google Cloud Vision API tasks over.
type Image struct {
	// Image content, represented as a stream of bytes.
	// Note: as with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Google Cloud Storage image location. If both 'content' and 'source'
	// are filled for an image, 'content' takes precedence and it will be
	// used for performing the image annotation request.
	Source *ImageSource `protobuf:"bytes,2,opt,name=source" json:"source,omitempty"`
}

func (m *Image) Reset()                    { *m = Image{} }
func (m *Image) String() string            { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()               {}
func (*Image) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *Image) GetSource() *ImageSource {
	if m != nil {
		return m.Source
	}
	return nil
}

// A face annotation object contains the results of face detection.
type FaceAnnotation struct {
	// The bounding polygon around the face. The coordinates of the bounding box
	// are in the original image's scale, as returned in ImageParams.
	// The bounding box is computed to "frame" the face in accordance with human
	// expectations. It is based on the landmarker results.
	// Note that one or more x and/or y coordinates may not be generated in the
	// BoundingPoly (the polygon will be unbounded) if only a partial face appears in
	// the image to be annotated.
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly" json:"bounding_poly,omitempty"`
	// This bounding polygon is tighter than the previous
	// <code>boundingPoly</code>, and
	// encloses only the skin part of the face. Typically, it is used to
	// eliminate the face from any image analysis that detects the
	// "amount of skin" visible in an image. It is not based on the
	// landmarker results, only on the initial face detection, hence
	// the <code>fd</code> (face detection) prefix.
	FdBoundingPoly *BoundingPoly `protobuf:"bytes,2,opt,name=fd_bounding_poly,json=fdBoundingPoly" json:"fd_bounding_poly,omitempty"`
	// Detected face landmarks.
	Landmarks []*FaceAnnotation_Landmark `protobuf:"bytes,3,rep,name=landmarks" json:"landmarks,omitempty"`
	// Roll angle. Indicates the amount of clockwise/anti-clockwise rotation of
	// the
	// face relative to the image vertical, about the axis perpendicular to the
	// face. Range [-180,180].
	RollAngle float32 `protobuf:"fixed32,4,opt,name=roll_angle,json=rollAngle" json:"roll_angle,omitempty"`
	// Yaw angle. Indicates the leftward/rightward angle that the face is
	// pointing, relative to the vertical plane perpendicular to the image. Range
	// [-180,180].
	PanAngle float32 `protobuf:"fixed32,5,opt,name=pan_angle,json=panAngle" json:"pan_angle,omitempty"`
	// Pitch angle. Indicates the upwards/downwards angle that the face is
	// pointing
	// relative to the image's horizontal plane. Range [-180,180].
	TiltAngle float32 `protobuf:"fixed32,6,opt,name=tilt_angle,json=tiltAngle" json:"tilt_angle,omitempty"`
	// Detection confidence. Range [0, 1].
	DetectionConfidence float32 `protobuf:"fixed32,7,opt,name=detection_confidence,json=detectionConfidence" json:"detection_confidence,omitempty"`
	// Face landmarking confidence. Range [0, 1].
	LandmarkingConfidence float32 `protobuf:"fixed32,8,opt,name=landmarking_confidence,json=landmarkingConfidence" json:"landmarking_confidence,omitempty"`
	// Joy likelihood.
	JoyLikelihood Likelihood `protobuf:"varint,9,opt,name=joy_likelihood,json=joyLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"joy_likelihood,omitempty"`
	// Sorrow likelihood.
	SorrowLikelihood Likelihood `protobuf:"varint,10,opt,name=sorrow_likelihood,json=sorrowLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"sorrow_likelihood,omitempty"`
	// Anger likelihood.
	AngerLikelihood Likelihood `protobuf:"varint,11,opt,name=anger_likelihood,json=angerLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"anger_likelihood,omitempty"`
	// Surprise likelihood.
	SurpriseLikelihood Likelihood `protobuf:"varint,12,opt,name=surprise_likelihood,json=surpriseLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"surprise_likelihood,omitempty"`
	// Under-exposed likelihood.
	UnderExposedLikelihood Likelihood `protobuf:"varint,13,opt,name=under_exposed_likelihood,json=underExposedLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"under_exposed_likelihood,omitempty"`
	// Blurred likelihood.
	BlurredLikelihood Likelihood `protobuf:"varint,14,opt,name=blurred_likelihood,json=blurredLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"blurred_likelihood,omitempty"`
	// Headwear likelihood.
	HeadwearLikelihood Likelihood `protobuf:"varint,15,opt,name=headwear_likelihood,json=headwearLikelihood,enum=google.cloud.vision.v1.Likelihood" json:"headwear_likelihood,omitempty"`
}

func (m *FaceAnnotation) Reset()                    { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string            { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()               {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *FaceAnnotation) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *FaceAnnotation) GetFdBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.FdBoundingPoly
	}
	return nil
}

func (m *FaceAnnotation) GetLandmarks() []*FaceAnnotation_Landmark {
	if m != nil {
		return m.Landmarks
	}
	return nil
}

// A face-specific landmark (for example, a face feature).
// Landmark positions may fall outside the bounds of the image
// when the face is near one or more edges of the image.
// Therefore it is NOT guaranteed that 0 <= x < width or 0 <= y < height.
type FaceAnnotation_Landmark struct {
	// Face landmark type.
	Type FaceAnnotation_Landmark_Type `protobuf:"varint,3,opt,name=type,enum=google.cloud.vision.v1.FaceAnnotation_Landmark_Type" json:"type,omitempty"`
	// Face landmark position.
	Position *Position `protobuf:"bytes,4,opt,name=position" json:"position,omitempty"`
}

func (m *FaceAnnotation_Landmark) Reset()                    { *m = FaceAnnotation_Landmark{} }
func (m *FaceAnnotation_Landmark) String() string            { return proto.CompactTextString(m) }
func (*FaceAnnotation_Landmark) ProtoMessage()               {}
func (*FaceAnnotation_Landmark) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3, 0} }

func (m *FaceAnnotation_Landmark) GetPosition() *Position {
	if m != nil {
		return m.Position
	}
	return nil
}

// Detected entity location information.
type LocationInfo struct {
	// Lat - long location coordinates.
	LatLng *google_type1.LatLng `protobuf:"bytes,1,opt,name=lat_lng,json=latLng" json:"lat_lng,omitempty"`
}

func (m *LocationInfo) Reset()                    { *m = LocationInfo{} }
func (m *LocationInfo) String() string            { return proto.CompactTextString(m) }
func (*LocationInfo) ProtoMessage()               {}
func (*LocationInfo) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *LocationInfo) GetLatLng() *google_type1.LatLng {
	if m != nil {
		return m.LatLng
	}
	return nil
}

// Arbitrary name/value pair.
type Property struct {
	// Name of the property.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Value of the property.
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *Property) Reset()                    { *m = Property{} }
func (m *Property) String() string            { return proto.CompactTextString(m) }
func (*Property) ProtoMessage()               {}
func (*Property) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

// Set of detected entity features.
type EntityAnnotation struct {
	// Opaque entity ID. Some IDs might be available in Knowledge Graph(KG).
	// For more details on KG please see:
	// https://developers.google.com/knowledge-graph/
	Mid string `protobuf:"bytes,1,opt,name=mid" json:"mid,omitempty"`
	// The language code for the locale in which the entity textual
	// <code>description</code> (next field) is expressed.
	Locale string `protobuf:"bytes,2,opt,name=locale" json:"locale,omitempty"`
	// Entity textual description, expressed in its <code>locale</code> language.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// Overall score of the result. Range [0, 1].
	Score float32 `protobuf:"fixed32,4,opt,name=score" json:"score,omitempty"`
	// The accuracy of the entity detection in an image.
	// For example, for an image containing 'Eiffel Tower,' this field represents
	// the confidence that there is a tower in the query image. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,5,opt,name=confidence" json:"confidence,omitempty"`
	// The relevancy of the ICA (Image Content Annotation) label to the
	// image. For example, the relevancy of 'tower' to an image containing
	// 'Eiffel Tower' is likely higher than an image containing a distant towering
	// building, though the confidence that there is a tower may be the same.
	// Range [0, 1].
	Topicality float32 `protobuf:"fixed32,6,opt,name=topicality" json:"topicality,omitempty"`
	// Image region to which this entity belongs. Not filled currently
	// for `LABEL_DETECTION` features. For `TEXT_DETECTION` (OCR), `boundingPoly`s
	// are produced for the entire text detected in an image region, followed by
	// `boundingPoly`s for each word within the detected text.
	BoundingPoly *BoundingPoly `protobuf:"bytes,7,opt,name=bounding_poly,json=boundingPoly" json:"bounding_poly,omitempty"`
	// The location information for the detected entity. Multiple
	// <code>LocationInfo</code> elements can be present since one location may
	// indicate the location of the scene in the query image, and another the
	// location of the place where the query image was taken. Location information
	// is usually present for landmarks.
	Locations []*LocationInfo `protobuf:"bytes,8,rep,name=locations" json:"locations,omitempty"`
	// Some entities can have additional optional <code>Property</code> fields.
	// For example a different kind of score or string that qualifies the entity.
	Properties []*Property `protobuf:"bytes,9,rep,name=properties" json:"properties,omitempty"`
}

func (m *EntityAnnotation) Reset()                    { *m = EntityAnnotation{} }
func (m *EntityAnnotation) String() string            { return proto.CompactTextString(m) }
func (*EntityAnnotation) ProtoMessage()               {}
func (*EntityAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *EntityAnnotation) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *EntityAnnotation) GetLocations() []*LocationInfo {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *EntityAnnotation) GetProperties() []*Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

// Set of features pertaining to the image, computed by various computer vision
// methods over safe-search verticals (for example, adult, spoof, medical,
// violence).
type SafeSearchAnnotation struct {
	// Represents the adult contents likelihood for the image.
	Adult Likelihood `protobuf:"varint,1,opt,name=adult,enum=google.cloud.vision.v1.Likelihood" json:"adult,omitempty"`
	// Spoof likelihood. The likelihood that an obvious modification
	// was made to the image's canonical version to make it appear
	// funny or offensive.
	Spoof Likelihood `protobuf:"varint,2,opt,name=spoof,enum=google.cloud.vision.v1.Likelihood" json:"spoof,omitempty"`
	// Likelihood this is a medical image.
	Medical Likelihood `protobuf:"varint,3,opt,name=medical,enum=google.cloud.vision.v1.Likelihood" json:"medical,omitempty"`
	// Violence likelihood.
	Violence Likelihood `protobuf:"varint,4,opt,name=violence,enum=google.cloud.vision.v1.Likelihood" json:"violence,omitempty"`
}

func (m *SafeSearchAnnotation) Reset()                    { *m = SafeSearchAnnotation{} }
func (m *SafeSearchAnnotation) String() string            { return proto.CompactTextString(m) }
func (*SafeSearchAnnotation) ProtoMessage()               {}
func (*SafeSearchAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

// Rectangle determined by min and max LatLng pairs.
type LatLongRect struct {
	// Min lat/long pair.
	MinLatLng *google_type1.LatLng `protobuf:"bytes,1,opt,name=min_lat_lng,json=minLatLng" json:"min_lat_lng,omitempty"`
	// Max lat/long pair.
	MaxLatLng *google_type1.LatLng `protobuf:"bytes,2,opt,name=max_lat_lng,json=maxLatLng" json:"max_lat_lng,omitempty"`
}

func (m *LatLongRect) Reset()                    { *m = LatLongRect{} }
func (m *LatLongRect) String() string            { return proto.CompactTextString(m) }
func (*LatLongRect) ProtoMessage()               {}
func (*LatLongRect) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *LatLongRect) GetMinLatLng() *google_type1.LatLng {
	if m != nil {
		return m.MinLatLng
	}
	return nil
}

func (m *LatLongRect) GetMaxLatLng() *google_type1.LatLng {
	if m != nil {
		return m.MaxLatLng
	}
	return nil
}

// Color information consists of RGB channels, score and fraction of
// image the color occupies in the image.
type ColorInfo struct {
	// RGB components of the color.
	Color *google_type.Color `protobuf:"bytes,1,opt,name=color" json:"color,omitempty"`
	// Image-specific score for this color. Value in range [0, 1].
	Score float32 `protobuf:"fixed32,2,opt,name=score" json:"score,omitempty"`
	// Stores the fraction of pixels the color occupies in the image.
	// Value in range [0, 1].
	PixelFraction float32 `protobuf:"fixed32,3,opt,name=pixel_fraction,json=pixelFraction" json:"pixel_fraction,omitempty"`
}

func (m *ColorInfo) Reset()                    { *m = ColorInfo{} }
func (m *ColorInfo) String() string            { return proto.CompactTextString(m) }
func (*ColorInfo) ProtoMessage()               {}
func (*ColorInfo) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *ColorInfo) GetColor() *google_type.Color {
	if m != nil {
		return m.Color
	}
	return nil
}

// Set of dominant colors and their corresponding scores.
type DominantColorsAnnotation struct {
	// RGB color values, with their score and pixel fraction.
	Colors []*ColorInfo `protobuf:"bytes,1,rep,name=colors" json:"colors,omitempty"`
}

func (m *DominantColorsAnnotation) Reset()                    { *m = DominantColorsAnnotation{} }
func (m *DominantColorsAnnotation) String() string            { return proto.CompactTextString(m) }
func (*DominantColorsAnnotation) ProtoMessage()               {}
func (*DominantColorsAnnotation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *DominantColorsAnnotation) GetColors() []*ColorInfo {
	if m != nil {
		return m.Colors
	}
	return nil
}

// Stores image properties (e.g. dominant colors).
type ImageProperties struct {
	// If present, dominant colors completed successfully.
	DominantColors *DominantColorsAnnotation `protobuf:"bytes,1,opt,name=dominant_colors,json=dominantColors" json:"dominant_colors,omitempty"`
}

func (m *ImageProperties) Reset()                    { *m = ImageProperties{} }
func (m *ImageProperties) String() string            { return proto.CompactTextString(m) }
func (*ImageProperties) ProtoMessage()               {}
func (*ImageProperties) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *ImageProperties) GetDominantColors() *DominantColorsAnnotation {
	if m != nil {
		return m.DominantColors
	}
	return nil
}

// Image context.
type ImageContext struct {
	// Lat/long rectangle that specifies the location of the image.
	LatLongRect *LatLongRect `protobuf:"bytes,1,opt,name=lat_long_rect,json=latLongRect" json:"lat_long_rect,omitempty"`
	// List of languages to use for TEXT_DETECTION. In most cases, an empty value
	// yields the best results since it enables automatic language detection. For
	// languages based on the Latin alphabet, setting `language_hints` is not
	// needed. In rare cases, when the language of the text in the image is known,
	// setting a hint will help get better results (although it will be a
	// significant hindrance if the hint is wrong). Text detection returns an
	// error if one or more of the specified languages is not one of the
	// [supported
	// languages](/translate/v2/translate-reference#supported_languages).
	LanguageHints []string `protobuf:"bytes,2,rep,name=language_hints,json=languageHints" json:"language_hints,omitempty"`
}

func (m *ImageContext) Reset()                    { *m = ImageContext{} }
func (m *ImageContext) String() string            { return proto.CompactTextString(m) }
func (*ImageContext) ProtoMessage()               {}
func (*ImageContext) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *ImageContext) GetLatLongRect() *LatLongRect {
	if m != nil {
		return m.LatLongRect
	}
	return nil
}

// Request for performing Google Cloud Vision API tasks over a user-provided
// image, with user-requested features.
type AnnotateImageRequest struct {
	// The image to be processed.
	Image *Image `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	// Requested features.
	Features []*Feature `protobuf:"bytes,2,rep,name=features" json:"features,omitempty"`
	// Additional context that may accompany the image.
	ImageContext *ImageContext `protobuf:"bytes,3,opt,name=image_context,json=imageContext" json:"image_context,omitempty"`
}

func (m *AnnotateImageRequest) Reset()                    { *m = AnnotateImageRequest{} }
func (m *AnnotateImageRequest) String() string            { return proto.CompactTextString(m) }
func (*AnnotateImageRequest) ProtoMessage()               {}
func (*AnnotateImageRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *AnnotateImageRequest) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *AnnotateImageRequest) GetFeatures() []*Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateImageRequest) GetImageContext() *ImageContext {
	if m != nil {
		return m.ImageContext
	}
	return nil
}

// Response to an image annotation request.
type AnnotateImageResponse struct {
	// If present, face detection completed successfully.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,1,rep,name=face_annotations,json=faceAnnotations" json:"face_annotations,omitempty"`
	// If present, landmark detection completed successfully.
	LandmarkAnnotations []*EntityAnnotation `protobuf:"bytes,2,rep,name=landmark_annotations,json=landmarkAnnotations" json:"landmark_annotations,omitempty"`
	// If present, logo detection completed successfully.
	LogoAnnotations []*EntityAnnotation `protobuf:"bytes,3,rep,name=logo_annotations,json=logoAnnotations" json:"logo_annotations,omitempty"`
	// If present, label detection completed successfully.
	LabelAnnotations []*EntityAnnotation `protobuf:"bytes,4,rep,name=label_annotations,json=labelAnnotations" json:"label_annotations,omitempty"`
	// If present, text (OCR) detection completed successfully.
	TextAnnotations []*EntityAnnotation `protobuf:"bytes,5,rep,name=text_annotations,json=textAnnotations" json:"text_annotations,omitempty"`
	// If present, safe-search annotation completed successfully.
	SafeSearchAnnotation *SafeSearchAnnotation `protobuf:"bytes,6,opt,name=safe_search_annotation,json=safeSearchAnnotation" json:"safe_search_annotation,omitempty"`
	// If present, image properties were extracted successfully.
	ImagePropertiesAnnotation *ImageProperties `protobuf:"bytes,8,opt,name=image_properties_annotation,json=imagePropertiesAnnotation" json:"image_properties_annotation,omitempty"`
	// If set, represents the error message for the operation.
	// Note that filled-in mage annotations are guaranteed to be
	// correct, even when <code>error</code> is non-empty.
	Error *google_rpc.Status `protobuf:"bytes,9,opt,name=error" json:"error,omitempty"`
}

func (m *AnnotateImageResponse) Reset()                    { *m = AnnotateImageResponse{} }
func (m *AnnotateImageResponse) String() string            { return proto.CompactTextString(m) }
func (*AnnotateImageResponse) ProtoMessage()               {}
func (*AnnotateImageResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

func (m *AnnotateImageResponse) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLandmarkAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LandmarkAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLogoAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LogoAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetLabelAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.LabelAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetTextAnnotations() []*EntityAnnotation {
	if m != nil {
		return m.TextAnnotations
	}
	return nil
}

func (m *AnnotateImageResponse) GetSafeSearchAnnotation() *SafeSearchAnnotation {
	if m != nil {
		return m.SafeSearchAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetImagePropertiesAnnotation() *ImageProperties {
	if m != nil {
		return m.ImagePropertiesAnnotation
	}
	return nil
}

func (m *AnnotateImageResponse) GetError() *google_rpc.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Multiple image annotation requests are batched into a single service call.
type BatchAnnotateImagesRequest struct {
	// Individual image annotation requests for this batch.
	Requests []*AnnotateImageRequest `protobuf:"bytes,1,rep,name=requests" json:"requests,omitempty"`
}

func (m *BatchAnnotateImagesRequest) Reset()                    { *m = BatchAnnotateImagesRequest{} }
func (m *BatchAnnotateImagesRequest) String() string            { return proto.CompactTextString(m) }
func (*BatchAnnotateImagesRequest) ProtoMessage()               {}
func (*BatchAnnotateImagesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *BatchAnnotateImagesRequest) GetRequests() []*AnnotateImageRequest {
	if m != nil {
		return m.Requests
	}
	return nil
}

// Response to a batch image annotation request.
type BatchAnnotateImagesResponse struct {
	// Individual responses to image annotation requests within the batch.
	Responses []*AnnotateImageResponse `protobuf:"bytes,1,rep,name=responses" json:"responses,omitempty"`
}

func (m *BatchAnnotateImagesResponse) Reset()                    { *m = BatchAnnotateImagesResponse{} }
func (m *BatchAnnotateImagesResponse) String() string            { return proto.CompactTextString(m) }
func (*BatchAnnotateImagesResponse) ProtoMessage()               {}
func (*BatchAnnotateImagesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

func (m *BatchAnnotateImagesResponse) GetResponses() []*AnnotateImageResponse {
	if m != nil {
		return m.Responses
	}
	return nil
}

func init() {
	proto.RegisterType((*Feature)(nil), "google.cloud.vision.v1.Feature")
	proto.RegisterType((*ImageSource)(nil), "google.cloud.vision.v1.ImageSource")
	proto.RegisterType((*Image)(nil), "google.cloud.vision.v1.Image")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.vision.v1.FaceAnnotation")
	proto.RegisterType((*FaceAnnotation_Landmark)(nil), "google.cloud.vision.v1.FaceAnnotation.Landmark")
	proto.RegisterType((*LocationInfo)(nil), "google.cloud.vision.v1.LocationInfo")
	proto.RegisterType((*Property)(nil), "google.cloud.vision.v1.Property")
	proto.RegisterType((*EntityAnnotation)(nil), "google.cloud.vision.v1.EntityAnnotation")
	proto.RegisterType((*SafeSearchAnnotation)(nil), "google.cloud.vision.v1.SafeSearchAnnotation")
	proto.RegisterType((*LatLongRect)(nil), "google.cloud.vision.v1.LatLongRect")
	proto.RegisterType((*ColorInfo)(nil), "google.cloud.vision.v1.ColorInfo")
	proto.RegisterType((*DominantColorsAnnotation)(nil), "google.cloud.vision.v1.DominantColorsAnnotation")
	proto.RegisterType((*ImageProperties)(nil), "google.cloud.vision.v1.ImageProperties")
	proto.RegisterType((*ImageContext)(nil), "google.cloud.vision.v1.ImageContext")
	proto.RegisterType((*AnnotateImageRequest)(nil), "google.cloud.vision.v1.AnnotateImageRequest")
	proto.RegisterType((*AnnotateImageResponse)(nil), "google.cloud.vision.v1.AnnotateImageResponse")
	proto.RegisterType((*BatchAnnotateImagesRequest)(nil), "google.cloud.vision.v1.BatchAnnotateImagesRequest")
	proto.RegisterType((*BatchAnnotateImagesResponse)(nil), "google.cloud.vision.v1.BatchAnnotateImagesResponse")
	proto.RegisterEnum("google.cloud.vision.v1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterEnum("google.cloud.vision.v1.Feature_Type", Feature_Type_name, Feature_Type_value)
	proto.RegisterEnum("google.cloud.vision.v1.FaceAnnotation_Landmark_Type", FaceAnnotation_Landmark_Type_name, FaceAnnotation_Landmark_Type_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ImageAnnotator service

type ImageAnnotatorClient interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error)
}

type imageAnnotatorClient struct {
	cc *grpc.ClientConn
}

func NewImageAnnotatorClient(cc *grpc.ClientConn) ImageAnnotatorClient {
	return &imageAnnotatorClient{cc}
}

func (c *imageAnnotatorClient) BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error) {
	out := new(BatchAnnotateImagesResponse)
	err := grpc.Invoke(ctx, "/google.cloud.vision.v1.ImageAnnotator/BatchAnnotateImages", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ImageAnnotator service

type ImageAnnotatorServer interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(context.Context, *BatchAnnotateImagesRequest) (*BatchAnnotateImagesResponse, error)
}

func RegisterImageAnnotatorServer(s *grpc.Server, srv ImageAnnotatorServer) {
	s.RegisterService(&_ImageAnnotator_serviceDesc, srv)
}

func _ImageAnnotator_BatchAnnotateImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchAnnotateImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ImageAnnotator/BatchAnnotateImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, req.(*BatchAnnotateImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ImageAnnotator_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vision.v1.ImageAnnotator",
	HandlerType: (*ImageAnnotatorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchAnnotateImages",
			Handler:    _ImageAnnotator_BatchAnnotateImages_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/cloud/vision/v1/image_annotator.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/cloud/vision/v1/image_annotator.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 2060 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x58, 0x4f, 0x73, 0xe3, 0x48,
	0x15, 0x5f, 0xdb, 0x71, 0x62, 0x3f, 0x27, 0x8e, 0xd2, 0xc9, 0x04, 0x4f, 0xe6, 0x5f, 0x56, 0xb0,
	0x90, 0xda, 0x5a, 0x6c, 0x26, 0xb3, 0x5b, 0xb5, 0xec, 0x0e, 0x5b, 0xd8, 0x89, 0x92, 0xb8, 0xe2,
	0x58, 0xde, 0xb6, 0xc3, 0x10, 0xa0, 0x50, 0x29, 0x72, 0x5b, 0xa3, 0x59, 0x59, 0x2d, 0x24, 0x39,
	0x93, 0x5c, 0x38, 0x50, 0x45, 0x15, 0x77, 0xce, 0xf0, 0x1d, 0xa8, 0xa2, 0xb8, 0x72, 0xe6, 0x48,
	0xed, 0x57, 0xe0, 0x43, 0x70, 0xa4, 0xfa, 0x8f, 0xe4, 0x76, 0x36, 0x1e, 0x9c, 0xb9, 0xd8, 0xdd,
	0xef, 0xbd, 0xdf, 0xef, 0x75, 0xbf, 0x7e, 0xfd, 0xe7, 0x09, 0x4e, 0x5d, 0x4a, 0x5d, 0x9f, 0xd4,
	0x5d, 0xea, 0xdb, 0x81, 0x5b, 0xa7, 0x91, 0xdb, 0x70, 0x49, 0x10, 0x46, 0x34, 0xa1, 0x0d, 0xa1,
	0xb2, 0x43, 0x2f, 0x6e, 0x38, 0x3e, 0x9d, 0x0c, 0x1b, 0x57, 0x5e, 0xec, 0xd1, 0xa0, 0x71, 0xf5,
	0xbc, 0xe1, 0x8d, 0x6d, 0x97, 0x58, 0x76, 0x10, 0xd0, 0xc4, 0x4e, 0x68, 0x54, 0xe7, 0x00, 0xb4,
	0x2d, 0xc9, 0xb8, 0x75, 0x5d, 0x58, 0xd7, 0xaf, 0x9e, 0xef, 0xb4, 0x17, 0x73, 0x62, 0x87, 0x5e,
	0x23, 0x26, 0xd1, 0x95, 0xe7, 0x10, 0x87, 0x06, 0x23, 0xcf, 0x6d, 0x48, 0x07, 0x1e, 0x0d, 0x62,
	0xe1, 0x62, 0xe7, 0xf0, 0xfd, 0xc6, 0xeb, 0x12, 0x3a, 0x26, 0x49, 0x74, 0x23, 0x59, 0x7e, 0xb6,
	0x18, 0x4b, 0x14, 0x3a, 0x8d, 0x38, 0xb1, 0x93, 0x49, 0x2c, 0xff, 0x24, 0xfc, 0xe5, 0x62, 0xf0,
	0xe4, 0x26, 0x24, 0x0d, 0x87, 0xfa, 0x34, 0x12, 0xbf, 0x12, 0xfd, 0xd5, 0x3d, 0xd0, 0xbe, 0x9d,
	0xf8, 0x81, 0x2b, 0xff, 0x04, 0x5e, 0xff, 0x4b, 0x1e, 0x56, 0x8e, 0x88, 0x9d, 0x4c, 0x22, 0x82,
	0x3e, 0x87, 0x25, 0x66, 0x57, 0xcb, 0xed, 0xe6, 0xf6, 0xaa, 0xfb, 0x3f, 0xa8, 0xdf, 0xbd, 0x00,
	0x75, 0x69, 0x5e, 0x1f, 0xdc, 0x84, 0x04, 0x73, 0x04, 0x7a, 0x06, 0x95, 0xb1, 0x7d, 0x6d, 0x45,
	0x24, 0x9e, 0xf8, 0x49, 0x5c, 0xcb, 0xef, 0xe6, 0xf6, 0x8a, 0x18, 0xc6, 0xf6, 0x35, 0x16, 0x12,
	0xfd, 0x1f, 0x39, 0x58, 0x62, 0xf6, 0x68, 0x0b, 0xb4, 0xc1, 0x45, 0xcf, 0xb0, 0xce, 0xbb, 0xfd,
	0x9e, 0x71, 0xd0, 0x3e, 0x6a, 0x1b, 0x87, 0xda, 0x07, 0x08, 0x41, 0xf5, 0xa8, 0x79, 0x60, 0x58,
	0x87, 0xc6, 0xc0, 0x38, 0x18, 0xb4, 0xcd, 0xae, 0x96, 0x43, 0xdb, 0x80, 0x3a, 0xcd, 0xee, 0xe1,
	0x59, 0x13, 0x9f, 0x2a, 0xf2, 0x3c, 0xb3, 0xed, 0x98, 0xc7, 0xa6, 0x22, 0x2b, 0xa0, 0x4d, 0x58,
	0xef, 0x34, 0x5b, 0x46, 0x47, 0x11, 0x2e, 0x31, 0xc3, 0x81, 0xf1, 0xcb, 0x81, 0x22, 0x2b, 0xa2,
	0x87, 0xf0, 0xa0, 0xdf, 0x3c, 0x32, 0xac, 0xbe, 0xd1, 0xc4, 0x07, 0x27, 0x8a, 0x6a, 0x99, 0x8d,
	0xac, 0x7d, 0xd6, 0x3c, 0x36, 0xac, 0x1e, 0x36, 0x7b, 0x06, 0x1e, 0xb4, 0x8d, 0xbe, 0xb6, 0xa2,
	0x3f, 0x87, 0x4a, 0x9b, 0xa5, 0x67, 0x9f, 0x4e, 0x22, 0x87, 0x20, 0x1d, 0xd6, 0x5c, 0x27, 0xb6,
	0x44, 0xc6, 0x4e, 0x22, 0x8f, 0xc7, 0xaa, 0x8c, 0x2b, 0xae, 0x13, 0x73, 0xb3, 0xf3, 0xc8, 0xd3,
	0x7f, 0x0b, 0x45, 0xde, 0x46, 0x35, 0x58, 0x71, 0x68, 0x90, 0x90, 0x20, 0xe1, 0x66, 0xab, 0x38,
	0xed, 0xa2, 0x2f, 0x61, 0x39, 0xe6, 0x84, 0x3c, 0x54, 0x95, 0xfd, 0xef, 0xcf, 0x8b, 0xb5, 0xe2,
	0x1b, 0x4b, 0x88, 0xfe, 0xef, 0x75, 0xa8, 0x1e, 0xd9, 0x0e, 0x69, 0x66, 0xf9, 0x8c, 0xda, 0xb0,
	0x76, 0x49, 0x27, 0xc1, 0xd0, 0x0b, 0x5c, 0x2b, 0xa4, 0xfe, 0x0d, 0xf7, 0x57, 0x99, 0xbf, 0x84,
	0x2d, 0x69, 0xdc, 0xa3, 0xfe, 0x0d, 0x5e, 0xbd, 0x54, 0x7a, 0xa8, 0x0b, 0xda, 0x68, 0x68, 0xcd,
	0xb2, 0xe5, 0xef, 0xc1, 0x56, 0x1d, 0x0d, 0xd5, 0x3e, 0x3a, 0x83, 0xb2, 0x6f, 0x07, 0xc3, 0xb1,
	0x1d, 0x7d, 0x13, 0xd7, 0x0a, 0xbb, 0x85, 0xbd, 0xca, 0x7e, 0x63, 0x6e, 0x66, 0xcd, 0xcc, 0xaa,
	0xde, 0x91, 0x38, 0x3c, 0x65, 0x40, 0x4f, 0x00, 0x22, 0xea, 0xfb, 0x96, 0x1d, 0xb8, 0x3e, 0xa9,
	0x2d, 0xed, 0xe6, 0xf6, 0xf2, 0xb8, 0xcc, 0x24, 0x4d, 0x26, 0x40, 0x8f, 0xa0, 0x1c, 0xda, 0x81,
	0xd4, 0x16, 0xb9, 0xb6, 0x14, 0xda, 0x81, 0x50, 0x3e, 0x01, 0x48, 0x3c, 0x3f, 0x91, 0xda, 0x65,
	0x81, 0x65, 0x12, 0xa1, 0x7e, 0x0e, 0x5b, 0x43, 0x92, 0x10, 0x87, 0xf9, 0xb6, 0xf8, 0x99, 0x31,
	0x24, 0x81, 0x43, 0x6a, 0x2b, 0xdc, 0x70, 0x33, 0xd3, 0x1d, 0x64, 0x2a, 0xf4, 0x19, 0x6c, 0xa7,
	0x43, 0x63, 0xc1, 0x52, 0x40, 0x25, 0x0e, 0x7a, 0xa0, 0x68, 0x15, 0x58, 0x1b, 0xaa, 0x6f, 0xe8,
	0x8d, 0xe5, 0x7b, 0xdf, 0x10, 0xdf, 0x7b, 0x4d, 0xe9, 0xb0, 0x56, 0xe6, 0x5b, 0x4e, 0x9f, 0x17,
	0x98, 0x4e, 0x66, 0x89, 0xd7, 0xde, 0xd0, 0x9b, 0x69, 0x17, 0x99, 0xb0, 0x11, 0xd3, 0x28, 0xa2,
	0x6f, 0x55, 0x36, 0x58, 0x98, 0x4d, 0x13, 0x60, 0x85, 0xf0, 0x0c, 0x34, 0x3b, 0x70, 0x49, 0xa4,
	0xf2, 0x55, 0x16, 0xe6, 0x5b, 0xe7, 0x58, 0x85, 0xae, 0x0f, 0x9b, 0xf1, 0x24, 0x0a, 0x23, 0x2f,
	0x26, 0x2a, 0xe3, 0xea, 0xc2, 0x8c, 0x28, 0x85, 0x2b, 0xa4, 0xbf, 0x81, 0xda, 0x24, 0x18, 0x92,
	0xc8, 0x22, 0xd7, 0x21, 0x8d, 0xc9, 0x50, 0x65, 0x5e, 0x5b, 0x98, 0x79, 0x9b, 0x73, 0x18, 0x82,
	0x42, 0x61, 0xff, 0x1a, 0xd0, 0xa5, 0x3f, 0x89, 0xa2, 0x59, 0xde, 0xea, 0xc2, 0xbc, 0x1b, 0x12,
	0x3d, 0x1b, 0x85, 0xd7, 0xc4, 0x1e, 0xbe, 0x25, 0xf6, 0x4c, 0x5c, 0xd7, 0x17, 0x8f, 0x42, 0x0a,
	0x9f, 0xca, 0x76, 0xfe, 0xb5, 0x02, 0xa5, 0x74, 0x8b, 0xa0, 0x13, 0x79, 0x76, 0x17, 0x38, 0xe5,
	0xa7, 0xf7, 0xdc, 0x61, 0xea, 0x59, 0xfe, 0x12, 0x4a, 0x21, 0x8d, 0x3d, 0xa6, 0xe7, 0xfb, 0xab,
	0xb2, 0xbf, 0x3b, 0x8f, 0xad, 0x27, 0xed, 0x70, 0x86, 0xd0, 0xff, 0xbe, 0x3c, 0x3d, 0xe8, 0xcf,
	0xbb, 0xa7, 0x5d, 0xf3, 0x55, 0xd7, 0x4a, 0x8f, 0x71, 0xed, 0x03, 0xb4, 0x0a, 0xa5, 0x8e, 0x71,
	0x34, 0xb0, 0x8c, 0x0b, 0x43, 0xcb, 0xa1, 0x35, 0x28, 0xe3, 0xf6, 0xf1, 0x89, 0xe8, 0xe6, 0x51,
	0x0d, 0xb6, 0xb8, 0xd2, 0x3c, 0xb2, 0x52, 0xa3, 0x16, 0x36, 0x5f, 0x69, 0x05, 0x76, 0x6c, 0x0b,
	0xc3, 0xdb, 0xaa, 0x25, 0xa6, 0x4a, 0x41, 0x19, 0x17, 0x57, 0x15, 0xd1, 0x0e, 0x6c, 0x67, 0xa8,
	0x59, 0xdd, 0x32, 0x83, 0x9d, 0xb5, 0x0f, 0x7b, 0x66, 0xbb, 0x3b, 0xb0, 0x5a, 0xc6, 0xe0, 0x95,
	0x61, 0x74, 0x99, 0xb6, 0xaf, 0xad, 0xb0, 0x31, 0x76, 0xcd, 0xbe, 0x61, 0x0d, 0xda, 0x3d, 0xad,
	0xc4, 0xc6, 0x78, 0xde, 0xeb, 0x19, 0xd8, 0xea, 0xb4, 0x7b, 0x5a, 0x99, 0x75, 0x3b, 0xe6, 0x2b,
	0xd9, 0x05, 0x54, 0x05, 0x38, 0x33, 0xcf, 0x07, 0x27, 0x7c, 0x54, 0x5a, 0x05, 0xad, 0x43, 0x45,
	0xf4, 0xb9, 0x3f, 0x6d, 0x15, 0x69, 0xb0, 0x2a, 0x04, 0x07, 0x46, 0x77, 0x60, 0x60, 0x6d, 0x0d,
	0x3d, 0x80, 0x0d, 0x4e, 0xdf, 0x32, 0x07, 0x03, 0xf3, 0x4c, 0x1a, 0x56, 0x59, 0xbc, 0x54, 0x31,
	0xe7, 0x5b, 0x67, 0x97, 0xa0, 0x2a, 0x95, 0x24, 0x5a, 0x36, 0x6b, 0xe3, 0xc2, 0xb0, 0x06, 0x66,
	0xcf, 0x6a, 0x99, 0xe7, 0xdd, 0xc3, 0x26, 0xbe, 0xd0, 0x36, 0x66, 0x54, 0x62, 0xd6, 0x07, 0x26,
	0xee, 0x1a, 0x58, 0x43, 0xe8, 0x31, 0xd4, 0x32, 0x95, 0x64, 0xcc, 0x80, 0x9b, 0x59, 0xf8, 0x99,
	0x96, 0x37, 0x24, 0x6e, 0x6b, 0x1a, 0xc8, 0xef, 0xb8, 0x7b, 0x30, 0xab, 0x9b, 0xf1, 0xb7, 0x8d,
	0x9e, 0xc0, 0xc3, 0xa9, 0xee, 0xb6, 0xc3, 0xef, 0x4d, 0x57, 0xf5, 0xb6, 0xc7, 0x1a, 0x7a, 0x06,
	0x8f, 0xd4, 0x75, 0xb6, 0xc4, 0x12, 0xa4, 0x2b, 0xa6, 0x3d, 0x44, 0xbb, 0xf0, 0x78, 0x66, 0x49,
	0x6f, 0x5b, 0xec, 0xb0, 0x80, 0x0a, 0x8a, 0x26, 0xb6, 0x06, 0xb8, 0x79, 0xcc, 0x6e, 0xf9, 0x47,
	0x2c, 0xfa, 0x12, 0xa7, 0x88, 0x1f, 0xf3, 0x47, 0x45, 0x3a, 0xf7, 0xde, 0x79, 0xaf, 0xdd, 0xd1,
	0x9e, 0xb0, 0x47, 0xc5, 0x74, 0x78, 0x42, 0xf8, 0x94, 0xe1, 0x8f, 0x4c, 0x6c, 0x9c, 0x18, 0xcd,
	0x43, 0xeb, 0x98, 0xbf, 0x39, 0x3a, 0x4d, 0xed, 0x19, 0xda, 0x80, 0xb5, 0x83, 0x93, 0x76, 0xd7,
	0x3a, 0xee, 0x36, 0x07, 0x27, 0x8c, 0x72, 0x97, 0xf9, 0xe7, 0x22, 0xce, 0x7b, 0x6c, 0x76, 0x99,
	0xf4, 0x43, 0x86, 0xe7, 0x52, 0xc1, 0x2c, 0xc5, 0xba, 0xfe, 0x12, 0x56, 0x3b, 0xd4, 0xe1, 0x9b,
	0xb2, 0x1d, 0x8c, 0x28, 0xfa, 0x04, 0x56, 0x7c, 0x3b, 0xb1, 0xfc, 0xc0, 0x95, 0x57, 0xf9, 0x66,
	0xba, 0x07, 0xd9, 0x1e, 0xad, 0x77, 0xec, 0xa4, 0x13, 0xb8, 0x78, 0xd9, 0xe7, 0xff, 0xfa, 0xa7,
	0x50, 0xea, 0x45, 0x34, 0x24, 0x51, 0x72, 0x83, 0x10, 0x2c, 0x05, 0xf6, 0x98, 0xc8, 0x87, 0x09,
	0x6f, 0xa3, 0x2d, 0x28, 0x5e, 0xd9, 0xfe, 0x44, 0xbc, 0x36, 0xca, 0x58, 0x74, 0xf4, 0x3f, 0x16,
	0x40, 0x33, 0x82, 0xc4, 0x4b, 0x6e, 0x94, 0x97, 0x84, 0x06, 0x85, 0xb1, 0x37, 0x94, 0x68, 0xd6,
	0x44, 0xdb, 0xb0, 0xec, 0x53, 0xc7, 0xf6, 0x53, 0xb4, 0xec, 0xa1, 0x5d, 0xa8, 0x0c, 0x49, 0xec,
	0x44, 0x5e, 0xc8, 0x8f, 0x8a, 0x82, 0x78, 0x08, 0x29, 0x22, 0xe6, 0x36, 0x76, 0x68, 0x94, 0x5e,
	0xd3, 0xa2, 0x83, 0x9e, 0x02, 0x28, 0xf7, 0xa4, 0xb8, 0xa3, 0x15, 0x09, 0xd3, 0x27, 0x34, 0xf4,
	0x1c, 0xdb, 0xf7, 0x92, 0x1b, 0x79, 0x4b, 0x2b, 0x92, 0xef, 0xbe, 0x75, 0x56, 0xde, 0xfb, 0xad,
	0xd3, 0x82, 0xb2, 0x2f, 0xa3, 0x1e, 0xd7, 0x4a, 0xfc, 0x6d, 0x32, 0x97, 0x46, 0x5d, 0x1e, 0x3c,
	0x85, 0xa1, 0x9f, 0x03, 0x84, 0x22, 0xf6, 0x1e, 0x89, 0x6b, 0x65, 0x4e, 0x32, 0xff, 0xc0, 0x94,
	0xab, 0x84, 0x15, 0x8c, 0xfe, 0xa7, 0x3c, 0x6c, 0xf5, 0xed, 0x11, 0xe9, 0x13, 0x3b, 0x72, 0x5e,
	0x2b, 0x6b, 0xf1, 0x39, 0x14, 0xed, 0xe1, 0xc4, 0x4f, 0xe4, 0x83, 0x7c, 0x91, 0x7b, 0x42, 0x00,
	0x18, 0x32, 0x0e, 0x29, 0x1d, 0xf1, 0x25, 0x5b, 0x10, 0xc9, 0x01, 0xe8, 0x25, 0xac, 0x8c, 0xc9,
	0x90, 0xc5, 0x5a, 0x5e, 0x25, 0x8b, 0x60, 0x53, 0x08, 0xfa, 0x0a, 0x4a, 0x57, 0x1e, 0xf5, 0xf9,
	0xca, 0x2e, 0x2d, 0x0c, 0xcf, 0x30, 0xfa, 0x5b, 0xa8, 0xb0, 0xd4, 0xa6, 0x81, 0x8b, 0x89, 0x93,
	0xa0, 0x17, 0x50, 0x19, 0x7b, 0x81, 0xb5, 0xc0, 0x4e, 0x28, 0x8f, 0xbd, 0x40, 0x34, 0x39, 0xc8,
	0xbe, 0xce, 0x40, 0xf9, 0x77, 0x81, 0xec, 0x6b, 0xd1, 0xd4, 0x23, 0x28, 0x1f, 0xb0, 0xaa, 0x8a,
	0x6f, 0xbe, 0x3d, 0x28, 0xf2, 0x12, 0x4b, 0x3a, 0x44, 0x33, 0x58, 0x6e, 0x86, 0x85, 0xc1, 0x34,
	0xc3, 0xf3, 0x6a, 0x86, 0x7f, 0x04, 0xd5, 0xd0, 0xbb, 0x26, 0xbe, 0x35, 0x8a, 0x6c, 0x27, 0xdb,
	0x1c, 0x79, 0xbc, 0xc6, 0xa5, 0x47, 0x52, 0xa8, 0x9f, 0x43, 0xed, 0x90, 0x8e, 0xbd, 0xc0, 0x0e,
	0x12, 0x4e, 0x1a, 0x2b, 0x4b, 0xff, 0x53, 0x58, 0xe6, 0x1e, 0xe2, 0x5a, 0x8e, 0x67, 0xd4, 0x87,
	0xf3, 0xc2, 0x98, 0x8d, 0x1a, 0x4b, 0x80, 0xee, 0xc3, 0x3a, 0xaf, 0x1a, 0x7a, 0x59, 0x86, 0xa1,
	0x0b, 0x58, 0x1f, 0x4a, 0x4f, 0x56, 0x46, 0xcb, 0xa6, 0xf6, 0x93, 0x79, 0xb4, 0xf3, 0x06, 0x86,
	0xab, 0xc3, 0x19, 0x8d, 0xfe, 0x7b, 0x58, 0xe5, 0xde, 0x0e, 0x58, 0x65, 0x73, 0x9d, 0xa0, 0x63,
	0x58, 0xe3, 0x91, 0xa7, 0x81, 0x6b, 0x45, 0xc4, 0x49, 0xa4, 0xa3, 0xb9, 0x05, 0x8e, 0xb2, 0xdc,
	0xb8, 0xe2, 0x2b, 0x6b, 0xff, 0x11, 0x54, 0x59, 0x45, 0x3b, 0x61, 0x85, 0xd6, 0x6b, 0x2f, 0xe0,
	0x55, 0x65, 0x61, 0xaf, 0x8c, 0xd7, 0x52, 0xe9, 0x09, 0x13, 0xea, 0xdf, 0xe6, 0x60, 0x4b, 0x0e,
	0x8f, 0xf0, 0x81, 0x60, 0xf2, 0xbb, 0x09, 0x89, 0x59, 0xee, 0x14, 0x79, 0x95, 0x26, 0x07, 0xf0,
	0xe4, 0x9d, 0x15, 0x16, 0x16, 0xb6, 0xe8, 0x4b, 0x28, 0x8d, 0x44, 0x75, 0x2b, 0xdc, 0x55, 0xf6,
	0x9f, 0xfd, 0x9f, 0x2a, 0x18, 0x67, 0x00, 0x76, 0x30, 0x89, 0xba, 0xd0, 0x11, 0xb1, 0xe0, 0xab,
	0xfe, 0x8e, 0x13, 0x45, 0x8d, 0x1b, 0x5e, 0xf5, 0x94, 0x9e, 0xfe, 0xcf, 0x22, 0x3c, 0xb8, 0x35,
	0xab, 0x38, 0xa4, 0x41, 0x4c, 0xd0, 0xd7, 0xa0, 0x8d, 0x6c, 0x27, 0xfb, 0x5a, 0xc2, 0x4f, 0x2e,
	0x91, 0x22, 0x3f, 0x5c, 0xec, 0xcd, 0x87, 0xd7, 0x47, 0x33, 0xfd, 0x18, 0xfd, 0x1a, 0xb6, 0xd2,
	0x32, 0x65, 0x86, 0x56, 0x04, 0x60, 0x6f, 0x1e, 0xed, 0xed, 0xab, 0x03, 0x6f, 0xa6, 0x2c, 0x2a,
	0x79, 0x1f, 0x34, 0x9f, 0xba, 0x74, 0x86, 0xb8, 0x70, 0x4f, 0xe2, 0x75, 0xc6, 0xa0, 0x92, 0x9e,
	0xc3, 0x86, 0x6f, 0x5f, 0x12, 0x7f, 0x86, 0x75, 0xe9, 0x9e, 0xac, 0x1a, 0xa7, 0xb8, 0x35, 0x56,
	0x16, 0xfd, 0x19, 0xd6, 0xe2, 0x7d, 0xc7, 0xca, 0x18, 0x54, 0xd2, 0x4b, 0xd8, 0x8e, 0xed, 0x11,
	0xb1, 0x62, 0x7e, 0xba, 0x2b, 0xdc, 0xfc, 0x6a, 0xab, 0xec, 0x7f, 0x32, 0x8f, 0xfa, 0xae, 0x2b,
	0x01, 0x6f, 0xc5, 0x77, 0x5d, 0x14, 0x2e, 0x3c, 0x12, 0x99, 0x37, 0xbd, 0x55, 0x54, 0x47, 0x25,
	0xee, 0xe8, 0x47, 0xef, 0xcc, 0xc3, 0xe9, 0x69, 0x81, 0x1f, 0x7a, 0xb3, 0x02, 0xc5, 0xd1, 0x1e,
	0x14, 0x49, 0x14, 0xd1, 0x88, 0xd7, 0xab, 0xca, 0xc9, 0x18, 0x85, 0x4e, 0xbd, 0xcf, 0x3f, 0x6a,
	0x61, 0x61, 0xa0, 0x8f, 0x60, 0xa7, 0x65, 0x27, 0xd9, 0x28, 0x45, 0x16, 0xc7, 0xe9, 0xe6, 0x3c,
	0x81, 0x52, 0x24, 0x9a, 0x69, 0xf6, 0xce, 0x0d, 0xc3, 0x5d, 0x9b, 0x1b, 0x67, 0x68, 0xfd, 0x0d,
	0x3c, 0xba, 0xd3, 0x8f, 0xdc, 0x2e, 0xa7, 0x50, 0x8e, 0x64, 0x3b, 0xf5, 0xf4, 0xe3, 0x05, 0x3d,
	0x09, 0x14, 0x9e, 0xe2, 0x3f, 0x26, 0x00, 0x4a, 0x4d, 0x57, 0x81, 0x15, 0x59, 0xe0, 0x68, 0x1f,
	0xb0, 0xf7, 0xdf, 0x2f, 0x0c, 0x7c, 0x61, 0x9d, 0x77, 0x3b, 0xed, 0x53, 0xa3, 0x73, 0xa1, 0xe5,
	0x58, 0x19, 0x91, 0xf5, 0xf2, 0xac, 0xd7, 0x33, 0xfb, 0xfd, 0x76, 0xab, 0x63, 0x68, 0x05, 0x04,
	0xb0, 0x2c, 0x35, 0x4b, 0xac, 0x64, 0xe0, 0x50, 0x29, 0x28, 0xee, 0xff, 0x2d, 0x07, 0x55, 0x3e,
	0x86, 0x66, 0xfa, 0x45, 0x14, 0xfd, 0x35, 0x07, 0x9b, 0x77, 0x4c, 0x13, 0xed, 0xcf, 0x7d, 0xf4,
	0xcc, 0x8d, 0xfd, 0xce, 0x8b, 0x7b, 0x61, 0xc4, 0xdc, 0xf5, 0xa7, 0x7f, 0xf8, 0xf6, 0x3f, 0x7f,
	0xce, 0xd7, 0xf4, 0xcd, 0xec, 0x7b, 0x6d, 0xfc, 0x85, 0xcc, 0x30, 0xf2, 0x45, 0xee, 0xe3, 0xd6,
	0x18, 0x76, 0x1c, 0x3a, 0x9e, 0xc3, 0xdc, 0xda, 0x9c, 0x9d, 0x4e, 0x2f, 0xa2, 0x09, 0xed, 0xe5,
	0x7e, 0xf5, 0xd9, 0x7b, 0x7d, 0x7e, 0xfd, 0x6f, 0x2e, 0x77, 0xb9, 0xcc, 0x8d, 0x5e, 0xfc, 0x2f,
	0x00, 0x00, 0xff, 0xff, 0x30, 0xf8, 0x96, 0xf0, 0x71, 0x16, 0x00, 0x00,
}
