// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/rpc/errdetails/error_details.proto
// DO NOT EDIT!

/*
Package errdetails is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/rpc/errdetails/error_details.proto

It has these top-level messages:
	RetryInfo
	DebugInfo
	QuotaFailure
	BadRequest
	RequestInfo
	ResourceInfo
	Help
	LocalizedMessage
*/
package errdetails // import "google.golang.org/genproto/googleapis/rpc/errdetails"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/duration"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Describes when the clients can retry a failed request. Clients could ignore
// the recommendation here or retry when this information is missing from error
// responses.
//
// It's always recommended that clients should use exponential backoff when
// retrying.
//
// Clients should wait until `retry_delay` amount of time has passed since
// receiving the error response before retrying.  If retrying requests also
// fail, clients should use an exponential backoff scheme to gradually increase
// the delay between retries based on `retry_delay`, until either a maximum
// number of retires have been reached or a maximum retry delay cap has been
// reached.
type RetryInfo struct {
	// Clients should wait at least this long between retrying the same request.
	RetryDelay *google_protobuf.Duration `protobuf:"bytes,1,opt,name=retry_delay,json=retryDelay" json:"retry_delay,omitempty"`
}

func (m *RetryInfo) Reset()                    { *m = RetryInfo{} }
func (m *RetryInfo) String() string            { return proto.CompactTextString(m) }
func (*RetryInfo) ProtoMessage()               {}
func (*RetryInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *RetryInfo) GetRetryDelay() *google_protobuf.Duration {
	if m != nil {
		return m.RetryDelay
	}
	return nil
}

// Describes additional debugging info.
type DebugInfo struct {
	// The stack trace entries indicating where the error occurred.
	StackEntries []string `protobuf:"bytes,1,rep,name=stack_entries,json=stackEntries" json:"stack_entries,omitempty"`
	// Additional debugging information provided by the server.
	Detail string `protobuf:"bytes,2,opt,name=detail" json:"detail,omitempty"`
}

func (m *DebugInfo) Reset()                    { *m = DebugInfo{} }
func (m *DebugInfo) String() string            { return proto.CompactTextString(m) }
func (*DebugInfo) ProtoMessage()               {}
func (*DebugInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Describes how a quota check failed.
//
// For example if a daily limit was exceeded for the calling project,
// a service could respond with a QuotaFailure detail containing the project
// id and the description of the quota limit that was exceeded.  If the
// calling project hasn't enabled the service in the developer console, then
// a service could respond with the project id and set `service_disabled`
// to true.
//
// Also see RetryDetail and Help types for other details about handling a
// quota failure.
type QuotaFailure struct {
	// Describes all quota violations.
	Violations []*QuotaFailure_Violation `protobuf:"bytes,1,rep,name=violations" json:"violations,omitempty"`
}

func (m *QuotaFailure) Reset()                    { *m = QuotaFailure{} }
func (m *QuotaFailure) String() string            { return proto.CompactTextString(m) }
func (*QuotaFailure) ProtoMessage()               {}
func (*QuotaFailure) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *QuotaFailure) GetViolations() []*QuotaFailure_Violation {
	if m != nil {
		return m.Violations
	}
	return nil
}

// A message type used to describe a single quota violation.  For example, a
// daily quota or a custom quota that was exceeded.
type QuotaFailure_Violation struct {
	// The subject on which the quota check failed.
	// For example, "clientip:<ip address of client>" or "project:<Google
	// developer project id>".
	Subject string `protobuf:"bytes,1,opt,name=subject" json:"subject,omitempty"`
	// A description of how the quota check failed. Clients can use this
	// description to find more about the quota configuration in the service's
	// public documentation, or find the relevant quota limit to adjust through
	// developer console.
	//
	// For example: "Service disabled" or "Daily Limit for read operations
	// exceeded".
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
}

func (m *QuotaFailure_Violation) Reset()                    { *m = QuotaFailure_Violation{} }
func (m *QuotaFailure_Violation) String() string            { return proto.CompactTextString(m) }
func (*QuotaFailure_Violation) ProtoMessage()               {}
func (*QuotaFailure_Violation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 0} }

// Describes violations in a client request. This error type focuses on the
// syntactic aspects of the request.
type BadRequest struct {
	// Describes all violations in a client request.
	FieldViolations []*BadRequest_FieldViolation `protobuf:"bytes,1,rep,name=field_violations,json=fieldViolations" json:"field_violations,omitempty"`
}

func (m *BadRequest) Reset()                    { *m = BadRequest{} }
func (m *BadRequest) String() string            { return proto.CompactTextString(m) }
func (*BadRequest) ProtoMessage()               {}
func (*BadRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *BadRequest) GetFieldViolations() []*BadRequest_FieldViolation {
	if m != nil {
		return m.FieldViolations
	}
	return nil
}

// A message type used to describe a single bad request field.
type BadRequest_FieldViolation struct {
	// A path leading to a field in the request body. The value will be a
	// sequence of dot-separated identifiers that identify a protocol buffer
	// field. E.g., "field_violations.field" would identify this field.
	Field string `protobuf:"bytes,1,opt,name=field" json:"field,omitempty"`
	// A description of why the request element is bad.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
}

func (m *BadRequest_FieldViolation) Reset()                    { *m = BadRequest_FieldViolation{} }
func (m *BadRequest_FieldViolation) String() string            { return proto.CompactTextString(m) }
func (*BadRequest_FieldViolation) ProtoMessage()               {}
func (*BadRequest_FieldViolation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 0} }

// Contains metadata about the request that clients can attach when filing a bug
// or providing other forms of feedback.
type RequestInfo struct {
	// An opaque string that should only be interpreted by the service generating
	// it. For example, it can be used to identify requests in the service's logs.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId" json:"request_id,omitempty"`
	// Any data that was used to serve this request. For example, an encrypted
	// stack trace that can be sent back to the service provider for debugging.
	ServingData string `protobuf:"bytes,2,opt,name=serving_data,json=servingData" json:"serving_data,omitempty"`
}

func (m *RequestInfo) Reset()                    { *m = RequestInfo{} }
func (m *RequestInfo) String() string            { return proto.CompactTextString(m) }
func (*RequestInfo) ProtoMessage()               {}
func (*RequestInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// Describes the resource that is being accessed.
type ResourceInfo struct {
	// A name for the type of resource being accessed, e.g. "sql table",
	// "cloud storage bucket", "file", "Google calendar"; or the type URL
	// of the resource: e.g. "type.googleapis.com/google.pubsub.v1.Topic".
	ResourceType string `protobuf:"bytes,1,opt,name=resource_type,json=resourceType" json:"resource_type,omitempty"`
	// The name of the resource being accessed.  For example, a shared calendar
	// name: "example.com_4fghdhgsrgh@group.calendar.google.com", if the current
	// error is [google.rpc.Code.PERMISSION_DENIED][google.rpc.Code.PERMISSION_DENIED].
	ResourceName string `protobuf:"bytes,2,opt,name=resource_name,json=resourceName" json:"resource_name,omitempty"`
	// The owner of the resource (optional).
	// For example, "user:<owner email>" or "project:<Google developer project
	// id>".
	Owner string `protobuf:"bytes,3,opt,name=owner" json:"owner,omitempty"`
	// Describes what error is encountered when accessing this resource.
	// For example, updating a cloud project may require the `writer` permission
	// on the developer console project.
	Description string `protobuf:"bytes,4,opt,name=description" json:"description,omitempty"`
}

func (m *ResourceInfo) Reset()                    { *m = ResourceInfo{} }
func (m *ResourceInfo) String() string            { return proto.CompactTextString(m) }
func (*ResourceInfo) ProtoMessage()               {}
func (*ResourceInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// Provides links to documentation or for performing an out of band action.
//
// For example, if a quota check failed with an error indicating the calling
// project hasn't enabled the accessed service, this can contain a URL pointing
// directly to the right place in the developer console to flip the bit.
type Help struct {
	// URL(s) pointing to additional information on handling the current error.
	Links []*Help_Link `protobuf:"bytes,1,rep,name=links" json:"links,omitempty"`
}

func (m *Help) Reset()                    { *m = Help{} }
func (m *Help) String() string            { return proto.CompactTextString(m) }
func (*Help) ProtoMessage()               {}
func (*Help) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *Help) GetLinks() []*Help_Link {
	if m != nil {
		return m.Links
	}
	return nil
}

// Describes a URL link.
type Help_Link struct {
	// Describes what the link offers.
	Description string `protobuf:"bytes,1,opt,name=description" json:"description,omitempty"`
	// The URL of the link.
	Url string `protobuf:"bytes,2,opt,name=url" json:"url,omitempty"`
}

func (m *Help_Link) Reset()                    { *m = Help_Link{} }
func (m *Help_Link) String() string            { return proto.CompactTextString(m) }
func (*Help_Link) ProtoMessage()               {}
func (*Help_Link) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6, 0} }

// Provides a localized error message that is safe to return to the user
// which can be attached to an RPC error.
type LocalizedMessage struct {
	// The locale used following the specification defined at
	// http://www.rfc-editor.org/rfc/bcp/bcp47.txt.
	// Examples are: "en-US", "fr-CH", "es-MX"
	Locale string `protobuf:"bytes,1,opt,name=locale" json:"locale,omitempty"`
	// The localized error message in the above locale.
	Message string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
}

func (m *LocalizedMessage) Reset()                    { *m = LocalizedMessage{} }
func (m *LocalizedMessage) String() string            { return proto.CompactTextString(m) }
func (*LocalizedMessage) ProtoMessage()               {}
func (*LocalizedMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func init() {
	proto.RegisterType((*RetryInfo)(nil), "google.rpc.RetryInfo")
	proto.RegisterType((*DebugInfo)(nil), "google.rpc.DebugInfo")
	proto.RegisterType((*QuotaFailure)(nil), "google.rpc.QuotaFailure")
	proto.RegisterType((*QuotaFailure_Violation)(nil), "google.rpc.QuotaFailure.Violation")
	proto.RegisterType((*BadRequest)(nil), "google.rpc.BadRequest")
	proto.RegisterType((*BadRequest_FieldViolation)(nil), "google.rpc.BadRequest.FieldViolation")
	proto.RegisterType((*RequestInfo)(nil), "google.rpc.RequestInfo")
	proto.RegisterType((*ResourceInfo)(nil), "google.rpc.ResourceInfo")
	proto.RegisterType((*Help)(nil), "google.rpc.Help")
	proto.RegisterType((*Help_Link)(nil), "google.rpc.Help.Link")
	proto.RegisterType((*LocalizedMessage)(nil), "google.rpc.LocalizedMessage")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/rpc/errdetails/error_details.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 568 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x94, 0xc1, 0x6f, 0xd3, 0x3e,
	0x14, 0xc7, 0x95, 0x75, 0xdb, 0x4f, 0x79, 0xed, 0x6f, 0x94, 0x08, 0x50, 0xa9, 0x84, 0x54, 0x82,
	0x90, 0x2a, 0x21, 0x25, 0xd2, 0x38, 0x31, 0x0e, 0x48, 0x25, 0xdb, 0x3a, 0x69, 0x40, 0x89, 0x10,
	0x07, 0x2e, 0x91, 0x9b, 0xbc, 0x06, 0x53, 0x37, 0x0e, 0xb6, 0x33, 0x54, 0xfe, 0x0a, 0xee, 0xdc,
	0x38, 0xf1, 0x67, 0x22, 0xc7, 0x4e, 0x9b, 0xae, 0x17, 0xc4, 0xcd, 0xdf, 0x97, 0x8f, 0xbf, 0x7e,
	0xdf, 0xe4, 0x39, 0x30, 0xcd, 0x39, 0xcf, 0x19, 0x06, 0x39, 0x67, 0xa4, 0xc8, 0x03, 0x2e, 0xf2,
	0x30, 0xc7, 0xa2, 0x14, 0x5c, 0xf1, 0xd0, 0x3c, 0x22, 0x25, 0x95, 0xa1, 0x28, 0xd3, 0x10, 0x85,
	0xc8, 0x50, 0x11, 0xca, 0xa4, 0x5e, 0x72, 0x91, 0x58, 0x15, 0xd4, 0xb4, 0x07, 0xd6, 0x49, 0x94,
	0xe9, 0xf0, 0x45, 0x4e, 0xd5, 0xe7, 0x6a, 0x1e, 0xa4, 0x7c, 0x15, 0x1a, 0xe7, 0xb0, 0x86, 0xe6,
	0xd5, 0x22, 0x2c, 0xd5, 0xba, 0x44, 0x19, 0x66, 0x95, 0x20, 0x8a, 0xf2, 0x62, 0xb3, 0x30, 0x36,
	0xfe, 0x25, 0xb8, 0x31, 0x2a, 0xb1, 0xbe, 0x2a, 0x16, 0xdc, 0x3b, 0x83, 0xae, 0xd0, 0x22, 0xc9,
	0x90, 0x91, 0xf5, 0xc0, 0x19, 0x39, 0xe3, 0xee, 0xe9, 0xc3, 0xc0, 0x9e, 0xd4, 0x58, 0x06, 0x91,
	0xb5, 0x88, 0xa1, 0xa6, 0x23, 0x0d, 0xfb, 0x53, 0x70, 0x23, 0x9c, 0x57, 0x79, 0x6d, 0xf4, 0x04,
	0xfe, 0x97, 0x8a, 0xa4, 0xcb, 0x04, 0x0b, 0x25, 0x28, 0xca, 0x81, 0x33, 0xea, 0x8c, 0xdd, 0xb8,
	0x57, 0x17, 0xcf, 0x4d, 0xcd, 0x7b, 0x00, 0xc7, 0x26, 0xd2, 0xe0, 0x60, 0xe4, 0x8c, 0xdd, 0xd8,
	0x2a, 0xff, 0xa7, 0x03, 0xbd, 0xf7, 0x15, 0x57, 0xe4, 0x82, 0x50, 0x56, 0x09, 0xf4, 0x26, 0x00,
	0x37, 0x94, 0xb3, 0xfa, 0x4c, 0x63, 0xd5, 0x3d, 0xf5, 0x83, 0x6d, 0xfe, 0xa0, 0x4d, 0x07, 0x1f,
	0x1b, 0x34, 0x6e, 0xed, 0x1a, 0x5e, 0x82, 0xbb, 0x79, 0xe0, 0x0d, 0xe0, 0x3f, 0x59, 0xcd, 0xbf,
	0x60, 0xaa, 0xea, 0x8c, 0x6e, 0xdc, 0x48, 0x6f, 0x04, 0xdd, 0x0c, 0x65, 0x2a, 0x68, 0xa9, 0x41,
	0xdb, 0x58, 0xbb, 0xe4, 0xff, 0x76, 0x00, 0x26, 0x24, 0x8b, 0xf1, 0x6b, 0x85, 0x52, 0x79, 0x33,
	0xe8, 0x2f, 0x28, 0xb2, 0x2c, 0xd9, 0xeb, 0xf0, 0x69, 0xbb, 0xc3, 0xed, 0x8e, 0xe0, 0x42, 0xe3,
	0xdb, 0x26, 0xef, 0x2c, 0x76, 0xb4, 0x1c, 0x4e, 0xe1, 0x64, 0x17, 0xf1, 0xee, 0xc1, 0x51, 0x0d,
	0xd9, 0x66, 0x8d, 0xf8, 0x8b, 0x56, 0xdf, 0x41, 0xd7, 0x1e, 0x5a, 0x7f, 0x94, 0x47, 0x00, 0xc2,
	0xc8, 0x84, 0x36, 0x5e, 0xae, 0xad, 0x5c, 0x65, 0xde, 0x63, 0xe8, 0x49, 0x14, 0x37, 0xb4, 0xc8,
	0x93, 0x8c, 0x28, 0xd2, 0x18, 0xda, 0x5a, 0x44, 0x14, 0xf1, 0x7f, 0x38, 0xd0, 0x8b, 0x51, 0xf2,
	0x4a, 0xa4, 0xd8, 0x7c, 0x67, 0x61, 0x75, 0xa2, 0xe7, 0xcc, 0xba, 0xf6, 0x9a, 0xe2, 0x87, 0x75,
	0x89, 0x3b, 0x50, 0x41, 0x56, 0x68, 0x9d, 0x37, 0xd0, 0x5b, 0xb2, 0x42, 0x9d, 0x91, 0x7f, 0x2b,
	0x50, 0x0c, 0x3a, 0x26, 0x63, 0x2d, 0x6e, 0x67, 0x3c, 0xdc, 0xcf, 0xc8, 0xe1, 0x70, 0x8a, 0xac,
	0xf4, 0x9e, 0xc1, 0x11, 0xa3, 0xc5, 0xb2, 0x79, 0xf9, 0xf7, 0xdb, 0x2f, 0x5f, 0x03, 0xc1, 0x35,
	0x2d, 0x96, 0xb1, 0x61, 0x86, 0x67, 0x70, 0xa8, 0xe5, 0x6d, 0x7b, 0x67, 0xcf, 0xde, 0xeb, 0x43,
	0xa7, 0x12, 0xcd, 0x80, 0xea, 0xa5, 0x1f, 0x41, 0xff, 0x9a, 0xa7, 0x84, 0xd1, 0xef, 0x98, 0xbd,
	0x41, 0x29, 0x49, 0x8e, 0x7a, 0x92, 0x99, 0xae, 0x35, 0xf9, 0xad, 0xd2, 0x73, 0xb6, 0x32, 0x88,
	0x75, 0x68, 0xe4, 0x84, 0xc1, 0x49, 0xca, 0x57, 0xad, 0x26, 0x27, 0x77, 0xcf, 0xf5, 0x25, 0x8f,
	0xcc, 0x1d, 0x9f, 0xe9, 0xab, 0x36, 0x73, 0x3e, 0xbd, 0xfa, 0x97, 0xdf, 0xc5, 0xcb, 0xed, 0xf2,
	0xd7, 0x41, 0x27, 0x9e, 0xbd, 0x9e, 0x1f, 0xd7, 0x3b, 0x9e, 0xff, 0x09, 0x00, 0x00, 0xff, 0xff,
	0x0c, 0x49, 0x28, 0x80, 0x7e, 0x04, 0x00, 0x00,
}
