// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/monitoredres/monitored_resource.proto
// DO NOT EDIT!

/*
Package monitoredres is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/api/monitoredres/monitored_resource.proto

It has these top-level messages:
	MonitoredResourceDescriptor
	MonitoredResource
*/
package monitoredres // import "google.golang.org/genproto/googleapis/api/monitoredres"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_api "google.golang.org/genproto/googleapis/api/label"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// An object that describes the schema of a [MonitoredResource][google.api.MonitoredResource] object using a
// type name and a set of labels.  For example, the monitored resource
// descriptor for Google Compute Engine VM instances has a type of
// `"gce_instance"` and specifies the use of the labels `"instance_id"` and
// `"zone"` to identify particular VM instances.
//
// Different APIs can support different monitored resource types. APIs generally
// provide a `list` method that returns the monitored resource descriptors used
// by the API.
type MonitoredResourceDescriptor struct {
	// Optional. The resource name of the monitored resource descriptor:
	// `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where
	// {type} is the value of the `type` field in this object and
	// {project_id} is a project ID that provides API-specific context for
	// accessing the type.  APIs that do not use project information can use the
	// resource name format `"monitoredResourceDescriptors/{type}"`.
	Name string `protobuf:"bytes,5,opt,name=name" json:"name,omitempty"`
	// Required. The monitored resource type. For example, the type
	// `"cloudsql_database"` represents databases in Google Cloud SQL.
	// The maximum length of this value is 256 characters.
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Optional. A concise name for the monitored resource type that might be
	// displayed in user interfaces. It should be a Title Cased Noun Phrase,
	// without any article or other determiners. For example,
	// `"Google Cloud SQL Database"`.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// Optional. A detailed description of the monitored resource type that might
	// be used in documentation.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// Required. A set of labels used to describe instances of this monitored
	// resource type. For example, an individual Google Cloud SQL database is
	// identified by values for the labels `"database_id"` and `"zone"`.
	Labels []*google_api.LabelDescriptor `protobuf:"bytes,4,rep,name=labels" json:"labels,omitempty"`
}

func (m *MonitoredResourceDescriptor) Reset()                    { *m = MonitoredResourceDescriptor{} }
func (m *MonitoredResourceDescriptor) String() string            { return proto.CompactTextString(m) }
func (*MonitoredResourceDescriptor) ProtoMessage()               {}
func (*MonitoredResourceDescriptor) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *MonitoredResourceDescriptor) GetLabels() []*google_api.LabelDescriptor {
	if m != nil {
		return m.Labels
	}
	return nil
}

// An object representing a resource that can be used for monitoring, logging,
// billing, or other purposes. Examples include virtual machine instances,
// databases, and storage devices such as disks. The `type` field identifies a
// [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor] object that describes the resource's
// schema. Information in the `labels` field identifies the actual resource and
// its attributes according to the schema. For example, a particular Compute
// Engine VM instance could be represented by the following object, because the
// [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor] for `"gce_instance"` has labels
// `"instance_id"` and `"zone"`:
//
//     { "type": "gce_instance",
//       "labels": { "instance_id": "12345678901234",
//                   "zone": "us-central1-a" }}
type MonitoredResource struct {
	// Required. The monitored resource type. This field must match
	// the `type` field of a [MonitoredResourceDescriptor][google.api.MonitoredResourceDescriptor] object. For
	// example, the type of a Cloud SQL database is `"cloudsql_database"`.
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Required. Values for all of the labels listed in the associated monitored
	// resource descriptor. For example, Cloud SQL databases use the labels
	// `"database_id"` and `"zone"`.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *MonitoredResource) Reset()                    { *m = MonitoredResource{} }
func (m *MonitoredResource) String() string            { return proto.CompactTextString(m) }
func (*MonitoredResource) ProtoMessage()               {}
func (*MonitoredResource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *MonitoredResource) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func init() {
	proto.RegisterType((*MonitoredResourceDescriptor)(nil), "google.api.MonitoredResourceDescriptor")
	proto.RegisterType((*MonitoredResource)(nil), "google.api.MonitoredResource")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/monitoredres/monitored_resource.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 326 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x92, 0xcb, 0x4a, 0xfb, 0x40,
	0x14, 0xc6, 0x99, 0xf4, 0x02, 0xff, 0x93, 0x3f, 0xa2, 0x83, 0x48, 0x68, 0x37, 0xb5, 0xab, 0xba,
	0x49, 0xc0, 0x82, 0x78, 0x59, 0xb5, 0x28, 0x22, 0x78, 0x29, 0x5d, 0xba, 0x29, 0xd3, 0x76, 0x08,
	0x83, 0xd3, 0x9c, 0x61, 0x26, 0x15, 0xf2, 0x3a, 0x82, 0xcf, 0xe1, 0x6b, 0xb9, 0x94, 0xb9, 0xd4,
	0x14, 0xea, 0x42, 0xdc, 0x84, 0x33, 0xdf, 0xf9, 0xe6, 0xf7, 0x9d, 0x93, 0x04, 0x9e, 0x72, 0xc4,
	0x5c, 0xf2, 0x34, 0x47, 0xc9, 0x8a, 0x3c, 0x45, 0x9d, 0x67, 0x39, 0x2f, 0x94, 0xc6, 0x12, 0x33,
	0xdf, 0x62, 0x4a, 0x98, 0x8c, 0x29, 0x91, 0xad, 0xb0, 0x10, 0x25, 0x6a, 0xbe, 0xd4, 0xdc, 0xd4,
	0x87, 0x99, 0xe6, 0x06, 0xd7, 0x7a, 0xc1, 0x53, 0x77, 0x89, 0x42, 0x00, 0x32, 0x25, 0x3a, 0x57,
	0xbf, 0x87, 0x4b, 0x36, 0xe7, 0xd2, 0x3f, 0x3d, 0xa8, 0xff, 0x41, 0xa0, 0xfb, 0xb0, 0x49, 0x99,
	0x86, 0x90, 0x6b, 0x6e, 0x16, 0x5a, 0xa8, 0x12, 0x35, 0xa5, 0xd0, 0x2c, 0xd8, 0x8a, 0x27, 0xad,
	0x1e, 0x19, 0xfc, 0x9b, 0xba, 0xda, 0x6a, 0x65, 0xa5, 0x78, 0x42, 0xbc, 0x66, 0x6b, 0x7a, 0x0c,
	0xff, 0x97, 0xc2, 0x28, 0xc9, 0xaa, 0x99, 0xf3, 0x47, 0xae, 0x17, 0x07, 0xed, 0xd1, 0x5e, 0xeb,
	0x41, 0xbc, 0x0c, 0x60, 0x81, 0x45, 0xd2, 0x08, 0x8e, 0x5a, 0xa2, 0x43, 0x68, 0xbb, 0xd9, 0x4c,
	0xd2, 0xec, 0x35, 0x06, 0xf1, 0x69, 0x37, 0xad, 0xd7, 0x4c, 0xef, 0x6d, 0xa7, 0x9e, 0x6c, 0x1a,
	0xac, 0xfd, 0x77, 0x02, 0x07, 0x3b, 0x1b, 0xfc, 0x38, 0xe3, 0xe8, 0x1b, 0x1f, 0x39, 0xfc, 0xc9,
	0x36, 0x7e, 0x07, 0xe1, 0x03, 0xcd, 0x4d, 0x51, 0xea, 0x6a, 0x13, 0xd6, 0xb9, 0x80, 0x78, 0x4b,
	0xa6, 0xfb, 0xd0, 0x78, 0xe1, 0x55, 0x08, 0xb1, 0x25, 0x3d, 0x84, 0xd6, 0x2b, 0x93, 0xeb, 0xcd,
	0x0b, 0xf0, 0x87, 0xcb, 0xe8, 0x9c, 0x8c, 0x25, 0xec, 0x2d, 0x70, 0xb5, 0x15, 0x39, 0x3e, 0xda,
	0xc9, 0x9c, 0xd8, 0x6f, 0x32, 0x21, 0xcf, 0x67, 0x7f, 0xfb, 0x5f, 0x3e, 0x09, 0x79, 0x8b, 0x9a,
	0xb7, 0xa3, 0xc9, 0xdd, 0xbc, 0xed, 0xcc, 0xc3, 0xaf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x6b, 0x87,
	0xa2, 0x37, 0x7a, 0x02, 0x00, 0x00,
}
