// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/cloud/runtimeconfig/v1beta1/runtimeconfig.proto
// DO NOT EDIT!

package google_cloud_runtimeconfig_v1beta1 // import "google.golang.org/genproto/googleapis/cloud/runtimeconfig/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf4 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Request for the `ListConfigs()` method.
type ListConfigsRequest struct {
	// The [project ID](https://support.google.com/cloud/answer/6158840?hl=en&ref_topic=6158848)
	// for this request, in the format `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Specifies the number of results to return per page. If there are fewer
	// elements than the specified number, returns all elements.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Specifies a page token to use. Set `pageToken` to a `nextPageToken`
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListConfigsRequest) Reset()                    { *m = ListConfigsRequest{} }
func (m *ListConfigsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListConfigsRequest) ProtoMessage()               {}
func (*ListConfigsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

// `ListConfigs()` returns the following response. The order of returned
// objects is arbitrary; that is, it is not ordered in any particular way.
type ListConfigsResponse struct {
	// A list of the configurations in the project. The order of returned
	// objects is arbitrary; that is, it is not ordered in any particular way.
	Configs []*RuntimeConfig `protobuf:"bytes,1,rep,name=configs" json:"configs,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `pageSize`, use the `nextPageToken`
	// as a value for the query parameter `pageToken` in the next list request.
	// Subsequent list requests will have their own `nextPageToken` to continue
	// paging through the results
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListConfigsResponse) Reset()                    { *m = ListConfigsResponse{} }
func (m *ListConfigsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListConfigsResponse) ProtoMessage()               {}
func (*ListConfigsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *ListConfigsResponse) GetConfigs() []*RuntimeConfig {
	if m != nil {
		return m.Configs
	}
	return nil
}

// Gets a RuntimeConfig resource.
type GetConfigRequest struct {
	// The name of the RuntimeConfig resource to retrieve, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
}

func (m *GetConfigRequest) Reset()                    { *m = GetConfigRequest{} }
func (m *GetConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetConfigRequest) ProtoMessage()               {}
func (*GetConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

// Creates a RuntimeConfig resource.
type CreateConfigRequest struct {
	// The [project ID](https://support.google.com/cloud/answer/6158840?hl=en&ref_topic=6158848)
	// for this request, in the format `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The RuntimeConfig to create.
	Config *RuntimeConfig `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
	// An optional but recommended unique `request_id`. If the server
	// receives two `create()` requests  with the same
	// `request_id`, then the second request will be ignored and the
	// first resource created and stored in the backend is returned.
	// Empty `request_id` fields are ignored.
	//
	// It is responsibility of the client to ensure uniqueness of the
	// `request_id` strings.
	//
	// `request_id` strings are limited to 64 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId" json:"request_id,omitempty"`
}

func (m *CreateConfigRequest) Reset()                    { *m = CreateConfigRequest{} }
func (m *CreateConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateConfigRequest) ProtoMessage()               {}
func (*CreateConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *CreateConfigRequest) GetConfig() *RuntimeConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

// Request message for `UpdateConfig()` method.
type UpdateConfigRequest struct {
	// The name of the RuntimeConfig resource to update, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The config resource to update.
	Config *RuntimeConfig `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
}

func (m *UpdateConfigRequest) Reset()                    { *m = UpdateConfigRequest{} }
func (m *UpdateConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateConfigRequest) ProtoMessage()               {}
func (*UpdateConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *UpdateConfigRequest) GetConfig() *RuntimeConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

// Request for the `DeleteConfig()` method.
type DeleteConfigRequest struct {
	// The RuntimeConfig resource to delete, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteConfigRequest) Reset()                    { *m = DeleteConfigRequest{} }
func (m *DeleteConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteConfigRequest) ProtoMessage()               {}
func (*DeleteConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

// Request for the `ListVariables()` method.
type ListVariablesRequest struct {
	// The path to the RuntimeConfig resource for which you want to list variables.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Filters variables by matching the specified filter. For example:
	//
	// `projects/example-project/config/[CONFIG_NAME]/variables/example-variable`.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// Specifies the number of results to return per page. If there are fewer
	// elements than the specified number, returns all elements.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Specifies a page token to use. Set `pageToken` to a `nextPageToken`
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListVariablesRequest) Reset()                    { *m = ListVariablesRequest{} }
func (m *ListVariablesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListVariablesRequest) ProtoMessage()               {}
func (*ListVariablesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

// Response for the `ListVariables()` method.
type ListVariablesResponse struct {
	// A list of variables and their values. The order of returned variable
	// objects is arbitrary.
	Variables []*Variable `protobuf:"bytes,1,rep,name=variables" json:"variables,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `pageSize`, use the `nextPageToken`
	// as a value for the query parameter `pageToken` in the next list request.
	// Subsequent list requests will have their own `nextPageToken` to continue
	// paging through the results
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListVariablesResponse) Reset()                    { *m = ListVariablesResponse{} }
func (m *ListVariablesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListVariablesResponse) ProtoMessage()               {}
func (*ListVariablesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *ListVariablesResponse) GetVariables() []*Variable {
	if m != nil {
		return m.Variables
	}
	return nil
}

// Request for the `WatchVariable()` method.
type WatchVariableRequest struct {
	// The name of the variable to watch, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// If specified, checks the current timestamp of the variable and if the
	// current timestamp is newer than `newerThan` timestamp, the method returns
	// immediately.
	//
	// If not specified or the variable has an older timestamp, the watcher waits
	// for a the value to change before returning.
	NewerThan *google_protobuf2.Timestamp `protobuf:"bytes,4,opt,name=newer_than,json=newerThan" json:"newer_than,omitempty"`
}

func (m *WatchVariableRequest) Reset()                    { *m = WatchVariableRequest{} }
func (m *WatchVariableRequest) String() string            { return proto.CompactTextString(m) }
func (*WatchVariableRequest) ProtoMessage()               {}
func (*WatchVariableRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *WatchVariableRequest) GetNewerThan() *google_protobuf2.Timestamp {
	if m != nil {
		return m.NewerThan
	}
	return nil
}

// Request for the `GetVariable()` method.
type GetVariableRequest struct {
	// The name of the variable to return, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIBLE_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetVariableRequest) Reset()                    { *m = GetVariableRequest{} }
func (m *GetVariableRequest) String() string            { return proto.CompactTextString(m) }
func (*GetVariableRequest) ProtoMessage()               {}
func (*GetVariableRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

// Request for the `CreateVariable()` method.
type CreateVariableRequest struct {
	// The path to the RutimeConfig resource that this variable should belong to.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The variable to create.
	Variable *Variable `protobuf:"bytes,2,opt,name=variable" json:"variable,omitempty"`
	// An optional but recommended unique `request_id`. If the server
	// receives two `create()` requests  with the same
	// `request_id`, then the second request will be ignored and the
	// first resource created and stored in the backend is returned.
	// Empty `request_id` fields are ignored.
	//
	// It is responsibility of the client to ensure uniqueness of the
	// `request_id` strings.
	//
	// `request_id` strings are limited to 64 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId" json:"request_id,omitempty"`
}

func (m *CreateVariableRequest) Reset()                    { *m = CreateVariableRequest{} }
func (m *CreateVariableRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateVariableRequest) ProtoMessage()               {}
func (*CreateVariableRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *CreateVariableRequest) GetVariable() *Variable {
	if m != nil {
		return m.Variable
	}
	return nil
}

// Request for the `UpdateVariable()` method.
type UpdateVariableRequest struct {
	// The name of the variable to update, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIABLE_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The variable to update.
	Variable *Variable `protobuf:"bytes,2,opt,name=variable" json:"variable,omitempty"`
}

func (m *UpdateVariableRequest) Reset()                    { *m = UpdateVariableRequest{} }
func (m *UpdateVariableRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateVariableRequest) ProtoMessage()               {}
func (*UpdateVariableRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *UpdateVariableRequest) GetVariable() *Variable {
	if m != nil {
		return m.Variable
	}
	return nil
}

// Request for the `DeleteVariable()` method.
type DeleteVariableRequest struct {
	// The name of the variable to delete, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIABLE_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Set to `true` to recursively delete multiple variables with the same
	// prefix.
	Recursive bool `protobuf:"varint,2,opt,name=recursive" json:"recursive,omitempty"`
}

func (m *DeleteVariableRequest) Reset()                    { *m = DeleteVariableRequest{} }
func (m *DeleteVariableRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteVariableRequest) ProtoMessage()               {}
func (*DeleteVariableRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

// Request for the `ListWaiters()` method.
type ListWaitersRequest struct {
	// The path to the configuration for which you want to get a list of waiters.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Specifies the number of results to return per page. If there are fewer
	// elements than the specified number, returns all elements.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Specifies a page token to use. Set `pageToken` to a `nextPageToken`
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListWaitersRequest) Reset()                    { *m = ListWaitersRequest{} }
func (m *ListWaitersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListWaitersRequest) ProtoMessage()               {}
func (*ListWaitersRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

// Response for the `ListWaiters()` method.
// Order of returned waiter objects is arbitrary.
type ListWaitersResponse struct {
	// Found waiters in the project.
	Waiters []*Waiter `protobuf:"bytes,1,rep,name=waiters" json:"waiters,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `pageSize`, use the `nextPageToken`
	// as a value for the query parameter `pageToken` in the next list request.
	// Subsequent list requests will have their own `nextPageToken` to continue
	// paging through the results
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListWaitersResponse) Reset()                    { *m = ListWaitersResponse{} }
func (m *ListWaitersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListWaitersResponse) ProtoMessage()               {}
func (*ListWaitersResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

func (m *ListWaitersResponse) GetWaiters() []*Waiter {
	if m != nil {
		return m.Waiters
	}
	return nil
}

// Request for the `GetWaiter()` method.
type GetWaiterRequest struct {
	// The fully-qualified name of the Waiter resource object to retrieve, in the
	// format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/waiters/[WAITER_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetWaiterRequest) Reset()                    { *m = GetWaiterRequest{} }
func (m *GetWaiterRequest) String() string            { return proto.CompactTextString(m) }
func (*GetWaiterRequest) ProtoMessage()               {}
func (*GetWaiterRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

// Request message for `CreateWaiter()` method.
type CreateWaiterRequest struct {
	// The path to the configuration that will own the waiter.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The Waiter resource to create.
	Waiter *Waiter `protobuf:"bytes,2,opt,name=waiter" json:"waiter,omitempty"`
	// An optional but recommended unique `request_id`. If the server
	// receives two `create()` requests  with the same
	// `request_id`, then the second request will be ignored and the
	// first resource created and stored in the backend is returned.
	// Empty `request_id` fields are ignored.
	//
	// It is responsibility of the client to ensure uniqueness of the
	// `request_id` strings.
	//
	// `request_id` strings are limited to 64 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId" json:"request_id,omitempty"`
}

func (m *CreateWaiterRequest) Reset()                    { *m = CreateWaiterRequest{} }
func (m *CreateWaiterRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateWaiterRequest) ProtoMessage()               {}
func (*CreateWaiterRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

func (m *CreateWaiterRequest) GetWaiter() *Waiter {
	if m != nil {
		return m.Waiter
	}
	return nil
}

// Request for the `DeleteWaiter()` method.
type DeleteWaiterRequest struct {
	// The Waiter resource to delete, in the format:
	//
	//  `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/waiters/[WAITER_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteWaiterRequest) Reset()                    { *m = DeleteWaiterRequest{} }
func (m *DeleteWaiterRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteWaiterRequest) ProtoMessage()               {}
func (*DeleteWaiterRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{17} }

func init() {
	proto.RegisterType((*ListConfigsRequest)(nil), "google.cloud.runtimeconfig.v1beta1.ListConfigsRequest")
	proto.RegisterType((*ListConfigsResponse)(nil), "google.cloud.runtimeconfig.v1beta1.ListConfigsResponse")
	proto.RegisterType((*GetConfigRequest)(nil), "google.cloud.runtimeconfig.v1beta1.GetConfigRequest")
	proto.RegisterType((*CreateConfigRequest)(nil), "google.cloud.runtimeconfig.v1beta1.CreateConfigRequest")
	proto.RegisterType((*UpdateConfigRequest)(nil), "google.cloud.runtimeconfig.v1beta1.UpdateConfigRequest")
	proto.RegisterType((*DeleteConfigRequest)(nil), "google.cloud.runtimeconfig.v1beta1.DeleteConfigRequest")
	proto.RegisterType((*ListVariablesRequest)(nil), "google.cloud.runtimeconfig.v1beta1.ListVariablesRequest")
	proto.RegisterType((*ListVariablesResponse)(nil), "google.cloud.runtimeconfig.v1beta1.ListVariablesResponse")
	proto.RegisterType((*WatchVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.WatchVariableRequest")
	proto.RegisterType((*GetVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.GetVariableRequest")
	proto.RegisterType((*CreateVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.CreateVariableRequest")
	proto.RegisterType((*UpdateVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.UpdateVariableRequest")
	proto.RegisterType((*DeleteVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.DeleteVariableRequest")
	proto.RegisterType((*ListWaitersRequest)(nil), "google.cloud.runtimeconfig.v1beta1.ListWaitersRequest")
	proto.RegisterType((*ListWaitersResponse)(nil), "google.cloud.runtimeconfig.v1beta1.ListWaitersResponse")
	proto.RegisterType((*GetWaiterRequest)(nil), "google.cloud.runtimeconfig.v1beta1.GetWaiterRequest")
	proto.RegisterType((*CreateWaiterRequest)(nil), "google.cloud.runtimeconfig.v1beta1.CreateWaiterRequest")
	proto.RegisterType((*DeleteWaiterRequest)(nil), "google.cloud.runtimeconfig.v1beta1.DeleteWaiterRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for RuntimeConfigManager service

type RuntimeConfigManagerClient interface {
	// Lists all the RuntimeConfig resources within project.
	ListConfigs(ctx context.Context, in *ListConfigsRequest, opts ...grpc.CallOption) (*ListConfigsResponse, error)
	// Gets information about a RuntimeConfig resource.
	GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error)
	// Creates a new RuntimeConfig resource. The configuration name must be
	// unique within project.
	CreateConfig(ctx context.Context, in *CreateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error)
	// Updates a RuntimeConfig resource. The configuration must exist beforehand.
	UpdateConfig(ctx context.Context, in *UpdateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error)
	// Deletes a RuntimeConfig resource.
	DeleteConfig(ctx context.Context, in *DeleteConfigRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error)
	// Lists variables within given a configuration, matching any provided filters.
	// This only lists variable names, not the values.
	ListVariables(ctx context.Context, in *ListVariablesRequest, opts ...grpc.CallOption) (*ListVariablesResponse, error)
	// Gets information about a single variable.
	GetVariable(ctx context.Context, in *GetVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Watches a specific variable and waits for a change in the variable's value.
	// When there is a change, this method returns the new value or times out.
	//
	// If a variable is deleted while being watched, the `variableState` state is
	// set to `DELETED` and the method returns the last known variable `value`.
	//
	// If you set the deadline for watching to a larger value than internal timeout
	// (60 seconds), the current variable value is returned and the `variableState`
	// will be `VARIABLE_STATE_UNSPECIFIED`.
	//
	// To learn more about creating a watcher, read the
	// [Watching a Variable for Changes](/deployment-manager/runtime-configurator/watching-a-variable)
	// documentation.
	WatchVariable(ctx context.Context, in *WatchVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Creates a variable within the given configuration. You cannot create
	// a variable with a name that is a prefix of an existing variable name, or a
	// name that has an existing variable name as a prefix.
	//
	// To learn more about creating a variable, read the
	// [Setting and Getting Data](/deployment-manager/runtime-configurator/set-and-get-variables)
	// documentation.
	CreateVariable(ctx context.Context, in *CreateVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Updates an existing variable with a new value.
	UpdateVariable(ctx context.Context, in *UpdateVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Deletes a variable or multiple variables.
	//
	// If you specify a variable name, then that variable is deleted. If you
	// specify a prefix and `recursive` is true, then all variables with that
	// prefix are deleted. You must set a `recursive` to true if you delete
	// variables by prefix.
	DeleteVariable(ctx context.Context, in *DeleteVariableRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error)
	// List waiters within the given configuration.
	ListWaiters(ctx context.Context, in *ListWaitersRequest, opts ...grpc.CallOption) (*ListWaitersResponse, error)
	// Gets information about a single waiter.
	GetWaiter(ctx context.Context, in *GetWaiterRequest, opts ...grpc.CallOption) (*Waiter, error)
	// Creates a Waiter resource. This operation returns a long-running Operation
	// resource which can be polled for completion. However, a waiter with the
	// given name will exist (and can be retrieved) prior to the operation
	// completing. If the operation fails, the failed Waiter resource will
	// still exist and must be deleted prior to subsequent creation attempts.
	CreateWaiter(ctx context.Context, in *CreateWaiterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes the waiter with the specified name.
	DeleteWaiter(ctx context.Context, in *DeleteWaiterRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error)
}

type runtimeConfigManagerClient struct {
	cc *grpc.ClientConn
}

func NewRuntimeConfigManagerClient(cc *grpc.ClientConn) RuntimeConfigManagerClient {
	return &runtimeConfigManagerClient{cc}
}

func (c *runtimeConfigManagerClient) ListConfigs(ctx context.Context, in *ListConfigsRequest, opts ...grpc.CallOption) (*ListConfigsResponse, error) {
	out := new(ListConfigsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListConfigs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error) {
	out := new(RuntimeConfig)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) CreateConfig(ctx context.Context, in *CreateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error) {
	out := new(RuntimeConfig)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) UpdateConfig(ctx context.Context, in *UpdateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error) {
	out := new(RuntimeConfig)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) DeleteConfig(ctx context.Context, in *DeleteConfigRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error) {
	out := new(google_protobuf4.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) ListVariables(ctx context.Context, in *ListVariablesRequest, opts ...grpc.CallOption) (*ListVariablesResponse, error) {
	out := new(ListVariablesResponse)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListVariables", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) GetVariable(ctx context.Context, in *GetVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetVariable", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) WatchVariable(ctx context.Context, in *WatchVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/WatchVariable", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) CreateVariable(ctx context.Context, in *CreateVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateVariable", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) UpdateVariable(ctx context.Context, in *UpdateVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateVariable", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) DeleteVariable(ctx context.Context, in *DeleteVariableRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error) {
	out := new(google_protobuf4.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteVariable", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) ListWaiters(ctx context.Context, in *ListWaitersRequest, opts ...grpc.CallOption) (*ListWaitersResponse, error) {
	out := new(ListWaitersResponse)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListWaiters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) GetWaiter(ctx context.Context, in *GetWaiterRequest, opts ...grpc.CallOption) (*Waiter, error) {
	out := new(Waiter)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetWaiter", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) CreateWaiter(ctx context.Context, in *CreateWaiterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateWaiter", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) DeleteWaiter(ctx context.Context, in *DeleteWaiterRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error) {
	out := new(google_protobuf4.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteWaiter", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for RuntimeConfigManager service

type RuntimeConfigManagerServer interface {
	// Lists all the RuntimeConfig resources within project.
	ListConfigs(context.Context, *ListConfigsRequest) (*ListConfigsResponse, error)
	// Gets information about a RuntimeConfig resource.
	GetConfig(context.Context, *GetConfigRequest) (*RuntimeConfig, error)
	// Creates a new RuntimeConfig resource. The configuration name must be
	// unique within project.
	CreateConfig(context.Context, *CreateConfigRequest) (*RuntimeConfig, error)
	// Updates a RuntimeConfig resource. The configuration must exist beforehand.
	UpdateConfig(context.Context, *UpdateConfigRequest) (*RuntimeConfig, error)
	// Deletes a RuntimeConfig resource.
	DeleteConfig(context.Context, *DeleteConfigRequest) (*google_protobuf4.Empty, error)
	// Lists variables within given a configuration, matching any provided filters.
	// This only lists variable names, not the values.
	ListVariables(context.Context, *ListVariablesRequest) (*ListVariablesResponse, error)
	// Gets information about a single variable.
	GetVariable(context.Context, *GetVariableRequest) (*Variable, error)
	// Watches a specific variable and waits for a change in the variable's value.
	// When there is a change, this method returns the new value or times out.
	//
	// If a variable is deleted while being watched, the `variableState` state is
	// set to `DELETED` and the method returns the last known variable `value`.
	//
	// If you set the deadline for watching to a larger value than internal timeout
	// (60 seconds), the current variable value is returned and the `variableState`
	// will be `VARIABLE_STATE_UNSPECIFIED`.
	//
	// To learn more about creating a watcher, read the
	// [Watching a Variable for Changes](/deployment-manager/runtime-configurator/watching-a-variable)
	// documentation.
	WatchVariable(context.Context, *WatchVariableRequest) (*Variable, error)
	// Creates a variable within the given configuration. You cannot create
	// a variable with a name that is a prefix of an existing variable name, or a
	// name that has an existing variable name as a prefix.
	//
	// To learn more about creating a variable, read the
	// [Setting and Getting Data](/deployment-manager/runtime-configurator/set-and-get-variables)
	// documentation.
	CreateVariable(context.Context, *CreateVariableRequest) (*Variable, error)
	// Updates an existing variable with a new value.
	UpdateVariable(context.Context, *UpdateVariableRequest) (*Variable, error)
	// Deletes a variable or multiple variables.
	//
	// If you specify a variable name, then that variable is deleted. If you
	// specify a prefix and `recursive` is true, then all variables with that
	// prefix are deleted. You must set a `recursive` to true if you delete
	// variables by prefix.
	DeleteVariable(context.Context, *DeleteVariableRequest) (*google_protobuf4.Empty, error)
	// List waiters within the given configuration.
	ListWaiters(context.Context, *ListWaitersRequest) (*ListWaitersResponse, error)
	// Gets information about a single waiter.
	GetWaiter(context.Context, *GetWaiterRequest) (*Waiter, error)
	// Creates a Waiter resource. This operation returns a long-running Operation
	// resource which can be polled for completion. However, a waiter with the
	// given name will exist (and can be retrieved) prior to the operation
	// completing. If the operation fails, the failed Waiter resource will
	// still exist and must be deleted prior to subsequent creation attempts.
	CreateWaiter(context.Context, *CreateWaiterRequest) (*google_longrunning.Operation, error)
	// Deletes the waiter with the specified name.
	DeleteWaiter(context.Context, *DeleteWaiterRequest) (*google_protobuf4.Empty, error)
}

func RegisterRuntimeConfigManagerServer(s *grpc.Server, srv RuntimeConfigManagerServer) {
	s.RegisterService(&_RuntimeConfigManager_serviceDesc, srv)
}

func _RuntimeConfigManager_ListConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).ListConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).ListConfigs(ctx, req.(*ListConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_GetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).GetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).GetConfig(ctx, req.(*GetConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_CreateConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).CreateConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).CreateConfig(ctx, req.(*CreateConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_UpdateConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).UpdateConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).UpdateConfig(ctx, req.(*UpdateConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_DeleteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).DeleteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).DeleteConfig(ctx, req.(*DeleteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_ListVariables_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVariablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).ListVariables(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListVariables",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).ListVariables(ctx, req.(*ListVariablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_GetVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).GetVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).GetVariable(ctx, req.(*GetVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_WatchVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WatchVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).WatchVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/WatchVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).WatchVariable(ctx, req.(*WatchVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_CreateVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).CreateVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).CreateVariable(ctx, req.(*CreateVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_UpdateVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).UpdateVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).UpdateVariable(ctx, req.(*UpdateVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_DeleteVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).DeleteVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).DeleteVariable(ctx, req.(*DeleteVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_ListWaiters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWaitersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).ListWaiters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListWaiters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).ListWaiters(ctx, req.(*ListWaitersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_GetWaiter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWaiterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).GetWaiter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetWaiter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).GetWaiter(ctx, req.(*GetWaiterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_CreateWaiter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWaiterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).CreateWaiter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateWaiter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).CreateWaiter(ctx, req.(*CreateWaiterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_DeleteWaiter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWaiterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).DeleteWaiter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteWaiter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).DeleteWaiter(ctx, req.(*DeleteWaiterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RuntimeConfigManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager",
	HandlerType: (*RuntimeConfigManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListConfigs",
			Handler:    _RuntimeConfigManager_ListConfigs_Handler,
		},
		{
			MethodName: "GetConfig",
			Handler:    _RuntimeConfigManager_GetConfig_Handler,
		},
		{
			MethodName: "CreateConfig",
			Handler:    _RuntimeConfigManager_CreateConfig_Handler,
		},
		{
			MethodName: "UpdateConfig",
			Handler:    _RuntimeConfigManager_UpdateConfig_Handler,
		},
		{
			MethodName: "DeleteConfig",
			Handler:    _RuntimeConfigManager_DeleteConfig_Handler,
		},
		{
			MethodName: "ListVariables",
			Handler:    _RuntimeConfigManager_ListVariables_Handler,
		},
		{
			MethodName: "GetVariable",
			Handler:    _RuntimeConfigManager_GetVariable_Handler,
		},
		{
			MethodName: "WatchVariable",
			Handler:    _RuntimeConfigManager_WatchVariable_Handler,
		},
		{
			MethodName: "CreateVariable",
			Handler:    _RuntimeConfigManager_CreateVariable_Handler,
		},
		{
			MethodName: "UpdateVariable",
			Handler:    _RuntimeConfigManager_UpdateVariable_Handler,
		},
		{
			MethodName: "DeleteVariable",
			Handler:    _RuntimeConfigManager_DeleteVariable_Handler,
		},
		{
			MethodName: "ListWaiters",
			Handler:    _RuntimeConfigManager_ListWaiters_Handler,
		},
		{
			MethodName: "GetWaiter",
			Handler:    _RuntimeConfigManager_GetWaiter_Handler,
		},
		{
			MethodName: "CreateWaiter",
			Handler:    _RuntimeConfigManager_CreateWaiter_Handler,
		},
		{
			MethodName: "DeleteWaiter",
			Handler:    _RuntimeConfigManager_DeleteWaiter_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/cloud/runtimeconfig/v1beta1/runtimeconfig.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/cloud/runtimeconfig/v1beta1/runtimeconfig.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 1115 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xb4, 0x98, 0xcf, 0x6f, 0x1b, 0x45,
	0x14, 0xc7, 0x35, 0x49, 0x49, 0xe3, 0x97, 0x26, 0xa0, 0xc9, 0x0f, 0x45, 0x0b, 0x95, 0xa2, 0x15,
	0x8a, 0xc2, 0xaa, 0xda, 0x6d, 0x92, 0xaa, 0x4d, 0x0c, 0xe5, 0x90, 0x14, 0x95, 0xf0, 0x43, 0x14,
	0x93, 0xd2, 0x63, 0x34, 0x76, 0x26, 0xeb, 0x05, 0x7b, 0x76, 0x99, 0x1d, 0x27, 0xb4, 0x28, 0x97,
	0x72, 0x03, 0x21, 0x21, 0x71, 0x28, 0x27, 0x0e, 0x48, 0x70, 0x42, 0x88, 0x13, 0x17, 0x44, 0xff,
	0x09, 0x24, 0xfe, 0x02, 0xfe, 0x10, 0xb4, 0xf3, 0x63, 0xbd, 0xeb, 0xd8, 0xf1, 0x6c, 0x08, 0x97,
	0x28, 0x1e, 0xef, 0x7b, 0xef, 0x33, 0x6f, 0xbe, 0x3b, 0xdf, 0x27, 0xc3, 0xc3, 0x30, 0x8e, 0xc3,
	0x0e, 0xf5, 0xc3, 0xb8, 0x43, 0x58, 0xe8, 0xc7, 0x3c, 0x0c, 0x42, 0xca, 0x12, 0x1e, 0x8b, 0x38,
	0x50, 0x5f, 0x91, 0x24, 0x4a, 0x83, 0x56, 0x27, 0xee, 0x1d, 0x06, 0xbc, 0xc7, 0x44, 0xd4, 0xa5,
	0xad, 0x98, 0x1d, 0x45, 0x61, 0x70, 0xbc, 0xde, 0xa4, 0x82, 0xac, 0x97, 0x57, 0x7d, 0x19, 0x8a,
	0x5d, 0x9d, 0x56, 0xc6, 0xf9, 0xe5, 0x27, 0x74, 0x9c, 0xb3, 0x67, 0x57, 0x9a, 0x24, 0x51, 0x90,
	0x52, 0x7e, 0x1c, 0xb5, 0x4c, 0x61, 0xc2, 0x58, 0x2c, 0x88, 0x88, 0x62, 0x96, 0xaa, 0x72, 0xce,
	0x87, 0x97, 0xb0, 0x0b, 0x9a, 0xc6, 0x3d, 0xde, 0xa2, 0x26, 0xe5, 0x8e, 0x5d, 0xca, 0x4e, 0xcc,
	0x42, 0xde, 0x63, 0x2c, 0x62, 0x61, 0x10, 0x27, 0x94, 0x97, 0xb0, 0x36, 0xc3, 0x48, 0xb4, 0x7b,
	0x4d, 0xbf, 0x15, 0x77, 0x03, 0x95, 0x27, 0x90, 0x5f, 0x34, 0x7b, 0x47, 0x41, 0x22, 0x1e, 0x27,
	0x34, 0x0d, 0x68, 0x37, 0x11, 0x8f, 0xd5, 0x5f, 0x1d, 0xf4, 0xfa, 0xf8, 0xa0, 0x0c, 0x3f, 0x15,
	0xa4, 0x9b, 0xf4, 0xff, 0x53, 0xc1, 0x6e, 0x1b, 0xf0, 0x7b, 0x51, 0x2a, 0x76, 0xe5, 0xde, 0xd2,
	0x06, 0xfd, 0xac, 0x47, 0x53, 0x81, 0x97, 0x60, 0x2a, 0x21, 0x9c, 0x32, 0xb1, 0x8c, 0x56, 0xd0,
	0x5a, 0xad, 0xa1, 0x3f, 0xe1, 0x97, 0xa1, 0x96, 0x90, 0x90, 0x1e, 0xa4, 0xd1, 0x13, 0xba, 0x3c,
	0xb1, 0x82, 0xd6, 0x5e, 0x68, 0x4c, 0x67, 0x0b, 0x1f, 0x45, 0x4f, 0x28, 0xbe, 0x0e, 0x20, 0xbf,
	0x14, 0xf1, 0xa7, 0x94, 0x2d, 0x4f, 0xca, 0x40, 0xf9, 0xf8, 0x7e, 0xb6, 0xe0, 0x7e, 0x85, 0x60,
	0xbe, 0x54, 0x2a, 0x4d, 0x62, 0x96, 0x52, 0xfc, 0x2e, 0x5c, 0x55, 0x9d, 0x4d, 0x97, 0xd1, 0xca,
	0xe4, 0xda, 0xcc, 0xc6, 0xba, 0x3f, 0x5e, 0x0b, 0x7e, 0x43, 0xad, 0xaa, 0x64, 0x0d, 0x93, 0x01,
	0xaf, 0xc2, 0x8b, 0x8c, 0x7e, 0x2e, 0x0e, 0x0a, 0x20, 0x13, 0x12, 0x64, 0x36, 0x5b, 0x7e, 0x90,
	0xc3, 0xac, 0xc2, 0x4b, 0xf7, 0xa9, 0x46, 0x31, 0x9b, 0xc6, 0x70, 0x85, 0x91, 0x2e, 0xd5, 0x01,
	0xf2, 0x7f, 0xf7, 0x19, 0x82, 0xf9, 0x5d, 0x4e, 0x89, 0xa0, 0xe5, 0x67, 0x47, 0x35, 0x68, 0x0f,
	0xa6, 0x14, 0x8a, 0xcc, 0x72, 0xa1, 0xbd, 0xe8, 0x04, 0x59, 0x3b, 0xb9, 0xaa, 0x76, 0x10, 0x1d,
	0x9a, 0x76, 0xea, 0x95, 0xbd, 0x43, 0x57, 0xc0, 0xfc, 0xc3, 0xe4, 0xf0, 0x0c, 0x98, 0xd9, 0x04,
	0xea, 0x6f, 0xe2, 0x12, 0xa1, 0xdc, 0xd7, 0x60, 0xfe, 0x1e, 0xed, 0x50, 0x8b, 0xaa, 0xee, 0x53,
	0x04, 0x0b, 0xd9, 0x79, 0x7f, 0x4c, 0x78, 0x44, 0x9a, 0x1d, 0x3a, 0x56, 0x5c, 0x4b, 0x30, 0x75,
	0x14, 0x75, 0x04, 0xe5, 0xfa, 0x04, 0xf4, 0xa7, 0xb2, 0xe8, 0x26, 0xcf, 0x15, 0xdd, 0x95, 0x41,
	0xd1, 0x7d, 0x8d, 0x60, 0x71, 0x00, 0x42, 0xcb, 0xee, 0x1d, 0xa8, 0x1d, 0x9b, 0x45, 0x2d, 0xbc,
	0x1b, 0x36, 0x7d, 0x31, 0x99, 0x1a, 0xfd, 0x70, 0x6b, 0xd5, 0x51, 0x58, 0x78, 0x44, 0x44, 0xab,
	0x9d, 0xe7, 0x38, 0xe7, 0xd0, 0xb6, 0x01, 0x18, 0x3d, 0xa1, 0xfc, 0x40, 0xb4, 0x89, 0xda, 0xd8,
	0xcc, 0x86, 0x63, 0x00, 0xcd, 0xfb, 0xed, 0xef, 0x9b, 0xd7, 0xb9, 0x51, 0x93, 0x4f, 0xef, 0xb7,
	0x09, 0x73, 0xd7, 0x00, 0xdf, 0xa7, 0xc2, 0xa2, 0x88, 0xfb, 0x3d, 0x82, 0x45, 0x25, 0xef, 0xc1,
	0xa7, 0x47, 0x1d, 0xd2, 0xdb, 0x30, 0x6d, 0xf6, 0xad, 0xd5, 0x54, 0xad, 0x6b, 0x79, 0xf4, 0x38,
	0x7d, 0xf7, 0x60, 0x51, 0xe9, 0xdb, 0xa6, 0x59, 0x97, 0x46, 0xe5, 0xee, 0xc1, 0xa2, 0x12, 0xb8,
	0x4d, 0xd9, 0x57, 0xa0, 0xc6, 0x69, 0xab, 0xc7, 0xd3, 0xe8, 0x58, 0xd5, 0x9d, 0x6e, 0xf4, 0x17,
	0xcc, 0xd5, 0xfa, 0x88, 0x44, 0x82, 0xf2, 0xff, 0xf5, 0x6a, 0xfd, 0x52, 0x5f, 0xad, 0x79, 0x29,
	0xad, 0xf1, 0x7b, 0x70, 0xf5, 0x44, 0x2d, 0x69, 0x85, 0x7b, 0x36, 0x5d, 0x51, 0x59, 0x1a, 0x26,
	0xb4, 0xe2, 0x9d, 0xaa, 0xa3, 0xcf, 0x11, 0xdd, 0xb7, 0xf9, 0x9d, 0x5a, 0x7e, 0x76, 0x54, 0x67,
	0x76, 0x60, 0x4a, 0xa1, 0xe8, 0xa3, 0xad, 0xb2, 0x09, 0x1d, 0x39, 0x4e, 0x6c, 0xf9, 0xb5, 0x36,
	0x96, 0x7e, 0xe3, 0xef, 0x05, 0x58, 0x28, 0xdd, 0x8d, 0xef, 0x13, 0x46, 0x42, 0xca, 0xf1, 0x2f,
	0x08, 0x66, 0x0a, 0xfe, 0x86, 0x6f, 0xdb, 0x60, 0x9e, 0xf5, 0x5e, 0xe7, 0x4e, 0xe5, 0x38, 0x75,
	0xda, 0xee, 0x8d, 0xa7, 0x7f, 0xfd, 0xf3, 0xdd, 0xc4, 0x2a, 0x7e, 0x35, 0x1f, 0x51, 0xbe, 0x50,
	0x1d, 0xbc, 0x9b, 0xf0, 0xf8, 0x13, 0xda, 0x12, 0x69, 0xe0, 0x9d, 0x06, 0xc6, 0x29, 0x7f, 0x44,
	0x50, 0xcb, 0x2d, 0x10, 0xdf, 0xb2, 0x29, 0x3a, 0xe8, 0x98, 0x4e, 0x75, 0x23, 0x19, 0x06, 0x99,
	0xb5, 0xb5, 0x80, 0x68, 0x08, 0x03, 0xef, 0x14, 0xff, 0x86, 0xe0, 0x5a, 0xd1, 0x7e, 0xb1, 0x55,
	0x73, 0x86, 0x18, 0xf6, 0x45, 0x50, 0x6f, 0x49, 0x54, 0xdf, 0xb5, 0xea, 0x67, 0xdd, 0xd8, 0x76,
	0x86, 0x5c, 0x34, 0x66, 0x3b, 0xe4, 0x21, 0x56, 0xfe, 0x1f, 0x90, 0x1d, 0xab, 0xee, 0xe6, 0xc8,
	0xdf, 0x20, 0xb8, 0x56, 0x74, 0x75, 0x3b, 0xe4, 0x21, 0x73, 0x80, 0xb3, 0x74, 0xc6, 0xa0, 0xde,
	0xca, 0x06, 0x55, 0x73, 0xea, 0x9e, 0xdd, 0xa9, 0x3f, 0x47, 0x30, 0x5b, 0x32, 0x6d, 0xbc, 0x65,
	0xfb, 0x4e, 0x0c, 0x0e, 0x1b, 0xce, 0xf6, 0x05, 0x22, 0xf5, 0xfb, 0xb4, 0x25, 0xa1, 0x37, 0xf0,
	0xcd, 0x73, 0xce, 0xbf, 0x80, 0x1d, 0xf4, 0xe7, 0x81, 0x5f, 0x11, 0xcc, 0x14, 0x1c, 0xd8, 0xee,
	0x2a, 0x38, 0x6b, 0xd9, 0x4e, 0x25, 0x13, 0x73, 0xb7, 0x25, 0xef, 0x26, 0x5e, 0xb7, 0x68, 0x72,
	0x1f, 0x36, 0xf0, 0xbc, 0x53, 0xfc, 0x07, 0x82, 0xd9, 0xd2, 0x64, 0x62, 0xd7, 0xf1, 0x61, 0xc3,
	0x4c, 0x45, 0xe8, 0x1d, 0x09, 0xfd, 0x86, 0x7b, 0xa7, 0x32, 0x74, 0xfd, 0x24, 0xab, 0x5e, 0x47,
	0x1e, 0xfe, 0x13, 0xc1, 0x5c, 0x79, 0x8a, 0xc1, 0xdb, 0xf6, 0xf7, 0xc4, 0xe5, 0xf0, 0x57, 0x16,
	0x49, 0xbd, 0x3f, 0x09, 0x3d, 0x47, 0x30, 0x57, 0x9e, 0x75, 0xec, 0xf8, 0x87, 0xce, 0x47, 0x15,
	0xf9, 0x77, 0x25, 0xff, 0x5d, 0xa7, 0xba, 0x68, 0x0a, 0x1b, 0xf8, 0x01, 0xc1, 0x5c, 0x79, 0x6a,
	0xb2, 0xdb, 0xc0, 0xd0, 0x49, 0x6b, 0xe4, 0x25, 0xa2, 0xf5, 0xed, 0x5d, 0x40, 0xdf, 0xbf, 0x6b,
	0x6f, 0xd6, 0x03, 0x92, 0xbd, 0x37, 0x97, 0x87, 0x37, 0x7b, 0x6f, 0x1e, 0x98, 0xc4, 0xdc, 0xdb,
	0x92, 0xfd, 0x26, 0xf6, 0x2d, 0x65, 0x62, 0x66, 0xaf, 0x9f, 0x94, 0x4b, 0xab, 0x74, 0xd6, 0x2e,
	0x5d, 0x9a, 0x62, 0x9c, 0x0a, 0xf3, 0xd2, 0x30, 0xce, 0xd1, 0x3d, 0xd6, 0x90, 0xd9, 0x95, 0xfd,
	0x73, 0x6e, 0xd4, 0x1a, 0xb5, 0x82, 0x51, 0x97, 0x69, 0xaf, 0x9b, 0xc0, 0xc2, 0x0f, 0x25, 0xfe,
	0x07, 0xe6, 0x87, 0x12, 0xf7, 0x4d, 0x09, 0xb8, 0xe5, 0x56, 0x6c, 0x64, 0xdd, 0x0c, 0x82, 0xcf,
	0x72, 0xaf, 0xab, 0x02, 0x3a, 0x64, 0x38, 0x1c, 0x29, 0x53, 0xdd, 0x42, 0xaf, 0x62, 0x0b, 0x77,
	0x3c, 0x58, 0x6d, 0xc5, 0x5d, 0x0b, 0x9a, 0x07, 0xa8, 0x39, 0x25, 0x6b, 0x6e, 0xfe, 0x1b, 0x00,
	0x00, 0xff, 0xff, 0x90, 0xc1, 0xfd, 0xca, 0x8d, 0x13, 0x00, 0x00,
}
