// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/monitoring/v3/group.proto
// DO NOT EDIT!

package google_monitoring_v3 // import "google.golang.org/genproto/googleapis/monitoring/v3"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The description of a dynamic collection of monitored resources. Each group
// has a filter that is matched against monitored resources and their associated
// metadata. If a group's filter matches an available monitored resource, then
// that resource is a member of that group.  Groups can contain any number of
// monitored resources, and each monitored resource can be a member of any
// number of groups.
//
// Groups can be nested in parent-child hierarchies. The `parentName` field
// identifies an optional parent for each group.  If a group has a parent, then
// the only monitored resources available to be matched by the group's filter
// are the resources contained in the parent group.  In other words, a group
// contains the monitored resources that match its filter and the filters of all
// the group's ancestors.  A group without a parent can contain any monitored
// resource.
//
// For example, consider an infrastructure running a set of instances with two
// user-defined tags: `"environment"` and `"role"`. A parent group has a filter,
// `environment="production"`.  A child of that parent group has a filter,
// `role="transcoder"`.  The parent group contains all instances in the
// production environment, regardless of their roles.  The child group contains
// instances that have the transcoder role *and* are in the production
// environment.
//
// The monitored resources contained in a group can change at any moment,
// depending on what resources exist and what filters are associated with the
// group and its ancestors.
type Group struct {
	// Output only. The name of this group. The format is
	// `"projects/{project_id_or_number}/groups/{group_id}"`.
	// When creating a group, this field is ignored and a new name is created
	// consisting of the project specified in the call to `CreateGroup`
	// and a unique `{group_id}` that is generated automatically.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A user-assigned name for this group, used only for display purposes.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// The name of the group's parent, if it has one.
	// The format is `"projects/{project_id_or_number}/groups/{group_id}"`.
	// For groups with no parent, `parentName` is the empty string, `""`.
	ParentName string `protobuf:"bytes,3,opt,name=parent_name,json=parentName" json:"parent_name,omitempty"`
	// The filter used to determine which monitored resources belong to this group.
	Filter string `protobuf:"bytes,5,opt,name=filter" json:"filter,omitempty"`
	// If true, the members of this group are considered to be a cluster.
	// The system can perform additional analysis on groups that are clusters.
	IsCluster bool `protobuf:"varint,6,opt,name=is_cluster,json=isCluster" json:"is_cluster,omitempty"`
}

func (m *Group) Reset()                    { *m = Group{} }
func (m *Group) String() string            { return proto.CompactTextString(m) }
func (*Group) ProtoMessage()               {}
func (*Group) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func init() {
	proto.RegisterType((*Group)(nil), "google.monitoring.v3.Group")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/monitoring/v3/group.proto", fileDescriptor3)
}

var fileDescriptor3 = []byte{
	// 216 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x6c, 0x8f, 0xc1, 0x4a, 0x03, 0x31,
	0x10, 0x86, 0x89, 0xda, 0xc5, 0x4e, 0x3d, 0x05, 0x91, 0xbd, 0x88, 0xd5, 0xd3, 0x9e, 0x92, 0xc3,
	0x3e, 0x80, 0x50, 0x0f, 0xde, 0xa4, 0xf4, 0x05, 0x4a, 0xac, 0x71, 0x08, 0x64, 0x33, 0x21, 0x49,
	0x17, 0x7c, 0x11, 0x9f, 0x57, 0x32, 0x59, 0xf0, 0xd2, 0x5b, 0xf2, 0x7f, 0x1f, 0xc3, 0xff, 0xc3,
	0x2b, 0x12, 0xa1, 0xb7, 0x0a, 0xc9, 0x9b, 0x80, 0x8a, 0x12, 0x6a, 0xb4, 0x21, 0x26, 0x2a, 0xa4,
	0x1b, 0x32, 0xd1, 0x65, 0x3d, 0x51, 0x70, 0x85, 0x92, 0x0b, 0xa8, 0xe7, 0x51, 0x63, 0xa2, 0x73,
	0x54, 0x2c, 0xc9, 0xfb, 0xe5, 0xc0, 0xbf, 0xa1, 0xe6, 0xf1, 0xe5, 0x57, 0xc0, 0xea, 0xbd, 0x5a,
	0x52, 0xc2, 0x4d, 0x30, 0x93, 0xed, 0xc5, 0x56, 0x0c, 0xeb, 0x03, 0xbf, 0xe5, 0x33, 0xdc, 0x7d,
	0xb9, 0x1c, 0xbd, 0xf9, 0x39, 0x32, 0xbb, 0x62, 0xb6, 0x59, 0xb2, 0x8f, 0xaa, 0x3c, 0xc1, 0x26,
	0x9a, 0x64, 0x43, 0x69, 0xc6, 0x35, 0x1b, 0xd0, 0x22, 0x16, 0x1e, 0xa0, 0xfb, 0x76, 0xbe, 0xd8,
	0xd4, 0xaf, 0x98, 0x2d, 0x3f, 0xf9, 0x08, 0xe0, 0xf2, 0xf1, 0xe4, 0xcf, 0xb9, 0xb2, 0x6e, 0x2b,
	0x86, 0xdb, 0xc3, 0xda, 0xe5, 0xb7, 0x16, 0xec, 0x06, 0xe8, 0x4f, 0x34, 0xa9, 0x4b, 0xa5, 0x77,
	0xc0, 0x8d, 0xf7, 0x75, 0xd6, 0x5e, 0x7c, 0x76, 0xbc, 0x6f, 0xfc, 0x0b, 0x00, 0x00, 0xff, 0xff,
	0x76, 0x8a, 0xec, 0x63, 0x22, 0x01, 0x00, 0x00,
}
