/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF5/releases.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 *  This example illustrates how to create and close a group.
 *  It is used in the HDF5 Tutorial.
 */

#include <iostream>
using std::cout;
using std::endl;

#include <string>
#include "H5Cpp.h"
using namespace H5;

const H5std_string FILE_NAME("h5tutr_group.h5");

int main(void)
{
    // Try block to detect exceptions raised by any of the calls inside it
    try
    {
        // Turn off the auto-printing when failure occurs so that we can
        // handle the errors appropriately
        Exception::dontPrint();

        // Create a new file using default property lists.
        H5File file(FILE_NAME, H5F_ACC_TRUNC);
        
        // Create a group named "/MygGroup" in the file
        Group group(file.createGroup("/MyGroup"));

        // File and group will be closed as their instances go out of scope.
   
    } // end of try block

    // catch failure caused by the H5File operations
    catch(FileIException error)
    {
        error.printErrorStack();
        return -1;
    }
    // catch failure caused by the Group operations
    catch(GroupIException error)
    {
        error.printErrorStack();
        return -1;
    }
 
    return 0;
}
