/* KDevelop CMake Support
 *
 * Copyright 2007-2012 Aleix Pol <aleixpol@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "cmakeduchaintypes.h"
#include <language/duchain/types/typeregister.h>

namespace KDevelop {
REGISTER_TYPE(TargetType);
}

TargetType::TargetType()
    : AbstractType(createData<TargetType>())
{}

TargetType::TargetType(TargetType& rhs)
    : AbstractType(copyData<TargetType>(*rhs.d_func()))
{}

TargetType::TargetType(KDevelop::AbstractTypeData& dd): AbstractType(dd)
{}


KDevelop::AbstractType* TargetType::clone() const
{
    return new TargetType;
}

void TargetType::accept0(KDevelop::TypeVisitor* ) const
{}

bool TargetType::equals(const KDevelop::AbstractType* rhs) const
{
    return dynamic_cast<const TargetType*>(rhs)!=0;
}
