#ifndef _DISPLAY_H
#define _DISPLAY_H

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/extensions/shape.h>
#include <string>
#include <vector>

#include "png++/image.hpp"
#include "png++/rgb_pixel.hpp"

#include <fakekey/fakekey.h>

class MyWindow;

class MyDisplay {
  public:
    bool Open();
    int Width() const;
    int Height() const;
    int Depth() const;
    void UpdateWidthHeight();
    void SetWidth(int w);
    void SetHeight(int h);
    void Flush();
    void GetEvent(XEvent* xev);
    XColor MakeXColor(short red, short green, short blue);
    XColor MakeXColor(const short rgb[]);
    void GenKeyEvent(std::string action);
    void GenMouseClickEvent(int x, int y, int button);
    void GenMouseMoveEvent(int x, int y);
    int shape_event_base;
    int shape_error_base;
    int randr_event_base;
    int randr_error_base;
    Display *disp;

  private:

    int width;
    int height;
    int screen;
    friend class MyWindow;
    FakeKey* fk;
};

class MyWindow {
  public:
    MyWindow(int width, int height, MyDisplay& display);
    ~MyWindow();
    void Create();
    void Create(int x, int y);
    void Move(int px, int py, int w, int h);
    void Move(int px, int py);
    int Width() const;
    int Height() const;
    int PosX();
    int PosY();
    void UnmapInput();
    void MapInput();
    void MapWin();
    void UnmapWin();
    void SetWidth(int w);
    void SetHeight(int h);
    void SetTransparent(bool trans);
    bool IsTransparent();
    void SetBackground(XColor col);
    void SetForeground(XColor col);
    void Refresh();
    void Refresh(int px, int py, int w, int h);
    //void Rectangle(int px, int py, int w, int h, XColor col);
    enum ImageBegin { TOP_LEFT, CENTER, TOP_CENTER };
    void AddText(int x, int y, const std::string& text, ImageBegin image_begin, int r, int g, int b);
    void AddImage(int x, int y, const std::string& name, int* width, int* height, ImageBegin image_begin, int r = -1, int g = -1, int b = -1);
    void AddPixel(int x, int y);
    void AddPixel(int x, int y, XColor col);
    void Clear();
    bool SetFont(const std::string& path);
    void SetFontSize(int size);
    Window& GetInputWindow();
    Window& GetWindow();
    MyDisplay& GetDisplay();
    void SaveBuffer(const std::string& name);
    bool LoadBuffer(const std::string& name);
  
  private:

    int width;
    int height;
    bool transparent;
    XColor fground, bground;
    Window win;
    Window input;
    Pixmap buf;
    MyDisplay& display;
    std::string font_path;
    int font_size;
    std::string buf_name;
    GC gc;
};

#endif
