/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF.  The full HDF copyright notice, including       *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://support.hdfgroup.org/ftp/HDF/releases/.  *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* $Id$ */

#include "tproto.h"

#define XSIZE 13
#define YSIZE 15
#define TESTFILE "tdf24.hdf"

#define JPEGX   46
#define JPEGY   23
#define NCOMPS  3
#define JPEGFILE "tjpeg.hdf"
#define NONHDF_JPEGFILE "tnonhdf_jpeg.hdf"

static const uint8  jpeg_8bit_orig[JPEGY][JPEGX] =
{
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 201, 201, 201, 200, 200, 200, 200, 200, 200, 201, 202, 204, 206, 208, 208, 206, 202, 201, 200, 200, 204, 210, 212, 214, 212, 206, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 200, 200, 201, 202, 204, 203, 201, 202, 200, 199, 200, 202, 202, 203, 204, 207, 210, 213, 218, 222, 209, 205, 207, 209, 212, 215, 220, 225, 203, 212, 216, 218, 221, 223, 201, 201, 200, 200, 200, 200, 201, 200, 200, 201, 201},
    {200, 200, 199, 200, 200, 201, 203, 206, 207, 206, 202, 197, 193, 193, 193, 192, 193, 199, 204, 205, 210, 219, 214, 193, 213, 225, 209, 196, 206, 222, 204, 208, 211, 121, 127, 229, 206, 196, 198, 207, 211, 212, 214, 215, 211, 196},
    {200, 201, 200, 200, 199, 200, 200, 198, 198, 199, 202, 207, 209, 211, 195, 180, 182, 182, 170, 111, 39, 71, 58, 64, 69, 73, 72, 82, 92, 213, 83, 73, 126, 111, 89, 92, 209, 197, 198, 201, 81, 51, 56, 55, 210, 208},
    {54, 53, 54, 55, 53, 51, 56, 55, 50, 54, 53, 49, 54, 55, 64, 66, 63, 105, 78, 51, 59, 39, 49, 45, 50, 66, 58, 67, 67, 71, 73, 87, 68, 80, 94, 113, 67, 202, 194, 90, 42, 39, 59, 43, 44, 58},
    {54, 52, 51, 53, 55, 56, 53, 57, 55, 57, 51, 51, 53, 50, 46, 50, 55, 51, 45, 68, 66, 63, 67, 50, 57, 38, 47, 56, 62, 65, 65, 87, 74, 110, 59, 63, 45, 47, 98, 40, 41, 199, 199, 170, 109, 43},
    {198, 198, 200, 201, 199, 203, 202, 201, 199, 197, 197, 192, 190, 190, 191, 195, 202, 153, 101, 197, 61, 69, 138, 182, 154, 202, 154, 73, 76, 71, 83, 83, 150, 231, 203, 179, 49, 53, 47, 162, 208, 203, 185, 199, 203, 83},
    {199, 200, 204, 202, 202, 200, 199, 197, 195, 198, 200, 202, 207, 211, 216, 219, 214, 199, 193, 192, 195, 195, 199, 205, 207, 218, 229, 196, 138, 121, 116, 213, 233, 197, 207, 211, 212, 215, 216, 216, 199, 197, 199, 201, 209, 211},
    {200, 201, 201, 202, 201, 201, 201, 201, 203, 206, 206, 207, 206, 201, 202, 202, 203, 202, 203, 205, 208, 211, 214, 221, 225, 209, 211, 213, 217, 220, 224, 225, 200, 200, 200, 201, 207, 209, 202, 200, 201, 201, 200, 200, 200, 200},
    {200, 200, 200, 200, 200, 201, 202, 203, 201, 200, 200, 200, 200, 200, 200, 200, 203, 209, 212, 214, 214, 211, 203, 200, 200, 200, 200, 202, 204, 202, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200},
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}
};

static const uint8  jpeg_8bit_j80[JPEGY][JPEGX] =
{
    {200, 200, 200, 200, 200, 200, 200, 200, 202, 202, 201, 201, 201, 200, 200, 200, 201, 201, 200, 200, 200, 201, 202, 202, 202, 202, 201, 200, 200, 200, 200, 201, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 199, 199, 199, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 199, 199, 199, 199, 200, 200, 201, 201, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 199, 199, 199, 200, 200, 201, 201, 201, 200, 200, 201, 201, 201, 200, 199, 199, 199, 199, 200, 201, 201, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 201, 201, 201, 201, 201, 201, 201, 201, 201, 201, 202, 202, 202, 201, 200, 199, 202, 202, 202, 202, 202, 200, 199, 198, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 201, 201, 201, 200, 200, 200, 199, 199, 200, 200, 200, 201, 201, 200, 200, 200, 200, 200, 201, 201, 201, 200, 200, 199, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 199, 199, 199, 198, 198, 198, 199, 199, 198, 198, 198, 199, 200, 201, 197, 197, 197, 198, 198, 200, 201, 202, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 199, 199, 200, 200, 201, 202, 202, 203, 201, 200, 199, 198, 199, 201, 204, 205, 203, 202, 200, 199, 198, 200, 202, 203, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 201, 202, 203, 205, 207, 208, 209, 205, 203, 201, 200, 202, 205, 208, 211, 214, 211, 206, 202, 200, 200, 201, 202, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {199, 199, 198, 199, 200, 202, 204, 205, 202, 200, 197, 198, 201, 204, 205, 205, 220, 204, 207, 222, 225, 201, 206, 213, 205, 218, 219, 224, 222, 198, 222, 208, 222, 208, 235, 201, 189, 204, 198, 202, 199, 201, 209, 192, 192, 217}, 
    {200, 200, 199, 199, 200, 201, 202, 203, 210, 208, 205, 203, 201, 197, 191, 186, 170, 212, 216, 191, 222, 217, 218, 185, 216, 226, 200, 193, 207, 232, 193, 221, 210, 124, 127, 218, 223, 192, 197, 207, 207, 209, 210, 220, 209, 184}, 
    {202, 201, 201, 200, 200, 200, 201, 201, 196, 197, 200, 203, 203, 200, 195, 191, 196, 180, 168, 123, 34, 66, 56, 74, 57, 83, 73, 81, 94, 221, 72, 64, 120, 119, 83, 100, 207, 190, 198, 198, 94, 44, 57, 50, 213, 215}, 
    {54, 54, 54, 53, 53, 54, 54, 54, 49, 51, 55, 59, 62, 63, 63, 62, 54, 110, 65, 43, 69, 40, 54, 36, 53, 67, 57, 65, 66, 61, 94, 83, 83, 69, 102, 99, 64, 214, 195, 90, 28, 46, 63, 51, 43, 57}, 
    {52, 52, 53, 54, 54, 55, 55, 55, 56, 54, 51, 48, 47, 46, 48, 49, 56, 63, 48, 72, 67, 55, 51, 65, 50, 48, 46, 70, 49, 67, 63, 86, 59, 107, 60, 73, 40, 44, 102, 36, 40, 218, 192, 165, 101, 44}, 
    {198, 199, 200, 201, 202, 202, 202, 202, 199, 197, 194, 190, 188, 190, 194, 198, 196, 151, 88, 202, 61, 71, 148, 169, 165, 188, 139, 77, 86, 70, 81, 84, 163, 226, 206, 184, 52, 46, 48, 165, 204, 189, 179, 213, 208, 79}, 
    {199, 200, 201, 202, 202, 201, 200, 199, 201, 203, 204, 205, 206, 209, 214, 218, 218, 198, 195, 199, 182, 201, 202, 206, 201, 228, 240, 191, 131, 121, 110, 221, 211, 208, 207, 198, 213, 231, 204, 220, 197, 211, 207, 194, 207, 213}, 
    {201, 202, 202, 203, 202, 200, 199, 197, 199, 202, 206, 206, 204, 202, 202, 203, 205, 195, 210, 199, 211, 220, 210, 224, 224, 204, 215, 205, 227, 218, 229, 220, 203, 201, 199, 202, 206, 206, 195, 205, 203, 194, 202, 197, 210, 190}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 203, 206, 210, 213, 213, 210, 206, 203, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 198, 199, 201, 202, 202, 201, 199, 198, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 199, 199, 198, 197, 197, 198, 199, 199, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 202, 201, 200, 199, 199, 200, 201, 202, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 199, 199, 199, 199, 199, 199, 199, 199, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 198, 199, 200, 201, 201, 200, 199, 198, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 201, 201, 202, 202, 202, 202, 201, 201, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200} 
};

static const uint8  jpeg_8bit_j30[JPEGY][JPEGX] =
{
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {202, 202, 202, 202, 202, 202, 202, 202, 196, 196, 197, 198, 200, 201, 202, 202, 203, 206, 220, 234, 226, 203, 192, 196, 226, 219, 212, 213, 219, 222, 219, 214, 213, 224, 225, 214, 206, 207, 207, 202, 213, 205, 195, 188, 190, 199}, 
    {203, 203, 203, 203, 203, 203, 203, 203, 221, 219, 214, 207, 200, 193, 188, 185, 186, 206, 207, 186, 187, 214, 229, 222, 219, 205, 195, 203, 219, 221, 203, 183, 192, 141, 135, 187, 212, 183, 168, 185, 208, 218, 230, 234, 226, 209}, 
    {203, 203, 203, 203, 203, 203, 203, 203, 207, 207, 207, 207, 207, 207, 207, 207, 170, 194, 165, 90, 57, 75, 72, 37, 99, 84, 79, 97, 124, 132, 112, 87, 128, 88, 84, 143, 202, 215, 201, 193, 67, 50, 51, 97, 167, 215}, 
    {53, 53, 53, 53, 53, 53, 53, 53, 44, 46, 49, 53, 57, 61, 64, 66, 74, 93, 87, 54, 35, 41, 36, 17, 40, 34, 35, 49, 71, 84, 82, 75, 54, 92, 90, 63, 100, 176, 178, 120, 62, 60, 57, 54, 53, 54}, 
    {53, 53, 53, 53, 53, 53, 53, 53, 61, 60, 57, 53, 48, 44, 41, 40, 63, 48, 53, 73, 72, 55, 64, 92, 76, 78, 75, 63, 51, 53, 70, 87, 71, 125, 117, 41, 10, 50, 67, 38, 38, 120, 193, 179, 97, 32}, 
    {203, 203, 203, 203, 203, 203, 203, 203, 199, 199, 199, 199, 199, 199, 199, 199, 191, 141, 120, 133, 117, 79, 93, 144, 149, 151, 138, 101, 60, 46, 66, 92, 181, 178, 176, 154, 98, 57, 82, 137, 223, 239, 247, 222, 169, 112}, 
    {203, 203, 203, 203, 203, 203, 203, 203, 184, 187, 192, 198, 205, 212, 217, 220, 228, 206, 197, 206, 204, 197, 218, 253, 227, 228, 216, 186, 154, 143, 158, 178, 233, 209, 215, 238, 214, 170, 186, 244, 203, 167, 141, 160, 208, 240}, 
    {202, 202, 202, 202, 202, 202, 202, 202, 209, 208, 208, 206, 205, 204, 203, 203, 184, 203, 212, 205, 202, 209, 210, 202, 219, 220, 218, 212, 208, 212, 225, 237, 192, 198, 200, 200, 207, 215, 209, 196, 180, 208, 233, 225, 197, 182}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 206, 206, 206, 206, 206, 206, 206, 206, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 205, 205, 205, 205, 205, 205, 205, 205, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 204, 204, 204, 204, 204, 204, 204, 204, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 203, 203, 203, 203, 203, 203, 203, 203, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 202, 202, 202, 202, 202, 202, 202, 202, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 200, 200, 200, 200, 200, 200, 200, 200, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199}, 
    {199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199, 199} 
};

static const uint8  jpeg_8bit_j75[JPEGY][JPEGX] =
{
    {200, 200, 200, 200, 200, 200, 200, 200, 198, 198, 198, 199, 199, 200, 200, 200, 202, 202, 200, 199, 199, 199, 199, 200, 199, 199, 200, 201, 201, 201, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 199, 199, 200, 200, 200, 200, 200, 200, 202, 202, 201, 201, 200, 200, 200, 200, 201, 201, 202, 202, 201, 201, 200, 199, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 201, 201, 200, 200, 200, 200, 200, 200, 201, 202, 202, 202, 202, 201, 200, 200, 203, 203, 202, 202, 201, 200, 200, 199, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 199, 199, 199, 199, 199, 200, 201, 202, 202, 201, 200, 199, 201, 201, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 199, 199, 199, 198, 198, 198, 198, 198, 198, 199, 199, 200, 200, 200, 199, 199, 199, 199, 198, 198, 199, 200, 201, 202, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 198, 198, 198, 199, 199, 200, 200, 200, 200, 200, 199, 199, 199, 200, 201, 202, 201, 200, 199, 198, 198, 200, 201, 203, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 198, 199, 199, 201, 202, 203, 204, 204, 204, 202, 200, 199, 200, 202, 204, 206, 207, 205, 203, 200, 199, 200, 201, 202, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 199, 200, 201, 202, 204, 206, 207, 207, 207, 205, 202, 200, 200, 203, 207, 210, 213, 210, 207, 203, 201, 200, 200, 201, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {202, 201, 200, 199, 200, 201, 203, 204, 202, 199, 196, 196, 200, 203, 203, 202, 205, 222, 189, 234, 214, 209, 216, 203, 204, 212, 224, 210, 226, 204, 214, 215, 219, 218, 214, 203, 200, 207, 189, 209, 194, 211, 188, 199, 211, 185}, 
    {202, 201, 200, 200, 200, 202, 203, 204, 212, 208, 204, 201, 199, 195, 190, 186, 186, 215, 205, 196, 218, 218, 206, 197, 223, 224, 188, 217, 204, 225, 195, 205, 211, 118, 158, 234, 196, 204, 194, 209, 208, 210, 216, 224, 211, 194}, 
    {198, 198, 198, 197, 198, 199, 200, 200, 199, 199, 200, 202, 204, 203, 200, 197, 176, 184, 165, 126, 21, 66, 63, 65, 66, 68, 78, 78, 89, 200, 87, 66, 117, 120, 65, 94, 212, 196, 206, 197, 80, 49, 56, 45, 206, 205}, 
    {54, 54, 54, 54, 55, 55, 56, 56, 49, 50, 53, 57, 60, 62, 62, 62, 63, 91, 80, 31, 78, 53, 41, 53, 63, 64, 48, 65, 75, 79, 80, 89, 83, 90, 90, 109, 76, 202, 178, 94, 41, 52, 47, 58, 50, 65}, 
    {54, 54, 55, 55, 56, 56, 56, 56, 59, 57, 55, 51, 48, 46, 46, 46, 62, 67, 49, 72, 82, 42, 55, 61, 42, 30, 65, 48, 66, 64, 53, 82, 53, 115, 63, 58, 46, 52, 86, 43, 34, 200, 200, 149, 103, 61}, 
    {197, 197, 198, 199, 200, 199, 199, 199, 197, 197, 196, 194, 192, 193, 196, 199, 187, 139, 105, 206, 44, 86, 158, 165, 167, 210, 135, 91, 55, 64, 104, 85, 172, 219, 206, 182, 36, 55, 59, 163, 211, 188, 208, 207, 212, 63}, 
    {199, 200, 201, 203, 203, 203, 202, 201, 192, 196, 200, 203, 205, 209, 214, 218, 237, 203, 178, 202, 187, 178, 206, 212, 202, 216, 224, 204, 133, 129, 121, 199, 221, 204, 209, 216, 207, 206, 228, 202, 183, 218, 188, 176, 208, 219}, 
    {198, 199, 201, 202, 203, 202, 201, 200, 202, 205, 209, 208, 204, 201, 201, 202, 198, 195, 207, 203, 219, 218, 210, 215, 226, 210, 214, 214, 211, 226, 201, 238, 208, 188, 212, 192, 209, 217, 199, 201, 209, 192, 207, 206, 207, 195}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 202, 206, 211, 215, 215, 211, 206, 202, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 198, 199, 201, 203, 203, 201, 199, 198, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 201, 200, 199, 198, 198, 199, 200, 201, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 203, 202, 201, 199, 199, 201, 202, 203, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 198, 198, 198, 199, 199, 198, 198, 198, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 197, 198, 199, 200, 200, 199, 198, 197, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200}, 
    {200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 201, 201, 202, 202, 202, 202, 201, 201, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200} 
};

 /* const uint8  jpeg_24bit_orig[JPEGY][JPEGX][3] =
 */ 
const uint8  jpeg_24bit_orig[JPEGY*JPEGX*3] =
{
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 99, 0, 255, 99, 0, 255, 99, 0, 255, 103, 0, 255, 103, 0,
    255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 99, 0, 255, 95, 0, 255, 87, 0, 255, 79, 0, 255,
    71, 0, 255, 71, 0, 255, 79, 0, 255, 95, 0, 255, 99, 0, 255, 103, 0, 255, 103, 0, 255, 87, 0, 255, 63, 0,
    255, 55, 0, 255, 47, 0, 255, 55, 0, 255, 79, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 99, 0, 255, 95, 0, 255, 87, 0, 255, 91, 0, 255, 99, 0, 255, 95, 0, 255, 103, 0,
    255, 107, 0, 255, 103, 0, 255, 95, 0, 255, 95, 0, 255, 91, 0, 255, 87, 0, 255, 75, 0, 255, 63, 0, 255,
    51, 0, 255, 31, 0, 255, 15, 0, 255, 67, 0, 255, 83, 0, 255, 75, 0, 255, 67, 0, 255, 55, 0, 255, 43, 0,
    255, 23, 0, 255, 3, 0, 255, 91, 0, 255, 55, 0, 255, 39, 0, 255, 31, 0, 255, 19, 0, 255, 11, 0, 255, 99, 0,
    255, 99, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 99, 0, 255, 103, 0, 255, 103, 0,
    255, 99, 0, 255, 99, 0, 255, 103, 0, 255, 103, 0, 255, 107, 0, 255, 103, 0, 255, 103, 0, 255, 99, 0,
    255, 91, 0, 255, 79, 0, 255, 75, 0, 255, 79, 0, 255, 95, 0, 255, 115, 0, 255, 131, 0, 255, 131, 0, 255,
    131, 0, 255, 135, 0, 255, 131, 0, 255, 107, 0, 255, 87, 0, 255, 83, 0, 255, 63, 0, 255, 27, 0, 255, 47,
    0, 255, 131, 0, 255, 51, 0, 255, 3, 0, 255, 67, 0, 255, 119, 0, 255, 79, 0, 255, 15, 0, 255, 87, 0, 255,
    71, 0, 255, 59, 0, 91, 255, 163, 115, 255, 139, 241, 0, 0, 255, 79, 0, 255, 119, 0, 255, 111, 0, 255,
    75, 0, 255, 59, 0, 255, 55, 0, 255, 47, 0, 255, 43, 0, 255, 59, 0, 255, 119, 0, 255, 103, 0, 255, 99, 0,
    255, 103, 0, 255, 103, 0, 255, 107, 0, 255, 103, 0, 255, 103, 0, 255, 111, 0, 255, 111, 0, 255, 107, 0,
    255, 95, 0, 255, 75, 0, 255, 67, 0, 255, 59, 0, 255, 123, 0, 255, 183, 0, 255, 175, 0, 255, 175, 0, 255,
    223, 0, 51, 255, 203, 0, 23, 255, 0, 151, 255, 0, 99, 255, 0, 123, 255, 0, 143, 255, 0, 159, 255, 0,
    155, 255, 0, 195, 255, 0, 235, 255, 255, 51, 0, 0, 199, 255, 0, 159, 255, 111, 255, 143, 51, 255, 203,
    0, 223, 255, 0, 235, 255, 255, 67, 0, 255, 115, 0, 255, 111, 0, 255, 99, 0, 0, 191, 255, 0, 71, 255, 0,
    91, 255, 0, 87, 255, 255, 63, 0, 255, 71, 0, 0, 83, 255, 0, 79, 255, 0, 83, 255, 0, 87, 255, 0, 79, 255,
    0, 71, 255, 0, 91, 255, 0, 87, 255, 0, 67, 255, 0, 83, 255, 0, 79, 255, 0, 63, 255, 0, 83, 255, 0, 87,
    255, 0, 123, 255, 0, 131, 255, 0, 119, 255, 27, 255, 227, 0, 179, 255, 0, 71, 255, 0, 103, 255, 0, 23,
    255, 0, 63, 255, 0, 47, 255, 0, 67, 255, 0, 131, 255, 0, 99, 255, 0, 135, 255, 0, 135, 255, 0, 151, 255,
    0, 159, 255, 0, 215, 255, 0, 139, 255, 0, 187, 255, 0, 243, 255, 59, 255, 195, 0, 135, 255, 255, 95, 0,
    255, 127, 0, 0, 227, 255, 0, 35, 255, 0, 23, 255, 0, 103, 255, 0, 39, 255, 0, 43, 255, 0, 99, 255, 0, 83,
    255, 0, 75, 255, 0, 71, 255, 0, 79, 255, 0, 87, 255, 0, 91, 255, 0, 79, 255, 0, 95, 255, 0, 87, 255, 0,
    95, 255, 0, 71, 255, 0, 71, 255, 0, 79, 255, 0, 67, 255, 0, 51, 255, 0, 67, 255, 0, 87, 255, 0, 71, 255,
    0, 47, 255, 0, 139, 255, 0, 131, 255, 0, 119, 255, 0, 135, 255, 0, 67, 255, 0, 95, 255, 0, 19, 255, 0,
    55, 255, 0, 91, 255, 0, 115, 255, 0, 127, 255, 0, 127, 255, 0, 215, 255, 0, 163, 255, 47, 255, 207, 0,
    103, 255, 0, 119, 255, 0, 47, 255, 0, 55, 255, 0, 255, 255, 0, 27, 255, 0, 31, 255, 255, 107, 0, 255,
    107, 0, 255, 223, 0, 43, 255, 211, 0, 39, 255, 255, 111, 0, 255, 111, 0, 255, 103, 0, 255, 99, 0, 255,
    107, 0, 255, 91, 0, 255, 95, 0, 255, 99, 0, 255, 107, 0, 255, 115, 0, 255, 115, 0, 255, 135, 0, 255,
    143, 0, 255, 143, 0, 255, 139, 0, 255, 123, 0, 255, 95, 0, 219, 255, 35, 11, 255, 243, 255, 115, 0, 0,
    111, 255, 0, 143, 255, 159, 255, 95, 255, 175, 0, 223, 255, 31, 255, 95, 0, 223, 255, 31, 0, 159, 255,
    0, 171, 255, 0, 151, 255, 0, 199, 255, 0, 199, 255, 207, 255, 47, 233, 0, 0, 255, 91, 0, 255, 187, 0, 0,
    63, 255, 0, 79, 255, 0, 55, 255, 255, 255, 0, 255, 71, 0, 255, 91, 0, 255, 163, 0, 255, 107, 0, 255, 91,
    0, 0, 199, 255, 255, 107, 0, 255, 103, 0, 255, 87, 0, 255, 95, 0, 255, 95, 0, 255, 103, 0, 255, 107, 0,
    255, 115, 0, 255, 123, 0, 255, 111, 0, 255, 103, 0, 255, 95, 0, 255, 75, 0, 255, 59, 0, 255, 39, 0, 255,
    27, 0, 255, 47, 0, 255, 107, 0, 255, 131, 0, 255, 135, 0, 255, 123, 0, 255, 123, 0, 255, 107, 0, 255,
    83, 0, 255, 75, 0, 255, 31, 0, 241, 0, 0, 255, 119, 0, 159, 255, 95, 91, 255, 163, 71, 255, 183, 255,
    51, 0, 224, 0, 0, 255, 115, 0, 255, 75, 0, 255, 59, 0, 255, 55, 0, 255, 43, 0, 255, 39, 0, 255, 39, 0,
    255, 107, 0, 255, 115, 0, 255, 107, 0, 255, 99, 0, 255, 67, 0, 255, 59, 0, 255, 103, 0, 255, 99, 0, 255,
    99, 0, 255, 95, 0, 255, 99, 0, 255, 99, 0, 255, 99, 0, 255, 99, 0, 255, 91, 0, 255, 79, 0, 255, 79, 0,
    255, 75, 0, 255, 79, 0, 255, 99, 0, 255, 95, 0, 255, 95, 0, 255, 91, 0, 255, 95, 0, 255, 91, 0, 255, 83,
    0, 255, 71, 0, 255, 59, 0, 255, 47, 0, 255, 19, 0, 255, 3, 0, 255, 67, 0, 255, 59, 0, 255, 51, 0, 255, 35,
    0, 255, 23, 0, 255, 7, 0, 255, 3, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 99, 0, 255, 75, 0, 255,
    67, 0, 255, 95, 0, 255, 103, 0, 255, 99, 0, 255, 99, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103,
    0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 99, 0, 255, 95, 0, 255, 91, 0,
    255, 99, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0,
    255, 91, 0, 255, 67, 0, 255, 55, 0, 255, 47, 0, 255, 47, 0, 255, 59, 0, 255, 91, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 95, 0, 255, 87, 0, 255, 95, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255, 103, 0, 255,
    103, 0, 255, 103, 0
};

static const uint8  jpeg_24bit_j80[JPEGY][JPEGX][3] =
{
    252, 106, 0, 252, 106, 0, 252, 106, 0, 252, 106, 0, 253, 105, 0, 253, 105, 0, 255, 104, 0, 
    255, 104, 0, 255, 105, 0, 255, 105, 0, 255, 105, 0, 255, 104, 0, 255, 104, 0, 255, 103, 0, 
    255, 102, 0, 252, 106, 0, 237, 111, 0, 235, 114, 0, 246, 111, 0, 248, 111, 0, 241, 114, 0, 
    243, 111, 0, 251, 103, 3, 255, 99, 4, 255, 105, 7, 255, 106, 4, 248, 110, 1, 250, 108, 0, 
    255, 99, 1, 255, 97, 6, 255, 101, 13, 251, 104, 9, 251, 106, 0, 248, 108, 0, 245, 109, 1, 
    239, 110, 6, 235, 111, 11, 234, 111, 17, 239, 107, 22, 245, 107, 9, 255, 106, 0, 
    255, 105, 0, 255, 102, 0, 255, 101, 0, 255, 101, 0, 255, 101, 0, 

    252, 105, 0, 252, 105, 0, 252, 105, 0, 252, 105, 0, 252, 105, 0, 253, 105, 0, 253, 105, 0, 
    253, 105, 0, 253, 102, 0, 253, 102, 0, 254, 101, 0, 254, 101, 0, 255, 102, 0, 255, 102, 0, 
    255, 101, 0, 253, 105, 0, 245, 109, 0, 243, 109, 0, 247, 105, 0, 248, 104, 0, 246, 105, 0, 
    251, 106, 1, 255, 104, 4, 255, 105, 5, 251, 98, 0, 248, 102, 0, 246, 105, 0, 251, 105, 0, 
    255, 101, 0, 255, 100, 2, 254, 104, 9, 251, 105, 6, 252, 106, 0, 252, 106, 0, 253, 105, 0, 
    251, 105, 4, 246, 106, 9, 244, 106, 15, 245, 105, 20, 251, 104, 11, 255, 104, 0, 
    255, 104, 0, 255, 102, 0, 255, 102, 0, 255, 104, 0, 255, 105, 0, 

    251, 105, 4, 251, 105, 4, 251, 105, 4, 251, 105, 4, 251, 105, 4, 252, 104, 4, 252, 104, 4, 
    252, 104, 4, 252, 103, 3, 253, 104, 4, 253, 104, 4, 253, 104, 4, 253, 104, 4, 254, 105, 5, 
    254, 105, 5, 255, 105, 2, 255, 105, 0, 255, 103, 0, 255, 102, 0, 255, 99, 0, 255, 97, 1, 
    255, 98, 3, 255, 102, 4, 255, 105, 1, 251, 104, 0, 251, 107, 0, 255, 108, 0, 255, 107, 0, 
    255, 104, 0, 255, 104, 0, 250, 105, 0, 247, 105, 0, 253, 106, 0, 255, 103, 0, 255, 96, 0, 
    255, 94, 4, 255, 95, 6, 255, 98, 9, 255, 98, 17, 255, 99, 13, 255, 99, 2, 255, 100, 0, 
    255, 103, 4, 248, 106, 8, 241, 109, 9, 237, 111, 9, 

    252, 104, 4, 252, 104, 4, 252, 104, 4, 252, 104, 4, 253, 104, 4, 252, 104, 4, 253, 104, 4, 
    253, 104, 4, 255, 106, 6, 255, 106, 6, 255, 106, 6, 254, 105, 5, 254, 105, 5, 253, 104, 4, 
    253, 104, 4, 255, 102, 1, 255, 98, 0, 255, 97, 0, 255, 100, 3, 255, 98, 9, 255, 95, 12, 
    255, 95, 9, 255, 98, 2, 252, 101, 0, 252, 108, 0, 254, 108, 0, 255, 103, 0, 255, 103, 0, 
    255, 103, 0, 253, 106, 0, 244, 109, 0, 244, 107, 0, 255, 105, 0, 255, 99, 0, 255, 95, 0, 
    255, 94, 1, 255, 94, 6, 255, 96, 8, 255, 98, 11, 255, 99, 9, 255, 98, 8, 255, 99, 6, 
    255, 102, 8, 248, 105, 11, 241, 108, 15, 238, 109, 17, 

    255, 102, 1, 255, 102, 1, 255, 102, 1, 255, 103, 1, 255, 102, 1, 255, 103, 1, 255, 102, 1, 
    255, 103, 1, 255, 103, 1, 255, 103, 1, 255, 103, 1, 255, 103, 1, 255, 103, 1, 255, 103, 1, 
    255, 103, 1, 255, 99, 1, 255, 93, 1, 255, 92, 6, 255, 93, 18, 255, 93, 23, 255, 92, 26, 
    255, 95, 20, 242, 105, 11, 237, 108, 4, 244, 105, 0, 255, 100, 0, 255, 90, 5, 255, 91, 7, 
    254, 99, 6, 245, 108, 2, 239, 114, 0, 244, 112, 1, 255, 99, 15, 255, 96, 15, 255, 101, 1, 
    255, 102, 0, 255, 102, 9, 253, 103, 9, 255, 103, 2, 255, 103, 1, 255, 100, 6, 255, 99, 4, 
    255, 100, 0, 255, 101, 0, 255, 100, 9, 255, 100, 15, 

    255, 101, 1, 255, 101, 1, 255, 101, 1, 255, 101, 1, 255, 101, 1, 255, 101, 1, 255, 101, 1, 
    255, 101, 1, 255, 102, 1, 255, 102, 1, 255, 103, 2, 255, 103, 2, 255, 104, 3, 255, 105, 3, 
    255, 105, 4, 255, 104, 5, 255, 100, 11, 255, 97, 16, 255, 94, 19, 255, 93, 22, 255, 95, 21, 
    254, 102, 19, 239, 115, 15, 238, 120, 14, 248, 108, 10, 255, 100, 11, 255, 88, 16, 
    255, 89, 15, 255, 100, 11, 244, 107, 3, 240, 111, 0, 245, 107, 0, 255, 98, 18, 255, 96, 18, 
    255, 103, 1, 251, 106, 0, 248, 105, 9, 246, 106, 8, 248, 108, 0, 251, 107, 0, 255, 103, 4, 
    255, 101, 4, 255, 101, 0, 255, 100, 0, 255, 99, 4, 255, 98, 9, 

    255, 100, 2, 255, 100, 2, 255, 100, 2, 255, 100, 2, 255, 100, 2, 255, 100, 2, 255, 101, 2, 
    255, 101, 2, 255, 104, 4, 255, 104, 4, 255, 103, 3, 255, 102, 2, 255, 102, 2, 254, 102, 1, 
    254, 100, 0, 251, 101, 4, 250, 103, 10, 255, 101, 11, 255, 99, 7, 255, 100, 3, 255, 102, 0, 
    250, 105, 0, 229, 112, 0, 230, 109, 2, 247, 98, 4, 255, 91, 8, 255, 85, 8, 255, 89, 7, 
    255, 100, 3, 253, 105, 0, 253, 103, 0, 255, 100, 0, 255, 99, 9, 255, 99, 9, 255, 102, 1, 
    255, 104, 0, 249, 106, 4, 245, 108, 2, 242, 112, 0, 244, 111, 0, 248, 106, 4, 251, 105, 6, 
    253, 105, 0, 255, 105, 0, 255, 103, 1, 255, 102, 4, 

    255, 99, 4, 255, 99, 4, 255, 99, 4, 255, 100, 4, 255, 99, 4, 255, 100, 4, 255, 100, 4, 
    255, 101, 4, 255, 102, 5, 255, 101, 4, 255, 98, 1, 250, 96, 0, 246, 92, 0, 242, 90, 0, 
    240, 86, 0, 236, 86, 0, 235, 92, 0, 244, 96, 0, 255, 96, 0, 255, 97, 0, 255, 97, 0, 
    248, 92, 0, 222, 87, 0, 214, 78, 0, 229, 68, 0, 248, 67, 0, 255, 72, 0, 255, 81, 0, 
    255, 94, 3, 255, 99, 5, 255, 97, 9, 255, 98, 9, 255, 101, 13, 249, 104, 15, 249, 104, 13, 
    249, 105, 9, 248, 106, 6, 246, 108, 1, 245, 110, 0, 245, 110, 0, 248, 106, 6, 249, 105, 9, 
    251, 105, 2, 253, 105, 0, 255, 103, 0, 255, 103, 0, 

    255, 98, 7, 255, 98, 6, 255, 98, 6, 255, 99, 6, 255, 94, 2, 252, 89, 0, 252, 89, 0, 
    253, 93, 0, 254, 94, 0, 254, 95, 1, 255, 96, 2, 254, 97, 2, 253, 96, 1, 250, 96, 0, 
    250, 93, 0, 246, 93, 0, 234, 86, 0, 229, 71, 0, 249, 64, 0, 247, 51, 0, 222, 30, 0, 
    255, 73, 0, 255, 83, 0, 242, 72, 0, 241, 67, 0, 243, 64, 0, 242, 60, 0, 228, 41, 0, 
    219, 28, 0, 255, 83, 26, 246, 56, 8, 223, 52, 0, 197, 60, 0, 174, 54, 0, 185, 64, 0, 
    233, 105, 30, 239, 101, 10, 251, 105, 4, 255, 110, 10, 248, 94, 0, 249, 98, 7, 255, 111, 25, 
    239, 83, 0, 255, 105, 13, 255, 99, 0, 255, 100, 0, 

    237, 105, 43, 234, 104, 42, 235, 105, 43, 236, 106, 44, 234, 104, 42, 228, 100, 37, 
    229, 101, 38, 232, 104, 41, 214, 89, 25, 224, 99, 35, 235, 111, 47, 243, 119, 55, 
    244, 120, 56, 244, 122, 57, 246, 124, 59, 244, 130, 59, 228, 126, 44, 235, 132, 53, 
    220, 100, 37, 210, 84, 36, 208, 85, 54, 185, 62, 46, 193, 64, 58, 253, 126, 119, 
    196, 79, 61, 156, 47, 18, 181, 78, 37, 229, 120, 81, 215, 89, 64, 185, 62, 47, 178, 73, 70, 
    192, 114, 102, 156, 111, 72, 222, 190, 139, 232, 195, 150, 109, 49, 0, 203, 101, 26, 
    236, 106, 20, 250, 104, 19, 232, 90, 24, 188, 75, 43, 183, 83, 68, 185, 83, 68, 183, 70, 40, 
    203, 68, 13, 247, 100, 33, 

    176, 117, 113, 174, 116, 112, 176, 118, 114, 178, 120, 116, 177, 119, 115, 175, 117, 113, 
    176, 118, 114, 178, 123, 118, 178, 123, 118, 174, 119, 114, 163, 108, 103, 150, 97, 91, 
    146, 93, 87, 162, 109, 103, 190, 137, 131, 203, 166, 148, 192, 185, 141, 174, 190, 145, 
    168, 193, 172, 180, 214, 226, 10, 45, 101, 87, 110, 206, 64, 61, 192, 100, 92, 229, 
    84, 94, 209, 92, 118, 202, 105, 143, 190, 108, 147, 176, 147, 170, 204, 74, 112, 151, 
    89, 171, 219, 34, 144, 181, 110, 227, 237, 115, 232, 223, 76, 187, 168, 130, 191, 157, 
    157, 124, 71, 216, 124, 57, 226, 108, 36, 207, 113, 87, 142, 120, 193, 54, 69, 186, 
    48, 66, 168, 78, 66, 150, 155, 87, 144, 190, 95, 139, 

    91, 67, 91, 89, 65, 89, 90, 66, 90, 93, 69, 93, 93, 69, 93, 92, 68, 92, 92, 70, 93, 
    95, 73, 96, 96, 74, 97, 95, 73, 96, 92, 68, 92, 85, 63, 86, 83, 61, 84, 93, 71, 94, 
    113, 91, 114, 119, 113, 123, 85, 113, 91, 133, 192, 174, 82, 171, 185, 4, 111, 165, 
    0, 108, 211, 0, 58, 198, 13, 72, 238, 0, 40, 205, 11, 77, 217, 47, 127, 240, 0, 95, 181, 
    32, 134, 208, 33, 129, 206, 13, 135, 212, 0, 168, 243, 12, 203, 255, 0, 143, 162, 
    44, 194, 192, 86, 226, 213, 123, 220, 209, 91, 110, 116, 155, 123, 124, 199, 145, 119, 
    188, 145, 154, 43, 40, 143, 10, 34, 166, 49, 83, 180, 21, 42, 125, 57, 44, 134, 99, 70, 163, 


    95, 70, 92, 91, 66, 88, 93, 65, 88, 95, 67, 90, 96, 68, 91, 94, 66, 89, 95, 67, 90, 
    98, 70, 93, 84, 56, 79, 88, 60, 83, 94, 64, 88, 94, 66, 89, 91, 63, 86, 85, 57, 80, 
    78, 50, 73, 70, 50, 61, 92, 90, 78, 43, 72, 70, 5, 73, 118, 22, 115, 195, 23, 124, 232, 
    27, 117, 231, 56, 114, 211, 40, 83, 162, 28, 74, 134, 0, 51, 114, 0, 64, 144, 18, 97, 190, 
    19, 114, 220, 2, 128, 228, 0, 159, 235, 37, 205, 242, 70, 177, 167, 124, 193, 162, 
    52, 106, 80, 61, 109, 129, 8, 60, 162, 14, 64, 179, 139, 181, 239, 31, 41, 77, 83, 30, 84, 
    180, 109, 139, 192, 142, 109, 234, 217, 189, 158, 185, 232, 2, 52, 137, 

    183, 122, 117, 178, 117, 112, 178, 115, 110, 180, 117, 112, 181, 118, 113, 179, 116, 111, 
    179, 116, 111, 181, 118, 113, 191, 126, 122, 190, 125, 121, 191, 126, 122, 196, 131, 127, 
    205, 137, 134, 207, 139, 136, 205, 137, 134, 199, 136, 127, 173, 116, 96, 249, 217, 204, 
    181, 186, 205, 123, 151, 190, 64, 97, 150, 88, 110, 159, 206, 203, 230, 181, 160, 175, 
    255, 230, 238, 133, 110, 126, 235, 230, 255, 88, 111, 165, 83, 137, 201, 57, 137, 198, 
    59, 159, 208, 87, 166, 183, 202, 217, 184, 99, 76, 24, 165, 128, 84, 207, 177, 185, 
    56, 58, 159, 43, 62, 180, 53, 75, 133, 235, 218, 236, 186, 84, 80, 227, 96, 50, 243, 136, 30, 
    189, 124, 30, 131, 128, 121, 117, 145, 182, 

    238, 109, 51, 232, 103, 45, 229, 100, 42, 231, 102, 44, 234, 104, 46, 232, 102, 44, 
    234, 101, 44, 236, 103, 46, 248, 113, 57, 243, 108, 52, 237, 102, 46, 232, 97, 41, 
    227, 90, 35, 217, 80, 25, 203, 66, 11, 192, 55, 1, 201, 66, 18, 226, 102, 50, 229, 127, 61, 
    226, 135, 64, 223, 130, 63, 221, 116, 58, 231, 108, 66, 244, 103, 73, 227, 68, 46, 
    197, 48, 24, 154, 42, 5, 202, 134, 89, 232, 210, 161, 193, 179, 144, 242, 195, 189, 
    158, 81, 71, 148, 43, 0, 240, 117, 50, 211, 76, 10, 215, 80, 35, 195, 67, 66, 178, 57, 62, 
    187, 72, 45, 187, 63, 11, 255, 108, 38, 250, 97, 3, 255, 126, 3, 244, 120, 6, 204, 100, 29, 
    193, 98, 50, 

    255, 101, 10, 255, 96, 5, 251, 92, 1, 253, 94, 3, 255, 95, 5, 255, 95, 5, 255, 95, 5, 
    255, 95, 6, 255, 91, 2, 250, 86, 0, 246, 81, 0, 246, 81, 0, 250, 85, 0, 255, 91, 2, 
    255, 93, 5, 255, 92, 11, 255, 88, 18, 253, 86, 8, 255, 100, 0, 249, 96, 0, 239, 80, 0, 
    247, 81, 0, 238, 62, 0, 222, 30, 0, 227, 20, 0, 255, 72, 15, 231, 69, 0, 198, 74, 0, 
    168, 82, 0, 174, 88, 1, 169, 39, 0, 191, 36, 0, 255, 102, 34, 255, 91, 10, 255, 98, 15, 
    255, 95, 15, 251, 67, 3, 255, 80, 15, 255, 85, 9, 255, 96, 6, 255, 91, 0, 255, 110, 0, 
    248, 94, 0, 254, 101, 0, 245, 92, 0, 255, 103, 10, 

    255, 104, 6, 255, 104, 6, 255, 103, 5, 255, 102, 4, 255, 101, 3, 253, 99, 1, 253, 99, 1, 
    254, 97, 0, 255, 101, 4, 255, 101, 4, 255, 101, 4, 255, 101, 4, 255, 101, 4, 255, 101, 4, 
    255, 101, 4, 255, 100, 6, 250, 86, 0, 245, 80, 0, 232, 73, 0, 226, 67, 0, 230, 69, 0, 
    240, 77, 0, 254, 86, 0, 255, 93, 6, 255, 95, 12, 255, 94, 10, 255, 96, 4, 245, 99, 0, 
    235, 103, 2, 237, 104, 9, 248, 102, 19, 255, 101, 19, 255, 101, 9, 255, 101, 6, 255, 101, 4, 
    255, 100, 4, 255, 99, 9, 255, 99, 9, 255, 100, 6, 255, 101, 2, 255, 102, 0, 255, 103, 0, 
    255, 104, 0, 255, 104, 0, 255, 104, 1, 255, 103, 2, 

    255, 105, 2, 255, 105, 2, 255, 104, 1, 255, 104, 1, 254, 103, 0, 253, 102, 0, 252, 101, 0, 
    252, 101, 0, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 103, 1, 255, 104, 6, 255, 103, 5, 255, 100, 2, 255, 99, 1, 255, 99, 1, 
    255, 102, 4, 255, 106, 8, 255, 109, 10, 255, 102, 3, 255, 101, 2, 255, 99, 0, 255, 99, 0, 
    255, 99, 0, 255, 100, 0, 255, 102, 2, 255, 103, 3, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 

    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 254, 103, 0, 254, 103, 0, 254, 103, 0, 
    254, 103, 0, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 103, 1, 255, 100, 1, 255, 100, 2, 255, 101, 3, 255, 101, 3, 255, 101, 3, 
    255, 100, 2, 255, 99, 1, 255, 99, 0, 255, 103, 4, 255, 103, 3, 255, 103, 3, 255, 102, 2, 
    255, 102, 2, 255, 103, 3, 255, 103, 3, 255, 104, 4, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 

    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 103, 1, 255, 103, 4, 255, 102, 3, 255, 99, 1, 255, 99, 0, 255, 98, 0, 
    255, 99, 0, 255, 100, 1, 255, 101, 1, 255, 103, 3, 255, 103, 3, 255, 104, 4, 255, 104, 4, 
    255, 104, 4, 255, 104, 4, 255, 103, 3, 255, 103, 3, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 

    254, 103, 0, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 103, 1, 255, 106, 6, 255, 105, 5, 255, 102, 3, 255, 102, 2, 255, 102, 2, 
    255, 103, 3, 255, 105, 5, 255, 106, 6, 255, 102, 2, 255, 102, 2, 255, 103, 3, 255, 104, 3, 
    255, 104, 3, 255, 104, 3, 255, 103, 2, 255, 103, 2, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 

    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 251, 97, 0, 252, 98, 0, 255, 100, 0, 255, 101, 1, 255, 102, 2, 
    255, 101, 1, 254, 100, 0, 253, 99, 0, 255, 101, 1, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 254, 102, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 

    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 253, 102, 0, 255, 104, 1, 255, 105, 3, 255, 108, 5, 255, 108, 5, 
    255, 107, 4, 255, 105, 2, 254, 103, 0, 255, 104, 1, 253, 104, 1, 253, 104, 1, 253, 104, 1, 
    253, 104, 1, 253, 104, 1, 253, 104, 1, 253, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1, 
    255, 104, 1, 255, 104, 1, 255, 104, 1, 255, 104, 1 
};

static const uint8  jpeg_24bit_j30[JPEGY][JPEGX][3] =
{
    235, 112, 16, 235, 112, 16, 235, 112, 16, 235, 112, 16, 235, 112, 16, 235, 112, 16, 
    235, 112, 16, 235, 112, 16, 230, 107, 11, 231, 108, 12, 232, 109, 13, 234, 111, 15, 
    236, 113, 17, 238, 115, 19, 239, 116, 20, 247, 113, 24, 255, 100, 25, 255, 95, 30, 
    255, 96, 32, 255, 96, 35, 255, 95, 41, 255, 95, 42, 255, 95, 46, 255, 95, 46, 252, 88, 37, 
    254, 88, 36, 255, 90, 32, 255, 90, 28, 255, 91, 25, 255, 92, 21, 255, 93, 17, 255, 98, 14, 
    250, 106, 10, 247, 107, 12, 255, 100, 19, 255, 96, 25, 255, 93, 30, 255, 95, 30, 
    255, 99, 28, 242, 108, 23, 228, 116, 16, 215, 124, 10, 210, 127, 9, 210, 127, 9, 
    217, 122, 16, 221, 119, 18, 

    245, 110, 3, 245, 110, 3, 245, 110, 3, 245, 110, 3, 245, 110, 3, 245, 110, 3, 245, 110, 3, 
    245, 110, 3, 241, 106, 0, 241, 106, 0, 242, 107, 0, 244, 109, 2, 245, 110, 3, 247, 112, 5, 
    248, 113, 6, 251, 112, 9, 250, 102, 6, 253, 99, 9, 251, 100, 11, 251, 99, 15, 250, 99, 20, 
    249, 99, 23, 249, 98, 25, 249, 98, 25, 249, 98, 25, 250, 98, 22, 251, 98, 18, 255, 99, 14, 
    255, 99, 8, 255, 100, 4, 255, 100, 1, 255, 100, 0, 255, 102, 0, 255, 101, 3, 255, 99, 7, 
    255, 98, 12, 255, 99, 14, 255, 101, 16, 252, 104, 14, 247, 107, 10, 242, 111, 5, 
    238, 114, 2, 235, 116, 0, 233, 116, 2, 235, 115, 5, 236, 113, 7, 

    255, 104, 0, 255, 104, 0, 255, 104, 0, 255, 104, 0, 255, 104, 0, 255, 104, 0, 255, 104, 0, 
    255, 104, 0, 255, 100, 0, 255, 100, 0, 255, 101, 0, 255, 102, 0, 255, 103, 0, 255, 104, 0, 
    255, 105, 0, 255, 109, 0, 243, 110, 0, 238, 112, 0, 236, 113, 0, 236, 112, 0, 235, 112, 0, 
    235, 111, 0, 235, 111, 0, 235, 111, 0, 241, 117, 0, 242, 116, 0, 243, 115, 0, 244, 116, 0, 
    245, 115, 0, 245, 114, 0, 246, 114, 0, 255, 107, 0, 255, 94, 0, 255, 90, 0, 255, 97, 0, 
    255, 104, 0, 247, 112, 0, 242, 115, 0, 246, 113, 0, 255, 108, 0, 255, 99, 0, 255, 94, 0, 
    255, 92, 0, 255, 94, 0, 255, 100, 0, 255, 103, 0, 

    255, 103, 0, 255, 104, 0, 255, 103, 0, 255, 104, 0, 255, 103, 0, 255, 104, 0, 255, 103, 0, 
    255, 104, 0, 255, 99, 0, 255, 101, 0, 255, 100, 0, 255, 101, 0, 255, 101, 0, 255, 102, 0, 
    255, 101, 0, 255, 105, 0, 251, 113, 0, 244, 116, 0, 244, 116, 0, 244, 115, 0, 242, 115, 0, 
    242, 114, 0, 242, 114, 0, 244, 113, 0, 249, 118, 0, 249, 118, 0, 249, 117, 0, 248, 117, 0, 
    248, 116, 0, 247, 116, 0, 248, 115, 0, 255, 108, 0, 255, 97, 0, 255, 93, 0, 255, 99, 0, 
    255, 105, 0, 252, 113, 0, 249, 114, 0, 253, 111, 0, 255, 106, 0, 255, 97, 0, 255, 93, 0, 
    255, 90, 0, 255, 92, 0, 255, 97, 0, 255, 100, 0, 

    255, 106, 0, 254, 106, 0, 255, 106, 0, 254, 106, 0, 255, 106, 0, 254, 106, 0, 255, 106, 0, 
    254, 106, 0, 253, 103, 0, 251, 103, 0, 253, 103, 0, 250, 102, 0, 252, 102, 0, 250, 102, 0, 
    251, 101, 0, 252, 101, 0, 255, 107, 0, 255, 106, 0, 255, 105, 0, 255, 105, 0, 255, 104, 0, 
    255, 103, 0, 255, 102, 0, 255, 101, 0, 255, 100, 0, 255, 100, 0, 255, 101, 0, 255, 102, 0, 
    255, 103, 0, 255, 102, 0, 255, 103, 0, 255, 106, 0, 236, 111, 21, 233, 111, 26, 250, 107, 5, 
    255, 104, 0, 255, 101, 0, 255, 100, 0, 255, 101, 0, 255, 103, 0, 249, 106, 14, 238, 108, 30, 
    232, 109, 39, 235, 109, 35, 246, 106, 19, 252, 105, 10, 

    250, 107, 5, 250, 107, 5, 250, 107, 5, 250, 107, 5, 250, 107, 5, 250, 107, 5, 250, 107, 5, 
    250, 107, 5, 248, 105, 3, 247, 104, 2, 246, 103, 1, 245, 102, 0, 244, 101, 0, 243, 100, 0, 
    242, 99, 0, 246, 98, 0, 255, 103, 0, 255, 101, 0, 255, 99, 0, 255, 98, 0, 255, 97, 0, 
    255, 96, 3, 255, 94, 7, 255, 94, 9, 255, 87, 2, 255, 88, 0, 255, 90, 0, 255, 94, 0, 
    255, 95, 0, 255, 98, 0, 255, 101, 0, 252, 107, 0, 222, 119, 18, 217, 120, 25, 235, 112, 16, 
    253, 105, 7, 255, 98, 0, 255, 96, 0, 255, 97, 3, 255, 102, 9, 242, 108, 19, 229, 113, 26, 
    224, 115, 30, 226, 114, 28, 240, 109, 21, 247, 106, 18, 

    252, 106, 7, 252, 106, 7, 252, 106, 7, 252, 106, 7, 252, 106, 7, 252, 106, 7, 252, 106, 7, 
    252, 106, 7, 250, 104, 5, 249, 103, 4, 248, 102, 3, 247, 101, 2, 245, 99, 0, 244, 98, 0, 
    242, 96, 0, 243, 96, 0, 247, 100, 0, 249, 99, 0, 250, 98, 0, 252, 96, 0, 253, 94, 0, 
    254, 93, 5, 255, 91, 9, 255, 90, 12, 244, 81, 2, 244, 83, 3, 246, 87, 3, 246, 92, 2, 
    247, 99, 3, 248, 105, 3, 249, 108, 2, 245, 115, 0, 233, 120, 0, 229, 121, 0, 231, 115, 14, 
    232, 110, 37, 235, 104, 58, 239, 101, 64, 245, 101, 51, 250, 102, 32, 254, 105, 2, 
    255, 108, 0, 255, 109, 0, 255, 108, 0, 255, 104, 0, 255, 102, 5, 

    255, 103, 5, 255, 104, 5, 255, 103, 5, 255, 104, 5, 255, 103, 5, 255, 104, 5, 255, 103, 5, 
    255, 104, 5, 255, 101, 3, 253, 101, 2, 253, 99, 1, 250, 98, 0, 249, 95, 0, 247, 95, 0, 
    246, 92, 0, 247, 91, 0, 247, 88, 0, 250, 86, 0, 252, 84, 0, 253, 83, 0, 255, 80, 4, 
    255, 79, 9, 255, 77, 14, 255, 77, 18, 248, 67, 10, 249, 70, 12, 248, 76, 12, 248, 83, 15, 
    251, 91, 17, 251, 98, 18, 252, 104, 18, 249, 110, 5, 242, 116, 0, 236, 118, 0, 228, 117, 12, 
    222, 114, 39, 219, 111, 62, 224, 108, 67, 235, 105, 55, 249, 102, 32, 255, 101, 0, 
    255, 99, 0, 255, 99, 0, 255, 99, 0, 255, 98, 0, 255, 99, 5, 

    255, 97, 0, 255, 97, 0, 255, 97, 0, 255, 97, 0, 255, 97, 0, 255, 97, 0, 255, 97, 0, 
    255, 97, 0, 245, 82, 0, 255, 96, 0, 255, 111, 10, 255, 114, 13, 255, 106, 5, 255, 98, 0, 
    255, 96, 0, 255, 95, 1, 255, 84, 4, 255, 62, 0, 245, 31, 0, 234, 18, 0, 255, 36, 0, 
    255, 66, 26, 255, 71, 38, 255, 56, 29, 255, 80, 55, 255, 35, 10, 225, 6, 0, 231, 21, 0, 
    254, 53, 11, 255, 64, 16, 244, 57, 4, 224, 55, 0, 204, 62, 0, 204, 82, 0, 164, 52, 0, 
    208, 103, 0, 255, 160, 52, 219, 108, 3, 217, 87, 0, 255, 128, 37, 255, 100, 20, 255, 93, 18, 
    255, 88, 19, 255, 91, 20, 255, 97, 19, 255, 99, 18, 

    233, 101, 29, 233, 101, 29, 233, 101, 29, 233, 101, 29, 233, 101, 29, 233, 101, 29, 
    233, 101, 29, 233, 101, 29, 225, 93, 21, 232, 100, 28, 239, 107, 35, 239, 107, 35, 
    236, 104, 32, 238, 106, 34, 248, 116, 44, 255, 124, 59, 235, 101, 50, 255, 122, 80, 
    255, 121, 87, 233, 85, 59, 202, 47, 29, 200, 42, 33, 221, 58, 59, 236, 73, 78, 182, 21, 29, 
    210, 53, 60, 243, 94, 96, 243, 105, 102, 207, 79, 70, 173, 56, 39, 186, 75, 55, 215, 117, 90, 
    197, 116, 86, 234, 162, 114, 248, 174, 103, 124, 45, 0, 139, 53, 0, 251, 155, 43, 
    217, 104, 10, 203, 76, 5, 205, 63, 25, 204, 54, 39, 207, 54, 49, 217, 66, 57, 227, 87, 54, 
    233, 96, 52, 

    186, 122, 110, 186, 122, 110, 186, 122, 110, 186, 122, 110, 186, 122, 110, 186, 122, 110, 
    186, 122, 110, 186, 122, 110, 180, 116, 104, 180, 116, 104, 177, 113, 101, 173, 109, 97, 
    175, 111, 99, 188, 124, 112, 207, 143, 131, 202, 169, 154, 150, 174, 158, 163, 213, 201, 
    177, 219, 215, 137, 175, 178, 88, 117, 131, 70, 92, 115, 80, 99, 131, 93, 111, 149, 
    95, 114, 156, 103, 131, 170, 120, 156, 192, 122, 171, 201, 94, 156, 179, 59, 132, 149, 
    49, 131, 143, 68, 144, 158, 133, 189, 216, 174, 205, 225, 149, 151, 140, 234, 208, 171, 
    226, 170, 113, 165, 93, 35, 241, 163, 124, 195, 123, 111, 155, 97, 122, 123, 79, 130, 
    96, 60, 124, 92, 57, 115, 118, 73, 102, 146, 98, 114, 

    91, 68, 94, 89, 69, 94, 91, 68, 94, 89, 69, 94, 91, 68, 94, 89, 69, 94, 91, 68, 94, 
    89, 69, 94, 84, 61, 87, 78, 58, 83, 74, 51, 77, 69, 49, 74, 75, 52, 78, 85, 65, 90, 
    103, 80, 106, 86, 104, 124, 53, 149, 161, 34, 166, 178, 27, 152, 172, 5, 123, 151, 
    0, 99, 138, 0, 88, 138, 0, 75, 136, 0, 60, 127, 0, 96, 165, 0, 87, 155, 0, 94, 158, 
    0, 124, 182, 9, 154, 207, 17, 175, 220, 30, 198, 237, 60, 212, 249, 38, 146, 182, 
    39, 114, 145, 184, 230, 254, 118, 136, 158, 83, 71, 91, 193, 165, 187, 150, 117, 148, 
    135, 107, 147, 74, 60, 111, 72, 68, 127, 66, 74, 136, 63, 72, 131, 61, 65, 113, 61, 62, 106, 


    78, 71, 113, 77, 72, 113, 78, 71, 113, 77, 72, 113, 78, 71, 113, 77, 72, 113, 78, 71, 113, 
    77, 72, 113, 79, 72, 114, 74, 69, 110, 72, 65, 107, 70, 65, 106, 74, 67, 109, 76, 71, 112, 
    80, 73, 115, 60, 84, 122, 38, 121, 153, 28, 137, 168, 27, 129, 169, 16, 108, 159, 
    16, 97, 160, 29, 103, 176, 36, 104, 187, 30, 97, 186, 19, 89, 184, 19, 100, 192, 
    20, 114, 202, 8, 117, 199, 0, 105, 182, 0, 108, 177, 0, 148, 212, 64, 192, 229, 90, 170, 159, 
    128, 184, 171, 49, 108, 142, 74, 129, 209, 7, 56, 175, 0, 20, 152, 142, 161, 255, 
    106, 108, 195, 51, 36, 77, 113, 90, 96, 176, 152, 140, 187, 172, 165, 140, 145, 167, 
    86, 100, 137, 

    172, 124, 136, 171, 125, 136, 172, 124, 136, 171, 125, 136, 172, 124, 136, 171, 125, 136, 
    172, 124, 136, 171, 125, 136, 185, 137, 149, 181, 135, 146, 179, 131, 143, 179, 133, 144, 
    182, 134, 146, 179, 133, 144, 172, 124, 136, 149, 123, 132, 108, 126, 128, 135, 170, 172, 
    162, 190, 201, 147, 165, 187, 126, 132, 166, 135, 134, 178, 169, 161, 218, 195, 186, 249, 
    176, 171, 238, 150, 155, 221, 131, 151, 212, 128, 163, 219, 114, 166, 214, 84, 151, 193, 
    60, 138, 174, 69, 133, 142, 206, 228, 189, 64, 71, 30, 118, 131, 139, 135, 151, 202, 
    90, 105, 196, 58, 61, 164, 49, 33, 122, 225, 187, 246, 150, 90, 102, 200, 129, 107, 
    241, 170, 128, 233, 173, 136, 183, 149, 140, 145, 124, 129, 

    241, 96, 31, 240, 97, 31, 241, 96, 31, 240, 97, 31, 241, 96, 31, 240, 97, 31, 241, 96, 31, 
    240, 97, 31, 255, 111, 46, 247, 104, 38, 242, 97, 32, 241, 98, 32, 246, 101, 36, 
    244, 101, 35, 237, 92, 27, 217, 88, 20, 184, 87, 8, 212, 125, 46, 240, 143, 74, 229, 123, 65, 
    212, 94, 48, 216, 89, 54, 232, 100, 77, 243, 110, 93, 233, 103, 90, 192, 72, 58, 
    177, 71, 55, 215, 127, 105, 255, 191, 160, 255, 205, 167, 217, 174, 131, 183, 139, 92, 
    99, 39, 0, 208, 135, 80, 180, 96, 34, 179, 81, 16, 193, 78, 13, 193, 65, 2, 237, 98, 43, 
    195, 48, 4, 242, 95, 61, 236, 93, 63, 219, 84, 55, 193, 69, 35, 174, 61, 17, 178, 72, 20, 


    255, 91, 0, 255, 91, 0, 255, 91, 0, 255, 91, 0, 255, 91, 0, 255, 91, 0, 255, 91, 0, 
    255, 91, 0, 255, 97, 0, 255, 86, 0, 255, 74, 0, 255, 73, 0, 255, 80, 0, 255, 83, 0, 
    255, 79, 0, 248, 76, 0, 254, 98, 0, 249, 100, 0, 247, 90, 0, 250, 87, 0, 255, 92, 3, 
    255, 91, 9, 242, 58, 0, 204, 19, 0, 217, 35, 0, 214, 41, 0, 220, 57, 0, 223, 72, 1, 
    202, 66, 0, 173, 48, 0, 162, 46, 0, 169, 58, 0, 227, 114, 46, 244, 122, 49, 242, 104, 6, 
    230, 75, 0, 255, 96, 0, 255, 78, 0, 236, 47, 0, 255, 117, 18, 255, 99, 30, 255, 94, 44, 
    255, 94, 53, 255, 100, 51, 255, 107, 34, 254, 104, 19, 

    255, 102, 0, 255, 102, 0, 255, 102, 0, 255, 102, 0, 255, 102, 0, 255, 102, 0, 255, 102, 0, 
    255, 102, 0, 255, 102, 0, 255, 102, 0, 255, 102, 0, 255, 102, 0, 255, 102, 0, 255, 102, 0, 
    255, 102, 0, 255, 102, 0, 253, 100, 0, 244, 93, 0, 234, 81, 0, 228, 72, 0, 229, 71, 0, 
    238, 78, 0, 251, 88, 0, 255, 96, 5, 255, 100, 10, 255, 101, 10, 255, 102, 10, 254, 104, 10, 
    252, 105, 10, 249, 106, 10, 247, 107, 10, 246, 107, 12, 246, 107, 16, 247, 106, 14, 
    253, 105, 5, 255, 105, 0, 255, 104, 0, 255, 103, 0, 255, 101, 0, 255, 101, 0, 255, 100, 9, 
    255, 100, 16, 255, 101, 19, 254, 102, 18, 254, 104, 10, 254, 104, 7, 

    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 111, 8, 255, 106, 3, 249, 98, 0, 243, 92, 0, 243, 92, 0, 
    249, 98, 0, 255, 106, 3, 255, 111, 8, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 

    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 112, 9, 255, 110, 7, 255, 108, 5, 255, 106, 3, 255, 106, 3, 
    255, 108, 5, 255, 110, 7, 255, 112, 9, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 

    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 252, 101, 0, 254, 103, 0, 255, 104, 1, 255, 105, 2, 255, 105, 2, 
    255, 104, 1, 254, 103, 0, 252, 101, 0, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 

    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 247, 96, 0, 250, 99, 0, 253, 102, 0, 255, 104, 1, 255, 104, 1, 
    253, 102, 0, 250, 99, 0, 247, 96, 0, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 

    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 253, 102, 0, 255, 104, 1, 255, 106, 3, 255, 108, 5, 255, 108, 5, 
    255, 106, 3, 255, 104, 1, 253, 102, 0, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 

    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 107, 4, 255, 106, 3, 255, 106, 3, 255, 105, 2, 255, 105, 2, 
    255, 106, 3, 255, 106, 3, 255, 107, 4, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2, 
    255, 105, 2, 255, 105, 2, 255, 105, 2, 255, 105, 2 
};

static const uint8  jpeg_24bit_j75[JPEGY][JPEGX][3] =
{
    252, 104, 4, 252, 104, 4, 252, 104, 4, 252, 104, 4, 252, 104, 4, 252, 104, 4, 252, 104, 4, 
    252, 104, 4, 252, 104, 4, 252, 104, 4, 252, 104, 4, 252, 104, 4, 252, 104, 4, 252, 104, 4, 
    252, 104, 4, 246, 108, 1, 241, 118, 0, 237, 119, 0, 242, 112, 0, 250, 104, 1, 255, 96, 3, 
    255, 94, 5, 255, 97, 10, 255, 103, 13, 246, 107, 14, 247, 106, 16, 255, 97, 15, 255, 91, 11, 
    255, 87, 6, 255, 93, 0, 255, 105, 0, 252, 112, 0, 253, 107, 0, 251, 108, 0, 245, 110, 0, 
    242, 110, 1, 248, 105, 13, 251, 104, 11, 255, 104, 0, 253, 106, 0, 249, 107, 0, 249, 108, 0, 
    253, 108, 0, 255, 106, 0, 255, 101, 0, 255, 98, 0, 

    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 251, 99, 0, 252, 100, 0, 252, 100, 0, 253, 101, 0, 254, 102, 1, 255, 103, 2, 
    255, 103, 2, 252, 107, 2, 238, 108, 0, 236, 109, 0, 246, 105, 0, 255, 100, 0, 255, 95, 3, 
    255, 94, 3, 255, 98, 3, 254, 101, 5, 244, 106, 5, 246, 106, 8, 255, 99, 8, 255, 94, 5, 
    255, 91, 3, 255, 94, 0, 250, 102, 0, 245, 104, 0, 255, 103, 0, 255, 103, 0, 249, 108, 0, 
    246, 109, 0, 249, 106, 2, 252, 104, 4, 255, 103, 1, 255, 104, 0, 251, 106, 0, 251, 107, 0, 
    255, 106, 0, 255, 104, 0, 255, 101, 0, 255, 100, 1, 

    255, 101, 0, 255, 101, 0, 255, 101, 0, 255, 101, 0, 255, 101, 0, 255, 101, 0, 255, 101, 0, 
    255, 101, 0, 255, 101, 0, 255, 102, 0, 255, 102, 0, 255, 102, 0, 255, 103, 1, 255, 103, 1, 
    255, 103, 1, 255, 105, 3, 247, 104, 2, 250, 104, 3, 255, 100, 5, 255, 96, 6, 255, 95, 4, 
    255, 97, 2, 255, 103, 0, 248, 106, 0, 245, 110, 0, 249, 109, 0, 255, 106, 0, 255, 104, 0, 
    255, 103, 4, 253, 103, 6, 242, 106, 7, 245, 102, 8, 255, 95, 9, 255, 95, 2, 255, 103, 0, 
    253, 108, 0, 252, 109, 0, 253, 107, 0, 255, 100, 9, 255, 100, 11, 255, 105, 0, 255, 105, 0, 
    255, 100, 15, 255, 99, 24, 251, 102, 18, 249, 103, 17, 

    255, 102, 0, 255, 102, 0, 255, 102, 0, 255, 102, 0, 255, 102, 0, 255, 102, 0, 255, 102, 0, 
    255, 102, 0, 255, 106, 0, 255, 105, 0, 255, 105, 0, 255, 104, 0, 255, 103, 0, 255, 103, 0, 
    255, 102, 0, 255, 103, 0, 255, 107, 11, 255, 104, 11, 255, 97, 5, 255, 94, 0, 255, 96, 0, 
    255, 100, 0, 250, 106, 0, 243, 109, 0, 246, 110, 0, 249, 109, 0, 253, 107, 0, 253, 108, 0, 
    249, 109, 0, 244, 112, 4, 241, 111, 15, 248, 107, 19, 255, 96, 15, 255, 95, 6, 255, 100, 0, 
    255, 104, 0, 255, 106, 0, 255, 105, 0, 255, 100, 17, 255, 99, 15, 255, 103, 0, 255, 103, 0, 
    255, 99, 13, 255, 99, 22, 249, 103, 18, 245, 105, 17, 

    252, 106, 0, 252, 106, 0, 252, 106, 0, 252, 106, 0, 252, 106, 0, 252, 106, 0, 252, 106, 0, 
    252, 106, 0, 251, 105, 0, 251, 105, 0, 251, 105, 0, 251, 105, 0, 251, 105, 0, 250, 104, 0, 
    250, 104, 0, 249, 104, 0, 252, 105, 9, 255, 100, 6, 255, 93, 0, 255, 93, 0, 255, 98, 0, 
    255, 106, 0, 241, 112, 0, 239, 114, 0, 249, 110, 0, 252, 107, 0, 250, 106, 0, 246, 106, 0, 
    236, 111, 0, 236, 113, 0, 240, 112, 5, 246, 110, 11, 251, 104, 11, 255, 101, 8, 255, 97, 2, 
    255, 97, 2, 255, 99, 11, 253, 101, 17, 249, 103, 18, 253, 103, 9, 255, 101, 0, 255, 100, 0, 
    255, 101, 0, 255, 103, 0, 255, 104, 0, 251, 106, 1, 

    251, 106, 0, 251, 106, 0, 251, 106, 0, 251, 106, 0, 251, 106, 0, 251, 106, 0, 251, 106, 0, 
    251, 106, 0, 250, 105, 0, 250, 105, 0, 251, 106, 0, 251, 106, 0, 252, 107, 0, 253, 108, 0, 
    253, 108, 0, 254, 109, 4, 250, 104, 5, 255, 100, 1, 255, 95, 0, 255, 98, 0, 255, 106, 0, 
    255, 112, 0, 245, 117, 0, 244, 118, 0, 255, 110, 1, 255, 106, 4, 255, 105, 3, 253, 106, 0, 
    244, 110, 0, 243, 112, 0, 250, 110, 0, 254, 110, 0, 249, 107, 0, 255, 104, 1, 255, 97, 2, 
    255, 95, 9, 255, 98, 20, 249, 103, 20, 242, 108, 9, 246, 107, 2, 255, 101, 0, 255, 98, 0, 
    255, 102, 0, 255, 104, 0, 255, 105, 0, 252, 105, 0, 

    255, 101, 8, 255, 101, 8, 255, 101, 8, 255, 101, 8, 255, 101, 8, 255, 101, 8, 255, 101, 8, 
    255, 101, 8, 255, 103, 10, 255, 102, 9, 255, 102, 9, 255, 101, 8, 255, 100, 7, 255, 100, 7, 
    255, 99, 6, 254, 100, 2, 249, 101, 0, 255, 102, 0, 255, 99, 4, 255, 102, 7, 255, 105, 5, 
    253, 108, 0, 242, 109, 0, 240, 104, 0, 251, 93, 2, 255, 90, 17, 255, 89, 32, 255, 93, 37, 
    255, 101, 27, 255, 105, 10, 255, 106, 0, 255, 106, 0, 255, 104, 0, 255, 102, 0, 255, 96, 0, 
    255, 96, 6, 252, 103, 13, 242, 109, 8, 235, 116, 0, 238, 114, 0, 252, 103, 13, 255, 98, 17, 
    255, 102, 0, 255, 104, 0, 252, 104, 4, 251, 104, 8, 

    255, 99, 11, 255, 100, 9, 255, 99, 11, 255, 100, 9, 255, 99, 11, 255, 100, 9, 255, 99, 11, 
    255, 100, 9, 255, 100, 12, 255, 99, 8, 255, 96, 8, 252, 93, 2, 248, 88, 0, 245, 86, 0, 
    242, 82, 0, 242, 81, 0, 252, 88, 0, 255, 92, 0, 255, 93, 7, 255, 95, 15, 255, 95, 12, 
    247, 89, 2, 235, 82, 0, 233, 73, 0, 237, 65, 0, 248, 64, 10, 255, 70, 32, 255, 78, 42, 
    255, 86, 37, 255, 90, 20, 255, 94, 0, 255, 96, 0, 255, 104, 0, 255, 104, 0, 255, 99, 4, 
    255, 99, 9, 251, 104, 9, 242, 110, 2, 238, 114, 0, 241, 112, 0, 251, 103, 15, 255, 100, 18, 
    255, 102, 8, 255, 103, 2, 252, 104, 4, 252, 104, 4, 

    255, 106, 11, 255, 103, 6, 255, 102, 7, 255, 103, 6, 255, 101, 6, 252, 95, 0, 250, 93, 0, 
    251, 94, 0, 254, 97, 2, 255, 99, 2, 255, 103, 8, 255, 104, 7, 255, 103, 8, 255, 100, 3, 
    253, 96, 1, 255, 89, 0, 255, 72, 0, 253, 56, 0, 248, 64, 0, 231, 53, 0, 202, 24, 0, 
    255, 74, 9, 255, 81, 26, 255, 67, 16, 255, 64, 16, 247, 49, 4, 255, 64, 21, 217, 10, 0, 
    242, 33, 0, 255, 62, 15, 255, 66, 17, 220, 46, 0, 188, 52, 0, 201, 78, 0, 194, 59, 0, 
    241, 98, 19, 244, 97, 4, 255, 115, 17, 253, 105, 9, 253, 103, 6, 252, 101, 0, 255, 109, 4, 
    254, 102, 1, 251, 100, 0, 248, 97, 0, 248, 98, 0, 

    232, 107, 41, 229, 104, 38, 228, 103, 37, 231, 106, 40, 230, 105, 39, 226, 101, 35, 
    224, 99, 33, 227, 102, 36, 208, 83, 17, 219, 94, 28, 231, 106, 40, 237, 112, 46, 
    238, 113, 47, 240, 115, 49, 246, 121, 55, 255, 124, 60, 255, 112, 55, 250, 111, 56, 
    214, 99, 44, 192, 87, 42, 220, 108, 86, 175, 51, 49, 184, 45, 64, 248, 106, 130, 
    195, 63, 76, 171, 46, 42, 197, 72, 50, 235, 110, 80, 211, 81, 55, 185, 60, 40, 195, 84, 77, 
    189, 106, 90, 150, 106, 59, 221, 188, 134, 233, 184, 141, 118, 45, 0, 227, 117, 38, 
    249, 115, 30, 237, 90, 20, 230, 92, 30, 197, 86, 30, 192, 97, 49, 172, 78, 42, 180, 79, 35, 
    214, 98, 25, 242, 118, 30, 

    187, 117, 119, 185, 115, 117, 185, 115, 117, 188, 118, 120, 189, 119, 121, 186, 116, 118, 
    186, 116, 118, 189, 119, 121, 194, 124, 126, 191, 121, 123, 182, 112, 114, 169, 99, 101, 
    163, 93, 95, 177, 107, 109, 206, 136, 138, 220, 166, 154, 191, 167, 129, 181, 188, 144, 
    175, 214, 185, 157, 204, 210, 0, 29, 85, 108, 126, 226, 86, 84, 219, 84, 82, 218, 
    90, 108, 218, 77, 111, 183, 100, 145, 174, 109, 162, 166, 136, 190, 192, 60, 124, 133, 
    79, 160, 189, 46, 148, 173, 106, 225, 231, 117, 237, 238, 83, 184, 196, 152, 199, 193, 
    139, 102, 49, 216, 125, 55, 230, 113, 59, 206, 113, 98, 133, 110, 162, 58, 74, 162, 
    38, 56, 156, 76, 73, 150, 136, 91, 112, 161, 94, 86, 

    99, 64, 97, 96, 61, 93, 96, 61, 94, 99, 64, 96, 100, 65, 98, 97, 62, 94, 98, 63, 96, 
    102, 67, 99, 93, 58, 91, 97, 62, 94, 99, 64, 97, 95, 60, 92, 92, 57, 90, 98, 63, 95, 
    113, 78, 111, 114, 100, 115, 96, 125, 103, 135, 203, 178, 82, 179, 185, 0, 103, 149, 
    11, 108, 205, 0, 29, 164, 12, 72, 230, 0, 53, 205, 0, 76, 194, 30, 130, 215, 0, 110, 160, 
    6, 136, 170, 4, 142, 178, 12, 163, 206, 0, 169, 228, 33, 207, 255, 0, 153, 175, 28, 179, 196, 
    67, 197, 231, 127, 212, 243, 86, 99, 108, 162, 124, 123, 203, 142, 141, 189, 139, 166, 
    51, 47, 131, 9, 36, 143, 70, 103, 206, 28, 54, 138, 47, 51, 99, 109, 102, 135, 

    94, 69, 98, 91, 67, 93, 90, 65, 94, 92, 68, 94, 92, 67, 96, 89, 65, 91, 90, 65, 94, 
    94, 70, 96, 89, 64, 93, 91, 67, 93, 93, 68, 97, 92, 68, 94, 88, 63, 92, 83, 59, 85, 
    79, 54, 83, 69, 58, 74, 65, 80, 75, 35, 75, 77, 4, 67, 111, 41, 112, 190, 40, 109, 213, 
    61, 122, 229, 67, 114, 202, 26, 71, 138, 35, 89, 133, 0, 66, 102, 0, 79, 125, 3, 109, 167, 
    1, 123, 198, 0, 132, 216, 0, 140, 225, 44, 180, 238, 71, 164, 169, 149, 212, 204, 
    56, 102, 125, 69, 105, 167, 25, 61, 171, 20, 49, 169, 168, 183, 255, 41, 31, 94, 
    85, 35, 70, 163, 102, 107, 161, 116, 87, 222, 208, 182, 153, 182, 196, 16, 66, 101, 


    182, 127, 124, 178, 123, 120, 176, 121, 118, 177, 122, 119, 176, 121, 118, 174, 119, 116, 
    175, 120, 117, 178, 123, 120, 185, 130, 127, 181, 126, 123, 180, 125, 122, 185, 130, 127, 
    193, 138, 135, 200, 145, 142, 201, 146, 143, 195, 146, 139, 162, 125, 107, 246, 223, 215, 
    166, 161, 181, 167, 172, 210, 81, 92, 138, 102, 107, 147, 211, 202, 221, 195, 176, 180, 
    255, 233, 231, 140, 128, 130, 189, 200, 222, 111, 146, 184, 96, 156, 210, 34, 108, 171, 
    102, 182, 245, 113, 169, 204, 202, 205, 184, 97, 69, 30, 160, 122, 109, 187, 158, 188, 
    60, 56, 151, 65, 72, 186, 50, 50, 136, 240, 208, 247, 185, 91, 66, 240, 123, 53, 
    248, 144, 45, 207, 139, 56, 145, 132, 113, 127, 141, 152, 

    235, 106, 48, 230, 101, 43, 228, 99, 41, 230, 101, 43, 229, 100, 42, 227, 98, 40, 
    229, 100, 42, 233, 104, 46, 242, 113, 55, 239, 110, 52, 235, 106, 48, 232, 103, 45, 
    226, 97, 39, 210, 81, 23, 189, 60, 2, 174, 45, 0, 197, 72, 14, 230, 115, 52, 222, 117, 49, 
    226, 134, 61, 206, 124, 50, 219, 132, 63, 216, 106, 55, 226, 93, 58, 230, 78, 57, 
    175, 27, 13, 176, 59, 39, 205, 121, 97, 230, 180, 155, 248, 213, 193, 212, 172, 164, 
    138, 73, 53, 146, 39, 0, 254, 130, 58, 208, 91, 14, 205, 93, 29, 198, 94, 57, 153, 51, 29, 
    176, 66, 49, 197, 78, 36, 249, 116, 23, 245, 104, 0, 253, 111, 3, 243, 105, 17, 218, 93, 39, 
    199, 81, 45, 

    255, 100, 11, 255, 96, 6, 255, 94, 5, 255, 96, 6, 255, 96, 7, 255, 95, 5, 255, 97, 8, 
    255, 102, 12, 255, 95, 6, 249, 88, 0, 242, 78, 0, 238, 77, 0, 246, 82, 0, 253, 92, 2, 
    255, 98, 9, 255, 101, 12, 255, 91, 6, 248, 87, 0, 255, 101, 0, 244, 100, 0, 220, 85, 0, 
    231, 91, 0, 232, 72, 0, 217, 38, 0, 221, 19, 0, 255, 77, 35, 234, 59, 4, 210, 63, 0, 
    192, 76, 1, 164, 57, 0, 161, 47, 0, 187, 54, 0, 255, 107, 31, 249, 81, 0, 255, 112, 7, 
    253, 101, 0, 227, 74, 0, 239, 84, 0, 255, 99, 21, 253, 93, 5, 250, 98, 0, 255, 106, 0, 
    255, 109, 0, 255, 91, 0, 255, 89, 12, 255, 102, 32, 

    255, 102, 5, 255, 103, 5, 255, 102, 5, 255, 102, 4, 255, 101, 4, 255, 101, 3, 255, 100, 3, 
    255, 101, 3, 255, 101, 4, 255, 102, 4, 255, 101, 4, 255, 102, 4, 255, 101, 4, 255, 102, 4, 
    255, 101, 4, 255, 101, 4, 251, 92, 0, 244, 86, 0, 233, 77, 0, 225, 72, 0, 223, 75, 0, 
    234, 83, 0, 250, 93, 0, 255, 98, 9, 255, 96, 14, 255, 95, 15, 255, 96, 11, 252, 98, 10, 
    245, 102, 10, 243, 104, 13, 246, 104, 18, 252, 104, 18, 255, 101, 9, 255, 101, 4, 
    255, 103, 1, 255, 104, 1, 255, 103, 2, 255, 103, 4, 255, 101, 8, 255, 102, 6, 255, 104, 0, 
    255, 104, 0, 255, 102, 0, 255, 101, 4, 255, 100, 8, 255, 100, 9, 

    255, 104, 3, 255, 104, 3, 255, 104, 3, 255, 103, 2, 255, 103, 2, 254, 102, 1, 254, 102, 1, 
    254, 102, 1, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 99, 0, 254, 98, 0, 253, 97, 0, 253, 97, 0, 254, 98, 0, 
    255, 100, 0, 255, 103, 3, 255, 105, 5, 255, 103, 3, 255, 102, 2, 255, 100, 0, 255, 99, 0, 
    255, 99, 0, 255, 100, 0, 255, 102, 2, 255, 103, 3, 255, 102, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 

    255, 104, 3, 255, 104, 3, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 254, 102, 1, 
    254, 102, 1, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 100, 0, 255, 102, 2, 255, 106, 6, 255, 108, 8, 255, 109, 9, 
    255, 107, 7, 255, 105, 5, 255, 103, 3, 255, 103, 3, 255, 102, 2, 255, 101, 1, 255, 100, 0, 
    255, 100, 0, 255, 101, 1, 255, 102, 2, 255, 103, 3, 255, 102, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 

    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 3, 255, 102, 2, 255, 102, 2, 255, 101, 1, 255, 101, 1, 
    255, 101, 1, 255, 102, 2, 255, 102, 2, 255, 103, 3, 255, 102, 2, 255, 101, 1, 255, 101, 1, 
    255, 101, 1, 255, 101, 1, 255, 102, 2, 255, 103, 3, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 

    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 106, 6, 255, 104, 4, 255, 102, 2, 255, 101, 1, 255, 101, 1, 
    255, 101, 1, 255, 103, 3, 255, 104, 4, 255, 103, 3, 255, 102, 2, 255, 102, 2, 255, 102, 2, 
    255, 102, 2, 255, 102, 2, 255, 102, 2, 255, 103, 3, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 

    254, 102, 1, 254, 102, 1, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 104, 3, 
    255, 104, 3, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 102, 2, 255, 103, 3, 255, 104, 4, 255, 106, 6, 255, 105, 5, 
    255, 104, 4, 255, 102, 2, 255, 101, 1, 255, 103, 3, 255, 103, 3, 255, 103, 3, 255, 103, 3, 
    255, 103, 3, 255, 103, 3, 255, 103, 3, 255, 103, 3, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 

    254, 102, 1, 254, 102, 1, 254, 102, 1, 255, 103, 2, 255, 103, 2, 255, 104, 3, 255, 104, 3, 
    255, 104, 3, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 252, 98, 0, 254, 100, 0, 255, 102, 2, 255, 103, 3, 255, 103, 3, 
    255, 102, 2, 255, 101, 1, 253, 99, 0, 255, 102, 2, 255, 103, 3, 255, 103, 3, 255, 103, 3, 
    255, 103, 3, 255, 103, 3, 255, 103, 3, 255, 102, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2, 
    255, 103, 2, 255, 103, 2, 255, 103, 2, 255, 103, 2 
};

void test_GRgetcomptype(); /* in "tdfr8.c" */
static VOID check_im_pal(int32 oldx, int32 oldy, int32 newx, int32 newy,
             uint8 *oldim, uint8 *newim, uint8 *oldpal, uint8 *newpal);

/* These two functions are in tusejpegfuncs.c.  They use JPEG functions directly
   to compress and decompress the same data as in test_r24_jpeg, to verify that
   the DFR24 API work correctly regardless which JPEG library is used */
intn comp_using_jpeglib(char *filename, long *file_offset, int im_height,
        int im_width, int im_ncomps, int quality, uint8 *written_buffer);
intn decomp_using_jpeglib(char *filename, long file_offset, int im_height,
        int im_width, int im_ncomps, uint8 *read_buffer);
void test_r24_jpeg(void);

/* ------------------------------- test_r24 ------------------------------- */

void
test_r24(void)
{
    int32       xd, yd;
    intn        il;
    int         Error;
    char        buf[YSIZE][XSIZE][3];
    char        buf1[YSIZE][3][XSIZE];
    char        buf2[3][YSIZE][XSIZE];
    char        in[YSIZE][XSIZE][3];
    char        in1[YSIZE][3][XSIZE];
    char        in2[3][YSIZE][XSIZE];
    int         i, j, ret;
    uint16      ref0, ref1, ref2;
    uint8      *jpeg_24bit_temp;

    jpeg_24bit_temp = (uint8 *) HDmalloc(JPEGX * JPEGY * 3);
    if (!jpeg_24bit_temp)
      {
          fprintf(stderr, "Out of memory!\n");
          exit(1);
      }

    for (i = 0; i < YSIZE; i++)
        for (j = 0; j < XSIZE; j++)
          {
              buf[i][j][0] = buf[i][j][1] = buf[i][j][2] = (char) (i + j);
              buf1[i][0][j] = buf1[i][1][j] = buf1[i][2][j] = (char) (i | j);
              buf2[0][i][j] = buf2[1][i][j] = buf2[2][i][j] = (char) (i ^ j);
          }

    MESSAGE(5, printf("Writing 24bit images with differing interlacing\n");
        );

    ret = DF24setil(DFIL_PIXEL);
    RESULT("DF24setil");
    ret = DF24putimage(TESTFILE, &(buf[0][0][0]), XSIZE, YSIZE);
    RESULT("DF24putimage");
    ref0 = DF24lastref();

    ret = DF24setil(DFIL_LINE);
    RESULT("DF24setil");
    ret = DF24addimage(TESTFILE, &(buf1[0][0][0]), XSIZE, YSIZE);
    RESULT("DF24addimage");
    ref1 = DF24lastref();

    ret = DF24setil(DFIL_PLANE);
    RESULT("DF24setil");
    ret = DF24addimage(TESTFILE, &(buf2[0][0][0]), XSIZE, YSIZE);
    RESULT("DF24addimage");
    ref2 = DF24lastref();

    if ((ret = DF24nimages(TESTFILE)) != 3)
      {
          fprintf(stderr, "  >>> DF24nimages() gives wrong number: %d <<<\n", ret);
          num_errs++;
      }

    /* read image 0 */

    MESSAGE(5, printf("Reading and verifying 24bit images\n");
        );

    ret = DF24restart();
    RESULT("DF24restart");
    ret = DF24reqil(DFIL_PIXEL);
    RESULT("DF24reqil");
    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");
    if (ret == FAIL)
        HEprint(stderr, 0);

    if ((xd != XSIZE) || (yd != YSIZE) || il != 0)
      {
          fprintf(stderr, "Returned meta-data is wrong for image 0\n");
          num_errs++;
      }

    ret = DF24getimage(TESTFILE, in, XSIZE, YSIZE);
    RESULT("DF24getimage");
    Error = FALSE;
    for (i = 0; i < YSIZE; i++)
        for (j = 0; j < XSIZE; j++)
            if (in[i][j][0] != buf[i][j][0]
                || in[i][j][1] != buf[i][j][1]
                || in[i][j][2] != buf[i][j][2])
              {
                  Error = TRUE;
              }

    if (Error)
      {
          printf("in:\n");
          for (i = 0; i < YSIZE; i++)
            {
                for (j = 0; j < XSIZE; j++)
                    printf("(%d,%d,%d)", (int) in[i][j][0], (int) in[i][j][1], (int) in[i][j][2]);
                printf("\n");
            }
          printf("buf:\n");
          for (i = 0; i < YSIZE; i++)
            {
                for (j = 0; j < XSIZE; j++)
                    printf("(%d,%d,%d)", (int) buf[i][j][0], (int) buf[i][j][1], (int) buf[i][j][2]);
                printf("\n");
            }
          fprintf(stderr, "Image 0 was incorrect\n");
          num_errs++;
      }

    if (ref0 != DF24lastref())
      {
          fprintf(stderr, "Bogus lastref for image 0\n");
          num_errs++;
      }

    /* read image 1 */

    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");

    if ((xd != XSIZE) || (yd != YSIZE) || il != 1)
      {
          fprintf(stderr, "Returned meta-data is wrong for image 1\n");
          num_errs++;
      }

    ret = DF24getimage(TESTFILE, in, XSIZE, YSIZE);
    RESULT("DF24getimage");
    Error = FALSE;
    for (i = 0; i < YSIZE; i++)
        for (j = 0; j < XSIZE; j++)
            if (in[i][j][0] != buf1[i][0][j]
                || in[i][j][1] != buf1[i][1][j]
                || in[i][j][2] != buf1[i][2][j])
              {
                  Error = TRUE;
              }

    if (Error)
      {
          fprintf(stderr, "Image 1 was incorrect\n");
          num_errs++;
      }

    if (ref1 != DF24lastref())
      {
          fprintf(stderr, "Bogus lastref for image 1\n");
          num_errs++;
      }

    /* read image 2 */

    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");

    if ((xd != XSIZE) || (yd != YSIZE) || il != 2)
      {
          fprintf(stderr, "Returned meta-data is wrong for image 2\n");
          num_errs++;
      }

    ret = DF24getimage(TESTFILE, in, XSIZE, YSIZE);
    RESULT("DF24getimage");
    Error = FALSE;
    for (i = 0; i < YSIZE; i++)
        for (j = 0; j < XSIZE; j++)
            if (in[i][j][0] != buf2[0][i][j]
                || in[i][j][1] != buf2[1][i][j]
                || in[i][j][2] != buf2[2][i][j])
              {
                  Error = TRUE;
              }

    if (Error)
      {
          fprintf(stderr, "Image 2 was incorrect\n");
          num_errs++;
      }

    if (ref2 != DF24lastref())
      {
          fprintf(stderr, "Bogus lastref for image 2\n");
          num_errs++;
      }

    ret = DF24restart();
    RESULT("DF24restart");

    /* read image 3 */

    ret = DF24reqil(DFIL_LINE);
    RESULT("DF24reqil");
    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");

    if ((xd != XSIZE) || (yd != YSIZE) || il != 0)
      {
          fprintf(stderr, "Returned meta-data is wrong for image 3\n");
          num_errs++;
      }

    ret = DF24getimage(TESTFILE, in1, XSIZE, YSIZE);
    RESULT("DF24getimage");
    Error = FALSE;
    for (i = 0; i < YSIZE; i++)
        for (j = 0; j < XSIZE; j++)
            if (in1[i][0][j] != buf[i][j][0]
                || in1[i][1][j] != buf[i][j][1]
                || in1[i][2][j] != buf[i][j][2])
              {
                  Error = TRUE;
              }

    if (Error)
      {
          fprintf(stderr, "Image 3 was incorrect\n");
          num_errs++;
      }

    /* read image 4 */

    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");

    if ((xd != XSIZE) || (yd != YSIZE) || il != 1)
      {
          fprintf(stderr, "Returned meta-data is wrong for image 4\n");
          num_errs++;
      }

    ret = DF24getimage(TESTFILE, in1, XSIZE, YSIZE);
    RESULT("DF24getimage");
    Error = FALSE;
    for (i = 0; i < YSIZE; i++)
        for (j = 0; j < XSIZE; j++)
            if (in1[i][0][j] != buf1[i][0][j]
                || in1[i][1][j] != buf1[i][1][j]
                || in1[i][2][j] != buf1[i][2][j])
              {
                  Error = TRUE;
              }

    if (Error)
      {
          fprintf(stderr, "Image 4 was incorrect\n");
          num_errs++;
      }

    /* read image 5 */

    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");

    if ((xd != XSIZE) || (yd != YSIZE) || il != 2)
      {
          fprintf(stderr, "Returned meta-data is wrong for image 5\n");
          num_errs++;
      }

    ret = DF24getimage(TESTFILE, in1, XSIZE, YSIZE);
    RESULT("DF24getimage");
    Error = FALSE;
    for (i = 0; i < YSIZE; i++)
        for (j = 0; j < XSIZE; j++)
            if (in1[i][0][j] != buf2[0][i][j]
                || in1[i][1][j] != buf2[1][i][j]
                || in1[i][2][j] != buf2[2][i][j])
              {
                  Error = TRUE;
              }

    if (Error)
      {
          fprintf(stderr, "Image 5 was incorrect\n");
          num_errs++;
      }

    /* read image 6 */

    ret = DF24restart();
    RESULT("DF24restart");

    ret = DF24reqil(DFIL_PLANE);
    RESULT("DF24reqil");

    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");

    if ((xd != XSIZE) || (yd != YSIZE) || il != 0)
      {
          fprintf(stderr, "Returned meta-data is wrong for image 6\n");
          num_errs++;
      }

    ret = DF24getimage(TESTFILE, in2, XSIZE, YSIZE);
    RESULT("DF24getimage");
    Error = FALSE;
    for (i = 0; i < YSIZE; i++)
        for (j = 0; j < XSIZE; j++)
            if (in2[0][i][j] != buf[i][j][0]
                || in2[1][i][j] != buf[i][j][1]
                || in2[2][i][j] != buf[i][j][2])
              {
                  Error = TRUE;
              }

    if (Error)
      {
          fprintf(stderr, "Image 6 was incorrect\n");
          num_errs++;
      }

    /* read image 7 */
    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");

    if ((xd != XSIZE) || (yd != YSIZE) || il != 1)
      {
          fprintf(stderr, "Returned meta-data is wrong for image 7\n");
          num_errs++;
      }

    ret = DF24getimage(TESTFILE, in2, XSIZE, YSIZE);
    RESULT("DF24getimage");
    for (i = 0; i < YSIZE; i++)
        for (j = 0; j < XSIZE; j++)
            if (in2[0][i][j] != buf1[i][0][j]
                || in2[1][i][j] != buf1[i][1][j]
                || in2[2][i][j] != buf1[i][2][j])
              {
                  Error = TRUE;
              }

    if (Error)
      {
          fprintf(stderr, "Image 7 was incorrect\n");
          num_errs++;
      }

    /* read image 8 */

    ret = DF24getdims(TESTFILE, &xd, &yd, &il);
    RESULT("DF24getdims");

    if ((xd != XSIZE) || (yd != YSIZE) || il != 2)
      {
          fprintf(stderr, "Returned meta-data is wrong for image 8\n");
          num_errs++;
      }

    ret = DF24getimage(TESTFILE, in2, XSIZE, YSIZE);
    RESULT("DF24getimage");
    Error = FALSE;
    for (i = 0; i < YSIZE; i++)
        for (j = 0; j < XSIZE; j++)
            if (in2[0][i][j] != buf2[0][i][j]
                || in2[1][i][j] != buf2[1][i][j]
                || in2[2][i][j] != buf2[2][i][j])
              {
                  Error = TRUE;
              }

    if (Error)
      {
          fprintf(stderr, "Image 8 was incorrect\n");
          num_errs++;
      }

    HDfree(jpeg_24bit_temp);

    /* Test 24-bit images with JPEG compression */
    test_r24_jpeg();
}

/**********************************************************************
 Utility function: read_binary_block
 Description:
	read_binary_block opens the given file in binary mode, seeks
	to the specified offset, then reads into the provided buffer
	nitems of values.
***********************************************************************/
size_t
read_binary_block(
	const char *filename,	/* file to be read */
	int32 offset,		/* position to start reading from */
	size_t nitems,		/* number of bytes to read */
	uint8 *buffer)		/* buffer to store the binary data in */
{
    FILE *fd;
    size_t readlen=0;   /* number of bytes actually read */

    /* Open the file to read binary data */
    if ((fd = fopen(filename, "rb")) == NULL) {
      fprintf(stderr, "can't open %s\n", filename);
      exit(1);
    }

    /* Forward to the specified offset to start reading */
    if (fseek(fd, (off_t)offset, SEEK_SET) == -1)
    {
        fprintf(stderr, "can't seek offset %d\n", (int)offset);
        exit(1);
    }

    /* Read in the specified block of data */
    readlen = fread((void*)buffer, 1, nitems, fd);
    return(readlen);
}

/* ------------------------------- test_r24_jpeg ------------------------------- */

#define N_IMAGES 3
void
test_r24_jpeg(void)
{
    int32     fid, grid,	/* file ID and GR interface ID */
              riid;		/* raster image ID */
    comp_info cinfo;		/* compression information for the JPEG */
    int32     xd, yd;		/* image's dimensions */
    intn      il;		/* image's interlace */
    long      begin_offset=0,	/* offset at the beginning of image's data */
	      end_offset=0;	/* offset at the end of image's data */
    uint8    *jpeg_24bit_temp;	/* buffer for 24-bit image data */
    uint8     jpeglib_readbuf[JPEGY*JPEGX*NCOMPS];
				/* buffer for data read by JPEG function */
    int32     offset, length;	/* offset/length in the HDF file */
    int32     nonhdf_offset;	/* offset in the nonHDF file */
    intn      status;		/* status returned from GR routines */
    intn      ii;		/* indices */
    int32     n_images, n_fattrs; /* number of images and number of file attrs */
    uint8    *hdf_buffer,	/* buffer of data read from HDF file */
	     *nonhdf_buffer;	/* buffer of data read from non-HDF file */
    int       ret;

    /* Allocate buffer for DF24getimage to store read data */
    jpeg_24bit_temp = (uint8 *) HDmalloc(JPEGX * JPEGY * 3);
    if (!jpeg_24bit_temp)
      {
          fprintf(stderr, "Out of memory!\n");
          exit(1);
      }

    MESSAGE(5, printf("\nStoring 24-bit images with JPEG compression\n");
        );

    ret = DF24setil(DFIL_PIXEL);
    RESULT("DF24setil");

    MESSAGE(6, printf("Storing first image with JPEG quality 80\n");
        );
    cinfo.jpeg.quality = 80;
    cinfo.jpeg.force_baseline = TRUE;
    DF24setcompress(COMP_JPEG, &cinfo);
    ret = DF24putimage((const char *)JPEGFILE, jpeg_24bit_orig, JPEGX, JPEGY);
    RESULT("DF24putimage");

    MESSAGE(6, printf("Storing second image with JPEG quality 30\n");
        );
    cinfo.jpeg.quality = 30;
    cinfo.jpeg.force_baseline = TRUE;
    DF24setcompress(COMP_JPEG, &cinfo);
    ret = DF24addimage((const char *)JPEGFILE, jpeg_24bit_orig, JPEGX, JPEGY);
    RESULT("DF24addimage");

    MESSAGE(6, printf("Storing third image with JPEG default quality of 75\n");
        );
    cinfo.jpeg.quality = 75;
    cinfo.jpeg.force_baseline = TRUE;
    DF24setcompress(COMP_JPEG, &cinfo);
    ret = DF24addimage((const char *)JPEGFILE, jpeg_24bit_orig, JPEGX, JPEGY);
    RESULT("DF24addimage");

    if (DF24nimages(JPEGFILE) != 3)
      {
          fprintf(stderr, "  >>> DF24nimages() gives wrong number for JPEG images<<<\n");
          num_errs++;
      }

    MESSAGE(5, printf("\nReading and verifying 24bit JPEG'ed images\n\n");
        );

    ret = DF24restart();
    RESULT("DF24restart");

    ret = DF24reqil(DFIL_PIXEL);
    RESULT("DF24reqil");

    /* Get dimensions of first image */
    ret = DF24getdims(JPEGFILE, &xd, &yd, &il);
    RESULT("DF24getdims");

    if ((xd != JPEGX) || (yd != JPEGY))
      {
          fprintf(stderr, "Returned meta-data is wrong for JPEG quality 80 image\n");
          fprintf(stderr, "xd=%d, yd=%d\n", (int)xd, (int)yd);
          num_errs++;
      }

    ret = DF24getimage(JPEGFILE, jpeg_24bit_temp, JPEGX, JPEGY);
    RESULT("DF24getimage");

    /* Compress the same data using the JPEG library directly, with quality 80 */
    comp_using_jpeglib(NONHDF_JPEGFILE, &end_offset, JPEGY, JPEGX, NCOMPS, 80, jpeg_24bit_orig);

    /* Read back the data using JPEG library directly */
    decomp_using_jpeglib(NONHDF_JPEGFILE, begin_offset, JPEGY, JPEGX, NCOMPS, jpeglib_readbuf);

    /* Compare data decompressed by HDF against that by JPEG lib, the buffers
       should be identical */
    if (HDmemcmp(jpeg_24bit_temp, jpeglib_readbuf, JPEGY*JPEGX*NCOMPS))
    {
	fprintf(stderr, "24-bit JPEG quality 80 image was incorrect\n");
	print_mismatched(jpeg_24bit_temp, jpeglib_readbuf, JPEGY*JPEGX*NCOMPS);
	num_errs++;
    }

#if 0 /* will remove after finish revising JPEG tests */
    if ((ret = fuzzy_memcmp(jpeg_24bit_temp, jpeg_24bit_j80, sizeof(jpeg_24bit_orig), JPEG_FUZZ)) != 0)
      {
          fprintf(stderr, "24-bit JPEG quality 80 image was incorrect\n");
          fprintf(stderr, "ret=%d, sizeof(jpeg_24bit_orig)=%u\n", (int) ret, (unsigned) sizeof(jpeg_24bit_orig));
          num_errs++;
      }
#endif

    /* Get dimensions of second image */
    ret = DF24getdims(JPEGFILE, &xd, &yd, &il);
    RESULT("DF24getdims");

    if ((xd != JPEGX) || (yd != JPEGY))
      {
          fprintf(stderr, "Returned meta-data is wrong for JPEG quality 30 image\n");
          fprintf(stderr, "xd=%d, yd=%d\n", (int)xd, (int)yd);
          num_errs++;
      }

    ret = DF24getimage(JPEGFILE, jpeg_24bit_temp, JPEGX, JPEGY);
    RESULT("DF24getimage");

    begin_offset = end_offset;

    /* Compress the same data using the JPEG library directly, with quality 30 */
    comp_using_jpeglib(NONHDF_JPEGFILE, &end_offset, JPEGY, JPEGX, NCOMPS, 30, jpeg_24bit_orig);

    /* Read back the data using JPEG library directly */
    decomp_using_jpeglib(NONHDF_JPEGFILE, begin_offset, JPEGY, JPEGX, NCOMPS, jpeglib_readbuf);

    /* Compare data decompressed by HDF against that by JPEG lib, the buffers
       should be identical */
    if (HDmemcmp(jpeg_24bit_temp, jpeglib_readbuf, JPEGY*JPEGX*NCOMPS))
    {
	fprintf(stderr, "24-bit JPEG quality 30 image was incorrect\n");
	print_mismatched(jpeg_24bit_temp, jpeglib_readbuf, JPEGY*JPEGX*NCOMPS);
	num_errs++;
    }

#if 0
    if ((ret = fuzzy_memcmp(jpeg_24bit_temp, jpeg_24bit_j30, sizeof(jpeg_24bit_orig), JPEG_FUZZ)) != 0)
      {
          fprintf(stderr, "24-bit JPEG quality 30 image was incorrect\n");
          fprintf(stderr, "ret=%d, sizeof(jpeg_24bit_orig)=%u\n", (int) ret, (unsigned) sizeof(jpeg_24bit_orig));
          num_errs++;
      }
#endif

    /* Get dimensions of third image */
    ret = DF24getdims(JPEGFILE, &xd, &yd, &il);
    RESULT("DF24getdims");

    if ((xd != JPEGX) || (yd != JPEGY))
      {
          fprintf(stderr, "Returned meta-data is wrong for JPEG quality 75 image\n");
          fprintf(stderr, "xd=%d, yd=%d\n", (int)xd, (int)yd);
          num_errs++;
      }

    ret = DF24getimage(JPEGFILE, jpeg_24bit_temp, JPEGX, JPEGY);
    RESULT("DF24getimage");

    begin_offset = end_offset;

    /* Compress the same data using the JPEG library directly, with quality 75 */
    comp_using_jpeglib(NONHDF_JPEGFILE, &end_offset, JPEGY, JPEGX, NCOMPS, 75, jpeg_24bit_orig);

    /* Read back the data using JPEG library directly */
    decomp_using_jpeglib(NONHDF_JPEGFILE, begin_offset, JPEGY, JPEGX, NCOMPS, jpeglib_readbuf);

    /* Compare data decompressed by HDF against that by JPEG lib, the buffers
       should be identical */
    if (HDmemcmp(jpeg_24bit_temp, jpeglib_readbuf, JPEGY*JPEGX*NCOMPS))
    {
	fprintf(stderr, "24-bit JPEG quality 75 image was incorrect\n");
	print_mismatched(jpeg_24bit_temp, jpeglib_readbuf, JPEGY*JPEGX*NCOMPS);
	num_errs++;
    }

#if 0
    if ((ret = fuzzy_memcmp(jpeg_24bit_temp, jpeg_24bit_j75, sizeof(jpeg_24bit_orig), JPEG_FUZZ)) != 0)
      {
          fprintf(stderr, "24-bit JPEG quality 75 image was incorrect\n");
          fprintf(stderr, "ret=%d, sizeof(jpeg_24bit_orig)=%u\n", (int) ret, (unsigned) sizeof(jpeg_24bit_orig));
          num_errs++;
      }
#endif

    HDfree(jpeg_24bit_temp);


    /********************************************************************
      Verify raw data in HDF and NON-HDF files using offsets and lengths.
    ********************************************************************/

   /* Re-open the file with GR interface */
    fid = Hopen (JPEGFILE, DFACC_RDONLY, 0);
    CHECK_VOID(fid, FAIL, "Hopen");
    grid = GRstart (fid);
    CHECK_VOID(grid, FAIL, "GRstart");

    /* Get the number of images in the file */
    status = GRfileinfo(grid, &n_images, &n_fattrs);
    CHECK_VOID(status, FAIL, "GRfileinfo");
    VERIFY_VOID(n_images, N_IMAGES, "GRfileinfo");

    /* Open each image and get its data information.  Read the block of
       binary data from the HDF file and the non-HDF file.  Then, verify
       that the two buffers are identical.  Note that the non-HDF file only
       contains the image data, thus the offset will start at 0. */
    nonhdf_offset = 0;
    for (ii = 0; ii < n_images; ii++)
    {
	size_t read_len=0;

	/* Get access to each image */
	riid = GRselect(grid, ii);
	CHECK_VOID(riid, FAIL, "GRselect");

	/* Get the image's data information */
	status = GRgetdatainfo(riid, 0, 1, &offset, &length);
	CHECK_VOID(status, FAIL, "GRgetdatainfo");

	/* Allocate buffers for the data from the HDF file and non-HDF file */
	hdf_buffer = (uint8 *) HDmalloc(length * sizeof(uint8));
	CHECK_ALLOC(hdf_buffer, "hdf_buffer", "test_r24_jpeg" );
	nonhdf_buffer = (uint8 *) HDmalloc(length * sizeof(uint8));
	CHECK_ALLOC(nonhdf_buffer, "nonhdf_buffer", "test_r24_jpeg" );

	/* Read the block of data from the HDF file using offset/length returned by
	   GRgetdatainfo and verify that the specified length of data was read */
	read_len = read_binary_block(JPEGFILE, offset, length, hdf_buffer);
	VERIFY_VOID(read_len, (size_t)length, "read_binary_block");

	/* Read the block of data from the non-HDF file using nonhdf_offset and
	   the length returned by GRgetdatainfo and verify that the specified
	   length of data was read */
	read_len = read_binary_block(NONHDF_JPEGFILE, nonhdf_offset, length, nonhdf_buffer);
	VERIFY_VOID(read_len, (size_t)length, "read_binary_block");

	/* Compare compressed data from the HDF file against that from the
	   non-HDF file.  The two buffers should be identical */
	if (HDmemcmp(hdf_buffer, nonhdf_buffer, length))
	{
	    /* Display any mismatched values for debugging */
	    print_mismatched(hdf_buffer, nonhdf_buffer, length);
	    num_errs++;
	}

	/* Move forward to the next set of non-HDF data, equivalent to the next
	   image in the HDF file JPEGFILE */
	nonhdf_offset = nonhdf_offset + length;

	/* Close the image */
	status = GRendaccess(riid);
	CHECK_VOID(status, FAIL, "GRendaccess");
    } /* for n_images */

    /* Terminate access to the GR interface and close the file */
    status = GRend(grid);
    CHECK_VOID(status, FAIL, "GRend");
    status = Hclose(fid);
    CHECK_VOID(status, FAIL, "Hclose");
}

static VOID
check_im_pal(int32 oldx, int32 oldy, int32 newx, int32 newy,
             uint8 *oldim, uint8 *newim, uint8 *oldpal, uint8 *newpal)
{
    int         error;
    int         x, y;
    uint8      *op, *np;

    MESSAGE(5, printf("Checking image and palette.\n");
        );

    op = (uint8 *) oldim;
    np = (uint8 *) newim;
    if (newx != oldx || newy != oldy)
        printf("        >>> DIMENSIONS WRONG <<<\n\n");
    error = FALSE;
    for (x = 0; x < oldx; x++)
        for (y = 0; y < oldy; y++)
          {
              if (*op != *np)
                {
                    printf("\t>>>Error at %d %d, orig image=%d; new image=%d<<<\n",
                           x, y, *op, *np);
                    error = TRUE;
                }
              op++;
              np++;
          }
    if (error)
      {
          printf("    >>> Image is wrong. <<<\n");
          num_errs++;
      }

    error = FALSE;
    for (x = 0; x < 768; x++)
        if (oldpal[x] != newpal[x])
          {
              printf("\t>>>Pal error at %d, orig pal %u new pal %u<<<\n",
                     x, oldpal[x], newpal[x]);
              error = TRUE;
          }
    if (error)
      {
          printf("    >>> Palette is wrong. <<<\n");
          num_errs++;
      }
}

/* ------------------------------- test_r8 -------------------------------- */

#define XD1 10
#define YD1 10
#define XD2 7
#define YD2 11
#define XD3 8
#define YD3 12
#define TESTFILE_R8  "tdfr8.hdf"
void
test_r8(void)
{
    comp_info   cinfo;          /* compression information for the JPEG */
    uint8      *im3, *ii3;
    uint8      *im2, *ii2;
    uint8      *im1, *ii1;
    uint8      *pal1, *pal2, *ipal;

    int         x, y;
    int         ret, num_images = 0;
    uint16      ref1, ref2;
    int32       xd, yd;
    int         ispal;
    uint8      *jpeg_8bit_temp;

    im1 = (uint8 *) HDmalloc(XD1 * YD1 * sizeof(uint8));
    ii1 = (uint8 *) HDmalloc(XD1 * YD1 * sizeof(uint8));
    if (!im1 || !ii1)
      {
          fprintf(stderr, "Out of memory!\n");
          exit(1);
      }

    im2 = (uint8 *) HDmalloc(XD2 * YD2 * sizeof(uint8));
    ii2 = (uint8 *) HDmalloc(XD2 * YD2 * sizeof(uint8));
    if (!im2 || !ii2)
      {
          fprintf(stderr, "Out of memory!\n");
          exit(1);
      }

    im3 = (uint8 *) HDmalloc(XD3 * YD3 * sizeof(uint8));
    ii3 = (uint8 *) HDmalloc(XD3 * YD3 * sizeof(uint8));
    if (!im3 || !ii3)
      {
          fprintf(stderr, "Out of memory!\n");
          exit(1);
      }

    pal1 = (uint8 *) HDmalloc(768 * sizeof(char));
    pal2 = (uint8 *) HDmalloc(768 * sizeof(char));
    ipal = (uint8 *) HDmalloc(768 * sizeof(char));
    if (!ipal || !pal1 || !pal2)
      {
          fprintf(stderr, "Out of memory!\n");
          exit(1);
      }

    jpeg_8bit_temp = (uint8 *) HDmalloc(JPEGX * JPEGY);
    if (!jpeg_8bit_temp)
      {
          fprintf(stderr, "Out of memory!\n");
          exit(1);
      }

    for (y = 0; y < YD1; y++)
        for (x = 0; x < XD1; x++)
            im1[y * XD1 + x] = (uint8) (x + y);
    for (y = 0; y < YD2; y++)
        for (x = 0; x < XD2; x++)
            im2[y * XD2 + x] = (uint8) ((2 * x + y) - 256 * ((2 * x + y) / 256));
    for (y = 0; y < YD3; y++)
        for (x = 0; x < XD3; x++)
            im3[y * XD3 + x] = (uint8) ((3 * x + y) - 256 * ((3 * x + y) / 256));
    for (x = 0; x < 256; x++)
      {
          pal1[3 * x] = (uint8) x;
          pal1[3 * x + 1] = (uint8) x;
          pal1[3 * x + 2] = (uint8) x;
          pal2[x] = (uint8) x;
          pal2[x + 256] = (uint8) x;
          pal2[x + 512] = (uint8) x;
      }

    /* start here */

    MESSAGE(5, printf("Storing 8bit raster images\n");
        );
    ret = DFR8setpalette(pal1);
    RESULT("DFR8setpalette");

    MESSAGE(5, printf("Putting image with no compression\n");
        );
    ret = DFR8putimage(TESTFILE_R8, im1, XD1, YD1, 0);
    RESULT("DFR8putimage");
    num_images++;
    ref1 = DFR8lastref();

    MESSAGE(5, printf("Putting image RLE compression\n");
        );
    ret = DFR8addimage(TESTFILE_R8, im2, XD2, YD2, DFTAG_RLE);
    RESULT("DFR8addimage");
    num_images++;
    ref2 = DFR8lastref();

#ifdef DONT_TEST_IMCOMP     /* QAK */
    ret = DFR8setpalette(pal2);
    RESULT("DFR8setpalette");
    MESSAGE(5, printf("Putting image IMCOMP compression\n");
        );
    ret = DFR8addimage(TESTFILE_R8, im3, XD3, YD3, DFTAG_IMCOMP);
    RESULT("DFR8addimage");
    num_images++;
    ref3 = DFR8lastref();
#endif /* DONT_TEST_IMCOMP */     /* QAK */

    ret = DFR8nimages(TESTFILE_R8);
    if (ret != num_images)
      {
          fprintf(stderr, "        >>> WRONG NUMBER OF IMAGES <<<\n");
          num_errs++;
      }

    MESSAGE(5, printf("Reading and verifying 8bit raster images\n");
        );

    ret = DFR8restart();
    RESULT("DFR8restart");

    MESSAGE(5, printf("Verifying uncompressed image\n");
        );

    ret = DFR8getdims(TESTFILE_R8, &xd, &yd, &ispal);
    RESULT("DFR8getdims");
    ret = DFR8getimage(TESTFILE_R8, (uint8 *) ii1, (int32) XD1, (int32) YD1, ipal);
    RESULT("DFR8getimage");
    check_im_pal(XD1, YD1, xd, yd, im1, ii1, pal1, ipal);

    MESSAGE(5, printf("Verifying RLE compressed image\n");
        );

    ret = DFR8getdims(TESTFILE_R8, &xd, &yd, &ispal);
    RESULT("DFR8getdims");

#ifdef DONT_TEST_IMCOMP /* QAK */
    MESSAGE(5, printf("Verifying IMCOMP compressed image\n");
        );

    ret = DFR8getdims(TESTFILE_R8, &xd, &yd, &ispal);
    RESULT("DFR8getdims");
    ret = DFR8getimage(TESTFILE_R8, (uint8 *) ii3, (int32) XD3, (int32) YD3, ipal);
    RESULT("DFR8getimage");
#endif /* DONT_TEST_IMCOMP */     /* QAK */

    MESSAGE(5, printf("Rechecking RLE image\n");
        );

    ret = DFR8readref(TESTFILE_R8, ref2);
    RESULT("DFR8readref");
    ret = DFR8getimage(TESTFILE_R8, (uint8 *) ii2, (int32) XD2, (int32) YD2, ipal);
    RESULT("DFR8getimage");
    check_im_pal(XD2, YD2, XD2, YD2, im2, ii2, pal1, ipal);

    MESSAGE(5, printf("Changing palette of first image\n");
        );

    ret = DFR8writeref(TESTFILE_R8, ref1);
    RESULT("DFR8writeref");
    ret = DFR8setpalette(pal2);
    RESULT("DFR8setpalette");
    ret = DFR8addimage(TESTFILE_R8, im1, XD1, YD1, DFTAG_RLE);
    RESULT("DFR8addimage");

    MESSAGE(5, printf("Verifying palette change\n");
        );

    ret = DFR8readref(TESTFILE_R8, ref1);
    RESULT("DFR8readref");
    ret = DFR8getdims(TESTFILE_R8, &xd, &yd, &ispal);
    RESULT("DFR8getdims");
    ret = DFR8getimage(TESTFILE_R8, (uint8 *) ii1, (int32) XD1, (int32) YD1, ipal);
    RESULT("DFR8getimage");
    check_im_pal(XD1, YD1, xd, yd, im1, ii1, pal2, ipal);

    MESSAGE(5, printf("\nStoring 8-bit images with JPEG compression\n");
        );

    MESSAGE(6, printf("Storing first image with JPEG quality 80\n");
        );
    cinfo.jpeg.quality = 80;
    cinfo.jpeg.force_baseline = TRUE;
    DFR8setcompress(COMP_JPEG, &cinfo);
    ret = DFR8putimage(JPEGFILE, jpeg_8bit_orig, JPEGX, JPEGY, COMP_JPEG);
    RESULT("DFR8putimage");

    MESSAGE(6, printf("Storing second image with JPEG quality 30\n");
        );
    cinfo.jpeg.quality = 30;
    cinfo.jpeg.force_baseline = TRUE;
    DFR8setcompress(COMP_JPEG, &cinfo);
    ret = DFR8addimage(JPEGFILE, jpeg_8bit_orig, JPEGX, JPEGY, COMP_JPEG);
    RESULT("DFR8addimage");

    MESSAGE(6, printf("Storing third image with JPEG default quality of 75\n");
        );
    ret = DFR8addimage(JPEGFILE, jpeg_8bit_orig, JPEGX, JPEGY, COMP_JPEG);
    RESULT("DFR8addimage");

    MESSAGE(5, printf("\nReading and verifying 8-bit JPEG'ed images\n\n");
        );

    ret = DFR8restart();
    RESULT("DFR8restart");

    ret = DFR8getdims(JPEGFILE, &xd, &yd, &ispal);
    RESULT("DFR8getdims");

    if ((xd != JPEGX) || (yd != JPEGY))
      {
          fprintf(stderr, "Returned meta-data is wrong for JPEG quality 80 image\n");
          num_errs++;
      }

    ret = DFR8getimage(JPEGFILE, (uint8 *) jpeg_8bit_temp, JPEGX, JPEGY, NULL);
    RESULT("DFR8getimage");

    if (HDmemcmp(jpeg_8bit_temp, jpeg_8bit_j80, sizeof(jpeg_8bit_orig)))
      {
          fprintf(stderr, "8-bit JPEG quality 80 image was incorrect\n");
          num_errs++;
      }

    ret = DFR8getdims(JPEGFILE, &xd, &yd, &ispal);
    RESULT("DFR8getdims");

    if ((xd != JPEGX) || (yd != JPEGY))
      {
          fprintf(stderr, "Returned meta-data is wrong for JPEG quality 30 image\n");
          num_errs++;
      }

    ret = DFR8getimage(JPEGFILE, (uint8 *) jpeg_8bit_temp, JPEGX, JPEGY, NULL);
    RESULT("DFR8getimage");

    if (HDmemcmp(jpeg_8bit_temp, jpeg_8bit_j30, sizeof(jpeg_8bit_orig)))
      {
          fprintf(stderr, "8-bit JPEG quality 30 image was incorrect\n");
          num_errs++;
      }

    ret = DFR8getdims(JPEGFILE, &xd, &yd, &ispal);
    RESULT("DFR8getdims");

    if ((xd != JPEGX) || (yd != JPEGY))
      {
          fprintf(stderr, "Returned meta-data is wrong for JPEG quality 75 image\n");
          num_errs++;
      }

    ret = DFR8getimage(JPEGFILE, (uint8 *) jpeg_8bit_temp, JPEGX, JPEGY, NULL);
    RESULT("DFR8getimage");

    if (HDmemcmp(jpeg_8bit_temp, jpeg_8bit_j75, sizeof(jpeg_8bit_orig)))
      {
          fprintf(stderr, "8-bit JPEG quality 75 image was incorrect\n");
          num_errs++;
      }

    HDfree(im1);
    HDfree(ii1);
    HDfree(im2);
    HDfree(ii2);
    HDfree(im3);
    HDfree(ii3);
    HDfree(pal1);
    HDfree(pal2);
    HDfree(ipal);
    HDfree(jpeg_8bit_temp);

    /* Temporarily call to test GRgetcomptype() for hmap project; these tests
       will need to be reformatted. Mar 13, 2011 -BMR */
    test_GRgetcomptype();
}

void
test_pal(void)
{
    int         i;
    int         ret;
    uint16      ref1, ref2;

    uint8       *pal1, *pal2, *ipal;

    pal1 = (uint8 *) HDmalloc(768 * sizeof(uint8));
    pal2 = (uint8 *) HDmalloc(768 * sizeof(uint8));
    ipal = (uint8 *) HDmalloc(768 * sizeof(uint8));
    if (!ipal || !pal1 || !pal2)
      {
          fprintf(stderr, "Out of memory!\n");
          exit(1);
      }

    for (i = 0; i < 256; i++)
      {
          pal1[3 * i] = (uint8) i;
          pal1[3 * i + 1] = (uint8) i;
          pal1[3 * i + 2] = (uint8) i;
          pal2[i] = (uint8) i;
          pal2[i + 256] = (uint8) i;
          pal2[i + 512] = (uint8) i;
      }

    MESSAGE(5, printf("Adding palettes to a file\n");
        );

    ret = DFPputpal(TESTFILE, pal1, 0, "w");
    RESULT("DFPputpal");
    ref1 = DFPlastref();

    ret = DFPaddpal(TESTFILE, pal2);
    RESULT("DFPaddpal");
    ref2 = DFPlastref();

    MESSAGE(5, printf("Reading and verifying palettes\n");
        );

    ret = DFPrestart();
    RESULT("DFPrestart");

    /* read and check palette 1 */
    ret = DFPgetpal(TESTFILE, ipal);
    RESULT("DFPgetpal");
    if(HDmemcmp(ipal,pal1,768)!=0)
        for (i = 0; i < 768; i++)
            if ((uint8)pal1[i] != (uint8)ipal[i])
                printf("Error at %d, ipal %d pal1 %d\n", (int)i, (int)ipal[i], (int)pal1[i]);

    if (ref1 != DFPlastref())
      {
          fprintf(stderr, "  >>> DFPlastref() bad for palette 1 <<<\n");
          num_errs++;
      }

    /* read and check palette 2 */
    ret = DFPgetpal(TESTFILE, ipal);
    RESULT("DFPgetpal");
    if(HDmemcmp(ipal,pal2,768)!=0)
        for (i = 0; i < 768; i++)
            if ((uint8)ipal[i] != (uint8)pal2[i])
                printf("Error at %d, ipal %d pal2 %d\n", (int)i, (int)ipal[i], (int)pal2[i]);

    if (ref2 != DFPlastref())
      {
          fprintf(stderr, "  >>> DFPlastref() bad for palette 2 <<<\n");
          num_errs++;
      }

    if (DFPnpals(TESTFILE) != 2)
      {
          fprintf(stderr, "  >>> DFPnpals() gives wrong number <<<\n");
          num_errs++;
      }

    /* recheck palette number 2 */
    ret = DFPreadref(TESTFILE, ref2);
    RESULT("DFPreadref");
    ret = DFPgetpal(TESTFILE, ipal);
    RESULT("DFPgetpal");
    if(HDmemcmp(ipal,pal2,768)!=0)
        for (i = 0; i < 768; i++)
            if (ipal[i] != pal2[i])
                printf("Error at %d, ipal %d pal2 %d\n", i, ipal[i], pal2[i]);

    /* recheck palette number 1 */
    ret = DFPreadref(TESTFILE, ref1);
    RESULT("DFPreadref");
    ret = DFPgetpal(TESTFILE, ipal);
    RESULT("DFPgetpal");
    if(HDmemcmp(ipal,pal1,768)!=0)
        for (i = 0; i < 768; i++)
            if (ipal[i] != pal1[i])
                printf("Error at %d, ipal %d pal1 %d\n", i, ipal[i], pal1[i]);

    MESSAGE(5, printf("Modifying first palette\n");
        );
    for (i = 0; i < 256; i++)
        pal1[i + 256] = (uint8) (255 - i);
    ret = DFPwriteref(TESTFILE, ref1);
    RESULT("DFPwriteref");

    ret = DFPputpal(TESTFILE, pal1, 1, "a");
    RESULT("DFPputpal");

    ret = DFPreadref(TESTFILE, ref1);
    RESULT("DFPreafref");

    ret = DFPgetpal(TESTFILE, ipal);
    RESULT("DFPgetpal");
    if(HDmemcmp(ipal,pal1,768)!=0)
        for (i = 0; i < 768; i++)
            if (ipal[i] != pal1[i])
                printf("(%d) Error at %d, ipal %d pal1 %d\n", __LINE__,i, ipal[i], pal1[i]);
    HDfree(pal1);
    HDfree(pal2);
    HDfree(ipal);
}
