/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_SC_SOURCE_UI_INC_SORTKEYDLG_HXX
#define INCLUDED_SC_SOURCE_UI_INC_SORTKEYDLG_HXX

#include <vector>
#include <memory>

#include "anyrefdg.hxx"

#include <vcl/weld.hxx>
#include <svx/langbox.hxx>

struct ScSortKeyItem
{
    std::unique_ptr<weld::Builder> m_xBuilder;

    std::unique_ptr<weld::Frame> m_xFrame;
    std::unique_ptr<weld::ComboBoxText> m_xLbSort;
    std::unique_ptr<weld::RadioButton> m_xBtnUp;
    std::unique_ptr<weld::RadioButton> m_xBtnDown;

    ScSortKeyItem(weld::Container* pParent);

    void DisableField();
    void EnableField();

    long getItemHeight() const;
};

typedef std::vector<std::unique_ptr<ScSortKeyItem> > ScSortKeyItems;

class ScSortKeyWindow
{
public:
    ScSortKeyItems m_aSortKeyItems;
private:
    weld::Container* m_pBox;
    sal_Int32 m_nItemHeight;

public:
    ScSortKeyWindow(weld::Container* pBox);
    ~ScSortKeyWindow();

    void AddSortKey( sal_uInt16 nItem );
    void DoScroll( sal_Int32 nNewPos );
    sal_Int32 GetItemHeight() const { return m_nItemHeight; }
};

#endif // INCLUDED_SC_SOURCE_UI_INC_SORTKEYDLG_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
