/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.6
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  Exceptions thrown by some libSBML constructors.
 <p>
 * In some situations, constructors for SBML objects may need to indicate to
 * callers that the creation of the object failed.  The failure may be for
 * different reasons, such as an attempt to use invalid parameters or a
 * system condition such as a memory error.  To communicate this to callers,
 * those classes will throw an {@link SBMLConstructorException}.
 <p>
 * In languages that don't have an exception mechanism (e.g., C), the
 * constructors generally try to return an error code instead of throwing
 * an exception.
 */

public class SBMLConstructorException extends java.lang.IllegalArgumentException {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected SBMLConstructorException(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(SBMLConstructorException obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBMLConstructorException obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBMLConstructorException(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  protected SBMLConstructorException(long cPtr, boolean cMemoryOwn, String v)
  {
    super(v);
    swigCMemOwn = cMemoryOwn;
    swigCPtr    = cPtr;
  }

  /**
   * Exception thrown by libSBML object constructors if something prevents
   * the object from being properly created.
   *
   * An example of what can cause this exception to be thrown is attempting
   * to create an SBML component with an invalid SBML Level/Version
   * combination.
   */
  public SBMLConstructorException(String v)
  {
    this(libsbmlJNI.new_SBMLConstructorException__SWIG_0(), true, v);
  }

  
/** * @internal */ public
 SBMLConstructorException() {
    this(libsbmlJNI.new_SBMLConstructorException__SWIG_0(), true);
  }

  
/** * @internal */ public
 SBMLConstructorException(String errmsg, String sbmlErrMsg) {
    this(libsbmlJNI.new_SBMLConstructorException__SWIG_1(errmsg, sbmlErrMsg), true);
  }

  
/** * @internal */ public
 SBMLConstructorException(String elementName, SBMLNamespaces xmlns) {
    this(libsbmlJNI.new_SBMLConstructorException__SWIG_2(elementName, SBMLNamespaces.getCPtr(xmlns), xmlns), true);
  }

  
/**
   * Returns the message associated with this SBML exception.
   <p>
   * @return the message string.
   */ public
 String getSBMLErrMsg() {
    return libsbmlJNI.SBMLConstructorException_getSBMLErrMsg(swigCPtr, this);
  }

}
