#
# spec file for package libxcrypt (Version 2.0)
#
# Copyright (c) 2003 SuSE Linux AG, Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments via http://www.suse.de/feedback/
#

# neededforbuild  
# usedforbuild    aaa_base acl attr bash bind9-utils bison bzip2 coreutils cpio cpp cvs cyrus-sasl db devs diffutils e2fsprogs file filesystem fillup findutils flex gawk gdbm-devel glibc glibc-devel glibc-locale gpm grep groff gzip info insserv kbd less libacl libattr libgcc libstdc++ libxcrypt m4 make man mktemp modutils ncurses ncurses-devel net-tools netcfg openldap2-client openssl pam pam-devel pam-modules patch permissions popt ps rcs readline sed sendmail shadow strace syslogd sysvinit tar texinfo timezone unzip util-linux vim zlib zlib-devel autoconf automake binutils cracklib gcc gdbm gettext libtool perl rpm

Name:         libxcrypt
License:      LGPL
Group:        System/Libraries
Autoreqprov:  on
Version:      2.1
Release:      0
Summary:      Crypt library for DES, MD5, and blowfish
Source:       libxcrypt-%{version}.tar.bz2
BuildRoot:    %{_tmppath}/%{name}-%{version}-build

%description
Libxcrypt is a replacement for libcrypt, which comes with the GNU C
Library. It supports DES crypt, MD5, and passwords with blowfish
encryption.



%package devel
Summary:      Development files for Crypt library
Group:        Development/Libraries/C and C++
Requires:     libxcrypt = %{version}
Autoreqprov:  on

%description devel
libxcrypt is a replacement for libcrypt, which comes with the GNU C
Library. It supports, beside DES crypt and MD5, passwords with blowfish
encryption.

This package contains the header files and static libraries, which are
necessary to develop your own software using libxcrypt.



%prep
%setup

%build
CFLAGS=$RPM_OPT_FLAGS ./configure --prefix=%{_prefix} --libdir=%{_libdir}
make
make check

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{_lib}
mv -v $RPM_BUILD_ROOT%{_libdir}/libxcrypt.so.* $RPM_BUILD_ROOT/%{_lib}
ln -sf ../../%{_lib}/libxcrypt.so.1 $RPM_BUILD_ROOT%{_libdir}/libxcrypt.so

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc COPYING README NEWS README.bcrypt README.ufc-crypt
/%{_lib}/libxcrypt.so.*

%files devel
%defattr(-,root,root)
%{_prefix}/include/*.h
%{_libdir}/libxcrypt.a
%{_libdir}/libxcrypt.la
%{_libdir}/libxcrypt.so

%changelog -n libxcrypt
* Mon Jul 28 2003 - kukuk@suse.de
- Update to 2.0
* Tue May 13 2003 - kukuk@suse.de
- Add defattr to filelist
* Thu Jan 16 2003 - kukuk@suse.de
- Update to version 1.4 (compiles with glibc > 2.3.1)
* Fri Jan 10 2003 - kukuk@suse.de
- Update to version 1.3 (fix initialisation of internal data
  struct for des_crypt)
* Mon Oct 21 2002 - kukuk@suse.de
- Update to version 1.2 (fix compiling with glibc 2.3.x)
* Mon May 27 2002 - kukuk@suse.de
- Update to version 1.1 (add SHA1 support)
* Wed Apr 17 2002 - kukuk@suse.de
- Add require to libxcrypt-devel for correct shared library
* Mon Apr 15 2002 - kukuk@suse.de
- Initial version of a libcrypt replacement
