(*
    ||M||  This file is part of HELM, an Hypertextual, Electronic        
    ||A||  Library of Mathematics, developed at the Computer Science     
    ||T||  Department, University of Bologna, Italy.                     
    ||I||                                                                
    ||T||  HELM is free software; you can redistribute it and/or         
    ||A||  modify it under the terms of the GNU General Public License   
    \   /  version 2 or (at your option) any later version.      
     \ /   This software is distributed as is, NO WARRANTY.     
      V_______________________________________________________________ *)

(* $Id: nCic.ml 9058 2008-10-13 17:42:30Z tassi $ *)

val string_of_comparison: Terms.comparison -> string

module Pp (B : Terms.Blob) : 
  sig

    val pp_foterm: B.t Terms.foterm -> string
    val pp_proof: B.t Terms.bag -> B.t Terms.proof -> string
    val pp_substitution: B.t Terms.substitution -> string
    val pp_unit_clause: ?margin:int -> B.t Terms.unit_clause -> string
    val pp_bag: B.t Terms.bag -> string

  end
