/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

/*! \file Factory.h
    \brief Definition of Factory  class.

    Magics Team - ECMWF 2004

    Started: Jan 2004

    Changes:

*/
#ifndef MvFactory_H
#define MvFactory_H

#include <map>
#include <string>
using namespace std;

#if 0
class NoFactoryException : public MagicsException
{
public:
	NoFactoryException( const string& factory ):
		MagicsException("Factory (" +  factory + ") not found") {}
	NoFactoryException():
		MagicsException("Factory not found") {}
}; 
#endif


template<class B> 
class SimpleFactory {

public:

   // -- Contructors
   SimpleFactory(const string& name);
   virtual ~SimpleFactory();

   // -- Methods
   static B*  create(const string& name);
   virtual B* make() const  = 0;

   // -- Members
   static map<string, SimpleFactory<B>* >* map_;
   static SimpleFactory<B>* get(const string& name);
   string name_;
};

template <class A, class B=A>
class SimpleObjectMaker : public SimpleFactory<B>
{

public :

   SimpleObjectMaker(const string& name) : SimpleFactory<B>(name)
   {}

   B* make() const { return new A(); }
};

#include "Factory.cc"

#endif
