/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Family.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef Family_H
#define Family_H

#ifndef Basic_H
#include "Basic.h"
#endif


#include <string>
using std::string;


class FamilyHelper;

class Family : public Basic {
public:

// -- Exceptions
	// None

// -- Contructors

	Family(Folder* parent,
		const IconClass& kind, const string& name,
		IconInfo* info);

// -- Destructor

	virtual ~Family(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods


// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	Family(const Family&);
	Family& operator=(const Family&);

// -- Members

	FamilyHelper& helper_;

// -- Methods
 
	Request first() const;
	Request second() const;
	string  keyword() const;
	
// -- Overridden methods

	// From IconObject

	virtual Request request() const;
	virtual void request(const Request&);

	virtual const IconClass& editorClass() const;
	virtual const IconClass& iconClass() const;

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const Family& p)
	//	{ p.print(s); return s; }

};

inline void destroy(Family**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Family);
//#endif

#endif
