/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQTheme_H
#define MvQTheme_H

#include <QHash>
#include <QPalette>
#include <QString>

class QApplication;
class MvRequest;

class MvQTheme
{
public:  
  	MvQTheme();
	void load(QApplication* ,QString);

	static QBrush brush(QString group,QString item);
	static QColor colour(QString group,QString item);
	
private:
  	void parse(const MvRequest&);
	void readPalette(QPalette::ColorGroup group,const MvRequest& r);
	void readGroup(const char* verb,const MvRequest& r);
	static QColor colour(QString name);
	static QBrush brush(QString name);

	QPalette palette_;
	static QHash<QString,QHash<QString,QBrush> >  groups_;
};  

#endif
