/*
 * Copyright (C) Jan 2013 Mellanox Technologies Ltd. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
 

/***
         *** This file was generated at "2017-03-19 12:09:18"
         *** by:
         ***    > /mswg/release/eat_me/last_release/adabe_plugins/adb2c/adb2pack.py --input adb/connectib/connectib.adb --file-prefix connectib --prefix connectib_
         ***/
#ifndef CONNECTIB_LAYOUTS_H
#define CONNECTIB_LAYOUTS_H


#ifdef __cplusplus
extern "C" {
#endif

#include "adb_to_c_utils.h"/* Description -   */
/* Size in bytes - 12 */
struct connectib_cmdif_ctx_special_qp_commands_uapp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - uapp_qp_buf_id */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t uapp_qp_buf_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - used when qp is attached to xrq- MUST BE AT LAST DWORD OF SPECIAL CTX */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t sw_wq_mkn;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - used when qp is attached to xrq- MUST BE AT LAST DWORD OF SPECIAL CTX */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t num_nim_indicies_allocated;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_cmdif_ctx_special_qp_commands_underlay {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t ste_ix;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_regular_qp_eth {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - points to head qp that holds the rq state */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t rq_head_qpn;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t lag_tx_port_affinity;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_regular_qp_ipoib {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t underlay_qp_ste_ix;
};

/* Description -   */
/* Size in bytes - 12 */
union connectib_cmdif_ctx_special_qp_commands_inner {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_cmdif_ctx_special_qp_commands_underlay underlay_qp;
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_cmdif_ctx_special_qp_commands_uapp uapp;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_pmlp_code_style_lane {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t module_num;
	/* Description - Lane - up to 4 serdeses in a module can be mapped to a local port. */
	/* 0x0.16 - 0x0.17 */
	 u_int8_t module_lane;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_dw {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t dw;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_type_nvlog {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t parameter_index;
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t sub_class;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t class_;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_type_eswitch {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t parameter_index;
	/* Description -  */
	/* 0x0.16 - 0x0.17 */
	 u_int8_t port;
	/* Description -  */
	/* 0x0.18 - 0x0.23 */
	 u_int8_t host;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t class_;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_type_per_host {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.9 */
	 u_int16_t parameter_index;
	/* Description -  */
	/* 0x0.10 - 0x0.17 */
	 u_int8_t function;
	/* Description -  */
	/* 0x0.18 - 0x0.23 */
	 u_int8_t host;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t class_;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_type_bmc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.12 */
	 u_int16_t parameter_index;
	/* Description -  */
	/* 0x0.13 - 0x0.17 */
	 u_int8_t channel;
	/* Description -  */
	/* 0x0.18 - 0x0.23 */
	 u_int8_t host;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t class_;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_type_physical_port {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t parameter_index;
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t port;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t class_;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_type_global {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t parameter_index;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t class_;
};

/* Description -   */
/* Size in bytes - 4 */
union connectib_regular_qp_sub_type {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_regular_qp_ipoib ipoib;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_regular_qp_eth eth;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_cmdif_ctx_special_qp_commands_other {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - next sqn to allocate pages in sq qplist hop3  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t next_sqn_for_4page_allocate;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x10.31 */
	 union connectib_cmdif_ctx_special_qp_commands_inner inner;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_cmdif_ctx_special_qp_commands_rts2rts {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - rts2rts:  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t new_cqn_rcv;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - rts2rts:  */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t new_srqn_rmpn;
	/* Description - rts2rts:  */
	/* 0x4.24 - 0x4.27 */
	 u_int8_t srq_cre_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - rts2rts: union params2assign_u qp_params */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t qp_params;
};

/* Description -   */
/* Size in bytes - 36 */
struct connectib_pmlp_code_style {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - unmap local port
1 - x1 (lane 0 is used)
2 - x2 (lanes 0,1 are used)
4 - x4 (lanes 0,  1,2 and 3 are used)
Other - reserved */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t width;
	/* Description - Local port number */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x14.31 */
	 struct connectib_pmlp_code_style_lane local_lane[4];
};

/* Description -   */
/* Size in bytes - 36 */
struct connectib_pmlp_prm_style {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - unmap local port
1 - x1 (lane 0 is used)
2 - x2 (lanes 0,1 are used)
4 - x4 (lanes 0,  1,2 and 3 are used)
Other - reserved */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t width;
	/* Description - Local port number */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t module0;
	/* Description - Lane - up to 4 serdeses in a module can be mapped to a local port. */
	/* 0x4.16 - 0x4.17 */
	 u_int8_t lane0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t module1;
	/* Description - Lane - up to 4 serdeses in a module can be mapped to a local port. */
	/* 0x8.16 - 0x8.17 */
	 u_int8_t lane1;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.7 */
	 u_int8_t module2;
	/* Description - Lane - up to 4 serdeses in a module can be mapped to a local port. */
	/* 0xc.16 - 0xc.17 */
	 u_int8_t lane2;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.7 */
	 u_int8_t module3;
	/* Description - Lane - up to 4 serdeses in a module can be mapped to a local port. */
	/* 0x10.16 - 0x10.17 */
	 u_int8_t lane3;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_register_access_data_reduced {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Real size can be larger than 0x20. Size is extracted from TLV */
	/* 0x0.0 - 0x10.31 */
	 u_int32_t dword[4];
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_nv_tlv_hdr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Size of configuration item data in bytes (not including header). Must be between 0 and 256 */
	/* 0x0.0 - 0x0.8 */
	 u_int16_t length;
	/* Description - tlv writer host index */
	/* 0x0.9 - 0x0.11 */
	 u_int8_t writer_host_id;
	/* Description - Configuration item version - defines the data structure following the header (together with the type field). See configuration items definitions */
	/* 0x0.12 - 0x0.15 */
	 u_int8_t version;
	/* Description - Writer ID */
	/* 0x0.16 - 0x0.20 */
	 u_int8_t writer_id;
	/* Description - Choose - read current values or user defined values: 0x0 - user defined values
 0x1 - current values ( values that are loaded in last boot)
 */
	/* 0x0.22 - 0x0.22 */
	 u_int8_t read_current;
	/* Description - Choose - read default values or user defined values: 0x0 - user defined values
 0x1 - default values
 */
	/* 0x0.23 - 0x0.23 */
	 u_int8_t read_default;
	/* Description - Controls the read operation of non-FW entities.
0 - TLV can be read.
1 - TLV cannot be read */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t rd_en;
	/* Description - Enables overwriting a TLV by lower priorities.
00 - Only written during equal or higher priority.
01 - Allowed to be over-written by the next level priority.
10 - Allowed to be overwritten at any stage */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t ovr_en;
	/* Description - Encodes the storage element Header Format
00 - Only Header is protected by CRC
01 - Header and Data are protected by CRC
10 - reserved
11 - reserved */
	/* 0x0.26 - 0x0.27 */
	 u_int8_t header_type;
	/* Description - Defines the allowed access to the data element
00 - Written only during Mellanox production stage
01 - Written during Mellanox production and OEM production stage
10 - written at any stage
11 - Reserved */
	/* 0x0.28 - 0x0.29 */
	 u_int8_t priority;
	/* Description - Encodes the data element validity
11 - Free (no data esists)
10 - Valid data
00 - Invalidated data element, should be skipped
01 - Illegal, treated as Invalidated data element */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Configuration item type */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Encodes the data integrity check of the data element.
Note: in some elements only encodes the header into the CRC16, as defined in the header type field */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t crc16;
};

/* Description -   */
/* Size in bytes - 4 */
union connectib_nv_tlv_type {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_nv_tlv_type_global global;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_nv_tlv_type_physical_port physical_port;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_nv_tlv_type_bmc bmc;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_nv_tlv_type_per_host per_host;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_nv_tlv_type_eswitch eswitch;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_nv_tlv_type_nvlog nvlog;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_dw as_dw;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_register_access_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Real size can be larger than 0x20. Size is extracted from TLV */
	/* 0x0.0 - 0x20.31 */
	 u_int32_t dword[8];
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_mfba_header {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Flash Select */
	/* 0x0.4 - 0x0.5 */
	 u_int8_t fs;
	/* Description - Parallel */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t p;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Transaction size */
	/* 0x4.0 - 0x4.8 */
	 u_int16_t size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - address in bytes */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t address;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_pmmp_sfp_protocol_override_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 10G Ethernet Compliance Codes
Override byte3 per SFF-8472:
Bit 7 - 10G Base-ER 
Bit 6 - 10G Base-LRM 
Bit 5 - 10G Base-LR 
Bit 4 - 10G Base-SR */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t tengig_ethernet_compliance_code;
	/* Description - SFP+ Cable Technology
Override byte8 per SFF-8472:
Bit 3 - Active Cable
Bit 2 - Passive Cable */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t cable_technology;
	/* Description - Override byte12 per SFF-8472
The nominal bit (signaling) rate (BR, nominal) is specified in 
units of 100 MBd, rounded off to the nearest 100 MBd.
A value of FFh indicates the bit rate is greater than 25.0Gb/s */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t bit_rate;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Ethernet Compliance Codes 
Override byte6 per SFF-8472:
Bit 7 - BASE-PX 
Bit 6 - BASE-BX10 
Bit 5 - 100BASE-FX 
Bit 4 - 100BASE-LX/LX10 
Bit 3 - 1000BASE-T 
Bit 2 - 1000BASE-CX 
Bit 1 - 1000BASE-LX 
Bit 0 - 1000BASE-SX */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t ethernet_compliance_code;
	/* Description - Extended Specification Compliance Codes (25GE) 
Override byte36 per SFF-8472:
0 - Unspecified
1 - 100G AOC (Active Optical Cable) or 25GAUI C2M AOC 
with FEC
2 - 100GBASE-SR4 or 25GBASE-SR
3 - 100GBASE-LR4 or 25GBASE-LR
4 - 100GBASE-ER4 or 25GBASE-ER
5 - 100GBASE-SR10
6 - 100G CWDM4
7 - 100G PSM4 Parallel SMF
8 - 100G ACC (Active Copper Cable) or 25GAUI C2M ACC. 
with FEC
11 - 100GBASE-CR4 or 25GBASE-CR CA-L
12 - 25GBASE-CR CA-S
13 - 25GBASE-CR CA-N
16 - 40GBASE-ER4
17 - 4 x 10GBASE-SR
18 - 40G PSM4 Parallel SMF
19 - G959.1 profile P1I1-2D1 (10709 MBd, 2km, 1310nm SM)
20 - G959.1 profile P1S1-2D2 (10709 MBd, 40km, 1550nm SM)
21 - G959.1 profile P1L1-2D2 (10709 MBd, 80km, 1550nm SM)
22 - 10GBASE-T with SFI electrical interface
23 - 100G CLR4
24 - 100G AOC or 25GAUI C2M AOC. No FEC
25 - 100G ACC or 25GAUI C2M ACC. No FEC */
	/* 0x4.8 - 0x4.15 */
	 u_int8_t ext_ethernet_compliance_code;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_pmmp_qsfp_protocol_override_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Ethernet Compliance Codes bit mask (10/40G/100G)
Override byte131 per SFF-8636:
Bit 7 - Extended Specification Compliance valid
Bit 6 - 10GBASE-LRM
Bit 5 - 10GBASE-LR
Bit 4 - 10GBASE-SR
Bit 3 - 40GBASE-CR4
Bit 2 - 40GBASE-SR4
Bit 1 - 40GBASE-LR4
Bit 0 - 40G Active Cable (XLPPI) */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t ethernet_compliance_code;
	/* Description - Override of byte113 per SFF-8636:
Bit 6-4 (Far End):
0 - Far end is unspecified
1 - Cable with single far end with 4 channels implemented, or 
separable module with 4-channel connector
2 - Cable with single far end with 2 channels implemented, or 
separable module with 2-channel connector
3 - Cable with single far end with 1 channel implemented, or sep
arable module with 1-channel connector
4 - 4 far ends with 1 channel implemented in each (i.e. 4x1 break 
out)
5 - 2 far ends with 2 channels implemented in each (i.e. 2x2 
break out)
6 - 2 far ends with 1 channel implemented in each (i.e. 2x1 break 
out)
Bit 3-0 (Near End)
Bit 0 - Channel 1 implementation 
Bit 1 - Channel 2 implementation
Bit 2 - Channel 3 implementation
Bit 3 - Channel 4 implementation
for each channel:
0 - Channel implemented 
1 - Channel not - implemented */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t cable_breakout;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Gigabit Ethernet Compliance Codes 
Override byte134 per SFF-8636:
Bit 3 - 1000BASE-T
Bit 2 - 1000BASE-CX
Bit 1 - 1000BASE-LX
Bit 0 - 1000BASE-SX */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t giga_ethernet_compliance_code;
	/* Description - Extended Specification Compliance Codes 
Override byte192 per SFF-8636:
0 - Unspecified
1 - 100G AOC (Active Optical Cable) or 25GAUI C2M AOC 
with FEC
2 - 100GBASE-SR4 or 25GBASE-SR
3 - 100GBASE-LR4 or 25GBASE-LR
4 - 100GBASE-ER4 or 25GBASE-ER
5 - 100GBASE-SR10
6 - 100G CWDM4
7 - 100G PSM4 Parallel SMF
8 - 100G ACC (Active Copper Cable) or 25GAUI C2M ACC. 
with FEC
11 - 100GBASE-CR4 or 25GBASE-CR CA-L
12 - 25GBASE-CR CA-S
13 - 25GBASE-CR CA-N
16 - 40GBASE-ER4
17 - 4 x 10GBASE-SR
18 - 40G PSM4 Parallel SMF
19 - G959.1 profile P1I1-2D1 (10709 MBd, 2km, 1310nm SM)
20 - G959.1 profile P1S1-2D2 (10709 MBd, 40km, 1550nm SM)
21 - G959.1 profile P1L1-2D2 (10709 MBd, 80km, 1550nm SM)
22 - 10GBASE-T with SFI electrical interface
23 - 100G CLR4
24 - 100G AOC or 25GAUI C2M AOC. No FEC
25 - 100G ACC or 25GAUI C2M ACC. No FEC */
	/* 0x4.8 - 0x4.15 */
	 u_int8_t ext_ethernet_compliance_code;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_pcie_timers_states {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - [Internal] 
Life time counter - can't be cleared. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t life_time_counter_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - [Internal] 
Life time counter - can't be cleared. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t life_time_counter_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Time form start until FW boot image starts running in 
usec. 
Note: can't be cleared. */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t time_to_boot_image_start;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Time form start until FW pci_link image starts running 
in usec. */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t time_to_link_image;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Time it took FW to do calibration in usec. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t calibration_time;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Time form start until FW handle first prest */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t time_to_first_perst;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Time form start until first transition to LTSSM.Detect_Q */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t time_to_detect_state;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Time form start until first transition to LTSSM.L0 */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t time_to_l0;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Time form start until crs is enabled */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t time_to_crs_en;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Time form start until FW plastic image starts running in 
usec. */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t time_to_plastic_image_start;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Time form start until FW iron image starts running in 
usec. */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t time_to_iron_image_start;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - Number of persts arrived */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t perst_handler;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - Number of times LTSSM entered L1 flow */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t times_in_l1;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - Number of times LTSSM entered L23 flow */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t times_in_l23;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - Number of moves for DL_active to DL_down */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t dl_down;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Number of configuration requests that FW handled in 
less then 1 usec */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t config_cycle1usec;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - Number of configuration requests that FW handled 
within 2 to 7 usec */
	/* 0x40.0 - 0x44.31 */
	 u_int32_t config_cycle2to7usec;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - Number of configuration requests that FW handled 
within 8 to 15 usec */
	/* 0x44.0 - 0x48.31 */
	 u_int32_t config_cycle8to15usec;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - Number of configuration requests that FW handled 
within 16 to 63 usec */
	/* 0x48.0 - 0x4c.31 */
	 u_int32_t config_cycle16to63usec;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - Number of configuration requests that FW handled took 
more than 64 usec */
	/* 0x4c.0 - 0x50.31 */
	 u_int32_t config_cycle64usec;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - Number of correctable error msg sent */
	/* 0x50.0 - 0x54.31 */
	 u_int32_t correctable_err_msg_sent;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - Number of Non-Fatal error msg sent */
	/* 0x54.0 - 0x58.31 */
	 u_int32_t non_fatal_err_msg_sent;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - Number of Fatal error msg sent */
	/* 0x58.0 - 0x5c.31 */
	 u_int32_t fatal_err_msg_sent;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_pcie_lanes_counters {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - [Internal] 
Life time counter - can't be cleared. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t life_time_counter_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - [Internal] 
Life time counter - can't be cleared. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t life_time_counter_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Number of errors detected on logical lane 0 */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t error_counter_lane0;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Number of errors detected on logical lane 1 */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t error_counter_lane1;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Number of errors detected on logical lane 2 */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t error_counter_lane2;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Number of errors detected on logical lane 3 */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t error_counter_lane3;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Number of errors detected on logical lane 4 */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t error_counter_lane4;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Number of errors detected on logical lane 5 */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t error_counter_lane5;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Number of errors detected on logical lane 6 */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t error_counter_lane6;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Number of errors detected on logical lane 7 */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t error_counter_lane7;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Number of errors detected on logical lane 8 */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t error_counter_lane8;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - Number of errors detected on logical lane 9 */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t error_counter_lane9;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - Number of errors detected on logical lane 10 */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t error_counter_lane10;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - Number of errors detected on logical lane 11 */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t error_counter_lane11;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - Number of errors detected on logical lane 12 */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t error_counter_lane12;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Number of errors detected on logical lane 13 */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t error_counter_lane13;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - Number of errors detected on logical lane 14 */
	/* 0x40.0 - 0x44.31 */
	 u_int32_t error_counter_lane14;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - Number of errors detected on logical lane 15 */
	/* 0x44.0 - 0x48.31 */
	 u_int32_t error_counter_lane15;
};

/* Description -   */
/* Size in bytes - 200 */
struct connectib_pcie_perf_counters {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Life time counter - can't be cleared. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t life_time_counter_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Life time counter - can't be cleared. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t life_time_counter_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Number of transitions to recovery due to Framing errors 
and CRC
 
(dlp and tlp) errors. */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t rx_errors;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Number of transitions to recovery due to EIEOS and TS 
errors. */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t tx_errors;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t l0_to_recovery_eieos;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t l0_to_recovery_ts;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t l0_to_recovery_framing;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t l0_to_recovery_retrain;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t crc_error_dllp;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t crc_error_tlp;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_phys_layer_stat_cntrs {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The time passed since the last counters clear event in 
msec. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t time_since_last_clear_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The time passed since the last counters clear event in 
msec. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t time_since_last_clear_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - This counter provides information on the total amount of 
traffic (bits) received. */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t phy_received_bits_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - This counter provides information on the total amount of 
traffic (bits) received. */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t phy_received_bits_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - This counter provides information on errors bits that 
wasn't corrected by FEC correction algorithm or that 
FEC is not active. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t phy_symbol_errors_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - This counter provides information on errors bits that 
wasn't corrected by FEC correction algorithm or that 
FEC is not active. */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t phy_symbol_errors_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Corrected bits by FEC engine. */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t phy_corrected_bits_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Corrected bits by FEC engine. */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t phy_corrected_bits_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - TBD */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t phy_corrected_bits_lane0_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - TBD */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t phy_corrected_bits_lane0_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - TBD */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t phy_corrected_bits_lane1_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - TBD */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t phy_corrected_bits_lane1_low;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - TBD */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t phy_corrected_bits_lane2_high;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - TBD */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t phy_corrected_bits_lane2_low;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - TBD */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t phy_corrected_bits_lane3_high;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - TBD */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t phy_corrected_bits_lane3_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - Raw_BER = 
raw_ber_coef*
10^(-
raw_ber_magnitude) */
	/* 0x60.0 - 0x60.3 */
	 u_int8_t raw_ber_coef;
	/* Description - Raw_BER = 
raw_ber_coef*
10^(-
raw_ber_magnitude) */
	/* 0x60.8 - 0x60.15 */
	 u_int8_t raw_ber_magnitude;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description - Effective_BER = 
effective_ber_coef*
10^(-
effective_ber_magnitude) */
	/* 0x64.0 - 0x64.3 */
	 u_int8_t effective_ber_coef;
	/* Description - Effective_BER = 
effective_ber_coef*
10^(-
effective_ber_magnitude) */
	/* 0x64.8 - 0x64.15 */
	 u_int8_t effective_ber_magnitude;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_per_traffic_congestion_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t wred_discard_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t wred_discard_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_ib_port_counters {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Total number of times the Port Training state machine has failed the link error recovery process and downed the link. Refer to the InfiniBand Architecture Specification, Volume 2, Link/Phy Interface. */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t link_downed_counter;
	/* Description - Total number of times the Port Training state machine has successfully completed the link error recovery. */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t link_error_recovery_counter;
	/* Description - Total number of minor link errors detected on one or more physical lanes. */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t symbol_error_counter;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Total number of packets marked with the EBP delimiter received on the port. */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t port_rcv_remote_physical_errors;
	/* Description - Total number of packets containing an error that were received on the port. */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t port_rcv_errors;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t port_xmit_discards;
	/* Description - Total number of packets received on the port that were discarded because they could not be forwarded by the switch relay. */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t port_rcv_switch_relay_errors;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The number of times that OverrunErrors consecutive flow control update periods occurred., each having at least one overrun error. */
	/* 0xc.0 - 0xc.3 */
	 u_int8_t excessive_buffer_overrun_errors;
	/* Description - The number of times that the count of local physical errors exceeded the threshold */
	/* 0xc.4 - 0xc.7 */
	 u_int8_t local_link_integrity_errors;
	/* Description - Total number of packets received on the port that are discarded. */
	/* 0xc.16 - 0xc.23 */
	 u_int8_t port_rcv_constraint_errors;
	/* Description - Total number of packets not transmitted from the port for the following reasons: " FilterRawOutbound is true and packet is raw " PartitionEnforcementOutbound is true and packet fails partition key check or IP version check */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t port_xmit_constraint_errors;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Number of incoming VL15 packets dropped due to resource limitations (e.g., lack of buffers) in the port */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t vl15_dropped;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Optional; shall be zero if not implemented. Total number of data octets, divided by 4, transmitted on all VLs from the port. This includes all octets between (and not including) the start of packet delimiter and the VCRC, and may include packets containing errors. */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t port_xmit_data;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Optional; shall be zero if not implemented. Total number of data octets, divided by 4, received on all VLs at the port. This includes all octets between (and not including) the start of packet delimiter and the VCRC, and may include packets containing errors. */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t port_rcv_data;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Optional; shall be zero if not implemented. Total number of packets transmitted on all VLs from the port. */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t port_xmit_pkts;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Optional; shall be zero if not implemented. Total number of packets, including packets containing errors */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t port_rcv_pkts;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - If ClassPortInfo:CapabilityMask.PortCountersXmitWaitSupported
is set to 1, the number of ticks during which the port
selected by PortSelect had data to transmit but no data was sent
during the entire tick either because of insufficient credits or
because of lack of arbitration.
Otherwise, undefined. */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t port_xmit_wait;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_llr_counters {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The total number of cells recieved (including bad cells) */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t llr_rx_cells_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t llr_rx_cells_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The total number of bad cells recieved (including CRC error) */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t llr_rx_error_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t llr_rx_error_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The total number of cells recieved with CRC error */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t llr_rx_crc_error_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t llr_rx_crc_error_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - The total number of cells transmitted (including retransmitted cells) */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t llr_tx_cells_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t llr_tx_cells_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - The total number of cells retransmitted */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t llr_tx_ret_cells_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t llr_tx_ret_cells_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - The total number of retransmission events */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t llr_tx_ret_events_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t llr_tx_ret_events_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_discard_cntrs_grp_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t ingress_general_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t ingress_general_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t ingress_policy_engine_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t ingress_policy_engine_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t ingress_vlan_membership_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t ingress_vlan_membership_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t ingress_tag_frame_type_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t ingress_tag_frame_type_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t egress_vlan_membership_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t egress_vlan_membership_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t loopback_filter_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t loopback_filter_low;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t egress_general_high;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t egress_general_low;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t egress_link_down_high;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t egress_link_down_low;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x44.31 */
	 u_int32_t egress_hoq_high;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description -  */
	/* 0x44.0 - 0x48.31 */
	 u_int32_t egress_hoq_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description -  */
	/* 0x48.0 - 0x4c.31 */
	 u_int32_t port_isolation_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description -  */
	/* 0x4c.0 - 0x50.31 */
	 u_int32_t port_isolation_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description -  */
	/* 0x50.0 - 0x54.31 */
	 u_int32_t egress_policy_engine_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description -  */
	/* 0x54.0 - 0x58.31 */
	 u_int32_t egress_policy_engine_low;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description -  */
	/* 0x58.0 - 0x5c.31 */
	 u_int32_t ingress_tx_link_down_high;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description -  */
	/* 0x5c.0 - 0x60.31 */
	 u_int32_t ingress_tx_link_down_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description -  */
	/* 0x60.0 - 0x64.31 */
	 u_int32_t egress_stp_filter_high;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description -  */
	/* 0x64.0 - 0x68.31 */
	 u_int32_t egress_stp_filter_low;
/*---------------- DWORD[26] (Offset 0x68) ----------------*/
	/* Description -  */
	/* 0x68.0 - 0x6c.31 */
	 u_int32_t egress_hoq_stall_high;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description -  */
	/* 0x6c.0 - 0x70.31 */
	 u_int32_t egress_hoq_stall_low;
};

/* Description -   */
/* Size in bytes - 200 */
struct connectib_phys_layer_cntrs {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The time passed since the last counters clear event in 
msec. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t time_since_last_clear_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The time passed since the last counters clear event in 
msec. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t time_since_last_clear_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Perf.PortCounters(SymbolErrorCounter)
 = Perf.Port
Counters(UnknownSymbol) */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t symbol_errors_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Perf.PortCounters(SymbolErrorCounter)
 = Perf.Port
Counters(UnknownSymbol) */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t symbol_errors_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Perf.PortExtendedSpeedsCounters(SynchHeaderError
Counter) */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t sync_headers_errors_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Perf.PortExtendedSpeedsCounters(SynchHeaderError
Counter) */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t sync_headers_errors_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane0Counter) / BIP error 
counter, lane 0
In PRBS test mode, indicates the number of PRBS errors 
on lane 0 */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t edpl_bip_errors_lane0_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane0Counter) / BIP error 
counter, lane 0
In PRBS test mode, indicates the number of PRBS errors 
on lane 0 */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t edpl_bip_errors_lane0_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane1Counter) / BIP error 
counter, lane 1
In PRBS test mode, indicates the number of PRBS errors 
on lane 1 */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t edpl_bip_errors_lane1_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane1Counter) / BIP error 
counter, lane 1
In PRBS test mode, indicates the number of PRBS errors 
on lane 1 */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t edpl_bip_errors_lane1_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane2Counter) / BIP error 
counter, lane 2
In PRBS test mode, indicates the number of PRBS errors 
on lane 2 */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t edpl_bip_errors_lane2_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane2Counter) / BIP error 
counter, lane 2
In PRBS test mode, indicates the number of PRBS errors 
on lane 2 */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t edpl_bip_errors_lane2_low;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane3Counter) / BIP error 
counter, lane 3
In PRBS test mode, indicates the number of PRBS errors 
on lane 3 */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t edpl_bip_errors_lane3_high;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane3Counter) / BIP error 
counter, lane 3
In PRBS test mode, indicates the number of PRBS errors 
on lane 3 */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t edpl_bip_errors_lane3_low;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane0) */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t fc_fec_corrected_blocks_lane0_high;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane0) */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t fc_fec_corrected_blocks_lane0_low;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane1) */
	/* 0x40.0 - 0x44.31 */
	 u_int32_t fc_fec_corrected_blocks_lane1_high;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane1) */
	/* 0x44.0 - 0x48.31 */
	 u_int32_t fc_fec_corrected_blocks_lane1_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane2) */
	/* 0x48.0 - 0x4c.31 */
	 u_int32_t fc_fec_corrected_blocks_lane2_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane2) */
	/* 0x4c.0 - 0x50.31 */
	 u_int32_t fc_fec_corrected_blocks_lane2_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane3) */
	/* 0x50.0 - 0x54.31 */
	 u_int32_t fc_fec_corrected_blocks_lane3_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane3) */
	/* 0x54.0 - 0x58.31 */
	 u_int32_t fc_fec_corrected_blocks_lane3_low;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane0) */
	/* 0x58.0 - 0x5c.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane0_high;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane0) */
	/* 0x5c.0 - 0x60.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane0_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane1) */
	/* 0x60.0 - 0x64.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane1_high;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane1) */
	/* 0x64.0 - 0x68.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane1_low;
/*---------------- DWORD[26] (Offset 0x68) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane2) */
	/* 0x68.0 - 0x6c.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane2_high;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane2) */
	/* 0x6c.0 - 0x70.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane2_low;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane3) */
	/* 0x70.0 - 0x74.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane3_high;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane3) */
	/* 0x74.0 - 0x78.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane3_low;
/*---------------- DWORD[30] (Offset 0x78) ----------------*/
	/* Description - Perf.PortExtendedSpeedsCounters(FECCorrecable
BlockCounter) */
	/* 0x78.0 - 0x7c.31 */
	 u_int32_t rs_fec_corrected_blocks_high;
/*---------------- DWORD[31] (Offset 0x7c) ----------------*/
	/* Description - Perf.PortExtendedSpeedsCounters(FECCorrecable
BlockCounter) */
	/* 0x7c.0 - 0x80.31 */
	 u_int32_t rs_fec_corrected_blocks_low;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description - Perf.PortExtendedSpeedsCounters(FEUncorrecable
BlockCounter) */
	/* 0x80.0 - 0x84.31 */
	 u_int32_t rs_fec_uncorrectable_blocks_high;
/*---------------- DWORD[33] (Offset 0x84) ----------------*/
	/* Description - Perf.PortExtendedSpeedsCounters(FEUncorrecable
BlockCounter) */
	/* 0x84.0 - 0x88.31 */
	 u_int32_t rs_fec_uncorrectable_blocks_low;
/*---------------- DWORD[34] (Offset 0x88) ----------------*/
	/* Description - The number of RS-FEC blocks received that had no 
errors.
Note: Total rs_fec blocks received = 
rs_fec_corrected_blocks + rs_fec_uncorrectable_blocks 
+ rs_fec_no_errors_blocks */
	/* 0x88.0 - 0x8c.31 */
	 u_int32_t rs_fec_no_errors_blocks_high;
/*---------------- DWORD[35] (Offset 0x8c) ----------------*/
	/* Description - The number of RS-FEC blocks received that had no 
errors.
Note: Total rs_fec blocks received = 
rs_fec_corrected_blocks + rs_fec_uncorrectable_blocks 
+ rs_fec_no_errors_blocks */
	/* 0x8c.0 - 0x90.31 */
	 u_int32_t rs_fec_no_errors_blocks_low;
/*---------------- DWORD[36] (Offset 0x90) ----------------*/
	/* Description - The number of corrected RS-FEC blocks received that 
had exactly 1 error symbol. 
Note: A FEC block that is counted by 
rs_fec_single_error_blocks is counted also by 
rs_fec_corrected_blocks */
	/* 0x90.0 - 0x94.31 */
	 u_int32_t rs_fec_single_error_blocks_high;
/*---------------- DWORD[37] (Offset 0x94) ----------------*/
	/* Description - The number of corrected RS-FEC blocks received that 
had exactly 1 error symbol. 
Note: A FEC block that is counted by 
rs_fec_single_error_blocks is counted also by 
rs_fec_corrected_blocks */
	/* 0x94.0 - 0x98.31 */
	 u_int32_t rs_fec_single_error_blocks_low;
/*---------------- DWORD[38] (Offset 0x98) ----------------*/
	/* Description - Perf.PortExtendedSpeedCounters(PortFECCorrect
edSymbolCounter) */
	/* 0x98.0 - 0x9c.31 */
	 u_int32_t rs_fec_corrected_symbols_total_high;
/*---------------- DWORD[39] (Offset 0x9c) ----------------*/
	/* Description - Perf.PortExtendedSpeedCounters(PortFECCorrect
edSymbolCounter) */
	/* 0x9c.0 - 0xa0.31 */
	 u_int32_t rs_fec_corrected_symbols_total_low;
/*---------------- DWORD[40] (Offset 0xa0) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane0) */
	/* 0xa0.0 - 0xa4.31 */
	 u_int32_t rs_fec_corrected_symbols_lane0_high;
/*---------------- DWORD[41] (Offset 0xa4) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane0) */
	/* 0xa4.0 - 0xa8.31 */
	 u_int32_t rs_fec_corrected_symbols_lane0_low;
/*---------------- DWORD[42] (Offset 0xa8) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane1) */
	/* 0xa8.0 - 0xac.31 */
	 u_int32_t rs_fec_corrected_symbols_lane1_high;
/*---------------- DWORD[43] (Offset 0xac) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane1) */
	/* 0xac.0 - 0xb0.31 */
	 u_int32_t rs_fec_corrected_symbols_lane1_low;
/*---------------- DWORD[44] (Offset 0xb0) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane2) */
	/* 0xb0.0 - 0xb4.31 */
	 u_int32_t rs_fec_corrected_symbols_lane2_high;
/*---------------- DWORD[45] (Offset 0xb4) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane2) */
	/* 0xb4.0 - 0xb8.31 */
	 u_int32_t rs_fec_corrected_symbols_lane2_low;
/*---------------- DWORD[46] (Offset 0xb8) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane3) */
	/* 0xb8.0 - 0xbc.31 */
	 u_int32_t rs_fec_corrected_symbols_lane3_high;
/*---------------- DWORD[47] (Offset 0xbc) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane3) */
	/* 0xbc.0 - 0xc0.31 */
	 u_int32_t rs_fec_corrected_symbols_lane3_low;
/*---------------- DWORD[48] (Offset 0xc0) ----------------*/
	/* Description - Perf.PortCounters(LinkDownedCounter) */
	/* 0xc0.0 - 0xc4.31 */
	 u_int32_t link_down_events;
/*---------------- DWORD[49] (Offset 0xc4) ----------------*/
	/* Description - Perf.PortCounters(LinkErrorRecoveryCounter) */
	/* 0xc4.0 - 0xc8.31 */
	 u_int32_t successful_recovery_events;
};

/* Description -   */
/* Size in bytes - 56 */
struct connectib_correct_on_demand_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The number of all rewind events */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t rewind_counter_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The number of all rewind events */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t rewind_counter_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The amount of data that were rewinded */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t data_rewinded_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The amount of data that were rewinded */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t data_rewinded_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The amount of packets that were rewinded */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t pkt_rewinded_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - The amount of packets that were rewinded */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t pkt_rewinded_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - The total number of received data - both good and rewinded data */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t total_rcv_data_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - The total number of received data - both good and rewinded data */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t total_rcv_data_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - The total number of received packets - both good and rewinded packets */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t total_rcv_pkt_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - The total number of received packets - both good and rewinded packets */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t total_rcv_pkt_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_per_traffic_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Contains the transmit queue depth in bytes on traffic class selected 
by 
traffic_class
 of the port selected by 
local_port
. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t transmit_queue_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Contains the transmit queue depth in bytes on traffic class selected 
by 
traffic_class
 of the port selected by 
local_port
. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t transmit_queue_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t no_buffer_discard_uc_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t no_buffer_discard_uc_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_per_prio_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The total number of octets received, including framing characters. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t rx_octets_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The total number of octets received, including framing characters. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t rx_octets_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - The total number of packets received for this priority (including control 
frames). */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t rx_frames_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - The total number of packets received for this priority (including control 
frames). */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t rx_frames_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - The total number of octets transmitted, including framing characters. */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t tx_octets_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - The total number of octets transmitted, including framing characters. */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t tx_octets_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - The total number of packets transmitted. */
	/* 0x48.0 - 0x4c.31 */
	 u_int32_t tx_frames_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - The total number of packets transmitted. */
	/* 0x4c.0 - 0x50.31 */
	 u_int32_t tx_frames_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - The total number of PAUSE frames received from the far-end port. */
	/* 0x50.0 - 0x54.31 */
	 u_int32_t rx_pause_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - The total number of PAUSE frames received from the far-end port. */
	/* 0x54.0 - 0x58.31 */
	 u_int32_t rx_pause_low;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - The total time in microseconds that transmission of packets to the far-end 
port have been paused. */
	/* 0x58.0 - 0x5c.31 */
	 u_int32_t rx_pause_duration_high;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - The total time in microseconds that transmission of packets to the far-end 
port have been paused. */
	/* 0x5c.0 - 0x60.31 */
	 u_int32_t rx_pause_duration_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - The total number of PAUSE frames sent to the far-end port. */
	/* 0x60.0 - 0x64.31 */
	 u_int32_t tx_pause_high;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description - The total number of PAUSE frames sent to the far-end port. */
	/* 0x64.0 - 0x68.31 */
	 u_int32_t tx_pause_low;
/*---------------- DWORD[26] (Offset 0x68) ----------------*/
	/* Description - The total time in microseconds that the far-end port have been requested 
to paused. */
	/* 0x68.0 - 0x6c.31 */
	 u_int32_t tx_pause_duration_high;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description - The total time in microseconds that the far-end port have been requested 
to paused. */
	/* 0x6c.0 - 0x70.31 */
	 u_int32_t tx_pause_duration_low;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description - Counts the number of transitions from Xoff to Xon. */
	/* 0x70.0 - 0x74.31 */
	 u_int32_t rx_pause_transition_high;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description - Counts the number of transitions from Xoff to Xon. */
	/* 0x74.0 - 0x78.31 */
	 u_int32_t rx_pause_transition_low;
/*---------------- DWORD[30] (Offset 0x78) ----------------*/
	/* Description - The number of inbound packets which were chosen to be dis
carded even though no errors had been detected to prevent 
their being deliverable to a higher-layer protocol. */
	/* 0x78.0 - 0x7c.31 */
	 u_int32_t rx_discards_high;
/*---------------- DWORD[31] (Offset 0x7c) ----------------*/
	/* Description - The number of inbound packets which were chosen to be dis
carded even though no errors had been detected to prevent 
their being deliverable to a higher-layer protocol. */
	/* 0x7c.0 - 0x80.31 */
	 u_int32_t rx_discards_low;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 0x80.0 - 0x84.31 */
	 u_int32_t device_stall_minor_watermark_cnt_high;
/*---------------- DWORD[33] (Offset 0x84) ----------------*/
	/* Description -  */
	/* 0x84.0 - 0x88.31 */
	 u_int32_t device_stall_minor_watermark_cnt_low;
/*---------------- DWORD[34] (Offset 0x88) ----------------*/
	/* Description -  */
	/* 0x88.0 - 0x8c.31 */
	 u_int32_t device_stall_critical_watermark_cnt_high;
/*---------------- DWORD[35] (Offset 0x8c) ----------------*/
	/* Description -  */
	/* 0x8c.0 - 0x90.31 */
	 u_int32_t device_stall_critical_watermark_cnt_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_extended_cntrs_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The number of ticks during which the port selected had data to 
transmit but no data was sent during the entire tick either because 
of insufficient credits or because of lack of arbitration.
A tick is a multiple of the time needed to transfer one byte on a 
single lane, that is, the symbol time. 
For example, for links operating at IBA SDR (single data rate), 
the symbol time is 4nsec. independent of the width of the link. 
For links operating at Ethernet 10GE on a single lane or 40GE on 
4 lanes, the symbol time is 0.8nSec. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t port_transmit_wait_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The number of ticks during which the port selected had data to 
transmit but no data was sent during the entire tick either because 
of insufficient credits or because of lack of arbitration.
A tick is a multiple of the time needed to transfer one byte on a 
single lane, that is, the symbol time. 
For example, for links operating at IBA SDR (single data rate), 
the symbol time is 4nsec. independent of the width of the link. 
For links operating at Ethernet 10GE on a single lane or 40GE on 
4 lanes, the symbol time is 0.8nSec. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t port_transmit_wait_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t ecn_marked_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t ecn_marked_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t no_buffer_discard_mc_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t no_buffer_discard_mc_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_3635_cntrs_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - A count of frames received that are not an integral number 
of octets in length and do not pass the FCS check. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t dot3stats_alignment_errors_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - A count of frames received that are not an integral number 
of octets in length and do not pass the FCS check. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t dot3stats_alignment_errors_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - A count of frames received that are an integral number of 
octets in length but do not pass the FCS check. This count 
does not include frames received with frame-too-long or 
frame-too-short errors. */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t dot3stats_fcs_errors_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - A count of frames received that are an integral number of 
octets in length but do not pass the FCS check. This count 
does not include frames received with frame-too-long or 
frame-too-short errors. */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t dot3stats_fcs_errors_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - A count of frames that are involved in a single collision, 
and are subsequently transmitted successfully.
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t dot3stats_single_collision_frames_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - A count of frames that are involved in a single collision, 
and are subsequently transmitted successfully.
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t dot3stats_single_collision_frames_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - A count of frames that are involved in more than one colli
sion and are subsequently transmitted successfully. 
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t dot3stats_multiple_collision_frames_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - A count of frames that are involved in more than one colli
sion and are subsequently transmitted successfully. 
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t dot3stats_multiple_collision_frames_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - A count of times that the SQE TEST ERROR is received 
on a particular interface.
This counter does not increment on interfaces operating at 
speeds greater than 10 Mb/s, or on interfaces operating in 
full-duplex mode. */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t dot3stats_sqe_test_errors_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - A count of times that the SQE TEST ERROR is received 
on a particular interface.
This counter does not increment on interfaces operating at 
speeds greater than 10 Mb/s, or on interfaces operating in 
full-duplex mode. */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t dot3stats_sqe_test_errors_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - A count of frames for which the first transmission attempt 
on a particular interface is delayed because the medium is 
busy. 
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t dot3stats_deferred_transmissions_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - A count of frames for which the first transmission attempt 
on a particular interface is delayed because the medium is 
busy. 
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t dot3stats_deferred_transmissions_low;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - The number of times that a collision is detected on a par
ticular interface later than one slotTime into the transmis
sion of a packet.
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t dot3stats_late_collisions_high;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - The number of times that a collision is detected on a par
ticular interface later than one slotTime into the transmis
sion of a packet.
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t dot3stats_late_collisions_low;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - A count of frames for which transmission on a particular 
interface fails due to excessive collisions.
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t dot3stats_excessive_collisions_high;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - A count of frames for which transmission on a particular 
interface fails due to excessive collisions.
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t dot3stats_excessive_collisions_low;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - A count of frames for which transmission failed and were 
discarded even though no errors had been detected to pre
vent their being deliverable to a higher-layer protocol. */
	/* 0x40.0 - 0x44.31 */
	 u_int32_t dot3stats_internal_mac_transmit_errors_high;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - A count of frames for which transmission failed and were 
discarded even though no errors had been detected to pre
vent their being deliverable to a higher-layer protocol. */
	/* 0x44.0 - 0x48.31 */
	 u_int32_t dot3stats_internal_mac_transmit_errors_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - The number of times that the carrier sense condition was 
lost or never asserted when attempting to transmit a frame 
on a particular interface. 
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 0x48.0 - 0x4c.31 */
	 u_int32_t dot3stats_carrier_sense_errors_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - The number of times that the carrier sense condition was 
lost or never asserted when attempting to transmit a frame 
on a particular interface. 
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 0x4c.0 - 0x50.31 */
	 u_int32_t dot3stats_carrier_sense_errors_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - A count of frames received that exceed the maximum per
mitted frame size. */
	/* 0x50.0 - 0x54.31 */
	 u_int32_t dot3stats_frame_too_longs_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - A count of frames received that exceed the maximum per
mitted frame size. */
	/* 0x54.0 - 0x58.31 */
	 u_int32_t dot3stats_frame_too_longs_low;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - A count of frames for which reception failed and were dis
carded even though no errors had been detected to prevent 
their being deliverable to a higher-layer protocol. */
	/* 0x58.0 - 0x5c.31 */
	 u_int32_t dot3stats_internal_mac_receive_errors_high;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - A count of frames for which reception failed and were dis
carded even though no errors had been detected to prevent 
their being deliverable to a higher-layer protocol. */
	/* 0x5c.0 - 0x60.31 */
	 u_int32_t dot3stats_internal_mac_receive_errors_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - The number of times the receiving media is non-idle (a 
carrier event) for a period of time equal to or greater than 
minFrameSize, and during which there was at least one 
occurrence of an event that causes the PHY to indicate 
"Receive Error". */
	/* 0x60.0 - 0x64.31 */
	 u_int32_t dot3stats_symbol_errors_high;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description - The number of times the receiving media is non-idle (a 
carrier event) for a period of time equal to or greater than 
minFrameSize, and during which there was at least one 
occurrence of an event that causes the PHY to indicate 
"Receive Error". */
	/* 0x64.0 - 0x68.31 */
	 u_int32_t dot3stats_symbol_errors_low;
/*---------------- DWORD[26] (Offset 0x68) ----------------*/
	/* Description - A count of MAC Control frames received that contain an 
opcode that is not supported. */
	/* 0x68.0 - 0x6c.31 */
	 u_int32_t dot3control_in_unknown_opcodes_high;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description - A count of MAC Control frames received that contain an 
opcode that is not supported. */
	/* 0x6c.0 - 0x70.31 */
	 u_int32_t dot3control_in_unknown_opcodes_low;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description - A count of MAC Control frames received with an opcode 
indicating the PAUSE operation. */
	/* 0x70.0 - 0x74.31 */
	 u_int32_t dot3in_pause_frames_high;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description - A count of MAC Control frames received with an opcode 
indicating the PAUSE operation. */
	/* 0x74.0 - 0x78.31 */
	 u_int32_t dot3in_pause_frames_low;
/*---------------- DWORD[30] (Offset 0x78) ----------------*/
	/* Description - A count of MAC Control frames transmitted with an 
opcode indicating the PAUSE operation. */
	/* 0x78.0 - 0x7c.31 */
	 u_int32_t dot3out_pause_frames_high;
/*---------------- DWORD[31] (Offset 0x7c) ----------------*/
	/* Description - A count of MAC Control frames transmitted with an 
opcode indicating the PAUSE operation. */
	/* 0x7c.0 - 0x80.31 */
	 u_int32_t dot3out_pause_frames_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_2819_cntrs_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The total number of events in which packets were 
dropped by the probe due to lack of resources. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t ether_stats_drop_events_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The total number of events in which packets were 
dropped by the probe due to lack of resources. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t ether_stats_drop_events_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The total number of octets of data (including those in 
bad packets) received (excluding framing bits but 
including FCS octets). */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t ether_stats_octets_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The total number of octets of data (including those in 
bad packets) received (excluding framing bits but 
including FCS octets). */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t ether_stats_octets_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The total number of packets (including bad packets, 
broadcast packets, and multicast packets) received. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t ether_stats_pkts_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - The total number of packets (including bad packets, 
broadcast packets, and multicast packets) received. */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t ether_stats_pkts_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - The total number of good packets received that were 
directed to the broadcast address. 
Note: This does not include multicast packets. */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t ether_stats_broadcast_pkts_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - The total number of good packets received that were 
directed to the broadcast address. 
Note: This does not include multicast packets. */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t ether_stats_broadcast_pkts_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - The total number of good packets received that were 
directed to a multicast MAC address. 
Note: This number does not include packets directed 
to the broadcast address. */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t ether_stats_multicast_pkts_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - The total number of good packets received that were 
directed to a multicast MAC address. 
Note: This number does not include packets directed 
to the broadcast address. */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t ether_stats_multicast_pkts_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - The total number of packets received that had a length 
(excluding framing bits, but including FCS octets) of 
between 64 and MTU
 octets, inclusive, but had either 
a bad frame check sequence (FCS) with an integral 
number of octets (FCS error) or a bad FCS with a 
non-integral number of octets (alignment error). */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t ether_stats_crc_align_errors_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - The total number of packets received that had a length 
(excluding framing bits, but including FCS octets) of 
between 64 and MTU
 octets, inclusive, but had either 
a bad frame check sequence (FCS) with an integral 
number of octets (FCS error) or a bad FCS with a 
non-integral number of octets (alignment error). */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t ether_stats_crc_align_errors_low;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - The total number of packets received that were less 
than 64 octets long (excluding framing bits, but 
including FCS octets) and were otherwise well 
formed. */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t ether_stats_undersize_pkts_high;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - The total number of packets received that were less 
than 64 octets long (excluding framing bits, but 
including FCS octets) and were otherwise well 
formed. */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t ether_stats_undersize_pkts_low;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - The total number of packets received that were longer 
than MTU octets (excluding framing bits, but includ
ing FCS octets) but were otherwise well formed. */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t ether_stats_oversize_pkts_high;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - The total number of packets received that were longer 
than MTU octets (excluding framing bits, but includ
ing FCS octets) but were otherwise well formed. */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t ether_stats_oversize_pkts_low;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - The total number of packets received that were less 
than 64 octets in length (excluding framing bits but 
including FCS octets) and had either a bad FCS with 
an integral number of octets (FCS error) or a bad FCS 
with a non-integral number of octets (alignment 
error). */
	/* 0x40.0 - 0x44.31 */
	 u_int32_t ether_stats_fragments_high;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - The total number of packets received that were less 
than 64 octets in length (excluding framing bits but 
including FCS octets) and had either a bad FCS with 
an integral number of octets (FCS error) or a bad FCS 
with a non-integral number of octets (alignment 
error). */
	/* 0x44.0 - 0x48.31 */
	 u_int32_t ether_stats_fragments_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - The total number of packets received that were longer 
than MTU octets (excluding framing bits, but includ
ing FCS octets), and had either a bad FCS with an 
integral number of octets (FCS error) or a bad FCS 
with a non-integral number of octets (alignment 
error). */
	/* 0x48.0 - 0x4c.31 */
	 u_int32_t ether_stats_jabbers_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - The total number of packets received that were longer 
than MTU octets (excluding framing bits, but includ
ing FCS octets), and had either a bad FCS with an 
integral number of octets (FCS error) or a bad FCS 
with a non-integral number of octets (alignment 
error). */
	/* 0x4c.0 - 0x50.31 */
	 u_int32_t ether_stats_jabbers_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - The best estimate of the total number of collisions on 
this Ethernet segment. */
	/* 0x50.0 - 0x54.31 */
	 u_int32_t ether_stats_collisions_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - The best estimate of the total number of collisions on 
this Ethernet segment. */
	/* 0x54.0 - 0x58.31 */
	 u_int32_t ether_stats_collisions_low;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were 64 octets in length (excluding 
framing bits but including FCS octets). */
	/* 0x58.0 - 0x5c.31 */
	 u_int32_t ether_stats_pkts64octets_high;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were 64 octets in length (excluding 
framing bits but including FCS octets). */
	/* 0x5c.0 - 0x60.31 */
	 u_int32_t ether_stats_pkts64octets_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 65 and 127 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x60.0 - 0x64.31 */
	 u_int32_t ether_stats_pkts65to127octets_high;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 65 and 127 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x64.0 - 0x68.31 */
	 u_int32_t ether_stats_pkts65to127octets_low;
/*---------------- DWORD[26] (Offset 0x68) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 128 and 255 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x68.0 - 0x6c.31 */
	 u_int32_t ether_stats_pkts128to255octets_high;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 128 and 255 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x6c.0 - 0x70.31 */
	 u_int32_t ether_stats_pkts128to255octets_low;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 256 and 511 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x70.0 - 0x74.31 */
	 u_int32_t ether_stats_pkts256to511octets_high;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 256 and 511 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x74.0 - 0x78.31 */
	 u_int32_t ether_stats_pkts256to511octets_low;
/*---------------- DWORD[30] (Offset 0x78) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 512 and 1023 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x78.0 - 0x7c.31 */
	 u_int32_t ether_stats_pkts512to1023octets_high;
/*---------------- DWORD[31] (Offset 0x7c) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 512 and 1023 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x7c.0 - 0x80.31 */
	 u_int32_t ether_stats_pkts512to1023octets_low;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1024 and 1518 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x80.0 - 0x84.31 */
	 u_int32_t ether_stats_pkts1024to1518octets_high;
/*---------------- DWORD[33] (Offset 0x84) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1024 and 1518 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x84.0 - 0x88.31 */
	 u_int32_t ether_stats_pkts1024to1518octets_low;
/*---------------- DWORD[34] (Offset 0x88) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x88.0 - 0x8c.31 */
	 u_int32_t ether_stats_pkts1519to2047octets_high;
/*---------------- DWORD[35] (Offset 0x8c) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x8c.0 - 0x90.31 */
	 u_int32_t ether_stats_pkts1519to2047octets_low;
/*---------------- DWORD[36] (Offset 0x90) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x90.0 - 0x94.31 */
	 u_int32_t ether_stats_pkts2048to4095octets_high;
/*---------------- DWORD[37] (Offset 0x94) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x94.0 - 0x98.31 */
	 u_int32_t ether_stats_pkts2048to4095octets_low;
/*---------------- DWORD[38] (Offset 0x98) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x98.0 - 0x9c.31 */
	 u_int32_t ether_stats_pkts4096to8191octets_high;
/*---------------- DWORD[39] (Offset 0x9c) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0x9c.0 - 0xa0.31 */
	 u_int32_t ether_stats_pkts4096to8191octets_low;
/*---------------- DWORD[40] (Offset 0xa0) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0xa0.0 - 0xa4.31 */
	 u_int32_t ether_stats_pkts8192to10239octets_high;
/*---------------- DWORD[41] (Offset 0xa4) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 0xa4.0 - 0xa8.31 */
	 u_int32_t ether_stats_pkts8192to10239octets_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_2863_cntrs_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The total number of octets received, including framing charac
ters. Including MAC control frames. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t if_in_octets_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The total number of octets received, including framing charac
ters. Including MAC control frames. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t if_in_octets_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The number of packets successfully received, which were not 
addressed to a multicast or broadcast MAC address. */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t if_in_ucast_pkts_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The number of packets successfully received, which were not 
addressed to a multicast or broadcast MAC address. */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t if_in_ucast_pkts_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The number of inbound packets which were chosen to be dis
carded even though no errors had been detected to prevent 
their being deliverable to a higher-layer protocol. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t if_in_discards_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - The number of inbound packets which were chosen to be dis
carded even though no errors had been detected to prevent 
their being deliverable to a higher-layer protocol. */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t if_in_discards_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - The number of inbound packets that contained errors prevent
ing them from being deliverable to a higher-layer protocol. */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t if_in_errors_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - The number of inbound packets that contained errors prevent
ing them from being deliverable to a higher-layer protocol. */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t if_in_errors_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - The number of packets received via the interface which were 
discarded because of an unknown or unsupported protocol. */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t if_in_unknown_protos_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - The number of packets received via the interface which were 
discarded because of an unknown or unsupported protocol. */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t if_in_unknown_protos_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - The total number of octets transmitted out of the interface, 
including framing characters. */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t if_out_octets_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - The total number of octets transmitted out of the interface, 
including framing characters. */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t if_out_octets_low;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - The total number of packets that higher-level protocols 
requested be transmitted and were not addressed to a multicast 
or broadcast MAC address, including those that were discarded 
or not sent. */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t if_out_ucast_pkts_high;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - The total number of packets that higher-level protocols 
requested be transmitted and were not addressed to a multicast 
or broadcast MAC address, including those that were discarded 
or not sent. */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t if_out_ucast_pkts_low;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - The number of outbound packets which were chosen to be dis
carded, even though no errors had been detected to prevent 
their being transmitted. */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t if_out_discards_high;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - The number of outbound packets which were chosen to be dis
carded, even though no errors had been detected to prevent 
their being transmitted. */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t if_out_discards_low;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - The number of outbound packets that could not be transmitted 
because of errors. */
	/* 0x40.0 - 0x44.31 */
	 u_int32_t if_out_errors_high;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - The number of outbound packets that could not be transmitted 
because of errors. */
	/* 0x44.0 - 0x48.31 */
	 u_int32_t if_out_errors_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - The number of packets successfully received, which were 
addressed to a multicast MAC address. */
	/* 0x48.0 - 0x4c.31 */
	 u_int32_t if_in_multicast_pkts_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - The number of packets successfully received, which were 
addressed to a multicast MAC address. */
	/* 0x4c.0 - 0x50.31 */
	 u_int32_t if_in_multicast_pkts_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - The number of packets successfully received, which were 
addressed to a broadcast MAC address. */
	/* 0x50.0 - 0x54.31 */
	 u_int32_t if_in_broadcast_pkts_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - The number of packets successfully received, which were 
addressed to a broadcast MAC address. */
	/* 0x54.0 - 0x58.31 */
	 u_int32_t if_in_broadcast_pkts_low;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - The total number of packets that higher-level protocols 
requested be transmitted, and which were addressed to a multi
cast MAC address, including those that were discarded or not 
sent. */
	/* 0x58.0 - 0x5c.31 */
	 u_int32_t if_out_multicast_pkts_high;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - The total number of packets that higher-level protocols 
requested be transmitted, and which were addressed to a multi
cast MAC address, including those that were discarded or not 
sent. */
	/* 0x5c.0 - 0x60.31 */
	 u_int32_t if_out_multicast_pkts_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - The total number of packets that higher-level protocols 
requested be transmitted, and which were addressed to a broad
cast MAC address, including those that were discarded or not 
sent. */
	/* 0x60.0 - 0x64.31 */
	 u_int32_t if_out_broadcast_pkts_high;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description - The total number of packets that higher-level protocols 
requested be transmitted, and which were addressed to a broad
cast MAC address, including those that were discarded or not 
sent. */
	/* 0x64.0 - 0x68.31 */
	 u_int32_t if_out_broadcast_pkts_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_802_3_cntrs_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - A count of frames that are successfully transmitted. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t a_frames_transmitted_ok_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - A count of frames that are successfully transmitted. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t a_frames_transmitted_ok_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - A count of frames that are successfully received. This 
does not include frames received with frame-too-long, 
frame check sequence (FCS), length or alignment errors, 
or frames lost due to other MAC errors. */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t a_frames_received_ok_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - A count of frames that are successfully received. This 
does not include frames received with frame-too-long, 
frame check sequence (FCS), length or alignment errors, 
or frames lost due to other MAC errors. */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t a_frames_received_ok_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - A count of receive frames that are an integral number of 
octets in length and do not pass the FCS check. This 
does not include frames received with frame-too-long, or 
frame-too-short (frame fragment) errors. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t a_frame_check_sequence_errors_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - A count of receive frames that are an integral number of 
octets in length and do not pass the FCS check. This 
does not include frames received with frame-too-long, or 
frame-too-short (frame fragment) errors. */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t a_frame_check_sequence_errors_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - A count of frames that are not an integral number of 
octets in length and do not pass the FCS check. */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t a_alignment_errors_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - A count of frames that are not an integral number of 
octets in length and do not pass the FCS check. */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t a_alignment_errors_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - A count of data and padding octets of frames that are 
successfully transmitted. */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t a_octets_transmitted_ok_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - A count of data and padding octets of frames that are 
successfully transmitted. */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t a_octets_transmitted_ok_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - A count of data and padding octets in frames that are 
successfully received. This does not include octets in 
frames received with frame-too-long, FCS, length or 
alignment errors, or frames lost due to other MAC 
errors. */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t a_octets_received_ok_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - A count of data and padding octets in frames that are 
successfully received. This does not include octets in 
frames received with frame-too-long, FCS, length or 
alignment errors, or frames lost due to other MAC 
errors. */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t a_octets_received_ok_low;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - A count of frames that are successfully transmitted to a 
group destination address other than broadcast. */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t a_multicast_frames_xmitted_ok_high;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - A count of frames that are successfully transmitted to a 
group destination address other than broadcast. */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t a_multicast_frames_xmitted_ok_low;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - A count of the frames that were successfully transmitted 
to the broadcast address. Frames transmitted to multicast 
addresses are not broadcast frames and are excluded. */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t a_broadcast_frames_xmitted_ok_high;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - A count of the frames that were successfully transmitted 
to the broadcast address. Frames transmitted to multicast 
addresses are not broadcast frames and are excluded. */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t a_broadcast_frames_xmitted_ok_low;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - A count of frames that are successfully received and 
directed to an active nonbroadcast group address. This 
does not include frames received with frame-too-long, 
FCS, length or alignment errors, or frames lost due to 
internal MAC sublayer error. */
	/* 0x40.0 - 0x44.31 */
	 u_int32_t a_multicast_frames_received_ok_high;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - A count of frames that are successfully received and 
directed to an active nonbroadcast group address. This 
does not include frames received with frame-too-long, 
FCS, length or alignment errors, or frames lost due to 
internal MAC sublayer error. */
	/* 0x44.0 - 0x48.31 */
	 u_int32_t a_multicast_frames_received_ok_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - A count of the frames that were successfully transmitted 
to the broadcast address. Frames transmitted to multicast 
addresses are not broadcast frames and are excluded. */
	/* 0x48.0 - 0x4c.31 */
	 u_int32_t a_broadcast_frames_recieved_ok_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - A count of the frames that were successfully transmitted 
to the broadcast address. Frames transmitted to multicast 
addresses are not broadcast frames and are excluded. */
	/* 0x4c.0 - 0x50.31 */
	 u_int32_t a_broadcast_frames_recieved_ok_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - A count of frames with a length/type field value between 
the minimum unpadded MAC client data size and the 
maximum allowed MAC client data size, inclusive, that 
does not match the number of MAC client data octets 
received. The counter also increments for frames whose 
length/type field value is less than the minimum allowed 
unpadded MAC client data size and the number of MAC 
client data octets received is greater than the minimum 
unpadded MAC client data size. */
	/* 0x50.0 - 0x54.31 */
	 u_int32_t a_in_range_length_errors_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - A count of frames with a length/type field value between 
the minimum unpadded MAC client data size and the 
maximum allowed MAC client data size, inclusive, that 
does not match the number of MAC client data octets 
received. The counter also increments for frames whose 
length/type field value is less than the minimum allowed 
unpadded MAC client data size and the number of MAC 
client data octets received is greater than the minimum 
unpadded MAC client data size. */
	/* 0x54.0 - 0x58.31 */
	 u_int32_t a_in_range_length_errors_low;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - A count of frames with a length field value greater than 
the maximum allowed LLC data size. */
	/* 0x58.0 - 0x5c.31 */
	 u_int32_t a_out_of_range_length_field_high;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - A count of frames with a length field value greater than 
the maximum allowed LLC data size. */
	/* 0x5c.0 - 0x60.31 */
	 u_int32_t a_out_of_range_length_field_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - A count of frames received that exceed the maximum 
permitted frame size by IEEE 802.3 (
MTU size). */
	/* 0x60.0 - 0x64.31 */
	 u_int32_t a_frame_too_long_errors_high;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description - A count of frames received that exceed the maximum 
permitted frame size by IEEE 802.3 (
MTU size). */
	/* 0x64.0 - 0x68.31 */
	 u_int32_t a_frame_too_long_errors_low;
/*---------------- DWORD[26] (Offset 0x68) ----------------*/
	/* Description - For full duplex operation at 1000 Mb/s, it is a count of 
the number of times the receiving media is non-idle (a 
carrier event) for a period of time equal to or greater than 
minFrameSize, and during which there was at least one 
occurrence of an event that causes the PHY to indicate 
"Data reception error". */
	/* 0x68.0 - 0x6c.31 */
	 u_int32_t a_symbol_error_during_carrier_high;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description - For full duplex operation at 1000 Mb/s, it is a count of 
the number of times the receiving media is non-idle (a 
carrier event) for a period of time equal to or greater than 
minFrameSize, and during which there was at least one 
occurrence of an event that causes the PHY to indicate 
"Data reception error". */
	/* 0x6c.0 - 0x70.31 */
	 u_int32_t a_symbol_error_during_carrier_low;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description - A count of MAC Control frames passed to the MAC 
sublayer for transmission. */
	/* 0x70.0 - 0x74.31 */
	 u_int32_t a_mac_control_frames_transmitted_high;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description - A count of MAC Control frames passed to the MAC 
sublayer for transmission. */
	/* 0x74.0 - 0x78.31 */
	 u_int32_t a_mac_control_frames_transmitted_low;
/*---------------- DWORD[30] (Offset 0x78) ----------------*/
	/* Description - A count of MAC Control frames passed by the MAC 
sublayer to the MAC Control sublayer. */
	/* 0x78.0 - 0x7c.31 */
	 u_int32_t a_mac_control_frames_received_high;
/*---------------- DWORD[31] (Offset 0x7c) ----------------*/
	/* Description - A count of MAC Control frames passed by the MAC 
sublayer to the MAC Control sublayer. */
	/* 0x7c.0 - 0x80.31 */
	 u_int32_t a_mac_control_frames_received_low;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description - A count of MAC Control frames received that contain an 
opcode that is not supported by the device. */
	/* 0x80.0 - 0x84.31 */
	 u_int32_t a_unsupported_opcodes_received_high;
/*---------------- DWORD[33] (Offset 0x84) ----------------*/
	/* Description - A count of MAC Control frames received that contain an 
opcode that is not supported by the device. */
	/* 0x84.0 - 0x88.31 */
	 u_int32_t a_unsupported_opcodes_received_low;
/*---------------- DWORD[34] (Offset 0x88) ----------------*/
	/* Description - A count of MAC PAUSE frames passed by the MAC 
sublayer to the MAC Control sublayer. */
	/* 0x88.0 - 0x8c.31 */
	 u_int32_t a_pause_mac_ctrl_frames_received_high;
/*---------------- DWORD[35] (Offset 0x8c) ----------------*/
	/* Description - A count of MAC PAUSE frames passed by the MAC 
sublayer to the MAC Control sublayer. */
	/* 0x8c.0 - 0x90.31 */
	 u_int32_t a_pause_mac_ctrl_frames_received_low;
/*---------------- DWORD[36] (Offset 0x90) ----------------*/
	/* Description - A count of PAUSE frames passed to the MAC sublayer 
for transmission. */
	/* 0x90.0 - 0x94.31 */
	 u_int32_t a_pause_mac_ctrl_frames_transmitted_high;
/*---------------- DWORD[37] (Offset 0x94) ----------------*/
	/* Description - A count of PAUSE frames passed to the MAC sublayer 
for transmission. */
	/* 0x94.0 - 0x98.31 */
	 u_int32_t a_pause_mac_ctrl_frames_transmitted_low;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_dct_qp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - idle, 1 - pending, 2- armed */
	/* 0x0.0 - 0x0.1 */
	 u_int8_t dc_access_key_violation_count_state;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t dc_access_key_violation_count;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_dcr_qp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t gb_first_psn;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t gb_last_psn;
	/* Description -  */
	/* 0x4.24 - 0x4.24 */
	 u_int8_t is_gb;
	/* Description -  */
	/* 0x4.25 - 0x4.25 */
	 u_int8_t drtl_cause_dcr_cleanup;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t reconnect_ack_psn;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - tells when DCR cleanup turned off the heartbeat of this DCR */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t dcr_heartbeat_clr_timestamp;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_regular_qp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Counter for retries (FW attempts recovery) on DS_EXCEEDS_PI error. this is a WA for and ordering issue seen with recovery DBs getting wrong PI */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t ds_exceeds_pi_retries;
	/* Description - is current requester retransmission first wqe rdma read */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t req_retrans_is_rdma_read;
	/* Description - deth qpn was taken from SW */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t use_deth_sqpn;
	/* Description - automatic path migration state
    APM_STATE_ARMED = 0x0,
    APM_STATE_REARM = 0x1,
    APM_STATE_MIGRATED = 0x3
 */
	/* 0x0.6 - 0x0.7 */
	 u_int8_t pm_state;
	/* Description -  */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t xport_retry_counter;
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t xport_retry_limit;
	/* Description -  */
	/* 0x0.24 - 0x0.27 */
	 u_int8_t rnr_retry_counter;
	/* Description -  */
	/* 0x0.28 - 0x0.31 */
	 u_int8_t rnr_retry_limit;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t sw_uar;
	/* Description - exponential backoff retry log */
	/* 0x4.24 - 0x4.27 */
	 u_int8_t log_rtm;
	/* Description - exponential backoff retry log */
	/* 0x4.28 - 0x4.31 */
	 u_int8_t sw_log_rtm;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 union connectib_regular_qp_sub_type sub_type_fields;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t ib_ft_root_id;
	/* Description -  */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t sw_xport_retry_limit;
};

/* Description -   */
/* Size in bytes - 1 */
struct connectib_schedint_cause {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t clear_all_causes;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t schedint_destroy_qp;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t schedint_qp_flush;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t schedint_apm;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t schedint_duplicate;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t schedint_sl_diff;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t schedint_pp_diff;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_fw_qpc_ib {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t oldest_non_acked_psn;
	/* Description - issi=1 and old user lib, getting user_index=ffffff from sw */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t invalid_user_index;
	/* Description - is max read atomic in reduced state */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t max_read_atomic_reduced;
	/* Description - 0 - none. 1 - basic. 2 - enhanced */
	/* 0x0.26 - 0x0.27 */
	 u_int8_t ulp_stateless_offload_mode;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_fw_qpc_eth {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t tis_num;
	/* Description -  */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t sq_in_lb_block;
	/* Description -  */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t reg_umr;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_hw_msix_context_data0 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t data;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_generic_headers {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.28 - 0x0.31 */
	 u_int8_t dword_select_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t dword_select;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_port {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t port;
	/* Description -  */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t grh;
	/* Description -  */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t bth;
	/* Description -  */
	/* 0x0.14 - 0x0.15 */
	 u_int8_t qp_type;
	/* Description -  */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t sx_sniffer;
	/* Description -  */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t force_lb;
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t func_lb;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t multicast;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_source_gvmi_qp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t source_gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t source_qp;
	/* Description -  */
	/* 0x4.24 - 0x4.24 */
	 u_int8_t source_is_requestor;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_ib_l4 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t dest_qp;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t pkey;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_ib_l3 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -   */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t dgid_127_96;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -   */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t dgid_95_64;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -   */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t dgid_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -   */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t dgid_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_ib_l3_extended {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.19 */
	 u_int32_t flow_label;
	/* Description -  */
	/* 0x0.20 - 0x0.23 */
	 u_int8_t sl;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t traffic_class;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t pkey;
	/* Description -  */
	/* 0x4.28 - 0x4.28 */
	 u_int8_t dceth_complete;
	/* Description -  */
	/* 0x4.29 - 0x4.29 */
	 u_int8_t deth_complete;
	/* Description -  */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t bth_complete;
	/* Description -  */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t ip_version;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t qkey_dc_access_key_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t qkey_dc_access_key_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_ib_l2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t dlid;
	/* Description -  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t grh;
	/* Description -  */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t bth;
	/* Description -  */
	/* 0x0.18 - 0x0.19 */
	 u_int8_t qp_type;
	/* Description -  */
	/* 0x0.20 - 0x0.23 */
	 u_int8_t sl;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t multicast;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.19 */
	 u_int32_t flow_label;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t rwh_ethertype;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_bulk {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -   */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t tag_127_96;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -   */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t tag_95_64;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -   */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t tag_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -   */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t tag_31_0;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_hw_transaction_pdf {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t invert_data_bits;
	/* Description - NO_DESCR */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t swap_data_bits;
	/* Description - NO_DESCR */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t seed;
	/* Description - NO_DESCR */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t swap_crc_bytes;
	/* Description - NO_DESCR */
	/* 0x0.21 - 0x0.21 */
	 u_int8_t swap_crc_bits;
	/* Description - NO_DESCR */
	/* 0x0.22 - 0x0.22 */
	 u_int8_t invert_crc;
	/* Description - NO_DESCR */
	/* 0x0.23 - 0x0.23 */
	 u_int8_t sig_zones_covered;
	/* Description - NO_DESCR */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t sig_type;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_hw_pdf_decoder {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t invert_data_bits;
	/* Description - NO_DESCR */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t swap_data_bits;
	/* Description - NO_DESCR */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t seed;
	/* Description - NO_DESCR */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t swap_crc_bytes;
	/* Description - NO_DESCR */
	/* 0x0.21 - 0x0.21 */
	 u_int8_t swap_crc_bits;
	/* Description - NO_DESCR */
	/* 0x0.22 - 0x0.22 */
	 u_int8_t invert_crc;
	/* Description - NO_DESCR */
	/* 0x0.23 - 0x0.23 */
	 u_int8_t regular;
	/* Description - NO_DESCR */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t sig_type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t dif_app_tag_bit_check_en;
	/* Description - NO_DESCR */
	/* 0x4.16 - 0x4.17 */
	 u_int8_t dif_guard_check_type;
	/* Description - NO_DESCR */
	/* 0x4.18 - 0x4.19 */
	 u_int8_t dif_learn_mode;
	/* Description - NO_DESCR */
	/* 0x4.20 - 0x4.20 */
	 u_int8_t dif_learn_app_tag;
	/* Description - NO_DESCR */
	/* 0x4.21 - 0x4.21 */
	 u_int8_t dif_learn_ref_tag;
	/* Description - NO_DESCR */
	/* 0x4.22 - 0x4.22 */
	 u_int8_t dif_inc_ref_tag;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_serdes_conf_tx_set_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.6 */
	 u_int8_t ob_preemp_pre;
	/* Description -  */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t pre_polarity;
	/* Description -  */
	/* 0x0.8 - 0x0.14 */
	 u_int8_t ob_preemp_post;
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t post_polarity;
	/* Description -  */
	/* 0x0.16 - 0x0.22 */
	 u_int8_t ob_preemp_main;
	/* Description -  */
	/* 0x0.23 - 0x0.23 */
	 u_int8_t main_polarity;
	/* Description -  */
	/* 0x0.24 - 0x0.25 */
	 u_int8_t preemp_mode;
	/* Description -  */
	/* 0x0.26 - 0x0.29 */
	 u_int8_t ob_bias;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_serdes_conf_rx_set_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t slicer_ind_en;
	/* Description -  */
	/* 0x0.8 - 0x0.11 */
	 u_int8_t slicer1_enable;
	/* Description -  */
	/* 0x0.12 - 0x0.15 */
	 u_int8_t slicer2_enable;
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t ffe_tap0;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t ffe_tap1;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t ffe_tap2;
	/* Description -  */
	/* 0x4.8 - 0x4.15 */
	 u_int8_t ffe_tap3;
	/* Description -  */
	/* 0x4.16 - 0x4.23 */
	 u_int8_t ffe_tap4;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_aba_index {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.5 */
	 u_int8_t aba_index0_start;
	/* Description -  */
	/* 0x0.6 - 0x0.11 */
	 u_int8_t aba_index0_end;
	/* Description -  */
	/* 0x0.12 - 0x0.17 */
	 u_int8_t aba_index0;
	/* Description -  */
	/* 0x0.18 - 0x0.23 */
	 u_int8_t aba_index1_start;
	/* Description -  */
	/* 0x0.24 - 0x0.29 */
	 u_int8_t aba_index1_end;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.5 */
	 u_int8_t aba_index1;
	/* Description -  */
	/* 0x4.6 - 0x4.11 */
	 u_int8_t aba_index2_start;
	/* Description -  */
	/* 0x4.12 - 0x4.17 */
	 u_int8_t aba_index2_end;
	/* Description -  */
	/* 0x4.18 - 0x4.23 */
	 u_int8_t aba_index2;
	/* Description -  */
	/* 0x4.24 - 0x4.29 */
	 u_int8_t aba_index3_start;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.5 */
	 u_int8_t aba_index3_end;
	/* Description -  */
	/* 0x8.6 - 0x8.11 */
	 u_int8_t aba_index3;
	/* Description -  */
	/* 0x8.12 - 0x8.17 */
	 u_int8_t aba_index4_start;
	/* Description -  */
	/* 0x8.18 - 0x8.23 */
	 u_int8_t aba_index4_end;
	/* Description -  */
	/* 0x8.24 - 0x8.29 */
	 u_int8_t aba_index4;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.5 */
	 u_int8_t aba_index5_start;
	/* Description -  */
	/* 0xc.6 - 0xc.11 */
	 u_int8_t aba_index5_end;
	/* Description -  */
	/* 0xc.12 - 0xc.17 */
	 u_int8_t aba_index5;
};

/* Description -   */
/* Size in bytes - 16 */
union connectib_cmdif_ctx_special_qp_commands_specific {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_cmdif_ctx_special_qp_commands_rts2rts rts2rts;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_cmdif_ctx_special_qp_commands_other other;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_pmcr_reg {
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_mpein_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - PCIE index number
Reserved when access is from the host */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t pcie_index;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t capability_mask;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Max Link Speed:
Bit 0 - 2.5G (Gen1)
Bit 1 - 5G (Gen2)
Bit 2 - 8G (Gen3)
Bit 4- 16G (Gen4) */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t link_speed_enabled;
	/* Description - Maximum Link Width enabled:
0 - 1x
1 - 2x
2 - 4x
3 - 8x
4 - 16x */
	/* 0x8.16 - 0x8.23 */
	 u_int8_t link_width_enabled;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Current Link Speed:
Bit 0 - 2.5G (Gen1)
Bit 1 - 5G (Gen2)
Bit 2 - 8G (Gen3)
Bit 4- 16G (Gen4) */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t link_speed_active;
	/* Description - Negotiated Link Width, pcie_link_width active:
0 - 1x
1 - 2x
2 - 4x
3 - 8x
4 - 16x */
	/* 0xc.16 - 0xc.23 */
	 u_int8_t link_width_active;
	/* Description - The physical lane position of logical lane0 */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t lane0_physical_position;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Number of Total Virtual Functions (for all PFs) */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t num_of_vfs;
	/* Description - Number of Physical Functions (PFs) */
	/* 0x10.16 - 0x10.31 */
	 u_int16_t num_of_pfs;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Bus Device Function - only for function0 */
	/* 0x14.16 - 0x14.31 */
	 u_int16_t bdf0;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Reversal mode of the link:
0 - straight 
1 - reversal
Note: together with 
lane0_physical_position
 provide the physical 
lane. */
	/* 0x18.0 - 0x18.0 */
	 u_int8_t lane_reversal;
	/* Description - Indicates the specific type of this PCI 
Express Function. Note that 
different Functions in a multi-Function device can generally be of 
different types.
0 - 
PCI Express Endpoint port
5 - Upstream port
6 - Downstream port */
	/* 0x18.12 - 0x18.15 */
	 u_int8_t port_type;
	/* Description - Max payload size in bytes:
0 - 128B
1 - 256B
2 - 512B
3 - 1024B
4 - 2048B
5 - 4096B */
	/* 0x18.24 - 0x18.27 */
	 u_int8_t max_payload_size;
	/* Description - Max read request size in bytes:
0 - 128B
1 - 256B
2 - 512B
3 - 1024B
4 - 2048B
5 - 4096B */
	/* 0x18.28 - 0x18.31 */
	 u_int8_t max_read_request_size;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - [Internal] Indicates the status of the PCIE state machine:
0x00 - Disable TS1
0x01 - Disable Ack
0x02 - Disable Wait
0x10 - RESET
0x20 - Loop Back Master Active
0x21 - Loop Back Master Exit
0x31 - Loop Back Slave Entry
0x32 - Loop Back Slave Align
0x33 - Loop Back Slave EB Threshold
0x34 - Loop Back Slave Active
0x35 - Loop Back Slave Idle
0x36 - Loop Back Slave Exit
0x40 - Detect Quiet
0x41 - Detect Active 1
0x42 - Detect Active 2
0x50 - Polling Active 
0x51 - Polling Compliance Entry 
0x52 - Polling Compliance 
0x53 - Polling Compliance Exit
0x54 - Polling Config
0x60 - Config Width Start
0x61 - Config Width Ack
0x62 - Config Lane Wait
0x63 - Config Lane Ack
0x64 - Config Complete
0x65 - Config Idle
0x70 - L0_UP
0x71:0x7F - L0s 
0x80 - L1 ENTER
0x81 - L1 ACTIVE
0x90 - L1 EXIT
0xA0 - Recover Receiver Lock 
0xA1 - Recover Speed 
0xA2 - Recover Config 
0xA2 - Recover Idle 
0xA5 - Recover ESpeed 
0xA8 - Recover Equalization Phase 0
0xA9 - Recover Equalization Phase 1
0xAA - Recover Equalization Phase 2
0xAB - Recover Equalization Phase 3
0xAC - Recover Equalization Idle
0xB0 - Force TS1
0xC0 - Force TS2
0xD0 - Force IDLE
0xE0 - Force COMP
0xF0 - Force disable */
	/* 0x24.8 - 0x24.15 */
	 u_int8_t port_state;
	/* Description - device_status bit mask:
Bit 0 - Correctable error
Bit 1 - Non-Fatal Error detection 
Bit 2 - Fatal Error detected
Bit 3 - Unsupported request detected
Bit 4 - AUX power 
Bit 5 - Transaction Pending */
	/* 0x24.16 - 0x24.31 */
	 u_int16_t device_status;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - [Internal] receiver detect result bit mask per lane */
	/* 0x28.0 - 0x28.15 */
	 u_int16_t receiver_detect_result;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_mvts {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - A SET operation with this flag set will only check if the new timestamp can be configured without updating NVRAM */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t check_timestamp_flag;
	/* Description - A GET operation with this flag set, will return the running FW version instead */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t running_flag;
	/* Description - A SET operation with this flag on will clear the running and other bank timestamps */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t clear_all_ts_flag;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - fw_version_major */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t fw_ver_major;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - fw version subminor */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t fw_ver_subminor;
	/* Description - fw_version_minor */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t fw_ver_minor;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Timestamp day     - 2 packed BCD */
	/* 0xc.0 - 0xc.7 */
	 u_int8_t ts_day;
	/* Description - Timestamp month   - 2 packed BCD */
	/* 0xc.8 - 0xc.15 */
	 u_int8_t ts_month;
	/* Description - Timestamp year    - 4 packed BCD */
	/* 0xc.16 - 0xc.31 */
	 u_int16_t ts_year;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Timestamp seconds - 2 packed BCD */
	/* 0x10.8 - 0x10.15 */
	 u_int8_t ts_seconds;
	/* Description - Timestamp minotes - 2 packed BCD */
	/* 0x10.16 - 0x10.23 */
	 u_int8_t ts_minutes;
	/* Description - Timestamp hour    - 2 packed BCD */
	/* 0x10.24 - 0x10.31 */
	 u_int8_t ts_hour;
};

/* Description -   */
/* Size in bytes - 36 */
union connectib_pmlp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x24.31 */
	 struct connectib_pmlp_prm_style prm_style;
	/* Description -  */
	/* 0x0.0 - 0x24.31 */
	 struct connectib_pmlp_code_style code_style;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_pplm_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Local port number */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The port"s active Profile ID. 
0xFF - unassigned - set when Media based port profile is set and no 
medium is connected. */
	/* 0x8.8 - 0x8.15 */
	 u_int8_t active_port_profile;
	/* Description - Valid when Media based port profile is cleared, used to set the static port"s 
profile index. */
	/* 0x8.16 - 0x8.23 */
	 u_int8_t static_port_profile;
	/* Description - Port profile modes (bitmask):
Bit 0 - Port type based port profile
When set the profile will be selected according to the connected port type. 
When cleared the port"s profile will be set according to the static_port_pro
file field 
Bit 1 - Legacy / IB spec profile enable (default set)
When set, the IB spec / legacy profile will be applied on the port when con
nected to a peer non-Mellanox or legacy port.
Note, when Legacy / IB spec profile enable bit is cleared, some of the con
figurations may not be supported by the peer port and will be ignored in the 
negotiation.
Bit 2 - Ethernet Enhanced FEC (default cleared)
TBD exact text - 
When auto mode (no override) is set on Mellanox links 
select the FEC based on the profile including Mellanox Phy modes
 
Bits 7:3 - Reserved */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t port_profile_mode;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Active FEC (bitmask)
Bit 0 - No FEC
Bit 1 - Firecode FEC
Bit 2 - Standard RS-FEC - RS(528,514)
Bit 3 - Standard LL RS-FEC - RS(271,257)
[Internal] Bit 4 - Mellanox Strong RS-FEC - RS(277,257)
[Internal] Bit 5 - Mellanox LL RS-FEC - RS(163,155)
[Internal] Bit 6- Correct On Demand (COD) */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t fec_mode_active;
	/* Description - Active Retransmission (bitmask)
Bit 0 - LLR
Bit 1 - PLR */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t retransmission_active;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 10GE/40GE Ethernet FEC override capability bitmask:
Bit 0 - No-FEC
Bit 1- Firecode FEC
Bit 2- Reserved
Bit 3- Reserved */
	/* 0x10.0 - 0x10.3 */
	 u_int8_t fec_override_cap_10g_40g;
	/* Description - 25GE Ethernet FEC override capability bitmask:
Bit 0 - No-FEC
Bit 1- Firecode FEC
Bit 2- RS-FEC
Bit 3- Reserved */
	/* 0x10.4 - 0x10.7 */
	 u_int8_t fec_override_cap_25g;
	/* Description - 50GE Ethernet FEC override capability bitmask:
Bit 0 - No-FEC
Bit 1- Firecode FEC
Bit 2- RS-FEC
Bit 3- Reserved */
	/* 0x10.8 - 0x10.11 */
	 u_int8_t fec_override_cap_50g;
	/* Description - 100GE Ethernet FEC override capability bitmask:
Bit 0 - No-FEC
Bit 1 - Reserved
Bit 2 - RS-FEC(528,514)
Bit 3 - Reserved */
	/* 0x10.12 - 0x10.15 */
	 u_int8_t fec_override_cap_100g;
	/* Description - 56GE Ethernet FEC override capability bitmask:
Bit 0 - No-FEC
Bit 1 - Firecode FEC
Bit 2 - Reserved
Bit 3 - Reserved */
	/* 0x10.16 - 0x10.19 */
	 u_int8_t fec_override_cap_56g;
	/* Description - RS-FEC correction bypass override capability:
0 - NO correction bypass
1 - RS-FEC correction bypass */
	/* 0x10.28 - 0x10.31 */
	 u_int8_t rs_fec_correction_bypass_cap;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - 10GE/40GE Ethernet FEC override admin, see 10g_40g_fec_override_cap.
0 - Auto, no override
1 - No FEC
2 - Firecode FEC */
	/* 0x14.0 - 0x14.3 */
	 u_int8_t fec_override_admin_10g_40g;
	/* Description - 25GE Ethernet FEC override admin, see 25g_fec_override_cap.
0 - Auto, no override
1 - No FEC
2 - Firecode FEC
4 - RS-FEC
Note: 
25g_fec_override_admin
 and 
50g_fec_override_admin
 must be set 
with the same value. */
	/* 0x14.4 - 0x14.7 */
	 u_int8_t fec_override_admin_25g;
	/* Description - 50GE Ethernet FEC override admin, see 50g_fec_override_cap.
0 - Auto, no override
1 - No FEC
2 - Firecode FEC
4 - RS-FEC
Note: 
25g_fec_override_admin
 and 
50g_fec_override_admin
 must be set 
with the same value. */
	/* 0x14.8 - 0x14.11 */
	 u_int8_t fec_override_admin_50g;
	/* Description - 100GE Ethernet FEC override admin, see 100g_fec_override_cap.
0 - Auto, no override
1 - No FEC
4 - RS-FEC */
	/* 0x14.12 - 0x14.15 */
	 u_int8_t fec_override_admin_100g;
	/* Description - 56GE Ethernet FEC override admin, see 56g_fec_override_cap.
0 - Auto, no override
1 - No FEC
2 - Firecode FEC */
	/* 0x14.16 - 0x14.19 */
	 u_int8_t fec_override_admin_56g;
	/* Description - RS-FEC correction bypass override admin:
0 - Auto, no override 
1 - NO correction bypass
2 - RS-FEC correction bypass */
	/* 0x14.28 - 0x14.31 */
	 u_int8_t rs_fec_correction_bypass_admin;
};

/* Description -   */
/* Size in bytes - 40 */
struct connectib_plpc_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Protocol Mask. Indicates which of the protocol data is valid
Bit 0: InfiniBand
Bit 2: Ethernet
Note: setting multiple bits will apply the setting to all the set protocols */
	/* 0x0.8 - 0x0.11 */
	 u_int8_t proto_mask;
	/* Description - Profile ID (bitmask)
Bit 0 - IB spec / legacy (See profiles description)
Bit 1 - Internal ports (Backplane)
Bit 2 - Passive copper - Short
Bit 3 - Passive copper - Medium
Bit 4 - Passive copper - Long
Bit 5 - Active optics / copper short reach (<30m)
Bit 6 - Optics long reach (>30m)
Bit 7 - NO-FEC
Bit 8 - FEC-ON
Bit 9 - User defined 1 (not supported)
Bit 10-11 - Reserved
Note: setting multiple bits will apply the setting to multiple profile ids.
Note: Short, Medium, Long are functions of the cable length and attenua
tion. */
	/* 0x0.16 - 0x0.27 */
	 u_int16_t profile_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Per lane speed (bitmask)
Bit 0 - Reserved
Bit 1 - Reserved
Bit 2 - Reserved
Bit 3 - FDR10 (10GE / 40GE)
Bit 4 - FDR (56GE)
Bit 5 - EDR (25GE / 50GE / 100GE)
Note: setting multiple bits will apply the setting to all the set speeds */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t lane_speed;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - FEC decision policy:
0 - optimize robustness
1 - optimize latency
2 - optimize bandwidth */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t fec_mode_policy;
	/* Description - Link Performance Based FEC
When set, only FEC types that are applicable for the link performance will 
be used. When cleared, the link performance is ignored for the FEC selec
tion and the FEC is selected only according to the policy. If the selected 
FEC is not applicable for the link performance, the speed may be consid
ered as non-operational. */
	/* 0x8.8 - 0x8.8 */
	 u_int8_t lpbf;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - FEC capability (bitmask)
Bit 0 - No FEC
Bit 1 - Firecode FEC
Bit 2 - Standard RS-FEC - RS(528,514)
Bit 3 - Standard LL RS-FEC - RS(271,257)
Bit 4 - Mellanox Strong RS-FEC - RS(277,257)
Bit 5 - Mellanox LL RS-FEC - RS(163,155)
Bit 6 - Correct on Demand (COD) */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t fec_mode_capability;
	/* Description - Retransmission capability (bitmask)
Bit 0 - LLR
Bit 1 - PLR */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t retransmission_capability;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - FEC s
upport admin (bitmask)
Valid only for Mellanox Phy only, when cleared peer ports requests to 
enable the FEC mode will be ignored.
Uses the same encoding as fec_mode_capability.
Writing 0 to the filed keeps the current setting. */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t fec_mode_support_admin;
	/* Description - Retransmission support admin (bitmask)
When cleared peer ports requests to enable the retransmission mode will be 
ignored.
Uses the same encoding as retransmission_capability. */
	/* 0x10.24 - 0x10.31 */
	 u_int8_t retransmission_support_admin;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - FEC request admin (bitmask)
Sets the FEC modes which are administratively enabled.
Uses the same encoding as retransmission_capability.
Writing 0 to the filed keeps the current setting.
The fec_mode_request_admin must be a subset of fec_mode_support_ad
min */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t fec_mode_request_admin;
	/* Description - Retransmission request admin (bitmask)
Sets the retransmission modes which are administratively enabled.
Uses the same encoding as retransmission_capability.
The retransmission_request_admin must be a subset of retransmission_sup
port_admin */
	/* 0x14.24 - 0x14.31 */
	 u_int8_t retransmission_request_admin;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_pplr_reg {
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_project_nvgn {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t nv_pointer;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x1c.31 */
	 struct connectib_nv_tlv_hdr tlv_header;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x2c.31 */
	 struct connectib_register_access_data_reduced tlv_data;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_project_nvia {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - ALL - all NVRAM parameters-0, NVLOG-1 */
	/* 0x0.0 - 0x0.2 */
	 u_int8_t target;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_project_nvgc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NVDA read factory settings, 0=unsupported, 1=supported */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t nvda_read_factory_settings;
	/* Description - NVDA read current settings, 0=unsupported, 1=supported */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t nvda_read_current_settings;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_project_nvqc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Configuration item type */
	/* 0x0.0 - 0x4.31 */
	 union connectib_nv_tlv_type type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t support_rd;
	/* Description -  */
	/* 0x4.1 - 0x4.1 */
	 u_int8_t support_wr;
	/* Description -  */
	/* 0x4.4 - 0x4.7 */
	 u_int8_t version;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_project_nvda {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_nv_tlv_hdr tlv_header;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x2c.31 */
	 struct connectib_register_access_data nvda_data;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_pmtu_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Local port number. */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Maximum MTU supported on the port (Read Only).
MTU depends on the port type. When port type (Eth/IB/FC) is configured, 
the relevant MTU is reported. When the port type is not configured, the 
minimum between the 
max_mtu
 for the different types (Eth/IB/FC) is 
reported. */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t max_mtu;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Administratively configured MTU on the port. Must be smaller or equal to 
max_mtu
. */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t admin_mtu;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Operational MTU. This is the actual MTU configured on the ports. Packets 
exceeding this size will be dropped.
Note: In Ethernet or FC, 
oper_mtu
 is equal to 
admin_mtu
. In InfiniBand, 
the actual operational MTU is reported which may be smaller than 
admin
_mtu
. */
	/* 0xc.16 - 0xc.31 */
	 u_int16_t oper_mtu;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_pamp_reg {
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_ppaos_reg {
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_pprt_reg {
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_pptt_reg {
};

/* Description -   */
/* Size in bytes - 40 */
struct connectib_slrg_reg {
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_ptas_reg {
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_sltp_reg {
};

/* Description -   */
/* Size in bytes - 40 */
struct connectib_slrp_reg {
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_paos_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Port operational state:
1 - up
2 - down
4 - down by port failure (transitioned by the hardware) */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t oper_status;
	/* Description - Port administrative state (the desired state of the interface):
1 - up
2 - down by configuration
3 - up once - if the port goes up and then down, the operational 
status should go to "down by port failure" and can only go back 
up upon explicit command
4 - disabled by system - this mode cannot be set by the software, 
only by the hardware.
[Internal] Default should come from ini. Up for unmanaged sys
tems and Down for managed
[Internal] For InfiniBand ports, this holds the local admin status. 
SM status does not overide this one and should be held in a tem
porary register.
[Internal] if 
ext_down_admin is in test_mode 
admin_status 
must 
remain down. */
	/* 0x0.8 - 0x0.11 */
	 u_int8_t admin_status;
	/* Description - Local port number. */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
	/* Description - For HCA: must always be 0.
Switch partition ID with which to associate the port.
Switch partitions are numbered from 0 to 7 inclusively.
The 
swid
 field is only valid when the 
local_port
 is the router port. 
In this case, the 
swid
 indicates which of the router ports to config
ure/query. */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t swid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Event generation on operational state change:
0
 - Do not generate event
1
 - Generate Event 
2
 - Generate Single Event
Not Supported for HCA. */
	/* 0x4.0 - 0x4.1 */
	 u_int8_t e;
	/* Description - Event update enable. If this bit is set, event generation will be 
updated based on the 
e
 field. Only relevant on Set operations.
Not Supported for HCA. */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t ee;
	/* Description - Admin state update enable. If this bit is set, admin state will be 
updated based on 
admin_state
 field. Only relevant on Set() opera
tions. */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t ase;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_mjtag {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Size of operation - relevant for JTAG interface access com
mands only, indicating the number of transaction bytes to exe
cute. Maximum size supported is 40.
Note:
 when size=0, no operation is performed (clock is not tog
gled). The 
tdo
 is sampled and provided in the response at 
jtag_transaction_set_0
. */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t size;
	/* Description - Command sequence number - to prevent re-execution of the 
same command due to command retransmission, this command 
includes a sequence number.
The enable and disable commands MUST be issues with 
sequence_number
 = 0 while any JTAG access command must 
increase the 
sequence_number
 by 1 (the first JTAG access com
mand should start at 
sequence_number
 = 1). */
	/* 0x0.24 - 0x0.27 */
	 u_int8_t sequence_number;
	/* Description - Command
0 - JTAG interface disable - JTAG interface is disabled
1 - JTAG interface enable - enabling JTAG interface
2 - JTAG interface access */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t cmd;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Transactions */
	/* 0x4.0 - 0x2c.31 */
	 u_int32_t dword[10];
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_mqis_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Type of information string to be queried:
0x0: VPD
0x1: MODEL_NAME
0x2: MODEL_DESCRIPTION
other values are reserved. */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t info_type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Total size of the information string, according to 
info_type
. 
Value given in bytes. */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t info_length;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Number of bytes requested. The device returns the number 
of bytes actually read. */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t read_length;
	/* Description - Offset in bytes of the first byte requested to read. */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t read_offset;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Information string accessed, according to 
info_type
. If the 
information is not available, a NULL string is returned. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t info_string[1];
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_mcda_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Update handle registered when the FSM was activated. */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t update_handle;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Offset of accessed address relative to component start. 
Accesses must be in accordance to 
log_mcda_word_size
 in 
Table 671, "
MCQI CAPABILITIES Info Layout
," on 
page 758 */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t offset;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Size of the data accessed, given in bytes */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t size;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Data block accessed */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t data[1];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_mcc_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Command to be executed by the FSM
0x1: LOCK_UPDATE_HANDLE
0x2: RELEASE_UPDATE_HANDLE 
0x3: UPDATE_COMPONENT
0x4: VERIFY_COMPONENT
0x5: ACTIVATE_COMPONENET 
0x6: ACTIVATE
0x7: READ_COMPONENT
0x8: CANCEL
0x9: CHECK_UPDATE_HANDLE
0xA: FORCE_HANDLE_RELEASE
0xB: READ_PENDING_COMPONENT
Other values are reserved. Applicable for write operation 
only. */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t instruction;
	/* Description - The number of seconds elapsed since the update_handle 
owner last issued a command. The time saturates at 0xFFF. */
	/* 0x0.16 - 0x0.27 */
	 u_int16_t time_elapsed_since_last_cmd;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Index of the accessed component. Valid for 
UPDATE_COMPONENT, ACTIVATE_COMPONENET, 
READ_COMPONENT and READ_PENDING_COMPO
NENT instructions. Otherwise, this field is reserved. */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t component_index;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Token representing the current flow executed by the FSM.
See 
"Update Handle" on page 429 */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t update_handle;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Current Update FSM state, See 
"FSM States" on page 
431
 
0x0: IDLE
0x1: LOCKED
0x2: INITIALIZE
0x3: DOWNLOAD
0x4: VERIFY
0x5: APPLY
0x6: ACTIVATE
0x7: UPLOAD
0x8: UPLOAD_PENDING
Other values are reserved */
	/* 0xc.0 - 0xc.3 */
	 u_int8_t control_state;
	/* Description - Indicates the successful completion of the 
instruction
, or 
the reason it failed. See 
"Error Handling" on page 431
0x0: OK
0x1: ERROR
0x2: REJECTED_DIGEST_ERR
0x3: REJECTED_NOT_APPLICABLE
0x4: REJECTED_UNKNOWN_KEY
0x5: REJECTED_AUTH_FAILED
0x6: REJECTED_UNSIGNED
0x7: REJECTED_KEY_NOT_APPLICABLE
0x8: REJECTED_BAD_FORMAT
0x9: BLOCKED_PENDING_RESET
Other values should be treated as an unknown error. */
	/* 0xc.8 - 0xc.15 */
	 u_int8_t error_code;
	/* Description - Indicates the estimated progress status of the current opera
tion executed by the FSM. Valid values are 0..100.
101 indicates that progress reporting is not supported for 
this update state. */
	/* 0xc.16 - 0xc.22 */
	 u_int8_t control_progress;
	/* Description - For 
handle_owner_type
 BMC, command-interface and 
ICMD, indicates the identifier of the host of the handle 
owner.
Otherwise reserved */
	/* 0xc.24 - 0xc.27 */
	 u_int8_t handle_owner_host_id;
	/* Description - Type of entity holding the update handle:
0x0: unspecified
0x1: Chassis BMC
0x2: MAD
0x3: BMC
0x4: command interface
0x5: ICMD 
Other values are reserved. */
	/* 0xc.28 - 0xc.31 */
	 u_int8_t handle_owner_type;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Component size in bytes. 
Valid for UPDATE_COMPONENT instruction. Specifying 
the size may shorten the update time.
Value 0x0 means that size is unspecified. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t component_size;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_mcqi_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Component index gathered by 
"MCQS - Management 
Component Query Status" */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t component_index;
	/* Description - When set, the register will return information about the 
pending component (if available) */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t read_pending_component;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Component properties set.
0x0: CAPABILITIES
0x1: VERSION
0x5: ACTIVATION_METHOD
Other values are reserved */
	/* 0x8.0 - 0x8.4 */
	 u_int8_t info_type;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Properties set structure size, given in bytes. */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t info_size;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The requested/returned data offset from the section start, 
given in bytes.
Must be DWORD aligned. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t offset;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - The requested/returned data size, given in bytes. 
If 
data_size
 is not DWORD aligned, the last bytes are zero 
padded. */
	/* 0x14.0 - 0x14.15 */
	 u_int16_t data_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Properties set structure according to 
info_type
.
CAPABILITIES - See 
Table 671, "
MCQI CAPABILITIES 
Info Layout
," on page 758
VERSION - See 
Table 673, "
MCQI VERSION Info Lay
out
," on page 760
ACTIVATION_METHOD - See 
Table 677, "
MCQI ACTI
VATION_METHOD Info Layout
," on page 761 */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t data[1];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_mcqs_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Component Index. Values range from 1 to the last compo
nent indicated by 
last_index_flag
. */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t component_index;
	/* Description - When set, this component is the last component (highest 
component_index
). */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t last_index_flag;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - This field uniquely identifies a specific component type. 
0x1: BOOT_IMG_CX4
0x2: RUNTIME_IMG_CX4
0x3: USER_NVCONFIG
0x4: OEM_NVCONFIG
0x5: MLNX_NVCONFIG
0x6: CS_TOKEN
0x7: DBG_TOKEN
0x8: DEV_INFO
0x9: PACKAGE_INFO
Other values are reserved */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t identifier;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Component statue in update flow, see 
"Component update 
state" on page 428
: 
0x0: IDLE
0x1: IN_PROGRESS
0x2: APPLIED
0x3: ACTIVE 
0x4: ACTIVE_PENDING_RESET
0x5: FAILED
0x6: CANCELED
0x7: BUSY
Other values are reserved */
	/* 0x8.0 - 0x8.3 */
	 u_int8_t component_update_state;
	/* Description - The status of the component:
0x0: NOT_PRESENT - The component is supported by the 
device but, currently not present
0x1: PRESENT - This component is present.
0x2: IN_USE - The component is present and currently in 
use.
Other values are reserved */
	/* 0x8.4 - 0x8.8 */
	 u_int8_t component_status;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - For 
last_update_state_changer_type
 BMC, command-
interface and ICMD, indicates the identifier of the host of 
the handle owner. Otherwise reserved. */
	/* 0xc.24 - 0xc.27 */
	 u_int8_t last_update_state_changer_host_id;
	/* Description - Indicates which entity was the last to change the 
compo
nent_update_state
 of this component.
0x0: unspecified
0x1: Chassis BMC
0x2: MAD
0x3: BMC
0x4: command interface
0x5: ICMD
Other values are reserved */
	/* 0xc.28 - 0xc.31 */
	 u_int8_t last_update_state_changer_type;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_mfbe {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Flash Select */
	/* 0x0.4 - 0x0.5 */
	 u_int8_t fs;
	/* Description - Parallel */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t p;
	/* Description - erase a 64KB bulk */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t bulk_64kb_erase;
	/* Description - erase a 32KB bulk */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t bulk_32kb_erase;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - address in bytes */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t address;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_project_mfba {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_mfba_header mfba_header;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x2c.31 */
	 struct connectib_register_access_data mfba_data;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_register_misc_counters {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - When performing a WRITE operation - , the counter select bitmask deter
mines which registers are set:
Bit 0 - ECC
Bit 1 - LDB silent drop */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t counter_select;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Counts number of arrays which encountered a bit error */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t ecc;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Counts number of packets silently dropped due to LDB error */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t ldb_silent_drop;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_mtmp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Sensors index to access */
	/* 0x0.0 - 0x0.6 */
	 u_int8_t sensor_index;
	/* Description - query the internal diodes */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t internal_diodes_query;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Temperature reading from the sensor. Reading in 0.125 Celsius degrees. */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t temperature;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The highest measured temperature from the sensor. */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t max_temperture;
	/* Description - Max Temperature Reset - clears the value of the max temperature register */
	/* 0x8.30 - 0x8.30 */
	 u_int8_t mtr;
	/* Description - Max Temperature Enable - enables measuring the max temperature on a sensor */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t mte;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - If the sensor temperature measurement is above the threshold (and events are enabled), an event
will be generated */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t temperature_threshold_hi;
	/* Description - Temperature Event Enable
00 - Do not generate event
01 - Generate Event
10 - Generate single event */
	/* 0xc.30 - 0xc.31 */
	 u_int8_t tee;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t temperature_threshold_lo;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t name_hi;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t name_lo;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_register_mfrl {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - on Read, required reset level. On write, minimum requested reset level
 0-Full ISFU
 1-Driver down but link is up
 2-driver and link down
 3-driver down, link down pci disable/enable
 7-server warm reboot
 8-server cold reboot */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t reset_level;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_register_mfai {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t address;
	/* Description - if set make image permamnent */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t permanent;
	/* Description - if set use address */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t use_address;
	/* Description - if set use image id and not address */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t use_image_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t image_id;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_mfpa {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Flash Select */
	/* 0x0.4 - 0x0.5 */
	 u_int8_t fs;
	/* Description - Parallel */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t p;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - address in bytes */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t boot_address;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - number of flash devices connected */
	/* 0x10.0 - 0x10.3 */
	 u_int8_t flash_num;
	/* Description - If set, MFMC register supports setting write protect with sub-sector blocks
Sub-sector block size is available in MFMC.sub_sector_protect_size */
	/* 0x10.16 - 0x10.16 */
	 u_int8_t sub_sector_wrp_en;
	/* Description - If set, MFMC register supports setting write protect with sector blocks
Sector block size is available in MFMC.sector_protect_size */
	/* 0x10.17 - 0x10.17 */
	 u_int8_t sector_wrp_en;
	/* Description - supports 64KB bulk erase operation */
	/* 0x10.29 - 0x10.29 */
	 u_int8_t bulk_64kb_erase_en;
	/* Description - supports 32KB bulk erase operation */
	/* 0x10.30 - 0x10.30 */
	 u_int8_t bulk_32kb_erase_en;
	/* Description - reflection of wip bit from flash */
	/* 0x10.31 - 0x10.31 */
	 u_int8_t wip;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Flash JEDEC ID */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t jedec_id;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Flash sectore size */
	/* 0x18.0 - 0x18.9 */
	 u_int16_t sector_size;
	/* Description -  */
	/* 0x18.16 - 0x18.23 */
	 u_int8_t block_allignment;
	/* Description -  */
	/* 0x18.24 - 0x18.31 */
	 u_int8_t block_size;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Bitmask indicates which capabilities are supported.
Bit 15-0: reserved
Bit 16: Set write protect supported (register MFMC supports setting write protection)
Bit 17: quad enable read write is supported (register MFMC supports setting quad enable)
Bit 18: set dummy cycle supported (register MFMC supports setting dummy cycles) */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t capability_mask;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_fpga_shell_caps {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Total size of shared QP buffer size in granularity of 2 KB. */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t total_rcv_credits;
	/* Description - Maximum number of supported QPs. */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t max_num_qps;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - If set, RC transport service is supported. */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t rc;
	/* Description - If set, UC transport service is supported. */
	/* 0x4.1 - 0x4.1 */
	 u_int8_t uc;
	/* Description - If set, UD transport service is supported. */
	/* 0x4.2 - 0x4.2 */
	 u_int8_t ud;
	/* Description - If set, DC transport service is supported. */
	/* 0x4.3 - 0x4.3 */
	 u_int8_t dc;
	/* Description - If set, RDMA READ operation is supported. */
	/* 0x4.8 - 0x4.8 */
	 u_int8_t rre;
	/* Description - If set, RDMA WRITE operation is supported. */
	/* 0x4.9 - 0x4.9 */
	 u_int8_t rwe;
	/* Description - If set, RDMA atomic operation is supported. */
	/* 0x4.10 - 0x4.10 */
	 u_int8_t rae;
	/* Description - Bit mask indicates which QP types are supported
Bit 0: Shell_qp - Shell QP supported
Bit 1: Sandbox_qp - Sandbox QP supported */
	/* 0x4.16 - 0x4.17 */
	 u_int8_t qp_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Log (base 2) of the DDR size in granularity of GB. */
	/* 0x8.0 - 0x8.5 */
	 u_int8_t log_ddr_size;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The maximum size of message size supported by FPGA Shell QP. */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t max_fpga_qp_msg_size;
};

/* Description -   */
/* Size in bytes - 12 */
union connectib_pmmp_sfp_protocol_override_layout_auto {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_pmmp_sfp_protocol_override_layout pmmp_sfp_protocol_override_layout;
};

/* Description -   */
/* Size in bytes - 12 */
union connectib_pmmp_qsfp_protocol_override_layout_auto {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_pmmp_qsfp_protocol_override_layout pmmp_qsfp_protocol_override_layout;
};

/* Description -   */
/* Size in bytes - 248 */
union connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0xc8.31 */
	 struct connectib_pcie_perf_counters pcie_perf_counters;
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_pcie_lanes_counters pcie_lanes_counters;
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_pcie_timers_states pcie_timers_states;
};

/* Description -   */
/* Size in bytes - 248 */
union connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_eth_802_3_cntrs_grp_data_layout eth_802_3_cntrs_grp_data_layout;
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_eth_2863_cntrs_grp_data_layout eth_2863_cntrs_grp_data_layout;
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_eth_2819_cntrs_grp_data_layout eth_2819_cntrs_grp_data_layout;
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_eth_3635_cntrs_grp_data_layout eth_3635_cntrs_grp_data_layout;
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_eth_extended_cntrs_grp_data_layout eth_extended_cntrs_grp_data_layout;
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_eth_per_prio_grp_data_layout eth_per_prio_grp_data_layout;
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_eth_per_traffic_grp_data_layout eth_per_traffic_grp_data_layout;
	/* Description -  */
	/* 0x0.0 - 0x38.31 */
	 struct connectib_correct_on_demand_layout correct_on_demand;
	/* Description -  */
	/* 0x0.0 - 0xc8.31 */
	 struct connectib_phys_layer_cntrs phys_layer_cntrs;
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_discard_cntrs_grp_data discard;
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_llr_counters llr_counters;
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_ib_port_counters ib_port_counters;
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_eth_per_traffic_congestion_grp_data_layout eth_per_traffic_congestion_grp_data_layout;
	/* Description -  */
	/* 0x0.0 - 0xf8.31 */
	 struct connectib_phys_layer_stat_cntrs phys_layer_stat_cntrs;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_access_register_unit_perf_counters_data_line {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t value;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_access_register_unit_perf_counters_cfg_line {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Counter selector configuration.
If set to 0 on even-numbered selectors, extends the consecutively (odd-numbered) counter to 64 bits.
If set to 0 on odd-numbered selectors, count core clock cycles. */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t select;
	/* Description - 0 = SKIP: do not modify this counter selector
1 = SET: set this counter selector, and reset the counter */
	/* 0x0.12 - 0x0.15 */
	 u_int8_t cmd;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_node_description {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 u_int32_t d[16];
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_application_prio_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - According to 802.1Q application priority TLV */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t protocol_id;
	/* Description - According to 802.1Q application priority TLV */
	/* 0x0.16 - 0x0.18 */
	 u_int8_t sel;
	/* Description - This field is reserved when HCA_CAP.num_ports ==1. 
 See Table 739, 
"
QUERY_HCA_CAP Input Structure Layout
," on page 801
. 
According to 
802.1Q application priority TLV */
	/* 0x0.21 - 0x0.23 */
	 u_int8_t priority;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_tc_qos_configuration {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The percentage of bandwidth guaranteed to TClass within its TClass Group */
	/* 0x0.0 - 0x0.6 */
	 u_int8_t bw_allocation;
	/* Description - TClass Group assigned to a TClass. */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t group;
	/* Description - Rate limit update. Enables update of the rate limiter (with the max_bw_units, max_bw_value) */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t r;
	/* Description - Bandwidth allocation update. Enables update of the ETS bandwidth allocation (with the bw_allocation). */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t b;
	/* Description - Group update. Enables update of the group assigned to the TClass. */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t g;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The maximal bandwidth allowed for the use TClass */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t max_bw_value;
	/* Description - 0 - rate limiter disbled, 0b0011 - 100 Mbps, 0b0100 - 1 Gbps  */
	/* 0x4.16 - 0x4.19 */
	 u_int8_t max_bw_units;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_fw_ref_count {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.27 */
	 u_int32_t ref_counter;
	/* Description - NOT_VALID = 0x0
MISC = 0x1
QP = 0x2
SQ = 0x3
MEMORY_RQ = 0x4
SRQ = 0x5
XRC_SRQ = 0x6
RMP = 0x7
TIR = 0x8
TIS = 0x9
DCT = 0xa
NO_LRO_QP = 0xb */
	/* 0x0.28 - 0x0.31 */
	 u_int8_t ref_valid_cre_type;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_mac_address_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Upper bits of mac address. */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t mac_addr_47_32;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Lower bits of mac address. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t mac_addr_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_tir_dmfs {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - resource index of the STE of TIR context */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t tir_ste_ix;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - resource index of the hash filter */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t hash_filter_base_ix;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - resource index of the hash entries */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t hash_entries_base_ix;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_rx_hash_field_select {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Bitmask which sets which packets headers fields should be 
selected for RX Hash.
Each bit represents a field as described below
0: SRC_IP
1: DST_IP
2: L4_SPORT
3: L4_DPORT
4: IPSEC_SPI
5-29: reserved
Only packets which contain the enabled fields can be delivered 
to that TIR, this must be done with proper Flow Table rules.
For example if L4_SPORT is enabled and l4_protocol_type == 
TCP only TCP packets are allowed to reach this TIR.
Note that if this field refers to tunneling packets only tunneling 
packets with proper inner headers are allowed to reach this TIR. */
	/* 0x0.0 - 0x0.29 */
	 u_int32_t selected_fields;
	/* Description - This field sets the L4 protocol type (TCP or UDP) L4_SPORT 
and L4_DPORT fields refer to:
0: TCP
1: UDP
If both L4_SPORT and L4_DPORT are disabled this field is 
ignored and it does not impact the RX hash behavior. */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t l4_prot_type;
	/* Description - This field sets the L3 protocol type (IPv4 or IPv6) SRC_IP and 
DST_IP fields refer to:
0: IPv4
1: IPv6
If both SRC_IP and DST_IP are disabled this field is ignored and 
it does not impact the RX hash behavior. */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t l3_prot_type;
};

/* Description -   */
/* Size in bytes - 16 */
union connectib_fw_qpc_special {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_regular_qp regular_qp;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_dcr_qp dcr_qp;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_dct_qp dct_qp;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_fw_qpc_q {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -   FW_QP_STATE_RESET     = 0,
  FW_QP_STATE_INIT      = 1,
  FW_QP_STATE_RTR_UNUSED       = 2,
  FW_QP_STATE_RTS_UNUSED       = 3,
  FW_QP_STATE_SQER_UNUSED      = 4,
  FW_QP_STATE_SQD_UNUSED       = 5,
  FW_QP_STATE_ERR       = 6,
  FW_QP_STATE_DRAINING_UNUSED  = 7,
  FW_QP_STATE_BUSY_UNUSED      = 8,
  FW_QP_STATE_SUSPENDED_UNUSED = 9,
  FW_QP_STATE_READY     = 10,
  FW_QP_STATE_FLUSHING  = 11,
  FW_QP_STATE_CHILLING  = 12,
  FW_QP_STATE_NACK      = 13
 */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t qp_state;
	/* Description -  */
	/* 0x0.8 - 0x0.15 */
	 struct connectib_schedint_cause schedint_cause;
	/* Description -  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t sxdc_valid;
	/* Description -  */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t qpc_valid;
	/* Description - relevant for DCT only. DCT_CLEANUP_IDLE = 0
 DCT_CLEANUP_DCRS_NOT_FOUND = 1
 DCT_CLEANUP_DCRS_FOUND = 2 */
	/* 0x0.18 - 0x0.19 */
	 u_int8_t dct_cleanup_state;
	/* Description -  */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t qp_in_linked_list;
	/* Description -  */
	/* 0x0.21 - 0x0.21 */
	 u_int8_t cmdif_awaiting;
	/* Description - kill qp arbiter was disabled as part of duplicate_sx_flush flow */
	/* 0x0.22 - 0x0.22 */
	 u_int8_t dup_sx_flush_kill_qp_arb_disabled;
	/* Description -  */
	/* 0x0.23 - 0x0.23 */
	 u_int8_t broken_wq_buffer;
	/* Description -  */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t broken_cq;
	/* Description -  */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t catas_event_generated;
	/* Description -  */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t last_wqe_event_generated;
	/* Description -  */
	/* 0x0.27 - 0x0.27 */
	 u_int8_t async_event_generated;
	/* Description -  */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t flushed_in_error;
	/* Description -  */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t sl_diff_flow_done;
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t all_connections_closed_event_req;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t disable_flushed_in_error;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t packet_pacing_rate_limit_index;
	/* Description - extends rx heartbeat for use with ODP */
	/* 0x4.8 - 0x4.8 */
	 u_int8_t rx_heartbeat_odp_ext;
	/* Description - extends rx heartbeat */
	/* 0x4.9 - 0x4.9 */
	 u_int8_t rx_heartbeat_gnrl_ext;
	/* Description - extends rx heartbeat */
	/* 0x4.10 - 0x4.10 */
	 u_int8_t rx_heartbeat_retry_cntr_ext;
	/* Description - extends sx heartbeat for use with ODP */
	/* 0x4.12 - 0x4.12 */
	 u_int8_t sx_heartbeat_odp_ext;
	/* Description - extends sx heartbeat */
	/* 0x4.13 - 0x4.13 */
	 u_int8_t sx_heartbeat_gnrl_ext;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t vendor_syndrome;
	/* Description -  */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t hw_syndrome;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.4 */
	 u_int8_t trap_reason;
	/* Description - for DCR cleanup */
	/* 0xc.5 - 0xc.5 */
	 u_int8_t connect_sent_to_ctrl_dct;
	/* Description - QP generated all needed events, or does need to */
	/* 0xc.6 - 0xc.6 */
	 u_int8_t needed_events_generated;
	/* Description - used in responder only */
	/* 0xc.8 - 0xc.11 */
	 u_int8_t retransmission_state;
	/* Description -  */
	/* 0xc.12 - 0xc.12 */
	 u_int8_t rx_fault_event_fired;
	/* Description -  */
	/* 0xc.14 - 0xc.14 */
	 u_int8_t sx_fault_event_fired;
	/* Description - (fw_trap_reason = SET_LIMIT) -> limit value.For DCR, requestor is used for odp gvmi */
	/* 0xc.16 - 0xc.31 */
	 u_int16_t trap_data_odp_gvmi;
};

/* Description -   */
/* Size in bytes - 4 */
union connectib_fw_qpc_ts_special {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_qpc_eth eth_qp;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_qpc_ib ib_qp;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_fw_xrqc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t num_offloads;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.4 */
	 u_int8_t nsq_log_page_size;
	/* Description -  */
	/* 0x4.8 - 0x4.12 */
	 u_int8_t ncq_log_page_size;
	/* Description -  */
	/* 0x4.16 - 0x4.20 */
	 u_int8_t stg_log_page_size;
	/* Description -  */
	/* 0x4.24 - 0x4.28 */
	 u_int8_t memory_page_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t tgt_num;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - notice this cq num is 16 bit field */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t send_cq_num;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t ioccsize;
	/* Description -  */
	/* 0x10.16 - 0x10.31 */
	 u_int16_t log_match_list_size;
};

/* Description -   */
/* Size in bytes - 4 */
union connectib_hw_msix_context_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_hw_msix_context_data0 regular;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_steering_qp_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t qp_number;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t force_responder;
};

/* Description -   */
/* Size in bytes - 16 */
union connectib_hw_ste_tag {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_hw_ste_tag_bulk bulk;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_hw_ste_tag_ib_l2 ibl2;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_hw_ste_tag_ib_l3_extended ibl3_extended;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_hw_ste_tag_ib_l3 ibl3;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_hw_ste_tag_ib_l4 ibl4;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_hw_ste_tag_source_gvmi_qp source_gvmi_qp;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_hw_ste_tag_port port;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_hw_ste_tag_generic_headers generic_headers;
};

/* Description -   */
/* Size in bytes - 8 */
union connectib_hw_pdf_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_hw_pdf_decoder pdf_decoder;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_hw_transaction_pdf transaction_pdf;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_dc_access_key_63_32 {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_dc_access_key_31_0 {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_tclass {
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.24 - 0x34.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_context_number {
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x34.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_hop_limit {
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.24 - 0x30.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_cq_number {
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x30.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_ts {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.28 - 0x2c.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_ipd {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.24 - 0x2c.27 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_my_gid_mac_index {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.16 - 0x2c.23 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_extended_atomic {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.12 - 0x2c.15 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_pkey_table_index {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x2c.11 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_counter_index {
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.24 - 0x28.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_srq_number {
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x28.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_atomic_like_write {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.31 - 0x24.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_my_lid {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.24 - 0x24.30 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_qp_valid {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.23 - 0x24.23 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_max_read_atomic {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.20 - 0x24.22 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_flow_label {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x24.19 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_grh_bit {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.27 - 0x20.27 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_port_number {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.26 - 0x20.26 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_adaptive_routing {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.25 - 0x20.25 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_tcu_trap {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.24 - 0x20.24 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_tcu_drop {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.23 - 0x20.23 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_dc_access_key_log_num_byte {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.20 - 0x20.22 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_fast_path {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.19 - 0x20.19 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_mtu {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.16 - 0x20.18 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_read_enable {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.15 - 0x20.15 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_send_with_invalidate_enable {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.14 - 0x20.14 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_ignore_pkey_check {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.13 - 0x20.13 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_max_message_size {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.8 - 0x20.12 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_inline_scatter {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.6 - 0x20.7 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_write_enable {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.5 - 0x20.5 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_rnr_timer {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x20.4 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct_complete_to_64B_eyald {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_qp_valid {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_grh_to_cqe {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_drop_my_self_multicast {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_ack_type {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.28 - 0x0.30 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_e2e_credits_enabled {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.27 - 0x0.27 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_no_direct_access {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_post_receive_slave_enable {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_atomic_like_write {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_write_enable {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.23 - 0x0.23 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_max_read_atomic {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.20 - 0x0.22 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_extended_atomic {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_ignore_pkey_check {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_send_with_invalidate_enable {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_read_enable {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_fast_path {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_check_source_uc_lb {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_check_source_mc_lb {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_check_source_gvmi {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_inline_scatter {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.6 - 0x0.7 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rwq_type {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.4 - 0x0.5 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_last_opcode {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_fw_link_type {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_check_source_uc_wire {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_write_rkey {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rx_heartbeat {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_e2e_credits_prefetch_threshold {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.28 - 0x8.30 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_e2e_fetch_enable {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.27 - 0x8.27 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_tcu_drop {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.26 - 0x8.26 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_can_use_reserved_lkey {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.25 - 0x8.25 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_tcu_trap {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.24 - 0x8.24 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rnr_timer {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.16 - 0x8.20 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rwqe_limit_event {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rwqe_consumer_index {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.16 - 0xc.31 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rcyclic_producer {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rwqe_producer_index {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_qp_state {
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rdb_write_pointer {
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.24 - 0x14.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_first_non_acked_psn {
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rcyclic_consumer {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_msn {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_dct_number {
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_cq_number {
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_expected_psn {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.8 - 0x20.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_flush_syndrom {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x20.7 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_counter_index {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.24 - 0x24.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_always_zero {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.23 - 0x24.23 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rdb_read_pointer {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x24.7 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rx_length_committed {
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.8 - 0x28.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_ts {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.28 - 0x2c.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_sx_heartbeat {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.27 - 0x2c.27 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_sqn {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.16 - 0x2c.26 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_dct_gvmi {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x2c.15 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_no_wqe_drop_count {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x2c.15 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_write_va_63_32 {
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_write_va_31_0 {
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_srq_number {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x38.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_next_dcr {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x38.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_mpi_uar {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.8 - 0x3c.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_responder_session_id {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.8 - 0x3c.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_xrc_domain {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.8 - 0x3c.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_dcr_connected {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.2 - 0x3c.2 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_e2e_pa_63_32 {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_e2e_pa_31_2 {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.2 - 0x3c.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_check_source_mc_wire {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.1 - 0x3c.1 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_connection_state {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x3c.1 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_pf_vf_vpd {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0x0.16 - 0x0.30 */
	 u_int16_t vpd_address;
	/* Description - NO_DESCR */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t F;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t vpd_data;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_pf_vf_sriov {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t vf_enable;
	/* Description - RO */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t vf_migration_en;
	/* Description - RO */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t vf_migration_int_en;
	/* Description - NO_DESCR */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t vf_mse;
	/* Description - NO_DESCR */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t ari_capable_hierarchy;
	/* Description - log value of system page size mask. no need to store more than 1 bit */
	/* 0x0.8 - 0x0.12 */
	 u_int8_t log_system_page_size;
	/* Description - number of vfs in this sr */
	/* 0x0.16 - 0x0.25 */
	 u_int16_t num_vfs;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - just a place holder */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t not_in_use;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_serdes_conf_preset_tx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_serdes_conf_tx_set_ini set[16];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_serdes_active_tx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_serdes_conf_tx_set_ini set[4];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_serdes_active_rx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_serdes_conf_rx_set_ini set[4];
};

/* Description -   */
/* Size in bytes - 40 */
struct connectib_serdes_force_tx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x28.31 */
	 struct connectib_serdes_conf_tx_set_ini set[10];
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_serdes_force_rx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x50.31 */
	 struct connectib_serdes_conf_rx_set_ini set[10];
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_serdes_conf_aba_tx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_serdes_conf_tx_set_ini set[32];
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_serdes_conf_aba_rx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_serdes_conf_rx_set_ini set[32];
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_serdes_conf_autoneg_tx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_serdes_conf_tx_set_ini set[32];
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_serdes_conf_autoneg_rx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_serdes_conf_rx_set_ini set[32];
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_aba_indexes {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_aba_index encode_64_66;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - node is not in use, exist only for future demand */
	/* 0x10.0 - 0x20.31 */
	 struct connectib_aba_index encode_8_10;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x30.31 */
	 struct connectib_aba_index encode_8_10_legacy;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_serdes_param_mask_per_proto_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t rx;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_pf_array_default_ones {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.31 - 0x8.30 */
	 u_int8_t ix[64];
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_nv_ets_tcN_config_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - See QETCR bw_allocation field. Valid values are 1-100. */
	/* 0x0.0 - 0x0.6 */
	 u_int8_t bw_allocation;
	/* Description - See group in the QETCR register */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t group;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - See max_bw_value in the QETCR register. */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t max_bw_value;
	/* Description - See max_bw_unit in the QETCR register.
0x0: DISABLED - rate lim
it
0x3: HUNDREDS_MBPS - max_bw_value is in 100 Mbps units
 
iter disabled
0x4: GBPS - max_bw_value is in 1 Gbps unit
s */
	/* 0x4.16 - 0x4.19 */
	 u_int8_t max_bw_units;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_fpga_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Next Fpga Caps Field to read */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t state;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - in Bytes */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t mailbox_write_offset;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - in Bytes */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t mailbox_write_size;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_fpga_access_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - i2c master handler state */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t state;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_create_lag {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t tx_remap_affinity_1;
	/* Description -  */
	/* 0x0.4 - 0x0.7 */
	 u_int8_t tx_remap_affinity_2;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_modify_sq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - syndrom of qp flush */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t qp_flush_syndrom;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_modify_rq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - syndrom of qp flush */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t qp_flush_syndrom;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - low wather mark */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t lwm;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_l2_table {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t hw_rx_ix;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t hw_sx_ix;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_dmfs_ft {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t vport_num;
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t log_size;
	/* Description - flow level is 0 */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t ft_in_level0;
	/* Description - flow table is the root */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t ft_is_root;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t next_table_id;
	/* Description -  */
	/* 0x4.24 - 0x4.27 */
	 u_int8_t table_miss_mode;
	/* Description -  */
	/* 0x4.29 - 0x4.29 */
	 u_int8_t lag_demux;
	/* Description -  */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t decap_en;
	/* Description -  */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t encap_en;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t table_id;
	/* Description -  */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t table_type;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t rx_head_ix;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t sx_head_ix;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_dmfs_fg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t vport_num;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t table_id;
	/* Description -  */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t table_type;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t vst_root_hash_meta_ix;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t rx_end_ste_ix;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t sx_end_ste_ix;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t rx_root_hash_meta_ix;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t sx_root_hash_meta_ix;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_dmfs_fte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t vport_num;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - last flow list item that its ref_count was increased (for rollback) */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t copied_items_cntr;
	/* Description - hierarchy index of the next steering table to be allocated */
	/* 0x4.16 - 0x4.23 */
	 u_int8_t next_hierarchy_to_alloc;
	/* Description -  */
	/* 0x4.24 - 0x4.24 */
	 u_int8_t fte_use_iterator;
	/* Description -  */
	/* 0x4.25 - 0x4.25 */
	 u_int8_t src_port_ext_match_exists;
	/* Description -  */
	/* 0x4.26 - 0x4.26 */
	 u_int8_t modify_flow_list;
	/* Description - fte points to external port */
	/* 0x4.27 - 0x4.27 */
	 u_int8_t external_dest_vport;
	/* Description - fte points to internal port */
	/* 0x4.28 - 0x4.28 */
	 u_int8_t internal_dest_vport;
	/* Description -  */
	/* 0x4.29 - 0x4.29 */
	 u_int8_t uc_match_exists;
	/* Description -  */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t mc_match_exists;
	/* Description -  */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t fte_add_remove_;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t table_id;
	/* Description -  */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t table_type;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t iterator_ix;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t fte_rx_ix;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t fte_sx_ix;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t fte_rx2_ix;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t fte_sx2_ix;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_create_mtt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t mtt_ix;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t num_mtts;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_psv {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t num_psv;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t num_alloced_psv;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t pd;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x20.31 */
	 u_int32_t psv_ix[4];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_mcg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t rx_mcg_index;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t sx_mcg_index;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t gid_msb;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x18.31 */
	 u_int64_t gid_lsb;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.15 */
	 u_int16_t member_count;
	/* Description - The attached QP ulp stateless offload mode */
	/* 0x18.16 - 0x18.17 */
	 u_int8_t ulp;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t iterator_ix;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_sniffer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t port_0_1;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_modify_rmp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t bitmask;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t lwm;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_arm_rq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t lwm;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_mkey {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t hw_addr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t fw_addr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t octoword_actual_size_mtt;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_modify_cq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t mtt_ix;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t producer_index;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.0 */
	 u_int8_t cqe_128b_size;
	/* Description -  */
	/* 0xc.1 - 0xc.5 */
	 u_int8_t log2_size;
	/* Description -  */
	/* 0xc.6 - 0xc.10 */
	 u_int8_t log_page_size;
	/* Description -  */
	/* 0xc.11 - 0xc.16 */
	 u_int8_t cq_page_offset;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t fence_slice;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.7 */
	 u_int8_t old_sw_eqn;
	/* Description -  */
	/* 0x14.8 - 0x14.8 */
	 u_int8_t modify_fields_c_eqn;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_create_cq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t fw_addr;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_create_eq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t fw_eqc_addr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - has either mtt_ix or PA address */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t mtt_ix_pas;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x18.31 */
	 u_int64_t event_bitmask;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t hw_eqn;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.7 */
	 u_int8_t offset_in_page;
	/* Description -  */
	/* 0x1c.8 - 0x1c.13 */
	 u_int8_t log_page_size;
	/* Description - set to 1 if PA mode, set 0 if MTT mode */
	/* 0x1c.16 - 0x1c.16 */
	 u_int8_t is_pa_mode;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_rqt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t rqt_fw_data_ix;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t rqt_hw_data_ix;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - base qp_number */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t rss_indirection_table_base_qpn;
	/* Description - defines the size of qp_numbers in the HW rqt */
	/* 0x8.30 - 0x8.31 */
	 u_int8_t rss_qpn_size;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - for rollback */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t num_rqs_to_dec;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.16 - 0x10.31 */
	 u_int16_t rqt_max_size;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.15 */
	 u_int16_t rqt_actual_size;
	/* Description - only for modify_rqt */
	/* 0x14.16 - 0x14.31 */
	 u_int16_t rqt_actual_size_old;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - only for modify_rqt */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t rqt_fw_data_ix_old;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - only for modify_rqt */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t rqt_hw_data_ix_old;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_create_xrq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - mtt offset from the initial ix - we create all xrq buffers mtts together */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t curr_mtt_offset;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t fw_srqn;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t tgt_num;
	/* Description - 0- None, 1- tag_matching */
	/* 0x8.24 - 0x8.27 */
	 u_int8_t offload;
	/* Description - 0- None, 1-rndv, 2-NVMf */
	/* 0x8.28 - 0x8.31 */
	 u_int8_t topology;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - nvmf only */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t nvme_sq_mkn;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - nvmf only */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t nvme_cq_mkn;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - nvmf only */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t uapp_data_mkn;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t uapp_ctrl_mkn;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - MUST BE AT OFFSET 0x1c */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t num_nim_indicies_allocated;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_create_srq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t fw_addr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t srqi;
	/* Description -  */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t cont_srq;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t pas_offset;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_create_rq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t fw_qpc_addr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t no_lro_qpn;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - copy of hca_params->log_max_qp */
	/* 0xc.0 - 0xc.4 */
	 u_int8_t log_max_qp;
	/* Description -  */
	/* 0xc.8 - 0xc.11 */
	 u_int8_t wq_type;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_qp_commands {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t fw_qpc_addr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t qpi;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - copy of hca_params->log_max_qp */
	/* 0xc.0 - 0xc.4 */
	 u_int8_t log_max_qp;
	/* Description -  */
	/* 0xc.5 - 0xc.5 */
	 u_int8_t is_dci;
	/* Description -  */
	/* 0xc.6 - 0xc.6 */
	 u_int8_t is_enhanced_ipoib;
	/* Description -  */
	/* 0xc.7 - 0xc.7 */
	 u_int8_t is_xrq;
	/* Description - 0-none, 1-rendezvous, 2-nvme */
	/* 0xc.8 - 0xc.10 */
	 u_int8_t offload_xrq_type;
	/* Description -  */
	/* 0xc.11 - 0xc.11 */
	 u_int8_t is_tag_matching_xrq;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x20.31 */
	 union connectib_cmdif_ctx_special_qp_commands_specific specific;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_modify_tis {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t transport_domain;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t underlay_qpn;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_modify_tir {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t bitmask;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t tir_ste_ix;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t hash_filter_base_ix;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t hash_entries_base_ix;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t rqt_number;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t old_rqt_number;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t inline_rqn;
	/* Description -  */
	/* 0x18.24 - 0x18.27 */
	 u_int8_t disp_type;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.23 */
	 u_int32_t transport_domain;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_create {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t num_mapped_mtts;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_flush_type_bitmask {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t dword;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_flush_type_bits {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t mkey_flush;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t qp_s_flush;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t qp_r_flush;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t rx_flush;
};

/* Description -   */
/* Size in bytes - 44 */
union connectib_reg_access_reg_tlv_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_mfpa mfpa;
	/* Description - misc flash activate image */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_register_mfai mfai;
	/* Description - misc flash reset level */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_register_mfrl mfrl;
	/* Description - misc temperature */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_mtmp mtmp;
	/* Description - misc_counters */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_register_misc_counters misc_counters;
	/* Description - misc flash block access */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_project_mfba mfba;
	/* Description - misc flash block erase */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_mfbe mfbe;
	/* Description - Secure Firmware Cmd: Management Component Query Status */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_mcqs_reg mcqs;
	/* Description - Secure Firmware Cmd: Management Component Query Information */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_mcqi_reg mcqi;
	/* Description - Secure Firmware Cmd: Management Component Control */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_mcc_reg mcc;
	/* Description - Secure Firmware Cmd: Management Component Data Access */
	/* 0x0.0 - 0x14.31 */
	 struct connectib_mcda_reg mcda;
	/* Description - Secure Firmware Cmd: Management Query Information Strings */
	/* 0x0.0 - 0x14.31 */
	 struct connectib_mqis_reg mqis;
	/* Description - mjtag - master jtag register */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_mjtag mjtag;
	/* Description - Table 236 - PAOS - Ports Administrative and Operational Status Register Layout */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_paos_reg paos;
	/* Description - Serdes Lane Receive Parameters */
	/* 0x0.0 - 0x28.31 */
	 struct connectib_slrp_reg slrp;
	/* Description - Table 305 - [Internal] SLTP - Serdes Lane Transmit Parameters Register Layout */
	/* 0x0.0 - 0x14.31 */
	 struct connectib_sltp_reg sltp;
	/* Description - Table 309 - PTAS - Phy Tuning Algorithm Settings Register Layout */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_ptas_reg ptas;
	/* Description - Table 307 - SLRG - Serdes Lane Receive Grade Register Layou */
	/* 0x0.0 - 0x28.31 */
	 struct connectib_slrg_reg slrg;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_pptt_reg pptt;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_pprt_reg pprt;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_ppaos_reg ppaos;
	/* Description - Table 301 - [Internal] PPAMP - Port Phy opAMP data Register Layout */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_pamp_reg ppamp;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_pmtu_reg pmtu;
	/* Description -  */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_project_nvda nvda;
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_nv_tlv_hdr nvdi;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_project_nvqc nvqc;
	/* Description - Table 267 NVGC Register Layout */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_project_nvgc nvgc;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_project_nvia nvia;
	/* Description -  */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_project_nvgn nvgn;
	/* Description - Table 291 - PPLR - Port Physical Loopback Register Layout */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_pplr_reg pplr;
	/* Description - Table 297 - PLPC - Phy Link Profiles Control Register Layout */
	/* 0x0.0 - 0x28.31 */
	 struct connectib_plpc_reg plpc;
	/* Description - Table 299 - PPLM - Port Phy Link Mode Register Layout */
	/* 0x0.0 - 0x18.31 */
	 struct connectib_pplm_reg pplm;
	/* Description - Table 303 - PMLP - Port Module to Local Port Register */
	/* 0x0.0 - 0x24.31 */
	 union connectib_pmlp pmlp;
	/* Description - Management Version Time Stamp */
	/* 0x0.0 - 0x14.31 */
	 struct connectib_mvts mvts;
	/* Description -  */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_mpein_reg mpein;
	/* Description -  */
	/* 0x0.0 - 0x18.31 */
	 struct connectib_pmcr_reg pmcr;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_pmaos_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Module state (reserved while 
admin_status
 is disabled):
0 - initializing
1 - plugged, enabled
2 - unplugged
3 - module plugged, error (details in 
error_type
).
4 - plugged, disabled */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t oper_status;
	/* Description - Module administrative state (the desired state of the module):
1- enabled
2- disabled by configuration
3- enabled once - if the module is active and then unplugged, the 
operational status should go to "disabled" and can only be enabled 
up upon explicit enable command.
Note: To disable a module, all ports associated with the port must 
be disabled first. */
	/* 0x0.8 - 0x0.11 */
	 u_int8_t admin_status;
	/* Description - Module number. */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t module;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Event Generation on operational state change:
00 - Do not generate event
01 - Generate Event 
10 - Generate Single Event */
	/* 0x4.0 - 0x4.1 */
	 u_int8_t e;
	/* Description - Module error details:
0x0 - Power Budget Exceeded
0x1 - Long Range for non MLNX cable/module
0x2 - Bus stuck (I2C Data or clock shorted)
0x3 - bad/ unsupported EEPROM
0x4 - Enforce part number list. 
0x5 - unsupported cable
0x6 - High Temperature
0x7 - bad cable (Module/Cable is shorted)
Valid only when 
oper_status 
= 4'b0011. */
	/* 0x4.8 - 0x4.11 */
	 u_int8_t error_type;
	/* Description - Event update enable. If this bit is set, event generation will be 
updated based on the 
e
 field. Only relevant on Set operations. */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t ee;
	/* Description - Admin state update enable. If this bit is set, admin state will be 
updated based on 
admin_state
 field. Only relevant on Set() opera
tions. */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t ase;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_mtppse_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Pin to be configured or queried out of the supported pins. */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t pin;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Event generation mode.
0x0: disable - no event is generated.(default mode). 
0x1: repetitive events - generate event on each event regardless 
event arming 
0x2: once till arm - generate a single event and wait for rearming */
	/* 0x4.0 - 0x4.3 */
	 u_int8_t event_generation_mode;
	/* Description - If set, 
a
rm the event mechanism to generate event. 
Valid only for event_gen_mode == once_till_arm. 
Note that by default the event is not armed. */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t event_arm;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_mtpps_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Maximum number of pps out pins supported on device. */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t cap_max_num_of_pps_out_pins;
	/* Description - Maximum number of pps in pins supported on device. */
	/* 0x0.8 - 0x0.11 */
	 u_int8_t cap_max_num_of_pps_in_pins;
	/* Description - Total number of pps pins supported on device. */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t cap_number_of_pps_pins;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Capability of PPS pin # 0
0x0: not_supporting_pps.
0x1: ptp_in 
0x2: ptp_out 
0x3: ptp_in_or_ptp out  */
	/* 0x8.0 - 0x8.3 */
	 u_int8_t cap_pin_0_mode;
	/* Description - Capability of PPS pin # 1
0x0: not_supporting_pps.
0x1: ptp_in 
0x2: ptp_out 
0x3: ptp_in_or_ptp out  */
	/* 0x8.8 - 0x8.11 */
	 u_int8_t cap_pin_1_mode;
	/* Description - Capability of PPS pin # 2
0x0: not_supporting_pps.
0x1: ptp_in 
0x2: ptp_out 
0x3: ptp_in_or_ptp out  */
	/* 0x8.16 - 0x8.19 */
	 u_int8_t cap_pin_2_mode;
	/* Description - Capability of PPS pin # 3
0x0: not_supporting_pps.
0x1
:
 ptp_in 
0x2
:
 ptp_out 
0x3
:
 ptp_in_or_ptp out  */
	/* 0x8.24 - 0x8.27 */
	 u_int8_t cap_pin_3_mode;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Capability of PPS pin # 4
0x0: not_supporting_pps.
0x1: ptp_in 
0x2: ptp_out 
0x3: ptp_in_or_ptp out  */
	/* 0xc.0 - 0xc.3 */
	 u_int8_t cap_pin_4_mode;
	/* Description - Capability of PPS pin # 5
0x0: not_supporting_pps.
0x1: ptp_in 
0x2: ptp_out 
0x3: ptp_in_or_ptp out  */
	/* 0xc.8 - 0xc.11 */
	 u_int8_t cap_pin_5_mode;
	/* Description - Capability of PPS pin # 6
0x0: not_supporting_pps.
0x1: ptp_in 
0x2: ptp_out 
0x3: ptp_in_or_ptp out  */
	/* 0xc.16 - 0xc.19 */
	 u_int8_t cap_pin_6_mode;
	/* Description - Capability of PPS pin # 7
0x0: not_supporting_pps.
0x1: ptp_in 
0x2: ptp_out 
0x3: ptp_in_or_ptp out  */
	/* 0xc.24 - 0xc.27 */
	 u_int8_t cap_pin_7_mode;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Pin to be 
configured or queried out of the supported pins. */
	/* 0x20.0 - 0x20.7 */
	 u_int8_t pin;
	/* Description - Pin mode to be used. The mode must comply with the supported 
modes 
of
 the requested pin.
0x0: pps_in .
0x1
:
 pps_out .
Operation will fail if pin does not support the required mode. */
	/* 0x20.8 - 0x20.11 */
	 u_int8_t pin_mode;
	/* Description - When pin_mode==pps_in:
0x0: Rising edge 
0x1: Falling edge 
When pin_mode==pps_out:
0
x0:
 Pulse (one shot) - the device will generate a pulse with pulse 
duration of out_pulse_duration. The pulse will be generated at 
out_time time 
0x1: 
periodic - the device will generate periodical pulses with 
pulse duration of out_pulse_duration every 1 second according 
to internal clock. The 1st pulse will be generated at out_time time 
Reserved when pin_mode is not equal to ptp_out. */
	/* 0x20.16 - 0x20.19 */
	 u_int8_t pattern;
	/* Description - Enables the PPS functionality the the specific pin.
0x0
:
 
D
isable 
0x1
:
 Enable  */
	/* 0x20.31 - 0x20.31 */
	 u_int8_t enable;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - When pin_mode==pps_in, 
t
he latched device time when it was 
triggered from the external GPIO pin. 
When pin_mode==pps_
out
, 
t
he target time to generate 
next output signal. 
Time is in units of 
device clock
. Device clock frequency 
can be fetched from HCA_CAP.device_frequency */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t time_stamp_hi;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - When pin_mode==pps_in, 
t
he latched device time when it was 
triggered from the external GPIO pin. 
When pin_mode==pps_
out
, 
t
he target time to generate 
next output signal. 
Time is in units of 
device clock
. Device clock frequency 
can be fetched from HCA_CAP.device_frequency */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t time_stamp_lo;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - Adjustment of offset from nominal frequency 
 
in units of 
nsec
c. 
Range is from -32768 to +32767 
The hardware does consecutive frequency adjustment 
Reserved when pin_mode != ptp_out */
	/* 0x30.0 - 0x30.15 */
	 u_int16_t out_periodic_adjustment;
	/* Description - Output pulse duration 
in 
u
nits of msec. 
Range is 1 to 1000. 
Reserved when pin_mode 
!=
 ptp_out */
	/* 0x30.16 - 0x30.31 */
	 u_int16_t out_pulse_duration;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_fpga_ctrl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Status of the last operation.
0x0: Success
0x1: Failure
0x2: In_progress
Valid only for query operation. */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t status;
	/* Description - Indicates the control operation to be performed. Allowed only when 
FPGA_CAP.fpga_ctrl_modify==1. 
 See Table 390, "
FPGA_CAP Register 
Layout
," on page 563
.
0x1: LOAD - when set, the FPGA will be forced to reload the image from 
flash according to 
image_select_admin
 value.
0x2: RESET - when set, the FPGA internal logic state (BRAMs, FFs, etc.) 
will be reset to the original state at loading time.
0x3: 
FLASH
_SELECT - when set, map the flash GW according to 
flash
_se
lect_admin
 value.
0x4: 
Sandbox_Bypass_On
 - If set, sandbox logic is inactive until 
Sandbox
_Bypass_Off
 
is set. Packets will skip the sandbox logic.
0x5: 
Sandbox_Bypass_Off - 
If set, sandbox logic is active. Packets will 
be 
processed by 
the sandbox logic. */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t operation;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Current 
flash
that 
is 
used to 
l
oad
images 
t
o FPGA.
0x0: Factory_default
0x1: User
Valid only if status is ok. */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t flash_select_oper;
	/* Description - Used to select next 
flash
 to be 
used
to load the images
.
0x0: Factory_default
0x1: User
Valid only for 
FLASH
_SELECT and LOAD operations. */
	/* 0x4.16 - 0x4.23 */
	 u_int8_t flash_select_admin;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_fpga_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - FPGA device type.
0x0: KU040
0x1: KU060 */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t fpga_device;
	/* Description - FPGA identifier.
0x0: unknown
0x1: Newton_X */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t fpga_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Shell registers space file version. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t register_file_ver;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Indicates the MODIFY operation's permissions of FPGA_ACCESS_REG.
0x0: Not_allowed - modify registers by FPGA_ACCESS_REG not allowed.
0x1: All_range_allowed- modify registers by FPGA_ACCESS_REG 
allowed for all addresses. */
	/* 0x8.16 - 0x8.17 */
	 u_int8_t access_reg_modify_mode;
	/* Description - Indicates the QUERY operation's permissions of FPGA_ACCESS_REG.
0x0: Not_allowed - Query registers by FPGA_ACCESS_REG not allowed.
0x1: All_range_allowed- Query registers by FPGA_ACCESS_REG allowed 
for all addresses. */
	/* 0x8.24 - 0x8.25 */
	 u_int8_t access_reg_query_mode;
	/* Description - If set, SW is allowed to modify FPGA_CTRL register. See
 Table 394, 
"
FPGA_CTRL Register Layout
," on page 567 */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t fpga_ctrl_modify;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Image version. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t image_version;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Creation date of current running image.
Format: DDMMYYYY.
For example:
0x12011995 means 12/01/1995 in DD/MM/YY. */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t image_date;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Creation time of current running image.
Format: 00HHMMSS.
For example:
0x00015324 means 01:53:24 in HH:MM:SS */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t image_time;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Shell image version. */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t shell_version;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - Shell capabilities. */
	/* 0x30.0 - 0x70.31 */
	 struct connectib_fpga_shell_caps shell_caps;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description - IEEE Vendor ID of sandbox user.
0x2C9: Mellanox */
	/* 0x70.0 - 0x70.23 */
	 u_int32_t ieee_vendor_id;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description - Sandbox product ID.
For Mellanox sandbox products
0x0: unknown
0x
1
:
 example
0x
2
:
 IPsec
0x
3
:
 TLS */
	/* 0x74.0 - 0x74.15 */
	 u_int16_t sandbox_product_id;
	/* Description - Sandbox version. */
	/* 0x74.16 - 0x74.31 */
	 u_int16_t sandbox_product_version;
/*---------------- DWORD[30] (Offset 0x78) ----------------*/
	/* Description - Sandbox basic capabilities per sandbox product ID.
For Mellanox sandbox products, see
 Table 347, "
IPsec_Basic_Capabilities 
Structure Layout
," on page 535
. */
	/* 0x78.0 - 0x7c.31 */
	 u_int32_t sandbox_basic_caps;
/*---------------- DWORD[31] (Offset 0x7c) ----------------*/
	/* Description - The length (in DWORDs) of sandbox extended capability (equals 0 when 
such capability is not present). */
	/* 0x7c.0 - 0x7c.15 */
	 u_int16_t sandbox_extended_caps_len;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description - Bits [63:32] of the extended capabilities address.;For Mellanox sandbox products See ;Table 335, ";IPSec_extended_ca;pabilities Structure Layout;," on page 550;. */
	/* 0x80.0 - 0x84.31 */
	 u_int32_t sandbox_extended_caps_addr_h;
/*---------------- DWORD[33] (Offset 0x84) ----------------*/
	/* Description - Bits [31:0] of the extended capabilities address. */
	/* 0x84.0 - 0x88.31 */
	 u_int32_t sandbox_extended_caps_addr_l;
/*---------------- DWORD[34] (Offset 0x88) ----------------*/
	/* Description - Start address of DDR */
	/* 0x88.0 - 0x8c.31 */
	 u_int32_t fpga_ddr_start_addr_h;
/*---------------- DWORD[35] (Offset 0x8c) ----------------*/
	/* Description - Start address of DDR */
	/* 0x8c.0 - 0x90.31 */
	 u_int32_t fpga_ddr_start_addr_l;
/*---------------- DWORD[36] (Offset 0x90) ----------------*/
	/* Description - Start address of cr-space */
	/* 0x90.0 - 0x94.31 */
	 u_int32_t fpga_cr_space_start_addr_h;
/*---------------- DWORD[37] (Offset 0x94) ----------------*/
	/* Description - Start address of cr-space */
	/* 0x94.0 - 0x98.31 */
	 u_int32_t fpga_cr_space_start_addr_l;
/*---------------- DWORD[38] (Offset 0x98) ----------------*/
	/* Description - Size of DDR in a granularity of 1KB */
	/* 0x98.0 - 0x9c.31 */
	 u_int32_t fpga_ddr_size;
/*---------------- DWORD[39] (Offset 0x9c) ----------------*/
	/* Description - Size of cr-space in a granularity of 1KB */
	/* 0x9c.0 - 0xa0.31 */
	 u_int32_t fpga_cr_space_size;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_fpga_access_reg {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Number of bytes to read/write.
Must be aligned to 4 bytes.
Note that the maximum size supported is 64 bytes. */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Bits [63:32] of 64-bit address.
Allowed address depending on the FPGA_CAP.access_reg_query_mode 
and FPGA_CAP.access_reg_modify_mode.
 See Table 390, "
FPGA_CAP 
Register Layout
," on page 563
. */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t address_h;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Bits [31:0] of 64-bit address.
Allowed address depending on the FPGA_CAP.access_reg_query_mode 
and FPGA_CAP.access_reg_modify_mode.
 See Table 390, "
FPGA_CAP 
Register Layout
," on page 563 */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t address_l;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - For Query operations, specify the read data from FPGA registers space.
For Write operation, specify the data to be written to FPGA registers space. */
	/* 0x10.24 - 0x10.31 */
	 u_int8_t data[1];
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_pmmp_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Module number. */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t module;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Override/ignore EEPROM advertisement properties bitmask: 
Bit 0 - Override cable protocols and technology for QSFP
Bit 1 - Override cable protocols and technology for SFP
Bit 2- Ignore Power Class (set high power)
Bit 3- Override Cable Length 
Bit 4- Override Attenuation */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t eeprom_override;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Valid only when
 the protocols and technology is overridden as indicated by 
eeprom_override
See Table 461, "PMMP - QSFP Protocol Bytes Override Layout," on 
page 623 */
	/* 0x8.0 - 0x14.31 */
	 union connectib_pmmp_qsfp_protocol_override_layout_auto qsfp_cable_protocol_technology;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Valid only when
 the protocols and technology is overridden as indicated by 
eeprom_override
See Table 463, "PMMP - SFP Protocol Bytes Override Layout," on 
page 626 */
	/* 0x14.0 - 0x20.31 */
	 union connectib_pmmp_sfp_protocol_override_layout_auto sfp_cable_protocol_technology;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Length of cable assembly, units of 1 m.
Valid only when
 the cable length is overridden as indicated by 
eeprom_override. */
	/* 0x20.0 - 0x20.7 */
	 u_int8_t cable_length;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Valid only when
 the attenuation is overridden as indicated by 
eeprom_override.
Attenuation - total channel attenuation @ 5GHz in db. */
	/* 0x24.0 - 0x24.7 */
	 u_int8_t attenuation_5g;
	/* Description - Valid only when
 the attenuation is overridden as indicated by 
eeprom_override.
Attenuation - total channel attenuation @ 7GHz in db. */
	/* 0x24.8 - 0x24.15 */
	 u_int8_t attenuation_7g;
	/* Description - Valid only when
 the attenuation is overridden as indicated by 
eeprom_override.
Attenuation - total channel attenuation @ 12GHz in db. */
	/* 0x24.16 - 0x24.23 */
	 u_int8_t attenuation_12g;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Valid only when
 the module identifier is overridden as indicated by 
eeprom_override.
0x3
:
 SFP+
/
SFP28
0xD
:
 QSFP+
0x11
:
 QSFP28 */
	/* 0x28.0 - 0x28.7 */
	 u_int8_t module_identifier;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_pcmr_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Local port number */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Specifies the check enable/disable capabilities of the local port. A bit set to 
1 for affirmation of supported enable/disable capability: 
PHY/PCS check disable/enable capability */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t pcs_cap;
	/* Description - Specifies the check enable/disable capabilities of the local port. A bit set to 
1 for affirmation of supported enable/disable capability: 
FCS check disable/enable capability
 */
	/* 0x4.1 - 0x4.1 */
	 u_int8_t fcs_cap;
	/* Description - Specifies the check enable/disable capabilities of the local port. A bit set to 
1 for affirmation of supported enable/disable capability: 
SHORT FRAME check disable/enable capability */
	/* 0x4.2 - 0x4.2 */
	 u_int8_t sht_cap;
	/* Description - Specifies the check enable/disable capabilities of the local port. A bit set to 
1 for affirmation of supported enable/disable capability: 
MTU error - check disable/enable capability (data packet"s actual length 
over mtu_frame_size) */
	/* 0x4.3 - 0x4.3 */
	 u_int8_t mtu_cap;
	/* Description - Specifies the check enable/disable capabilities of the local port. A bit set to 
1 for affirmation of supported enable/disable capability: 
FRAME TYPE check disable/enable capability (out-of-range Type-Length 
field) */
	/* 0x4.4 - 0x4.4 */
	 u_int8_t type_cap;
	/* Description - Specifies the check enable/disable capabilities of the local port. A bit set to 
1 for affirmation of supported enable/disable capability: 
LENGTH MISMATCH check disable/enable capability (Length in Length
Type is does not match actual payload length) */
	/* 0x4.5 - 0x4.5 */
	 u_int8_t len_cap;
	/* Description - Specifies the check enable/disable capabilities of the local port. A bit set to 
1 for affirmation of supported enable/disable capability: 
flow-control packet check disable/enable capability */
	/* 0x4.7 - 0x4.7 */
	 u_int8_t fc_cap;
	/* Description - Specifies the check enable/disable capabilities of the local port. A bit set to 
1 for affirmation of supported enable/disable capability: 
Control packet check disable/enable capability */
	/* 0x4.8 - 0x4.8 */
	 u_int8_t cp_cap;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - PHY/PCS error check
Values:
0: disable check. 
1: perform check
Note: when disabling a check, it will also affects the relevant counters. */
	/* 0x8.0 - 0x8.0 */
	 u_int8_t pcs_chk;
	/* Description - FCS check
Values:
0: disable check. 
1: perform check
Note: when disabling a check, it will also affects the relevant counters. */
	/* 0x8.1 - 0x8.1 */
	 u_int8_t fcs_chk;
	/* Description - SHORT FRAME check
Values:
0: disable check. 
1: perform check
Note: when disabling a check, it will also affects the relevant counters. */
	/* 0x8.2 - 0x8.2 */
	 u_int8_t sht_chk;
	/* Description - MTU check
Values:
0: disable check. 
1: perform check
Note: when disabling a check, it will also affects the relevant counters. */
	/* 0x8.3 - 0x8.3 */
	 u_int8_t mtu_chk;
	/* Description - FRAME TYPE check
Values:
0: disable check. 
1: perform check
Note: when disabling a check, it will also affects the relevant counters. */
	/* 0x8.4 - 0x8.4 */
	 u_int8_t type_chk;
	/* Description - LENGTH MISMATCH check
Values:
0: disable check. 
1: perform check
Note: when disabling a check, it will also affects the relevant counters. */
	/* 0x8.5 - 0x8.5 */
	 u_int8_t len_chk;
	/* Description - flow-control packet check
Values:
0: disable check. 
1: perform check
Note: when disabling a check, it will also affects the relevant counters. */
	/* 0x8.7 - 0x8.7 */
	 u_int8_t fc_chk;
	/* Description - Control packet check
Values:
0: disable check. 
1: perform check
Note: when disabling a check, it will also affects the relevant counters. */
	/* 0x8.8 - 0x8.8 */
	 u_int8_t cp_chk;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_mcion_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t module;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Bit 0 - Present ;\Bit1 - RX_LOS ;\Bit2 - TX_FAULT */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t module_status_bits;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_pddr_reg {
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_mpcnt_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Performance counter group.
0: PCIE performance counters
 */
	/* 0x0.0 - 0x0.5 */
	 u_int8_t grp;
	/* Description - PCI
e
 index number
Reserved when access is from the host */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t pcie_index;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Clear counters. Setting the 
clr
 bit will reset the counter value for all 
counters in the counter group. This bit can be set for both Set() and 
Get() operation. */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t clr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Counter set as described in
Table 657, "
PCI
e
 Performance Counters Data Layout
," on page 746
[Internal] 
Table 661, "
PCIE lanes counters Data Layout
," on 
page 750
[Internal] 
Table 659, "
PCIE timers and states Data Layout
," on 
page 748 */
	/* 0x8.0 - 0x100.31 */
	 union connectib_pcie_perf_counters_pcie_lanes_counters_pcie_timers_states_auto counter_set;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_mcia_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Module Status (added in PRM 0.95)
0h - GOOD
1h - NO_EEPROM_MODULE. No response from modules EPROM.
2h - MODULE_NOT_SUPPORTED. Module type not supported by the device. [Internal] we currently supports all module but who knows.
3h - MODULE_NOT_CONNECTED. No module present indica-tion. [Internal] The below codes are available in current FW. I think is  should be removed.
4h - MODULE_TYPE_INVALID               - if the module is not qsfp or sfp - meaning it doesn't has eeprom by definition (no need to  check the bus as NO_EEPROM_MODULE). Module types comes from ini.                  
5h - MODULE_NOT_ACCESSIABLE     - this is future imple-mented but not tested flow. If a module causing the I2C to hang (while we access its module) the firmware reset the I2C and remem-bers not to access this module until it is unplugged. we should fail access commands for this module.
9h - I2C_ERROR. Error occurred while trying to access the mod-ules EPROM using I2C.
10h - MODULE_DISABLED - module is disabled (using Disable Command). */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t status;
	/* Description - Module number */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t module;
	/* Description - Cable Info Lock Page bit */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t l;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t device_address;
	/* Description -  */
	/* 0x4.16 - 0x4.23 */
	 u_int8_t page_number;
	/* Description -  */
	/* 0x4.24 - 0x4.31 */
	 u_int8_t i2c_device_address;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t size;
	/* Description - Password capability */
	/* 0x8.29 - 0x8.29 */
	 u_int8_t passwd_cap;
	/* Description - If set to 1 will force the password to be cleared from the module password field at the end of the module access. */
	/* 0x8.30 - 0x8.30 */
	 u_int8_t passwd_clr;
	/* Description - If set to 1 the Password field is valid and is written to the module password field (address 123-126) before accessing the page. */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t passwd_v;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The password that is written to the module password field. */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t password;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x40.31 */
	 u_int32_t dword[12];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_ppad_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - If 
single_base_mac
 = 0 - base MAC address, mac[7:0] is 
reserved.
If 
single_base_mac
 = 1 - the per port MAC address */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t mac_47_32;
	/* Description - Port number
Reserved when 
single_base_mac
 = 0 */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
	/* Description - 0 - base_mac, 
local_port 
should be 0 and mac[7:0] is 
reserved.HW will set incremental 
1 - single_mac - mac of the 
local_port
Reserved for 
SwitchX/-2. */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t single_base_mac;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - If 
single_base_mac
 = 0 - base MAC address, mac[7:0] is 
reserved.
If 
single_base_mac
 = 1 - the per port MAC address */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t mac_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_pvlc_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Local port number */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Virtual Lanes supported on this port.
0 - Reserved
1: VL0
2: VL0, VL1
4: VL0 - VL3
8: VL0 - VL7
15: VL0 - VL14 */
	/* 0x4.0 - 0x4.3 */
	 u_int8_t vl_hw_cap;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Virtual Lanes enabled by the local admin on this port.
0: No change; valid only on Set()
1: VL0
2: VL0, VL1
4: VL0 - VL3
8: VL0 - VL7
15: VL0 - VL14 */
	/* 0x8.0 - 0x8.3 */
	 u_int8_t vl_admin;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Operational VLs as configured by the SM on this port:
0: No change; valid only on Set()
1: VL0
2: VL0, VL1
4: VL0 - VL3
8: VL0 - VL7
15: VL0 - VL14
Changing 
vl_operational
 in certain PortStates may cause in flow control 
update errors which may initiate Link/PHY retraining.
vl_operational
 value is valid only when link state is UP. */
	/* 0xc.0 - 0xc.3 */
	 u_int8_t vl_operational;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_ppcnt_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Performance counter group.
Group 63 indicates all groups. Only valid on Set() operation with 
clr
 bit set.
0x0: IEEE 802.3 Counters
0x1: RFC 2863 Counters
0x2: RFC 2819 Counters
0x3: RFC 3635 Counters
0x5: Ethernet Extended Counters
0x6: Ethernet Discard Counters (Switches Only)
0x8: Link Level Retransmission Counters
0x10: Per Priority Counters
0x11: Per Traffic Class Counters
0x11: Per Traffic Class Counters
0x12: Physical Layer Counters
0x13: Per Traffic Class Congestion Counters (Switches Only)
0x14: Correct On Demand Counters
0x15: Per Receive Buffer Counters
0x20 InfiniBand PortCounters */
	/* 0x0.0 - 0x0.5 */
	 u_int8_t grp;
	/* Description - Port number access type:
0 - Local port number
1 - IB port number */
	/* 0x0.14 - 0x0.15 */
	 u_int8_t pnat;
	/* Description - Local port number. 
255 indicates all ports on the device, and is only allowed for Set() operation. */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
	/* Description - For HCA
:
 must be always 0.
Switch partition ID to associate port with.
Switch partitions are numbered from 0 to 7 inclusively.
Switch partition 254 indicates stacking ports.
Switch partition 255 indicates all switch partitions.
Only valid on Set() operation with local_port=255. */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t swid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Priority for counter set that support per priority. Traffic class for counter set 
the support per traffic class. Otherwise must be 0. */
	/* 0x4.0 - 0x4.4 */
	 u_int8_t prio_tc;
	/* Description - Clear counters. Setting the 
clr
 bit will reset the counter value for all counters 
in the counter group. This bit can be set for both Set() and Get() operation. */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t clr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Counter set as described in:
 See Table 244, "
Ethernet IEEE 802.3 Counters Group Data Layout
," on 
page 397
 See Table 246, "
Ethernet RFC 2863 Counter Group Data Layout
," on 
page 400
 See Table 248, "
Ethernet RFC 2819 Coun
t
er Group Data Layout
," on 
page 402
 See Table 250, "
Ethernet RFC 3635 Counter Group Data Layout
," on 
page 405
 See Table 252, "
Ethernet Extended Counter Group Data Layout
," on 
page 408
 See Table 254, "
Ethernet Per Priority Group Data Layout
," on page 409
 See Table 256, "
Ethernet Per Traffic Cla
s
s Group data layout
," on page 411 */
	/* 0x8.0 - 0x100.31 */
	 union connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto counter_set;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_ptys_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Protocol Mask. Indicates which of the protocol data is valid
Bit 0: InfiniBand
Bit 1: FC
Bit 2: Ethernet */
	/* 0x0.0 - 0x0.2 */
	 u_int8_t proto_mask;
	/* Description - Local port number */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
	/* Description - When set, use ABA parameters on TX when in force operation (AN-dis
able or parallel detect) */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t force_tx_aba_param;
	/* Description - Auto Negotiation disable capability:
0 - Device does
 not 
support AN disable
1 - Device Supports AN disable */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t an_disable_cap;
	/* Description - Auto Negotiation disable:
0 - Normal operation 
1 - Disable AN.
Note: When Disabling AN, the "
eth_proto_admin
" bit mask must comply 
to single speed
 rate set. 
 */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t an_disable_admin;
	/* Description - THIS BIT MUST BE TIED TO 
1
!
This is old capability bit that address AN_DISABLE capability with only 
one enabled protocol. */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t reserved_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Port data rate in resolution of 100 Mb/s (
data_rate
_oper * 100 Mb/s)
Value 0x0 indicates this field is not supported. */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t data_rate_oper;
	/* Description - Auto Negotiation status: 
0 - Status is unavailable
1 - AN completed successfully 
2 - AN performed but failed
3 - AN was not performed, link is up 
4 - AN was not performed, link is down */
	/* 0x4.28 - 0x4.31 */
	 u_int8_t an_status;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - FC port speed/protocols supported (bitmask)
Bit 3 - 8GFC
Bit 2 - 4GFC
Bit 1 - 2GFC
Bit 0 - 1GFC */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t fc_proto_capability;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Ethernet port speed/protocols supported (bitmask)
Bit 31 - 50GBase-KR2
Bit 30 - 50GBase-CR2
Bit 29 - 25GBase-SR
Bit 28 - 25GBase-KR
Bit 27 - 25GBase-CR
[Internal] Bit 26 - 10GBase-T 
[Internal] Bit 25 - 1000Base-T
[Internal] Bit 24 - 100Base-TX
[Internal] Bit 23 - 100GBase LR4/ER4
Bit 22 - 100GBase KR4
Bit 21 - 100GBase SR4
Bit 20 - 100GBase CR4
Bit 19 - 50GBase-KR4
Bit 18 - 50GBase-SR2
Bit 16 - 40GBase LR4/ER4
Bit 15 - 40GBase SR4
Bit 14 - 10GBase ER/LR
Bit 13 - 10GBase SR
Bit 12 - 10GBase CR
[Internal] Bit 8 - 56GBase *R4
Bit 7 - 40GBase KR4
Bit 6 - 40GBase CR4
[internal] Bit 5 - 20GBase-KR2
Bit 4 - 10GBase KR
Bit 3 - 10GBase KX4
Bit 2 - 10GBase-CX4
Bit 1 - 1000Base KX
Bit 0 - SGMII */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t eth_proto_capability;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - InfiniBand port speed supported (bitmask)
ib_link_speed <= ib_proto_capability[7:0]
Bit 0 - SDR
Bit 1 - DDR
Bit 2 - QDR
Bit 3 - FDR10
Bit 4 - FDR
Bit 5 - EDR
[Internal]Bit 6 - HDR
[Internal]Bit 7 - NDR */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t ib_proto_capability;
	/* Description - ib_link_width <= ib_proto_capability
Bit 0 - 1x
Bit 1 - 2x
Bit 2 - 4x
Bit 3 - 8x
Bit 4 - 12x */
	/* 0x10.16 - 0x10.31 */
	 u_int16_t ib_link_width_capability;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - FC port speed/protocols bitmask */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t fc_proto_admin;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Ethernet port speed/protocols bitmask */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t eth_proto_admin;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - InfiniBand port speed bitmask */
	/* 0x1c.0 - 0x1c.15 */
	 u_int16_t ib_proto_admin;
	/* Description - InfiniBand port link width bitmask */
	/* 0x1c.16 - 0x1c.31 */
	 u_int16_t ib_link_width_admin;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - FC port speed/protocols bitmask */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t fc_proto_oper;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Ethernet port speed/protocols bitmask */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t eth_proto_oper;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - InfiniBand port speed bitmask */
	/* 0x28.0 - 0x28.15 */
	 u_int16_t ib_proto_oper;
	/* Description - InfiniBand port link width bitmask */
	/* 0x28.16 - 0x28.31 */
	 u_int16_t ib_link_width_oper;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - Ethernet port's link partner advertised protocols. Returns the protocols 
that were advertised by the link partner during auto-negotiation. */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t eth_proto_lp_advertise;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_pmlp_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - unmap local port
1 - x1 (lane 0 is used)
2 - x2 (lanes 0,1 are used)
4 - x4 (lanes 0,1,2 and 3 are used)
Other - reserved */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t width;
	/* Description - Local port number. */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
	/* Description - Use different configuration for RX and TX.
If this bit is cleared, the TX value is used for both RX and TX. When set, 
the RX configuration is taken from the separate field. This is to enable 
backward compatible implementation. */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rxtx;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Module SerDes for lane <i>
Up to 4 SerDeses in a module can be mapped to a local port. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t lane0_module_mapping;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Module SerDes for lane <i>
Up to 4 SerDeses in a module can be mapped to a local port. */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t lane1_module_mapping;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Module SerDes for lane <i>
Up to 4 SerDeses in a module can be mapped to a local port. */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t lane2_module_mapping;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Module SerDes for lane <i>
Up to 4 SerDeses in a module can be mapped to a local port. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t lane3_module_mapping;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_register_mfbe {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Flash Select */
	/* 0x0.4 - 0x0.5 */
	 u_int8_t fs;
	/* Description - Parallel */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t p;
	/* Description - erase a 64KB bulk */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t bulk_64kb_erase;
	/* Description - erase a 32KB bulk */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t bulk_32kb_erase;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - address in bytes */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t address;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_register_mfba {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Flash Select */
	/* 0x0.4 - 0x0.5 */
	 u_int8_t fs;
	/* Description - Parallel */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t p;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Transaction size */
	/* 0x4.0 - 0x4.8 */
	 u_int16_t size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - address in bytes */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t address;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x2c.31 */
	 struct connectib_register_access_data data;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_register_mfpa {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Flash Select */
	/* 0x0.4 - 0x0.5 */
	 u_int8_t fs;
	/* Description - Parallel */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t p;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - address in bytes */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t boot_address;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - number of flash devices connected */
	/* 0x10.0 - 0x10.3 */
	 u_int8_t flash_num;
	/* Description - supports 64KB bulk erase operation */
	/* 0x10.29 - 0x10.29 */
	 u_int8_t bulk_64kb_erase_en;
	/* Description - supports 32KB bulk erase operation */
	/* 0x10.30 - 0x10.30 */
	 u_int8_t bulk_32kb_erase_en;
	/* Description - reflection of wip bit from flash */
	/* 0x10.31 - 0x10.31 */
	 u_int8_t wip;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Flash JEDEC ID */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t jedec_id;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Flash sectore size */
	/* 0x18.0 - 0x18.9 */
	 u_int16_t sector_size;
	/* Description -  */
	/* 0x18.16 - 0x18.23 */
	 u_int8_t block_allignment;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - capability mask ;bit 0:Parallel flash Support;else:Reserved  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t capability_mask;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_db_threshold_register_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Required upper watermark.
When FIFO/buffer reaches this size- an event will be sent */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t threshold;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Current FIFO/buffer size */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t size;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_register_pplr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - local port number */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - external loopback enable (default - disabled) */
	/* 0x4.2 - 0x4.2 */
	 u_int8_t exl;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_register_host_endianness {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0
:
 LITTLE
_
ENDIAN
1
:
 BIG
_
ENDIAN */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t he;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_register_fp_sl_map {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - If bit [i] of the register is set, SL[i] is a fast path SL */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t fp_sl_indication;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_register_power_settings {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0x0 - minimum power (maximum latency penalty)
0x1-0xfe - reserved
0xff - maximum power (minimum latency penalty) */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t power_settings_level;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_register_loopback_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 1 - port 1
2 - port 2
255 - both ports
otherwise - reserved */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t port;
	/* Description - When set, the HCA will always send packets meant for the same port to wire, 
rather than perform internal loopback */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t no_lb;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_pfcc_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - S
end to higher layers operation:
0 - Pause and PFC are handled by the port (default)
1 - Pause and PFC are handled by the port and are also been send to 
higher layers.
Only valid if 
shl_cap
 = 1. */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t shl_opr;
	/* Description - S
end to higher layers capabilities:
0 - No capability of sending Pause and PFC to higher layers
1 - Device has capability of send Pause and PFC to higher layers
NOTE: This relates to IEEE 802.3 PAUSE and IEEE 802.3 PFC. */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t shl_cap;
	/* Description - Port number access type. determines the way 
local_port
 
is interpreted:
0 - Local port number
1 - IB / label port number
[Internal] 3 - Out of band / PCI
 */
	/* 0x0.14 - 0x0.15 */
	 u_int8_t pnat;
	/* Description - Local port number. */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
	/* Description - Indicates if operation of remote admin parameters (
dcxb_operation_
type
 0x2) is supported. */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t cap_remote_admin;
	/* Description - Indicates if operation of local admin parameters (
dcxb_operation_type
 
0x1) is supported. */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t cap_local_admin;
	/* Description - The Operation type, valid only on HCAs.
0x0: local operative parameters.
0x1: local admin parameters. Supported only when 
cap_local_ad
min==1
.
0x2: remote admin parameters. Supported only when 
cap_remote_ad
min==1
.
Only 
pfctx
 and 
pfcrx
 are supported on remote device */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t dcbx_operation_type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Bit per prio indicating if RX flow control policy should be updated 
based on bit 
pfcrx
. */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t prio_mask_rx;
	/* Description - Bit per prio indicating if TX flow control policy should be updated 
based on bit 
pfctx
. */
	/* 0x4.16 - 0x4.23 */
	 u_int8_t prio_mask_tx;
	/* Description - Pause policy auto negotiation
0: disabled - generate and ignore pause frames based on pptx, pprx
1: enabled - when auto-negotiation is performed, set the pause policy 
based on the auto-negotiation resolution.
Note - The auto-negotiation advertisement is set according to pptx, 
pprx.
Note - When PFC is set on the TX / RX ppan must be set to 0. */
	/* 0x4.28 - 0x4.31 */
	 u_int8_t ppan;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Credit based flow control policy on TX[7:0]. Per TClass bit mask:
0 - never generate flow control credit frames on the specified TClass 
(default)
1 - generate flow control credit frames according to RX buffer state on 
the specified TClass
pfctx
, 
pptx
 and 
cbftx
 must be mutual exclusive (i.e. only one of them 
at most can be set). */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t cbftx;
	/* Description - Valid only on HCAs.
The bit is set if the device has passed the device_stall_critical_water
mark (for global flow control or any priority when using priority flow 
control) and has become stalled. 
When fctx_disabled is set, the device won't send flow control and pri
ority flow control (PFC) packets. */
	/* 0x8.8 - 0x8.8 */
	 u_int8_t fctx_disabled;
	/* Description - Priority based flow control policy on TX[7:0]. Per priority bit mask:
0 - never generate pause frames on the specified priority (default)
1 - generate pause frames according to RX buffer threshold on the 
specified priority
pfctx
, 
pptx
 must be mutually exclusive (for example, only one of them 
at most can be set). */
	/* 0x8.16 - 0x8.23 */
	 u_int8_t pfctx;
	/* Description - Active (operational) pause policy on TX
0 - do not generate pause frames
1 - generate pause frames according to RX buffer threshold */
	/* 0x8.30 - 0x8.30 */
	 u_int8_t aptx;
	/* Description - Admin pause policy on TX (see also 
pfctx
):
0 - never generate pause frames (default)
1 - generate pause frames according to RX buffer threshold */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t pptx;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Credit based flow control policy in RX[7:0]. Per TClass bit mask:
0 - ignore incoming flow control credit frames on the specified TClass 
(default)
1 - respect flow control credit frames according to RX buffer state on 
the specified TClass */
	/* 0xc.0 - 0xc.7 */
	 u_int8_t cbfrx;
	/* Description - Priority based flow control policy on RX[7:0]. Per priority bit mask:
0 - ignore incoming pause frames on the specified priority (default)
1 - respect incoming pause frames on the specified priority */
	/* 0xc.16 - 0xc.23 */
	 u_int8_t pfcrx;
	/* Description - Active (operational) pause policy on RX
0 - ignore received pause frames
1 - respect received pause frames */
	/* 0xc.30 - 0xc.30 */
	 u_int8_t aprx;
	/* Description - Admin pause policy on RX (see also 
pfcrx
):
0 - ignore received pause frames (default)
1 - respect received pause frames */
	/* 0xc.31 - 0xc.31 */
	 u_int8_t pprx;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Valid only on HCAs (When 
rx_activity 
is set).
The maximum period for a single received packet processing, if the 
packet wasnot processed during this time, the device will be declared 
as stalled and will increase the 
device_stall_critical_watermark_cnt 
(PPCNT) 
counter. Value given in mSec, The maximum period is 8 
sec. 
The special value of 0, indicates that the 
device_stall_critical_water
mark
 is inactive.
Range: 0x0050 - 0x1F40 */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t device_stall_critical_watermark;
	/* Description - Valid only on HCAs (When 
rx_activity 
is set).
The maximum period for a single received packet processing, if the 
packet wasn't processed during this time, the device will increase the 
device_stall_minor_watermark_cnt (PPCNT)
. Value given in mSec, 
The maximum period is 8 sec. 
The special value of 0, indicates that the 
device_stall_minor_water
mark
 is inactive.
Range: 0x0050 - 0x1F40 */
	/* 0x10.16 - 0x10.31 */
	 u_int16_t device_stall_minor_watermark;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_access_register_unit_port_capabilities {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - manually added, for reserved equal zero test */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t reserved_1;
	/* Description - local port number */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
	/* Description - manually added, for reserved equal zero test */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t reserved_0;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - sets port info capability mask, specifies the supported capabilities of the node. A bit set to 1 for affirmation of supported capability */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t port_capabilities_127_96;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t port_capabilities_95_64;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t port_capabilities_63_32;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t port_capabilities_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_register_unit_perf_counters_global_ctrl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0x0 - stop counting in all performance counters
0x1 - start counting in all performance counters 
Otherwise - reserved */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t cmd;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_access_register_unit_perf_counters_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_access_register_unit_perf_counters_data_line counter[8];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_access_register_unit_perf_counters_cfg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_access_register_unit_perf_counters_cfg_line counter[8];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_register_set_node {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_node_description node_description;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_dcbx_app_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Physical port number.
This field is reserved when HCA_CAP.num_ports ==1. 
 See Table 739, 
"
QUERY_HCA_CAP Input Structure Layout
," on page 801 */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t port_number;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.5 */
	 u_int8_t num_app_prio;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Application priority entry. */
	/* 0x10.0 - 0x14.31 */
	 struct connectib_application_prio_entry app_prio[1];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_dcbx_param_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The maximum size of DCBX application table. */
	/* 0x0.0 - 0x0.5 */
	 u_int8_t max_application_table_size;
	/* Description - Physical port number.
This field is reserved when HCA_CAP.num_ports ==1. 
 See Table 739, 
"
QUERY_HCA_CAP Input Structure Layout
," on page 801 */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t port_number;
	/* Description - If set, device supports DCBX on standby mode (aux power). */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t dcbx_standby_cap;
	/* Description - If set, DCBX IEEE version is supported. */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t dcbx_ieee_cap;
	/* Description - If set, DCBX CEE version is supported. */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t dcbx_cee_cap;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Set the DCBX version.
0x0: disabled- host is in charge 
0x1: CEE - supported only when dcbx_cee_cap==1
0x2: IEEE - supported only when dcbx_ieee_cap==1
0x3: CEE_and_IEEE - CEE and IEEE auto select. When using this mode, 
the device uses IEEE mode. If handshake with other party succeed, it will 
continue on using IEEE, otherwise it will fall back to CEE. Supported only 
when dcbx_cee_cap==1 and cbx_ieee_cap==1. */
	/* 0x4.0 - 0x4.2 */
	 u_int8_t version_admin;
	/* Description - 0x0: disabled - host is in charge.
0x1: CEE_enabled
0x2: IEEE_enabled
If the DCBX_PARAM.version_oper is 0x0, all oper and remote fields in 
DCBX_PARAM () are invalid. DCBX_APPLICATION.num_app_prio is 0
DCBX_PARAM.version is 0x0 until a successful handshake with remote 
party. */
	/* 0x4.8 - 0x4.10 */
	 u_int8_t version_oper;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Number of TCs. */
	/* 0x8.0 - 0x8.3 */
	 u_int8_t num_of_tc_admin;
	/* Description - Number of TCs - operational state after negotiation with remote party
. */
	/* 0x8.8 - 0x8.11 */
	 u_int8_t num_of_tc_oper;
	/* Description - Number of traffic classes that may simultaneously support PFC. Can be set 
in the range 0 8 */
	/* 0x8.16 - 0x8.19 */
	 u_int8_t pfc_cap_admin;
	/* Description - Number of traffic classes that may simultaneously support PFC. Can be set 
in the range 0 8 - operational state after negotiation with remote party. */
	/* 0x8.24 - 0x8.27 */
	 u_int8_t pfc_cap_oper;
	/* Description - 0x0: non
_
w
illing
0x1: willing */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t willing_admin;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Remote side's number of TCs. Valid only after negotiation with remote 
party. */
	/* 0xc.0 - 0xc.3 */
	 u_int8_t remote_num_of_tc;
	/* Description - Remote side's number of traffic classes that may simultaneously support 
PFC. Valid only after negotiation with remote party. */
	/* 0xc.24 - 0xc.27 */
	 u_int8_t remote_pfc_cap;
	/* Description - Remote side's willing state. Valid only after negotiation with remote party */
	/* 0xc.31 - 0xc.31 */
	 u_int8_t remote_willing;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Bitmask indicates errors reported.
Bit 0: not enough TC to comply with remote 
Bit 1: not enough pfc to comply with remote 
Bit 2: TSA unsupported */
	/* 0x10.0 - 0x10.7 */
	 u_int8_t error;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_mlcr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Led type (only supported when cap_local_or_uid_only==1.)
0: LOCALP_AND_UID - local port and uid
1: UID 
2: LOCALP - local port */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t led_type;
	/* Description - If set, led_type of type UID and LOCAL Port only are supported. */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t cap_local_or_uid_only;
	/* Description - Local port number
Not supported for CPU port
(only supported only when cap_local_or_uid_only==1.) */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Duration of the beacon to be active, units of seconds
The value of 0x0 will turn off the beacon
The value of 0xffff will set the beacon to infinity */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t beacon_duration;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Remaining duration of the beacon, units of seconds
The value of 0xffff means infinity */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t beacon_remain;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_qhll {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Local port */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - HLL Timeout value
HLL Timeout = 4.096uSec * 2^
hll_time
Values of 20-31 indicate HLL is disabled */
	/* 0x4.0 - 0x4.4 */
	 u_int8_t hll_time;
	/* Description - B
itmask per TC/VL. When a bit is set, the appropriate TC/VL will 
not be subject to HLL timeout. */
	/* 0x4.24 - 0x4.31 */
	 u_int8_t hll_mask;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Stall count. Number of consecutive HLL discarded packets 
required to enter the Stall-State.
Range 1..7
Reserved when 
stall_en
 = 0 */
	/* 0x8.0 - 0x8.2 */
	 u_int8_t stall_cnt;
	/* Description - Stall state enable
0x0 - Stall state disabled
0x1 - Stall state enabled (default) */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t stall_en;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_qtct_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Priority */
	/* 0x0.0 - 0x0.2 */
	 u_int8_t prio;
	/* Description - Physical port number.
This field is reserved when HCA_CAP.num_ports ==1. 
 See Table 739, 
"
QUERY_HCA_CAP Input Structure Layout
," on page 801 */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t port_number;
	/* Description - Indicates if operation_type==remote_admin_parameters is supported. */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t cap_remote_admin;
	/* Description - Indicates if operation_type==local_admin_parameters is supported */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t cap_local_admin;
	/* Description - Operation type.
0x0: local_operative_parameters
0x1: local_admin_parameters - Supported only when cap_local_admin==1
0x2: remote_admin_parameters- Supported only when cap_remote_ad
min==1 */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t operation_type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - TClass used for priority=<prio>.
Default values are: tclass[prio=0]=1, tclass[prio=1]=0, tclass[prio=i]=i (for 
i>1). */
	/* 0x4.0 - 0x4.2 */
	 u_int8_t tclass;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_qpdp_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Physical port number.
This field is reserved when HCA_CAP.num_ports ==1. 
 See Table 739, 
"
QUERY_HCA_CAP Input Structure Layout
," on page 801
. */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t port_number;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Default port priority (default 0) */
	/* 0x4.0 - 0x4.2 */
	 u_int8_t pprio;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_qetcr_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Physical port number.
This field is reserved when HCA_CAP.num_ports ==1. See 
Table 772, 
"
QUERY_HCA_CAP Input Structure Layout
," on page 851 */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t port_number;
	/* Description - Indicates if operation_type==remote_admin_parameters is supported. */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t cap_remote_admin;
	/* Description - Indicates if operation_type==local_admin_parameters is supported */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t cap_local_admin;
	/* Description - Operation type.
0x0: local operative parameters.
0x1: local admin parameters. Supported only when cap_local_admin==1.
0x2: remote admin parameters. Supported only when cap_remote_ad
min==1.
 */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t operation_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Per-tclass configuration. For details, 
 See Table 378, "
ETS tcN Configu
ration Register Layout
," on page 581
. */
	/* 0x8.0 - 0x48.31 */
	 struct connectib_tc_qos_configuration tc[8];
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - Global configuration. For details, refer to 
Table 380, "
ETS Global 
Configuration Register Layout
"
. */
	/* 0x48.0 - 0x50.31 */
	 u_int64_t global_configuration;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_pcam_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Access Register ID groups
0 - RegID 0x5000 -
 
0x507F
1-255 - Reserved */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t access_reg_group;
	/* Description - Feature list mask index: 
0 - enhanced features 
1-255 - Reserved */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t feature_group;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Supported port's access register bitmaks. Based on 
access_reg_group 
index.
When bit is set , The register is supported in the device. 
When 
access_reg_group == 0
 :
Bit 0 - 0x5000 
Bit 1 - 0x5001 (
PCAP)
Bit 2 - 0x5002 (PMLP)
Bit 3 - 0x5003 (PMTU)
Bit 4 - 0x5004 (PTYS)
.
,
Bit 127-
 
0x507F (PCAM) */
	/* 0x8.0 - 0x18.31 */
	 u_int32_t port_access_reg_cap_mask[4];
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Supported port's enhanced features. Based on 
feature_group
 
index.
When bit is set , The feature is supported in the device: 
Bit 0 - PPCNT counter group: Phy statistical counter group 
Bit 1 - PPCNT counter group: Discard counter group 
Bit 2:255 - Reserved */
	/* 0x28.0 - 0x38.31 */
	 u_int32_t feature_cap_mask[4];
};

/* Description -   */
/* Size in bytes - 72 */
struct connectib_mcam_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Access Register ID groups 
0 - Fi REG_ID */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t access_reg_group;
	/* Description - Feature list mask index : 
0 - enfeatures */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t feature_group;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Supmanagement's access register bitmaks.
Based on 
access_reg_group 
index.
 
When bit is set , The register is supported in the device. 
Bit 1 - MFCR (0x9001)
Bit 2 - MFSC (0x9002)
BiFSM (0x9003)
Bit 4 - MFSL (0x9004)
Bit 127- MCAP (0x907F) */
	/* 0x8.0 - 0x18.31 */
	 u_int32_t mng_access_reg_cap_mask[4];
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Supported port's enhanced features.
Based on 
feature_group
 
index.
When bit is set , The feature is supported in the device: 
Bit 0 - 
MPCNT counter group: 
PCIE performance counters supported */
	/* 0x28.0 - 0x38.31 */
	 u_int32_t mng_feature_cap_mask[4];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_ib_gid {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 u_int32_t dword[4];
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_dmfs_encap_meta {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.2 */
	 u_int8_t header_type;
	/* Description -  */
	/* 0x4.6 - 0x4.15 */
	 u_int16_t encap_size;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_flow_counter_fw_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - counts how many FTEs count on this counter */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t src_gvmi;
	/* Description -  */
	/* 0x4.24 - 0x4.30 */
	 u_int8_t ft_type;
	/* Description -  */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t ft_type_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t mac;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t next_flow_counter;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t prev_flow_counter;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_l2_table_entry_fw_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_mac_address_layout mac;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - ethernet vlan */
	/* 0x8.0 - 0x8.11 */
	 u_int16_t vlan;
	/* Description - when set to 1, vlan field is valid.
when set to 0, vlan field isn't valid - only mac. */
	/* 0x8.12 - 0x8.12 */
	 u_int8_t vlan_valid;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t hw_rx_ix;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t hw_sx_ix;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_dmfs_fte_meta {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t external_dest_vport;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t internal_dest_vport;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t uc_match_exists;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t mc_match_exists;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t src_port_ext_match_exists;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t fte_use_iterator;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - HW iterator for multiple flow destinations */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t dest_iter_ix;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t vst_dealloc_hash_ix;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t vst_dealloc_ste_ix;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_dmfs_ft_meta {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  0: INVALID
 1: FT_NIC_TRANSMIT
 2: FT_ESW_EGRESS
 3: FT_ESW_INGRESS
 4: FT_ESW_FDB */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t table_type;
	/* Description -  */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t log2_table_size;
	/* Description - location in table chaining hierarchy
level 0x0 is the root table */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t level;
	/* Description - FT is the root FT */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t ft_is_root;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - total num of flows points to this flow table */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t total_ref_count;
	/* Description - valid only for ESW ingress/egress flow table */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t vport_num;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t prev_ft;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t next_ft;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - first group_id in flow table */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t groups_list_head;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - num of groups member in this flow table */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t groups_member_count;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t ft_rx_head_ix;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t ft_sx_head_ix;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x20.23 */
	 u_int32_t next_table_id;
	/* Description -  */
	/* 0x20.24 - 0x20.27 */
	 u_int8_t table_miss_mode;
	/* Description -  */
	/* 0x20.29 - 0x20.29 */
	 u_int8_t lag_demux;
	/* Description -  */
	/* 0x20.30 - 0x20.30 */
	 u_int8_t decap_en;
	/* Description -  */
	/* 0x20.31 - 0x20.31 */
	 u_int8_t encap_en;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - total number of FGs that were inserted to RX HW tables */
	/* 0x24.0 - 0x24.15 */
	 u_int16_t fgs_in_rx_hw_count;
	/* Description - total number of FGs that were inserted to SX HW tables */
	/* 0x24.16 - 0x24.31 */
	 u_int16_t fgs_in_sx_hw_count;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_dmfs_fg_meta {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - counting rules member in group */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  0: INVALID
 1: FT_NIC_TRANSMIT
 2: FT_ESW_EGRESS
 3: FT_ESW_INGRESS
 4: FT_ESW_FDB */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t table_type;
	/* Description -  */
	/* 0x4.8 - 0x4.31 */
	 u_int32_t table_id;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Bitmask representing which of the headers and parameters in match_criteria are used in defining the Flow */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t match_criteria_enable;
	/* Description - group belongs to RX NIC FT, and include vlan match */
	/* 0x8.8 - 0x8.8 */
	 u_int8_t vlan_match_exist;
	/* Description - group exists in the RX HW steering tables (have at least one FTE) */
	/* 0x8.9 - 0x8.9 */
	 u_int8_t in_rx_hw;
	/* Description - group exists in the SX HW steering tables (have at least one FTE) */
	/* 0x8.10 - 0x8.10 */
	 u_int8_t in_sx_hw;
	/* Description - valid only for ESW ingress/egress flow table */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t vport_num;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t start_flow_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t end_flow_index;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t prev_group_id;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t next_group_id;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t vst_root_hash_meta_ix;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t rx_root_hash_meta_ix;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t sx_root_hash_meta_ix;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t rx_end_ste_ix;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t sx_end_ste_ix;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - number of FTEs in the RX FG that aren't used in HW */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t unused_ftes_in_rx_count;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - number of FTEs in the SX FG that aren't used in HW */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t unused_ftes_in_sx_count;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_mkey_dump {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t ready_4_dump;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_fw_tis {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Defines the desired TX LAG port number. If 0 the device will assign a proper value */
	/* 0x4.0 - 0x4.3 */
	 u_int8_t lag_tx_port_affinity;
	/* Description - If set, the TIS is not subject to LAG TX port remapping */
	/* 0x4.4 - 0x4.4 */
	 u_int8_t strict_lag_tx_port_affinity;
	/* Description -  */
	/* 0x4.12 - 0x4.15 */
	 u_int8_t prio;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t sqn_head;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t transport_domain;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t underlay_qpn;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_fw_tir {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - valid only for direct tir */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t inline_rqn;
	/* Description - 0 - Direct
1 - Indirect */
	/* 0x4.24 - 0x4.27 */
	 u_int8_t disp_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t lro_max_ip_payload_size;
	/* Description -  */
	/* 0x8.8 - 0x8.11 */
	 u_int8_t lro_enable_mask;
	/* Description -  */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t lro_timeout_period_usecs;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - valid only for indirect tir */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t rqt_number;
	/* Description - 0 - HASH_NONE
1 - HASH_INVERTED_XOR8
2 - HASH_TOEPLITZ */
	/* 0xc.24 - 0xc.27 */
	 u_int8_t rx_hash_fn;
	/* Description -  */
	/* 0xc.28 - 0xc.28 */
	 u_int8_t tunneled_offload_en;
	/* Description -  */
	/* 0xc.30 - 0xc.30 */
	 u_int8_t rx_hash_symmetric;
	/* Description -  */
	/* 0xc.31 - 0xc.31 */
	 u_int8_t steering_start_pipe;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - This field sets which outer or the only packets headers fields should be */
	/* 0x10.0 - 0x14.31 */
	 struct connectib_rx_hash_field_select rx_hash_field_selector_outer;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - This field sets which outer or the only packets headers fields should be */
	/* 0x14.0 - 0x18.31 */
	 struct connectib_rx_hash_field_select rx_hash_field_selector_inner;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t transport_domain;
	/* Description -  */
	/* 0x18.24 - 0x18.25 */
	 u_int8_t self_lb_block;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x40.31 */
	 struct connectib_tir_dmfs dmfs;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_fw_qpc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - shared between fw_qpc_special unions, must move together! 
Transport Service Type:
0x0 - RC
0x1 - UC
0x2 - UD
0x3 - XRC
0x4 - MLX
0x5 - DCI/DCI
0x6 - DCT
0x7 - QP0
0x8 - QP1
0x9 - Raw Ethernet
0xA - Raw IPv6
0xB - Sniffer
0xC - SYNC_UMR
0xD - PTP1588
other: reserved
Note: QPs of types QP0 and QP1 have the same properties as UD QP. There can be at most one for each type per port
QPs of types Raw Ethernet, Raw IPv6, Sniffer and PTP1588 have the same properties as MLX QP. There can be at most one for each type per port
QP of types SYNC_UMR have the same properties as UD QP. There can be at most one such QP per device */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t sw_st;
	/* Description -  */
	/* 0x4.8 - 0x4.10 */
	 u_int8_t sw_rwq_type;
	/* Description -  */
	/* 0x4.11 - 0x4.11 */
	 u_int8_t no_sq;
	/* Description -  */
	/* 0x4.12 - 0x4.13 */
	 u_int8_t sw_rq_type;
	/* Description -  */
	/* 0x4.14 - 0x4.14 */
	 u_int8_t qp_dual_write;
	/* Description -  */
	/* 0x4.15 - 0x4.15 */
	 u_int8_t ack_fence_req;
	/* Description - in nak flow, qp flush will wait till nak2ack slice is done */
	/* 0x4.16 - 0x4.23 */
	 u_int8_t ack_slice_to_fence;
	/* Description -  */
	/* 0x4.24 - 0x4.26 */
	 u_int8_t min_wqe_inline_mode;
	/* Description - If Set, posting multi packet send wqes are allowed on this SQ */
	/* 0x4.27 - 0x4.27 */
	 u_int8_t allow_multi_pkt_send_wqe;
	/* Description - xrq offload is nvme */
	/* 0x4.28 - 0x4.28 */
	 u_int8_t is_connected_to_nvme_xrq;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - original timer value requested by SW */
	/* 0x8.0 - 0x8.4 */
	 u_int8_t sw_timer_granularity;
	/* Description -  */
	/* 0x8.5 - 0x8.9 */
	 u_int8_t current_timer_granularity;
	/* Description -  */
	/* 0x8.10 - 0x8.10 */
	 u_int8_t one_side_flush;
	/* Description - APM - automatic path migration - path validation failed
send EVENT_TYPE_PATH_MIG_FAIL only once per migration cycle */
	/* 0x8.11 - 0x8.11 */
	 u_int8_t apm_path_validation_failed;
	/* Description -  */
	/* 0x8.12 - 0x8.12 */
	 u_int8_t cd_slave_send;
	/* Description -  */
	/* 0x8.13 - 0x8.13 */
	 u_int8_t cd_slave_receive;
	/* Description -  */
	/* 0x8.14 - 0x8.14 */
	 u_int8_t cd_master;
	/* Description -  */
	/* 0x8.15 - 0x8.15 */
	 u_int8_t sqd_on_sigerr;
	/* Description -  */
	/* 0x8.16 - 0x8.19 */
	 u_int8_t sl_diff_new_sl;
	/* Description - original max read atomic */
	/* 0x8.20 - 0x8.22 */
	 u_int8_t fw_max_read_atomic;
	/* Description - sw or fw ownership of the cq */
	/* 0x8.23 - 0x8.23 */
	 u_int8_t hca_sq_owner;
	/* Description - indicate command is waiting. indicate the slot num. */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t cmdif_entry_ix;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 union connectib_fw_qpc_ts_special fw_qpc_ts_special;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x20.31 */
	 struct connectib_fw_qpc_q responder;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x30.31 */
	 struct connectib_fw_qpc_q requestor;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x40.31 */
	 union connectib_fw_qpc_special fw_qpc_special;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_fw_srqc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t catas_event_generated;
	/* Description -  */
	/* 0x4.1 - 0x4.1 */
	 u_int8_t basic_cyclic_rcv_wqe;
	/* Description -  */
	/* 0x4.2 - 0x4.2 */
	 u_int8_t invalid_user_index;
	/* Description -  */
	/* 0x4.3 - 0x4.3 */
	 u_int8_t end_padding_mode;
	/* Description - bit per reason.
0x0 - reserved
0x1 - SET LIMIT */
	/* 0x4.12 - 0x4.15 */
	 u_int8_t trap_reason;
	/* Description - (fw_trap_reason = SET_LIMIT) -> limit value */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t trap_data;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - valid for memory_rq (non connector_rq) */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t no_lro_qpn;
	/* Description - valid for eth memory_rq only */
	/* 0x10.24 - 0x10.31 */
	 u_int8_t memory_rq_state;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - valid for xrq only */
	/* 0x20.0 - 0x40.31 */
	 struct connectib_fw_xrqc xrq;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_sw_ads {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Index to pkey table
Reserved for RoCE.
For RoCE index 0, which contains the default PKEY: 
0xFFFF, is chosen automatically */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t pkey_index;
	/* Description - When set, packets sent using this QP are marked for free 
adaptive routing. On IB wire, it is marked in LRH and BTH.
For RoCE, it is marked in BTH. Supported only for UD and 
UC transports. */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t free_ar;
	/* Description - Force loopback */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t fl;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Remote LID.
Reserved when fl==1.
Reserved for RoCE. */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t rlid;
	/* Description - LMC bits of LID 
Reserved for RoCE. */
	/* 0x4.16 - 0x4.22 */
	 u_int8_t mlid;
	/* Description - Use GRH
For InfiniBand, if set, GRH will be placed in the packet 
header, if clear, no GRH.
Reserved for RoCE. */
	/* 0x4.23 - 0x4.23 */
	 u_int8_t grh;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - For IB and RoCE version 1.0: GRH Hop Limit.
For RRoCE: IPv6 hop limit or IPv4 TTL */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t hop_limit;
	/* Description - Maximum static rate control.
0: no_limit - no limit on static rate (100% port speed)
1-6: reserved
7: Gbps_2.5
8: Gbps_10
9: Gbps_30
10: Gbps_5
11: Gbps_20
12: Gbps_40
13: Gbps_60
14: Gbps_80
15: Gbps_120 */
	/* 0x8.8 - 0x8.11 */
	 u_int8_t stat_rate;
	/* Description - Retry Timeout Multiplier. ACK timeout will be multiplied 
by 2^
log_rtm
 every consecutive retry. See 
"
Exponential 
Backoff Timer
" */
	/* 0x8.12 - 0x8.15 */
	 u_int8_t log_rtm;
	/* Description - For InfiniBand: Index to Address Table in the port to get 
source GID address.
For RoCE: index to Address table to get the source GID/IP 
and MAC address, VLAN ID, IP Type (IPV4, IPv6) and 
RoCE type. */
	/* 0x8.16 - 0x8.23 */
	 u_int8_t src_addr_index;
	/* Description - Ack timeout timer for activation of retransmission mecha
nism. If zero - timeout is disabled. timeout is 4.096 uS 
*2^(ack_timeout)/ */
	/* 0x8.27 - 0x8.31 */
	 u_int8_t ack_timeout;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - IPv6 Flow Label */
	/* 0xc.0 - 0xc.19 */
	 u_int32_t flow_label;
	/* Description - For InfiniBand and RoCE v1.0: GRH TClass */
	/* 0xc.20 - 0xc.27 */
	 u_int8_t tclass;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Remote GID/IP address.
For IB port - Valid if the GRH bit is set.
For an Ethernet port for RoCE mode, this field must always 
be valid and contain the remote GID address.
For an Ethernet port for R-RoCE mode, this field contains 
IPv4 or IPv6 depending on the IP type which appears in 
RoCE Address table entry pointed by src_addr_index field: 
for IP type == IPV4 then rgid/rip bits [31:0] specify the 
remote IPv4 address and rgid/rip bits [127:32] are reserved, 
when L3 header type == IPV6 rgid/rip bits [127:0] contains 
an IPv6 address. */
	/* 0x10.24 - 0x20.23 */
	 u_int8_t rgid_rip[16];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - For R-RoCE v2.0 RC/UC QPs: UDP source port.
must belong to the range: [QUERY_HCA_CAP. r_roce_ud
p_src_port_range_min-QUERY_HCA_CAP. r_roce_udp_s
rc_port_range_max]. 
 See Section 743, "
HCA Capabilities 
Layout
," on page 804 */
	/* 0x20.0 - 0x20.15 */
	 u_int16_t udp_sport;
	/* Description - For R-RoCE: IP DSCP
This field is reserved when QP supports only RoCE v1.0. */
	/* 0x20.16 - 0x20.21 */
	 u_int8_t dscp;
	/* Description - For R-RoCE: IP ECN 
This field is reserved when QP supports only RoCE v1.0. */
	/* 0x20.22 - 0x20.23 */
	 u_int8_t ecn;
	/* Description - Force Ethernet user priority for UD/DC RoCE QPs.
When set take Ethernet priority from QP"s Address Path and 
not from send WQE.
Note: When f_eth_prio is enabled but send WQE points to 
RoCE Address Table entry with vlan_valid disabled, priority 
tagged frame is created and Ethernet priority and DEI/CFI 
fields are taken from QP"s Address Path. */
	/* 0x20.24 - 0x20.24 */
	 u_int8_t f_eth_prio;
	/* Description - Force IP ECN only for UD/DC RoCE QPs.
Take IP ECN field from QPC and not from send WQE.
When QP can generate only RoCE v.1 packets this field is 
reserved. */
	/* 0x20.26 - 0x20.26 */
	 u_int8_t f_ecn;
	/* Description - Force IP DSCP for UD/DC QPs.
Take IPv4/IPv6 DSCP field from QPC and not from send 
WQE.
When QP can generate only RoCE v.1 packets this field is 
reserved. */
	/* 0x20.27 - 0x20.27 */
	 u_int8_t f_dscp;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Upper bits of remote MAC address.
Valid only for RoCE QPs. */
	/* 0x24.0 - 0x24.15 */
	 u_int16_t rmac_47_32;
	/* Description - port number */
	/* 0x24.16 - 0x24.23 */
	 u_int8_t port;
	/* Description - InfiniBand: Service Level (SL) */
	/* 0x24.24 - 0x24.27 */
	 u_int8_t sl;
	/* Description - Ethernet Priority (PCP).
Reserved for InfiniBand. */
	/* 0x24.28 - 0x24.30 */
	 u_int8_t eth_prio;
	/* Description - DEI/CFI field.
For UD/DCI QP, DEI/CFI
,
 field is taken from UD Address 
Vector of the send WQE with the following exception:
when f_eth_prio is enabled and send WQE points to RoCE 
Address Table entry with vlan_valid disabled. priority 
tagged frame is created and DEI/CFI is taken from QP"s 
Address Path.
Reserved for InfiniBand and for RoCE UD/DCI QP with 
AP.f_eth_prio disabled. */
	/* 0x24.31 - 0x24.31 */
	 u_int8_t dei_cfi_reserved_from_prm_041;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Lower bits of remote MAC address.
Valid only for RoCE QPs. */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t rmac_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_msix_ext_context {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t mask_3_0;
	/* Description -  */
	/* 0x0.4 - 0x0.7 */
	 u_int8_t disable_3_0;
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t need;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.19 */
	 u_int32_t timestamp_51_32;
	/* Description -  */
	/* 0x8.20 - 0x8.31 */
	 u_int16_t min_wait;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t timestamp_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_msix_context {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.2 - 0x0.31 */
	 u_int32_t addr_31_2_;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t addr_63_32_;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 union connectib_hw_msix_context_data data;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.0 */
	 u_int8_t spec_mask;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hw_rdb_atomic_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 u_int32_t atomic_data[8];
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_hw_mtt2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t hi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t lo;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_hw_mtt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t pas_63_32;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t rd_en;
	/* Description -  */
	/* 0x4.1 - 0x4.1 */
	 u_int8_t wr_en;
	/* Description -  */
	/* 0x4.3 - 0x4.31 */
	 u_int32_t pas_31_3;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_steering_qp_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_steering_qp_entry steering_qp_entry0;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_steering_qp_entry steering_qp_entry1;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 struct connectib_steering_qp_entry steering_qp_entry2;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 struct connectib_steering_qp_entry steering_qp_entry3;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 struct connectib_steering_qp_entry steering_qp_entry4;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 struct connectib_steering_qp_entry steering_qp_entry5;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 struct connectib_steering_qp_entry steering_qp_entry6;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 struct connectib_steering_qp_entry steering_qp_entry7;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x24.31 */
	 struct connectib_steering_qp_entry steering_qp_entry8;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 struct connectib_steering_qp_entry steering_qp_entry9;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x2c.31 */
	 struct connectib_steering_qp_entry steering_qp_entry10;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x30.31 */
	 struct connectib_steering_qp_entry steering_qp_entry11;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x34.31 */
	 struct connectib_steering_qp_entry steering_qp_entry12;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x38.31 */
	 struct connectib_steering_qp_entry steering_qp_entry13;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x3c.31 */
	 struct connectib_steering_qp_entry steering_qp_entry14;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x40.31 */
	 struct connectib_steering_qp_entry steering_qp_entry15;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_ste {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t member_count;
	/* Description -  */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t rx_packet_qp;
	/* Description -  */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t rx_fw_int;
	/* Description - Compare = 0x0, MissOnTagMatch = 0x1, AlwaysHit = 0x2, AlwaysMiss = 0x3 */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t rx_cmd;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t pport_byte_counters_trigger;
	/* Description -  */
	/* 0x4.8 - 0x4.15 */
	 u_int8_t pport_packet_counters_trigger;
	/* Description -  */
	/* 0x4.16 - 0x4.19 */
	 u_int8_t vport_byte_counters_trigger;
	/* Description -  */
	/* 0x4.20 - 0x4.23 */
	 u_int8_t vport_packet_counters_trigger;
	/* Description -  */
	/* 0x4.26 - 0x4.26 */
	 u_int8_t sx_sniffer;
	/* Description -  */
	/* 0x4.27 - 0x4.27 */
	 u_int8_t sx_func_lb;
	/* Description -  */
	/* 0x4.28 - 0x4.28 */
	 u_int8_t sx_wire;
	/* Description -  */
	/* 0x4.29 - 0x4.29 */
	 u_int8_t sx_fw_int;
	/* Description - HitOnTagMatch = 0x0, HitAndTerminateOnTagMatch = 0x1, HitOnTagMismatch  = 0x2, HitAndTerminateOnTagMismatch = 0x3 */
	/* 0x4.30 - 0x4.31 */
	 u_int8_t sx_cmd;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - FW uses reserved bits to add implicit uniqe STE id */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t fw_id;
	/* Description - Nop=0x0, Port = 0x1, IbL2 = 0x2, IbL3 = 0x3, IbL3Extended = 0x4, IbL4Qp = 0x5, 
SrcGvmiAndQp = 0x8, 
GenericDwordSelect0 = 0xc, GenericDwordSelect1 = 0xd,
GenericDwordSelect2 = 0xe, GenericDwordSelect3 = 0xf */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t my_lookup_type;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.7 */
	 u_int8_t hit_lookup_type_hash_field_mask;
	/* Description -  */
	/* 0xc.8 - 0xc.13 */
	 u_int8_t log2_hit_entry_size;
	/* Description -  */
	/* 0xc.16 - 0xc.31 */
	 u_int16_t gvmi;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -   */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t hit_base_address_63_32;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Nop=0x0, Port = 0x1, IbL2 = 0x2, IbL3 = 0x3, IbL3Extended = 0x4, IbL4Qp = 0x5, 
SrcGvmiAndQp = 0x8, 
GenericDwordSelect0 = 0xc, GenericDwordSelect1 = 0xd,
GenericDwordSelect2 = 0xe, GenericDwordSelect3 = 0xf */
	/* 0x14.0 - 0x14.7 */
	 u_int8_t hit_lookup_type;
	/* Description -   */
	/* 0x14.8 - 0x14.31 */
	 u_int32_t hit_base_address_31_8;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t miss_address_63_32;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.5 */
	 u_int8_t log2_hit_table_size;
	/* Description -  */
	/* 0x1c.6 - 0x1c.31 */
	 u_int32_t miss_address_31_6;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -   */
	/* 0x20.0 - 0x30.31 */
	 union connectib_hw_ste_tag tag_data;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -   */
	/* 0x30.0 - 0x40.31 */
	 union connectib_hw_ste_tag tag_mask;
};

/* Description -   */
/* Size in bytes - 1 */
struct connectib_hw_timer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - time to wait before timeout (see qpc MAS) */
	/* 0x0.0 - 0x0.4 */
	 u_int8_t timer_granularity;
	/* Description - state of timer (see qpc mas) */
	/* 0x0.5 - 0x0.6 */
	 u_int8_t timer_state;
	/* Description - timer is valid */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t timer_valid;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_sxdc_requestor_in_sq {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.24 - 0x4.24 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_sxdc_responder_in_sq {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.25 - 0x4.25 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_sxdc_scheduling_interrupt {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.26 - 0x4.26 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_sxdc_doorbell_int {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.28 - 0x4.28 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_sxdc_fast_path {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.29 - 0x4.29 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_sxdc_external_db_en {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_sxdc_valid {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_sxdc_sq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_sxdc_swqe_producer_index {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_sxdc_uar {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t m_check_gen;
	/* Description - NO_DESCR */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t m_init;
	/* Description - NO_DESCR */
	/* 0x0.2 - 0x0.3 */
	 u_int8_t m_pad;
	/* Description - NO_DESCR */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t w_check_gen;
	/* Description - NO_DESCR */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t w_init;
	/* Description - NO_DESCR */
	/* 0x0.10 - 0x0.11 */
	 u_int8_t w_pad;
	/* Description - NO_DESCR */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t byte_check_en;
	/* Description - NO_DESCR */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t aligned;
	/* Description - NO_DESCR */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t raw_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t w_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t w_b_pdf_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - NO_DESCR */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t m_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t m_b_pdf_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - NO_DESCR */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t prologue_size;
	/* Description - NO_DESCR */
	/* 0x10.24 - 0x10.24 */
	 u_int8_t m_t_end;
	/* Description - NO_DESCR */
	/* 0x10.25 - 0x10.25 */
	 u_int8_t m_t_start;
	/* Description - NO_DESCR */
	/* 0x10.28 - 0x10.28 */
	 u_int8_t w_t_end;
	/* Description - NO_DESCR */
	/* 0x10.29 - 0x10.29 */
	 u_int8_t w_t_start;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t epilogue_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - NO_DESCR */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t w_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x18.24 - 0x18.31 */
	 u_int8_t w_t_pdf_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - NO_DESCR */
	/* 0x1c.0 - 0x1c.23 */
	 u_int32_t m_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x1c.24 - 0x1c.31 */
	 u_int8_t m_t_pdf_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 0x20.0 - 0x20.15 */
	 u_int16_t w_dif_app_tag;
	/* Description - NO_DESCR */
	/* 0x20.30 - 0x20.30 */
	 u_int8_t w_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 0x20.31 - 0x20.31 */
	 u_int8_t w_in_line_vld;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t w_dif_ref_tag;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 0x28.0 - 0x30.31 */
	 union connectib_hw_pdf_entry w_in_line_pdf;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - NO_DESCR */
	/* 0x30.0 - 0x30.15 */
	 u_int16_t m_dif_app_tag;
	/* Description - NO_DESCR */
	/* 0x30.30 - 0x30.30 */
	 u_int8_t m_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 0x30.31 - 0x30.31 */
	 u_int8_t m_in_line_vld;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - NO_DESCR */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t m_dif_ref_tag;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - NO_DESCR */
	/* 0x38.0 - 0x40.31 */
	 union connectib_hw_pdf_entry m_in_line_pdf;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_bsf_entry_w_non_repeating_m_repeating {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t m_block_size_selector;
	/* Description - NO_DESCR */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t w_check_gen;
	/* Description - NO_DESCR */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t w_init;
	/* Description - NO_DESCR */
	/* 0x0.10 - 0x0.11 */
	 u_int8_t w_pad;
	/* Description - NO_DESCR */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t byte_check_en;
	/* Description - NO_DESCR */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t aligned;
	/* Description - NO_DESCR */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t raw_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t w_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t w_b_pdf_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - NO_DESCR */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t m_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t m_b_pdf_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - NO_DESCR */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t prologue_size;
	/* Description - NO_DESCR */
	/* 0x10.24 - 0x10.24 */
	 u_int8_t m_t_end;
	/* Description - NO_DESCR */
	/* 0x10.25 - 0x10.25 */
	 u_int8_t m_t_start;
	/* Description - NO_DESCR */
	/* 0x10.28 - 0x10.28 */
	 u_int8_t w_t_end;
	/* Description - NO_DESCR */
	/* 0x10.29 - 0x10.29 */
	 u_int8_t w_t_start;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t epilogue_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - NO_DESCR */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t w_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x18.24 - 0x18.31 */
	 u_int8_t w_t_pdf_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - NO_DESCR */
	/* 0x1c.0 - 0x1c.23 */
	 u_int32_t m_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x1c.24 - 0x1c.31 */
	 u_int8_t m_t_pdf_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 0x20.0 - 0x20.15 */
	 u_int16_t w_dif_app_tag;
	/* Description - NO_DESCR */
	/* 0x20.30 - 0x20.30 */
	 u_int8_t w_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 0x20.31 - 0x20.31 */
	 u_int8_t w_in_line_vld;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t w_dif_ref_tag;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 0x28.0 - 0x30.31 */
	 union connectib_hw_pdf_entry w_in_line_pdf;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - NO_DESCR */
	/* 0x30.0 - 0x30.15 */
	 u_int16_t m_dif_app_tag;
	/* Description - NO_DESCR */
	/* 0x30.30 - 0x30.30 */
	 u_int8_t m_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 0x30.31 - 0x30.31 */
	 u_int8_t m_in_line_vld;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - NO_DESCR */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t m_dif_ref_tag;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - NO_DESCR */
	/* 0x38.0 - 0x40.31 */
	 union connectib_hw_pdf_entry m_in_line_pdf;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_bsf_entry_w_repeating_m_non_repeating {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t m_check_gen;
	/* Description - NO_DESCR */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t m_init;
	/* Description - NO_DESCR */
	/* 0x0.2 - 0x0.3 */
	 u_int8_t m_pad;
	/* Description - NO_DESCR */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t w_block_size_selector;
	/* Description - NO_DESCR */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t byte_check_en;
	/* Description - NO_DESCR */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t aligned;
	/* Description - NO_DESCR */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t raw_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t w_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t w_b_pdf_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - NO_DESCR */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t m_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t m_b_pdf_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - NO_DESCR */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t prologue_size;
	/* Description - NO_DESCR */
	/* 0x10.24 - 0x10.24 */
	 u_int8_t m_t_end;
	/* Description - NO_DESCR */
	/* 0x10.25 - 0x10.25 */
	 u_int8_t m_t_start;
	/* Description - NO_DESCR */
	/* 0x10.28 - 0x10.28 */
	 u_int8_t w_t_end;
	/* Description - NO_DESCR */
	/* 0x10.29 - 0x10.29 */
	 u_int8_t w_t_start;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t epilogue_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - NO_DESCR */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t w_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x18.24 - 0x18.31 */
	 u_int8_t w_t_pdf_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - NO_DESCR */
	/* 0x1c.0 - 0x1c.23 */
	 u_int32_t m_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x1c.24 - 0x1c.31 */
	 u_int8_t m_t_pdf_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 0x20.0 - 0x20.15 */
	 u_int16_t w_dif_app_tag;
	/* Description - NO_DESCR */
	/* 0x20.30 - 0x20.30 */
	 u_int8_t w_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 0x20.31 - 0x20.31 */
	 u_int8_t w_in_line_vld;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t w_dif_ref_tag;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 0x28.0 - 0x30.31 */
	 union connectib_hw_pdf_entry w_in_line_pdf;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - NO_DESCR */
	/* 0x30.0 - 0x30.15 */
	 u_int16_t m_dif_app_tag;
	/* Description - NO_DESCR */
	/* 0x30.30 - 0x30.30 */
	 u_int8_t m_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 0x30.31 - 0x30.31 */
	 u_int8_t m_in_line_vld;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - NO_DESCR */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t m_dif_ref_tag;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - NO_DESCR */
	/* 0x38.0 - 0x40.31 */
	 union connectib_hw_pdf_entry m_in_line_pdf;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_bsf_entry_w_repeating_m_repeating {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t m_block_size_selector;
	/* Description - NO_DESCR */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t w_block_size_selector;
	/* Description - NO_DESCR */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t byte_check_en;
	/* Description - NO_DESCR */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t aligned;
	/* Description - NO_DESCR */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t raw_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t w_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t w_b_pdf_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - NO_DESCR */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t m_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t m_b_pdf_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - NO_DESCR */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t prologue_size;
	/* Description - NO_DESCR */
	/* 0x10.24 - 0x10.24 */
	 u_int8_t m_t_end;
	/* Description - NO_DESCR */
	/* 0x10.25 - 0x10.25 */
	 u_int8_t m_t_start;
	/* Description - NO_DESCR */
	/* 0x10.28 - 0x10.28 */
	 u_int8_t w_t_end;
	/* Description - NO_DESCR */
	/* 0x10.29 - 0x10.29 */
	 u_int8_t w_t_start;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t epilogue_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - NO_DESCR */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t w_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x18.24 - 0x18.31 */
	 u_int8_t w_t_pdf_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - NO_DESCR */
	/* 0x1c.0 - 0x1c.23 */
	 u_int32_t m_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x1c.24 - 0x1c.31 */
	 u_int8_t m_t_pdf_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 0x20.0 - 0x20.15 */
	 u_int16_t w_dif_app_tag;
	/* Description - NO_DESCR */
	/* 0x20.30 - 0x20.30 */
	 u_int8_t w_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 0x20.31 - 0x20.31 */
	 u_int8_t w_in_line_vld;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t w_dif_ref_tag;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 0x28.0 - 0x30.31 */
	 union connectib_hw_pdf_entry w_in_line_pdf;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - NO_DESCR */
	/* 0x30.0 - 0x30.15 */
	 u_int16_t m_dif_app_tag;
	/* Description - NO_DESCR */
	/* 0x30.30 - 0x30.30 */
	 u_int8_t m_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 0x30.31 - 0x30.31 */
	 u_int8_t m_in_line_vld;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - NO_DESCR */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t m_dif_ref_tag;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - NO_DESCR */
	/* 0x38.0 - 0x40.31 */
	 union connectib_hw_pdf_entry m_in_line_pdf;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_bsf_entry_same_block_non_repeating {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t m_check_gen;
	/* Description - NO_DESCR */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t m_init;
	/* Description - NO_DESCR */
	/* 0x0.2 - 0x0.3 */
	 u_int8_t m_pad;
	/* Description - NO_DESCR */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t copy_byte_mask;
	/* Description - NO_DESCR */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t byte_check_en;
	/* Description - NO_DESCR */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t aligned;
	/* Description - NO_DESCR */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t raw_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t w_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t w_b_pdf_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - NO_DESCR */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t m_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t m_b_pdf_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - NO_DESCR */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t prologue_size;
	/* Description - NO_DESCR */
	/* 0x10.24 - 0x10.24 */
	 u_int8_t m_t_end;
	/* Description - NO_DESCR */
	/* 0x10.25 - 0x10.25 */
	 u_int8_t m_t_start;
	/* Description - NO_DESCR */
	/* 0x10.28 - 0x10.28 */
	 u_int8_t w_t_end;
	/* Description - NO_DESCR */
	/* 0x10.29 - 0x10.29 */
	 u_int8_t w_t_start;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t epilogue_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - NO_DESCR */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t w_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x18.24 - 0x18.31 */
	 u_int8_t w_t_pdf_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - NO_DESCR */
	/* 0x1c.0 - 0x1c.23 */
	 u_int32_t m_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x1c.24 - 0x1c.31 */
	 u_int8_t m_t_pdf_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 0x20.0 - 0x20.15 */
	 u_int16_t w_dif_app_tag;
	/* Description - NO_DESCR */
	/* 0x20.30 - 0x20.30 */
	 u_int8_t w_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 0x20.31 - 0x20.31 */
	 u_int8_t w_in_line_vld;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t w_dif_ref_tag;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 0x28.0 - 0x30.31 */
	 union connectib_hw_pdf_entry w_in_line_pdf;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - NO_DESCR */
	/* 0x30.0 - 0x30.15 */
	 u_int16_t m_dif_app_tag;
	/* Description - NO_DESCR */
	/* 0x30.30 - 0x30.30 */
	 u_int8_t m_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 0x30.31 - 0x30.31 */
	 u_int8_t m_in_line_vld;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - NO_DESCR */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t m_dif_ref_tag;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - NO_DESCR */
	/* 0x38.0 - 0x40.31 */
	 union connectib_hw_pdf_entry m_in_line_pdf;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_bsf_entry_same_block_repeating {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t m_block_size_selector;
	/* Description - NO_DESCR */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t copy_byte_mask;
	/* Description - NO_DESCR */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t byte_check_en;
	/* Description - NO_DESCR */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t aligned;
	/* Description - NO_DESCR */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t raw_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t w_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t w_b_pdf_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - NO_DESCR */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t m_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t m_b_pdf_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - NO_DESCR */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t prologue_size;
	/* Description - NO_DESCR */
	/* 0x10.24 - 0x10.24 */
	 u_int8_t m_t_end;
	/* Description - NO_DESCR */
	/* 0x10.25 - 0x10.25 */
	 u_int8_t m_t_start;
	/* Description - NO_DESCR */
	/* 0x10.28 - 0x10.28 */
	 u_int8_t w_t_end;
	/* Description - NO_DESCR */
	/* 0x10.29 - 0x10.29 */
	 u_int8_t w_t_start;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t epilogue_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - NO_DESCR */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t w_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x18.24 - 0x18.31 */
	 u_int8_t w_t_pdf_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - NO_DESCR */
	/* 0x1c.0 - 0x1c.23 */
	 u_int32_t m_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 0x1c.24 - 0x1c.31 */
	 u_int8_t m_t_pdf_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 0x20.0 - 0x20.15 */
	 u_int16_t w_dif_app_tag;
	/* Description - NO_DESCR */
	/* 0x20.30 - 0x20.30 */
	 u_int8_t w_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 0x20.31 - 0x20.31 */
	 u_int8_t w_in_line_vld;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t w_dif_ref_tag;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 0x28.0 - 0x30.31 */
	 union connectib_hw_pdf_entry w_in_line_pdf;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - NO_DESCR */
	/* 0x30.0 - 0x30.15 */
	 u_int16_t m_dif_app_tag;
	/* Description - NO_DESCR */
	/* 0x30.30 - 0x30.30 */
	 u_int8_t m_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 0x30.31 - 0x30.31 */
	 u_int8_t m_in_line_vld;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - NO_DESCR */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t m_dif_ref_tag;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - NO_DESCR */
	/* 0x38.0 - 0x40.31 */
	 union connectib_hw_pdf_entry m_in_line_pdf;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_dct {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - this field add for making this struct size 64B (as QPC) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_complete_to_64B_eyald complete_to_64B_eyald;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_rnr_timer rnr_timer;
	/* Description - 
EAS NAME: rwe */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_write_enable write_enable;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload <=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload <=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_inline_scatter inline_scatter;
	/* Description - 2^thisValue is the max number of bytes per mesaage
EAS NAME: msg_max */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_max_message_size max_message_size;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_ignore_pkey_check ignore_pkey_check;
	/* Description - When set send and invalidate is allowed on this Qp (like AWR bits) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_send_with_invalidate_enable send_with_invalidate_enable;
	/* Description - 
EAS NAME: rre */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_read_enable read_enable;
	/* Description - 0: 256 bytes 
1: 512 bytes 
2: 1K bytes 
3: 2K bytes 
4: 4k bytes
5: 8k bytes
EAS NAME: mtu */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_mtu mtu;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_fast_path fast_path;
	/* Description - number of valid bytes in the dca_access_key
0-3: 2^value bytes
7-disable */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_dc_access_key_log_num_byte dc_access_key_log_num_byte;
	/* Description - 
EAS NAME: N/A */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_tcu_drop tcu_drop;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_tcu_trap tcu_trap;
	/* Description - mark packets as eligible for adaptive routing; supported on UC & UD transports
EAS NAME: free_ar */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_adaptive_routing adaptive_routing;
	/* Description - 
EAS NAME: Derived from sched_queue */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_port_number port_number;
	/* Description - IB native only: packet should have GRH header
not used in UD/L2 responder
EAS NAME: grh */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_grh_bit grh_bit;
	/* Description - 
EAS NAME: flow_label */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_flow_label flow_label;
	/* Description - 2^this value=max number of atomic/rdma reads
Hermon: max_rdma_atomic
EAS NAME: sra_max, rra_max */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_max_read_atomic max_read_atomic;
	/* Description - in other decode options this bit should be reserved and always_zero.
this is because we don't have a HW check of ts when fetching DCT.
if we get normal QP by accident this will show invalid context. */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_qp_valid qp_valid;
	/* Description - 
EAS NAME: mlid */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_my_lid my_lid;
	/* Description - RDMA write coming to this QP will enter the atomic lock mechanism to ensure PCI atomicity */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_atomic_like_write atomic_like_write;
	/* Description - 
EAS NAME: srqn
condition:rwq_type==SRQ & ts!=DCR */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_srq_number srq_number;
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid
EAS NAME: if_counter_index */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_counter_index counter_index;
	/* Description - 
EAS NAME: pkey_index */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_pkey_table_index pkey_table_index;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand)
0: disable atomic
1: IB spec (responder extended RDB is N/A)
all enum from here support extended atomic in addition
2: only 8B (hermon mode, responder extended RDB is N/A)
3: up to 8B (also 4B, responder extended RDB is N/A)
4: up to 16B (responder extended RDB is N/A)
5: up to 32B (responder extended RDB is N/A)
6: up to 64B (responder extended RDB is 64B)
7: up to 128B (responder extended RDB is 128B)
8: up to 256B (responder extended RDB is 256B)
EAS NAME: rae, rdma_atomic_mode */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_extended_atomic extended_atomic;
	/* Description - access ICM with {GVMI, my_gid_index} to get GRH.MyGID, IPv6 and IPv4 use the same field
EAS NAME: mgid_index */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_my_gid_mac_index my_gid_mac_index;
	/* Description - 
EAS NAME: stat_rate */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_ipd ipd;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent
9-RMC child (RX only)
10-FCP
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_ts ts;
	/* Description - 
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_cq_number cq_number;
	/* Description - Number of hops between subnets a packet can make before being discarded
Used by TCU for CNP with GRH in connected mode
EAS NAME: hop_limit */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_hop_limit hop_limit;
	/* Description - in DCR this is the DCT number, this is MyQPN in the packet
EAS NAME: local_qpn */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_context_number context_number;
	/* Description - UD-see force_grh_tclass
golan2: we should have 2 tclass fields for ETHoIB enforcement
EAS NAME: tclass */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_tclass tclass;
	/* Description - 
condition:ts==DCI */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_dc_access_key_31_0 dc_access_key_31_0;
	/* Description - 
condition:ts==DCI */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_dct_dc_access_key_63_32 dc_access_key_63_32;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_r_qpc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Controls handling of packets with correct and incorrect PSN and opcode sequences 0: Unconnected - QPC ePSN and opcode sequence are invalid 1:Connected (good flow) - QPC.ePSN and correct opcode sequence are forwarded; everything else triggers FW 2: Resync (^xxstate^) -  QPC.ePSN and correct opcode sequence will cause HW to move QPC to Connected state; everything else is dropped 3: Closed - everything is dropped in RXT HW writes to this field in RNR-nack flow */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_connection_state connection_state;
	/* Description - check source (choose source based on QP bit) for multicast wire */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_check_source_mc_wire check_source_mc_wire;
	/* Description - e2e credits pysical address, bits[63:2] */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_e2e_pa_31_2 e2e_pa_31_2;
	/* Description - e2e credits pysical address, bits[63:2] */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_e2e_pa_63_32 e2e_pa_63_32;
	/* Description - 1: dcr is connected 0: dcr is free */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_dcr_connected dcr_connected;
	/* Description - Hermon: srcd */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_xrc_domain xrc_domain;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_responder_session_id responder_session_id;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_mpi_uar mpi_uar;
	/* Description - when equal 0xffffff: next DCR does not exist, end of list */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_next_dcr next_dcr;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_srq_number srq_number;
	/* Description - virtual address of write being processed */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_write_va_31_0 write_va_31_0;
	/* Description - virtual address of write being processed */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_write_va_63_32 write_va_63_32;
	/* Description - cleared when CQE is sent, increament when packet is dropped due to lack of receive WQE's saturation on 0xff TODO: 8 MSB are not used TODO: rename to wqe_drop_count_en */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_no_wqe_drop_count no_wqe_drop_count;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_dct_gvmi dct_gvmi;
	/* Description - SQ number TODO: reduce 1 bit */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_sqn sqn;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_sx_heartbeat sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5]) 0-RC 1-UC 2-RD (reserved) 3-UD 5-XRC (SRC in hermon) 8-RMC parent 9-RMC child (RX only) 10-FCP 11-DCI/DCR 12-DCT 15-L2 (Hermon name: L2 & MLX) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_ts ts;
	/* Description - How many received in current message, 0-not inside a message RC: in chuncks of 256B LRO: in bytes hermon name: part was in last_opcode */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_rx_length_committed rx_length_committed;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_rdb_read_pointer rdb_read_pointer;
	/* Description - bug 153508 TODO: delete on next project This bit must always be 0 (if this QP will erroneously be read as a DCT, the DCT.vld will be 0) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_always_zero always_zero;
	/* Description - index to the counters table 0-disable */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_counter_index counter_index;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_flush_syndrom flush_syndrom;
	/* Description - UD: used for LRO checks */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_expected_psn expected_psn;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_cq_number cq_number;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_dct_number dct_number;
	/* Description - Indicates which MSN was done */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_msn msn;
	/* Description - how many bytes received ^ modulo 4G */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_rcyclic_consumer rcyclic_consumer;
	/* Description - in hermon: last_acked_psn (+1 from hermon) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_first_non_acked_psn first_non_acked_psn;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_rdb_write_pointer rdb_write_pointer;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_qp_state qp_state;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_rwqe_producer_index rwqe_producer_index;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_rcyclic_producer rcyclic_producer;
	/* Description - index to next free wqe rwq_type=SRQ: copy index from SRQ on packet first */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_rwqe_consumer_index rwqe_consumer_index;
	/* Description - E2E Limit on  TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_rwqe_limit_event rwqe_limit_event;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_rnr_timer rnr_timer;
	/* Description - interrupt FW when packet arrives to tcu on this Qp Hermon: tcu_int */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_tcu_trap tcu_trap;
	/* Description - Used for translation and key check (TPT) TODO: next project move to common section? */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_can_use_reserved_lkey can_use_reserved_lkey;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_tcu_drop tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_e2e_fetch_enable e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits 0 means e2e prefethch disabled for this qp in rcylic this thrshould is in MTU, otherwise in WQEs */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_e2e_credits_prefetch_threshold e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_rx_heartbeat rx_heartbeat;
	/* Description - On WriteFirst set to the packet.R_key */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_write_rkey write_rkey;
	/* Description - check_source_uc_wire - check source (choose source based on QP bit) for multicast wire */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_check_source_uc_wire check_source_uc_wire;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_fw_link_type fw_link_type;
	/* Description - last opcode was: 0-write 1-send */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_last_opcode last_opcode;
	/* Description - Work Queue Type 1: normal WQ 2: attached to SRQ 3: Receive Cyclic Buffer */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_rwq_type rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry 1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline) 2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline) Hermon: disable_inline_scatter */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_inline_scatter inline_scatter;
	/* Description - Loopback only, If set, function_id is checked with the receiving QP function_id. Otherwise, SMAC is checked. This and the following 4 not needed in FC (And RC) since we check DMAC in the QP and make sure that the packet arrived to its intended destination */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_check_source_gvmi check_source_gvmi;
	/* Description - check source (choose source based on QP bit) for multicast loopback */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_check_source_mc_lb check_source_mc_lb;
	/* Description - check source (choose source based on QP bit) for unicast loopback */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_check_source_uc_lb check_source_uc_lb;
	/* Description - This QP should use the fast_path inside the device */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_fast_path fast_path;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_read_enable read_enable;
	/* Description - When set send and invalidate is allowed on this Qp (like AWR bits) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_send_with_invalidate_enable send_with_invalidate_enable;
	/* Description - TODO next project: rename to pkey_check_enable TODO next project: delete it from all TS (who needs it)? */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_ignore_pkey_check ignore_pkey_check;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand) 0: disable atomic 1: IB spec (responder extended RDB is N/A) all enum from here support extended atomic in addition 2: only 8B (hermon mode, responder extended RDB is N/A) 3: up to 8B (also 4B, responder extended RDB is N/A) 4: up to 16B (responder extended RDB is N/A) 5: up to 32B (responder extended RDB is N/A) 6: up to 64B (responder extended RDB is 64B) 7: up to 128B (responder extended RDB is 128B) 8: up to 256B (responder extended RDB is 256B) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_extended_atomic extended_atomic;
	/* Description - 2^this value=max number of atomic/rdma reads Hermon: max_rdma_atomic */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_max_read_atomic max_read_atomic;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_write_enable write_enable;
	/* Description - RDMA write coming to this QP will enter the atomic lock mechanism to ensure PCI atomicity */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_atomic_like_write atomic_like_write;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp must be set to 0 on DCR and XRC */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_post_receive_slave_enable post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN). When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed. See issue 34551  TODO: rename to direct_access_enable */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_no_direct_access no_direct_access;
	/* Description - TCU requestor should trap when e2e_credits_enabled==&AETH.syndrom.CCCCC */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_e2e_credits_enabled e2e_credits_enabled;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_ack_type ack_type;
	/* Description - when set: multicast loopback packets coming from the same QP will be dropped */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_drop_my_self_multicast drop_my_self_multicast;
	/* Description - 1: GRH is sent to CQE 0: GRH is sent to first 40B of the WQE (or 40B reserved if GRH not present). this is the backward compatiblity mode */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_grh_to_cqe grh_to_cqe;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_r_qpc_qp_valid qp_valid;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_packet_allowed {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_qp_valid {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_uncompleted_non_wire_wqe {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_dc_full_handshake {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_e2e_credits_enabled {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.27 - 0x0.27 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_no_direct_access {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_umr_permission_select {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.24 - 0x0.25 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_max_read_atomic {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.20 - 0x0.22 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_extended_atomic {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_ignore_pkey_check {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_rnr_nak_retry_counter {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.12 - 0x0.14 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_fast_path {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_rnr_nak_retry_limit {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.8 - 0x0.10 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_inline_scatter {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.6 - 0x0.7 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_ldb_int {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_rx_heartbeat {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_frwr_enable {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.29 - 0x8.29 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_umr_enable {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.28 - 0x8.28 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_tcu_drop {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.26 - 0x8.26 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_can_use_reserved_lkey {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.25 - 0x8.25 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_tcu_trap {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.24 - 0x8.24 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_ack_req_frequency {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.20 - 0x8.23 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_limited_qp {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.17 - 0x8.19 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_dc_state {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.1 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_currently_completing_wqe_index {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.16 - 0xc.31 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_swqe_consumer_index {
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.16 - 0x10.31 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_qp_state {
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_psn_since_ackreq {
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.24 - 0x14.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_oldest_non_acked_psn {
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_deth_sqpn {
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_responder_session_id {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_cq_number {
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_next_to_send_psn {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.8 - 0x20.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_flush_syndrom {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x20.7 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_counter_index {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.24 - 0x24.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_ssn {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x24.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_to_sequence_error_retry_counter {
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.20 - 0x28.22 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_reverse_sl {
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.16 - 0x28.19 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_force_grh_tclass {
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.15 - 0x28.15 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_ts {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.28 - 0x2c.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_sx_heartbeat {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.27 - 0x2c.27 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_to_sequence_error_retry_limit {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.24 - 0x2c.26 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_force_my_gid_index {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.23 - 0x2c.23 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_sx_gather_commit {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x2c.22 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_lsn {
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x30.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_dc_access_key_63_32 {
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_dc_access_key_31_0 {
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_force_grh {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.31 - 0x38.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_vl15 {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.30 - 0x38.30 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_timer_enable {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.30 - 0x38.30 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_currently_completing_ds {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.24 - 0x38.29 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_first_psn_of_message_currently_completing {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x38.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_number_outstanding_reads {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.24 - 0x3c.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_first_unsent_psn {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x3c.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_common_valid {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_wq_signature {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_dual_write {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_log_page_size {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.24 - 0x0.28 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_rwq_type {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.4 - 0x0.5 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_force_loopback {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_ipd {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.16 - 0x4.19 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_rwqe_stride {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.12 - 0x4.14 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_rcyclic_size {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.8 - 0x4.12 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_rwqe_buffer_size {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.8 - 0x4.11 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_tclass {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_hop_limit {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_peer_qp {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_rx_migreq {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.31 - 0xc.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_sx_migreq {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.30 - 0xc.30 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_wqe_page_offset {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.24 - 0xc.29 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_context_number {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_pkey_table_index {
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.20 - 0x10.31 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_flow_label {
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.19 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_qkey {
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_mtu {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.29 - 0x18.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_max_message_size {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.24 - 0x18.28 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_my_gid_mac_index {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.16 - 0x18.23 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_my_lid {
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.16 - 0x1c.22 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_peer_lid {
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.15 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_swqe_buffer_size {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.24 - 0x20.27 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_adaptive_routing {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.22 - 0x20.22 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_port_number {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.21 - 0x20.21 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_grh_bit {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.20 - 0x20.20 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_sl {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.16 - 0x20.19 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_mtt_pointer_39_37 {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x24.2 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_mtt_pointer_36_5 {
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_mtt_pointer_4_0 {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.27 - 0x2c.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_pd {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x2c.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_peer_qp2 {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x38.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_peer_lid2 {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x3c.15 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_peer_gid_127_96 {
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_peer_gid_95_64 {
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_peer_gid_63_32 {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_peer_gid_31_0 {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t val;
};

/* Description -  e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
/* Size in bytes - 64 */
struct connectib_e2e_pa_33_2 {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t val;
};

/* Description -  each WQE in the r&s WQ are signature protected */
/* Size in bytes - 64 */
struct connectib_wq_signature {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.31 - 0x38.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_srq_valid {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.30 - 0x38.30 */
	 u_int8_t val;
};

/* Description -  e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
/* Size in bytes - 64 */
struct connectib_e2e_pa_63_34 {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x38.29 */
	 u_int32_t val;
};

/* Description -  Used in TPT for wqe translation */
/* Size in bytes - 64 */
struct connectib_mtt_pointer_31_0 {
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t val;
};

/* Description -  E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
/* Size in bytes - 64 */
struct connectib_rwqe_limit_event {
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.16 - 0x30.31 */
	 u_int16_t val;
};

/* Description -  e2e fetch is allowed only according to this bit */
/* Size in bytes - 64 */
struct connectib_e2e_fetch_enable {
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.15 - 0x30.15 */
	 u_int8_t val;
};

/* Description -  set by RX on every packet received and accepted
EAS NAME: N/A */
/* Size in bytes - 64 */
struct connectib_rx_heartbeat {
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.14 - 0x30.14 */
	 u_int8_t val;
};

/* Description -  If rwq_type==0 then 
 swqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
else 
 rwqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
 swqe_address=(2^log_page_size)*wqe_page_offset*64 + 2^(rwqe_buffer_size+rwqe_stride)*16 + masked_wqe_index*64
EAS NAME: page_offset */
/* Size in bytes - 64 */
struct connectib_wqe_page_offset {
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.8 - 0x30.13 */
	 u_int8_t val;
};

/* Description -  Used in TPT for wqe translation */
/* Size in bytes - 64 */
struct connectib_mtt_pointer_39_32 {
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x30.7 */
	 u_int8_t val;
};

/* Description -  interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
/* Size in bytes - 64 */
struct connectib_tcu_trap {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.31 - 0x2c.31 */
	 u_int8_t val;
};

/* Description -  Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
/* Size in bytes - 64 */
struct connectib_can_use_reserved_lkey {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.30 - 0x2c.30 */
	 u_int8_t val;
};

/* Description -  
EAS NAME: N/A */
/* Size in bytes - 64 */
struct connectib_tcu_drop {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.29 - 0x2c.29 */
	 u_int8_t val;
};

/* Description -  page_size = 4096*2^log_page_size */
/* Size in bytes - 64 */
struct connectib_log_page_size {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.24 - 0x2c.28 */
	 u_int8_t val;
};

/* Description -  in DCR this is the DCT number, this is MyQPN in the packet
EAS NAME: local_qpn */
/* Size in bytes - 64 */
struct connectib_context_number {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x2c.23 */
	 u_int32_t val;
};

/* Description -  WQE size: (2^this field)*16B
EAS NAME: log_rq_stride
condition:rwq_type!=RCYCLIC */
/* Size in bytes - 64 */
struct connectib_rwqe_stride {
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.28 - 0x28.30 */
	 u_int8_t val;
};

/* Description -  number of WQEs in the WQ: 2 in power of
EAS NAME: log_rq_size
condition:rwq_type!=RCYCLIC */
/* Size in bytes - 64 */
struct connectib_rwqe_buffer_size {
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.24 - 0x28.27 */
	 u_int8_t val;
};

/* Description -  
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
/* Size in bytes - 64 */
struct connectib_cq_number {
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x28.23 */
	 u_int32_t val;
};

/* Description -  2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
/* Size in bytes - 64 */
struct connectib_e2e_credits_prefetch_threshold {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.24 - 0x24.26 */
	 u_int8_t val;
};

/* Description -  protection domain
EAS NAME: pd */
/* Size in bytes - 64 */
struct connectib_pd {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x24.23 */
	 u_int32_t val;
};

/* Description -  Hermon: srcd
EAS NAME: xrcd
condition:ts==XRC */
/* Size in bytes - 64 */
struct connectib_xrc_domain {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x20.23 */
	 u_int32_t val;
};

/* Description -  written by e2e credit machine */
/* Size in bytes - 64 */
struct connectib_e2e_producer_index {
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.16 - 0x1c.31 */
	 u_int16_t val;
};

/* Description -  index to next free wqe
rwq_type=SRQ: copy index from SRQ on packet first
EAS NAME: rq_wqe_counter
condition:rwq_type!=RCYCLIC */
/* Size in bytes - 64 */
struct connectib_rwqe_consumer_index {
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.15 */
	 u_int16_t val;
};

/* Description -  FW bits, these are the only reserved bits that are not overriden by HW in ICM */
/* Size in bytes - 64 */
struct connectib_srq_fw {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.16 - 0x18.25 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_e2e_consumer_index {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.15 */
	 u_int16_t val;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_pf_vf_cfg_space {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - pcie sriov capability for pf */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_pf_vf_sriov sriov;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - VPD capability for pf */
	/* 0x8.0 - 0x10.31 */
	 struct connectib_pf_vf_vpd vpd;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.9 */
	 u_int16_t hw_msix_vec0;
	/* Description - General MSIX function mask to all the function's vectors */
	/* 0x10.10 - 0x10.10 */
	 u_int8_t msix_func_mask;
	/* Description - NO_DESCR */
	/* 0x10.11 - 0x10.11 */
	 u_int8_t msix_enable;
	/* Description - pcie bus mastering for the function */
	/* 0x10.12 - 0x10.12 */
	 u_int8_t bus_master_en;
	/* Description - memory space enable
used for Golan only.
for Shomron, use command_register_memory_space */
	/* 0x10.13 - 0x10.13 */
	 u_int8_t memory_space;
	/* Description - valid for pf, rsvd for vf
used for Golan only.
for Shomron, use status_register_serr */
	/* 0x10.15 - 0x10.15 */
	 u_int8_t serr_status;
	/* Description - valid for pf, rsvd for vf
used for Golan only.
for Shomron, use command_register_serr_report_en */
	/* 0x10.16 - 0x10.16 */
	 u_int8_t serr_enable;
	/* Description - NO_DESCR
used for Golan only.
for Shomron, use command_register_perr_report_en */
	/* 0x10.17 - 0x10.17 */
	 u_int8_t perr_enable;
	/* Description - NO_DESCR */
	/* 0x10.18 - 0x10.18 */
	 u_int8_t int_disable;
	/* Description - Function got FLR, need to send event to driver */
	/* 0x10.19 - 0x10.19 */
	 u_int8_t need_to_fire_flr_event;
	/* Description - NO_DESCR */
	/* 0x10.20 - 0x10.20 */
	 u_int8_t in_middle_of_flr;
	/* Description - If set, this function power state is transparent to power management (L1) mechanism */
	/* 0x10.21 - 0x10.21 */
	 u_int8_t hide;
	/* Description - pcie logical Dstate */
	/* 0x10.22 - 0x10.23 */
	 u_int8_t power_state;
	/* Description - NO_DESCR */
	/* 0x10.24 - 0x10.31 */
	 u_int8_t cache_line;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 0x14.0 - 0x14.7 */
	 u_int8_t interrupt_line;
	/* Description - NO_DESCR */
	/* 0x14.10 - 0x14.10 */
	 u_int8_t exp_rom_en;
	/* Description - NO_DESCR */
	/* 0x14.11 - 0x14.31 */
	 u_int32_t exp_rom_addr_31_11;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - PF - base. VF - RsvdP */
	/* 0x18.0 - 0x18.0 */
	 u_int8_t device_control_correctable_error_report_en;
	/* Description - PF - base. VF - RsvdP */
	/* 0x18.1 - 0x18.1 */
	 u_int8_t device_control_nonfatal_error_report_en;
	/* Description - PF - base. VF - RsvdP */
	/* 0x18.2 - 0x18.2 */
	 u_int8_t device_control_fatal_error_report_en;
	/* Description - PF - base. VF - RsvdP */
	/* 0x18.3 - 0x18.3 */
	 u_int8_t device_control_ur_error_report_en;
	/* Description - PF - base. VF - RsvdP */
	/* 0x18.4 - 0x18.4 */
	 u_int8_t device_control_enable_relaxed_ordering;
	/* Description - PF - base. VF - RsvdP */
	/* 0x18.5 - 0x18.7 */
	 u_int8_t device_control_max_payload_size;
	/* Description - PF - base. VF - RsvdP */
	/* 0x18.8 - 0x18.8 */
	 u_int8_t device_control_extended_tag_en;
	/* Description - PF - base. VF - RsvdP */
	/* 0x18.9 - 0x18.9 */
	 u_int8_t device_control_enable_no_snoop;
	/* Description - PF - base. VF - RsvdP */
	/* 0x18.10 - 0x18.12 */
	 u_int8_t device_control_max_read_request_size;
	/* Description -  */
	/* 0x18.13 - 0x18.13 */
	 u_int8_t device_status_correctable_error_detected;
	/* Description -  */
	/* 0x18.14 - 0x18.14 */
	 u_int8_t device_status_nonfatal_error_detected;
	/* Description -  */
	/* 0x18.15 - 0x18.15 */
	 u_int8_t device_status_fatal_error_detected;
	/* Description -  */
	/* 0x18.16 - 0x18.16 */
	 u_int8_t device_status_ur_error_detected;
	/* Description - PF - base. VF - RsvdP */
	/* 0x18.17 - 0x18.17 */
	 u_int8_t command_register_memory_space;
	/* Description - PF - base. VF - base */
	/* 0x18.18 - 0x18.18 */
	 u_int8_t command_register_bus_master_en;
	/* Description - PF - base. VF - RsvdP */
	/* 0x18.19 - 0x18.19 */
	 u_int8_t command_register_perr_report_en;
	/* Description - PF - base. VF - RsvdP */
	/* 0x18.20 - 0x18.20 */
	 u_int8_t command_register_serr_report_en;
	/* Description - PF - base. VF - 0 */
	/* 0x18.21 - 0x18.21 */
	 u_int8_t command_register_interrupt_disable;
	/* Description - PF - base. VF - 0 */
	/* 0x18.22 - 0x18.22 */
	 u_int8_t status_register_interrupt_status;
	/* Description -  */
	/* 0x18.23 - 0x18.23 */
	 u_int8_t status_register_perr;
	/* Description -  */
	/* 0x18.24 - 0x18.24 */
	 u_int8_t status_register_serr;
	/* Description -  */
	/* 0x18.25 - 0x18.25 */
	 u_int8_t status_register_received_master_abort;
	/* Description -  */
	/* 0x18.26 - 0x18.26 */
	 u_int8_t status_register_received_target_abort;
	/* Description -  */
	/* 0x18.27 - 0x18.27 */
	 u_int8_t status_register_detected_parity_error;
	/* Description -  */
	/* 0x18.28 - 0x18.28 */
	 u_int8_t status_register_signaled_target_abort;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_hw_init_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0-init not started, 1-init in progress, 3 - init done */
	/* 0x0.0 - 0x0.1 */
	 u_int8_t init_state;
	/* Description - lock to prevent parallel init */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t init_lock;
	/* Description - This VF owner PF */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t owner_pf;
};

/* Description -  updated when eqe is generated from a global timer */
/* Size in bytes - 64 */
struct connectib_hw_cqc_moderation_timestamp_7_0 {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.24 - 0x3c.31 */
	 u_int8_t val;
};

/* Description -  
EAS NAME: usr_page */
/* Size in bytes - 64 */
struct connectib_hw_cqc_uar {
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x3c.23 */
	 u_int32_t val;
};

/* Description -  updated when eqe is generated from a global timer */
/* Size in bytes - 64 */
struct connectib_hw_cqc_moderation_timestamp_39_8 {
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t val;
};

/* Description -  MSB of physical address translation, 12lsb are VA[11:0] */
/* Size in bytes - 64 */
struct connectib_hw_cqc_pa1_31_12 {
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.12 - 0x34.31 */
	 u_int32_t val;
};

/* Description -  updated when eqe is generated from a global timer */
/* Size in bytes - 64 */
struct connectib_hw_cqc_moderation_timestamp_51_40 {
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x34.11 */
	 u_int16_t val;
};

/* Description -  MSB of physical address translation, 12lsb are VA[11:0] */
/* Size in bytes - 64 */
struct connectib_hw_cqc_pa1_63_32 {
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t val;
};

/* Description -  Used in TPT for wqe translation */
/* Size in bytes - 64 */
struct connectib_hw_cqc_mtt_pointer_4_0 {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.27 - 0x2c.31 */
	 u_int8_t val;
};

/* Description -  When set: ci is ignored, and never read (block,lookahead) */
/* Size in bytes - 64 */
struct connectib_hw_cqc_overrun_ignore {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.26 - 0x2c.26 */
	 u_int8_t val;
};

/* Description -  0-Fired
1-Armed Solicited
2-Armed
3-Always Armed
Hermon name: state */
/* Size in bytes - 64 */
struct connectib_hw_cqc_cq_state {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.24 - 0x2c.25 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_cqc_consumer_index {
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x2c.23 */
	 u_int32_t val;
};

/* Description -  Used in TPT for wqe translation */
/* Size in bytes - 64 */
struct connectib_hw_cqc_mtt_pointer_36_5 {
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t val;
};

/* Description -  bits[63:3] of the physical address of the ci
condition:cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_cipa_31_3 {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.3 - 0x24.31 */
	 u_int32_t val;
};

/* Description -  Used in TPT for wqe translation */
/* Size in bytes - 64 */
struct connectib_hw_cqc_mtt_pointer_39_37 {
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x24.2 */
	 u_int8_t val;
};

/* Description -  bits[63:3] of the physical address of the ci
condition:cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_cipa_63_32 {
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t val;
};

/* Description -  used for db.db_sn check
condition:cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_number_of_events_generated {
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.30 - 0x1c.31 */
	 u_int8_t val;
};

/* Description -  set to 1 on every received DB */
/* Size in bytes - 64 */
struct connectib_hw_cqc_db_heartbeat {
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.29 - 0x1c.29 */
	 u_int8_t val;
};

/* Description -  amount of CQE in CQ is 2^los2_size */
/* Size in bytes - 64 */
struct connectib_hw_cqc_log2_size {
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.24 - 0x1c.28 */
	 u_int8_t val;
};

/* Description -  doorbell ci - in the case of cq_state different from Fired, this field indicates what should be pi for firing the event. Updated by the doorbell handler */
/* Size in bytes - 64 */
struct connectib_hw_cqc_db_ci {
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.23 */
	 u_int32_t val;
};

/* Description -  minimum wait time between eqe:
0 means moderation is disabled on this CQ
condition:cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_moderation_min_wait_time {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.20 - 0x18.31 */
	 u_int16_t val;
};

/* Description -  CQC: eqn+eq_offset
EQC with MSIX: ^ MSIX number+offset
EQC with interrupt: 0-INT_A, 1-INT_B, 2-INT_C, 3-INT_D, 4-INT_YU */
/* Size in bytes - 64 */
struct connectib_hw_cqc_eqn_msix {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.19 */
	 u_int32_t val;
};

/* Description -  minimum # of cqes to generate eqe
condition:cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_moderation_cnt_limit_7_0 {
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.24 - 0x14.31 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_cqc_producer_index {
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t val;
};

/* Description -  last index for which an event was created */
/* Size in bytes - 64 */
struct connectib_hw_cqc_last_notified_index {
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.8 - 0x10.31 */
	 u_int32_t val;
};

/* Description -  minimum # of cqes to generate eqe
condition:cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_moderation_cnt_limit_15_8 {
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.7 */
	 u_int8_t val;
};

/* Description -  MSB of physical address translation, 12lsb are VA[11:0] */
/* Size in bytes - 64 */
struct connectib_hw_cqc_pa0_31_12 {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.12 - 0xc.31 */
	 u_int32_t val;
};

/* Description -  when this bit is set, FW should be called */
/* Size in bytes - 64 */
struct connectib_hw_cqc_cq_trap {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.11 - 0xc.11 */
	 u_int8_t val;
};

/* Description -  All the CQEs are written to the same address. Required for CQE coalescing */
/* Size in bytes - 64 */
struct connectib_hw_cqc_shrink {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.10 - 0xc.10 */
	 u_int8_t val;
};

/* Description -  0: no pa fetch
1: single pa (bring next pa when last CQE of page is written)
2: dual pa prefetch */
/* Size in bytes - 64 */
struct connectib_hw_cqc_pa_mode {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.8 - 0xc.9 */
	 u_int8_t val;
};

/* Description -  set to 1 on every CQE creation */
/* Size in bytes - 64 */
struct connectib_hw_cqc_cqe_heartbeat {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.7 - 0xc.7 */
	 u_int8_t val;
};

/* Description -  
condition:cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_db_recovery_enable {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.6 - 0xc.6 */
	 u_int8_t val;
};

/* Description -  CQ start address is: cq_page_offset &lt;&lt; (crspace+6)
It was changed to log page size from the context */
/* Size in bytes - 64 */
struct connectib_hw_cqc_cq_page_offset {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.5 */
	 u_int8_t val;
};

/* Description -  MSB of physical address translation, 12lsb are VA[11:0] */
/* Size in bytes - 64 */
struct connectib_hw_cqc_pa0_63_32 {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t val;
};

/* Description -  When pi - ci = lookahead_size ci is read from memory
condition:cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_lookahead_size_7_0 {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.24 - 0x4.31 */
	 u_int8_t val;
};

/* Description -  index of the last CQE with SE bit set
condition:cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_last_solicited_index {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_cqc_last_notified_check_for_arm_en {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t val;
};

/* Description -  
condition:cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_poll_cq_queue_in_error_state {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t val;
};

/* Description -  
condition:cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_poll_cq_cqe_with_error_generated_on_this_queue {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t val;
};

/* Description -  page_size = 4096*2^log_page_size */
/* Size in bytes - 64 */
struct connectib_hw_cqc_log_page_size {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.24 - 0x0.28 */
	 u_int8_t val;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_cqc_pa_error {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.22 - 0x0.23 */
	 u_int8_t val;
};

/* Description -  qe_coalesce_checksum - Shomron only!!!
msix:
1: send interupt to MSIX
0:send interupt to int pin
condition:~cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_cqe_coalesce_checksum_msix {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t val;
};

/* Description -  CQE size: 0-64B, 1-128B
condition:cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_cqe_128b_size {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t val;
};

/* Description -  when this bit is cleared IRISC should be called */
/* Size in bytes - 64 */
struct connectib_hw_cqc_cqc_valid {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t val;
};

/* Description -  When pi - ci = lookahead_size ci is read from memory
condition:cq */
/* Size in bytes - 64 */
struct connectib_hw_cqc_lookahead_size_23_8 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t val;
};

/* Description -  to be used in core2phy interface */
/* Size in bytes - 4 */
struct connectib_mlnx_enhanced_equal_info_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t mlpn_100kr4_extended_time_sup;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t mlpn_100cr4_extended_time_sup;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t mlpn_40cr4_extended_time_sup;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t mlpn_40kr4_extended_time_sup;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t mlpn_kr_extended_time_sup;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t edr_rx_atten_sup;
	/* Description -  */
	/* 0x0.6 - 0x0.10 */
	 u_int8_t edr_rx_atten;
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t fdr_rx_atten_sup;
	/* Description -  */
	/* 0x0.12 - 0x0.16 */
	 u_int8_t fdr_rx_atten;
	/* Description -  */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t qdr_ddr_ts3_rev;
};

/* Description -  mlpn cability (ability)/ admin (request) bits for ScratchPad (not in pages foramt) */
/* Size in bytes - 4 */
struct connectib_mlpn_database_all_protocol_bits_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t fdr_8_10;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t mlx_kr2;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t eth_56gb;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t fdr10;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t speed_reduction;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t width_reduction;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t eth_cbf;
	/* Description -  */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t ib_64b_credits;
	/* Description - llr_en. ability/request according to node */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t llr_ib_edr;
	/* Description - llr_en. ability/request according to node */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t llr_ib_fdr;
	/* Description - llr_en. ability/request according to node */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t llr_ib_fdr10;
	/* Description - llr_en. ability/request according to node */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t llr_ib_qdr;
	/* Description - llr_en. ability/request according to node */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t llr_ib_ddr;
	/* Description - llr_en. ability/request according to node */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t llr_ib_sdr;
	/* Description - llr_en 56GBASE-KR4. ability/request according to node */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t llr_56_kr4;
	/* Description - llr_en 56GBASE-KX4. ability/request according to node */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t llr_56_kx4;
	/* Description - llr_en 40GBASE-KR4. ability/request according to node */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t llr_kr4;
	/* Description - llr_en 40GBASE-CR4 (copper). ability/request according to node */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t llr_cr4;
	/* Description - llr_en 40GBASE-S/LR4(optics). ability/request according to node */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t llr_slr4;
	/* Description - llr_en 10GBASE-KR (XFI). ability/request according to node */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t llr_kr;
	/* Description - llr_en 10GBASE-CR (copper). ability/request according to node */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t llr_cr;
	/* Description - llr_en 10GBASE-S/LR(optics). ability/request according to node */
	/* 0x0.21 - 0x0.21 */
	 u_int8_t llr_slr;
	/* Description - llr_en 10GBASE-X (XAUI). ability/request according to node */
	/* 0x0.22 - 0x0.22 */
	 u_int8_t llr_xaui;
	/* Description - llr_en. ability/request according to node */
	/* 0x0.23 - 0x0.23 */
	 u_int8_t llr_sgmii;
	/* Description - in page0: protocol ability
in page2: protocol default (may set no more than one protocol bit, none - no default) */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t fc_protocol;
	/* Description - in page0: protocol ability
in page2: protocol default (may set no more than one protocol bit, none - no default) */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t eth_protocol;
	/* Description - in page0: protocol ability
in page2: protocol default (may set no more than one protocol bit, none - no default) */
	/* 0x0.27 - 0x0.27 */
	 u_int8_t ib_protocol;
	/* Description -  */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t ib_64_66_spec_recovery;
	/* Description - in page0: protocol ability
in page2: protocol default (may set no more than one protocol bit, none - no default) */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t ib_128b_llr;
	/* Description - in page0: protocol ability
in page2: protocol default (may set no more than one protocol bit, none - no default) */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t ll_llr;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_serdes_preset_sets_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_serdes_conf_preset_tx_ini tx;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_serdes_active_sets_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - set0: half active fibre IB 8/10
set1: active fibre IB 8/10\
;set2: half active fibre IB FDR (64/66)
set3: active fibre IB FDR (64/66) */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_serdes_active_rx_ini rx;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - set0: half active fibre 8/10
set1: active fibre 8/10
set2: half active fibre FDR (64/66)
set3: active fibre FDR (64/66) */
	/* 0x20.0 - 0x30.31 */
	 struct connectib_serdes_active_tx_ini tx;
};

/* Description -   */
/* Size in bytes - 120 */
struct connectib_serdes_force_sets_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - set0: force sdr
set1: force ddr
set2: force qdr
set3: forc
e fdr
set4: aggressor
set5: force xaui
set6: force sgmii
set7: force xfi
set8: ffe initial
set9: for slicer4err calib */
	/* 0x0.0 - 0x50.31 */
	 struct connectib_serdes_force_rx_ini rx;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - set0: force sdr
set1: force ddr
set2: force qdr
set3: forc
e fdr
set4: aggressor
set5: force xaui
set6: force sgmii
set7: force xfi
set9: for slicer4err calib */
	/* 0x50.0 - 0x78.31 */
	 struct connectib_serdes_force_tx_ini tx;
};

/* Description -   */
/* Size in bytes - 384 */
struct connectib_serdes_aba_sets_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - sets 0-7   : IB 8/10
sets 8-15 : IB 8/10 for legacy device
sets16-31: IB FDR */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_serdes_conf_aba_rx_ini rx;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description - sets 0-7   : IB 8/10
sets 8-15 : IB 8/10 for legacy device
sets16-31: IB FDR */
	/* 0x100.0 - 0x180.31 */
	 struct connectib_serdes_conf_aba_tx_ini tx;
};

/* Description -   */
/* Size in bytes - 384 */
struct connectib_serdes_autoneg_sets_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_serdes_conf_autoneg_rx_ini rx;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 0x100.0 - 0x180.31 */
	 struct connectib_serdes_conf_autoneg_tx_ini tx;
};

/* Description -   */
/* Size in bytes - 76 */
struct connectib_spec1_3_preset_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - mask for the TX preset in FDR.
only the preset indexes that their bit is set in the mask will be checked. */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t preset_tx_mask_internal;
	/* Description - mask for the TX preset in FDR.
only the preset indexes that their
bit is set in the mask will be checked. */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t preset_tx_mask;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.4 */
	 u_int8_t aba_mask0_start;
	/* Description -  */
	/* 0x4.8 - 0x4.12 */
	 u_int8_t aba_mask0_end;
	/* Description -  */
	/* 0x4.14 - 0x4.15 */
	 u_int8_t tx_ABA_en_mask;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t aba_mask0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.4 */
	 u_int8_t aba_mask1_start;
	/* Description -  */
	/* 0x8.8 - 0x8.12 */
	 u_int8_t aba_mask1_end;
	/* Description - mask per port 
ABA                = 0x0
ABA_legacy       = 0x1 */
	/* 0x8.14 - 0x8.15 */
	 u_int8_t tx_ABA_mode_mask;
	/* Description -  */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t aba_mask1;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.4 */
	 u_int8_t aba_mask2_start;
	/* Description -  */
	/* 0xc.8 - 0xc.12 */
	 u_int8_t aba_mask2_end;
	/* Description -  */
	/* 0xc.16 - 0xc.31 */
	 u_int16_t aba_mask2;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.4 */
	 u_int8_t aba_mask3_start;
	/* Description -  */
	/* 0x10.8 - 0x10.12 */
	 u_int8_t aba_mask3_end;
	/* Description -  */
	/* 0x10.16 - 0x10.31 */
	 u_int16_t aba_mask3;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.4 */
	 u_int8_t aba_mask4_start;
	/* Description -  */
	/* 0x14.8 - 0x14.12 */
	 u_int8_t aba_mask4_end;
	/* Description -  */
	/* 0x14.16 - 0x14.31 */
	 u_int16_t aba_mask4;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.4 */
	 u_int8_t aba_mask5_start;
	/* Description -  */
	/* 0x18.8 - 0x18.12 */
	 u_int8_t aba_mask5_end;
	/* Description -  */
	/* 0x18.16 - 0x18.31 */
	 u_int16_t aba_mask5;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x4c.31 */
	 struct connectib_aba_indexes aba_indexes;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_ib_ini_per_lcl_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t spec1_2_ib_support;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t spec1_3_ib_support;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t fec_request_fdr;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t fec_request_fdr10;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t heartbeat_enable;
	/* Description -  */
	/* 0x0.5 - 0x0.8 */
	 u_int8_t force_speed_val;
	/* Description -  */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t force_speed_en;
	/* Description -  */
	/* 0x0.10 - 0x0.13 */
	 u_int8_t force_width_val;
	/* Description -  */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t force_width_en;
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t force_qdr_is_fdr10_val;
	/* Description -  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t force_qdr_is_fdr10_en;
	/* Description -  */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t force_llr_fdr_en;
	/* Description -  */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t force_llr_fdr_val;
	/* Description -  */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t force_llr_fdr10_en;
	/* Description -  */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t force_llr_fdr10_val;
	/* Description -  */
	/* 0x0.21 - 0x0.21 */
	 u_int8_t mlpn_en;
	/* Description -  */
	/* 0x0.22 - 0x0.22 */
	 u_int8_t llr_cell_size;
	/* Description -  */
	/* 0x0.23 - 0x0.23 */
	 u_int8_t speed_reduction_force;
	/* Description -  */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t width_reduction_force;
	/* Description -  */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t llr_fdr10_force;
	/* Description -  */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t llr_fdr_force;
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t spec1_2_legacy_mode;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t llr_disable_failsafe;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_serdes_param_mask_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_serdes_param_mask_per_proto_ini encode_8_10;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_serdes_param_mask_per_proto_ini encode_64_66;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 struct connectib_serdes_param_mask_per_proto_ini encode_kr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 struct connectib_serdes_param_mask_per_proto_ini fdr;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_data_tpt_capabilities {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 1 when log_max_payload_size is configurable - when ticket #869555 closed pick the node from EAS_st */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t log_max_payload_size_supported;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tpt_conf {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0x0: AUTO
MATIC
0xC: _4KB */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t log_max_payload_size;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_nv_global_pci_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - True when non_prefetchable_pf_bar field is configurable. */
	/* 0x0.23 - 0x0.23 */
	 u_int8_t non_prefetchable_pf_bar_supported;
	/* Description - When set, t
he log_pf_uar_bar_size field is configurable and the max
_log_pf_uar_bar_size field is valid. */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t pf_bar_size_supported;
	/* Description - When set, t
he log_vf_uar_bar_size field is configurable and the max
_log_vf_uar_bar_size field is valid. */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t vf_bar_size_supported;
	/* Description - Wh
en 
set, 
t
h
e num_pf_msix field is configurable and the max_num_p
f_msix field is valid. */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t num_pf_msix_supported;
	/* Description - When set, t
he num_vf_msix field is configurable and the max
_num_vf_msix field is valid. */
	/* 0x0.27 - 0x0.27 */
	 u_int8_t num_vf_msix_supported;
	/* Description - When set, th
e num_pfs field is configurable and max_num_pfs is valid. */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t num_pfs_supported;
	/* Description - When set, the NIC will only respect an NV_GLOBAL_PCI_CONF TLV 
if the total bar size required for all PFs and VFs is lower or equal to the 
number specified in the max_total_bar field below. */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t max_total_bar_valid;
	/* Description - When set, the NIC will only respect NV_GLOBAL_PCI_CONF TLV if 
the total MSIX required for all PFs and VFs is lower or equal to the num
ber specified in the max_total_msix field below. */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t max_total_msix_valid;
	/* Description - When set, the NIC will only respect NV_GLOBAL_PCI_CONF TLV if 
its total_vfs parameter is lower than or equal to the value of the max
_vfs_per_pf field below. */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t max_vfs_per_pf_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The maximum number of VFs that can be set in the total_vfs setting (per 
PF)
. */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t max_vfs_per_pf;
	/* Description - Maximum number of PFs */
	/* 0x4.16 - 0x4.19 */
	 u_int8_t max_num_pfs;
	/* Description - When set, f
unction per-port setting is configurable */
	/* 0x4.29 - 0x4.29 */
	 u_int8_t fpp_support;
	/* Description - When set, th
e device supports controlling the VF QoS setting. */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t vf_qos_control_support;
	/* Description - When set, SR-IOV support is configurable by the NV_GLOBAL_PCI_
CONF sriov_en bit. */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t sriov_support;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Log 2 of the maximum size (in MBs) of a PF"s UAR BAR */
	/* 0x8.0 - 0x8.5 */
	 u_int8_t max_log_pf_uar_bar_size;
	/* Description - Log 2 of the maximum size (in MBs) of a VF"s UAR BAR */
	/* 0x8.6 - 0x8.11 */
	 u_int8_t max_log_vf_uar_bar_size;
	/* Description - Maximum number of MSI-X vectors and EQs per PF. */
	/* 0x8.12 - 0x8.21 */
	 u_int16_t max_num_pf_msix;
	/* Description - Maximum number of MSI-X vectors and EQs per VF. */
	/* 0x8.22 - 0x8.31 */
	 u_int16_t max_num_vf_msix;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Maximum number of MSI-X for the aggregate of all PFs and VFs. */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t max_total_msix;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Maximum total of the MMIO space for all PFs and VFs combined, in 
megabytes.
Note: if the number of PF or VF per port is not a power of 2, this param
eter will also not be a power of 2 */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t max_total_bar;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_nv_global_pci_conf {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t toolpf_en;
	/* Description - When set, the PF BAR 'prefetchable' bit is cleared.
Note: PCI switches and operation systems have dedicated quotas for 
non-prefetchable memory hence, you may need to decrease log_p
f_uar_bar_size to enable this feature. */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t non_prefetchable_pf_bar;
	/* Description - When True, non_prefetchable_bar field and allow_large_non_prefetch
able_pf_bar overrides the default value. */
	/* 0x0.23 - 0x0.23 */
	 u_int8_t non_prefetchable_pf_bar_valid;
	/* Description - When set, the pf_bar_size field is valid. 
When cleared, the device uses the "factory_settings" value. */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t pf_bar_size_valid;
	/* Description - When set, the vf_bar_size field is valid. 
When cleared, the device uses the "factory_settings" value. */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t vf_bar_size_valid;
	/* Description - When set, the num_pf_msix field is valid. 
When cleared, the device uses the "factory_settings" value. */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t num_pf_msix_valid;
	/* Description - When set, the num_vf_msix field is valid. 
When cleared, the device uses the "factory_settings" value. */
	/* 0x0.27 - 0x0.27 */
	 u_int8_t num_vf_msix_valid;
	/* Description - When set, the num_pfs field is valid. 
When cleared, the device uses the "factory_settings" value. */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t num_pfs_valid;
	/* Description - When set, the fpp field is valid. 
When cleared, the device uses the "factory_settings" value. */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t fpp_valid;
	/* Description - When set, the full_vf_qos field is valid. 
When cleared, the device uses the "factory_settings" value. */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t full_vf_qos_valid;
	/* Description - When set, the sriov field is valid. 
When cleared, the device uses the "factory_settings" value. */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t sriov_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The total number of 
Virtual Functions (
VFs
)
 that can be supported, for 
each PF. */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t total_vfs;
	/* Description - Total number of PCIe functions (PFs) exposed by the device. The num
ber of PFs must be a multiple of the number of ports */
	/* 0x4.16 - 0x4.19 */
	 u_int8_t num_pfs;
	/* Description - When this bit is cleared, the device exposes a single PCI function for 
both ports. When set, the device exposes one or more PCI functions for 
each port (this is the only mode supported by ConnectX-4 devices). */
	/* 0x4.29 - 0x4.29 */
	 u_int8_t fpp_en;
	/* Description - When set, Virtual Function has the same number of traffic classes as 
physical functions. */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t full_vf_qos;
	/* Description - Enable Single-Root I/O Virtualization (SR-IOV) */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t sriov_en;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Log 2 of the size of a PF"s UAR BAR in MBs. */
	/* 0x8.0 - 0x8.5 */
	 u_int8_t log_pf_uar_bar_size;
	/* Description - Log 2 of the size of a VF"s UAR BAR in MBs. */
	/* 0x8.6 - 0x8.11 */
	 u_int8_t log_vf_uar_bar_size;
	/* Description - Number of MSI-X vectors and EQs per PF. */
	/* 0x8.12 - 0x8.21 */
	 u_int16_t num_pf_msix;
	/* Description - Number of MSI-X vectors and EQs per VF. */
	/* 0x8.22 - 0x8.31 */
	 u_int16_t num_vf_msix;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_pcie_acs_ctrl_fields {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t acs_source_validation;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t acs_translation_blocking;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t acs_p2p_request_redirect;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t acs_p2p_complition_redirect;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t acs_upstream_forwarding;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t acs_p2p_egress_control;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t acs_direct_translated_p2p;
	/* Description -  */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t egress_controll_vector_size;
	/* Description -  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t acs_source_validation_enable;
	/* Description -  */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t acs_translation_blocking_enable;
	/* Description -  */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t acs_p2p_request_redirect_enable;
	/* Description -  */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t acs_p2p_complition_redirect_enable;
	/* Description -  */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t acs_p2p_upstream_forwarding_enable;
	/* Description -  */
	/* 0x0.21 - 0x0.21 */
	 u_int8_t acs_p2p_egress_control_enable;
	/* Description -  */
	/* 0x0.22 - 0x0.22 */
	 u_int8_t acs_direct_translated_p2p_enable;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_header_log {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t hdr_127_96;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t hdr_95_64;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t hdr_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t hdr_31_0;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_advanced_error_cap_ctl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The first error reported in the Uncorrectable Error
5'd15 : //CA(nsi) : can not happened, not supported by HW
5'd0  : //Undefined (Previously was Link Training Error of PHy)
5'd4  : //DLU  : log 32 MSB of the received DLLPs (not compliant)  
5'd13 : //FCPE : have no hdr to log
5'd19 : //ECRC
5'd18 : //ML
5'd17 : //OVF
5'd16 : //UX
5'd20 : //UR
5'd15 : //CA(drx)  : have no hdr to log (not supported by HW in CX3)
5'd12 : //Poison
5'd14 : // CTO : have no hdr to log */
	/* 0x0.0 - 0x0.4 */
	 u_int8_t first_error_pointer;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t ecrc_generation_cap;
	/* Description - This bit when set enables ECRC generation (see Section 2.7).
 Default value of this field is 0.
RWS */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t ecrc_generation_enable;
	/* Description -  */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t ecrc_check_cap;
	/* Description - This bit when set enables ECRC checking (see Section 2.7).
Default value of this field is 0.
RWS */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t ecrc_check_enable;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_correctable_error_mask {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - RWS */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t receiver_error_mask;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t reserved1;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t reserved2;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t reserved3;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t reserved4;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t reserved5;
	/* Description - RWS */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t bad_tlp_mask;
	/* Description - RWS */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t bad_dllp_mask;
	/* Description - RWS */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t replay_num_rollover_mask;
	/* Description -  */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t reserved9;
	/* Description -  */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t reserved10;
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t reserved11;
	/* Description - RWS */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t replay_timer_timeout_mask;
	/* Description - Advisory Non-Fatal Error Mask.
This bit is Set by default to enable compatibility with software that
does not comprehend Role-Based Error Reporting */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t advisory_non_fatal_err_mask;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_correctable_error_status {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - RW1CS */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t receiver_error_status;
	/* Description - RW1CS */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t bad_tlp_status;
	/* Description - RW1CS */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t bad_dllp_status;
	/* Description - RW1CS */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t replay_num_rollover_status;
	/* Description - RW1CS */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t replay_timer_timeout_status;
	/* Description - Advisory Non-Fatal Error Status
RW1CS */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t advisory_nonftl_err_status;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_uncorrectable_error_severity {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - RWS */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t training_error_severity;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t reserved1;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t reserved2;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t reserved3;
	/* Description - RWS */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t data_link_protocol_error;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t reserved5;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t reserved6;
	/* Description -  */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t reserved7;
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t reserved8;
	/* Description -  */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t reserved9;
	/* Description -  */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t reserved10;
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t reserved11;
	/* Description - RWS */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t poisoned_tlp;
	/* Description - RWS */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t flow_control_protocol_error;
	/* Description - RWS */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t completion_timeout;
	/* Description - RWS */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t completer_abort;
	/* Description - RWS */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t unexpected_completion;
	/* Description - RWS */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t receiver_overflow;
	/* Description - RWS */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t malformed_tlp;
	/* Description - RWS */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t ecrc_error;
	/* Description - RWS */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t unsupported_request_error;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_uncorrectable_error_mask {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - RWS */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t training_error_mask;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t reserved1;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t reserved2;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t reserved3;
	/* Description - RWS */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t data_link_protocol_error;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t reserved5;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t reserved6;
	/* Description -  */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t reserved7;
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t reserved8;
	/* Description -  */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t reserved9;
	/* Description -  */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t reserved10;
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t reserved11;
	/* Description - RWS */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t poisoned_tlp;
	/* Description - RWS */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t flow_control_protocol_error;
	/* Description - RWS */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t completion_timeout;
	/* Description - RWS */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t completer_abort;
	/* Description - RWS */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t unexpected_completion;
	/* Description - RWS */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t receiver_overflow;
	/* Description - RWS */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t malformed_tlp;
	/* Description - RWS */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t ecrc_error;
	/* Description - RWS */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t unsupported_request_error;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_uncorrectable_error_status {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Undefined
previously was training_error_status */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t training_error_status;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t data_link_protocol_error_status;
	/* Description -  */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t poisoned_tlp_status;
	/* Description -  */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t flow_control_protocol_error_status;
	/* Description -  */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t completion_timeout_status;
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t completer_abort_status;
	/* Description -  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t unexpected_completion_status;
	/* Description -  */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t receiver_overflow_status;
	/* Description -  */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t malformed_tlp_status;
	/* Description -  */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t ecrc_error_status;
	/* Description -  */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t unsupported_request_error_status;
};

/* Description -  Basic address register high bits - for 64bit bar address length */
/* Size in bytes - 4 */
struct connectib_bar_high {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - BAR[63:32] */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t addr_63_32;
};

/* Description -  Basic address register low bits */
/* Size in bytes - 4 */
struct connectib_bar_low {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0-map to memory space, 1-map to io space */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t memory_or_io;
	/* Description - address length: 0-mapping to the 32bit address space, 2-mapping to the 64bit address space */
	/* 0x0.1 - 0x0.2 */
	 u_int8_t type;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t prefetchable;
	/* Description - BAR[31:4] */
	/* 0x0.4 - 0x0.31 */
	 u_int32_t addr_31_4;
};

/* Description -  SR-IOV status register */
/* Size in bytes - 2 */
struct connectib_sriov_status {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - VF Migration Status */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t vf_mig_status;
};

/* Description -  SR-IOV control register */
/* Size in bytes - 2 */
struct connectib_sriov_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - VF Enable */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t vf_enable;
	/* Description - VF Migration Enable */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t vf_migration_en;
	/* Description - VF Migration Interrupt Enable */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t vf_migration_int_en;
	/* Description - VF MSE */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t vf_mse;
	/* Description - ARI Capable Hierarchy */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t ari_capable_hierarchy;
};

/* Description -  SR-IOV capability struct */
/* Size in bytes - 4 */
struct connectib_sriov_capabilities {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - VF migration capable */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t vf_mig_capable;
	/* Description - ARI Capable Hierarchy Preserved */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t ari_cap_hier_preserved;
	/* Description - VF Migration Interrupt Message Number */
	/* 0x0.21 - 0x0.31 */
	 u_int16_t vf_mig_int_msg_num;
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_ari_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t mfvc_en;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t acs_en;
	/* Description -  */
	/* 0x0.4 - 0x0.6 */
	 u_int8_t func_group;
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_ari_capabilities {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t mfvc;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t acs;
	/* Description - next pf number */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t next_func_num;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_lane_eql_ctl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t downstream_port_transmitter_preset0;
	/* Description -  */
	/* 0x0.4 - 0x0.6 */
	 u_int8_t downstream_port_receiver_preset_hint0;
	/* Description -  */
	/* 0x0.8 - 0x0.11 */
	 u_int8_t upstream_port_transmitter_preset0;
	/* Description -  */
	/* 0x0.12 - 0x0.14 */
	 u_int8_t upstream_port_receiver_preset_hint0;
	/* Description -  */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t downstream_port_transmitter_preset1;
	/* Description -  */
	/* 0x0.20 - 0x0.22 */
	 u_int8_t downstream_port_receiver_preset_hint1;
	/* Description -  */
	/* 0x0.24 - 0x0.27 */
	 u_int8_t upstream_port_transmitter_preset1;
	/* Description -  */
	/* 0x0.28 - 0x0.30 */
	 u_int8_t upstream_port_receiver_preset_hint1;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_pciex_link_ctl3 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t perform_equalization;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t link_equalization_req_int_en;
};

/* Description -  Bridge Control */
/* Size in bytes - 2 */
struct connectib_bridge_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t parity_error_response_enable;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t serr_enable;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t secondary_bus_reset;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_exp_rom {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - expansion ROM exist */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t exp_rom_en;
	/* Description - ADDR[31:11] */
	/* 0x0.11 - 0x0.31 */
	 u_int32_t addr_31_11;
};

/* Description -  Secondary Status */
/* Size in bytes - 2 */
struct connectib_secondary_status {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t master_data_parity_error;
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t signaled_target_abort;
	/* Description -  */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t received_target_abort;
	/* Description -  */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t received_master_abort;
	/* Description -  */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t received_system_error;
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t detected_parity_error;
};

/* Description -  Header Type */
/* Size in bytes - 1 */
struct connectib_header_type {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Header Layout */
	/* 0x0.0 - 0x0.6 */
	 u_int8_t header_layout;
	/* Description - Multi-Function Device */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t multi_function_device;
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_stat_reg1 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t int_status;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t capabilities_list;
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t master_data_perr;
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t signaled_ta;
	/* Description -  */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t received_ta;
	/* Description -  */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t received_ma;
	/* Description -  */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t signaled_serr;
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t detected_perr;
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_cmd_reg1 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t io_space;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t memory_space;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t bus_master_en;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t perr_enable;
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t serr_enable;
	/* Description -  */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t int_disable;
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_message_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - num of msix vectors */
	/* 0x0.0 - 0x0.10 */
	 u_int16_t table_size;
	/* Description - If 1, all vectors of this function are masked regardless of their per vector mask bit   */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t function_mask;
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t msix_en;
};

/* Description -  PCI express link status register2 */
/* Size in bytes - 2 */
struct connectib_link_stat2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t current_de_emphasis_level;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t equalization_complete;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t equalization_phase1_successful;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t equalization_phase2_successful;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t equalization_phase3_successful;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t link_equalization_request;
};

/* Description -  PCI express link control register2 */
/* Size in bytes - 2 */
struct connectib_link_ctl2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t target_link_speed;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t enter_compliance;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t hardware_autonomous_speed_disable;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t selectable_de_emphasis;
	/* Description -  */
	/* 0x0.7 - 0x0.9 */
	 u_int8_t transmit_margin;
	/* Description -  */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t modified_compliance;
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t compliance_sos;
	/* Description -  */
	/* 0x0.12 - 0x0.15 */
	 u_int8_t compliance_preset_de_emphasis;
};

/* Description -  PCI express link capabilities register2 */
/* Size in bytes - 4 */
struct connectib_link_caps2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.1 - 0x0.7 */
	 u_int8_t supported_link_speed_vector;
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t cross_link_supported;
};

/* Description -  PCI express device status register2 */
/* Size in bytes - 2 */
struct connectib_device_stat2 {
};

/* Description -  PCI express device control register2 */
/* Size in bytes - 2 */
struct connectib_device_ctl2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t completion_timeout_value;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t completion_timeout_disable;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t ari_forwarding_enable;
	/* Description -  */
	/* 0x0.13 - 0x0.14 */
	 u_int8_t obff_enable;
};

/* Description -  PCI express device capabilities register2 */
/* Size in bytes - 4 */
struct connectib_device_caps2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t completion_timeout_ranges_supported;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t completion_timeout_disable_supported;
	/* Description -  */
	/* 0x0.5 - 0x0.7 */
	 u_int8_t ari_forwarding_supported;
	/* Description -  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t _10bit_tag_completer_supported;
	/* Description -  */
	/* 0x0.18 - 0x0.19 */
	 u_int8_t obff_supported;
	/* Description -  */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t extended_fmt_field_supported;
};

/* Description -  PCI express slot capabilities register */
/* Size in bytes - 4 */
struct connectib_slot_caps {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t attention_button_present;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t power_controller_present;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t mrl_sensor_present;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t attention_indicator_present;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t power_indicator_present;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t hot_plug_surprise;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t hot_plug_capable;
	/* Description -  */
	/* 0x0.7 - 0x0.14 */
	 u_int8_t slot_power_limit_value;
	/* Description -  */
	/* 0x0.15 - 0x0.16 */
	 u_int8_t slot_power_limit_scale;
	/* Description -  */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t electromechanical_interlock_present;
	/* Description -  */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t no_command_completed_supported;
	/* Description -  */
	/* 0x0.19 - 0x0.31 */
	 u_int16_t physical_slot_number;
};

/* Description -  PCI express link status register */
/* Size in bytes - 2 */
struct connectib_link_stat {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t link_speed;
	/* Description -  */
	/* 0x0.4 - 0x0.9 */
	 u_int8_t negotiated_link_width;
	/* Description -  */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t training_error;
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t link_training;
	/* Description -  */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t slot_clock_cfg;
	/* Description -  */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t link_bandwidth_mgmt_status;
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t link_autonomous_bandwidth_status;
};

/* Description -  PCI express link control register */
/* Size in bytes - 2 */
struct connectib_link_ctl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.1 */
	 u_int8_t aspm_control;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t rcb;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t link_disable;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t retrain_link;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t common_clock_configuration;
	/* Description -  */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t extended_synch;
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t enable_clock_power_management;
	/* Description -  */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t hardware_autonomous_width_disable;
	/* Description -  */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t link_bandwidth_mgmt_interrupt_en;
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t link_autonomous_bandwidth_interrupt_en;
};

/* Description -  PCI express link capabilities register */
/* Size in bytes - 4 */
struct connectib_link_caps {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t max_link_speed;
	/* Description -  */
	/* 0x0.4 - 0x0.9 */
	 u_int8_t max_link_width;
	/* Description -  */
	/* 0x0.10 - 0x0.11 */
	 u_int8_t aspm_support;
	/* Description -  */
	/* 0x0.12 - 0x0.14 */
	 u_int8_t l0s_exit_latency;
	/* Description -  */
	/* 0x0.15 - 0x0.17 */
	 u_int8_t l1_exit_latency;
	/* Description -  */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t clock_power_management;
	/* Description -  */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t surprise_down_error_reporting_cap;
	/* Description -  */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t link_active_reporting_cap;
	/* Description -  */
	/* 0x0.21 - 0x0.21 */
	 u_int8_t link_bw_notification_cap;
	/* Description -  */
	/* 0x0.22 - 0x0.22 */
	 u_int8_t aspm_optionality_compliance;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t port_number;
};

/* Description -  PCI express device status register */
/* Size in bytes - 2 */
struct connectib_device_stat {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t correctable_error;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t non_fatal_error;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t fatal_error;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t unsupported_request;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t aux_power;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t transactions_pending;
};

/* Description -  PCI express device control register */
/* Size in bytes - 2 */
struct connectib_device_ctl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t correctable_error_report;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t non_fatal_error_report;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t fatal_error_report;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t unsupported_request_report;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t relaxed_ordering;
	/* Description -  */
	/* 0x0.5 - 0x0.7 */
	 u_int8_t max_payload_size;
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t extended_tag_field_en;
	/* Description -  */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t phantom_funcs;
	/* Description -  */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t aux_power;
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t no_snoop;
	/* Description -  */
	/* 0x0.12 - 0x0.14 */
	 u_int8_t max_read_request_size;
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t initiate_function_level_reset;
};

/* Description -  PCI express device capabilities register */
/* Size in bytes - 4 */
struct connectib_device_caps {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.2 */
	 u_int8_t max_payload_size_supported;
	/* Description -  */
	/* 0x0.3 - 0x0.4 */
	 u_int8_t phantom_funcs;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t extended_tag_field_sup;
	/* Description -  */
	/* 0x0.6 - 0x0.8 */
	 u_int8_t l0s_acceptable_latency;
	/* Description -  */
	/* 0x0.9 - 0x0.11 */
	 u_int8_t l1_acceptable_latency;
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t role_based_error_reporting;
	/* Description -  */
	/* 0x0.18 - 0x0.25 */
	 u_int8_t captured_slot_power_limit_value;
	/* Description -  */
	/* 0x0.26 - 0x0.27 */
	 u_int8_t captured_slot_power_limit_scale;
	/* Description -  */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t function_level_reset_capability;
};

/* Description -  PCI express device capabilities reg1 */
/* Size in bytes - 2 */
struct connectib_pciex_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t version;
	/* Description -  */
	/* 0x0.4 - 0x0.7 */
	 u_int8_t device_port_type;
	/* Description - slot implemented */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t slot;
	/* Description -  */
	/* 0x0.9 - 0x0.13 */
	 u_int8_t int_message_num;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_external_port_pf_array {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Port owner (PF array, pf_ix = (host_ix)*max_num_pfs_per_host_ini_value + func_num) */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_pf_array_default_ones port_owner;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Allow read counters (PF array, pf_ix = (host_ix)*max_num_pfs_per_host_ini_value + func_num) */
	/* 0x8.0 - 0x10.31 */
	 struct connectib_pf_array_default_ones allow_rd_counters;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Renegotiate only on config change (PF array, pf_ix = (host_ix)*max_num_pfs_per_host_ini_value + func_num) */
	/* 0x10.0 - 0x18.31 */
	 struct connectib_pf_array_default_ones reneg_on_change;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_data_curr_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - indicates who was the last writer id to write/invalidate tlv */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t current_cfg_method;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_config_flex_nic {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0x0 - user image
0x1 - factory default
other - reserved - remove when #844406 closed - pick the node from EAS_st */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t fpga_image_bank;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_config_host_2_bmc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0x0 - No traffic is looped-back in the device 
 0x1 - Enable traffic from host 2 local BMC - remove when ticket #843912 closed and pick node from EAS_st */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t host_2_bmc_traffic_enable;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_tweaks {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Enable packet pacing */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t packet_pacing;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_nv_sw_offload_conf {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Configure which algorithm should be used by the NIC in order 
to decide when to activate CQE compression based on PCIe bus 
condition.Note that the driver can enable compression on a per 
CQE basis
0x0: BALANCED
0x1: AGGRESSIVE */
	/* 0x0.0 - 0x0.2 */
	 u_int8_t cqe_compression;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t one_qp_per_recovery;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Log2 of Large Receive Offload (LRO) timeout #0, in microsec
onds. Driver can select one of the 4 configured LRO timeouts on 
a per Qp basis in run-time (lro_timeout_period_usecs field of the 
TIR context) */
	/* 0x4.0 - 0x4.3 */
	 u_int8_t lro_log_timeout0;
	/* Description - Log2 of Large Receive Offload (LRO) timeout #1, in microsec
onds. Driver can select one of the 4 configured LRO timeouts on 
a per Qp basis in run-time (lro_timeout_period_usecs field of the 
TIR context) */
	/* 0x4.4 - 0x4.7 */
	 u_int8_t lro_log_timeout1;
	/* Description - Log2 of Large Receive Offload (LRO) timeout #2, in microsec
onds. Driver can select one of the 4 configured LRO timeouts on 
a per Qp basis in run-time (lro_timeout_period_usecs field of the 
TIR context) */
	/* 0x4.8 - 0x4.11 */
	 u_int8_t lro_log_timeout2;
	/* Description - Log2 of Large Receive Offload (LRO) timeout #3, in microsec
onds. Driver can select one of the 4 configured LRO timeouts on 
a per Qp basis in run-time (lro_timeout_period_usecs field of the 
TIR context) */
	/* 0x4.12 - 0x4.15 */
	 u_int8_t lro_log_timeout3;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_roce_1_5_conf {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The next protocol value set in the IPv4/IPv6 packets for RoCE 
v1.5. The default is 0xFE. */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t roce_over_ip_next_protocol;
};

/* Description -   */
/* Size in bytes - 72 */
struct connectib_nv_qos_ets_tc_conf {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x48.31 */
	 struct connectib_nv_ets_tcN_config_reg tc_configuration[8];
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_qos_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Maximum number of VLs supported by the HBA.
0x1: _1_VL - VL0 only
0x2: _2_VLs - VL0, VL1
0x3: _4_VLs - VL0..VL3
0x4: _8_VLs - VL0..VL7
0x5: _15_VLs -- VL0..VL14 (VL15 is always present for 
MADs) */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t max_num_of_vl;
	/* Description - Maximum number of traffic classes supported by the NIC, where 
0 => 8 T
C */
	/* 0x0.4 - 0x0.7 */
	 u_int8_t max_num_of_tc;
	/* Description - Maximum number of priority flow control
supported_from_version: 1 */
	/* 0x0.8 - 0x0.11 */
	 u_int8_t max_num_pfc;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_nv_qos_conf {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Number of Infiniband Virtual Lanes for this port,
 
(s
see vl_admin 
in PVLC Register)
0x1: _1_VL - VL0 only
0x2: _2_VLs - VL0, VL1
0x3: _4_VLs - VL0..VL3
0x4: _8_VLs - VL0..VL7
0x5: _15_VLs --VL0, VL14 (VL15 is always present for MADs) */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t num_of_vl;
	/* Description - Number of traffic classes, when DCB-X is enabled, this is the 
maximum number of TC that can negotiated with the remote 
peer. (see num_of_tc_admin in DCBX_PARAM Register)
0x0: _8_TCs
0x1: _1_TC
0x2: _2_TCs
0x3: _3_TCs
0x4: _4_TCs
0x5: _5_TCs
0x6: _6_TCs
0x7: _7_TCs */
	/* 0x0.4 - 0x0.7 */
	 u_int8_t num_of_tc;
	/* Description - Number of IEEE priorities that may simultaneously support flow 
control. 
 (see pfc_cap_admin DCBX_PARAM Register) */
	/* 0x0.8 - 0x0.11 */
	 u_int8_t num_pfc;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Control pause frame transmission and reception (processing) per 
an IEEE priority
(See prio_pfctx and prio_pfcrx in the PFCC
 r
egister
0x0: DISABLED
0x1: RX_ONLY
0x2: TX_ONLY
0x3: RX_TX */
	/* 0x4.28 - 0x8.27 */
	 u_int8_t priority_pfcc_pfc[8];
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The TC used for a given IEEE priority (see tclass in the QTCT 
register) */
	/* 0x8.28 - 0xc.27 */
	 u_int8_t priority_tc[8];
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_lldp_nb_dcbx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Enable DCBX in IEEE mode */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t ieee_dcbx_en;
	/* Description - Enable DCBX in CEE mode */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t cee_dcbx_en;
	/* Description - Allow the NIC to accept DCBX configuration from the remote 
peer. */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t dcbx_willing;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_nv_lldp_nb_conf {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Interval for sending LLDP NB PDUs in seconds */
	/* 0x0.0 - 0x0.11 */
	 u_int16_t lldp_msg_tx_interval;
	/* Description - Enable DCBX */
	/* 0x0.27 - 0x0.27 */
	 u_int8_t lldp_nb_dcbx;
	/* Description - Enable the internal LLDP client, and define which TLV it will 
process.
0x0: OFF - Not listen for incoming LLDP BPDU (incoming 
LLDP frames will be routed to the host)
0x1: MANDATORY - Listen for incoming LLDP frames, store 
only the mandatory LLDP BPDUs (1..3)
0x2: ALL - Receive and store all incoming LLDP BPDUs */
	/* 0x0.28 - 0x0.29 */
	 u_int8_t lldp_nb_rx_mode;
	/* Description - Select which LLDP TLV will be generated by the NIC
0x0: OFF - NIC internal LLDP client will not send LLDP frames 
0x1: MANDATORY - Transmit only mandatory LLDP BPDU 
(ChassisID, PortID & TTL)
0x2:
 
ALL - Transmit optional LLDP BPDU if configured */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t lldp_nb_tx_mode;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The size in bytes of that the lldp client must reserve for incoming 
TLVs */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t lldp_nb_rx_buffer_size;
	/* Description - The size in bytes of that the lldp client must reserve for transmit
ted TLVs. The buffer size must be big enough to hold all the 
mandatory TLVs (chassisID, PortID & TTL) as well as all the 
optional TLVs that the client need to send. */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t lldp_nb_tx_buffer_size;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_nv_lldp_nb_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - DCB-X supported
supported_from_version:1 */
	/* 0x0.27 - 0x0.27 */
	 u_int8_t lldp_nb_dcbx_en;
	/* Description - 0x0: NA - Reception and storing of LLDP frames is not sup
ported (incoming frames will be forwarded to the host)
0x1: MANDATORY - The client can only store received the 
mandatory LLDP-TLVs 
0x2: ALL - The client can receive and store incoming LLDP 
TLVs */
	/* 0x0.28 - 0x0.29 */
	 u_int8_t lldp_nb_rx_cap;
	/* Description - 0x0: NA - LLDP transmission not supported 
0x1: MANDATORY - The LLDP client only support sending of 
the mandatory LLDP NB TLVs (ChassisID, PortID & TTL)
0x2: ALL - The LLDP client support sending mandatory and 
optional TLVs 
3: reserved */
	/* 0x0.30 - 0x0.31 */
	 u_int8_t lldp_nb_tx_cap;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The maximum supported buffer size for incoming  LLDP TLVs */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t max_lldp_nb_rx_buffer_size;
	/* Description - The maximum supported buffer size for outgoing LLDP TLVs */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t max_lldp_nb_tx_buffer_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The maximum number of optional LLDP TLVs that are sup
ported by the firmware. The firmware is searching of LLDP NB 
TLV to send from type 0x110 to type (0x110 + this field)
Default: 16 */
	/* 0x8.0 - 0x8.6 */
	 u_int8_t max_num_of_tx_optional_lldp_tlv;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_keep_link_up {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - When set, the NIC keeps the link up as long as the server is not in 
standby mode (Ethernet only). */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t keep_eth_link_up;
	/* Description - When set, the NIC keeps the link up as long as the server is not in 
standby mode (InfiniBand only). */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t keep_ib_link_up;
	/* Description - When set, the NIC keeps the link up as long as the server is not in 
standby mode and a driver is not initialized. */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t keep_link_up_on_boot;
	/* Description - When set, the NIC keeps the link up from power-up until the server 
is turned on, and when the server is in standby mode. */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t keep_link_up_on_standby;
	/* Description - When set, the NIC does not clear the ppcnt counters value when the first real os driver lunch init_hca, this bit is mainly for debugging purpose . */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t disable_clear_port_stat_on_loading;
};

/* Description -   */
/* Size in bytes - 68 */
struct connectib_nv_roce_cc_ecn {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - When receiving an CNP, the target rate should be updated if the 
transmission rate was increased due to the timer, and not only 
due to the byte counter */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t clamp_tgt_rate_after_time_inc;
	/* Description - If set, whenever a CNP is processed, the target rate is updated to 
be the current rate. */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t clamp_tgt_rate;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Time between rate increases if no CNPs are received. Given in 
u-seconds. */
	/* 0x4.0 - 0x4.16 */
	 u_int32_t rpg_time_reset;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Transmitted data between rate increases if no CNPs are received. 
Given in Bytes (0=DISABLED) */
	/* 0x8.0 - 0x8.14 */
	 u_int16_t rpg_byte_reset;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The number of times rpByteStage or rpTimeStage can count 
before the RP rate control state machine advances states. */
	/* 0xc.0 - 0xc.4 */
	 u_int8_t rpg_threshold;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The maximum rate, in Mbits per second, at which an RP can 
transmit. Once this limit is reached, the RP rate limited is 
released and the flow is not rate limited any more (0=Full Port 
Speed). */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t rpg_max_rate;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - The rate, in Mbits per second, used to increase rpTargetRate in 
the RPR_ACTIVE_INCREASE. */
	/* 0x14.0 - 0x14.16 */
	 u_int32_t rpg_ai_rate;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - The rate, in Mbits per second, used to increase rpTargetRate in 
the RPR_HYPER_INCREASE state */
	/* 0x18.0 - 0x18.16 */
	 u_int32_t rpg_hai_rate;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - I
f a CNP is received, the flow rate is reduced at the beginning of 
the next rate_reduce_monitor_period interval to (1-Alpha/
Gd)*CurrentRate. rpg_gd is given as log2(Gd), where Gd may 
only be powers of 2. */
	/* 0x1c.0 - 0x1c.3 */
	 u_int8_t rpg_gd;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - The minimum factor by which the current transmit rate can be 
changed when processing a CNP. Value is given as a percentage 
(1-100). */
	/* 0x20.0 - 0x20.7 */
	 u_int8_t rpg_min_dec_fac;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - The minimum value, in Mbits per second, for rate to limit. */
	/* 0x24.0 - 0x24.16 */
	 u_int32_t rpg_min_rate;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - The rate that is set for the flow when a rate limiter is allocated to 
it upon first CNP received, in Mbps (=Full Port Speed) */
	/* 0x28.0 - 0x28.16 */
	 u_int32_t rate_to_set_on_first_cnp;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - Used to update the congestion estimator (alpha) once every 
dce_tcp_rtt microseconds, according to the equation:
Alpha = (cnp_received * dceTcpG) + (1 - dceTcpG) * alpha .
dceTcpG is divided by 2^10.
cnp_received is set to one if a CNP was received for this flow 
during period since the previous update and the current update */
	/* 0x2c.0 - 0x2c.9 */
	 u_int16_t dce_tcp_g;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - The time between updates of the alpha value, in microseconds. */
	/* 0x30.0 - 0x30.16 */
	 u_int32_t dce_tcp_rtt;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - The minimum time between 2 consecutive rate reductions for a 
single flow. Rate reduction will occur only if a CNP is received 
during the relevant time interval. */
	/* 0x34.0 - 0x34.16 */
	 u_int32_t rate_reduce_monitor_period;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - The initial value of alpha to use when receiving the first CNP for 
a flow. Expressed in a fixed point fraction of 2^10
. */
	/* 0x38.0 - 0x38.9 */
	 u_int16_t initial_alpha_value;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Minimum time between sending CNPs from the port, in micro
seconds. */
	/* 0x3c.0 - 0x3c.16 */
	 u_int32_t min_time_between_cnps;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - The 802.1p priority value of the generated CNP for this port */
	/* 0x40.0 - 0x40.2 */
	 u_int8_t cnp_802p_prio;
	/* Description - The DiffServ Code Point of the generated CNP for this port. */
	/* 0x40.8 - 0x40.13 */
	 u_int8_t cnp_dscp;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_roce_cc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Each bit in this mask indicates if the RoCE should be enabled on 
the n-th IEEE priority. */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t roce_cc_enable_pri;
	/* Description - Select RDMA over Converged Ethernet (RoCE) algorithm
0x0: ECN
0x1: QCN */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t roce_cc_algorithm;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_dword_val {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_port_cap_mask1_fields {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t is_sm;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t is_notice_sup;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t is_trap_sup;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t is_optional_ipd_sup;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t is_automatic_migration_sup;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t is_sl_mapping_sup;
	/* Description -  */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t is_mkey_nvram;
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t is_pkey_nvram;
	/* Description -  */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t is_led_info_sup;
	/* Description -  */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t is_sm_disabled;
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t is_system_image_guid_sup;
	/* Description -  */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t is_pkey_switch_external_port_trap_sup;
	/* Description -  */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t is_cable_info_supported;
	/* Description -  */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t is_extended_speed_sup;
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t is_capability_mask2_supported;
	/* Description -  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t is_communication_management_sup;
	/* Description -  */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t is_snmp_tunneling_sup;
	/* Description -  */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t is_reinit_sup;
	/* Description -  */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t is_device_management_sup;
	/* Description -  */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t is_vendor_class_sup;
	/* Description -  */
	/* 0x0.21 - 0x0.21 */
	 u_int8_t is_dr_notice_sup;
	/* Description -  */
	/* 0x0.22 - 0x0.22 */
	 u_int8_t is_capability_mask_notice_sup;
	/* Description -  */
	/* 0x0.23 - 0x0.23 */
	 u_int8_t is_boot_management_sup;
	/* Description -  */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t is_link_round_trip_latency_sup;
	/* Description -  */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t is_client_reregistration_sup;
	/* Description -  */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t is_other_local_changes_notice_supported;
	/* Description -  */
	/* 0x0.27 - 0x0.27 */
	 u_int8_t is_link_speed_width_pairs_table_supported;
	/* Description -  */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t is_vendor_specific_mads_table_supported;
	/* Description -  */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t is_multicast_pkey_trap_suppression_supported;
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t is_multicast_fdb_top_supported;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t is_hierarchy_info_supported;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_dcr_odp_event_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t dcrn;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t valid;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_flow_counter_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Flow counter handle */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t flow_counter_id;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_dest_format_struct {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - When destination_type == VPORT - destination is vport number. Only 
bits[15:0] are valid, bits[23:16] are reserved.
When destination_type == FLOW_TABLE - destination is Flow Table Id.
When destination_type == TIR - destination is TIR.
When destination_type==QP - destination QP Number */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t destination_id;
	/* Description - Defines the destination type. Valid only when action [FWD_DEST] is set
0x
0: VPORT
0x
1: FLOW_TABLE
0x
2: TIR
0x3: QP */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t destination_type;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_odp_hca_params {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t odp_rc;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t odp_uc;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t odp_ud;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t odp_xrc;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t odp_dc;
};

/* Description -   */
/* Size in bytes - 32 */
union connectib_cmdif_ctx_special {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_special_create c;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_special_modify_tir tir;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_special_modify_tis tis;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_special_qp_commands qp;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_special_create_rq rq;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_special_create_srq srq;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_special_create_xrq xrq;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_rqt rqt;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_special_create_eq eq;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_special_create_cq c_cq;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_special_modify_cq m_cq;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_special_mkey mkey;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_special_arm_rq arm_rq;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_special_modify_rmp modify_rmp;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_sniffer sniffer;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_mcg mcg;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_psv psv;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_create_mtt mtt;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_dmfs_fte dmfs_fte;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_dmfs_fg dmfs_fg;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_dmfs_ft dmfs_ft;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_l2_table l2_table;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_modify_rq modify_rq;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_modify_sq modify_sq;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_create_lag lag;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_fpga_access_reg fpga_access_reg;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_cmdif_ctx_fpga_cap fpga_cap;
};

/* Description -   */
/* Size in bytes - 4 */
union connectib_flush_type {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_flush_type_bits bits;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_flush_type_bitmask bitmask;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_general_notification_delay_drop_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The User Index of the RQ that cause the timeout */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t rq_user_index_delay_drop;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_pps_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Indicating the pin where PPS event was generated */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t pin;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - MSB of 
t
he device time when it was triggered from the exter
nal GPIO pin. 
In_time for ptp_in, and out_time for ptp_out.
Time is in units of device clock. Device clock frequency can 
be fetched from HCA_CAP.device_frequency */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t time_stamp_h;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - MSB of 
t
he device time when it was triggered from the exter
nal GPIO pin. 
In_time for ptp_in, and out_time for ptp_out.
Time is in units of device clock. Device clock frequency can 
be fetched from HCA_CAP.device_frequency */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t time_stamp_l;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_fpga_qp_error_event {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 0x1: retry_counter_expired
0x2: RNR_expired */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t syndrome;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - FPGA QP Number */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t fpga_qpn;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_fpga_error_event {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 0x1: corrupted_ddr
0x2: flash_timeout
0x3: internal_link_error
0x4: watchdog_failure
0x5: I2C_failure
0x6: Image_changed */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t syndrome;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_nic_vport_change_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Which function requested to claim or reclaim pages
0 - my hca.
others - function_id of specific vhca. used by vhca_group_man
ager(HCA_CAP.vhca_group_manager ==1). */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t vport_num;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_pages_req_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Which function requested to claim or reclaim pages
0 - my hca.
others - function_id of specific vhca. used by vhca_group_man
ager(HCA_CAP.vhca_group_manager ==1). */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t function_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Number of missing / unneeded pages (signed number, msb indicate sign). 
This is just a recommendation for the driver. the actual number of pages 
that the driver deliver to the device is as set in the MANAGE_PAGES 
command. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t num_pages;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_cmd_inter_comp_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Bits in this vector are set for commands completed and not yet 
reported by event */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t command_completion_vector;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_stall_vl_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - VL number */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t vl;
	/* Description - port number */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t port_num;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_db_bf_congestion_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - N/A
1 - Mild congestion
...
7 - Severe congestion */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t congestion_level;
	/* Description - 0 - Doorbell congestion
1 - BlueFlame congestion */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t event_subtype;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_temp_warning_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Bit vector indicating which of the sensor reading is above thresh;old.;Address 00h bit31 is sensor_warning[127];Address 0Ch bit0 is sensor_warning[0] */
	/* 0x0.0 - 0x10.31 */
	 u_int32_t sensor_warning[4];
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_dcbx_change_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Event subtype.
0x1: ERROR_STATE - DCBX has reached an error state. The 
error is reported in the error field. The error enumeration is 
according to its definition in error field in the DCBX_PARAM 
register. 
0x2: REMOTE_CONFIG_CHANGE - Change in remote 
party config. New parameters reported by PFCC, QTCT, 
QETCR and DCBX_PARAM registers for remote config 
change.
0x3: LOCAL_OPER_CANGE - Change in local party opera
tional state. New parameters reported by PFCC, QTCT, 
QETCR and DCBX_PARAM registers for local operational 
change 
0x4: REMOTE_CONFIG_APPLICATION_PRIORI
TY_CHANGE - Change in DCBX_APPLICATION register. 
No event data is attached. */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t event_sub_type;
	/* Description - Indicates the error cause the event.
valid only when event_sub_type==ERROR_STATE. */
	/* 0x0.8 - 0x0.11 */
	 u_int8_t error;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_port_module_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Module Status.
0x1: 
P
lugged
0x2:
 
U
nplugged
0x3: 
M
odule plugged with Error
-
 Details in errors reported in 
error_type field. */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t module_status;
	/* Description - Module Number.
SW can use PMLP register to know port number to module 
number mapping. */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t module;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Module error type. Valid when module_status==0x3
0x0: Power Budget Exceeded
0x1: Long Range for non MLNX cable/module
0x2: Bus stuck(I2C or data shorted)
0x3: No EEPROM/retry timeout
0x4: Enforce part number list
0x5: Unknown identifier
0x6: High Temperature
0x7: Cable is shorted */
	/* 0x4.8 - 0x4.11 */
	 u_int8_t error_type;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_gpio_event {
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - If any bit is set to '1', then a rising/falling event has occurred 
on the corresponding GPIO pin. */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t gpio_event_hi;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - If any bit is set to '1', then a rising/falling event has occurred 
on the corresponding GPIO pin. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t gpio_event_lo;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_port_state_change_event {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Port number */
	/* 0x8.28 - 0x8.31 */
	 u_int8_t port_num;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_dropped_packet_logged {
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_cq_error {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - CQ number event is reported for */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t cqn;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 0x1: CQ_overrun
0x2: CQ_access_violation_error */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t syndrome;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_rdma_page_fault_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The number of bytes already sent/received in this WQE before the fault. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t bytes_committed;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The R-key used for the RDMA transaction which caused the fault. */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t r_key;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The length of the packet received/constructed for transmission when the 
fault occurred. Measured in bytes.
This can be used on RDMA write operations, where we do not always 
know the rdma_op_len. The software may attempt to prefetch memory 
based on the event attributes, but must make sure it can map the pages 
needed for packet_len bytes. */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t packet_len;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The length of the RDMA operation, in bytes. If the HW cannot reliably 
report the length, it will put 0 in this field, and the driver should perform 
prefetching based on access pattern */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t rdma_op_len;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The VA used for the beginning of the RDMA operation, upper 32-bits. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t rdma_va_hi;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - The VA used for the beginning of the RDMA operation, lower 32-bits. */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t rdma_va_lo;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - The QP on which the fault occurred */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t qpn;
	/* Description - If set, the fault happened on the requestor (initiator) side of the QP.
Not set - responder side of the QP */
	/* 0x18.24 - 0x18.24 */
	 u_int8_t requestor;
	/* Description - If set, the operation attempted was writing memory. 
Not set - reading from memory */
	/* 0x18.25 - 0x18.25 */
	 u_int8_t write_read_;
	/* Description - 1 - RDMA associated page fault.
0 - WQE associated page fault */
	/* 0x18.26 - 0x18.26 */
	 u_int8_t rdma;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_wqe_associated_page_fault_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The number of bytes already sent/received in this WQE before the fault. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t bytes_committed;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The WQE index (from beginning of the relevant queue, in WQEBB 
units) where the fault occurred */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t wqe_index;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Length of memory access operation that experienced a page fault.
For page faults on send operations in the responder side we need to know 
how much of the WQE's memory we must fetch successfully. We may 
try to fetch more of the WQE's memory, beyond the needs of the current 
packet, but a failure to do that will not cause a QP error. */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t len;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - The QP
 number on which the fault occurred */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t qpn;
	/* Description - If set, the fault happened on the requestor (initiator) side of the QP.
Not set - responder side of the QP */
	/* 0x18.24 - 0x18.24 */
	 u_int8_t requestor;
	/* Description - If set, the operation attempted was writing memory. 
Not set - reading from memory */
	/* 0x18.25 - 0x18.25 */
	 u_int8_t write_read;
	/* Description - 1 - RDMA associated page fault
0 - WQE associated page fault */
	/* 0x18.26 - 0x18.26 */
	 u_int8_t rdma;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_qp_events {
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Queue type
0: QP
1: RQ
2: SQ */
	/* 0x14.24 - 0x14.31 */
	 u_int8_t type;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Indicates 
QPN, 
SQN or RQN depending on type field. */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t qpn_rqn_sqn;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_dct_events {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t dctn;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_comp_event {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t cqn;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_sw_eqe_flat_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 u_int32_t data[7];
};

/* Description -   */
/* Size in bytes - 268 */
struct connectib_generic_flash_reg_access_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x2c.31 */
	 union connectib_reg_access_reg_tlv_data reg_data;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - reg access is shared with smp mads that are limited to 0x40B */
	/* 0x2c.0 - 0x10c.31 */
	 u_int32_t more_data[56];
};

/* Description -   */
/* Size in bytes - 264 */
union connectib_access_register_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x48.31 */
	 struct connectib_mcam_reg mcam_reg;
	/* Description -  */
	/* 0x0.0 - 0x50.31 */
	 struct connectib_pcam_reg pcam_reg;
	/* Description -  */
	/* 0x0.0 - 0x50.31 */
	 struct connectib_qetcr_reg qetcr;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_qpdp_reg qpdp;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_qtct_reg qtct;
	/* Description - Table 363 - QHLL - QoS Head of Queue Lifetime Limit Register Layout */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_qhll qhll;
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_mlcr mlcr;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_dcbx_param_reg dcbx;
	/* Description -  */
	/* 0x0.0 - 0x14.31 */
	 struct connectib_dcbx_app_reg dcbx_app;
	/* Description - register_set_node */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_register_set_node register_set_node;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_access_register_unit_perf_counters_cfg perf_counters_cfg;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_access_register_unit_perf_counters_data perf_counters_data;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_register_unit_perf_counters_global_ctrl perf_counters_global_ctrl;
	/* Description -  */
	/* 0x0.0 - 0x14.31 */
	 struct connectib_access_register_unit_port_capabilities port_capabilities_reg;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_pfcc_reg port_flow_control_cfg_reg;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_register_loopback_control loopback_control_reg;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_register_power_settings power_settings_reg;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_register_fp_sl_map fp_sl_map_reg;
	/* Description - register_host_endianness layout */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_register_host_endianness register_host_endianness;
	/* Description - register_pplr */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_register_pplr register_pplr;
	/* Description - misc_counters */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_register_misc_counters misc_counters;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_db_threshold_register_layout db_threshold;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_register_mfpa flash_mfpa;
	/* Description -  */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_register_mfba flash_mfba;
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_register_mfbe flash_mfbe;
	/* Description - Table 236 - PAOS - Ports Administrative and Operational Status Register Layout */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_paos_reg access_register_paos;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_pmtu_reg access_register_pmtu;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_pmlp_reg access_register_pmlp;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_ptys_reg access_register_ptys;
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_ppcnt_reg access_register_ppcnt;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_pvlc_reg access_register_pvlc;
	/* Description - Table 307 - [Internal] PPAMP - Port Phy opAMP data Register Layout */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_pamp_reg access_register_pamp;
	/* Description - Table 315 - PTAS - Phy Tuning Algorithm Settings Register Layout */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_ptas_reg access_register_ptas;
	/* Description - Table 313 - SLRG - Serdes Lane Receive Grade Register Layout */
	/* 0x0.0 - 0x28.31 */
	 struct connectib_slrg_reg access_register_slrg;
	/* Description - Serdes Lane Receive Parameters */
	/* 0x0.0 - 0x28.31 */
	 struct connectib_slrp_reg access_register_slrp;
	/* Description - Table 311 - [Internal] SLTP - Serdes Lane Transmit Parameters Register Layout */
	/* 0x0.0 - 0x14.31 */
	 struct connectib_sltp_reg access_register_sltp;
	/* Description - Table 291 - PPLR - Port Physical Loopback Register Layout */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_pplr_reg access_register_pplr;
	/* Description - Table 297 - PLPC - Phy Link Profiles Control Register Layout */
	/* 0x0.0 - 0x28.31 */
	 struct connectib_plpc_reg access_register_plpc;
	/* Description - Table 299 - PPLM - Port Phy Link Mode Register Layout */
	/* 0x0.0 - 0x18.31 */
	 struct connectib_pplm_reg access_register_pplm;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_ppad_reg access_register_ppad;
	/* Description - mcia - misc cable info access */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_mcia_reg access_register_mcia;
	/* Description - Table 438 - pcie info register */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_mpein_reg access_register_mpein;
	/* Description - Table 440 */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_mpcnt_reg access_register_mpcnt;
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_pddr_reg access_register_pddr;
	/* Description - Table 440 */
	/* 0x0.0 - 0x18.31 */
	 struct connectib_mcion_reg access_register_mcion;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_pptt_reg access_register_pptt;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_pprt_reg access_register_pprt;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_ppaos_reg access_register_ppaos;
	/* Description - Table 406 - PCMR - Ports Check Mask Register Layout */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_pcmr_reg access_register_pcmr;
	/* Description - Port Module Memory Map Properties Register */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_pmmp_reg access_register_pmmp;
	/* Description - Port Module Control Register */
	/* 0x0.0 - 0x18.31 */
	 struct connectib_pmcr_reg access_register_pmcr;
	/* Description - Table 344 - FPGA_ACCESS_REG_SPACE Register Layout */
	/* 0x0.0 - 0x14.31 */
	 struct connectib_fpga_access_reg fpga_access_reg;
	/* Description - Table 338 - FPGA_CAP Register Layout */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_fpga_cap fpga_cap;
	/* Description - Table 342 - FPGA_CTRL Register Layout */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_fpga_ctrl fpga_ctrl;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_mtpps_reg access_register_mtpps;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_mtppse_reg access_register_mtppse;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_pmaos_reg access_register_pmaos;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_scheduling_context {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Type of Scheduling Element
0x0: TSAR
0x1: VPORT
0x2: VPORT_TC
0x3: PARA_VPORT_TC
other values are reserved */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t element_type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Specific attributes according to the 
element_type
.
TSAR - 
 See Table 1465, "
TSAR Element Attributes Format
," on 
page 1082
VPORT - 
 See Table 1467, "
VPORT Element Attributes Format
," on 
page 1082
VPORT_TC - 
 See Table 1469, "
VPORT_TC Element Attributes 
Format
," on page 1083
PARA_VPORT_TC - 
 See Table 1471, "
PARA_VPORT_TC Ele
ment Attributes Format
," on page 1083 */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t element_attributes;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Identifier of the Scheduling element to which the created Scheduling 
element will be connected. This field is reserved for the root TSAR. */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t parent_element_id;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - The relative BW share allocated for this element. This field has no 
units. The BW is shared between all elements connected to the same 
parent element, relatively to their 
bw_share
.
Value 0x0 indicates a device default Weight. This field is reserved 
for the root TSAR */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t bw_share;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - The maximal transmission rate allowed for the element, averaged 
over time. 
Value is given in units of 1 Mbit/sec.
Value 0x0 indicates the rate is unlimited. */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t max_average_bw;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_fw_ipoib_meta {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t q_key;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t pkey_index;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_fw_q_counters {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t duplicate_request;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t rnr_nack_retry_err;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t packet_seq_err;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t implied_nack_seq_err;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t local_ack_timeout_err;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t resp_rnr_nak;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t req_rnr_retries_exceeded;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_fw_transport_domain {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t sq_list_size;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_vqos_arb_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 1 arbiter is allowed to distribute tokens */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t allowed;
	/* Description - ID of the lower level arbiter */
	/* 0x0.1 - 0x0.11 */
	 u_int16_t father_id;
	/* Description - arbiter's weight for consuming tokens */
	/* 0x0.12 - 0x0.15 */
	 u_int8_t weight;
	/* Description - Sum of childrens weights */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t sum_of_weights;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - arbiters amount of tokens */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t token_count;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - cweight for rate limiter */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t cweight;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - ctoken count */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t ctoken_count;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - indication for being the first sq to need tokens from father */
	/* 0x10.0 - 0x10.0 */
	 u_int8_t i_am_first;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_dc_control_packet_desc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t dlid;
	/* Description -  */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t slid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t source_qp;
	/* Description -  */
	/* 0x4.24 - 0x4.24 */
	 u_int8_t valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t dest_qp;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t psn;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t pkey;
	/* Description -  */
	/* 0x10.16 - 0x10.19 */
	 u_int8_t sl;
	/* Description -  */
	/* 0x10.20 - 0x10.20 */
	 u_int8_t port_id;
	/* Description -  */
	/* 0x10.21 - 0x10.21 */
	 u_int8_t has_grh;
	/* Description -  */
	/* 0x10.22 - 0x10.22 */
	 u_int8_t force_loopback;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.15 */
	 u_int16_t dct_gvmi;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.7 */
	 u_int8_t tclass;
	/* Description -  */
	/* 0x18.8 - 0x18.15 */
	 u_int8_t hop_limit;
	/* Description -  */
	/* 0x18.16 - 0x18.31 */
	 u_int16_t flow_label;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x30.31 */
	 struct connectib_ib_gid dgid;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x40.31 */
	 struct connectib_ib_gid sgid;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_dmfs_resources {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_dmfs_fg_meta fg_meta;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_dmfs_ft_meta ft_meta;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_dmfs_fte_meta fte_meta;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_l2_table_entry_fw_ctx l2_table_entry_fw_ctx;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_flow_counter_fw_ctx flow_counter_fw_ctx;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_dmfs_encap_meta encap_meta;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_list_element {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.24 */
	 u_int32_t next;
	/* Description -  */
	/* 0x0.25 - 0x0.30 */
	 u_int8_t list_ix;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t in_list;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.24 */
	 u_int32_t prev;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_fw_rqt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t rqt_max_size;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t rqt_actual_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t lro_max_ip_payload_size;
	/* Description -  */
	/* 0x8.8 - 0x8.11 */
	 u_int8_t lro_enable_mask;
	/* Description -  */
	/* 0x8.12 - 0x8.12 */
	 u_int8_t tunneled_offload_en;
	/* Description -  */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t lro_timeout_period_usecs;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.1 */
	 u_int8_t rss_qpn_size;
	/* Description -  */
	/* 0xc.2 - 0xc.25 */
	 u_int32_t rss_indirection_table_base_qpn;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t rqt_hw_data_ix;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t rqt_fw_data_ix;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_fw_cqc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0x0 = Ok
0x1 = Error: CQ Overrun
0x2 = Error: Access Violation */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t cq_status;
	/* Description -  */
	/* 0x4.8 - 0x4.11 */
	 u_int8_t trap_reason;
	/* Description -  */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t in_cq_overrun_list;
	/* Description -  */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t in_eq_overrun_list;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_fw_psv {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t pd;
	/* Description -  */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t fw_marked_sigerr;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_fw_mkc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.30 */
	 u_int32_t state;
	/* Description -  */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t sync_umr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 struct connectib_mkey_dump mkey_dump;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.0 */
	 u_int8_t next_num_of_sigerr;
	/* Description -  */
	/* 0xc.1 - 0xc.1 */
	 u_int8_t pg_access;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_fw_cre {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_fw_srqc fw_srqc;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_fw_qpc fw_qpc;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_fw_tir fw_tir;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_fw_tis fw_tis;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_fw_basic_res_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_fw_alt_path {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - ads layout */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_sw_ads alt;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_fw_eqc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Note: ref_counter must be in offset 0x0 ! */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0x0 = Ok
0x2 = Error: Access Violation */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t eq_status;
	/* Description -  */
	/* 0x4.8 - 0x4.11 */
	 u_int8_t trap_reason;
	/* Description -  */
	/* 0x4.16 - 0x4.20 */
	 u_int8_t log_page_size;
	/* Description -  */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t needs_eq_probe;
	/* Description -  */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t in_eq_overrun_list;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_qp_counter {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Only RX (Out-of-buffer induced dropped Rx packet count) */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t pkt_nobuffer_drop;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t pkt_good_unicast;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t pkt_good_multicast;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - RX - Error induced dropped Rx packet count. SX - Dropped Tx packet count */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t pkt_dropped;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Only RX */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t msg_write_req;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t msg_rnr_nack;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - RX: Read Requests. SX : Read Responses */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t msg_read;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t msg_dct_connect;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - RX: Atomic Requests. SX : Atomic Ack */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t msg_atomic;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t fw_reserved;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - PAYLOAD bytes of RDMA frames that carry data */
	/* 0x28.0 - 0x30.31 */
	 u_int64_t bytes_rdma_frame;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x38.31 */
	 u_int64_t bytes_good_unicast;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x40.31 */
	 u_int64_t bytes_good_multicast;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hw_msix {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - pci spec msix vector */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_hw_msix_context msix_context;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - msix extended context */
	/* 0x10.0 - 0x20.31 */
	 struct connectib_hw_msix_ext_context msix_ext_context;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_rdb {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t opcode;
	/* Description - TODO: need to align this field to 32.  */
	/* 0x0.8 - 0x0.31 */
	 u_int32_t psn;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t r_key;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t address_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t address_31_0;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t byte_count;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.7 - 0x14.7 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - TODO: need to align this field to 32.  */
	/* 0x14.8 - 0x14.31 */
	 u_int32_t pd;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.10 */
	 u_int16_t protection_ffser;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - new name for fw_marked_as_read */
	/* 0x1c.0 - 0x1c.0 */
	 u_int8_t allow_excessiveness;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x40.31 */
	 struct connectib_hw_rdb_atomic_data atomic_data;
};

/* Description -   */
/* Size in bytes - 8 */
union connectib_icm_mtt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_hw_mtt hw;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_hw_mtt2 as_dw;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_steering_entry_icmc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_ste hw_ste;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_steering_qp_list steering_qp_list;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_hw_pkey {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t pkey;
};

/* Description -  the timer is 8 bit, this is an adapter to node to unions */
/* Size in bytes - 4 */
struct connectib_hw_timer_32 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 struct connectib_hw_timer hw_timer;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_hw_sq_qp_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  QPN QP number */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t qpi;
	/* Description -  DCR if this bit is set, the QP came from DCR DB */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t global_gvmi;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_hw_pipa {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  Producer Index Physical Address */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t pa_63_32;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  if 0, there will not br recovery on this QPn */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t recovery_en;
	/* Description -  */
	/* 0x4.1 - 0x4.1 */
	 u_int8_t always_zero;
	/* Description -  Producer Index Physical Address */
	/* 0x4.2 - 0x4.31 */
	 u_int32_t pa_31_2;
};

/* Description -   */
/* Size in bytes - 8 */
union connectib_hw_sxdc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_sxdc_uar uar;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_sxdc_swqe_producer_index swqe_producer_index;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_sxdc_sq sq;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_sxdc_valid valid;
	/* Description - only when set external DB are accepted by the device, when cleared they are silently dropped */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_sxdc_external_db_en external_db_en;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_sxdc_fast_path fast_path;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_sxdc_doorbell_int doorbell_int;
	/* Description - for QP flush FW flow. Indicates that the QP should not be scheduled when popping from the SQ but go the FW state */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_sxdc_scheduling_interrupt scheduling_interrupt;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_sxdc_responder_in_sq responder_in_sq;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_sxdc_requestor_in_sq requestor_in_sq;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_klm_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t length;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t key;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t va;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hw_sq_tokens {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  number of tokens to transfer in case the SQ has WareHouse QPs */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t ware_house_burst_size_23_8;
	/* Description -  */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  Number of bytes for transmission by SXW for a QP popped from this SQ responder queue */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t responder_burst_size;
	/* Description -  number of tokens to transfer in case the SQ has WareHouse QPs */
	/* 0x4.24 - 0x4.31 */
	 u_int8_t ware_house_burst_size_7_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  Number of bytes for transmission by SXW for a QP popped from this SQ requestor queue */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t requestor_burst_size;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  Number of bytes to add to GvmiTokenCount from GVMI tokens pool */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t gvmi_vl_weight;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  Number of bytes allocated to the SQ from the GVMI tokens pool */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t gvmi_vl_token_count;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  Maximum value of GvmiVlTokenCount */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t gvmi_vl_saturation;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  Number of bytes to add to SwitchTokenCount during reset event of SQ-to-SL virtual switch arbiter */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t dwrr_weight;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  Number of Tokens that the SQ has to Transfer to the SXW from the DWRR token Count */
	/* 0x1c.0 - 0x1c.23 */
	 u_int32_t dwrr_token_count;
	/* Description -  */
	/* 0x1c.24 - 0x1c.27 */
	 u_int8_t vl;
	/* Description -  */
	/* 0x1c.28 - 0x1c.30 */
	 u_int8_t vlg;
	/* Description -  */
	/* 0x1c.31 - 0x1c.31 */
	 u_int8_t port;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hw_gvmi_tokens {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  Maximum value in *_token_count = (2 ^ *_weight_saturation - 1); must be  <= 23 to allow negative tokens */
	/* 0x8.0 - 0x8.4 */
	 u_int8_t port1_avg_saturation;
	/* Description -  VL group that will get tokens in next distribution cycle; updated during token reset cycle */
	/* 0x8.5 - 0x8.7 */
	 u_int8_t port1_high_vlg_req_token;
	/* Description -  port1_avg_time Log2 of the number of token distribution cycles to wait before adding tokens to average bandwidth bucket */
	/* 0x8.8 - 0x8.12 */
	 u_int8_t port1_log2avg_time;
	/* Description -  Maximum bucket bandwidth = weight_mantissa * 2^weight_exp, in bytes */
	/* 0x8.13 - 0x8.15 */
	 u_int8_t port1_max_weight_exp;
	/* Description -  port1_max_time Log2 of the number of token distribution cycles to wait before adding tokens to maximum bandwidth bucket */
	/* 0x8.16 - 0x8.20 */
	 u_int8_t port1_log2max_time;
	/* Description -  port0_has_tokens During token distribution cycle (from GVMI to SQ), indicates if maximum bandwidth bucket had tokens at the beginning of the cycle */
	/* 0x8.21 - 0x8.21 */
	 u_int8_t port0_has_token;
	/* Description -  VL group that will get tokens in next distribution cycle; updated during token reset cycle */
	/* 0x8.22 - 0x8.22 */
	 u_int8_t port0_vlg_req_vld;
	/* Description -  During token distribution cycle (from GVMI to SQ), indicates if maximum bandwidth bucket had tokens at the beginning of the cycle */
	/* 0x8.23 - 0x8.23 */
	 u_int8_t port1_has_token;
	/* Description -  Maximum value in *_token_count = (2 ^ *_weight_saturation - 1); must be  <= 23 to allow negative tokens */
	/* 0x8.24 - 0x8.28 */
	 u_int8_t port1_max_saturation;
	/* Description -  VL group that will get tokens in next distribution cycle; updated during token reset cycle */
	/* 0x8.29 - 0x8.29 */
	 u_int8_t port1_vlg_req_vld;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  Maximum value in *_token_count = (2 ^ *_weight_saturation - 1); must be  <= 23 to allow negative tokens */
	/* 0xc.0 - 0xc.4 */
	 u_int8_t port0_avg_saturation;
	/* Description -  Maximum bucket bandwidth = weight_mantissa * 2^weight_exp, in bytes */
	/* 0xc.5 - 0xc.7 */
	 u_int8_t port0_avg_weight_exp;
	/* Description -  port0_avg_time Log2 of the number of token distribution cycles to wait before adding tokens to average bandwidth bucket */
	/* 0xc.8 - 0xc.12 */
	 u_int8_t port0_log2avg_time;
	/* Description -  VL group that will get tokens in next distribution cycle; updated during token reset cycle */
	/* 0xc.13 - 0xc.15 */
	 u_int8_t port0_high_vlg_req_token;
	/* Description -  port0_max_time Log2 of the number of token distribution cycles to wait before adding tokens to maximum bandwidth bucket */
	/* 0xc.16 - 0xc.20 */
	 u_int8_t port0_log2max_time;
	/* Description -  Maximum bucket bandwidth = weight_mantissa * 2^weight_exp, in bytes */
	/* 0xc.21 - 0xc.23 */
	 u_int8_t port0_max_weight_exp;
	/* Description -  Maximum value in *_token_count = (2 ^ *_weight_saturation - 1); must be  <= 23 to allow negative tokens */
	/* 0xc.24 - 0xc.28 */
	 u_int8_t port0_max_saturation;
	/* Description -  Average bucket bandwidth = weight_mantissa * 2^weight_exp, in bytes */
	/* 0xc.29 - 0xc.31 */
	 u_int8_t port1_avg_weight_exp;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  Maximum bandwidth bucket token count */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t port1_max_token_count;
	/* Description -  */
	/* 0x10.24 - 0x10.31 */
	 u_int8_t port1_max_weight_mantissa;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  Average bandwidth bucket token count */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t port1_avg_token_count;
	/* Description -  */
	/* 0x14.24 - 0x14.31 */
	 u_int8_t port1_avg_weight_mantissa;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  Maximum bandwidth bucket token count */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t port0_max_token_count;
	/* Description -  */
	/* 0x18.24 - 0x18.31 */
	 u_int8_t port0_max_weight_mantissa;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  Average bandwidth bucket token count */
	/* 0x1c.0 - 0x1c.23 */
	 u_int32_t port0_avg_token_count;
	/* Description -  */
	/* 0x1c.24 - 0x1c.31 */
	 u_int8_t port0_avg_weight_mantissa;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hw_sq_pointers {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  weight of requestor for dwrr between requstor and responder */
	/* 0x0.0 - 0x0.9 */
	 u_int16_t weight_requestor;
	/* Description - NO_DESCR */
	/* 0x0.10 - 0x0.15 */
	 u_int8_t sq_offset_11_6;
	/* Description -  weight of responder for dwrr between requstor and responder */
	/* 0x0.16 - 0x0.25 */
	 u_int16_t weight_responder;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  Guest Virtual Machine ID */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
	/* Description -  requestor_responder_dwrr_token number of corrent tokens for corrent LastGntRequestor */
	/* 0x4.16 - 0x4.25 */
	 u_int16_t token;
	/* Description - NO_DESCR */
	/* 0x4.26 - 0x4.31 */
	 u_int8_t sq_offset_5_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  ware_house_counter_responder Number of responder QPs unscheduled back into the SQ due to lack of VL credits */
	/* 0x8.0 - 0x8.24 */
	 u_int32_t ware_house_counter_responder;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  ware_house_counter_requestor Number of requestor QPs unscheduled back into the SQ due to lack of VL credits */
	/* 0xc.0 - 0xc.24 */
	 u_int32_t ware_house_counter_requestor;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  responder_push_pointer responder push pointer at the SQ */
	/* 0x10.0 - 0x10.24 */
	 u_int32_t push_pointer_responder;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  requestor_push_pointer requestor push pointer at the SQ */
	/* 0x14.0 - 0x14.24 */
	 u_int32_t push_pointer_requestor;
	/* Description -  */
	/* 0x14.25 - 0x14.25 */
	 u_int8_t port;
	/* Description -  scheduling_interrupt if set QPs at this SQ will not be sched to the SXW, but will move to FW state at the scheduling slices */
	/* 0x14.26 - 0x14.26 */
	 u_int8_t scheduling_interrupt;
	/* Description -  Virtual lane */
	/* 0x14.28 - 0x14.31 */
	 u_int8_t vl;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  responder_pop_pointer responder pop pointer at the SQ */
	/* 0x18.0 - 0x18.24 */
	 u_int32_t pop_pointer_responder;
	/* Description -  last grant ID (requestor/responder) for DWRR at the SQ */
	/* 0x18.25 - 0x18.25 */
	 u_int8_t last_gnt_requestor;
	/* Description -  Log2 size of responder schedule queue, opened in ICM for QP list */
	/* 0x18.26 - 0x18.31 */
	 u_int8_t log2_max_num_of_qp_responder;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  requestor_pop_pointer requestor pop pointer at the SQ */
	/* 0x1c.0 - 0x1c.24 */
	 u_int32_t pop_pointer_requestor;
	/* Description -  scheduling_interrupt if set QPs at this SQ will not be sched to the SXW, but will move to FW state at the scheduling slices */
	/* 0x1c.25 - 0x1c.25 */
	 u_int8_t db_interrupt;
	/* Description -  Log2 size of requestor schedule queue, opened in ICM for QP list */
	/* 0x1c.26 - 0x1c.31 */
	 u_int8_t log2_max_num_of_qp_requestor;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_trasta {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t va_offset_63_32;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t va_offset_31_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t klm_index;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t invalidation_counter;
	/* Description -  */
	/* 0xc.16 - 0xc.16 */
	 u_int8_t valid;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hw_trastb {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  generation 16 bits: MKC.generation at the moment of last update. TRAST is stale if the genartion does not match current MKC, and will not be used */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t generation_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  bsf_offset 32 bits: offset in 16B granularity of the BSF described by the entry, from the first BSF pointed by MKC */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t bsf_offset;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  memory_fbo 32 bits: offset in bytes inside memory signature block, carried from previous BSF */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t m_fbo;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  wire_fbo 32 bits: offset in bytes inside wire signature block, carried from previous BSF */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t w_fbo;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  memory_va 64 bits: accumulated memory address from all BSFs prior to the one described by the entry */
	/* 0x10.0 - 0x18.31 */
	 u_int64_t m_va;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  wire_va 64 bits: accumulated wire address from all BSFs prior to the one described by the entry */
	/* 0x18.0 - 0x20.31 */
	 u_int64_t w_va;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_base_psv {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t pd;
	/* Description -  */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t data_heart_beat;
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t wqe_heart_beat;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t status;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t syndrome;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t transient_signature;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t reference_tag;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_bsf_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_bsf_entry_same_block_repeating same_block_repeating;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_bsf_entry_same_block_non_repeating same_block_non_repeating;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_bsf_entry_w_repeating_m_repeating hw_bsf_entry_w_repeating_m_repeating;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_bsf_entry_w_repeating_m_non_repeating hw_bsf_entry_w_repeating_m_non_repeating;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_bsf_entry_w_non_repeating_m_repeating hw_bsf_entry_w_non_repeating_m_repeating;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating hw_bsf_entry_w_non_repeating_m_non_repeating;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_port_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0x0.0 - 0x0.2 */
	 u_int8_t lmc;
	/* Description - NO_DESCR */
	/* 0x0.28 - 0x0.29 */
	 u_int8_t mad_filter;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t lid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t gid_prefix;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 0x20.16 - 0x40.15 */
	 u_int16_t dc_rsl2sq_map[16];
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_qpc_r_dct {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_hw_r_qpc qpc;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_hw_dct dct;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_s_qpc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Hermon: highest_psn */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_first_unsent_psn first_unsent_psn;
	/* Description - Counts number of outstanding reads and atomic */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_number_outstanding_reads number_outstanding_reads;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_first_psn_of_message_currently_completing first_psn_of_message_currently_completing;
	/* Description - value 0 means that we are not in the middle of a read response read middle: if DS is too big rx slice should skip the REQSL machine */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_currently_completing_ds currently_completing_ds;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_timer_enable timer_enable;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_vl15 vl15;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_force_grh force_grh;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_dc_access_key_31_0 dc_access_key_31_0;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_dc_access_key_63_32 dc_access_key_63_32;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_lsn lsn;
	/* Description - How many bytes were sent from current WQE LSO byte granularty, otherwise 256B granularty */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_sx_gather_commit sx_gather_commit;
	/* Description - if set gid index is taken from sqpc.mgid (my gid) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_force_my_gid_index force_my_gid_index;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_to_sequence_error_retry_limit to_sequence_error_retry_limit;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_sx_heartbeat sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5]) 0-RC 1-UC 2-RD (reserved) 3-UD 5-XRC (SRC in hermon) 8-RMC parent 9-RMC child (RX only) 10-FCP 11-DCI/DCR 12-DCT 15-L2 (Hermon name: L2 & MLX) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_ts ts;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_force_grh_tclass force_grh_tclass;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_reverse_sl reverse_sl;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_to_sequence_error_retry_counter to_sequence_error_retry_counter;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_ssn ssn;
	/* Description - index to the counters table 0-disable */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_counter_index counter_index;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_flush_syndrom flush_syndrom;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_next_to_send_psn next_to_send_psn;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_cq_number cq_number;
	/* Description - copied from packet on first ack */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_responder_session_id responder_session_id;
	/* Description - SX should put this field in D    ETH.SQPN field */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_deth_sqpn deth_sqpn;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_oldest_non_acked_psn oldest_non_acked_psn;
	/* Description - ACKREQ_PSN (PSN of last packet sent with ACKREQ=1, virtual field for timer decision) = QP.next_to_send_psn - 1 - QP.PSN_since_ACKREQ */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_psn_since_ackreq psn_since_ackreq;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_qp_state qp_state;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_swqe_consumer_index swqe_consumer_index;
	/* Description - index updated when poping from ldb (ldb_index) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_currently_completing_wqe_index currently_completing_wqe_index;
	/* Description - 0: not connected 1: connect packet sent 2: connect was acked */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_dc_state dc_state;
	/* Description - 0-no limit, 1-outstanding reads, 2-fence, 3-strong ordering, 4-fc_seq_initiative, 5-outstanding psn, 6-dc wait for connect, 7-e2e credit (limited state) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_limited_qp limited_qp;
	/* Description -  2^value is the frequency at which we send ackreq.valid. values are 0-8 giving ackreq bit per 1-256 packets */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_ack_req_frequency ack_req_frequency;
	/* Description - interrupt FW when packet arrives to tcu on this Qp Hermon: tcu_int */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_tcu_trap tcu_trap;
	/* Description - Used for translation and key check (TPT) TODO: next project move to common section? */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_can_use_reserved_lkey can_use_reserved_lkey;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_tcu_drop tcu_drop;
	/* Description - Hermon name: bind_enable */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_umr_enable umr_enable;
	/* Description - enable fast register WQE Hermon name: frwr_en */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_frwr_enable frwr_enable;
	/* Description - set by RX on every packet received and accepted */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_rx_heartbeat rx_heartbeat;
	/* Description - TODO this bit does not work and is not needed, delete on next project */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_ldb_int ldb_int;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry 1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline) 2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline) Hermon: disable_inline_scatter */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_inline_scatter inline_scatter;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_rnr_nak_retry_limit rnr_nak_retry_limit;
	/* Description - This QP should use the fast_path inside the device */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_fast_path fast_path;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_rnr_nak_retry_counter rnr_nak_retry_counter;
	/* Description - TODO next project: rename to pkey_check_enable TODO next project: delete it from all TS (who needs it)? */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_ignore_pkey_check ignore_pkey_check;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand) 0: disable atomic 1: IB spec (responder extended RDB is N/A) all enum from here support extended atomic in addition 2: only 8B (hermon mode, responder extended RDB is N/A) 3: up to 8B (also 4B, responder extended RDB is N/A) 4: up to 16B (responder extended RDB is N/A) 5: up to 32B (responder extended RDB is N/A) 6: up to 64B (responder extended RDB is 64B) 7: up to 128B (responder extended RDB is 128B) 8: up to 256B (responder extended RDB is 256B) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_extended_atomic extended_atomic;
	/* Description - 2^this value=max number of atomic/rdma reads Hermon: max_rdma_atomic */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_max_read_atomic max_read_atomic;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_umr_permission_select umr_permission_select;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN). When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed. See issue 34551  TODO: rename to direct_access_enable */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_no_direct_access no_direct_access;
	/* Description - TCU requestor should trap when e2e_credits_enabled==&AETH.syndrom.CCCCC */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_e2e_credits_enabled e2e_credits_enabled;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_dc_full_handshake dc_full_handshake;
	/* Description - set by SX when executing a non wire WQE cleared by RX when LDB is empty used by LDB for performance optimisation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_uncompleted_non_wire_wqe uncompleted_non_wire_wqe;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_qp_valid qp_valid;
	/* Description - SX WQE opcode that cause packet creation are allowed */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_s_qpc_packet_allowed packet_allowed;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_c_qpc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_peer_gid_31_0 peer_gid_31_0;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_peer_gid_63_32 peer_gid_63_32;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_peer_gid_95_64 peer_gid_95_64;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_peer_gid_127_96 peer_gid_127_96;
	/* Description - this hold the 2'nd peer_lid for dual write */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_peer_lid2 peer_lid2;
	/* Description - this hold the 2'nd peer_qp for dual write */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_peer_qp2 peer_qp2;
	/* Description - protection domain */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_pd pd;
	/* Description - Used in TPT for wqe translation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_mtt_pointer_4_0 mtt_pointer_4_0;
	/* Description - Used in TPT for wqe translation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_mtt_pointer_36_5 mtt_pointer_36_5;
	/* Description - Used in TPT for wqe translation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_mtt_pointer_39_37 mtt_pointer_39_37;
	/* Description - In DCE this field is {VLAN.prio, CFI\DA} */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_sl sl;
	/* Description - IB native only: packet should have GRH header not used in UD/L2 responder */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_grh_bit grh_bit;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_port_number port_number;
	/* Description - mark packets as eligible for adaptive routing; supported on UC & UD transports */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_adaptive_routing adaptive_routing;
	/* Description - WQ size = 64B*2^value */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_swqe_buffer_size swqe_buffer_size;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_peer_lid peer_lid;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_my_lid my_lid;
	/* Description - access ICM with {GVMI, my_gid_index} to get GRH.MyGID, IPv6 and IPv4 use the same field */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_my_gid_mac_index my_gid_mac_index;
	/* Description - 2^thisValue is the max number of bytes per mesaage */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_max_message_size max_message_size;
	/* Description - 0: 256 bytes   1: 512 bytes   2: 1K bytes  3: 2K bytes  4: 4k bytes 5: 8k bytes */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_mtu mtu;
	/* Description - sx: used when WQE.Qkey[31]=1 TODO FCP: what about FCoIB */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_qkey qkey;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_flow_label flow_label;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_pkey_table_index pkey_table_index;
	/* Description - except for DCR this is MyQPN in the packet */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_context_number context_number;
	/* Description - If rwq_type==0 then      swqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64 else      rwqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64     swqe_address=(2^log_page_size)*wqe_page_offset*64 + 2^(rwqe_buffer_size+rwqe_stride)*16  + masked_wqe_index*64 */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_wqe_page_offset wqe_page_offset;
	/* Description - sx will put this field in the migreq field Hermon: path_migration_fsm[1] */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_sx_migreq sx_migreq;
	/* Description - tcu check will jump if pkt.migreq differ from this bit Hermon: mig_req */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_rx_migreq rx_migreq;
	/* Description - Dest Qp in connection */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_peer_qp peer_qp;
	/* Description - Number of hops between subnets a packet can make before being discarded Used by TCU for CNP with GRH in connected mode */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_hop_limit hop_limit;
	/* Description - UD-see force_grh_tclass golan2: we should have 2 tclass fields for ETHoIB enforcement */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_tclass tclass;
	/* Description - number of WQEs in the WQ: 2 in power of */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_rwqe_buffer_size rwqe_buffer_size;
	/* Description - WQE size: (2^this field)*16B */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_rcyclic_size rcyclic_size;
	/* Description - WQE size: (2^this field)*16B */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_rwqe_stride rwqe_stride;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_ipd ipd;
	/* Description - IB port: all packets go to loopback port Ethernet port: see IAS see issue 32965 */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_force_loopback force_loopback;
	/* Description - Work Queue Type 1: normal WQ 2: attached to SRQ 3: Receive Cyclic Buffer */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_rwq_type rwq_type;
	/* Description - page_size = 4096*2^log_page_size */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_log_page_size log_page_size;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_dual_write dual_write;
	/* Description - each WQE in the r&s WQ are signature protected */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_wq_signature wq_signature;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_c_qpc_common_valid common_valid;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_c_srq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_e2e_consumer_index e2e_consumer_index;
	/* Description - FW bits, these are the only reserved bits that are not overriden by HW in ICM */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_srq_fw srq_fw;
	/* Description - index to next free wqe
rwq_type=SRQ: copy index from SRQ on packet first
EAS NAME: rq_wqe_counter
condition:rwq_type!=RCYCLIC */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_rwqe_consumer_index rwqe_consumer_index;
	/* Description - written by e2e credit machine */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_e2e_producer_index e2e_producer_index;
	/* Description - Hermon: srcd
EAS NAME: xrcd
condition:ts==XRC */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_xrc_domain xrc_domain;
	/* Description - protection domain
EAS NAME: pd */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_pd pd;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_e2e_credits_prefetch_threshold e2e_credits_prefetch_threshold;
	/* Description - 
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_cq_number cq_number;
	/* Description - number of WQEs in the WQ: 2 in power of
EAS NAME: log_rq_size
condition:rwq_type!=RCYCLIC */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_rwqe_buffer_size rwqe_buffer_size;
	/* Description - WQE size: (2^this field)*16B
EAS NAME: log_rq_stride
condition:rwq_type!=RCYCLIC */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_rwqe_stride rwqe_stride;
	/* Description - in DCR this is the DCT number, this is MyQPN in the packet
EAS NAME: local_qpn */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_context_number context_number;
	/* Description - page_size = 4096*2^log_page_size */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_log_page_size log_page_size;
	/* Description - 
EAS NAME: N/A */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_tcu_drop tcu_drop;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_can_use_reserved_lkey can_use_reserved_lkey;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_tcu_trap tcu_trap;
	/* Description - Used in TPT for wqe translation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_mtt_pointer_39_32 mtt_pointer_39_32;
	/* Description - If rwq_type==0 then 
 swqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
else 
 rwqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
 swqe_address=(2^log_page_size)*wqe_page_offset*64 + 2^(rwqe_buffer_size+rwqe_stride)*16 + masked_wqe_index*64
EAS NAME: page_offset */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_wqe_page_offset wqe_page_offset;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_rx_heartbeat rx_heartbeat;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_e2e_fetch_enable e2e_fetch_enable;
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_rwqe_limit_event rwqe_limit_event;
	/* Description - Used in TPT for wqe translation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_mtt_pointer_31_0 mtt_pointer_31_0;
	/* Description - e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_e2e_pa_63_34 e2e_pa_63_34;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_srq_valid srq_valid;
	/* Description - each WQE in the r&s WQ are signature protected */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_wq_signature wq_signature;
	/* Description - e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_e2e_pa_33_2 e2e_pa_33_2;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_toc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  number that should be added to EQ number when giving an EQ DoorBell to RXC */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t eqn_offset;
	/* Description -  number that should be added to MSIx Vector Number when giving an MSIx Read/Write operation to RXC */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t msix_offset;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0-idle, 1-in progress, 2-do not used, 3-returning pages */
	/* 0x4.0 - 0x4.1 */
	 u_int8_t flr_state;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t cmdq_phy_addr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 struct connectib_hw_init_info init_info;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - pci_configuration_per_pf_vf */
	/* 0x14.0 - 0x30.31 */
	 struct connectib_pf_vf_cfg_space pci_cfg_space;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x30.7 */
	 u_int8_t sw_cmd_eq;
	/* Description - cmdif_checksum */
	/* 0x30.8 - 0x30.9 */
	 u_int8_t csum;
	/* Description -  */
	/* 0x30.10 - 0x30.10 */
	 u_int8_t ext_mod;
	/* Description -  */
	/* 0x30.11 - 0x30.11 */
	 u_int8_t teardown_event;
	/* Description -  */
	/* 0x30.12 - 0x30.12 */
	 u_int8_t pre_icm_driver_refused;
	/* Description - Reported in function initialization segment: 1 - device still in initializing state.0 - device is ready to receive commands. There is also global bit - static_config_not_done */
	/* 0x30.13 - 0x30.13 */
	 u_int8_t initializing;
	/* Description -  */
	/* 0x30.24 - 0x30.31 */
	 u_int8_t issi;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - state for init gvmix function  - pre init hca */
	/* 0x34.0 - 0x34.7 */
	 u_int8_t hca_state;
	/* Description - 0 - disabled, 1 - full driver , 2 - simple nic - internal FW copy */
	/* 0x34.8 - 0x34.9 */
	 u_int8_t nic_interface_type;
	/* Description - 0 - disabled, 1 - full driver , 2 - simple nic - value of SW visible field */
	/* 0x34.10 - 0x34.11 */
	 u_int8_t nic_interface_type_sw;
	/* Description - If set FLR was triggered by internal flr and not pci related */
	/* 0x34.12 - 0x34.12 */
	 u_int8_t non_pci_flr;
	/* Description - If set PCI error was triggered */
	/* 0x34.13 - 0x34.13 */
	 u_int8_t icmc_error_px;
	/* Description - GALIL ONLY : per gvmi bit for enabling/disabling doorbell recovery */
	/* 0x34.14 - 0x34.14 */
	 u_int8_t doorbell_recovery_en;
	/* Description - global nodnic (simple nic interface) index */
	/* 0x34.16 - 0x34.18 */
	 u_int8_t nodnic_idx;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - NO_DESCR */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t doorbell_record;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Used in CAPI for ICM pages */
	/* 0x3c.0 - 0x3c.15 */
	 u_int16_t capi_direct_pasid;
	/* Description - Used in CAPI for command mailbox */
	/* 0x3c.16 - 0x3c.31 */
	 u_int16_t capi_pasid;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_mkc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  check that the mkey version fit to cr_space version. */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t version;
	/* Description -   0x0: PA - (VA=PA, no translation needed)
0x1: MTT - (PA is needed)
0x2: KLMs (Indirect access) 
 */
	/* 0x0.8 - 0x0.9 */
	 u_int8_t access_mode;
	/* Description -  If set, local read is enabled why is this check not part of the EAS? It's part of the IB Spec */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t lr;
	/* Description -  If set, local write is enabled */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t lw;
	/* Description -  If set, remote read is enabled */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t rr;
	/* Description -  If set, remote write is enabled */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t rw;
	/* Description -  If set, atomic operation is enabled */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t a;
	/* Description -  If set, this Mkey context support UMR operations */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t umr_en;
	/* Description -  If set, the corresponding bit in the transaltion response will be set
EAS: responder will have one read request toward the PCIe (per QP) */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t small_fence_on_rdma_read_response;
	/* Description -  If cleared, no PCI access will be performed on the target address.
RDMA write will be druped drooped.
RDMA read will give zeroes.
need to open on QUERY_DUMP_FILL_MKEY
 */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t goto_pci;
	/* Description -  If set issue PCIe cycle with  relaxed ordering  attribute (allows write after write bypassing)
EAS: If cleared, PCIe cycle should be issued with relaxed ordering attribute */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t relaxed_ordering;
	/* Description -  If set, issue PCIe cycle with (no Snoop) attribute and this cycle will not be snooped in CPU cache */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t no_snoop;
	/* Description - NO_DESCR */
	/* 0x0.20 - 0x0.21 */
	 u_int8_t tlp_processing_hints;
	/* Description - NO_DESCR */
	/* 0x0.22 - 0x0.22 */
	 u_int8_t tlp_processing_hints_en;
	/* Description -  Unbound Type1 windows are denoted by _len=0.
 Unbound Type II windows are denoted by Status = Free. */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t free;
	/* Description - NO_DESCR */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  Variant part of MKey specified by this MKey context */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t mem_key;
	/* Description -  QP number this MW is attached to. (no QPN attached if QPN = 0xFFFFFF) */
	/* 0x4.8 - 0x4.31 */
	 u_int32_t qpn;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  Protection Domain. (no Protection Domain if PD = 0xFFFFFF) */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t pd;
	/* Description -  Enable remote invalidation */
	/* 0xc.24 - 0xc.24 */
	 u_int8_t en_rinval;
	/* Description -  If set, MKEY is armed to produce sigerr cqe. */
	/* 0xc.26 - 0xc.26 */
	 u_int8_t num_of_sigerr;
	/* Description -  can improve permormance of klm */
	/* 0xc.28 - 0xc.28 */
	 u_int8_t trast_a_en;
	/* Description -  can improve permormance of bsf */
	/* 0xc.29 - 0xc.29 */
	 u_int8_t trast_b_en;
	/* Description -  If set, this MKey specifies BSF (signature context) remove? */
	/* 0xc.30 - 0xc.30 */
	 u_int8_t bsf_enabled;
	/* Description -  to determine that len is 2^64 */
	/* 0xc.31 - 0xc.31 */
	 u_int8_t length_64;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  Start Address - Virtual Address where this region/window starts */
	/* 0x10.0 - 0x18.31 */
	 u_int64_t start_address;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  Region/Window Length [bytes] */
	/* 0x18.0 - 0x20.31 */
	 u_int64_t length;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t bsf_octoword_count;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 0x24.0 - 0x24.14 */
	 u_int16_t bsf_first_index_46_32;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 0x28.4 - 0x28.31 */
	 u_int32_t bsf_first_index_31_4;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  Handle specifying ICM area allocated for the MTT This area will be used by the HCA to store translation pages or list of pointers (indirect MKey) */
	/* 0x2c.0 - 0x2c.14 */
	 u_int16_t mtt_first_index_46_32;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  Handle specifying ICM area allocated for the MTT This area will be used by the HCA to store translation pages or list of pointers (indirect MKey) */
	/* 0x30.3 - 0x30.31 */
	 u_int32_t mtt_first_index_31_3;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  number of MTTs/KLMs octowords (16B) that are mapped to this region */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t mtt_octoword_count;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  page size = 2^(entity_size) [byte] */
	/* 0x38.0 - 0x38.4 */
	 u_int8_t entity_size;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  init to 0 */
	/* 0x3c.0 - 0x3c.15 */
	 u_int16_t generation_counter;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_c_eqc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - When pi - ci = lookahead_size ci is read from memory
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_lookahead_size_23_8 lookahead_size_23_8;
	/* Description - when this bit is cleared IRISC should be called */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cqc_valid cqc_valid;
	/* Description - CQE size: 0-64B, 1-128B
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cqe_128b_size cqe_128b_size;
	/* Description - qe_coalesce_checksum - Shomron only!!!
msix:
1: send interupt to MSIX
0:send interupt to int pin
condition:~cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cqe_coalesce_checksum_msix cqe_coalesce_checksum_msix;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_pa_error pa_error;
	/* Description - page_size = 4096*2^log_page_size */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_log_page_size log_page_size;
	/* Description - 
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_poll_cq_cqe_with_error_generated_on_this_queue poll_cq_cqe_with_error_generated_on_this_queue;
	/* Description - 
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_poll_cq_queue_in_error_state poll_cq_queue_in_error_state;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_last_notified_check_for_arm_en last_notified_check_for_arm_en;
	/* Description - index of the last CQE with SE bit set
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_last_solicited_index last_solicited_index;
	/* Description - When pi - ci = lookahead_size ci is read from memory
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_lookahead_size_7_0 lookahead_size_7_0;
	/* Description - MSB of physical address translation, 12lsb are VA[11:0] */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_pa0_63_32 pa0_63_32;
	/* Description - CQ start address is: cq_page_offset &lt;&lt; (crspace+6)
It was changed to log page size from the context */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cq_page_offset cq_page_offset;
	/* Description - 
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_db_recovery_enable db_recovery_enable;
	/* Description - set to 1 on every CQE creation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cqe_heartbeat cqe_heartbeat;
	/* Description - 0: no pa fetch
1: single pa (bring next pa when last CQE of page is written)
2: dual pa prefetch */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_pa_mode pa_mode;
	/* Description - All the CQEs are written to the same address. Required for CQE coalescing */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_shrink shrink;
	/* Description - when this bit is set, FW should be called */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cq_trap cq_trap;
	/* Description - MSB of physical address translation, 12lsb are VA[11:0] */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_pa0_31_12 pa0_31_12;
	/* Description - minimum # of cqes to generate eqe
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_moderation_cnt_limit_15_8 moderation_cnt_limit_15_8;
	/* Description - last index for which an event was created */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_last_notified_index last_notified_index;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_producer_index producer_index;
	/* Description - minimum # of cqes to generate eqe
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_moderation_cnt_limit_7_0 moderation_cnt_limit_7_0;
	/* Description - CQC: eqn+eq_offset
EQC with MSIX: ^ MSIX number+offset
EQC with interrupt: 0-INT_A, 1-INT_B, 2-INT_C, 3-INT_D, 4-INT_YU */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_eqn_msix eqn_msix;
	/* Description - minimum wait time between eqe:
0 means moderation is disabled on this CQ
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_moderation_min_wait_time moderation_min_wait_time;
	/* Description - doorbell ci - in the case of cq_state different from Fired, this field indicates what should be pi for firing the event. Updated by the doorbell handler */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_db_ci db_ci;
	/* Description - amount of CQE in CQ is 2^los2_size */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_log2_size log2_size;
	/* Description - set to 1 on every received DB */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_db_heartbeat db_heartbeat;
	/* Description - used for db.db_sn check
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_number_of_events_generated number_of_events_generated;
	/* Description - bits[63:3] of the physical address of the ci
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cipa_63_32 cipa_63_32;
	/* Description - Used in TPT for wqe translation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_mtt_pointer_39_37 mtt_pointer_39_37;
	/* Description - bits[63:3] of the physical address of the ci
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cipa_31_3 cipa_31_3;
	/* Description - Used in TPT for wqe translation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_mtt_pointer_36_5 mtt_pointer_36_5;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_consumer_index consumer_index;
	/* Description - 0-Fired
1-Armed Solicited
2-Armed
3-Always Armed
Hermon name: state */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cq_state cq_state;
	/* Description - When set: ci is ignored, and never read (block,lookahead) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_overrun_ignore overrun_ignore;
	/* Description - Used in TPT for wqe translation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_mtt_pointer_4_0 mtt_pointer_4_0;
	/* Description - MSB of physical address translation, 12lsb are VA[11:0] */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_pa1_63_32 pa1_63_32;
	/* Description - updated when eqe is generated from a global timer */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_moderation_timestamp_51_40 moderation_timestamp_51_40;
	/* Description - MSB of physical address translation, 12lsb are VA[11:0] */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_pa1_31_12 pa1_31_12;
	/* Description - updated when eqe is generated from a global timer */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_moderation_timestamp_39_8 moderation_timestamp_39_8;
	/* Description - 
EAS NAME: usr_page */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_uar uar;
	/* Description - updated when eqe is generated from a global timer */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_moderation_timestamp_7_0 moderation_timestamp_7_0;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_c_cqc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - When pi - ci = lookahead_size ci is read from memory
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_lookahead_size_23_8 lookahead_size_23_8;
	/* Description - when this bit is cleared IRISC should be called */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cqc_valid cqc_valid;
	/* Description - CQE size: 0-64B, 1-128B
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cqe_128b_size cqe_128b_size;
	/* Description - qe_coalesce_checksum - Shomron only!!!
msix:
1: send interupt to MSIX
0:send interupt to int pin
condition:~cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cqe_coalesce_checksum_msix cqe_coalesce_checksum_msix;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_pa_error pa_error;
	/* Description - page_size = 4096*2^log_page_size */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_log_page_size log_page_size;
	/* Description - 
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_poll_cq_cqe_with_error_generated_on_this_queue poll_cq_cqe_with_error_generated_on_this_queue;
	/* Description - 
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_poll_cq_queue_in_error_state poll_cq_queue_in_error_state;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_last_notified_check_for_arm_en last_notified_check_for_arm_en;
	/* Description - index of the last CQE with SE bit set
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_last_solicited_index last_solicited_index;
	/* Description - When pi - ci = lookahead_size ci is read from memory
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_lookahead_size_7_0 lookahead_size_7_0;
	/* Description - MSB of physical address translation, 12lsb are VA[11:0] */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_pa0_63_32 pa0_63_32;
	/* Description - CQ start address is: cq_page_offset &lt;&lt; (crspace+6)
It was changed to log page size from the context */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cq_page_offset cq_page_offset;
	/* Description - 
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_db_recovery_enable db_recovery_enable;
	/* Description - set to 1 on every CQE creation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cqe_heartbeat cqe_heartbeat;
	/* Description - 0: no pa fetch
1: single pa (bring next pa when last CQE of page is written)
2: dual pa prefetch */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_pa_mode pa_mode;
	/* Description - All the CQEs are written to the same address. Required for CQE coalescing */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_shrink shrink;
	/* Description - when this bit is set, FW should be called */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cq_trap cq_trap;
	/* Description - MSB of physical address translation, 12lsb are VA[11:0] */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_pa0_31_12 pa0_31_12;
	/* Description - minimum # of cqes to generate eqe
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_moderation_cnt_limit_15_8 moderation_cnt_limit_15_8;
	/* Description - last index for which an event was created */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_last_notified_index last_notified_index;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_producer_index producer_index;
	/* Description - minimum # of cqes to generate eqe
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_moderation_cnt_limit_7_0 moderation_cnt_limit_7_0;
	/* Description - CQC: eqn+eq_offset
EQC with MSIX: ^ MSIX number+offset
EQC with interrupt: 0-INT_A, 1-INT_B, 2-INT_C, 3-INT_D, 4-INT_YU */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_eqn_msix eqn_msix;
	/* Description - minimum wait time between eqe:
0 means moderation is disabled on this CQ
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_moderation_min_wait_time moderation_min_wait_time;
	/* Description - doorbell ci - in the case of cq_state different from Fired, this field indicates what should be pi for firing the event. Updated by the doorbell handler */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_db_ci db_ci;
	/* Description - amount of CQE in CQ is 2^los2_size */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_log2_size log2_size;
	/* Description - set to 1 on every received DB */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_db_heartbeat db_heartbeat;
	/* Description - used for db.db_sn check
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_number_of_events_generated number_of_events_generated;
	/* Description - bits[63:3] of the physical address of the ci
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cipa_63_32 cipa_63_32;
	/* Description - Used in TPT for wqe translation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_mtt_pointer_39_37 mtt_pointer_39_37;
	/* Description - bits[63:3] of the physical address of the ci
condition:cq */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cipa_31_3 cipa_31_3;
	/* Description - Used in TPT for wqe translation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_mtt_pointer_36_5 mtt_pointer_36_5;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_consumer_index consumer_index;
	/* Description - 0-Fired
1-Armed Solicited
2-Armed
3-Always Armed
Hermon name: state */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_cq_state cq_state;
	/* Description - When set: ci is ignored, and never read (block,lookahead) */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_overrun_ignore overrun_ignore;
	/* Description - Used in TPT for wqe translation */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_mtt_pointer_4_0 mtt_pointer_4_0;
	/* Description - MSB of physical address translation, 12lsb are VA[11:0] */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_pa1_63_32 pa1_63_32;
	/* Description - updated when eqe is generated from a global timer */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_moderation_timestamp_51_40 moderation_timestamp_51_40;
	/* Description - MSB of physical address translation, 12lsb are VA[11:0] */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_pa1_31_12 pa1_31_12;
	/* Description - updated when eqe is generated from a global timer */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_moderation_timestamp_39_8 moderation_timestamp_39_8;
	/* Description - 
EAS NAME: usr_page */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_uar uar;
	/* Description - updated when eqe is generated from a global timer */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_cqc_moderation_timestamp_7_0 moderation_timestamp_7_0;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_ffe_tap_set {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t ffe_tap0;
	/* Description -  */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t ffe_tap1;
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t ffe_tap2;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t ffe_tap3;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t ffe_tap4;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_GEN3_TRANSMITTER_SETTING {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.5 */
	 u_int8_t post;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t reject_coeff;
	/* Description -  */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t parity;
	/* Description -  */
	/* 0x0.8 - 0x0.13 */
	 u_int8_t main;
	/* Description -  */
	/* 0x0.16 - 0x0.21 */
	 u_int8_t pre;
	/* Description -  */
	/* 0x0.24 - 0x0.25 */
	 u_int8_t ec;
	/* Description -  */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t reset_eieos;
	/* Description -  */
	/* 0x0.27 - 0x0.30 */
	 u_int8_t preset;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t use_preset;
};

/* Description -   */
/* Size in bytes - 1 */
struct connectib_gpio_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t mode0;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t mode1;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t def_val;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t pull_up;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t pull_en;
	/* Description - 1-masked (don't use function defaults), 0-not masked */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t masked;
};

/* Description -   */
/* Size in bytes - 1 */
struct connectib_gpio_function {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Map function to GPIO num, 0x3f - function not present. */
	/* 0x0.0 - 0x0.5 */
	 u_int8_t mapping;
	/* Description - function polarity 0-normal, 1-reverse. Normal polarity means 0 = non active, 1 = active. */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t reverse_polarity;
	/* Description - 1-masked (don't use function defaults), 0-not masked */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t masked;
};

/* Description -  to be used in core2phy interface (not in page format) */
/* Size in bytes - 4 */
struct connectib_mlpn_enhanced_database_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - mlpn bits */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_mlnx_enhanced_equal_info_ini as_bits;
};

/* Description -  mlpn cability (ability)/ admin (request) bits for ScratchPad (not in pages foramt) */
/* Size in bytes - 4 */
struct connectib_mlpn_database_all_protocol_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - mlpn bits */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_mlpn_database_all_protocol_bits_ini as_bits;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_tx_rx_logic_serdes_mapping_node_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 u_int32_t logic_to_serdes[8];
};

/* Description -   */
/* Size in bytes - 1088 */
struct connectib_serdes_conf_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x180.31 */
	 struct connectib_serdes_autoneg_sets_ini nego;
/*---------------- DWORD[96] (Offset 0x180) ----------------*/
	/* Description - sets 0-7   : IB 8/10
sets 8-15 : IB 8/10 for legacy device
sets16-31: IB FDR */
	/* 0x180.0 - 0x300.31 */
	 struct connectib_serdes_aba_sets_ini aba;
/*---------------- DWORD[192] (Offset 0x300) ----------------*/
	/* Description - set0: force sdr
set1: force ddr
set2: force qdr
set3: force fdr
set4: aggressor
set5: force xaui
set6: force sgmii
set7: force xfi
set8: ffe initial
set9: for slicer4err calib */
	/* 0x300.0 - 0x378.31 */
	 struct connectib_serdes_force_sets_ini force;
/*---------------- DWORD[222] (Offset 0x378) ----------------*/
	/* Description - set0: half active fibre IB 8/10
set1: active fibre IB 8/10
set2: half active fibre IB FDR (64/66)
set3: active fibre IB FDR (64/66) */
	/* 0x378.0 - 0x3a8.31 */
	 struct connectib_serdes_active_sets_ini active;
/*---------------- DWORD[234] (Offset 0x3a8) ----------------*/
	/* Description - spec1_3 preset for fdr */
	/* 0x3a8.0 - 0x3e8.31 */
	 struct connectib_serdes_preset_sets_ini preset_tx_fdr;
/*---------------- DWORD[250] (Offset 0x3e8) ----------------*/
	/* Description - spec1_3 preset for qdr */
	/* 0x3e8.0 - 0x428.31 */
	 struct connectib_serdes_preset_sets_ini preset_tx_qdr;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_rx_adapt_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - max number of FFE steps bedore stop. 0 - unlimited */
	/* 0x0.0 - 0x0.5 */
	 u_int8_t max_num_ffe_search;
	/* Description - number of FFE taps to use.
allow values: 1-5 */
	/* 0x0.6 - 0x0.8 */
	 u_int8_t num_of_ffe_taps;
	/* Description - number of HW machine FFE searches before FW interfere */
	/* 0x0.9 - 0x0.14 */
	 u_int8_t num_of_ffe_hw_steps;
	/* Description - how many HW machine runs before doing eye open to help with ffe stop condition.
0 - dont do eye open for ffe stop condition */
	/* 0x0.15 - 0x0.18 */
	 u_int8_t num_hw_ffe_before_open_eye;
	/* Description - when set, dont do FFE search in RX adaptation flow, just go over RX sets. */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t skip_ffe_srch;
	/* Description - when set, dont do RX buffer sets seatch in RX adaptation. */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t skip_rx_srch;
	/* Description -  */
	/* 0x0.21 - 0x0.27 */
	 u_int8_t offset_eye_opener_range;
	/* Description - Max gap between eye pointers of current set and best set */
	/* 0x0.28 - 0x0.31 */
	 u_int8_t mixer_offset_grade_margin;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - jump size for first level of FFE search */
	/* 0x4.0 - 0x4.3 */
	 u_int8_t jump_size_ffe_level1;
	/* Description - jump size for second level of FFE search */
	/* 0x4.4 - 0x4.7 */
	 u_int8_t jump_size_ffe_level2;
	/* Description - jump size for third level of FFE search */
	/* 0x4.8 - 0x4.11 */
	 u_int8_t jump_size_ffe_level3;
	/* Description - determines start point of linear search on phase  */
	/* 0x4.12 - 0x4.16 */
	 u_int8_t delta_from_edges_phase;
	/* Description - determines start point of linear search on offset */
	/* 0x4.17 - 0x4.22 */
	 u_int8_t delta_from_edges_offst;
	/* Description -  */
	/* 0x4.23 - 0x4.23 */
	 u_int8_t offset_penalty_en;
	/* Description -  */
	/* 0x4.24 - 0x4.31 */
	 u_int8_t offset_penalty_weight;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - center the eye on the phase */
	/* 0x8.0 - 0x8.0 */
	 u_int8_t center_mix90phase;
	/* Description -  */
	/* 0x8.1 - 0x8.1 */
	 u_int8_t disable_calib_in_QDR_rev0;
	/* Description - center the eye on the offset */
	/* 0x8.2 - 0x8.2 */
	 u_int8_t center_mixer_offset;
	/* Description - enable mixer_offset_grade_margin feature */
	/* 0x8.3 - 0x8.3 */
	 u_int8_t grade_mixer_margin_en;
	/* Description - 2^value * 64ns */
	/* 0x8.4 - 0x8.8 */
	 u_int8_t eye_open_machine_measure_time;
	/* Description - 2^value * 64ns */
	/* 0x8.9 - 0x8.13 */
	 u_int8_t eye_open_machine_stab_time;
	/* Description - minimum grade for eye. if below this grade, dont finish RX adaptation */
	/* 0x8.14 - 0x8.21 */
	 u_int8_t best_grade_th;
	/* Description -  */
	/* 0x8.22 - 0x8.26 */
	 u_int8_t eye_open_machine_stab_time_extended;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.7 */
	 u_int8_t eye_phase_diff_min;
	/* Description -  */
	/* 0xc.8 - 0xc.15 */
	 u_int8_t eye_offset_diff_min;
	/* Description -  */
	/* 0xc.16 - 0xc.16 */
	 u_int8_t min_eye_en;
	/* Description -  */
	/* 0xc.17 - 0xc.17 */
	 u_int8_t grade_eye_from_center;
	/* Description - if max_tap_offset exceeds this value - offset_grade is 0 */
	/* 0xc.18 - 0xc.23 */
	 u_int8_t offset_zero_grade_threshold;
	/* Description -  */
	/* 0xc.24 - 0xc.28 */
	 u_int8_t eye_open_machine_measure_time_in_stab_extend;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Maximal value for offset_grade. If offset_grade exceeds - it truncated to this value */
	/* 0x10.2 - 0x10.7 */
	 u_int8_t offset_max_grade;
	/* Description - seperate the eyes that passes this limit from the ones that did not pass */
	/* 0x10.8 - 0x10.12 */
	 u_int8_t phase_limit;
	/* Description -  */
	/* 0x10.13 - 0x10.15 */
	 u_int8_t rx_adaptation_reattempts;
	/* Description - weight for phase in grade calc */
	/* 0x10.16 - 0x10.23 */
	 u_int8_t phase_weight;
	/* Description - weight for offsetin grade calc */
	/* 0x10.24 - 0x10.31 */
	 u_int8_t offset_weight;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - maximum for the sum of rx taps */
	/* 0x14.0 - 0x14.7 */
	 u_int8_t rx_taps_norm_val;
};

/* Description -   */
/* Size in bytes - 96 */
struct connectib_ib_ini_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The time to wait (* 50 usec) before turn off llr if lp don't has llr enabled.
Actual only for FDR
SDR/DDR/QDR wait time is 150 usec. */
	/* 0x0.0 - 0x0.5 */
	 u_int8_t llr_wait_time;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t spec1_3_ignore_peer_tx_req;
	/* Description -  */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t qdr_tx_aggressor_en;
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t equal_req_en;
	/* Description -  */
	/* 0x0.9 - 0x0.10 */
	 u_int8_t ts3_fcu;
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t ts3_hbr;
	/* Description -  */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t ts3_sct;
	/* Description -  */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t ts3_tp;
	/* Description -  */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t ts3_mpr;
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t ts3_ft;
	/* Description -  */
	/* 0x0.16 - 0x0.20 */
	 u_int8_t min_ib_grade;
	/* Description -  */
	/* 0x0.21 - 0x0.24 */
	 u_int8_t tx_polarity_port0;
	/* Description -  */
	/* 0x0.25 - 0x0.28 */
	 u_int8_t tx_polarity_port1;
	/* Description - bit mask per logical port */
	/* 0x0.29 - 0x0.30 */
	 u_int8_t Mloop_en_mask;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0xc.31 */
	 struct connectib_ib_ini_per_lcl_ini lcl[2];
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.6 */
	 u_int8_t retry_counter_threshold;
	/* Description -  */
	/* 0xc.7 - 0xc.14 */
	 u_int8_t time_2_clear_err_after_linkup;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - hold the spec1_3 preset mask from INI and all the ABA masks and borders */
	/* 0x10.0 - 0x5c.31 */
	 struct connectib_spec1_3_preset_ini spec1_3_preset;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description -  */
	/* 0x5c.0 - 0x5c.0 */
	 u_int8_t disable_llr_on_long_optic;
	/* Description -  */
	/* 0x5c.1 - 0x5c.7 */
	 u_int8_t llr_max_cable_length;
	/* Description -  */
	/* 0x5c.8 - 0x5c.8 */
	 u_int8_t terminate_pkt_timeout;
	/* Description -  */
	/* 0x5c.9 - 0x5c.9 */
	 u_int8_t llr_rx_check_en;
	/* Description -  */
	/* 0x5c.10 - 0x5c.10 */
	 u_int8_t enable_fec_on_long_optic;
	/* Description -  */
	/* 0x5c.11 - 0x5c.17 */
	 u_int8_t fec_min_cable_length;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_PORT_PHY_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_serdes_param_mask_ini serdes_param_mask;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_data_vpi_settings {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t network_link_type_ib;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t network_link_type_eth;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t default_link_type_ib;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t default_link_type_eth;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_config_kdnet_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - indicates if KDNET is ebnabled - remove when ticket #869451 closed and pick node from EAS_st */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t kdnet_en;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_nv_config_tpt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_nv_tpt_conf settings;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_nv_tlv_data_tpt_capabilities capabilities;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_nv_config_pci {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_nv_global_pci_conf settings;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x20.31 */
	 struct connectib_nv_global_pci_cap capabilities;
};

/* Description -  ACS Extended capability */
/* Size in bytes - 8 */
struct connectib_acs_ext_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability id */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t cap_id;
	/* Description - capability version */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t version;
	/* Description - next capability pointer */
	/* 0x0.20 - 0x0.31 */
	 u_int16_t nxt_ptr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_pcie_acs_ctrl_fields acs_ctrl_fields;
};

/* Description -   */
/* Size in bytes - 56 */
struct connectib_advanced_error_reporting {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t cap_id;
	/* Description -  */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t version;
	/* Description -  */
	/* 0x0.20 - 0x0.31 */
	 u_int16_t nxt_ptr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_uncorrectable_error_status uncorrectable_error_status;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 struct connectib_uncorrectable_error_mask uncorrectable_error_mask;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 struct connectib_uncorrectable_error_severity uncorrectable_error_severity;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 struct connectib_correctable_error_status correctable_error_status;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 struct connectib_correctable_error_mask correctable_error_mask;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 struct connectib_advanced_error_cap_ctl advanced_error_cap_ctl;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x2c.31 */
	 struct connectib_header_log header_log;
};

/* Description -  Device serial number capability */
/* Size in bytes - 12 */
struct connectib_dev_serial_num_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability id */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t cap_id;
	/* Description - capability id */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t version;
	/* Description - next capability pointer */
	/* 0x0.20 - 0x0.31 */
	 u_int16_t nxt_ptr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t serial_number_31_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t serial_number_63_32;
};

/* Description -  Single Root IO virtualization capability */
/* Size in bytes - 64 */
struct connectib_sriov_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - SR-IOV capability id */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t cap_id;
	/* Description - SR-IOV capability version */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t version;
	/* Description - next capability pointer */
	/* 0x0.20 - 0x0.31 */
	 u_int16_t nxt_ptr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_sriov_capabilities capabilities;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 struct connectib_sriov_control ctrl;
	/* Description -  */
	/* 0x8.16 - 0x8.31 */
	 struct connectib_sriov_status status;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The number of VFs that are initially associated with the PF    - default is not in use (overwrite by NV */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t initial_vfs;
	/* Description - The maximum number of VFs that could be associated with the PF - default is not in use (overwrite by NV */
	/* 0xc.16 - 0xc.31 */
	 u_int16_t total_vfs;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The number of VFs that are visible */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t num_vfs;
	/* Description - Function dependency Link */
	/* 0x10.16 - 0x10.23 */
	 u_int8_t func_dependency_link;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - First VF Offset */
	/* 0x14.0 - 0x14.15 */
	 u_int16_t first_vf_offset;
	/* Description - VF Stride */
	/* 0x14.16 - 0x14.31 */
	 u_int16_t vf_stride;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.16 - 0x18.31 */
	 u_int16_t vf_device_id;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Supported Page Sizes. By default support all page size up to 4MB */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t supported_page_sizes;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - System Page Size */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t system_page_size;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 struct connectib_bar_low vf_bar0;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x2c.31 */
	 struct connectib_bar_high vf_bar1;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x30.31 */
	 struct connectib_bar_low vf_bar2;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x34.31 */
	 struct connectib_bar_high vf_bar3;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x38.31 */
	 struct connectib_bar_low vf_bar4;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x3c.31 */
	 struct connectib_bar_high vf_bar5;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - VF Migration State Array Offset */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t vf_migstate_arrayofst;
};

/* Description -  alternative routing id cap */
/* Size in bytes - 8 */
struct connectib_ari_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability id */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t cap_id;
	/* Description - capability id */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t version;
	/* Description - next capability pointer */
	/* 0x0.20 - 0x0.31 */
	 u_int16_t nxt_ptr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 struct connectib_ari_capabilities ari_capabilities;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 struct connectib_ari_control ari_control;
};

/* Description -  Secondary pcie extended capability for gen3 device */
/* Size in bytes - 44 */
struct connectib_secondary_pciex_ext_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability id */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t cap_id;
	/* Description - capability version */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t version;
	/* Description - next capability pointer */
	/* 0x0.20 - 0x0.31 */
	 u_int16_t nxt_ptr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_pciex_link_ctl3 pciex_link_ctl3;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t lane_err_bits;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x2c.31 */
	 struct connectib_lane_eql_ctl lane_eql_ctl[8];
};

/* Description -  type1 configuration space header */
/* Size in bytes - 64 */
struct connectib_pci_cfg_type1_header {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Vendor ID */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t vendor_id;
	/* Description - Device ID */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t device_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Command Register */
	/* 0x4.0 - 0x4.15 */
	 struct connectib_cmd_reg1 command;
	/* Description - Status Register */
	/* 0x4.16 - 0x4.31 */
	 struct connectib_stat_reg1 status;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Revision ID */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t revision_id;
	/* Description - Class Code */
	/* 0x8.8 - 0x8.31 */
	 u_int32_t class_code;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Cache Line Size */
	/* 0xc.0 - 0xc.7 */
	 u_int8_t cache_line;
	/* Description - Primary Latency Timer */
	/* 0xc.8 - 0xc.15 */
	 u_int8_t latency;
	/* Description - Header Type */
	/* 0xc.16 - 0xc.23 */
	 struct connectib_header_type header_type;
	/* Description - BIST */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t bist;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Base Address Register 0 */
	/* 0x10.0 - 0x14.31 */
	 struct connectib_bar_low bar_low;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Base Address Register 1 */
	/* 0x14.0 - 0x18.31 */
	 struct connectib_bar_high bar_high;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Bus immediatly above the bridge */
	/* 0x18.0 - 0x18.7 */
	 u_int8_t primary_bus;
	/* Description - Bus immediatly below the bridge */
	/* 0x18.8 - 0x18.15 */
	 u_int8_t secondary_bus;
	/* Description - Furthest bus below the bridge */
	/* 0x18.16 - 0x18.23 */
	 u_int8_t subordinate_bus;
	/* Description - Secondary Latency */
	/* 0x18.24 - 0x18.31 */
	 u_int8_t secondary_latency;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - IO Base */
	/* 0x1c.0 - 0x1c.7 */
	 u_int8_t io_base;
	/* Description - IO Limit */
	/* 0x1c.8 - 0x1c.15 */
	 u_int8_t io_limit;
	/* Description - Secondary Status */
	/* 0x1c.16 - 0x1c.31 */
	 struct connectib_secondary_status secondary_status;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Memory Base */
	/* 0x20.0 - 0x20.15 */
	 u_int16_t memory_base;
	/* Description - Memory Limit */
	/* 0x20.16 - 0x20.31 */
	 u_int16_t memory_limit;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Prefetchable Memory Base */
	/* 0x24.0 - 0x24.15 */
	 u_int16_t pre_memory_base;
	/* Description - Prefetchable Memory Limit */
	/* 0x24.16 - 0x24.31 */
	 u_int16_t pre_memory_limit;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Prefetchable Base Upper 32 Bits */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t pre_base_upper_32;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - Prefetchable Limit Upper 32 Bits */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t pre_limit_upper_32;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - IO Base Upper 16 Bits */
	/* 0x30.0 - 0x30.15 */
	 u_int16_t io_base_upper_16;
	/* Description - IO Limit Upper 16 Bits */
	/* 0x30.16 - 0x30.31 */
	 u_int16_t io_limit_upper_16;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - Capabilities Pointer */
	/* 0x34.0 - 0x34.7 */
	 u_int8_t cap_ptr;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - Expansion ROM Base Address */
	/* 0x38.0 - 0x3c.31 */
	 struct connectib_exp_rom exp_rom_bar;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Interrupt Line */
	/* 0x3c.0 - 0x3c.7 */
	 u_int8_t interrupt_line;
	/* Description - Interrupt Pin */
	/* 0x3c.8 - 0x3c.15 */
	 u_int8_t interrupt_pin;
	/* Description - Bridge Control */
	/* 0x3c.16 - 0x3c.31 */
	 struct connectib_bridge_control bridge_control;
};

/* Description -  PCIe MSIX capability block */
/* Size in bytes - 12 */
struct connectib_msix_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability id */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t msix_cap_id;
	/* Description - next capability pointer */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t nxt_ptr;
	/* Description - VPD address */
	/* 0x0.16 - 0x0.31 */
	 struct connectib_message_control message_control;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Vector table BAR number */
	/* 0x4.0 - 0x4.2 */
	 u_int8_t Table_BIR;
	/* Description - Vector table offset in the BAR */
	/* 0x4.3 - 0x4.31 */
	 u_int32_t Table_Offset;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Pending bit array BAR number */
	/* 0x8.0 - 0x8.2 */
	 u_int8_t PBA_BIR;
	/* Description - PBA offset in the BAR */
	/* 0x8.3 - 0x8.31 */
	 u_int32_t PBA_Offset;
};

/* Description -  PCIe capability block */
/* Size in bytes - 60 */
struct connectib_pciex_cap_block {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability id */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t pciex_cap_id;
	/* Description - next capability pointer */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t nxt_ptr;
	/* Description -  */
	/* 0x0.16 - 0x0.31 */
	 struct connectib_pciex_cap pciex_cap;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_device_caps device_caps;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 struct connectib_device_ctl device_ctl;
	/* Description -  */
	/* 0x8.16 - 0x8.31 */
	 struct connectib_device_stat device_stat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 struct connectib_link_caps link_caps;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.15 */
	 struct connectib_link_ctl link_ctl;
	/* Description -  */
	/* 0x10.16 - 0x10.31 */
	 struct connectib_link_stat link_stat;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 struct connectib_slot_caps slot_caps;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 struct connectib_device_caps2 device_caps2;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x28.15 */
	 struct connectib_device_ctl2 device_ctl2;
	/* Description -  */
	/* 0x28.16 - 0x28.31 */
	 struct connectib_device_stat2 device_stat2;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x30.31 */
	 struct connectib_link_caps2 link_caps2;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x30.15 */
	 struct connectib_link_ctl2 link_ctl2;
	/* Description -  */
	/* 0x30.16 - 0x30.31 */
	 struct connectib_link_stat2 link_stat2;
};

/* Description -  PCIe VPD capability block */
/* Size in bytes - 8 */
struct connectib_vpd_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability id */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t vpd_cap_id;
	/* Description - next capability pointer */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t nxt_ptr;
	/* Description - VPD address */
	/* 0x0.16 - 0x0.30 */
	 u_int16_t vpd_address;
	/* Description - Flag - indicates a read/write command */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t F;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - VPD data */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t vpd_data;
};

/* Description -  Power Management Capability */
/* Size in bytes - 8 */
struct connectib_pci_power_management_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t cap_id;
	/* Description -  */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t nxt_ptr;
	/* Description -  */
	/* 0x0.16 - 0x0.18 */
	 u_int8_t version;
	/* Description -  */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t pme_clock;
	/* Description -  */
	/* 0x0.21 - 0x0.21 */
	 u_int8_t device_specific;
	/* Description -  */
	/* 0x0.22 - 0x0.24 */
	 u_int8_t aux_current;
	/* Description -  */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t d1_support;
	/* Description -  */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t d2_support;
	/* Description -  */
	/* 0x0.27 - 0x0.31 */
	 u_int8_t pme_support;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0-D0, 1-D1, 2-D2, 3-D3 */
	/* 0x4.0 - 0x4.1 */
	 u_int8_t power_state;
	/* Description - No_Soft_Reset - When set , this bit indicates that devices transitioning from D3hot to D0 because ofPowerState commands do not perform an internal reset. */
	/* 0x4.3 - 0x4.3 */
	 u_int8_t no_soft_reset;
	/* Description -  */
	/* 0x4.8 - 0x4.8 */
	 u_int8_t pme_enable;
	/* Description -  */
	/* 0x4.9 - 0x4.12 */
	 u_int8_t data_select;
	/* Description -  */
	/* 0x4.13 - 0x4.14 */
	 u_int8_t data_scale;
	/* Description -  */
	/* 0x4.15 - 0x4.15 */
	 u_int8_t pme_status;
	/* Description - not applicable for PCIe- should be 0 all the time */
	/* 0x4.16 - 0x4.23 */
	 u_int8_t pmcsr_bse;
	/* Description -  */
	/* 0x4.24 - 0x4.31 */
	 u_int8_t data;
};

/* Description -  type0 configuration space */
/* Size in bytes - 64 */
struct connectib_pci_cfg_type0_header {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - pcie vendor id */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t vendor_id;
	/* Description - pcie device id */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t device_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 struct connectib_cmd_reg1 cmd;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 struct connectib_stat_reg1 status;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - revision id */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t rev_id;
	/* Description - class code */
	/* 0x8.8 - 0x8.31 */
	 u_int32_t class_code;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.7 */
	 u_int8_t cache_line;
	/* Description -  */
	/* 0xc.8 - 0xc.15 */
	 u_int8_t latency;
	/* Description -  */
	/* 0xc.16 - 0xc.23 */
	 u_int8_t hdr_type;
	/* Description -  */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t bist;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 struct connectib_bar_low reg4;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 struct connectib_bar_high reg5;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 struct connectib_bar_low reg6;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 struct connectib_bar_high reg7;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x24.31 */
	 struct connectib_bar_low reg8;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 struct connectib_bar_high reg9;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x2c.15 */
	 u_int16_t sub_vendor_id;
	/* Description -  */
	/* 0x2c.16 - 0x2c.31 */
	 u_int16_t subsystem_id;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - expansion ROM base address */
	/* 0x30.0 - 0x34.31 */
	 struct connectib_exp_rom reg12;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - Capabilities pointer */
	/* 0x34.0 - 0x34.7 */
	 u_int8_t cap_ptr;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x3c.7 */
	 u_int8_t interrupt_line;
	/* Description -  */
	/* 0x3c.8 - 0x3c.15 */
	 u_int8_t interrupt_pin;
	/* Description -  */
	/* 0x3c.16 - 0x3c.31 */
	 u_int16_t min_gnt_max_lat;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_fw_block_behavior_fields {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - [MCC/MCDA flow] disable MFPA, MFBA and MFBE reg access cmds */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t disable_mfpa_mfba_mfbe;
	/* Description - [MCC/MCDA flow] write access to flash GW is disabled */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t disable_cr_space_flash_gw;
	/* Description - [MCC/MCDA flow] the fw_block_behavior fields overwrite the defaults value */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t en;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_fw_block_behavior_dw {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t dw;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_nv_config_host_func_main {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x18.31 */
	 struct connectib_external_port_pf_array external_port;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_nv_config_global_main {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_nv_roce_1_5_conf roce_1_5_next_prot;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0xc.31 */
	 struct connectib_nv_sw_offload_conf sw_offload_conf;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 struct connectib_nv_tlv_tweaks tweaks;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 struct connectib_nv_config_host_2_bmc host_2_bmc;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 struct connectib_nv_config_flex_nic flex_nic;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 struct connectib_nv_tlv_data_curr_config current_configurator;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_port_settings {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_nv_roce_cc roce_cc_ctrl;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x4c.31 */
	 struct connectib_nv_roce_cc_ecn roce_ecn;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description -  */
	/* 0x58.0 - 0x5c.31 */
	 struct connectib_nv_keep_link_up keep_link_up;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description -  */
	/* 0x60.0 - 0x6c.31 */
	 struct connectib_nv_lldp_nb_cap lldp_nb_cap;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description -  */
	/* 0x6c.0 - 0x78.31 */
	 struct connectib_nv_lldp_nb_conf lldp_nb_param;
/*---------------- DWORD[30] (Offset 0x78) ----------------*/
	/* Description -  */
	/* 0x78.0 - 0x7c.31 */
	 struct connectib_nv_lldp_nb_dcbx dcbx_nb;
/*---------------- DWORD[33] (Offset 0x84) ----------------*/
	/* Description -  */
	/* 0x84.0 - 0x90.31 */
	 struct connectib_nv_qos_conf qos_conf;
/*---------------- DWORD[36] (Offset 0x90) ----------------*/
	/* Description -  */
	/* 0x90.0 - 0x94.31 */
	 struct connectib_nv_qos_cap qos_cap;
/*---------------- DWORD[37] (Offset 0x94) ----------------*/
	/* Description -  */
	/* 0x94.0 - 0xdc.31 */
	 struct connectib_nv_qos_ets_tc_conf qos_ets_tc_conf;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_phy_lcl_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t PlaceHolder;
};

/* Description -   */
/* Size in bytes - 4 */
union connectib_port_cap_mask1 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_port_cap_mask1_fields fields;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_dword_val dword;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_reset_version {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Reset considered only if valid is set */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t valid;
	/* Description - If Major matches. Match means seamless reset. Greater means reset supported. Less then upgrade not supported */
	/* 0x0.4 - 0x0.15 */
	 u_int16_t minor;
	/* Description - Match means upgrade supported, mismatch implies reset not supported */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t major;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_dcr_odp_events {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_dcr_odp_event_entry event_entry[16];
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_disable_mask_value {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - This value correspond to the bits in enable_mask_bits that influence any_disable_bit_set function. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t value;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_disable_mask_bits {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t module_not_present;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t paos;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t mad;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t non_mlnx_long_range_cable;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t verification;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t ekey;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t high_power_not_allowed;
	/* Description -  */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t unknown_identifier;
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t paos_up_once_active;
	/* Description -  */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t stamping_failure;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_dmfs_ft_type_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - the root flow table id */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t root_ft;
	/* Description -  */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t ft_exist;
	/* Description -  */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t level0_ft_exist;
	/* Description -  */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t is_ft_root_set;
};

/* Description -   */
/* Size in bytes - 68 */
struct connectib_ocbb_fields_from_vpd {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.24 - 0x28.23 */
	 u_int8_t product_name[40];
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.24 - 0x34.23 */
	 u_int8_t part_number[12];
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.24 - 0x40.23 */
	 u_int8_t serial_number[12];
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.8 - 0x40.15 */
	 u_int8_t serial_number_size;
	/* Description -  */
	/* 0x40.16 - 0x40.23 */
	 u_int8_t part_number_size;
	/* Description -  */
	/* 0x40.24 - 0x40.31 */
	 u_int8_t product_name_size;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_fw_banner {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 u_int32_t fw_banner_str[3];
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_resource_type_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t type;
	/* Description - resource is locked in icmc */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t locked;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_index_and_length {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - first open resource index */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t index;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - number of open resources following (including the first one) */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t length;
};

/* Description -   */
/* Size in bytes - 8 */
union connectib_flow_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_dest_format_struct dest;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_flow_counter_list cntr;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_flow_table_entry_match_set_lyr_2_4 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Source MAC address of incoming packet. */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t smac_47_16;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Incoming packet Ethertype - this is the Ethertype following the last VLAN 
tag of the packet. */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t ethertype;
	/* Description - Source MAC address of incoming packet. */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t smac_15_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Destination MAC address of incoming packet. */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t dmac_47_16;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - VLAN ID of first VLAN tag in the incoming packet. Valid only when 
cvlan_tag==1 or svlan_tag==1. */
	/* 0xc.0 - 0xc.11 */
	 u_int16_t first_vid;
	/* Description - CFI bit of first VLAN tag in the incoming packet. Valid only when 
cvlan_tag==1 or svlan_tag==1. */
	/* 0xc.12 - 0xc.12 */
	 u_int8_t first_cfi;
	/* Description - Priority of first VLAN tag in the incoming packet. Valid only when 
cvlan_tag==1 or svlan_tag==1. */
	/* 0xc.13 - 0xc.15 */
	 u_int8_t first_prio;
	/* Description - Destination MAC address of incoming packet. */
	/* 0xc.16 - 0xc.31 */
	 u_int16_t dmac_15_0;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - TCP flags. 
Bit 0: FIN
Bit 1: SYN
Bit 2: RST
Bit 3: PSH
Bit 4: ACK
Bit 5: URG
Bit 6: ECE
Bit 7: CWR
Bit 8: NS */
	/* 0x10.0 - 0x10.8 */
	 u_int16_t tcp_flags;
	/* Description -  */
	/* 0x10.9 - 0x10.12 */
	 u_int8_t ip_version;
	/* Description - Packet is an IP fragment. */
	/* 0x10.13 - 0x10.13 */
	 u_int8_t frag;
	/* Description - The first vlan in the packet is s-vlan (0x8a88). cvlan_tag and svlan_tag 
cannot be set together. */
	/* 0x10.14 - 0x10.14 */
	 u_int8_t svlan_tag;
	/* Description - The first vlan in the packet is c-vlan (0x8100). cvlan_tag and svlan_tag 
cannot be set together */
	/* 0x10.15 - 0x10.15 */
	 u_int8_t cvlan_tag;
	/* Description - Explicit Congestion Notification derived from Traffic Class/TOS field of 
IPv6/v4 */
	/* 0x10.16 - 0x10.17 */
	 u_int8_t ip_ecn;
	/* Description - Differentiated Services Code Point derived from Traffic Class/TOS field 
of IPv6/v4 */
	/* 0x10.18 - 0x10.23 */
	 u_int8_t ip_dscp;
	/* Description - IP protocol. */
	/* 0x10.24 - 0x10.31 */
	 u_int8_t ip_protocol;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - TCP destination port. 
tcp and udp sport/dport are mutually exclusive. */
	/* 0x14.0 - 0x14.15 */
	 u_int16_t tcp_dport;
	/* Description - TCP source port.
tcp and udp sport/dport are mutually exclusive. */
	/* 0x14.16 - 0x14.31 */
	 u_int16_t tcp_sport;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - UDP destination port.
tcp and udp sport/dport are mutually exclusive. */
	/* 0x1c.0 - 0x1c.15 */
	 u_int16_t udp_dport;
	/* Description - UDP source port.
tcp and udp sport/dport are mutually exclusive. */
	/* 0x1c.16 - 0x1c.31 */
	 u_int16_t udp_sport;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - IPv6 source address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t src_ip_127_96;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - IPv6 source address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t src_ip_95_64;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - IPv6 source address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t src_ip_63_32;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - IPv6 source address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t src_ip_31_0;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - IPv6 destination address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t dst_ip_127_96;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - IPv6 destination address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t dst_ip_95_64;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - IPv6 destination address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t dst_ip_63_32;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - IPv6 destination address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t dst_ip_31_0;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_flow_table_entry_match_set_misc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Source SQN */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t source_sqn;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Source port.
0xffff determines wire port. */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t source_port;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - VLAN ID of first VLAN tag the inner header of the incoming packet. Valid 
only when inner_second_cvlan_tag ==1 or inner_second_svlan_tag ==1. */
	/* 0x8.0 - 0x8.11 */
	 u_int16_t inner_second_vid;
	/* Description - CFI bit of first VLAN tag in the inner header of the incoming packet. Valid 
only when inner_second_cvlan_tag ==1 or inner_second_svlan_tag ==1. */
	/* 0x8.12 - 0x8.12 */
	 u_int8_t inner_second_cfi;
	/* Description - Priority of second VLAN tag in the inner header of the incoming packet. 
Valid only when inner_second_cvlan_tag ==1 or inner_second_svlan_tag 
==1. */
	/* 0x8.13 - 0x8.15 */
	 u_int8_t inner_second_prio;
	/* Description - VLAN ID of first VLAN tag the outer header of the incoming packet. Valid 
only when outer_second_cvlan_tag ==1 or outer_second_svlan_tag ==1. */
	/* 0x8.16 - 0x8.27 */
	 u_int16_t outer_second_vid;
	/* Description - CFI bit of first VLAN tag in the outer header of the incoming packet. Valid 
only when outer_second_cvlan_tag ==1 or outer_second_svlan_tag ==1. */
	/* 0x8.28 - 0x8.28 */
	 u_int8_t outer_second_cfi;
	/* Description - Priority of second VLAN tag in the outer header of the incoming packet. 
Valid only when outer_second_cvlan_tag ==1 or outer_second_svlan_tag 
==1. */
	/* 0x8.29 - 0x8.31 */
	 u_int8_t outer_second_prio;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - GRE Protocol (outer). */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t gre_protocol;
	/* Description - The second vlan in the inner header of the packet is s-vlan (0x8a88). 
inner_second_cvlan_tag and inner_second_svlan_tag cannot be set together. */
	/* 0xc.28 - 0xc.28 */
	 u_int8_t inner_second_svlan_tag;
	/* Description - The second vlan in the outer header of the packet is s-vlan (0x8a88). out
er_second_cvlan_tag and outer_second_svlan_tag cannot be set together. */
	/* 0xc.29 - 0xc.29 */
	 u_int8_t outer_second_svlan_tag;
	/* Description - The second vlan in the inner header of the packet is c-vlan (0x8100). 
inner_second_cvlan_tag and inner_second_svlan_tag cannot be set together. */
	/* 0xc.30 - 0xc.30 */
	 u_int8_t inner_second_cvlan_tag;
	/* Description - The second vlan in the outer header of the packet is c-vlan (0x8100). out
er_second_cvlan_tag and outer_second_svlan_tag cannot be set together. */
	/* 0xc.31 - 0xc.31 */
	 u_int8_t outer_second_cvlan_tag;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - GRE Key [7:0] (outer). */
	/* 0x10.0 - 0x10.7 */
	 u_int8_t gre_key_l;
	/* Description - GRE Key[31:8] (outer). */
	/* 0x10.8 - 0x10.31 */
	 u_int32_t gre_key_h;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - VXLAN VNI (outer). */
	/* 0x14.8 - 0x14.31 */
	 u_int32_t vxlan_vni;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - GENEVE OAM field (outer) */
	/* 0x18.0 - 0x18.0 */
	 u_int8_t geneve_oam;
	/* Description - GENEVE VNI field (outer) */
	/* 0x18.8 - 0x18.31 */
	 u_int32_t geneve_vni;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Flow label of incoming IPv6 packet (outer). */
	/* 0x1c.0 - 0x1c.19 */
	 u_int32_t outer_ipv6_flow_label;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Flow label of incoming IPv6 packet (inner). */
	/* 0x20.0 - 0x20.19 */
	 u_int32_t inner_ipv6_flow_label;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - GENEVE protocol type (outer) */
	/* 0x24.0 - 0x24.15 */
	 u_int16_t geneve_protocol_type;
	/* Description - GENEVE protocol type (outer) */
	/* 0x24.16 - 0x24.21 */
	 u_int8_t geneve_opt_len;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Destination QP in BTH header. */
	/* 0x28.0 - 0x28.23 */
	 u_int32_t bth_dst_qp;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_ver_data_one_qp_per_recovery {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t rw_;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t input;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t output;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_ver_data_max_atomic {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - minimum value of 5, max value is 8. Set 0 to return to original value */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t log_max_atomic_size;
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_fw_vport_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  0-port is down, 1-port is up, 2-follow */
	/* 0x0.0 - 0x0.1 */
	 u_int8_t esw_state;
	/* Description -  ETH: 0-port is down, 1-port is up, IB: 1-down, 2- initalize, 3- arm, 4- active */
	/* 0x0.2 - 0x0.4 */
	 u_int8_t nic_state;
	/* Description -  */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t connected_2_steering;
	/* Description - bit mask: PORT_MAD_EVENT_NUM_PKEY =  0
PORT_MAD_EVENT_NUM_LID =  1
PORT_MAD_EVENT_NUM_CLIENT_REREG = 2
PORT_MAD_EVENT_NUM_GUID = 3
 PORT_MAD_EVENT_NUM_PORT_STATE = 4
PORT_MAD_EVENT_NUM_ERROR_CABLE_M0 = 5
PORT_MAD_EVENT_NUM_ERROR_CABLE_M1 = 6
 */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t event_mask;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_vf_pages_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 u_int64_t pages[8];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icm_page_manager {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - pointer to first free page. Head of page linked list */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t page_list;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Number of free pages (without the pre-allocated pages) available to GVMI */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t free_count;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Number of used pages of GVMI */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t used_count;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Number of free pages + pre-allocated unused pages */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t page_list_length;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - If set, means page manager is used by another flow */
	/* 0x14.0 - 0x14.0 */
	 u_int8_t lock;
	/* Description - Event was triggered and response is still pending */
	/* 0x14.1 - 0x14.1 */
	 u_int8_t event_pending;
	/* Description - Received a command from driver refusing to give pages. Return fail instead of wait for alloc pages request */
	/* 0x14.2 - 0x14.2 */
	 u_int8_t driver_refused;
	/* Description -  0-init state, 1-default state, 2-teardown state */
	/* 0x14.3 - 0x14.4 */
	 u_int8_t state;
	/* Description -  */
	/* 0x14.5 - 0x14.5 */
	 u_int8_t valid;
	/* Description -  */
	/* 0x14.16 - 0x14.23 */
	 u_int8_t num_vf_pages;
	/* Description -  */
	/* 0x14.24 - 0x14.31 */
	 u_int8_t vf_page_ix;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - process address space id - CAPI/ATS */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t page_owner_pasid;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hca_params {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t partition_cap;
	/* Description -  */
	/* 0x8.24 - 0x8.28 */
	 u_int8_t log_max_qp;
	/* Description -  */
	/* 0x8.29 - 0x8.29 */
	 u_int8_t phy_port_owner;
	/* Description -  */
	/* 0x8.30 - 0x8.30 */
	 u_int8_t eswitch_owner;
	/* Description -  */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t dct;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.8 - 0xc.13 */
	 u_int8_t log_max_ra_res_qp;
	/* Description -  */
	/* 0xc.24 - 0xc.29 */
	 u_int8_t log_max_ra_req_qp;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.8 - 0x10.15 */
	 u_int8_t num_ports;
	/* Description - If set, 128 byte Cache line size is supported.0 means only 64 byte cache line is supported */
	/* 0x10.31 - 0x10.31 */
	 u_int8_t cache_line_128byte;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - log2_uar_page_sz in 4kbyte chunks. 4-64 kbyte supported */
	/* 0x14.0 - 0x14.15 */
	 u_int16_t log_uar_page_sz;
	/* Description - sw format = log_gid_table_size-3: 0: 8 gid entries, 1: 16 gid entries, 2: 32 gid entries, 3: 64 gid entries, 4: 128 gid entries, other: reserved */
	/* 0x14.16 - 0x14.21 */
	 u_int8_t log_gid_table_size;
	/* Description -  */
	/* 0x14.22 - 0x14.22 */
	 u_int8_t uar_4k;
	/* Description - snapshot named_qp capability */
	/* 0x14.23 - 0x14.23 */
	 u_int8_t named_qp;
	/* Description - snapshot named_mkey capability */
	/* 0x14.24 - 0x14.24 */
	 u_int8_t named_mkey;
	/* Description - 0:BE,  1: according to HOST_ENDIENESS for 8B only */
	/* 0x14.28 - 0x14.29 */
	 u_int8_t atomic_req_8b_endianess_mode;
	/* Description -  */
	/* 0x14.30 - 0x14.30 */
	 u_int8_t init_hca_disable_linkup;
	/* Description - 0:BE   1:LE */
	/* 0x14.31 - 0x14.31 */
	 u_int8_t host_endianess;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 struct connectib_odp_hca_params odp_caps;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_dummy_addresses_one_cache_line {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 u_int64_t ix[8];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_cmdif_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t done_missions;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.24 */
	 u_int32_t res_num;
	/* Description -  */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t cmd_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t opcode;
	/* Description -  */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t op_mod;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t allocated_pages;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t needed_pages;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 union connectib_flush_type flush_type;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - valid only when flush_type qp_flush is set */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t flush_qpn;
	/* Description - valid only when flush_type qp_flush is set */
	/* 0x18.24 - 0x18.31 */
	 u_int8_t flush_synd;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t nim_start_offset;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x40.31 */
	 union connectib_cmdif_ctx_special s;
};

/* Description -   */
/* Size in bytes - 28 */
union connectib_comp_event_dct_events_qp_events_wqe_associated_page_fault_event_rdma_page_fault_event_cq_error_dropped_packet_logged_port_state_change_event_gpio_event_port_module_event_dcbx_change_event_temp_warning_event_db_bf_congestion_event_stall_vl_event_cmd_inter_comp_event_pages_req_event_nic_vport_change_event_fpga_error_event_fpga_qp_error_event_general_notification_delay_drop_event_auto {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_sw_eqe_flat_data flat_data;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_comp_event comp_event;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_dct_events dct_events;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_qp_events qp_events;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_wqe_associated_page_fault_event wqe_associated_page_fault_event;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_rdma_page_fault_event rdma_page_fault_event;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_cq_error cq_error;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_dropped_packet_logged dropped_packet_logged;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_port_state_change_event port_state_change_event;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_gpio_event gpio_event;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_port_module_event port_module_event;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_dcbx_change_event dcbx_change_event;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_temp_warning_event temp_warning_event;
	/* Description -  */
	/* 0x0.0 - 0x18.31 */
	 struct connectib_db_bf_congestion_event db_bf_congestion_event;
	/* Description -  */
	/* 0x0.0 - 0x18.31 */
	 struct connectib_stall_vl_event stall_vl_event;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_cmd_inter_comp_event cmd_inter_comp_event;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_pages_req_event pages_req_event;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_nic_vport_change_event nic_vport_change_event;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_fpga_error_event fpga_error_event;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_fpga_qp_error_event fpga_qp_error_event;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_pps_event pps_event;
	/* Description -  */
	/* 0x0.0 - 0x1c.31 */
	 struct connectib_general_notification_delay_drop_event general_notification_delay_drop_event;
};

/* Description -   */
/* Size in bytes - 272 */
union connectib_icmd_generic_reg_access_reg_tlv_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x108.31 */
	 union connectib_access_register_data_layout cmdif_access_register;
	/* Description -  */
	/* 0x0.0 - 0x10c.31 */
	 struct connectib_generic_flash_reg_access_data flash_reg_access;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_reg_access_tlv {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.16 - 0x0.26 */
	 u_int16_t len;
	/* Description - enum {
    EMAD_TLV_TYPE_END   = 0x0,
    EMAD_TLV_TYPE_OPER  = 0x1,
    EMAD_TLV_TYPE_RD    = 0x2,
    EMAD_TLV_TYPE_REG   = 0x3,
    EMAD_TLV_TYPE_UDATA = 0x4,
};
 */
	/* 0x0.27 - 0x0.31 */
	 u_int8_t type;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_IB_TID {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t High;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t Low;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_kdnet_ctrl_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Bus-Device-Function (BDF) of the PF that was/will be created for KDNET use.
This field is reserved when 
status
 field is DISABLED or ERROR. */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t kdnet_bdf;
	/* Description - Current status of the KDNET PF:
0x0: DISABLED
0x1: ENABLED
0x2: DISABLE_PENDING- the KDNET PF will be disabled after the next server boot
0x3: ENABLE_PENDING - the KDNET PF will be disabled after the next server boot.
0x4: BUSY - KDNET is enabled on other port
0xF: ERROR
other values are reserved */
	/* 0x0.28 - 0x0.31 */
	 u_int8_t status;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_kdnet_ctrl_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Command operation:
0x0: DISABLE 
0x1: ENABLE 
0x2: QUERY 
other values are reserved */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t operation;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_itrace_ctrl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - threashhold of logging to print from:
0 - LOG_DEBUG
1 - LOG_INFO
2 - LOG_WARNING
3 - LOG_ERROR */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t log_level;
	/* Description - added delay (usec) to prevent log event lost */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t log_delay;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_output_inline_standart {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - check the io function before changing this field.
overrun while status and syndrom is writen */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t auto_1;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t status;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t syndrome;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t ix;
	/* Description -  */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t auto_2;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t auto_3;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_input_inline_standart {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - manually added, for reserved equal zero test */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t reserved_0;
	/* Description -  */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t opcode;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t opcode_mod;
	/* Description - manually added, for reserved equal zero test */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t reserved_1;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t ix;
	/* Description - manually added, for reserved equal zero test */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t reserved_2;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - manually added, for reserved equal zero test */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t reserved_3;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_g_rse_decoders_as_dwords {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 u_int32_t dword[64];
};

/* Description -  // Created At Mon Oct  7 12:23:46 IST 2013, By the following script (revision 1.45): ./decoder2adb.tcl -f /net/mtlfs01/vol/veri2/rev/golan/../../../../../../fwgwork/danielg/shomron/verilog/golan/./rxs_rxt_desc_decoder.v -o rxs_rxt_desc_decoder -adbfile ../adabe/golan//hw_decoders_st.adb */
/* Size in bytes - 64 */
struct connectib_rxs_rxt_desc_decoder {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.13 */
	 u_int16_t payload_end_offset;
	/* Description -  */
	/* 0x4.14 - 0x4.14 */
	 u_int8_t mask_px_icmc_tpt_vld;
	/* Description -  */
	/* 0x4.15 - 0x4.15 */
	 u_int8_t need_invalidation;
	/* Description -  */
	/* 0x4.16 - 0x4.19 */
	 u_int8_t extended_rdb_size;
	/* Description -  */
	/* 0x4.20 - 0x4.22 */
	 u_int8_t max_rdma_atomic;
	/* Description -  */
	/* 0x4.23 - 0x4.23 */
	 u_int8_t scatter_grh;
	/* Description -  */
	/* 0x4.24 - 0x4.26 */
	 u_int8_t packet_type;
	/* Description -  */
	/* 0x4.27 - 0x4.27 */
	 u_int8_t can_use_reserved_lkey;
	/* Description -  */
	/* 0x4.28 - 0x4.28 */
	 u_int8_t use_dcr_gvmi_for_rdb;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x8.16 - 0x8.29 */
	 u_int16_t packet_len;
	/* Description -  */
	/* 0x8.30 - 0x8.30 */
	 u_int8_t free_line;
	/* Description -  */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t header_capture;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t qpn;
	/* Description -  */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t rdb_write_pointer;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t psn;
	/* Description -  */
	/* 0x10.24 - 0x10.31 */
	 u_int8_t payload_offset;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.23 */
	 u_int32_t pd;
	/* Description -  */
	/* 0x14.24 - 0x14.31 */
	 u_int8_t grh_offset;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t rkey;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t dma_length;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t va_63_32;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t va_31_0;
};

/* Description -  // Created At Mon Oct  7 12:23:46 IST 2013, By the following script (revision 1.45): ./decoder2adb.tcl -f /net/mtlfs01/vol/veri2/rev/golan/../../../../../../fwgwork/danielg/shomron/verilog/golan/./rxt_context_fetch_qp_desc_decoder.v -o rxt_context_fetch_qp_desc_decoder -adbfile ../adabe/golan//hw_decoders_st.adb */
/* Size in bytes - 16 */
struct connectib_rxt_context_fetch_qp_desc_decoder {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t qpc_ts_3_3;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t port_number;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x4.0 - 0x4.12 */
	 u_int16_t srq_number_23_11;
	/* Description - TODO: need to align this field to 16.  */
	/* 0x4.13 - 0x4.28 */
	 u_int16_t gvmi;
	/* Description - TODO: need to align this field to 4. This Field was broken due to 32-bit miss-alignement  */
	/* 0x4.29 - 0x4.31 */
	 u_int8_t qpc_ts_2_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.11 */
	 u_int16_t pkey_index;
	/* Description - TODO: need to align this field to 8.  */
	/* 0x8.12 - 0x8.19 */
	 u_int8_t my_gid_index;
	/* Description -  */
	/* 0x8.20 - 0x8.20 */
	 u_int8_t srq_vld;
	/* Description - TODO: need to align this field to 32. This Field was broken due to 32-bit miss-alignement  */
	/* 0x8.21 - 0x8.31 */
	 u_int16_t srq_number_10_0;
};

/* Description -  // Created At Mon Oct  7 12:23:46 IST 2013, By the following script (revision 1.45): ./decoder2adb.tcl -f /net/mtlfs01/vol/veri2/rev/golan/../../../../../../fwgwork/danielg/shomron/verilog/golan/./rxt_checks_steering_results_decoder.v -o rxt_checks_steering_results_decoder -adbfile ../adabe/golan//hw_decoders_st.adb */
/* Size in bytes - 16 */
struct connectib_rxt_checks_steering_results_decoder {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t vport_packet_counters_trigger;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x4.0 - 0x4.8 */
	 u_int16_t xqpn_40_32;
	/* Description -  */
	/* 0x4.9 - 0x4.9 */
	 u_int8_t pport_counters_trigger_vld;
	/* Description -  */
	/* 0x4.10 - 0x4.10 */
	 u_int8_t qpn_direct_access;
	/* Description -  */
	/* 0x4.11 - 0x4.11 */
	 u_int8_t vport_counters_trigger_vld;
	/* Description -  */
	/* 0x4.12 - 0x4.15 */
	 u_int8_t vport_byte_counters_trigger;
	/* Description -  */
	/* 0x4.16 - 0x4.23 */
	 u_int8_t pport_byte_counters_trigger;
	/* Description -  */
	/* 0x4.24 - 0x4.31 */
	 u_int8_t pport_packet_counters_trigger;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t xqpn_31_0;
};

/* Description -  // Created At Mon Oct  7 12:23:46 IST 2013, By the following script (revision 1.45): ./decoder2adb.tcl -f /net/mtlfs01/vol/veri2/rev/golan/../../../../../../fwgwork/danielg/shomron/verilog/golan/./rxt_steering_context_decoder.v -o rxt_steering_context_decoder -adbfile ../adabe/golan//hw_decoders_st.adb */
/* Size in bytes - 32 */
struct connectib_rxt_steering_context_decoder {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.5 */
	 u_int8_t log2_hit_table_size;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t take_qp_from_packet;
	/* Description -  */
	/* 0x0.8 - 0x0.11 */
	 u_int8_t vport_byte_counters_trigger;
	/* Description -  */
	/* 0x0.12 - 0x0.15 */
	 u_int8_t vport_packet_counters_trigger;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x4.16 - 0x4.23 */
	 u_int8_t pport_packet_counters_trigger;
	/* Description -  */
	/* 0x4.24 - 0x4.29 */
	 u_int8_t log2_hit_entry_size;
	/* Description -  */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t first_line_of_steering_entry;
	/* Description -  */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t sx_sniffer_accomulated;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t qp_list_index;
	/* Description -  */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t pport_byte_counters_trigger;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t member_count;
	/* Description -  */
	/* 0xc.24 - 0xc.31 */
	 u_int8_t hit_lookup_type_hash_field_mask;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t hit_base_address_55_32;
	/* Description -  */
	/* 0x10.24 - 0x10.31 */
	 u_int8_t hit_lookup_type;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t hit_base_address_31_0;
};

/* Description -  // Created At Mon Oct  7 12:23:47 IST 2013, By the following script (revision 1.45): ./decoder2adb.tcl -f /net/mtlfs01/vol/veri2/rev/golan/../../../../../../fwgwork/danielg/shomron/verilog/golan/./rxt_checks_packet_descriptor_decoder.v -o rxt_checks_packet_descriptor_decoder -adbfile ../adabe/golan//hw_decoders_st.adb */
/* Size in bytes - 64 */
struct connectib_rxt_checks_packet_descriptor_decoder {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.1 */
	 u_int8_t timestamp_version;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t force_loopback;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t functional_loopback;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t inner_crc_ok;
	/* Description -  */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t mad_baseversion_error;
	/* Description -  */
	/* 0x0.6 - 0x0.6 */
	 u_int8_t mad_classversion_error;
	/* Description -  */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t mad_send2host;
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t outer_crc_ok;
	/* Description -  */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t port_error;
	/* Description -  */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t sx_sniffer;
	/* Description -  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t timestamp_vld;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t payload_offset;
	/* Description -  */
	/* 0x4.16 - 0x4.19 */
	 u_int8_t custom_dw0_vld;
	/* Description -  */
	/* 0x4.20 - 0x4.23 */
	 u_int8_t custom_dw1_vld;
	/* Description -  */
	/* 0x4.24 - 0x4.27 */
	 u_int8_t custom_dw2_vld;
	/* Description -  */
	/* 0x4.28 - 0x4.31 */
	 u_int8_t custom_dw3_vld;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t custom_dw3;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t custom_dw2;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t custom_dw1;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t custom_dw0;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x18.0 - 0x18.8 */
	 u_int16_t source_xqpn_40_32;
	/* Description -  */
	/* 0x18.9 - 0x18.9 */
	 u_int8_t dummy_packet;
	/* Description - TODO: need to align this field to 8.  */
	/* 0x18.10 - 0x18.15 */
	 u_int8_t mad_qp1_class;
	/* Description -  */
	/* 0x18.16 - 0x18.31 */
	 u_int16_t packet_end_offset;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t source_xqpn_31_0;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t timestamp_63_32;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t timestamp_31_0;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_ctx_as_dwords {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 u_int32_t dwords[16];
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_fw_resource_context {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_fw_eqc fw_eqc;
	/* Description - ads layout */
	/* 0x0.0 - 0x30.31 */
	 struct connectib_fw_alt_path fw_alt_path;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_basic_res_ctx fw_basic;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_fw_cre fw_cre;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_fw_mkc fw_mkc;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_psv fw_psv;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_fw_cqc fw_cqc;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_fw_rqt fw_rqt;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_list_element list_element;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_dmfs_resources dmfs_resources;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_dc_control_packet_desc dc_control_packet_desc;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_vqos_arb_ctx vqos_arb_ctx;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_fw_transport_domain fw_transport_domain;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_fw_q_counters fw_q_counters;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_fw_ipoib_meta fw_ipoib_meta;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_scheduling_context sched_element_ctx;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_hca_contexts {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_hw_c_cqc hw_c_cqc;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_hw_c_eqc hw_c_eqc;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_mkc mkc;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_toc toc;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_hw_c_srq hw_c_srq;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_hw_dct dct;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_hw_c_qpc c_qpc;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_hw_s_qpc s_qpc;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_hw_qpc_r_dct r_qpc;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_port_info port_info;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_hw_bsf_entry bsf_entry;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_hw_base_psv base_psv;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_hw_trastb trastb;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_hw_trasta trasta;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_hw_sq_pointers sq_pointers;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_hw_gvmi_tokens gvmi_tokens;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_hw_sq_tokens sq_tokens;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_hw_klm_entry klm_entry;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 union connectib_hw_sxdc sxdc;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_hw_pipa pipa;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_hw_sq_qp_list sq_qp_list;
	/* Description - the timer is 8 bit, here its just a wrapper */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_hw_timer_32 timer;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_hw_pkey pkey;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_ste hw_ste;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_steering_entry_icmc steering_entry_icmc;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 union connectib_icm_mtt mtt;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_rdb rdb;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_hw_msix msix;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_qp_counter qp_counter;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_field_boundary {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t field_boundary;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_add_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t add_data;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_compare_mask_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t compare_mask_data;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_swap_mask_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t swap_mask_data;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_compare_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t compare_data;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_swap_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t swap_data;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_component_authentication_configuration {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0-NULL, 1-SHA256Digest, 3-2048 bit RSA */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t auth_type;
	/* Description - used for authenticating Factory Re-COnfiguration Responses */
	/* 0x0.27 - 0x0.27 */
	 u_int8_t frc_en;
	/* Description - used for signing NVCONFIG at MLNX level */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t mlnx_nvconfig_en;
	/* Description - used for authenticating NVCONFIG at OEM level */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t vendor_nvconfig_en;
	/* Description - used for authenticating CS tokens at OEM level */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t cs_token_en;
	/* Description - Used for authenticating firmware, DBG_FW, DBG Tokens */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t fw_en;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_data_pointer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Offset of entire list area from start of NV data area. Every unit is 64 bytes */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t offset_in_64_bytes;
	/* Description - Size of entire list area. Every unit is 64 bytes. */
	/* 0x0.16 - 0x0.25 */
	 u_int16_t size_in_64_bytes;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_jump_addresses {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t plastic;
};

/* Description -   */
/* Size in bytes - 68 */
struct connectib_pcie_rx_adaptation_cfg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t actual_ffe_tap_config_num;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t ffe_tap_value_lifting_en;
	/* Description - In case the ffe_tap values are modified manually in scratchpad,
 pushing this button will cause performing calibration for each set. */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t redo_calibration;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0: Default setup ffe tap values
1: PLX optimized ffe tap vlaues
 2-7: Default setup ffe tap values - Not used by default */
	/* 0x4.0 - 0x44.31 */
	 struct connectib_ffe_tap_set ffe_tap_config[8];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_pcie_tx_adaptation_cfg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - enable for tx adaptation at Ph 2. */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t tx_adaptation_config_num;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x10.31 */
	 struct connectib_GEN3_TRANSMITTER_SETTING tx_adaptation_ts_param[3];
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_pcie_debug_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.12 */
	 u_int16_t internal_cause_mask;
	/* Description - Opens PCIe width debug capability (can be used for width degrade debug)
When enabled pxp.port_state will be stoped at each Config.Width state and sample the received TS. */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t width_debug_en;
	/* Description - Opens PCIe speed debug capability (can be used for speed degrade debug)

TODO (still not affect FW operation)! */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t speed_debug_en;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t internal_cause_en;
};

/* Description -   */
/* Size in bytes - 52 */
struct connectib_pcie_equalization_and_eye {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Mellanox full swing parameter - default is max 63 */
	/* 0x0.0 - 0x0.5 */
	 u_int8_t local_fs;
	/* Description - Mellanox full swing parameter - default is max 63 */
	/* 0x0.8 - 0x0.12 */
	 u_int8_t local_lf;
	/* Description - preset to be requested at phase 2 */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t preset;
	/* Description - set in case we wish to request some preset at phase 2 */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t force_preset;
	/* Description - Equalization phase 0 timeout in     msec.
After this timeout (started upon entering to phase 0), and if relevant TS arrived on all lanes we move to phase 1. */
	/* 0x0.21 - 0x0.25 */
	 u_int8_t phase0_timeout;
	/* Description - Equalization phase 2 timeout i    n msec.
After this timeout (started upon entering to phase 2) we move to phase 3. */
	/* 0x0.26 - 0x0.30 */
	 u_int8_t phase2_timeout;
	/* Description - enables fast (within 1 usec) phase3 FW response during the equalization process */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t fast_x1_eql_for_compliance;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x30.31 */
	 u_int32_t gen3_preset[11];
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - ffe_tap_offset1 offset used for vertical eye opening */
	/* 0x30.0 - 0x30.4 */
	 u_int8_t eye_center_mixer_offset;
	/* Description - enable eye centering on the phase (horizontal). */
	/* 0x30.5 - 0x30.5 */
	 u_int8_t eye_center_mix90_en;
	/* Description - enable eye centering on the offset (vertical). */
	/* 0x30.6 - 0x30.6 */
	 u_int8_t eye_center_offset_en;
	/* Description - when set perform vertiacal eye centerting before horizntal. When clear perform horizontal eye centering first. */
	/* 0x30.7 - 0x30.7 */
	 u_int8_t first_offset_phase_second;
	/* Description - The time (in usec) we wait for error in TS */
	/* 0x30.8 - 0x30.15 */
	 u_int8_t phase_err_wait_time;
	/* Description - The time (in usec) we wait since mix90phase set, and till we reset the the TS error counter */
	/* 0x30.16 - 0x30.19 */
	 u_int8_t phase_stabilize_time;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_pcie_serdes_cfg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.2 */
	 u_int8_t sdr_preemp;
	/* Description -  */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t sdr_preemp_pre;
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t sdr_preemp_post;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t sdr_preemp_main;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.2 */
	 u_int8_t ddr_6_db_preemp;
	/* Description -  */
	/* 0x4.8 - 0x4.15 */
	 u_int8_t ddr_6_db_preemp_pre;
	/* Description -  */
	/* 0x4.16 - 0x4.23 */
	 u_int8_t ddr_6_db_preemp_post;
	/* Description -  */
	/* 0x4.24 - 0x4.31 */
	 u_int8_t ddr_6_db_preemp_main;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.2 */
	 u_int8_t ddr_3_dot_5_db_preemp;
	/* Description -  */
	/* 0x8.8 - 0x8.15 */
	 u_int8_t ddr_3_dot_5_db_preemp_pre;
	/* Description -  */
	/* 0x8.16 - 0x8.23 */
	 u_int8_t ddr_3_dot_5_db_preemp_post;
	/* Description -  */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t ddr_3_dot_5_db_preemp_main;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 struct connectib_GEN3_TRANSMITTER_SETTING gen3_def_tx_preset;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.7 */
	 u_int8_t slicer_ind_en;
	/* Description -  */
	/* 0x10.8 - 0x10.11 */
	 u_int8_t slicer1_enable;
	/* Description -  */
	/* 0x10.12 - 0x10.15 */
	 u_int8_t slicer2_enable;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.6 */
	 u_int8_t signal_detect_threshold;
	/* Description - If set, signal detect will be enabled by setting rx_power_mode = 0, and its threshold will be according INI.
Else, rx_power_mode = 1 */
	/* 0x14.7 - 0x14.7 */
	 u_int8_t signal_detect_en;
	/* Description -  */
	/* 0x14.8 - 0x14.11 */
	 u_int8_t ob_bias;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x20.31 */
	 struct connectib_ffe_tap_set default_ffe_tap_set;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_gpio_configurations {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.24 - 0x30.23 */
	 struct connectib_gpio_config gpio[48];
};

/* Description -   */
/* Size in bytes - 84 */
struct connectib_gpio_functions {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 struct connectib_gpio_function physical_led_p1;
	/* Description -  */
	/* 0x0.8 - 0x0.15 */
	 struct connectib_gpio_function physical_led_p2;
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 struct connectib_gpio_function logical_led_p1;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 struct connectib_gpio_function logical_led_p2;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 struct connectib_gpio_function gp_lv;
	/* Description -  */
	/* 0x4.8 - 0x4.15 */
	 struct connectib_gpio_function int_p1_l;
	/* Description -  */
	/* 0x4.16 - 0x4.23 */
	 struct connectib_gpio_function int_p2_l;
	/* Description -  */
	/* 0x4.24 - 0x4.31 */
	 struct connectib_gpio_function modprs_p1_l;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.7 */
	 struct connectib_gpio_function modprs_p2_l;
	/* Description -  */
	/* 0x8.8 - 0x8.15 */
	 struct connectib_gpio_function modsel_p1_l;
	/* Description -  */
	/* 0x8.16 - 0x8.23 */
	 struct connectib_gpio_function modsel_p2_l;
	/* Description -  */
	/* 0x8.24 - 0x8.31 */
	 struct connectib_gpio_function ncsi_arb_in;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.7 */
	 struct connectib_gpio_function ncsi_arb_out;
	/* Description -  */
	/* 0xc.8 - 0xc.15 */
	 struct connectib_gpio_function ncsi_crs_dv;
	/* Description -  */
	/* 0xc.16 - 0xc.23 */
	 struct connectib_gpio_function ncsi_rxd0;
	/* Description -  */
	/* 0xc.24 - 0xc.31 */
	 struct connectib_gpio_function ncsi_rxd1;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.7 */
	 struct connectib_gpio_function ncsi_txd0;
	/* Description -  */
	/* 0x10.8 - 0x10.15 */
	 struct connectib_gpio_function ncsi_txd1;
	/* Description -  */
	/* 0x10.16 - 0x10.23 */
	 struct connectib_gpio_function ncsi_ref_clk;
	/* Description -  */
	/* 0x10.24 - 0x10.31 */
	 struct connectib_gpio_function ncsi_tx_en;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.7 */
	 struct connectib_gpio_function oc_int_l;
	/* Description -  */
	/* 0x14.8 - 0x14.15 */
	 struct connectib_gpio_function ovt_wrng;
	/* Description -  */
	/* 0x14.16 - 0x14.23 */
	 struct connectib_gpio_function ovt_shtdn;
	/* Description -  */
	/* 0x14.24 - 0x14.31 */
	 struct connectib_gpio_function pe_rst_l;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.7 */
	 struct connectib_gpio_function gpio_func_reserved;
	/* Description -  */
	/* 0x18.8 - 0x18.15 */
	 struct connectib_gpio_function reset_p1_l;
	/* Description -  */
	/* 0x18.16 - 0x18.23 */
	 struct connectib_gpio_function reset_p2_l;
	/* Description -  */
	/* 0x18.24 - 0x18.31 */
	 struct connectib_gpio_function spi_clk;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.7 */
	 struct connectib_gpio_function spi_cs0_l;
	/* Description -  */
	/* 0x1c.8 - 0x1c.15 */
	 struct connectib_gpio_function spi_cs1_l;
	/* Description -  */
	/* 0x1c.16 - 0x1c.23 */
	 struct connectib_gpio_function spi_io0;
	/* Description -  */
	/* 0x1c.24 - 0x1c.31 */
	 struct connectib_gpio_function spi_io1;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x20.7 */
	 struct connectib_gpio_function spi_io2;
	/* Description -  */
	/* 0x20.8 - 0x20.15 */
	 struct connectib_gpio_function spi_io3;
	/* Description -  */
	/* 0x20.16 - 0x20.23 */
	 struct connectib_gpio_function i2c_scl1;
	/* Description -  */
	/* 0x20.24 - 0x20.31 */
	 struct connectib_gpio_function i2c_scl2;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x24.7 */
	 struct connectib_gpio_function i2c_scl3;
	/* Description -  */
	/* 0x24.8 - 0x24.15 */
	 struct connectib_gpio_function i2c_sda1;
	/* Description -  */
	/* 0x24.16 - 0x24.23 */
	 struct connectib_gpio_function i2c_sda2;
	/* Description -  */
	/* 0x24.24 - 0x24.31 */
	 struct connectib_gpio_function i2c_sda3;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x28.7 */
	 struct connectib_gpio_function i2c_int_l;
	/* Description -  */
	/* 0x28.8 - 0x28.15 */
	 struct connectib_gpio_function i2c_rst_l;
	/* Description -  */
	/* 0x28.16 - 0x28.23 */
	 struct connectib_gpio_function vdd_mod;
	/* Description -  */
	/* 0x28.24 - 0x28.31 */
	 struct connectib_gpio_function wake_l;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x2c.7 */
	 struct connectib_gpio_function ibm_mezz_fault_l;
	/* Description -  */
	/* 0x2c.8 - 0x2c.15 */
	 struct connectib_gpio_function ibm_ite_all_pgood;
	/* Description -  */
	/* 0x2c.16 - 0x2c.23 */
	 struct connectib_gpio_function ibm_t_control_l;
	/* Description -  */
	/* 0x2c.24 - 0x2c.31 */
	 struct connectib_gpio_function ibm_t_warning_l;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x30.7 */
	 struct connectib_gpio_function ibm_t_critical_l;
	/* Description -  */
	/* 0x30.8 - 0x30.15 */
	 struct connectib_gpio_function ibm_cib_slot_id_0;
	/* Description -  */
	/* 0x30.16 - 0x30.23 */
	 struct connectib_gpio_function ibm_cib_slot_id_1;
	/* Description -  */
	/* 0x30.24 - 0x30.31 */
	 struct connectib_gpio_function ibm_vpd_update_l;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x34.7 */
	 struct connectib_gpio_function ibm_vpd_cache_comp;
	/* Description -  */
	/* 0x34.8 - 0x34.15 */
	 struct connectib_gpio_function ibm_vpd_ctrl;
	/* Description -  */
	/* 0x34.16 - 0x34.23 */
	 struct connectib_gpio_function gpio_port_swap;
	/* Description -  */
	/* 0x34.24 - 0x34.31 */
	 struct connectib_gpio_function gpio_func_reserved_1;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_i2c_device_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - I2C slave address of device */
	/* 0x0.0 - 0x0.6 */
	 u_int8_t slave_addr;
	/* Description - I2C bus number of device */
	/* 0x0.8 - 0x0.9 */
	 u_int8_t bus_id;
	/* Description - I2C addr size of device */
	/* 0x0.16 - 0x0.18 */
	 u_int8_t addr_size;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_module_config_st {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - 1.5W
1 - 2W
2 - 2.5W
3 - 3.5W */
	/* 0x0.0 - 0x0.1 */
	 u_int8_t module_power_level_supported;
	/* Description - 0.1W granularity */
	/* 0x0.2 - 0x0.7 */
	 u_int8_t module_mlnx_sub_power_supported;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_iopx_power {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t ref_clk_right_left_;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_iopl_power {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t ref_clk_right_left_;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t dynamic_pll_manage_en;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t dynamic_serdes_manage_en;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_port_mlpn_db {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - mlpn ability bits */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_mlpn_database_all_protocol_ini mlpn_supported;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - mlpn request bits */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_mlpn_database_all_protocol_ini mlpn_request;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - mlpn mlnx_enhanced_equalization_info bits */
	/* 0x8.0 - 0xc.31 */
	 struct connectib_mlpn_enhanced_database_ini mlpn_enhanced_database;
};

/* Description -   */
/* Size in bytes - 36 */
struct connectib_pll_params {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t pll_fctrl_th;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t enable_phy_varactor_calibration;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x14.31 */
	 u_int32_t pll_fctrl_var[4];
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x24.31 */
	 u_int32_t pll_fctrl_val[4];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_logic_serdes_mapping_node_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_tx_rx_logic_serdes_mapping_node_ini tx;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x40.31 */
	 struct connectib_tx_rx_logic_serdes_mapping_node_ini rx;
};

/* Description -   */
/* Size in bytes - 1472 */
struct connectib_phy_hw_main_config_ip {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_PORT_PHY_ini port[2];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x80.31 */
	 struct connectib_ib_ini_ini ib;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 0x80.0 - 0x98.31 */
	 struct connectib_rx_adapt_ini rx_adapt_ini;
/*---------------- DWORD[40] (Offset 0xa0) ----------------*/
	/* Description -  */
	/* 0xa0.0 - 0x4e0.31 */
	 struct connectib_serdes_conf_ini serdes_conf;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_config_boot_port_settings {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_nv_tlv_data_vpi_settings vpi;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_nv_config_boot_global {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_nv_config_pci pci;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x28.31 */
	 struct connectib_nv_config_tpt tpt;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x30.31 */
	 struct connectib_nv_config_kdnet_data kdnet_data;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_pciex_ext_cfg_space {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_secondary_pciex_ext_cap secondary_pciex_ext_cap;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - Alternative Routing ID cap */
	/* 0x2c.0 - 0x34.31 */
	 struct connectib_ari_cap ari;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - Single Root IO virtualization capability */
	/* 0x34.0 - 0x74.31 */
	 struct connectib_sriov_cap sriov;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description - Device serial number capability */
	/* 0x74.0 - 0x80.31 */
	 struct connectib_dev_serial_num_cap device_serial_number;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 0x80.0 - 0xb8.31 */
	 struct connectib_advanced_error_reporting advanced_error_reporting;
/*---------------- DWORD[48] (Offset 0xc0) ----------------*/
	/* Description -  */
	/* 0xc0.0 - 0xc8.31 */
	 struct connectib_acs_ext_cap acs;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_pci_cfg_space {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_pci_cfg_type0_header cfg_hdr;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - Power Management Capability */
	/* 0x40.0 - 0x48.31 */
	 struct connectib_pci_power_management_cap power_management;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - VPD Capability */
	/* 0x48.0 - 0x50.31 */
	 struct connectib_vpd_cap vpd;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - image status - if not 0 then indicates the cause for going to livefish */
	/* 0x50.0 - 0x54.31 */
	 u_int32_t image_status;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - The address for crspace access */
	/* 0x58.0 - 0x5c.31 */
	 u_int32_t cr_addr;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - The data for crspace access */
	/* 0x5c.0 - 0x60.31 */
	 u_int32_t cr_data;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - PCIe capability block */
	/* 0x60.0 - 0x9c.31 */
	 struct connectib_pciex_cap_block pciex_cap_block;
/*---------------- DWORD[39] (Offset 0x9c) ----------------*/
	/* Description - PCIe MSIX capability block */
	/* 0x9c.0 - 0xa8.31 */
	 struct connectib_msix_cap msix;
/*---------------- DWORD[42] (Offset 0xa8) ----------------*/
	/* Description -  */
	/* 0xa8.0 - 0xe8.31 */
	 struct connectib_pci_cfg_type1_header type1_cfg_hdr;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_logger_init_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.14 */
	 u_int16_t cfg_request_mask;
	/* Description -  */
	/* 0x0.15 - 0x0.24 */
	 u_int16_t splix_mask;
	/* Description -  */
	/* 0x0.25 - 0x0.30 */
	 u_int8_t writes_amount;
};

/* Description -   */
/* Size in bytes - 4 */
union connectib_fw_block_behavior {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - dword for the extra capabilities */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_block_behavior_dw dw;
	/* Description - fields description for the extra capabilities */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_fw_block_behavior_fields fields;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_nv_config_main_fw_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x200.31 */
	 struct connectib_port_settings port[2];
/*---------------- DWORD[128] (Offset 0x200) ----------------*/
	/* Description -  */
	/* 0x200.0 - 0x240.31 */
	 struct connectib_nv_config_global_main global;
/*---------------- DWORD[160] (Offset 0x280) ----------------*/
	/* Description - tlvs with class host_func */
	/* 0x280.0 - 0x298.31 */
	 struct connectib_nv_config_host_func_main host_func_pf_order;
};

/* Description -   */
/* Size in bytes - 384 */
struct connectib_phy_fw_main_config_ip {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t PlaceHolder;
};

/* Description -   */
/* Size in bytes - 232 */
struct connectib_phy_fw_main_config_golan {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_phy_lcl_ini lcl[2];
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_wol_cap_host_port {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - bit0 - host0 port0, bit1 - host1 port 0, ..., bit 4 - host0 port 1, bit5 - host1 port1 */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t magic_packet;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_ibm_thermal_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t enable;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t thermal_threshold_tcontrol;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t thermal_threshold_tcontrol_low;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t thermal_threshold_twarning;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t thermal_threshold_twarning_low;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t thermal_threshold_tcritical;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t thermal_threshold_tcritical_low;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_ocsd_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t enable;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t internal_caution_threshold;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t extrenal_caution_threshold;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t internal_max_cont_threshold;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t external_max_cont_threshold;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_fw_vport0_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t partition_cap;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t log_guid_cap;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_extended_port_info_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t link_speed_supported;
	/* Description -  */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t link_speed_enabled;
	/* Description -  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t llr_64_byte_cell_size;
	/* Description -  */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t llr_128_byte_cell_size;
	/* Description -  */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t link_up_after_boot;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_ib_port_info_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Additional supported capabilities of this port. Valid only if IsCapabilityMask2Supported bit is set in CapabilityMask. A bit set to 1 indicates affirmation of supported capability. 0: IsSetNodeDescriptionSupportede 1: IsPortInfoExtendedSupported 2-15: Reserved */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t cap_mask2;
	/* Description - Diagnostic code, as described in 14.2.5.6.1 Interpretation of DiagCode on page 889. */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t diag_code;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Optional; shall be 0 if not implemented (PortInfo:CapabilityMask.IsLinkRoundTripLatency-Supported = 0). This value represents a measurement of the round-trip latency of the link attached to this port. It is an unsigned 24-bit integer counting 4 nsec. intervals. This value might not be accurate to better than +/- 4 nsec. A value of 0 is valid when implemented, and indicates a latency of up to 4 nsec. LinkRoundTripLatency is reset to 0xFFFFFF whenever this port transitions to PortState = Down. Each time a link heartbeat reply (ACK) is received on this port when PortState is not Down, this value is set to the minimum of (a) the prior value of this attribute; and (b) the time elapsed since the corresponding heartbeat (SND) was sent. Note that while the value of this component will never increase, it may change over time due to varying queueing delays associated with traffic load. Note that this component is always 0 for Enhanced SP 0. See InfiniBand Architecture Volume 2, Link/Phy Interface chapter. */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t link_roundtrip_lat;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Optional; shall be 0 if not implemented (PortInfo:CapabilityMask.IsLinkRoundTripLatency-Supported = 0). This value provides a vendordependent indication of the maximum number of credits available per VL on the Port. */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t max_credit_hint;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 union connectib_port_cap_mask1 cap_mask;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.7 */
	 u_int8_t link_width_sup;
	/* Description - Enabled link width, indicated as follows: 0: No State Change valid only on Set(); 1: 1x 2: 4x; 3: 1x or 4x; 4: 8x; 5: 1x or 8x; 6: 4x or 8x; 7: 1x or 4x or 8x; 8: 12x; 9: 1x or 12x; 10: 4x or 12x; 11: 1x or 4x or 12x; 12: 8x or 12x; 13: 1x or 8x or 12x; 14: 4x or 8x or 12x; 15: 1x or 4x or 8x or 12x; 16 - 254: Reserved; 255: Set to LinkWidthSupported value; response; contains actual LinkWidthSupported.;Changes to this component do not take effect immediately. See InfiniBand Architecture Specification Volume 2, Link/Phy Interface chapter. */
	/* 0x10.8 - 0x10.15 */
	 u_int8_t link_width_ena;
	/* Description - Enabled link speed, indicated as follows: 0: No State Change; valid only on Set(); 1: 2.5 Gbps (also when SMSupportsExtended-Speeds is set to 0 on set, disable any extended speeds); 3: 2.5 or 5.0 Gbps (also when SMSupportsExtendedSpeeds is set to 0 on set, disable any extended speeds); 5: 2.5 or 10.0 Gbps (or higher when SMSupportsExtendedSpeeds is set to 0 in request/response AM); 7: 2.5 or 5.0 or 10.0 Gbps (or higher when SMSupportsExtendedSpeeds is set to 0 in request/response AM); 2, 4, 6, 8-14 Reserved; 15: Set to LinkSpeedSupported value; response contains actual LinkSpeedSupported. In addition to the LinkSpeedSupported value, when SMSupportsExtendedSpeeds is set to 0 in request/response AM, response contains QDR indication if an extended speed is enabled.; Note: See 14.3.14 SMSupportsExtendedLink-Speeds on page 932 for more information on SMSupportsExtendedSpeeds.; Changes to this component do not take effect immediately. See InfiniBand Architecture Specification Volume 2, Link/Phy Interface chapter. */
	/* 0x10.16 - 0x10.19 */
	 u_int8_t link_speed_ena;
	/* Description - 0: No state change; valid only on Set(); 1: Sleep; 2: Polling; 3 - 15: Reserved; See InfiniBand Architecture Specification Volume 2, Link/Phy Interface chapter. */
	/* 0x10.20 - 0x10.23 */
	 u_int8_t down_def_state;
	/* Description - Supported link speed, indicated as follows: 1: 2.5 Gbps; 3: 2.5 or 5.0 Gbps; 5: 2.5 or 10.0 Gbps (or higher when SMSupportsExtendedSpeeds is set to 0 in request/response AM); 7: 2.5 or 5.0 or 10.0 Gbps (or higher when SMSupportsExtendedSpeeds is set to 0 in request/response AM); 0, 2, 4, 6, 8-15: Reserved; Note: See 14.3.14 SMSupportsExtendedLink-Speeds on page 932 for more information on SMSupportsExtendedSpeeds. */
	/* 0x10.24 - 0x10.27 */
	 u_int8_t link_speed_sup;
	/* Description - Optional; shall be 0 if not implemented. Type of initialization requested by this port before SM moves it to Active or Armed state. See 14.4.4 Node Reinitialization on page 947.;/  bit 0: NoLoad. 0 = Port is requesting that its attributes be initialized (see 14.4.3 Initialization Actions on page 943). 1 = Port is requesting that no data be loaded into its attributes at all, asserting that the last-loaded data still exists and is valid.;/  bit 1: PreserveContent. 0 = Port makes no request regarding content of the data that is loaded into its attributes. 1 = Port is requesting that all such data, if loaded, be set to the most recent content loaded by the SM.;/ bit 2: PreservePresence. 0 = Port is requesting that all settable SA attributes referencing this port (see Table 209 Subnet Administration Attribute / Method Map on page 968) be removed prior to activating this port and Report()s of in/out of service (trap numbers 64/65) be sent. 1 = Port is requesting that all such data be preserved, and Report()s of in/out of service (trap numbers 64/65) not be sent for this port.;/ bit 3: DoNotResuscitate. 0 = bits 0, 1, and 2 of this field are valid; initialization of this port should begin based on their values. 1 = bits 0, 1, and 2 are not valid; port is requesting that reinitialization of this port, and any Report()s of in/out of service (trap numbers 64/65) be delayed until this bit is set to 0. */
	/* 0x10.28 - 0x10.31 */
	 u_int8_t init_type;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - VL/Weight pairs supported on this port in the VLArbitration table for high priority. Shall be 1 to 64 if more than one data VL is supported on this port, 0 otherwise. See 7.6.9 VL Arbitration and Prioritization on page 200. */
	/* 0x14.0 - 0x14.7 */
	 u_int8_t vl_arb_high_cap;
	/* Description - Limit of High Priority component of VL Arbitration Table, as defined in 7.6.9 VL Arbitration and Prioritization on page 200. */
	/* 0x14.8 - 0x14.15 */
	 u_int8_t vl_high_limit;
	/* Description - VL/Weight pairs supported on this port in the VLArbitration table for high priority. Shall be 1 to 64 if more than one data VL is supported on this port, 0 otherwise. See 7.6.9 VL Arbitration and Prioritization on page 200. */
	/* 0x14.20 - 0x14.27 */
	 u_int8_t vl_arb_low_cap;
	/* Description - Virtual Lanes operational on this port, indicated as follows: 0: No change; valid only on Set();/ 1: VL0;/ 2: VL0, VL1;/ 3: VL0 - VL3;/ 4: VL0 - VL7;/ 5: VL0 - VL14;/ 6 - 15: reserved;/ Changing OperationalVLs in certain PortStates may cause flow control update errors which may initiate Link/Phy retraining. */
	/* 0x14.28 - 0x14.31 */
	 u_int8_t operational_vl;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Virtual Lanes operational on this port, indicated as follows: 0: No change; valid only on Set();/ 1: VL0;/ 2: VL0, VL1;/ 3: VL0 - VL3;/ 4: VL0 - VL7;/ 5: VL0 - VL14;/ 6 - 15: reserved;/ Changing OperationalVLs in certain PortStates may cause flow control update errors which may initiate Link/Phy retraining. */
	/* 0x18.0 - 0x18.3 */
	 u_int8_t neighbor_mtu;
	/* Description - Maximum MTU supported by this port.;/ 1: 256 ;/ 2: 512;/ 3: 1024;/ 4: 2048;/ 5: 4096;/ 0, 6 - 15: reserved */
	/* 0x18.4 - 0x18.7 */
	 u_int8_t mtu_cap;
	/* Description - Multicast PKey Trap Suppression Enable */
	/* 0x18.8 - 0x18.9 */
	 u_int8_t mc_pkey_trap_suppress_en;
	/* Description - Number of GUID entries supported in the GUIDInfo attribute for this port. */
	/* 0x18.10 - 0x18.17 */
	 u_int8_t guid_cap;
	/* Description - Specifies the expected maximum time between the port reception of a SMP and the transmission of the associated response. The duration of time is calculated based on (4.096 usec * 2^RespTimeValue). */
	/* 0x18.18 - 0x18.22 */
	 u_int8_t resp_time_value;
	/* Description - 0: No State Change; valid only on Set(); 1: 14.0625 Gbps (FDR); 2: 25.78125 Gbps (EDR); 3: 14.0625 Gbps (FDR) or 25.78125 Gbps (EDR); 4-29: Reserved; 30: Disable extended link speeds/Extended link speeds disabled; 31: Set to LinkSpeedExtSupported value; response contains actual LinkSpeedExtSupported; */
	/* 0x18.23 - 0x18.27 */
	 u_int8_t link_speed_ext_ena;
	/* Description - 0: Reserved; 1: 14.0625 Gbps (FDR); 2: 25.78125 Gbps (EDR); 3: 14.0625 Gbps (FDR) or 25.78125 Gbps (EDR); 4-15: Reserved */
	/* 0x18.28 - 0x18.31 */
	 u_int8_t link_speed_ext_sup;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_node_info_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t node_type;
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t class_version;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t base_version;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t system_image_guid_hi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t system_image_guid_lo;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t node_guid_hi;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t node_guid_lo;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t port_guid_hi;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t port_guid_lo;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.15 */
	 u_int16_t device_id;
	/* Description -  */
	/* 0x1c.16 - 0x1c.31 */
	 u_int16_t partition_cap;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t revision;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x24.23 */
	 u_int32_t vendor_id;
	/* Description -  */
	/* 0x24.24 - 0x24.31 */
	 u_int8_t local_port_num;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_led_port_blink_pattern {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t phy_pattern;
	/* Description -  */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t log_pattern;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t length;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_uid_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Number of allocated UIDs in this entry */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t num_allocated;
	/* Description - Step size by which to derive the UIDs for this entry
See struct description */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t step;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - For MACs, the upper 16 bits in the 'hi' dword are reserved */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t uid;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_module_version {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t branch;
	/* Description -  */
	/* 0x0.8 - 0x0.19 */
	 u_int16_t minor;
	/* Description -  */
	/* 0x0.20 - 0x0.31 */
	 u_int16_t major;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_reset_level_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_reset_version ver;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t ini_sig;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 2^0-full ISFU, 2^1-management+link up ISFU 2^2-only PCIe ISFU 2^3-PCI disable/enable, 2^7-power_up */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t reset_type;
	/* Description -  */
	/* 0x8.8 - 0x8.8 */
	 u_int8_t ini_sig_v;
	/* Description -  */
	/* 0x8.9 - 0x8.9 */
	 u_int8_t ini_sig_ignore;
};

/* Description -   */
/* Size in bytes - 732 */
struct connectib_sysport_packet_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x2dc.31 */
	 u_int32_t data[183];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_sysport_packet_properties {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t portid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t vl;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t prio;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t func_loopback;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t force_loopback;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t sx_sniffer;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t packet_is_roce;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_rw_gvmi_fw_ctx_sub_structs {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_dcr_odp_events dcr_odp_event;
};

/* Description -   */
/* Size in bytes - 4 */
union connectib_disable_mask {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - enable the port - bit for each reason */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_disable_mask_bits bits;
	/* Description - enable the port - total value of the mask */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_disable_mask_value value;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_drivers_mask_arr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0-63 per pf */
	/* 0x0.0 - 0x8.31 */
	 u_int32_t mask[2];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_vport_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - IB + ROCE */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t port_guid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - IB + ROCE */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t node_guid;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x18.31 */
	 struct connectib_mac_address_layout permanent_address;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.15 */
	 u_int16_t cap_mask;
	/* Description -  */
	/* 0x18.16 - 0x18.27 */
	 u_int16_t allowed_uc_list_size;
	/* Description -  */
	/* 0x18.28 - 0x18.28 */
	 u_int8_t force_roce_disable_shadow;
	/* Description - disable RoCE per function */
	/* 0x18.29 - 0x18.29 */
	 u_int8_t force_roce_disable;
	/* Description - vport ctx was changed but event wasn't armed */
	/* 0x18.30 - 0x18.30 */
	 u_int8_t esw_ctx_dirty;
	/* Description -  */
	/* 0x18.31 - 0x18.31 */
	 u_int8_t roce_en;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.15 */
	 u_int16_t p_key_violations;
	/* Description - IB + ROCE */
	/* 0x1c.16 - 0x1c.31 */
	 u_int16_t q_key_violations;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x20.11 */
	 u_int16_t allowed_mc_list_size;
	/* Description -  */
	/* 0x20.12 - 0x20.12 */
	 u_int8_t event_on_uc_address_change;
	/* Description -  */
	/* 0x20.13 - 0x20.13 */
	 u_int8_t event_on_mc_address_change;
	/* Description -  */
	/* 0x20.14 - 0x20.14 */
	 u_int8_t event_on_vlan_change;
	/* Description -  */
	/* 0x20.15 - 0x20.15 */
	 u_int8_t event_on_promisc_change;
	/* Description -  */
	/* 0x20.16 - 0x20.27 */
	 u_int16_t allowed_vlan_list_size;
	/* Description -  */
	/* 0x20.28 - 0x20.28 */
	 u_int8_t arm_change_event;
	/* Description -  */
	/* 0x20.29 - 0x20.29 */
	 u_int8_t promisc_all;
	/* Description -  */
	/* 0x20.30 - 0x20.30 */
	 u_int8_t promisc_mc;
	/* Description -  */
	/* 0x20.31 - 0x20.31 */
	 u_int8_t promisc_uc;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.22 - 0x24.22 */
	 u_int8_t disable_mc_local_lb;
	/* Description -  */
	/* 0x24.23 - 0x24.23 */
	 u_int8_t disable_uc_local_lb;
	/* Description -  */
	/* 0x24.24 - 0x24.26 */
	 u_int8_t min_wqe_inline_mode;
	/* Description - the offset in FW ICM context */
	/* 0x24.27 - 0x24.27 */
	 u_int8_t uc_list_offset_selector;
	/* Description - the offset in FW ICM context */
	/* 0x24.28 - 0x24.28 */
	 u_int8_t mc_list_offset_selector;
	/* Description - the offset in FW ICM context */
	/* 0x24.29 - 0x24.29 */
	 u_int8_t vlan_list_offset_selector;
	/* Description - was mtu ever written by vnic */
	/* 0x24.30 - 0x24.30 */
	 u_int8_t mtu_vld;
	/* Description -  */
	/* 0x24.31 - 0x24.31 */
	 u_int8_t event_on_mtu_change;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x28.15 */
	 u_int16_t mtu;
	/* Description - flow_counter_id of the vport flow counters link list head */
	/* 0x28.16 - 0x28.31 */
	 u_int16_t flow_counter_head;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x30.31 */
	 struct connectib_dmfs_ft_type_info esw_egress_info;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x34.31 */
	 struct connectib_dmfs_ft_type_info esw_ingress_info;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - this field defines dcbx and other event types */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t extension_event_mask;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_vport_shadow {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - IB + ROCE */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t port_guid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - IB + ROCE */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t node_guid;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x18.31 */
	 struct connectib_mac_address_layout permanent_address;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_ocbb_pci_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t pci_vendor_id;
	/* Description -  */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t pci_device_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t pci_subsys_vendor_id;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t pci_subsys_device_id;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t num_of_pcie_func_per_port;
	/* Description -  */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t pci_bus_number;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t pci_class;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.7 */
	 u_int8_t pci_bus_rx_utilization;
	/* Description -  */
	/* 0x10.8 - 0x10.15 */
	 u_int8_t pci_bus_tx_utilization;
	/* Description -  */
	/* 0x10.16 - 0x10.23 */
	 u_int8_t pci_function_num;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t pci_errors_cap_id;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t pci_errors_uncor_stat;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t pci_errors_uncor_mask;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t pci_errors_corr_stat;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t pci_errors_corr_mask;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t pci_errors_cap_and_ctrl;
};

/* Description -   */
/* Size in bytes - 512 */
struct connectib_ocbb_fields {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_fw_banner fw_banner_str;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t hca_cap_num_ports;
	/* Description -  */
	/* 0xc.16 - 0xc.23 */
	 u_int8_t sriov_en;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t max_num_vmq_per_port;
	/* Description -  */
	/* 0x10.16 - 0x10.31 */
	 u_int16_t max_num_vmq_per_pf;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.15 */
	 u_int16_t lowest_port_recv;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.24 - 0x28.23 */
	 u_int8_t lldp_rx_get_chassis_id_tlv[12];
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.24 - 0x30.23 */
	 u_int8_t lldp_rx_get_port_id_tlv[8];
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.24 - 0x38.23 */
	 u_int8_t core_utilization[4];
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.24 - 0x44.23 */
	 u_int8_t device_bios_version[12];
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description -  */
	/* 0x44.24 - 0x50.23 */
	 u_int8_t device_hw_version[12];
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description -  */
	/* 0x50.0 - 0x50.7 */
	 u_int8_t port_type;
	/* Description -  */
	/* 0x50.8 - 0x50.15 */
	 u_int8_t flow_control_indicator;
	/* Description -  */
	/* 0x50.16 - 0x50.23 */
	 u_int8_t flex_ten_mode_en;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description -  */
	/* 0x54.0 - 0x58.31 */
	 u_int32_t port_speed;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description -  */
	/* 0x58.0 - 0x58.7 */
	 u_int8_t port_phy_link_status;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description -  */
	/* 0x5c.0 - 0x60.31 */
	 u_int32_t max_speed_supported;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description -  */
	/* 0x60.0 - 0x60.7 */
	 u_int8_t function_type;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description -  */
	/* 0x64.0 - 0x64.15 */
	 u_int16_t mtu_size;
	/* Description -  */
	/* 0x64.16 - 0x64.31 */
	 u_int16_t feature_flags;
/*---------------- DWORD[26] (Offset 0x68) ----------------*/
	/* Description -  */
	/* 0x68.0 - 0x68.15 */
	 u_int16_t max_offload_size;
	/* Description -  */
	/* 0x68.16 - 0x68.31 */
	 u_int16_t lso_min_seg_count;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description -  */
	/* 0x6c.0 - 0x6c.7 */
	 u_int8_t promiscuous_mode;
	/* Description -  */
	/* 0x6c.16 - 0x6c.31 */
	 u_int16_t tx_descr_size;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description -  */
	/* 0x70.0 - 0x70.15 */
	 u_int16_t rx_descr_size;
	/* Description -  */
	/* 0x70.24 - 0x70.31 */
	 u_int8_t iov_offload;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description -  */
	/* 0x74.0 - 0x74.15 */
	 u_int16_t num_of_netq;
/*---------------- DWORD[30] (Offset 0x78) ----------------*/
	/* Description -  */
	/* 0x78.0 - 0x7c.31 */
	 u_int32_t pcp_prio_map_table;
/*---------------- DWORD[31] (Offset 0x7c) ----------------*/
	/* Description -  */
	/* 0x7c.0 - 0x7c.7 */
	 u_int8_t max_num_pci_vfs_per_pfs;
	/* Description -  */
	/* 0x7c.8 - 0x7c.15 */
	 u_int8_t os_driver_state;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 0x80.0 - 0xc4.31 */
	 struct connectib_ocbb_fields_from_vpd vpd_data;
/*---------------- DWORD[49] (Offset 0xc4) ----------------*/
	/* Description -  */
	/* 0xc4.0 - 0xc4.7 */
	 u_int8_t device_power_reset_state;
	/* Description -  */
	/* 0xc4.16 - 0xc4.31 */
	 u_int16_t max_num_of_vfs;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 0x100.0 - 0x104.31 */
	 u_int32_t rx_discards;
/*---------------- DWORD[65] (Offset 0x104) ----------------*/
	/* Description -  */
	/* 0x104.0 - 0x108.31 */
	 u_int32_t rx_errors;
/*---------------- DWORD[66] (Offset 0x108) ----------------*/
	/* Description -  */
	/* 0x108.0 - 0x10c.31 */
	 u_int32_t tx_errors;
/*---------------- DWORD[67] (Offset 0x10c) ----------------*/
	/* Description -  */
	/* 0x10c.0 - 0x110.31 */
	 u_int32_t tx_discards;
/*---------------- DWORD[68] (Offset 0x110) ----------------*/
	/* Description -  */
	/* 0x110.0 - 0x118.31 */
	 u_int64_t rx_frames_received;
/*---------------- DWORD[70] (Offset 0x118) ----------------*/
	/* Description -  */
	/* 0x118.0 - 0x120.31 */
	 u_int64_t rx_bytes_received;
/*---------------- DWORD[72] (Offset 0x120) ----------------*/
	/* Description -  */
	/* 0x120.0 - 0x128.31 */
	 u_int64_t tx_frames_sent;
/*---------------- DWORD[74] (Offset 0x128) ----------------*/
	/* Description -  */
	/* 0x128.0 - 0x130.31 */
	 u_int64_t tx_bytes_sent;
/*---------------- DWORD[76] (Offset 0x130) ----------------*/
	/* Description -  */
	/* 0x130.0 - 0x138.31 */
	 u_int64_t pfc_frames_sent;
/*---------------- DWORD[78] (Offset 0x138) ----------------*/
	/* Description -  */
	/* 0x138.0 - 0x140.31 */
	 u_int64_t pfc_frames_received;
/*---------------- DWORD[80] (Offset 0x140) ----------------*/
	/* Description -  */
	/* 0x140.0 - 0x148.31 */
	 u_int64_t prog_max_addr_1;
/*---------------- DWORD[82] (Offset 0x148) ----------------*/
	/* Description -  */
	/* 0x148.0 - 0x150.31 */
	 u_int64_t prog_max_addr_2;
/*---------------- DWORD[84] (Offset 0x150) ----------------*/
	/* Description -  */
	/* 0x150.0 - 0x150.15 */
	 u_int16_t max_mtu;
	/* Description -  */
	/* 0x150.16 - 0x150.31 */
	 u_int16_t max_num_of_pci_func_per_port;
};

/* Description -   */
/* Size in bytes - 56 */
struct connectib_module_db_pre_define_st {
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_fw_driver_version {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 u_int32_t data[16];
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_iterator_result {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.16 - 0x0.17 */
	 u_int8_t port_0_1;
	/* Description -  */
	/* 0x0.18 - 0x0.21 */
	 u_int8_t vl;
	/* Description -  */
	/* 0x0.22 - 0x0.25 */
	 u_int8_t sl;
	/* Description -  */
	/* 0x0.26 - 0x0.29 */
	 u_int8_t pp;
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t req_res_;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t is_fw_sq;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t sqn;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_general_fault_injector_pair {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - in config: must be bigger then 1 */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t freq;
	/* Description - the error will be duration of times in sequence */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t duration;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_dmfs_gvmi_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_dmfs_ft_type_info rx_nic_info;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_dmfs_ft_type_info sx_nic_info;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 struct connectib_dmfs_ft_type_info esw_fdb_info;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 struct connectib_dmfs_ft_type_info rx_sniffer_info;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 struct connectib_dmfs_ft_type_info sx_sniffer_info;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 struct connectib_dmfs_ft_type_info rx_rdma_info;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - ref_count of vports with sx sniffer enable */
	/* 0x18.0 - 0x18.15 */
	 u_int16_t sx_sniffer_pf_ref_count;
	/* Description - counter of pf active vfs */
	/* 0x18.16 - 0x18.27 */
	 u_int16_t active_vfs_counter;
	/* Description - gvmi has started init flow for steering purposes */
	/* 0x18.28 - 0x18.28 */
	 u_int8_t is_gvmi_init_hca_set;
	/* Description - enabled by LAG matser gvmi, via CREATE_VPORT_LAG command */
	/* 0x18.29 - 0x18.29 */
	 u_int8_t vport_lag_enable;
	/* Description - vport works on VST mode */
	/* 0x18.30 - 0x18.30 */
	 u_int8_t cvlan_stripping_enable;
	/* Description -  */
	/* 0x18.31 - 0x18.31 */
	 u_int8_t gvmi_sx_sniffer_enable;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - ETH: number of mac only addresses connected to that pf
IB : number of IBL3 addresses connected to that pf */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t mpfs_cache_pf_mac_guid_counter;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - num of mac+vlan addresses on that pf */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t mpfs_cache_pf_mac_vlan_counter;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t ft_link_list_head;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - number of Flow Counter that were attached to the gvmi NIC FT */
	/* 0x28.0 - 0x28.15 */
	 u_int16_t nic_flow_counters_cntr;
	/* Description -  */
	/* 0x28.16 - 0x28.23 */
	 u_int8_t load_balance_mac_ref_count;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - ref_count of tables with encap_en set */
	/* 0x2c.0 - 0x2c.7 */
	 u_int8_t encap_en_ref_count;
	/* Description - number of enhanced ipoib QPs opened for that gvmi */
	/* 0x2c.8 - 0x2c.31 */
	 u_int32_t ipoib_enhanced_qps_counter;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_dmfs_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - is mpfs cache enable (fast mode) */
	/* 0x0.1 - 0x0.2 */
	 u_int8_t mpfs_cache_enable[2];
	/* Description - sx steering will do always loopback - patch for Utopx - DO NOT MOVE!!! */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t steering_loopback_mode;
	/* Description - mpfs cache chicken bit (if set, cache isn't active) */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t mpfs_cache_chicken;
	/* Description - number of bmc loopback entries of that port */
	/* 0x0.24 - 0x0.7 */
	 u_int8_t bmc_member_count[2];
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - number of port gvmis that has sx_sniffer  */
	/* 0x4.16 - 0x8.15 */
	 u_int16_t sx_sniffer_ref_counter[2];
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - ETH: number of L2 mac only addresses connected to that port
IB : number of IBL3 addresses connected to that port */
	/* 0x8.0 - 0x10.31 */
	 u_int32_t mpfs_cache_mac_guid_addrs_counter[2];
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - number of L2 mac+vlan addresses connected to that port */
	/* 0x10.0 - 0x18.31 */
	 u_int32_t mpfs_cache_mac_vlan_addrs_counter[2];
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_icmd_get_ste_resources_list_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t resources_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x100.31 */
	 struct connectib_resource_type_entry resource_type[63];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_ste_resources_list_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_get_ste_open_resources_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - there are more open resources, please query again with the next start index */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t more;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - number of valid entries in open resources table */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t output_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x208.31 */
	 struct connectib_index_and_length opened_resource[32];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_ste_open_resources_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t icm_resource_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t start_index;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_get_fte_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t action;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t group_id;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t flow_tag;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t destination_list_size;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.23 */
	 u_int32_t flow_counter_list_size;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x80.31 */
	 struct connectib_flow_table_entry_match_set_lyr_2_4 outer_headers;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 0x80.0 - 0xc0.31 */
	 struct connectib_flow_table_entry_match_set_misc misc_parameters;
/*---------------- DWORD[48] (Offset 0xc0) ----------------*/
	/* Description -  */
	/* 0xc0.0 - 0x100.31 */
	 struct connectib_flow_table_entry_match_set_lyr_2_4 inner_headers;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 0x100.0 - 0x300.31 */
	 union connectib_flow_list destination[64];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_fte_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t table_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t flow_index;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t requested_fte_partition;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_fte_list_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t valid;
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t last;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t first;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t flow_index;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_fte_list_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t table_id;
	/* Description - 0: Request the first FTE and ignore flow_index
1: Request the next FTE following the one pointed by flow_index */
	/* 0x0.29 - 0x0.31 */
	 u_int8_t info;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t flow_index;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_icmd_get_fg_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t start_flow_index;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t end_flow_index;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t match_criteria_enable;
	/* Description -  */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t valid;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x80.31 */
	 struct connectib_flow_table_entry_match_set_lyr_2_4 outer_headers;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 0x80.0 - 0xc0.31 */
	 struct connectib_flow_table_entry_match_set_misc misc_parameters;
/*---------------- DWORD[48] (Offset 0xc0) ----------------*/
	/* Description -  */
	/* 0xc0.0 - 0x100.31 */
	 struct connectib_flow_table_entry_match_set_lyr_2_4 inner_headers;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_fg_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t table_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t group_id;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_fg_list_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t valid;
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t last;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t first;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t group_id;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_fg_list_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t table_id;
	/* Description - 0: Request the first FG and ignore group_ID
1: Request the next FG following the one pointed by Group_ID */
	/* 0x0.29 - 0x0.31 */
	 u_int8_t info;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t group_id;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_ft_info_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t log_size;
	/* Description -  */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t level;
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t table_type;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t table_miss_id;
	/* Description -  */
	/* 0x4.24 - 0x4.27 */
	 u_int8_t table_miss_mode;
	/* Description -  */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t encap_en;
	/* Description -  */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t decap_en;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t lag_master_next_table_id;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_ft_info_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t table_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_ft_list_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t table_id;
	/* Description -  */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t valid;
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t last;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t first;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_ft_list_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t table_id;
	/* Description - 0: Request the first FT and ignore Table_ID
1: Request  the next FT following the one pointed by Table_ID */
	/* 0x0.29 - 0x0.31 */
	 u_int8_t info;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_led_control_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 u_int32_t port_led_pair_bank[16];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_steering_table_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - base index of table */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t base_index;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t default_ste_ix;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t entry_count;
	/* Description -  */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t descendant_count;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - table lookup type */
	/* 0xc.0 - 0xc.7 */
	 u_int8_t ste_lu_type;
	/* Description -  */
	/* 0xc.8 - 0xc.15 */
	 u_int8_t log2_table_size;
	/* Description -  */
	/* 0xc.16 - 0xc.19 */
	 u_int8_t log2_entry_size;
	/* Description - if 1 - hash_table was sent to garbage collector */
	/* 0xc.23 - 0xc.23 */
	 u_int8_t sent_to_gc;
	/* Description -  */
	/* 0xc.24 - 0xc.24 */
	 u_int8_t pipe;
	/* Description - 0 - NO_RESIZE
1 - RESIZE_CLEANUP
2 - AWAITING_RESIZE
3 - IN_PROGRESS
4 - RESIZE_POINTLESS */
	/* 0xc.25 - 0xc.27 */
	 u_int8_t resize_state;
	/* Description - while searching ste in table:
0 - do match only on data + mask
1 - do match only on data
2 - do full match on whole ste */
	/* 0xc.28 - 0xc.29 */
	 u_int8_t match_mode;
	/* Description -  */
	/* 0xc.31 - 0xc.31 */
	 u_int8_t sx_rx_;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.7 */
	 u_int8_t hash_fieldwise_mask;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - id of the flow table corresponding to the hash table */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t table_id;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - id of the flow group corresponding to the hash table */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t group_id;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Number of buckets containing valid entries */
	/* 0x28.0 - 0x28.15 */
	 u_int16_t bucket_count;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - valid only when resize_in_progress == 1. index of the destination hash meta in resize process */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t new_hash_meta_ix;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - valid only when resize_in_progress == 1. index of next bucket in hash table that will be copied to resize_table_icm_addr */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t next_bucket_to_copy;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x34.15 */
	 u_int16_t needed_pages;
	/* Description -  */
	/* 0x34.16 - 0x34.31 */
	 u_int16_t allocated_pages;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_dcr_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t next_dcri;
	/* Description -  */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t valid;
	/* Description -  */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t connected;
	/* Description -  */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t trapped;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_icmd_ver_data_cmd_specific {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - command allowed only when no driver is loaded */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_icmd_ver_data_max_atomic max_atomic;
	/* Description - command allowed only when no driver is loaded */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_icmd_ver_data_one_qp_per_recovery one_qp_per_recovery;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_pcie_ver_frequency {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - .yu.bootrecord.core_f */
	/* 0x0.0 - 0x0.6 */
	 u_int8_t core_f;
	/* Description - .scratchpad.kernel.shared_kernel.core_clocks_per_usec */
	/* 0x0.7 - 0x0.7 */
	 u_int8_t core_clocks_per_usec;
	/* Description - .yu.bootrecord.core_r */
	/* 0x0.8 - 0x0.12 */
	 u_int8_t core_r;
	/* Description - .px.pxdp.pxp.cx3_count_in_core_clocks */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t cx3_count_in_core_clocks;
	/* Description - .scratchpad.kernel.shared_kernel.usecs_in_high_tick */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t usecs_in_high_tick;
	/* Description - .scratchpad.ini.hw_main_config.gpios.functions.vdd_mod.mapping */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t vdd_mod_mapping;
	/* Description - .yu.bootrecord.flash_div */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t flash_div;
	/* Description - .yu.bootrecord.core_od */
	/* 0x0.20 - 0x0.21 */
	 u_int8_t core_od;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_pcie_ver_cables {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.identifier */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t identifier;
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.qsfp.extended_identifier */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t extended_identifier;
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.qsfp.device_tech */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t device_tech;
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.qsfp.attenuation_5g */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t attenuation_5g;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - .scratchpad.peripherals.module_mng.module_database[NUM].vendor_oui */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t vendor_oui;
	/* Description - .scratchpad.peripherals.module_mng.module_database[NUM].m_fsm_state */
	/* 0x4.24 - 0x4.29 */
	 u_int8_t m_fsm_state;
	/* Description - .scratchpad.peripherals.module_mng.module_database[NUM].mlnx_cable */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t mlnx_cable;
	/* Description - .scratchpad.peripherals.module_mng.module_database[NUM].eeprom_present */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t eeprom_present;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.sfp.link_length_supported */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t link_length_supported;
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.sfp.eth_com_codes */
	/* 0x8.8 - 0x8.15 */
	 u_int8_t eth_com_codes;
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.sfp.tech */
	/* 0x8.16 - 0x8.24 */
	 u_int16_t tech;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.sfp.ib_10ge_com_codes */
	/* 0xc.0 - 0xc.6 */
	 u_int8_t ib_10ge_com_codes;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_pcie_ver_device {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - .yu.boot.devid.devid */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t devid;
	/* Description - .yu.boot.devid.revid */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t revid;
	/* Description - .yu.boot.reset.strap_eprom_present */
	/* 0x0.20 - 0x0.20 */
	 u_int8_t strap_eprom_present;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_code_coverage_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Window start address [Byte] is code address */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t window;
	/* Description - Read only: size in bytes of collection window. */
	/* 0x0.24 - 0x0.28 */
	 u_int8_t log_window_size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Bitmask of irisc to collect 1-Iron, 0-7 plastic */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t irisc_bitmask;
	/* Description - Shomron only. back pressure on congestion */
	/* 0x4.24 - 0x4.24 */
	 u_int8_t bp;
	/* Description - Shomron only. If set collect all IPs, if cleared only branches */
	/* 0x4.25 - 0x4.25 */
	 u_int8_t all_ips;
	/* Description - Shomron only. Use 0 for legacy mode, non 0 for future modes */
	/* 0x4.26 - 0x4.27 */
	 u_int8_t trace_mode;
	/* Description - If set tracer will be enabled. For ini, use boot field for boot collection */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t enable;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_vport_real_state {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.28 - 0x80.27 */
	 u_int8_t real_state[256];
};

/* Description -   */
/* Size in bytes - 512 */
struct connectib_fw_esw {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.16 - 0x200.15 */
	 struct connectib_fw_vport_ctx vport_ctx[256];
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_gvmix_sub_structs {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_cmdif_ctx cmdif_ctx;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_dummy_addresses_one_cache_line dummy_addresses;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_hca_params hca_params;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_icm_page_manager icm_page_manager;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_vf_pages_list vf_pages_list;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_sw_eqe {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Event Sub Type.
Defined for events which have sub types, zero elsewhere. */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t event_sub_type;
	/* Description - Event Type */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t event_type;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Delivers auxiliary data to handle the event.
 See Table 142, "
Event_data Field - Completion Event Layout
," on 
page 335
 See Table 144, "
Event_data Field - DCT Events Layout
," on page 335
 See Table 146, "
Event_data Field - 
QP/
SQ/RQ Events Layout
," on 
page 336
 See Table 149, "
Event_data Field - WQE Associated Page Fault Event 
Layout
," on page 337
 See Table 151, "
Event_data Field - RDMA Page Fault Event Layout
," 
on page 338
 See Table 153, "
Event_data Field - Completion Queue Error Event Lay
out
," on page 339
 See Table 155, "
Event_data Field - DROPPED_PACKET_LOGGED 
Event Layout
," on page 340
 See Table 157, "
Event_data Field - Port State Change Event Layout
," on 
page 341
 See Table 160, "
Event_data Field - GPIO Event Layout
," on page 342
 See Table 162, "
Event_data Field - Port Module Event Layout
," on 
page 342
 See Table 164, "
Event_data Field - DCBX Change Event Layout
," on 
page 343
 See Table 168, "
Temperature Warning Event Layout
," on page 345
 See Table 170, "
Event_data Field - Doorbell / Blueflame Congestion 
Event Layout
," on page 346
 See Table 173, "
Event_data Field - Stall VL Event Field Descriptions
," 
on page 347
 See Table 174, "
Event_data Field - Command interface Completion 
Event Layout
," on page 347
 See Table 176, "
Pages Request Event Layout
," on page 347
 See Table 178, "
Nic Vport Change Event Layout
," on page 348
 See Table 180, "
Event_data Field - FPGA Error Event Layout
," on 
page 348
 See Table 182, "
Event_data Field - FPGA QP Error Event Layout
," on 
page 349 */
	/* 0x20.0 - 0x3c.31 */
	 union connectib_comp_event_dct_events_qp_events_wqe_associated_page_fault_event_rdma_page_fault_event_cq_error_dropped_packet_logged_port_state_change_event_gpio_event_port_module_event_dcbx_change_event_temp_warning_event_db_bf_congestion_event_stall_vl_event_cmd_inter_comp_event_pages_req_event_nic_vport_change_event_fpga_error_event_fpga_qp_error_event_general_notification_delay_drop_event_auto event_data;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Owner of the entry */
	/* 0x3c.0 - 0x3c.0 */
	 u_int8_t owner;
	/* Description - Byte-wise XOR of EQE - signature protection (see 
 See Section 16.2.4, 
"
Completion and Event Queue Elements (CQEs and EQEs)
," on 
page 474
). EQE is valid if byte-wise XOR of entire EQE (including 
sig
nature
 field) and the EQE index is 0xff. */
	/* 0x3c.8 - 0x3c.15 */
	 u_int8_t signature;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_lock_tag {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t resource_id;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t resource_type;
};

/* Description -   */
/* Size in bytes - 276 */
struct connectib_icmd_generic_reg_access_reg_tlv {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_reg_access_tlv hdr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x114.31 */
	 union connectib_icmd_generic_reg_access_reg_tlv_data reg_tlv_data;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_reg_access_oper_tlv {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Code indicating status of operation */
	/* 0x0.8 - 0x0.14 */
	 u_int8_t Status;
	/* Description - Direct route - must be set on direct route packets. DR TLV must follow. */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t dr;
	/* Description -  */
	/* 0x0.16 - 0x0.26 */
	 u_int16_t len;
	/* Description -  */
	/* 0x0.27 - 0x0.31 */
	 u_int8_t type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Class of operation */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t class_;
	/* Description - Method to perform Based on Management Class */
	/* 0x4.8 - 0x4.14 */
	 u_int8_t Method;
	/* Description - Response
0 Request */
	/* 0x4.15 - 0x4.15 */
	 u_int8_t r;
	/* Description - Defines objects being operated by a management class (Page 658) */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t register_id;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x10.31 */
	 struct connectib_IB_TID TID;
};

/* Description -   */
/* Size in bytes - 4 */
union connectib_icmd_kdnet_ctrl_io {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_icmd_kdnet_ctrl_in ctrl_in;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_icmd_kdnet_ctrl_out ctrl_out;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_query_cap_general {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - When set, device supports FW components updated through ICMD interface. 
See 
"Firmware Components Update" on page 428
 */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t fw_ctrl_update_icmd;
	/* Description - When set, the 
"
ICMD_KDNET_CTRL - Control KDNET PF
"
 com
mand is supported. */
	/* 0x0.27 - 0x0.27 */
	 u_int8_t kdnet_ctrl;
	/* Description - When set, multi-host synchronization through the device is supported. 
 See 
Section 25.4.3, "
ICMD_MH_SYNC - Multi-Host Synchronization
," on 
page 772
. */
	/* 0x0.28 - 0x0.28 */
	 u_int8_t mh_sync;
	/* Description - If set, ICMD_ACCESS_REGISTER supports every register. (in the past it sup
ported some of them). */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t allow_icmd_access_reg_on_all_registers;
	/* Description - When set, ICMD_QUERY_FW_INFO returns the 
psid
 field. */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t fw_info_psid;
	/* Description - When set, ICMD_ACCESS_REGISTER supports the following registers:
NVDA
NVDI
NVIA
NVQC */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t nv_access;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - If set, wake on phy activity is supported. */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t wol_p;
	/* Description - If set, wake on unicast packet is supported. */
	/* 0x4.1 - 0x4.1 */
	 u_int8_t wol_u;
	/* Description - If set, wake on multicast packet is supported. */
	/* 0x4.2 - 0x4.2 */
	 u_int8_t wol_m;
	/* Description - If set, wake on broadcast packet is supported. */
	/* 0x4.3 - 0x4.3 */
	 u_int8_t wol_b;
	/* Description - If set, wake on ARP is supported. */
	/* 0x4.4 - 0x4.4 */
	 u_int8_t wol_a;
	/* Description - If set, wake on magic packet is supported. */
	/* 0x4.5 - 0x4.5 */
	 u_int8_t wol_g;
	/* Description - If set, wake on secured magic packet is supported. */
	/* 0x4.6 - 0x4.6 */
	 u_int8_t wol_s;
	/* Description - If set, reset on magic packet is supported. */
	/* 0x4.8 - 0x4.8 */
	 u_int8_t rol_g;
	/* Description - If set, reset on secured magic packet is supp
o
rted. */
	/* 0x4.9 - 0x4.9 */
	 u_int8_t rol_s;
	/* Description - If set, FPGA device is supported by the device. See TBD */
	/* 0x4.10 - 0x4.10 */
	 u_int8_t fpga;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_query_cap_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Group of capabilities.
0x0 - General capability
other values are reserved. */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t capability_group;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_cable_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t address;
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t page_number;
	/* Description - slave adddr */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t device_address;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t size;
	/* Description - If set to 1 will force the password to be cleared from the module password field at the end of the module access. */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t passwd_clr;
	/* Description - If set to 1 the Password field is valid and is written to the module password field (address 123-126) before accessing the page. */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t passwd_v;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The password that is written to the module password field. */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t password;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x40.31 */
	 u_int32_t dword[12];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_grepper_dwords {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 u_int32_t dwords[16];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_itrace {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - bit numbers:
0=DEBUG_INIT
1=INIT
2=ICM
3=ICM_FREE_LIST
4=LOG_MOD_HOST_MNG
5=CMD_IF
6=PHY_IB
7=PHY_RX_ADAP
8=PHY_EYE_OPN
9=PHY_GENERAL
10=PHY_MANAGER
11=PWR
12=FLR
13=ICM_ACCESS
14=MAD
15=RXT_CHECKS
16=I2C
17=TRANSPORT
18=FW_LL
19=RX_ERRORS
20=CMDIF_DRIVER
21=PROFILING
22=MANAGEMENT
23=FLASH
24=STEERING
25=IFARM
26=ICMD
27=PCI
28=DC_CLEANUP
29=PHY_ETH
30=VIRT */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t unit_mask;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_itrace_ctrl ctrl;
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_cc_table_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - this is the shift value used when calculating the injection rate delay */
	/* 0x0.0 - 0x0.13 */
	 u_int16_t cct_multiplier;
	/* Description - this is the multiplier used when calculating the injection rate delay */
	/* 0x0.14 - 0x0.15 */
	 u_int8_t cct_shift;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_ca_congestion_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - when the CCTI is equal to this value, an event is logged in the CA's cycyclic event log */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t trigger_threshold;
	/* Description - the number to be added to the table index (CCTI) on the receipt of a BECN */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t ccti_increase;
	/* Description - when the timer expires it will be reset to its specified value, and 1 will be decremented from the CCTI */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t ccti_timer;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - the minimum value permitted for the CCTI. This is used to impose a minimum injection rate delay on the SL */
	/* 0x4.24 - 0x4.31 */
	 u_int8_t ccti_min;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_congestion_log_event_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - local QP that reached CN threshold. Set to zero if port threshold reached */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t service_type;
	/* Description - SL associated with local QP */
	/* 0x0.4 - 0x0.7 */
	 u_int8_t sl;
	/* Description - remote QP that is connect to local QP. set to zero for datagram QPs */
	/* 0x0.8 - 0x0.31 */
	 u_int32_t local_qpn;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - local QP that reached CN threshold. Set to zero if port threshold reached */
	/* 0x4.8 - 0x4.31 */
	 u_int32_t remote_qpn;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - LID of remote port that is connet to local QP. Set to zero for datagram service */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t remote_lid;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - timestamp when threshold reached */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t timestamp;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_special_qps {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t qp0;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t qp1;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t raw;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t ipv6;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t reserved;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t ptp1588;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t sync_umr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t cnak;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_cmdif_hdr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t reserved0;
	/* Description - cmd type = 0x7 */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - input command length in bytes */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t input_length;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t ibox_pointer;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - just the standart, The first 128 bits of the command input */
	/* 0x10.0 - 0x20.31 */
	 struct connectib_input_inline_standart input_inline;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - The first 128 bits of the command output */
	/* 0x20.0 - 0x30.31 */
	 struct connectib_output_inline_standart output_inline;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x38.31 */
	 u_int64_t obox_pointer;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - output command length in bytes */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t output_length;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - SW should set to 1 when posting the command. HW will change to zero to move ownership bit to SW. */
	/* 0x3c.0 - 0x3c.0 */
	 u_int8_t ownership;
	/* Description -     NO_ERRORS          = 0x0,
    SIGNATURE_ERROR    = 0x1,
    TOKEN_ERROR        = 0x2,
    BAD_BLOCK_NUMBER   = 0x3,
    BAD_OUTPUT_POINTER = 0x4,   // pointer not align to mailbox size
    BAD_INPUT_POINTER  = 0x5,   // pointer not align to mailbox size
    INTERNAL_ERROR     = 0x6,
    INPUT_LEN_ERROR    = 0x7,   // input  length less than 0x8.
    OUTPUT_LEN_ERROR   = 0x8,   // output length less than 0x8.
    RESERVE_NOT_ZERO   = 0x9,
    BAD_CMD_TYPE       = 0x10,
 */
	/* 0x3c.1 - 0x3c.7 */
	 u_int8_t status;
	/* Description -  */
	/* 0x3c.8 - 0x3c.15 */
	 u_int8_t reserved1;
	/* Description - SW should set to 1 when posting the command. HW will change to zero to move ownership bit to SW. */
	/* 0x3c.16 - 0x3c.23 */
	 u_int8_t signature;
	/* Description - SW should set to 1 when posting the command. HW will change to zero to move ownership bit to SW. */
	/* 0x3c.24 - 0x3c.31 */
	 u_int8_t token;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_icmd_header_capture_checks {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 u_int32_t word[16];
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_icmd_header_capture_headers {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 u_int32_t word[32];
};

/* Description -   */
/* Size in bytes - 256 */
union connectib_g_rse_hw_decoders {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_rxt_checks_packet_descriptor_decoder rxt_checks_packet_descriptor_decoder;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_rxt_steering_context_decoder rxt_steering_context_decoder;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_rxt_checks_steering_results_decoder rxt_checks_steering_results_decoder;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_rxt_context_fetch_qp_desc_decoder rxt_context_fetch_qp_desc_decoder;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_rxs_rxt_desc_decoder rxs_rxt_desc_decoder;
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_g_rse_decoders_as_dwords raw_dwords;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_FW_VERSION {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t MAJOR;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t SUBMINOR;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t MINOR;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.8 - 0x8.15 */
	 u_int8_t Hour;
	/* Description -  */
	/* 0x8.16 - 0x8.23 */
	 u_int8_t Minutes;
	/* Description -  */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t Seconds;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.7 */
	 u_int8_t Day;
	/* Description -  */
	/* 0xc.8 - 0xc.15 */
	 u_int8_t Month;
	/* Description -  */
	/* 0xc.16 - 0xc.31 */
	 u_int16_t Year;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_golan_hw_fw_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_hw_hca_contexts hw_ctx;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_fw_resource_context fw_ctx;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_ctx_as_dwords as_dwords;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_wqe_extended_atomic_fetch_add_128byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_add_data add_data[32];
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 0x80.0 - 0x100.31 */
	 struct connectib_field_boundary field_boundary[32];
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_wqe_extended_atomic_fetch_add_64byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_add_data add_data[16];
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x80.31 */
	 struct connectib_field_boundary field_boundary[16];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_wqe_extended_atomic_fetch_add_32byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_add_data add_data[8];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x40.31 */
	 struct connectib_field_boundary field_boundary[8];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_wqe_extended_atomic_fetch_add_16byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_add_data add_data[4];
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x20.31 */
	 struct connectib_field_boundary field_boundary[4];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_extended_atomic_fetch_add_8byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_add_data add_data[2];
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x10.31 */
	 struct connectib_field_boundary field_boundary[2];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_extended_atomic_fetch_add_4byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t add_data;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t field_boundary;
};

/* Description -   */
/* Size in bytes - 512 */
struct connectib_wqe_extended_atomic_cmp_swap_128byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_swap_data swap_data[32];
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 0x80.0 - 0x100.31 */
	 struct connectib_compare_data compare_data[32];
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 0x100.0 - 0x180.31 */
	 struct connectib_swap_mask_data swap_mask_data[32];
/*---------------- DWORD[96] (Offset 0x180) ----------------*/
	/* Description -  */
	/* 0x180.0 - 0x200.31 */
	 struct connectib_compare_mask_data compare_mask_data[32];
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_wqe_extended_atomic_cmp_swap_64byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_swap_data swap_data[16];
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x80.31 */
	 struct connectib_compare_data compare_data[16];
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 0x80.0 - 0xc0.31 */
	 struct connectib_swap_mask_data swap_mask_data[16];
/*---------------- DWORD[48] (Offset 0xc0) ----------------*/
	/* Description -  */
	/* 0xc0.0 - 0x100.31 */
	 struct connectib_compare_mask_data compare_mask_data[16];
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_wqe_extended_atomic_cmp_swap_32byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_swap_data swap_data[8];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x40.31 */
	 struct connectib_compare_data compare_data[8];
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x60.31 */
	 struct connectib_swap_mask_data swap_mask_data[8];
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description -  */
	/* 0x60.0 - 0x80.31 */
	 struct connectib_compare_mask_data compare_mask_data[8];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_wqe_extended_atomic_cmp_swap_16byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_swap_data swap_data[4];
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x20.31 */
	 struct connectib_compare_data compare_data[4];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x30.31 */
	 struct connectib_swap_mask_data swap_mask_data[4];
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x40.31 */
	 struct connectib_compare_mask_data compare_mask_data[4];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_wqe_extended_atomic_cmp_swap_8byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_swap_data swap_data[2];
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x10.31 */
	 struct connectib_compare_data compare_data[2];
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x18.31 */
	 struct connectib_swap_mask_data swap_mask_data[2];
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x20.31 */
	 struct connectib_compare_mask_data compare_mask_data[2];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_extended_atomic_cmp_swap_4byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t swap_data;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t compare_data;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t swap_mask_data;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t compare_mask_data;
};

/* Description -   */
/* Size in bytes - 288 */
struct connectib_file_public_keys {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - configuration bits to enable authentication for each component */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_component_authentication_configuration component_authentication_configuration;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - public key exponent, FW should use an exponent of 65537 */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t keypair_exp;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - UUID of this key created by server when it generates a keypair */
	/* 0x10.0 - 0x20.31 */
	 u_int32_t keypair_uuid[4];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - 2048 bit public-key */
	/* 0x20.0 - 0x120.31 */
	 u_int32_t key[64];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_nv_config_header {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - if 0x4d544346, this nv_data partition is valid */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t signature;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t version_minor;
	/* Description -  */
	/* 0x4.8 - 0x4.15 */
	 u_int8_t version_major;
	/* Description - non volatile counter incremented when fw didn't find valid configuration header and need to erase the nv partition */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t num_of_init_cfg_hdr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - non volatile counter incremented on each sector erase */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t num_of_swaps;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 0=hw_calibration, 1=fast_list, 2=slow_list */
	/* 0xc.0 - 0x24.31 */
	 struct connectib_nv_data_pointer list_pointers[6];
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - crc16 of header area */
	/* 0x3c.0 - 0x3c.15 */
	 u_int16_t crc16;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_fw_image {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t itoc_ptr;
	/* Description -  */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t is_palladium;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x20.31 */
	 struct connectib_jump_addresses jump_addresses;
};

/* Description -   */
/* Size in bytes - 192 */
struct connectib_pcie_cfg_golan {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t pcie_max_speed_supported;
	/* Description - [0]-x1\n[1]-x2\n[2]-x4\n[3]-x8\n[4]-x16 */
	/* 0x0.4 - 0x0.8 */
	 u_int8_t pcie_max_width_supported;
	/* Description - Drop LPS after 5 msec */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t drop_loopback_slave_en;
	/* Description - disable automatic reversal, set lane_reversal_enable = 0x1, this flag is for Loopback PTC Test. It solve the problem of rx_active_lanes when moving to Loopback from Configuration */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t disable_automatic_reversal;
	/* Description - Enable up or down configuring the link width */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t upconfigure_capable;
	/* Description - PCIe is reversed in comparison to the rx */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t px_tx_reversal;
	/* Description -  */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t polling_compliance_en;
	/* Description -  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t pcie_center_phase_optimization_en;
	/* Description -  */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t handle_bar_miss_error_by_cr_handler_en;
	/* Description - This bit enables DC ballance on the transmitter */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t dc_ballance_en;
	/* Description - Enable receiver detect as a condition to exit from Detect 
   Notice: Need to configure the receiver detect time */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t receiver_detect_en;
	/* Description - When using receiver detect WA this field define the delay to detect a receiver
   Notice: Using a value too high for a system will cause the PCIe not to link up */
	/* 0x0.20 - 0x0.28 */
	 u_int16_t receiver_detect_time;
	/* Description - Reference clock indication 1-from connector 0-local oscilator */
	/* 0x0.29 - 0x0.29 */
	 u_int8_t slot_clock_cfg;
	/* Description -  */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t dynamic_pll_manage_en;
	/* Description - If set, the unused PX SerDes x4 ports will be disabled in order to save power.
 */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t static_width_reduction_en;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Do mixer0 calibration with optimization. */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t do_mixer0_calibration_optimized;
	/* Description - Delta from edges while serching for valid mixer_offset0 */
	/* 0x4.1 - 0x4.6 */
	 u_int8_t do_mixer0_calibration_delta;
	/* Description - calibration is done per lane according to this mask in stage I and then on mask_not in stage II */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t first_iteration_calibration_mask;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x28.31 */
	 struct connectib_pcie_serdes_cfg serdes_cfg;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x5c.31 */
	 struct connectib_pcie_equalization_and_eye pcie_equalization_and_eye;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - Opens specific PCIe debug capabilities */
	/* 0x5c.0 - 0x60.31 */
	 struct connectib_pcie_debug_cap pcie_debug_cap;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - preset values se  nt in Eq.Phase2 / Enable */
	/* 0x60.0 - 0x70.31 */
	 struct connectib_pcie_tx_adaptation_cfg tx_adaptation_cfg;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description -  */
	/* 0x70.0 - 0xb4.31 */
	 struct connectib_pcie_rx_adaptation_cfg rx_adaptation_cfg;
/*---------------- DWORD[45] (Offset 0xb4) ----------------*/
	/* Description - tx_polarity ini :
Each bit set the polarity reversal on the equivilant tx lane */
	/* 0xb4.0 - 0xb4.15 */
	 u_int16_t pcie_tx_polarity;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_vpd_eeprom_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Size of VPD eeprom / flash */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t vpd_size;
	/* Description - Size of each one of the EEEPROM slaves of the VPD */
	/* 0x0.16 - 0x0.20 */
	 u_int8_t log2_vpd_eeprom_size;
	/* Description - Number of EEEPROM slaves of the VPD */
	/* 0x0.24 - 0x0.26 */
	 u_int8_t vpd_num_eeproms;
	/* Description - Set if VPD on eeprom, if on flash */
	/* 0x0.27 - 0x0.27 */
	 u_int8_t vpd_eeprom;
};

/* Description -   */
/* Size in bytes - 132 */
struct connectib_ini_gpios_golan {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x54.31 */
	 struct connectib_gpio_functions functions;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description -  */
	/* 0x54.0 - 0x84.31 */
	 struct connectib_gpio_configurations configurations;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_i2c_devices_db {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_i2c_device_entry device[16];
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_module_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_module_config_st module[2];
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_thermal_config_golan {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Threshold (in celsius degree) for the temp _fsm to move from WARM to COLD state,
and clear the OVT warning over gpio (if enabled).
set by default to 95c. */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t warm2cold_threshold;
	/* Description - Threshold (in celsius degree) for the temp _fsm to move from COLD to WARM state,
and set the OVT warning over gpio (if enabled).
set by default to 110c. */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t cold2warm_threshold;
	/* Description - Reaching this temperature will cause the fw algorith to move the temp_fsm to HOT state
and cause thermal_shut_down.
set by default to 120c. */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t fw_shut_down_threshold;
	/* Description - if set and thermal fsm reaches HOT state, FW will perform thermal_shut_down (i1fsm moved to FATAL state). */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t fw_shut_down_en;
	/* Description - 1- indicate that board over temp warning gpio is enabled.
can be set/clear by ini and mad. */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t gpio_enable;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - left from baz for MAD query.
 */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t trap_supported;
	/* Description - left from baz for MAD query. */
	/* 0x4.1 - 0x4.1 */
	 u_int8_t trap_enable;
	/* Description - if set, report to fatal buffer. */
	/* 0x4.2 - 0x4.2 */
	 u_int8_t fatal_enable;
	/* Description - external sensors active, bit per sensor. bit0 = internal EMC1444 sensor
 bit1 = EMC1444 Q1 sensor
 bit2 = EMC1444 Q2 sensor
 bit3 = EMC1444 Q3 sensor
 */
	/* 0x4.8 - 0x4.11 */
	 u_int8_t active_ext_sensors;
	/* Description - compare mask, bit per a2d (0 - iopx, 1 - iopl, 2 - yu)
if set, the a2d will be configured to HW protection (compare).
HW will shut down if 130deg threshold will be reached.
default is YU a2d selected.
legal value are 1,2,4 so only one a2d is selected only, or 0 for none (hw protection disabled).
 */
	/* 0x4.16 - 0x4.18 */
	 u_int8_t a2d_compare_mask;
	/* Description - measure mask, measure circuit is analog. bit per a2d (0 - iopx, 1 - iopl, 2 - yu)
if set, the fw will measure the temperature from relevant a2d and calc it for fw thermal protection.
default is none as compare and measure is considered more reliable. */
	/* 0x4.19 - 0x4.21 */
	 u_int8_t a2d_measure_mask;
	/* Description - compare and measure mask, measure circuit is digital. bit per a2d (0 - iopx, 1 - iopl, 2 - yu)
if set, the fw will measure the temperature from relevant a2d and calc it for fw thermal protection.
default is IOPX and IOPL only (the YU will be used for hw thermal protection). */
	/* 0x4.22 - 0x4.24 */
	 u_int8_t a2d_compare_and_measure_mask;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_system_mng {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - If set network ports will be reveresed */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t port_swap;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_power {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - In case fuse_dvfs_force is set, contain the forced DVFS value for voltage scaling procedure */
	/* 0x0.28 - 0x0.30 */
	 u_int8_t fuse_dvfs;
	/* Description - if set, the DVFS is read from INI instead of reading from fuse */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t fuse_dvfs_force;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_iopl_power iopl_power;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 struct connectib_iopx_power iopx_power;
};

/* Description -   */
/* Size in bytes - 1792 */
struct connectib_port_serdes {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - contains parameters that are board related.
for example: polarity, SD parameters */
	/* 0x0.0 - 0x5c0.31 */
	 struct connectib_phy_hw_main_config_ip phy_hw_main_config_ip;
/*---------------- DWORD[372] (Offset 0x5d0) ----------------*/
	/* Description -  */
	/* 0x5d0.0 - 0x610.31 */
	 struct connectib_logic_serdes_mapping_node_ini logic_serdes_mapping_node_ini;
/*---------------- DWORD[389] (Offset 0x614) ----------------*/
	/* Description -  */
	/* 0x614.0 - 0x638.31 */
	 struct connectib_pll_params pll_params;
/*---------------- DWORD[398] (Offset 0x638) ----------------*/
	/* Description -  */
	/* 0x638.0 - 0x658.31 */
	 struct connectib_port_mlpn_db mlpn_port[2];
};

/* Description -  format of non volatile configuration loaded from flash for pre plastic flows */
/* Size in bytes - 64 */
struct connectib_nv_config_boot {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x30.31 */
	 struct connectib_nv_config_boot_global global;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x38.31 */
	 struct connectib_nv_config_boot_port_settings port[2];
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_pcie_power_management {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - both for gen12 adn for gen3 */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t delay_in_recovery_lock;
	/* Description -  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t pcie_l1_en;
	/* Description - Allow_icmc_transpose when enter/exit standby mode */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t close_icmc_on_standby;
	/* Description - shomron or newer only
Allows us to enter L1 while in gen1 or gen2
disabled by default in shomron
see RM 587894 */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t l1_on_gen1_gen2_en;
};

/* Description -  PCI configuration space (by spec) */
/* Size in bytes - 512 */
struct connectib_pci_cfg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_pci_cfg_space pci_cfg_space;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 0x100.0 - 0x200.31 */
	 struct connectib_pciex_ext_cfg_space pciex_ext_cfg_space;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_pcie_transaction {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Max number of pending outbound read requests */
	/* 0x0.0 - 0x0.8 */
	 u_int16_t global_read_task_limit;
	/* Description - Function Level Reset Capability enable */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t function_level_reset_capability;
	/* Description - If and only if set, upon sending Completion with UR status, due to incoming Cfg Type 1 Request, 
will be reported (by FW) as AER advisory-non-fatal (anf) error  */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t aer_anf_by_cfg_type_1_en;
	/* Description - If and only if set, upon sending Completion with UR status, due to bad function number in incoming Cfg Request, 
will be reported (by FW) as AER advisory-non-fatal (anf) error  */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t aer_anf_by_bad_func_en;
	/* Description -  */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t advisory_non_fatal_en;
	/* Description - advanced error reporting enable */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t aer_cap_en;
	/* Description - Alternatove Rounting-ID capability enable  */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t ari_cap_en;
	/* Description - SR-IOV capability enable  */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t sriov_cap_en;
	/* Description - VPD  capability enable  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t vpd_cap_en;
	/* Description - enable crspace access via conf space register 22 and 23 */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t pci_crspace_access_en;
	/* Description - MLNX PCI VSEC   capability enable  */
	/* 0x0.18 - 0x0.18 */
	 u_int8_t pci_vsec_cap_en;
	/* Description - MLNX PCIE VSEC  - for future use */
	/* 0x0.19 - 0x0.19 */
	 u_int8_t pcie_vsec_cap_en;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - configuration read/write logger */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_logger_init_info logger_init_info;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_multi_function {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - vport0 will be associate with this host(today port_pf_gvmi) */
	/* 0x0.0 - 0x0.1 */
	 u_int8_t vport0_hix;
	/* Description - multi host will be lid based */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t lid_based;
	/* Description - num of hosts */
	/* 0x0.5 - 0x0.7 */
	 u_int8_t num_hosts;
	/* Description - num of ports */
	/* 0x0.8 - 0x0.10 */
	 u_int8_t num_of_ports;
	/* Description - num of msix vectors per pf */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t pf_msix_table_size;
	/* Description - num of msix vectors per vf */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t vf_msix_table_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - UAR Bar width - 0x0=32bit , 0x1=64bit */
	/* 0x8.6 - 0x8.6 */
	 u_int8_t pf_bar_type;
	/* Description - VF Bar width - 0x0=32bit , 0x1=64bit */
	/* 0x8.14 - 0x8.14 */
	 u_int8_t vf_minibar_type;
	/* Description - VF Bar prefetchable property */
	/* 0x8.15 - 0x8.15 */
	 u_int8_t vf_minibar_prefetchable;
	/* Description - function number that requests and enables crspace bar */
	/* 0x8.16 - 0x8.19 */
	 u_int8_t cr_bar_func;
	/* Description - CR Bar width - 0x0=32bit , 0x1=64bit */
	/* 0x8.20 - 0x8.20 */
	 u_int8_t cr_bar_type;
	/* Description - request and enable crspace bar */
	/* 0x8.21 - 0x8.21 */
	 u_int8_t cr_bar_en;
	/* Description - enable/disable the credits blockage fsm */
	/* 0x8.22 - 0x8.22 */
	 u_int8_t credits_blockage_fsm_en;
	/* Description -  */
	/* 0x8.24 - 0x8.27 */
	 u_int8_t log_max_num_of_eqs;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_secure_fw {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - extended capabilities that block write access to flash, crspace... */
	/* 0x4.0 - 0x8.31 */
	 union connectib_fw_block_behavior fw_block_behavior;
};

/* Description -  format of non volatile configuration loaded from flash */
/* Size in bytes - 768 */
struct connectib_nv_config_main {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x300.31 */
	 struct connectib_nv_config_main_fw_data fw_config;
};

/* Description -   */
/* Size in bytes - 720 */
struct connectib_phy_fw_main_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0xe8.31 */
	 struct connectib_phy_fw_main_config_golan phy_golan;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description - contains parameters that are FW flows related. 
for example: MLPN bits. speed, width capabilities .. */
	/* 0x100.0 - 0x280.31 */
	 struct connectib_phy_fw_main_config_ip phy_ip;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_host_management {
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x24.31 */
	 struct connectib_ocsd_config ocsd_config;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x40.31 */
	 struct connectib_ibm_thermal_config ibm_thermal_config;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - wake on lan capability */
	/* 0x4c.0 - 0x50.31 */
	 struct connectib_wol_cap_host_port wol_cap;
};

/* Description -   */
/* Size in bytes - 384 */
struct connectib_management {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_node_info_ini node_info;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x5c.31 */
	 struct connectib_ib_port_info_ini port_info;
/*---------------- DWORD[48] (Offset 0xc0) ----------------*/
	/* Description -  */
	/* 0xc0.0 - 0xc0.0 */
	 u_int8_t eeprom_read_disable_p1;
	/* Description -  */
	/* 0xc0.1 - 0xc0.1 */
	 u_int8_t eeprom_read_disable_p2;
	/* Description - override fw cable stamping */
	/* 0xc0.2 - 0xc0.2 */
	 u_int8_t fw_stamping_override;
	/* Description - override read supported cable speed */
	/* 0xc0.3 - 0xc0.3 */
	 u_int8_t cable_speed_override;
/*---------------- DWORD[49] (Offset 0xc4) ----------------*/
	/* Description -  */
	/* 0xc4.0 - 0xc8.31 */
	 struct connectib_extended_port_info_ini extended_port_info;
/*---------------- DWORD[50] (Offset 0xc8) ----------------*/
	/* Description - valid i2c address for cable info mad */
	/* 0xc8.24 - 0xcc.23 */
	 u_int8_t valid_i2c_address[4];
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 0x100.0 - 0x104.31 */
	 struct connectib_fw_vport0_ini fw_vport0;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_customization {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - the module rx amp range in port1 will be configured according to active_amp_range value */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t active_amp_range_p1;
	/* Description - the module rx amp range in port2 will be configured according to active_amp_range value */
	/* 0x0.4 - 0x0.7 */
	 u_int8_t active_amp_range_p2;
};

/* Description -   */
/* Size in bytes - 160 */
struct connectib_leds_blink_patterns {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_led_port_blink_pattern no_phy_no_log_link;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x10.31 */
	 struct connectib_led_port_blink_pattern phy_no_log_link;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x18.31 */
	 struct connectib_led_port_blink_pattern phy_log_link;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x20.31 */
	 struct connectib_led_port_blink_pattern phy_log_link_traffic;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x28.31 */
	 struct connectib_led_port_blink_pattern error;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0xa0.31 */
	 struct connectib_led_port_blink_pattern reserved_pattern[15];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_static_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t dwrr_en;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t ifarm_en;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t xrc_use_ib_spec_opcode;
	/* Description - If set madifc will be accepted on all PFs even if not host 0 */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t allowed_madifc_on_all_pfs;
	/* Description - flip flop data protection enable
if error is detected -
ib + pci serdes will give dc stable (i.e all 0's) */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t ffser_en;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - mask of iriscs that participate in prio group X in dispatcher */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t prio_g_0_ix_mask_no_ifarm;
	/* Description - mask of iriscs that participate in prio group X in dispatcher */
	/* 0x4.8 - 0x4.15 */
	 u_int8_t prio_g_1_ix_mask_no_ifarm;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t gvmi_rl_custom_tokens_mantissa;
	/* Description -  */
	/* 0x8.16 - 0x8.19 */
	 u_int8_t gvmi_rl_custom_tokens_exponent;
	/* Description - 0x0 - no rate limiter, 0x1 - GVMI_RL_10GBPS, 0x2 - GVMI_RL_12_5_GBPS, 0x3 - GVMI_RL_CUSTOM_TOK, 0x4 - QP_RATE_LIMITER, 0x5 - GVMI_RL_25_GBPS, 0x6 - GVMI_RL_50_GBPS, 0x7 - FW_VQOS_MODE */
	/* 0x8.20 - 0x8.22 */
	 u_int8_t gvmi_rl_mode;
	/* Description - when set managment mac address will be base mac address plus 2 (active only when  single port single host single pf per port devices) */
	/* 0x8.28 - 0x8.28 */
	 u_int8_t ocp_bmc_mac_plus_two;
	/* Description - default flow control configuration, bit per port. 0x0 - no pause, 0x1 - global pause on port 1, 0x2 - global pause on port 2, 0x3 - global pause on port 1 and 2 */
	/* 0x8.29 - 0x8.30 */
	 u_int8_t global_pause_en;
	/* Description - allow flash 64kByte sector erase */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t allow_flash_64k_erase;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_guids {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - UIDs (MACs and GUIDs) Allocation Entry.
guids[0], is used for system GUID, node GUID and port GUID of port 0. guids[1], is used for port GUID of port 1.;/Multiple UIDs can be assigned to a single port, to be used for multiple virtual guests.

Allocation Example:
For a port GUID, if the
    UID = 0x2c9030001000
    num_allocated  = 4, 
    step = 8

Then the GUIDs for this port would be:
    0x2c9030001000
    0x2c9030001008
    0x2c9030001010
    0x2c9030001018 */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_uid_entry guids[2];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x40.31 */
	 struct connectib_uid_entry macs[2];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_module_versions {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_module_version core;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_module_version phy;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 struct connectib_module_version kernel;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 struct connectib_module_version iron_image;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 struct connectib_module_version host_management;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 struct connectib_module_version mad;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_image_size {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - log of next address in bytes to search for an image. Address in bytes is 2^log_step */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t log_step;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Max possible size in bytes of image. Image read / write should not occure beyond this address */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t max_size;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_TRIPPLE_VERSION {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t MAJOR;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t SUBMINOR;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t MINOR;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_operation_key {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t key_modifier;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t key;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_toc_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t address;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t size;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_rst_api_ver {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_reset_level_info reset[8];
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_reset_capabilities {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Initial capability for reset level */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t reset_ver_en;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_get_gvmi_rl_ctx_ix {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t real_gvmi;
	/* Description -  */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t vl;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t port;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi_rl_ctx_ix;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t gvmi_tag;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_sysport {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Packet properties */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_sysport_packet_properties pkt_prop;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Packet length in bytes */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t pkt_length;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Packet data */
	/* 0x24.0 - 0x300.31 */
	 struct connectib_sysport_packet_data pkt_data;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_drop_counter_read {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t sq_num_to;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_icmd_rw_gvmi_fw_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_rw_gvmi_fw_ctx_sub_structs sub_structs;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x44.31 */
	 u_int32_t gvmi;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - DCR_ODP_EVENT = 0x1,
 */
	/* 0x44.0 - 0x48.31 */
	 u_int32_t node_type;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description -  */
	/* 0x48.0 - 0x4c.31 */
	 u_int32_t ix;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_mh_sync {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - input mailbox: state of sync: IDLE, GET_READY, GO */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t input_state;
	/* Description - input mailbox: sync_type - 0x01 = FW_RESET */
	/* 0x0.8 - 0x0.15 */
	 u_int8_t input_sync_type;
	/* Description - input mailbox: when set - ignore inactive hosts */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t input_ignore_inactive_hosts;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - output mailbox: state of sync: IDLE, GET_READY, GO */
	/* 0x4.0 - 0x4.3 */
	 u_int8_t fsm_state;
	/* Description - output mailbox: sync_type - 0x01 = FW_RESET */
	/* 0x4.8 - 0x4.15 */
	 u_int8_t fsm_sync_type;
	/* Description - output mailbox: when set - ignore inactive hosts */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t fsm_ignore_inactive_hosts;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - output mailbox: bit per host - indicates hosts already issued GET_READY */
	/* 0x8.0 - 0x8.3 */
	 u_int8_t fsm_host_ready;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - output mailbox: NIC uptime since last reset in microsecondes at the moment of first GET_READY */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t fsm_start_uptime;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_asn1_force_port_state {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t port0_1;
	/* Description -  */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t force_enable_disable;
	/* Description -  */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t state_enable_disable;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icmd_port_admin_state_mng {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - icmd get, 1 - icmd set */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t set_get_;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t portid;
	/* Description - 0 - ignore this mgmt, 1 - set this mgmt. bit 0  - mgmt admin, bit 1 - mgmt ASN.1 */
	/* 0x0.4 - 0x0.5 */
	 u_int8_t mgmt_update_mask;
	/* Description - mgmt values to set. bit 0  - mgmt admin, bit 1 - mgmt ASN.1 */
	/* 0x0.8 - 0x0.9 */
	 u_int8_t mgmt_update_data;
	/* Description - 0 - ignore this klu, 1 - set this klu. bit 0  - KLU Eth, bit 1 - KLU IB, bit 2 - KLU on boot, bit 3 - KLU on standby */
	/* 0x0.12 - 0x0.15 */
	 u_int8_t klu_update_mask;
	/* Description - KLU values to set. bit 0  - KLU Eth, bit 1 - KLU IB, bit 2 - KLU on boot, bit 3 - KLU on standby */
	/* 0x0.20 - 0x0.23 */
	 u_int8_t klu_update_data;
	/* Description - KLU current state. */
	/* 0x0.28 - 0x0.29 */
	 u_int8_t klu_state;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0 - ignore reneg on chage on set, 1 - set reneg on change on set */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t reneg_on_change_set_mask;
	/* Description - 0 - ignore reneg on chage on set, 1 - set reneg on change on set */
	/* 0x4.8 - 0x4.8 */
	 u_int8_t reneg_on_change_set_data;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - gvmi to set_reneg_on_change */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t reneg_on_change_set_gvmi;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Renegotiate only on config change (PF array, pf_ix = (host_ix)*max_num_pfs_per_host_ini_value + func_num).                                                                                                                        on set, will set reneg_on_change[0] go reneg on change gvmi */
	/* 0xc.0 - 0x14.31 */
	 struct connectib_pf_array_default_ones reneg_on_change;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - on set - invalid. on get - drivers mask [0-63] per pf */
	/* 0x14.0 - 0x1c.31 */
	 struct connectib_drivers_mask_arr drivers_mask;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Disable union.
If one bit is set to 1, do not open             the port. */
	/* 0x1c.0 - 0x20.31 */
	 union connectib_disable_mask disable_mask;
};

/* Description -   */
/* Size in bytes - 100 */
struct connectib_icmd_get_packet_pacing_debug_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description - packet pacing rate limit index */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t rate_limit_index;
	/* Description - indicate if rate limit exist for the given index */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rate_limit_active;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - rate in 10^3 bits per second */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t rate_kbits;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t burst_upper_bound_bytes;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - burst size that is configured in the schedQ */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t burst_bytes;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t log2qp_rate_limiter_time;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x64.31 */
	 u_int32_t sq_index[20];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_map_event_eq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t set_get_;
	/* Description -  */
	/* 0x0.17 - 0x0.17 */
	 u_int8_t map_unmap_;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t eqn;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t event_bitmask;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_internal_query_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t opcode;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t opcode_exists_out;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icmd_detect_gvmi_in_qpc_and_icmc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - gvmi to detect */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - gvmi detected in QPC */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t qpi;
	/* Description - gvmi detected in QPC */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t qpc_detection_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - gvmi detected in ICMC */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t icmc_detection_valid;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t va_63_32;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t va_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_temp_warn_gen_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Bit vector indicating which of the sensor reading is above threshold. Address 00h bit31 is sensor_warning[127] Address 0Ch bit0 is sensor_warning[0] */
	/* 0x0.0 - 0x10.31 */
	 u_int32_t sensors_arr[4];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_icmd_access_register_nodnic_queue_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t nodnic_idx;
	/* Description -  */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t send0_qpi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t send1_qpi;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t rcv0_qpi;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t rcv1_qpi;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t cqi;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t eqi;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t drop_qpi;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - if query failed syndrome will be here */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t status;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icmd_set_get_debug_pf_mac {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw_;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t port_id;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t host_id;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t mac_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t mac_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.7 */
	 u_int8_t pf_idx_in_host_port;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_icmd_get_pf_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t portid;
	/* Description -  */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t vport_num;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t pf_gvmi;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x40.31 */
	 struct connectib_vport_shadow vport_shadow;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x80.31 */
	 struct connectib_vport_info vport_info;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_ocbb_get_pci_api {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - function index. for fpp, this is port index */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t func_index;
	/* Description - host */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t host;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x30.31 */
	 struct connectib_ocbb_pci_data output_data;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_ocbb_rndc_get_core_api {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x200.31 */
	 struct connectib_ocbb_fields output_data;
/*---------------- DWORD[128] (Offset 0x200) ----------------*/
	/* Description - port_0_1 */
	/* 0x200.0 - 0x200.7 */
	 u_int8_t portid;
	/* Description -  */
	/* 0x200.16 - 0x200.31 */
	 u_int16_t host_ix;
};

/* Description -   */
/* Size in bytes - 60 */
struct connectib_icmd_pre_define_module_db {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t module;
	/* Description - CABLE_TYPE_INPUT_DATA = 0x0,CABLE_TYPE_COPPER = 0x1,CABLE_TYPE_OPTIC_THUNDER = 0x2 */
	/* 0x0.8 - 0x0.10 */
	 u_int8_t cable_type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x3c.31 */
	 struct connectib_module_db_pre_define_st module_database;
};

/* Description -   */
/* Size in bytes - 36 */
struct connectib_icmd_pmlp_query {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - unmap local port
1 - x1 (lane 0 is used)
2 - x2 (lanes 0,1 are used)
4 - x4 (lanes 0,1,2 and 3 are used)
Other - reserved */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t width;
	/* Description - Local port number */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t local_port;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t module0;
	/* Description - Lane - up to 4 serdeses in a module can be mapped to   a local port. */
	/* 0x4.16 - 0x4.17 */
	 u_int8_t lane0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t module1;
	/* Description - Lane - up to 4 serdeses in a module can be mapped to   a local port. */
	/* 0x8.16 - 0x8.17 */
	 u_int8_t lane1;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.7 */
	 u_int8_t module2;
	/* Description - Lane - up to 4 serdeses in a module can be mapped to   a local port. */
	/* 0xc.16 - 0xc.17 */
	 u_int8_t lane2;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.7 */
	 u_int8_t module3;
	/* Description - Lane - up to 4 serdeses in a module can be mapped to   a local port. */
	/* 0x10.16 - 0x10.17 */
	 u_int8_t lane3;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_icmd_get_fw_driver_version {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_fw_driver_version fw_driver_version;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - if set, icmd gets the function from hix and func_num */
	/* 0x40.0 - 0x40.0 */
	 u_int8_t use_hix_func_num;
	/* Description -  */
	/* 0x40.16 - 0x40.31 */
	 u_int16_t gvmi;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description -  */
	/* 0x44.0 - 0x44.7 */
	 u_int8_t func_num;
	/* Description -  */
	/* 0x44.8 - 0x44.15 */
	 u_int8_t host_ix;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_set_oc_int {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - module 0 or 1 */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t module;
	/* Description - if bit is 1, bad cable flow refers as oc_int gpio is down */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t force_gpio_down;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_gen_assert {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - assert value */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t value;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - assert type, FW enum */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t type;
};

/* Description -   */
/* Size in bytes - 68 */
struct connectib_icmd_read_write_varb_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - read = 1 , write = 0 */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t rw_;
	/* Description - arbiter index [0-2047] */
	/* 0x0.1 - 0x0.12 */
	 u_int16_t arb_id;
	/* Description - gvmi index */
	/* 0x0.13 - 0x0.24 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x24.31 */
	 struct connectib_vqos_arb_ctx data;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x44.31 */
	 struct connectib_vqos_arb_ctx mask;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_debug_calc_sqn {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t port_0_1;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t vl;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t sl;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t pp;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t req_res_;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t is_fw_sq;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t sqn;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - use iterator = 0 / calc_sq_iterator */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t calc_sqn_iterator_;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - total iterator iterations */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t iterations;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - iterator skip_vl15 */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t skip_vl_15;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - iterator return sqs even if sl2vl_mismatch */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t include_sl2vl_mismatch;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - iterator will return only iterations are greater then the given number */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t iterator_lowest_iter;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x300.31 */
	 struct connectib_iterator_result iterator_res[89];
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_mini_flow_activator {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0=flicks_enable_disable; 1=steering_flush_cache; 2=invalidate_qp_l0_cache; 3=invalidate_dct_l0_caches; 4=invalidate_rxw_l2_cache; 5=invalidate_dirty_rxc_cache_start; 6=invalidate_dirty_sxd_cache_start; 7=update_gvmis_steering_bypasses; 8=invalidate_dirty_ldb_cache_start */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t freq;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_general_fault_injector {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0=no_free_pages; 1=no_pages_for_resource; 2=lock_eq_gw; 3=lock_cqe_gw; 4=rx_fence_type; 5=sx_fence_type; 6=rxt_slices_fence_type; 7=sxd_ec_slices_fence_type; 8=general_fence_type; */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_general_fault_injector_pair config;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - smbus gw. relevant only for type 0x9. */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t param;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_icmd_access_register_pvlc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x14.31 */
	 struct connectib_pvlc_reg pvlc;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_icmd_parse_icm_address {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t addr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t gvmi;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t res_type;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t res_num;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_icmd_get_steering_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t gvmi_active;
	/* Description -  */
	/* 0x4.2 - 0x4.2 */
	 u_int8_t fpp_enable;
	/* Description -  */
	/* 0x4.3 - 0x4.3 */
	 u_int8_t sriov_enable;
	/* Description -  */
	/* 0x4.4 - 0x4.4 */
	 u_int8_t portid;
	/* Description -  */
	/* 0x4.5 - 0x4.5 */
	 u_int8_t ib_eth_;
	/* Description -  */
	/* 0x4.6 - 0x4.6 */
	 u_int8_t roce_en;
	/* Description -  */
	/* 0x4.7 - 0x4.7 */
	 u_int8_t gvmi_steering_enabled;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t pf_gvmi;
	/* Description -  */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t port_pf_gvmi;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t vport_num;
	/* Description -  */
	/* 0xc.16 - 0xc.31 */
	 u_int16_t allowed_uc_list_size;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.1 */
	 u_int8_t nic_state;
	/* Description -  */
	/* 0x10.2 - 0x10.3 */
	 u_int8_t esw_state;
	/* Description -  */
	/* 0x10.4 - 0x10.4 */
	 u_int8_t connected_2_steering;
	/* Description -  */
	/* 0x10.8 - 0x10.11 */
	 u_int8_t num_of_hosts;
	/* Description -  */
	/* 0x10.12 - 0x10.15 */
	 u_int8_t num_pfs;
	/* Description -  */
	/* 0x10.16 - 0x10.31 */
	 u_int16_t total_vfs;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 struct connectib_dmfs_ft_type_info esw_egress_info;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 struct connectib_dmfs_ft_type_info esw_ingress_info;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x40.31 */
	 struct connectib_dmfs_data dmfs_data;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x80.31 */
	 struct connectib_dmfs_gvmi_ctx dmfs_gvmi_ctx;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_icmd_read_ste {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_ste data;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x44.31 */
	 u_int32_t index;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description -  */
	/* 0x44.0 - 0x44.15 */
	 u_int16_t gvmi;
	/* Description - is ste locked in icmc, if so gvmi is reserved */
	/* 0x44.31 - 0x44.31 */
	 u_int8_t locked_in_icmc;
};

/* Description -   */
/* Size in bytes - 256 */
union connectib_icmd_get_ste_resources_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_ste_resources_list_in in;
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_icmd_get_ste_resources_list_out out;
};

/* Description -   */
/* Size in bytes - 768 */
union connectib_icmd_get_ste_open_resources {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_ste_open_resources_in in;
	/* Description -  */
	/* 0x0.0 - 0x300.31 */
	 struct connectib_icmd_get_ste_open_resources_out out;
};

/* Description -   */
/* Size in bytes - 768 */
union connectib_icmd_get_fte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_fte_in in;
	/* Description -  */
	/* 0x0.0 - 0x300.31 */
	 struct connectib_icmd_get_fte_out out;
};

/* Description -   */
/* Size in bytes - 16 */
union connectib_icmd_get_fte_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_fte_list_in in;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_fte_list_out out;
};

/* Description -   */
/* Size in bytes - 256 */
union connectib_icmd_get_fg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_fg_in in;
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_icmd_get_fg_out out;
};

/* Description -   */
/* Size in bytes - 16 */
union connectib_icmd_get_fg_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_fg_list_in in;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_fg_list_out out;
};

/* Description -   */
/* Size in bytes - 16 */
union connectib_icmd_get_ft_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_ft_info_in in;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_ft_info_out out;
};

/* Description -   */
/* Size in bytes - 16 */
union connectib_icmd_get_ft_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_ft_list_in in;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_ft_list_out out;
};

/* Description -   */
/* Size in bytes - 72 */
struct connectib_icmd_led_control_mad {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 1 = GET, 2 = SET */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t method;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - attribute_modifier - choose gourp of leds */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t attribute_mod;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x48.31 */
	 struct connectib_led_control_data data;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_led_cmd {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t index;
	/* Description - type: 0=phy; 1=traffic; 2=pci; 3=uid; 4=bad_port; */
	/* 0x0.8 - 0x0.11 */
	 u_int8_t led_type;
	/* Description - pattern; */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t pattern;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Read/Write pattern (for write Enable should be ON = 1) */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t rw;
	/* Description - Enable bit. 
 to reset LED control need to send write(rw=0) with en = 0 */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t en;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_icmd_set_get_port_cntr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t data;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.0 */
	 u_int8_t port_0_1;
	/* Description -  */
	/* 0x8.1 - 0x8.1 */
	 u_int8_t set_get_;
	/* Description - ConnectX4 max_ix=276 ; ConnectIB max_ix=182 */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t cntr_ix;
};

/* Description -   */
/* Size in bytes - 268 */
struct connectib_icmd_access_register_ppcnt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x104.31 */
	 struct connectib_ppcnt_reg ppcnt;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_icmd_measure_frequency {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - cluster number */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t cl;
	/* Description - pll id */
	/* 0x0.8 - 0x0.9 */
	 u_int8_t pll;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - measured divider quotient */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t measured_div_quotient;
	/* Description - measured divider fraction */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t measured_div_fraction;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_restore_phy_registers {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.4 */
	 u_int8_t local_port;
};

/* Description -   */
/* Size in bytes - 68 */
struct connectib_icmd_access_reg_ptys {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x44.31 */
	 struct connectib_ptys_reg ptys;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_icmd_access_register_pmtu {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x14.31 */
	 struct connectib_pmtu_reg pmtu;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_access_register_mlcr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x10.31 */
	 struct connectib_mlcr mlcr;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_access_register_plpc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x2c.31 */
	 struct connectib_plpc_reg plpc;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_access_register_pplm {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x1c.31 */
	 struct connectib_pplm_reg pplm;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_access_register_pplr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0xc.31 */
	 struct connectib_pplr_reg pplr;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_access_register_ppamp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x30.31 */
	 struct connectib_pamp_reg ppamp;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_access_register_ptas {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x30.31 */
	 struct connectib_ptas_reg ptas;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_icmd_access_register_ppaos {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x14.31 */
	 struct connectib_ppaos_reg ppaos;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_icmd_access_register_pprt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x24.31 */
	 struct connectib_pprt_reg pprt;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icmd_access_register_pptt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x20.31 */
	 struct connectib_pptt_reg pptt;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_icmd_access_register_slrg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x2c.31 */
	 struct connectib_slrg_reg slrg;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_icmd_access_register_sltp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x18.31 */
	 struct connectib_sltp_reg sltp;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_access_register_slrp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x2c.31 */
	 struct connectib_slrp_reg slrp;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_icmd_access_register_paos {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x14.31 */
	 struct connectib_paos_reg paos;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_enable_tools_pf {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t disable_enable_;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_icmd_set_toolpf_tracer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t PA;
};

/* Description -   */
/* Size in bytes - 272 */
struct connectib_icmd_nvcfg_rw_tlv {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.20 - 0x0.23 */
	 u_int8_t writer_id;
	/* Description - debug - commit a nvct flow */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t apply;
	/* Description - debug - write tlv to shadow list */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t shadow;
	/* Description - debug - tlv ovr_en */
	/* 0x0.26 - 0x0.26 */
	 u_int8_t ovr_en;
	/* Description - debug - tlv rd_en */
	/* 0x0.27 - 0x0.27 */
	 u_int8_t rd_en;
	/* Description - debug - tlv priority */
	/* 0x0.28 - 0x0.29 */
	 u_int8_t prio;
	/* Description - read tlv defaults from ini */
	/* 0x0.30 - 0x0.30 */
	 u_int8_t read_defaults;
	/* Description - read or write bit */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t rw_;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - tlv type */
	/* 0x4.0 - 0x8.31 */
	 union connectib_nv_tlv_type type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - data length in bytes */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t data_len_bytes;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - status returned from the rw tlv function icmd uses */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t status;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - data */
	/* 0x10.0 - 0x110.31 */
	 u_int32_t data[64];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_xport_xonfig {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - XPORT_CONFIG_ACK_TIMEOUT
 */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t bitmask;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - read=1, write=0, for read - bitmask must be 0, for write: at least 1 bit should be set in bitmask */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t rw_;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.4 */
	 u_int8_t ack_timeout;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_gvmi_via_vsec {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t hix;
	/* Description -  */
	/* 0x0.24 - 0x0.27 */
	 u_int8_t pfs_per_host;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.3 */
	 u_int8_t num_physical_ports;
	/* Description -  */
	/* 0x4.4 - 0x4.7 */
	 u_int8_t port_pfs_per_host;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t device_id;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_icmd_steering_table_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_steering_table_info table_info;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - defined in steering_inner.h */
	/* 0x40.0 - 0x40.23 */
	 u_int32_t steering_table;
	/* Description -  */
	/* 0x40.31 - 0x40.31 */
	 u_int8_t portid;
};

/* Description -   */
/* Size in bytes - 68 */
struct connectib_icmd_access_steering_root {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_hw_ste data;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x40.0 */
	 u_int8_t sx_rx_;
	/* Description -  */
	/* 0x40.1 - 0x40.1 */
	 u_int8_t portid;
	/* Description -  */
	/* 0x40.2 - 0x40.2 */
	 u_int8_t mc_uc_;
	/* Description - valid only for SX, in HW indication come from QP */
	/* 0x40.3 - 0x40.3 */
	 u_int8_t special_root;
	/* Description -  */
	/* 0x40.4 - 0x40.4 */
	 u_int8_t enable_disable_;
	/* Description -  */
	/* 0x40.31 - 0x40.31 */
	 u_int8_t rw_;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_dcr_ll_next_dcr_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t start_dcri;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t list_length;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 0x100.0 - 0x300.31 */
	 struct connectib_dcr_info dcr_info[128];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_dcr_ll_trvrs {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t start_dcri;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t list_length;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t last_dcri;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icmd_flr_debug {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - read - update in_standby_mode and times. write - simulate exit/enter icmc power save flow (caller should set exit_enter_) */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t rw_;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t flow_id;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t flow_data_0;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t flow_data_1;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_push_db {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t qpn;
	/* Description -  */
	/* 0x4.24 - 0x4.24 */
	 u_int8_t req_res_;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_icmd_ver_data {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - determines specific behavior. 1-set atomic size,  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t opcode;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - for general use */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t user_data;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x50.31 */
	 union connectib_icmd_ver_data_cmd_specific cmd_specific;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_icmd_pcie_ver_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_pcie_ver_device device;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x30.31 */
	 struct connectib_icmd_pcie_ver_cables cables[2];
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x40.31 */
	 struct connectib_icmd_pcie_ver_frequency frequency;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_icmd_error_flow_trigger {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - RXT */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t type;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_icmd_stop_toggler {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - DC_CNAK    = 0
RXT_CHECKS = 1
TIMERS     = 2
SX_ERROR   = 3
RX_ERROR   = 4
MX_ERROR   = 5
MAD_TRAP   = 6
RXT_SLICE       = 0x7
QOS_ARBITER     = 0x8
RXB_XMIT_HOLD     = 0x9
FW_SCHED_Q     = 0xa */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - HW/FW will be working/stopped (according to mostly_working config) for a fraction of 1/(2^log_stress) each duty cycle. Duty cycle is: approx. 50uSec * 2^log_duty_cycle */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t mostly_working;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 0 = remove stress */
	/* 0x8.0 - 0x8.4 */
	 u_int8_t log_duty_cycle;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - must be less than log_duty_cycle */
	/* 0xc.0 - 0xc.4 */
	 u_int8_t log_stress;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - bit per prio/vl (vl_mask[8] = vl15) */
	/* 0x20.0 - 0x20.8 */
	 u_int16_t xmit_hold_vl_mask;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - port number 1 or 2 */
	/* 0x24.0 - 0x24.7 */
	 u_int8_t xmit_hold_port_num;
};

/* Description -   */
/* Size in bytes - 264 */
struct connectib_icmd_code_coverage_read {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 u_int32_t data[64];
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description - dword to start reading the data from */
	/* 0x100.0 - 0x100.15 */
	 u_int16_t start_dw;
	/* Description - number of dword to read. Max number is buffer size in dwords or number of dwords left in HW queue from start */
	/* 0x100.16 - 0x100.31 */
	 u_int16_t num_dw;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_code_coverage_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t rw_;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - reg access is shared with smp mads that are limited to 0x40B */
	/* 0x4.0 - 0xc.31 */
	 struct connectib_code_coverage_control code_coverage_control;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_esw {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x200.31 */
	 struct connectib_fw_esw fw_esw;
/*---------------- DWORD[128] (Offset 0x200) ----------------*/
	/* Description -  */
	/* 0x200.0 - 0x280.31 */
	 struct connectib_vport_real_state vport_real_state;
/*---------------- DWORD[189] (Offset 0x2f4) ----------------*/
	/* Description -  */
	/* 0x2f4.29 - 0x2f4.29 */
	 u_int8_t port_is_ib;
	/* Description -  */
	/* 0x2f4.30 - 0x2f4.30 */
	 u_int8_t rw_;
	/* Description -  */
	/* 0x2f4.31 - 0x2f4.31 */
	 u_int8_t portid;
/*---------------- DWORD[190] (Offset 0x2f8) ----------------*/
	/* Description -  */
	/* 0x2f8.0 - 0x2fc.31 */
	 u_int32_t gvmi;
/*---------------- DWORD[191] (Offset 0x2fc) ----------------*/
	/* Description -  */
	/* 0x2fc.0 - 0x300.31 */
	 u_int32_t num_of_vport;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_icmd_rw_gvmix {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_gvmix_sub_structs sub_structs;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x44.31 */
	 u_int32_t gvmi;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - ICMD_RW_GVMIX_CMD_CTX = 0x1,
ICMD_RW_GVMIX_DUMMY_ADDR = 0x2,
ICMD_RW_GVMIX_HCA_PARAMS = 0x3,
ICMD_RW_GVMIX_PAGE_MANAGER = 0x4, */
	/* 0x44.0 - 0x48.31 */
	 u_int32_t node_type;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description -  */
	/* 0x48.0 - 0x4c.31 */
	 u_int32_t ix;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_icmd_gen_eqe {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t eqn;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x50.31 */
	 struct connectib_sw_eqe eqe;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_pcie_tools_pointers {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t pcie_endpoint_data_ptr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t pcie_timestamps_ptr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t pcie_transaction_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t pcie_debug_equalization_debug_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t pcie_debug_ts_debug_ptr;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t pcie_debug_internal_error_debug_ptr;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t pcie_phy_gen3_equalization_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t pcie_phy_pcie_eye_centering_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t pcie_phy_first_calibration_results_ptr;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t pcie_phy_pcie_rx_adaptation_ptr;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t pcie_phy_pcie_tx_adaptation_ptr;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t pcie_phy_tracer_ptr;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t pcie_pfs_ptr;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_phy_ver_overwrite {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - port1, 1 - port2 */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t port_id;
	/* Description - 0x00 - CABLE_STAMP
0x01 - MLPN_EN
0x02 - MLPN_SUP
0x03 - MLPN_REQ
0x04 - SPEC_1_2
0x05 - SPEC_1_3
0x06 - FEC_REQ_FDR
0x07 - FEC_REQ_FDR10 */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t field_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - New value to overwrite.
 For MLPN_SUP and MLPN_REQ full DW
 */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t field_value;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_icmd_init_ocsd {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t addr_hi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t addr_low;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_init_ncsi {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - number of bmcs */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t num_of_bmc;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - number of channels per package */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t num_of_channels;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_icmd_dc_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - DC_CONFIG_BIT_HANDSHAKE
1 -DC_CONFIG_LOG_DCR_LIFO_SIZE
7 - DC_CONFIG_LOG_DCR_HASH_SIZE
8 - DC_CONFIG_FORCE_NO_DCRS
9 - DC_CONFIG_FORCE_GARBAGE_COLLECT
10 - DC_CONFIG_GARBAGE_COLLECT_PACKET_DROP
11 - DC_CONFIG_GHOST_BUSTER_ENABLE
 12 - DC_CONFIG_MAX_CNAK_BUFFER_SIZE
13 - DC_CONFIG_CNAK_QP_ON_THRESHOLD
14 - DC_CONFIG_CNAK_QP_OFF_THRESHOLD
 15 - DC_CONFIG_DCR_LIFO_SIZE */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t bitmask;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - read=1, write=0, for read - bitmask must be 0, for write: at least 1 bit should be set in bitmask */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t rw_;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - must be configured before init hca (deprecated, mutexed with dcr_lifo_size) */
	/* 0xc.0 - 0xc.4 */
	 u_int8_t log_dcr_lifo_size;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - must be configured before init_hca */
	/* 0x10.0 - 0x10.4 */
	 u_int8_t log_dcr_hash_size;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - set all qps opened from this point with full_handshake = 0/1 */
	/* 0x14.0 - 0x14.0 */
	 u_int8_t full_handshake_enable;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - RO - current number of free dcrs in lifo */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t available_lifo_size;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - when GARBAGE_COLLECTION bit is set in bitmask, icmd will return OK if done, or OPERATIONAL_ERROR if garbage collection doesn't finish with this number of ticks (~50usec) */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t force_garbage_collection_fail_threshold;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - number of ghost busters currently active. should be 0 once garbage collection is done */
	/* 0x3c.0 - 0x40.31 */
	 u_int32_t number_of_active_ghost_busters;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - N next dcr cleanup connects will be dropped */
	/* 0x40.0 - 0x44.31 */
	 u_int32_t cleanup_drop_n_connects;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - N next dcr cleanup disconnects will be dropped */
	/* 0x44.0 - 0x48.31 */
	 u_int32_t cleanup_drop_n_disconnects;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - enables/disable ghost buster mechanism */
	/* 0x48.0 - 0x48.0 */
	 u_int8_t ghost_buster_enable;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - max entries in cnak buffer */
	/* 0x4c.0 - 0x4c.15 */
	 u_int16_t max_cnak_buffer_size;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - lower threshold - below this num credits - cnak_qp will be turned on */
	/* 0x50.0 - 0x50.23 */
	 u_int32_t cnak_qp_on_threshold;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - upper threshold - above this num credits - cnak_qp will be turned off */
	/* 0x54.0 - 0x54.23 */
	 u_int32_t cnak_qp_off_threshold;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - mutexed with log_dcr_lifo_size */
	/* 0x58.0 - 0x58.23 */
	 u_int32_t dcr_lifo_size;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_read_icmc_tags_and_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - data[0] + data[1] = set[first_set][way[0]], data[2] + data[3] = set[first_set][way[1]]  */
	/* 0x0.0 - 0x2fc.31 */
	 u_int32_t data[191];
/*---------------- DWORD[191] (Offset 0x2fc) ----------------*/
	/* Description - read icmc tags start from first set */
	/* 0x2fc.0 - 0x2fc.11 */
	 u_int16_t first_set;
	/* Description - number of set read by icmd */
	/* 0x2fc.12 - 0x2fc.23 */
	 u_int16_t number_of_sets;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_icmd_access_icm_line {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 u_int32_t data[16];
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.31 - 0x40.31 */
	 u_int8_t rw_;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description -  */
	/* 0x48.0 - 0x50.31 */
	 u_int64_t addr;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_check_sqpc_status {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t qpn;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
	/* Description - 0:all good
1:db_record!=sxdc_pi
2:pi!=ci;\3:ci!=ccwi */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t result_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - the diff */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t result_diff;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_lock_unlock_resource {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_lock_tag lock_tag;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.0 */
	 u_int8_t lock_unlock_;
	/* Description -  */
	/* 0xc.8 - 0xc.10 */
	 u_int8_t irisc_ix;
	/* Description - when this bit is set, locking will impersonate irisc specified in irisc_ix field */
	/* 0xc.11 - 0xc.11 */
	 u_int8_t spy_en;
};

/* Description -   */
/* Size in bytes - 296 */
struct connectib_icmd_generic_access_register {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_reg_access_oper_tlv oper_tlv;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x124.31 */
	 struct connectib_icmd_generic_reg_access_reg_tlv generic_reg_tlv;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_kdnet_ctrl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 union connectib_icmd_kdnet_ctrl_io io;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 struct connectib_nv_config_kdnet_data data;
};

/* Description -   */
/* Size in bytes - 8 */
union connectib_icmd_query_capabilities {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_icmd_query_cap_in cap_in;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_icmd_query_cap_general cap_general;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_icmd_get_icm_ctx_addr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - defined in icm_resources.h */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t icm_res_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t ctx_num_hi;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t ctx_num_lo;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t icm_addr_hi;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t icm_addr_lo;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_phy_nego_ctrl_st {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t force_link_up_port0;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t halt_fw_phy_fsm_port0;
	/* Description -  */
	/* 0x0.2 - 0x0.2 */
	 u_int8_t force_link_up_port1;
	/* Description -  */
	/* 0x0.3 - 0x0.3 */
	 u_int8_t halt_fw_phy_fsm_port1;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_eye_opening_read_st {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t port_num;
	/* Description -  */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t lane_num;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t amplitude_high;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t amplitude_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t phase_high;
	/* Description -  */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t phase_low;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t tx_set_chosen;
	/* Description -  */
	/* 0xc.16 - 0xc.31 */
	 u_int16_t rx_set_chosen;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_icmd_alloc_dealloc_resource {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t alloc_dealloc;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - defined in icm_resources.h */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t icm_res_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t res_num_hi;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t res_num_lo;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t return_status;
};

/* Description -   */
/* Size in bytes - 36 */
struct connectib_icmd_get_icm_res_prop {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - valid types defined at icm_resources.h */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t input_icm_type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t table_base_hi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t table_base_lo;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t offset;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t log2_stride;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t log2_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t log2_table_size;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t dummy_idx;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t sw_type;
};

/* Description -   */
/* Size in bytes - 72 */
struct connectib_icmd_emad_mcia {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - write = 1
query = 0
 */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t write_query_;
	/* Description - PASSED_SANITY_CHECKS     = 0,
MODULE_TYPE_NOT_SUPPORTED = 1,
I2C_ERROR = 2,
MODULE_DISABLED = 3,
NO_EEPROM = 4,
MODULE_NOT_CONNECTED = 5,
INVALID_SLAVE_ADDR = 6,
BAD_PARAM_PAGE_NUM  = 7,
BAD_PARAM = 8,
RETRY = 9,
BUSY = 10,
LONG_PROCESS = 11,

This field will provide information of the sanity checks run over the emad input  */
	/* 0x0.16 - 0x0.19 */
	 u_int8_t sanity_checks_sts;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0h - GOOD.
1h - NO_EEPROM_MODULE. No response from module's EPROM.
2h - MODULE_NOT_SUPPORTED. Module type not supported by the device.
3h - MODULE_NOT_CONNECTED. No module present indication.
4h - MODULE_TYPE_INVALID - if the module is not qsfp or sfp - ini configuration.
9h - I2C_ERROR. Error occurred while trying to access the module's EPROM using I2C
10h - MODULE_DISABLED - module is disabled (using Disable Command).
 */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t status;
	/* Description - Module number */
	/* 0x4.16 - 0x4.23 */
	 u_int8_t module;
	/* Description - Cable Info Lock Page bit - when set there will be no page select for the module, the page number field is ignored */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t l;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The address to read/write in the module */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t device_address;
	/* Description - The page from which to read/write in the module, last page is cached, when the page is changed a page select transaction will be occured  */
	/* 0x8.16 - 0x8.23 */
	 u_int8_t page_number;
	/* Description - The module's i2c slave address - usually 0x50 */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t i2c_device_address;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Desired read/write size in bytes */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t size;
	/* Description - Password capability */
	/* 0xc.29 - 0xc.29 */
	 u_int8_t passwd_cap;
	/* Description - If set to 1 will force the password to be cleared from the module password field at the end of the module access. */
	/* 0xc.30 - 0xc.30 */
	 u_int8_t passwd_clr;
	/* Description - If set to 1 the Password field is valid and is written to the module password field (address 123-126) before accessing the page. */
	/* 0xc.31 - 0xc.31 */
	 u_int8_t passwd_v;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The password that is written to the module password field. */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t password;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Write transaction - Data to write ,
query transaction - Returned read data,
 */
	/* 0x14.0 - 0x44.31 */
	 u_int32_t dword[12];
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - internal icmd implementation */
	/* 0x44.0 - 0x44.0 */
	 u_int8_t internal_state;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_icmd_cable_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 1 = GET, 2 = SET */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t method;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - return status */
	/* 0x4.16 - 0x4.30 */
	 u_int16_t status;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x14.7 */
	 u_int8_t module;
	/* Description - when set, no page select will be made */
	/* 0x14.31 - 0x14.31 */
	 u_int8_t lock_bit;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x80.31 */
	 struct connectib_cable_info data;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_cable_plug_out_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Bit per port. 0x1 - port1, 0x2 - port2, 0x3 - both ports, others reserved. */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t port;
	/* Description - Simulate plug out (0x1) or plug in (0x0), this mode will work if delay=0 */
	/* 0x0.8 - 0x0.8 */
	 u_int8_t plug_out_in;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icmd_standby {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - read - update in_standby_mode and times. write - simulate exit/enter icmc power save flow (caller should set exit_enter_) */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t rw_;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0x0 - enter power save mode, 0x1 - exit power save mode */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t exit_enter_;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 0x0 - ports, 0x1 - icmc, 0x2 - arrays, 0x3- clock */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t in_standby_mode;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - last iron down time usec. update on icmd read */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t last_iron_down_time_usec;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 0 - icmc standby flow , 1 - arrays standby flow, 2 - clock standby flow, 3 - full standby flow */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t flow_id;
};

/* Description -   */
/* Size in bytes - 512 */
struct connectib_icmd_grepper {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - icmd will run grepper operation - 0x0 - icmc_write, 0x1 - icmc_copy, 0x2 - icmc_copy_and_lock, 0x3 - icmc unlock and invalidate */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t icmd_grepper_flow;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - address to read */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t read_addr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - address to write */
	/* 0x10.0 - 0x18.31 */
	 u_int64_t write_addr;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - read stride size (log) */
	/* 0x18.0 - 0x18.4 */
	 u_int8_t log_read_stride;
	/* Description - write stride size (log) */
	/* 0x18.5 - 0x18.9 */
	 u_int8_t log_write_stride;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - offset from the first line */
	/* 0x1c.0 - 0x1c.25 */
	 u_int32_t line_start_offset;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - number of iterations */
	/* 0x20.0 - 0x20.25 */
	 u_int32_t iterations;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Address of first hit (read only) */
	/* 0x24.0 - 0x24.25 */
	 u_int32_t first_line_hit;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - number of hits (read only) */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t number_of_hits;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - write_data */
	/* 0x2c.0 - 0x6c.31 */
	 struct connectib_grepper_dwords write_data;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description - write_mask */
	/* 0x6c.0 - 0xac.31 */
	 struct connectib_grepper_dwords write_mask;
/*---------------- DWORD[43] (Offset 0xac) ----------------*/
	/* Description - compare_data */
	/* 0xac.0 - 0xec.31 */
	 struct connectib_grepper_dwords compare_data;
/*---------------- DWORD[75] (Offset 0x12c) ----------------*/
	/* Description - compare_mask */
	/* 0x12c.0 - 0x16c.31 */
	 struct connectib_grepper_dwords compare_mask;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_execute_fw_log {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_itrace itrace;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - see in icmd.c */
	/* 0x10.0 - 0x10.3 */
	 u_int8_t opcode;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x30.31 */
	 u_int32_t log_var[7];
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_debug_fw_tracer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 u_int32_t arg[8];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Number of arguments passed to the icmd */
	/* 0x20.0 - 0x20.3 */
	 u_int8_t num_of_args;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Number of print iterations to execute */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t num_of_iterations;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Delay between iterations in msec */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t iter_delay;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icmd_get_highest_index {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
	/* Description - defined in icm_resources.h */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t icm_res_type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - highest free list index */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t highest_internal_index;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - highest icm_res_num */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t highest_icm_res_num;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_get_open_resources {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - defined in icm_resources.h */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t icm_res_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x10.31 */
	 u_int64_t start_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - there are more open resources, please query again with the next start index */
	/* 0x10.0 - 0x10.0 */
	 u_int8_t more;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - number of valid entries in open resources table */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t output_size;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x220.31 */
	 struct connectib_index_and_length open_resources[32];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icmd_read_icm_dummy_addr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - resource type - see icm_ctx icmd node */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - dummy index: based to icmd_get_icm_res_prop.dummy_idx */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t dummy_idx;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - hop number 3-6 */
	/* 0x8.0 - 0x8.2 */
	 u_int8_t hop_num;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - PA of dummy page */
	/* 0x10.0 - 0x18.31 */
	 u_int64_t dummy_addr;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_icmd_read_icm_tlb_line {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 u_int64_t data[8];
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x48.31 */
	 u_int64_t tlb_addr;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description -  */
	/* 0x48.0 - 0x48.3 */
	 u_int8_t hop_number;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_config_cc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - ICMD_CONFIG_CC_OPCODE_SET_CC_SETTINGS = 0x0
ICMD_CONFIG_CC_OPCODE_GET_CC_SETTINGS = 0x1
ICMD_CONFIG_CC_OPCODE_SET_CCT = 0x2
ICMD_CONFIG_CC_OPCODE_GET_CCT = 0x3 */
	/* 0x0.0 - 0x0.1 */
	 u_int8_t opcode;
	/* Description -  */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t portid;
	/* Description -  */
	/* 0x0.8 - 0x0.9 */
	 u_int8_t cc_mode;
	/* Description -  */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t sl_map;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.7 */
	 u_int8_t base;
	/* Description -  */
	/* 0x4.16 - 0x4.23 */
	 u_int8_t num_entries;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description - specifies a list of 16 CA congestion entries, one per SL */
	/* 0x100.0 - 0x180.31 */
	 struct connectib_ca_congestion_entry ca_congestion_entry_list[16];
/*---------------- DWORD[128] (Offset 0x200) ----------------*/
	/* Description - specifies a list of 64 CCT entries */
	/* 0x200.16 - 0x280.15 */
	 struct connectib_cc_table_entry ccti_entry_list[64];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_icmd_ud_to_raw {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t qpn;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t port;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t vl15;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_icmd_update_rq_ci {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - RQ, 1 - RMP, 2 - XRC_SRQ, 3 - SRQ, 4 - XRQ */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t context_type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - gvmi of context */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t context_num;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - new consumer index (i.e number of wqe posts) */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t new_ci;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - for link list: pointer for next wq  */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t new_next_index;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_icmd_write_dc_cnak_lid {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.1 */
	 u_int8_t port;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t lid;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_icmd_congestion_log {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.1 */
	 u_int8_t port;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x20.31 */
	 struct connectib_congestion_log_event_entry log_entry;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_port_sniffer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t sx_port1;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t sx_port2;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t rx_port1;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t rx_port2;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_set_port_sniffer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t sx_rx_;
	/* Description -  */
	/* 0x4.16 - 0x4.16 */
	 u_int8_t attach_detach_;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.24 - 0x8.31 */
	 u_int8_t port;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t sniffer_qpn;
};

/* Description -   */
/* Size in bytes - 260 */
struct connectib_icmd_special_qps {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_special_qps qps;
/*---------------- DWORD[39] (Offset 0x9c) ----------------*/
	/* Description - QP Index of GVMI_MNG_TRAP_QP */
	/* 0x9c.0 - 0xa0.31 */
	 u_int32_t host_mng_qpn;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 0x100.0 - 0x100.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x100.16 - 0x100.16 */
	 u_int8_t port;
};

/* Description -   */
/* Size in bytes - 260 */
struct connectib_eqn4type {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 u_int32_t eqn[64];
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 0x100.0 - 0x100.15 */
	 u_int16_t gvmi;
};

/* Description -   */
/* Size in bytes - 72 */
struct connectib_icmd_access_cmdq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_cmdif_hdr cmdq;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x40.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x40.16 - 0x40.20 */
	 u_int8_t cmd_ix;
};

/* Description -   */
/* Size in bytes - 72 */
struct connectib_icmd_read_sx_wq_buffer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 u_int32_t data[16];
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x40.4 */
	 u_int8_t ec;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description -  */
	/* 0x44.0 - 0x44.4 */
	 u_int8_t wqe_idx;
};

/* Description -   */
/* Size in bytes - 192 */
struct connectib_icmd_header_capture {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_icmd_header_capture_headers headers;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 0x80.0 - 0xc0.31 */
	 struct connectib_icmd_header_capture_checks checks;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_print_icm {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t enable_specific_gvmi;
	/* Description -  */
	/* 0x0.1 - 0x0.1 */
	 u_int8_t enable_specific_icm_type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
	/* Description - take from icm_resources.h */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t icm_res_type;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_allowed_madifc_on_all_pfs {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - write 0xBADC0FFE in order to enable */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t protection;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0x1 - enable flow
0x2 - disable */
	/* 0x4.0 - 0x4.1 */
	 u_int8_t enable_disable;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_fw_reset {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - write 0xBADC0FFE in order to enable FW reset */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t protection;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0x1 - upgrade flow
0x2 - dirty MBIST flow */
	/* 0x4.0 - 0x4.1 */
	 u_int8_t reset_mode;
};

/* Description -   */
/* Size in bytes - 264 */
struct connectib_icmd_read_g_rse_slice_desc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 union connectib_g_rse_hw_decoders desc;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 0x100.0 - 0x100.4 */
	 u_int8_t slice;
	/* Description -  */
	/* 0x100.8 - 0x100.11 */
	 u_int8_t array_index;
/*---------------- DWORD[65] (Offset 0x104) ----------------*/
	/* Description - 0x0 STEERING_RES
0x1 PKT_DESC
0x2 RXT_RXS_DESC
0x3 CONTEXT_FETCH_QP_DESC
0x4 STEERING PIPE0
0x5 STEERING PIPE1
0x6 STEERING QPCOMMIT */
	/* 0x104.0 - 0x104.7 */
	 u_int8_t desc_type;
};

/* Description -   */
/* Size in bytes - 524 */
struct connectib_icmd_read_rx_slice_packet {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x200.31 */
	 u_int32_t data[128];
/*---------------- DWORD[128] (Offset 0x200) ----------------*/
	/* Description - Total Packet size (returned by ICMD) */
	/* 0x200.0 - 0x200.11 */
	 u_int16_t packet_size;
/*---------------- DWORD[129] (Offset 0x204) ----------------*/
	/* Description -  */
	/* 0x204.0 - 0x204.4 */
	 u_int8_t slice;
/*---------------- DWORD[130] (Offset 0x208) ----------------*/
	/* Description - How many bytes to read in this iteration. (Must be a multiple of 64. Max allowed value is 512) */
	/* 0x208.0 - 0x208.11 */
	 u_int16_t size;
	/* Description - Offset in dw to start from */
	/* 0x208.16 - 0x208.27 */
	 u_int16_t offset_dw;
};

/* Description -   */
/* Size in bytes - 36 */
struct connectib_icmd_get_fw_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_FW_VERSION fw_version;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Hash gen file signature */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t hash_signature;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.24 - 0x24.23 */
	 char psid[17];
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_get_link_leds {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 1-port1 2-port2 */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t port_number;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t physical_link;
	/* Description -  */
	/* 0x4.8 - 0x4.8 */
	 u_int8_t logical_link;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_get_boot_stage {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t boot_stage;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_get_irisc_heart_beat {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - bit per irisc */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t irisc_heart_beat;
};

/* Description -   */
/* Size in bytes - 524 */
struct connectib_icmd_read_q_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x200.31 */
	 u_int32_t data[128];
/*---------------- DWORD[128] (Offset 0x200) ----------------*/
	/* Description -  */
	/* 0x200.0 - 0x200.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[129] (Offset 0x204) ----------------*/
	/* Description -  */
	/* 0x204.0 - 0x204.23 */
	 u_int32_t q_num;
	/* Description - 0=sq 1=rq 2=cq 4=eq 5=rdb 6=srq */
	/* 0x204.24 - 0x204.31 */
	 u_int8_t q_type;
/*---------------- DWORD[130] (Offset 0x208) ----------------*/
	/* Description -  */
	/* 0x208.0 - 0x20c.31 */
	 u_int32_t index;
};

/* Description -   */
/* Size in bytes - 296 */
struct connectib_icmd_access_host_mem {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 u_int32_t data[64];
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 0x100.0 - 0x100.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x100.31 - 0x100.31 */
	 u_int8_t rw_;
/*---------------- DWORD[65] (Offset 0x104) ----------------*/
	/* Description - up to 256 bytes */
	/* 0x104.0 - 0x108.31 */
	 u_int32_t num_dwords;
/*---------------- DWORD[66] (Offset 0x108) ----------------*/
	/* Description - CMAS- offset */
	/* 0x108.0 - 0x110.31 */
	 u_int64_t addr;
/*---------------- DWORD[68] (Offset 0x110) ----------------*/
	/* Description - VA - mkey, MTT - ptr */
	/* 0x110.0 - 0x118.31 */
	 u_int64_t key_or_ptr;
/*---------------- DWORD[70] (Offset 0x118) ----------------*/
	/* Description - 0-PA
1-MTT
2-VA
3-OFFSET(signature)
4-CMAS */
	/* 0x118.0 - 0x118.3 */
	 u_int8_t addr_type;
	/* Description - MTT only */
	/* 0x118.16 - 0x118.31 */
	 u_int16_t l2_block_s;
/*---------------- DWORD[71] (Offset 0x11c) ----------------*/
	/* Description - Will be used only if CAPI is enabled */
	/* 0x11c.0 - 0x120.31 */
	 u_int32_t capi_pasid;
/*---------------- DWORD[72] (Offset 0x120) ----------------*/
	/* Description - CMAS only */
	/* 0x120.0 - 0x120.23 */
	 u_int32_t cmas_ix;
	/* Description - CMAS only */
	/* 0x120.24 - 0x120.31 */
	 u_int8_t cmas_type;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_icmd_get_pi_ci {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t pi_ci;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x4.16 - 0x4.31 */
	 u_int16_t ctx_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t ctx_num;
};

/* Description -   */
/* Size in bytes - 96 */
struct connectib_icmd_access_icm_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_golan_hw_fw_ctx ctx;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x40.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0x40.31 - 0x40.31 */
	 u_int8_t rw_;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - 0x5f MTT
 0x01 SQ_QP_LIST_REQ
 0x02 SQ_QP_LIST_RES
 0x03 BSF
 0x04 RDB
 0x05 EXT_RDB
 0x06 ICM_CRC
 0x07 QP_COMMON
  0x08 REQUESTOR_QPC
 0x09 RESPONDER_QPC
 0x0a MKEY
 0x0b SRQ
 0x0c CQ
 0x0d TRANS_STATUS_BSF
 0x0e TRANS_STATUS_KLM
 0x0f PSV
  0x10 EXT_PSV
 0x11 SXDC
 0x12 PIPA
 0x13 TIMER
 0x14 FW_COUNTERS
 0x15 EQ
 0x16 MSIX
 0x17 SXD_GVMI_RATE_LIMITER
 0x18 PORT0_PKEY
 0x19 PORT0_GUID
  0x1a PORT0_INFO
 0x1b PORT0_COUNTERS_GVMI_RX
 0x1c PORT1_PKEY
 0x1d PORT1_GUID
 0x1e PORT1_INFO
 0x1f PORT1_COUNTERS_GVMI_RX
  0x20 STEERING
 0x21 LDB_CACHE
 0x22 REQ_SL_CACHE
 0x23 IRISC
 0x24 SCRATCHPAD
 0x25 SQ_POINTERS
 0x26 SQ_TOKENS_OR_SQ_CONTEXT
 0x27 TOC
  0x28 FW_GVMI_CTX
 0x29 FW_QPC
 0x2a FW_MALLOC
 0x2b FW_PD
 0x2c FW_UAR
 0x2d FW_EQ
 0x2e FW_CQ
 0x2f FW_MKEY
 0x30 FW_SRQ
  0x31 FW_GLOBAL
 0x32 FW_SQ
 0x33 GLOBAL_FW_GVMI_CTX
 0x34 FW_ALT_PATH
 0x36 COUNTERS_QP_RX
 0x36 PORT0_COUNTERS_GVMI_SX
  0x37 PORT1_COUNTERS_GVMI_SX
 0x38 FW_LL_QP_REQ
 0x39 FW_LL_QP_RES
 0x3a  FW_LL_CQ_OVERRUN
 0x3b FW_LL_EQ_OVERRUN_CQ
  0x3c FW_LL_EQ_OVERRUN_EQ
 0x3d EQ_OVERRUN_LIST_META
 0x3e ICM_RES_FW_XRCD
 0x3f ICM_RES_FW_FREE_LIST
 0x4e COUNTERS_QP_SX
 0x5e FW_PORT_INFO */
	/* 0x44.0 - 0x44.15 */
	 u_int16_t ctx_type;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description -  */
	/* 0x48.0 - 0x50.31 */
	 u_int64_t ctx_num;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - second index - for reading RDB */
	/* 0x50.0 - 0x54.31 */
	 u_int32_t ctx_num2;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_cmd_as_dwords {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x300.31 */
	 u_int32_t dword[192];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_sw_cqe_64b {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t rsvd_5;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t rsvd_4;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t checksum;
	/* Description -  */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t rsvd_3;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t ip_status;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x10.15 */
	 u_int16_t slid_smac_47_32;
	/* Description -  */
	/* 0x10.16 - 0x10.31 */
	 u_int16_t vlan_ml_path;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t slid_smac_31_0;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.23 */
	 u_int32_t rqpn;
	/* Description -  */
	/* 0x18.24 - 0x18.27 */
	 u_int8_t sl_vlan_type;
	/* Description -  */
	/* 0x18.28 - 0x18.29 */
	 u_int8_t g;
	/* Description -  */
	/* 0x18.30 - 0x18.30 */
	 u_int8_t fl;
	/* Description -  */
	/* 0x18.31 - 0x18.31 */
	 u_int8_t rsvd_bit;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t rss_val;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x20.23 */
	 u_int32_t srq_num;
	/* Description -  */
	/* 0x20.24 - 0x20.31 */
	 u_int8_t rsvd_1;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t imm_inv_key;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x28.15 */
	 u_int16_t application_info;
	/* Description - when application=tag_matching: 0x1-tag consumed, 0x2-msg arrived expected, 0x3-message_arrived_unexpected, 0x4-message_arrived_no_tag, 0x5-append, 0x5-remove, 0x7-NOP, 0x8-rndv (internal!), 0x9-tag_consumed_sw_rndv, 0xa-tag_consumed_message_arrive, 0xb-tag_consumed_message_arrive_sw_rndv */
	/* 0x28.16 - 0x28.23 */
	 u_int8_t application_opcode;
	/* Description - application specific cqe: 0x1 - tag matching - valid only when QP is tag matching qp */
	/* 0x28.24 - 0x28.31 */
	 u_int8_t application;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t byte_count;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t timestamp_h;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t timestamp_l;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x38.23 */
	 u_int32_t qpn;
	/* Description -  */
	/* 0x38.24 - 0x38.31 */
	 u_int8_t swqe_opcode_drop_cntr;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x3c.0 */
	 u_int8_t owner;
	/* Description -  */
	/* 0x3c.1 - 0x3c.1 */
	 u_int8_t se;
	/* Description -  */
	/* 0x3c.2 - 0x3c.3 */
	 u_int8_t cqe_format;
	/* Description -  */
	/* 0x3c.4 - 0x3c.7 */
	 u_int8_t rwqe_opcode;
	/* Description -  */
	/* 0x3c.8 - 0x3c.15 */
	 u_int8_t signature;
	/* Description -  */
	/* 0x3c.16 - 0x3c.31 */
	 u_int16_t wqe_counter;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_grh_inline_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 u_int32_t grh_inline_data[16];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_eth_segment {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.13 */
	 u_int16_t mss;
	/* Description -  */
	/* 0x4.28 - 0x4.28 */
	 u_int8_t l3cs_inner;
	/* Description -  */
	/* 0x4.29 - 0x4.29 */
	 u_int8_t l4cs_inner;
	/* Description -  */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t l3cs;
	/* Description -  */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t l4cs;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t inline_headers;
	/* Description -  */
	/* 0xc.16 - 0xc.25 */
	 u_int16_t inline_header_size;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_wqe_inline_header {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.9 */
	 u_int16_t byte_count;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t wqe_inline;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_gather_scatter_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.30 */
	 u_int32_t byte_count;
	/* Description -  */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t wqe_inline;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t local_key;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t local_address_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t local_address_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_srq_next {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t next_wqe_index;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.24 - 0x4.31 */
	 u_int8_t signature;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_signature {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.24 - 0x4.31 */
	 u_int8_t signature;
};

/* Description -   */
/* Size in bytes - 256 */
union connectib_wqe_extended_atomic_fetch_add {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_wqe_extended_atomic_fetch_add_4byte byte4;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_wqe_extended_atomic_fetch_add_8byte byte8;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_wqe_extended_atomic_fetch_add_16byte byte16;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_wqe_extended_atomic_fetch_add_32byte byte32;
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_wqe_extended_atomic_fetch_add_64byte byte64;
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_wqe_extended_atomic_fetch_add_128byte byte128;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_atomic_fetch_add {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t add_data_63_32;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t add_data_31_0;
};

/* Description -   */
/* Size in bytes - 512 */
union connectib_wqe_extended_atomic_cmp_swap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_wqe_extended_atomic_cmp_swap_4byte byte4;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_wqe_extended_atomic_cmp_swap_8byte byte8;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_wqe_extended_atomic_cmp_swap_16byte byte16;
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_wqe_extended_atomic_cmp_swap_32byte byte32;
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_wqe_extended_atomic_cmp_swap_64byte byte64;
	/* Description -  */
	/* 0x0.0 - 0x200.31 */
	 struct connectib_wqe_extended_atomic_cmp_swap_128byte byte126;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_atomic_cmp_swap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t swap_data_63_32;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t swap_data_31_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t compare_data_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t compare_data_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_rdma_read {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 u_int64_t remote_va;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t remote_key;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_wqe_address_vector_ext {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t auto_1;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.0 */
	 u_int8_t auto_2;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.7 */
	 u_int8_t hop_limit;
	/* Description -  */
	/* 0x8.8 - 0x8.15 */
	 u_int8_t tclass;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.19 */
	 u_int32_t flow_label;
	/* Description -  */
	/* 0xc.20 - 0xc.27 */
	 u_int8_t my_gid_index1;
	/* Description -  */
	/* 0xc.30 - 0xc.30 */
	 u_int8_t grh;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t rgid_127_96;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t rgid_95_64;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t rgid_63_32;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t rgid_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_address_vector_basic {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t dca_key_63_32_qkey;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t dca_key_31_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t destination_qp_dct;
	/* Description - Used only in DC. Sent in "Connect" packet. */
	/* 0x8.24 - 0x8.27 */
	 u_int8_t reverse_sl;
	/* Description - Ext=1:AV global extension exist. Ext=0:AV global extension doesn't exist. */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t ext;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t rlid_15_0;
	/* Description -  */
	/* 0xc.16 - 0xc.23 */
	 u_int8_t slid;
	/* Description -  */
	/* 0xc.24 - 0xc.27 */
	 u_int8_t sl;
	/* Description -  */
	/* 0xc.28 - 0xc.31 */
	 u_int8_t static_rate;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_xrc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t xrc;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_mlx {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.16 - 0x4.19 */
	 u_int8_t sl;
	/* Description -  */
	/* 0x4.20 - 0x4.23 */
	 u_int8_t static_rate;
	/* Description - Force loopback
0-packet is sent to loopback\serdes according to Loopback Resolution
1-packet is sent to loopback only (used for opening QP's between application on the same guest before SM gives the link layer the LID) */
	/* 0x4.26 - 0x4.26 */
	 u_int8_t fl;
	/* Description - 1 - Don't add ICRC (raw packet, or ICRC calculated by driver)
0 - Replace last DW with ICRC */
	/* 0x4.27 - 0x4.27 */
	 u_int8_t ic;
	/* Description -  */
	/* 0x4.28 - 0x4.28 */
	 u_int8_t fc;
	/* Description - SLID MSB taken from:
0-(PortInfo - Per GVMI,Port)
1-packetSLID MSB taken from:
0-(PortInfo - Per GVMI,Port)
1-packet */
	/* 0x4.29 - 0x4.29 */
	 u_int8_t slr;
	/* Description -  */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t vl15;
	/* Description - When set VLAN should 
be transmitted with VLAN.
(Inserted if no vlan in the packet/ replaced by WQE.VLAN if vlan exists)


Ethertype is a configuration.
VLAN_ID is located in VLAN */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t v;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0x8.15 */
	 u_int16_t dmac_dlid_47_32;
	/* Description - VLAN to add to the packet. */
	/* 0x8.16 - 0x8.31 */
	 u_int16_t vlan;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t dmac_dlid_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.7 */
	 u_int8_t opcode;
	/* Description -  */
	/* 0x0.8 - 0x0.23 */
	 u_int16_t wqe_index;
	/* Description -  */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t opc_mod;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - WQE size in octwords (16 byte)
needed only for gather list size
valid values: 1-63 */
	/* 0x4.0 - 0x4.5 */
	 u_int8_t ds;
	/* Description -  */
	/* 0x4.8 - 0x4.31 */
	 u_int32_t qpn;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - interrupt bit */
	/* 0x8.0 - 0x8.0 */
	 u_int8_t interrupt;
	/* Description - solicited event  */
	/* 0x8.1 - 0x8.1 */
	 u_int8_t se;
	/* Description - CQE and EQE control
00 - generate CQE only on error WQE completion. (note - per IB spec, if completion with error, generate event)
01 - No CQE, No EQE (even on error)
10 - Gen CQE on WQE completion (good or bad)
11 - Gen CQE and EQE (loccal Solicited event).
 */
	/* 0x8.2 - 0x8.3 */
	 u_int8_t ce;
	/* Description - nop bit
no supported in golan
 */
	/* 0x8.4 - 0x8.4 */
	 u_int8_t nop;
	/* Description - fence mode
000 - No Fence
001 - Initiator Small Fence.
Wait as long as there are WQEs that are currently locally in execution (doing gather / memop etc.)
010 - Fence - the WQE will start execution only after all previous Read/Atomic WQEs complete.
011 - Strong Ordering - when set, the WQE will be executed only after all previous WQEs have been executed. Can be set for RC WQEs only. .
100 - Fence and Initiator Small Fence.
101-111 - reserved */
	/* 0x8.5 - 0x8.7 */
	 u_int8_t fm;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t immediate_invalidation_key;
};

/* Description -   */
/* Size in bytes - 2304 */
struct connectib_public_keys {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x900.31 */
	 struct connectib_file_public_keys file_public_keys[8];
};

/* Description -   */
/* Size in bytes - 320 */
struct connectib_image_signature {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - time based UUID for this signature */
	/* 0x0.0 - 0x10.31 */
	 u_int32_t signature_uuid[4];
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The UUID of the keypair used for signing this file */
	/* 0x10.0 - 0x20.31 */
	 u_int32_t keypair_uuid[4];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - The signature itself */
	/* 0x20.0 - 0x120.31 */
	 u_int32_t signature[64];
};

/* Description -   */
/* Size in bytes - 65536 */
struct connectib_nv_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_nv_config_header header;
};

/* Description -   */
/* Size in bytes - 320 */
struct connectib_hw_boot_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Address on flash of manufacturing info */
	/* 0x0.0 - 0x0.23 */
	 u_int32_t manufacture_info_address;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Address on flash of read only manufacturing info */
	/* 0x4.0 - 0x4.23 */
	 u_int32_t ro_manufacture_info_address;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Address on flash of VPD info, copy 1 */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t vpd_info_address_1;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Address on flash  of VPD info, copy 2 */
	/* 0xc.0 - 0xc.23 */
	 u_int32_t vpd_info_address_2;
	/* Description - True if the nic hac a circuitry that can indicate when the device is working on AUX power */
	/* 0xc.24 - 0xc.24 */
	 u_int8_t aux_power_indication_gpio_en;
	/* Description - Offset of Aux power indication GPIO */
	/* 0xc.25 - 0xc.31 */
	 u_int8_t aux_power_indication_gpio_offset;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Describes info about the vpd */
	/* 0x10.0 - 0x18.31 */
	 struct connectib_vpd_eeprom_info vpd_eeprom;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - used to enable hw tracer for code coverage */
	/* 0x18.0 - 0x20.31 */
	 struct connectib_code_coverage_control code_coverage;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0xe0.31 */
	 struct connectib_pcie_cfg_golan pcie_cfg;
/*---------------- DWORD[56] (Offset 0xe0) ----------------*/
	/* Description -  */
	/* 0xe0.0 - 0x100.31 */
	 struct connectib_fw_image fw_image;
};

/* Description -   */
/* Size in bytes - 2816 */
struct connectib_hw_main_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x700.31 */
	 struct connectib_port_serdes ports_serdes;
/*---------------- DWORD[448] (Offset 0x700) ----------------*/
	/* Description -  */
	/* 0x700.0 - 0x710.31 */
	 struct connectib_power power;
/*---------------- DWORD[452] (Offset 0x710) ----------------*/
	/* Description -  */
	/* 0x710.0 - 0x714.31 */
	 struct connectib_system_mng system_mng;
/*---------------- DWORD[453] (Offset 0x714) ----------------*/
	/* Description -  */
	/* 0x714.0 - 0x71c.31 */
	 struct connectib_thermal_config_golan thermal;
/*---------------- DWORD[480] (Offset 0x780) ----------------*/
	/* Description -  */
	/* 0x780.0 - 0x788.31 */
	 struct connectib_module_config module;
/*---------------- DWORD[482] (Offset 0x788) ----------------*/
	/* Description - Board I2C information */
	/* 0x788.0 - 0x7d8.31 */
	 struct connectib_i2c_devices_db i2c;
/*---------------- DWORD[502] (Offset 0x7d8) ----------------*/
	/* Description - Board GPIO information */
	/* 0x7d8.0 - 0x85c.31 */
	 struct connectib_ini_gpios_golan gpios;
};

/* Description -   */
/* Size in bytes - 1216 */
struct connectib_fw_boot_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_FW_VERSION fw_version;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - All multi_function pconfigurable parameters */
	/* 0x10.0 - 0x1c.31 */
	 struct connectib_multi_function multi_function;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - All Transaction Layer flags */
	/* 0x1c.0 - 0x24.31 */
	 struct connectib_pcie_transaction pcie_transaction;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - PCIe cfg space data */
	/* 0x24.0 - 0x224.31 */
	 struct connectib_pci_cfg pcie_cfg_data;
/*---------------- DWORD[137] (Offset 0x224) ----------------*/
	/* Description - PCIe cfg space for masking */
	/* 0x224.0 - 0x424.31 */
	 struct connectib_pci_cfg pcie_cfg_mask;
/*---------------- DWORD[265] (Offset 0x424) ----------------*/
	/* Description - PF/SR pciex data */
	/* 0x424.0 - 0x440.31 */
	 struct connectib_pf_vf_cfg_space pf_vf_cfg_data;
/*---------------- DWORD[272] (Offset 0x440) ----------------*/
	/* Description - power management (L1) configuration */
	/* 0x440.0 - 0x444.31 */
	 struct connectib_pcie_power_management pcie_power_management;
/*---------------- DWORD[273] (Offset 0x444) ----------------*/
	/* Description - data later to be overridden by NV config */
	/* 0x444.0 - 0x484.31 */
	 struct connectib_nv_config_boot nv_config;
};

/* Description -   */
/* Size in bytes - 4096 */
struct connectib_fw_main_config {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x4.2 */
	 u_int8_t log_max_num_rdbs;
	/* Description - size is 2^(value): 6-64B, 7- reserverd. A value > 5 causes extended RDBs to be mapped and increases memory consumption */
	/* 0x4.4 - 0x4.7 */
	 u_int8_t log_max_atomic_size;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x20.31 */
	 struct connectib_static_config static_config;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0xc0.31 */
	 struct connectib_leds_blink_patterns leds_blink_pattern;
/*---------------- DWORD[48] (Offset 0xc0) ----------------*/
	/* Description -  */
	/* 0xc0.0 - 0x100.31 */
	 struct connectib_customization customization;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 0x100.0 - 0x280.31 */
	 struct connectib_management management;
/*---------------- DWORD[160] (Offset 0x280) ----------------*/
	/* Description -  */
	/* 0x280.0 - 0x300.31 */
	 struct connectib_host_management host_management;
/*---------------- DWORD[192] (Offset 0x300) ----------------*/
	/* Description -  */
	/* 0x300.0 - 0x5d0.31 */
	 struct connectib_phy_fw_main_config phy_fw_main_config;
/*---------------- DWORD[372] (Offset 0x5d0) ----------------*/
	/* Description - data later to be overridden ny NV config */
	/* 0x5d0.0 - 0x8d0.31 */
	 struct connectib_nv_config_main nv_config;
/*---------------- DWORD[628] (Offset 0x9d0) ----------------*/
	/* Description -  */
	/* 0x9d0.0 - 0x9d8.31 */
	 struct connectib_secure_fw secure_fw;
};

/* Description -   */
/* Size in bytes - 320 */
struct connectib_mfg_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.24 - 0x10.23 */
	 char psid[17];
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - When this bit is set, the GUIDs should be taken from the device_info node.
When this bit is cleared, the GUIDs should be taken from the mfg_info node. */
	/* 0x1c.0 - 0x1c.0 */
	 u_int8_t guids_override_en;
	/* Description - MFG_INFO section minor version */
	/* 0x1c.16 - 0x1c.23 */
	 u_int8_t minor_version;
	/* Description - MFG_INFO section major version */
	/* 0x1c.24 - 0x1c.31 */
	 u_int8_t major_version;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x60.31 */
	 struct connectib_guids guids;
};

/* Description -   */
/* Size in bytes - 1024 */
struct connectib_image_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - OEM lifecycle NVCONFIG files are signed */
	/* 0x0.9 - 0x0.9 */
	 u_int8_t signed_vendor_nvconfig_files;
	/* Description - Mellanox lifecycle NVCONFIG files are signed */
	/* 0x0.10 - 0x0.10 */
	 u_int8_t signed_mlnx_nvconfig_files;
	/* Description - Factory re-customizationflow is supported */
	/* 0x0.11 - 0x0.11 */
	 u_int8_t frc_supported;
	/* Description - Customer Support Tokens are supported */
	/* 0x0.12 - 0x0.12 */
	 u_int8_t cs_tokens_supported;
	/* Description - This is a debug firmware */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t debug_fw;
	/* Description - [MCC/MCDA flow] if set, the SHA 256 digest is encrypted - enabled by default for secure_fw - cr-space not closed */
	/* 0x0.14 - 0x0.14 */
	 u_int8_t signed_fw;
	/* Description - [MCC/MCDA flow] cr-space closed */
	/* 0x0.15 - 0x0.15 */
	 u_int8_t secured_fw;
	/* Description - IMAGE_INFO section minor version */
	/* 0x0.16 - 0x0.23 */
	 u_int8_t minor_version;
	/* Description - IMAGE_INFO section major version */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t major_version;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x14.31 */
	 struct connectib_FW_VERSION FW_VERSION;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x1c.31 */
	 struct connectib_TRIPPLE_VERSION mic_version;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.24 - 0x34.23 */
	 char psid[17];
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x34.15 */
	 u_int16_t vsd_vendor_id;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.24 - 0x108.23 */
	 char vsd[209];
/*---------------- DWORD[66] (Offset 0x108) ----------------*/
	/* Description - image size parameters */
	/* 0x108.0 - 0x110.31 */
	 struct connectib_image_size image_size;
/*---------------- DWORD[70] (Offset 0x118) ----------------*/
	/* Description - HW device(s) supported by this FW image.
0 means invalid entry.
For Golan A0, first entry should be 0x1ff
 */
	/* 0x118.0 - 0x128.31 */
	 u_int32_t supported_hw_id[4];
/*---------------- DWORD[74] (Offset 0x128) ----------------*/
	/* Description -  */
	/* 0x128.0 - 0x12c.31 */
	 u_int32_t ini_file_num;
/*---------------- DWORD[112] (Offset 0x1c0) ----------------*/
	/* Description - Product Version is the unified version of the FW and expansion ROM.
Format is defined by the packager.
When set to a non-empty string the FW update tool burns the image as a monolythic entity and refuses to update rom only or FW only. */
	/* 0x1c0.24 - 0x1d0.23 */
	 char prod_ver[17];
/*---------------- DWORD[192] (Offset 0x300) ----------------*/
	/* Description -  */
	/* 0x300.0 - 0x340.31 */
	 struct connectib_module_versions module_versions;
/*---------------- DWORD[208] (Offset 0x340) ----------------*/
	/* Description -  */
	/* 0x340.24 - 0x34c.23 */
	 char spare_part[13];
/*---------------- DWORD[211] (Offset 0x34c) ----------------*/
	/* Description -  */
	/* 0x34c.24 - 0x364.23 */
	 char product_id[25];
};

/* Description -   */
/* Size in bytes - 512 */
struct connectib_device_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t signature0;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t signature1;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t signature2;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t signature3;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Format version for this struct */
	/* 0x10.0 - 0x10.7 */
	 u_int8_t minor_version;
	/* Description - Format version for this struct */
	/* 0x10.8 - 0x10.16 */
	 u_int16_t major_version;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x60.31 */
	 struct connectib_guids guids;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description -  */
	/* 0x6c.0 - 0x6c.15 */
	 u_int16_t vsd_vendor_id;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description -  */
	/* 0x70.24 - 0x140.23 */
	 char vsd[209];
/*---------------- DWORD[88] (Offset 0x160) ----------------*/
	/* Description -  */
	/* 0x160.0 - 0x1a0.31 */
	 struct connectib_operation_key keys[4];
};

/* Description -   */
/* Size in bytes - 256 */
union connectib_dtoc_pointers {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_toc_data device_info_0;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_toc_data nv_data_0;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_toc_data nv_data_1;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_toc_data fw_nv_log;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_toc_data mfg_info;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_reset_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability mask for reset database */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_reset_capabilities rst_cap_mask;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - versions for data structures that need to be maintained acrros different reset levels */
	/* 0x10.0 - 0x90.31 */
	 struct connectib_rst_api_ver rst_api_ver;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_boot_record_golan {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - SPI clock frequenct equal = E1ClockFreq / (2*(n+1))
where n is is value of this register */
	/* 0x0.0 - 0x0.3 */
	 u_int8_t flash_div;
	/* Description - Set default to 0 (hot_reset request from px will be ignored) as WA for HW BUG #170316 (serdes power toggles during reset from px). */
	/* 0x0.4 - 0x0.4 */
	 u_int8_t hot_reset_enable;
	/* Description - after pll stabilization (timer), the boot machine will wait till core pll lock indication before continuing */
	/* 0x0.5 - 0x0.5 */
	 u_int8_t wait_lock;
	/* Description - 0 - disable.
1 - iopx will be powered down while perst is asserted.
2 - all_reset will be triggered upon perst change. */
	/* 0x0.6 - 0x0.7 */
	 u_int8_t perst_action;
	/* Description - CoreFreq = PadFreq * 2(F+1) / ((R+1)*(2^OD)) */
	/* 0x0.8 - 0x0.14 */
	 u_int8_t core_f;
	/* Description - core PLL PowerDown */
	/* 0x0.16 - 0x0.16 */
	 u_int8_t core_pd;
	/* Description -  */
	/* 0x0.17 - 0x0.18 */
	 u_int8_t core_od;
	/* Description -  */
	/* 0x0.19 - 0x0.23 */
	 u_int8_t core_r;
	/* Description - Core PLL bypass.
When set, pad and core clock are the same.

default is 0 */
	/* 0x0.24 - 0x0.24 */
	 u_int8_t core_bypass;
	/* Description - When set, core PLL input comes from PCIe ref clock.
When cleared, core PLL input comes from CCLK pad.

For live-fish, PCIe clock is used, and we are confident 
that the clock used will be 100MHz thus we can set default 
value to the PLL.

On functional mode, this bit is taken from flash with the 
correctPLL parameters thus any oscillator can be used 
for CCLK */
	/* 0x0.25 - 0x0.25 */
	 u_int8_t core_from_pex;
	/* Description - Reserved for parity bit from the flash */
	/* 0x0.31 - 0x0.31 */
	 u_int8_t parity_reserved0;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Bit per thermal diode, when one of the termal diodes is too hot and masked, the GPIO will be set.
bit[0]: A2D in Iopx (px)
bit[1]: A2D in Iop
bit[2]: A2D in Yu
 */
	/* 0x4.14 - 0x4.16 */
	 u_int8_t temp_gpio_mask;
	/* Description - Bit per thermal diode, when one of the termal diodes is too hot and masked, chip will enter FATAL.
bit[0]: A2D in Iopx (px)
bit[1]: A2D in Iop
bit[2]: A2D in Yu */
	/* 0x4.18 - 0x4.20 */
	 u_int8_t temp_fatal_mask;
	/* Description - bit[0] gpio weak pull (up/down) enable together with gpio_pull_enable
bit[1] jtag weak pull up/down enable */
	/* 0x4.22 - 0x4.23 */
	 u_int8_t gpio_pull_en;
	/* Description - //Choose which PLL to debug: lock on GPIO21 and clock on GPIO22
//[3:0] debug_pll_id
// 0-0000 - the PAD are controled by the regular GPIO logic
// 1-0001 - iop0 clock 0
// 2-0010 - iop0 clock 1
// 3-0011 - iop0 clock 3
// 4-0100 - iop0 clock 2
// 5-0101 - iop1 clock 0 (NA)
// 6-0110 - iop1 clock 1 (NA)
// 7-0111 - iop1 clock 3 (NA)
// 8-1000 - iop1 clock 2 (NA)
// 9-1001 - iotg clock 0
//10-1010 - iotg clock 1
//11-1011  -pll input pin : FIN 
//12-1100 - pll output pin : FOUT 
//13-1101 - i1clk //same clock which go to the core
//14-1110 - pll2 output pin : FOUT (i2clk) (NA)
//15-1111 - muxed_clock before the bypass muxes (NA)


//[6:4] debug_pll_id
//000 - div by 1
//001 - div by 2
//010 - div by 4
//011 - div by 8 
//100- div by 16
//101- div by 64
//110 - div by 128
//111 - div by 256
 */
	/* 0x4.24 - 0x4.30 */
	 u_int8_t pll_debug;
	/* Description - Reserved for parity bit from the flash */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t parity_reserved1;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 2^mbist_group_size wrappers will run simultaniously
values 15-9 are reserved - does not work */
	/* 0x8.0 - 0x8.3 */
	 u_int8_t mbist_group_size;
	/* Description - 2^mbist_unit_size units will run simultaniously */
	/* 0x8.4 - 0x8.6 */
	 u_int8_t mbist_unit_size;
	/* Description - Enable MBIST run */
	/* 0x8.8 - 0x8.8 */
	 u_int8_t mbist_en;
	/* Description - adds (2^x - 1) relax cycles between captures of different units */
	/* 0x8.13 - 0x8.15 */
	 u_int8_t lbist_capture_delay;
	/* Description -  */
	/* 0x8.16 - 0x8.22 */
	 u_int8_t i2c_slave_addr;
	/* Description - i2c slave enable */
	/* 0x8.23 - 0x8.23 */
	 u_int8_t i2c_slave_en;
	/* Description - value 0 will disabe yu_fuse read/write requests to reach the fuse (in case Fuse is malfunctioning).
upon reads, data recieved will be hard wired zeros.
upon write, efuse_done will rise after 1 cycle. */
	/* 0x8.24 - 0x8.24 */
	 u_int8_t fuse_enable;
	/* Description - the boot machine will wait 2^(this value) e1clk
need to wait for 200us between power_down fall and pxp.port_state move to detect
With clock of 156.25Mhz this gives = 31,250 clocks ~ 2^15
With clock of 78.125Mhz this will give = 400us (which is much less than PCIe constrain of 20ms)

As a margin we config to 0x11 (1.6ms with 78.125Mhz oscilator)
 */
	/* 0x8.26 - 0x8.30 */
	 u_int8_t pll_stabilize;
	/* Description - Reserved for parity bit from the flash */
	/* 0x8.31 - 0x8.31 */
	 u_int8_t parity_reserved2;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - logic bist pattern count (LSB)
MSB is in the extended boot record
When {MSB,LSB}=0 lbist will run 2^32 patterns */
	/* 0xc.0 - 0xc.15 */
	 u_int16_t lbist_pat_cnt_lsb;
	/* Description - value is the number of captures per pattern
value=0 means no capture state at all.
last pattern is controled by lbist_capture_last */
	/* 0xc.19 - 0xc.21 */
	 u_int8_t lbist_capture;
	/* Description - at each capture 2 selected units work together for gaining full chip coverage */
	/* 0xc.22 - 0xc.22 */
	 u_int8_t lbist_capt_2;
	/* Description - shift cycle every corepll clocks:
f = 2^x (f = 1,2,4,8,..,128)
0-1, 1-2, 2-4, 3-8... */
	/* 0xc.23 - 0xc.25 */
	 u_int8_t lbist_shift_clk_divider;
	/* Description - same as lbist_capture but only for the last pattern, part of the stop function.
value must be > 0 */
	/* 0xc.27 - 0xc.29 */
	 u_int8_t lbist_capture_last;
	/* Description - Logic BIST enable */
	/* 0xc.30 - 0xc.30 */
	 u_int8_t lbist_en;
	/* Description - Reserved for parity bit from the flash */
	/* 0xc.31 - 0xc.31 */
	 u_int8_t parity_reserved3;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_ctrl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Protection against accidently writing to contexts
To enable write 0xBADC0FFE */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t destructive_op_unlock;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - from the function */
	/* 0x4.0 - 0x4.15 */
	 u_int16_t gvmi;
	/* Description - when set limited icmd are supported */
	/* 0x4.16 - 0x4.16 */
	 u_int8_t public_icmd;
	/* Description - for commands with state machines */
	/* 0x4.24 - 0x4.31 */
	 u_int8_t state;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - external syndrome (cmdif syndrom for cmd_access_reg command) */
	/* 0x8.0 - 0x8.23 */
	 u_int32_t syndrome;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - set by user, cleared by firmware */
	/* 0xc.0 - 0xc.0 */
	 u_int8_t busy;
	/* Description -  0x00 OK
 0x01 INVALID_OPCODE
 0x02 INVALID_CMD
 0x03 OPERATIONAL_ERROR
 0x04 BAD_PARAM
 0x05 BUSY */
	/* 0xc.8 - 0xc.15 */
	 u_int8_t status;
	/* Description -     0x1000 = ICMD_OPCODE_MNG_MMINIT
  0x1001 = ICMD_OPCODE_MNG_GPIO_FUNC
  0x2000 = ICMD_OPCODE_PRE_DEFINE_MODULE_DB
  0x2800 = ICMD_OPCODE_GET_FW_DRIVER_VERSION
  0x2801 = ICMD_OPCODE_OCBB_RNDC_GET_CORE_API
  0x2802 = ICMD_OPCODE_OCBB_GET_PCI_API
  0x2803 = ICMD_OPCODE_READ_NCSI_RDMA_COUNTERS
  0x2804 = ICMD_OPCODE_CABLE_ERROR_GEN_EVENT
  0x2805 = ICMD_OPCODE_LED_CMD
  0x2806 = ICMD_READ_ICMC_TAGS_AND_INFO
  0x2807 = ICMD_OPCODE_OVONEL_MNG_INITIAL_CMD
  0x2810 = ICMD_OPCODE_LED_CONTROL_MAD
  0x2811 = ICMD_OPCODE_TEMP_WARN_GEN_EVENT
  0x2812 = ICMD_OPCODE_ENABLE_DISABLE_PORT
  0x2814 = ICMD_OPCODE_ASN1_FORCE_PORT_STATE
  0x2815 = ICMD_OPCODE_SET_STEERING_LOOPBACK
  0x2816 = ICMD_OPCODE_DROP_COUNTER_READ
  0x2817 = ICMD_OPCODE_PORT_ADMIN_STATE_MNG
  0x2820 = ICMD_OPCODE_INTERNAL_QUERY_CAP
  0x2821 = ICMD_OPCODE_ALLOWED_PFS_MADIFC
  0x2823 = ICMD_OPCODE_SYSPORT
  0x6001 = ICMD_OPCODE_PHY_UC_DO_CONTINUE
  0x6002 = ICMD_OPCODE_PHY_UC_DO_STEP
  0x6003 = ICMD_OPCODE_PHY_UC_SET_DEL_BP
  0x6004 = ICMD_OPCODE_PHY_UC_SET_GET_DATA
  0x6005 = ICMD_OPCODE_PHY_UC_GET_ARRAY_PROP
  0x6006 = ICMD_OPCODE_PHY_UC_GET_STATUS
  0x6007 = ICMD_OPCODE_PHY_ACTIVATE_RX_ADAP
  0x6008 = ICMD_OPCODE_PHY_UC_SET_GET_DATA_FIELD
  0x6009 = ICMD_OPCODE_PHY_UC_ACTIVATE_UC
  0x600b = ICMD_OPCODE_PHY_GET_LINK_STATUS
  0x600c = ICMD_OPCODE_PHY_OPEN_CLOSE_PORT
  0x600d = ICMD_OPCODE_PHY_PLL_VARACTOR_CALIB
  0x600e = ICMD_OPCODE_PHY_HALT_FSM
  0x600f = ICMD_OPCODE_PHY_SET_GET_TX_SD
  0x6010 = ICMD_OPCODE_PHY_SET_GET_RX_SD
  0x6011 = ICMD_OPCODE_PHY_TRANS_OR_SYNC
  0x6013 = ICMD_OPCODE_PHY_GET_CLEAR_COUNTERS
  0x6014 = ICMD_OPCODE_PHY_UPDATE_CALIB_VALS
  0x6015 = ICMD_OPCODE_PHY_GET_GRADE_INFO
  0x6016 = ICMD_OPCODE_PHY_SET_GET_PTAS
  0x6017 = ICMD_OPCODE_PHY_GET_PPAMP
  0x6018 = ICMD_OPCODE_PHY_GET_PPLL
  0x6019 = ICMD_OPCODE_PHY_GET_PDDR
  0x601a = ICMD_OPCODE_PHY_RUN_HYB_EYE_OPENER
  0x601b = ICMD_OPCODE_PHY_DESIGN_VER_IF
  0x601c = ICMD_OPCODE_RESTORE_PHY_REGISTERS
  0x601d = ICMD_OPCODE_PHY_MEASURE_FREQUENCY
  0x601e = ICMD_OPCODE_PHY_ACTIVATE_PLL
  0x8000 = ACCESS_ICM_LINE
  0x8001 = ACCESS_ICM_CTX
  0x8002 = ACCESS_HOST_MEM
  0x8003 = READ_Q_ENTRY
  0x8004 = GET_IRISC_HEAR_BEAT
  0x8005 = GET_BOOT_STAGE
  0x8006 = GET_LINK_LEDS
  0x8007 = GET_FW_VERSION
  0x8008 = READ_RX_SLICE_PACKET
  0x8009 = READ_G_RSE_SLICE_DESC
  0x8010 = READ_SX_WQ_BUFFER
  0x8011 = READ_ICM_TLB_LINE
  0x8012 = READ_ICM_DUMMY_ADDRESS
  0x8013 = DEBUG_FW_TRACER
  0x8014 = CABLE_PLUG_OUT_IN
  0x8015 = GET_ICM_RES_PROP
  0x8017 = GET_ICM_CTX_ADDR
  0x8018 = CHECK_SQPC_STATUS
  0x8019 = ALLOC_DEALLOC_RESOURCE
  0x801a = LOCK_UNLOCK
  0x801b = ICMD_DB_RECOVERY
  0x801c = ICMD_READ_ICMC_TAG
  0x8020 = ICMD_RW_GVMIX
  0x8021 = ICMD_ICMC_LOCKED_HISTOGRAM
  0x8022 = ICMD_DC_CONFIG
  0x8023 = ICMD_OPCODE_PUSH_DB
  0x8024 = GET_OPEN_RESOURCES
  0x8025 = RW_ESW
  0x8026 = ACCESS_REG_PMTU
  0x8027 = ICMD_OPCODE_ACCESS_REGISTER_PAOS
  0x8028 = ACCESS_REG_PPCNT
  0x8029 = ACCESS_REG_PTYS
  0x8030 = ICMD_OPCODE_ACCESS_REGISTER_SLRP
  0x8031 = ICMD_OPCODE_ACCESS_REGISTER_SLTP
  0x8032 = ICMD_OPCODE_ACCESS_REGISTER_SLRG
  0x8033 = ICMD_OPCODE_ACCESS_REGISTER_PTAS
  0x8034 = ICMD_OPCODE_ACCESS_REGISTER_PPAMP
  0x8035 = ICMD_OPCODE_ACCESS_REGISTER_PPLR
  0x8036 = ICMD_OPCODE_ACCESS_REGISTER_PLPC
  0x8037 = ICMD_OPCODE_ACCESS_REGISTER_PPLM
  0x8038 = ICMD_OPCODE_ACCESS_REGISTER_PPTT
  0x8039 = ICMD_OPCODE_ACCESS_REGISTER_PPRT
  0x8040 = ICMD_OPCODE_ACCESS_REGISTER_PPAOS
  0x802a = ACCESS_REG_PVLC
  0x8100 = DEBUG_PRINT_ICM
  0x8101 = GET_HEADER_CAPTURE
  0x8200 = ICMD_OPCODE_SET_GET_PORT_CNTR
  0x8201 = ICMD_OPCODE_GET_PF_CTX
  0x8202 = GET_PI_CI
  0x8300 = GET_FT_LIST
  0x8301 = GET_FT_INFO
  0x8302 = GET_FG_LIST
  0x8303 = GET_FG
  0x8304 = GET_FTE_LIST
  0x8305 = GET_FTE
  0x8306 = GET_STE_OPEN_RESOURCES
  0x8307 = GET_STE_RESOURCES_LIST
  0x8308 = READ_STE
  0x8309 = GET_STEERING_INFO
  0x830a = PARSE_ICM_ADDRESS
  0x830b = ICMD_OPCODE_DEBUG_LLDP
  0x830c = ICMD_OPCODE_GET_SET_LLDP_TLV
  0x830d = ICMD_OPCODE_DEBUG_MCTP_VND_PCI
  0x830e = ICMD_OPCODE_EXECUTE_FW_LOG
  0x830f = ICMD_OPCODE_PACKET_DROP
  0x8310 = GET_HIGHEST_INDEX
  0x8400 = ICMD_QUERY_CAPABILITIES
  0x8401 = ICMD_KDNET_CTRL
  0x8402 = ICMD_OPCODE_MH_SYNC
  0x8403 = ICMD_OPCODE_MH_SYNC_STATUS
  0x9001 = ICMD_ACCESS_REGISTER
  0x9002 = ICMD_OPCODE_NVCONF_RW_TLV_DEBUG
  0x9003 = ICMD_OPCODE_QUERY_VIRTUAL_MAC
  0x9004 = ICMD_OPCODE_SET_VIRTUAL_MAC
  0x9005 = ICMD_QUERY_WOL_ROL
  0x9006 = ICMD_SET_WOL_ROL
  0x9007 = ICMD_OCBB_INIT
  0x9008 = ICMD_OCBB_QUERY_HEADER_STATUS
  0x9009 = ICMD_OCBB_QUERY_ETOC_STATUS
  0x900a = ICMD_OCBB_SET_EVENT
  0x902b = ICMD_OPCODE_ACCESS_REGISTER_MLCR
  0xa000 = FW_SW_RESET
  0xb000 = READ_COMMAND
  0xa004 = ICMD_OPCODE_PMAOS_WRITE
  0xa005 = ICMD_OPCODE_PMAOS_QUERY
  0xa008 = ICMD_OPCODE_MNG_EMAD_MCIA
  0xc000 = READ_EQ4TYPE
  0xc001 = READ_SPECIAL_QPS
  0xc002 = SET_PORT_SNIFFER
  0xc003 = GET_PORT_SNIFFER
  0xc004 = ICMD_OPCODE_WRITE_CC_LOG
  0xc005 = ICMD_OPCODE_CONFIG_CC
  0xc006 = ICMD_OPCODE_WRITE_DC_CNAK_LID
  0xc007 = ICMD_OPCODE_UPDATE_RQ_CI
  0xc008 = ICMD_OPCODE_UD_TO_RAW
  0xf000 = ICMD_OPCODE_PHY_NEGO_CTRL
  0xf001 = ICMD_OPCODE_EYE_OPENER_READ
  0xf002 = CLEAR_RXT_CHK_CAUSES
  0xf003 = SET_ITRACE
  0xf004 = ICMD_OPCODE_INIT_OCSD
  0xf005 = ICMD_OPCODE_PHY_VER_OVERWRITE
  0xf006 = ICMD_OPCODE_PCIE_TOOLS_POINTERS
  0xf007 = ICMD_OPCODE_CODE_COVERAGE
  0xf008 = ICMD_OPCODE_CODE_COVERAGE_READ
  0xf009 = ICMD_OPCODE_PCIE_VER_DATA
  0xf00a = ICMD_OPCODE_VER_DATA
  0xf00b = ICMD_STOP_TOGGLER
  0xf00c = ICMD_ERROR_FLOW_TRIGGER
  0xf010 = ICMD_OPCODE_GREPPER
  0xf011 = ICMD_OPCODE_STANDBY
  0xf012 = ICMD_OPCODE_FLR_DEBUG
  0xf013 = ICMD_OPCODE_DCR_LL_TRVRS
  0xf014 = ICMD_OPCODE_NEXT_DCR
  0xf015 = ICMD_OPCODE_GENERAL_FAULT_INJECTOR
  0xf016 = ICMD_OPCODE_ACCESS_STEERING_ROOT
  0xf017 = ICMD_OPCODE_GET_STEERING_TABLE_INFO
  0xf018 = ICMD_OPCODE_GET_GVMI_VIA_VSEC
  0xf019 = ICMD_OPCODE_XPORT_CONFIG
  0xf01a = ICMD_OPCODE_MINI_FLOW_ACTIVATOR
  0xf01b = ICMD_OPCODE_ENABLE_TOOLPF
  0xf01c = ICMD_OPCODE_SET_TOOLPF_TRACER;\  0xf01d = ICMD_OPCODE_RW_GVMI_FW_CONTEXT;\  0xa100 = ICMD_OPCODE_SMBUS_MASTER_ACCESS
  0xa102 = ICMD_OPCODE_MNG_SMBUS_GW_FREQ
  0xa200 = ICMD_OPCODE_FPGA_FLEX_NIC_CTRL
  0xff59 = ICMD_OPCODE_GVMI_RL_CTX_IX
  0xff60 = ICMD_OPCODE_CABLE_INFO
  0xff61 = ICMD_OPCODE_GEN_ASSERT
  0xff62 = ICMD_OPCODE_DEBUG_PF_MAC
  0xff63 = ICMD_OPCODE_SET_OC_INT_CAUSE
  0xff65 = ICMD_OPCODE_PMLP_QUERY
  0x2808 = ICMD_OPCODE_INIT_NCSI
  0x2809 = ICMD_OPCODE_INJECT_NCSI
  0xff66 = ICMD_OPCODE_READ_WRITE_VARB_CTX
  0xff67 = ICMD_OPCODE_GET_PACKET_PACING_DEBUG_INFO
  0xff68 = ICMD_OPCODE_DEBUG_CALC_SQN
  0xff69 = ICMD_OPCODE_DETECT_GVMI */
	/* 0xc.16 - 0xc.31 */
	 u_int16_t opcode;
};

/* Description -   */
/* Size in bytes - 768 */
union connectib_icmd_cmd {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x300.31 */
	 struct connectib_icmd_cmd_as_dwords as_dwords;
	/* Description -  */
	/* 0x0.0 - 0x60.31 */
	 struct connectib_icmd_access_icm_ctx access_icm_ctx;
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_icmd_get_pi_ci get_pi_ci;
	/* Description -  */
	/* 0x0.0 - 0x50.31 */
	 struct connectib_icmd_access_icm_line access_icm_line;
	/* Description -  */
	/* 0x0.0 - 0x128.31 */
	 struct connectib_icmd_access_host_mem access_host_mem;
	/* Description -  */
	/* 0x0.0 - 0x20c.31 */
	 struct connectib_icmd_read_q_entry read_q_entry;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_icmd_get_irisc_heart_beat get_irisc_heart_beat;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_icmd_get_boot_stage get_boot_stage;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_icmd_get_link_leds get_link_leds;
	/* Description -  */
	/* 0x0.0 - 0x24.31 */
	 struct connectib_icmd_get_fw_info get_fw_info;
	/* Description -  */
	/* 0x0.0 - 0x20c.31 */
	 struct connectib_icmd_read_rx_slice_packet read_rx_slice_packet;
	/* Description -  */
	/* 0x0.0 - 0x108.31 */
	 struct connectib_icmd_read_g_rse_slice_desc read_g_rse_slice_desc;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_icmd_fw_reset fw_reset;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_icmd_allowed_madifc_on_all_pfs allowed_pfs_madifc;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_print_icm debug_print_icm;
	/* Description -  */
	/* 0x0.0 - 0xc0.31 */
	 struct connectib_icmd_header_capture header_capture;
	/* Description -  */
	/* 0x0.0 - 0x48.31 */
	 struct connectib_icmd_read_sx_wq_buffer read_sx_wq_buffer;
	/* Description -  */
	/* 0x0.0 - 0x48.31 */
	 struct connectib_icmd_access_cmdq icmd_access_cmdq;
	/* Description -  */
	/* 0x0.0 - 0x104.31 */
	 struct connectib_eqn4type eqn4type;
	/* Description -  */
	/* 0x0.0 - 0x104.31 */
	 struct connectib_icmd_special_qps special_qps;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_set_port_sniffer set_port_sniffer;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_port_sniffer get_port_sniffer;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_icmd_congestion_log congestion_log;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_icmd_write_dc_cnak_lid write_dc_cnak_lid;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_icmd_update_rq_ci update_rq_ci;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_icmd_ud_to_raw ud_to_raw;
	/* Description -  */
	/* 0x0.0 - 0x300.31 */
	 struct connectib_icmd_config_cc config_cc;
	/* Description -  */
	/* 0x0.0 - 0x50.31 */
	 struct connectib_icmd_read_icm_tlb_line read_icm_tlb_line;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_icmd_read_icm_dummy_addr read_icm_dummy_addr;
	/* Description -  */
	/* 0x0.0 - 0x300.31 */
	 struct connectib_icmd_get_open_resources get_open_resources;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_icmd_get_highest_index get_highest_index;
	/* Description -  */
	/* 0x0.0 - 0x30.31 */
	 struct connectib_icmd_debug_fw_tracer debug_fw_tracer;
	/* Description -  */
	/* 0x0.0 - 0x30.31 */
	 struct connectib_icmd_execute_fw_log execute_fw_log;
	/* Description -  */
	/* 0x0.0 - 0x200.31 */
	 struct connectib_icmd_grepper grepper;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_icmd_standby standby;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_icmd_cable_plug_out_in cable_plug_out_in;
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_icmd_cable_info cable_info;
	/* Description -  */
	/* 0x0.0 - 0x48.31 */
	 struct connectib_icmd_emad_mcia emad_mcia;
	/* Description -  */
	/* 0x0.0 - 0x24.31 */
	 struct connectib_icmd_get_icm_res_prop get_icm_res_prop;
	/* Description -  */
	/* 0x0.0 - 0x18.31 */
	 struct connectib_icmd_alloc_dealloc_resource alloc_dealloc_resource;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_eye_opening_read_st eye_opening_read;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_phy_nego_ctrl_st phy_nego_ctrl;
	/* Description -  */
	/* 0x0.0 - 0x18.31 */
	 struct connectib_icmd_get_icm_ctx_addr get_icm_ctx_addr;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 union connectib_icmd_query_capabilities query_capabilities;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_icmd_kdnet_ctrl kdnet_ctrl;
	/* Description -  */
	/* 0x0.0 - 0x128.31 */
	 struct connectib_icmd_generic_access_register access_register;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_check_sqpc_status check_sqpc_status;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_lock_unlock_resource lock_unlock_resource;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_check_sqpc_status db_recovery;
	/* Description -  */
	/* 0x0.0 - 0x50.31 */
	 struct connectib_icmd_access_icm_line read_icmc_tag;
	/* Description -  */
	/* 0x0.0 - 0x300.31 */
	 struct connectib_icmd_read_icmc_tags_and_info read_icmc_tags_and_info;
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_icmd_dc_config dc_config;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_itrace set_itrace;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_init_ncsi init_ncsi;
	/* Description -  */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_icmd_init_ocsd init_ocsd;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_icmd_phy_ver_overwrite phy_ver_overwrite;
	/* Description - pointers to some tables in pciex scratchpad, for tools usage */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_pcie_tools_pointers pcie_tools_pointers;
	/* Description -  */
	/* 0x0.0 - 0x50.31 */
	 struct connectib_icmd_gen_eqe gen_eqe;
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_icmd_rw_gvmix rw_gvmix;
	/* Description -  */
	/* 0x0.0 - 0x300.31 */
	 struct connectib_icmd_esw rw_esw;
	/* Description - used to enable/query HW tracer for code coverage */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_code_coverage_control code_coverage;
	/* Description - Read code coverage bitmask from HW buffer */
	/* 0x0.0 - 0x108.31 */
	 struct connectib_icmd_code_coverage_read code_coverage_read;
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_icmd_stop_toggler stop_toggler;
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_icmd_error_flow_trigger error_flow_trigger;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_icmd_pcie_ver_data pcie_ver_data;
	/* Description -  */
	/* 0x0.0 - 0x50.31 */
	 struct connectib_icmd_ver_data ver_data;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_icmd_push_db push_db;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_icmd_flr_debug flr_debug;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_dcr_ll_trvrs dcr_ll_trvrs;
	/* Description -  */
	/* 0x0.0 - 0x300.31 */
	 struct connectib_icmd_dcr_ll_next_dcr_list dcr_ll_next_dcr_list;
	/* Description -  */
	/* 0x0.0 - 0x44.31 */
	 struct connectib_icmd_access_steering_root access_steering_root;
	/* Description -  */
	/* 0x0.0 - 0x50.31 */
	 struct connectib_icmd_steering_table_info get_steering_table_info;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_get_gvmi_via_vsec get_gvmi_via_vsec;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_xport_xonfig xport_config;
	/* Description -  */
	/* 0x0.0 - 0x110.31 */
	 struct connectib_icmd_nvcfg_rw_tlv nv_ram_rw_tlv;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_icmd_set_toolpf_tracer set_toolpf_tracer;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_icmd_enable_tools_pf enable_tools_pf;
	/* Description -  */
	/* 0x0.0 - 0x14.31 */
	 struct connectib_icmd_access_register_paos access_register_paos;
	/* Description -  */
	/* 0x0.0 - 0x30.31 */
	 struct connectib_icmd_access_register_slrp access_register_slrp;
	/* Description -  */
	/* 0x0.0 - 0x18.31 */
	 struct connectib_icmd_access_register_sltp access_register_sltp;
	/* Description -  */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_icmd_access_register_slrg access_register_slrg;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_icmd_access_register_pptt access_register_pptt;
	/* Description -  */
	/* 0x0.0 - 0x2c.31 */
	 struct connectib_icmd_access_register_pprt access_register_pprt;
	/* Description -  */
	/* 0x0.0 - 0x14.31 */
	 struct connectib_icmd_access_register_ppaos access_register_ppaos;
	/* Description -  */
	/* 0x0.0 - 0x30.31 */
	 struct connectib_icmd_access_register_ptas access_register_ptas;
	/* Description -  */
	/* 0x0.0 - 0x30.31 */
	 struct connectib_icmd_access_register_ppamp access_register_ppamp;
	/* Description -  */
	/* 0x0.0 - 0x30.31 */
	 struct connectib_icmd_access_register_pplr access_register_pplr;
	/* Description -  */
	/* 0x0.0 - 0x30.31 */
	 struct connectib_icmd_access_register_pplm access_register_pplm;
	/* Description -  */
	/* 0x0.0 - 0x30.31 */
	 struct connectib_icmd_access_register_plpc access_register_plpc;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_access_register_mlcr access_register_mlcr;
	/* Description -  */
	/* 0x0.0 - 0x14.31 */
	 struct connectib_icmd_access_register_pmtu access_register_pmtu;
	/* Description -  */
	/* 0x0.0 - 0x44.31 */
	 struct connectib_icmd_access_reg_ptys access_register_ptys;
	/* Description - restore all access registers to thier default values */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_restore_phy_registers restore_phy_registers;
	/* Description - performs frequency measurement */
	/* 0x0.0 - 0xc.31 */
	 struct connectib_icmd_measure_frequency measure_frequency;
	/* Description -  */
	/* 0x0.0 - 0x10c.31 */
	 struct connectib_icmd_access_register_ppcnt access_register_ppcnt;
	/* Description -  */
	/* 0x0.0 - 0x18.31 */
	 struct connectib_icmd_set_get_port_cntr set_get_port_counter;
	/* Description - Verification tool to get_set LED pattern */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_icmd_led_cmd led_cmd;
	/* Description -  */
	/* 0x0.0 - 0x48.31 */
	 struct connectib_icmd_led_control_mad led_control_mad;
	/* Description - FTE dump tool: Flow Table list */
	/* 0x0.0 - 0x10.31 */
	 union connectib_icmd_get_ft_list get_ft_list;
	/* Description - FTE dump tool: Flow Table info */
	/* 0x0.0 - 0x10.31 */
	 union connectib_icmd_get_ft_info get_ft_info;
	/* Description - FTE dump tool: Flow Group list */
	/* 0x0.0 - 0x10.31 */
	 union connectib_icmd_get_fg_list get_fg_list;
	/* Description - FTE dump tool: Flow Group info */
	/* 0x0.0 - 0x100.31 */
	 union connectib_icmd_get_fg get_fg;
	/* Description - FTE dump tool: Flow Table Entry list */
	/* 0x0.0 - 0x10.31 */
	 union connectib_icmd_get_fte_list get_fte_list;
	/* Description - FTE dump tool: Flow Table Entry info */
	/* 0x0.0 - 0x300.31 */
	 union connectib_icmd_get_fte get_fte;
	/* Description - STE dump tool: STE opened resources */
	/* 0x0.0 - 0x300.31 */
	 union connectib_icmd_get_ste_open_resources get_ste_open_resources;
	/* Description - STE dump tool: STE resources list */
	/* 0x0.0 - 0x100.31 */
	 union connectib_icmd_get_ste_resources_list get_ste_resources_list;
	/* Description - STE dump tool: STE dump */
	/* 0x0.0 - 0x50.31 */
	 struct connectib_icmd_read_ste read_ste;
	/* Description - steering info for debug */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_icmd_get_steering_info steering_info;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_icmd_parse_icm_address parse_icm_address;
	/* Description -  */
	/* 0x0.0 - 0x14.31 */
	 struct connectib_icmd_access_register_pvlc access_register_pvlc;
	/* Description - injects faults for verification */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_general_fault_injector general_fault_injector;
	/* Description - flicks_enable_disable and cache invalidation */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_icmd_mini_flow_activator mini_flow_activator;
	/* Description -  */
	/* 0x0.0 - 0x300.31 */
	 struct connectib_icmd_debug_calc_sqn calc_sqn;
	/* Description -  */
	/* 0x0.0 - 0x44.31 */
	 struct connectib_icmd_read_write_varb_ctx read_write_varb_ctx;
	/* Description - generate assert */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_icmd_gen_assert gen_assert;
	/* Description - set oc int */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_icmd_set_oc_int set_oc_int;
	/* Description - get fw driver version */
	/* 0x0.0 - 0x50.31 */
	 struct connectib_icmd_get_fw_driver_version get_fw_driver_ver;
	/* Description -  */
	/* 0x0.0 - 0x24.31 */
	 struct connectib_icmd_pmlp_query pmlp_query;
	/* Description -  */
	/* 0x0.0 - 0x3c.31 */
	 struct connectib_icmd_pre_define_module_db pre_define_module_db;
	/* Description - call ocbb apis */
	/* 0x0.0 - 0x300.31 */
	 struct connectib_icmd_ocbb_rndc_get_core_api ocbb_rndc_get_core_api;
	/* Description - call ocbb pci apis */
	/* 0x0.0 - 0x30.31 */
	 struct connectib_icmd_ocbb_get_pci_api ocbb_get_pci_api;
	/* Description - vport_info or vport_shadow */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_icmd_get_pf_ctx get_pf_ctx;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_icmd_set_get_debug_pf_mac debug_pf_mac;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_icmd_access_register_nodnic_queue_info nodnic_queue_info;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_temp_warn_gen_event temp_warn_gen;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_icmd_detect_gvmi_in_qpc_and_icmc detect_gvmi_in_hw;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_icmd_internal_query_cap internal_query_cap;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_map_event_eq map_event_eq;
	/* Description -  */
	/* 0x0.0 - 0x64.31 */
	 struct connectib_icmd_get_packet_pacing_debug_info get_packet_pacing_debug_info;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_icmd_port_admin_state_mng port_admin_state_mng;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_icmd_asn1_force_port_state asn1_force_port_state;
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_icmd_mh_sync mh_sync;
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_icmd_rw_gvmi_fw_ctx rw_gvmi_fw_ctx;
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 struct connectib_icmd_drop_counter_read drop_counter_read;
	/* Description - operate sysport to send packet */
	/* 0x0.0 - 0x300.31 */
	 struct connectib_icmd_sysport sysport;
	/* Description -  */
	/* 0x0.0 - 0x8.31 */
	 struct connectib_icmd_get_gvmi_rl_ctx_ix get_gvmi_rl_ctx_ix;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_sw_cqe_sigerr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t rsvd_9;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t rsvd_8;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t rsvd_7;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t rsvd_6;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t expected_trans_sig;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t actual_trans_sig;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t expected_ref_tag;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t actual_ref_tag;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x20.15 */
	 u_int16_t rsvd_5;
	/* Description -  */
	/* 0x20.16 - 0x20.31 */
	 u_int16_t syndrome;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t mkey;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t sig_err_byte_h;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t sig_err_byte_l;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t rsvd_4;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t rsvd_3;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x38.23 */
	 u_int32_t qpn;
	/* Description -  */
	/* 0x38.24 - 0x38.31 */
	 u_int8_t rsvd_2;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x3c.0 */
	 u_int8_t owner;
	/* Description -  */
	/* 0x3c.1 - 0x3c.3 */
	 u_int8_t rsvd_0;
	/* Description -  */
	/* 0x3c.4 - 0x3c.7 */
	 u_int8_t opcode;
	/* Description -  */
	/* 0x3c.8 - 0x3c.15 */
	 u_int8_t signature;
	/* Description -  */
	/* 0x3c.16 - 0x3c.31 */
	 u_int16_t rsvd_1;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_sw_cqe_resize {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t rsvd_14;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t rsvd_13;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t rsvd_12;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t rsvd_11;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t rsvd_10;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t rsvd_9;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t rsvd_8;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t rsvd_7;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x24.31 */
	 u_int32_t rsvd_6;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t rsvd_5;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t rsvd_4;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t rsvd_3;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t timestamp_h;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x38.31 */
	 u_int32_t timestamp_l;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x3c.31 */
	 u_int32_t rsvd_2;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x3c.0 */
	 u_int8_t owner;
	/* Description -  */
	/* 0x3c.1 - 0x3c.3 */
	 u_int8_t rsvd_1;
	/* Description -  */
	/* 0x3c.4 - 0x3c.7 */
	 u_int8_t opcode;
	/* Description -  */
	/* 0x3c.8 - 0x3c.15 */
	 u_int8_t signature;
	/* Description -  */
	/* 0x3c.16 - 0x3c.31 */
	 u_int16_t rsvd_0;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_sw_cqe_error {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x0.15 */
	 u_int16_t wqe_id;
	/* Description -  */
	/* 0x0.16 - 0x0.31 */
	 u_int16_t rsvd_14;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t rsvd_13;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t rsvd_12;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t rsvd_11;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x14.31 */
	 u_int32_t rsvd_10;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.0 - 0x18.31 */
	 u_int32_t rsvd_9;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x1c.31 */
	 u_int32_t rsvd_8;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x20.31 */
	 u_int32_t rsvd_7;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x20.23 */
	 u_int32_t srq_num;
	/* Description -  */
	/* 0x20.24 - 0x20.31 */
	 u_int8_t rsvd_6;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 0x24.0 - 0x28.31 */
	 u_int32_t rsvd_5;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 0x28.0 - 0x2c.31 */
	 u_int32_t rsvd_4;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 0x2c.0 - 0x30.31 */
	 u_int32_t byte_cnt;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x34.31 */
	 u_int32_t rsvd_2;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 0x34.0 - 0x34.7 */
	 u_int8_t syndrome;
	/* Description -  */
	/* 0x34.8 - 0x34.15 */
	 u_int8_t vendor_error_syndrome;
	/* Description -  */
	/* 0x34.16 - 0x34.19 */
	 u_int8_t rsvd_1;
	/* Description -  */
	/* 0x34.20 - 0x34.23 */
	 u_int8_t hw_syndrome_type;
	/* Description -  */
	/* 0x34.24 - 0x34.31 */
	 u_int8_t vendor_hw_syndrome;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 0x38.0 - 0x38.23 */
	 u_int32_t qpn;
	/* Description -  */
	/* 0x38.24 - 0x38.31 */
	 u_int8_t swqe_opcode_drop_cntr;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 0x3c.0 - 0x3c.0 */
	 u_int8_t owner;
	/* Description -  */
	/* 0x3c.1 - 0x3c.1 */
	 u_int8_t se;
	/* Description -  */
	/* 0x3c.2 - 0x3c.3 */
	 u_int8_t rsvd_0;
	/* Description -  */
	/* 0x3c.4 - 0x3c.7 */
	 u_int8_t rwqe_opcode;
	/* Description -  */
	/* 0x3c.8 - 0x3c.15 */
	 u_int8_t signature;
	/* Description -  */
	/* 0x3c.16 - 0x3c.31 */
	 u_int16_t wqe_counter;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_sw_cqe_128b {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_grh_inline_data grh_inline_data;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - 64B CQE */
	/* 0x40.0 - 0x80.31 */
	 struct connectib_sw_cqe_64b cqe_64b;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_itoc_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.2 - 0x0.23 */
	 u_int32_t size;
	/* Description - Section ID Section Type DESCRIPTION
0x1 BOOT_CODE FW loader code
0x2 PCI_CODE Code that is required to raise PCIe link.
0x3 MAIN_CODE All non-PCIe FW code
0x8 HW_BOOT_CFG Initial values for the PCI related registers
0x9 HW_MAIN_CFG Initial values for all other registers 
0x10 IMAGE_INFO Management data for the burning tool. See 'Image Info Section' chapter in the Mellanox Flash Programming Application Note
0x11 FW_BOOT_CFG Initial values for user set-able hi level non-hardware related settings, such as number of physical functions
(optional)
0x12 FW_MAIN_CFG Initial values for user set-able hi level non-hardware related settings.
(optional)
0x18 ROM_CODE PXE/Boot over IB code. 
0x30 DBG_LOG_MAP FW logger 'index to string' map. The map is in ASCI text. Format is TBD.
                                          PARAM0 in the iTOC specifies the compression method of this sector:
                                          0. Uncompressed
                                          1. Zlib compress2()
                                          2. LZMA
                                          Others - Reserved 
0x31 DBG_FW_INI The Ini file used in the image generation. The PARAM0 applies the same as in  DBG_LOG_MAP section type.
0x32 DBG_FW_PARAMS FW settable parameters. ASCII text. Format is TBD. The PARAM0 applies the same as in  DBG_LOG_MAP section type.
0xff END_MARKER A type of 0xff marks the end of the iTOC entries array. It is recommended to leave the unused part of the iTOC section blank (that is, 0xff in all unused bytes)
All other values Reserved 
 */
	/* 0x0.24 - 0x0.31 */
	 u_int8_t type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - if partition type is code or ini then the load address is in here */
	/* 0x4.0 - 0x4.29 */
	 u_int32_t param0;
	/* Description - When this bit is set, Data within the section is protected by per-line crc. See yu.flash.replacement.crc_en */
	/* 0x4.30 - 0x4.30 */
	 u_int8_t cache_line_crc;
	/* Description - When this bit is set, image is zipped */
	/* 0x4.31 - 0x4.31 */
	 u_int8_t zipped_image;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - if partition type is code then the jump address is in here */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t param1;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 0x14.2 - 0x14.30 */
	 u_int32_t flash_addr;
	/* Description -  */
	/* 0x14.31 - 0x14.31 */
	 u_int8_t relative_addr;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 0x18.0 - 0x18.15 */
	 u_int16_t section_crc;
	/* Description -  */
	/* 0x18.16 - 0x18.16 */
	 u_int8_t no_crc;
	/* Description - When this bit is set, the section pointed by this entry in belongs to teh device tather than to teh FW image.
A device_data section should not be updated in a regular FW update.
Example for device_data section: VPD_R, GUIDs. */
	/* 0x18.17 - 0x18.17 */
	 u_int8_t device_data;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.15 */
	 u_int16_t itoc_entry_crc;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_itoc_header {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 49 54 4f 43 */
	/* 0x0.0 - 0x4.31 */
	 u_int32_t signature0;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 04 08 15 16 */
	/* 0x4.0 - 0x8.31 */
	 u_int32_t signature1;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 23 42 ca fa */
	/* 0x8.0 - 0xc.31 */
	 u_int32_t signature2;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - ba ca fe 00 */
	/* 0xc.0 - 0x10.31 */
	 u_int32_t signature3;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Current version: 1 */
	/* 0x10.0 - 0x10.7 */
	 u_int8_t version;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 0x1c.0 - 0x1c.15 */
	 u_int16_t itoc_entry_crc;
};

/* Description -   */
/* Size in bytes - 1024 */
struct connectib_sw_wqe {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_wqe_control conrtol;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 0x10.0 - 0x20.31 */
	 struct connectib_wqe_mlx mlx;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 0x20.0 - 0x30.31 */
	 struct connectib_wqe_xrc xrc;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 0x30.0 - 0x40.31 */
	 struct connectib_wqe_address_vector_basic address_vector_basic;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 0x40.0 - 0x60.31 */
	 struct connectib_wqe_address_vector_ext address_vector_ext;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description -  */
	/* 0x60.0 - 0x70.31 */
	 struct connectib_wqe_rdma_read rdma_read;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description -  */
	/* 0x70.0 - 0x80.31 */
	 struct connectib_wqe_atomic_cmp_swap atomic_cmp_swap;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 0x80.0 - 0x280.31 */
	 union connectib_wqe_extended_atomic_cmp_swap ext_atom_cmp_swap;
/*---------------- DWORD[160] (Offset 0x280) ----------------*/
	/* Description -  */
	/* 0x280.0 - 0x290.31 */
	 struct connectib_wqe_atomic_fetch_add atomic_fetch_add;
/*---------------- DWORD[164] (Offset 0x290) ----------------*/
	/* Description -  */
	/* 0x290.0 - 0x390.31 */
	 union connectib_wqe_extended_atomic_fetch_add ext_atom_fetch_add;
/*---------------- DWORD[228] (Offset 0x390) ----------------*/
	/* Description -  */
	/* 0x390.0 - 0x3a0.31 */
	 struct connectib_wqe_signature signature;
/*---------------- DWORD[232] (Offset 0x3a0) ----------------*/
	/* Description -  */
	/* 0x3a0.0 - 0x3b0.31 */
	 struct connectib_wqe_srq_next srq_next;
/*---------------- DWORD[236] (Offset 0x3b0) ----------------*/
	/* Description -  */
	/* 0x3b0.0 - 0x3c0.31 */
	 struct connectib_wqe_gather_scatter_entry gather_scatter_entry;
/*---------------- DWORD[240] (Offset 0x3c0) ----------------*/
	/* Description -  */
	/* 0x3c0.0 - 0x3c4.31 */
	 struct connectib_wqe_inline_header inline_header;
/*---------------- DWORD[244] (Offset 0x3d0) ----------------*/
	/* Description -  */
	/* 0x3d0.0 - 0x3e0.31 */
	 struct connectib_wqe_eth_segment eth_segment;
};

/* Description -  All ini  fields */
/* Size in bytes - 65536 */
union connectib_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 1. Boot record endianes: reserved1 is the fist Byte that should be written on the NVRAM (address 0)
2. Each line is protected by parity bit (bit 31) the xor of the 32 read bits should be 1 */
	/* 0x0.0 - 0x10.31 */
	 struct connectib_boot_record_golan boot_record;
	/* Description -  */
	/* 0x0.0 - 0x100.31 */
	 struct connectib_reset_info reset_info;
	/* Description - This is a 'dummy' section.
It holds teh pointers for the dTOC entries.
Used by the mic tool */
	/* 0x0.0 - 0x100.31 */
	 union connectib_dtoc_pointers dtoc_pointers;
	/* Description - This struct contains device specific info, such as GUIDs, VSD, Keys, etc...
It is not a part of teh FW image.
 */
	/* 0x0.0 - 0x200.31 */
	 struct connectib_device_info device_info;
	/* Description - This section contains info which is shared by FW and burning tool */
	/* 0x0.0 - 0x400.31 */
	 struct connectib_image_info image_info;
	/* Description -  */
	/* 0x0.0 - 0x140.31 */
	 struct connectib_mfg_info mfg_info;
	/* Description - plastic fw config data */
	/* 0x0.0 - 0x1000.31 */
	 struct connectib_fw_main_config fw_main_config;
	/* Description - boot + iron fw config data */
	/* 0x0.0 - 0x4c0.31 */
	 struct connectib_fw_boot_config fw_boot_config;
	/* Description - plastic hw and board config data */
	/* 0x0.0 - 0xb00.31 */
	 struct connectib_hw_main_config hw_main_config;
	/* Description - boot and iron hw and board config data */
	/* 0x0.0 - 0x140.31 */
	 struct connectib_hw_boot_config hw_boot_config;
	/* Description -  */
	/* 0x0.0 - 0x10000.31 */
	 struct connectib_nv_data nv_data_0;
	/* Description -  */
	/* 0x0.0 - 0x10000.31 */
	 struct connectib_nv_data nv_data_1;
	/* Description -  */
	/* 0x0.0 - 0x10000.31 */
	 struct connectib_nv_data fw_nv_log;
	/* Description - This section holds the pending images signature and keypair_uuid */
	/* 0x0.0 - 0x140.31 */
	 struct connectib_image_signature image_signature;
	/* Description - This section holds the current image's signature and keypair_uuid */
	/* 0x0.0 - 0x900.31 */
	 struct connectib_public_keys public_keys;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_a2d {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - PowerUp the a2d circuit */
	/* 0x0.0 - 0x0.0 */
	 u_int8_t power_up;
	/* Description - divider the clock by: 2^(16-N) */
	/* 0x0.1 - 0x0.3 */
	 u_int8_t clock_div;
	/* Description - 
0: temperature (tempnet represented by voltage coming from bandgap circuit)
1: ibres2a2d : voltage coming from opamp_dft representing current over cml_res for debug
2: vddcore1 vdd coming from core. Omer needs to specify exactly where it is connected to
3: vsscore1 vss coming from core. Omer needs to specify exactly where it is connected to
4: vddcore2 vdd coming from core. Omer needs to specify exactly where it is connected to
5: vsscore2 vss coming from core. Omer needs to specify exactly where it is connected to
6: vddsd - vdd coming from serdes. Please refer to measure_sedes_probe in serdes
7: vsssd - vss coming from serdes. Please refer to measure_sedes_probe in serdes
8: irstatation voltages
9: av2a2d debug voltages coming from plls. Please refer to selav2a2d in PllCenter
10: bg12 directly from bandgap
11: bgx1 - coming from pll_ref buffered
12: package vss_sense
13: package vdd_sense
14: avout analog d2a voltage
15: fbout d2d feedback

 */
	/* 0x0.4 - 0x0.7 */
	 u_int8_t probe_sel;
	/* Description - Define the A2D measure mode (not thermal protect)
0,1: compare (for thermal protection or when SW driving HW machine)
2: binary search
    If thermal protection is enabled than the protection and measurement will operate simultaniously
3: circuit binary search (thermal_protect_en must be set to 0) */
	/* 0x0.8 - 0x0.9 */
	 u_int8_t measure_mode;
	/* Description - Which clock drives the A2D block:
0-internal ring oscilator
1-clock from pll input buffer 0
2-clock directly from pad1
3-clock directly from pad0
5-clock from pll input buffer 1 */
	/* 0x0.10 - 0x0.12 */
	 u_int8_t clock_sel;
	/* Description - sets the polarity of the bin_search algorithm. i.e. wheather to go up or down on each d2a results. */
	/* 0x0.13 - 0x0.13 */
	 u_int8_t measure_polarity;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - selects which analog net is connected to the ref_cm pad:
0-serial mode out
1-vss
2-analog value from probes
3-d2a analog value out */
	/* 0x4.0 - 0x4.1 */
	 u_int8_t pad_out_sel;
	/* Description - defines the direction of the spike direction */
	/* 0x4.2 - 0x4.2 */
	 u_int8_t spike_direction;
	/* Description - CAUTION - this register causes chage sharing over pllx4

0: 0.9V  (best for temperature)
1: 1.2V  (best for vddcore)
2: 1.8V  (best for vddhs)
3: 2.4V  (best for biases and analog) */
	/* 0x4.4 - 0x4.6 */
	 u_int8_t dynamic_range;
	/* Description - probe_sel needs to have values 6 (Vdd) / 7 (Vss) to select these voltages

1: vdd rxl. Please refer to serdes.x4.top_probe
2: vdd rxr. Please refer to serdes.x4.top_probe
3: vdd txl. Please refer to serdes.x4.top_probe
4: vdd txr. Please refer to serdes.x4.top_probe
5: vddhs ibfl . Please refer to serdes.x4.mid_probe
6: vddhs ibf4. Please refer to serdes.x4.mid_probe
7: spare
8: spare
 */
	/* 0x4.10 - 0x4.12 */
	 u_int8_t measure_serdes_probe;
	/* Description - When this register is set then the too hot indication (a2d_compare)
will be send to yu (too hot) */
	/* 0x4.13 - 0x4.13 */
	 u_int8_t thermal_protect_en;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 
Current value from A2D block or threshold value to compare with.
Temperature values are in reverse order to actual temperture[C] */
	/* 0x8.0 - 0x8.10 */
	 u_int16_t measure_value;
	/* Description - set by HW upon receiving valid from circuit binary machine, may be cleared by FW */
	/* 0x8.11 - 0x8.11 */
	 u_int8_t circuit_binary_done;
	/* Description - compare value from A2D block
1-too hot / analog below threshold
0-cold / analog above threshold */
	/* 0x8.12 - 0x8.12 */
	 u_int8_t a2d_compare;
	/* Description - threshold cross sticky bit
write 0 to clear */
	/* 0x8.13 - 0x8.13 */
	 u_int8_t spike_detect;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 
stabilization time:  2^ in i1 clocks
This time purpose is to wait for the HW a2d to stabilize and give a good output.
The time starts counting once inputs are good and control will disregard a2d output
as long time not ended.
 */
	/* 0xc.0 - 0xc.4 */
	 u_int8_t stabilization_time;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - min a2d value
writable by crspace */
	/* 0x10.0 - 0x10.10 */
	 u_int16_t measure_min;
	/* Description - compare value from A2D block on the last measure cycle
1-too hot / analog below threshold
0-cold / analog above threshold */
	/* 0x10.11 - 0x10.11 */
	 u_int8_t measure_compare;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - max a2d value
writable by crspace */
	/* 0x14.0 - 0x14.10 */
	 u_int16_t measure_max;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - This value is driven to HW a2d to compare when protect mode is on
temp values are in reverse order to temperture
 */
	/* 0x18.0 - 0x18.10 */
	 u_int16_t protect_value;
	/* Description - sets polarity of the protection mode or the too_hot indication going towards YU */
	/* 0x18.11 - 0x18.11 */
	 u_int8_t protect_polarity;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - temperature value as measured before VDDCORE was powered up
temp values are in reverse order to temperture */
	/* 0x1c.0 - 0x1c.10 */
	 u_int16_t calib_value;
};

/* Description -   */
/* Size in bytes - 1024 */
struct connectib_icmd {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x300.31 */
	 union connectib_icmd_cmd cmd;
/*---------------- DWORD[252] (Offset 0x3f0) ----------------*/
	/* Description -  */
	/* 0x3f0.0 - 0x400.31 */
	 struct connectib_icmd_ctrl ctrl;
};

/* Description -   */
/* Size in bytes - 128 */
union connectib_sw_cqe {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - cqe 64B layout */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_sw_cqe_64b cqe_64b;
	/* Description - cqe 128B layout */
	/* 0x0.0 - 0x80.31 */
	 struct connectib_sw_cqe_128b cqe_128b;
	/* Description - error cqe layout */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_sw_cqe_error cqe_error;
	/* Description - CQ resize cqe layout */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_sw_cqe_resize cqe_resize;
	/* Description - signature error cqe layout */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_sw_cqe_sigerr cqe_sigerr;
};

/* Description -  All nodes */
/* Size in bytes - 32 */
union connectib_itoc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Size must be multiple of 16B */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_itoc_header header;
	/* Description - Size must be multiple of 16B. When the no_crc bit is set, the section_crc should not be checked.
 */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_itoc_entry entry;
};

/* Description -   */
/* Size in bytes - 65536 */
union connectib_connectib_Nodes {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 union connectib_itoc itoc;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 union connectib_hw_hca_contexts hw_hca_contexts;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_guids guids;
	/* Description -  */
	/* 0x0.0 - 0x80.31 */
	 union connectib_sw_cqe sw_cqe;
	/* Description -  */
	/* 0x0.0 - 0x400.31 */
	 struct connectib_icmd icmd;
	/* Description -  */
	/* 0x0.0 - 0x20.31 */
	 struct connectib_a2d a2d;
	/* Description -  */
	/* 0x0.0 - 0x10000.31 */
	 union connectib_ini ini;
	/* Description -  */
	/* 0x0.0 - 0x400.31 */
	 struct connectib_sw_wqe sw_wqe;
	/* Description -  */
	/* 0x0.0 - 0x40.31 */
	 struct connectib_sw_eqe sw_eqe;
};


/*================= PACK/UNPACK/PRINT FUNCTIONS ======================*/
/* cmdif_ctx_special_qp_commands_uapp */
void connectib_cmdif_ctx_special_qp_commands_uapp_pack(const struct connectib_cmdif_ctx_special_qp_commands_uapp *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_qp_commands_uapp_unpack(struct connectib_cmdif_ctx_special_qp_commands_uapp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_qp_commands_uapp_print(const struct connectib_cmdif_ctx_special_qp_commands_uapp *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_qp_commands_uapp_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_QP_COMMANDS_UAPP_SIZE    (0xc)
void connectib_cmdif_ctx_special_qp_commands_uapp_dump(const struct connectib_cmdif_ctx_special_qp_commands_uapp *ptr_struct, FILE* file);
/* cmdif_ctx_special_qp_commands_underlay */
void connectib_cmdif_ctx_special_qp_commands_underlay_pack(const struct connectib_cmdif_ctx_special_qp_commands_underlay *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_qp_commands_underlay_unpack(struct connectib_cmdif_ctx_special_qp_commands_underlay *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_qp_commands_underlay_print(const struct connectib_cmdif_ctx_special_qp_commands_underlay *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_qp_commands_underlay_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_QP_COMMANDS_UNDERLAY_SIZE    (0xc)
void connectib_cmdif_ctx_special_qp_commands_underlay_dump(const struct connectib_cmdif_ctx_special_qp_commands_underlay *ptr_struct, FILE* file);
/* regular_qp_eth */
void connectib_regular_qp_eth_pack(const struct connectib_regular_qp_eth *ptr_struct, u_int8_t* ptr_buff);
void connectib_regular_qp_eth_unpack(struct connectib_regular_qp_eth *ptr_struct, const u_int8_t* ptr_buff);
void connectib_regular_qp_eth_print(const struct connectib_regular_qp_eth *ptr_struct, FILE* file, int indent_level);
int connectib_regular_qp_eth_size(void);
#define CONNECTIB_REGULAR_QP_ETH_SIZE    (0x4)
void connectib_regular_qp_eth_dump(const struct connectib_regular_qp_eth *ptr_struct, FILE* file);
/* regular_qp_ipoib */
void connectib_regular_qp_ipoib_pack(const struct connectib_regular_qp_ipoib *ptr_struct, u_int8_t* ptr_buff);
void connectib_regular_qp_ipoib_unpack(struct connectib_regular_qp_ipoib *ptr_struct, const u_int8_t* ptr_buff);
void connectib_regular_qp_ipoib_print(const struct connectib_regular_qp_ipoib *ptr_struct, FILE* file, int indent_level);
int connectib_regular_qp_ipoib_size(void);
#define CONNECTIB_REGULAR_QP_IPOIB_SIZE    (0x4)
void connectib_regular_qp_ipoib_dump(const struct connectib_regular_qp_ipoib *ptr_struct, FILE* file);
/* cmdif_ctx_special_qp_commands_inner */
void connectib_cmdif_ctx_special_qp_commands_inner_pack(const union connectib_cmdif_ctx_special_qp_commands_inner *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_qp_commands_inner_unpack(union connectib_cmdif_ctx_special_qp_commands_inner *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_qp_commands_inner_print(const union connectib_cmdif_ctx_special_qp_commands_inner *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_qp_commands_inner_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_QP_COMMANDS_INNER_SIZE    (0xc)
void connectib_cmdif_ctx_special_qp_commands_inner_dump(const union connectib_cmdif_ctx_special_qp_commands_inner *ptr_struct, FILE* file);
/* pmlp_code_style_lane */
void connectib_pmlp_code_style_lane_pack(const struct connectib_pmlp_code_style_lane *ptr_struct, u_int8_t* ptr_buff);
void connectib_pmlp_code_style_lane_unpack(struct connectib_pmlp_code_style_lane *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pmlp_code_style_lane_print(const struct connectib_pmlp_code_style_lane *ptr_struct, FILE* file, int indent_level);
int connectib_pmlp_code_style_lane_size(void);
#define CONNECTIB_PMLP_CODE_STYLE_LANE_SIZE    (0x4)
void connectib_pmlp_code_style_lane_dump(const struct connectib_pmlp_code_style_lane *ptr_struct, FILE* file);
/* dw */
void connectib_dw_pack(const struct connectib_dw *ptr_struct, u_int8_t* ptr_buff);
void connectib_dw_unpack(struct connectib_dw *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dw_print(const struct connectib_dw *ptr_struct, FILE* file, int indent_level);
int connectib_dw_size(void);
#define CONNECTIB_DW_SIZE    (0x4)
void connectib_dw_dump(const struct connectib_dw *ptr_struct, FILE* file);
/* nv_tlv_type_nvlog */
void connectib_nv_tlv_type_nvlog_pack(const struct connectib_nv_tlv_type_nvlog *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_nvlog_unpack(struct connectib_nv_tlv_type_nvlog *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_nvlog_print(const struct connectib_nv_tlv_type_nvlog *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_nvlog_size(void);
#define CONNECTIB_NV_TLV_TYPE_NVLOG_SIZE    (0x4)
void connectib_nv_tlv_type_nvlog_dump(const struct connectib_nv_tlv_type_nvlog *ptr_struct, FILE* file);
/* nv_tlv_type_eswitch */
void connectib_nv_tlv_type_eswitch_pack(const struct connectib_nv_tlv_type_eswitch *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_eswitch_unpack(struct connectib_nv_tlv_type_eswitch *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_eswitch_print(const struct connectib_nv_tlv_type_eswitch *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_eswitch_size(void);
#define CONNECTIB_NV_TLV_TYPE_ESWITCH_SIZE    (0x4)
void connectib_nv_tlv_type_eswitch_dump(const struct connectib_nv_tlv_type_eswitch *ptr_struct, FILE* file);
/* nv_tlv_type_per_host */
void connectib_nv_tlv_type_per_host_pack(const struct connectib_nv_tlv_type_per_host *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_per_host_unpack(struct connectib_nv_tlv_type_per_host *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_per_host_print(const struct connectib_nv_tlv_type_per_host *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_per_host_size(void);
#define CONNECTIB_NV_TLV_TYPE_PER_HOST_SIZE    (0x4)
void connectib_nv_tlv_type_per_host_dump(const struct connectib_nv_tlv_type_per_host *ptr_struct, FILE* file);
/* nv_tlv_type_bmc */
void connectib_nv_tlv_type_bmc_pack(const struct connectib_nv_tlv_type_bmc *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_bmc_unpack(struct connectib_nv_tlv_type_bmc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_bmc_print(const struct connectib_nv_tlv_type_bmc *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_bmc_size(void);
#define CONNECTIB_NV_TLV_TYPE_BMC_SIZE    (0x4)
void connectib_nv_tlv_type_bmc_dump(const struct connectib_nv_tlv_type_bmc *ptr_struct, FILE* file);
/* nv_tlv_type_physical_port */
void connectib_nv_tlv_type_physical_port_pack(const struct connectib_nv_tlv_type_physical_port *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_physical_port_unpack(struct connectib_nv_tlv_type_physical_port *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_physical_port_print(const struct connectib_nv_tlv_type_physical_port *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_physical_port_size(void);
#define CONNECTIB_NV_TLV_TYPE_PHYSICAL_PORT_SIZE    (0x4)
void connectib_nv_tlv_type_physical_port_dump(const struct connectib_nv_tlv_type_physical_port *ptr_struct, FILE* file);
/* nv_tlv_type_global */
void connectib_nv_tlv_type_global_pack(const struct connectib_nv_tlv_type_global *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_global_unpack(struct connectib_nv_tlv_type_global *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_global_print(const struct connectib_nv_tlv_type_global *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_global_size(void);
#define CONNECTIB_NV_TLV_TYPE_GLOBAL_SIZE    (0x4)
void connectib_nv_tlv_type_global_dump(const struct connectib_nv_tlv_type_global *ptr_struct, FILE* file);
/* regular_qp_sub_type */
void connectib_regular_qp_sub_type_pack(const union connectib_regular_qp_sub_type *ptr_struct, u_int8_t* ptr_buff);
void connectib_regular_qp_sub_type_unpack(union connectib_regular_qp_sub_type *ptr_struct, const u_int8_t* ptr_buff);
void connectib_regular_qp_sub_type_print(const union connectib_regular_qp_sub_type *ptr_struct, FILE* file, int indent_level);
int connectib_regular_qp_sub_type_size(void);
#define CONNECTIB_REGULAR_QP_SUB_TYPE_SIZE    (0x4)
void connectib_regular_qp_sub_type_dump(const union connectib_regular_qp_sub_type *ptr_struct, FILE* file);
/* cmdif_ctx_special_qp_commands_other */
void connectib_cmdif_ctx_special_qp_commands_other_pack(const struct connectib_cmdif_ctx_special_qp_commands_other *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_qp_commands_other_unpack(struct connectib_cmdif_ctx_special_qp_commands_other *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_qp_commands_other_print(const struct connectib_cmdif_ctx_special_qp_commands_other *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_qp_commands_other_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_QP_COMMANDS_OTHER_SIZE    (0x10)
void connectib_cmdif_ctx_special_qp_commands_other_dump(const struct connectib_cmdif_ctx_special_qp_commands_other *ptr_struct, FILE* file);
/* cmdif_ctx_special_qp_commands_rts2rts */
void connectib_cmdif_ctx_special_qp_commands_rts2rts_pack(const struct connectib_cmdif_ctx_special_qp_commands_rts2rts *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_qp_commands_rts2rts_unpack(struct connectib_cmdif_ctx_special_qp_commands_rts2rts *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_qp_commands_rts2rts_print(const struct connectib_cmdif_ctx_special_qp_commands_rts2rts *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_qp_commands_rts2rts_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_QP_COMMANDS_RTS2RTS_SIZE    (0x10)
void connectib_cmdif_ctx_special_qp_commands_rts2rts_dump(const struct connectib_cmdif_ctx_special_qp_commands_rts2rts *ptr_struct, FILE* file);
/* pmlp_code_style */
void connectib_pmlp_code_style_pack(const struct connectib_pmlp_code_style *ptr_struct, u_int8_t* ptr_buff);
void connectib_pmlp_code_style_unpack(struct connectib_pmlp_code_style *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pmlp_code_style_print(const struct connectib_pmlp_code_style *ptr_struct, FILE* file, int indent_level);
int connectib_pmlp_code_style_size(void);
#define CONNECTIB_PMLP_CODE_STYLE_SIZE    (0x24)
void connectib_pmlp_code_style_dump(const struct connectib_pmlp_code_style *ptr_struct, FILE* file);
/* pmlp_prm_style */
void connectib_pmlp_prm_style_pack(const struct connectib_pmlp_prm_style *ptr_struct, u_int8_t* ptr_buff);
void connectib_pmlp_prm_style_unpack(struct connectib_pmlp_prm_style *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pmlp_prm_style_print(const struct connectib_pmlp_prm_style *ptr_struct, FILE* file, int indent_level);
int connectib_pmlp_prm_style_size(void);
#define CONNECTIB_PMLP_PRM_STYLE_SIZE    (0x24)
void connectib_pmlp_prm_style_dump(const struct connectib_pmlp_prm_style *ptr_struct, FILE* file);
/* register_access_data_reduced */
void connectib_register_access_data_reduced_pack(const struct connectib_register_access_data_reduced *ptr_struct, u_int8_t* ptr_buff);
void connectib_register_access_data_reduced_unpack(struct connectib_register_access_data_reduced *ptr_struct, const u_int8_t* ptr_buff);
void connectib_register_access_data_reduced_print(const struct connectib_register_access_data_reduced *ptr_struct, FILE* file, int indent_level);
int connectib_register_access_data_reduced_size(void);
#define CONNECTIB_REGISTER_ACCESS_DATA_REDUCED_SIZE    (0x10)
void connectib_register_access_data_reduced_dump(const struct connectib_register_access_data_reduced *ptr_struct, FILE* file);
/* nv_tlv_hdr */
void connectib_nv_tlv_hdr_pack(const struct connectib_nv_tlv_hdr *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_hdr_unpack(struct connectib_nv_tlv_hdr *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_hdr_print(const struct connectib_nv_tlv_hdr *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_hdr_size(void);
#define CONNECTIB_NV_TLV_HDR_SIZE    (0xc)
void connectib_nv_tlv_hdr_dump(const struct connectib_nv_tlv_hdr *ptr_struct, FILE* file);
/* nv_tlv_type */
void connectib_nv_tlv_type_pack(const union connectib_nv_tlv_type *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_unpack(union connectib_nv_tlv_type *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_print(const union connectib_nv_tlv_type *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_size(void);
#define CONNECTIB_NV_TLV_TYPE_SIZE    (0x4)
void connectib_nv_tlv_type_dump(const union connectib_nv_tlv_type *ptr_struct, FILE* file);
/* register_access_data */
void connectib_register_access_data_pack(const struct connectib_register_access_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_register_access_data_unpack(struct connectib_register_access_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_register_access_data_print(const struct connectib_register_access_data *ptr_struct, FILE* file, int indent_level);
int connectib_register_access_data_size(void);
#define CONNECTIB_REGISTER_ACCESS_DATA_SIZE    (0x20)
void connectib_register_access_data_dump(const struct connectib_register_access_data *ptr_struct, FILE* file);
/* mfba_header */
void connectib_mfba_header_pack(const struct connectib_mfba_header *ptr_struct, u_int8_t* ptr_buff);
void connectib_mfba_header_unpack(struct connectib_mfba_header *ptr_struct, const u_int8_t* ptr_buff);
void connectib_mfba_header_print(const struct connectib_mfba_header *ptr_struct, FILE* file, int indent_level);
int connectib_mfba_header_size(void);
#define CONNECTIB_MFBA_HEADER_SIZE    (0xc)
void connectib_mfba_header_dump(const struct connectib_mfba_header *ptr_struct, FILE* file);
/* pmmp_sfp_protocol_override_layout */
void connectib_pmmp_sfp_protocol_override_layout_pack(const struct connectib_pmmp_sfp_protocol_override_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_pmmp_sfp_protocol_override_layout_unpack(struct connectib_pmmp_sfp_protocol_override_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pmmp_sfp_protocol_override_layout_print(const struct connectib_pmmp_sfp_protocol_override_layout *ptr_struct, FILE* file, int indent_level);
int connectib_pmmp_sfp_protocol_override_layout_size(void);
#define CONNECTIB_PMMP_SFP_PROTOCOL_OVERRIDE_LAYOUT_SIZE    (0xc)
void connectib_pmmp_sfp_protocol_override_layout_dump(const struct connectib_pmmp_sfp_protocol_override_layout *ptr_struct, FILE* file);
/* pmmp_qsfp_protocol_override_layout */
void connectib_pmmp_qsfp_protocol_override_layout_pack(const struct connectib_pmmp_qsfp_protocol_override_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_pmmp_qsfp_protocol_override_layout_unpack(struct connectib_pmmp_qsfp_protocol_override_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pmmp_qsfp_protocol_override_layout_print(const struct connectib_pmmp_qsfp_protocol_override_layout *ptr_struct, FILE* file, int indent_level);
int connectib_pmmp_qsfp_protocol_override_layout_size(void);
#define CONNECTIB_PMMP_QSFP_PROTOCOL_OVERRIDE_LAYOUT_SIZE    (0xc)
void connectib_pmmp_qsfp_protocol_override_layout_dump(const struct connectib_pmmp_qsfp_protocol_override_layout *ptr_struct, FILE* file);
/* pcie_timers_states */
void connectib_pcie_timers_states_pack(const struct connectib_pcie_timers_states *ptr_struct, u_int8_t* ptr_buff);
void connectib_pcie_timers_states_unpack(struct connectib_pcie_timers_states *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pcie_timers_states_print(const struct connectib_pcie_timers_states *ptr_struct, FILE* file, int indent_level);
int connectib_pcie_timers_states_size(void);
#define CONNECTIB_PCIE_TIMERS_STATES_SIZE    (0xf8)
void connectib_pcie_timers_states_dump(const struct connectib_pcie_timers_states *ptr_struct, FILE* file);
/* pcie_lanes_counters */
void connectib_pcie_lanes_counters_pack(const struct connectib_pcie_lanes_counters *ptr_struct, u_int8_t* ptr_buff);
void connectib_pcie_lanes_counters_unpack(struct connectib_pcie_lanes_counters *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pcie_lanes_counters_print(const struct connectib_pcie_lanes_counters *ptr_struct, FILE* file, int indent_level);
int connectib_pcie_lanes_counters_size(void);
#define CONNECTIB_PCIE_LANES_COUNTERS_SIZE    (0xf8)
void connectib_pcie_lanes_counters_dump(const struct connectib_pcie_lanes_counters *ptr_struct, FILE* file);
/* pcie_perf_counters */
void connectib_pcie_perf_counters_pack(const struct connectib_pcie_perf_counters *ptr_struct, u_int8_t* ptr_buff);
void connectib_pcie_perf_counters_unpack(struct connectib_pcie_perf_counters *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pcie_perf_counters_print(const struct connectib_pcie_perf_counters *ptr_struct, FILE* file, int indent_level);
int connectib_pcie_perf_counters_size(void);
#define CONNECTIB_PCIE_PERF_COUNTERS_SIZE    (0xc8)
void connectib_pcie_perf_counters_dump(const struct connectib_pcie_perf_counters *ptr_struct, FILE* file);
/* phys_layer_stat_cntrs */
void connectib_phys_layer_stat_cntrs_pack(const struct connectib_phys_layer_stat_cntrs *ptr_struct, u_int8_t* ptr_buff);
void connectib_phys_layer_stat_cntrs_unpack(struct connectib_phys_layer_stat_cntrs *ptr_struct, const u_int8_t* ptr_buff);
void connectib_phys_layer_stat_cntrs_print(const struct connectib_phys_layer_stat_cntrs *ptr_struct, FILE* file, int indent_level);
int connectib_phys_layer_stat_cntrs_size(void);
#define CONNECTIB_PHYS_LAYER_STAT_CNTRS_SIZE    (0xf8)
void connectib_phys_layer_stat_cntrs_dump(const struct connectib_phys_layer_stat_cntrs *ptr_struct, FILE* file);
/* eth_per_traffic_congestion_grp_data_layout */
void connectib_eth_per_traffic_congestion_grp_data_layout_pack(const struct connectib_eth_per_traffic_congestion_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_per_traffic_congestion_grp_data_layout_unpack(struct connectib_eth_per_traffic_congestion_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_per_traffic_congestion_grp_data_layout_print(const struct connectib_eth_per_traffic_congestion_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_per_traffic_congestion_grp_data_layout_size(void);
#define CONNECTIB_ETH_PER_TRAFFIC_CONGESTION_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_per_traffic_congestion_grp_data_layout_dump(const struct connectib_eth_per_traffic_congestion_grp_data_layout *ptr_struct, FILE* file);
/* ib_port_counters */
void connectib_ib_port_counters_pack(const struct connectib_ib_port_counters *ptr_struct, u_int8_t* ptr_buff);
void connectib_ib_port_counters_unpack(struct connectib_ib_port_counters *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ib_port_counters_print(const struct connectib_ib_port_counters *ptr_struct, FILE* file, int indent_level);
int connectib_ib_port_counters_size(void);
#define CONNECTIB_IB_PORT_COUNTERS_SIZE    (0xf8)
void connectib_ib_port_counters_dump(const struct connectib_ib_port_counters *ptr_struct, FILE* file);
/* llr_counters */
void connectib_llr_counters_pack(const struct connectib_llr_counters *ptr_struct, u_int8_t* ptr_buff);
void connectib_llr_counters_unpack(struct connectib_llr_counters *ptr_struct, const u_int8_t* ptr_buff);
void connectib_llr_counters_print(const struct connectib_llr_counters *ptr_struct, FILE* file, int indent_level);
int connectib_llr_counters_size(void);
#define CONNECTIB_LLR_COUNTERS_SIZE    (0xf8)
void connectib_llr_counters_dump(const struct connectib_llr_counters *ptr_struct, FILE* file);
/* discard_cntrs_grp_data */
void connectib_discard_cntrs_grp_data_pack(const struct connectib_discard_cntrs_grp_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_discard_cntrs_grp_data_unpack(struct connectib_discard_cntrs_grp_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_discard_cntrs_grp_data_print(const struct connectib_discard_cntrs_grp_data *ptr_struct, FILE* file, int indent_level);
int connectib_discard_cntrs_grp_data_size(void);
#define CONNECTIB_DISCARD_CNTRS_GRP_DATA_SIZE    (0xf8)
void connectib_discard_cntrs_grp_data_dump(const struct connectib_discard_cntrs_grp_data *ptr_struct, FILE* file);
/* phys_layer_cntrs */
void connectib_phys_layer_cntrs_pack(const struct connectib_phys_layer_cntrs *ptr_struct, u_int8_t* ptr_buff);
void connectib_phys_layer_cntrs_unpack(struct connectib_phys_layer_cntrs *ptr_struct, const u_int8_t* ptr_buff);
void connectib_phys_layer_cntrs_print(const struct connectib_phys_layer_cntrs *ptr_struct, FILE* file, int indent_level);
int connectib_phys_layer_cntrs_size(void);
#define CONNECTIB_PHYS_LAYER_CNTRS_SIZE    (0xc8)
void connectib_phys_layer_cntrs_dump(const struct connectib_phys_layer_cntrs *ptr_struct, FILE* file);
/* correct_on_demand_layout */
void connectib_correct_on_demand_layout_pack(const struct connectib_correct_on_demand_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_correct_on_demand_layout_unpack(struct connectib_correct_on_demand_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_correct_on_demand_layout_print(const struct connectib_correct_on_demand_layout *ptr_struct, FILE* file, int indent_level);
int connectib_correct_on_demand_layout_size(void);
#define CONNECTIB_CORRECT_ON_DEMAND_LAYOUT_SIZE    (0x38)
void connectib_correct_on_demand_layout_dump(const struct connectib_correct_on_demand_layout *ptr_struct, FILE* file);
/* eth_per_traffic_grp_data_layout */
void connectib_eth_per_traffic_grp_data_layout_pack(const struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_per_traffic_grp_data_layout_unpack(struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_per_traffic_grp_data_layout_print(const struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_per_traffic_grp_data_layout_size(void);
#define CONNECTIB_ETH_PER_TRAFFIC_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_per_traffic_grp_data_layout_dump(const struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, FILE* file);
/* eth_per_prio_grp_data_layout */
void connectib_eth_per_prio_grp_data_layout_pack(const struct connectib_eth_per_prio_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_per_prio_grp_data_layout_unpack(struct connectib_eth_per_prio_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_per_prio_grp_data_layout_print(const struct connectib_eth_per_prio_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_per_prio_grp_data_layout_size(void);
#define CONNECTIB_ETH_PER_PRIO_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_per_prio_grp_data_layout_dump(const struct connectib_eth_per_prio_grp_data_layout *ptr_struct, FILE* file);
/* eth_extended_cntrs_grp_data_layout */
void connectib_eth_extended_cntrs_grp_data_layout_pack(const struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_extended_cntrs_grp_data_layout_unpack(struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_extended_cntrs_grp_data_layout_print(const struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_extended_cntrs_grp_data_layout_size(void);
#define CONNECTIB_ETH_EXTENDED_CNTRS_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_extended_cntrs_grp_data_layout_dump(const struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, FILE* file);
/* eth_3635_cntrs_grp_data_layout */
void connectib_eth_3635_cntrs_grp_data_layout_pack(const struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_3635_cntrs_grp_data_layout_unpack(struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_3635_cntrs_grp_data_layout_print(const struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_3635_cntrs_grp_data_layout_size(void);
#define CONNECTIB_ETH_3635_CNTRS_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_3635_cntrs_grp_data_layout_dump(const struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, FILE* file);
/* eth_2819_cntrs_grp_data_layout */
void connectib_eth_2819_cntrs_grp_data_layout_pack(const struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_2819_cntrs_grp_data_layout_unpack(struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_2819_cntrs_grp_data_layout_print(const struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_2819_cntrs_grp_data_layout_size(void);
#define CONNECTIB_ETH_2819_CNTRS_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_2819_cntrs_grp_data_layout_dump(const struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, FILE* file);
/* eth_2863_cntrs_grp_data_layout */
void connectib_eth_2863_cntrs_grp_data_layout_pack(const struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_2863_cntrs_grp_data_layout_unpack(struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_2863_cntrs_grp_data_layout_print(const struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_2863_cntrs_grp_data_layout_size(void);
#define CONNECTIB_ETH_2863_CNTRS_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_2863_cntrs_grp_data_layout_dump(const struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, FILE* file);
/* eth_802_3_cntrs_grp_data_layout */
void connectib_eth_802_3_cntrs_grp_data_layout_pack(const struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_802_3_cntrs_grp_data_layout_unpack(struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_802_3_cntrs_grp_data_layout_print(const struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_802_3_cntrs_grp_data_layout_size(void);
#define CONNECTIB_ETH_802_3_CNTRS_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_802_3_cntrs_grp_data_layout_dump(const struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, FILE* file);
/* dct_qp */
void connectib_dct_qp_pack(const struct connectib_dct_qp *ptr_struct, u_int8_t* ptr_buff);
void connectib_dct_qp_unpack(struct connectib_dct_qp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dct_qp_print(const struct connectib_dct_qp *ptr_struct, FILE* file, int indent_level);
int connectib_dct_qp_size(void);
#define CONNECTIB_DCT_QP_SIZE    (0x10)
void connectib_dct_qp_dump(const struct connectib_dct_qp *ptr_struct, FILE* file);
/* dcr_qp */
void connectib_dcr_qp_pack(const struct connectib_dcr_qp *ptr_struct, u_int8_t* ptr_buff);
void connectib_dcr_qp_unpack(struct connectib_dcr_qp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dcr_qp_print(const struct connectib_dcr_qp *ptr_struct, FILE* file, int indent_level);
int connectib_dcr_qp_size(void);
#define CONNECTIB_DCR_QP_SIZE    (0x10)
void connectib_dcr_qp_dump(const struct connectib_dcr_qp *ptr_struct, FILE* file);
/* regular_qp */
void connectib_regular_qp_pack(const struct connectib_regular_qp *ptr_struct, u_int8_t* ptr_buff);
void connectib_regular_qp_unpack(struct connectib_regular_qp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_regular_qp_print(const struct connectib_regular_qp *ptr_struct, FILE* file, int indent_level);
int connectib_regular_qp_size(void);
#define CONNECTIB_REGULAR_QP_SIZE    (0x10)
void connectib_regular_qp_dump(const struct connectib_regular_qp *ptr_struct, FILE* file);
/* schedint_cause */
void connectib_schedint_cause_pack(const struct connectib_schedint_cause *ptr_struct, u_int8_t* ptr_buff);
void connectib_schedint_cause_unpack(struct connectib_schedint_cause *ptr_struct, const u_int8_t* ptr_buff);
void connectib_schedint_cause_print(const struct connectib_schedint_cause *ptr_struct, FILE* file, int indent_level);
int connectib_schedint_cause_size(void);
#define CONNECTIB_SCHEDINT_CAUSE_SIZE    (0x1)
void connectib_schedint_cause_dump(const struct connectib_schedint_cause *ptr_struct, FILE* file);
/* fw_qpc_ib */
void connectib_fw_qpc_ib_pack(const struct connectib_fw_qpc_ib *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_qpc_ib_unpack(struct connectib_fw_qpc_ib *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_qpc_ib_print(const struct connectib_fw_qpc_ib *ptr_struct, FILE* file, int indent_level);
int connectib_fw_qpc_ib_size(void);
#define CONNECTIB_FW_QPC_IB_SIZE    (0x4)
void connectib_fw_qpc_ib_dump(const struct connectib_fw_qpc_ib *ptr_struct, FILE* file);
/* fw_qpc_eth */
void connectib_fw_qpc_eth_pack(const struct connectib_fw_qpc_eth *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_qpc_eth_unpack(struct connectib_fw_qpc_eth *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_qpc_eth_print(const struct connectib_fw_qpc_eth *ptr_struct, FILE* file, int indent_level);
int connectib_fw_qpc_eth_size(void);
#define CONNECTIB_FW_QPC_ETH_SIZE    (0x4)
void connectib_fw_qpc_eth_dump(const struct connectib_fw_qpc_eth *ptr_struct, FILE* file);
/* hw_msix_context_data0 */
void connectib_hw_msix_context_data0_pack(const struct connectib_hw_msix_context_data0 *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_msix_context_data0_unpack(struct connectib_hw_msix_context_data0 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_msix_context_data0_print(const struct connectib_hw_msix_context_data0 *ptr_struct, FILE* file, int indent_level);
int connectib_hw_msix_context_data0_size(void);
#define CONNECTIB_HW_MSIX_CONTEXT_DATA0_SIZE    (0x4)
void connectib_hw_msix_context_data0_dump(const struct connectib_hw_msix_context_data0 *ptr_struct, FILE* file);
/* hw_ste_tag_generic_headers */
void connectib_hw_ste_tag_generic_headers_pack(const struct connectib_hw_ste_tag_generic_headers *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_generic_headers_unpack(struct connectib_hw_ste_tag_generic_headers *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_generic_headers_print(const struct connectib_hw_ste_tag_generic_headers *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_generic_headers_size(void);
#define CONNECTIB_HW_STE_TAG_GENERIC_HEADERS_SIZE    (0x10)
void connectib_hw_ste_tag_generic_headers_dump(const struct connectib_hw_ste_tag_generic_headers *ptr_struct, FILE* file);
/* hw_ste_tag_port */
void connectib_hw_ste_tag_port_pack(const struct connectib_hw_ste_tag_port *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_port_unpack(struct connectib_hw_ste_tag_port *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_port_print(const struct connectib_hw_ste_tag_port *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_port_size(void);
#define CONNECTIB_HW_STE_TAG_PORT_SIZE    (0x10)
void connectib_hw_ste_tag_port_dump(const struct connectib_hw_ste_tag_port *ptr_struct, FILE* file);
/* hw_ste_tag_source_gvmi_qp */
void connectib_hw_ste_tag_source_gvmi_qp_pack(const struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_source_gvmi_qp_unpack(struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_source_gvmi_qp_print(const struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_source_gvmi_qp_size(void);
#define CONNECTIB_HW_STE_TAG_SOURCE_GVMI_QP_SIZE    (0x10)
void connectib_hw_ste_tag_source_gvmi_qp_dump(const struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, FILE* file);
/* hw_ste_tag_ib_l4 */
void connectib_hw_ste_tag_ib_l4_pack(const struct connectib_hw_ste_tag_ib_l4 *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l4_unpack(struct connectib_hw_ste_tag_ib_l4 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l4_print(const struct connectib_hw_ste_tag_ib_l4 *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_ib_l4_size(void);
#define CONNECTIB_HW_STE_TAG_IB_L4_SIZE    (0x10)
void connectib_hw_ste_tag_ib_l4_dump(const struct connectib_hw_ste_tag_ib_l4 *ptr_struct, FILE* file);
/* hw_ste_tag_ib_l3 */
void connectib_hw_ste_tag_ib_l3_pack(const struct connectib_hw_ste_tag_ib_l3 *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l3_unpack(struct connectib_hw_ste_tag_ib_l3 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l3_print(const struct connectib_hw_ste_tag_ib_l3 *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_ib_l3_size(void);
#define CONNECTIB_HW_STE_TAG_IB_L3_SIZE    (0x10)
void connectib_hw_ste_tag_ib_l3_dump(const struct connectib_hw_ste_tag_ib_l3 *ptr_struct, FILE* file);
/* hw_ste_tag_ib_l3_extended */
void connectib_hw_ste_tag_ib_l3_extended_pack(const struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l3_extended_unpack(struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l3_extended_print(const struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_ib_l3_extended_size(void);
#define CONNECTIB_HW_STE_TAG_IB_L3_EXTENDED_SIZE    (0x10)
void connectib_hw_ste_tag_ib_l3_extended_dump(const struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, FILE* file);
/* hw_ste_tag_ib_l2 */
void connectib_hw_ste_tag_ib_l2_pack(const struct connectib_hw_ste_tag_ib_l2 *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l2_unpack(struct connectib_hw_ste_tag_ib_l2 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l2_print(const struct connectib_hw_ste_tag_ib_l2 *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_ib_l2_size(void);
#define CONNECTIB_HW_STE_TAG_IB_L2_SIZE    (0x10)
void connectib_hw_ste_tag_ib_l2_dump(const struct connectib_hw_ste_tag_ib_l2 *ptr_struct, FILE* file);
/* hw_ste_tag_bulk */
void connectib_hw_ste_tag_bulk_pack(const struct connectib_hw_ste_tag_bulk *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_bulk_unpack(struct connectib_hw_ste_tag_bulk *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_bulk_print(const struct connectib_hw_ste_tag_bulk *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_bulk_size(void);
#define CONNECTIB_HW_STE_TAG_BULK_SIZE    (0x10)
void connectib_hw_ste_tag_bulk_dump(const struct connectib_hw_ste_tag_bulk *ptr_struct, FILE* file);
/* hw_transaction_pdf */
void connectib_hw_transaction_pdf_pack(const struct connectib_hw_transaction_pdf *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_transaction_pdf_unpack(struct connectib_hw_transaction_pdf *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_transaction_pdf_print(const struct connectib_hw_transaction_pdf *ptr_struct, FILE* file, int indent_level);
int connectib_hw_transaction_pdf_size(void);
#define CONNECTIB_HW_TRANSACTION_PDF_SIZE    (0x8)
void connectib_hw_transaction_pdf_dump(const struct connectib_hw_transaction_pdf *ptr_struct, FILE* file);
/* hw_pdf_decoder */
void connectib_hw_pdf_decoder_pack(const struct connectib_hw_pdf_decoder *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_pdf_decoder_unpack(struct connectib_hw_pdf_decoder *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_pdf_decoder_print(const struct connectib_hw_pdf_decoder *ptr_struct, FILE* file, int indent_level);
int connectib_hw_pdf_decoder_size(void);
#define CONNECTIB_HW_PDF_DECODER_SIZE    (0x8)
void connectib_hw_pdf_decoder_dump(const struct connectib_hw_pdf_decoder *ptr_struct, FILE* file);
/* ser