#include <assert.h>
#include <signal.h>

#include "compat.h"
#include "watch_maildirs.h"
#include "state.h"
#include "watcher_base.h"

char notify_method[] = "dnotify";

static void sigrt_handler(int, siginfo_t*, void*)
{
	// No operation
}

static void init_signals(sigset_t* sigset)
{
	struct sigaction sigact;
	int r;

	sigemptyset(sigset);
	sigaddset(sigset, SIGRTMIN);

	// Work around lpthread bug (libc/4927)
	r = sigprocmask(SIG_UNBLOCK, sigset, NULL);
	die_if(r < 0, "sigprocmask");

	sigact.sa_sigaction = sigrt_handler;
	sigemptyset(&sigact.sa_mask);
	sigact.sa_flags = SA_SIGINFO | SA_RESTART | SA_NODEFER;
	r = sigaction(SIGRTMIN, &sigact, NULL);
	die_if(r < 0, "sigaction");

	r = sigprocmask(SIG_BLOCK, sigset, NULL);
	die_if(r < 0, "sigprocmask");
}

void watch(const char* maildir)
{
	sigset_t sigset;

	init_signals(&sigset);

	dnotify_state state(maildir);
	watcher_base wb(&state);
	send_watch_started();

	while (1)
	{
		siginfo_t siginfo;
		int signal = TEMP_FAILURE_RETRY(sigwaitinfo(&sigset, &siginfo));
		die_if(signal < 0, "sigwaitinfo");
		assert(signal == SIGRTMIN);

		watcher* w = state.get_watcher_by_fd(siginfo.si_fd);
		if (w)
			w->process_event(siginfo.si_fd);
	}
}
