.TH MSGCHK %manext1% "April 14, 2013" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
msgchk \- check for messages
.SH SYNOPSIS
.HP 5
.na
.B msgchk
.RB [ \-date " | " \-nodate ]
.RB [ \-notify
all/mail/nomail ]
.RB [ \-nonotify
all/mail/nomail ]
.RB [ \-host
.IR hostname ]
.RB [ \-user
.IR username ]
.RB [ \-sasl ]
.RB [ \-saslmech
.IR mechanism ]
.RB [ \-snoop ]
.RI [ users
\&... ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
The
.B msgchk
program checks all known mail drops for mail waiting
for you.  For those drops which have mail for you,
.B msgchk
will
indicate if it believes that you have seen the mail in question before.
.PP
The
.B \-notify
.I type
switch indicates under what circumstances
.B msgchk
should produce a message.  The default is
.B \-notify
.I all
which says that
.B msgchk
should always report the status of the
users maildrop.  Other values for `type' include `mail' which says that
.B msgchk
should report the status of waiting mail; and, `nomail'
which says that
.B msgchk
should report the status of empty maildrops.
The
.B \-nonotify
.I type
switch has the inverted sense, so
.B \-nonotify
.I all
directs
.B msgchk
to never report the status of
maildrops.  This is useful if the user wishes to check
.BR msgchk 's
exit status.  A non\-zero exit status indicates that mail was
.B not
waiting for at least one of the indicated users.
.PP
If
.B msgchk
produces output, then the
.B \-date
switch directs
.B msgchk
to print out the last date mail was read, if this can
be determined.
.SS "Using POP"
.B msgchk
will normally check all the local mail drops, but if
the option \*(lqpophost:\*(rq is set in the mts configuration file
\*(lqmts.conf\*(rq, or if the
.B \-host
.I hostname
switch is given,
.B msgchk
will query this POP service host as to the status of
mail waiting.
.PP
To specify a username for authentication with the POP server, use the
.B \-user
.I username
switch.  The credentials profile entry in the mh\-profile(5) man page
describes the ways to supply a username and password.
.PP
For debugging purposes, there is also a switch
.BR \-snoop ,
which will
allow you to watch the POP transaction take place between you and the
POP server.
.PP
If
.B nmh
has been compiled with SASL support, the
.B \-sasl
switch will enable
the use of SASL authentication.  Depending on the SASL mechanism used, this
may require an additional password prompt from the user (but the
.I netrc
file can be used to store this password, as described in the
mh-profile(5) man page).  The
.B \-saslmech
switch can be used to select a particular SASL mechanism.
.PP
If SASL authentication is successful,
.B inc
will attempt to negotiate
a security layer for session encryption.  Encrypted traffic is labelled
with `(encrypted)' and `(decrypted)' when viewing the POP transaction
with the
.B \-snoop
switch.
.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
^%etcdir%/mts.conf~^nmh mts configuration file
^%mailspool%/$USER~^Location of mail drop
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
None
.fi
.SH "SEE ALSO"
.IR inc (1),
.IR mh\-mail (5)
.SH DEFAULTS
.nf
.RB ` user "' defaults to the current user"
.RB ` \-date '
.RB ` "\-notify\ all" '
.fi
.SH CONTEXT
None
