/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebServiceWorkerError_h
#define WebServiceWorkerError_h

#include "public/platform/WebString.h"
#include "third_party/WebKit/common/service_worker/service_worker_error_type.mojom-shared.h"

namespace blink {

struct WebServiceWorkerError {
  WebServiceWorkerError(mojom::ServiceWorkerErrorType error_type,
                        const WebString& message)
      : WebServiceWorkerError(error_type, message, WebString()) {}

  WebServiceWorkerError(mojom::ServiceWorkerErrorType error_type,
                        const WebString& message,
                        const WebString& unsanitized_message)
      : error_type(error_type),
        message(message),
        unsanitized_message(unsanitized_message) {}

  mojom::ServiceWorkerErrorType error_type;
  // |message| can be used to populate an error that's exposed to JavaScript.
  // For service worker APIs, typically a promise will reject with this error.
  WebString message;
  // |unsanitized_message| can be used to add a more detailed error to
  // console or other logging that shouldn't be exposed to JavaScript.
  WebString unsanitized_message;
};

}  // namespace blink

#endif
