# Copyright 2015 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'extensions_common_constants_sources': [
      'common/constants.cc',
      'common/constants.h',
    ],
    'extensions_common_mojo_sources': [
      'common/mojo/keep_alive.mojom',
      'common/mojo/stash.mojom',
    ],
    'extensions_common_mojo_sources_wifi_display': [
      'common/mojo/wifi_display_session_service.mojom',
    ],
    'extensions_common_sources': [
      'common/api/bluetooth/bluetooth_manifest_data.cc',
      'common/api/bluetooth/bluetooth_manifest_data.h',
      'common/api/bluetooth/bluetooth_manifest_handler.cc',
      'common/api/bluetooth/bluetooth_manifest_handler.h',
      'common/api/bluetooth/bluetooth_manifest_permission.cc',
      'common/api/bluetooth/bluetooth_manifest_permission.h',
      'common/api/declarative/declarative_manifest_data.cc',
      'common/api/declarative/declarative_manifest_data.h',
      'common/api/declarative/declarative_manifest_handler.cc',
      'common/api/declarative/declarative_manifest_handler.h',
      'common/api/messaging/message.h',
      'common/api/printer_provider/usb_printer_manifest_data.cc',
      'common/api/printer_provider/usb_printer_manifest_data.h',
      'common/api/printer_provider/usb_printer_manifest_handler.cc',
      'common/api/printer_provider/usb_printer_manifest_handler_android.cc',
      'common/api/printer_provider/usb_printer_manifest_handler.h',
      'common/api/sockets/sockets_manifest_data.cc',
      'common/api/sockets/sockets_manifest_data.h',
      'common/api/sockets/sockets_manifest_handler.cc',
      'common/api/sockets/sockets_manifest_handler.h',
      'common/api/sockets/sockets_manifest_permission.cc',
      'common/api/sockets/sockets_manifest_permission.h',
      'common/cast/cast_cert_validator.cc',
      'common/cast/cast_cert_validator.h',
      'common/common_manifest_handlers.cc',
      'common/common_manifest_handlers.h',
      'common/csp_validator.cc',
      'common/csp_validator.h',
      'common/dom_action_types.h',
      'common/draggable_region.cc',
      'common/draggable_region.h',
      'common/error_utils.cc',
      'common/error_utils.h',
      'common/event_filter.cc',
      'common/event_filter.h',
      'common/event_filtering_info.cc',
      'common/event_filtering_info.h',
      'common/event_matcher.cc',
      'common/event_matcher.h',
      'common/extension.cc',
      'common/extension.h',
      'common/extension_api.cc',
      'common/extension_api.h',
      'common/extension_icon_set.cc',
      'common/extension_icon_set.h',
      'common/extension_l10n_util.cc',
      'common/extension_l10n_util.h',
      'common/extension_message_generator.cc',
      'common/extension_message_generator.h',
      'common/extension_messages.cc',
      'common/extension_messages.h',
      'common/extension_paths.cc',
      'common/extension_paths.h',
      'common/extension_resource.cc',
      'common/extension_resource.h',
      'common/extension_set.cc',
      'common/extension_set.h',
      'common/extension_urls.cc',
      'common/extension_urls.h',
      'common/extension_utility_messages.h',
      'common/extensions_client.cc',
      'common/extensions_client.h',
      'common/feature_switch.cc',
      'common/feature_switch.h',
      'common/features/api_feature.cc',
      'common/features/api_feature.h',
      'common/features/base_feature_provider.cc',
      'common/features/base_feature_provider.h',
      'common/features/behavior_feature.cc',
      'common/features/behavior_feature.h',
      'common/features/complex_feature.cc',
      'common/features/complex_feature.h',
      'common/features/feature.cc',
      'common/features/feature.h',
      'common/features/feature_provider.cc',
      'common/features/feature_provider.h',
      'common/features/feature_util.h',
      'common/features/json_feature_provider_source.cc',
      'common/features/json_feature_provider_source.h',
      'common/features/manifest_feature.cc',
      'common/features/manifest_feature.h',
      'common/features/permission_feature.cc',
      'common/features/permission_feature.h',
      'common/features/simple_feature.cc',
      'common/features/simple_feature.h',
      'common/features/simple_feature_filter.cc',
      'common/features/simple_feature_filter.h',
      'common/file_util.cc',
      'common/file_util.h',
      'common/guest_view/extensions_guest_view_messages.h',
      'common/host_id.cc',
      'common/host_id.h',
      'common/image_util.cc',
      'common/image_util.h',
      'common/install_warning.cc',
      'common/install_warning.h',
      'common/manifest.cc',
      'common/manifest.h',
      'common/manifest_constants.cc',
      'common/manifest_constants.h',
      'common/manifest_handler.cc',
      'common/manifest_handler.h',
      'common/manifest_handler_helpers.cc',
      'common/manifest_handler_helpers.h',
      'common/manifest_handlers/app_isolation_info.cc',
      'common/manifest_handlers/app_isolation_info.h',
      'common/manifest_handlers/background_info.cc',
      'common/manifest_handlers/background_info.h',
      'common/manifest_handlers/content_capabilities_handler.cc',
      'common/manifest_handlers/content_capabilities_handler.h',
      'common/manifest_handlers/csp_info.cc',
      'common/manifest_handlers/csp_info.h',
      'common/manifest_handlers/default_locale_handler.cc',
      'common/manifest_handlers/default_locale_handler.h',
      'common/manifest_handlers/externally_connectable.cc',
      'common/manifest_handlers/externally_connectable.h',
      'common/manifest_handlers/file_handler_info.cc',
      'common/manifest_handlers/file_handler_info.h',
      'common/manifest_handlers/icons_handler.cc',
      'common/manifest_handlers/icons_handler.h',
      'common/manifest_handlers/incognito_info.cc',
      'common/manifest_handlers/incognito_info.h',
      'common/manifest_handlers/kiosk_mode_info.cc',
      'common/manifest_handlers/kiosk_mode_info.h',
      'common/manifest_handlers/launcher_page_info.cc',
      'common/manifest_handlers/launcher_page_info.h',
      'common/manifest_handlers/mime_types_handler.cc',
      'common/manifest_handlers/mime_types_handler.h',
      'common/manifest_handlers/oauth2_manifest_handler.cc',
      'common/manifest_handlers/oauth2_manifest_handler.h',
      'common/manifest_handlers/offline_enabled_info.cc',
      'common/manifest_handlers/offline_enabled_info.h',
      'common/manifest_handlers/options_page_info.cc',
      'common/manifest_handlers/options_page_info.h',
      'common/manifest_handlers/permissions_parser.cc',
      'common/manifest_handlers/permissions_parser.h',
      'common/manifest_handlers/requirements_info.cc',
      'common/manifest_handlers/requirements_info.h',
      'common/manifest_handlers/sandboxed_page_info.cc',
      'common/manifest_handlers/sandboxed_page_info.h',
      'common/manifest_handlers/shared_module_info.cc',
      'common/manifest_handlers/shared_module_info.h',
      'common/manifest_handlers/web_accessible_resources_info.cc',
      'common/manifest_handlers/web_accessible_resources_info.h',
      'common/manifest_handlers/webview_info.cc',
      'common/manifest_handlers/webview_info.h',
      'common/manifest_url_handlers.cc',
      'common/manifest_url_handlers.h',
      'common/message_bundle.cc',
      'common/message_bundle.h',
      'common/one_shot_event.cc',
      'common/one_shot_event.h',
      'common/permissions/api_permission.cc',
      'common/permissions/api_permission.h',
      'common/permissions/api_permission_set.cc',
      'common/permissions/api_permission_set.h',
      'common/permissions/base_set_operators.h',
      'common/permissions/extensions_api_permissions.cc',
      'common/permissions/extensions_api_permissions.h',
      'common/permissions/manifest_permission.cc',
      'common/permissions/manifest_permission.h',
      'common/permissions/manifest_permission_set.cc',
      'common/permissions/manifest_permission_set.h',
      'common/permissions/media_galleries_permission.cc',
      'common/permissions/media_galleries_permission.h',
      'common/permissions/media_galleries_permission_data.cc',
      'common/permissions/media_galleries_permission_data.h',
      'common/permissions/permission_message.cc',
      'common/permissions/permission_message.h',
      'common/permissions/permission_message_provider.cc',
      'common/permissions/permission_message_provider.h',
      'common/permissions/permission_message_util.cc',
      'common/permissions/permission_message_util.h',
      'common/permissions/permission_set.cc',
      'common/permissions/permission_set.h',
      'common/permissions/permissions_data.cc',
      'common/permissions/permissions_data.h',
      'common/permissions/permissions_info.cc',
      'common/permissions/permissions_info.h',
      'common/permissions/permissions_provider.h',
      'common/permissions/set_disjunction_permission.h',
      'common/permissions/settings_override_permission.cc',
      'common/permissions/settings_override_permission.h',
      'common/permissions/socket_permission.cc',
      'common/permissions/socket_permission.h',
      'common/permissions/socket_permission_data.cc',
      'common/permissions/socket_permission_data.h',
      'common/permissions/socket_permission_entry.cc',
      'common/permissions/socket_permission_entry.h',
      'common/permissions/usb_device_permission.cc',
      'common/permissions/usb_device_permission.h',
      'common/permissions/usb_device_permission_data.cc',
      'common/permissions/usb_device_permission_data.h',
      'common/stack_frame.cc',
      'common/stack_frame.h',
      'common/switches.cc',
      'common/switches.h',
      'common/update_manifest.cc',
      'common/update_manifest.h',
      'common/url_pattern.cc',
      'common/url_pattern.h',
      'common/url_pattern_set.cc',
      'common/url_pattern_set.h',
      'common/user_script.cc',
      'common/user_script.h',
      'common/value_builder.cc',
      'common/value_builder.h',
      'common/value_counter.cc',
      'common/value_counter.h',
      'common/view_type.cc',
      'common/view_type.h',
    ],
    'extensions_common_sources_nacl': [
      'common/manifest_handlers/nacl_modules_handler.cc',
      'common/manifest_handlers/nacl_modules_handler.h',
    ],
    'extensions_browser_sources': [
      # NOTE: When moving an API out of Chrome be sure to verify that the
      # Android build still compiles. See conditions below.
      'browser/api/activity_log/web_request_constants.cc',
      'browser/api/activity_log/web_request_constants.h',
      'browser/api/alarms/alarm_manager.cc',
      'browser/api/alarms/alarm_manager.h',
      'browser/api/alarms/alarms_api.cc',
      'browser/api/alarms/alarms_api.h',
      'browser/api/api_resource.cc',
      'browser/api/api_resource.h',
      'browser/api/api_resource_manager.h',
      'browser/api/app_current_window_internal/app_current_window_internal_api.cc',
      'browser/api/app_current_window_internal/app_current_window_internal_api.h',
      'browser/api/app_runtime/app_runtime_api.cc',
      'browser/api/app_runtime/app_runtime_api.h',
      'browser/api/app_window/app_window_api.cc',
      'browser/api/app_window/app_window_api.h',
      'browser/api/async_api_function.cc',
      'browser/api/async_api_function.h',
      'browser/api/audio/audio_api.cc',
      'browser/api/audio/audio_api.h',
      'browser/api/audio/audio_service.h',
      'browser/api/bluetooth/bluetooth_api.cc',
      'browser/api/bluetooth/bluetooth_api.h',
      'browser/api/bluetooth/bluetooth_api_pairing_delegate.cc',
      'browser/api/bluetooth/bluetooth_api_pairing_delegate.h',
      'browser/api/bluetooth/bluetooth_api_utils.cc',
      'browser/api/bluetooth/bluetooth_api_utils.h',
      'browser/api/bluetooth/bluetooth_event_router.cc',
      'browser/api/bluetooth/bluetooth_event_router.h',
      'browser/api/bluetooth/bluetooth_extension_function.cc',
      'browser/api/bluetooth/bluetooth_extension_function.h',
      'browser/api/bluetooth/bluetooth_private_api.cc',
      'browser/api/bluetooth/bluetooth_private_api.h',
      'browser/api/bluetooth_socket/bluetooth_api_socket.cc',
      'browser/api/bluetooth_socket/bluetooth_api_socket.h',
      'browser/api/bluetooth_socket/bluetooth_socket_api.cc',
      'browser/api/bluetooth_socket/bluetooth_socket_api.h',
      'browser/api/bluetooth_socket/bluetooth_socket_event_dispatcher.cc',
      'browser/api/bluetooth_socket/bluetooth_socket_event_dispatcher.h',
      'browser/api/capture_web_contents_function.cc',
      'browser/api/capture_web_contents_function.h',
      'browser/api/cast_channel/cast_auth_ica.cc',
      'browser/api/cast_channel/cast_auth_ica.h',
      'browser/api/cast_channel/cast_auth_util.cc',
      'browser/api/cast_channel/cast_auth_util.h',
      'browser/api/cast_channel/cast_channel_api.cc',
      'browser/api/cast_channel/cast_channel_api.h',
      'browser/api/cast_channel/cast_framer.cc',
      'browser/api/cast_channel/cast_framer.h',
      'browser/api/cast_channel/cast_message_util.cc',
      'browser/api/cast_channel/cast_message_util.h',
      'browser/api/cast_channel/cast_socket.cc',
      'browser/api/cast_channel/cast_socket.h',
      'browser/api/cast_channel/cast_transport.cc',
      'browser/api/cast_channel/cast_transport.h',
      'browser/api/cast_channel/keep_alive_delegate.cc',
      'browser/api/cast_channel/keep_alive_delegate.h',
      'browser/api/cast_channel/logger.cc',
      'browser/api/cast_channel/logger.h',
      'browser/api/cast_channel/logger_util.cc',
      'browser/api/cast_channel/logger_util.h',
      'browser/api/declarative/declarative_api.cc',
      'browser/api/declarative/declarative_api.h',
      'browser/api/declarative/declarative_rule.h',
      'browser/api/declarative/deduping_factory.h',
      'browser/api/declarative/rules_cache_delegate.cc',
      'browser/api/declarative/rules_cache_delegate.h',
      'browser/api/declarative/rules_registry.cc',
      'browser/api/declarative/rules_registry.h',
      'browser/api/declarative/rules_registry_service.cc',
      'browser/api/declarative/rules_registry_service.h',
      'browser/api/declarative/test_rules_registry.cc',
      'browser/api/declarative/test_rules_registry.h',
      'browser/api/declarative_content/content_rules_registry.h',
      'browser/api/declarative_webrequest/request_stage.cc',
      'browser/api/declarative_webrequest/request_stage.h',
      'browser/api/declarative_webrequest/webrequest_action.cc',
      'browser/api/declarative_webrequest/webrequest_action.h',
      'browser/api/declarative_webrequest/webrequest_condition.cc',
      'browser/api/declarative_webrequest/webrequest_condition.h',
      'browser/api/declarative_webrequest/webrequest_condition_attribute.cc',
      'browser/api/declarative_webrequest/webrequest_condition_attribute.h',
      'browser/api/declarative_webrequest/webrequest_constants.cc',
      'browser/api/declarative_webrequest/webrequest_constants.h',
      'browser/api/declarative_webrequest/webrequest_rules_registry.cc',
      'browser/api/declarative_webrequest/webrequest_rules_registry.h',
      'browser/api/device_permissions_manager.cc',
      'browser/api/device_permissions_manager.h',
      'browser/api/device_permissions_prompt.cc',
      'browser/api/device_permissions_prompt.h',
      'browser/api/display_source/display_source_api.cc',
      'browser/api/display_source/display_source_api.h',
      'browser/api/display_source/display_source_connection_delegate.cc',
      'browser/api/display_source/display_source_connection_delegate.h',
      'browser/api/display_source/display_source_connection_delegate_factory.cc',
      'browser/api/display_source/display_source_connection_delegate_factory.h',
      'browser/api/display_source/display_source_event_router.cc',
      'browser/api/display_source/display_source_event_router_factory.cc',
      'browser/api/display_source/display_source_event_router_factory.h',
      'browser/api/display_source/display_source_event_router.h',
      'browser/api/dns/dns_api.cc',
      'browser/api/dns/dns_api.h',
      'browser/api/dns/host_resolver_wrapper.cc',
      'browser/api/dns/host_resolver_wrapper.h',
      'browser/api/document_scan/document_scan_api.cc',
      'browser/api/document_scan/document_scan_api.h',
      'browser/api/document_scan/document_scan_interface.cc',
      'browser/api/document_scan/document_scan_interface.h',
      'browser/api/document_scan/document_scan_interface_chromeos.cc',
      'browser/api/execute_code_function.cc',
      'browser/api/execute_code_function.h',
      'browser/api/extensions_api_client.cc',
      'browser/api/extensions_api_client.h',
      'browser/api/guest_view/app_view/app_view_guest_internal_api.cc',
      'browser/api/guest_view/app_view/app_view_guest_internal_api.h',
      'browser/api/guest_view/extension_view/extension_view_internal_api.cc',
      'browser/api/guest_view/extension_view/extension_view_internal_api.h',
      'browser/api/guest_view/guest_view_internal_api.cc',
      'browser/api/guest_view/guest_view_internal_api.h',
      'browser/api/guest_view/web_view/web_view_internal_api.cc',
      'browser/api/guest_view/web_view/web_view_internal_api.h',
      'browser/api/hid/hid_api.cc',
      'browser/api/hid/hid_api.h',
      'browser/api/hid/hid_connection_resource.cc',
      'browser/api/hid/hid_connection_resource.h',
      'browser/api/hid/hid_device_manager.cc',
      'browser/api/hid/hid_device_manager.h',
      'browser/api/idle/idle_api.cc',
      'browser/api/idle/idle_api.h',
      'browser/api/idle/idle_api_constants.cc',
      'browser/api/idle/idle_api_constants.h',
      'browser/api/idle/idle_manager.cc',
      'browser/api/idle/idle_manager.h',
      'browser/api/idle/idle_manager_factory.cc',
      'browser/api/idle/idle_manager_factory.h',
      'browser/api/management/management_api.cc',
      'browser/api/management/management_api.h',
      'browser/api/management/management_api_constants.cc',
      'browser/api/management/management_api_constants.h',
      'browser/api/management/management_api_delegate.h',
      'browser/api/messaging/native_message_host.cc',
      'browser/api/mime_handler_private/mime_handler_private.cc',
      'browser/api/mime_handler_private/mime_handler_private.h',
      'browser/api/networking_private/networking_private_api.cc',
      'browser/api/networking_private/networking_private_api.h',
      'browser/api/networking_private/networking_private_chromeos.cc',
      'browser/api/networking_private/networking_private_chromeos.h',
      'browser/api/networking_private/networking_private_delegate.cc',
      'browser/api/networking_private/networking_private_delegate.h',
      'browser/api/networking_private/networking_private_delegate_factory.cc',
      'browser/api/networking_private/networking_private_delegate_factory.h',
      'browser/api/networking_private/networking_private_delegate_observer.h',
      'browser/api/networking_private/networking_private_event_router.h',
      'browser/api/networking_private/networking_private_event_router_chromeos.cc',
      'browser/api/networking_private/networking_private_event_router_factory.cc',
      'browser/api/networking_private/networking_private_event_router_factory.h',
      'browser/api/power/power_api.cc',
      'browser/api/power/power_api.h',
      'browser/api/printer_provider/printer_provider_api.cc',
      'browser/api/printer_provider/printer_provider_api.h',
      'browser/api/printer_provider/printer_provider_api_factory.cc',
      'browser/api/printer_provider/printer_provider_api_factory.h',
      'browser/api/printer_provider/printer_provider_print_job.cc',
      'browser/api/printer_provider/printer_provider_print_job.h',
      'browser/api/printer_provider_internal/printer_provider_internal_api.cc',
      'browser/api/printer_provider_internal/printer_provider_internal_api.h',
      'browser/api/printer_provider_internal/printer_provider_internal_api_observer.h',
      'browser/api/runtime/runtime_api.cc',
      'browser/api/runtime/runtime_api.h',
      'browser/api/runtime/runtime_api_delegate.cc',
      'browser/api/runtime/runtime_api_delegate.h',
      'browser/api/serial/serial_api.cc',
      'browser/api/serial/serial_api.h',
      'browser/api/serial/serial_connection.cc',
      'browser/api/serial/serial_connection.h',
      'browser/api/serial/serial_event_dispatcher.cc',
      'browser/api/serial/serial_event_dispatcher.h',
      'browser/api/serial/serial_service_factory.cc',
      'browser/api/serial/serial_service_factory.h',
      'browser/api/socket/socket.cc',
      'browser/api/socket/socket.h',
      'browser/api/socket/socket_api.cc',
      'browser/api/socket/socket_api.h',
      'browser/api/socket/tcp_socket.cc',
      'browser/api/socket/tcp_socket.h',
      'browser/api/socket/tls_socket.cc',
      'browser/api/socket/tls_socket.h',
      'browser/api/socket/udp_socket.cc',
      'browser/api/socket/udp_socket.h',
      'browser/api/sockets_tcp/sockets_tcp_api.cc',
      'browser/api/sockets_tcp/sockets_tcp_api.h',
      'browser/api/sockets_tcp/tcp_socket_event_dispatcher.cc',
      'browser/api/sockets_tcp/tcp_socket_event_dispatcher.h',
      'browser/api/sockets_tcp_server/sockets_tcp_server_api.cc',
      'browser/api/sockets_tcp_server/sockets_tcp_server_api.h',
      'browser/api/sockets_tcp_server/tcp_server_socket_event_dispatcher.cc',
      'browser/api/sockets_tcp_server/tcp_server_socket_event_dispatcher.h',
      'browser/api/sockets_udp/sockets_udp_api.cc',
      'browser/api/sockets_udp/sockets_udp_api.h',
      'browser/api/sockets_udp/udp_socket_event_dispatcher.cc',
      'browser/api/sockets_udp/udp_socket_event_dispatcher.h',
      'browser/api/storage/leveldb_settings_storage_factory.cc',
      'browser/api/storage/leveldb_settings_storage_factory.h',
      'browser/api/storage/local_value_store_cache.cc',
      'browser/api/storage/local_value_store_cache.h',
      'browser/api/storage/settings_namespace.cc',
      'browser/api/storage/settings_namespace.h',
      'browser/api/storage/settings_observer.h',
      'browser/api/storage/settings_storage_factory.h',
      'browser/api/storage/settings_storage_quota_enforcer.cc',
      'browser/api/storage/settings_storage_quota_enforcer.h',
      'browser/api/storage/storage_api.cc',
      'browser/api/storage/storage_api.h',
      'browser/api/storage/storage_frontend.cc',
      'browser/api/storage/storage_frontend.h',
      'browser/api/storage/value_store_cache.cc',
      'browser/api/storage/value_store_cache.h',
      'browser/api/storage/weak_unlimited_settings_storage.cc',
      'browser/api/storage/weak_unlimited_settings_storage.h',
      'browser/api/system_cpu/cpu_info_provider.cc',
      'browser/api/system_cpu/cpu_info_provider.h',
      'browser/api/system_cpu/cpu_info_provider_linux.cc',
      'browser/api/system_cpu/cpu_info_provider_mac.cc',
      'browser/api/system_cpu/cpu_info_provider_win.cc',
      'browser/api/system_cpu/system_cpu_api.cc',
      'browser/api/system_cpu/system_cpu_api.h',
      'browser/api/system_display/display_info_provider.cc',
      'browser/api/system_display/display_info_provider.h',
      'browser/api/system_display/system_display_api.cc',
      'browser/api/system_display/system_display_api.h',
      'browser/api/system_info/system_info_api.cc',
      'browser/api/system_info/system_info_api.h',
      'browser/api/system_info/system_info_provider.cc',
      'browser/api/system_info/system_info_provider.h',
      'browser/api/system_memory/memory_info_provider.cc',
      'browser/api/system_memory/memory_info_provider.h',
      'browser/api/system_memory/system_memory_api.cc',
      'browser/api/system_memory/system_memory_api.h',
      'browser/api/system_network/system_network_api.cc',
      'browser/api/system_network/system_network_api.h',
      'browser/api/system_storage/storage_info_provider.cc',
      'browser/api/system_storage/storage_info_provider.h',
      'browser/api/system_storage/system_storage_api.cc',
      'browser/api/system_storage/system_storage_api.h',
      'browser/api/test/test_api.cc',
      'browser/api/test/test_api.h',
      'browser/api/usb/usb_api.cc',
      'browser/api/usb/usb_api.h',
      'browser/api/usb/usb_device_resource.cc',
      'browser/api/usb/usb_device_resource.h',
      'browser/api/usb/usb_event_router.cc',
      'browser/api/usb/usb_event_router.h',
      'browser/api/usb/usb_guid_map.cc',
      'browser/api/usb/usb_guid_map.h',
      'browser/api/virtual_keyboard_private/virtual_keyboard_delegate.h',
      'browser/api/virtual_keyboard_private/virtual_keyboard_private_api.cc',
      'browser/api/virtual_keyboard_private/virtual_keyboard_private_api.h',
      'browser/api/web_request/form_data_parser.cc',
      'browser/api/web_request/form_data_parser.h',
      'browser/api/web_request/upload_data_presenter.cc',
      'browser/api/web_request/upload_data_presenter.h',
      'browser/api/web_request/web_request_api.cc',
      'browser/api/web_request/web_request_api.h',
      'browser/api/web_request/web_request_api_constants.cc',
      'browser/api/web_request/web_request_api_constants.h',
      'browser/api/web_request/web_request_api_helpers.cc',
      'browser/api/web_request/web_request_api_helpers.h',
      'browser/api/web_request/web_request_event_details.cc',
      'browser/api/web_request/web_request_event_details.h',
      'browser/api/web_request/web_request_event_router_delegate.cc',
      'browser/api/web_request/web_request_event_router_delegate.h',
      'browser/api/web_request/web_request_permissions.cc',
      'browser/api/web_request/web_request_permissions.h',
      'browser/api/web_request/web_request_time_tracker.cc',
      'browser/api/web_request/web_request_time_tracker.h',
      'browser/api_activity_monitor.h',
      'browser/app_sorting.h',
      'browser/app_window/app_delegate.h',
      'browser/app_window/app_web_contents_helper.cc',
      'browser/app_window/app_web_contents_helper.h',
      'browser/app_window/app_window.cc',
      'browser/app_window/app_window.h',
      'browser/app_window/app_window_client.cc',
      'browser/app_window/app_window_client.h',
      'browser/app_window/app_window_contents.cc',
      'browser/app_window/app_window_contents.h',
      'browser/app_window/app_window_geometry_cache.cc',
      'browser/app_window/app_window_geometry_cache.h',
      'browser/app_window/app_window_registry.cc',
      'browser/app_window/app_window_registry.h',
      'browser/app_window/native_app_window.h',
      'browser/app_window/size_constraints.cc',
      'browser/app_window/size_constraints.h',
      'browser/bad_message.cc',
      'browser/bad_message.h',
      'browser/blacklist_state.h',
      'browser/blob_holder.cc',
      'browser/blob_holder.h',
      'browser/browser_context_keyed_api_factory.h',
      'browser/browser_context_keyed_service_factories.cc',
      'browser/browser_context_keyed_service_factories.h',
      'browser/component_extension_resource_manager.h',
      'browser/computed_hashes.cc',
      'browser/computed_hashes.h',
      'browser/content_hash_fetcher.cc',
      'browser/content_hash_fetcher.h',
      'browser/content_hash_reader.cc',
      'browser/content_hash_reader.h',
      'browser/content_hash_tree.cc',
      'browser/content_hash_tree.h',
      'browser/content_verifier.cc',
      'browser/content_verifier.h',
      'browser/content_verifier_delegate.h',
      'browser/content_verifier_io_data.cc',
      'browser/content_verifier_io_data.h',
      'browser/content_verify_job.cc',
      'browser/content_verify_job.h',
      'browser/crx_file_info.cc',
      'browser/crx_file_info.h',
      'browser/declarative_user_script_manager.cc',
      'browser/declarative_user_script_manager.h',
      'browser/declarative_user_script_manager_factory.cc',
      'browser/declarative_user_script_manager_factory.h',
      'browser/declarative_user_script_master.cc',
      'browser/declarative_user_script_master.h',
      'browser/deferred_start_render_host.h',
      'browser/deferred_start_render_host_observer.h',
      'browser/error_map.cc',
      'browser/error_map.h',
      'browser/event_listener_map.cc',
      'browser/event_listener_map.h',
      'browser/event_page_tracker.h',
      'browser/event_router.cc',
      'browser/event_router.h',
      'browser/event_router_factory.cc',
      'browser/event_router_factory.h',
      'browser/extension_api_frame_id_map.cc',
      'browser/extension_api_frame_id_map.h',
      'browser/extension_dialog_auto_confirm.cc',
      'browser/extension_dialog_auto_confirm.h',
      'browser/extension_error.cc',
      'browser/extension_error.h',
      'browser/extension_function.cc',
      'browser/extension_function.h',
      'browser/extension_function_dispatcher.cc',
      'browser/extension_function_dispatcher.h',
      'browser/extension_function_registry.cc',
      'browser/extension_function_registry.h',
      'browser/extension_function_util.cc',
      'browser/extension_function_util.h',
      'browser/extension_host.cc',
      'browser/extension_host.h',
      'browser/extension_host_delegate.h',
      'browser/extension_host_observer.h',
      'browser/extension_host_queue.h',
      'browser/extension_icon_image.cc',
      'browser/extension_icon_image.h',
      'browser/extension_icon_placeholder.cc',
      'browser/extension_icon_placeholder.h',
      'browser/extension_message_filter.cc',
      'browser/extension_message_filter.h',
      'browser/extension_pref_store.cc',
      'browser/extension_pref_store.h',
      'browser/extension_pref_value_map.cc',
      'browser/extension_pref_value_map.h',
      'browser/extension_pref_value_map_factory.cc',
      'browser/extension_pref_value_map_factory.h',
      'browser/extension_prefs.cc',
      'browser/extension_prefs.h',
      'browser/extension_prefs_factory.cc',
      'browser/extension_prefs_factory.h',
      'browser/extension_prefs_observer.h',
      'browser/extension_prefs_scope.h',
      'browser/extension_protocols.cc',
      'browser/extension_protocols.h',
      'browser/extension_registry.cc',
      'browser/extension_registry.h',
      'browser/extension_registry_factory.cc',
      'browser/extension_registry_factory.h',
      'browser/extension_registry_observer.h',
      'browser/extension_request_limiting_throttle.cc',
      'browser/extension_request_limiting_throttle.h',
      'browser/extension_scoped_prefs.h',
      'browser/extension_system.cc',
      'browser/extension_system.h',
      'browser/extension_system_provider.cc',
      'browser/extension_system_provider.h',
      'browser/extension_throttle_entry.cc',
      'browser/extension_throttle_entry.h',
      'browser/extension_throttle_entry_interface.h',
      'browser/extension_throttle_manager.cc',
      'browser/extension_throttle_manager.h',
      'browser/extension_user_script_loader.cc',
      'browser/extension_user_script_loader.h',
      'browser/extension_util.cc',
      'browser/extension_util.h',
      'browser/extension_web_contents_observer.cc',
      'browser/extension_web_contents_observer.h',
      'browser/extension_zoom_request_client.cc',
      'browser/extension_zoom_request_client.h',
      'browser/extensions_browser_client.cc',
      'browser/extensions_browser_client.h',
      'browser/external_provider_interface.h',
      'browser/file_highlighter.cc',
      'browser/file_highlighter.h',
      'browser/file_reader.cc',
      'browser/file_reader.h',
      'browser/granted_file_entry.cc',
      'browser/granted_file_entry.h',
      'browser/guest_view/app_view/app_view_constants.cc',
      'browser/guest_view/app_view/app_view_constants.h',
      'browser/guest_view/app_view/app_view_guest.cc',
      'browser/guest_view/app_view/app_view_guest.h',
      'browser/guest_view/app_view/app_view_guest_delegate.cc',
      'browser/guest_view/app_view/app_view_guest_delegate.h',
      'browser/guest_view/extension_options/extension_options_constants.cc',
      'browser/guest_view/extension_options/extension_options_constants.h',
      'browser/guest_view/extension_options/extension_options_guest.cc',
      'browser/guest_view/extension_options/extension_options_guest.h',
      'browser/guest_view/extension_options/extension_options_guest_delegate.cc',
      'browser/guest_view/extension_options/extension_options_guest_delegate.h',
      'browser/guest_view/extension_view/extension_view_constants.cc',
      'browser/guest_view/extension_view/extension_view_constants.h',
      'browser/guest_view/extension_view/extension_view_guest.cc',
      'browser/guest_view/extension_view/extension_view_guest.h',
      'browser/guest_view/extension_view/whitelist/extension_view_whitelist.cc',
      'browser/guest_view/extension_view/whitelist/extension_view_whitelist.h',
      'browser/guest_view/extensions_guest_view_manager_delegate.cc',
      'browser/guest_view/extensions_guest_view_manager_delegate.h',
      'browser/guest_view/extensions_guest_view_message_filter.cc',
      'browser/guest_view/extensions_guest_view_message_filter.h',
      'browser/guest_view/guest_view_events.cc',
      'browser/guest_view/guest_view_events.h',
      'browser/guest_view/mime_handler_view/mime_handler_stream_manager.cc',
      'browser/guest_view/mime_handler_view/mime_handler_stream_manager.h',
      'browser/guest_view/mime_handler_view/mime_handler_view_constants.cc',
      'browser/guest_view/mime_handler_view/mime_handler_view_constants.h',
      'browser/guest_view/mime_handler_view/mime_handler_view_guest.cc',
      'browser/guest_view/mime_handler_view/mime_handler_view_guest.h',
      'browser/guest_view/mime_handler_view/mime_handler_view_guest_delegate.cc',
      'browser/guest_view/mime_handler_view/mime_handler_view_guest_delegate.h',
      'browser/guest_view/web_view/javascript_dialog_helper.cc',
      'browser/guest_view/web_view/javascript_dialog_helper.h',
      'browser/guest_view/web_view/web_ui/web_ui_url_fetcher.cc',
      'browser/guest_view/web_view/web_ui/web_ui_url_fetcher.h',
      'browser/guest_view/web_view/web_view_constants.cc',
      'browser/guest_view/web_view/web_view_constants.h',
      'browser/guest_view/web_view/web_view_content_script_manager.cc',
      'browser/guest_view/web_view/web_view_content_script_manager.h',
      'browser/guest_view/web_view/web_view_find_helper.cc',
      'browser/guest_view/web_view/web_view_find_helper.h',
      'browser/guest_view/web_view/web_view_guest.cc',
      'browser/guest_view/web_view/web_view_guest.h',
      'browser/guest_view/web_view/web_view_guest_delegate.h',
      'browser/guest_view/web_view/web_view_permission_helper.cc',
      'browser/guest_view/web_view/web_view_permission_helper.h',
      'browser/guest_view/web_view/web_view_permission_helper_delegate.cc',
      'browser/guest_view/web_view/web_view_permission_helper_delegate.h',
      'browser/guest_view/web_view/web_view_permission_types.h',
      'browser/guest_view/web_view/web_view_renderer_state.cc',
      'browser/guest_view/web_view/web_view_renderer_state.h',
      'browser/image_loader.cc',
      'browser/image_loader.h',
      'browser/image_loader_factory.cc',
      'browser/image_loader_factory.h',
      'browser/info_map.cc',
      'browser/info_map.h',
      'browser/install/crx_install_error.h',
      'browser/install/extension_install_ui.cc',
      'browser/install/extension_install_ui.h',
      'browser/install_flag.h',
      'browser/io_thread_extension_message_filter.cc',
      'browser/io_thread_extension_message_filter.h',
      'browser/lazy_background_task_queue.cc',
      'browser/lazy_background_task_queue.h',
      'browser/lazy_background_task_queue_factory.cc',
      'browser/lazy_background_task_queue_factory.h',
      'browser/load_monitoring_extension_host_queue.cc',
      'browser/load_monitoring_extension_host_queue.h',
      'browser/management_policy.cc',
      'browser/management_policy.h',
      'browser/mojo/keep_alive_impl.cc',
      'browser/mojo/keep_alive_impl.h',
      'browser/mojo/service_registration.cc',
      'browser/mojo/service_registration.h',
      'browser/mojo/stash_backend.cc',
      'browser/mojo/stash_backend.h',
      'browser/notification_types.cc',
      'browser/notification_types.h',
      'browser/null_app_sorting.cc',
      'browser/null_app_sorting.h',
      'browser/pref_names.cc',
      'browser/pref_names.h',
      'browser/process_manager.cc',
      'browser/process_manager.h',
      'browser/process_manager_delegate.h',
      'browser/process_manager_factory.cc',
      'browser/process_manager_factory.h',
      'browser/process_manager_observer.h',
      'browser/process_map.cc',
      'browser/process_map.h',
      'browser/process_map_factory.cc',
      'browser/process_map_factory.h',
      'browser/quota_service.cc',
      'browser/quota_service.h',
      'browser/renderer_startup_helper.cc',
      'browser/renderer_startup_helper.h',
      'browser/requirements_checker.h',
      'browser/runtime_data.cc',
      'browser/runtime_data.h',
      'browser/sandboxed_unpacker.cc',
      'browser/sandboxed_unpacker.h',
      'browser/script_execution_observer.h',
      'browser/script_executor.cc',
      'browser/script_executor.h',
      'browser/serial_extension_host_queue.cc',
      'browser/serial_extension_host_queue.h',
      'browser/service_worker_manager.cc',
      'browser/service_worker_manager.h',
      'browser/state_store.cc',
      'browser/state_store.h',
      'browser/suggest_permission_util.cc',
      'browser/suggest_permission_util.h',
      'browser/uninstall_reason.h',
      'browser/update_observer.h',
      'browser/updater/extension_cache.h',
      'browser/updater/extension_downloader.cc',
      'browser/updater/extension_downloader.h',
      'browser/updater/extension_downloader_delegate.cc',
      'browser/updater/extension_downloader_delegate.h',
      'browser/updater/manifest_fetch_data.cc',
      'browser/updater/manifest_fetch_data.h',
      'browser/updater/null_extension_cache.cc',
      'browser/updater/null_extension_cache.h',
      'browser/updater/request_queue.h',
      'browser/updater/request_queue_impl.h',
      'browser/updater/safe_manifest_parser.cc',
      'browser/updater/safe_manifest_parser.h',
      'browser/updater/update_client_config.cc',
      'browser/updater/update_client_config.h',
      'browser/updater/update_data_provider.cc',
      'browser/updater/update_data_provider.h',
      'browser/updater/update_install_shim.cc',
      'browser/updater/update_install_shim.h',
      'browser/updater/update_service.cc',
      'browser/updater/update_service.h',
      'browser/updater/update_service_factory.cc',
      'browser/updater/update_service_factory.h',
      'browser/url_request_util.cc',
      'browser/url_request_util.h',
      'browser/user_script_loader.cc',
      'browser/user_script_loader.h',
      'browser/value_store/leveldb_value_store.cc',
      'browser/value_store/leveldb_value_store.h',
      'browser/value_store/testing_value_store.cc',
      'browser/value_store/testing_value_store.h',
      'browser/value_store/value_store.cc',
      'browser/value_store/value_store.h',
      'browser/value_store/value_store_change.cc',
      'browser/value_store/value_store_change.h',
      'browser/value_store/value_store_frontend.cc',
      'browser/value_store/value_store_frontend.h',
      'browser/verified_contents.cc',
      'browser/verified_contents.h',
      'browser/view_type_utils.cc',
      'browser/view_type_utils.h',
      'browser/warning_service.cc',
      'browser/warning_service.h',
      'browser/warning_service_factory.cc',
      'browser/warning_service_factory.h',
      'browser/warning_set.cc',
      'browser/warning_set.h',
      'browser/web_ui_user_script_loader.cc',
      'browser/web_ui_user_script_loader.h',
    ],
    'extensions_browser_sources_chromeos': [
      'browser/api/audio/audio_service_chromeos.cc',
      'browser/api/diagnostics/diagnostics_api.cc',
      'browser/api/diagnostics/diagnostics_api.h',
      'browser/api/diagnostics/diagnostics_api_chromeos.cc',
      'browser/api/networking_config/networking_config_api.cc',
      'browser/api/networking_config/networking_config_api.h',
      'browser/api/networking_config/networking_config_service.cc',
      'browser/api/networking_config/networking_config_service.h',
      'browser/api/networking_config/networking_config_service_factory.cc',
      'browser/api/networking_config/networking_config_service_factory.h',
      'browser/api/socket/app_firewall_hole_manager.cc',
      'browser/api/socket/app_firewall_hole_manager.h',
      'browser/api/vpn_provider/vpn_provider_api.cc',
      'browser/api/vpn_provider/vpn_provider_api.h',
      'browser/api/vpn_provider/vpn_service.cc',
      'browser/api/vpn_provider/vpn_service.h',
      'browser/api/vpn_provider/vpn_service_factory.h',
      'browser/api/webcam_private/v4l2_webcam.cc',
      'browser/api/webcam_private/v4l2_webcam.h',
      'browser/api/webcam_private/visca_webcam.cc',
      'browser/api/webcam_private/visca_webcam.h',
      'browser/api/webcam_private/webcam.cc',
      'browser/api/webcam_private/webcam.h',
      'browser/api/webcam_private/webcam_private_api.h',
      'browser/api/webcam_private/webcam_private_api_chromeos.cc',
    ],
    'extensions_browser_sources_nonchromeos': [
      'browser/api/audio/audio_service.cc',
      'browser/api/document_scan/document_scan_interface_nonchromeos.cc',
    ],
    'extensions_browser_sources_win_or_mac': [
      'browser/api/networking_private/networking_private_event_router_nonchromeos.cc',
      'browser/api/networking_private/networking_private_service_client.cc',
      'browser/api/networking_private/networking_private_service_client.h',
    ],
    'extensions_browser_sources_linux_nonchromeos': [
      'browser/api/networking_private/network_config_dbus_constants_linux.cc',
      'browser/api/networking_private/network_config_dbus_constants_linux.h',
      'browser/api/networking_private/networking_private_event_router_nonchromeos.cc',
      'browser/api/networking_private/networking_private_linux.cc',
      'browser/api/networking_private/networking_private_linux.h',
    ],
    'extensions_browser_sources_wifi_display': [
      'browser/api/display_source/wifi_display/wifi_display_session_service_impl.cc',
      'browser/api/display_source/wifi_display/wifi_display_session_service_impl.h',
    ],
    'extensions_renderer_sources': [
      'renderer/activity_log_converter_strategy.cc',
      'renderer/activity_log_converter_strategy.h',
      'renderer/api/automation/automation_api_helper.cc',
      'renderer/api/automation/automation_api_helper.h',
      'renderer/api/display_source/display_source_session.cc',
      'renderer/api/display_source/display_source_session.h',
      'renderer/api_activity_logger.cc',
      'renderer/api_activity_logger.h',
      'renderer/api_definitions_natives.cc',
      'renderer/api_definitions_natives.h',
      'renderer/app_window_custom_bindings.cc',
      'renderer/app_window_custom_bindings.h',
      'renderer/binding_generating_native_handler.cc',
      'renderer/binding_generating_native_handler.h',
      'renderer/blob_native_handler.cc',
      'renderer/blob_native_handler.h',
      'renderer/console.cc',
      'renderer/console.h',
      'renderer/content_watcher.cc',
      'renderer/content_watcher.h',
      'renderer/context_menus_custom_bindings.cc',
      'renderer/context_menus_custom_bindings.h',
      'renderer/css_native_handler.cc',
      'renderer/css_native_handler.h',
      'renderer/dispatcher.cc',
      'renderer/dispatcher.h',
      'renderer/dispatcher_delegate.h',
      'renderer/display_source_custom_bindings.cc',
      'renderer/display_source_custom_bindings.h',
      'renderer/document_custom_bindings.cc',
      'renderer/document_custom_bindings.h',
      'renderer/dom_activity_logger.cc',
      'renderer/dom_activity_logger.h',
      'renderer/event_bindings.cc',
      'renderer/event_bindings.h',
      'renderer/extension_frame_helper.cc',
      'renderer/extension_frame_helper.h',
      'renderer/extension_groups.h',
      'renderer/extension_helper.cc',
      'renderer/extension_helper.h',
      'renderer/extension_injection_host.cc',
      'renderer/extension_injection_host.h',
      'renderer/extensions_render_frame_observer.cc',
      'renderer/extensions_render_frame_observer.h',
      'renderer/extensions_renderer_client.cc',
      'renderer/extensions_renderer_client.h',
      'renderer/file_system_natives.cc',
      'renderer/file_system_natives.h',
      'renderer/gc_callback.cc',
      'renderer/gc_callback.h',
      'renderer/guest_view/extensions_guest_view_container.cc',
      'renderer/guest_view/extensions_guest_view_container.h',
      'renderer/guest_view/extensions_guest_view_container_dispatcher.cc',
      'renderer/guest_view/extensions_guest_view_container_dispatcher.h',
      'renderer/guest_view/guest_view_internal_custom_bindings.cc',
      'renderer/guest_view/guest_view_internal_custom_bindings.h',
      'renderer/guest_view/mime_handler_view/mime_handler_view_container.cc',
      'renderer/guest_view/mime_handler_view/mime_handler_view_container.h',
      'renderer/i18n_custom_bindings.cc',
      'renderer/i18n_custom_bindings.h',
      'renderer/id_generator_custom_bindings.cc',
      'renderer/id_generator_custom_bindings.h',
      'renderer/injection_host.cc',
      'renderer/injection_host.h',
      'renderer/lazy_background_page_native_handler.cc',
      'renderer/lazy_background_page_native_handler.h',
      'renderer/logging_native_handler.cc',
      'renderer/logging_native_handler.h',
      'renderer/messaging_bindings.cc',
      'renderer/messaging_bindings.h',
      'renderer/module_system.cc',
      'renderer/module_system.h',
      'renderer/native_handler.cc',
      'renderer/native_handler.h',
      'renderer/object_backed_native_handler.cc',
      'renderer/object_backed_native_handler.h',
      'renderer/print_native_handler.cc',
      'renderer/print_native_handler.h',
      'renderer/process_info_native_handler.cc',
      'renderer/process_info_native_handler.h',
      'renderer/programmatic_script_injector.cc',
      'renderer/programmatic_script_injector.h',
      'renderer/render_frame_observer_natives.cc',
      'renderer/renderer_extension_registry.cc',
      'renderer/renderer_extension_registry.h',
      'renderer/request_sender.cc',
      'renderer/request_sender.h',
      'renderer/resource_bundle_source_map.cc',
      'renderer/resource_bundle_source_map.h',
      'renderer/resources/app_runtime_custom_bindings.js',
      'renderer/resources/app_window_custom_bindings.js',
      'renderer/resources/binding.js',
      'renderer/resources/context_menus_custom_bindings.js',
      'renderer/resources/declarative_webrequest_custom_bindings.js',
      'renderer/resources/entry_id_manager.js',
      'renderer/resources/event.js',
      'renderer/resources/extension.css',
      'renderer/resources/extension_custom_bindings.js',
      'renderer/resources/extension_fonts.css',
      'renderer/resources/greasemonkey_api.js',
      'renderer/resources/i18n_custom_bindings.js',
      'renderer/resources/image_util.js',
      'renderer/resources/json_schema.js',
      'renderer/resources/last_error.js',
      'renderer/resources/messaging.js',
      'renderer/resources/messaging_utils.js',
      'renderer/resources/permissions_custom_bindings.js',
      'renderer/resources/platform_app.css',
      'renderer/resources/platform_app.js',
      'renderer/resources/runtime_custom_bindings.js',
      'renderer/resources/schema_utils.js',
      'renderer/resources/send_request.js',
      'renderer/resources/set_icon.js',
      'renderer/resources/storage_area.js',
      'renderer/resources/test_custom_bindings.js',
      'renderer/resources/uncaught_exception_handler.js',
      'renderer/resources/utils.js',
      'renderer/resources/guest_view/app_view/app_view.js',
      'renderer/resources/guest_view/extension_options/extension_options.js',
      'renderer/resources/guest_view/extension_view/extension_view.js',
      'renderer/resources/guest_view/web_view/web_view.js',
      'renderer/resources/guest_view/web_view/web_view_events.js',
      'renderer/resources/guest_view/web_view/web_view_iframe.js',
      'renderer/resources/web_request_custom_bindings.js',
      'renderer/resources/web_request_internal_custom_bindings.js',
      'renderer/runtime_custom_bindings.cc',
      'renderer/runtime_custom_bindings.h',
      'renderer/safe_builtins.cc',
      'renderer/safe_builtins.h',
      'renderer/script_context.cc',
      'renderer/script_context.h',
      'renderer/script_context_set.cc',
      'renderer/script_context_set.h',
      'renderer/script_injection.cc',
      'renderer/script_injection.h',
      'renderer/script_injection_callback.cc',
      'renderer/script_injection_callback.h',
      'renderer/script_injection_manager.cc',
      'renderer/script_injection_manager.h',
      'renderer/script_injector.h',
      'renderer/scripts_run_info.cc',
      'renderer/scripts_run_info.h',
      'renderer/send_request_natives.cc',
      'renderer/send_request_natives.h',
      'renderer/set_icon_natives.cc',
      'renderer/set_icon_natives.h',
      'renderer/static_v8_external_one_byte_string_resource.cc',
      'renderer/static_v8_external_one_byte_string_resource.h',
      'renderer/test_features_native_handler.cc',
      'renderer/test_features_native_handler.h',
      'renderer/test_native_handler.cc',
      'renderer/test_native_handler.h',
      'renderer/user_gestures_native_handler.cc',
      'renderer/user_gestures_native_handler.h',
      'renderer/user_script_injector.cc',
      'renderer/user_script_injector.h',
      'renderer/user_script_set.cc',
      'renderer/user_script_set.h',
      'renderer/user_script_set_manager.cc',
      'renderer/user_script_set_manager.h',
      'renderer/utils_native_handler.cc',
      'renderer/utils_native_handler.h',
      'renderer/v8_context_native_handler.cc',
      'renderer/v8_context_native_handler.h',
      'renderer/v8_helpers.h',
      'renderer/v8_schema_registry.cc',
      'renderer/v8_schema_registry.h',
      'renderer/wake_event_page.cc',
      'renderer/wake_event_page.h',
      'renderer/web_ui_injection_host.cc',
      'renderer/web_ui_injection_host.h',
      'renderer/worker_script_context_set.cc',
      'renderer/worker_script_context_set.h',
    ],
    'extensions_render_sources_wifi_display': [
      'renderer/api/display_source/wifi_display/wifi_display_session.cc',
      'renderer/api/display_source/wifi_display/wifi_display_session.h',
    ],
    'extensions_utility_sources': [
      'utility/unpacker.cc',
      'utility/unpacker.h',
      'utility/utility_handler.cc',
      'utility/utility_handler.h',
    ],
    'extensions_test_support_sources': [
      'browser/api/cast_channel/cast_test_util.cc',
      'browser/api/cast_channel/cast_test_util.h',
      'browser/api/dns/mock_host_resolver_creator.cc',
      'browser/api/dns/mock_host_resolver_creator.h',
      'browser/api/storage/settings_test_util.cc',
      'browser/api/storage/settings_test_util.h',
      'browser/api_test_utils.cc',
      'browser/api_test_utils.h',
      'browser/api_unittest.cc',
      'browser/api_unittest.h',
      'browser/app_window/test_app_window_contents.cc',
      'browser/app_window/test_app_window_contents.h',
      'browser/extension_error_test_util.cc',
      'browser/extension_error_test_util.h',
      'browser/extensions_test.cc',
      'browser/extensions_test.h',
      'browser/guest_view/mime_handler_view/test_mime_handler_view_guest.cc',
      'browser/guest_view/mime_handler_view/test_mime_handler_view_guest.h',
      'browser/mock_extension_system.cc',
      'browser/mock_extension_system.h',
      'browser/test_extension_registry_observer.cc',
      'browser/test_extension_registry_observer.h',
      'browser/test_extensions_browser_client.cc',
      'browser/test_extensions_browser_client.h',
      'browser/test_image_loader.cc',
      'browser/test_image_loader.h',
      'browser/test_management_policy.cc',
      'browser/test_management_policy.h',
      'browser/test_runtime_api_delegate.cc',
      'browser/test_runtime_api_delegate.h',
      'common/extension_builder.cc',
      'common/extension_builder.h',
      'common/manifest_test.cc',
      'common/manifest_test.h',
      'common/permissions/permission_message_test_util.cc',
      'common/permissions/permission_message_test_util.h',
      'common/test_util.cc',
      'common/test_util.h',
      'renderer/test_extensions_renderer_client.cc',
      'renderer/test_extensions_renderer_client.h',
      'test/background_page_watcher.cc',
      'test/background_page_watcher.h',
      'test/extension_test_message_listener.cc',
      'test/extension_test_message_listener.h',
      'test/result_catcher.cc',
      'test/result_catcher.h',
      'test/test_content_utility_client.cc',
      'test/test_content_utility_client.h',
      'test/test_extensions_client.cc',
      'test/test_extensions_client.h',
      'test/test_permission_message_provider.cc',
      'test/test_permission_message_provider.h',
    ],
  },
}
