% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotCounts}
\alias{plotCounts}
\title{Plot of normalized counts for a single gene on log scale}
\usage{
plotCounts(dds, gene, intgroup = "condition", normalized = TRUE,
  transform = FALSE, main, xlab = "group", returnData = FALSE,
  replaced = FALSE, ...)
}
\arguments{
\item{dds}{a \code{DESeqDataSet}}

\item{gene}{a character, specifying the name of the gene to plot}

\item{intgroup}{interesting groups: a character vector of names in \code{colData(x)} to use for grouping}

\item{normalized}{whether the counts should be normalized by size factor
(default is TRUE)}

\item{transform}{whether to present log2 counts (TRUE) or
to present the counts on the log scale (FALSE, default)}

\item{main}{as in 'plot'}

\item{xlab}{as in 'plot'}

\item{returnData}{should the function only return the data.frame of counts and
covariates for custom plotting (default is FALSE)}

\item{replaced}{use the outlier-replaced counts if they exist}

\item{...}{arguments passed to plot}
}
\description{
Note: normalized counts plus a pseudocount of 0.5 are shown.
}
\examples{

dds <- makeExampleDESeqDataSet()
plotCounts(dds, "gene1")

}

