% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{PipeServer}
\alias{PipeServer}
\title{PipeServer class}
\description{
This class represents a server running one application that listens on a
named pipe.
}
\section{Methods}{


\describe{
  \item{\code{initialize(name, mask, app)}}{
    Create a new \code{PipeServer} object. \code{app} is an httpuv application
    object as described in \code{\link{startServer}}.
  }
  \item{\code{getName()}}{Return the value of \code{name} that was passed to
    \code{initialize()}.
  }
  \item{\code{getMask()}}{Return the value of \code{mask} that was passed to
    \code{initialize()}.
  }
  \item{\code{stop()}}{Stops a running server.}
  \item{\code{isRunning()}}{Returns TRUE if the server is currently running.}
  \item{\code{getStaticPaths()}}{Returns a list of \code{\link{staticPath}}
    objects for the server.
  }
  \item{\code{setStaticPath(..., .list = NULL)}}{Sets a static path for the
    current server. Each static path can be given as a named argument, or as
    an named item in \code{.list}. If there already exists a static path with
    the same name, it will be replaced.
  }
  \item{\code{removeStaticPath(path)}}{Removes a static path with the given
    name.
  }
  \item{\code{getStaticPathOptions()}}{Returns a list of default
    \code{staticPathOptions} for the current server. Each static path will
    use these options by default, but they can be overridden for each static
    path.
  }
  \item{\code{setStaticPathOption(..., .list = NULL)}}{Sets one or more
    static path options. Each option can be given as a named argument, or as
    a named item in \code{.list}.
  }
}
}

\seealso{
\code{\link{Server}} and \code{\link{WebServer}}.
}
\keyword{internal}
\section{Super class}{
\code{\link[httpuv:Server]{httpuv::Server}} -> \code{PipeServer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeServer$new()}}
\item \href{#method-getName}{\code{PipeServer$getName()}}
\item \href{#method-getMask}{\code{PipeServer$getMask()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="getStaticPathOptions">}\href{../../httpuv/html/Server.html#method-getStaticPathOptions}{\code{httpuv::Server$getStaticPathOptions()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="getStaticPaths">}\href{../../httpuv/html/Server.html#method-getStaticPaths}{\code{httpuv::Server$getStaticPaths()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="isRunning">}\href{../../httpuv/html/Server.html#method-isRunning}{\code{httpuv::Server$isRunning()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="removeStaticPath">}\href{../../httpuv/html/Server.html#method-removeStaticPath}{\code{httpuv::Server$removeStaticPath()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="setStaticPath">}\href{../../httpuv/html/Server.html#method-setStaticPath}{\code{httpuv::Server$setStaticPath()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="setStaticPathOption">}\href{../../httpuv/html/Server.html#method-setStaticPathOption}{\code{httpuv::Server$setStaticPathOption()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="stop">}\href{../../httpuv/html/Server.html#method-stop}{\code{httpuv::Server$stop()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeServer$new(name, mask, app, quiet = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getName"></a>}}
\if{latex}{\out{\hypertarget{method-getName}{}}}
\subsection{Method \code{getName()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeServer$getName()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getMask"></a>}}
\if{latex}{\out{\hypertarget{method-getMask}{}}}
\subsection{Method \code{getMask()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeServer$getMask()}\if{html}{\out{</div>}}
}

}
}
