% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/durations.r
\name{quick_durations}
\alias{ddays}
\alias{dhours}
\alias{dmicroseconds}
\alias{dmilliseconds}
\alias{dminutes}
\alias{dnanoseconds}
\alias{dpicoseconds}
\alias{dseconds}
\alias{dweeks}
\alias{dyears}
\alias{quick_durations}
\title{Quickly create duration objects.}
\usage{
dseconds(x = 1)

dminutes(x = 1)

dhours(x = 1)

ddays(x = 1)

dweeks(x = 1)

dyears(x = 1)

dmilliseconds(x = 1)

dmicroseconds(x = 1)

dnanoseconds(x = 1)

dpicoseconds(x = 1)
}
\arguments{
\item{x}{numeric value of the number of units to be contained in the duration.}
}
\value{
a duration object
}
\description{
Quickly create Duration objects for easy date-time manipulation. The units of
the duration created depend on the name of the function called. For Duration
objects, units are equal to their most common lengths in seconds (i.e.
minutes = 60 seconds, hours = 3600 seconds, days = 86400 seconds, weeks =
604800, years = 31536000).
}
\details{
When paired with date-times, these functions allow date-times to be
manipulated in a method similar to object oriented programming. Duration
objects can be added to Date, POSIXt, and Interval objects.

Since version 1.4.0 the following functions are deprecated: \code{eseconds},
\code{eminutes}, \code{ehours}, \code{edays}, \code{eweeks}, \code{eyears},
\code{emilliseconds}, \code{emicroseconds}, \code{enanoseconds},
\code{epicoseconds}
}
\examples{
dseconds(1)
dminutes(3.5)

x <- as.POSIXct("2009-08-03")
x + ddays(1) + dhours(6) + dminutes(30)
x + ddays(100) - dhours(8)

class(as.Date("2009-08-09") + ddays(1)) # retains Date class
as.Date("2009-08-09") + dhours(12)
class(as.Date("2009-08-09") + dhours(12))
# converts to POSIXt class to accomodate time units

dweeks(1) - ddays(7)
c(1:3) * dhours(1)
#
# compare DST handling to durations
boundary <- as.POSIXct("2009-03-08 01:59:59")
boundary + days(1) # period
boundary + ddays(1) # duration
}
\seealso{
\code{\link{duration}}, \code{\link{days}}
}
\keyword{chron}
\keyword{manip}

