///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef.h"
using namespace rheolef;
using namespace std;
size_t d;
Float f (const point& x) { return 1; }
Float g (const point& x) { return -0.5/d; }
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  d = omega.dimension();
  space Xh (omega, argv[2]);
  trial u (Xh); test v (Xh);
  form  m  = integrate (u*v);
  form  a  = integrate (dot(grad(u),grad(v)));
  field b  = m*field(Xh,1);
  field lh = integrate (f*v) + integrate ("boundary", g*v);
  csr<Float> A = {{  a.uu(),     b.u()}, 
                  {trans(b.u()),  0   }};
  vec<Float> B =  {  lh.u(),      0   };
  A.set_symmetry(true);
  solver sa = ldlt(A);
  vec<Float> U = sa.solve (B);
  field uh(Xh);
  uh.set_u() = U [range(0,uh.u().size())];
  Float lambda = (U.size() == uh.u().size()+1) ? U [uh.u().size()] : 0;
#ifdef _RHEOLEF_HAVE_MPI
  mpi::broadcast (U.comm(), lambda, U.comm().size() - 1); 
#endif // _RHEOLEF_HAVE_MPI
  dout << uh 
       << "lambda" << lambda << endl;
}
