# frozen_string_literal: true

module Bootsnap
  module LoadPathCache
    class RealpathCache
      def initialize
        @cache = Hash.new { |h, k| h[k] = realpath(*k) }
      end

      def call(*key)
        @cache[key]
      end

      private

      def realpath(caller_location, path)
        base = File.dirname(caller_location)
        file = find_file(File.expand_path(path, base))
        dir = File.dirname(file)
        File.join(dir, File.basename(file))
      end

      def find_file(name)
        ['', *CACHED_EXTENSIONS].each do |ext|
          filename = "#{name}#{ext}"
          return File.realpath(filename) if File.exist?(filename)
        end
        name
      end
    end
  end
end
