/*
 * Includes for Cray-mysql routines
 *
 * Copyright (c) 2009-2011 Centro Svizzero di Calcolo Scientifico (CSCS)
 * Licensed under the GPLv2.
 */
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <ctype.h>
#include <mysql.h>
#include <basil_log.h>	/* internal */

/* Maximum string length */
#define BASIL_STRING_SIZE	128

/*
 *	mySQL Utilities
 */
/** Connect to the XTAdmin table on the SDB */
extern MYSQL *cray_connect_sdb(void);

/** Initialize and prepare statement */
extern MYSQL_STMT *prepare_stmt(MYSQL *handle, const char *query,
				MYSQL_BIND bind_parm[], unsigned long nparams,
				MYSQL_BIND bind_cols[], unsigned long ncols);

/** Execute and validate prepared statement. */
extern bool run_stmt(MYSQL_STMT *stmt, const char *query,
		     MYSQL_BIND bind_col[], unsigned long ncols, bool do_store);

/** Execute and return the number of rows. */
extern int exec_stmt(MYSQL_STMT *stmt, const char *query,
		     MYSQL_BIND bind_col[], unsigned long ncols);

/** Combine all the above for parameter-less statements */
extern MYSQL_STMT *exec_query(MYSQL *handle, const char *query,
			      MYSQL_BIND columns[], unsigned long ncols);

/** Return the result of a parameter-less Boolean query */
extern int exec_boolean_query(MYSQL *handle, const char *query);

/** Number of cores per compute node on a homogeneous system */
extern int cray_num_compute_node_cores(MYSQL *handle);

/** Find out interconnect chip: Gemini (XE) or SeaStar (XT) */
extern int cray_is_gemini_system(MYSQL *handle);

/** Torus type and configuration via database query */
extern struct torus_info *cray_torus_from_database(MYSQL *handle);

/** maximum X/Y/Z coordinates */
extern bool cray_get_torus_dimensions(MYSQL *handle, int *x, int *y, int *z);
