/* ====================================================================
 * Copyright (c) 2006-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CONTROLLER_H
#define _SC_CONTROLLER_H

// sc
#include "util/Id.h"
#include "util/String.h"
class ScModel;
class WcViewModel;
class RpViewModel;
class LogViewModel;
class BlameViewModel;
class LogGraphViewModel;
class BookmarkViewModel;
class Bookmark;

// qt
#include <QtCore/QObject>

// sys
#include <map>

// types
struct WcViewData
{
  WcViewModel* _model;

  bool         _initialized;
  sc::String   _source;
};

typedef std::map< ID, WcViewData > WcViewModels;

struct RpViewData
{
  RpViewModel* _model;

  bool         _initialized;
  sc::String   _source;
};
typedef std::map< ID, RpViewData > RpViewModels;


class Controller : public QObject
{
  typedef QObject super;
   Q_OBJECT;

public:
  Controller( ScModel* model );
  ~Controller();

  // ListWidget
  ScModel* getScModel();
  WcViewModel* getWcViewModel();
  BookmarkViewModel* getBookmarkViewModel();
  void initBookmarks();
  void updateBookmarks();

public slots:
  void addBookmark( Bookmark* bm );
  void delBookmark( Bookmark* bm );
  void selectBookmark( Bookmark* bm );
  void modifiedBookmark( Bookmark* bm );

  // redirect actions to model
  void reload();

  void wcDiffBase();
  void wcAdd();
  void wcRemove();
  void wcRevert();
  void wcCommit();
  void wcEditConflict();
  void wcResolved();
  void wcLog();
  void wcLogGraph();
  void wcProperties();
  void wcIgnore();
  void wcBlame();
  void wcLock();
  void wcUnlock();
  void wcCleanup();
  void wcMkdir();
  void wcExport();
  void wcUpdateRev();
  void wcBranchTag();
  void wcPropList();
  void wcPropGet();
  void wcPropSet();
  void wcCat();
  /** Run working copy auto update. */
  void wcAutoUpdate();

  void rpLog();
  void rpLogGraph();
  void rpBlame();
  void rpBranchTag();
  void rpCheckout();
  void rpSwitch();
  void rpDiff();
  void rpMerge();
  void rpMkdir();
  void rpRemove();
  void rpImport();
  void rpExport();
  void rpCat();

  void bmLog();
  void bmCommit();
  void bmUpdate();
  void bmUpdateRev();
  void bmBranchTag();
  void bmCheckout();
  void bmSwitch();

  void adminCreate();

signals:
  void newView( ID id, WcViewModel* m );
  void newView( ID id, RpViewModel* m );
  void delView( ID id );
  void showView( ID id );

  void showCommit( bool bookmark, WcViewModel* m );
  void showProps( WcViewModel* m );
  void showLog( LogViewModel* m );
  void showLogGraph( LogGraphViewModel* m );
  void showBlame( BlameViewModel* m );
  void confirmAutoUpdate( bool& );
  void confirmCreateRepository( bool& );

private:
  WcViewModel* getWcModel( ID id );

  ScModel*           _model;
  BookmarkViewModel* _bmModel;
  
  WcViewModels       _wcModels;
  WcViewModel*       _curWcModel;

  RpViewModels       _rpModels;
  RpViewModel*       _curRpModel;
};


#endif //  _SC_CONTROLLER_H
