/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROPSETCMD_H
#define _SC_PROPSETCMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class PropSetParam;


/**
 * Command for setting the properties of a path.
 */
class PropSetCmd : public ScCmd
{
public:
  /**
   * Construct a PropSetCmd.
   *
   * \param param the parameters for the command. The command takes ownership
   * of the parameter object and deletes it if it itself destroyed.
   *
   * \param cb the callback that gets called when the command has finished.
   * 
   */
  PropSetCmd( PropSetParam* param, CmdResultCallback* cb );
  ~PropSetCmd();

  void run();

private:
  // in
  PropSetParam*      _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_PROPSETCMD_H
