//
// Copyright (c) 2012-2013 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//

#ifndef COMPILER_TRANSLATOR_DIAGNOSTICS_H_
#define COMPILER_TRANSLATOR_DIAGNOSTICS_H_

#include "common/angleutils.h"
#include "compiler/preprocessor/DiagnosticsBase.h"
#include "compiler/translator/Severity.h"

namespace sh
{

class TInfoSinkBase;
struct TSourceLoc;

class TDiagnostics : public pp::Diagnostics, angle::NonCopyable
{
  public:
    TDiagnostics(TInfoSinkBase &infoSink);
    ~TDiagnostics() override;

    int numErrors() const { return mNumErrors; }
    int numWarnings() const { return mNumWarnings; }

    void error(const pp::SourceLocation &loc, const char *reason, const char *token);
    void warning(const pp::SourceLocation &loc, const char *reason, const char *token);

    void error(const TSourceLoc &loc, const char *reason, const char *token);
    void warning(const TSourceLoc &loc, const char *reason, const char *token);

    void globalError(const char *message);

    void resetErrorCount();

  protected:
    void writeInfo(Severity severity,
                   const pp::SourceLocation &loc,
                   const char *reason,
                   const char *token);

    void print(ID id, const pp::SourceLocation &loc, const std::string &text) override;

  private:
    TInfoSinkBase &mInfoSink;
    int mNumErrors;
    int mNumWarnings;
};

}  // namespace sh

#endif  // COMPILER_TRANSLATOR_DIAGNOSTICS_H_
